{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetClosureType: TArcClosureType;
    procedure SetClosureType(const Value: TArcClosureType);
    function GetEndAngle: Single;
    procedure SetEndAngle(const Value: Single);
    function GetRadius: Single;
    procedure SetRadius(const Value: Single);
    function GetStartAngle: Single;
    procedure SetStartAngle(const Value: Single);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdClosureType: TSFStringEnum;
    { Internal wrapper for property @code(ClosureType). This wrapper API may change, we advise to access simpler @code(ClosureType) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdClosureType: TSFStringEnum read FFdClosureType;
    {  }
    property ClosureType: TArcClosureType read GetClosureType write SetClosureType;

    strict private FFdEndAngle: TSFFloat;
    { Internal wrapper for property @code(EndAngle). This wrapper API may change, we advise to access simpler @code(EndAngle) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEndAngle: TSFFloat read FFdEndAngle;
    {  }
    property EndAngle: Single read GetEndAngle write SetEndAngle;

    strict private FFdRadius: TSFFloat;
    { Internal wrapper for property @code(Radius). This wrapper API may change, we advise to access simpler @code(Radius) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdRadius: TSFFloat read FFdRadius;
    {  }
    property Radius: Single read GetRadius write SetRadius;

    strict private FFdSolid: TSFBool;
    { Internal wrapper for property @code(Solid). This wrapper API may change, we advise to access simpler @code(Solid) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSolid: TSFBool read FFdSolid;

    strict private FFdStartAngle: TSFFloat;
    { Internal wrapper for property @code(StartAngle). This wrapper API may change, we advise to access simpler @code(StartAngle) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdStartAngle: TSFFloat read FFdStartAngle;
    {  }
    property StartAngle: Single read GetStartAngle write SetStartAngle;

{$endif read_interface}

{$ifdef read_implementation}

{ TArcClose2DNode ----------------------------------------------- }

function TArcClose2DNode.GetClosureType: TArcClosureType;
begin
  Result := TArcClosureType(FdClosureType.EnumValue);
end;

procedure TArcClose2DNode.SetClosureType(const Value: TArcClosureType);
begin
  FdClosureType.SendEnumValue(Ord(Value));
end;

function TArcClose2DNode.GetEndAngle: Single;
begin
  Result := FdEndAngle.Value;
end;

procedure TArcClose2DNode.SetEndAngle(const Value: Single);
begin
  FdEndAngle.Send(Value);
end;

function TArcClose2DNode.GetRadius: Single;
begin
  Result := FdRadius.Value;
end;

procedure TArcClose2DNode.SetRadius(const Value: Single);
begin
  FdRadius.Send(Value);
end;

function TArcClose2DNode.GetStartAngle: Single;
begin
  Result := FdStartAngle.Value;
end;

procedure TArcClose2DNode.SetStartAngle(const Value: Single);
begin
  FdStartAngle.Send(Value);
end;

class function TArcClose2DNode.ClassX3DType: String;
begin
  Result := 'ArcClose2D';
end;

procedure TArcClose2DNode.CreateNode;
begin
  inherited;

  FFdClosureType := TSFStringEnum.Create(Self, False, 'closureType', @ArcClosureTypeNames, Ord(High(ArcClosureTypeNames)) + 1, Ord(acPie));
   FdClosureType.ChangeAlways := chGeometry;
  AddField(FFdClosureType);

  FFdEndAngle := TSFFloat.Create(Self, False, 'endAngle', Pi/2);
   FdEndAngle.ChangeAlways := chGeometry;
   FdEndAngle.Angle := true;
  AddField(FFdEndAngle);

  FFdRadius := TSFFloat.Create(Self, False, 'radius', 1);
   FdRadius.ChangeAlways := chGeometry;
   FdRadius.MustBeNonnegative := true;
  AddField(FFdRadius);

  FFdSolid := TSFBool.Create(Self, False, 'solid', false);
   FdSolid.ChangeAlways := chGeometry;
  AddField(FFdSolid);

  FFdStartAngle := TSFFloat.Create(Self, False, 'startAngle', 0);
   FdStartAngle.ChangeAlways := chGeometry;
   FdStartAngle.Angle := true;
  AddField(FFdStartAngle);
end;

{$endif read_implementation}
