{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetIntegerKey: Integer;
    procedure SetIntegerKey(const Value: Integer);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FEventSet_boolean: TSFBoolEvent;
    {  }
    public property EventSet_boolean: TSFBoolEvent read FEventSet_boolean;

    strict private FFdIntegerKey: TSFInt32;
    { Internal wrapper for property @code(IntegerKey). This wrapper API may change, we advise to access simpler @code(IntegerKey) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdIntegerKey: TSFInt32 read FFdIntegerKey;
    {  }
    property IntegerKey: Integer read GetIntegerKey write SetIntegerKey;

    strict private FEventTriggerValue: TSFInt32Event;
    {  }
    public property EventTriggerValue: TSFInt32Event read FEventTriggerValue;

{$endif read_interface}

{$ifdef read_implementation}

{ TIntegerTriggerNode ----------------------------------------------- }

function TIntegerTriggerNode.GetIntegerKey: Integer;
begin
  Result := FdIntegerKey.Value;
end;

procedure TIntegerTriggerNode.SetIntegerKey(const Value: Integer);
begin
  FdIntegerKey.Send(Value);
end;

class function TIntegerTriggerNode.ClassX3DType: String;
begin
  Result := 'IntegerTrigger';
end;

procedure TIntegerTriggerNode.CreateNode;
begin
  inherited;

  FEventSet_boolean := TSFBoolEvent.Create(Self, 'set_boolean', true);
  AddEvent(FEventSet_boolean);

  FFdIntegerKey := TSFInt32.Create(Self, True, 'integerKey', -1);
   FdIntegerKey.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdIntegerKey);

  FEventTriggerValue := TSFInt32Event.Create(Self, 'triggerValue', false);
  AddEvent(FEventTriggerValue);
end;

{$endif read_implementation}
