{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdValue: TMFBool;
    { Internal wrapper for property @code(Value). This wrapper API may change, we advise to access simpler @code(Value) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdValue: TMFBool read FFdValue;
    {  }
    procedure SetValue(const Value: array of boolean); overload;
    {  }
    procedure SetValue(const Value: TBooleanList); overload;

{$endif read_interface}

{$ifdef read_implementation}

{ TMetadataBooleanNode ----------------------------------------------- }

procedure TMetadataBooleanNode.SetValue(const Value: array of boolean);
begin
  FdValue.Send(Value);
end;

procedure TMetadataBooleanNode.SetValue(const Value: TBooleanList);
begin
  FdValue.Send(Value);
end;

class function TMetadataBooleanNode.ClassX3DType: String;
begin
  Result := 'MetadataBoolean';
end;

procedure TMetadataBooleanNode.CreateNode;
begin
  inherited;

  FFdValue := TMFBool.Create(Self, True, 'value', []);
   FdValue.ChangeAlways := chNone;
  AddField(FFdValue);
end;

{$endif read_implementation}
