{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetControlPoint: TAbstractCoordinateNode;
    procedure SetControlPoint(const Value: TAbstractCoordinateNode);
    function GetTessellation: Integer;
    procedure SetTessellation(const Value: Integer);
    function GetClosed: Boolean;
    procedure SetClosed(const Value: Boolean);
    function GetOrder: Integer;
    procedure SetOrder(const Value: Integer);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdControlPoint: TSFNode;
    { Internal wrapper for property @code(ControlPoint). This wrapper API may change, we advise to access simpler @code(ControlPoint) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdControlPoint: TSFNode read FFdControlPoint;
    {  }
    property ControlPoint: TAbstractCoordinateNode read GetControlPoint write SetControlPoint;

    strict private FFdTessellation: TSFInt32;
    { Internal wrapper for property @code(Tessellation). This wrapper API may change, we advise to access simpler @code(Tessellation) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTessellation: TSFInt32 read FFdTessellation;
    {  }
    property Tessellation: Integer read GetTessellation write SetTessellation;

    strict private FFdWeight: TMFDouble;
    { Internal wrapper for property @code(Weight). This wrapper API may change, we advise to access simpler @code(Weight) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdWeight: TMFDouble read FFdWeight;
    {  }
    procedure SetWeight(const Value: array of Double); overload;
    {  }
    procedure SetWeight(const Value: TDoubleList); overload;

    strict private FFdClosed: TSFBool;
    { Internal wrapper for property @code(Closed). This wrapper API may change, we advise to access simpler @code(Closed) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdClosed: TSFBool read FFdClosed;
    {  }
    property Closed: Boolean read GetClosed write SetClosed;

    strict private FFdKnot: TMFDouble;
    { Internal wrapper for property @code(Knot). This wrapper API may change, we advise to access simpler @code(Knot) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdKnot: TMFDouble read FFdKnot;
    {  }
    procedure SetKnot(const Value: array of Double); overload;
    {  }
    procedure SetKnot(const Value: TDoubleList); overload;

    strict private FFdOrder: TSFInt32;
    { Internal wrapper for property @code(Order). This wrapper API may change, we advise to access simpler @code(Order) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdOrder: TSFInt32 read FFdOrder;
    {  }
    property Order: Integer read GetOrder write SetOrder;

{$endif read_interface}

{$ifdef read_implementation}

{ TNurbsCurveNode ----------------------------------------------- }

function TNurbsCurveNode.GetControlPoint: TAbstractCoordinateNode;
begin
  if FdControlPoint.Value is TAbstractCoordinateNode then
    Result := TAbstractCoordinateNode(FdControlPoint.Value)
  else
    Result := nil;
end;

procedure TNurbsCurveNode.SetControlPoint(const Value: TAbstractCoordinateNode);
begin
  FdControlPoint.Send(Value);
end;

function TNurbsCurveNode.GetTessellation: Integer;
begin
  Result := FdTessellation.Value;
end;

procedure TNurbsCurveNode.SetTessellation(const Value: Integer);
begin
  FdTessellation.Send(Value);
end;

procedure TNurbsCurveNode.SetWeight(const Value: array of Double);
begin
  FdWeight.Send(Value);
end;

procedure TNurbsCurveNode.SetWeight(const Value: TDoubleList);
begin
  FdWeight.Send(Value);
end;

function TNurbsCurveNode.GetClosed: Boolean;
begin
  Result := FdClosed.Value;
end;

procedure TNurbsCurveNode.SetClosed(const Value: Boolean);
begin
  FdClosed.Send(Value);
end;

procedure TNurbsCurveNode.SetKnot(const Value: array of Double);
begin
  FdKnot.Send(Value);
end;

procedure TNurbsCurveNode.SetKnot(const Value: TDoubleList);
begin
  FdKnot.Send(Value);
end;

function TNurbsCurveNode.GetOrder: Integer;
begin
  Result := FdOrder.Value;
end;

procedure TNurbsCurveNode.SetOrder(const Value: Integer);
begin
  FdOrder.Send(Value);
end;

class function TNurbsCurveNode.ClassX3DType: String;
begin
  Result := 'NurbsCurve';
end;

procedure TNurbsCurveNode.CreateNode;
begin
  inherited;

  FFdControlPoint := TSFNode.Create(Self, True, 'controlPoint', [TAbstractCoordinateNode]);
   FdControlPoint.ChangeAlways := chGeometry;
  AddField(FFdControlPoint);

  FFdTessellation := TSFInt32.Create(Self, True, 'tessellation', 0);
   FdTessellation.ChangeAlways := chGeometry;
  AddField(FFdTessellation);

  FFdWeight := TMFDouble.Create(Self, True, 'weight', []);
   FdWeight.ChangeAlways := chGeometry;
  AddField(FFdWeight);

  FFdClosed := TSFBool.Create(Self, False, 'closed', false);
   FdClosed.ChangeAlways := chGeometry;
  AddField(FFdClosed);

  FFdKnot := TMFDouble.Create(Self, False, 'knot', []);
   FdKnot.ChangeAlways := chGeometry;
  AddField(FFdKnot);

  FFdOrder := TSFInt32.Create(Self, False, 'order', 3);
   FdOrder.ChangeAlways := chGeometry;
  AddField(FFdOrder);
end;

{$endif read_implementation}
