{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetClosed: Boolean;
    procedure SetClosed(const Value: Boolean);
    function GetNormalizeVelocity: Boolean;
    procedure SetNormalizeVelocity(const Value: Boolean);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdClosed: TSFBool;
    { Internal wrapper for property @code(Closed). This wrapper API may change, we advise to access simpler @code(Closed) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdClosed: TSFBool read FFdClosed;
    {  }
    property Closed: Boolean read GetClosed write SetClosed;

    strict private FFdKeyValue: TMFVec2f;
    { Internal wrapper for property @code(KeyValue). This wrapper API may change, we advise to access simpler @code(KeyValue) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdKeyValue: TMFVec2f read FFdKeyValue;
    {  }
    procedure SetKeyValue(const Value: array of TVector2); overload;
    {  }
    procedure SetKeyValue(const Value: TVector2List); overload;

    strict private FFdKeyVelocity: TMFVec2f;
    { Internal wrapper for property @code(KeyVelocity). This wrapper API may change, we advise to access simpler @code(KeyVelocity) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdKeyVelocity: TMFVec2f read FFdKeyVelocity;
    {  }
    procedure SetKeyVelocity(const Value: array of TVector2); overload;
    {  }
    procedure SetKeyVelocity(const Value: TVector2List); overload;

    strict private FFdNormalizeVelocity: TSFBool;
    { Internal wrapper for property @code(NormalizeVelocity). This wrapper API may change, we advise to access simpler @code(NormalizeVelocity) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdNormalizeVelocity: TSFBool read FFdNormalizeVelocity;
    {  }
    property NormalizeVelocity: Boolean read GetNormalizeVelocity write SetNormalizeVelocity;

    strict private FEventValue_changed: TSFVec2fEvent;
    {  }
    public property EventValue_changed: TSFVec2fEvent read FEventValue_changed;

{$endif read_interface}

{$ifdef read_implementation}

{ TSplinePositionInterpolator2DNode ----------------------------------------------- }

function TSplinePositionInterpolator2DNode.GetClosed: Boolean;
begin
  Result := FdClosed.Value;
end;

procedure TSplinePositionInterpolator2DNode.SetClosed(const Value: Boolean);
begin
  FdClosed.Send(Value);
end;

procedure TSplinePositionInterpolator2DNode.SetKeyValue(const Value: array of TVector2);
begin
  FdKeyValue.Send(Value);
end;

procedure TSplinePositionInterpolator2DNode.SetKeyValue(const Value: TVector2List);
begin
  FdKeyValue.Send(Value);
end;

procedure TSplinePositionInterpolator2DNode.SetKeyVelocity(const Value: array of TVector2);
begin
  FdKeyVelocity.Send(Value);
end;

procedure TSplinePositionInterpolator2DNode.SetKeyVelocity(const Value: TVector2List);
begin
  FdKeyVelocity.Send(Value);
end;

function TSplinePositionInterpolator2DNode.GetNormalizeVelocity: Boolean;
begin
  Result := FdNormalizeVelocity.Value;
end;

procedure TSplinePositionInterpolator2DNode.SetNormalizeVelocity(const Value: Boolean);
begin
  FdNormalizeVelocity.Send(Value);
end;

class function TSplinePositionInterpolator2DNode.ClassX3DType: String;
begin
  Result := 'SplinePositionInterpolator2D';
end;

procedure TSplinePositionInterpolator2DNode.CreateNode;
begin
  inherited;

  FFdClosed := TSFBool.Create(Self, True, 'closed', false);
   FdClosed.ChangeAlways := chNone;
  AddField(FFdClosed);

  FFdKeyValue := TMFVec2f.Create(Self, True, 'keyValue', []);
   FdKeyValue.ChangeAlways := chNone;
  AddField(FFdKeyValue);

  FFdKeyVelocity := TMFVec2f.Create(Self, True, 'keyVelocity', []);
   FdKeyVelocity.ChangeAlways := chNone;
  AddField(FFdKeyVelocity);

  FFdNormalizeVelocity := TSFBool.Create(Self, True, 'normalizeVelocity', false);
   FdNormalizeVelocity.ChangeAlways := chNone;
  AddField(FFdNormalizeVelocity);

  FEventValue_changed := TSFVec2fEvent.Create(Self, 'value_changed', false);
  AddEvent(FEventValue_changed);
end;

{$endif read_implementation}
