{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetFieldOfView: TVector4;
    procedure SetFieldOfView(const Value: TVector4);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdFieldOfView: TSFVec4f;
    { Internal wrapper for property @code(FieldOfView). This wrapper API may change, we advise to access simpler @code(FieldOfView) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdFieldOfView: TSFVec4f read FFdFieldOfView;
    {  }
    property FieldOfView: TVector4 read GetFieldOfView write SetFieldOfView;

{$endif read_interface}

{$ifdef read_implementation}

{ TTextureProjectorParallelNode ----------------------------------------------- }

function TTextureProjectorParallelNode.GetFieldOfView: TVector4;
begin
  Result := FdFieldOfView.Value;
end;

procedure TTextureProjectorParallelNode.SetFieldOfView(const Value: TVector4);
begin
  FdFieldOfView.Send(Value);
end;

class function TTextureProjectorParallelNode.ClassX3DType: String;
begin
  Result := 'TextureProjectorParallel';
end;

procedure TTextureProjectorParallelNode.CreateNode;
begin
  inherited;

  FFdFieldOfView := TSFVec4f.Create(Self, True, 'fieldOfView', Vector4(-1, -1, 1, 1));
   FdFieldOfView.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdFieldOfView);
end;

{$endif read_implementation}
