{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetCycleInterval: TFloatTime;
    procedure SetCycleInterval(const Value: TFloatTime);
    function GetEnabled: Boolean;
    procedure SetEnabled(const Value: Boolean);
    function GetFractionIncreasing: Boolean;
    procedure SetFractionIncreasing(const Value: Boolean);
    function GetDetectAffectedFields: Boolean;
    procedure SetDetectAffectedFields(const Value: Boolean);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdCycleInterval: TSFTime;
    { Internal wrapper for property @code(CycleInterval). This wrapper API may change, we advise to access simpler @code(CycleInterval) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdCycleInterval: TSFTime read FFdCycleInterval;
    {  }
    property CycleInterval: TFloatTime read GetCycleInterval write SetCycleInterval;

    strict private FEventCycleTime: TSFTimeEvent;
    {  }
    public property EventCycleTime: TSFTimeEvent read FEventCycleTime;

    strict private FEventFraction_changed: TSFFloatEvent;
    {  }
    public property EventFraction_changed: TSFFloatEvent read FEventFraction_changed;

    strict private FEventTime: TSFTimeEvent;
    {  }
    public property EventTime: TSFTimeEvent read FEventTime;

    strict private FFdEnabled: TSFBool;
    { Internal wrapper for property @code(Enabled). This wrapper API may change, we advise to access simpler @code(Enabled) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEnabled: TSFBool read FFdEnabled;
    {  }
    property Enabled: Boolean read GetEnabled write SetEnabled;

    strict private FFdFractionIncreasing: TSFBool;
    { Internal wrapper for property @code(FractionIncreasing). This wrapper API may change, we advise to access simpler @code(FractionIncreasing) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdFractionIncreasing: TSFBool read FFdFractionIncreasing;
    {  }
    property FractionIncreasing: Boolean read GetFractionIncreasing write SetFractionIncreasing;

    strict private FFdDetectAffectedFields: TSFBool;
    { Internal wrapper for property @code(DetectAffectedFields). This wrapper API may change, we advise to access simpler @code(DetectAffectedFields) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDetectAffectedFields: TSFBool read FFdDetectAffectedFields;
    {  }
    property DetectAffectedFields: Boolean read GetDetectAffectedFields write SetDetectAffectedFields;

{$endif read_interface}

{$ifdef read_implementation}

{ TTimeSensorNode ----------------------------------------------- }

function TTimeSensorNode.GetCycleInterval: TFloatTime;
begin
  Result := FdCycleInterval.Value;
end;

procedure TTimeSensorNode.SetCycleInterval(const Value: TFloatTime);
begin
  FdCycleInterval.Send(Value);
end;

function TTimeSensorNode.GetEnabled: Boolean;
begin
  Result := FdEnabled.Value;
end;

procedure TTimeSensorNode.SetEnabled(const Value: Boolean);
begin
  FdEnabled.Send(Value);
end;

function TTimeSensorNode.GetFractionIncreasing: Boolean;
begin
  Result := FdFractionIncreasing.Value;
end;

procedure TTimeSensorNode.SetFractionIncreasing(const Value: Boolean);
begin
  FdFractionIncreasing.Send(Value);
end;

function TTimeSensorNode.GetDetectAffectedFields: Boolean;
begin
  Result := FdDetectAffectedFields.Value;
end;

procedure TTimeSensorNode.SetDetectAffectedFields(const Value: Boolean);
begin
  FdDetectAffectedFields.Send(Value);
end;

class function TTimeSensorNode.ClassX3DType: String;
begin
  Result := 'TimeSensor';
end;

procedure TTimeSensorNode.CreateNode;
begin
  inherited;

  FFdCycleInterval := TSFTime.Create(Self, True, 'cycleInterval', 1);
   FdCycleInterval.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdCycleInterval);

  FEventCycleTime := TSFTimeEvent.Create(Self, 'cycleTime', false);
  AddEvent(FEventCycleTime);

  FEventFraction_changed := TSFFloatEvent.Create(Self, 'fraction_changed', false);
  AddEvent(FEventFraction_changed);

  FEventTime := TSFTimeEvent.Create(Self, 'time', false);
  AddEvent(FEventTime);

  FFdEnabled := TSFBool.Create(Self, True, 'enabled', true);
   FdEnabled.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEnabled);

  FFdFractionIncreasing := TSFBool.Create(Self, True, 'fractionIncreasing', true);
   FdFractionIncreasing.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdFractionIncreasing);

  FFdDetectAffectedFields := TSFBool.Create(Self, False, 'detectAffectedFields', true);
   FdDetectAffectedFields.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDetectAffectedFields);
end;

{$endif read_implementation}
