{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetAttenuation: TVector3;
    procedure SetAttenuation(const Value: TVector3);
    function GetLocation: TVector3;
    procedure SetLocation(const Value: TVector3);
    function GetRadius: Single;
    procedure SetRadius(const Value: Single);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdAttenuation: TSFVec3f;
    { Internal wrapper for property @code(Attenuation). This wrapper API may change, we advise to access simpler @code(Attenuation) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAttenuation: TSFVec3f read FFdAttenuation;
    {  }
    property Attenuation: TVector3 read GetAttenuation write SetAttenuation;

    strict private FFdLocation: TSFVec3f;
    { Internal wrapper for property @code(Location). This wrapper API may change, we advise to access simpler @code(Location) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdLocation: TSFVec3f read FFdLocation;
    {  }
    property Location: TVector3 read GetLocation write SetLocation;

    strict private FFdRadius: TSFFloat;
    { Internal wrapper for property @code(Radius). This wrapper API may change, we advise to access simpler @code(Radius) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdRadius: TSFFloat read FFdRadius;
    {  }
    property Radius: Single read GetRadius write SetRadius;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractPositionalLightNode ----------------------------------------------- }

function TAbstractPositionalLightNode.GetAttenuation: TVector3;
begin
  Result := FdAttenuation.Value;
end;

procedure TAbstractPositionalLightNode.SetAttenuation(const Value: TVector3);
begin
  FdAttenuation.Send(Value);
end;

function TAbstractPositionalLightNode.GetLocation: TVector3;
begin
  Result := FdLocation.Value;
end;

procedure TAbstractPositionalLightNode.SetLocation(const Value: TVector3);
begin
  FdLocation.Send(Value);
end;

function TAbstractPositionalLightNode.GetRadius: Single;
begin
  Result := FdRadius.Value;
end;

procedure TAbstractPositionalLightNode.SetRadius(const Value: Single);
begin
  FdRadius.Send(Value);
end;

class function TAbstractPositionalLightNode.ClassX3DType: String;
begin
  Result := 'X3DPositionalLightNode';
end;

procedure TAbstractPositionalLightNode.CreateNode;
begin
  inherited;

  FFdAttenuation := TSFVec3f.Create(Self, True, 'attenuation', Vector3(1, 0, 0));
   FdAttenuation.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAttenuation);

  FFdLocation := TSFVec3f.Create(Self, True, 'location', Vector3(0, 0, 0));
   FdLocation.ChangeAlways := chLightLocationDirection;
  AddField(FFdLocation);

  FFdRadius := TSFFloat.Create(Self, True, 'radius', 100);
   FdRadius.ChangeAlways := chLightInstanceProperty;
  AddField(FFdRadius);
end;

{$endif read_implementation}
