{ -*- buffer-read-only: t -*-

  Copyright 2018-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated wrapper to make vectors/colors persistent.

  Do not edit this file manually!
  Instead
  - edit tools/internal/generate-persistent-vectors/persistent_vectors_input.txt
  - and run generate-persistent-vectors in that directory.
}

{$ifdef read_interface_class}
strict private
  FBorderColorPersistent: TCastleColorPersistent;
  function GetBorderColorForPersistent: TCastleColor;
  procedure SetBorderColorForPersistent(const AValue: TCastleColor);
published
  { @link(BorderColor) that can be visually edited in
    Castle Game Engine Editor, Lazarus and Delphi.
    Normal user code does not need to deal with this,
    instead read or write @link(BorderColor) directly.

    @seealso BorderColor }
  property BorderColorPersistent: TCastleColorPersistent read FBorderColorPersistent ;
{$endif read_interface_class}

{$ifdef read_implementation_methods}
function TCastleUserInterface.GetBorderColorForPersistent: TCastleColor;
begin
  Result := BorderColor;
end;

procedure TCastleUserInterface.SetBorderColorForPersistent(const AValue: TCastleColor);
begin
  BorderColor := AValue;
end;
{$endif read_implementation_methods}

{$ifdef read_implementation_constructor}
  FBorderColorPersistent := TCastleColorPersistent.Create(nil);
  { Note that some classes (like TCastleVector3Persistent) call SetSubComponent(true)
    on themselves, for backward compatibility. But we should not depend on it,
    some classes (like TFloatRectanglePersisten) may not call it.
    The responsibility of calling "SetSubComponent(true)" should be on the owner
    in general (this is more functional, and more standard too). }
  FBorderColorPersistent.SetSubComponent(true);
  FBorderColorPersistent.InternalGetValue := {$ifdef FPC}@{$endif}GetBorderColorForPersistent;
  FBorderColorPersistent.InternalSetValue := {$ifdef FPC}@{$endif}SetBorderColorForPersistent;
  FBorderColorPersistent.InternalDefaultValue := BorderColor; // current value is default
{$endif read_implementation_constructor}

{$ifdef read_implementation_destructor}
  FreeAndNil(FBorderColorPersistent);
{$endif read_implementation_destructor}

{ -*- buffer-read-only: t -*-

  Copyright 2018-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated wrapper to make vectors/colors persistent.

  Do not edit this file manually!
  Instead
  - edit tools/internal/generate-persistent-vectors/persistent_vectors_input.txt
  - and run generate-persistent-vectors in that directory.
}

{$ifdef read_interface_class}
strict private
  FTranslationPersistent: TCastleVector2Persistent;
  function GetTranslationForPersistent: TVector2;
  procedure SetTranslationForPersistent(const AValue: TVector2);
published
  { @link(Translation) that can be visually edited in
    Castle Game Engine Editor, Lazarus and Delphi.
    Normal user code does not need to deal with this,
    instead read or write @link(Translation) directly.

    @seealso Translation }
  property TranslationPersistent: TCastleVector2Persistent read FTranslationPersistent ;
{$endif read_interface_class}

{$ifdef read_implementation_methods}
function TCastleUserInterface.GetTranslationForPersistent: TVector2;
begin
  Result := Translation;
end;

procedure TCastleUserInterface.SetTranslationForPersistent(const AValue: TVector2);
begin
  Translation := AValue;
end;
{$endif read_implementation_methods}

{$ifdef read_implementation_constructor}
  FTranslationPersistent := TCastleVector2Persistent.Create(nil);
  { Note that some classes (like TCastleVector3Persistent) call SetSubComponent(true)
    on themselves, for backward compatibility. But we should not depend on it,
    some classes (like TFloatRectanglePersisten) may not call it.
    The responsibility of calling "SetSubComponent(true)" should be on the owner
    in general (this is more functional, and more standard too). }
  FTranslationPersistent.SetSubComponent(true);
  FTranslationPersistent.InternalGetValue := {$ifdef FPC}@{$endif}GetTranslationForPersistent;
  FTranslationPersistent.InternalSetValue := {$ifdef FPC}@{$endif}SetTranslationForPersistent;
  FTranslationPersistent.InternalDefaultValue := Translation; // current value is default
{$endif read_implementation_constructor}

{$ifdef read_implementation_destructor}
  FreeAndNil(FTranslationPersistent);
{$endif read_implementation_destructor}

