#!/bin/sh

# This script was used to update most of CDT's plugins from
# java 7 to java 8.
# The script recursively updated all plugins starting
# at $root_dir from java version $old_ver to $new_ver
# for changes required to go from java 7 to java 8.
#
# To re-use this script in the future for a new version of java,
# please make sure its behaviour mimics Eclipse behavior of
# "Update the classpath settings" in the Overview tab of manifest
# file editor.

old_ver=1\\.7 # Need to escape the . to avoid it matching any character
new_ver=1.8
java_name=JavaSE

root_dir=.

classpath_file=.classpath
manifest_file=MANIFEST.MF
jdt_pref_file=org.eclipse.jdt.core.prefs
jdt_pref1=org.eclipse.jdt.core.compiler.codegen.targetPlatform
jdt_pref2=org.eclipse.jdt.core.compiler.compliance
jdt_pref3=org.eclipse.jdt.core.compiler.source

fix_classpath_file()
{
    find $root_dir -type f -name ${classpath_file} \
        -exec sed -i s,${java_name}-${old_ver},${java_name}-${new_ver}, '{}' \;
}

fix_manifest_file()
{
    find $root_dir -type f -name ${manifest_file} \
        -exec sed -i s,${java_name}-${old_ver},${java_name}-${new_ver}, '{}' \;
}

fix_jdt_prefs_file()
{
    find $root_dir -type f -name ${jdt_pref_file} \
        -exec sed -i s,${jdt_pref1}=$old_ver,${jdt_pref1}=$new_ver, '{}' \;
    find $root_dir -type f -name ${jdt_pref_file} \
        -exec sed -i s,${jdt_pref2}=$old_ver,${jdt_pref2}=$new_ver, '{}' \;
    find $root_dir -type f -name ${jdt_pref_file} \
        -exec sed -i s,${jdt_pref3}=$old_ver,${jdt_pref3}=$new_ver, '{}' \;
}

launch_file=StandaloneTests.launch
fix_standalone_debugger_test_launch()
{
    find $root_dir -type f -name ${launch_file} \
        -exec sed -i s,${java_name}-${old_ver},${java_name}-${new_ver}, '{}' \;
}

pom_file=pom.xml
fix_pom()
{
    find $root_dir -type f -name ${pom_file} \
        -exec sed -i s,sonar.java.source\>${old_ver},sonar.java.source\>${new_ver}, '{}' \;
    find $root_dir -type f -name ${pom_file} \
        -exec sed -i s,targetJdk\>${old_ver},targetJdk\>${new_ver}, '{}' \;
}

old_ver_remaining_log=/tmp/remaingOldStrings.log
grep_for_remaining_old_version_string()
{
    echo "Please CHECK the file\n   ${old_ver_remaining_log}\nfor any remaining instances"\
         "of ${old_ver} below directory:\n   $root_dir\nto make sure they were not forgotten."
    grep -r ${old_ver} ${root_dir} | grep -v "/target/" | grep -v "Binary file" | grep -vF .log | grep -v "Generated by javadoc" > ${old_ver_remaining_log}
    echo "Please also CHECK that all changes made are correct before committing"
}

fix_classpath_file
fix_manifest_file
fix_jdt_prefs_file
fix_standalone_debugger_test_launch
fix_pom
grep_for_remaining_old_version_string
