// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/securitycentermanagement/v1/security_center_management.proto

package securitycentermanagementpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	iampb "cloud.google.com/go/iam/apiv1/iampb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	expr "google.golang.org/genproto/googleapis/type/expr"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The enablement state of the module.
type EffectiveSecurityHealthAnalyticsCustomModule_EnablementState int32

const (
	// Unspecified enablement state.
	EffectiveSecurityHealthAnalyticsCustomModule_ENABLEMENT_STATE_UNSPECIFIED EffectiveSecurityHealthAnalyticsCustomModule_EnablementState = 0
	// The module is enabled at the given level.
	EffectiveSecurityHealthAnalyticsCustomModule_ENABLED EffectiveSecurityHealthAnalyticsCustomModule_EnablementState = 1
	// The module is disabled at the given level.
	EffectiveSecurityHealthAnalyticsCustomModule_DISABLED EffectiveSecurityHealthAnalyticsCustomModule_EnablementState = 2
)

// Enum value maps for EffectiveSecurityHealthAnalyticsCustomModule_EnablementState.
var (
	EffectiveSecurityHealthAnalyticsCustomModule_EnablementState_name = map[int32]string{
		0: "ENABLEMENT_STATE_UNSPECIFIED",
		1: "ENABLED",
		2: "DISABLED",
	}
	EffectiveSecurityHealthAnalyticsCustomModule_EnablementState_value = map[string]int32{
		"ENABLEMENT_STATE_UNSPECIFIED": 0,
		"ENABLED":                      1,
		"DISABLED":                     2,
	}
)

func (x EffectiveSecurityHealthAnalyticsCustomModule_EnablementState) Enum() *EffectiveSecurityHealthAnalyticsCustomModule_EnablementState {
	p := new(EffectiveSecurityHealthAnalyticsCustomModule_EnablementState)
	*p = x
	return p
}

func (x EffectiveSecurityHealthAnalyticsCustomModule_EnablementState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EffectiveSecurityHealthAnalyticsCustomModule_EnablementState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_enumTypes[0].Descriptor()
}

func (EffectiveSecurityHealthAnalyticsCustomModule_EnablementState) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_enumTypes[0]
}

func (x EffectiveSecurityHealthAnalyticsCustomModule_EnablementState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EffectiveSecurityHealthAnalyticsCustomModule_EnablementState.Descriptor instead.
func (EffectiveSecurityHealthAnalyticsCustomModule_EnablementState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{0, 0}
}

// Possible enablement states of a custom module.
type SecurityHealthAnalyticsCustomModule_EnablementState int32

const (
	// Unspecified enablement state.
	SecurityHealthAnalyticsCustomModule_ENABLEMENT_STATE_UNSPECIFIED SecurityHealthAnalyticsCustomModule_EnablementState = 0
	// The module is enabled at the given CRM resource.
	SecurityHealthAnalyticsCustomModule_ENABLED SecurityHealthAnalyticsCustomModule_EnablementState = 1
	// The module is disabled at the given CRM resource.
	SecurityHealthAnalyticsCustomModule_DISABLED SecurityHealthAnalyticsCustomModule_EnablementState = 2
	// State is inherited from an ancestor module. The module will either
	// be effectively ENABLED or DISABLED based on its closest non-inherited
	// ancestor module in the CRM hierarchy. Attempting to set a top level
	// module (module with no parent) to the INHERITED state will result in an
	// INVALID_ARGUMENT error.
	SecurityHealthAnalyticsCustomModule_INHERITED SecurityHealthAnalyticsCustomModule_EnablementState = 3
)

// Enum value maps for SecurityHealthAnalyticsCustomModule_EnablementState.
var (
	SecurityHealthAnalyticsCustomModule_EnablementState_name = map[int32]string{
		0: "ENABLEMENT_STATE_UNSPECIFIED",
		1: "ENABLED",
		2: "DISABLED",
		3: "INHERITED",
	}
	SecurityHealthAnalyticsCustomModule_EnablementState_value = map[string]int32{
		"ENABLEMENT_STATE_UNSPECIFIED": 0,
		"ENABLED":                      1,
		"DISABLED":                     2,
		"INHERITED":                    3,
	}
)

func (x SecurityHealthAnalyticsCustomModule_EnablementState) Enum() *SecurityHealthAnalyticsCustomModule_EnablementState {
	p := new(SecurityHealthAnalyticsCustomModule_EnablementState)
	*p = x
	return p
}

func (x SecurityHealthAnalyticsCustomModule_EnablementState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecurityHealthAnalyticsCustomModule_EnablementState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_enumTypes[1].Descriptor()
}

func (SecurityHealthAnalyticsCustomModule_EnablementState) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_enumTypes[1]
}

func (x SecurityHealthAnalyticsCustomModule_EnablementState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecurityHealthAnalyticsCustomModule_EnablementState.Descriptor instead.
func (SecurityHealthAnalyticsCustomModule_EnablementState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{4, 0}
}

// Defines the valid value options for the severity of a finding.
type CustomConfig_Severity int32

const (
	// Unspecified severity.
	CustomConfig_SEVERITY_UNSPECIFIED CustomConfig_Severity = 0
	// Critical severity.
	CustomConfig_CRITICAL CustomConfig_Severity = 1
	// High severity.
	CustomConfig_HIGH CustomConfig_Severity = 2
	// Medium severity.
	CustomConfig_MEDIUM CustomConfig_Severity = 3
	// Low severity.
	CustomConfig_LOW CustomConfig_Severity = 4
)

// Enum value maps for CustomConfig_Severity.
var (
	CustomConfig_Severity_name = map[int32]string{
		0: "SEVERITY_UNSPECIFIED",
		1: "CRITICAL",
		2: "HIGH",
		3: "MEDIUM",
		4: "LOW",
	}
	CustomConfig_Severity_value = map[string]int32{
		"SEVERITY_UNSPECIFIED": 0,
		"CRITICAL":             1,
		"HIGH":                 2,
		"MEDIUM":               3,
		"LOW":                  4,
	}
)

func (x CustomConfig_Severity) Enum() *CustomConfig_Severity {
	p := new(CustomConfig_Severity)
	*p = x
	return p
}

func (x CustomConfig_Severity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CustomConfig_Severity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_enumTypes[2].Descriptor()
}

func (CustomConfig_Severity) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_enumTypes[2]
}

func (x CustomConfig_Severity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CustomConfig_Severity.Descriptor instead.
func (CustomConfig_Severity) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{5, 0}
}

// The state of the finding.
type SimulatedFinding_State int32

const (
	// Unspecified state.
	SimulatedFinding_STATE_UNSPECIFIED SimulatedFinding_State = 0
	// The finding requires attention and has not been addressed yet.
	SimulatedFinding_ACTIVE SimulatedFinding_State = 1
	// The finding has been fixed, triaged as a non-issue or otherwise addressed
	// and is no longer active.
	SimulatedFinding_INACTIVE SimulatedFinding_State = 2
)

// Enum value maps for SimulatedFinding_State.
var (
	SimulatedFinding_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "INACTIVE",
	}
	SimulatedFinding_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"INACTIVE":          2,
	}
)

func (x SimulatedFinding_State) Enum() *SimulatedFinding_State {
	p := new(SimulatedFinding_State)
	*p = x
	return p
}

func (x SimulatedFinding_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SimulatedFinding_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_enumTypes[3].Descriptor()
}

func (SimulatedFinding_State) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_enumTypes[3]
}

func (x SimulatedFinding_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SimulatedFinding_State.Descriptor instead.
func (SimulatedFinding_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{15, 0}
}

// The severity of the finding.
type SimulatedFinding_Severity int32

const (
	// This value is used for findings when a source doesn't write a severity
	// value.
	SimulatedFinding_SEVERITY_UNSPECIFIED SimulatedFinding_Severity = 0
	// Vulnerability:
	// A critical vulnerability is easily discoverable by an external actor,
	// exploitable, and results in the direct ability to execute arbitrary code,
	// exfiltrate data, and otherwise gain additional access and privileges to
	// cloud resources and workloads. Examples include publicly accessible
	// unprotected user data and public SSH access with weak or no
	// passwords.
	//
	// Threat:
	// Indicates a threat that is able to access, modify, or delete data or
	// execute unauthorized code within existing resources.
	SimulatedFinding_CRITICAL SimulatedFinding_Severity = 1
	// Vulnerability:
	// A high risk vulnerability can be easily discovered and exploited in
	// combination with other vulnerabilities in order to gain direct access and
	// the ability to execute arbitrary code, exfiltrate data, and otherwise
	// gain additional access and privileges to cloud resources and workloads.
	// An example is a database with weak or no passwords that is only
	// accessible internally. This database could easily be compromised by an
	// actor that had access to the internal network.
	//
	// Threat:
	// Indicates a threat that is able to create new computational resources in
	// an environment but not able to access data or execute code in existing
	// resources.
	SimulatedFinding_HIGH SimulatedFinding_Severity = 2
	// Vulnerability:
	// A medium risk vulnerability could be used by an actor to gain access to
	// resources or privileges that enable them to eventually (through multiple
	// steps or a complex exploit) gain access and the ability to execute
	// arbitrary code or exfiltrate data. An example is a service account with
	// access to more projects than it should have. If an actor gains access to
	// the service account, they could potentially use that access to manipulate
	// a project the service account was not intended to.
	//
	// Threat:
	// Indicates a threat that is able to cause operational impact but may not
	// access data or execute unauthorized code.
	SimulatedFinding_MEDIUM SimulatedFinding_Severity = 3
	// Vulnerability:
	// A low risk vulnerability hampers a security organization's ability to
	// detect vulnerabilities or active threats in their deployment, or prevents
	// the root cause investigation of security issues. An example is monitoring
	// and logs being disabled for resource configurations and access.
	//
	// Threat:
	// Indicates a threat that has obtained minimal access to an environment but
	// is not able to access data, execute code, or create resources.
	SimulatedFinding_LOW SimulatedFinding_Severity = 4
)

// Enum value maps for SimulatedFinding_Severity.
var (
	SimulatedFinding_Severity_name = map[int32]string{
		0: "SEVERITY_UNSPECIFIED",
		1: "CRITICAL",
		2: "HIGH",
		3: "MEDIUM",
		4: "LOW",
	}
	SimulatedFinding_Severity_value = map[string]int32{
		"SEVERITY_UNSPECIFIED": 0,
		"CRITICAL":             1,
		"HIGH":                 2,
		"MEDIUM":               3,
		"LOW":                  4,
	}
)

func (x SimulatedFinding_Severity) Enum() *SimulatedFinding_Severity {
	p := new(SimulatedFinding_Severity)
	*p = x
	return p
}

func (x SimulatedFinding_Severity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SimulatedFinding_Severity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_enumTypes[4].Descriptor()
}

func (SimulatedFinding_Severity) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_enumTypes[4]
}

func (x SimulatedFinding_Severity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SimulatedFinding_Severity.Descriptor instead.
func (SimulatedFinding_Severity) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{15, 1}
}

// Represents what kind of Finding it is.
type SimulatedFinding_FindingClass int32

const (
	// Unspecified finding class.
	SimulatedFinding_FINDING_CLASS_UNSPECIFIED SimulatedFinding_FindingClass = 0
	// Describes unwanted or malicious activity.
	SimulatedFinding_THREAT SimulatedFinding_FindingClass = 1
	// Describes a potential weakness in software that increases risk to
	// Confidentiality & Integrity & Availability.
	SimulatedFinding_VULNERABILITY SimulatedFinding_FindingClass = 2
	// Describes a potential weakness in cloud resource/asset configuration that
	// increases risk.
	SimulatedFinding_MISCONFIGURATION SimulatedFinding_FindingClass = 3
	// Describes a security observation that is for informational purposes.
	SimulatedFinding_OBSERVATION SimulatedFinding_FindingClass = 4
	// Describes an error that prevents some SCC functionality.
	SimulatedFinding_SCC_ERROR SimulatedFinding_FindingClass = 5
	// Describes a potential security risk due to a change in the security
	// posture.
	SimulatedFinding_POSTURE_VIOLATION SimulatedFinding_FindingClass = 6
)

// Enum value maps for SimulatedFinding_FindingClass.
var (
	SimulatedFinding_FindingClass_name = map[int32]string{
		0: "FINDING_CLASS_UNSPECIFIED",
		1: "THREAT",
		2: "VULNERABILITY",
		3: "MISCONFIGURATION",
		4: "OBSERVATION",
		5: "SCC_ERROR",
		6: "POSTURE_VIOLATION",
	}
	SimulatedFinding_FindingClass_value = map[string]int32{
		"FINDING_CLASS_UNSPECIFIED": 0,
		"THREAT":                    1,
		"VULNERABILITY":             2,
		"MISCONFIGURATION":          3,
		"OBSERVATION":               4,
		"SCC_ERROR":                 5,
		"POSTURE_VIOLATION":         6,
	}
)

func (x SimulatedFinding_FindingClass) Enum() *SimulatedFinding_FindingClass {
	p := new(SimulatedFinding_FindingClass)
	*p = x
	return p
}

func (x SimulatedFinding_FindingClass) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SimulatedFinding_FindingClass) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_enumTypes[5].Descriptor()
}

func (SimulatedFinding_FindingClass) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_enumTypes[5]
}

func (x SimulatedFinding_FindingClass) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SimulatedFinding_FindingClass.Descriptor instead.
func (SimulatedFinding_FindingClass) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{15, 2}
}

// The enablement state of the module.
type EffectiveEventThreatDetectionCustomModule_EnablementState int32

const (
	// Unspecified enablement state.
	EffectiveEventThreatDetectionCustomModule_ENABLEMENT_STATE_UNSPECIFIED EffectiveEventThreatDetectionCustomModule_EnablementState = 0
	// The module is enabled at the given level.
	EffectiveEventThreatDetectionCustomModule_ENABLED EffectiveEventThreatDetectionCustomModule_EnablementState = 1
	// The module is disabled at the given level.
	EffectiveEventThreatDetectionCustomModule_DISABLED EffectiveEventThreatDetectionCustomModule_EnablementState = 2
)

// Enum value maps for EffectiveEventThreatDetectionCustomModule_EnablementState.
var (
	EffectiveEventThreatDetectionCustomModule_EnablementState_name = map[int32]string{
		0: "ENABLEMENT_STATE_UNSPECIFIED",
		1: "ENABLED",
		2: "DISABLED",
	}
	EffectiveEventThreatDetectionCustomModule_EnablementState_value = map[string]int32{
		"ENABLEMENT_STATE_UNSPECIFIED": 0,
		"ENABLED":                      1,
		"DISABLED":                     2,
	}
)

func (x EffectiveEventThreatDetectionCustomModule_EnablementState) Enum() *EffectiveEventThreatDetectionCustomModule_EnablementState {
	p := new(EffectiveEventThreatDetectionCustomModule_EnablementState)
	*p = x
	return p
}

func (x EffectiveEventThreatDetectionCustomModule_EnablementState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EffectiveEventThreatDetectionCustomModule_EnablementState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_enumTypes[6].Descriptor()
}

func (EffectiveEventThreatDetectionCustomModule_EnablementState) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_enumTypes[6]
}

func (x EffectiveEventThreatDetectionCustomModule_EnablementState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EffectiveEventThreatDetectionCustomModule_EnablementState.Descriptor instead.
func (EffectiveEventThreatDetectionCustomModule_EnablementState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{17, 0}
}

// The enablement state of the module.
type EventThreatDetectionCustomModule_EnablementState int32

const (
	// Unspecified enablement state.
	EventThreatDetectionCustomModule_ENABLEMENT_STATE_UNSPECIFIED EventThreatDetectionCustomModule_EnablementState = 0
	// The module is enabled at the given level.
	EventThreatDetectionCustomModule_ENABLED EventThreatDetectionCustomModule_EnablementState = 1
	// The module is disabled at the given level.
	EventThreatDetectionCustomModule_DISABLED EventThreatDetectionCustomModule_EnablementState = 2
	// State is inherited from an ancestor module. The module will either
	// be effectively ENABLED or DISABLED based on its closest non-inherited
	// ancestor module in the CRM hierarchy. Attempting to set a top level
	// module (module with no parent) to the INHERITED state will result in an
	// error.
	EventThreatDetectionCustomModule_INHERITED EventThreatDetectionCustomModule_EnablementState = 3
)

// Enum value maps for EventThreatDetectionCustomModule_EnablementState.
var (
	EventThreatDetectionCustomModule_EnablementState_name = map[int32]string{
		0: "ENABLEMENT_STATE_UNSPECIFIED",
		1: "ENABLED",
		2: "DISABLED",
		3: "INHERITED",
	}
	EventThreatDetectionCustomModule_EnablementState_value = map[string]int32{
		"ENABLEMENT_STATE_UNSPECIFIED": 0,
		"ENABLED":                      1,
		"DISABLED":                     2,
		"INHERITED":                    3,
	}
)

func (x EventThreatDetectionCustomModule_EnablementState) Enum() *EventThreatDetectionCustomModule_EnablementState {
	p := new(EventThreatDetectionCustomModule_EnablementState)
	*p = x
	return p
}

func (x EventThreatDetectionCustomModule_EnablementState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EventThreatDetectionCustomModule_EnablementState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_enumTypes[7].Descriptor()
}

func (EventThreatDetectionCustomModule_EnablementState) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_enumTypes[7]
}

func (x EventThreatDetectionCustomModule_EnablementState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EventThreatDetectionCustomModule_EnablementState.Descriptor instead.
func (EventThreatDetectionCustomModule_EnablementState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{21, 0}
}

// An EffectiveSecurityHealthAnalyticsCustomModule is the representation of
// a Security Health Analytics custom module at a specified level of the
// resource hierarchy: organization, folder, or project. If a custom module is
// inherited from a parent organization or folder, the value of the
// `enablementState` property in EffectiveSecurityHealthAnalyticsCustomModule is
// set to the value that is effective in the parent, instead of  `INHERITED`.
// For example, if the module is enabled in a parent organization or folder, the
// effective enablement_state for the module in all child folders or projects is
// also `enabled`. EffectiveSecurityHealthAnalyticsCustomModule is read-only.
type EffectiveSecurityHealthAnalyticsCustomModule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name of the custom module.
	// Its format is
	// "organizations/{organization}/locations/{location}/effectiveSecurityHealthAnalyticsCustomModules/{effective_security_health_analytics_custom_module}",
	// or
	// "folders/{folder}/locations/{location}/effectiveSecurityHealthAnalyticsCustomModules/{effective_security_health_analytics_custom_module}",
	// or
	// "projects/{project}/locations/{location}/effectiveSecurityHealthAnalyticsCustomModules/{effective_security_health_analytics_custom_module}"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The user-specified configuration for the module.
	CustomConfig *CustomConfig `protobuf:"bytes,2,opt,name=custom_config,json=customConfig,proto3" json:"custom_config,omitempty"`
	// Output only. The effective state of enablement for the module at the given
	// level of the hierarchy.
	EnablementState EffectiveSecurityHealthAnalyticsCustomModule_EnablementState `protobuf:"varint,3,opt,name=enablement_state,json=enablementState,proto3,enum=google.cloud.securitycentermanagement.v1.EffectiveSecurityHealthAnalyticsCustomModule_EnablementState" json:"enablement_state,omitempty"`
	// Output only. The display name for the custom module. The name must be
	// between 1 and 128 characters, start with a lowercase letter, and contain
	// alphanumeric characters or underscores only.
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *EffectiveSecurityHealthAnalyticsCustomModule) Reset() {
	*x = EffectiveSecurityHealthAnalyticsCustomModule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EffectiveSecurityHealthAnalyticsCustomModule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EffectiveSecurityHealthAnalyticsCustomModule) ProtoMessage() {}

func (x *EffectiveSecurityHealthAnalyticsCustomModule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EffectiveSecurityHealthAnalyticsCustomModule.ProtoReflect.Descriptor instead.
func (*EffectiveSecurityHealthAnalyticsCustomModule) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{0}
}

func (x *EffectiveSecurityHealthAnalyticsCustomModule) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EffectiveSecurityHealthAnalyticsCustomModule) GetCustomConfig() *CustomConfig {
	if x != nil {
		return x.CustomConfig
	}
	return nil
}

func (x *EffectiveSecurityHealthAnalyticsCustomModule) GetEnablementState() EffectiveSecurityHealthAnalyticsCustomModule_EnablementState {
	if x != nil {
		return x.EnablementState
	}
	return EffectiveSecurityHealthAnalyticsCustomModule_ENABLEMENT_STATE_UNSPECIFIED
}

func (x *EffectiveSecurityHealthAnalyticsCustomModule) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// Request message for listing effective Security Health Analytics custom
// modules.
type ListEffectiveSecurityHealthAnalyticsCustomModulesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of parent to list effective custom modules. Its format is
	// "organizations/{organization}/locations/{location}",
	// "folders/{folder}/locations/{location}",
	// or
	// "projects/{project}/locations/{location}"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of results to return in a single response.
	// Default is 10, minimum is 1, maximum is 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The value returned by the last call indicating a continuation.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListEffectiveSecurityHealthAnalyticsCustomModulesRequest) Reset() {
	*x = ListEffectiveSecurityHealthAnalyticsCustomModulesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEffectiveSecurityHealthAnalyticsCustomModulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEffectiveSecurityHealthAnalyticsCustomModulesRequest) ProtoMessage() {}

func (x *ListEffectiveSecurityHealthAnalyticsCustomModulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEffectiveSecurityHealthAnalyticsCustomModulesRequest.ProtoReflect.Descriptor instead.
func (*ListEffectiveSecurityHealthAnalyticsCustomModulesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{1}
}

func (x *ListEffectiveSecurityHealthAnalyticsCustomModulesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEffectiveSecurityHealthAnalyticsCustomModulesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEffectiveSecurityHealthAnalyticsCustomModulesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for listing effective Security Health Analytics custom
// modules.
type ListEffectiveSecurityHealthAnalyticsCustomModulesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of EffectiveSecurityHealthAnalyticsCustomModule
	EffectiveSecurityHealthAnalyticsCustomModules []*EffectiveSecurityHealthAnalyticsCustomModule `protobuf:"bytes,1,rep,name=effective_security_health_analytics_custom_modules,json=effectiveSecurityHealthAnalyticsCustomModules,proto3" json:"effective_security_health_analytics_custom_modules,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListEffectiveSecurityHealthAnalyticsCustomModulesResponse) Reset() {
	*x = ListEffectiveSecurityHealthAnalyticsCustomModulesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEffectiveSecurityHealthAnalyticsCustomModulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEffectiveSecurityHealthAnalyticsCustomModulesResponse) ProtoMessage() {}

func (x *ListEffectiveSecurityHealthAnalyticsCustomModulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEffectiveSecurityHealthAnalyticsCustomModulesResponse.ProtoReflect.Descriptor instead.
func (*ListEffectiveSecurityHealthAnalyticsCustomModulesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{2}
}

func (x *ListEffectiveSecurityHealthAnalyticsCustomModulesResponse) GetEffectiveSecurityHealthAnalyticsCustomModules() []*EffectiveSecurityHealthAnalyticsCustomModule {
	if x != nil {
		return x.EffectiveSecurityHealthAnalyticsCustomModules
	}
	return nil
}

func (x *ListEffectiveSecurityHealthAnalyticsCustomModulesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Message for getting a EffectiveSecurityHealthAnalyticsCustomModule
type GetEffectiveSecurityHealthAnalyticsCustomModuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the SHA custom module.
	//
	// Its format is:
	//
	//   - "organizations/{organization}/locations/{location}/effectiveSecurityHealthAnalyticsCustomModules/{module_id}".
	//   - "folders/{folder}/locations/{location}/effectiveSecurityHealthAnalyticsCustomModules/{module_id}".
	//   - "projects/{project}/locations/{location}/effectiveSecurityHealthAnalyticsCustomModules/{module_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEffectiveSecurityHealthAnalyticsCustomModuleRequest) Reset() {
	*x = GetEffectiveSecurityHealthAnalyticsCustomModuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEffectiveSecurityHealthAnalyticsCustomModuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEffectiveSecurityHealthAnalyticsCustomModuleRequest) ProtoMessage() {}

func (x *GetEffectiveSecurityHealthAnalyticsCustomModuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEffectiveSecurityHealthAnalyticsCustomModuleRequest.ProtoReflect.Descriptor instead.
func (*GetEffectiveSecurityHealthAnalyticsCustomModuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{3}
}

func (x *GetEffectiveSecurityHealthAnalyticsCustomModuleRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Represents an instance of a Security Health Analytics custom module,
// including its full module name, display name, enablement state, and last
// updated time. You can create a custom module at the organization, folder, or
// project level. Custom modules that you create at the organization or folder
// level are inherited by the child folders and projects.
type SecurityHealthAnalyticsCustomModule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name of the custom module.
	// Its format is
	// "organizations/{organization}/locations/{location}/securityHealthAnalyticsCustomModules/{security_health_analytics_custom_module}",
	// or
	// "folders/{folder}/locations/{location}/securityHealthAnalyticsCustomModules/{security_health_analytics_custom_module}",
	// or
	// "projects/{project}/locations/{location}/securityHealthAnalyticsCustomModules/{security_health_analytics_custom_module}"
	//
	// The id {customModule} is server-generated and is not user settable.
	// It will be a numeric id containing 1-20 digits.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The display name of the Security Health Analytics custom module.
	// This display name becomes the finding category for all findings that are
	// returned by this custom module. The display name must be between 1 and
	// 128 characters, start with a lowercase letter, and contain alphanumeric
	// characters or underscores only.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. The enablement state of the custom module.
	EnablementState SecurityHealthAnalyticsCustomModule_EnablementState `protobuf:"varint,3,opt,name=enablement_state,json=enablementState,proto3,enum=google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule_EnablementState" json:"enablement_state,omitempty"`
	// Output only. The time at which the custom module was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The editor that last updated the custom module.
	LastEditor string `protobuf:"bytes,5,opt,name=last_editor,json=lastEditor,proto3" json:"last_editor,omitempty"`
	// Output only. Specifies the organization or folder from which the custom
	// module is inherited. If empty, indicates that the custom module was created
	// in the organization, folder, or project in which you are viewing the custom
	// module.
	AncestorModule string `protobuf:"bytes,6,opt,name=ancestor_module,json=ancestorModule,proto3" json:"ancestor_module,omitempty"`
	// Optional. The user specified custom configuration for the module.
	CustomConfig *CustomConfig `protobuf:"bytes,7,opt,name=custom_config,json=customConfig,proto3" json:"custom_config,omitempty"`
}

func (x *SecurityHealthAnalyticsCustomModule) Reset() {
	*x = SecurityHealthAnalyticsCustomModule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecurityHealthAnalyticsCustomModule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecurityHealthAnalyticsCustomModule) ProtoMessage() {}

func (x *SecurityHealthAnalyticsCustomModule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecurityHealthAnalyticsCustomModule.ProtoReflect.Descriptor instead.
func (*SecurityHealthAnalyticsCustomModule) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{4}
}

func (x *SecurityHealthAnalyticsCustomModule) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SecurityHealthAnalyticsCustomModule) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *SecurityHealthAnalyticsCustomModule) GetEnablementState() SecurityHealthAnalyticsCustomModule_EnablementState {
	if x != nil {
		return x.EnablementState
	}
	return SecurityHealthAnalyticsCustomModule_ENABLEMENT_STATE_UNSPECIFIED
}

func (x *SecurityHealthAnalyticsCustomModule) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *SecurityHealthAnalyticsCustomModule) GetLastEditor() string {
	if x != nil {
		return x.LastEditor
	}
	return ""
}

func (x *SecurityHealthAnalyticsCustomModule) GetAncestorModule() string {
	if x != nil {
		return x.AncestorModule
	}
	return ""
}

func (x *SecurityHealthAnalyticsCustomModule) GetCustomConfig() *CustomConfig {
	if x != nil {
		return x.CustomConfig
	}
	return nil
}

// Defines the properties in a custom module configuration for Security
// Health Analytics. Use the custom module configuration to create custom
// detectors that generate custom findings for resources that you specify.
type CustomConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The CEL expression to evaluate to produce findings. When the
	// expression evaluates to true against a resource, a finding is generated.
	Predicate *expr.Expr `protobuf:"bytes,1,opt,name=predicate,proto3" json:"predicate,omitempty"`
	// Optional. Custom output properties.
	CustomOutput *CustomConfig_CustomOutputSpec `protobuf:"bytes,2,opt,name=custom_output,json=customOutput,proto3" json:"custom_output,omitempty"`
	// Optional. The Cloud Asset Inventory resource types that the custom module
	// operates on. For information about resource types, see [Supported asset
	// types](https://cloud.google.com/asset-inventory/docs/supported-asset-types).
	// Each custom module can specify up to 5 resource types.
	ResourceSelector *CustomConfig_ResourceSelector `protobuf:"bytes,3,opt,name=resource_selector,json=resourceSelector,proto3" json:"resource_selector,omitempty"`
	// Optional. The severity to assign to findings generated by the module.
	Severity CustomConfig_Severity `protobuf:"varint,4,opt,name=severity,proto3,enum=google.cloud.securitycentermanagement.v1.CustomConfig_Severity" json:"severity,omitempty"`
	// Optional. Text that describes the vulnerability or misconfiguration that
	// the custom module detects. This explanation is returned with each finding
	// instance to help investigators understand the detected issue. The text must
	// be enclosed in quotation marks.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. An explanation of the recommended steps that security teams can
	// take to resolve the detected issue. This explanation is returned with each
	// finding generated by this module in the `nextSteps` property of the finding
	// JSON.
	Recommendation string `protobuf:"bytes,6,opt,name=recommendation,proto3" json:"recommendation,omitempty"`
}

func (x *CustomConfig) Reset() {
	*x = CustomConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomConfig) ProtoMessage() {}

func (x *CustomConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomConfig.ProtoReflect.Descriptor instead.
func (*CustomConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{5}
}

func (x *CustomConfig) GetPredicate() *expr.Expr {
	if x != nil {
		return x.Predicate
	}
	return nil
}

func (x *CustomConfig) GetCustomOutput() *CustomConfig_CustomOutputSpec {
	if x != nil {
		return x.CustomOutput
	}
	return nil
}

func (x *CustomConfig) GetResourceSelector() *CustomConfig_ResourceSelector {
	if x != nil {
		return x.ResourceSelector
	}
	return nil
}

func (x *CustomConfig) GetSeverity() CustomConfig_Severity {
	if x != nil {
		return x.Severity
	}
	return CustomConfig_SEVERITY_UNSPECIFIED
}

func (x *CustomConfig) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CustomConfig) GetRecommendation() string {
	if x != nil {
		return x.Recommendation
	}
	return ""
}

// Request message for listing Security Health Analytics custom modules.
type ListSecurityHealthAnalyticsCustomModulesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of parent to list custom modules. Its format is
	// "organizations/{organization}/locations/{location}",
	// "folders/{folder}/locations/{location}",
	// or
	// "projects/{project}/locations/{location}"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of results to return in a single response.
	// Default is 10, minimum is 1, maximum is 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSecurityHealthAnalyticsCustomModulesRequest) Reset() {
	*x = ListSecurityHealthAnalyticsCustomModulesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSecurityHealthAnalyticsCustomModulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSecurityHealthAnalyticsCustomModulesRequest) ProtoMessage() {}

func (x *ListSecurityHealthAnalyticsCustomModulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSecurityHealthAnalyticsCustomModulesRequest.ProtoReflect.Descriptor instead.
func (*ListSecurityHealthAnalyticsCustomModulesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{6}
}

func (x *ListSecurityHealthAnalyticsCustomModulesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSecurityHealthAnalyticsCustomModulesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSecurityHealthAnalyticsCustomModulesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for listing Security Health Analytics custom modules.
type ListSecurityHealthAnalyticsCustomModulesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of SecurityHealthAnalyticsCustomModules
	SecurityHealthAnalyticsCustomModules []*SecurityHealthAnalyticsCustomModule `protobuf:"bytes,1,rep,name=security_health_analytics_custom_modules,json=securityHealthAnalyticsCustomModules,proto3" json:"security_health_analytics_custom_modules,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSecurityHealthAnalyticsCustomModulesResponse) Reset() {
	*x = ListSecurityHealthAnalyticsCustomModulesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSecurityHealthAnalyticsCustomModulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSecurityHealthAnalyticsCustomModulesResponse) ProtoMessage() {}

func (x *ListSecurityHealthAnalyticsCustomModulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSecurityHealthAnalyticsCustomModulesResponse.ProtoReflect.Descriptor instead.
func (*ListSecurityHealthAnalyticsCustomModulesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{7}
}

func (x *ListSecurityHealthAnalyticsCustomModulesResponse) GetSecurityHealthAnalyticsCustomModules() []*SecurityHealthAnalyticsCustomModule {
	if x != nil {
		return x.SecurityHealthAnalyticsCustomModules
	}
	return nil
}

func (x *ListSecurityHealthAnalyticsCustomModulesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for listing descendant Security Health Analytics custom
// modules.
type ListDescendantSecurityHealthAnalyticsCustomModulesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of parent to list custom modules. Its format is
	// "organizations/{organization}/locations/{location}",
	// "folders/{folder}/locations/{location}",
	// or
	// "projects/{project}/locations/{location}"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of results to return in a single response.
	// Default is 10, minimum is 1, maximum is 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDescendantSecurityHealthAnalyticsCustomModulesRequest) Reset() {
	*x = ListDescendantSecurityHealthAnalyticsCustomModulesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDescendantSecurityHealthAnalyticsCustomModulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDescendantSecurityHealthAnalyticsCustomModulesRequest) ProtoMessage() {}

func (x *ListDescendantSecurityHealthAnalyticsCustomModulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDescendantSecurityHealthAnalyticsCustomModulesRequest.ProtoReflect.Descriptor instead.
func (*ListDescendantSecurityHealthAnalyticsCustomModulesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{8}
}

func (x *ListDescendantSecurityHealthAnalyticsCustomModulesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDescendantSecurityHealthAnalyticsCustomModulesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDescendantSecurityHealthAnalyticsCustomModulesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for listing descendant Security Health Analytics custom
// modules.
type ListDescendantSecurityHealthAnalyticsCustomModulesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of SecurityHealthAnalyticsCustomModules
	SecurityHealthAnalyticsCustomModules []*SecurityHealthAnalyticsCustomModule `protobuf:"bytes,1,rep,name=security_health_analytics_custom_modules,json=securityHealthAnalyticsCustomModules,proto3" json:"security_health_analytics_custom_modules,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDescendantSecurityHealthAnalyticsCustomModulesResponse) Reset() {
	*x = ListDescendantSecurityHealthAnalyticsCustomModulesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDescendantSecurityHealthAnalyticsCustomModulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDescendantSecurityHealthAnalyticsCustomModulesResponse) ProtoMessage() {}

func (x *ListDescendantSecurityHealthAnalyticsCustomModulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDescendantSecurityHealthAnalyticsCustomModulesResponse.ProtoReflect.Descriptor instead.
func (*ListDescendantSecurityHealthAnalyticsCustomModulesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{9}
}

func (x *ListDescendantSecurityHealthAnalyticsCustomModulesResponse) GetSecurityHealthAnalyticsCustomModules() []*SecurityHealthAnalyticsCustomModule {
	if x != nil {
		return x.SecurityHealthAnalyticsCustomModules
	}
	return nil
}

func (x *ListDescendantSecurityHealthAnalyticsCustomModulesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Message for getting a SecurityHealthAnalyticsCustomModule
type GetSecurityHealthAnalyticsCustomModuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSecurityHealthAnalyticsCustomModuleRequest) Reset() {
	*x = GetSecurityHealthAnalyticsCustomModuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSecurityHealthAnalyticsCustomModuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSecurityHealthAnalyticsCustomModuleRequest) ProtoMessage() {}

func (x *GetSecurityHealthAnalyticsCustomModuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSecurityHealthAnalyticsCustomModuleRequest.ProtoReflect.Descriptor instead.
func (*GetSecurityHealthAnalyticsCustomModuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{10}
}

func (x *GetSecurityHealthAnalyticsCustomModuleRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for creating a SecurityHealthAnalyticsCustomModule
type CreateSecurityHealthAnalyticsCustomModuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the parent for the module. Its format is
	// "organizations/{organization}/locations/{location}",
	// "folders/{folder}/locations/{location}",
	// or
	// "projects/{project}/locations/{location}"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The resource being created
	SecurityHealthAnalyticsCustomModule *SecurityHealthAnalyticsCustomModule `protobuf:"bytes,2,opt,name=security_health_analytics_custom_module,json=securityHealthAnalyticsCustomModule,proto3" json:"security_health_analytics_custom_module,omitempty"`
	// Optional. When set to true, only validations (including IAM checks) will
	// done for the request (no module will be created). An OK response indicates
	// the request is valid while an error response indicates the request is
	// invalid. Note that a subsequent request to actually create the module could
	// still fail because:
	//  1. the state could have changed (e.g. IAM permission lost) or
	//  2. A failure occurred during creation of the module.
	//
	// Defaults to false.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateSecurityHealthAnalyticsCustomModuleRequest) Reset() {
	*x = CreateSecurityHealthAnalyticsCustomModuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSecurityHealthAnalyticsCustomModuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSecurityHealthAnalyticsCustomModuleRequest) ProtoMessage() {}

func (x *CreateSecurityHealthAnalyticsCustomModuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSecurityHealthAnalyticsCustomModuleRequest.ProtoReflect.Descriptor instead.
func (*CreateSecurityHealthAnalyticsCustomModuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{11}
}

func (x *CreateSecurityHealthAnalyticsCustomModuleRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSecurityHealthAnalyticsCustomModuleRequest) GetSecurityHealthAnalyticsCustomModule() *SecurityHealthAnalyticsCustomModule {
	if x != nil {
		return x.SecurityHealthAnalyticsCustomModule
	}
	return nil
}

func (x *CreateSecurityHealthAnalyticsCustomModuleRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Message for updating a SecurityHealthAnalyticsCustomModule
type UpdateSecurityHealthAnalyticsCustomModuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The list of fields to be updated. The only fields that can be
	// updated are `enablement_state` and `custom_config`. If empty or set to the
	// wildcard value `*`, both `enablement_state` and `custom_config` are
	// updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The resource being updated
	SecurityHealthAnalyticsCustomModule *SecurityHealthAnalyticsCustomModule `protobuf:"bytes,2,opt,name=security_health_analytics_custom_module,json=securityHealthAnalyticsCustomModule,proto3" json:"security_health_analytics_custom_module,omitempty"`
	// Optional. When set to true, only validations (including IAM checks) will
	// done for the request (module will not be updated). An OK response indicates
	// the request is valid while an error response indicates the request is
	// invalid. Note that a subsequent request to actually update the module could
	// still fail because 1. the state could have changed (e.g. IAM permission
	// lost) or
	// 2. A failure occurred while trying to update the module.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *UpdateSecurityHealthAnalyticsCustomModuleRequest) Reset() {
	*x = UpdateSecurityHealthAnalyticsCustomModuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSecurityHealthAnalyticsCustomModuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSecurityHealthAnalyticsCustomModuleRequest) ProtoMessage() {}

func (x *UpdateSecurityHealthAnalyticsCustomModuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSecurityHealthAnalyticsCustomModuleRequest.ProtoReflect.Descriptor instead.
func (*UpdateSecurityHealthAnalyticsCustomModuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{12}
}

func (x *UpdateSecurityHealthAnalyticsCustomModuleRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateSecurityHealthAnalyticsCustomModuleRequest) GetSecurityHealthAnalyticsCustomModule() *SecurityHealthAnalyticsCustomModule {
	if x != nil {
		return x.SecurityHealthAnalyticsCustomModule
	}
	return nil
}

func (x *UpdateSecurityHealthAnalyticsCustomModuleRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Message for deleting a SecurityHealthAnalyticsCustomModule
type DeleteSecurityHealthAnalyticsCustomModuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the SHA custom module.
	//
	// Its format is:
	//
	//   - "organizations/{organization}/locations/{location}/securityHealthAnalyticsCustomModules/{security_health_analytics_custom_module}".
	//   - "folders/{folder}/locations/{location}/securityHealthAnalyticsCustomModules/{security_health_analytics_custom_module}".
	//   - "projects/{project}/locations/{location}/securityHealthAnalyticsCustomModules/{security_health_analytics_custom_module}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. When set to true, only validations (including IAM checks) will
	// done for the request (module will not be deleted). An OK response indicates
	// the request is valid while an error response indicates the request is
	// invalid. Note that a subsequent request to actually delete the module could
	// still fail because 1. the state could have changed (e.g. IAM permission
	// lost) or
	// 2. A failure occurred while trying to delete the module.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *DeleteSecurityHealthAnalyticsCustomModuleRequest) Reset() {
	*x = DeleteSecurityHealthAnalyticsCustomModuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSecurityHealthAnalyticsCustomModuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSecurityHealthAnalyticsCustomModuleRequest) ProtoMessage() {}

func (x *DeleteSecurityHealthAnalyticsCustomModuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSecurityHealthAnalyticsCustomModuleRequest.ProtoReflect.Descriptor instead.
func (*DeleteSecurityHealthAnalyticsCustomModuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{13}
}

func (x *DeleteSecurityHealthAnalyticsCustomModuleRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteSecurityHealthAnalyticsCustomModuleRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message to simulate a CustomConfig against a given test resource.
// Maximum size of the request is 4 MB by default.
type SimulateSecurityHealthAnalyticsCustomModuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative resource name of the organization, project, or
	// folder. For more information about relative resource names, see [Relative
	// Resource
	// Name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
	// Example: `organizations/{organization_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The custom configuration that you need to test.
	CustomConfig *CustomConfig `protobuf:"bytes,2,opt,name=custom_config,json=customConfig,proto3" json:"custom_config,omitempty"`
	// Required. Resource data to simulate custom module against.
	Resource *SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource `protobuf:"bytes,3,opt,name=resource,proto3" json:"resource,omitempty"`
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleRequest) Reset() {
	*x = SimulateSecurityHealthAnalyticsCustomModuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SimulateSecurityHealthAnalyticsCustomModuleRequest) ProtoMessage() {}

func (x *SimulateSecurityHealthAnalyticsCustomModuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SimulateSecurityHealthAnalyticsCustomModuleRequest.ProtoReflect.Descriptor instead.
func (*SimulateSecurityHealthAnalyticsCustomModuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{14}
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleRequest) GetCustomConfig() *CustomConfig {
	if x != nil {
		return x.CustomConfig
	}
	return nil
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleRequest) GetResource() *SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource {
	if x != nil {
		return x.Resource
	}
	return nil
}

// A subset of the fields of the Security Center Finding proto. The minimum set
// of fields needed to represent a simulated finding from a SHA custom module.
type SimulatedFinding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The [relative resource
	// name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
	// of the finding. Example:
	// "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
	// "folders/{folder_id}/sources/{source_id}/findings/{finding_id}",
	// "projects/{project_id}/sources/{source_id}/findings/{finding_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The relative resource name of the source the finding belongs to. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name
	// This field is immutable after creation time.
	// For example:
	// "organizations/{organization_id}/sources/{source_id}"
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// For findings on Google Cloud resources, the full resource
	// name of the Google Cloud resource this finding is for. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	// When the finding is for a non-Google Cloud resource, the resourceName can
	// be a customer or partner defined string. This field is immutable after
	// creation time.
	ResourceName string `protobuf:"bytes,3,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The additional taxonomy group within findings from a given source.
	// This field is immutable after creation time.
	// Example: "XSS_FLASH_INJECTION"
	Category string `protobuf:"bytes,4,opt,name=category,proto3" json:"category,omitempty"`
	// Output only. The state of the finding.
	State SimulatedFinding_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.securitycentermanagement.v1.SimulatedFinding_State" json:"state,omitempty"`
	// Source specific properties. These properties are managed by the source
	// that writes the finding. The key names in the source_properties map must be
	// between 1 and 255 characters, and must start with a letter and contain
	// alphanumeric characters or underscores only.
	SourceProperties map[string]*structpb.Value `protobuf:"bytes,6,rep,name=source_properties,json=sourceProperties,proto3" json:"source_properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The time the finding was first detected. If an existing finding is updated,
	// then this is the time the update occurred.
	// For example, if the finding represents an open firewall, this property
	// captures the time the detector believes the firewall became open. The
	// accuracy is determined by the detector. If the finding is later resolved,
	// then this time reflects when the finding was resolved. This must not
	// be set to a value greater than the current timestamp.
	EventTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=event_time,json=eventTime,proto3" json:"event_time,omitempty"`
	// The severity of the finding. This field is managed by the source that
	// writes the finding.
	Severity SimulatedFinding_Severity `protobuf:"varint,8,opt,name=severity,proto3,enum=google.cloud.securitycentermanagement.v1.SimulatedFinding_Severity" json:"severity,omitempty"`
	// The class of the finding.
	FindingClass SimulatedFinding_FindingClass `protobuf:"varint,9,opt,name=finding_class,json=findingClass,proto3,enum=google.cloud.securitycentermanagement.v1.SimulatedFinding_FindingClass" json:"finding_class,omitempty"`
}

func (x *SimulatedFinding) Reset() {
	*x = SimulatedFinding{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SimulatedFinding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SimulatedFinding) ProtoMessage() {}

func (x *SimulatedFinding) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SimulatedFinding.ProtoReflect.Descriptor instead.
func (*SimulatedFinding) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{15}
}

func (x *SimulatedFinding) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SimulatedFinding) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *SimulatedFinding) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *SimulatedFinding) GetCategory() string {
	if x != nil {
		return x.Category
	}
	return ""
}

func (x *SimulatedFinding) GetState() SimulatedFinding_State {
	if x != nil {
		return x.State
	}
	return SimulatedFinding_STATE_UNSPECIFIED
}

func (x *SimulatedFinding) GetSourceProperties() map[string]*structpb.Value {
	if x != nil {
		return x.SourceProperties
	}
	return nil
}

func (x *SimulatedFinding) GetEventTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EventTime
	}
	return nil
}

func (x *SimulatedFinding) GetSeverity() SimulatedFinding_Severity {
	if x != nil {
		return x.Severity
	}
	return SimulatedFinding_SEVERITY_UNSPECIFIED
}

func (x *SimulatedFinding) GetFindingClass() SimulatedFinding_FindingClass {
	if x != nil {
		return x.FindingClass
	}
	return SimulatedFinding_FINDING_CLASS_UNSPECIFIED
}

// Response message for simulating a `SecurityHealthAnalyticsCustomModule`
// against a given resource.
type SimulateSecurityHealthAnalyticsCustomModuleResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Result for test case in the corresponding request.
	Result *SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleResponse) Reset() {
	*x = SimulateSecurityHealthAnalyticsCustomModuleResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SimulateSecurityHealthAnalyticsCustomModuleResponse) ProtoMessage() {}

func (x *SimulateSecurityHealthAnalyticsCustomModuleResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SimulateSecurityHealthAnalyticsCustomModuleResponse.ProtoReflect.Descriptor instead.
func (*SimulateSecurityHealthAnalyticsCustomModuleResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{16}
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleResponse) GetResult() *SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult {
	if x != nil {
		return x.Result
	}
	return nil
}

// An EffectiveEventThreatDetectionCustomModule is the representation of
// EventThreatDetectionCustomModule at a given level taking hierarchy into
// account and resolving various fields accordingly. e.g. if the module is
// enabled at the ancestor level, effective modules at all descendant levels
// will have enablement_state set to ENABLED. Similarly, if module.inherited is
// set, then effective module's config will contain the ancestor's config
// details. EffectiveEventThreatDetectionCustomModule is read-only.
type EffectiveEventThreatDetectionCustomModule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name of the ETD custom module.
	//
	// Its format is:
	//
	//   - "organizations/{organization}/locations/{location}/effectiveEventThreatDetectionCustomModules/{effective_event_threat_detection_custom_module}".
	//   - "folders/{folder}/locations/{location}/effectiveEventThreatDetectionCustomModules/{effective_event_threat_detection_custom_module}".
	//   - "projects/{project}/locations/{location}/effectiveEventThreatDetectionCustomModules/{effective_event_threat_detection_custom_module}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Config for the effective module.
	Config *structpb.Struct `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// Output only. The effective state of enablement for the module at the given
	// level of the hierarchy.
	EnablementState EffectiveEventThreatDetectionCustomModule_EnablementState `protobuf:"varint,3,opt,name=enablement_state,json=enablementState,proto3,enum=google.cloud.securitycentermanagement.v1.EffectiveEventThreatDetectionCustomModule_EnablementState" json:"enablement_state,omitempty"`
	// Output only. Type for the module. e.g. CONFIGURABLE_BAD_IP.
	Type string `protobuf:"bytes,4,opt,name=type,proto3" json:"type,omitempty"`
	// Output only. The human readable name to be displayed for the module.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The description for the module.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *EffectiveEventThreatDetectionCustomModule) Reset() {
	*x = EffectiveEventThreatDetectionCustomModule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EffectiveEventThreatDetectionCustomModule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EffectiveEventThreatDetectionCustomModule) ProtoMessage() {}

func (x *EffectiveEventThreatDetectionCustomModule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EffectiveEventThreatDetectionCustomModule.ProtoReflect.Descriptor instead.
func (*EffectiveEventThreatDetectionCustomModule) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{17}
}

func (x *EffectiveEventThreatDetectionCustomModule) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EffectiveEventThreatDetectionCustomModule) GetConfig() *structpb.Struct {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *EffectiveEventThreatDetectionCustomModule) GetEnablementState() EffectiveEventThreatDetectionCustomModule_EnablementState {
	if x != nil {
		return x.EnablementState
	}
	return EffectiveEventThreatDetectionCustomModule_ENABLEMENT_STATE_UNSPECIFIED
}

func (x *EffectiveEventThreatDetectionCustomModule) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *EffectiveEventThreatDetectionCustomModule) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *EffectiveEventThreatDetectionCustomModule) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// Request message for listing effective Event Threat Detection custom
// modules.
type ListEffectiveEventThreatDetectionCustomModulesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of parent to list effective custom modules. Its format is
	// "organizations/{organization}/locations/{location}",
	// "folders/{folder}/locations/{location}",
	// or
	// "projects/{project}/locations/{location}"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of results to return in a single response.
	// Default is 10, minimum is 1, maximum is 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The value returned by the last call indicating a continuation
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListEffectiveEventThreatDetectionCustomModulesRequest) Reset() {
	*x = ListEffectiveEventThreatDetectionCustomModulesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEffectiveEventThreatDetectionCustomModulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEffectiveEventThreatDetectionCustomModulesRequest) ProtoMessage() {}

func (x *ListEffectiveEventThreatDetectionCustomModulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEffectiveEventThreatDetectionCustomModulesRequest.ProtoReflect.Descriptor instead.
func (*ListEffectiveEventThreatDetectionCustomModulesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{18}
}

func (x *ListEffectiveEventThreatDetectionCustomModulesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEffectiveEventThreatDetectionCustomModulesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEffectiveEventThreatDetectionCustomModulesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for listing effective Event Threat Detection custom
// modules.
type ListEffectiveEventThreatDetectionCustomModulesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of EffectiveEventThreatDetectionCustomModules
	EffectiveEventThreatDetectionCustomModules []*EffectiveEventThreatDetectionCustomModule `protobuf:"bytes,1,rep,name=effective_event_threat_detection_custom_modules,json=effectiveEventThreatDetectionCustomModules,proto3" json:"effective_event_threat_detection_custom_modules,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListEffectiveEventThreatDetectionCustomModulesResponse) Reset() {
	*x = ListEffectiveEventThreatDetectionCustomModulesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEffectiveEventThreatDetectionCustomModulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEffectiveEventThreatDetectionCustomModulesResponse) ProtoMessage() {}

func (x *ListEffectiveEventThreatDetectionCustomModulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEffectiveEventThreatDetectionCustomModulesResponse.ProtoReflect.Descriptor instead.
func (*ListEffectiveEventThreatDetectionCustomModulesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{19}
}

func (x *ListEffectiveEventThreatDetectionCustomModulesResponse) GetEffectiveEventThreatDetectionCustomModules() []*EffectiveEventThreatDetectionCustomModule {
	if x != nil {
		return x.EffectiveEventThreatDetectionCustomModules
	}
	return nil
}

func (x *ListEffectiveEventThreatDetectionCustomModulesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Message for getting a EffectiveEventThreatDetectionCustomModule
type GetEffectiveEventThreatDetectionCustomModuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the ETD custom module.
	//
	// Its format is:
	//
	//   - "organizations/{organization}/locations/{location}/effectiveEventThreatDetectionCustomModules/{effective_event_threat_detection_custom_module}".
	//   - "folders/{folder}/locations/{location}/effectiveEventThreatDetectionCustomModules/{effective_event_threat_detection_custom_module}".
	//   - "projects/{project}/locations/{location}/effectiveEventThreatDetectionCustomModules/{effective_event_threat_detection_custom_module}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEffectiveEventThreatDetectionCustomModuleRequest) Reset() {
	*x = GetEffectiveEventThreatDetectionCustomModuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEffectiveEventThreatDetectionCustomModuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEffectiveEventThreatDetectionCustomModuleRequest) ProtoMessage() {}

func (x *GetEffectiveEventThreatDetectionCustomModuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEffectiveEventThreatDetectionCustomModuleRequest.ProtoReflect.Descriptor instead.
func (*GetEffectiveEventThreatDetectionCustomModuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{20}
}

func (x *GetEffectiveEventThreatDetectionCustomModuleRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// An event threat detection custom module is a Cloud SCC resource that contains
// the configuration and enablement state of a custom module, which enables ETD
// to write certain findings to Cloud SCC.
type EventThreatDetectionCustomModule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name of the ETD custom module.
	//
	// Its format is:
	//
	//   - "organizations/{organization}/locations/{location}/eventThreatDetectionCustomModules/{event_threat_detection_custom_module}".
	//   - "folders/{folder}/locations/{location}/eventThreatDetectionCustomModules/{event_threat_detection_custom_module}".
	//   - "projects/{project}/locations/{location}/eventThreatDetectionCustomModules/{event_threat_detection_custom_module}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Config for the module. For the resident module, its config value
	// is defined at this level. For the inherited module, its config value is
	// inherited from the ancestor module.
	Config *structpb.Struct `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// Output only. The closest ancestor module that this module inherits the
	// enablement state from. If empty, indicates that the custom module was
	// created in the requesting parent organization, folder, or project. The
	// format is the same as the EventThreatDetectionCustomModule resource name.
	AncestorModule string `protobuf:"bytes,3,opt,name=ancestor_module,json=ancestorModule,proto3" json:"ancestor_module,omitempty"`
	// Optional. The state of enablement for the module at the given level of the
	// hierarchy.
	EnablementState EventThreatDetectionCustomModule_EnablementState `protobuf:"varint,4,opt,name=enablement_state,json=enablementState,proto3,enum=google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule_EnablementState" json:"enablement_state,omitempty"`
	// Optional. Type for the module. e.g. CONFIGURABLE_BAD_IP.
	Type string `protobuf:"bytes,5,opt,name=type,proto3" json:"type,omitempty"`
	// Optional. The human readable name to be displayed for the module.
	DisplayName string `protobuf:"bytes,6,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. The description for the module.
	Description string `protobuf:"bytes,7,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The time the module was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The editor the module was last updated by.
	LastEditor string `protobuf:"bytes,9,opt,name=last_editor,json=lastEditor,proto3" json:"last_editor,omitempty"`
}

func (x *EventThreatDetectionCustomModule) Reset() {
	*x = EventThreatDetectionCustomModule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventThreatDetectionCustomModule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventThreatDetectionCustomModule) ProtoMessage() {}

func (x *EventThreatDetectionCustomModule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventThreatDetectionCustomModule.ProtoReflect.Descriptor instead.
func (*EventThreatDetectionCustomModule) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{21}
}

func (x *EventThreatDetectionCustomModule) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EventThreatDetectionCustomModule) GetConfig() *structpb.Struct {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *EventThreatDetectionCustomModule) GetAncestorModule() string {
	if x != nil {
		return x.AncestorModule
	}
	return ""
}

func (x *EventThreatDetectionCustomModule) GetEnablementState() EventThreatDetectionCustomModule_EnablementState {
	if x != nil {
		return x.EnablementState
	}
	return EventThreatDetectionCustomModule_ENABLEMENT_STATE_UNSPECIFIED
}

func (x *EventThreatDetectionCustomModule) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *EventThreatDetectionCustomModule) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *EventThreatDetectionCustomModule) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *EventThreatDetectionCustomModule) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *EventThreatDetectionCustomModule) GetLastEditor() string {
	if x != nil {
		return x.LastEditor
	}
	return ""
}

// Request message for listing Event Threat Detection custom modules.
type ListEventThreatDetectionCustomModulesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of parent to list custom modules. Its format is
	// "organizations/{organization}/locations/{location}",
	// "folders/{folder}/locations/{location}",
	// or
	// "projects/{project}/locations/{location}"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of modules to return. The service may return
	// fewer than this value. If unspecified, at most 10 configs will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous
	// `ListEventThreatDetectionCustomModules` call. Provide this to retrieve the
	// subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListEventThreatDetectionCustomModules` must match the call that provided
	// the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListEventThreatDetectionCustomModulesRequest) Reset() {
	*x = ListEventThreatDetectionCustomModulesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEventThreatDetectionCustomModulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEventThreatDetectionCustomModulesRequest) ProtoMessage() {}

func (x *ListEventThreatDetectionCustomModulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEventThreatDetectionCustomModulesRequest.ProtoReflect.Descriptor instead.
func (*ListEventThreatDetectionCustomModulesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{22}
}

func (x *ListEventThreatDetectionCustomModulesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEventThreatDetectionCustomModulesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEventThreatDetectionCustomModulesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for listing Event Threat Detection custom modules.
type ListEventThreatDetectionCustomModulesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of EventThreatDetectionCustomModules
	EventThreatDetectionCustomModules []*EventThreatDetectionCustomModule `protobuf:"bytes,1,rep,name=event_threat_detection_custom_modules,json=eventThreatDetectionCustomModules,proto3" json:"event_threat_detection_custom_modules,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListEventThreatDetectionCustomModulesResponse) Reset() {
	*x = ListEventThreatDetectionCustomModulesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEventThreatDetectionCustomModulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEventThreatDetectionCustomModulesResponse) ProtoMessage() {}

func (x *ListEventThreatDetectionCustomModulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEventThreatDetectionCustomModulesResponse.ProtoReflect.Descriptor instead.
func (*ListEventThreatDetectionCustomModulesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{23}
}

func (x *ListEventThreatDetectionCustomModulesResponse) GetEventThreatDetectionCustomModules() []*EventThreatDetectionCustomModule {
	if x != nil {
		return x.EventThreatDetectionCustomModules
	}
	return nil
}

func (x *ListEventThreatDetectionCustomModulesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for listing descendant Event Threat Detection custom
// modules.
type ListDescendantEventThreatDetectionCustomModulesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of parent to list custom modules. Its format is
	// "organizations/{organization}/locations/{location}",
	// "folders/{folder}/locations/{location}",
	// or
	// "projects/{project}/locations/{location}"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of modules to return. The service may return
	// fewer than this value. If unspecified, at most 10 configs will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDescendantEventThreatDetectionCustomModulesRequest) Reset() {
	*x = ListDescendantEventThreatDetectionCustomModulesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDescendantEventThreatDetectionCustomModulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDescendantEventThreatDetectionCustomModulesRequest) ProtoMessage() {}

func (x *ListDescendantEventThreatDetectionCustomModulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDescendantEventThreatDetectionCustomModulesRequest.ProtoReflect.Descriptor instead.
func (*ListDescendantEventThreatDetectionCustomModulesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{24}
}

func (x *ListDescendantEventThreatDetectionCustomModulesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDescendantEventThreatDetectionCustomModulesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDescendantEventThreatDetectionCustomModulesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for listing descendant Event Threat Detection custom
// modules.
type ListDescendantEventThreatDetectionCustomModulesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of EventThreatDetectionCustomModules
	EventThreatDetectionCustomModules []*EventThreatDetectionCustomModule `protobuf:"bytes,1,rep,name=event_threat_detection_custom_modules,json=eventThreatDetectionCustomModules,proto3" json:"event_threat_detection_custom_modules,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDescendantEventThreatDetectionCustomModulesResponse) Reset() {
	*x = ListDescendantEventThreatDetectionCustomModulesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDescendantEventThreatDetectionCustomModulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDescendantEventThreatDetectionCustomModulesResponse) ProtoMessage() {}

func (x *ListDescendantEventThreatDetectionCustomModulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDescendantEventThreatDetectionCustomModulesResponse.ProtoReflect.Descriptor instead.
func (*ListDescendantEventThreatDetectionCustomModulesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{25}
}

func (x *ListDescendantEventThreatDetectionCustomModulesResponse) GetEventThreatDetectionCustomModules() []*EventThreatDetectionCustomModule {
	if x != nil {
		return x.EventThreatDetectionCustomModules
	}
	return nil
}

func (x *ListDescendantEventThreatDetectionCustomModulesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Message for getting a EventThreatDetectionCustomModule
type GetEventThreatDetectionCustomModuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the ETD custom module.
	//
	// Its format is:
	//
	//   - "organizations/{organization}/locations/{location}/eventThreatDetectionCustomModules/{event_threat_detection_custom_module}".
	//   - "folders/{folder}/locations/{location}/eventThreatDetectionCustomModules/{event_threat_detection_custom_module}".
	//   - "projects/{project}/locations/{location}/eventThreatDetectionCustomModules/{event_threat_detection_custom_module}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEventThreatDetectionCustomModuleRequest) Reset() {
	*x = GetEventThreatDetectionCustomModuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEventThreatDetectionCustomModuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEventThreatDetectionCustomModuleRequest) ProtoMessage() {}

func (x *GetEventThreatDetectionCustomModuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEventThreatDetectionCustomModuleRequest.ProtoReflect.Descriptor instead.
func (*GetEventThreatDetectionCustomModuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{26}
}

func (x *GetEventThreatDetectionCustomModuleRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for creating a EventThreatDetectionCustomModule
type CreateEventThreatDetectionCustomModuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of parent for the module. Its format is
	// "organizations/{organization}/locations/{location}",
	// "folders/{folder}/locations/{location}",
	// or
	// "projects/{project}/locations/{location}"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The module to create. The
	// event_threat_detection_custom_module.name will be ignored and server
	// generated.
	EventThreatDetectionCustomModule *EventThreatDetectionCustomModule `protobuf:"bytes,3,opt,name=event_threat_detection_custom_module,json=eventThreatDetectionCustomModule,proto3" json:"event_threat_detection_custom_module,omitempty"`
	// Optional. When set to true, only validations (including IAM checks) will
	// done for the request (no module will be created). An OK response indicates
	// the request is valid while an error response indicates the request is
	// invalid. Note that a subsequent request to actually create the module could
	// still fail because 1. the state could have changed (e.g. IAM permission
	// lost) or
	// 2. A failure occurred during creation of the module.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateEventThreatDetectionCustomModuleRequest) Reset() {
	*x = CreateEventThreatDetectionCustomModuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateEventThreatDetectionCustomModuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEventThreatDetectionCustomModuleRequest) ProtoMessage() {}

func (x *CreateEventThreatDetectionCustomModuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEventThreatDetectionCustomModuleRequest.ProtoReflect.Descriptor instead.
func (*CreateEventThreatDetectionCustomModuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{27}
}

func (x *CreateEventThreatDetectionCustomModuleRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateEventThreatDetectionCustomModuleRequest) GetEventThreatDetectionCustomModule() *EventThreatDetectionCustomModule {
	if x != nil {
		return x.EventThreatDetectionCustomModule
	}
	return nil
}

func (x *CreateEventThreatDetectionCustomModuleRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Message for updating a EventThreatDetectionCustomModule
type UpdateEventThreatDetectionCustomModuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// EventThreatDetectionCustomModule resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The module being updated
	EventThreatDetectionCustomModule *EventThreatDetectionCustomModule `protobuf:"bytes,2,opt,name=event_threat_detection_custom_module,json=eventThreatDetectionCustomModule,proto3" json:"event_threat_detection_custom_module,omitempty"`
	// Optional. When set to true, only validations (including IAM checks) will
	// done for the request (module will not be updated). An OK response indicates
	// the request is valid while an error response indicates the request is
	// invalid. Note that a subsequent request to actually update the module could
	// still fail because 1. the state could have changed (e.g. IAM permission
	// lost) or
	// 2. A failure occurred while trying to update the module.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *UpdateEventThreatDetectionCustomModuleRequest) Reset() {
	*x = UpdateEventThreatDetectionCustomModuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateEventThreatDetectionCustomModuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateEventThreatDetectionCustomModuleRequest) ProtoMessage() {}

func (x *UpdateEventThreatDetectionCustomModuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateEventThreatDetectionCustomModuleRequest.ProtoReflect.Descriptor instead.
func (*UpdateEventThreatDetectionCustomModuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{28}
}

func (x *UpdateEventThreatDetectionCustomModuleRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateEventThreatDetectionCustomModuleRequest) GetEventThreatDetectionCustomModule() *EventThreatDetectionCustomModule {
	if x != nil {
		return x.EventThreatDetectionCustomModule
	}
	return nil
}

func (x *UpdateEventThreatDetectionCustomModuleRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Message for deleting a EventThreatDetectionCustomModule
type DeleteEventThreatDetectionCustomModuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the ETD custom module.
	//
	// Its format is:
	//
	//   - "organizations/{organization}/locations/{location}/eventThreatDetectionCustomModules/{event_threat_detection_custom_module}".
	//   - "folders/{folder}/locations/{location}/eventThreatDetectionCustomModules/{event_threat_detection_custom_module}".
	//   - "projects/{project}/locations/{location}/eventThreatDetectionCustomModules/{event_threat_detection_custom_module}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. When set to true, only validations (including IAM checks) will
	// done for the request (module will not be deleted). An OK response indicates
	// the request is valid while an error response indicates the request is
	// invalid. Note that a subsequent request to actually delete the module could
	// still fail because 1. the state could have changed (e.g. IAM permission
	// lost) or
	// 2. A failure occurred while trying to delete the module.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *DeleteEventThreatDetectionCustomModuleRequest) Reset() {
	*x = DeleteEventThreatDetectionCustomModuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteEventThreatDetectionCustomModuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteEventThreatDetectionCustomModuleRequest) ProtoMessage() {}

func (x *DeleteEventThreatDetectionCustomModuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteEventThreatDetectionCustomModuleRequest.ProtoReflect.Descriptor instead.
func (*DeleteEventThreatDetectionCustomModuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{29}
}

func (x *DeleteEventThreatDetectionCustomModuleRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteEventThreatDetectionCustomModuleRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request to validate an Event Threat Detection custom module.
type ValidateEventThreatDetectionCustomModuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the parent to validate the Custom Module under.
	//
	// Its format is:
	//
	//   - "organizations/{organization}/locations/{location}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The raw text of the module's contents. Used to generate error
	// messages.
	RawText string `protobuf:"bytes,2,opt,name=raw_text,json=rawText,proto3" json:"raw_text,omitempty"`
	// Required. The type of the module (e.g. CONFIGURABLE_BAD_IP).
	Type string `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *ValidateEventThreatDetectionCustomModuleRequest) Reset() {
	*x = ValidateEventThreatDetectionCustomModuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidateEventThreatDetectionCustomModuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateEventThreatDetectionCustomModuleRequest) ProtoMessage() {}

func (x *ValidateEventThreatDetectionCustomModuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateEventThreatDetectionCustomModuleRequest.ProtoReflect.Descriptor instead.
func (*ValidateEventThreatDetectionCustomModuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{30}
}

func (x *ValidateEventThreatDetectionCustomModuleRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ValidateEventThreatDetectionCustomModuleRequest) GetRawText() string {
	if x != nil {
		return x.RawText
	}
	return ""
}

func (x *ValidateEventThreatDetectionCustomModuleRequest) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

// Response to validating an Event Threat Detection custom module.
type ValidateEventThreatDetectionCustomModuleResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of errors returned by the validator. If the list is empty, there
	// were no errors.
	Errors []*ValidateEventThreatDetectionCustomModuleResponse_CustomModuleValidationError `protobuf:"bytes,2,rep,name=errors,proto3" json:"errors,omitempty"`
}

func (x *ValidateEventThreatDetectionCustomModuleResponse) Reset() {
	*x = ValidateEventThreatDetectionCustomModuleResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidateEventThreatDetectionCustomModuleResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateEventThreatDetectionCustomModuleResponse) ProtoMessage() {}

func (x *ValidateEventThreatDetectionCustomModuleResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateEventThreatDetectionCustomModuleResponse.ProtoReflect.Descriptor instead.
func (*ValidateEventThreatDetectionCustomModuleResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{31}
}

func (x *ValidateEventThreatDetectionCustomModuleResponse) GetErrors() []*ValidateEventThreatDetectionCustomModuleResponse_CustomModuleValidationError {
	if x != nil {
		return x.Errors
	}
	return nil
}

// A set of optional name-value pairs that define custom source properties to
// return with each finding that is generated by the custom module. The custom
// source properties that are defined here are included in the finding JSON
// under `sourceProperties`.
type CustomConfig_CustomOutputSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A list of custom output properties to add to the finding.
	Properties []*CustomConfig_CustomOutputSpec_Property `protobuf:"bytes,1,rep,name=properties,proto3" json:"properties,omitempty"`
}

func (x *CustomConfig_CustomOutputSpec) Reset() {
	*x = CustomConfig_CustomOutputSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomConfig_CustomOutputSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomConfig_CustomOutputSpec) ProtoMessage() {}

func (x *CustomConfig_CustomOutputSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomConfig_CustomOutputSpec.ProtoReflect.Descriptor instead.
func (*CustomConfig_CustomOutputSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{5, 0}
}

func (x *CustomConfig_CustomOutputSpec) GetProperties() []*CustomConfig_CustomOutputSpec_Property {
	if x != nil {
		return x.Properties
	}
	return nil
}

// Resource for selecting resource type.
type CustomConfig_ResourceSelector struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The resource types to run the detector on.
	ResourceTypes []string `protobuf:"bytes,1,rep,name=resource_types,json=resourceTypes,proto3" json:"resource_types,omitempty"`
}

func (x *CustomConfig_ResourceSelector) Reset() {
	*x = CustomConfig_ResourceSelector{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomConfig_ResourceSelector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomConfig_ResourceSelector) ProtoMessage() {}

func (x *CustomConfig_ResourceSelector) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomConfig_ResourceSelector.ProtoReflect.Descriptor instead.
func (*CustomConfig_ResourceSelector) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{5, 1}
}

func (x *CustomConfig_ResourceSelector) GetResourceTypes() []string {
	if x != nil {
		return x.ResourceTypes
	}
	return nil
}

// An individual name-value pair that defines a custom source property.
type CustomConfig_CustomOutputSpec_Property struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Name of the property for the custom output.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The CEL expression for the custom output. A resource property
	// can be specified to return the value of the property or a text string
	// enclosed in quotation marks.
	ValueExpression *expr.Expr `protobuf:"bytes,2,opt,name=value_expression,json=valueExpression,proto3" json:"value_expression,omitempty"`
}

func (x *CustomConfig_CustomOutputSpec_Property) Reset() {
	*x = CustomConfig_CustomOutputSpec_Property{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomConfig_CustomOutputSpec_Property) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomConfig_CustomOutputSpec_Property) ProtoMessage() {}

func (x *CustomConfig_CustomOutputSpec_Property) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomConfig_CustomOutputSpec_Property.ProtoReflect.Descriptor instead.
func (*CustomConfig_CustomOutputSpec_Property) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{5, 0, 0}
}

func (x *CustomConfig_CustomOutputSpec_Property) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CustomConfig_CustomOutputSpec_Property) GetValueExpression() *expr.Expr {
	if x != nil {
		return x.ValueExpression
	}
	return nil
}

// Manually constructed resource name. If the custom module evaluates against
// only the resource data, you can omit the `iam_policy_data` field. If it
// evaluates only the `iam_policy_data` field, you can omit the resource data.
type SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The type of the resource, for example,
	// `compute.googleapis.com/Disk`.
	ResourceType string `protobuf:"bytes,1,opt,name=resource_type,json=resourceType,proto3" json:"resource_type,omitempty"`
	// Optional. A representation of the Google Cloud resource. Should match the
	// Google Cloud resource JSON format.
	ResourceData *structpb.Struct `protobuf:"bytes,2,opt,name=resource_data,json=resourceData,proto3" json:"resource_data,omitempty"`
	// Optional. A representation of the IAM policy.
	IamPolicyData *iampb.Policy `protobuf:"bytes,3,opt,name=iam_policy_data,json=iamPolicyData,proto3" json:"iam_policy_data,omitempty"`
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource) Reset() {
	*x = SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource) ProtoMessage() {}

func (x *SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource.ProtoReflect.Descriptor instead.
func (*SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{14, 0}
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource) GetResourceType() string {
	if x != nil {
		return x.ResourceType
	}
	return ""
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource) GetResourceData() *structpb.Struct {
	if x != nil {
		return x.ResourceData
	}
	return nil
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource) GetIamPolicyData() *iampb.Policy {
	if x != nil {
		return x.IamPolicyData
	}
	return nil
}

// Possible test result.
type SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Result:
	//
	//	*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Finding
	//	*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_NoViolation
	//	*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Error
	Result isSimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Result `protobuf_oneof:"result"`
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult) Reset() {
	*x = SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult) ProtoMessage() {}

func (x *SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult.ProtoReflect.Descriptor instead.
func (*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{16, 0}
}

func (m *SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult) GetResult() isSimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult) GetFinding() *SimulatedFinding {
	if x, ok := x.GetResult().(*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Finding); ok {
		return x.Finding
	}
	return nil
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult) GetNoViolation() *emptypb.Empty {
	if x, ok := x.GetResult().(*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_NoViolation); ok {
		return x.NoViolation
	}
	return nil
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult) GetError() *status.Status {
	if x, ok := x.GetResult().(*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Error); ok {
		return x.Error
	}
	return nil
}

type isSimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Result interface {
	isSimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Result()
}

type SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Finding struct {
	// Finding that would be published for the test case,
	// if a violation is detected.
	Finding *SimulatedFinding `protobuf:"bytes,1,opt,name=finding,proto3,oneof"`
}

type SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_NoViolation struct {
	// Indicates that the test case does not trigger any violation.
	NoViolation *emptypb.Empty `protobuf:"bytes,2,opt,name=no_violation,json=noViolation,proto3,oneof"`
}

type SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Error struct {
	// Error encountered during the test.
	Error *status.Status `protobuf:"bytes,3,opt,name=error,proto3,oneof"`
}

func (*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Finding) isSimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Result() {
}

func (*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_NoViolation) isSimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Result() {
}

func (*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Error) isSimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Result() {
}

// An error encountered while validating the uploaded configuration of an
// Event Threat Detection Custom Module.
type ValidateEventThreatDetectionCustomModuleResponse_CustomModuleValidationError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A description of the error, suitable for human consumption. Required.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// The path, in RFC 8901 JSON Pointer format, to the field that failed
	// validation. This may be left empty if no specific field is affected.
	FieldPath string `protobuf:"bytes,2,opt,name=field_path,json=fieldPath,proto3" json:"field_path,omitempty"`
	// The initial position of the error in the uploaded text version of the
	// module. This field may be omitted if no specific position applies, or if
	// one could not be computed.
	Start *ValidateEventThreatDetectionCustomModuleResponse_Position `protobuf:"bytes,3,opt,name=start,proto3,oneof" json:"start,omitempty"`
	// The end position of the error in the uploaded text version of the
	// module. This field may be omitted if no specific position applies, or if
	// one could not be computed..
	End *ValidateEventThreatDetectionCustomModuleResponse_Position `protobuf:"bytes,4,opt,name=end,proto3,oneof" json:"end,omitempty"`
}

func (x *ValidateEventThreatDetectionCustomModuleResponse_CustomModuleValidationError) Reset() {
	*x = ValidateEventThreatDetectionCustomModuleResponse_CustomModuleValidationError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidateEventThreatDetectionCustomModuleResponse_CustomModuleValidationError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateEventThreatDetectionCustomModuleResponse_CustomModuleValidationError) ProtoMessage() {}

func (x *ValidateEventThreatDetectionCustomModuleResponse_CustomModuleValidationError) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateEventThreatDetectionCustomModuleResponse_CustomModuleValidationError.ProtoReflect.Descriptor instead.
func (*ValidateEventThreatDetectionCustomModuleResponse_CustomModuleValidationError) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{31, 0}
}

func (x *ValidateEventThreatDetectionCustomModuleResponse_CustomModuleValidationError) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ValidateEventThreatDetectionCustomModuleResponse_CustomModuleValidationError) GetFieldPath() string {
	if x != nil {
		return x.FieldPath
	}
	return ""
}

func (x *ValidateEventThreatDetectionCustomModuleResponse_CustomModuleValidationError) GetStart() *ValidateEventThreatDetectionCustomModuleResponse_Position {
	if x != nil {
		return x.Start
	}
	return nil
}

func (x *ValidateEventThreatDetectionCustomModuleResponse_CustomModuleValidationError) GetEnd() *ValidateEventThreatDetectionCustomModuleResponse_Position {
	if x != nil {
		return x.End
	}
	return nil
}

// A position in the uploaded text version of a module.
type ValidateEventThreatDetectionCustomModuleResponse_Position struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The line position in the text
	LineNumber int32 `protobuf:"varint,1,opt,name=line_number,json=lineNumber,proto3" json:"line_number,omitempty"`
	// The column position in the line
	ColumnNumber int32 `protobuf:"varint,2,opt,name=column_number,json=columnNumber,proto3" json:"column_number,omitempty"`
}

func (x *ValidateEventThreatDetectionCustomModuleResponse_Position) Reset() {
	*x = ValidateEventThreatDetectionCustomModuleResponse_Position{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidateEventThreatDetectionCustomModuleResponse_Position) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateEventThreatDetectionCustomModuleResponse_Position) ProtoMessage() {}

func (x *ValidateEventThreatDetectionCustomModuleResponse_Position) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateEventThreatDetectionCustomModuleResponse_Position.ProtoReflect.Descriptor instead.
func (*ValidateEventThreatDetectionCustomModuleResponse_Position) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP(), []int{31, 1}
}

func (x *ValidateEventThreatDetectionCustomModuleResponse_Position) GetLineNumber() int32 {
	if x != nil {
		return x.LineNumber
	}
	return 0
}

func (x *ValidateEventThreatDetectionCustomModuleResponse_Position) GetColumnNumber() int32 {
	if x != nil {
		return x.ColumnNumber
	}
	return 0
}

var File_google_cloud_securitycentermanagement_v1_security_center_management_proto protoreflect.FileDescriptor

var file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDesc = []byte{
	0x0a, 0x49, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x5f, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x28, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x65, 0x78, 0x70, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xa0, 0x08, 0x0a, 0x2c, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x60, 0x0a,
	0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x96, 0x01, 0x0a, 0x10, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x66, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x2e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x22, 0x4e, 0x0a, 0x0f, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x4d, 0x45, 0x4e,
	0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44,
	0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02,
	0x3a, 0xe3, 0x04, 0xea, 0x41, 0xdf, 0x04, 0x0a, 0x54, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x93, 0x01,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f,
	0x7b, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x7d, 0x12, 0x89, 0x01, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x66,
	0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x66, 0x66,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f,
	0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x7d, 0x12,
	0x87, 0x01, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x5f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68,
	0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x7d, 0x2a, 0x2d, 0x65, 0x66, 0x66, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x32, 0x2c, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22, 0xf6, 0x01, 0x0a, 0x38, 0x4c, 0x69, 0x73, 0x74, 0x45,
	0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x74, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x5c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x56, 0x12, 0x54, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0xa7, 0x02, 0x0a, 0x39, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0xc1, 0x01,
	0x0a, 0x32, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x52, 0x2d, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xaa, 0x01, 0x0a, 0x36, 0x47, 0x65,
	0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x70, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x5c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x56, 0x0a, 0x54, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xad, 0x09, 0x0a, 0x23, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x8d, 0x01, 0x0a, 0x10, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x5d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65,
	0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x24, 0x0a, 0x0b, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x65, 0x64, 0x69, 0x74, 0x6f, 0x72,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x6c, 0x61, 0x73,
	0x74, 0x45, 0x64, 0x69, 0x74, 0x6f, 0x72, 0x12, 0x7c, 0x0a, 0x0f, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x53, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x4d, 0x0a, 0x4b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x0e, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x4d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x60, 0x0a, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x5d, 0x0a, 0x0f, 0x45, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x45, 0x4e,
	0x41, 0x42, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07,
	0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53,
	0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x49, 0x4e, 0x48, 0x45, 0x52,
	0x49, 0x54, 0x45, 0x44, 0x10, 0x03, 0x3a, 0x8d, 0x04, 0xea, 0x41, 0x89, 0x04, 0x0a, 0x4b, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x80, 0x01, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65,
	0x61, 0x6c, 0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x7d, 0x12, 0x76, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x7d, 0x12, 0x74, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b,
	0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x73, 0x2f, 0x7b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x7d, 0x2a, 0x24, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x73, 0x32, 0x23, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22, 0xef, 0x06, 0x0a, 0x0c, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x34, 0x0a, 0x09, 0x70, 0x72, 0x65, 0x64, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x71, 0x0a,
	0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x12, 0x79, 0x0a, 0x11, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x6c, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x60, 0x0a, 0x08, 0x73,
	0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x25, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x0a, 0x0e, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0e, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x1a, 0xf1, 0x01, 0x0a, 0x10, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x75, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53,
	0x70, 0x65, 0x63, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x1a, 0x66, 0x0a,
	0x08, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x41, 0x0a, 0x10, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x65, 0x78, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x45, 0x78, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x3e, 0x0a, 0x10, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x2a, 0x0a, 0x0e, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x22, 0x51, 0x0a, 0x08, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74,
	0x79, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43,
	0x52, 0x49, 0x54, 0x49, 0x43, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x49, 0x47,
	0x48, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x45, 0x44, 0x49, 0x55, 0x4d, 0x10, 0x03, 0x12,
	0x07, 0x0a, 0x03, 0x4c, 0x4f, 0x57, 0x10, 0x04, 0x22, 0xe4, 0x01, 0x0a, 0x2f, 0x4c, 0x69, 0x73,
	0x74, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6b, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x53, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x4d, 0x12, 0x4b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x82, 0x02, 0x0a, 0x30, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0xa5, 0x01, 0x0a, 0x28, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x24, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xee, 0x01, 0x0a, 0x39, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x73,
	0x63, 0x65, 0x6e, 0x64, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x6b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x53, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x4d, 0x12, 0x4b, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8c, 0x02, 0x0a, 0x3a, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65,
	0x73, 0x63, 0x65, 0x6e, 0x64, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0xa5, 0x01, 0x0a, 0x28, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x24, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x98, 0x01, 0x0a, 0x2d, 0x47, 0x65, 0x74, 0x53, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x67, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x53, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x4d, 0x0a, 0x4b, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65,
	0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xf4, 0x02, 0x0a, 0x30, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x6b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x53, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x4d, 0x12, 0x4b, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65,
	0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0xa8, 0x01, 0x0a, 0x27, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x23, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x28, 0x0a, 0x0d,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xc9, 0x02, 0x0a, 0x30, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0xa8, 0x01,
	0x0a, 0x27, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x23, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e,
	0x6c, 0x79, 0x22, 0xc5, 0x01, 0x0a, 0x30, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x67, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x53, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x4d, 0x0a, 0x4b, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x8c, 0x04, 0x0a, 0x32, 0x53,
	0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x60,
	0x0a, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x8f, 0x01, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x1a, 0xc4, 0x01, 0x0a, 0x11, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x41, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x44, 0x61, 0x74, 0x61, 0x12, 0x42, 0x0a, 0x0f, 0x69, 0x61, 0x6d, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x69, 0x61, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x44, 0x61, 0x74, 0x61, 0x22, 0xe1, 0x09, 0x0a, 0x10, 0x53, 0x69,
	0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79,
	0x12, 0x5b, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x6d, 0x75, 0x6c,
	0x61, 0x74, 0x65, 0x64, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x7d, 0x0a,
	0x11, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x46, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x10, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x39, 0x0a, 0x0a,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5f, 0x0a, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72,
	0x69, 0x74, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x46, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x52, 0x08,
	0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x6c, 0x0a, 0x0d, 0x66, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x6d, 0x75, 0x6c,
	0x61, 0x74, 0x65, 0x64, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x46, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x0c, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x1a, 0x5b, 0x0a, 0x15, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x2c, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x38, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12,
	0x0c, 0x0a, 0x08, 0x49, 0x4e, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x22, 0x51, 0x0a,
	0x08, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x45, 0x56,
	0x45, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x49, 0x54, 0x49, 0x43, 0x41, 0x4c, 0x10,
	0x01, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x49, 0x47, 0x48, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x4d,
	0x45, 0x44, 0x49, 0x55, 0x4d, 0x10, 0x03, 0x12, 0x07, 0x0a, 0x03, 0x4c, 0x4f, 0x57, 0x10, 0x04,
	0x22, 0x99, 0x01, 0x0a, 0x0c, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x12, 0x1d, 0x0a, 0x19, 0x46, 0x49, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x43, 0x4c, 0x41,
	0x53, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0a, 0x0a, 0x06, 0x54, 0x48, 0x52, 0x45, 0x41, 0x54, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d,
	0x56, 0x55, 0x4c, 0x4e, 0x45, 0x52, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x10, 0x02, 0x12,
	0x14, 0x0a, 0x10, 0x4d, 0x49, 0x53, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x55, 0x52, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x4f, 0x42, 0x53, 0x45, 0x52, 0x56, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x43, 0x43, 0x5f, 0x45, 0x52,
	0x52, 0x4f, 0x52, 0x10, 0x05, 0x12, 0x15, 0x0a, 0x11, 0x50, 0x4f, 0x53, 0x54, 0x55, 0x52, 0x45,
	0x5f, 0x56, 0x49, 0x4f, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x06, 0x3a, 0xee, 0x01, 0xea,
	0x41, 0xea, 0x01, 0x0a, 0x25, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x40, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2f, 0x7b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x2f, 0x7b, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x7d, 0x12, 0x34, 0x66, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x7d, 0x2f,
	0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x7d, 0x12, 0x36, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x7b,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73,
	0x2f, 0x7b, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x7d, 0x2a, 0x08, 0x66, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x32, 0x07, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x22, 0x9c, 0x03,
	0x0a, 0x33, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x85, 0x01, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x1a, 0xdc, 0x01,
	0x0a, 0x0f, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x12, 0x56, 0x0a, 0x07, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69,
	0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x48, 0x00,
	0x52, 0x07, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x3b, 0x0a, 0x0c, 0x6e, 0x6f, 0x5f,
	0x76, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x48, 0x00, 0x52, 0x0b, 0x6e, 0x6f, 0x56, 0x69, 0x6f,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72,
	0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x48, 0x00, 0x52, 0x05, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x93, 0x08, 0x0a,
	0x29, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54,
	0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x93, 0x01, 0x0a, 0x10, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x63, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x17, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x4e, 0x0a, 0x0f, 0x45, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x45, 0x4e,
	0x41, 0x42, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07,
	0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53,
	0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x3a, 0xc8, 0x04, 0xea, 0x41, 0xc4, 0x04, 0x0a, 0x51,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x12, 0x8d, 0x01, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73,
	0x2f, 0x7b, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x7d, 0x12, 0x83, 0x01, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x66, 0x66, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x7d, 0x12, 0x81, 0x01, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x73, 0x2f, 0x7b, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x66, 0x66, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65,
	0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x7d, 0x2a, 0x2a, 0x65, 0x66, 0x66,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61,
	0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x32, 0x29, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x22, 0xf0, 0x01, 0x0a, 0x35, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x71, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x59, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x53, 0x12, 0x51, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x66,
	0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65,
	0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9b, 0x02, 0x0a, 0x36, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x66,
	0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65,
	0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0xb8, 0x01, 0x0a, 0x2f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52,
	0x2a, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54,
	0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xa4, 0x01, 0x0a, 0x33, 0x47, 0x65, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6d, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x59, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x53, 0x0a, 0x51, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x66, 0x66, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9c, 0x09, 0x0a, 0x20, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x79,
	0x0a, 0x0f, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x50, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x4a, 0x0a,
	0x48, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x0e, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x8a, 0x01, 0x0a, 0x10, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x2e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x24, 0x0a, 0x0b, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x65, 0x64, 0x69, 0x74, 0x6f, 0x72, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x6c, 0x61, 0x73, 0x74,
	0x45, 0x64, 0x69, 0x74, 0x6f, 0x72, 0x22, 0x5d, 0x0a, 0x0f, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x45, 0x4e, 0x41,
	0x42, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x45,
	0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41,
	0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x49, 0x4e, 0x48, 0x45, 0x52, 0x49,
	0x54, 0x45, 0x44, 0x10, 0x03, 0x3a, 0xf1, 0x03, 0xea, 0x41, 0xed, 0x03, 0x0a, 0x48, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61,
	0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x7a, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54,
	0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x7d, 0x12, 0x70, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x7d, 0x12, 0x6e, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x7d, 0x2a, 0x21, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61,
	0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x32, 0x20, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22, 0xde, 0x01, 0x0a, 0x2c, 0x4c, 0x69,
	0x73, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x68, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x50, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x4a, 0x12, 0x48, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xf6, 0x01, 0x0a, 0x2d, 0x4c,
	0x69, 0x73, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x9c, 0x01, 0x0a,
	0x25, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x21, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54,
	0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xe8, 0x01, 0x0a, 0x36, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x73, 0x63,
	0x65, 0x6e, 0x64, 0x61, 0x6e, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61,
	0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x68,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x50,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x4a, 0x12, 0x48, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x80,
	0x02, 0x0a, 0x37, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x61, 0x6e,
	0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x9c, 0x01, 0x0a, 0x25, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61,
	0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x21, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x92, 0x01, 0x0a, 0x2a, 0x47, 0x65, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x64, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x50,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x4a, 0x0a, 0x48, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe5, 0x02, 0x0a, 0x2d, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x68, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x50, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x4a,
	0x12, 0x48, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54,
	0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x9f, 0x01, 0x0a, 0x24, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x20, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xbd,
	0x02, 0x0a, 0x2d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x12, 0x9f, 0x01, 0x0a, 0x24, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x20, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xbf,
	0x01, 0x0a, 0x2d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x64, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x50,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x4a, 0x0a, 0x48, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79,
	0x22, 0xd4, 0x01, 0x0a, 0x2f, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x68, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x50, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x4a, 0x12, 0x48, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61,
	0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1e,
	0x0a, 0x08, 0x72, 0x61, 0x77, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x72, 0x61, 0x77, 0x54, 0x65, 0x78, 0x74, 0x12, 0x17,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x84, 0x05, 0x0a, 0x30, 0x56, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x8e, 0x01, 0x0a,
	0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x76, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x1a, 0xec, 0x02,
	0x0a, 0x1b, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x56, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x20, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1d, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x50, 0x61, 0x74, 0x68, 0x12, 0x7e,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x63, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x00, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x88, 0x01, 0x01, 0x12, 0x7a,
	0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x63, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x48, 0x01, 0x52, 0x03, 0x65, 0x6e, 0x64, 0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x42, 0x06, 0x0a, 0x04, 0x5f, 0x65, 0x6e, 0x64, 0x1a, 0x50, 0x0a, 0x08,
	0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x69, 0x6e, 0x65,
	0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x6c,
	0x69, 0x6e, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0c, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x32, 0xa1,
	0x4b, 0x0a, 0x18, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x90, 0x04, 0x0a, 0x31,
	0x4c, 0x69, 0x73, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x73, 0x12, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x63, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x91, 0x02, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x81, 0x02, 0x5a, 0x52, 0x12,
	0x50, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x73, 0x5a, 0x58, 0x12, 0x56, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x66,
	0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x51, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0xfd,
	0x03, 0x0a, 0x2f, 0x47, 0x65, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x12, 0x60, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22, 0x8f, 0x02, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x81, 0x02, 0x5a, 0x52, 0x12,
	0x50, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x5a, 0x58, 0x12, 0x56, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x66, 0x66, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x51, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x66,
	0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xda,
	0x03, 0x0a, 0x28, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x59, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65,
	0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0xf6, 0x01, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0xe6, 0x01, 0x5a, 0x49, 0x12, 0x47, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73,
	0x5a, 0x4f, 0x12, 0x4d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x73, 0x12, 0x48, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0xa5, 0x04, 0x0a, 0x32,
	0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x61, 0x6e, 0x74, 0x53, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x73, 0x12, 0x63, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x44, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x61, 0x6e,
	0x74, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xa3, 0x02,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x93, 0x02,
	0x5a, 0x58, 0x12, 0x56, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x3a, 0x6c, 0x69, 0x73, 0x74,
	0x44, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x61, 0x6e, 0x74, 0x5a, 0x5e, 0x12, 0x5c, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x3a, 0x6c, 0x69, 0x73, 0x74,
	0x44, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x61, 0x6e, 0x74, 0x12, 0x57, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x73, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64,
	0x61, 0x6e, 0x74, 0x12, 0xc7, 0x03, 0x0a, 0x26, 0x47, 0x65, 0x74, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x57,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22, 0xf4, 0x01, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0xe6, 0x01, 0x5a, 0x49, 0x12, 0x47, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x5a, 0x4f, 0x12, 0x4d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0x48, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65,
	0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf2, 0x04,
	0x0a, 0x29, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x5a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22, 0x99, 0x03, 0xda, 0x41, 0x2e, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xe1,
	0x02, 0x3a, 0x27, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5a, 0x72, 0x3a, 0x27, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22, 0x47, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x5a, 0x78,
	0x3a, 0x27, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22, 0x4d, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x22, 0x48, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x73, 0x12, 0xf1, 0x05, 0x0a, 0x29, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x12, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x4d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22, 0x98, 0x04, 0xda, 0x41,
	0x33, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68,
	0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xdb, 0x03, 0x3a, 0x27, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x5a, 0x9a, 0x01, 0x3a, 0x27, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x32, 0x6f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f,
	0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x5a, 0xa0, 0x01, 0x3a, 0x27, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x32, 0x75, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x32, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x96, 0x03, 0x0a, 0x29, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x12, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65,
	0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0xf4, 0x01, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xe6, 0x01, 0x5a, 0x49, 0x2a, 0x47, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x4f, 0x2a, 0x4d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2a, 0x48, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0x9e, 0x04, 0x0a, 0x2b, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12,
	0x5c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x6d, 0x75, 0x6c,
	0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x5d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74,
	0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xb1, 0x02, 0xda,
	0x41, 0x1d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x8a, 0x02, 0x3a, 0x01, 0x2a, 0x5a, 0x55, 0x3a, 0x01, 0x2a, 0x22, 0x50,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x3a, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65,
	0x5a, 0x5b, 0x3a, 0x01, 0x2a, 0x22, 0x56, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x73, 0x3a, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x22, 0x51, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x3a, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65,
	0x12, 0xfe, 0x03, 0x0a, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x73, 0x12, 0x5f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x60, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x88, 0x02, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xf8, 0x01, 0x5a, 0x4f, 0x12, 0x4d, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x5a, 0x55, 0x12, 0x53, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x73, 0x12, 0x4e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x73, 0x12, 0xeb, 0x03, 0x0a, 0x2c, 0x47, 0x65, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x12, 0x5d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54,
	0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x66, 0x66,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61,
	0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22, 0x86, 0x02, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0xf8, 0x01, 0x5a, 0x4f, 0x12, 0x4d, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x66, 0x66, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x55, 0x12, 0x53, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0x4e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xc8, 0x03, 0x0a, 0x25, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xed, 0x01, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xdd, 0x01, 0x5a, 0x46, 0x12,
	0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x73, 0x5a, 0x4c, 0x12, 0x4a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x73, 0x12, 0x45, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x93, 0x04, 0x0a, 0x2f, 0x4c,
	0x69, 0x73, 0x74, 0x44, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x61, 0x6e, 0x74, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x60,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65,
	0x73, 0x63, 0x65, 0x6e, 0x64, 0x61, 0x6e, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x44, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x61, 0x6e, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54,
	0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x9a, 0x02, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x8a, 0x02, 0x5a, 0x55, 0x12, 0x53, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x3a, 0x6c,
	0x69, 0x73, 0x74, 0x44, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x61, 0x6e, 0x74, 0x5a, 0x5b, 0x12,
	0x59, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54,
	0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x3a, 0x6c, 0x69, 0x73, 0x74,
	0x44, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x61, 0x6e, 0x74, 0x12, 0x54, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x73, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x61, 0x6e, 0x74,
	0x12, 0xb5, 0x03, 0x0a, 0x23, 0x47, 0x65, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65,
	0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x4a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54,
	0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22, 0xeb, 0x01, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xdd, 0x01, 0x5a, 0x46, 0x12, 0x44, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x5a, 0x4c, 0x12, 0x4a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0x45, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd4, 0x04, 0x0a, 0x26, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x12, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x4a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22, 0x84, 0x03, 0xda, 0x41, 0x2b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61,
	0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xcf, 0x02,
	0x3a, 0x24, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5a, 0x6c, 0x3a, 0x24, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f,
	0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22, 0x44,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x73, 0x5a, 0x72, 0x3a, 0x24, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22, 0x4a, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65,
	0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x22, 0x45, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12,
	0xca, 0x05, 0x0a, 0x26, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54,
	0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x57, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22,
	0xfa, 0x03, 0xda, 0x41, 0x30, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61,
	0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xc0, 0x03, 0x3a, 0x24, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x5a, 0x91, 0x01, 0x3a, 0x24, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x32, 0x69, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x97, 0x01, 0x3a, 0x24, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x32,
	0x6f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65,
	0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x32, 0x6a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x87, 0x03, 0x0a,
	0x26, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65,
	0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0xeb, 0x01, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xdd, 0x01, 0x5a, 0x46, 0x2a, 0x44, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x5a, 0x4c, 0x2a, 0x4a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2a,
	0x45, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xec, 0x03, 0x0a, 0x28, 0x56, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x12, 0x59, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x56,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65,
	0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x5a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x88, 0x02, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x81, 0x02, 0x3a, 0x01, 0x2a, 0x5a, 0x52, 0x3a, 0x01, 0x2a, 0x22, 0x4d, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x73, 0x3a, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5a, 0x58, 0x3a, 0x01, 0x2a,
	0x22, 0x53, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x3a, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x22, 0x4e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x3a, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x1a, 0x5b, 0xca, 0x41, 0x27, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x42, 0x93, 0x04, 0xea, 0x41, 0x71, 0x0a, 0x3c, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0xea, 0x41, 0x5f, 0x0a, 0x36, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x0a, 0x2c, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x42, 0x1d, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x68, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x70, 0x62, 0x3b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x70, 0x62, 0xaa, 0x02, 0x28, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x56, 0x31, 0xca,
	0x02, 0x28, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x2b, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescOnce sync.Once
	file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescData = file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDesc
)

func file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescGZIP() []byte {
	file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescOnce.Do(func() {
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescData)
	})
	return file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDescData
}

var file_google_cloud_securitycentermanagement_v1_security_center_management_proto_enumTypes = make([]protoimpl.EnumInfo, 8)
var file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes = make([]protoimpl.MessageInfo, 40)
var file_google_cloud_securitycentermanagement_v1_security_center_management_proto_goTypes = []interface{}{
	(EffectiveSecurityHealthAnalyticsCustomModule_EnablementState)(0),            // 0: google.cloud.securitycentermanagement.v1.EffectiveSecurityHealthAnalyticsCustomModule.EnablementState
	(SecurityHealthAnalyticsCustomModule_EnablementState)(0),                     // 1: google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule.EnablementState
	(CustomConfig_Severity)(0),                                                   // 2: google.cloud.securitycentermanagement.v1.CustomConfig.Severity
	(SimulatedFinding_State)(0),                                                  // 3: google.cloud.securitycentermanagement.v1.SimulatedFinding.State
	(SimulatedFinding_Severity)(0),                                               // 4: google.cloud.securitycentermanagement.v1.SimulatedFinding.Severity
	(SimulatedFinding_FindingClass)(0),                                           // 5: google.cloud.securitycentermanagement.v1.SimulatedFinding.FindingClass
	(EffectiveEventThreatDetectionCustomModule_EnablementState)(0),               // 6: google.cloud.securitycentermanagement.v1.EffectiveEventThreatDetectionCustomModule.EnablementState
	(EventThreatDetectionCustomModule_EnablementState)(0),                        // 7: google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule.EnablementState
	(*EffectiveSecurityHealthAnalyticsCustomModule)(nil),                         // 8: google.cloud.securitycentermanagement.v1.EffectiveSecurityHealthAnalyticsCustomModule
	(*ListEffectiveSecurityHealthAnalyticsCustomModulesRequest)(nil),             // 9: google.cloud.securitycentermanagement.v1.ListEffectiveSecurityHealthAnalyticsCustomModulesRequest
	(*ListEffectiveSecurityHealthAnalyticsCustomModulesResponse)(nil),            // 10: google.cloud.securitycentermanagement.v1.ListEffectiveSecurityHealthAnalyticsCustomModulesResponse
	(*GetEffectiveSecurityHealthAnalyticsCustomModuleRequest)(nil),               // 11: google.cloud.securitycentermanagement.v1.GetEffectiveSecurityHealthAnalyticsCustomModuleRequest
	(*SecurityHealthAnalyticsCustomModule)(nil),                                  // 12: google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule
	(*CustomConfig)(nil),                                                         // 13: google.cloud.securitycentermanagement.v1.CustomConfig
	(*ListSecurityHealthAnalyticsCustomModulesRequest)(nil),                      // 14: google.cloud.securitycentermanagement.v1.ListSecurityHealthAnalyticsCustomModulesRequest
	(*ListSecurityHealthAnalyticsCustomModulesResponse)(nil),                     // 15: google.cloud.securitycentermanagement.v1.ListSecurityHealthAnalyticsCustomModulesResponse
	(*ListDescendantSecurityHealthAnalyticsCustomModulesRequest)(nil),            // 16: google.cloud.securitycentermanagement.v1.ListDescendantSecurityHealthAnalyticsCustomModulesRequest
	(*ListDescendantSecurityHealthAnalyticsCustomModulesResponse)(nil),           // 17: google.cloud.securitycentermanagement.v1.ListDescendantSecurityHealthAnalyticsCustomModulesResponse
	(*GetSecurityHealthAnalyticsCustomModuleRequest)(nil),                        // 18: google.cloud.securitycentermanagement.v1.GetSecurityHealthAnalyticsCustomModuleRequest
	(*CreateSecurityHealthAnalyticsCustomModuleRequest)(nil),                     // 19: google.cloud.securitycentermanagement.v1.CreateSecurityHealthAnalyticsCustomModuleRequest
	(*UpdateSecurityHealthAnalyticsCustomModuleRequest)(nil),                     // 20: google.cloud.securitycentermanagement.v1.UpdateSecurityHealthAnalyticsCustomModuleRequest
	(*DeleteSecurityHealthAnalyticsCustomModuleRequest)(nil),                     // 21: google.cloud.securitycentermanagement.v1.DeleteSecurityHealthAnalyticsCustomModuleRequest
	(*SimulateSecurityHealthAnalyticsCustomModuleRequest)(nil),                   // 22: google.cloud.securitycentermanagement.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
	(*SimulatedFinding)(nil),                                                     // 23: google.cloud.securitycentermanagement.v1.SimulatedFinding
	(*SimulateSecurityHealthAnalyticsCustomModuleResponse)(nil),                  // 24: google.cloud.securitycentermanagement.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
	(*EffectiveEventThreatDetectionCustomModule)(nil),                            // 25: google.cloud.securitycentermanagement.v1.EffectiveEventThreatDetectionCustomModule
	(*ListEffectiveEventThreatDetectionCustomModulesRequest)(nil),                // 26: google.cloud.securitycentermanagement.v1.ListEffectiveEventThreatDetectionCustomModulesRequest
	(*ListEffectiveEventThreatDetectionCustomModulesResponse)(nil),               // 27: google.cloud.securitycentermanagement.v1.ListEffectiveEventThreatDetectionCustomModulesResponse
	(*GetEffectiveEventThreatDetectionCustomModuleRequest)(nil),                  // 28: google.cloud.securitycentermanagement.v1.GetEffectiveEventThreatDetectionCustomModuleRequest
	(*EventThreatDetectionCustomModule)(nil),                                     // 29: google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule
	(*ListEventThreatDetectionCustomModulesRequest)(nil),                         // 30: google.cloud.securitycentermanagement.v1.ListEventThreatDetectionCustomModulesRequest
	(*ListEventThreatDetectionCustomModulesResponse)(nil),                        // 31: google.cloud.securitycentermanagement.v1.ListEventThreatDetectionCustomModulesResponse
	(*ListDescendantEventThreatDetectionCustomModulesRequest)(nil),               // 32: google.cloud.securitycentermanagement.v1.ListDescendantEventThreatDetectionCustomModulesRequest
	(*ListDescendantEventThreatDetectionCustomModulesResponse)(nil),              // 33: google.cloud.securitycentermanagement.v1.ListDescendantEventThreatDetectionCustomModulesResponse
	(*GetEventThreatDetectionCustomModuleRequest)(nil),                           // 34: google.cloud.securitycentermanagement.v1.GetEventThreatDetectionCustomModuleRequest
	(*CreateEventThreatDetectionCustomModuleRequest)(nil),                        // 35: google.cloud.securitycentermanagement.v1.CreateEventThreatDetectionCustomModuleRequest
	(*UpdateEventThreatDetectionCustomModuleRequest)(nil),                        // 36: google.cloud.securitycentermanagement.v1.UpdateEventThreatDetectionCustomModuleRequest
	(*DeleteEventThreatDetectionCustomModuleRequest)(nil),                        // 37: google.cloud.securitycentermanagement.v1.DeleteEventThreatDetectionCustomModuleRequest
	(*ValidateEventThreatDetectionCustomModuleRequest)(nil),                      // 38: google.cloud.securitycentermanagement.v1.ValidateEventThreatDetectionCustomModuleRequest
	(*ValidateEventThreatDetectionCustomModuleResponse)(nil),                     // 39: google.cloud.securitycentermanagement.v1.ValidateEventThreatDetectionCustomModuleResponse
	(*CustomConfig_CustomOutputSpec)(nil),                                        // 40: google.cloud.securitycentermanagement.v1.CustomConfig.CustomOutputSpec
	(*CustomConfig_ResourceSelector)(nil),                                        // 41: google.cloud.securitycentermanagement.v1.CustomConfig.ResourceSelector
	(*CustomConfig_CustomOutputSpec_Property)(nil),                               // 42: google.cloud.securitycentermanagement.v1.CustomConfig.CustomOutputSpec.Property
	(*SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource)(nil), // 43: google.cloud.securitycentermanagement.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource
	nil, // 44: google.cloud.securitycentermanagement.v1.SimulatedFinding.SourcePropertiesEntry
	(*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult)(nil),          // 45: google.cloud.securitycentermanagement.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult
	(*ValidateEventThreatDetectionCustomModuleResponse_CustomModuleValidationError)(nil), // 46: google.cloud.securitycentermanagement.v1.ValidateEventThreatDetectionCustomModuleResponse.CustomModuleValidationError
	(*ValidateEventThreatDetectionCustomModuleResponse_Position)(nil),                    // 47: google.cloud.securitycentermanagement.v1.ValidateEventThreatDetectionCustomModuleResponse.Position
	(*timestamppb.Timestamp)(nil), // 48: google.protobuf.Timestamp
	(*expr.Expr)(nil),             // 49: google.type.Expr
	(*fieldmaskpb.FieldMask)(nil), // 50: google.protobuf.FieldMask
	(*structpb.Struct)(nil),       // 51: google.protobuf.Struct
	(*iampb.Policy)(nil),          // 52: google.iam.v1.Policy
	(*structpb.Value)(nil),        // 53: google.protobuf.Value
	(*emptypb.Empty)(nil),         // 54: google.protobuf.Empty
	(*status.Status)(nil),         // 55: google.rpc.Status
}
var file_google_cloud_securitycentermanagement_v1_security_center_management_proto_depIdxs = []int32{
	13, // 0: google.cloud.securitycentermanagement.v1.EffectiveSecurityHealthAnalyticsCustomModule.custom_config:type_name -> google.cloud.securitycentermanagement.v1.CustomConfig
	0,  // 1: google.cloud.securitycentermanagement.v1.EffectiveSecurityHealthAnalyticsCustomModule.enablement_state:type_name -> google.cloud.securitycentermanagement.v1.EffectiveSecurityHealthAnalyticsCustomModule.EnablementState
	8,  // 2: google.cloud.securitycentermanagement.v1.ListEffectiveSecurityHealthAnalyticsCustomModulesResponse.effective_security_health_analytics_custom_modules:type_name -> google.cloud.securitycentermanagement.v1.EffectiveSecurityHealthAnalyticsCustomModule
	1,  // 3: google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule.enablement_state:type_name -> google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule.EnablementState
	48, // 4: google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule.update_time:type_name -> google.protobuf.Timestamp
	13, // 5: google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule.custom_config:type_name -> google.cloud.securitycentermanagement.v1.CustomConfig
	49, // 6: google.cloud.securitycentermanagement.v1.CustomConfig.predicate:type_name -> google.type.Expr
	40, // 7: google.cloud.securitycentermanagement.v1.CustomConfig.custom_output:type_name -> google.cloud.securitycentermanagement.v1.CustomConfig.CustomOutputSpec
	41, // 8: google.cloud.securitycentermanagement.v1.CustomConfig.resource_selector:type_name -> google.cloud.securitycentermanagement.v1.CustomConfig.ResourceSelector
	2,  // 9: google.cloud.securitycentermanagement.v1.CustomConfig.severity:type_name -> google.cloud.securitycentermanagement.v1.CustomConfig.Severity
	12, // 10: google.cloud.securitycentermanagement.v1.ListSecurityHealthAnalyticsCustomModulesResponse.security_health_analytics_custom_modules:type_name -> google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule
	12, // 11: google.cloud.securitycentermanagement.v1.ListDescendantSecurityHealthAnalyticsCustomModulesResponse.security_health_analytics_custom_modules:type_name -> google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule
	12, // 12: google.cloud.securitycentermanagement.v1.CreateSecurityHealthAnalyticsCustomModuleRequest.security_health_analytics_custom_module:type_name -> google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule
	50, // 13: google.cloud.securitycentermanagement.v1.UpdateSecurityHealthAnalyticsCustomModuleRequest.update_mask:type_name -> google.protobuf.FieldMask
	12, // 14: google.cloud.securitycentermanagement.v1.UpdateSecurityHealthAnalyticsCustomModuleRequest.security_health_analytics_custom_module:type_name -> google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule
	13, // 15: google.cloud.securitycentermanagement.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.custom_config:type_name -> google.cloud.securitycentermanagement.v1.CustomConfig
	43, // 16: google.cloud.securitycentermanagement.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.resource:type_name -> google.cloud.securitycentermanagement.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource
	3,  // 17: google.cloud.securitycentermanagement.v1.SimulatedFinding.state:type_name -> google.cloud.securitycentermanagement.v1.SimulatedFinding.State
	44, // 18: google.cloud.securitycentermanagement.v1.SimulatedFinding.source_properties:type_name -> google.cloud.securitycentermanagement.v1.SimulatedFinding.SourcePropertiesEntry
	48, // 19: google.cloud.securitycentermanagement.v1.SimulatedFinding.event_time:type_name -> google.protobuf.Timestamp
	4,  // 20: google.cloud.securitycentermanagement.v1.SimulatedFinding.severity:type_name -> google.cloud.securitycentermanagement.v1.SimulatedFinding.Severity
	5,  // 21: google.cloud.securitycentermanagement.v1.SimulatedFinding.finding_class:type_name -> google.cloud.securitycentermanagement.v1.SimulatedFinding.FindingClass
	45, // 22: google.cloud.securitycentermanagement.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.result:type_name -> google.cloud.securitycentermanagement.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult
	51, // 23: google.cloud.securitycentermanagement.v1.EffectiveEventThreatDetectionCustomModule.config:type_name -> google.protobuf.Struct
	6,  // 24: google.cloud.securitycentermanagement.v1.EffectiveEventThreatDetectionCustomModule.enablement_state:type_name -> google.cloud.securitycentermanagement.v1.EffectiveEventThreatDetectionCustomModule.EnablementState
	25, // 25: google.cloud.securitycentermanagement.v1.ListEffectiveEventThreatDetectionCustomModulesResponse.effective_event_threat_detection_custom_modules:type_name -> google.cloud.securitycentermanagement.v1.EffectiveEventThreatDetectionCustomModule
	51, // 26: google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule.config:type_name -> google.protobuf.Struct
	7,  // 27: google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule.enablement_state:type_name -> google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule.EnablementState
	48, // 28: google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule.update_time:type_name -> google.protobuf.Timestamp
	29, // 29: google.cloud.securitycentermanagement.v1.ListEventThreatDetectionCustomModulesResponse.event_threat_detection_custom_modules:type_name -> google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule
	29, // 30: google.cloud.securitycentermanagement.v1.ListDescendantEventThreatDetectionCustomModulesResponse.event_threat_detection_custom_modules:type_name -> google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule
	29, // 31: google.cloud.securitycentermanagement.v1.CreateEventThreatDetectionCustomModuleRequest.event_threat_detection_custom_module:type_name -> google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule
	50, // 32: google.cloud.securitycentermanagement.v1.UpdateEventThreatDetectionCustomModuleRequest.update_mask:type_name -> google.protobuf.FieldMask
	29, // 33: google.cloud.securitycentermanagement.v1.UpdateEventThreatDetectionCustomModuleRequest.event_threat_detection_custom_module:type_name -> google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule
	46, // 34: google.cloud.securitycentermanagement.v1.ValidateEventThreatDetectionCustomModuleResponse.errors:type_name -> google.cloud.securitycentermanagement.v1.ValidateEventThreatDetectionCustomModuleResponse.CustomModuleValidationError
	42, // 35: google.cloud.securitycentermanagement.v1.CustomConfig.CustomOutputSpec.properties:type_name -> google.cloud.securitycentermanagement.v1.CustomConfig.CustomOutputSpec.Property
	49, // 36: google.cloud.securitycentermanagement.v1.CustomConfig.CustomOutputSpec.Property.value_expression:type_name -> google.type.Expr
	51, // 37: google.cloud.securitycentermanagement.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource.resource_data:type_name -> google.protobuf.Struct
	52, // 38: google.cloud.securitycentermanagement.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource.iam_policy_data:type_name -> google.iam.v1.Policy
	53, // 39: google.cloud.securitycentermanagement.v1.SimulatedFinding.SourcePropertiesEntry.value:type_name -> google.protobuf.Value
	23, // 40: google.cloud.securitycentermanagement.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult.finding:type_name -> google.cloud.securitycentermanagement.v1.SimulatedFinding
	54, // 41: google.cloud.securitycentermanagement.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult.no_violation:type_name -> google.protobuf.Empty
	55, // 42: google.cloud.securitycentermanagement.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult.error:type_name -> google.rpc.Status
	47, // 43: google.cloud.securitycentermanagement.v1.ValidateEventThreatDetectionCustomModuleResponse.CustomModuleValidationError.start:type_name -> google.cloud.securitycentermanagement.v1.ValidateEventThreatDetectionCustomModuleResponse.Position
	47, // 44: google.cloud.securitycentermanagement.v1.ValidateEventThreatDetectionCustomModuleResponse.CustomModuleValidationError.end:type_name -> google.cloud.securitycentermanagement.v1.ValidateEventThreatDetectionCustomModuleResponse.Position
	9,  // 45: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.ListEffectiveSecurityHealthAnalyticsCustomModules:input_type -> google.cloud.securitycentermanagement.v1.ListEffectiveSecurityHealthAnalyticsCustomModulesRequest
	11, // 46: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.GetEffectiveSecurityHealthAnalyticsCustomModule:input_type -> google.cloud.securitycentermanagement.v1.GetEffectiveSecurityHealthAnalyticsCustomModuleRequest
	14, // 47: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.ListSecurityHealthAnalyticsCustomModules:input_type -> google.cloud.securitycentermanagement.v1.ListSecurityHealthAnalyticsCustomModulesRequest
	16, // 48: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.ListDescendantSecurityHealthAnalyticsCustomModules:input_type -> google.cloud.securitycentermanagement.v1.ListDescendantSecurityHealthAnalyticsCustomModulesRequest
	18, // 49: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.GetSecurityHealthAnalyticsCustomModule:input_type -> google.cloud.securitycentermanagement.v1.GetSecurityHealthAnalyticsCustomModuleRequest
	19, // 50: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.CreateSecurityHealthAnalyticsCustomModule:input_type -> google.cloud.securitycentermanagement.v1.CreateSecurityHealthAnalyticsCustomModuleRequest
	20, // 51: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.UpdateSecurityHealthAnalyticsCustomModule:input_type -> google.cloud.securitycentermanagement.v1.UpdateSecurityHealthAnalyticsCustomModuleRequest
	21, // 52: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.DeleteSecurityHealthAnalyticsCustomModule:input_type -> google.cloud.securitycentermanagement.v1.DeleteSecurityHealthAnalyticsCustomModuleRequest
	22, // 53: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.SimulateSecurityHealthAnalyticsCustomModule:input_type -> google.cloud.securitycentermanagement.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
	26, // 54: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.ListEffectiveEventThreatDetectionCustomModules:input_type -> google.cloud.securitycentermanagement.v1.ListEffectiveEventThreatDetectionCustomModulesRequest
	28, // 55: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.GetEffectiveEventThreatDetectionCustomModule:input_type -> google.cloud.securitycentermanagement.v1.GetEffectiveEventThreatDetectionCustomModuleRequest
	30, // 56: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.ListEventThreatDetectionCustomModules:input_type -> google.cloud.securitycentermanagement.v1.ListEventThreatDetectionCustomModulesRequest
	32, // 57: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.ListDescendantEventThreatDetectionCustomModules:input_type -> google.cloud.securitycentermanagement.v1.ListDescendantEventThreatDetectionCustomModulesRequest
	34, // 58: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.GetEventThreatDetectionCustomModule:input_type -> google.cloud.securitycentermanagement.v1.GetEventThreatDetectionCustomModuleRequest
	35, // 59: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.CreateEventThreatDetectionCustomModule:input_type -> google.cloud.securitycentermanagement.v1.CreateEventThreatDetectionCustomModuleRequest
	36, // 60: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.UpdateEventThreatDetectionCustomModule:input_type -> google.cloud.securitycentermanagement.v1.UpdateEventThreatDetectionCustomModuleRequest
	37, // 61: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.DeleteEventThreatDetectionCustomModule:input_type -> google.cloud.securitycentermanagement.v1.DeleteEventThreatDetectionCustomModuleRequest
	38, // 62: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.ValidateEventThreatDetectionCustomModule:input_type -> google.cloud.securitycentermanagement.v1.ValidateEventThreatDetectionCustomModuleRequest
	10, // 63: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.ListEffectiveSecurityHealthAnalyticsCustomModules:output_type -> google.cloud.securitycentermanagement.v1.ListEffectiveSecurityHealthAnalyticsCustomModulesResponse
	8,  // 64: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.GetEffectiveSecurityHealthAnalyticsCustomModule:output_type -> google.cloud.securitycentermanagement.v1.EffectiveSecurityHealthAnalyticsCustomModule
	15, // 65: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.ListSecurityHealthAnalyticsCustomModules:output_type -> google.cloud.securitycentermanagement.v1.ListSecurityHealthAnalyticsCustomModulesResponse
	17, // 66: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.ListDescendantSecurityHealthAnalyticsCustomModules:output_type -> google.cloud.securitycentermanagement.v1.ListDescendantSecurityHealthAnalyticsCustomModulesResponse
	12, // 67: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.GetSecurityHealthAnalyticsCustomModule:output_type -> google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule
	12, // 68: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.CreateSecurityHealthAnalyticsCustomModule:output_type -> google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule
	12, // 69: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.UpdateSecurityHealthAnalyticsCustomModule:output_type -> google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule
	54, // 70: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.DeleteSecurityHealthAnalyticsCustomModule:output_type -> google.protobuf.Empty
	24, // 71: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.SimulateSecurityHealthAnalyticsCustomModule:output_type -> google.cloud.securitycentermanagement.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
	27, // 72: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.ListEffectiveEventThreatDetectionCustomModules:output_type -> google.cloud.securitycentermanagement.v1.ListEffectiveEventThreatDetectionCustomModulesResponse
	25, // 73: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.GetEffectiveEventThreatDetectionCustomModule:output_type -> google.cloud.securitycentermanagement.v1.EffectiveEventThreatDetectionCustomModule
	31, // 74: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.ListEventThreatDetectionCustomModules:output_type -> google.cloud.securitycentermanagement.v1.ListEventThreatDetectionCustomModulesResponse
	33, // 75: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.ListDescendantEventThreatDetectionCustomModules:output_type -> google.cloud.securitycentermanagement.v1.ListDescendantEventThreatDetectionCustomModulesResponse
	29, // 76: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.GetEventThreatDetectionCustomModule:output_type -> google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule
	29, // 77: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.CreateEventThreatDetectionCustomModule:output_type -> google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule
	29, // 78: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.UpdateEventThreatDetectionCustomModule:output_type -> google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule
	54, // 79: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.DeleteEventThreatDetectionCustomModule:output_type -> google.protobuf.Empty
	39, // 80: google.cloud.securitycentermanagement.v1.SecurityCenterManagement.ValidateEventThreatDetectionCustomModule:output_type -> google.cloud.securitycentermanagement.v1.ValidateEventThreatDetectionCustomModuleResponse
	63, // [63:81] is the sub-list for method output_type
	45, // [45:63] is the sub-list for method input_type
	45, // [45:45] is the sub-list for extension type_name
	45, // [45:45] is the sub-list for extension extendee
	0,  // [0:45] is the sub-list for field type_name
}

func init() { file_google_cloud_securitycentermanagement_v1_security_center_management_proto_init() }
func file_google_cloud_securitycentermanagement_v1_security_center_management_proto_init() {
	if File_google_cloud_securitycentermanagement_v1_security_center_management_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EffectiveSecurityHealthAnalyticsCustomModule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEffectiveSecurityHealthAnalyticsCustomModulesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEffectiveSecurityHealthAnalyticsCustomModulesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEffectiveSecurityHealthAnalyticsCustomModuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecurityHealthAnalyticsCustomModule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSecurityHealthAnalyticsCustomModulesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSecurityHealthAnalyticsCustomModulesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDescendantSecurityHealthAnalyticsCustomModulesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDescendantSecurityHealthAnalyticsCustomModulesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSecurityHealthAnalyticsCustomModuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSecurityHealthAnalyticsCustomModuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSecurityHealthAnalyticsCustomModuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSecurityHealthAnalyticsCustomModuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SimulateSecurityHealthAnalyticsCustomModuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SimulatedFinding); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SimulateSecurityHealthAnalyticsCustomModuleResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EffectiveEventThreatDetectionCustomModule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEffectiveEventThreatDetectionCustomModulesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEffectiveEventThreatDetectionCustomModulesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEffectiveEventThreatDetectionCustomModuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventThreatDetectionCustomModule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEventThreatDetectionCustomModulesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEventThreatDetectionCustomModulesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDescendantEventThreatDetectionCustomModulesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDescendantEventThreatDetectionCustomModulesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEventThreatDetectionCustomModuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateEventThreatDetectionCustomModuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateEventThreatDetectionCustomModuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteEventThreatDetectionCustomModuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValidateEventThreatDetectionCustomModuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValidateEventThreatDetectionCustomModuleResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomConfig_CustomOutputSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomConfig_ResourceSelector); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomConfig_CustomOutputSpec_Property); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValidateEventThreatDetectionCustomModuleResponse_CustomModuleValidationError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValidateEventThreatDetectionCustomModuleResponse_Position); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[37].OneofWrappers = []interface{}{
		(*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Finding)(nil),
		(*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_NoViolation)(nil),
		(*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Error)(nil),
	}
	file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes[38].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDesc,
			NumEnums:      8,
			NumMessages:   40,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_securitycentermanagement_v1_security_center_management_proto_goTypes,
		DependencyIndexes: file_google_cloud_securitycentermanagement_v1_security_center_management_proto_depIdxs,
		EnumInfos:         file_google_cloud_securitycentermanagement_v1_security_center_management_proto_enumTypes,
		MessageInfos:      file_google_cloud_securitycentermanagement_v1_security_center_management_proto_msgTypes,
	}.Build()
	File_google_cloud_securitycentermanagement_v1_security_center_management_proto = out.File
	file_google_cloud_securitycentermanagement_v1_security_center_management_proto_rawDesc = nil
	file_google_cloud_securitycentermanagement_v1_security_center_management_proto_goTypes = nil
	file_google_cloud_securitycentermanagement_v1_security_center_management_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SecurityCenterManagementClient is the client API for SecurityCenterManagement service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SecurityCenterManagementClient interface {
	// Returns a list of all EffectiveSecurityHealthAnalyticsCustomModules for the
	// given parent. This includes resident modules defined at the scope of the
	// parent, and inherited modules, inherited from CRM ancestors (no
	// descendants).
	ListEffectiveSecurityHealthAnalyticsCustomModules(ctx context.Context, in *ListEffectiveSecurityHealthAnalyticsCustomModulesRequest, opts ...grpc.CallOption) (*ListEffectiveSecurityHealthAnalyticsCustomModulesResponse, error)
	// Gets details of a single EffectiveSecurityHealthAnalyticsCustomModule.
	GetEffectiveSecurityHealthAnalyticsCustomModule(ctx context.Context, in *GetEffectiveSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*EffectiveSecurityHealthAnalyticsCustomModule, error)
	// Returns a list of all SecurityHealthAnalyticsCustomModules for the given
	// parent. This includes resident modules defined at the scope of the parent,
	// and inherited modules, inherited from CRM ancestors (no descendants).
	ListSecurityHealthAnalyticsCustomModules(ctx context.Context, in *ListSecurityHealthAnalyticsCustomModulesRequest, opts ...grpc.CallOption) (*ListSecurityHealthAnalyticsCustomModulesResponse, error)
	// Returns a list of all resident SecurityHealthAnalyticsCustomModules under
	// the given CRM parent and all of the parent's CRM descendants.
	ListDescendantSecurityHealthAnalyticsCustomModules(ctx context.Context, in *ListDescendantSecurityHealthAnalyticsCustomModulesRequest, opts ...grpc.CallOption) (*ListDescendantSecurityHealthAnalyticsCustomModulesResponse, error)
	// Retrieves a SecurityHealthAnalyticsCustomModule.
	GetSecurityHealthAnalyticsCustomModule(ctx context.Context, in *GetSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*SecurityHealthAnalyticsCustomModule, error)
	// Creates a resident SecurityHealthAnalyticsCustomModule at the scope of the
	// given CRM parent, and also creates inherited
	// SecurityHealthAnalyticsCustomModules for all CRM descendants of the given
	// parent. These modules are enabled by default.
	CreateSecurityHealthAnalyticsCustomModule(ctx context.Context, in *CreateSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*SecurityHealthAnalyticsCustomModule, error)
	// Updates the SecurityHealthAnalyticsCustomModule under the given name based
	// on the given update mask. Updating the enablement state is supported on
	// both resident and inherited modules (though resident modules cannot have an
	// enablement state of "inherited"). Updating the display name and custom
	// config of a module is supported on resident modules only.
	UpdateSecurityHealthAnalyticsCustomModule(ctx context.Context, in *UpdateSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*SecurityHealthAnalyticsCustomModule, error)
	// Deletes the specified SecurityHealthAnalyticsCustomModule and all of its
	// descendants in the CRM hierarchy. This method is only supported for
	// resident custom modules.
	DeleteSecurityHealthAnalyticsCustomModule(ctx context.Context, in *DeleteSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Simulates a given SecurityHealthAnalyticsCustomModule and Resource.
	SimulateSecurityHealthAnalyticsCustomModule(ctx context.Context, in *SimulateSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*SimulateSecurityHealthAnalyticsCustomModuleResponse, error)
	// Lists all effective Event Threat Detection custom modules for the
	// given parent. This includes resident modules defined at the scope of the
	// parent along with modules inherited from its ancestors.
	ListEffectiveEventThreatDetectionCustomModules(ctx context.Context, in *ListEffectiveEventThreatDetectionCustomModulesRequest, opts ...grpc.CallOption) (*ListEffectiveEventThreatDetectionCustomModulesResponse, error)
	// Gets an effective ETD custom module. Retrieves the effective module at the
	// given level. The difference between an EffectiveCustomModule and a
	// CustomModule is that the fields for an EffectiveCustomModule are computed
	// from ancestors if needed. For example, the enablement_state for a
	// CustomModule can be either ENABLED, DISABLED, or INHERITED. Where as the
	// enablement_state for an EffectiveCustomModule is always computed to ENABLED
	// or DISABLED (the effective enablement_state).
	GetEffectiveEventThreatDetectionCustomModule(ctx context.Context, in *GetEffectiveEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*EffectiveEventThreatDetectionCustomModule, error)
	// Lists all Event Threat Detection custom modules for the given
	// Resource Manager parent. This includes resident modules defined at the
	// scope of the parent along with modules inherited from ancestors.
	ListEventThreatDetectionCustomModules(ctx context.Context, in *ListEventThreatDetectionCustomModulesRequest, opts ...grpc.CallOption) (*ListEventThreatDetectionCustomModulesResponse, error)
	// Lists all resident Event Threat Detection custom modules under the
	// given Resource Manager parent and its descendants.
	ListDescendantEventThreatDetectionCustomModules(ctx context.Context, in *ListDescendantEventThreatDetectionCustomModulesRequest, opts ...grpc.CallOption) (*ListDescendantEventThreatDetectionCustomModulesResponse, error)
	// Gets an Event Threat Detection custom module.
	GetEventThreatDetectionCustomModule(ctx context.Context, in *GetEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*EventThreatDetectionCustomModule, error)
	// Creates a resident Event Threat Detection custom module at the scope of the
	// given Resource Manager parent, and also creates inherited custom modules
	// for all descendants of the given parent. These modules are enabled by
	// default.
	CreateEventThreatDetectionCustomModule(ctx context.Context, in *CreateEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*EventThreatDetectionCustomModule, error)
	// Updates the Event Threat Detection custom module with the given name based
	// on the given update mask. Updating the enablement state is supported for
	// both resident and inherited modules (though resident modules cannot have an
	// enablement state of "inherited"). Updating the display name or
	// configuration of a module is supported for resident modules only. The type
	// of a module cannot be changed.
	UpdateEventThreatDetectionCustomModule(ctx context.Context, in *UpdateEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*EventThreatDetectionCustomModule, error)
	// Deletes the specified Event Threat Detection custom module and all of its
	// descendants in the Resource Manager hierarchy. This method is only
	// supported for resident custom modules.
	DeleteEventThreatDetectionCustomModule(ctx context.Context, in *DeleteEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Validates the given Event Threat Detection custom module.
	ValidateEventThreatDetectionCustomModule(ctx context.Context, in *ValidateEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*ValidateEventThreatDetectionCustomModuleResponse, error)
}

type securityCenterManagementClient struct {
	cc grpc.ClientConnInterface
}

func NewSecurityCenterManagementClient(cc grpc.ClientConnInterface) SecurityCenterManagementClient {
	return &securityCenterManagementClient{cc}
}

func (c *securityCenterManagementClient) ListEffectiveSecurityHealthAnalyticsCustomModules(ctx context.Context, in *ListEffectiveSecurityHealthAnalyticsCustomModulesRequest, opts ...grpc.CallOption) (*ListEffectiveSecurityHealthAnalyticsCustomModulesResponse, error) {
	out := new(ListEffectiveSecurityHealthAnalyticsCustomModulesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/ListEffectiveSecurityHealthAnalyticsCustomModules", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterManagementClient) GetEffectiveSecurityHealthAnalyticsCustomModule(ctx context.Context, in *GetEffectiveSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*EffectiveSecurityHealthAnalyticsCustomModule, error) {
	out := new(EffectiveSecurityHealthAnalyticsCustomModule)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/GetEffectiveSecurityHealthAnalyticsCustomModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterManagementClient) ListSecurityHealthAnalyticsCustomModules(ctx context.Context, in *ListSecurityHealthAnalyticsCustomModulesRequest, opts ...grpc.CallOption) (*ListSecurityHealthAnalyticsCustomModulesResponse, error) {
	out := new(ListSecurityHealthAnalyticsCustomModulesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/ListSecurityHealthAnalyticsCustomModules", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterManagementClient) ListDescendantSecurityHealthAnalyticsCustomModules(ctx context.Context, in *ListDescendantSecurityHealthAnalyticsCustomModulesRequest, opts ...grpc.CallOption) (*ListDescendantSecurityHealthAnalyticsCustomModulesResponse, error) {
	out := new(ListDescendantSecurityHealthAnalyticsCustomModulesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/ListDescendantSecurityHealthAnalyticsCustomModules", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterManagementClient) GetSecurityHealthAnalyticsCustomModule(ctx context.Context, in *GetSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*SecurityHealthAnalyticsCustomModule, error) {
	out := new(SecurityHealthAnalyticsCustomModule)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/GetSecurityHealthAnalyticsCustomModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterManagementClient) CreateSecurityHealthAnalyticsCustomModule(ctx context.Context, in *CreateSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*SecurityHealthAnalyticsCustomModule, error) {
	out := new(SecurityHealthAnalyticsCustomModule)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/CreateSecurityHealthAnalyticsCustomModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterManagementClient) UpdateSecurityHealthAnalyticsCustomModule(ctx context.Context, in *UpdateSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*SecurityHealthAnalyticsCustomModule, error) {
	out := new(SecurityHealthAnalyticsCustomModule)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/UpdateSecurityHealthAnalyticsCustomModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterManagementClient) DeleteSecurityHealthAnalyticsCustomModule(ctx context.Context, in *DeleteSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/DeleteSecurityHealthAnalyticsCustomModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterManagementClient) SimulateSecurityHealthAnalyticsCustomModule(ctx context.Context, in *SimulateSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*SimulateSecurityHealthAnalyticsCustomModuleResponse, error) {
	out := new(SimulateSecurityHealthAnalyticsCustomModuleResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/SimulateSecurityHealthAnalyticsCustomModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterManagementClient) ListEffectiveEventThreatDetectionCustomModules(ctx context.Context, in *ListEffectiveEventThreatDetectionCustomModulesRequest, opts ...grpc.CallOption) (*ListEffectiveEventThreatDetectionCustomModulesResponse, error) {
	out := new(ListEffectiveEventThreatDetectionCustomModulesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/ListEffectiveEventThreatDetectionCustomModules", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterManagementClient) GetEffectiveEventThreatDetectionCustomModule(ctx context.Context, in *GetEffectiveEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*EffectiveEventThreatDetectionCustomModule, error) {
	out := new(EffectiveEventThreatDetectionCustomModule)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/GetEffectiveEventThreatDetectionCustomModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterManagementClient) ListEventThreatDetectionCustomModules(ctx context.Context, in *ListEventThreatDetectionCustomModulesRequest, opts ...grpc.CallOption) (*ListEventThreatDetectionCustomModulesResponse, error) {
	out := new(ListEventThreatDetectionCustomModulesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/ListEventThreatDetectionCustomModules", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterManagementClient) ListDescendantEventThreatDetectionCustomModules(ctx context.Context, in *ListDescendantEventThreatDetectionCustomModulesRequest, opts ...grpc.CallOption) (*ListDescendantEventThreatDetectionCustomModulesResponse, error) {
	out := new(ListDescendantEventThreatDetectionCustomModulesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/ListDescendantEventThreatDetectionCustomModules", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterManagementClient) GetEventThreatDetectionCustomModule(ctx context.Context, in *GetEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*EventThreatDetectionCustomModule, error) {
	out := new(EventThreatDetectionCustomModule)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/GetEventThreatDetectionCustomModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterManagementClient) CreateEventThreatDetectionCustomModule(ctx context.Context, in *CreateEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*EventThreatDetectionCustomModule, error) {
	out := new(EventThreatDetectionCustomModule)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/CreateEventThreatDetectionCustomModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterManagementClient) UpdateEventThreatDetectionCustomModule(ctx context.Context, in *UpdateEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*EventThreatDetectionCustomModule, error) {
	out := new(EventThreatDetectionCustomModule)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/UpdateEventThreatDetectionCustomModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterManagementClient) DeleteEventThreatDetectionCustomModule(ctx context.Context, in *DeleteEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/DeleteEventThreatDetectionCustomModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterManagementClient) ValidateEventThreatDetectionCustomModule(ctx context.Context, in *ValidateEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*ValidateEventThreatDetectionCustomModuleResponse, error) {
	out := new(ValidateEventThreatDetectionCustomModuleResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/ValidateEventThreatDetectionCustomModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SecurityCenterManagementServer is the server API for SecurityCenterManagement service.
type SecurityCenterManagementServer interface {
	// Returns a list of all EffectiveSecurityHealthAnalyticsCustomModules for the
	// given parent. This includes resident modules defined at the scope of the
	// parent, and inherited modules, inherited from CRM ancestors (no
	// descendants).
	ListEffectiveSecurityHealthAnalyticsCustomModules(context.Context, *ListEffectiveSecurityHealthAnalyticsCustomModulesRequest) (*ListEffectiveSecurityHealthAnalyticsCustomModulesResponse, error)
	// Gets details of a single EffectiveSecurityHealthAnalyticsCustomModule.
	GetEffectiveSecurityHealthAnalyticsCustomModule(context.Context, *GetEffectiveSecurityHealthAnalyticsCustomModuleRequest) (*EffectiveSecurityHealthAnalyticsCustomModule, error)
	// Returns a list of all SecurityHealthAnalyticsCustomModules for the given
	// parent. This includes resident modules defined at the scope of the parent,
	// and inherited modules, inherited from CRM ancestors (no descendants).
	ListSecurityHealthAnalyticsCustomModules(context.Context, *ListSecurityHealthAnalyticsCustomModulesRequest) (*ListSecurityHealthAnalyticsCustomModulesResponse, error)
	// Returns a list of all resident SecurityHealthAnalyticsCustomModules under
	// the given CRM parent and all of the parent's CRM descendants.
	ListDescendantSecurityHealthAnalyticsCustomModules(context.Context, *ListDescendantSecurityHealthAnalyticsCustomModulesRequest) (*ListDescendantSecurityHealthAnalyticsCustomModulesResponse, error)
	// Retrieves a SecurityHealthAnalyticsCustomModule.
	GetSecurityHealthAnalyticsCustomModule(context.Context, *GetSecurityHealthAnalyticsCustomModuleRequest) (*SecurityHealthAnalyticsCustomModule, error)
	// Creates a resident SecurityHealthAnalyticsCustomModule at the scope of the
	// given CRM parent, and also creates inherited
	// SecurityHealthAnalyticsCustomModules for all CRM descendants of the given
	// parent. These modules are enabled by default.
	CreateSecurityHealthAnalyticsCustomModule(context.Context, *CreateSecurityHealthAnalyticsCustomModuleRequest) (*SecurityHealthAnalyticsCustomModule, error)
	// Updates the SecurityHealthAnalyticsCustomModule under the given name based
	// on the given update mask. Updating the enablement state is supported on
	// both resident and inherited modules (though resident modules cannot have an
	// enablement state of "inherited"). Updating the display name and custom
	// config of a module is supported on resident modules only.
	UpdateSecurityHealthAnalyticsCustomModule(context.Context, *UpdateSecurityHealthAnalyticsCustomModuleRequest) (*SecurityHealthAnalyticsCustomModule, error)
	// Deletes the specified SecurityHealthAnalyticsCustomModule and all of its
	// descendants in the CRM hierarchy. This method is only supported for
	// resident custom modules.
	DeleteSecurityHealthAnalyticsCustomModule(context.Context, *DeleteSecurityHealthAnalyticsCustomModuleRequest) (*emptypb.Empty, error)
	// Simulates a given SecurityHealthAnalyticsCustomModule and Resource.
	SimulateSecurityHealthAnalyticsCustomModule(context.Context, *SimulateSecurityHealthAnalyticsCustomModuleRequest) (*SimulateSecurityHealthAnalyticsCustomModuleResponse, error)
	// Lists all effective Event Threat Detection custom modules for the
	// given parent. This includes resident modules defined at the scope of the
	// parent along with modules inherited from its ancestors.
	ListEffectiveEventThreatDetectionCustomModules(context.Context, *ListEffectiveEventThreatDetectionCustomModulesRequest) (*ListEffectiveEventThreatDetectionCustomModulesResponse, error)
	// Gets an effective ETD custom module. Retrieves the effective module at the
	// given level. The difference between an EffectiveCustomModule and a
	// CustomModule is that the fields for an EffectiveCustomModule are computed
	// from ancestors if needed. For example, the enablement_state for a
	// CustomModule can be either ENABLED, DISABLED, or INHERITED. Where as the
	// enablement_state for an EffectiveCustomModule is always computed to ENABLED
	// or DISABLED (the effective enablement_state).
	GetEffectiveEventThreatDetectionCustomModule(context.Context, *GetEffectiveEventThreatDetectionCustomModuleRequest) (*EffectiveEventThreatDetectionCustomModule, error)
	// Lists all Event Threat Detection custom modules for the given
	// Resource Manager parent. This includes resident modules defined at the
	// scope of the parent along with modules inherited from ancestors.
	ListEventThreatDetectionCustomModules(context.Context, *ListEventThreatDetectionCustomModulesRequest) (*ListEventThreatDetectionCustomModulesResponse, error)
	// Lists all resident Event Threat Detection custom modules under the
	// given Resource Manager parent and its descendants.
	ListDescendantEventThreatDetectionCustomModules(context.Context, *ListDescendantEventThreatDetectionCustomModulesRequest) (*ListDescendantEventThreatDetectionCustomModulesResponse, error)
	// Gets an Event Threat Detection custom module.
	GetEventThreatDetectionCustomModule(context.Context, *GetEventThreatDetectionCustomModuleRequest) (*EventThreatDetectionCustomModule, error)
	// Creates a resident Event Threat Detection custom module at the scope of the
	// given Resource Manager parent, and also creates inherited custom modules
	// for all descendants of the given parent. These modules are enabled by
	// default.
	CreateEventThreatDetectionCustomModule(context.Context, *CreateEventThreatDetectionCustomModuleRequest) (*EventThreatDetectionCustomModule, error)
	// Updates the Event Threat Detection custom module with the given name based
	// on the given update mask. Updating the enablement state is supported for
	// both resident and inherited modules (though resident modules cannot have an
	// enablement state of "inherited"). Updating the display name or
	// configuration of a module is supported for resident modules only. The type
	// of a module cannot be changed.
	UpdateEventThreatDetectionCustomModule(context.Context, *UpdateEventThreatDetectionCustomModuleRequest) (*EventThreatDetectionCustomModule, error)
	// Deletes the specified Event Threat Detection custom module and all of its
	// descendants in the Resource Manager hierarchy. This method is only
	// supported for resident custom modules.
	DeleteEventThreatDetectionCustomModule(context.Context, *DeleteEventThreatDetectionCustomModuleRequest) (*emptypb.Empty, error)
	// Validates the given Event Threat Detection custom module.
	ValidateEventThreatDetectionCustomModule(context.Context, *ValidateEventThreatDetectionCustomModuleRequest) (*ValidateEventThreatDetectionCustomModuleResponse, error)
}

// UnimplementedSecurityCenterManagementServer can be embedded to have forward compatible implementations.
type UnimplementedSecurityCenterManagementServer struct {
}

func (*UnimplementedSecurityCenterManagementServer) ListEffectiveSecurityHealthAnalyticsCustomModules(context.Context, *ListEffectiveSecurityHealthAnalyticsCustomModulesRequest) (*ListEffectiveSecurityHealthAnalyticsCustomModulesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListEffectiveSecurityHealthAnalyticsCustomModules not implemented")
}
func (*UnimplementedSecurityCenterManagementServer) GetEffectiveSecurityHealthAnalyticsCustomModule(context.Context, *GetEffectiveSecurityHealthAnalyticsCustomModuleRequest) (*EffectiveSecurityHealthAnalyticsCustomModule, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetEffectiveSecurityHealthAnalyticsCustomModule not implemented")
}
func (*UnimplementedSecurityCenterManagementServer) ListSecurityHealthAnalyticsCustomModules(context.Context, *ListSecurityHealthAnalyticsCustomModulesRequest) (*ListSecurityHealthAnalyticsCustomModulesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListSecurityHealthAnalyticsCustomModules not implemented")
}
func (*UnimplementedSecurityCenterManagementServer) ListDescendantSecurityHealthAnalyticsCustomModules(context.Context, *ListDescendantSecurityHealthAnalyticsCustomModulesRequest) (*ListDescendantSecurityHealthAnalyticsCustomModulesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListDescendantSecurityHealthAnalyticsCustomModules not implemented")
}
func (*UnimplementedSecurityCenterManagementServer) GetSecurityHealthAnalyticsCustomModule(context.Context, *GetSecurityHealthAnalyticsCustomModuleRequest) (*SecurityHealthAnalyticsCustomModule, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetSecurityHealthAnalyticsCustomModule not implemented")
}
func (*UnimplementedSecurityCenterManagementServer) CreateSecurityHealthAnalyticsCustomModule(context.Context, *CreateSecurityHealthAnalyticsCustomModuleRequest) (*SecurityHealthAnalyticsCustomModule, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateSecurityHealthAnalyticsCustomModule not implemented")
}
func (*UnimplementedSecurityCenterManagementServer) UpdateSecurityHealthAnalyticsCustomModule(context.Context, *UpdateSecurityHealthAnalyticsCustomModuleRequest) (*SecurityHealthAnalyticsCustomModule, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateSecurityHealthAnalyticsCustomModule not implemented")
}
func (*UnimplementedSecurityCenterManagementServer) DeleteSecurityHealthAnalyticsCustomModule(context.Context, *DeleteSecurityHealthAnalyticsCustomModuleRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteSecurityHealthAnalyticsCustomModule not implemented")
}
func (*UnimplementedSecurityCenterManagementServer) SimulateSecurityHealthAnalyticsCustomModule(context.Context, *SimulateSecurityHealthAnalyticsCustomModuleRequest) (*SimulateSecurityHealthAnalyticsCustomModuleResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SimulateSecurityHealthAnalyticsCustomModule not implemented")
}
func (*UnimplementedSecurityCenterManagementServer) ListEffectiveEventThreatDetectionCustomModules(context.Context, *ListEffectiveEventThreatDetectionCustomModulesRequest) (*ListEffectiveEventThreatDetectionCustomModulesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListEffectiveEventThreatDetectionCustomModules not implemented")
}
func (*UnimplementedSecurityCenterManagementServer) GetEffectiveEventThreatDetectionCustomModule(context.Context, *GetEffectiveEventThreatDetectionCustomModuleRequest) (*EffectiveEventThreatDetectionCustomModule, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetEffectiveEventThreatDetectionCustomModule not implemented")
}
func (*UnimplementedSecurityCenterManagementServer) ListEventThreatDetectionCustomModules(context.Context, *ListEventThreatDetectionCustomModulesRequest) (*ListEventThreatDetectionCustomModulesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListEventThreatDetectionCustomModules not implemented")
}
func (*UnimplementedSecurityCenterManagementServer) ListDescendantEventThreatDetectionCustomModules(context.Context, *ListDescendantEventThreatDetectionCustomModulesRequest) (*ListDescendantEventThreatDetectionCustomModulesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListDescendantEventThreatDetectionCustomModules not implemented")
}
func (*UnimplementedSecurityCenterManagementServer) GetEventThreatDetectionCustomModule(context.Context, *GetEventThreatDetectionCustomModuleRequest) (*EventThreatDetectionCustomModule, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetEventThreatDetectionCustomModule not implemented")
}
func (*UnimplementedSecurityCenterManagementServer) CreateEventThreatDetectionCustomModule(context.Context, *CreateEventThreatDetectionCustomModuleRequest) (*EventThreatDetectionCustomModule, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateEventThreatDetectionCustomModule not implemented")
}
func (*UnimplementedSecurityCenterManagementServer) UpdateEventThreatDetectionCustomModule(context.Context, *UpdateEventThreatDetectionCustomModuleRequest) (*EventThreatDetectionCustomModule, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateEventThreatDetectionCustomModule not implemented")
}
func (*UnimplementedSecurityCenterManagementServer) DeleteEventThreatDetectionCustomModule(context.Context, *DeleteEventThreatDetectionCustomModuleRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteEventThreatDetectionCustomModule not implemented")
}
func (*UnimplementedSecurityCenterManagementServer) ValidateEventThreatDetectionCustomModule(context.Context, *ValidateEventThreatDetectionCustomModuleRequest) (*ValidateEventThreatDetectionCustomModuleResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ValidateEventThreatDetectionCustomModule not implemented")
}

func RegisterSecurityCenterManagementServer(s *grpc.Server, srv SecurityCenterManagementServer) {
	s.RegisterService(&_SecurityCenterManagement_serviceDesc, srv)
}

func _SecurityCenterManagement_ListEffectiveSecurityHealthAnalyticsCustomModules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEffectiveSecurityHealthAnalyticsCustomModulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterManagementServer).ListEffectiveSecurityHealthAnalyticsCustomModules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/ListEffectiveSecurityHealthAnalyticsCustomModules",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterManagementServer).ListEffectiveSecurityHealthAnalyticsCustomModules(ctx, req.(*ListEffectiveSecurityHealthAnalyticsCustomModulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterManagement_GetEffectiveSecurityHealthAnalyticsCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEffectiveSecurityHealthAnalyticsCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterManagementServer).GetEffectiveSecurityHealthAnalyticsCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/GetEffectiveSecurityHealthAnalyticsCustomModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterManagementServer).GetEffectiveSecurityHealthAnalyticsCustomModule(ctx, req.(*GetEffectiveSecurityHealthAnalyticsCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterManagement_ListSecurityHealthAnalyticsCustomModules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSecurityHealthAnalyticsCustomModulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterManagementServer).ListSecurityHealthAnalyticsCustomModules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/ListSecurityHealthAnalyticsCustomModules",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterManagementServer).ListSecurityHealthAnalyticsCustomModules(ctx, req.(*ListSecurityHealthAnalyticsCustomModulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterManagement_ListDescendantSecurityHealthAnalyticsCustomModules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDescendantSecurityHealthAnalyticsCustomModulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterManagementServer).ListDescendantSecurityHealthAnalyticsCustomModules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/ListDescendantSecurityHealthAnalyticsCustomModules",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterManagementServer).ListDescendantSecurityHealthAnalyticsCustomModules(ctx, req.(*ListDescendantSecurityHealthAnalyticsCustomModulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterManagement_GetSecurityHealthAnalyticsCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSecurityHealthAnalyticsCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterManagementServer).GetSecurityHealthAnalyticsCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/GetSecurityHealthAnalyticsCustomModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterManagementServer).GetSecurityHealthAnalyticsCustomModule(ctx, req.(*GetSecurityHealthAnalyticsCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterManagement_CreateSecurityHealthAnalyticsCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSecurityHealthAnalyticsCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterManagementServer).CreateSecurityHealthAnalyticsCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/CreateSecurityHealthAnalyticsCustomModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterManagementServer).CreateSecurityHealthAnalyticsCustomModule(ctx, req.(*CreateSecurityHealthAnalyticsCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterManagement_UpdateSecurityHealthAnalyticsCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSecurityHealthAnalyticsCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterManagementServer).UpdateSecurityHealthAnalyticsCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/UpdateSecurityHealthAnalyticsCustomModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterManagementServer).UpdateSecurityHealthAnalyticsCustomModule(ctx, req.(*UpdateSecurityHealthAnalyticsCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterManagement_DeleteSecurityHealthAnalyticsCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSecurityHealthAnalyticsCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterManagementServer).DeleteSecurityHealthAnalyticsCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/DeleteSecurityHealthAnalyticsCustomModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterManagementServer).DeleteSecurityHealthAnalyticsCustomModule(ctx, req.(*DeleteSecurityHealthAnalyticsCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterManagement_SimulateSecurityHealthAnalyticsCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SimulateSecurityHealthAnalyticsCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterManagementServer).SimulateSecurityHealthAnalyticsCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/SimulateSecurityHealthAnalyticsCustomModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterManagementServer).SimulateSecurityHealthAnalyticsCustomModule(ctx, req.(*SimulateSecurityHealthAnalyticsCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterManagement_ListEffectiveEventThreatDetectionCustomModules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEffectiveEventThreatDetectionCustomModulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterManagementServer).ListEffectiveEventThreatDetectionCustomModules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/ListEffectiveEventThreatDetectionCustomModules",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterManagementServer).ListEffectiveEventThreatDetectionCustomModules(ctx, req.(*ListEffectiveEventThreatDetectionCustomModulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterManagement_GetEffectiveEventThreatDetectionCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEffectiveEventThreatDetectionCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterManagementServer).GetEffectiveEventThreatDetectionCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/GetEffectiveEventThreatDetectionCustomModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterManagementServer).GetEffectiveEventThreatDetectionCustomModule(ctx, req.(*GetEffectiveEventThreatDetectionCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterManagement_ListEventThreatDetectionCustomModules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEventThreatDetectionCustomModulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterManagementServer).ListEventThreatDetectionCustomModules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/ListEventThreatDetectionCustomModules",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterManagementServer).ListEventThreatDetectionCustomModules(ctx, req.(*ListEventThreatDetectionCustomModulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterManagement_ListDescendantEventThreatDetectionCustomModules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDescendantEventThreatDetectionCustomModulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterManagementServer).ListDescendantEventThreatDetectionCustomModules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/ListDescendantEventThreatDetectionCustomModules",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterManagementServer).ListDescendantEventThreatDetectionCustomModules(ctx, req.(*ListDescendantEventThreatDetectionCustomModulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterManagement_GetEventThreatDetectionCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEventThreatDetectionCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterManagementServer).GetEventThreatDetectionCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/GetEventThreatDetectionCustomModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterManagementServer).GetEventThreatDetectionCustomModule(ctx, req.(*GetEventThreatDetectionCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterManagement_CreateEventThreatDetectionCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEventThreatDetectionCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterManagementServer).CreateEventThreatDetectionCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/CreateEventThreatDetectionCustomModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterManagementServer).CreateEventThreatDetectionCustomModule(ctx, req.(*CreateEventThreatDetectionCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterManagement_UpdateEventThreatDetectionCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEventThreatDetectionCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterManagementServer).UpdateEventThreatDetectionCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/UpdateEventThreatDetectionCustomModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterManagementServer).UpdateEventThreatDetectionCustomModule(ctx, req.(*UpdateEventThreatDetectionCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterManagement_DeleteEventThreatDetectionCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEventThreatDetectionCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterManagementServer).DeleteEventThreatDetectionCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/DeleteEventThreatDetectionCustomModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterManagementServer).DeleteEventThreatDetectionCustomModule(ctx, req.(*DeleteEventThreatDetectionCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenterManagement_ValidateEventThreatDetectionCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateEventThreatDetectionCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterManagementServer).ValidateEventThreatDetectionCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycentermanagement.v1.SecurityCenterManagement/ValidateEventThreatDetectionCustomModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterManagementServer).ValidateEventThreatDetectionCustomModule(ctx, req.(*ValidateEventThreatDetectionCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SecurityCenterManagement_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.securitycentermanagement.v1.SecurityCenterManagement",
	HandlerType: (*SecurityCenterManagementServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListEffectiveSecurityHealthAnalyticsCustomModules",
			Handler:    _SecurityCenterManagement_ListEffectiveSecurityHealthAnalyticsCustomModules_Handler,
		},
		{
			MethodName: "GetEffectiveSecurityHealthAnalyticsCustomModule",
			Handler:    _SecurityCenterManagement_GetEffectiveSecurityHealthAnalyticsCustomModule_Handler,
		},
		{
			MethodName: "ListSecurityHealthAnalyticsCustomModules",
			Handler:    _SecurityCenterManagement_ListSecurityHealthAnalyticsCustomModules_Handler,
		},
		{
			MethodName: "ListDescendantSecurityHealthAnalyticsCustomModules",
			Handler:    _SecurityCenterManagement_ListDescendantSecurityHealthAnalyticsCustomModules_Handler,
		},
		{
			MethodName: "GetSecurityHealthAnalyticsCustomModule",
			Handler:    _SecurityCenterManagement_GetSecurityHealthAnalyticsCustomModule_Handler,
		},
		{
			MethodName: "CreateSecurityHealthAnalyticsCustomModule",
			Handler:    _SecurityCenterManagement_CreateSecurityHealthAnalyticsCustomModule_Handler,
		},
		{
			MethodName: "UpdateSecurityHealthAnalyticsCustomModule",
			Handler:    _SecurityCenterManagement_UpdateSecurityHealthAnalyticsCustomModule_Handler,
		},
		{
			MethodName: "DeleteSecurityHealthAnalyticsCustomModule",
			Handler:    _SecurityCenterManagement_DeleteSecurityHealthAnalyticsCustomModule_Handler,
		},
		{
			MethodName: "SimulateSecurityHealthAnalyticsCustomModule",
			Handler:    _SecurityCenterManagement_SimulateSecurityHealthAnalyticsCustomModule_Handler,
		},
		{
			MethodName: "ListEffectiveEventThreatDetectionCustomModules",
			Handler:    _SecurityCenterManagement_ListEffectiveEventThreatDetectionCustomModules_Handler,
		},
		{
			MethodName: "GetEffectiveEventThreatDetectionCustomModule",
			Handler:    _SecurityCenterManagement_GetEffectiveEventThreatDetectionCustomModule_Handler,
		},
		{
			MethodName: "ListEventThreatDetectionCustomModules",
			Handler:    _SecurityCenterManagement_ListEventThreatDetectionCustomModules_Handler,
		},
		{
			MethodName: "ListDescendantEventThreatDetectionCustomModules",
			Handler:    _SecurityCenterManagement_ListDescendantEventThreatDetectionCustomModules_Handler,
		},
		{
			MethodName: "GetEventThreatDetectionCustomModule",
			Handler:    _SecurityCenterManagement_GetEventThreatDetectionCustomModule_Handler,
		},
		{
			MethodName: "CreateEventThreatDetectionCustomModule",
			Handler:    _SecurityCenterManagement_CreateEventThreatDetectionCustomModule_Handler,
		},
		{
			MethodName: "UpdateEventThreatDetectionCustomModule",
			Handler:    _SecurityCenterManagement_UpdateEventThreatDetectionCustomModule_Handler,
		},
		{
			MethodName: "DeleteEventThreatDetectionCustomModule",
			Handler:    _SecurityCenterManagement_DeleteEventThreatDetectionCustomModule_Handler,
		},
		{
			MethodName: "ValidateEventThreatDetectionCustomModule",
			Handler:    _SecurityCenterManagement_ValidateEventThreatDetectionCustomModule_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/securitycentermanagement/v1/security_center_management.proto",
}
