//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armrecoveryservicesbackup

const (
	moduleName    = "armrecoveryservicesbackup"
	moduleVersion = "v1.0.0"
)

// AcquireStorageAccountLock - Whether storage account lock is to be acquired for this container or not.
type AcquireStorageAccountLock string

const (
	AcquireStorageAccountLockAcquire    AcquireStorageAccountLock = "Acquire"
	AcquireStorageAccountLockNotAcquire AcquireStorageAccountLock = "NotAcquire"
)

// PossibleAcquireStorageAccountLockValues returns the possible values for the AcquireStorageAccountLock const type.
func PossibleAcquireStorageAccountLockValues() []AcquireStorageAccountLock {
	return []AcquireStorageAccountLock{
		AcquireStorageAccountLockAcquire,
		AcquireStorageAccountLockNotAcquire,
	}
}

// AzureFileShareType - File Share type XSync or XSMB.
type AzureFileShareType string

const (
	AzureFileShareTypeInvalid AzureFileShareType = "Invalid"
	AzureFileShareTypeXSMB    AzureFileShareType = "XSMB"
	AzureFileShareTypeXSync   AzureFileShareType = "XSync"
)

// PossibleAzureFileShareTypeValues returns the possible values for the AzureFileShareType const type.
func PossibleAzureFileShareTypeValues() []AzureFileShareType {
	return []AzureFileShareType{
		AzureFileShareTypeInvalid,
		AzureFileShareTypeXSMB,
		AzureFileShareTypeXSync,
	}
}

// BackupEngineType - Type of the backup engine.
type BackupEngineType string

const (
	BackupEngineTypeAzureBackupServerEngine BackupEngineType = "AzureBackupServerEngine"
	BackupEngineTypeDpmBackupEngine         BackupEngineType = "DpmBackupEngine"
	BackupEngineTypeInvalid                 BackupEngineType = "Invalid"
)

// PossibleBackupEngineTypeValues returns the possible values for the BackupEngineType const type.
func PossibleBackupEngineTypeValues() []BackupEngineType {
	return []BackupEngineType{
		BackupEngineTypeAzureBackupServerEngine,
		BackupEngineTypeDpmBackupEngine,
		BackupEngineTypeInvalid,
	}
}

// BackupItemType - Type of backup items associated with this container.
type BackupItemType string

const (
	BackupItemTypeAzureFileShare    BackupItemType = "AzureFileShare"
	BackupItemTypeAzureSQLDb        BackupItemType = "AzureSqlDb"
	BackupItemTypeClient            BackupItemType = "Client"
	BackupItemTypeExchange          BackupItemType = "Exchange"
	BackupItemTypeFileFolder        BackupItemType = "FileFolder"
	BackupItemTypeGenericDataSource BackupItemType = "GenericDataSource"
	BackupItemTypeInvalid           BackupItemType = "Invalid"
	BackupItemTypeSAPAseDatabase    BackupItemType = "SAPAseDatabase"
	BackupItemTypeSAPHanaDatabase   BackupItemType = "SAPHanaDatabase"
	BackupItemTypeSQLDB             BackupItemType = "SQLDB"
	BackupItemTypeSQLDataBase       BackupItemType = "SQLDataBase"
	BackupItemTypeSharepoint        BackupItemType = "Sharepoint"
	BackupItemTypeSystemState       BackupItemType = "SystemState"
	BackupItemTypeVM                BackupItemType = "VM"
	BackupItemTypeVMwareVM          BackupItemType = "VMwareVM"
)

// PossibleBackupItemTypeValues returns the possible values for the BackupItemType const type.
func PossibleBackupItemTypeValues() []BackupItemType {
	return []BackupItemType{
		BackupItemTypeAzureFileShare,
		BackupItemTypeAzureSQLDb,
		BackupItemTypeClient,
		BackupItemTypeExchange,
		BackupItemTypeFileFolder,
		BackupItemTypeGenericDataSource,
		BackupItemTypeInvalid,
		BackupItemTypeSAPAseDatabase,
		BackupItemTypeSAPHanaDatabase,
		BackupItemTypeSQLDB,
		BackupItemTypeSQLDataBase,
		BackupItemTypeSharepoint,
		BackupItemTypeSystemState,
		BackupItemTypeVM,
		BackupItemTypeVMwareVM,
	}
}

// BackupManagementType - Backup management type to execute the current job.
type BackupManagementType string

const (
	BackupManagementTypeAzureBackupServer BackupManagementType = "AzureBackupServer"
	BackupManagementTypeAzureIaasVM       BackupManagementType = "AzureIaasVM"
	BackupManagementTypeAzureSQL          BackupManagementType = "AzureSql"
	BackupManagementTypeAzureStorage      BackupManagementType = "AzureStorage"
	BackupManagementTypeAzureWorkload     BackupManagementType = "AzureWorkload"
	BackupManagementTypeDPM               BackupManagementType = "DPM"
	BackupManagementTypeDefaultBackup     BackupManagementType = "DefaultBackup"
	BackupManagementTypeInvalid           BackupManagementType = "Invalid"
	BackupManagementTypeMAB               BackupManagementType = "MAB"
)

// PossibleBackupManagementTypeValues returns the possible values for the BackupManagementType const type.
func PossibleBackupManagementTypeValues() []BackupManagementType {
	return []BackupManagementType{
		BackupManagementTypeAzureBackupServer,
		BackupManagementTypeAzureIaasVM,
		BackupManagementTypeAzureSQL,
		BackupManagementTypeAzureStorage,
		BackupManagementTypeAzureWorkload,
		BackupManagementTypeDPM,
		BackupManagementTypeDefaultBackup,
		BackupManagementTypeInvalid,
		BackupManagementTypeMAB,
	}
}

// BackupType - Type of backup, viz. Full, Differential, Log or CopyOnlyFull
type BackupType string

const (
	BackupTypeCopyOnlyFull BackupType = "CopyOnlyFull"
	BackupTypeDifferential BackupType = "Differential"
	BackupTypeFull         BackupType = "Full"
	BackupTypeIncremental  BackupType = "Incremental"
	BackupTypeInvalid      BackupType = "Invalid"
	BackupTypeLog          BackupType = "Log"
)

// PossibleBackupTypeValues returns the possible values for the BackupType const type.
func PossibleBackupTypeValues() []BackupType {
	return []BackupType{
		BackupTypeCopyOnlyFull,
		BackupTypeDifferential,
		BackupTypeFull,
		BackupTypeIncremental,
		BackupTypeInvalid,
		BackupTypeLog,
	}
}

// ContainerType - Type of container for filter
type ContainerType string

const (
	ContainerTypeAzureBackupServerContainer             ContainerType = "AzureBackupServerContainer"
	ContainerTypeAzureSQLContainer                      ContainerType = "AzureSqlContainer"
	ContainerTypeAzureWorkloadContainer                 ContainerType = "AzureWorkloadContainer"
	ContainerTypeCluster                                ContainerType = "Cluster"
	ContainerTypeDPMContainer                           ContainerType = "DPMContainer"
	ContainerTypeGenericContainer                       ContainerType = "GenericContainer"
	ContainerTypeIaasVMContainer                        ContainerType = "IaasVMContainer"
	ContainerTypeIaasVMServiceContainer                 ContainerType = "IaasVMServiceContainer"
	ContainerTypeInvalid                                ContainerType = "Invalid"
	ContainerTypeMABContainer                           ContainerType = "MABContainer"
	ContainerTypeMicrosoftClassicComputeVirtualMachines ContainerType = "Microsoft.ClassicCompute/virtualMachines"
	ContainerTypeMicrosoftComputeVirtualMachines        ContainerType = "Microsoft.Compute/virtualMachines"
	ContainerTypeSQLAGWorkLoadContainer                 ContainerType = "SQLAGWorkLoadContainer"
	ContainerTypeStorageContainer                       ContainerType = "StorageContainer"
	ContainerTypeUnknown                                ContainerType = "Unknown"
	ContainerTypeVCenter                                ContainerType = "VCenter"
	ContainerTypeVMAppContainer                         ContainerType = "VMAppContainer"
	ContainerTypeWindows                                ContainerType = "Windows"
)

// PossibleContainerTypeValues returns the possible values for the ContainerType const type.
func PossibleContainerTypeValues() []ContainerType {
	return []ContainerType{
		ContainerTypeAzureBackupServerContainer,
		ContainerTypeAzureSQLContainer,
		ContainerTypeAzureWorkloadContainer,
		ContainerTypeCluster,
		ContainerTypeDPMContainer,
		ContainerTypeGenericContainer,
		ContainerTypeIaasVMContainer,
		ContainerTypeIaasVMServiceContainer,
		ContainerTypeInvalid,
		ContainerTypeMABContainer,
		ContainerTypeMicrosoftClassicComputeVirtualMachines,
		ContainerTypeMicrosoftComputeVirtualMachines,
		ContainerTypeSQLAGWorkLoadContainer,
		ContainerTypeStorageContainer,
		ContainerTypeUnknown,
		ContainerTypeVCenter,
		ContainerTypeVMAppContainer,
		ContainerTypeWindows,
	}
}

// CopyOptions - Options to resolve copy conflicts.
type CopyOptions string

const (
	CopyOptionsCreateCopy     CopyOptions = "CreateCopy"
	CopyOptionsFailOnConflict CopyOptions = "FailOnConflict"
	CopyOptionsInvalid        CopyOptions = "Invalid"
	CopyOptionsOverwrite      CopyOptions = "Overwrite"
	CopyOptionsSkip           CopyOptions = "Skip"
)

// PossibleCopyOptionsValues returns the possible values for the CopyOptions const type.
func PossibleCopyOptionsValues() []CopyOptions {
	return []CopyOptions{
		CopyOptionsCreateCopy,
		CopyOptionsFailOnConflict,
		CopyOptionsInvalid,
		CopyOptionsOverwrite,
		CopyOptionsSkip,
	}
}

// CreateMode - Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
type CreateMode string

const (
	CreateModeDefault CreateMode = "Default"
	CreateModeInvalid CreateMode = "Invalid"
	CreateModeRecover CreateMode = "Recover"
)

// PossibleCreateModeValues returns the possible values for the CreateMode const type.
func PossibleCreateModeValues() []CreateMode {
	return []CreateMode{
		CreateModeDefault,
		CreateModeInvalid,
		CreateModeRecover,
	}
}

// DataMoveLevel - DataMove Level
type DataMoveLevel string

const (
	DataMoveLevelContainer DataMoveLevel = "Container"
	DataMoveLevelInvalid   DataMoveLevel = "Invalid"
	DataMoveLevelVault     DataMoveLevel = "Vault"
)

// PossibleDataMoveLevelValues returns the possible values for the DataMoveLevel const type.
func PossibleDataMoveLevelValues() []DataMoveLevel {
	return []DataMoveLevel{
		DataMoveLevelContainer,
		DataMoveLevelInvalid,
		DataMoveLevelVault,
	}
}

// DataSourceType - Type of workload this item represents.
type DataSourceType string

const (
	DataSourceTypeAzureFileShare    DataSourceType = "AzureFileShare"
	DataSourceTypeAzureSQLDb        DataSourceType = "AzureSqlDb"
	DataSourceTypeClient            DataSourceType = "Client"
	DataSourceTypeExchange          DataSourceType = "Exchange"
	DataSourceTypeFileFolder        DataSourceType = "FileFolder"
	DataSourceTypeGenericDataSource DataSourceType = "GenericDataSource"
	DataSourceTypeInvalid           DataSourceType = "Invalid"
	DataSourceTypeSAPAseDatabase    DataSourceType = "SAPAseDatabase"
	DataSourceTypeSAPHanaDatabase   DataSourceType = "SAPHanaDatabase"
	DataSourceTypeSQLDB             DataSourceType = "SQLDB"
	DataSourceTypeSQLDataBase       DataSourceType = "SQLDataBase"
	DataSourceTypeSharepoint        DataSourceType = "Sharepoint"
	DataSourceTypeSystemState       DataSourceType = "SystemState"
	DataSourceTypeVM                DataSourceType = "VM"
	DataSourceTypeVMwareVM          DataSourceType = "VMwareVM"
)

// PossibleDataSourceTypeValues returns the possible values for the DataSourceType const type.
func PossibleDataSourceTypeValues() []DataSourceType {
	return []DataSourceType{
		DataSourceTypeAzureFileShare,
		DataSourceTypeAzureSQLDb,
		DataSourceTypeClient,
		DataSourceTypeExchange,
		DataSourceTypeFileFolder,
		DataSourceTypeGenericDataSource,
		DataSourceTypeInvalid,
		DataSourceTypeSAPAseDatabase,
		DataSourceTypeSAPHanaDatabase,
		DataSourceTypeSQLDB,
		DataSourceTypeSQLDataBase,
		DataSourceTypeSharepoint,
		DataSourceTypeSystemState,
		DataSourceTypeVM,
		DataSourceTypeVMwareVM,
	}
}

type DayOfWeek string

const (
	DayOfWeekSunday    DayOfWeek = "Sunday"
	DayOfWeekMonday    DayOfWeek = "Monday"
	DayOfWeekTuesday   DayOfWeek = "Tuesday"
	DayOfWeekWednesday DayOfWeek = "Wednesday"
	DayOfWeekThursday  DayOfWeek = "Thursday"
	DayOfWeekFriday    DayOfWeek = "Friday"
	DayOfWeekSaturday  DayOfWeek = "Saturday"
)

// PossibleDayOfWeekValues returns the possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{
		DayOfWeekSunday,
		DayOfWeekMonday,
		DayOfWeekTuesday,
		DayOfWeekWednesday,
		DayOfWeekThursday,
		DayOfWeekFriday,
		DayOfWeekSaturday,
	}
}

// DedupState - Vault Dedup state
type DedupState string

const (
	DedupStateDisabled DedupState = "Disabled"
	DedupStateEnabled  DedupState = "Enabled"
	DedupStateInvalid  DedupState = "Invalid"
)

// PossibleDedupStateValues returns the possible values for the DedupState const type.
func PossibleDedupStateValues() []DedupState {
	return []DedupState{
		DedupStateDisabled,
		DedupStateEnabled,
		DedupStateInvalid,
	}
}

// EncryptionAtRestType - Encryption At Rest Type
type EncryptionAtRestType string

const (
	EncryptionAtRestTypeCustomerManaged  EncryptionAtRestType = "CustomerManaged"
	EncryptionAtRestTypeInvalid          EncryptionAtRestType = "Invalid"
	EncryptionAtRestTypeMicrosoftManaged EncryptionAtRestType = "MicrosoftManaged"
)

// PossibleEncryptionAtRestTypeValues returns the possible values for the EncryptionAtRestType const type.
func PossibleEncryptionAtRestTypeValues() []EncryptionAtRestType {
	return []EncryptionAtRestType{
		EncryptionAtRestTypeCustomerManaged,
		EncryptionAtRestTypeInvalid,
		EncryptionAtRestTypeMicrosoftManaged,
	}
}

// EnhancedSecurityState - Enabled or Disabled.
type EnhancedSecurityState string

const (
	EnhancedSecurityStateDisabled EnhancedSecurityState = "Disabled"
	EnhancedSecurityStateEnabled  EnhancedSecurityState = "Enabled"
	EnhancedSecurityStateInvalid  EnhancedSecurityState = "Invalid"
)

// PossibleEnhancedSecurityStateValues returns the possible values for the EnhancedSecurityState const type.
func PossibleEnhancedSecurityStateValues() []EnhancedSecurityState {
	return []EnhancedSecurityState{
		EnhancedSecurityStateDisabled,
		EnhancedSecurityStateEnabled,
		EnhancedSecurityStateInvalid,
	}
}

// FabricName - Specifies the fabric name - Azure or AD
type FabricName string

const (
	FabricNameAzure   FabricName = "Azure"
	FabricNameInvalid FabricName = "Invalid"
)

// PossibleFabricNameValues returns the possible values for the FabricName const type.
func PossibleFabricNameValues() []FabricName {
	return []FabricName{
		FabricNameAzure,
		FabricNameInvalid,
	}
}

// HTTPStatusCode - HTTP Status Code of the operation.
type HTTPStatusCode string

const (
	HTTPStatusCodeContinue                     HTTPStatusCode = "Continue"
	HTTPStatusCodeSwitchingProtocols           HTTPStatusCode = "SwitchingProtocols"
	HTTPStatusCodeOK                           HTTPStatusCode = "OK"
	HTTPStatusCodeCreated                      HTTPStatusCode = "Created"
	HTTPStatusCodeAccepted                     HTTPStatusCode = "Accepted"
	HTTPStatusCodeNonAuthoritativeInformation  HTTPStatusCode = "NonAuthoritativeInformation"
	HTTPStatusCodeNoContent                    HTTPStatusCode = "NoContent"
	HTTPStatusCodeResetContent                 HTTPStatusCode = "ResetContent"
	HTTPStatusCodePartialContent               HTTPStatusCode = "PartialContent"
	HTTPStatusCodeMultipleChoices              HTTPStatusCode = "MultipleChoices"
	HTTPStatusCodeAmbiguous                    HTTPStatusCode = "Ambiguous"
	HTTPStatusCodeMovedPermanently             HTTPStatusCode = "MovedPermanently"
	HTTPStatusCodeMoved                        HTTPStatusCode = "Moved"
	HTTPStatusCodeFound                        HTTPStatusCode = "Found"
	HTTPStatusCodeRedirect                     HTTPStatusCode = "Redirect"
	HTTPStatusCodeSeeOther                     HTTPStatusCode = "SeeOther"
	HTTPStatusCodeRedirectMethod               HTTPStatusCode = "RedirectMethod"
	HTTPStatusCodeNotModified                  HTTPStatusCode = "NotModified"
	HTTPStatusCodeUseProxy                     HTTPStatusCode = "UseProxy"
	HTTPStatusCodeUnused                       HTTPStatusCode = "Unused"
	HTTPStatusCodeTemporaryRedirect            HTTPStatusCode = "TemporaryRedirect"
	HTTPStatusCodeRedirectKeepVerb             HTTPStatusCode = "RedirectKeepVerb"
	HTTPStatusCodeBadRequest                   HTTPStatusCode = "BadRequest"
	HTTPStatusCodeUnauthorized                 HTTPStatusCode = "Unauthorized"
	HTTPStatusCodePaymentRequired              HTTPStatusCode = "PaymentRequired"
	HTTPStatusCodeForbidden                    HTTPStatusCode = "Forbidden"
	HTTPStatusCodeNotFound                     HTTPStatusCode = "NotFound"
	HTTPStatusCodeMethodNotAllowed             HTTPStatusCode = "MethodNotAllowed"
	HTTPStatusCodeNotAcceptable                HTTPStatusCode = "NotAcceptable"
	HTTPStatusCodeProxyAuthenticationRequired  HTTPStatusCode = "ProxyAuthenticationRequired"
	HTTPStatusCodeRequestTimeout               HTTPStatusCode = "RequestTimeout"
	HTTPStatusCodeConflict                     HTTPStatusCode = "Conflict"
	HTTPStatusCodeGone                         HTTPStatusCode = "Gone"
	HTTPStatusCodeLengthRequired               HTTPStatusCode = "LengthRequired"
	HTTPStatusCodePreconditionFailed           HTTPStatusCode = "PreconditionFailed"
	HTTPStatusCodeRequestEntityTooLarge        HTTPStatusCode = "RequestEntityTooLarge"
	HTTPStatusCodeRequestURITooLong            HTTPStatusCode = "RequestUriTooLong"
	HTTPStatusCodeUnsupportedMediaType         HTTPStatusCode = "UnsupportedMediaType"
	HTTPStatusCodeRequestedRangeNotSatisfiable HTTPStatusCode = "RequestedRangeNotSatisfiable"
	HTTPStatusCodeExpectationFailed            HTTPStatusCode = "ExpectationFailed"
	HTTPStatusCodeUpgradeRequired              HTTPStatusCode = "UpgradeRequired"
	HTTPStatusCodeInternalServerError          HTTPStatusCode = "InternalServerError"
	HTTPStatusCodeNotImplemented               HTTPStatusCode = "NotImplemented"
	HTTPStatusCodeBadGateway                   HTTPStatusCode = "BadGateway"
	HTTPStatusCodeServiceUnavailable           HTTPStatusCode = "ServiceUnavailable"
	HTTPStatusCodeGatewayTimeout               HTTPStatusCode = "GatewayTimeout"
	HTTPStatusCodeHTTPVersionNotSupported      HTTPStatusCode = "HttpVersionNotSupported"
)

// PossibleHTTPStatusCodeValues returns the possible values for the HTTPStatusCode const type.
func PossibleHTTPStatusCodeValues() []HTTPStatusCode {
	return []HTTPStatusCode{
		HTTPStatusCodeContinue,
		HTTPStatusCodeSwitchingProtocols,
		HTTPStatusCodeOK,
		HTTPStatusCodeCreated,
		HTTPStatusCodeAccepted,
		HTTPStatusCodeNonAuthoritativeInformation,
		HTTPStatusCodeNoContent,
		HTTPStatusCodeResetContent,
		HTTPStatusCodePartialContent,
		HTTPStatusCodeMultipleChoices,
		HTTPStatusCodeAmbiguous,
		HTTPStatusCodeMovedPermanently,
		HTTPStatusCodeMoved,
		HTTPStatusCodeFound,
		HTTPStatusCodeRedirect,
		HTTPStatusCodeSeeOther,
		HTTPStatusCodeRedirectMethod,
		HTTPStatusCodeNotModified,
		HTTPStatusCodeUseProxy,
		HTTPStatusCodeUnused,
		HTTPStatusCodeTemporaryRedirect,
		HTTPStatusCodeRedirectKeepVerb,
		HTTPStatusCodeBadRequest,
		HTTPStatusCodeUnauthorized,
		HTTPStatusCodePaymentRequired,
		HTTPStatusCodeForbidden,
		HTTPStatusCodeNotFound,
		HTTPStatusCodeMethodNotAllowed,
		HTTPStatusCodeNotAcceptable,
		HTTPStatusCodeProxyAuthenticationRequired,
		HTTPStatusCodeRequestTimeout,
		HTTPStatusCodeConflict,
		HTTPStatusCodeGone,
		HTTPStatusCodeLengthRequired,
		HTTPStatusCodePreconditionFailed,
		HTTPStatusCodeRequestEntityTooLarge,
		HTTPStatusCodeRequestURITooLong,
		HTTPStatusCodeUnsupportedMediaType,
		HTTPStatusCodeRequestedRangeNotSatisfiable,
		HTTPStatusCodeExpectationFailed,
		HTTPStatusCodeUpgradeRequired,
		HTTPStatusCodeInternalServerError,
		HTTPStatusCodeNotImplemented,
		HTTPStatusCodeBadGateway,
		HTTPStatusCodeServiceUnavailable,
		HTTPStatusCodeGatewayTimeout,
		HTTPStatusCodeHTTPVersionNotSupported,
	}
}

// HealthState - Health State for the backed up item.
type HealthState string

const (
	HealthStateActionRequired  HealthState = "ActionRequired"
	HealthStateActionSuggested HealthState = "ActionSuggested"
	HealthStateInvalid         HealthState = "Invalid"
	HealthStatePassed          HealthState = "Passed"
)

// PossibleHealthStateValues returns the possible values for the HealthState const type.
func PossibleHealthStateValues() []HealthState {
	return []HealthState{
		HealthStateActionRequired,
		HealthStateActionSuggested,
		HealthStateInvalid,
		HealthStatePassed,
	}
}

// HealthStatus - Health status of protected item.
type HealthStatus string

const (
	HealthStatusActionRequired  HealthStatus = "ActionRequired"
	HealthStatusActionSuggested HealthStatus = "ActionSuggested"
	HealthStatusInvalid         HealthStatus = "Invalid"
	HealthStatusPassed          HealthStatus = "Passed"
)

// PossibleHealthStatusValues returns the possible values for the HealthStatus const type.
func PossibleHealthStatusValues() []HealthStatus {
	return []HealthStatus{
		HealthStatusActionRequired,
		HealthStatusActionSuggested,
		HealthStatusInvalid,
		HealthStatusPassed,
	}
}

type IAASVMPolicyType string

const (
	IAASVMPolicyTypeInvalid IAASVMPolicyType = "Invalid"
	IAASVMPolicyTypeV1      IAASVMPolicyType = "V1"
	IAASVMPolicyTypeV2      IAASVMPolicyType = "V2"
)

// PossibleIAASVMPolicyTypeValues returns the possible values for the IAASVMPolicyType const type.
func PossibleIAASVMPolicyTypeValues() []IAASVMPolicyType {
	return []IAASVMPolicyType{
		IAASVMPolicyTypeInvalid,
		IAASVMPolicyTypeV1,
		IAASVMPolicyTypeV2,
	}
}

type InfrastructureEncryptionState string

const (
	InfrastructureEncryptionStateDisabled InfrastructureEncryptionState = "Disabled"
	InfrastructureEncryptionStateEnabled  InfrastructureEncryptionState = "Enabled"
	InfrastructureEncryptionStateInvalid  InfrastructureEncryptionState = "Invalid"
)

// PossibleInfrastructureEncryptionStateValues returns the possible values for the InfrastructureEncryptionState const type.
func PossibleInfrastructureEncryptionStateValues() []InfrastructureEncryptionState {
	return []InfrastructureEncryptionState{
		InfrastructureEncryptionStateDisabled,
		InfrastructureEncryptionStateEnabled,
		InfrastructureEncryptionStateInvalid,
	}
}

// InquiryStatus - Status of protectable item, i.e. InProgress,Succeeded,Failed
type InquiryStatus string

const (
	InquiryStatusFailed  InquiryStatus = "Failed"
	InquiryStatusInvalid InquiryStatus = "Invalid"
	InquiryStatusSuccess InquiryStatus = "Success"
)

// PossibleInquiryStatusValues returns the possible values for the InquiryStatus const type.
func PossibleInquiryStatusValues() []InquiryStatus {
	return []InquiryStatus{
		InquiryStatusFailed,
		InquiryStatusInvalid,
		InquiryStatusSuccess,
	}
}

// IntentItemType - Type of workload this item represents
type IntentItemType string

const (
	IntentItemTypeInvalid                       IntentItemType = "Invalid"
	IntentItemTypeSQLAvailabilityGroupContainer IntentItemType = "SQLAvailabilityGroupContainer"
	IntentItemTypeSQLInstance                   IntentItemType = "SQLInstance"
)

// PossibleIntentItemTypeValues returns the possible values for the IntentItemType const type.
func PossibleIntentItemTypeValues() []IntentItemType {
	return []IntentItemType{
		IntentItemTypeInvalid,
		IntentItemTypeSQLAvailabilityGroupContainer,
		IntentItemTypeSQLInstance,
	}
}

// JobOperationType - Type of operation.
type JobOperationType string

const (
	JobOperationTypeBackup                   JobOperationType = "Backup"
	JobOperationTypeConfigureBackup          JobOperationType = "ConfigureBackup"
	JobOperationTypeCrossRegionRestore       JobOperationType = "CrossRegionRestore"
	JobOperationTypeDeleteBackupData         JobOperationType = "DeleteBackupData"
	JobOperationTypeDisableBackup            JobOperationType = "DisableBackup"
	JobOperationTypeInvalid                  JobOperationType = "Invalid"
	JobOperationTypeRegister                 JobOperationType = "Register"
	JobOperationTypeRestore                  JobOperationType = "Restore"
	JobOperationTypeUnRegister               JobOperationType = "UnRegister"
	JobOperationTypeUndelete                 JobOperationType = "Undelete"
	JobOperationTypeUpdateCustomerManagedKey JobOperationType = "UpdateCustomerManagedKey"
)

// PossibleJobOperationTypeValues returns the possible values for the JobOperationType const type.
func PossibleJobOperationTypeValues() []JobOperationType {
	return []JobOperationType{
		JobOperationTypeBackup,
		JobOperationTypeConfigureBackup,
		JobOperationTypeCrossRegionRestore,
		JobOperationTypeDeleteBackupData,
		JobOperationTypeDisableBackup,
		JobOperationTypeInvalid,
		JobOperationTypeRegister,
		JobOperationTypeRestore,
		JobOperationTypeUnRegister,
		JobOperationTypeUndelete,
		JobOperationTypeUpdateCustomerManagedKey,
	}
}

// JobStatus - Status of the job.
type JobStatus string

const (
	JobStatusCancelled             JobStatus = "Cancelled"
	JobStatusCancelling            JobStatus = "Cancelling"
	JobStatusCompleted             JobStatus = "Completed"
	JobStatusCompletedWithWarnings JobStatus = "CompletedWithWarnings"
	JobStatusFailed                JobStatus = "Failed"
	JobStatusInProgress            JobStatus = "InProgress"
	JobStatusInvalid               JobStatus = "Invalid"
)

// PossibleJobStatusValues returns the possible values for the JobStatus const type.
func PossibleJobStatusValues() []JobStatus {
	return []JobStatus{
		JobStatusCancelled,
		JobStatusCancelling,
		JobStatusCompleted,
		JobStatusCompletedWithWarnings,
		JobStatusFailed,
		JobStatusInProgress,
		JobStatusInvalid,
	}
}

type JobSupportedAction string

const (
	JobSupportedActionInvalid     JobSupportedAction = "Invalid"
	JobSupportedActionCancellable JobSupportedAction = "Cancellable"
	JobSupportedActionRetriable   JobSupportedAction = "Retriable"
)

// PossibleJobSupportedActionValues returns the possible values for the JobSupportedAction const type.
func PossibleJobSupportedActionValues() []JobSupportedAction {
	return []JobSupportedAction{
		JobSupportedActionInvalid,
		JobSupportedActionCancellable,
		JobSupportedActionRetriable,
	}
}

// LastBackupStatus - Last backup operation status. Possible values: Healthy, Unhealthy.
type LastBackupStatus string

const (
	LastBackupStatusHealthy   LastBackupStatus = "Healthy"
	LastBackupStatusIRPending LastBackupStatus = "IRPending"
	LastBackupStatusInvalid   LastBackupStatus = "Invalid"
	LastBackupStatusUnhealthy LastBackupStatus = "Unhealthy"
)

// PossibleLastBackupStatusValues returns the possible values for the LastBackupStatus const type.
func PossibleLastBackupStatusValues() []LastBackupStatus {
	return []LastBackupStatus{
		LastBackupStatusHealthy,
		LastBackupStatusIRPending,
		LastBackupStatusInvalid,
		LastBackupStatusUnhealthy,
	}
}

type LastUpdateStatus string

const (
	LastUpdateStatusFailed              LastUpdateStatus = "Failed"
	LastUpdateStatusFirstInitialization LastUpdateStatus = "FirstInitialization"
	LastUpdateStatusInitialized         LastUpdateStatus = "Initialized"
	LastUpdateStatusInvalid             LastUpdateStatus = "Invalid"
	LastUpdateStatusNotEnabled          LastUpdateStatus = "NotEnabled"
	LastUpdateStatusPartiallyFailed     LastUpdateStatus = "PartiallyFailed"
	LastUpdateStatusPartiallySucceeded  LastUpdateStatus = "PartiallySucceeded"
	LastUpdateStatusSucceeded           LastUpdateStatus = "Succeeded"
)

// PossibleLastUpdateStatusValues returns the possible values for the LastUpdateStatus const type.
func PossibleLastUpdateStatusValues() []LastUpdateStatus {
	return []LastUpdateStatus{
		LastUpdateStatusFailed,
		LastUpdateStatusFirstInitialization,
		LastUpdateStatusInitialized,
		LastUpdateStatusInvalid,
		LastUpdateStatusNotEnabled,
		LastUpdateStatusPartiallyFailed,
		LastUpdateStatusPartiallySucceeded,
		LastUpdateStatusSucceeded,
	}
}

// MabServerType - Server type of MAB container.
type MabServerType string

const (
	MabServerTypeAzureBackupServerContainer MabServerType = "AzureBackupServerContainer"
	MabServerTypeAzureSQLContainer          MabServerType = "AzureSqlContainer"
	MabServerTypeCluster                    MabServerType = "Cluster"
	MabServerTypeDPMContainer               MabServerType = "DPMContainer"
	MabServerTypeGenericContainer           MabServerType = "GenericContainer"
	MabServerTypeIaasVMContainer            MabServerType = "IaasVMContainer"
	MabServerTypeIaasVMServiceContainer     MabServerType = "IaasVMServiceContainer"
	MabServerTypeInvalid                    MabServerType = "Invalid"
	MabServerTypeMABContainer               MabServerType = "MABContainer"
	MabServerTypeSQLAGWorkLoadContainer     MabServerType = "SQLAGWorkLoadContainer"
	MabServerTypeStorageContainer           MabServerType = "StorageContainer"
	MabServerTypeUnknown                    MabServerType = "Unknown"
	MabServerTypeVCenter                    MabServerType = "VCenter"
	MabServerTypeVMAppContainer             MabServerType = "VMAppContainer"
	MabServerTypeWindows                    MabServerType = "Windows"
)

// PossibleMabServerTypeValues returns the possible values for the MabServerType const type.
func PossibleMabServerTypeValues() []MabServerType {
	return []MabServerType{
		MabServerTypeAzureBackupServerContainer,
		MabServerTypeAzureSQLContainer,
		MabServerTypeCluster,
		MabServerTypeDPMContainer,
		MabServerTypeGenericContainer,
		MabServerTypeIaasVMContainer,
		MabServerTypeIaasVMServiceContainer,
		MabServerTypeInvalid,
		MabServerTypeMABContainer,
		MabServerTypeSQLAGWorkLoadContainer,
		MabServerTypeStorageContainer,
		MabServerTypeUnknown,
		MabServerTypeVCenter,
		MabServerTypeVMAppContainer,
		MabServerTypeWindows,
	}
}

type MonthOfYear string

const (
	MonthOfYearInvalid   MonthOfYear = "Invalid"
	MonthOfYearJanuary   MonthOfYear = "January"
	MonthOfYearFebruary  MonthOfYear = "February"
	MonthOfYearMarch     MonthOfYear = "March"
	MonthOfYearApril     MonthOfYear = "April"
	MonthOfYearMay       MonthOfYear = "May"
	MonthOfYearJune      MonthOfYear = "June"
	MonthOfYearJuly      MonthOfYear = "July"
	MonthOfYearAugust    MonthOfYear = "August"
	MonthOfYearSeptember MonthOfYear = "September"
	MonthOfYearOctober   MonthOfYear = "October"
	MonthOfYearNovember  MonthOfYear = "November"
	MonthOfYearDecember  MonthOfYear = "December"
)

// PossibleMonthOfYearValues returns the possible values for the MonthOfYear const type.
func PossibleMonthOfYearValues() []MonthOfYear {
	return []MonthOfYear{
		MonthOfYearInvalid,
		MonthOfYearJanuary,
		MonthOfYearFebruary,
		MonthOfYearMarch,
		MonthOfYearApril,
		MonthOfYearMay,
		MonthOfYearJune,
		MonthOfYearJuly,
		MonthOfYearAugust,
		MonthOfYearSeptember,
		MonthOfYearOctober,
		MonthOfYearNovember,
		MonthOfYearDecember,
	}
}

// OperationStatusValues - Operation status.
type OperationStatusValues string

const (
	OperationStatusValuesCanceled   OperationStatusValues = "Canceled"
	OperationStatusValuesFailed     OperationStatusValues = "Failed"
	OperationStatusValuesInProgress OperationStatusValues = "InProgress"
	OperationStatusValuesInvalid    OperationStatusValues = "Invalid"
	OperationStatusValuesSucceeded  OperationStatusValues = "Succeeded"
)

// PossibleOperationStatusValuesValues returns the possible values for the OperationStatusValues const type.
func PossibleOperationStatusValuesValues() []OperationStatusValues {
	return []OperationStatusValues{
		OperationStatusValuesCanceled,
		OperationStatusValuesFailed,
		OperationStatusValuesInProgress,
		OperationStatusValuesInvalid,
		OperationStatusValuesSucceeded,
	}
}

// OperationType - Re-Do Operation
type OperationType string

const (
	OperationTypeInvalid    OperationType = "Invalid"
	OperationTypeRegister   OperationType = "Register"
	OperationTypeReregister OperationType = "Reregister"
)

// PossibleOperationTypeValues returns the possible values for the OperationType const type.
func PossibleOperationTypeValues() []OperationType {
	return []OperationType{
		OperationTypeInvalid,
		OperationTypeRegister,
		OperationTypeReregister,
	}
}

// OverwriteOptions - Can Overwrite if Target DataBase already exists
type OverwriteOptions string

const (
	OverwriteOptionsFailOnConflict OverwriteOptions = "FailOnConflict"
	OverwriteOptionsInvalid        OverwriteOptions = "Invalid"
	OverwriteOptionsOverwrite      OverwriteOptions = "Overwrite"
)

// PossibleOverwriteOptionsValues returns the possible values for the OverwriteOptions const type.
func PossibleOverwriteOptionsValues() []OverwriteOptions {
	return []OverwriteOptions{
		OverwriteOptionsFailOnConflict,
		OverwriteOptionsInvalid,
		OverwriteOptionsOverwrite,
	}
}

// PolicyType - Type of backup policy type
type PolicyType string

const (
	PolicyTypeCopyOnlyFull PolicyType = "CopyOnlyFull"
	PolicyTypeDifferential PolicyType = "Differential"
	PolicyTypeFull         PolicyType = "Full"
	PolicyTypeIncremental  PolicyType = "Incremental"
	PolicyTypeInvalid      PolicyType = "Invalid"
	PolicyTypeLog          PolicyType = "Log"
)

// PossiblePolicyTypeValues returns the possible values for the PolicyType const type.
func PossiblePolicyTypeValues() []PolicyType {
	return []PolicyType{
		PolicyTypeCopyOnlyFull,
		PolicyTypeDifferential,
		PolicyTypeFull,
		PolicyTypeIncremental,
		PolicyTypeInvalid,
		PolicyTypeLog,
	}
}

// PrivateEndpointConnectionStatus - Gets or sets the status
type PrivateEndpointConnectionStatus string

const (
	PrivateEndpointConnectionStatusApproved     PrivateEndpointConnectionStatus = "Approved"
	PrivateEndpointConnectionStatusDisconnected PrivateEndpointConnectionStatus = "Disconnected"
	PrivateEndpointConnectionStatusPending      PrivateEndpointConnectionStatus = "Pending"
	PrivateEndpointConnectionStatusRejected     PrivateEndpointConnectionStatus = "Rejected"
)

// PossiblePrivateEndpointConnectionStatusValues returns the possible values for the PrivateEndpointConnectionStatus const type.
func PossiblePrivateEndpointConnectionStatusValues() []PrivateEndpointConnectionStatus {
	return []PrivateEndpointConnectionStatus{
		PrivateEndpointConnectionStatusApproved,
		PrivateEndpointConnectionStatusDisconnected,
		PrivateEndpointConnectionStatusPending,
		PrivateEndpointConnectionStatusRejected,
	}
}

// ProtectedItemHealthStatus - Health status of the backup item, evaluated based on last heartbeat received
type ProtectedItemHealthStatus string

const (
	ProtectedItemHealthStatusHealthy      ProtectedItemHealthStatus = "Healthy"
	ProtectedItemHealthStatusIRPending    ProtectedItemHealthStatus = "IRPending"
	ProtectedItemHealthStatusInvalid      ProtectedItemHealthStatus = "Invalid"
	ProtectedItemHealthStatusNotReachable ProtectedItemHealthStatus = "NotReachable"
	ProtectedItemHealthStatusUnhealthy    ProtectedItemHealthStatus = "Unhealthy"
)

// PossibleProtectedItemHealthStatusValues returns the possible values for the ProtectedItemHealthStatus const type.
func PossibleProtectedItemHealthStatusValues() []ProtectedItemHealthStatus {
	return []ProtectedItemHealthStatus{
		ProtectedItemHealthStatusHealthy,
		ProtectedItemHealthStatusIRPending,
		ProtectedItemHealthStatusInvalid,
		ProtectedItemHealthStatusNotReachable,
		ProtectedItemHealthStatusUnhealthy,
	}
}

// ProtectedItemState - Backup state of the backed up item.
type ProtectedItemState string

const (
	ProtectedItemStateIRPending         ProtectedItemState = "IRPending"
	ProtectedItemStateInvalid           ProtectedItemState = "Invalid"
	ProtectedItemStateProtected         ProtectedItemState = "Protected"
	ProtectedItemStateProtectionError   ProtectedItemState = "ProtectionError"
	ProtectedItemStateProtectionPaused  ProtectedItemState = "ProtectionPaused"
	ProtectedItemStateProtectionStopped ProtectedItemState = "ProtectionStopped"
)

// PossibleProtectedItemStateValues returns the possible values for the ProtectedItemState const type.
func PossibleProtectedItemStateValues() []ProtectedItemState {
	return []ProtectedItemState{
		ProtectedItemStateIRPending,
		ProtectedItemStateInvalid,
		ProtectedItemStateProtected,
		ProtectedItemStateProtectionError,
		ProtectedItemStateProtectionPaused,
		ProtectedItemStateProtectionStopped,
	}
}

// ProtectionIntentItemType - backup protectionIntent type.
type ProtectionIntentItemType string

const (
	ProtectionIntentItemTypeAzureResourceItem                          ProtectionIntentItemType = "AzureResourceItem"
	ProtectionIntentItemTypeAzureWorkloadAutoProtectionIntent          ProtectionIntentItemType = "AzureWorkloadAutoProtectionIntent"
	ProtectionIntentItemTypeAzureWorkloadContainerAutoProtectionIntent ProtectionIntentItemType = "AzureWorkloadContainerAutoProtectionIntent"
	ProtectionIntentItemTypeAzureWorkloadSQLAutoProtectionIntent       ProtectionIntentItemType = "AzureWorkloadSQLAutoProtectionIntent"
	ProtectionIntentItemTypeInvalid                                    ProtectionIntentItemType = "Invalid"
	ProtectionIntentItemTypeRecoveryServiceVaultItem                   ProtectionIntentItemType = "RecoveryServiceVaultItem"
)

// PossibleProtectionIntentItemTypeValues returns the possible values for the ProtectionIntentItemType const type.
func PossibleProtectionIntentItemTypeValues() []ProtectionIntentItemType {
	return []ProtectionIntentItemType{
		ProtectionIntentItemTypeAzureResourceItem,
		ProtectionIntentItemTypeAzureWorkloadAutoProtectionIntent,
		ProtectionIntentItemTypeAzureWorkloadContainerAutoProtectionIntent,
		ProtectionIntentItemTypeAzureWorkloadSQLAutoProtectionIntent,
		ProtectionIntentItemTypeInvalid,
		ProtectionIntentItemTypeRecoveryServiceVaultItem,
	}
}

// ProtectionState - Backup state of this backup item.
type ProtectionState string

const (
	ProtectionStateIRPending         ProtectionState = "IRPending"
	ProtectionStateInvalid           ProtectionState = "Invalid"
	ProtectionStateProtected         ProtectionState = "Protected"
	ProtectionStateProtectionError   ProtectionState = "ProtectionError"
	ProtectionStateProtectionPaused  ProtectionState = "ProtectionPaused"
	ProtectionStateProtectionStopped ProtectionState = "ProtectionStopped"
)

// PossibleProtectionStateValues returns the possible values for the ProtectionState const type.
func PossibleProtectionStateValues() []ProtectionState {
	return []ProtectionState{
		ProtectionStateIRPending,
		ProtectionStateInvalid,
		ProtectionStateProtected,
		ProtectionStateProtectionError,
		ProtectionStateProtectionPaused,
		ProtectionStateProtectionStopped,
	}
}

// ProtectionStatus - Specifies whether the container is registered or not
type ProtectionStatus string

const (
	ProtectionStatusInvalid          ProtectionStatus = "Invalid"
	ProtectionStatusNotProtected     ProtectionStatus = "NotProtected"
	ProtectionStatusProtected        ProtectionStatus = "Protected"
	ProtectionStatusProtecting       ProtectionStatus = "Protecting"
	ProtectionStatusProtectionFailed ProtectionStatus = "ProtectionFailed"
)

// PossibleProtectionStatusValues returns the possible values for the ProtectionStatus const type.
func PossibleProtectionStatusValues() []ProtectionStatus {
	return []ProtectionStatus{
		ProtectionStatusInvalid,
		ProtectionStatusNotProtected,
		ProtectionStatusProtected,
		ProtectionStatusProtecting,
		ProtectionStatusProtectionFailed,
	}
}

// ProvisioningState - Gets or sets provisioning state of the private endpoint connection
type ProvisioningState string

const (
	ProvisioningStateDeleting  ProvisioningState = "Deleting"
	ProvisioningStateFailed    ProvisioningState = "Failed"
	ProvisioningStatePending   ProvisioningState = "Pending"
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns the possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{
		ProvisioningStateDeleting,
		ProvisioningStateFailed,
		ProvisioningStatePending,
		ProvisioningStateSucceeded,
	}
}

// RecoveryMode - Defines whether the current recovery mode is file restore or database restore
type RecoveryMode string

const (
	RecoveryModeFileRecovery     RecoveryMode = "FileRecovery"
	RecoveryModeInvalid          RecoveryMode = "Invalid"
	RecoveryModeWorkloadRecovery RecoveryMode = "WorkloadRecovery"
)

// PossibleRecoveryModeValues returns the possible values for the RecoveryMode const type.
func PossibleRecoveryModeValues() []RecoveryMode {
	return []RecoveryMode{
		RecoveryModeFileRecovery,
		RecoveryModeInvalid,
		RecoveryModeWorkloadRecovery,
	}
}

// RecoveryPointTierStatus - Recovery point tier status.
type RecoveryPointTierStatus string

const (
	RecoveryPointTierStatusInvalid    RecoveryPointTierStatus = "Invalid"
	RecoveryPointTierStatusValid      RecoveryPointTierStatus = "Valid"
	RecoveryPointTierStatusDisabled   RecoveryPointTierStatus = "Disabled"
	RecoveryPointTierStatusDeleted    RecoveryPointTierStatus = "Deleted"
	RecoveryPointTierStatusRehydrated RecoveryPointTierStatus = "Rehydrated"
)

// PossibleRecoveryPointTierStatusValues returns the possible values for the RecoveryPointTierStatus const type.
func PossibleRecoveryPointTierStatusValues() []RecoveryPointTierStatus {
	return []RecoveryPointTierStatus{
		RecoveryPointTierStatusInvalid,
		RecoveryPointTierStatusValid,
		RecoveryPointTierStatusDisabled,
		RecoveryPointTierStatusDeleted,
		RecoveryPointTierStatusRehydrated,
	}
}

// RecoveryPointTierType - Recovery point tier type.
type RecoveryPointTierType string

const (
	RecoveryPointTierTypeInvalid    RecoveryPointTierType = "Invalid"
	RecoveryPointTierTypeInstantRP  RecoveryPointTierType = "InstantRP"
	RecoveryPointTierTypeHardenedRP RecoveryPointTierType = "HardenedRP"
	RecoveryPointTierTypeArchivedRP RecoveryPointTierType = "ArchivedRP"
)

// PossibleRecoveryPointTierTypeValues returns the possible values for the RecoveryPointTierType const type.
func PossibleRecoveryPointTierTypeValues() []RecoveryPointTierType {
	return []RecoveryPointTierType{
		RecoveryPointTierTypeInvalid,
		RecoveryPointTierTypeInstantRP,
		RecoveryPointTierTypeHardenedRP,
		RecoveryPointTierTypeArchivedRP,
	}
}

// RecoveryType - Type of this recovery.
type RecoveryType string

const (
	RecoveryTypeAlternateLocation RecoveryType = "AlternateLocation"
	RecoveryTypeInvalid           RecoveryType = "Invalid"
	RecoveryTypeOffline           RecoveryType = "Offline"
	RecoveryTypeOriginalLocation  RecoveryType = "OriginalLocation"
	RecoveryTypeRestoreDisks      RecoveryType = "RestoreDisks"
)

// PossibleRecoveryTypeValues returns the possible values for the RecoveryType const type.
func PossibleRecoveryTypeValues() []RecoveryType {
	return []RecoveryType{
		RecoveryTypeAlternateLocation,
		RecoveryTypeInvalid,
		RecoveryTypeOffline,
		RecoveryTypeOriginalLocation,
		RecoveryTypeRestoreDisks,
	}
}

// RehydrationPriority - Rehydration Priority
type RehydrationPriority string

const (
	RehydrationPriorityHigh     RehydrationPriority = "High"
	RehydrationPriorityStandard RehydrationPriority = "Standard"
)

// PossibleRehydrationPriorityValues returns the possible values for the RehydrationPriority const type.
func PossibleRehydrationPriorityValues() []RehydrationPriority {
	return []RehydrationPriority{
		RehydrationPriorityHigh,
		RehydrationPriorityStandard,
	}
}

// ResourceHealthStatus - Resource Health Status
type ResourceHealthStatus string

const (
	ResourceHealthStatusHealthy             ResourceHealthStatus = "Healthy"
	ResourceHealthStatusInvalid             ResourceHealthStatus = "Invalid"
	ResourceHealthStatusPersistentDegraded  ResourceHealthStatus = "PersistentDegraded"
	ResourceHealthStatusPersistentUnhealthy ResourceHealthStatus = "PersistentUnhealthy"
	ResourceHealthStatusTransientDegraded   ResourceHealthStatus = "TransientDegraded"
	ResourceHealthStatusTransientUnhealthy  ResourceHealthStatus = "TransientUnhealthy"
)

// PossibleResourceHealthStatusValues returns the possible values for the ResourceHealthStatus const type.
func PossibleResourceHealthStatusValues() []ResourceHealthStatus {
	return []ResourceHealthStatus{
		ResourceHealthStatusHealthy,
		ResourceHealthStatusInvalid,
		ResourceHealthStatusPersistentDegraded,
		ResourceHealthStatusPersistentUnhealthy,
		ResourceHealthStatusTransientDegraded,
		ResourceHealthStatusTransientUnhealthy,
	}
}

// RestorePointQueryType - RestorePoint type
type RestorePointQueryType string

const (
	RestorePointQueryTypeAll                 RestorePointQueryType = "All"
	RestorePointQueryTypeDifferential        RestorePointQueryType = "Differential"
	RestorePointQueryTypeFull                RestorePointQueryType = "Full"
	RestorePointQueryTypeFullAndDifferential RestorePointQueryType = "FullAndDifferential"
	RestorePointQueryTypeIncremental         RestorePointQueryType = "Incremental"
	RestorePointQueryTypeInvalid             RestorePointQueryType = "Invalid"
	RestorePointQueryTypeLog                 RestorePointQueryType = "Log"
)

// PossibleRestorePointQueryTypeValues returns the possible values for the RestorePointQueryType const type.
func PossibleRestorePointQueryTypeValues() []RestorePointQueryType {
	return []RestorePointQueryType{
		RestorePointQueryTypeAll,
		RestorePointQueryTypeDifferential,
		RestorePointQueryTypeFull,
		RestorePointQueryTypeFullAndDifferential,
		RestorePointQueryTypeIncremental,
		RestorePointQueryTypeInvalid,
		RestorePointQueryTypeLog,
	}
}

// RestorePointType - Type of restore point
type RestorePointType string

const (
	RestorePointTypeDifferential RestorePointType = "Differential"
	RestorePointTypeFull         RestorePointType = "Full"
	RestorePointTypeIncremental  RestorePointType = "Incremental"
	RestorePointTypeInvalid      RestorePointType = "Invalid"
	RestorePointTypeLog          RestorePointType = "Log"
)

// PossibleRestorePointTypeValues returns the possible values for the RestorePointType const type.
func PossibleRestorePointTypeValues() []RestorePointType {
	return []RestorePointType{
		RestorePointTypeDifferential,
		RestorePointTypeFull,
		RestorePointTypeIncremental,
		RestorePointTypeInvalid,
		RestorePointTypeLog,
	}
}

// RestoreRequestType - Restore Type (FullShareRestore or ItemLevelRestore)
type RestoreRequestType string

const (
	RestoreRequestTypeFullShareRestore RestoreRequestType = "FullShareRestore"
	RestoreRequestTypeInvalid          RestoreRequestType = "Invalid"
	RestoreRequestTypeItemLevelRestore RestoreRequestType = "ItemLevelRestore"
)

// PossibleRestoreRequestTypeValues returns the possible values for the RestoreRequestType const type.
func PossibleRestoreRequestTypeValues() []RestoreRequestType {
	return []RestoreRequestType{
		RestoreRequestTypeFullShareRestore,
		RestoreRequestTypeInvalid,
		RestoreRequestTypeItemLevelRestore,
	}
}

// RetentionDurationType - Retention duration type of retention policy.
type RetentionDurationType string

const (
	RetentionDurationTypeDays    RetentionDurationType = "Days"
	RetentionDurationTypeInvalid RetentionDurationType = "Invalid"
	RetentionDurationTypeMonths  RetentionDurationType = "Months"
	RetentionDurationTypeWeeks   RetentionDurationType = "Weeks"
	RetentionDurationTypeYears   RetentionDurationType = "Years"
)

// PossibleRetentionDurationTypeValues returns the possible values for the RetentionDurationType const type.
func PossibleRetentionDurationTypeValues() []RetentionDurationType {
	return []RetentionDurationType{
		RetentionDurationTypeDays,
		RetentionDurationTypeInvalid,
		RetentionDurationTypeMonths,
		RetentionDurationTypeWeeks,
		RetentionDurationTypeYears,
	}
}

// RetentionScheduleFormat - Retention schedule format type for monthly retention policy.
type RetentionScheduleFormat string

const (
	RetentionScheduleFormatDaily   RetentionScheduleFormat = "Daily"
	RetentionScheduleFormatInvalid RetentionScheduleFormat = "Invalid"
	RetentionScheduleFormatWeekly  RetentionScheduleFormat = "Weekly"
)

// PossibleRetentionScheduleFormatValues returns the possible values for the RetentionScheduleFormat const type.
func PossibleRetentionScheduleFormatValues() []RetentionScheduleFormat {
	return []RetentionScheduleFormat{
		RetentionScheduleFormatDaily,
		RetentionScheduleFormatInvalid,
		RetentionScheduleFormatWeekly,
	}
}

// SQLDataDirectoryType - Type of data directory mapping
type SQLDataDirectoryType string

const (
	SQLDataDirectoryTypeData    SQLDataDirectoryType = "Data"
	SQLDataDirectoryTypeInvalid SQLDataDirectoryType = "Invalid"
	SQLDataDirectoryTypeLog     SQLDataDirectoryType = "Log"
)

// PossibleSQLDataDirectoryTypeValues returns the possible values for the SQLDataDirectoryType const type.
func PossibleSQLDataDirectoryTypeValues() []SQLDataDirectoryType {
	return []SQLDataDirectoryType{
		SQLDataDirectoryTypeData,
		SQLDataDirectoryTypeInvalid,
		SQLDataDirectoryTypeLog,
	}
}

// ScheduleRunType - Frequency of the schedule operation of this policy.
type ScheduleRunType string

const (
	ScheduleRunTypeDaily   ScheduleRunType = "Daily"
	ScheduleRunTypeHourly  ScheduleRunType = "Hourly"
	ScheduleRunTypeInvalid ScheduleRunType = "Invalid"
	ScheduleRunTypeWeekly  ScheduleRunType = "Weekly"
)

// PossibleScheduleRunTypeValues returns the possible values for the ScheduleRunType const type.
func PossibleScheduleRunTypeValues() []ScheduleRunType {
	return []ScheduleRunType{
		ScheduleRunTypeDaily,
		ScheduleRunTypeHourly,
		ScheduleRunTypeInvalid,
		ScheduleRunTypeWeekly,
	}
}

// SoftDeleteFeatureState - Soft Delete feature state
type SoftDeleteFeatureState string

const (
	SoftDeleteFeatureStateDisabled SoftDeleteFeatureState = "Disabled"
	SoftDeleteFeatureStateEnabled  SoftDeleteFeatureState = "Enabled"
	SoftDeleteFeatureStateInvalid  SoftDeleteFeatureState = "Invalid"
)

// PossibleSoftDeleteFeatureStateValues returns the possible values for the SoftDeleteFeatureState const type.
func PossibleSoftDeleteFeatureStateValues() []SoftDeleteFeatureState {
	return []SoftDeleteFeatureState{
		SoftDeleteFeatureStateDisabled,
		SoftDeleteFeatureStateEnabled,
		SoftDeleteFeatureStateInvalid,
	}
}

// StorageType - Storage type
type StorageType string

const (
	StorageTypeGeoRedundant               StorageType = "GeoRedundant"
	StorageTypeInvalid                    StorageType = "Invalid"
	StorageTypeLocallyRedundant           StorageType = "LocallyRedundant"
	StorageTypeReadAccessGeoZoneRedundant StorageType = "ReadAccessGeoZoneRedundant"
	StorageTypeZoneRedundant              StorageType = "ZoneRedundant"
)

// PossibleStorageTypeValues returns the possible values for the StorageType const type.
func PossibleStorageTypeValues() []StorageType {
	return []StorageType{
		StorageTypeGeoRedundant,
		StorageTypeInvalid,
		StorageTypeLocallyRedundant,
		StorageTypeReadAccessGeoZoneRedundant,
		StorageTypeZoneRedundant,
	}
}

// StorageTypeState - Locked or Unlocked. Once a machine is registered against a resource, the storageTypeState is always
// Locked.
type StorageTypeState string

const (
	StorageTypeStateInvalid  StorageTypeState = "Invalid"
	StorageTypeStateLocked   StorageTypeState = "Locked"
	StorageTypeStateUnlocked StorageTypeState = "Unlocked"
)

// PossibleStorageTypeStateValues returns the possible values for the StorageTypeState const type.
func PossibleStorageTypeStateValues() []StorageTypeState {
	return []StorageTypeState{
		StorageTypeStateInvalid,
		StorageTypeStateLocked,
		StorageTypeStateUnlocked,
	}
}

// SupportStatus - Support status of feature
type SupportStatus string

const (
	SupportStatusDefaultOFF   SupportStatus = "DefaultOFF"
	SupportStatusDefaultON    SupportStatus = "DefaultON"
	SupportStatusInvalid      SupportStatus = "Invalid"
	SupportStatusNotSupported SupportStatus = "NotSupported"
	SupportStatusSupported    SupportStatus = "Supported"
)

// PossibleSupportStatusValues returns the possible values for the SupportStatus const type.
func PossibleSupportStatusValues() []SupportStatus {
	return []SupportStatus{
		SupportStatusDefaultOFF,
		SupportStatusDefaultON,
		SupportStatusInvalid,
		SupportStatusNotSupported,
		SupportStatusSupported,
	}
}

// Type - Backup management type for this container.
type Type string

const (
	TypeBackupProtectedItemCountSummary       Type = "BackupProtectedItemCountSummary"
	TypeBackupProtectionContainerCountSummary Type = "BackupProtectionContainerCountSummary"
	TypeInvalid                               Type = "Invalid"
)

// PossibleTypeValues returns the possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{
		TypeBackupProtectedItemCountSummary,
		TypeBackupProtectionContainerCountSummary,
		TypeInvalid,
	}
}

// UsagesUnit - Unit of the usage.
type UsagesUnit string

const (
	UsagesUnitBytes          UsagesUnit = "Bytes"
	UsagesUnitBytesPerSecond UsagesUnit = "BytesPerSecond"
	UsagesUnitCount          UsagesUnit = "Count"
	UsagesUnitCountPerSecond UsagesUnit = "CountPerSecond"
	UsagesUnitPercent        UsagesUnit = "Percent"
	UsagesUnitSeconds        UsagesUnit = "Seconds"
)

// PossibleUsagesUnitValues returns the possible values for the UsagesUnit const type.
func PossibleUsagesUnitValues() []UsagesUnit {
	return []UsagesUnit{
		UsagesUnitBytes,
		UsagesUnitBytesPerSecond,
		UsagesUnitCount,
		UsagesUnitCountPerSecond,
		UsagesUnitPercent,
		UsagesUnitSeconds,
	}
}

// ValidationStatus - Validation Status
type ValidationStatus string

const (
	ValidationStatusFailed    ValidationStatus = "Failed"
	ValidationStatusInvalid   ValidationStatus = "Invalid"
	ValidationStatusSucceeded ValidationStatus = "Succeeded"
)

// PossibleValidationStatusValues returns the possible values for the ValidationStatus const type.
func PossibleValidationStatusValues() []ValidationStatus {
	return []ValidationStatus{
		ValidationStatusFailed,
		ValidationStatusInvalid,
		ValidationStatusSucceeded,
	}
}

type WeekOfMonth string

const (
	WeekOfMonthFirst   WeekOfMonth = "First"
	WeekOfMonthSecond  WeekOfMonth = "Second"
	WeekOfMonthThird   WeekOfMonth = "Third"
	WeekOfMonthFourth  WeekOfMonth = "Fourth"
	WeekOfMonthLast    WeekOfMonth = "Last"
	WeekOfMonthInvalid WeekOfMonth = "Invalid"
)

// PossibleWeekOfMonthValues returns the possible values for the WeekOfMonth const type.
func PossibleWeekOfMonthValues() []WeekOfMonth {
	return []WeekOfMonth{
		WeekOfMonthFirst,
		WeekOfMonthSecond,
		WeekOfMonthThird,
		WeekOfMonthFourth,
		WeekOfMonthLast,
		WeekOfMonthInvalid,
	}
}

// WorkloadItemType - Workload item type of the item for which intent is to be set
type WorkloadItemType string

const (
	WorkloadItemTypeInvalid         WorkloadItemType = "Invalid"
	WorkloadItemTypeSAPAseDatabase  WorkloadItemType = "SAPAseDatabase"
	WorkloadItemTypeSAPAseSystem    WorkloadItemType = "SAPAseSystem"
	WorkloadItemTypeSAPHanaDatabase WorkloadItemType = "SAPHanaDatabase"
	WorkloadItemTypeSAPHanaSystem   WorkloadItemType = "SAPHanaSystem"
	WorkloadItemTypeSQLDataBase     WorkloadItemType = "SQLDataBase"
	WorkloadItemTypeSQLInstance     WorkloadItemType = "SQLInstance"
)

// PossibleWorkloadItemTypeValues returns the possible values for the WorkloadItemType const type.
func PossibleWorkloadItemTypeValues() []WorkloadItemType {
	return []WorkloadItemType{
		WorkloadItemTypeInvalid,
		WorkloadItemTypeSAPAseDatabase,
		WorkloadItemTypeSAPAseSystem,
		WorkloadItemTypeSAPHanaDatabase,
		WorkloadItemTypeSAPHanaSystem,
		WorkloadItemTypeSQLDataBase,
		WorkloadItemTypeSQLInstance,
	}
}

// WorkloadType - Type of workload for the backup management
type WorkloadType string

const (
	WorkloadTypeAzureFileShare    WorkloadType = "AzureFileShare"
	WorkloadTypeAzureSQLDb        WorkloadType = "AzureSqlDb"
	WorkloadTypeClient            WorkloadType = "Client"
	WorkloadTypeExchange          WorkloadType = "Exchange"
	WorkloadTypeFileFolder        WorkloadType = "FileFolder"
	WorkloadTypeGenericDataSource WorkloadType = "GenericDataSource"
	WorkloadTypeInvalid           WorkloadType = "Invalid"
	WorkloadTypeSAPAseDatabase    WorkloadType = "SAPAseDatabase"
	WorkloadTypeSAPHanaDatabase   WorkloadType = "SAPHanaDatabase"
	WorkloadTypeSQLDB             WorkloadType = "SQLDB"
	WorkloadTypeSQLDataBase       WorkloadType = "SQLDataBase"
	WorkloadTypeSharepoint        WorkloadType = "Sharepoint"
	WorkloadTypeSystemState       WorkloadType = "SystemState"
	WorkloadTypeVM                WorkloadType = "VM"
	WorkloadTypeVMwareVM          WorkloadType = "VMwareVM"
)

// PossibleWorkloadTypeValues returns the possible values for the WorkloadType const type.
func PossibleWorkloadTypeValues() []WorkloadType {
	return []WorkloadType{
		WorkloadTypeAzureFileShare,
		WorkloadTypeAzureSQLDb,
		WorkloadTypeClient,
		WorkloadTypeExchange,
		WorkloadTypeFileFolder,
		WorkloadTypeGenericDataSource,
		WorkloadTypeInvalid,
		WorkloadTypeSAPAseDatabase,
		WorkloadTypeSAPHanaDatabase,
		WorkloadTypeSQLDB,
		WorkloadTypeSQLDataBase,
		WorkloadTypeSharepoint,
		WorkloadTypeSystemState,
		WorkloadTypeVM,
		WorkloadTypeVMwareVM,
	}
}

// XcoolState - Vault x-cool state
type XcoolState string

const (
	XcoolStateDisabled XcoolState = "Disabled"
	XcoolStateEnabled  XcoolState = "Enabled"
	XcoolStateInvalid  XcoolState = "Invalid"
)

// PossibleXcoolStateValues returns the possible values for the XcoolState const type.
func PossibleXcoolStateValues() []XcoolState {
	return []XcoolState{
		XcoolStateDisabled,
		XcoolStateEnabled,
		XcoolStateInvalid,
	}
}
