//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsql

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// DatabaseVulnerabilityAssessmentScansClient contains the methods for the DatabaseVulnerabilityAssessmentScans group.
// Don't use this type directly, use NewDatabaseVulnerabilityAssessmentScansClient() instead.
type DatabaseVulnerabilityAssessmentScansClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewDatabaseVulnerabilityAssessmentScansClient creates a new instance of DatabaseVulnerabilityAssessmentScansClient with the specified values.
// subscriptionID - The subscription ID that identifies an Azure subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewDatabaseVulnerabilityAssessmentScansClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*DatabaseVulnerabilityAssessmentScansClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &DatabaseVulnerabilityAssessmentScansClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// Export - Convert an existing scan result to a human readable format. If already exists nothing happens
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// serverName - The name of the server.
// databaseName - The name of the scanned database.
// vulnerabilityAssessmentName - The name of the vulnerability assessment.
// scanID - The vulnerability assessment scan Id.
// options - DatabaseVulnerabilityAssessmentScansClientExportOptions contains the optional parameters for the DatabaseVulnerabilityAssessmentScansClient.Export
// method.
func (client *DatabaseVulnerabilityAssessmentScansClient) Export(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, scanID string, options *DatabaseVulnerabilityAssessmentScansClientExportOptions) (DatabaseVulnerabilityAssessmentScansClientExportResponse, error) {
	req, err := client.exportCreateRequest(ctx, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanID, options)
	if err != nil {
		return DatabaseVulnerabilityAssessmentScansClientExportResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DatabaseVulnerabilityAssessmentScansClientExportResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return DatabaseVulnerabilityAssessmentScansClientExportResponse{}, runtime.NewResponseError(resp)
	}
	return client.exportHandleResponse(resp)
}

// exportCreateRequest creates the Export request.
func (client *DatabaseVulnerabilityAssessmentScansClient) exportCreateRequest(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, scanID string, options *DatabaseVulnerabilityAssessmentScansClientExportOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/export"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if databaseName == "" {
		return nil, errors.New("parameter databaseName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseName}", url.PathEscape(databaseName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if scanID == "" {
		return nil, errors.New("parameter scanID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scanId}", url.PathEscape(scanID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// exportHandleResponse handles the Export response.
func (client *DatabaseVulnerabilityAssessmentScansClient) exportHandleResponse(resp *http.Response) (DatabaseVulnerabilityAssessmentScansClientExportResponse, error) {
	result := DatabaseVulnerabilityAssessmentScansClientExportResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseVulnerabilityAssessmentScansExport); err != nil {
		return DatabaseVulnerabilityAssessmentScansClientExportResponse{}, err
	}
	return result, nil
}

// Get - Gets a vulnerability assessment scan record of a database.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// serverName - The name of the server.
// databaseName - The name of the database.
// vulnerabilityAssessmentName - The name of the vulnerability assessment.
// scanID - The vulnerability assessment scan Id of the scan to retrieve.
// options - DatabaseVulnerabilityAssessmentScansClientGetOptions contains the optional parameters for the DatabaseVulnerabilityAssessmentScansClient.Get
// method.
func (client *DatabaseVulnerabilityAssessmentScansClient) Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, scanID string, options *DatabaseVulnerabilityAssessmentScansClientGetOptions) (DatabaseVulnerabilityAssessmentScansClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanID, options)
	if err != nil {
		return DatabaseVulnerabilityAssessmentScansClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DatabaseVulnerabilityAssessmentScansClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DatabaseVulnerabilityAssessmentScansClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *DatabaseVulnerabilityAssessmentScansClient) getCreateRequest(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, scanID string, options *DatabaseVulnerabilityAssessmentScansClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if databaseName == "" {
		return nil, errors.New("parameter databaseName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseName}", url.PathEscape(databaseName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if scanID == "" {
		return nil, errors.New("parameter scanID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scanId}", url.PathEscape(scanID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *DatabaseVulnerabilityAssessmentScansClient) getHandleResponse(resp *http.Response) (DatabaseVulnerabilityAssessmentScansClientGetResponse, error) {
	result := DatabaseVulnerabilityAssessmentScansClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VulnerabilityAssessmentScanRecord); err != nil {
		return DatabaseVulnerabilityAssessmentScansClientGetResponse{}, err
	}
	return result, nil
}

// BeginInitiateScan - Executes a Vulnerability Assessment database scan.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// serverName - The name of the server.
// databaseName - The name of the database.
// vulnerabilityAssessmentName - The name of the vulnerability assessment.
// scanID - The vulnerability assessment scan Id of the scan to retrieve.
// options - DatabaseVulnerabilityAssessmentScansClientBeginInitiateScanOptions contains the optional parameters for the DatabaseVulnerabilityAssessmentScansClient.BeginInitiateScan
// method.
func (client *DatabaseVulnerabilityAssessmentScansClient) BeginInitiateScan(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, scanID string, options *DatabaseVulnerabilityAssessmentScansClientBeginInitiateScanOptions) (*runtime.Poller[DatabaseVulnerabilityAssessmentScansClientInitiateScanResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.initiateScan(ctx, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanID, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[DatabaseVulnerabilityAssessmentScansClientInitiateScanResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[DatabaseVulnerabilityAssessmentScansClientInitiateScanResponse](options.ResumeToken, client.pl, nil)
	}
}

// InitiateScan - Executes a Vulnerability Assessment database scan.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-11-01-preview
func (client *DatabaseVulnerabilityAssessmentScansClient) initiateScan(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, scanID string, options *DatabaseVulnerabilityAssessmentScansClientBeginInitiateScanOptions) (*http.Response, error) {
	req, err := client.initiateScanCreateRequest(ctx, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanID, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// initiateScanCreateRequest creates the InitiateScan request.
func (client *DatabaseVulnerabilityAssessmentScansClient) initiateScanCreateRequest(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, scanID string, options *DatabaseVulnerabilityAssessmentScansClientBeginInitiateScanOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/initiateScan"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if databaseName == "" {
		return nil, errors.New("parameter databaseName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseName}", url.PathEscape(databaseName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if scanID == "" {
		return nil, errors.New("parameter scanID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scanId}", url.PathEscape(scanID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// NewListByDatabasePager - Lists the vulnerability assessment scans of a database.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// serverName - The name of the server.
// databaseName - The name of the database.
// vulnerabilityAssessmentName - The name of the vulnerability assessment.
// options - DatabaseVulnerabilityAssessmentScansClientListByDatabaseOptions contains the optional parameters for the DatabaseVulnerabilityAssessmentScansClient.ListByDatabase
// method.
func (client *DatabaseVulnerabilityAssessmentScansClient) NewListByDatabasePager(resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, options *DatabaseVulnerabilityAssessmentScansClientListByDatabaseOptions) *runtime.Pager[DatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse] {
	return runtime.NewPager(runtime.PagingHandler[DatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse]{
		More: func(page DatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse) (DatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByDatabaseCreateRequest(ctx, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return DatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return DatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return DatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByDatabaseHandleResponse(resp)
		},
	})
}

// listByDatabaseCreateRequest creates the ListByDatabase request.
func (client *DatabaseVulnerabilityAssessmentScansClient) listByDatabaseCreateRequest(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, options *DatabaseVulnerabilityAssessmentScansClientListByDatabaseOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if databaseName == "" {
		return nil, errors.New("parameter databaseName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseName}", url.PathEscape(databaseName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByDatabaseHandleResponse handles the ListByDatabase response.
func (client *DatabaseVulnerabilityAssessmentScansClient) listByDatabaseHandleResponse(resp *http.Response) (DatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse, error) {
	result := DatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VulnerabilityAssessmentScanRecordListResult); err != nil {
		return DatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse{}, err
	}
	return result, nil
}
