/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */

/* This file is automatically generated using bindtool */

#include <pybind11/complex.h>
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

#include <pmt/pmt_pool.h>
// pydoc.h is automatically generated in the build directory
#include <pmt_pool_pydoc.h>

void bind_pmt_pool(py::module& m)
{

    using pmt_pool = ::pmt::pmt_pool;


    py::class_<pmt_pool, std::shared_ptr<pmt_pool>>(m, "pmt_pool", D(pmt_pool))

        .def(py::init<size_t, size_t, size_t, size_t>(),
             py::arg("itemsize"),
             py::arg("alignment") = 16,
             py::arg("allocation_size") = 4096,
             py::arg("max_items") = 0,
             D(pmt_pool, pmt_pool))


        .def("malloc", &pmt_pool::malloc, D(pmt_pool, malloc))


        .def("free", &pmt_pool::free, py::arg("p"), D(pmt_pool, free));
}
