/*************************************************************************
* Copyright (C) 2002 Intel Corporation
*
* Licensed under the Apache License,  Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* 	http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law  or agreed  to  in  writing,  software
* distributed under  the License  is  distributed  on  an  "AS IS"  BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the  specific  language  governing  permissions  and
* limitations under the License.
*************************************************************************/

#ifndef IFMA_ECPRECOMP4_P521_H
#define IFMA_ECPRECOMP4_P521_H

#include <internal/ecnist/ifma_ecpoint_p521.h>

#if (_MBX >= _MBX_K1)

#define MUL_BASEPOINT_WIN_SIZE (4)

#define BP_WIN_SIZE MUL_BASEPOINT_WIN_SIZE
#define BP_N_SLOTS  NUMBER_OF_DIGITS(P521_BITSIZE + 1, BP_WIN_SIZE)
#define BP_N_ENTRY  (1 << (BP_WIN_SIZE - 1))

/* clang-format off */
__ALIGN64 static SINGLE_P521_POINT_AFFINE ifma_ec_nistp521_bp_precomp[][BP_N_ENTRY] = {
{   /* digit=0 [{1,2,3,..,}]*([2^0]*G)  */
    {{0x00031a16381adc10,0x000f3f18e172deb3,0x000e0c2b5214dfcb,0x00017fd46f19a459,0x000ac947f0ee093d,0x000d50a5af3bf7f3,0x0001457b035a69ed,0x00009c829fda90fc,0x00011cada214e324,0x000274e6cf1f65b3,0x0000000000000000}, {0x000460e4a5a9e268,0x000f4a3b4fe8b328,0x0004351396120445,0x000fd683b09a9e38,0x000132062a85c809,0x00064bf7394caf7a,0x000d7de8b939f331,0x000224abcda2340b,0x000163e8deccc7aa,0x000de0022e452fda,0x0000000000000001}},
    {{0x00090cf08640909d,0x000f1c99dd36bc1e,0x000b26b07ecb3fa1,0x000ae2d7a0e797d1,0x000aa83d508251d1,0x000bd9d9026d377a,0x000372a82ebb4df4,0x0003cd8e66031a96,0x000a461413a3a019,0x000f3f3417e59440,0x0000000000000001}, {0x0003d2ee331fe1b6,0x0001ab6b30fa0d81,0x0004af6e07a7b8df,0x000d19247a757e5f,0x0008fb5c9c9bfd4c,0x000dd9f1bbef4f92,0x00090d14c836216d,0x00083e26d4bba055,0x0007769f85ae35a8,0x0009338053f9f677,0x0000000000000001}},
    {{0x000e9cf4d4910f78,0x0008ce976f1bd6be,0x0004316197502d2c,0x000acff10dd75a48,0x00019028ed35e8b5,0x0008d69f8b251d24,0x000d6bd0896bd46e,0x00072d891ecd5cf2,0x0005acaca3cda953,0x00048caeec8eb532,0x0000000000000001}, {0x000cfa6c0ee5f7e9,0x000c4650f7436072,0x000de49d2c8212fa,0x000f61e3867882e4,0x000bad816ad6768e,0x00061716ea67c6e2,0x0007c558fd1aae77,0x000fd4154e818be9,0x000655c0a7978aab,0x00016eeccbcfc363,0x0000000000000001}},
    {{0x0008d6d77d92b8ab,0x00043a09438c8179,0x0002d8472d2f17de,0x0003c5783350ea81,0x00083a8745c474f8,0x0006432cf1257f1e,0x00062eaaaa0e9e75,0x00048e2ff9cd7e03,0x0003e483866e30e4,0x00010261aa5a41a4,0x0000000000000000}, {0x000a0825be109849,0x000fa3fe1a372686,0x00078234ce8ecf10,0x0004adc2f75dbfd7,0x000c2a029127ba85,0x00093cf941f2a5d1,0x000731ff178cc83f,0x00077b7371970dad,0x000585a55db2a90d,0x000ce95b39f00bc7,0x0000000000000001}},
    {{0x000194afcf14a49e,0x0005a84b7647983c,0x000f36c498b9c6ad,0x0009bf3cd194ebf0,0x0000a11b8897f578,0x00021c1e0636af18,0x00081ed5c78bbd67,0x00077eda9f869267,0x000e027585fbd2cb,0x000219639ede19c8,0x0000000000000001}, {0x000d6f9bbc6f7598,0x000e61f46f584865,0x00092b9aa7bfc0b9,0x000e7affbce8f803,0x00079ba188aa0108,0x0003ddb44be48396,0x000ec0be4d01a384,0x000f4743970028f6,0x000a54089488e6c7,0x0000eb764515b988,0x0000000000000000}},
    {{0x000fb915a75b36d6,0x00098df6fbc9035c,0x000ab2bf9c05711b,0x000a98df4617b374,0x000b9ca70393d11c,0x00092fde650b0a9f,0x0000a8356f25580a,0x00084bbfeb8e79cc,0x000a24068cab11e9,0x00090ca9977f9a7c,0x0000000000000000}, {0x000f780956b43319,0x000666bc2c6a278b,0x0005aae506d6f0f5,0x00013a79101ee3dc,0x000464efcb64c26f,0x000b655b96872b32,0x000205493100d454,0x000db9ed2d404739,0x000a371d8889555d,0x0007ac35716e9382,0x0000000000000000}},
    {{0x00015b574766756d,0x000756c4140b766a,0x000a87ee130cd00e,0x000e71dde237ca9f,0x0004c6c64d36f986,0x000ec61846855fe3,0x0000c69617b88a62,0x0000747aa4191478,0x00005839d062f917,0x000fb1a3775b2fed,0x0000000000000001}, {0x0008f4b46df66eaa,0x0005c5e48292928d,0x000952eef7e3dae3,0x0008e70d2fcf3b38,0x0004f15ca91d1a2c,0x000ab5e87949e6f6,0x000edecc51365ef2,0x0001681412786eb8,0x0001ceb423c5ae2c,0x0001508868ec18bd,0x0000000000000001}},
    {{0x0000208b103ed8c0,0x000cf52a553c6734,0x000dad37a0202c37,0x00046bcf0d5ab144,0x000a4f845acc60de,0x0007adff52dc2bcf,0x000c51d82fc1314c,0x000ec54d801f0545,0x0005808712dea714,0x000fb931541a41cb,0x0000000000000000}, {0x00058cc64475550b,0x000b21788f8bc00e,0x000a004a389a9c56,0x0002e2bc34cf9dd4,0x000da5ff85d06f83,0x0008c4f4e0552c88,0x00041ef30833bd47,0x0006f4f16038ada8,0x0003c429dcd227c7,0x000e2410247ed5b7,0x0000000000000001}},
},
{   /* digit=1 [{1,2,3,..,}]*([2^4]*G)  */
    {{0x000f45f44362a272,0x00062847c0d42017,0x0004003ee6e299d3,0x000c2b186f86dfae,0x000005072cb2ed3c,0x00094a1ff8c430e5,0x000197c69058c452,0x000b30c97e9f9eeb,0x000563a1d859543f,0x0005682eed4bed13,0x0000000000000000}, {0x0001e8dcd0f160b5,0x0001397c4de39d5f,0x00069468c3199a97,0x000eccc4294f1802,0x000a3d505983ad64,0x0000e0c1709cc6da,0x000e51864a5b5c16,0x000261dc006a8763,0x0009e9f34b9099af,0x000b800fe38a58c6,0x0000000000000001}},
    {{0x00059ae8d65b4828,0x0008ad5c3b72b54f,0x000ae6b62e3c123c,0x000d2e8fca4e7ba3,0x000cb7633eb4deb5,0x000b750251aee39a,0x000d3f677dcf2f5e,0x000b32a703401c6d,0x000a5d0ad9a1f1f0,0x000d234a21b83d7c,0x0000000000000001}, {0x00011dec3fd34650,0x00054d4c8a50ab55,0x000b2d5cb0b1b4ae,0x0005079b6fe6cc64,0x000eb5cdba6f0e3f,0x000ef10266dc0c66,0x000ef80e32e16ebb,0x000c5faff80cb3e0,0x000f9f041347fbde,0x00055c088b1af3af,0x0000000000000000}},
    {{0x000fecd778ec8555,0x00013eb0956c3cd6,0x0005e90a57516438,0x0007f84773320ba9,0x000dfd66f6e10d88,0x000a16d04c079fb7,0x0009e6452c01f397,0x0006b339081619a5,0x00076316466573eb,0x000a315640ac72e5,0x0000000000000001}, {0x000e34d296b0561e,0x000ac0c9e92b6a35,0x000402420e573d8c,0x000d871e142cb792,0x000bf1bdbe0a1707,0x000d7310a6b250ec,0x000894a7b366170d,0x000fe4a684f16643,0x00025d9fae0bb793,0x000c96f6d42adcf6,0x0000000000000000}},
    {{0x0006ae6a85f73844,0x000ee1c671907ba1,0x000014d027ea0da9,0x0001f3800efad55c,0x0001bb9d3e0160b0,0x00038df5e9e2f7ed,0x0000a5ce67c43969,0x000dd40c305dd65b,0x000c97f61533f5ed,0x00097668a79ebe01,0x0000000000000000}, {0x0009d235c3ae123a,0x0008b82c52fc6fad,0x000edd0329eea2d7,0x0007cac021e0e0d2,0x000a5887a53dcf1d,0x0005d60b2dd0a846,0x00031dd1b4f43d5c,0x00064597d8ee0e86,0x0002bdcac36cdd8e,0x000902b9d50810be,0x0000000000000000}},
    {{0x0002ff15cc9efbda,0x000d0adea1bf15e4,0x000712003c28f70c,0x0009acbb183fe29d,0x000e35ff46058b74,0x0000e6fbe9505c1f,0x000949d4ed7c586f,0x0006bc96db22c518,0x000e9fa6b4caa767,0x0006b3b723ba4dae,0x0000000000000000}, {0x000d4a1dbb01ce30,0x0002733373d1589b,0x000695b9bd79abea,0x00024c417444789b,0x000a3e366b3687f5,0x00018eccb8e87edb,0x0007fa4355949d4f,0x0003b1b5225855c5,0x00040d600e111ea7,0x0002ca9912224327,0x0000000000000000}},
    {{0x0001ccaa77955b13,0x000980cc45066e57,0x00005f6f02b3f9b1,0x000f381f6757639e,0x000d14e03775ce84,0x000770c3535ef348,0x0000c573845ff7f4,0x0007edbd50365fb5,0x000ae96135b16a31,0x000b1cbda8a1cae0,0x0000000000000000}, {0x000fb5af8ac6debc,0x000ccace499e422e,0x000f85f9a34dea5d,0x00099ffe8fc76f8d,0x000700f62f621078,0x00048a20afbdb94b,0x000353ffe99ecf56,0x0009d5421253436c,0x000d53ffd3fcac92,0x000092a9413337e3,0x0000000000000000}},
    {{0x000cc6739bc22034,0x0002d46c578a3cfb,0x00074dd1918f2158,0x000820e4ee32d9c8,0x000ee4769c451119,0x000a52dc0b788cd9,0x000ea08ad1dce239,0x000e6c51ce30fbf6,0x000c6808b739646f,0x00014612aa8ed807,0x0000000000000000}, {0x00084f57ce386096,0x00001bd8dd33a19d,0x0006d6cf7616b3bf,0x000aa0ec8a31fd3f,0x0000f33cd7d20cf3,0x000d8c7b490a7ae4,0x0003afd25187398f,0x0001d4b82d520c24,0x00008bc63a1c99f6,0x000da20702f937af,0x0000000000000000}},
    {{0x0005f3504967c9f8,0x00081372b9b7d4f0,0x00090711a09dabb5,0x00052fc0a79713f3,0x0008ebea8efb840b,0x000ba724a4b43b13,0x00089257bae703ec,0x000c5de16b6e9669,0x000a9811fd41e4b4,0x000c0fc1b18e0380,0x0000000000000001}, {0x0009bdb977d41aa0,0x00084a0964efd898,0x000049a3954725e1,0x0002567309871a1a,0x000d6462734e1923,0x0004d24ffa586e4c,0x000a7d5e1d8d7ce5,0x000f69f3efbcb30d,0x0007de3d3416e700,0x00041ee729987fef,0x0000000000000001}},
},
{   /* digit=2 [{1,2,3,..,}]*([2^8]*G)  */
    {{0x000757d0283c0ad6,0x000745c834df0056,0x000e5caf285c0d9c,0x000faea391f23599,0x000232d4e48a9620,0x0009bdc7a7b74615,0x0002fd4f47934e59,0x000c4f65ada3d4dc,0x0000798974c81e39,0x00061064a2c57e3c,0x0000000000000001}, {0x000a38d40ea9cd04,0x00060922a435ef3f,0x000a826a53bc247d,0x000e94d33d8a1866,0x000de75ac695cced,0x000bcb2e7b2b9c71,0x00016e1d52b9aa78,0x000540f2da2b1a83,0x000881db4e2a0769,0x000e217e4c0ddd49,0x0000000000000001}},
    {{0x0008396a04a1a9b5,0x00071e1d4dea3fc9,0x000f1b1b60428524,0x000875279e270a42,0x00031e46c1327bff,0x000c05c823fe0222,0x0001988e4c1b07ef,0x000346e86dbfa458,0x000ea14d7c3803e0,0x0002698c2f4163f3,0x0000000000000001}, {0x0004df73f1c64b3b,0x000bae3f77cba047,0x0009fac52f482f0e,0x00046303eabe2a5c,0x000605a86c7774d0,0x0006157561d8716f,0x0006dae76cfe4cf1,0x0006f10528e0564b,0x0008d8ad69113bb2,0x000c2f933ccc8b87,0x0000000000000000}},
    {{0x000963cd234bdeab,0x0005b961fb152043,0x000192d80595fa4f,0x00021e095276439a,0x000ab3cdd8200acb,0x000b977cb97a7564,0x000f1ac5e95df534,0x000082ed91f8da63,0x0005eeb0ff149253,0x000e11676ac3e35f,0x0000000000000001}, {0x0001cccbb8a0782c,0x0008ef764987a4d5,0x000621e7649cd3df,0x0006ca705ffe9912,0x000d887d63f6769b,0x000a2f7ad40e5963,0x00074e3b9fc2e426,0x000bd597aa3dacd3,0x0000fea916df09cd,0x000c4db4a1b5ffeb,0x0000000000000000}},
    {{0x0006312ffff6fab5,0x0006b5b394c36d7c,0x000ae9f8123d8c52,0x0007a4616b7fb3e1,0x000a92d9f22f9728,0x00095d4a0fd21b31,0x0002d23d7cbfded8,0x000b5c10574881ff,0x000e2bd04e830bd0,0x000fd69dfeb7774f,0x0000000000000000}, {0x000b243fcf68f023,0x00066b7e7441cd83,0x0005c91b009a23e1,0x000f85c785f70865,0x0002122e7768c122,0x000fb751856db403,0x0001836d6df94b82,0x000098df3edc80b3,0x000298e9aeea7ce8,0x0006e6048ecb9605,0x0000000000000001}},
    {{0x000cad0b80b053c4,0x000883158e365644,0x0001acd6f66175a4,0x00078eba00f9062c,0x0000f302446bdc8b,0x0004ffcc5c874a3b,0x0001cc9e542baabd,0x000ca8d66f56fe73,0x000fec6e656e27fc,0x0000e12576ad29e3,0x0000000000000000}, {0x000f2114ad6a5008,0x000ff37b5e9ff077,0x000fe609c9e85ddc,0x000612f68cb97937,0x00035cc97418d8cb,0x000e6da8506bf5e6,0x0001561e4122e23c,0x00026ba1b08bd010,0x0007eb4a708cbd94,0x0000c9d309deaf41,0x0000000000000001}},
    {{0x0001bba765fa9bcf,0x0003babdc21b3ff6,0x00025b55117dbb2e,0x000cd85081bffb4d,0x00081cb8cbfa61b2,0x000244b920db891a,0x000db06e819df932,0x000532ca257bcc77,0x000ade96bb81f698,0x000552846b3d2e5e,0x0000000000000000}, {0x000cc4965acbbc52,0x00019fc3317e41d4,0x000a394d289bf4a3,0x000dfcc926b6b451,0x00099fdc4795a3bb,0x000fbdeb87e6005a,0x000e9db4adbdc0b3,0x00050e680b14c0a6,0x000a1f2811642efe,0x000396ef97cb540f,0x0000000000000000}},
    {{0x0005f3ef0a7bd1f0,0x000acae8e898fb4a,0x000ba953fee10eac,0x000ac34b13e74541,0x000d80a4f317458b,0x000699b6bc22b700,0x0009d659b3752d47,0x000972beec5644da,0x00015e14a99a228f,0x0008731fa64678ce,0x0000000000000000}, {0x00076f9ee24a5ff4,0x0001761a3d49abfd,0x000099dc50257cde,0x000182905bef244d,0x000f586d9a90e6d1,0x0007ebb4cb4857b6,0x00070d79d0a32ad0,0x0004bfe6c4dca5d6,0x0009e03cd5b7b143,0x00028c04a0538f51,0x0000000000000001}},
    {{0x000c6fc14a74584c,0x000402292021e48e,0x0009500ecd0a9680,0x00002339ed719b16,0x000ebb81e8a19412,0x00040e8e4db85440,0x0002a313f6a53c2d,0x00082796c5c684a1,0x000636765497c008,0x00020c751837b791,0x0000000000000000}, {0x000740897b89a933,0x000f39feb6c7cfd4,0x0006675504305fd0,0x000708d724da0165,0x0003fcde5846c915,0x000cbcc847c7bb1c,0x00035875d5c58a40,0x000f531dd999d009,0x000ff3f98178ab52,0x000a7c4485d31888,0x0000000000000000}},
},
{   /* digit=3 [{1,2,3,..,}]*([2^12]*G)  */
    {{0x000bc092fe2354e8,0x000850a2f27fd64d,0x0002ad51407fff03,0x000808402ffc14aa,0x0007fbe516b67c4b,0x000f027098449910,0x0009af3715688b40,0x000dbddce7795e2c,0x0008a5dc626ec8f7,0x00032acc9e1305cc,0x0000000000000001}, {0x00014a5956e30ed0,0x000921ce664e13cd,0x000b7485d5a678ff,0x0001d65fed6fe685,0x000152b7d0453dd6,0x0001e48dc7a066d9,0x00012560c3395f08,0x000d6053e587c1cb,0x00076afca630f2cd,0x000814f0d70553c7,0x0000000000000001}},
    {{0x000a19c3686b1f78,0x0009545540d3da61,0x000fed5fc9dde90b,0x0009be8908cbe546,0x0002b931292ec657,0x000e0b221531c8bf,0x0003dcf64709233d,0x0006a91e2913f0e3,0x0003880d89929920,0x000d07ab37b02493,0x0000000000000000}, {0x000b1d587081c0df,0x00062b5f29f3ee6e,0x00013755e246f468,0x000c2e51e2652ae3,0x00046ba6a65e2952,0x000fd1b792013b94,0x00049175e7bffb43,0x000166af7dd896a1,0x0003d0d5f68a4101,0x0003a34ff29cf955,0x0000000000000000}},
    {{0x000b9e5f2e5de279,0x0006be9e4c557ee8,0x000c510883da6331,0x00016eedfba63955,0x000b55eba66cb586,0x000d93dd071f901b,0x0000d11e4c33f467,0x00029c2288bdd752,0x000f22d4f3c9b728,0x000416f979cce9a3,0x0000000000000000}, {0x000f91fa66b3408c,0x0009041780ab3969,0x0001e17f9e99f2b3,0x0002825a0408a22e,0x00013e814b39af10,0x00017c70c14077db,0x000fd91116e8d047,0x00025157bba11642,0x0003d53fd072760c,0x000130f596860d22,0x0000000000000001}},
    {{0x000ddddf5d1e5c64,0x000b39631d236577,0x0005fc5e812c4b6d,0x000ec807d1cccab0,0x0002c8729f1a1c38,0x000999e4061629e9,0x00088f56b4c00d1c,0x000c3cac8f29781d,0x000b02141cce3380,0x000920c7e0e0cc16,0x0000000000000001}, {0x000234580d88382b,0x000b0ad02da7d076,0x000cc82cf5ae2d27,0x0008a15c3adad7f2,0x0004d7009305d2c0,0x000e9e632a55fa7b,0x00011560b55b693d,0x0008b565732e2a82,0x000f0adb63788cf9,0x00038e2d1f605489,0x0000000000000001}},
    {{0x00007e33611831c8,0x00062ce163c826e6,0x0001c1873d3e07b5,0x000df7813a79a532,0x0007451a6bebf65d,0x000789f014abc3f1,0x000cc2aa01512853,0x000bc25e7cee2985,0x000dd32f61a13543,0x000f9b061a57a2a5,0x0000000000000000}, {0x0003734e520ae3c4,0x00041544fe045295,0x000321b2f9da98d0,0x0004ac066f5c4118,0x0004f9ed8d4d338c,0x000c2ea3577c3f4a,0x000a775eee973782,0x000efa3a3176188c,0x000aa0ec53f7823f,0x0009b227eec20996,0x0000000000000000}},
    {{0x000cab486125bb6b,0x000ce02028378ff0,0x0005e625f7d1c380,0x000dc7cec93bc7c0,0x000d0c3b6e1a5a67,0x0001da033baa95ac,0x000e0b126ba3c688,0x0005b900f71e6919,0x000cfb69d4bcab68,0x00090d9f859cecf3,0x0000000000000001}, {0x00030307c7f8906c,0x0006bf1f14afae02,0x00001d0c8e70d7c3,0x00031fcdd396a945,0x00035972de152221,0x0001149c59aa6c9c,0x000e743c53f3251e,0x00072a17186bca64,0x000bae52281f6178,0x000c98982b2d35fe,0x0000000000000001}},
    {{0x000abaada33bf5eb,0x000334cbe9475074,0x000503921efaf87b,0x0001a3119b05ca55,0x000a4fa919940136,0x000a8bd8f158f3c3,0x0002e855587cab4c,0x000fd133003309bc,0x000a468f055eab49,0x0008de65f435935f,0x0000000000000001}, {0x0005a479ed62ca37,0x00046fb6c0237009,0x000c6558be89daa3,0x000e86cd9c606b6e,0x000dcb5426f2b48f,0x0002744bfa702fd9,0x000e9ceab7372571,0x000cd8bef4768a91,0x000d361ea2d4f5d1,0x0000ca847b5f94d5,0x0000000000000001}},
    {{0x000c6a7b65b21bde,0x000fc723a29c73b0,0x000392643c39c3ea,0x0000b213f81be3c4,0x000e3ec734fa388c,0x000b26d37a33b98a,0x000332e230742689,0x000e28354ec1687a,0x0000d4b7e6935b64,0x000ba79d55aecff6,0x0000000000000000}, {0x000073362910afa1,0x0007fb8bcd336bd6,0x000b6c7a7845b5f6,0x000017305633e845,0x00076a907be72df6,0x000e65734d2814a5,0x000f113c7084b86f,0x000cd7bad9f20758,0x000f6af2a5030c22,0x0001647ff1cabc3e,0x0000000000000001}},
},
{   /* digit=4 [{1,2,3,..,}]*([2^16]*G)  */
    {{0x00084cce9eb37269,0x000406ac65525f61,0x000c9acc4f25051a,0x0007bdd2651c4a44,0x00059571fa6bdb63,0x000cf1489d2ae9ce,0x000a821f56bdf324,0x0000e5fa827f61b0,0x00046a2449dcea62,0x000c947027c9ed4b,0x0000000000000001}, {0x00095f1c50d4d450,0x0002c227a410cd04,0x000bc9ba135ee643,0x0004257073536858,0x0000b7e39c350531,0x00016eeb65d0616e,0x000e949a694a0693,0x00069aba0dc455bb,0x000d36d721f9d7b7,0x000a041dcb7a1d32,0x0000000000000000}},
    {{0x00030d330fc15e51,0x0006a88312448f9b,0x00027c12fd1499ca,0x000b765eaf5a132e,0x0008d01b2d2a5c3f,0x000e3517c807951a,0x000936a97c68ed6c,0x000f8cdd161ce67d,0x0005d9876ad5eb28,0x0009976496ac4a79,0x0000000000000001}, {0x000d912524de7c0e,0x0001e66e4dff627f,0x000a96a9194e4460,0x000ccae884a673b1,0x0005d06054966f81,0x00032269452eba8c,0x000ba7677e70b535,0x000298891e5c17de,0x000f9a70e2fe55a9,0x0004d48b39032dcc,0x0000000000000001}},
    {{0x0009dc9a72f4ff50,0x000df54e86b3f74b,0x000b7fc672cd56a4,0x000ac313c91daa4c,0x00053d8b04fac047,0x000047ffb771df8b,0x000a8ad48cf7c44d,0x0008bf663542e196,0x000aa68b0ea4fed6,0x000483dbd49e0b45,0x0000000000000001}, {0x0007d603e389e5cb,0x000ee233664de2d7,0x000994f96855ef7d,0x000c5bf8c8ab10b1,0x000c2f5ab3d235e3,0x000bff37afff2ae5,0x00050de9d0fd0f4d,0x000ca6d91d5250db,0x00042da0be2c950f,0x0001c70ec3836fa7,0x0000000000000000}},
    {{0x0009b222a53c1578,0x000733b1bb114a22,0x000887f6c13ff59f,0x000d5dfb2679cded,0x0001fd35dec8bbba,0x0000930770ea94d4,0x0007da8d4f0a6019,0x000d2142901c2ad0,0x0002aaa8648f142e,0x000f42252e455969,0x0000000000000001}, {0x0004f335e4753950,0x00010578c42f0d9b,0x000fda89975c2716,0x000761372c49b195,0x000583ac76051357,0x000cd0c4d54de0d0,0x000c35f47ffa549f,0x000731f21817e11b,0x000ac2b103f57a56,0x000284cde0cd7146,0x0000000000000001}},
    {{0x000bb2a3bcba0504,0x00052359d22ba169,0x000ee4d727c18bc1,0x000338aababfd9ca,0x000cae35505124c8,0x000599b6e8a9cc3c,0x0003c6415386807e,0x00043919da2fc5ab,0x0001a4c6fd2ee43d,0x0007be38ead93480,0x0000000000000000}, {0x0008c66b564a97d4,0x0002177834d44e8b,0x000690ef30774807,0x0007151d926feb1c,0x0003fbe2f1f3454c,0x00048ce8e6456bd0,0x000270c04a6964dc,0x000fe8febbc7afec,0x0000f159a483b3a5,0x000aca96cb139ad3,0x0000000000000001}},
    {{0x000c0e9763d8a013,0x000baa65d7b1d37f,0x000608a4b87c8c06,0x0008c2592e527b8c,0x000aacc19bb3aa2d,0x000ce5b0adb09308,0x000e0f42458761d4,0x0002d73d4f707a6e,0x0003867f8d791c44,0x000c943ba7a1a60d,0x0000000000000001}, {0x0007ffca3e51b076,0x000d23467af3d90e,0x0009427b9fa60c44,0x00054ce0e4a16358,0x0001655e4129aaff,0x000befd5ea275c28,0x0000ce27c03c7fcc,0x0000c97ca421b716,0x00069ee6f84bb35f,0x0007ec35e0436eea,0x0000000000000000}},
    {{0x00033b8c99430421,0x000e3aa65723117d,0x0001482e2ca3fcee,0x0006dfdb52560262,0x00036a105a9eb6d9,0x000c0fd8b7bdc41e,0x000c58ba2f2edd58,0x000c050043d8b271,0x0009966a34a51907,0x000aee0fa52e13a7,0x0000000000000000}, {0x000c2d7066d5fc91,0x0000d462accbe2da,0x0008397028d0b78e,0x000b525e2c9d107f,0x0003dfedd5666711,0x00083957250c9620,0x0006d0f2be094638,0x00026dd96c8ff985,0x00098fe829c7a670,0x000dacfc430b6d43,0x0000000000000000}},
    {{0x000aba8bae3f0048,0x0006fc5f421abd9f,0x00094ac402ce8227,0x0005bead91f2efc8,0x000d28241f32e7d5,0x0008bce170cc1090,0x00050cb19f59df3e,0x00034ac35c2de273,0x0003cf90c3e6cfc4,0x0002a784bc2847d1,0x0000000000000001}, {0x0003f87f754f1aa3,0x0003382713cbe9fd,0x00034163c334fd8d,0x0004cbe346cada61,0x000dd6aa94a54721,0x0007b9235830a042,0x000500be120acf2f,0x000d30c3e8d009be,0x000225e2751dc7f0,0x000714b7edd06e6f,0x0000000000000000}},
},
{   /* digit=5 [{1,2,3,..,}]*([2^20]*G)  */
    {{0x000c1256fe47d13c,0x0007012fd1181020,0x000c4a469315aa78,0x000b1163ea26a86c,0x000e4be00b905056,0x0002f1dad4a0ac68,0x000e2d8c19c57695,0x0000bbc11daec6fd,0x0003baf9c6293f81,0x000d375056fba03a,0x0000000000000000}, {0x00073f08bbfc9af7,0x0006c14cc716b559,0x000b5b613b18efce,0x000f005d64d3ad94,0x00034ba83b800248,0x0009ee4cf2a375eb,0x0007d29413af2a4c,0x000525ea872268a2,0x000c082bd8d12fde,0x0006fa2d233189c9,0x0000000000000000}},
    {{0x000f1bef2c1b123b,0x000c9ca73fb5cd85,0x0001a80d76a111a8,0x00025f888d3b7461,0x0003f7765b87f2e3,0x0002e36012c8ad9e,0x0009dc42c7cf6c49,0x000d7d5db366bf5a,0x0005359f96228a81,0x000772725123cd91,0x0000000000000001}, {0x0006c7a0e2cfcba5,0x00097fa38cc5da8b,0x000b43bb38eee14f,0x000f15c0770c4afd,0x00093138850f3aa0,0x000658cf7e3953b9,0x0007c8bb70f07792,0x0000d78fd38c1d44,0x00023ebe4681177a,0x000c9d704ca7518e,0x0000000000000001}},
    {{0x0008fa7e4527a9d3,0x0004db4e9fda74ba,0x000404855f433494,0x000f130f65201753,0x000d719a9846d31d,0x000c651ab9661cb9,0x000b653c04c2995b,0x00031b2c3fb591c2,0x0000b91d21b65fb3,0x000c1f9233b624c9,0x0000000000000001}, {0x000eac108061f9eb,0x000a2e86d9cc5afc,0x0000e2ec8f94cdd0,0x00040675309b7d38,0x000320d2223f6f2c,0x0003be480dc1e34e,0x0007b72b364f62ba,0x00063595753dec52,0x000283d90f6639f0,0x0001d567ed0c354e,0x0000000000000001}},
    {{0x00067e2e3d478324,0x000b9d2b33e93756,0x0005cc9c7d0711cf,0x000aa7c2edf0adb9,0x000b6610b704fc5a,0x000107368e770150,0x000cc4ef9af2a471,0x000afe1e566d06e6,0x000a67146814dd0c,0x000fd36c67f6637c,0x0000000000000000}, {0x000b744b33ca6a46,0x000a2ad960d19dec,0x00099ff41dbc0bcf,0x000977ca933b28a6,0x000a7951faf63b97,0x0005168f23ca3752,0x00097d901e0f16b1,0x000105f55f964ea3,0x0003c0d403b374a5,0x000d43e408ed3a81,0x0000000000000001}},
    {{0x0007586c50a55f86,0x00026583c230d093,0x0009c8f1eaf61062,0x0009876910419f67,0x0006e8d67dbad2c6,0x000c3c184d440783,0x000753899fd2f814,0x00037825fefa52a3,0x000f0758545a721e,0x000498a4b823d5ff,0x0000000000000000}, {0x000e376ebd4ed258,0x00004d6a23fbe496,0x000b69ec3505f765,0x0008fe6b545afc26,0x0000e87ed2073fb2,0x0006145047af95f2,0x00053f84d27cd1ba,0x000fa35d865dc4cc,0x0007b711a9ee96b7,0x0008ec430aefdeb0,0x0000000000000000}},
    {{0x000354ba169146af,0x0008c79fdb88cac7,0x0009f85e2efdc64a,0x0001012d7f3a69d0,0x00017d2bed232563,0x0004dfd89cfd4d1f,0x0008288e64d46be0,0x00089f8bf20fd559,0x0001d08641f269d1,0x0009fc333e29ffc1,0x0000000000000001}, {0x000c7dab1b832059,0x000223bbef8e949c,0x0007f10fed75c714,0x000647b0bb61d266,0x000b8e823dbf309c,0x000601c5a1f58db2,0x0009c023a71fa3e4,0x000a0b5cbdd6344f,0x000df6a6577b11f1,0x00027e6eb12db5f8,0x0000000000000001}},
    {{0x000b94e9f2c64c2a,0x000dff9c4cc3460d,0x000339e03c0646b9,0x000ca76c7ae26f18,0x000612ba1712f64d,0x0006950e5f2c8040,0x000569eb5bf0fae1,0x0006185858b613d1,0x00080b1245b35ba8,0x000d9a3c93740668,0x0000000000000000}, {0x0005f1c44e1c9646,0x00061096f83044ee,0x000e69176fe10924,0x000a78875cfb2614,0x00007825516a8324,0x000065d69cfbad90,0x0001f873d71727bc,0x000185c81c530662,0x000c1471ae21856f,0x00047e68582e4e3a,0x0000000000000001}},
    {{0x000ce1c67b68f07c,0x000dfa5469124c9a,0x000ccd6db2024f3d,0x0002fc6faadd52b4,0x0005124af076574a,0x000510591517b271,0x0000081118a106bb,0x0007cffda2d67e24,0x000b3b39fc6925ec,0x00012037b374e288,0x0000000000000000}, {0x000d91b81541ec51,0x000c413a683e17ef,0x000952a60eda72b7,0x000b61d80495c130,0x000f6bf06a5749c4,0x000c7cbd39872c4b,0x0001a82e01cb7ce0,0x0001726d7547989f,0x000742de944906b4,0x00009f2e02ff3752,0x0000000000000001}},
},
{   /* digit=6 [{1,2,3,..,}]*([2^24]*G)  */
    {{0x0000872f1cba7983,0x000a9c28a369cd44,0x00007ce63b6f5daf,0x0009c12dc12c54cd,0x000a00a67eec84f7,0x000bc7a4edee7a34,0x000ea82ff4e7f63d,0x000950ab492940f7,0x000953027dc3353f,0x000be21b37a3c6cd,0x0000000000000001}, {0x0005f758ab77d6e7,0x000bab416ce18f4c,0x000b9e45e70a1adf,0x00038074a53a6ae6,0x0005919bbc5eaf8e,0x0006580a40639d33,0x00033f83c3446f86,0x0009f20b5de7abe3,0x000a42c48703c063,0x000ed659dbbfadd4,0x0000000000000000}},
    {{0x00025b49cc7d0744,0x000d5ca66a4107d0,0x00009a278704a0b9,0x00027e26383562d7,0x000c28bfb3e1fb8b,0x0006132452cd156b,0x000d9a249ca82ac0,0x0005a22d3a0e92d3,0x000b19aafd34655b,0x00048d36ff20dea2,0x0000000000000000}, {0x000f6b3025835a5b,0x0008531143727c86,0x000c5c003858192a,0x0001da9352b2fd4b,0x000d25e79d62bdaf,0x0003c74903de7c27,0x000ad4718fc47302,0x00063e48286ed6b3,0x0005e2dbee1fb246,0x000857558feb16de,0x0000000000000001}},
    {{0x0009f56e96a543bc,0x000d31c6bb399ae7,0x00031b99e11a37bd,0x0006c0e42fdb7dca,0x00074aad0723ad0f,0x000aae97e4f8e5ac,0x0000fdee33ad0efe,0x000675078a78e14a,0x000909b38b03996b,0x0007469ca609f2ac,0x0000000000000000}, {0x000466dcc50132b4,0x000eddd95df5a1fb,0x000a8d9a82cb91aa,0x000178685d056d78,0x000f44580cbb5024,0x000b8404125b7ea5,0x000c959397a21279,0x000b3c397b77ec41,0x00050358651ee34e,0x000febe48525c5d2,0x0000000000000001}},
    {{0x0003aa997f7f37af,0x000bd0399f83a0f3,0x000f152344eac6ee,0x0003cc5d1e36ba58,0x00058bcb7b01bb23,0x000e6e01c3b95ccb,0x0003f3cbd70b3470,0x0005471f142928b7,0x000f33fe8192a8fa,0x00067751b82a4272,0x0000000000000000}, {0x000ea1f801a1be23,0x0000e029d67e2091,0x000355df0fe9219d,0x000069ec86128187,0x000e9196ceb57b88,0x000b831fc0c5d6f3,0x000b18561a90e72c,0x0006875cf51476cc,0x0009d0fdc775daca,0x000556f11fb0d65e,0x0000000000000000}},
    {{0x000d755a99415514,0x00085952e4dc0b72,0x000ddaa98f7198b9,0x0002cf0597f96150,0x000e7060ed10994b,0x0005df6128c96445,0x000ea5cf35637a95,0x000b47cf25cfbeee,0x0003e924da7f8ade,0x000d5d59754f0973,0x0000000000000000}, {0x0007794536974a33,0x000bee39625b4887,0x000c916eff917626,0x000c143d7b2fe99a,0x0002b42a1f214f15,0x000a92c52323d0ac,0x000fb97a09db1674,0x00097d2bc99da798,0x000062e5a6c7b18b,0x000498e32a3a4e9d,0x0000000000000000}},
    {{0x0006f0528c6a99de,0x0005f78365a5404f,0x000a6130da7d607f,0x000ce8f385d457a1,0x000127a71db8c282,0x00075b1780f22e8e,0x0005f271ed981d16,0x0000879b71615445,0x0003f2395d4c8d2d,0x00002ffbb885eae5,0x0000000000000001}, {0x0004e8a699830814,0x000f60c1a29f03dd,0x000620f1843d15d6,0x0005370351aa6497,0x0003f3bdc3d85b92,0x0005713630b15aa8,0x000b25038bafd76d,0x000aa324c45046f5,0x0008ff854c7ef0e3,0x000f873074cd9a42,0x0000000000000001}},
    {{0x000a5c1655f0c965,0x000ad8760b75d0c0,0x0002d3b7a7dc8ea4,0x000d9d864941a528,0x000eb47e8ca867c6,0x0001a8847066dfb5,0x000249722cfbbbd6,0x000d270c27ad4dec,0x000e74307c896550,0x000812fcfddc8f52,0x0000000000000001}, {0x0009df50d9240b18,0x000a5431583e94ff,0x00044e5e649470bb,0x000156c0cde5a76d,0x000ad9f50c93b508,0x00099e86567b7ad7,0x000e7618f9dede32,0x000b84978d6f1f46,0x000aba70858d56a1,0x000626f5aa274be1,0x0000000000000001}},
    {{0x00038150eda6a189,0x000d5498edde21db,0x00010e8c4a802c3e,0x000d570892441512,0x000a6f9b009f95d3,0x000c80e954785d69,0x0008dbfa197859ea,0x000f9a954ad6166d,0x0005360545cac81c,0x00042d01aaa83bd5,0x0000000000000001}, {0x0008a0342c362ba4,0x0008202cf6246957,0x0008c4987d0b8dd8,0x000becfec2b48e0f,0x000a0d5c621a63b1,0x000668f2b6a90343,0x0008bd4fe098700f,0x0008bd8fa8829c08,0x0007948513f0936a,0x000733ae92e72067,0x0000000000000000}},
},
{   /* digit=7 [{1,2,3,..,}]*([2^28]*G)  */
    {{0x000f8517a4c96e5e,0x000b0e039e54c124,0x0001ec83d522549e,0x0008ead8eb02627a,0x000ef95771e9618a,0x0004f3a6b4497c2c,0x00055a41c4917c7d,0x000be8babd80080b,0x000548c7990585b7,0x000c64dabe54a06c,0x0000000000000001}, {0x000269bac978d382,0x000c6bdf9b98b02b,0x0000247e075c4ed8,0x00030716d8e1a299,0x0003a019c94edbc8,0x000c1665fb3458f3,0x000e700cd4d82fa9,0x000a2326e507ff63,0x000452b8341c9bbf,0x0000dfc9214a3f5b,0x0000000000000001}},
    {{0x0001109faf34910d,0x00006e16fb098733,0x000f23db2247dc5b,0x000f53ef62c76a0d,0x00018f68431633f2,0x0003cbe6a9413972,0x000253b6d05ffc26,0x00047ed103a8b14a,0x00089d6938ee0b45,0x000f4f3310d7c6f3,0x0000000000000001}, {0x000ae5ea5e61f0fe,0x000803eba63d9ee3,0x000ff5d7d44281cc,0x0006da525a289454,0x000688b5bf3e7fa2,0x0006c91ab88b9a08,0x0009907565a2877f,0x0001737c021210a3,0x00031db551223d6a,0x00041419f277aae1,0x0000000000000000}},
    {{0x000ab41a098c92a7,0x00072fa6811333e6,0x000851f03fd8fe3b,0x0008e34493163c43,0x00028174f0009cb6,0x000db83d4e177695,0x0004d1bfc734499f,0x000c56272647cc55,0x000d38b2b770d722,0x000fcea5c023f6ae,0x0000000000000000}, {0x000d52df57e5ca52,0x00065ec98ce0bb77,0x0002140495f37162,0x000d03a5ffc6d632,0x000f0d0061a4f743,0x000af61ada3e0094,0x0004b70091a92992,0x0003fe83591d84a0,0x0008b7e8b2e59f37,0x0006892e459b7561,0x0000000000000001}},
    {{0x0005e28d077485e2,0x00020e97a1a0b220,0x0006679b5d8662c1,0x0000da8bd256806d,0x000925177882d56f,0x000fd447d9b3a0c2,0x000077e15eb4fc81,0x0000f15d98b7d44b,0x00021ac9944ac5bb,0x00096438b1a53927,0x0000000000000001}, {0x00015ec8db3161c2,0x000f397c19309926,0x000de0771a46014e,0x00075e027929bb3e,0x0009dcd3fad002d9,0x0008c634c3d387bd,0x0009c3f4ebf24793,0x000a2c2da2b50807,0x000e85151e2b2209,0x0005f4bb80ad2ed2,0x0000000000000000}},
    {{0x000d84a6577d1d88,0x000209b195d9875f,0x0007dc25315ab09e,0x00041e59650e28f1,0x000f81b07fd77f04,0x000191d3288a8ccb,0x0001838964e3273f,0x00014aa2bd5786f8,0x000d924c29c83190,0x000d240eca2dec17,0x0000000000000001}, {0x000c94cf500620a8,0x00017a01ff5bfc59,0x0001d4396ff8b7cb,0x0004fb6ee69226c5,0x000565facfed55e4,0x000fa0b30de43edc,0x000b20ea8612b643,0x00056d93e66dab8d,0x00098f9a9e46bfc5,0x000537cf26d7b09b,0x0000000000000001}},
    {{0x000ab3bbacf312ed,0x00003114377687ca,0x000ecbe360e1fdea,0x0000336e644349d4,0x000ce9701c97498e,0x000b970f76e36640,0x000d18aeb034f110,0x000d8c04737b96e3,0x000b828ff89d3a4a,0x000ceb091b279c08,0x0000000000000000}, {0x00002832632c0b79,0x000f06083c30b6b6,0x000d6d46a5784fec,0x00018a1a822c2ef2,0x000ffd16846c810e,0x000859c7f32abfb3,0x000410206687e5a6,0x0001a4731948bcab,0x0009310e425eab64,0x0006640ebb114d39,0x0000000000000000}},
    {{0x000759039c7a9d17,0x000c2d4dd47b8758,0x000c1f2cd883e5fd,0x0007f9cf12cfd22e,0x000b330c8103c8b6,0x000fef902907b0c0,0x0008540db26c476e,0x000e726a64472792,0x000b090ef761ac1d,0x000f96107e57dd18,0x0000000000000001}, {0x0004650aeff40f19,0x000f9022a822976b,0x000a5007e542efc8,0x0007e6336d263df3,0x000d3e6b563a86e0,0x000fc14e677c3dd9,0x0001920cf4b81cd1,0x0001cedaf8056af9,0x0006ebfcbc28b238,0x000af30ce3975f89,0x0000000000000001}},
    {{0x00090c95c3d0b9c7,0x000844b8f686b48f,0x000a746779417d91,0x000bd2f6b498e1e2,0x0002adf2e61e9354,0x0000db08d1aea1ed,0x000a497f347f08db,0x000c7871378402cb,0x000753c735de0850,0x0001f9ed5b707951,0x0000000000000000}, {0x000d045e45f819b7,0x00024591e83186d4,0x0002f07b1add4180,0x00067074059bab68,0x000ea2b0f371c1d4,0x0000e5f219b0e391,0x000f844f22e68c28,0x000679b7f960b058,0x0002502036ca9899,0x00028a1f63acdbd1,0x0000000000000000}},
},
{   /* digit=8 [{1,2,3,..,}]*([2^32]*G)  */
    {{0x00023b6569acb75b,0x0008bff580463d22,0x000bd3d896f7a55f,0x000bc35819d6f3c8,0x000fcf8dfdd32dc1,0x0007477a57a2786c,0x000a3b0ae5589b65,0x000806de5eae9f47,0x000782fcd93f2178,0x00096dd9479ee32c,0x0000000000000001}, {0x00029435cbeebc5d,0x000d8352a35de209,0x0004ce809af5b11d,0x000a76cf080ab8c3,0x0002250478b1ce25,0x00003b3ff7216bfb,0x0004133d87f47621,0x000a4132748099b3,0x00029b68995f627a,0x0006fb62b3cf30a7,0x0000000000000000}},
    {{0x0009267d43d108b4,0x000b5b0396f4d947,0x000b1e5f7f088692,0x0009c3c1fd9437e3,0x0006cb9b9b7fa950,0x000a37b6c115a75e,0x00062d05b42f650b,0x000d5b3cf510dbbc,0x000a49bf06d5fe62,0x000049824e6593c6,0x0000000000000000}, {0x0007f70f36b1fb53,0x0004a3eb94fc53cc,0x00082c0e60f6a2b3,0x0002888aea4bc9d4,0x000d37ab9ed318f4,0x000a505ae0c0fe3e,0x00082c9e94fad3b1,0x000efa0f31285453,0x000bd4be69ae4fb8,0x000003a516fe8844,0x0000000000000001}},
    {{0x0005e8088591d8c2,0x000c6e24bb4a7ab3,0x000968fd3709e47e,0x000d55e3e7d95582,0x000f8783f2538474,0x0003b454e19d35c0,0x000724c4578fbe58,0x000b98f51326114b,0x00090d99b97ee546,0x000691801229b8f1,0x0000000000000000}, {0x000e4a0a2aa86765,0x000aa08b19b4b67e,0x000c220cb11d4f5f,0x000c7d426ad0862b,0x0002dd7a63508ce1,0x000aae47773236a7,0x000cce936cda4ace,0x0000808ba7a0be3f,0x000c14a5b972c384,0x000887cda4655c79,0x0000000000000001}},
    {{0x0007786aa39096d4,0x000a4070017bccec,0x000926b1ae026576,0x000026855e810d17,0x00039def24d306c0,0x0008ac55c7d826c4,0x000b521e40f66cc7,0x000ae26697c9fbf9,0x000a75caf01aaaf8,0x0002a9d094aec346,0x0000000000000000}, {0x000a161f4c1b67b7,0x000e72cc3c7e5f99,0x000fefa749b88977,0x00063737d6e24cf4,0x000ed4607a910568,0x00017686854dcfe4,0x00011acac7bc09c0,0x000cc731394d9ec2,0x0009e4dd8ac76909,0x000bc7246fb612d5,0x0000000000000000}},
    {{0x000d5c2ad970ea88,0x0000eb7dbc22b4be,0x00070d534e1a9e33,0x0004b0eab21921c0,0x00071b3a90f4b6c3,0x00015ce8387fd7ac,0x000ec28efad61dad,0x000f792985d577d5,0x0009ac313d175e05,0x0002d86582a5f995,0x0000000000000000}, {0x000258f797f0af53,0x0006198f53a67607,0x0008e97661c802c3,0x000001f410140442,0x0003c270534a9c94,0x000a5333d3d840fe,0x00076ed16f99ddeb,0x00021b94ff80e532,0x0002761460189f70,0x00007bce48c909c6,0x0000000000000001}},
    {{0x00018e1640843ac0,0x000d435c11720f14,0x00057cebd3881c75,0x00023104876137be,0x000da25ae87bc97f,0x000052fc640f68c5,0x00027372b9f14882,0x000b4e854fcb3017,0x0009d3406b0f1a39,0x000e653db1df6886,0x0000000000000001}, {0x000c416fe50a1e7a,0x000c29b7a99148a5,0x000d660bcfe2e7c6,0x000630309213716a,0x0004b63e38c0d1fe,0x00033bb86d3923a4,0x00056213e592fda9,0x00080b360f884315,0x000db3b21dcd9fe7,0x000617bc0a7836eb,0x0000000000000000}},
    {{0x00035cd63c7c9de3,0x000a91ffca828c02,0x000b3e377bfdd504,0x000496682e625999,0x000b8af1c462d519,0x0009570d96676ec9,0x000bf815f3869cb1,0x000b476a8b4fba76,0x00057597ce654eda,0x000e2235375a2127,0x0000000000000001}, {0x000e9252adfeeb9b,0x000707b233b4a650,0x000ab158faa771d2,0x000df78fbc7a8536,0x000be88e5009a864,0x000abbc52635e311,0x0008769bd53cfa60,0x000305e36a566f93,0x0000e758e66271c0,0x000b10e12e9cdd0e,0x0000000000000000}},
    {{0x00092f38031c9da3,0x000f6f0dd54d0455,0x000298fe24144d05,0x0006274ae2d191b2,0x000909113fc1ead4,0x000dea702ccc54c5,0x00008c5763ea8c10,0x000635441e7274f2,0x00006b2f2578c573,0x000c3b8134369537,0x0000000000000000}, {0x000ada464a85cfcd,0x0006064c2605a588,0x000004bbf31d5464,0x00010805ca04e18d,0x00067998cccf9032,0x0008398a6f896278,0x000dacf8d2faed14,0x0002de01ea7eca85,0x000eb7d829278474,0x000eb89fe5859b0f,0x0000000000000000}},
},
{   /* digit=9 [{1,2,3,..,}]*([2^36]*G)  */
    {{0x000a73aaf5f01aa9,0x0009abe5e08d9505,0x0009fd8bcd318e91,0x000915895b386f06,0x0004a0b5abd07d68,0x00039901b007bc24,0x000ff05c36936913,0x0003179dcef7684c,0x000125196e69b799,0x000a2823db7308b0,0x0000000000000001}, {0x0008e83616d0d063,0x0003bf0c66e267f8,0x0006d375b822f9f9,0x000dc02109656c0d,0x000530c1fc16b6d5,0x0006bf6541ba81db,0x000443cb4caf94b8,0x000a87f59d3c1a6d,0x0002afcd60e10fe1,0x000a088d7e1995b7,0x0000000000000000}},
    {{0x0005b8daa50517e7,0x000dbed46676160a,0x00016e7a7e78dcdb,0x0008e1fc1b0f5e9c,0x000933cb9503e917,0x0006f78b36f2294c,0x0006ec3420442aae,0x000c01e17c7ffb2d,0x0007293b87d30fdd,0x00092836bed4739c,0x0000000000000001}, {0x00075943e2ebfd04,0x0007b784cf37b849,0x000645eaa02ab285,0x0000b0ace12a0d65,0x000ff267c93aa3d3,0x000fa6954230be3e,0x00001e1903aa7ed6,0x000c311ae0c82cdb,0x0005f0bd3c5056d4,0x00022094d54a9827,0x0000000000000001}},
    {{0x0001c0660a4f2bbd,0x000c3d2fe061f455,0x000a2b6dd7091d40,0x000bf7437cc4883d,0x000f258011ddabd2,0x0001bdaba7aee852,0x000195b39f463ce7,0x000efb33b881bd7c,0x0007d695aede085f,0x000380f8fa2471bf,0x0000000000000001}, {0x0006eeab983554b4,0x000f138a6f5a6dc9,0x000b29f154f07f71,0x0007d1c7242d7a9e,0x00042f3c7f1afb70,0x000af2896b44aee8,0x000b55601f569990,0x00061e36ed07c5c5,0x0005430facca2678,0x00016ea78eb21424,0x0000000000000000}},
    {{0x000aeaaabe68e207,0x00098b6eaee3177d,0x000f5c1267a6e353,0x00092ae2d01bbbbb,0x000bf3af1a4f4a2b,0x000532088e5cdfa4,0x000c8ee638a58f55,0x000bbce5e7aa2a0e,0x000a1644879c3f50,0x00025e378387c246,0x0000000000000001}, {0x00069ee8884e88e1,0x00090f8ec2984b67,0x0001f9e47bd62fea,0x000f9867e7522665,0x000cb916cb0493d9,0x000106987f5be2cc,0x000869c71156e1c1,0x0005011576bd7bad,0x000b76a6e945007a,0x0000aec18de41f38,0x0000000000000001}},
    {{0x0007c59949c6f67a,0x000c897a229d2368,0x000118e3e788aa53,0x000794e3080e973b,0x000815a91046f15c,0x000ac04ed530c0f2,0x00078a4fe35eb925,0x0001fe18e7070c54,0x000f409ce7d9c57a,0x0008aafcd17edd4b,0x0000000000000001}, {0x0002850fe8174557,0x00037e234694753d,0x000c528ec7d2c45c,0x000bdd41f346792a,0x00032ca964be2a36,0x000fef3e7911d679,0x0000101c72673a03,0x000653d6358ef0bc,0x000f874e2b9caaba,0x00045ebbcc31882b,0x0000000000000001}},
    {{0x00090baa505384e0,0x000993148d7d8454,0x000d948464cae379,0x000f46feac4f8ace,0x0007268d1b7c8dda,0x0000d4770e6c39b6,0x000c1955967ac571,0x00052098b74830a2,0x0008d17fe1904773,0x000191e5071ced85,0x0000000000000000}, {0x000b4f003b56551f,0x0000872a7e419344,0x0001262c90a767f8,0x00015a9791770fa4,0x0001a4bc5606e253,0x000a665041696dd3,0x000da6d7ec137466,0x000cac07c562bd01,0x000c4a92e59de1e2,0x0007068f7d29994b,0x0000000000000000}},
    {{0x000172698b05a9bf,0x0000570dde3c4b9d,0x0004dad7e2ab8a86,0x000cc4fe376d08bb,0x000df2d396e50709,0x0008138716b38f91,0x0004e9a6a45d9577,0x000feda477817a06,0x0007062a4f79bf83,0x000ca12aff8e0103,0x0000000000000000}, {0x000748577bd0ea3b,0x00068ca23c2d1e49,0x00079fc968bdb9b4,0x000359089d5d5807,0x00037ae7478afb4f,0x000f6ac1a17ffb5a,0x00076fb0ad6d0956,0x0003cc73da4935d0,0x000b38ddd4e896c8,0x00091fcd942654f0,0x0000000000000000}},
    {{0x000d06bf88e947b1,0x000a0ca717a0accc,0x000b428946c6ceb8,0x000992652bd2594e,0x00041806882365c1,0x0004f2f3523a8241,0x0002e27b634a60c7,0x0006f4680f2b83ce,0x0005e159f3342680,0x00053718c76ca148,0x0000000000000001}, {0x00063dec4e0c9dd7,0x000cb7d74bb74e1f,0x0004a5f09446f95c,0x000f4555c75d0662,0x00028d6e7583fd36,0x00083fa30323cc2b,0x00010012c0c49bb7,0x0009907cd3d64f77,0x000c79e69ac90f89,0x0006c12cb352bde2,0x0000000000000001}},
},
{   /* digit=10 [{1,2,3,..,}]*([2^40]*G)  */
    {{0x000bc2a7fe05ab80,0x0001a246f49f7a93,0x00091072db7cc0b4,0x00011f97d30ac7ec,0x000169de685e7537,0x0008a2ae9aef0acc,0x000e3c46bded4c6b,0x000604789cdc4497,0x000a082feb2b2ea2,0x00078fe890cba4fe,0x0000000000000001}, {0x000edbc5c5076824,0x000298a472aca466,0x000a80660505ad15,0x0000c1cc1b16ca97,0x000dda2937bbf38b,0x0002545fac4d56c3,0x00090f07e35494b7,0x0000903e9ca74b57,0x000b43111b0c8bc4,0x0005465923f9e9c4,0x0000000000000000}},
    {{0x0008b52bfb73ff4e,0x000a4d6410d489c1,0x000ae318bb528530,0x0004b71f3f7d7028,0x000970b21b686b53,0x00001ea2751f5995,0x0001322663379ddf,0x000e77c11915800a,0x000261c476db4bea,0x000ae8e89c22a1e3,0x0000000000000000}, {0x000e16965a7b1dfa,0x0009afd6426762fc,0x000532ec13f2e53d,0x000fe4131e801ed5,0x000c86963e2f9e9e,0x000f46e5098aecc3,0x000faa2b47801a35,0x00043b6f3406c3d8,0x000b57971349f37b,0x0007d749ef39f4ad,0x0000000000000000}},
    {{0x000dcaceb126ca58,0x00046c5a73dec3f9,0x0000e0ffb30d8879,0x00026935e7e62831,0x000f5e074c83b841,0x0008b04291158a7d,0x000f72a08eaada21,0x000a40d05438fa20,0x00005e6ac9aa8c4a,0x000b92b755928484,0x0000000000000000}, {0x00081326c74e90da,0x000cdbf1a037a879,0x0009887e29013ab2,0x000ffd6598bd3d86,0x0003b3c803a95fec,0x000e4c50722fd839,0x0004e70129b699c3,0x0000fa72cdd65e3c,0x0000ccbba65f24da,0x0008975325682f6c,0x0000000000000001}},
    {{0x0008d8231d21b98b,0x000f46eede07ff72,0x000c57dc8bc52ba3,0x00096a93bbd28782,0x000609e0a7a0e49d,0x0009fbe4aa495765,0x0004c5f79dbfb8ae,0x0005e1789960cccb,0x000b74da3d25ebfd,0x000c2e56df642b09,0x0000000000000001}, {0x0007057a2be83a30,0x00026ba759ce4dd1,0x00057744ef0ab9d2,0x000c9ee2b7115a63,0x00000d77f24c2ddd,0x000142ea1adfee89,0x0000f3fa9d5346a2,0x0007a84ecd7e6d50,0x00035caeb7a1527e,0x000c8110e6262dae,0x0000000000000001}},
    {{0x000457989aea7c3e,0x000a16bd6196a6cd,0x0006f76c2cbdd85c,0x0005840dcfd847e9,0x000ec8ea001b3aa2,0x000898be24444e27,0x000397d8a0c53dda,0x0003fa5f98a5b3e4,0x0008e197364ea986,0x000bbd922c6bbfbe,0x0000000000000000}, {0x00064b7db5084e37,0x0008c954735a1906,0x0007371d65a99056,0x000bdaf052b4c902,0x0009ec2cc9668600,0x000adac668469729,0x0002f7ceb4949cfb,0x0001eda14ca03327,0x0009270923989fbe,0x0002a80f1714c9d9,0x0000000000000001}},
    {{0x000da9fadd2d2e35,0x000ebe39d9c06e00,0x0007878b1c269b9b,0x00045c0350e16aa4,0x000d604f7fb31a05,0x000233dc435d57a4,0x0004a59629977c5d,0x000caa747e5387e5,0x0006980680cca577,0x000c7f3aa2473480,0x0000000000000000}, {0x0006ecf72ff177c1,0x000ea087d84398f4,0x000f8e3dbad5b5e3,0x000793b7c29bdf29,0x000d48b4ad4a2c86,0x0004cf9d25337e0d,0x000be01c858ea723,0x000fe90a676bb282,0x000306f507590c7b,0x000915155053c47d,0x0000000000000001}},
    {{0x000311b42bb970cd,0x00056fa08e6727fa,0x0006285b2f7609fc,0x000807c307ce1a3e,0x000d8c9c1df6de94,0x00070b979619a317,0x000fdde052a3379d,0x000baa7d20b3870e,0x0006e443d8f7406d,0x000355511beafebb,0x0000000000000000}, {0x0002e82c90634dd6,0x0002249d51e499d6,0x000615ca9d89995a,0x00097ac7d99162d9,0x0009551034000ab8,0x00070ca9d924f35e,0x000b526853be7dfb,0x000638dc8c8aff11,0x00031fb01463b8a6,0x0004e7b55e740433,0x0000000000000000}},
    {{0x0008d4f13a03485a,0x0004c5dd3ccf1850,0x000d8ab1776f2552,0x000a54a5e0bf0c9e,0x000e81226e24a017,0x0000e5b1ecb9626b,0x0006acb8b7b3bc5b,0x000414da0130f24c,0x000b2f1d94673605,0x0003ae73af8b9c7d,0x0000000000000001}, {0x0001a4baf806025a,0x00068cf7b99ef6b1,0x000b70549901e9bb,0x000cc5d4a5ca0071,0x000b555009f7be57,0x0008dbaab6501aba,0x0005c582d17b21b0,0x000d9921c7bacde3,0x00013fb4b9991c48,0x000d72c6f664c93f,0x0000000000000000}},
},
{   /* digit=11 [{1,2,3,..,}]*([2^44]*G)  */
    {{0x00000e09c15f3e5c,0x000f97f45b409fb9,0x000ff4a01087837b,0x000d204b2bcafcbc,0x0000a0da165ec6b8,0x00011716978423a6,0x000f2f7f8295351b,0x00081f58e2d13eb1,0x000ed84592b66922,0x00025f5f9819aebb,0x0000000000000001}, {0x0007ea077d668278,0x000b9653ee2ff77b,0x00098e8334b5b359,0x0005210487baabe1,0x0001a95a5886c85a,0x00009649f4c23788,0x00056127f95c6f68,0x000aed6c6419d339,0x000be49aa657d29f,0x000da67ae0b376a5,0x0000000000000001}},
    {{0x000fb32bacbbde73,0x0004f08a721e3545,0x000584020b45c467,0x000fd3a284a774fc,0x00004477afffeada,0x0006a2c4ec266e10,0x00066dc326c6652d,0x00070b3a65b94280,0x00055b8104c7d5c7,0x000d8c4b6af237e3,0x0000000000000000}, {0x0000b97b7ca1cffd,0x000435de1358221c,0x000876cab38cc7ac,0x00054cdc8f30b09e,0x0000ccb3a4f5aec6,0x0002ac30ca26a9da,0x00011038e2a6fa3b,0x0004545c20a577ee,0x000bff8e2f50fb14,0x00093158359a6d97,0x0000000000000000}},
    {{0x000b8fa7bdc8384d,0x000f2859e636e718,0x000ed301cc9c465c,0x000006a5b105b2b7,0x0007075698827d1b,0x000fbe7e34565b30,0x0006110c56ecfa0a,0x000be3136324ecec,0x000a684fbfe59f06,0x00056bc39bf313cf,0x0000000000000001}, {0x0008543e894e8a16,0x0006d339681c386b,0x0001fc0aac97005d,0x000c6eaa38aa9f79,0x000a90d6089956c5,0x0005ec33374fdc05,0x0007a4eaa1631484,0x0008df64f8ad9e1c,0x0007f44336b984af,0x000859e7ad53b8dd,0x0000000000000000}},
    {{0x000c8ba9ccf89d24,0x000874ddf8d1b9b2,0x00027291ffd7f24e,0x0008bd9d563287c7,0x00065d01bdb48d02,0x0001b99b973b0c12,0x000050d618319b97,0x00038420d531f686,0x000d7c201c411c3a,0x000d97468eb84cae,0x0000000000000000}, {0x000eb2fc05bf609a,0x00073e1dab9da1f6,0x00049847c3ac275b,0x0007880554d322f9,0x000fedd0cd2b7f05,0x00085bb3e74958ea,0x000fcd8d9061a481,0x0006f9ac370d5c6d,0x0004cb188a021786,0x00057aa132c3b5f5,0x0000000000000000}},
    {{0x000a082d83368da6,0x0009c04ba3a92f9d,0x00018e366fb4a189,0x000dca28f8a4aa8f,0x0008c98efdf41b12,0x000e7f6ce11df724,0x0003850179926b22,0x000c0fa0bae8aa29,0x0007fa3acc87191b,0x0008222f18a88f29,0x0000000000000001}, {0x0009dda00370c8d5,0x000720c0497d2a02,0x000cdb5a6b3dc411,0x00032f0daa73c7c9,0x000505d3784e14b1,0x000d7b77b06edb5d,0x000c1f94b45f2c9d,0x0003193f38ea4c8e,0x0001706f6af3bbf0,0x000f0df22ed99a0b,0x0000000000000001}},
    {{0x00097825d9e0b2bb,0x00096d1340276af1,0x000d82fe6324bbcc,0x0000475ecad6233b,0x0009a0cd8d04ac29,0x000e8e067d738cce,0x0004317aa038ad08,0x0009a7ce55aad83e,0x0006a1887d5e91f4,0x000a135efeae9285,0x0000000000000001}, {0x000fa0b6a035b085,0x0005853d153ead9b,0x000ca7f6fb4ef7bc,0x000bfbb30b798e2a,0x0006653595cf1f8a,0x000774e7d1791820,0x00048df862d39281,0x0002db1e40868b45,0x000153b336e38fc5,0x00052ce2e4b80e72,0x0000000000000001}},
    {{0x000306c918831eac,0x000de7b8556b1913,0x000c579621fb2237,0x0001fa1088e011f5,0x0007511558db4265,0x000c63131310e896,0x00029cec356a91fc,0x0004b85a2f85b7d1,0x0006bc4404e3b5cc,0x000ac5c4fcc3a6fc,0x0000000000000001}, {0x000498b1e054105b,0x000818b7c971dcbb,0x0006cf66f8ee2eea,0x000fa05b49db517f,0x00012073a35daeb3,0x000d5bb674f202b9,0x00032d411842792d,0x00076cdcc487632e,0x0006568c96ca8dd3,0x000ecdfe1c986f51,0x0000000000000000}},
    {{0x000595043dc23233,0x0008d9e1b752f3f5,0x000f6e2b3641b931,0x00064e0f5c02bb70,0x000169d8f287038d,0x00062f3a1b075424,0x00001bf3b8c6755a,0x000a2b642127d597,0x000c17f0c20fbe8b,0x0005263410177dfa,0x0000000000000000}, {0x00008cc560c65efb,0x000ef6706807502b,0x0007a1e8980e532c,0x0007963729a4a8b8,0x0007ccb3a4f193b6,0x0002e07ae80043db,0x0005be0346fea839,0x0009ef33f7a00da3,0x0001ea778cb41f4e,0x00096ebb760e7727,0x0000000000000001}},
},
{   /* digit=12 [{1,2,3,..,}]*([2^48]*G)  */
    {{0x0009ba658c1f9460,0x000b18b48e1df3f7,0x0005fc03a103eb15,0x0001ad263bed592a,0x0000a127b78a3359,0x0000337c7b07e9d8,0x000d2a0349dd74fc,0x0003b1a807c5364e,0x000d92cca588d420,0x000d9e772a1716ec,0x0000000000000001}, {0x000fc1df3f66f295,0x00015742d25980f6,0x00036f0fdb08922f,0x0001fe47a583206a,0x00001c73f88168cc,0x0001b777671d2798,0x00068317ac8979ce,0x0002a98b48363dba,0x000f36b7460d4015,0x000da1c3d46c62c7,0x0000000000000001}},
    {{0x0001fb046e7fab2a,0x0000e190213473d6,0x000cbb6e9b84f9db,0x0008fb8a36fcff78,0x000c47cd5e9d16aa,0x000c2601e9337a00,0x000713efe8445d72,0x00030681fd15bbab,0x00051cff90b2dd23,0x00024900ab444b21,0x0000000000000000}, {0x000de9a880ca8289,0x000e3bcb8ede5206,0x000e1369e32209ab,0x00036516b711e224,0x00025533569db531,0x000419656e59d965,0x000ee21f2d680255,0x0001d59bb004326e,0x000bb722c073cca7,0x000866aa784f931c,0x0000000000000001}},
    {{0x000d262bb3ca8da3,0x00045288c7563397,0x000d10c59451797d,0x0004e594575ac7f4,0x000311006db0bd6b,0x0004d6485bec56e6,0x00089e23442953a9,0x000610efbe7ae598,0x000f1a0f166d5639,0x0004e5f91e0ed7d5,0x0000000000000001}, {0x000aca95d51d383f,0x0000d23ae1d67e17,0x0001b867b62738a3,0x000907e6a529f72f,0x00059335e44e6986,0x0001d5fbd59c1e58,0x00018393e6789776,0x000e5bc878acd1b0,0x00059b26328cd9f3,0x000f3d83306eef44,0x0000000000000000}},
    {{0x0009313593b1d240,0x0003b3672b4b0a51,0x00078ea42e614acc,0x000784cd22fe0a9a,0x000a6c20faf43e72,0x000e49f3038f9c3e,0x000fb914c50987c5,0x00000c76e9b912d1,0x000dc2b7b96a89b9,0x0008de238b29a074,0x0000000000000000}, {0x00068ea377031f72,0x000e9606adb168ca,0x000e58dde885ecba,0x000177424d422e92,0x0008aa609937ceba,0x000f30fc81145199,0x000c9f99eba807b8,0x000e200db6e7a724,0x000db2dc7651c126,0x00009cb58e38f0c9,0x0000000000000001}},
    {{0x0002dda36b654cc9,0x0008acdfcec83248,0x000164e7c3c6f06e,0x000ff27341f98b3f,0x000b145595e7208c,0x000f8fbf6e4d7416,0x000a519d6e691f26,0x00082c10e5fd7be7,0x000b1af42c760524,0x000f36238c97dbcb,0x0000000000000000}, {0x000a3b8e5e8a7251,0x0006fabc0a713664,0x0004fe41fe20cb31,0x0004067dc2b00d32,0x0004fa30d7f12a4e,0x0003f79c759905ca,0x000ef9b323da1724,0x000357ea84efa0af,0x00083350488b839e,0x000408f03e5cf22c,0x0000000000000001}},
    {{0x000e616991835801,0x00028f75d4e1a857,0x00031b04bb8869ad,0x000fb7737091410d,0x000cdd4fad2e164a,0x0004c7cf900934ac,0x0009b433f8948c75,0x00028687541974f6,0x0008f0af013f8d2a,0x0000b59eac62d398,0x0000000000000000}, {0x0000c23b25d034e1,0x0007d927e7c611fb,0x0007596a05e54d05,0x000f8995596eb4b3,0x0005b26be4690555,0x000ae1277dbebe99,0x0006bc99c064aa3f,0x0001128fda3fad13,0x000cd244392bf3eb,0x000a481bf8fac406,0x0000000000000001}},
    {{0x000d8f6c1e9aa431,0x000e3d32dbe1679d,0x0006391e1828c205,0x00026f450a2821e3,0x000a00cf3fc9e32a,0x000a2fc5a7a744f6,0x0006b70facb792c6,0x000e8edf92ab0b29,0x000d53faf8f11ba4,0x000b1e87f01ff5b4,0x0000000000000000}, {0x000e6fdf30e29338,0x00014840cefab311,0x000c4e092d034ea0,0x000be36bee8c5b8d,0x0001f39e2788cf85,0x0008f32c467a702e,0x0005e353cc3b7917,0x000f137377576e06,0x0000db55d1c5fcce,0x000d16e9cd523a0e,0x0000000000000001}},
    {{0x000e8870b81dfb8c,0x0006908ea654a671,0x000c3eb3660a23dd,0x000daf70673dbdf6,0x000c19bbf5d38a5d,0x000fe1371d1e7af5,0x000e30bcc1eff610,0x000f1308bdd31572,0x0000db70b20ce33c,0x000e036ab6b3edc6,0x0000000000000000}, {0x000357b86d4f22a6,0x000b893ce6e16bae,0x000a3849b8d94e06,0x000e1675b6058ad8,0x000ed6add0f99ace,0x0003cd380c39df12,0x000e2335c645ff14,0x000994a0f6180481,0x0005a52a4c84b4bf,0x000e9849a710f480,0x0000000000000000}},
},
{   /* digit=13 [{1,2,3,..,}]*([2^52]*G)  */
    {{0x0002ea2996fba378,0x000cf933ae1a32c4,0x000b43b79b9d0dda,0x0002636c30561bd9,0x000f9122413700ad,0x0005a779a0d830de,0x000580fda5f65618,0x00067e785d8628b8,0x000ce8b188bafa8c,0x0006d2c75df63d48,0x0000000000000001}, {0x00090afd2d7e01b7,0x000e57c72b304c5a,0x00040d7dec21b4b2,0x00094cfde0f45d07,0x00010aabbfa713eb,0x0007fa8b4fae1b3f,0x00047d2b080d24d3,0x0001142abdb36f64,0x000470df72045350,0x00047e76e433f8fd,0x0000000000000001}},
    {{0x000081cbd682dd91,0x000d2c1433b543ad,0x00094641d2488d8c,0x00036e702da0394f,0x0008248288ca4d8e,0x000112c8a6461fe7,0x0004a486f063613a,0x000f77efb66bb862,0x0006e8d41511d90f,0x0009a1ce80969401,0x0000000000000000}, {0x000feced91fc3935,0x0002e83ecdac7136,0x000ee8e2857921f4,0x000ef9bbe82b293d,0x000bd182b25ab2c3,0x00097ad819ac32f4,0x000916b74b598de2,0x0004d5e666a5dd15,0x0007be0b151456a2,0x000b794dc25c5c44,0x0000000000000000}},
    {{0x00087c377c23c5aa,0x000d33ca314119f6,0x0002512d0943eacf,0x000f9fd69c0e1850,0x000b7c3c6ea7ee55,0x0006291556c20685,0x00053374868b07c6,0x0009f9f339d7b589,0x000d6855b9238a10,0x000491ac6af37f75,0x0000000000000000}, {0x000b5d5b2f49812c,0x000855e7603bff6e,0x0008f73b087f7552,0x0005c0adc19b7320,0x000d355df5442e8f,0x000a4b8876b6aeab,0x000a7378dc2b22b3,0x000c26f89265f8bc,0x0006645f23dbb040,0x000f38b09ab1bbfb,0x0000000000000001}},
    {{0x00011ca0d8fcc245,0x0008ea92267e1494,0x000bbfcc2abb385c,0x00029656bfd56d29,0x000075f2180a734b,0x000dc3400006f728,0x000f754023104376,0x00021bae73e6854a,0x000a8d2ddbc75324,0x0003d711770a3406,0x0000000000000001}, {0x000476594b8d6365,0x000aedeb8cb49714,0x000c86324ad6ba99,0x00016428c49863ca,0x0002a2e5cfc3d8a3,0x0009adc3e0cb62d8,0x000eff79e5f3fda7,0x000eb4f990b6cadd,0x000b0e410ae15a98,0x00000aedf394c7b9,0x0000000000000001}},
    {{0x00021de1984e2e65,0x000603254887ed1d,0x00087e7535512fa1,0x0006f4ddde7dd7d2,0x000fd9cd7f2faac0,0x00009274ea570744,0x000b8cb9c92e3b10,0x000294aa3ad7752d,0x0001e25f444d43f5,0x000d6a378f2a4af0,0x0000000000000000}, {0x00007294901179cf,0x000fc01f2357da9c,0x0003c6543ad3aafc,0x0004db8aa97c6078,0x000dd86b1f882854,0x000e842c5d55c6a1,0x000e30c9aff1c67b,0x000d71107c0af546,0x00097038444a87de,0x000d8c2bb6354272,0x0000000000000001}},
    {{0x00086f90f323a729,0x00082963dacbf625,0x0004056ab9d5b07c,0x0001d30212e37a0e,0x00065da9a3d1070f,0x000445a33677e429,0x000c39a6aee3c700,0x0006b968d6cd0279,0x00098776415f9a3e,0x0007bd59dc1684b7,0x0000000000000000}, {0x0005cafc1fb833a8,0x000b18657b2cb0ad,0x000af58b0bf123c6,0x000acc1e7ceb4334,0x000e5575f0e10ca6,0x000d22916c7bc194,0x00097f735880fd80,0x000604a86980d5b3,0x0002f218f0f8d8fa,0x0000806dbeec3ed6,0x0000000000000000}},
    {{0x000b6c1669c31b94,0x000b37bb5eb33b20,0x000f2f86abcd3194,0x000093b3893ef395,0x000d0b48537fd7dc,0x0006863b5109af48,0x000cb076c2fca9e7,0x000fc785f088e6f5,0x000c88facfd552fb,0x0001054316685a3b,0x0000000000000001}, {0x000b6af5d1972479,0x000ccf45d30e213b,0x000db2b3881288b7,0x0008f7bff9008ba2,0x000607009e5be8cf,0x000e10b176da0a78,0x000522cf433a33d0,0x000090924737e4d8,0x000cc0a11c296771,0x0001fd3715d11b75,0x0000000000000001}},
    {{0x000c391c2f2938b1,0x0006b396d1c5f420,0x0006bb17f5eeaef7,0x0006a57b7feb16a1,0x00026cc8015523f1,0x000ded6e6d4aadf1,0x000f602e23393c9c,0x000e2c8dbcb36848,0x00011e23c49f3a9a,0x000730c0c1ebfaf8,0x0000000000000000}, {0x0001b88cdd5da561,0x0002fcb4c22029af,0x0009624d6d5aa7f2,0x000db935bb120735,0x00019a8308449416,0x000467f9f185fd32,0x00057d8b4d3e00fc,0x000e187052a8a69d,0x0009e66380528c91,0x0007a42a603bc9b7,0x0000000000000001}},
},
{   /* digit=14 [{1,2,3,..,}]*([2^56]*G)  */
    {{0x00026efe1474fe09,0x00029da3ad38a0ca,0x000ec34abeaf5cd5,0x000847ac94808b1e,0x0001587ade96127c,0x000a43fa8cfa6df2,0x000bb39bcfdb5ad6,0x0005dd4d0c9f947f,0x000772a4ebca687c,0x0009227d79e215e8,0x0000000000000000}, {0x000926e1c81cb032,0x000ffdb04fbc5abf,0x00034707ba5b9c12,0x000a347c4ee8c89b,0x00072367a152d81a,0x0004511a3a4cd565,0x000b8f1a66429397,0x000260ea13e9d0e3,0x000a19a28ee14ab4,0x000d5dea76ba4c81,0x0000000000000001}},
    {{0x000f1e1b3fe2f1a3,0x0006da87421ab9af,0x000a3305ebdbbfcc,0x000cb7784b75a8e1,0x0006a4410056f8f4,0x000ff65612b5abdc,0x0004b1cd83f32f54,0x000fb989d25121c4,0x00014abed80a7bb1,0x0005ba8f200e1152,0x0000000000000001}, {0x000fb8525d63a07f,0x0002a4f5f23c02f4,0x000405911d9aa8e0,0x000dae0345abb8b1,0x0007b4834d14e7a6,0x000b31fdc5462195,0x0005dca7cbf9b75e,0x0001ee84304e26ee,0x0006a2c7d37349cc,0x000fc85a34c3afcc,0x0000000000000001}},
    {{0x000cefac8c58a5d9,0x000939b188506808,0x0005985dd6ee8422,0x00094a64ab14cf0e,0x0001ac27af983cda,0x00024f6eafd12785,0x00025d8bab20f8ff,0x0004a549d9c6da3b,0x000f18f37ed810bd,0x000655f630e4c95b,0x0000000000000000}, {0x00018594e51ad76d,0x000d8952697460ae,0x000aec56660f8de9,0x00093a39294777cd,0x000bdf7dc98fde3a,0x0000c53dc363fcc0,0x00091985d2c2708c,0x00093692d05055da,0x000c4d312ebcde24,0x0000c18d0017f5cd,0x0000000000000000}},
    {{0x000a3f86e5f8496f,0x0007f32df7ec8ea1,0x000d8551991f1f8f,0x0000f4eeb16ec397,0x000f5ebe5be1abc8,0x000f8233b8a1e6cb,0x00037675c403702a,0x000cbf97ecb04148,0x0006555682899a5c,0x0000280720d39958,0x0000000000000000}, {0x000312054dc27af9,0x00074dd550df7288,0x000193eb1e2f87e2,0x00073656a715c43f,0x0006ecb67dce2977,0x000aacb5db8a585c,0x000d92a6332fcd10,0x000cdeebccba4f16,0x00036c8da2b8001a,0x0007817b62765789,0x0000000000000000}},
    {{0x0002d6d084e03d59,0x000c244d84ecf179,0x000c93fa7f1e0110,0x000f695cc72b1bb4,0x000921730f1b2908,0x000b0b36b38d0bc6,0x00029c0e4bf469cd,0x000c1d41428da1db,0x000d1253d7a577f2,0x00006a23b655222c,0x0000000000000000}, {0x000ba5fbd7ebe31e,0x0005209808ec8aa4,0x00049718327a5383,0x000bb2492c210a5f,0x0002eef53e1dbdc5,0x0009d3c1717e38e0,0x000d4877b41e983c,0x00012d8aedea3a07,0x0007e058b6c0e3ba,0x000fd022c8be6da1,0x0000000000000001}},
    {{0x000870ab98aeb123,0x000044a353002cf5,0x0006150f34fa12da,0x0006eea20086b83e,0x000a0a2cdf13169e,0x00028616b25e80e0,0x000c5982d13e0cc5,0x00019702e01a4a67,0x000b60ef183d6e66,0x000a1f6f9172f815,0x0000000000000001}, {0x0002b57766386476,0x0001a0e6acc5477b,0x000ba422b2405581,0x00090991a9873020,0x00045310acf2c8c9,0x0008701ea796459d,0x0008c83917c30ec7,0x0009db51be44d168,0x000514c3bb42ce9e,0x00048d0b03fd870b,0x0000000000000001}},
    {{0x0007edbd640c9bb6,0x0001c6f483d72a01,0x00058a225c5b0849,0x000e8697568a7e71,0x00022821bf73d7fd,0x000c765e3aef4bc0,0x0001d2e8d1daf2fe,0x000772d486e7b59a,0x000595f951edfc03,0x000ffff1683f882a,0x0000000000000000}, {0x000fc53814c4cc13,0x00014196f30cc555,0x00076a3af64c6ce2,0x0009bfff339f5668,0x000ffe438adb5544,0x000aa59ae8f3c48d,0x0006c57ce59b5441,0x000eb7bdc7b7c0fd,0x0003b8e1d8e51d10,0x000d6a6427d57897,0x0000000000000001}},
    {{0x00005519264c8b35,0x00066ff272a08c1d,0x000142d545c343f7,0x000ef117b8bd86e9,0x0001c60c69c66860,0x000b54e53cb6de93,0x0000c9b9924f2f51,0x00030b949095878c,0x00016f5f1fba7e2a,0x0005817da79c3a69,0x0000000000000000}, {0x0006ad6babd55997,0x000be6d551de11e0,0x0006c45d4c33b3cb,0x0009e3dfcc4aa553,0x000821bb5c238e3c,0x000dfc012d05a1e3,0x000650684d8d4638,0x000805b7e2413b85,0x000718949cdcfd8e,0x0002efc1a85e6627,0x0000000000000001}},
},
{   /* digit=15 [{1,2,3,..,}]*([2^60]*G)  */
    {{0x000f6a9bd09d8e58,0x00004bdca0a6cc0a,0x000d9e6d336fe5f9,0x000c9d8bd87d0339,0x0003f4d463bab3b8,0x000203e46dfb629c,0x0000ef34ea62ed4c,0x000564035458998a,0x00069592c6278328,0x00081b3c56ebb377,0x0000000000000001}, {0x0009a17aab96cc87,0x000f8ed51ce44125,0x000c62b1c658666d,0x000b6999437c7966,0x0008f0fecb36474d,0x000f725b1f7c6099,0x000396c71fdafc21,0x0006a547fb5a5b56,0x000566ae79d88868,0x0000f4130033ff0f,0x0000000000000000}},
    {{0x000a6c73f41a4fd1,0x000bf46616431912,0x0009c6ffbd2fe4c8,0x0009e4fd42f313ec,0x000b9f8b100ba286,0x000e18229bbae712,0x000550161a1f1da0,0x0000032c80f2ffe5,0x000f0b1d53bfaa0e,0x00035fb83c760748,0x0000000000000000}, {0x000ed33353cf7a1f,0x00075b8b3c031fa0,0x00053c30e33c1415,0x000945a8fa62217c,0x000aa8b667de4f9f,0x000c4952fb889399,0x000b6e3b711abc77,0x000959e7e12fabed,0x00057ebfe5a1b2cb,0x0005344206e24318,0x0000000000000001}},
    {{0x0005f9c5a301de7d,0x000b800d937115a9,0x0004b1412c82ee0e,0x00039cf3df5a5904,0x00016cd50327ee6f,0x000841dfd19a796b,0x0005d79c493ac5c0,0x00097275eb2319d1,0x0003b6feb4b9d447,0x000542e1eb10df1a,0x0000000000000000}, {0x00051bac56d17f38,0x0007837a907c7875,0x00082e7d67e232dc,0x000c3c225acaf222,0x00056e17100c95eb,0x000198b234622502,0x0006b8a4beb3ba23,0x0005492d30351698,0x000c0dd28973e413,0x00031b2e1155d6fc,0x0000000000000001}},
    {{0x00014d7bc4df6981,0x000c45e951da151f,0x0003964143f3d397,0x00056c9c24be6549,0x0000ae1293e252e5,0x000bfda40e3aed33,0x000e72cdf82159a4,0x000f514f7b173b13,0x0000684bfa5b859f,0x000fce90812f67e2,0x0000000000000001}, {0x000a9abf7e9a0c25,0x000a823b0b3a0fbc,0x00011d2709072194,0x000b7a7f17f5564f,0x0007987f0af999bb,0x0009d6201796c014,0x000d35c45cce25a6,0x0009265843370c43,0x000a55401cbff6e8,0x0000eab503e2ea19,0x0000000000000001}},
    {{0x000caabc4b5cd512,0x00034cdeccde50ae,0x000395d24049ffdf,0x0005918925068e1b,0x0003f93fb9ea4405,0x000a60ba95d141ad,0x0005981c42f76f02,0x0005946bf800414a,0x000435023138c47b,0x000f3cf314147e38,0x0000000000000001}, {0x0008bdcc69ae19e3,0x000ac73cebd917e3,0x000c35337880966b,0x000e6ede2718c3e8,0x000fd10236ae833e,0x0004797bb14f5b88,0x0001296485e76bd4,0x000a68194c12b2b3,0x000b75dc1e45112b,0x000dd88574000b0c,0x0000000000000001}},
    {{0x00037d315eea24bc,0x000160f77a65b38f,0x000de27962237731,0x000bd3346f06ae65,0x0007a25b38b1587e,0x00055c6b9f2a1d2c,0x0002f34b1687394a,0x00054f27c66a0ccf,0x000866c84ecf3de7,0x000b4da4a0f4aaa9,0x0000000000000001}, {0x00066dd8b8dffeb8,0x000121bfeaeff003,0x000a80b5c3bfe941,0x0005b6a4c3fed2fa,0x000c623dfdf4718a,0x000b0791d22ef007,0x000949ccec61c6bd,0x0006e328d9cc6d79,0x00014a1530d03e69,0x000d45fdb36710aa,0x0000000000000000}},
    {{0x0006dcfa61a8d3cd,0x000ff977e2649373,0x000089ee4ac6af49,0x000b86d61720bd71,0x0007848d2c5df2f3,0x00078e07afbcc66a,0x0007ceb1f230a9ed,0x0000d2f61bf5077a,0x000770c3ffbf99e7,0x0001487ae5f08492,0x0000000000000000}, {0x000ee44c464c2996,0x000d8f990f4f03a6,0x000453774274aacb,0x0005c8730ef447b6,0x000e5e02e661f55b,0x0009f13f1011e65a,0x000f4c8fe17d3ed9,0x0000dbeb35dd393c,0x000a7d1cd2327711,0x0003fb444802cd65,0x0000000000000000}},
    {{0x00071a842f621fd7,0x0008594c057a1dea,0x000e1689c80fc8fb,0x00022f52adc9a8e1,0x00099c47b816309c,0x0000c495f00a960c,0x0002e200a0f356d9,0x000a87494b798824,0x000dcd587b7f9ca6,0x0009c4d76d2c396f,0x0000000000000000}, {0x00035970dd6ecf15,0x000449aee47a261e,0x000adfd394c8df13,0x000dfbec67553f2c,0x000aca43c615471c,0x000606556ef09db2,0x000a225f2e040114,0x00099dfb28da12ec,0x000812bc587a4c83,0x0001ab8cba898428,0x0000000000000001}},
},
{   /* digit=16 [{1,2,3,..,}]*([2^64]*G)  */
    {{0x0006146954276a1b,0x0000c171344edf1e,0x000b30130812b4a5,0x000314a14896c770,0x000e796a686592cf,0x00079226d890053f,0x000869a5847ac79d,0x000cf60993a83ada,0x000e4b5fe7d156a5,0x000add7850cdf667,0x0000000000000001}, {0x0005bcbb35fb3dea,0x0000a34e2d6021f3,0x00090be93989877f,0x000303404d6435bb,0x00007e5919257861,0x000c99d1992710c0,0x0001c7987d3586cc,0x0008e8681c58c145,0x00059a487fa896da,0x0009a8b1a9e54366,0x0000000000000000}},
    {{0x00029533273f3ddc,0x0009580b259ba7fa,0x000a4092fea94f8c,0x000efd38be9d56f6,0x000720f2ba425622,0x0007c0adb2a4d25a,0x00018752498a9ea5,0x000d893bbb4d11f1,0x00056b02f195ec41,0x000bca2ad72c4b2f,0x0000000000000000}, {0x000a4013f1ab7060,0x000f17521f983a0f,0x0005292b2f1ebae7,0x00075002debce289,0x00003b6cd203ad6d,0x000c3592c993bfe5,0x0005400a40b351b3,0x000e9b6bafed180f,0x000d6a9f0291283a,0x000563036cf95dd4,0x0000000000000001}},
    {{0x000efa3e474a5b75,0x000e5a6d55141813,0x00008a31bd3435d9,0x0006a68b3c599425,0x000252817b3af9bc,0x0006a695a37f35e7,0x000f06836ac1d6b0,0x000b19a92f525bb2,0x000215d9b8e544be,0x00080723f1554fe6,0x0000000000000000}, {0x000e709e6109d280,0x000e367fd7bcb2f8,0x000be531b1c6fe21,0x0002d1fc5388b64a,0x000c169c0609b0df,0x000cd0fc3d5f664a,0x0003de00815f78ff,0x00049af9ff38956a,0x000e62c250aedb30,0x000af977c662b6e7,0x0000000000000001}},
    {{0x000cfa5a95db7680,0x000cc333878665a8,0x000809b2a4ba5401,0x0009594f6cdc3f0e,0x000e99bbfac6790d,0x000d836074d551d6,0x0009d9ae874e847f,0x000a264b3b0b13f8,0x0003ac51f7a6ec5f,0x00021d6dd250c60a,0x0000000000000000}, {0x000e14abaa7747bd,0x000f127c3196cad1,0x00078a629241495e,0x000ded5d0cbcf8af,0x0005b83d56ec31f4,0x000c6ef029fa54b1,0x000cc516f0a12c6c,0x0000ce830e11ae62,0x000747fe9964fd2d,0x000c6756076a3288,0x0000000000000001}},
    {{0x000b9a69b333564c,0x000cec5ad994fbe9,0x00091ab4f5d4d95d,0x0004dbde503f2b0d,0x0003c8b32fed7498,0x0009fa10339bf799,0x000b1e6b4c7bd908,0x0001c54e64a99794,0x000598ef7979d915,0x000f29a322ae1bc8,0x0000000000000000}, {0x00042520c237fcf4,0x000303a14c0e24d4,0x000f7ed62c67df4c,0x000ee5dfd3635dff,0x00097bcf94654c63,0x000eb529e2ea1f28,0x000969c7cff702bb,0x0003bf0591306903,0x000474be25c3afe3,0x000d8f2570e7350c,0x0000000000000001}},
    {{0x0003d3d928f89c37,0x0004d9c668cfa4b7,0x00097ee2907da69c,0x000fb743bf4c3402,0x000cd4034c59cbf5,0x0009bc4b73d60ae9,0x0007664da82be729,0x0007e3800a84da1f,0x000700f12fb007b6,0x000882b546161eb7,0x0000000000000000}, {0x000e150bbd0f66b9,0x000122fc5d0def4b,0x0001ba0f43d660c9,0x0004e9263a5b4550,0x000ef33c24e5b722,0x000249e1b7ba92b4,0x000aa152b1856c8d,0x00095fe68108b2c9,0x000e766ae6e54017,0x000903a379f58c2f,0x0000000000000000}},
    {{0x000980153e2aed11,0x000ca0053853a90a,0x00003bf5f23c9661,0x0009061283e91bda,0x0006236d967ae1de,0x0004f3d80708ed52,0x000bb014e9c6763d,0x0002f3d82f09bad2,0x000f8d828de34c80,0x000187805c46ac1b,0x0000000000000001}, {0x00086a0c8fd9feb0,0x000d468bed15d861,0x00036573dedab729,0x000d88e4dce7ee93,0x000d9e86caa8e75e,0x000c0d08d6110fe2,0x00082b709f0b0d08,0x000ab3fbb5af39b1,0x000c1b7910befecc,0x00062bf43fafb941,0x0000000000000000}},
    {{0x0005341f232f3278,0x000c66dff5ad0b4d,0x0006270a82ebb141,0x0002897d7912e413,0x0006b6b16ad87fc6,0x000fe7c18f348f2e,0x000a03bae57af6d0,0x000a6d2d6ab02f22,0x00017c3e7efa7a28,0x0009c673423958d7,0x0000000000000001}, {0x0004f0f2ce49ed5e,0x00055b8c6c92190b,0x000aff1be7fa884b,0x0002c375de74b331,0x000f37a676c7d888,0x0001190b6b57c355,0x0009c95180dbbfa7,0x0001d7dc77b1599b,0x0007eba118f76648,0x0004aa840229ee22,0x0000000000000000}},
},
{   /* digit=17 [{1,2,3,..,}]*([2^68]*G)  */
    {{0x000507b4b3de6fe0,0x0009064574b533f1,0x00076eaa707b56c3,0x0005e98aa9532376,0x00034611c9b6716e,0x000eb6a26112d9a9,0x0006e068430b4789,0x000e50fd96103fab,0x000509b62d215cdd,0x0000b7c4da786d1d,0x0000000000000001}, {0x0002a0af86e4be0a,0x0008383ebf635e75,0x0009175f3f7680f5,0x000b999d9f1a0d87,0x0001f04cce1e2861,0x00086e6afd75ef23,0x0004476af7240e6e,0x0005e887f56c0473,0x00094ba352837e09,0x000f469e3dc524c1,0x0000000000000000}},
    {{0x000726e7d4a98265,0x000a397d1e874b3c,0x0008c78c755a513d,0x000fef1392677915,0x000e1e9e24f3ae62,0x00096cf6213d1cf9,0x00004b1f503d4fcd,0x0000f07e39bb0e12,0x000406c607195818,0x00046d3b7b9a617a,0x0000000000000000}, {0x000b43a8c35ac9c8,0x000a92f37f3857cd,0x0008ae49b6bed377,0x0000e3380827d789,0x000e2deff6865bd5,0x000758e466fdb287,0x0001f3ba0c560a0e,0x000db418a2645432,0x000aa26f5d44767f,0x000d36cc7b7f8bfa,0x0000000000000000}},
    {{0x000020f87c5aeb2e,0x00035693c551e0d7,0x0004a7f0938f3f98,0x0008d4d829ae419e,0x000d8e42f19ee358,0x0004d94560e54e60,0x000ddb20bc96b546,0x00014bfcf64c2c92,0x000518fec9517e43,0x000a92773a95b0b8,0x0000000000000001}, {0x000c159b5e61b250,0x00070c6538519060,0x000d0372c4dd1c2d,0x000fd8998866b5fd,0x000ceccabb79115b,0x0000eee1fb689260,0x000b839fc8378f05,0x000677dee33a7134,0x000b9326b080c62a,0x0003ae07e602129a,0x0000000000000001}},
    {{0x0000dde02f16a4fb,0x0001ca814d149b58,0x0003cc8c599eaa3b,0x000d833d43a45440,0x000afdba29de3c98,0x000b2ff2056e31f2,0x000ab3bf81e95cba,0x000649419f19b530,0x000585b648a6e1bb,0x000ff11dfbba1ed0,0x0000000000000001}, {0x0004734696bc60cf,0x000199c0250d4a2b,0x000d4759758b9f4e,0x000f68bc326d4e2a,0x000cea78113abc32,0x000d248f92840b01,0x000d61ebd87644ac,0x000ae9a32d38a8d8,0x0000c706b58a69c2,0x000561f4b942e16a,0x0000000000000001}},
    {{0x0002fe7e20769488,0x000a1c068b87a199,0x00032a3459c496fa,0x000e96c391b8839f,0x0007f4914cec7211,0x00039756176c58a1,0x000aa63441905f9c,0x0008ea16377fb867,0x00042578ce2a2865,0x000cd140c73dd697,0x0000000000000001}, {0x00074ef7ab059a14,0x00031e0f7d0f636a,0x000fea67e10b4430,0x0006ef5711a15a06,0x000f717856862153,0x0002513381cfd3a9,0x000a8b9906086974,0x000a08521bae079c,0x00052ef6a1d4b90c,0x0004f5ad24ad39a3,0x0000000000000001}},
    {{0x000c2d28a3a30e7c,0x000933949c694069,0x000d1f2a5ed527fa,0x000e2b5573d97d5c,0x0006aa892b500798,0x0008ac4418f1419e,0x0007bf2d1e227f12,0x000bc2143f4c8a62,0x000ae6ef99da3403,0x000679827f46143c,0x0000000000000001}, {0x000a8cba49268935,0x00038ccee58ce9de,0x00061df0ac493218,0x00075eb49225f314,0x000073000d3eb206,0x000145d79e65edfa,0x00007b1990aba7cc,0x000c916353a37685,0x000854a40d94fba3,0x000cb2e109e1b50c,0x0000000000000001}},
    {{0x0000c263771f69c1,0x000d1595543d358f,0x000ef2e3d8a56184,0x0005866bc8c3965a,0x00021c100a7748c1,0x00029b46541a4ddf,0x000c5cb49ea744d6,0x0007a3a96b8b1fb0,0x0005aa7e85061bd2,0x000163e83c339e28,0x0000000000000000}, {0x000102ac6923a672,0x0004153c3e1bd59a,0x0003473bcdaf9384,0x000f589da2a6c958,0x0003af0eb1a0311a,0x00041f50baac8d3b,0x000bd2c8728d9afa,0x000fc24b4e16e953,0x0003e6d4570ad37f,0x000aac57efaaa8de,0x0000000000000000}},
    {{0x0008c7fccb0a85bf,0x0003bdff198eec53,0x00029ee8af84ec04,0x000572ea125b846f,0x00025280cfc9ed01,0x000f73f2654ba803,0x000ffbf57e3b7be3,0x0004f83701a26bca,0x000d20a251a2d372,0x0003ec410f80b319,0x0000000000000001}, {0x000961197dc0e519,0x0003d8c136f93b3b,0x000000ba8d6c2646,0x00084f848d99824e,0x0003fcfbb42b20e0,0x00038715f781fef3,0x000bdd048ed10781,0x000042869724ca7d,0x000de2c203c66b90,0x00090489fab2c4cf,0x0000000000000000}},
},
{   /* digit=18 [{1,2,3,..,}]*([2^72]*G)  */
    {{0x00038bb0c7aa46ca,0x000d2cad2e37a158,0x00054d33ad65a28c,0x00004b20d4f1caa9,0x000b180e4c9d244b,0x00070a13f58c65ce,0x0008816ecff016c3,0x00016ad260aeee75,0x000dbb7b595c36fe,0x0002944d06dfe8bb,0x0000000000000000}, {0x000c325d67839921,0x0006a5955c2a22f5,0x0001664092579a37,0x0003aac4f8e9390b,0x000722a8dbf2236b,0x0007b02d94034f2b,0x000fcd8d5de86b97,0x000fa8bc9f80729c,0x000bcbc03be296bc,0x000364ec1469f11d,0x0000000000000001}},
    {{0x00048e2fcaa83f58,0x000495fafcc6105f,0x000d34073fc2c5d9,0x00042510321d1a08,0x000d83427742e304,0x000ec5f97b8068ff,0x000530da7faa8a52,0x00005d010e52ac14,0x000df5701f277a14,0x0000eacdd532283e,0x0000000000000000}, {0x000f566cbb172daf,0x00050c51771845f8,0x00066aafeeea7b0e,0x0005258081cf4ee6,0x000c71bc2c6ec8fd,0x000790d250232a19,0x00011bed4c06ab26,0x0000acd06e0bdc44,0x000734273e0fd2a2,0x0005c1c9fb738a19,0x0000000000000000}},
    {{0x000b6ef22ab96e69,0x00026b8cd18dc5dc,0x000563a07bc4111e,0x000f73913482455e,0x000edcb5ec4ad0e2,0x0000caacaf21483b,0x0000f16a5a48441c,0x0005bffbf280c9e8,0x000f37a7690242b8,0x0002eed954418691,0x0000000000000000}, {0x00066d6e31428479,0x000f47fc4b8794a7,0x000a81360ec38293,0x0004d77d31e9f867,0x00042db92af31be3,0x000d799976882df8,0x00005ddd34a906cc,0x000b961ddfb3abb5,0x000bbb326a3a37b0,0x0005d4f7af85a74f,0x0000000000000001}},
    {{0x0006d183b4b1bfc3,0x000143cdd1f50d0b,0x000721cf9d088770,0x000338fad247118a,0x0004efa498ee55a8,0x0008d9808733ff45,0x000faa72107a954a,0x000a392986064eae,0x0000c503bc385af5,0x00095cfc7e0cec3e,0x0000000000000001}, {0x000f6c1133ea5097,0x000685bf161ebfa2,0x000bb087e9c48b5f,0x000987c958eb481e,0x0001ea465a54c3b7,0x00081943446e92e0,0x000a8941e66d88ba,0x000d40dc6c71b0c7,0x0007f59a3690cafa,0x000130f02679ac05,0x0000000000000000}},
    {{0x000c5b4b93b19e8d,0x0001b316df16919e,0x000549bdce1a1a0a,0x0001cc00d06d528f,0x000cf17722a1d1b7,0x0009c7821f1ae098,0x00007c6fc2825a3d,0x000f796a6b06d5bd,0x0004ca4366a06040,0x00072103b88040d4,0x0000000000000001}, {0x00038b6ea0266cec,0x0003d4ff03eab713,0x0008f81bfb033aae,0x0004b58cdd700e03,0x0002486b62595d6a,0x00027288e5a75ffb,0x000043649c2c3428,0x00056516d9dc3a87,0x000145473b4564bc,0x000f9a0961272b27,0x0000000000000000}},
    {{0x0006ad885aea13aa,0x00022fbb0e237052,0x000115fb0a1aa034,0x000ccb8ce398278d,0x0004178f8f78a3bc,0x000403be5854a510,0x0006bcde0e2e720a,0x000edf5f632b7fc4,0x00038eed71d606d0,0x000d21f92dbc6d75,0x0000000000000000}, {0x000631ff7cd8f78c,0x000698475f524849,0x0005eafa796bd6f5,0x000fa7a4ee42bd53,0x000b8f8540687776,0x000540f9fdea3095,0x000f5bf17004e5b9,0x000834c440599d47,0x00063874f7c8a4ef,0x0006bec9a4f28185,0x0000000000000001}},
    {{0x000c12a0297bd390,0x00020c5821857743,0x000e07f2b528d6e4,0x000318df51deafc4,0x0009c03086d94e26,0x0004d01fde5e064b,0x00071c1d5855c1d9,0x000cdd2d762cca56,0x00022e583500cf8e,0x0003f52279b68b61,0x0000000000000001}, {0x000b572837258eb6,0x000b88af33e25ea0,0x000ba976e7082c63,0x0000d0abef5e06ce,0x0005c8fda6ac69af,0x000f82b26435f42d,0x0005ef9369e629b7,0x00029491bb2be768,0x000ae13ca4da59b7,0x0000f00ce8846bfb,0x0000000000000000}},
    {{0x0000079959682d5c,0x00076719e3233b3a,0x000c78c2194cd545,0x000e51d3c744ff86,0x00053afacd6dd789,0x00098cb1ba7a5cd2,0x0004fb918b560853,0x0009ff1bce38273c,0x000a7efa90ba240c,0x000ba73bb2e372bc,0x0000000000000000}, {0x0003a114b353d398,0x000d2df4adbd1d56,0x000e9ad940e90284,0x000fca7fe3af63ef,0x000de96feaa4e61f,0x000bf94ff4ba0669,0x0005279d7b8471ad,0x00071dda976e696c,0x00066b8800a22911,0x000f5fba44b58815,0x0000000000000001}},
},
{   /* digit=19 [{1,2,3,..,}]*([2^76]*G)  */
    {{0x000b896b5317311c,0x000ccb025efc3b29,0x000bcd9f85c60e34,0x0005f821ae29c1d9,0x000293dcc63561e8,0x000f95824c27219e,0x000843c9e01039f3,0x00048ef0f79fd3a9,0x000ddb5a3bba44b8,0x000011f0a7f5379c,0x0000000000000001}, {0x0000be31597dedd3,0x000aaa0d73669dd4,0x00090c605d60706d,0x0007d62f262a826a,0x0005e90997b0e2e6,0x0004dc73225ac29c,0x0008be39728fe4ca,0x00038656b7a746c2,0x0008bd5a3cf46a3d,0x00080a0c58ac7031,0x0000000000000001}},
    {{0x00070e2b4e96cd1b,0x00023ea39d68ac53,0x000f98a99040b26e,0x000362a9be557ba1,0x0003c202765cccef,0x000726d7b5a7731e,0x000faf8cd815e2ba,0x000ba6579cd91c25,0x000ec8fb3dafb2e8,0x000af4648049fac5,0x0000000000000000}, {0x0004b6251452046e,0x000cb296110b89a0,0x000551f88c9d1ddc,0x000bbb0b0f26d015,0x000c2b5bd39d39b8,0x000dc18ef79d52ff,0x000b527ab6d006e2,0x000a804f61d0142f,0x000be5992391511f,0x000815a3e717ea9d,0x0000000000000001}},
    {{0x00029eaddc553333,0x000212246b16c20f,0x0009da31a639b833,0x0005a63d297cf150,0x0003190a2a3a8499,0x0002ca8af6260545,0x00018490cdf918d2,0x0005a5ed4b646253,0x0004fec387ca9de6,0x00010b72b35acffa,0x0000000000000000}, {0x0006d539b23d78ec,0x000a4b221e3646f9,0x000b6bf83af256f3,0x000d62f0c408a90f,0x000fdaefff14a7ab,0x000e41ce0c4069cd,0x0001cba29824953a,0x0007a382ab7eb47d,0x0007f64599eb440b,0x00074a4c148b6095,0x0000000000000001}},
    {{0x0005a160c85caa71,0x000f0e79edff6be6,0x0007704970c1ae3a,0x000a395f8b957c42,0x000c85f0f181eb8a,0x0007d8f529bdf3d6,0x000d3534e626c58e,0x000c770dabfad83f,0x0003e65d7e5ada98,0x0005676430730bac,0x0000000000000000}, {0x000d0476d73fcec9,0x000d714dcf97c309,0x000a56a3252ab9b5,0x00097fc79648c08c,0x0006b897ba609ff2,0x000c446a06ff8430,0x0002d01ddb643744,0x000f97ee1218bc20,0x00048db33f9b0f80,0x0005e8b5f54bb8f0,0x0000000000000001}},
    {{0x000851bfcfbb80d1,0x00082b51c40077e9,0x00087cd565dbfe09,0x000954bdd372a1cb,0x000f6bbff7b4dccd,0x000237c51d294b36,0x00003d64ce0f8798,0x0000569d6e3c2614,0x000a6224fb79e0e6,0x0004d7c33dd3b5eb,0x0000000000000001}, {0x000f054ad5a9cfa1,0x000bee5f93daceaa,0x0008aa260aa160bb,0x0005025da9f4b722,0x00004817d1e67b1b,0x000e00279781308a,0x000c2084afd2f00f,0x000c154f68e6680c,0x000c6b0f1d4b7ecc,0x000fe2b89761184c,0x0000000000000000}},
    {{0x0007fbeff2b9ea68,0x00035c954c6cefab,0x000062277d67291b,0x000820637553137c,0x000e8b75730d8af4,0x00068d2250710c68,0x0007a2fbae3e7c1b,0x000f6b643e1aff63,0x000dc46991ef002b,0x00096e38ab4582dc,0x0000000000000000}, {0x000bea0d80f3758d,0x0001d6899ee62692,0x000cdd2a79a4d763,0x0002f50f2ee3aea9,0x000fb1476eea0816,0x0007c81475c4d433,0x0009d9fe82142372,0x000756c76934dc96,0x00033eb086d918c8,0x000e3056d2a89175,0x0000000000000001}},
    {{0x000ef0de9496fb55,0x00076806fa762c50,0x000770bcaf6f226f,0x000a0d3e47cff6b0,0x0004eb780ef8cec1,0x00034df87449872a,0x000896382a505c84,0x00046b56a94dfc29,0x00021c7a5c037f2d,0x000659ef98ff9417,0x0000000000000000}, {0x000001c935289072,0x000f4a229e4010ce,0x000b1be023ab7710,0x00073fb44f780b68,0x0002944ddc611373,0x000ba09ab8b61290,0x000be003d4bb157e,0x000f7557730f52d1,0x000506c275d184bf,0x000c57abea8b4979,0x0000000000000001}},
    {{0x000004498fadaa48,0x0009d0bea3c3894e,0x000a8f46458aa39f,0x0000008b0b3654a0,0x000ca4cd7392bf83,0x00012eb97aa46a22,0x000b9cb80e1d7afb,0x000cf74c8adcd888,0x000b51d04bb6e179,0x000b50968eb22473,0x0000000000000000}, {0x000f96d03d831756,0x0007499de9e10051,0x000ecddcd4ffade3,0x0009dbdffc72771e,0x0006b5e1bb9647aa,0x000addb508dc2415,0x000ddf40de78eeab,0x000ab1c488946fac,0x000c823824a964d6,0x0003b16f258c8749,0x0000000000000000}},
},
{   /* digit=20 [{1,2,3,..,}]*([2^80]*G)  */
    {{0x000cc508d53fa611,0x00057fcd40894532,0x000f3eb54e960b10,0x000ea40877d231ff,0x00043e5110313bd6,0x0005209f6eb9ee83,0x000589764924e778,0x000332e258b2e7fa,0x000e2e038618a6eb,0x000aaf96067c3511,0x0000000000000001}, {0x00022156015c8ff4,0x0003a0ef974e440f,0x0008ea1f931a1b7a,0x000e417472932b48,0x00003bb75d745720,0x00096758e51bf9c8,0x000f97c7f0b39099,0x000b39d56a488d83,0x000fe1ded1fac932,0x000399aaf43ccf55,0x0000000000000000}},
    {{0x000fb78344f73774,0x000a49ad3e73876f,0x0008771e37ad3158,0x00003f2cb98ec469,0x000f31bd531106f1,0x000434959ff8325a,0x00064eee47f875ba,0x0001cf224bc0a102,0x0007d33a19ccf2f6,0x000f2186ce603133,0x0000000000000001}, {0x00006e91f2869773,0x0000239179c5ea67,0x0009aa4ed3879ba3,0x0003eb977e239f26,0x00090ef091443aa8,0x00036fc4d282853a,0x000a0bb2b260d343,0x0008119fbd0756b3,0x00053a3a6e0f1619,0x000016a2af080234,0x0000000000000000}},
    {{0x00000185bd1fcc92,0x000a0002ebe1f280,0x00030d3e5f23ebcd,0x0009d40f75cccaba,0x00063108edd488ea,0x000028024e152a65,0x0008296732e422c6,0x0006142e6cc11761,0x0004e44889dea726,0x0004d1b05325e95d,0x0000000000000001}, {0x000270a2e4063870,0x0004d9c29b5dcaf3,0x000d2f759d7bad98,0x000ff7c2ad7bc046,0x0000fa4e4f59d347,0x000a06be29c16d4c,0x000bb31872d14ff0,0x0002b7a5b6ec2390,0x0008ae4cc66be2ce,0x0007006b9b1fe040,0x0000000000000000}},
    {{0x000c4cee52cfafd0,0x000916a99628d59c,0x0004417813a4764e,0x0003f0c49a05da16,0x000992babb644e42,0x000179a66e24dca8,0x000cbef894f6883d,0x0001ed7756c7c157,0x000ff08e144c3013,0x0008ac78b0a3e9cd,0x0000000000000000}, {0x000dabd753963ba6,0x000426be7ba3ec43,0x000d17b8f8b93626,0x000d7ac0bfcd2a78,0x000c2aeda53c9486,0x000c99eeaefc3c49,0x0003d0949fb4a9cb,0x0005db07562812ab,0x0005da4c6c0f863b,0x0009e08ec31fe43d,0x0000000000000001}},
    {{0x0008d00b0f45825d,0x00075f4acb7a9109,0x000fe317cf8f4f81,0x0009a77cf8155d16,0x000d7ac3ddeef2bc,0x000aeae3c417520b,0x000e6ff44ee6fbc0,0x0008d8c238521aaa,0x0003f42c9f47bc82,0x000d2fc09b26d055,0x0000000000000000}, {0x00032ac7c6897ed6,0x000498c1e669bb9a,0x000697322f4c8aca,0x000625a543042d46,0x0003cdf16aa69334,0x000b4b67c267bda0,0x0005d6f205d341fa,0x000005daa2bd83a5,0x000c9573fcdfd94e,0x0004e81cb76afe9a,0x0000000000000001}},
    {{0x00074fcede51930f,0x0001c997863b91f0,0x00092d449a3c4328,0x000c91197a68c2d7,0x0006a3b2de0b3063,0x0003e7d82555e166,0x000f427f70b4227f,0x00066c04e18d6aac,0x0004c82c2c2b9b61,0x00095a376fa210aa,0x0000000000000001}, {0x000de0f4a3a29f55,0x00023263844f1727,0x000fd0bec7770941,0x000e79f43b5f4e85,0x000035cbc9a5768f,0x0005bb2328826a73,0x0008a77da7d22096,0x00096978fe424078,0x000ae1a0514c7cf9,0x00085e77943ce3c2,0x0000000000000001}},
    {{0x0000d1b4594afc85,0x0006a925e9937fdb,0x000d1cf398814c56,0x00000694cd250848,0x0005fbfd82b6ccc3,0x00047db4ae135bc7,0x000c1f18639e63fa,0x000730a5e5b32295,0x00041bb1c61f91b2,0x0009451335383b28,0x0000000000000000}, {0x000df27e3f2dca32,0x000ee40fb695c7e1,0x000c8c313d1721a9,0x0008bc93267e9801,0x0006a9aafbe12b28,0x000e34c2b180d7a3,0x000e6b65e8b79ae5,0x00047da7f03b22ef,0x00094e563552e913,0x000f4aab16538cee,0x0000000000000001}},
    {{0x0006db42e9e50fad,0x00042149f7546b33,0x00057093c06f6900,0x000dbce88e00d7d3,0x0004ad9ede7428d2,0x0001940521d004dc,0x000e4970d3be2ce0,0x00031bb5cf60dc4a,0x0003df5670a6ccb0,0x000b64df04605d80,0x0000000000000001}, {0x0005f0fb0c7d8a77,0x0006951f8ad28aa0,0x000e5b908dd39d0a,0x0005f76fd67e92ff,0x00080f281077f416,0x0009ee2db2c8d529,0x000e9a09ff0b841c,0x000f9a5850f2e792,0x000e9887cd74d1ff,0x0009aa468c4978db,0x0000000000000001}},
},
{   /* digit=21 [{1,2,3,..,}]*([2^84]*G)  */
    {{0x00045bc39568d9b4,0x000deebca99c74cf,0x000ae132b3816aa0,0x0003fb57b713a9d8,0x000e4139b0131f8d,0x00042164bbc38156,0x0005a533293d5ffc,0x000f28a54d0e74da,0x000246758970fcef,0x0005cb3ef8fd2b56,0x0000000000000000}, {0x000e59886b3941bc,0x0009ade1a4b217a0,0x00023117719aa3f6,0x000c88c1b7b4e45e,0x000c3f1294233118,0x0001ed8c9dd7dfa5,0x0003ffafa2104f8f,0x000e89ed71382221,0x000d0f8573ea0a97,0x000a81f09db9f82c,0x0000000000000000}},
    {{0x00077d542b1d8c85,0x0009eb6c76648a7d,0x000ae9936fca1675,0x000c8db3d9556eeb,0x0008f1fc23af7239,0x000956a6643df02c,0x0005264fec894e1d,0x0000aaa92f802a0d,0x000d756f014a90b9,0x000e0753d197ff93,0x0000000000000001}, {0x000dc80b7f62d4df,0x0005de026f897406,0x000bf46ad6add1ea,0x000f1c5d1c416858,0x0004d6b3d82ce8f0,0x000459159df587ce,0x000ca473b92c19aa,0x0006da5bec10b6ba,0x000e0b4be600af3c,0x000cf6c81e2b9b40,0x0000000000000001}},
    {{0x000c67c15f2b99a5,0x0002e78f41b12d02,0x000f7e85b9e3bb96,0x000e6c293dd82110,0x000a0b7296f35eee,0x0008b9f01a446a48,0x000f7d8d89873daa,0x000d90409d0bfd67,0x000b42d1c91c3962,0x00005e6c3afa1fdc,0x0000000000000001}, {0x000607a511880114,0x00046b3caa5f65bf,0x000ed1d7edcb6427,0x000223b76ca3eaf2,0x000c254785aeacd8,0x0003d96bed772614,0x000fe17074c3138f,0x000fc4599803c303,0x00029d4441854c4a,0x00068d2f47c7e6ad,0x0000000000000001}},
    {{0x00027dadf66942d9,0x0002d934d4f0887d,0x00024ab4a3b4ff58,0x0008094d151ee4b7,0x00059df116aee58c,0x000c8ad8141ceee5,0x000c277f6cc0cd16,0x000b9d41dd2c3d13,0x00018d63c75e0cd1,0x000c06bb0767f3f3,0x0000000000000000}, {0x0003f3f369ef6b69,0x0007808f1170f91f,0x0006338ef6344906,0x000cb4597495e6b8,0x000283f524ab766d,0x000d7731127ec634,0x00075be86373e0af,0x0008d2af0e3a5495,0x00014c6819dfc2be,0x000f7affa7af5c63,0x0000000000000001}},
    {{0x000892c7124cd33e,0x000b92182e71043c,0x000db014cae4df90,0x0009ceb0a4ea4119,0x000ef942ed19b706,0x0000628b68098d1b,0x00084c6cb159ff0e,0x0004d4b5184cdc53,0x000190191d032e77,0x0006b2ec68efce97,0x0000000000000001}, {0x0003436236c90d20,0x000e12c74816ecfc,0x0003e074e74849dd,0x0007be255b09c30d,0x000526507824bfa8,0x000ef7cb512aeee2,0x0002afeb20a50c2e,0x0008aa489a2c4123,0x000334adba554c1c,0x000ed1b94b601c93,0x0000000000000000}},
    {{0x0001c752e894f83b,0x0001102db47294b0,0x000efd031528755f,0x0008e7a5233b9d7e,0x000dc69c62c7500f,0x00051f44711ee3b5,0x0009d94a5e280f05,0x000b11042cd8c7dd,0x0008b14370c2167e,0x0007807f4636e4af,0x0000000000000000}, {0x000598691d482817,0x000b8412f599a077,0x0000459d6b4cf61c,0x000405e26f27cc0b,0x000ddbc7fdaf5126,0x000cdbba7c4a3026,0x000b262658e4a3b0,0x0000f2e795bb25d0,0x000766509eec95e9,0x0005a452259c52c8,0x0000000000000000}},
    {{0x0005f6dc2c523bd7,0x000003d082f18f83,0x000ef7ee57fec42f,0x000f2558c3c5a1e3,0x00038f0a9e89f93b,0x000efbe9151ca6a7,0x000ed767c4685458,0x00079d486204e6f8,0x000a36a1a4b728f1,0x00043b885c25b705,0x0000000000000001}, {0x000eabc2b52d4646,0x0006c95bf22f084b,0x000314aed2f78fee,0x000dd61877362fd0,0x0009044697d005db,0x0001d56d41727a4e,0x000627e07ab413dd,0x0000b5903e3cd67c,0x0009c224e9a02779,0x000806739d1d3428,0x0000000000000000}},
    {{0x0004109673b0becb,0x00029788f9eb9435,0x000ae5dfb3d20da6,0x00057d88527623e5,0x00015c844e99c175,0x0006a57ec3b40311,0x0000b594aff5aa0b,0x000cea2e84adbe7d,0x0007fcbaf1e84a37,0x0008e3048c293594,0x0000000000000001}, {0x000f58bede275de5,0x000b21503171b093,0x0007b8e1c737aaa2,0x000dfceb6261f263,0x000d21e8e8701620,0x000e453d37db241d,0x000825774e79c85c,0x00066f92bc717db8,0x000b9d9ff5a2566e,0x000bfd4ae0bd7b6f,0x0000000000000001}},
},
{   /* digit=22 [{1,2,3,..,}]*([2^88]*G)  */
    {{0x000cd0f9ef7a9efa,0x0001757bbdb01042,0x0001996a380a3fbb,0x0009e651f39db731,0x000cdf3f08146bb6,0x000679b0b6ec6679,0x000ae26608474788,0x000d883e5a5990d1,0x00061924fa5e209e,0x0001de3c755c0bba,0x0000000000000000}, {0x0007c1f82ebae92f,0x000ccf8ace9c6a84,0x000857d9026a1434,0x0005b0b7ad864d4c,0x00018f613e2210ee,0x0001165b2c86a357,0x00019fb55984d679,0x000f15401901080d,0x0009a0e8b3389ecc,0x000e608b509b98d9,0x0000000000000001}},
    {{0x000a526cf604c662,0x0003afa9ed0f7a0c,0x0001dd685ac125b3,0x0007ff8f516f5290,0x000ad927c416e17e,0x000fc77cc9720475,0x000071767e1e9190,0x000f6652fcb33aec,0x0000f0d48cb2653d,0x00086c8bf16720d8,0x0000000000000000}, {0x000404c440590fcd,0x0003377f43e4e408,0x000defb22729c42e,0x000241aec3b37e10,0x00092c795c866daf,0x000f4d30790a07c8,0x000075bb2425f5fb,0x0001b7cb5830a5db,0x000c950890875f16,0x000e6591cad66493,0x0000000000000000}},
    {{0x0003de8c91c31e47,0x000a2de46bc7eb7b,0x000f3de301a0b479,0x00094aa7479aa235,0x000be5191502fe1c,0x000266a8b4adef28,0x0002961e0e185a17,0x000f211c2c23ddea,0x0007d3314a5b8f85,0x0007d3d59f2b026d,0x0000000000000001}, {0x00032b1fd4f159bf,0x0003721f923e006e,0x00024a7d38b715f2,0x0000994620d23277,0x000ab6678b2917d4,0x000fa4a8245b0c3a,0x000912038e0b4172,0x000f6fdcf8c4b1b8,0x000ccd3b3eaaf19e,0x000d40f97e7249e4,0x0000000000000001}},
    {{0x0007975597dddacd,0x0009d9266f6975c3,0x000599f544c22dfb,0x000c2be6db081480,0x0002aeb8ec462839,0x0009d49cd3b5cdf1,0x0006a8ba917fb29d,0x0008233b216f9614,0x000abf1a9d936c0b,0x0007878c8a45a2f0,0x0000000000000000}, {0x0005dd64a0356029,0x0008c2d1625aef0f,0x0005ff56fc705652,0x000323cb9b293d67,0x000bd02b295cca5c,0x000c7129104d697c,0x000d83fe4eb4b02b,0x0004a4e9327cc1e4,0x000f46cdc9c23cdd,0x00053f946406995a,0x0000000000000001}},
    {{0x000d1e43a1e16a36,0x000514cd5be788b6,0x000f3827d2f55b7d,0x0000a3f8f594d05c,0x0006accb980d1448,0x0004ad1e4f1f6b59,0x000e7dd3016801fc,0x0007c435098ccf31,0x000c6bc2e61b9059,0x000588b12be241e3,0x0000000000000001}, {0x0000b8e2e65481b3,0x000aef410135fbc4,0x000c7a2e23221960,0x000fd4a513faa141,0x000a0357c6f569e3,0x000f4ac3eadff143,0x000f6174146f64bf,0x000c13f9a5506c59,0x0005ed7b5be845e0,0x000d0deb4721eef8,0x0000000000000001}},
    {{0x000e8dfde28d4a2d,0x0001761a2d5208a2,0x00005b6ff5ebb541,0x000b58d09bebbafe,0x000a9eccec1be769,0x0004b3933ce41d83,0x000e22e31e1a1a39,0x00081430e109c5df,0x0005c36dffc66dc3,0x0006a93ad68549c2,0x0000000000000001}, {0x000135d5a197f614,0x000b4beb4875f558,0x000374737f60f213,0x000b3391150b17e2,0x000fd51cce3f02fd,0x00090f492191217f,0x000bccbadc4f8a8a,0x0005d89eef2479ce,0x000b7145781a1c26,0x000e4d791a7d8953,0x0000000000000001}},
    {{0x0006a3d38b806bee,0x0002ffcbc7fbb018,0x0004904b1192a4cb,0x00039b7f571c01df,0x00040717c8035f6f,0x000f75f4a725c0f7,0x0003575b1f8427ca,0x000cefd7922924c3,0x000c3f91c6705a27,0x000f14804d6b5694,0x0000000000000001}, {0x000d6688c387623f,0x000533d1b2b7249a,0x0006a96c61952611,0x0009fa8adb7cd547,0x0006614cc5f19687,0x0000dc38a5b55739,0x000b43a1185de8e8,0x000489b0890de38d,0x000cfe16e6aaab3a,0x0009a02c0ab01066,0x0000000000000000}},
    {{0x00047414fc9de104,0x000b82aed9435d61,0x00062ff16a9bd16d,0x000caf4a3b07e71a,0x0003ff9456ee752d,0x000d78dd65ea0d3e,0x0005bf864901fef1,0x0007bc9f42253114,0x000cb13ee366fd36,0x000fe6290083f481,0x0000000000000001}, {0x00032088e6e77ebe,0x000f38c5e887c852,0x000f005e149cc7b3,0x00089874e1bede78,0x000c72dfeaf32e8c,0x000cb0a4d9cb4e28,0x000aba5da48c7113,0x000b1fe289a0af7d,0x0005d0dc00d3633a,0x000801c0b05c86bd,0x0000000000000000}},
},
{   /* digit=23 [{1,2,3,..,}]*([2^92]*G)  */
    {{0x000567a7a06de008,0x0007cf045155d807,0x000ce8bb24635169,0x000c2900cba64633,0x000c724297174dd5,0x000c3a3851e7f044,0x000f59548c830bf0,0x0003817a26f0d35f,0x0003d8b027d923f5,0x00062c2b3dd7cad9,0x0000000000000000}, {0x00094cbf6924bf9f,0x000c09986d299bcc,0x000f89ccb5adf6f5,0x00099f825aee26f4,0x00056c1b545bb186,0x0000d22aa56595e6,0x000ba5ea3953faeb,0x0003a9580b4b6abc,0x000465246d4e240d,0x000d8613b6fdf7ef,0x0000000000000000}},
    {{0x0008a64cd725af51,0x000d6dda66823389,0x0001f40d7d1c8516,0x000115e05fb1f564,0x000ad7906c2d8d5a,0x000f4efe00496ac4,0x0002d973643f7076,0x0004414f58386c89,0x0002d83c2e34b14c,0x000437c00d08bc7c,0x0000000000000000}, {0x0004451656bebe71,0x0003f2219e2e5bca,0x000118227eacbf3a,0x0007e2cef1a84019,0x0002d58a5f9de601,0x0001ecfa6e192212,0x0006fb198696eb0f,0x000854826be2d3df,0x000dea0068fefc08,0x00074e77c2979102,0x0000000000000001}},
    {{0x00048eb205a5b22a,0x0007d680f21ad148,0x0008e50bcbdde0fb,0x0006f6074c1119fd,0x00079f9f2e43583d,0x00065361f1d9961c,0x000463e625f26bb7,0x000f2b47c8db008a,0x0008c397787cd134,0x00029b36eea7ef32,0x0000000000000001}, {0x0006647223894ce2,0x00087adfe036fb3d,0x00067daf1eb206e8,0x000b19b372f017c4,0x000a8ad33a99ef7d,0x00055c0da806ea7b,0x000c02414bd637ef,0x000b598649739b12,0x000feed3dd282f3b,0x0003ecce69b37255,0x0000000000000001}},
    {{0x000e5f81ac137092,0x0000518f81e9a3bd,0x0009720014a7f4da,0x0001f457a02bf073,0x0006be074553e9ff,0x0004351eaa3a46ea,0x00022b27e32f0dd6,0x0003b488462fd22b,0x0006ddddacafc2c2,0x00035bfb75908f56,0x0000000000000001}, {0x000987332b5b9a11,0x00044ffe94dfd9e8,0x000f9b91bc64f63b,0x00077f430dbd772b,0x000dfd580392aecb,0x000ddc69fb2fb67d,0x000314d2fdb69c91,0x000e754b9b9f9ea2,0x000f2e9c2e624f23,0x0000a3c6e677e1f3,0x0000000000000001}},
    {{0x000e37a930c3bc57,0x00006f969b4cf1af,0x000df3ff74237c4c,0x000d1ea35c488b6e,0x000e084f47372a77,0x00065b61ccb75b2d,0x000a4e47577fd773,0x000dbd98a086f5f2,0x000533002b74aa9d,0x000bedfb9c8068e6,0x0000000000000001}, {0x000b7aec02da823b,0x0009baf08dcbb7e2,0x000400bf0e5f485f,0x0003a3c7f9dfd4e3,0x0007472ece43050d,0x00091a092b1134f2,0x0004c1a0e70ff8a8,0x00037f3b75a31807,0x0000f51f254e9906,0x000c2183d0367614,0x0000000000000001}},
    {{0x000a39c0dd80f6fe,0x000a13cb07adfd25,0x000ee3ca4d8c1a3a,0x0007a28212986a18,0x000c5167c4c47943,0x000beb7b7306e9bb,0x00038cfc9b26c1f3,0x000b68e5bc206604,0x0003bd9665b63ba8,0x000661b9d7de6c40,0x0000000000000001}, {0x000c9e6e7c3229ea,0x000fb93cb721672d,0x0002429ae120fbe8,0x0007d3de1f64e3d5,0x000492888bee099a,0x0009c2f4894dc1d6,0x00011bda9ef3c7dd,0x000289559ae47758,0x0008fcbb34df4ae3,0x0005c440c5d0ce22,0x0000000000000001}},
    {{0x000fc1fd2377e231,0x000257cc9235e4c6,0x000a8f0482692e0c,0x00027d24355728b1,0x00087856d3663645,0x000dfe4f7c7f19ee,0x000c0f9ccd7eb847,0x0001019511788244,0x000c4838c54b2a98,0x0008b89d2d46944a,0x0000000000000001}, {0x000e02a1a1d2a70d,0x000b7d63b4d27dff,0x000ab61d5fa9a970,0x000d7730420f7a7f,0x00079f4479996041,0x0001189500cc1597,0x000981b342dd1a18,0x000b0c87b154435a,0x000fe5a645fb9438,0x000a1ab34fb7fc43,0x0000000000000001}},
    {{0x000f438f4b100160,0x000f22d13ff0c314,0x000d55796ecb8e45,0x0000ab873dd2e2bb,0x000789eb71d33f83,0x0003167e0b14a364,0x00002c246513aa48,0x000b03e86d3a7935,0x000b2db2bb0fe98c,0x0000d70404a0ec4e,0x0000000000000001}, {0x0004384c5c6b60bc,0x0002570cd19a5c8f,0x0001c33b468c19b3,0x000cbac39210942f,0x0007d36048a2a29c,0x000f69ef5fd4ffa9,0x000ece5cd6b0a674,0x000b1322973982d0,0x0001493bd4bce1b8,0x00083d4d6596bf49,0x0000000000000001}},
},
{   /* digit=24 [{1,2,3,..,}]*([2^96]*G)  */
    {{0x0000db5e813acae0,0x0005831117f6d456,0x0001106059c8e19b,0x000f908ce8232c57,0x00092d0f09782c78,0x000bd0fcb64a24aa,0x00077e3d766becf8,0x000f155f53d2f599,0x000389ae2fa9a727,0x000920ff877e9249,0x0000000000000001}, {0x00085d510d2d4458,0x000dc73b4e520499,0x000aa68342be4788,0x0004f89c8a0ca8e6,0x000e8668748927b1,0x00017375ddf19eb3,0x00041d15e5f8b7ce,0x00052912af54652a,0x000b9a777a86a727,0x00003bbaf706d85a,0x0000000000000001}},
    {{0x00017d39542a7b35,0x000d6953d2cbb145,0x00044a3ef5b5b733,0x00076565472126ff,0x000b2a4a1334dee0,0x0002573d17b26c37,0x0002c7ab5b295171,0x0008d328148c129c,0x000907f5aa2c72b0,0x00018b1d10e10308,0x0000000000000001}, {0x000159666154b57d,0x0005dd9359d8885e,0x0000281b6f14827d,0x0009bc4ba475f3a4,0x000c32eef44696b1,0x00082b50dbdc6dfb,0x000236a9ef4383e7,0x000fd73208450583,0x000d190b07767db3,0x0003153c0278a00d,0x0000000000000000}},
    {{0x000ba905f5456251,0x0008ee5b3d8d39c0,0x000ea2a0a4462a26,0x000032f3094457cb,0x0009bab36ceff80f,0x0001b0fdf3879073,0x0009dc840209bce2,0x000df0c1c8e03824,0x000c51d81213ecb4,0x00063c2b025e0d70,0x0000000000000001}, {0x0003bb32c4b899f8,0x000ccb798bfbf249,0x00028838277f622f,0x000e5b67c2594827,0x0003c2c07c4dd5cb,0x000c19526a2c4c70,0x0000177dcd0df4c1,0x000457a743a1ed39,0x00032bea63a4c527,0x00075d1c302e78ac,0x0000000000000000}},
    {{0x000fc5003828ff0b,0x000436a9841f4323,0x000c6f35f8a62407,0x0009286efc260a1f,0x000fbe74c4b2df5e,0x000cb3568b504bfa,0x000dbcf3548e5047,0x0005d92aaad71af9,0x00018241085e423c,0x0004f894d1d8842d,0x0000000000000001}, {0x00075b2a3f29b75d,0x000ec555f7834899,0x00092b31a410939e,0x000b7bc223255263,0x000db65a25c264a1,0x0008fc1aed283464,0x0005c70ecd1a9b70,0x000d90a7a2a0ea33,0x000d21f2e9f14ffd,0x000fb49566dadd7f,0x0000000000000000}},
    {{0x000fa5757545376f,0x000ae164cbfd55ff,0x0008a8545451f1c3,0x0002e007d0be9705,0x000ed2a8f4c49727,0x00097ed736254138,0x000516215e864c7c,0x000bb624fc1b83df,0x0000313aaf4114fd,0x000a7a8c7f0423cc,0x0000000000000000}, {0x000ed76abc8d276d,0x000bfe3e74f599a4,0x00025d1f92d8b381,0x0005a3599e406956,0x00071869bdf5e06a,0x000ec86f625afaf6,0x000d724bbcc12cda,0x0003da7516890dd1,0x0009b69252163060,0x0002541f15a18b40,0x0000000000000001}},
    {{0x000e1c4e632e5d61,0x0002987ad659b7d5,0x0003f7f338de2f2a,0x000b55a5aaeb06f1,0x000b9a60e84f26d9,0x000d10563130c6f8,0x000e760d017d58e9,0x00039e20b973fa41,0x0000eaafdb2f4acf,0x000501ec9c6ab584,0x0000000000000000}, {0x000f4549ba5a6302,0x000a98b140b89722,0x0003e099225c2510,0x000f31b19117bbe6,0x00046ba7147bd18a,0x0000f540e368bb5c,0x000eacf29d33114f,0x0007e59588a01c9a,0x000ef0e25eb2d0e6,0x00058e4bb1b8d029,0x0000000000000001}},
    {{0x00057915cb5440b5,0x00088e89a3e1eb04,0x000ed12c670e08cc,0x000eab1d89133ab9,0x000f615d9bc0c1fa,0x00081504d63c4250,0x00062cd084c8e8f8,0x000aaf76dbe53ead,0x000bf1dcc49cfac6,0x000fc7007ea0b885,0x0000000000000001}, {0x000472352fc50515,0x000fa2123835c747,0x00067bab29e80692,0x000cca008379c2a8,0x000799065aafbc2e,0x000a605d2e32da97,0x0002283421bbbfbd,0x000dbdc2e1151243,0x0007a9d899c126b9,0x0007467ce3f8d643,0x0000000000000000}},
    {{0x00000c97f4a1ee70,0x0000a55fa6cdb3e0,0x000fd5fcd60595ed,0x000522bda02a23c6,0x0000361844a1d76e,0x000c6c179ebaf8c0,0x000a6ccd0a47af40,0x000071e2a1156aa1,0x000a1b0fc4eb0062,0x000bb4c1c5314a2c,0x0000000000000000}, {0x000c048376702b16,0x0002ef5b4e8123cd,0x000a7d67834242a3,0x0003bc3accb0fead,0x00007e65ed32fc2a,0x000b8b44e6e71194,0x00077e9aeb1712aa,0x000039ce4f895a59,0x0009d43ed708cfeb,0x0004254957cd1ca1,0x0000000000000001}},
},
{   /* digit=25 [{1,2,3,..,}]*([2^100]*G)  */
    {{0x0009a3fb62f03e91,0x000fc3cfe3b9a1c2,0x0008c5a528bca033,0x00096cd7b4bc3e3f,0x0008c4bd134e2233,0x00065224c739c3eb,0x00071ec25548c0a5,0x0007b0fb17f6f014,0x000aee1015fc6579,0x000448c4d69b6d18,0x0000000000000001}, {0x00074be708f600f9,0x000042a14b550a00,0x000f8e6b95a52425,0x0004e9813f438c42,0x0005181004aa1017,0x00010cd9a834ae43,0x0002105b1b67e295,0x000141438bad8cdf,0x0004d11308ec5ba9,0x00034300e8c08dc6,0x0000000000000000}},
    {{0x000625d111480c24,0x00034cdcf3505fb2,0x000c306874b99629,0x00004410981e8fcd,0x000492bd0a650027,0x000a534a84249eb3,0x000e1326b6bb40b6,0x000ebe5d29140c32,0x0009956b2cb2ca52,0x000b8c77c7225102,0x0000000000000001}, {0x0002b4e077c5c4dd,0x0008846314442efe,0x00066618e794431d,0x000a933fcd3eeea2,0x00006644159656a5,0x00022dc52fbda24f,0x000542f82f45dda5,0x000e0e5075c9d412,0x0002aba0fff34a66,0x000d69512c4a1d9a,0x0000000000000001}},
    {{0x000dc5b949f6aa55,0x000cb79872016ba3,0x0001df5e18d2889c,0x000aebf5e0129254,0x0003a4cd20b4cdbc,0x000f30108963d6c3,0x000c0dbc46a1dad1,0x00042c0e39b6755f,0x00007fa126ef9e69,0x000805d500d36fac,0x0000000000000000}, {0x0000b5e7bd19e5fb,0x000b3765e8dbbff9,0x000e491cc2deb8ec,0x000ab995d314c068,0x000b4e810513ad31,0x000b50dc0fcca181,0x00029580c1e05269,0x0006b6453c858930,0x0009a98b2de5a7d2,0x000b386f7a77183c,0x0000000000000000}},
    {{0x000d861fc542368a,0x000a737b3c184cd7,0x00014a6e3b95c425,0x000f514e85d4a651,0x00098b665bb45532,0x00066a39b08b87e5,0x00008dbdbcbbabba,0x000ba64b561fa462,0x0005692509520864,0x000281de8b31e205,0x0000000000000001}, {0x0001bb6a74473c21,0x000932e76a8c5ddd,0x000c6ee633cc0f66,0x000f68d0c546bb80,0x00006828f4e0c911,0x000b2a4276c213a2,0x0008cb204a16b2ce,0x000d38c09aa1cbe9,0x000f3ebeebcc1671,0x00032c7a684ba9a6,0x0000000000000000}},
    {{0x000a3463989cd762,0x00035114b160b22c,0x00057f2d520e3cc4,0x0000ff788707011b,0x00068b1a346a61d3,0x00084618b8d69eda,0x00020c04008115fa,0x000dfeeecaa806f5,0x0007e08436a14e30,0x00005f68bc839ccc,0x0000000000000000}, {0x000ae58e3c998f3f,0x000951d35d5af6b3,0x00038625415f29bb,0x000fd087552cd755,0x0002087ef7e8ab49,0x0006b067b5de9ebd,0x0001e74110309c17,0x0007b224505a1ece,0x000ba962991a5a2d,0x000b8879263dad03,0x0000000000000000}},
    {{0x0001b7e0189fcda6,0x0008775ba885f2a7,0x000b98305b9915b6,0x00019b2753769a90,0x000638d87ac0d10c,0x00083c77c18f7acf,0x000d23964d02af25,0x000de5be92026e04,0x0005a30998f85294,0x0002d2bb22f8803a,0x0000000000000001}, {0x0000daae09876e93,0x0007b9f1b9b10415,0x000e48eb13c50096,0x000cf9ccec3e5c4d,0x000f7b6158629895,0x000aa201ea7d90f3,0x0006e88c0cda29f8,0x000f4c0d70150c9a,0x000ee70bc97d1c62,0x000b8e4fd0f68d56,0x0000000000000000}},
    {{0x0003edbb844d6c8a,0x00076a792ccd3b41,0x00072527a7c1564f,0x00055b682778d6f2,0x0002167ba3cee45b,0x000d96d43a6e138f,0x000806538c932f15,0x000d4892afee6363,0x0002b82f06ed7c45,0x000fee287b4614b8,0x0000000000000000}, {0x000953f4fc1bb9d4,0x000e995150d18cb0,0x00067e23c2e107a5,0x000bfba071a733f6,0x00008ca46066c2e8,0x000cfb49871d6c61,0x0004ece39bb5a648,0x00040cf34f514816,0x0009b9250336996f,0x000c69d6e08146e9,0x0000000000000001}},
    {{0x00008e517921a752,0x000ab87a6c13d140,0x000c4597b07c5d69,0x00074a68c66db12e,0x00019ca40dec9dbd,0x000a617fff4579d7,0x0005876131725395,0x000d09e3b946e383,0x000d20c852478942,0x00087982ecbef742,0x0000000000000001}, {0x000589886da1602b,0x000c3fc9ae2bbd5f,0x0002126ee978ba22,0x00075595e212b5ab,0x000a2389b739eff8,0x00063595af9d6707,0x0000f9787d12dd72,0x0003b014c3309267,0x0002f506a0067880,0x000f67060764da69,0x0000000000000000}},
},
{   /* digit=26 [{1,2,3,..,}]*([2^104]*G)  */
    {{0x000365108b90f9d0,0x000f80765f67fb1e,0x000b1b38d141aae9,0x00024d697a9407e4,0x0003f9693e7ccc84,0x000a50e7d291d93e,0x000cd34385c13c5b,0x00066fcf73c9d94e,0x000598f4a80eb0bb,0x000b721c4d4c290d,0x0000000000000001}, {0x0000fb9a3bbeb3c7,0x0007ba326d546e3b,0x000a848cf094c6d2,0x0000e41609d2dc18,0x000266f0069ca46c,0x000c4aef799231b9,0x000abacbdbead081,0x000b272ba1959d4d,0x00049b7208e216ce,0x0002ba83cc03eccc,0x0000000000000001}},
    {{0x0004c0998b5250d8,0x000c867c43b599d6,0x0004c9f6ac785a2e,0x0004ec8b59f29f0d,0x0004df16ae8c0faa,0x000b8d8f78201760,0x000bc38bb59089da,0x0007384039822772,0x000d1571c6e88e81,0x000a7b7d4e8e0cf3,0x0000000000000001}, {0x0007bc572ea0f919,0x00064539b5eb1047,0x00077d71bc88d22a,0x0004dc62d769223e,0x000adfe2b562c973,0x000173fab241cdb0,0x000603370ddf3ff3,0x000f70dbbbbd997d,0x0008a88a56d59561,0x0004be64aafc3299,0x0000000000000000}},
    {{0x00045d30a00d827f,0x0006bbe20955e997,0x000cead0ee1643eb,0x000fce2db7c5ac6f,0x000ad1d2efb30bc2,0x000d9fbc667affb8,0x000bb6fb3983d3ef,0x000f70a834538091,0x0008384fd172dade,0x0003f32390fa3030,0x0000000000000000}, {0x00022aae53d2000c,0x000caf0273baad84,0x0004a6a878c712a8,0x00002615beecdb4d,0x000b0e868dba85ad,0x000964d03b5c6537,0x000cbcf8b6d0fd98,0x0006a16ca9f74a32,0x000552ffb8c5dbeb,0x000bf0f20d682f2c,0x0000000000000000}},
    {{0x0009a64c8deb9f4b,0x000532674c0fe944,0x00001e88fe681603,0x000b8697595c6e13,0x0008cf6f513d4913,0x0008c1e3203b6d47,0x000b68db28573518,0x000bdfb9fd4390cf,0x0006601496c4bb93,0x0000633f388af7cc,0x0000000000000001}, {0x0005258fb2317523,0x00040dacae0a8b9a,0x000ba0560abb741a,0x0008bc6a795d005e,0x00096caa47999397,0x000ff04fef1c0b24,0x000b0926ddcefe71,0x0008f281ff3947c3,0x000027cc7cc93f3d,0x000e78773c9a3f23,0x0000000000000000}},
    {{0x0001c60cc85e7257,0x00011fa52f42f768,0x0002f380ec8fe41b,0x0004893bc07fb9d3,0x00034451f49fbf7a,0x000388023d1b4705,0x00079c42053de8b9,0x000cf909c04d42cb,0x000eca57f6797b3a,0x000cf34d35027c43,0x0000000000000001}, {0x00086008351763ff,0x000f9e1103300427,0x000991707dcb32e9,0x000efb21a41fbb4f,0x000b5649d55978db,0x00004e4d7b3fa6d3,0x00012196968dee3a,0x0003561c60989b74,0x0009c91c53ee540c,0x000b9823a2ee0db7,0x0000000000000000}},
    {{0x000f6a15601d1f8d,0x000406c4591dc921,0x000b36c8aaaf7c15,0x000834fd3b0d0813,0x000e544ef9e76287,0x0002fb609294a18c,0x00008d9bd0198775,0x000cd4816092b24d,0x0008b097d39d2d32,0x000b3a5b9f00f218,0x0000000000000000}, {0x000da9d6f0979e9d,0x00080741dad104cc,0x0004ee619b7637d2,0x000d71560f5a9cc8,0x000b897bb554b4f3,0x000890a210367054,0x000aff63f1f61c3e,0x000cb92963c20784,0x0009317afc9acc43,0x0005c1dadb0d3e30,0x0000000000000001}},
    {{0x0004debc7af95096,0x0002bf8bc26e7cbc,0x000070bd1c43e146,0x00017181a62e8acb,0x0001c46b5339f3b4,0x000a2c14c9b646ef,0x0005de576b9f4c81,0x0004f9a155e97645,0x0003cfbba219f7e3,0x0009fb1fd4f92031,0x0000000000000001}, {0x000bcf11449769d9,0x000ea5acc7cb996d,0x0006bdb653213f43,0x0003a2cf9c396c5f,0x000777fb3075bc28,0x0009fab46fa97f51,0x000d80cd600dc1e5,0x0008ba6a57a9d490,0x000c9975b8111175,0x00067a2ad8270658,0x0000000000000000}},
    {{0x0005e67b8d52ab83,0x000eb2049665d86d,0x000b56e1ced19993,0x0009c1fc7a62ba87,0x000276fc5cf75dfb,0x00054f5dad4712b6,0x00089fbe0548bd15,0x000d1ee24125ecba,0x000176a53fa18f5a,0x0004e18796b5267e,0x0000000000000000}, {0x000a0f1a17a9eb45,0x000584e4e5f968ad,0x0008e12a3e089107,0x0009c73cd6a2ba69,0x00002e23b2a1f1ee,0x00028e9adc43a76e,0x00062c6e3d7526f4,0x000d0557ab8af09d,0x00058b1d337cd537,0x000000e54434b827,0x0000000000000000}},
},
{   /* digit=27 [{1,2,3,..,}]*([2^108]*G)  */
    {{0x00036c3a6abc7042,0x00004a11953f80fe,0x0000b4cc57cd15f7,0x000df44d3d3a8bb5,0x00015b5099398347,0x00081f3a553789e2,0x000d0115f2bce30d,0x00090b7f91f0853e,0x0007ec29320d53ac,0x00085b63e7bfbe8d,0x0000000000000000}, {0x000cdcd80232c6da,0x000d8fc636cf5e56,0x0006e4c3d9621241,0x000b84a86812f9d5,0x000287741d3de81f,0x000ab3d77eb50a79,0x00048627cc80386b,0x000a1901afee8f37,0x00095591fbf5ceb2,0x00080aed0c8140dd,0x0000000000000000}},
    {{0x0002fcdd07efc38c,0x000c9ad8b1dbd166,0x000af6b6e1566c06,0x0005c4ad28998a9b,0x000b12d2005dbca4,0x00009acb17fcd947,0x000af2e6bf7b35f6,0x0000b8a8aba325eb,0x000302e3f599df52,0x00080d2bf9b973e4,0x0000000000000001}, {0x000aebd112a3c0c1,0x000c408868630c25,0x000af7c4f6ba5529,0x000d49e0f5657b1a,0x000da3fa70b84c0f,0x0009f530044d86ec,0x0003f7ec59dce6d3,0x0004bdaf73433951,0x00022dd61822c292,0x000466acb0786ece,0x0000000000000000}},
    {{0x000bab3d6168fc90,0x0007cbb6b2be9857,0x0001cf2ccb017656,0x0001630304c6ccfa,0x000ab9344dbdd28a,0x00075f0fec3093b4,0x000ff2494e7a4029,0x000ca3bad1c9c568,0x000b17aa4b7bc2e4,0x0001be8844e06c12,0x0000000000000001}, {0x000748f359f51efa,0x0006b016fa4643bf,0x000de784a5c3f1e9,0x0006412db1ab3996,0x0002a042b01eeae2,0x0005a0d3a2a424ea,0x0009b9a7aeefe348,0x000b209614c9d52b,0x000556ff1e6afd00,0x0001e2290dec8fe5,0x0000000000000000}},
    {{0x000dedb27f20e8c4,0x000f535a0fc33855,0x000788ccd8803e8a,0x0001f7d6e10cabd0,0x000355f889d7fa1f,0x000583e3030487ee,0x000f3dd1885d800a,0x000f09ae9a4a2fc9,0x00054fc302887b5b,0x000678d91181d3a5,0x0000000000000001}, {0x000b146d6cdca631,0x00046652f280d553,0x000e0b73d63dfaac,0x000399cd0d77869d,0x00057ba5ffe6aa8a,0x000ffc1da65c61b7,0x000738771cf6c9ea,0x000620ae124834d2,0x0006504def184b95,0x000d761c974cb47f,0x0000000000000000}},
    {{0x000b12824a32cfa1,0x0009c552049f6e5b,0x0002cf47aab27c7f,0x000c49affe61e35a,0x0002247309f28abd,0x000d8f5d3d157087,0x000c6b864fe18c22,0x000addbbfad216e7,0x0006e83c0b6f0f26,0x000fd5df730de2cf,0x0000000000000000}, {0x000d5ed49aa6d720,0x0003b8bf56601c9e,0x000932a05f265897,0x000b6e7997e501b5,0x000a12ea7ac82871,0x0009ee973ffc91a5,0x0008bc4a89b5c6c1,0x0003ff7cc4ea3cde,0x000dd04f7b689969,0x000d1dbe61024f53,0x0000000000000001}},
    {{0x0009c8cbe80fbbcf,0x0001820704f59919,0x000a2837d2432345,0x0001d7c57c052221,0x0004dd7abcf6f7fc,0x000ceb0c9ac384fa,0x000cbcbae19fcf70,0x00044465c2e5cd22,0x000a11ffc8ca98c5,0x0007b72231b3018f,0x0000000000000001}, {0x0005516f6500002e,0x00015b8dc7f05ee2,0x000111229aa6356e,0x0006bd0e54525c30,0x000dcfc5ecb4c0df,0x000355785f844693,0x000ab74792af79c9,0x0007357c34213765,0x00008a7b5867734f,0x00069a6d820a3083,0x0000000000000000}},
    {{0x000b3a34b0a583e8,0x0004109d1c2a05b3,0x00056d185c8227f4,0x000c30eb0f8b309e,0x000e5f0d836e7213,0x0002fdae4ffef15c,0x000257bcdd2d7309,0x000dad1ff9a8d757,0x00098efcc192b734,0x000fe0e5b46f1d9f,0x0000000000000001}, {0x000ec3057c0b1268,0x000e1eea4fea07c8,0x000ac5ab201c4cbc,0x0001b75086654bcd,0x000e612c2aee9474,0x00065fa077070bf8,0x00015dd97afeaab6,0x00088802f9979ef0,0x000c9b3109eb556d,0x000e513d135fae08,0x0000000000000000}},
    {{0x0009b9b53c1efab4,0x000babd37156ff65,0x000a115d2c7f8338,0x0007371c9d1175b5,0x000a353c22d6aa92,0x00079ee37be5b07d,0x00020293585421cb,0x000abe2b0a938ac9,0x0003622f3d489e47,0x000ac9ccd5811b36,0x0000000000000000}, {0x000cb54f0f506ac3,0x000feebf83fb7441,0x0007d9fa2d5527b4,0x000b40376d4a3597,0x00045e4619c87f8a,0x000b913b27d590e9,0x0001da0e8861075a,0x000dd8fb707f389b,0x000140b6fe0beb49,0x000bf7392dd17235,0x0000000000000001}},
},
{   /* digit=28 [{1,2,3,..,}]*([2^112]*G)  */
    {{0x00082a01cdf12457,0x000bf550e3442670,0x00027cfd7b191616,0x0009bf54426bd9ae,0x000375f468d0ec29,0x00095e63540487ca,0x000f558b93aa7dc6,0x00028f48edec9322,0x0007ee742818f059,0x000d23aca5b08895,0x0000000000000001}, {0x00018972085008e4,0x0009e445a0130711,0x0005bf246e5348cb,0x0008ccf1f5c183c6,0x000f2e9a40aeb3fd,0x00087abdef0fbda6,0x00050f5daf09cee0,0x0003e33344ee90c4,0x0004044243abe107,0x000b8f02a065d1a3,0x0000000000000000}},
    {{0x000b66d418145236,0x0007896ea70c3fff,0x000cb17d54fc5491,0x00042a641eaf6e4d,0x00096b15be10c7c6,0x00011efe5f993282,0x000c04930829e9c6,0x000a5f18e8613cde,0x0007985a51a7c38d,0x000b8f3536d908ab,0x0000000000000001}, {0x000ce50b447f989e,0x0006725435f6e48e,0x00060505d7413d04,0x00051fa907efc4e5,0x00091cc601ad28a5,0x000eeaf4b18fed33,0x0002e1a4338a8549,0x000b61868d3372c5,0x0003a511bce70bb6,0x000e1f5c8d75eb9c,0x0000000000000000}},
    {{0x000d68d2a3e7e05d,0x0009bf6f65a63322,0x000368db479d7794,0x000e22f5738f46ed,0x000947212d465e52,0x000bb783e24758d1,0x0009d33d677a59c8,0x0005609046041b23,0x000f6497a9c2f277,0x000e7a9be5339a8d,0x0000000000000001}, {0x000804d780847503,0x000fb6bd5cd190b5,0x000d58769b6bfbeb,0x000a5b2366d25685,0x00084206ac283f9e,0x00045e93a909d14a,0x0007818e03b612f8,0x0005061fa312c680,0x000501efdeb98070,0x00043cfa3670b66b,0x0000000000000000}},
    {{0x0008296f30c9bed5,0x00099a4bb11c1f32,0x00015b4084960501,0x000c50ce53a7ca7c,0x000f50a2c1da281b,0x0002c0e34f682873,0x000f21f441021705,0x000e9f354fbc9c5e,0x000d7990a0bba954,0x000ca402432a326c,0x0000000000000001}, {0x000e6dddd976d76d,0x000a57e55cac7b2b,0x000da37392c8a3b8,0x000fecd4ec1dc93e,0x00009cf4f78c92e3,0x000ff689fefedf3f,0x000abd5033740521,0x0000df4087ca092d,0x00002763eb9e4e11,0x000689f3f329b79d,0x0000000000000000}},
    {{0x000d09236f94e981,0x000f3b87c2492089,0x000090559806590f,0x0006b638cb962e83,0x00043caf0b4cf40f,0x00066f61c7a2faca,0x000edaa5c1d246d3,0x000b19d9f9d7b0bc,0x000d3b97c04cafce,0x000f23bf9f27399e,0x0000000000000000}, {0x000b2a804eb31689,0x0009a2a7437938a7,0x000f3c9cd990c2d5,0x000b68b7f843ec1e,0x0005141dcc07de04,0x000fdd1e7d56eecb,0x000a099220b61db4,0x0004184b463b9f76,0x00076a6a6fd2bcb4,0x00067d87f98ad9c6,0x0000000000000000}},
    {{0x00025736286ff497,0x0002401f1271e328,0x000981dcd7607683,0x000cfb7ab6548084,0x000df4da03d9c990,0x000d822ebf4ae8a1,0x00099db5f23d4a99,0x000f6315e3fb9894,0x000021f262e80d80,0x00027457b91d5ecd,0x0000000000000000}, {0x0007a0ed90d98205,0x000cf6f6b6c517c8,0x00057c5ae11bc6b8,0x00000efaef845be3,0x0005e74813e365be,0x000c8e0106700aae,0x000d776c99ef5ca6,0x0001e3d37bff71e1,0x0003a89779b96572,0x000c15ea2a31bd25,0x0000000000000000}},
    {{0x0000092959940ede,0x000bb4c7bf2ceef4,0x000d604555c30636,0x0003fe5635d8d5c1,0x0008cdef0cb902ce,0x000b6f22235732b0,0x000fddf6f7cfc6cb,0x000369004df1a446,0x0004ba65bcff1dc7,0x00020adfd4756b77,0x0000000000000001}, {0x000afeaa9dfdfa89,0x0000b80d92606c1c,0x0006888e19c65eb3,0x000bf9bb4db51900,0x0008e84280b5d191,0x00077a1cb4c3d007,0x00055fc83156ea4d,0x0009f40279edea0b,0x000aa5223480bee2,0x000f264b4f70afa9,0x0000000000000001}},
    {{0x00054382d016c8d9,0x000ec7826f7b17bd,0x000dce64f2832c36,0x000193ae22a16680,0x0000aaf6a85c2ab2,0x000f20270252cc0a,0x000f317cc1335b32,0x00003743776e2afb,0x000a199000deb474,0x0006bc61591f25f9,0x0000000000000001}, {0x00084eebf2800729,0x000608b06a4eb61d,0x000b23e73968bb72,0x000a3ae82e886104,0x000d27c8605d2992,0x00033bec6e418a91,0x00029d45f2b49e6e,0x000bd1f4a3f4a9d8,0x000bc4ceaeb2f044,0x000c63b1ef09fa28,0x0000000000000001}},
},
{   /* digit=29 [{1,2,3,..,}]*([2^116]*G)  */
    {{0x000826845611f97e,0x00015b6b1ee54a04,0x000608b1dc092400,0x0009050925698b8a,0x00031b5e532ada13,0x0000c41c46df4acb,0x00090c116e05bee3,0x0009642c127307d1,0x000365a48b566eca,0x00046d5c3cffa21b,0x0000000000000000}, {0x000b8836b9754189,0x00079ea005768621,0x0007bf51510520f5,0x000bbc0ca43d38cb,0x000c9fe21891a0a4,0x000242b093687446,0x0006d618feab8811,0x00047a921f31cacb,0x000cb09d3cf611aa,0x0007d8fef9a8efc5,0x0000000000000001}},
    {{0x00042c81af50749b,0x00081540e019366d,0x000d6072e7b7487e,0x0004156c32da913c,0x0003df1e87478e7b,0x000880f5ccb21742,0x0002347ca344dd54,0x000d15da2c269018,0x000993e2887d2337,0x000379604cc23f8d,0x0000000000000001}, {0x000778d40c2ec9c0,0x00027ec9dd1808f9,0x000dcd7b63f43450,0x000cf65f198a63ab,0x000d3a7a4c38803b,0x000476f99f1130c2,0x000d6b9c1ea5019b,0x00034f67377e991a,0x0009047dfa9f5ad1,0x0005dc80641e2fd9,0x0000000000000001}},
    {{0x000de0d9dfa7af75,0x000eba7ea5710283,0x000dd5435234652c,0x0006f821b8a36856,0x000c319e00261b58,0x000ed079e56ce309,0x0001099e0f75ac31,0x000e2442020d51ff,0x0008b83fa0c077ae,0x000e6fc85e1f8724,0x0000000000000001}, {0x000872b798445d10,0x00032b311d3108af,0x0005040c97d2ca2a,0x0005703d4fa4c2f0,0x0006980d5eb27761,0x0005f074a536c8c1,0x000181395daa1e3b,0x000b672dad89bda9,0x0001f3d94395bd4f,0x0004b4c4a2c81ef6,0x0000000000000001}},
    {{0x000924e7856ff846,0x000ee4f61f664ccb,0x0005ac67cb02e404,0x00050da76b002de5,0x000c4537e3c3c875,0x000c36c052b6b43f,0x000b204b2d5ce01c,0x00088e7f6d0e0c5b,0x000c188bbf930fde,0x000168056f87d909,0x0000000000000001}, {0x0001106b668bd3a0,0x0008dce76203aabd,0x00002fff3110182e,0x000f7d1e1307d3fa,0x000347101339296b,0x0004a22e456ed2ca,0x0002d011b668eed2,0x000b79cf95e5e410,0x0006693b0681d10c,0x000355f94e08ac6c,0x0000000000000000}},
    {{0x000323242b9413a5,0x000d8925b57cdbcc,0x0004d31e6960afac,0x000cc1c8075e88b1,0x0003a4d853d5880e,0x000c2d17b4e21339,0x000c35a1d02b3405,0x000f7f4eb22a29f6,0x0001b6570763f945,0x00008a38d9e91699,0x0000000000000000}, {0x0009e262a8faf74b,0x000d89cdb707d091,0x000c28362e27b3cc,0x0000a8d2e31adec3,0x0004f2e5340b0d97,0x00076d44ac11f1ff,0x000ddee42bd388ab,0x00052165e718528c,0x000c2384a7cb055f,0x000e3bd81cae87a8,0x0000000000000000}},
    {{0x000e0ef29067ec5b,0x000b3efb1759268e,0x00093d33d241c82d,0x0005ebc6b912da50,0x00004cea7d557bb1,0x000a95c0c2531329,0x000338d1728bce52,0x00023e934774d703,0x000bdaa179ff6232,0x0009c05a25267ea4,0x0000000000000000}, {0x000b3f1bf490cbf7,0x000ec049cf21d24d,0x0001567c730a18c0,0x0008c3e0f359d391,0x0004ea1bf7eca8f7,0x000252d4d89f9aa6,0x0007a2e5b2ffd6d4,0x000e70d5197d3cf7,0x000ac046e420f1fd,0x000f82fbaabfd6c4,0x0000000000000000}},
    {{0x00023d833bf81b28,0x000064787960d20f,0x0001e23da2c1a82d,0x000fca0df31fd1ab,0x0000d67beaa32632,0x0009e45d2648f548,0x000d563bb162f9bb,0x000110e02089d434,0x0007082d3a10eef0,0x000cb7b7735d1d64,0x0000000000000000}, {0x000d95b89701e6ec,0x0003bbe61d29d940,0x0001c7d5b4e68b4d,0x00012a5ad78df4bc,0x00047d83302cabd6,0x00011140b2809827,0x000211a754f62795,0x00041d43610e16e7,0x00099e665f0dec95,0x000ee6baca9f0f39,0x0000000000000001}},
    {{0x000657257b2d9252,0x000915208861aaee,0x0008adfc02b5d4bf,0x000f78398b2a8792,0x0002cd1929e3951b,0x0001878fc66ac2d8,0x000a1972453f26a5,0x000c0ebd963c67c6,0x0006feb8829e6f9c,0x000c986a8aecc7ab,0x0000000000000000}, {0x00030636d8df74f1,0x00011de6a5beb09f,0x000247b37675f6af,0x0003d122a04301fc,0x0003f577167d7789,0x000a69addd4d974f,0x000f8be983fc60de,0x0003627055a8d35b,0x000c83aaf95c80a8,0x000a9aa21f06b151,0x0000000000000000}},
},
{   /* digit=30 [{1,2,3,..,}]*([2^120]*G)  */
    {{0x000c1e136664d27c,0x000e853cf04eac1d,0x000599f98901c4f5,0x000f0e3ecbc44867,0x000ee5a12a7f834f,0x000066c152851c12,0x0002df97ca61be6f,0x00027153da2c7383,0x0003e882e14acdbe,0x00030b87567338b7,0x0000000000000001}, {0x000fe8148de5b00a,0x0003a405fd56d3d1,0x000e986a7db49ee5,0x000cf7bc11101981,0x000a9750760e2695,0x000815cb90b6aca2,0x0009f299f5ace2a4,0x000d6b06b61bc3dc,0x0002e5c223b28698,0x000c0b5687880a6b,0x0000000000000001}},
    {{0x000f552c0e5d59cd,0x00029aaaadcddf1a,0x000f071e91a160c3,0x000bbaf777f33e93,0x000696e836178f9c,0x00030ecc6d74f3bc,0x0002571349ec6474,0x000dbbec63ff9e68,0x000eff8b43f624e0,0x0008000d19e23a64,0x0000000000000000}, {0x00060d53484cb54f,0x0000d83eff3832ce,0x00012f600dae89d0,0x00089d2df8745dbd,0x0008a48217cd83eb,0x0005ce0f8ae79b86,0x0004021c2c4ae44c,0x000ea980ca2b0fe9,0x0004146745ab9482,0x0001c2cffa33fcf0,0x0000000000000001}},
    {{0x00076fd51fd99bf9,0x0007e3a2b01fa7b1,0x0001a17875cbebf2,0x0008df20ca98073a,0x0001c738732531a0,0x000c360b05cea958,0x0008986bad316bfd,0x00009591db5fb8a6,0x0008ce8516941db2,0x000cd50df495ad83,0x0000000000000001}, {0x000d46b24a5b2933,0x000a4af0d09b27b5,0x000e34ef392f2b04,0x00028d0cc4e0cb50,0x0005bbe1270619c0,0x00002d927660b899,0x000c444a9beaf922,0x0003686effea3a61,0x000321e427cc238c,0x000fe609075147ce,0x0000000000000000}},
    {{0x000e9dd164c62b53,0x0001878a3599a216,0x0000821091d05317,0x0002cda324ef2697,0x000e94950f2f16ed,0x000815b553eaefd2,0x000f8019f00612dc,0x0001930eacc547c1,0x0006fc4a1fd1730a,0x000db88252d52d13,0x0000000000000001}, {0x00077522a6c4bee6,0x0006b12deb38426b,0x000ca869197aea9f,0x000c43193823d16a,0x00028f12c9d38187,0x00031f43dad5cc98,0x000728a436529c3e,0x000863d40c6f0781,0x000da1798bfbb097,0x0001e17a19693394,0x0000000000000001}},
    {{0x000a20633820f8b6,0x0008884ce6057395,0x000b9e9ac4298b05,0x000f80c79f28e7bc,0x00012abb15751770,0x000ce75763d01472,0x000afbe67296f82c,0x0002a2950d9f8034,0x00031ca6f1179141,0x0008bb87c616f997,0x0000000000000001}, {0x000f27dc8004bd5d,0x0004fc5fa5d017c7,0x0009fdb4deb95bcc,0x00051c1e39917e40,0x000cfbefa777d300,0x0006ebd51f3f36df,0x000089ed9696a852,0x000c58a6c0bc16cc,0x00093efb56723f03,0x000f77e4f7a67531,0x0000000000000001}},
    {{0x00082edbf63cd0fa,0x000fb67ff0d41a00,0x00076aa53cf1522f,0x00099dda453dcda7,0x000bf634bcd8a3ac,0x000f09af12ca31a6,0x00045d3da6aee65d,0x0000b2e1c131b960,0x0001888166f3c7e7,0x000d21cb58f8b972,0x0000000000000001}, {0x000f3e0321dcdf91,0x0009a8d4da7b1151,0x000e3a95788cafbe,0x0007071e39c010af,0x0004b05cb3faf8c8,0x0008a702fbafcfc0,0x000618742c775b70,0x00068aab53d65b3b,0x000b27ffbb84f938,0x000a7508491b708b,0x0000000000000001}},
    {{0x00020328d4b15dd1,0x000274b581eaa62f,0x0008fb2a285d269e,0x0006ea89604b1779,0x000933aa53ad75b2,0x000fa62691d5119e,0x00067e03e002a949,0x0000629215018ba1,0x000ae2796195dffb,0x000282dc1f93eae4,0x0000000000000001}, {0x0000977c61f7743f,0x0008f7654950f798,0x0009f0fcf77422ba,0x00070562b7dc1d4c,0x0008f0b2f76176b9,0x00094ad6c12de606,0x000d53dd34579508,0x0001fc63f78fe569,0x000a90b5214981ae,0x0005ab902dadf9f2,0x0000000000000000}},
    {{0x00006fc86d7474a9,0x000491c759885f54,0x0002d4cddc55bd2a,0x00061045c35aa122,0x0007a2154985eb54,0x000f0dcbe4188b45,0x0006a7e235148dff,0x0006a2535a30d70c,0x000e2be337d8e901,0x000cf899a19ee96b,0x0000000000000001}, {0x000dc1860747030f,0x000a1d519771baa1,0x000e6bf7f8dea4c9,0x000b88d5c44825c6,0x0001648270d80fd4,0x000d7c088d619d7b,0x000e67f50ac4887c,0x0009d1ac72f9cc2c,0x000dce091aafa6b8,0x000ac9b9365de8af,0x0000000000000001}},
},
{   /* digit=31 [{1,2,3,..,}]*([2^124]*G)  */
    {{0x000c9884018b1bd5,0x00017e335350476d,0x000f240ea34a105e,0x0007225c0ca7c1ed,0x0002e60ee9bcde0a,0x0001b7a04f8d5abc,0x000d636ed201196d,0x000fee08dcde421f,0x000648f1c3a41da5,0x00014b37a2b18a4d,0x0000000000000001}, {0x000574ca3d13216a,0x00000c8f4aa46ce2,0x0005e6cb8b142b50,0x000aeecc2cc007b3,0x0008b139d4602d18,0x000857b6e6fad62b,0x000703a0b8035154,0x00047dfe5be4aaf5,0x000e255f15b88d9b,0x000ceeb42f23b0c7,0x0000000000000001}},
    {{0x00027bf41035c3be,0x000003d6c228d698,0x000ac8482db53bd6,0x000f6c6cedd6d84e,0x00055554b59c1199,0x000b3dd0d5c80a25,0x00098fd9a255d70b,0x00088ce8ece5b616,0x00010e4ff0160238,0x000e8b21f2b5b409,0x0000000000000001}, {0x0009be6e93956f12,0x00028be014bad7ba,0x0007941a6f1d6c8e,0x000374aa983d3be4,0x0001ab03efe8a93e,0x000ecc1517778750,0x000a07f3863f0102,0x00022339ade08ce1,0x0002e138fb118165,0x00037ded66083914,0x0000000000000000}},
    {{0x000be450955d0f49,0x000350db3612b4e4,0x0008b05c6937d0f5,0x00091d0bc00589e9,0x000f08134602fbb3,0x00072898cb46a43b,0x0000c3f425983612,0x00092a9319d102b7,0x0002adb9889640c9,0x000f69984da61b9f,0x0000000000000000}, {0x000925b413e1ae3e,0x00046d808d55308e,0x0001e8e95f85495a,0x0001aa328926b87f,0x000e6f7c0b2cf48a,0x00097c234327b453,0x000bc1b584c452ac,0x000ac04a1db1b2a7,0x0002c2df96a4716f,0x0008b35f6c998afc,0x0000000000000001}},
    {{0x000c246de542c405,0x00006abed2f33bb7,0x000d46decdec7b50,0x000afeed50c509c6,0x0007109502cf683e,0x000fa7b0916c8d21,0x000971ce284eb826,0x000b5478a9a06ef3,0x000dbb05d7e812b4,0x000fa9bdf3afd0be,0x0000000000000001}, {0x000c0e4a6519aab5,0x000d79de9fb97617,0x0002d46f889510f0,0x00025cb75085caf9,0x000f963379f4c576,0x00002dc4877679ee,0x000748161e8da062,0x0007933c7094d95a,0x000527ab96f198e7,0x0000a23cef9bb67e,0x0000000000000000}},
    {{0x000254c4bef57a31,0x000f8fe05ebbca4c,0x000036d19011dab0,0x00092f09f97449f1,0x000feb784d8ec601,0x000551e5955591a4,0x00088c74b266204b,0x000fefa58c8cd4d4,0x000954c3d29f9c68,0x000262f04bf8acfc,0x0000000000000000}, {0x0005e5c9d99f906b,0x0005ebe8f2ee55b8,0x000f127eee6b4d59,0x0005b10ba97a057a,0x000c7680e692309f,0x0007c47d151a8543,0x000975bcc38cb298,0x00056b40037e7ed1,0x00069095953732ea,0x000e079710f9d766,0x0000000000000000}},
    {{0x0007ef5561843b50,0x000725adb4b17e58,0x000223554b9e6db7,0x00040d6a298840a9,0x00089b9987d3e8ea,0x000c544359088f19,0x000712498c4e6798,0x0009d49555742687,0x000531911aeb4757,0x000c25edd6bd8c42,0x0000000000000000}, {0x000da2be384ee90b,0x000ed1578452ef17,0x00026ec7e64f3506,0x000d93fd400c530b,0x0006442c14bcb0a9,0x000bc44330eec280,0x000b7a321d894abd,0x000383284ca21784,0x000aabf2cbd2fe67,0x000a0b333a314bbd,0x0000000000000001}},
    {{0x000deccb4cc0fcd3,0x0002b5d6f0d87e14,0x00022447f7757c4f,0x000f03b5e4d05426,0x0003dcf9d56f98d5,0x0001c6d571746b68,0x000648164a40c197,0x00086a775d32054f,0x000bbccdf9c7e93f,0x000ab95b370c616c,0x0000000000000000}, {0x000ad22f9be04193,0x00049e68cea75e3b,0x0004683245da929e,0x000316e38a93792f,0x000965e00dbe19e7,0x000e9c59fb61ef64,0x00094c5036fbab0d,0x0009e4c2c8f5993c,0x000c76d4a049b3bd,0x000c781dc2d523d7,0x0000000000000000}},
    {{0x00010cba8003a62b,0x0002963dead37561,0x00024e572ee261b1,0x000924c14f710c53,0x0003a3234879da4d,0x0000242c6b2bb72d,0x00025965319d73bf,0x000c5d438ac356b7,0x000eb1ea69c1467e,0x0006ea40556d55e4,0x0000000000000000}, {0x0003bb0cfbfbdc6b,0x000292f755482f11,0x000b750229b1fdd8,0x0006dd9d36eb56b3,0x0009fd65055f0875,0x00005fbea1ad24bc,0x000b5ba29626eb13,0x0004c9855409fcec,0x000000d0af627326,0x000b249d561b2281,0x0000000000000001}},
},
{   /* digit=32 [{1,2,3,..,}]*([2^128]*G)  */
    {{0x00097f8c2da756c3,0x00065716b51e78af,0x0004d4e4ac9bb4d7,0x000be63f12ece85a,0x0007f2c2556ca2a2,0x0002341b0c191c3b,0x00063796c15ecee1,0x00092e302dd7df66,0x000d162a4ce9cb82,0x0003dfa7f8ba9276,0x0000000000000000}, {0x000403973587aa55,0x000a9956dae839d8,0x000d9da7dcbd9d38,0x000d0fffb69b8acf,0x000544e0adb2ad93,0x000b2ad644f74f04,0x000e7d5b5de013bb,0x000f944ef674d489,0x000e01d0ea2d2bd3,0x0008aedd32d1ec0a,0x0000000000000000}},
    {{0x0003c3743a6b3bf8,0x00083b2cea274d8e,0x000f6accb4a79b20,0x000ac9cff7eff159,0x000c5bd1a458b1a2,0x000af5afd8c30597,0x000e95f67ad0a34d,0x000ffcb5f547ad0c,0x0002c927ef492633,0x000118d70d201bd4,0x0000000000000000}, {0x00025271d14dfd7c,0x000f83511be77473,0x000e33f2540532d9,0x0002d9c50e1e6624,0x000b9f8f4394e620,0x00085289919c8fa1,0x000d6412359d3b9f,0x000a4c00c9ead88e,0x000626daa054c125,0x000853e0db1f33bd,0x0000000000000000}},
    {{0x000ad013227cbee4,0x0005d963a674d5e9,0x0002422839e1c90e,0x0006f11c073f8abd,0x00051cbde443fb90,0x000f94add68e37cb,0x000d9cdf247fb6d7,0x0003b3ec024c71cd,0x000015c9b5032da9,0x0007607e0d83a94a,0x0000000000000000}, {0x000d4287c9083b11,0x000b167379dfa59e,0x00092871f05ea23f,0x0000a530c1fbcc90,0x000c9b670aaadfc5,0x000840b4f012b3f9,0x0006d74574236725,0x0005827f0582ac31,0x00047f13870e7720,0x0006f314a9061f10,0x0000000000000000}},
    {{0x0003be466658f617,0x0009fd565e43add7,0x0004a046e438ce3b,0x0007e9edef2d69e6,0x0006c7f11d4e7b33,0x0009fce23db4d264,0x0007ee69cfe36cf0,0x0009d497797ff857,0x0000fa9f71e1b23f,0x0002d2813fdfceba,0x0000000000000001}, {0x0005801d34f0db76,0x0008b9ba1d6ad8bc,0x00038f8437efa8c8,0x000755dc58d2c493,0x0008ea5d4147adf5,0x000454e0d19f3138,0x0005174d880f0ef2,0x0006f4ab4400ed7c,0x0002f97c02972f59,0x000bb7fd1f05bd42,0x0000000000000001}},
    {{0x000f26521378e02f,0x0002d730a6852468,0x000763f810a221e5,0x000f48636e9cb246,0x0004c1b9e4959290,0x00093bb4ca5e4a52,0x000f2a6103eedfad,0x0009e3ea2bb0a0a9,0x00013663d597d7ac,0x000a98c50bf00061,0x0000000000000001}, {0x00050b19a3ef90bc,0x0000ea69cbaa303c,0x00074f8f2fe993d5,0x000223c8be835b07,0x000f455e7085ef84,0x0002207ec6b0871e,0x000e48bd79a714e6,0x000daa1613ef3b51,0x00098f36229d3dd8,0x000c2d9134c94bcc,0x0000000000000000}},
    {{0x00050a19f5342c54,0x000dc653d78301f8,0x0006bbf10f389ca9,0x0004326e54a5af67,0x000fdd8a13b29709,0x0008aa3fafda8b65,0x0006c2e3f7baf8bf,0x000bca4111083f35,0x000cdf78842a34d7,0x0002a973106a6473,0x0000000000000001}, {0x000155f05f4ec88f,0x000ffd8679f932ba,0x000e00ae69c605da,0x000b7c72ba823e0d,0x0009e0bbb62edf8b,0x000f7bf5bd871069,0x0004e610f36c3cf4,0x000e41a06519118f,0x00014868b2ff5976,0x0000f7b8d8554854,0x0000000000000000}},
    {{0x0003e5d502754293,0x000e9ee9e0f2543e,0x000a3731f423dc07,0x0003b8bc5bf91184,0x000726f4ea8f1d1a,0x0008035844d23059,0x000c7266e29e66af,0x00082574f0c5767c,0x0001a6dd0e57d5d2,0x0004e537115bccdf,0x0000000000000000}, {0x0009f7ce1bfb6728,0x0000ccb130bc8170,0x00039a62c614cf63,0x00068e187476935f,0x00034de841f4a723,0x00011647b88ac5f1,0x000e09f54f07f6bb,0x000f505a8bf2adfb,0x000d75a5f605b64d,0x0000df9bbeb2b499,0x0000000000000000}},
    {{0x000308733efc5f8c,0x000b75cdb37e83e5,0x00060b5bfda48081,0x0009f06138365296,0x0009688a8974b9f6,0x0005444cc05fb9ec,0x0005a67f252002f7,0x0009664675a1899c,0x000b6d7be11db7cc,0x000549e5e85617c6,0x0000000000000001}, {0x0000536e04ec0d89,0x000ceb7897a84665,0x000b8acad3957bde,0x000ba89439f416b8,0x000cfde12e814bb4,0x000a77e0ef45c679,0x000f35bbfcd091bf,0x0009f3ea6cc5ae92,0x000f66583ff4f9db,0x0009a867f0fed315,0x0000000000000000}},
},
{   /* digit=33 [{1,2,3,..,}]*([2^132]*G)  */
    {{0x000487d30649cced,0x000796a5efc98a70,0x00086f3d00556482,0x000c177d81ed5742,0x000f3693c918841a,0x00044078e141f63f,0x000ad9ccb0cceba5,0x0005cd9ca803f396,0x000a3b9f81f2f890,0x000c5b4318691bb9,0x0000000000000001}, {0x00076e3095e41a52,0x0001ffb6fd45a8f8,0x000a8a0715ef8788,0x000192a0b8d73d7d,0x00086ca88981c074,0x0000f41a80dc66d0,0x0002bbb8f279d460,0x000cb55640383488,0x00052b11c10c7a90,0x000053f89b04d855,0x0000000000000001}},
    {{0x0002e1e8d88792dc,0x00022e3ae581427b,0x00090f869db2e712,0x000e06689d393376,0x000702d537bfdb1c,0x0007346bbf1a9bff,0x00090f54aeeb8464,0x000273c9dd468a0e,0x000c871a654e3afa,0x0007465945d8c3b6,0x0000000000000000}, {0x0000e770af4a5960,0x000be4ac70e87a10,0x000797d6d911c87d,0x000533fb961a5c5e,0x000b8548c0001c5b,0x0009d47191b560cf,0x0009eeca65c8463a,0x000ecad37d2137d3,0x0000514ad716bab4,0x000f8789ad5bc27b,0x0000000000000001}},
    {{0x000dbc583693bf30,0x000ef8d24b6766c6,0x00095890706d31b0,0x000c51cce3a35296,0x00080b8ed7618c90,0x000973ebf17cff3a,0x0009c68d473b1c44,0x0001098525e43a12,0x00074031f5036c9f,0x0001d33955ea92c3,0x0000000000000001}, {0x0006f1c314ce3a37,0x000a4064ddf24cf4,0x00070db52569e1fd,0x000405305ea2c55e,0x000d5f14297acf89,0x00046ea96e034f59,0x000622a42888331a,0x000a102ad1347dc4,0x00088a514e007741,0x0000461db8ec7cfe,0x0000000000000000}},
    {{0x00023847d8cf0718,0x00021ccb2c301d0f,0x00024b1883c46a31,0x00063cce64fb5faa,0x0003cc10bc090432,0x000510506a731fce,0x0009a05134986c0e,0x0003aa30a907d289,0x00071f165d859243,0x000eeaa5074a4066,0x0000000000000000}, {0x000b1d8c9f3b369e,0x0008874f03f7bd39,0x0004a870054ed9a2,0x000756adbd121753,0x0001a9a0d0a37510,0x000529605385faa5,0x000c2eddf5c089f3,0x000a130a237e15a5,0x00074ff2cbd316fb,0x0007ee2c9d3ce137,0x0000000000000001}},
    {{0x0009dbdc68f3280d,0x000657e090c25dbe,0x00024c6421981e70,0x00037a5a5d0a99ac,0x00037fc8c760c5df,0x00044d1a53e37845,0x000ff43dddfe06f5,0x000e4ab44983d93f,0x000c0915a82bb80c,0x000646c74033c3a1,0x0000000000000000}, {0x00004b5d5c7ce211,0x0001372b933ba5de,0x000ea64d116a103a,0x0006df2d3d823414,0x000619b7a1bf8333,0x0006eac1655d2034,0x0009aeedd521f9b1,0x0006d98d98725948,0x000610e8ae934636,0x000efd7b215cbea4,0x0000000000000000}},
    {{0x0005d0308e1127f5,0x000cf03c8e2019c4,0x000aa0237cf6545f,0x000764372510cd18,0x00097139d47739de,0x000a85188927140f,0x00037dc9b8b5e192,0x000b2545731c10b5,0x000991ea59d03831,0x00067dea66743632,0x0000000000000001}, {0x000cc6866cf98c39,0x0009016f3fd54524,0x000592bcebafd818,0x0002f06cc34bdbb8,0x000b6cb2e7a209f5,0x0005749dab7ee649,0x00076406958e2abb,0x0009516d049dfaf2,0x000de5f7e8adfc4b,0x0007ce97062d4c5e,0x0000000000000001}},
    {{0x0007da121df0699c,0x000ad3597a95de87,0x000181d213d52a92,0x00002da71c92de4d,0x000dd3803396793e,0x000c8761f332f0e0,0x0005c1e0d83b70eb,0x00048cf70527f5a7,0x000ceb82fe3e31cf,0x00029a56f1047f6a,0x0000000000000001}, {0x000ae721531eb7f3,0x000c70c79169f267,0x000d345b58d29bb0,0x0006c1daec3533a3,0x000115913b369665,0x00099820ca585f3e,0x000623473863b5d7,0x0003e2b952a9549d,0x00011f22279d7812,0x0007e6cad8cfd481,0x0000000000000001}},
    {{0x000c384b610f9960,0x0009e42d4100e245,0x000c5264e577187b,0x0000ec202477a817,0x0009dc146fbb4cb2,0x000c49fc51a5dd07,0x000dd34b66b540f6,0x000418cb3114a207,0x000042a4afc85f36,0x000592a886f4d479,0x0000000000000000}, {0x00062b5959d642be,0x000c107df28ef33c,0x000c98bc18d09a83,0x000908cb61720266,0x00034bfa40c64e8b,0x0005f7d00d3266ed,0x0006699785d5c5ac,0x00070fda50cded6e,0x000a7129a0528d63,0x000df6226a01349f,0x0000000000000001}},
},
{   /* digit=34 [{1,2,3,..,}]*([2^136]*G)  */
    {{0x0004a83b5020b6b5,0x00064ea6b7250085,0x000f5cc5dee82b8a,0x0007e307a44f4310,0x00061a979f99982f,0x0006271c95260383,0x00087bd9d4a6e7e3,0x000183121a682c2e,0x000a0c42c801461a,0x0009efc46dd1bbdd,0x0000000000000001}, {0x000ff9d53c8adce8,0x0004cbac7e6d6ff5,0x0008a2a18c9ba604,0x000457234e0b1c61,0x0001b538c1881476,0x000d20849fff1d07,0x000e3333d9430380,0x0001d1326f05033a,0x0004a49c4e89c642,0x000e640c63716450,0x0000000000000000}},
    {{0x000a7c6657e0c514,0x00010e4ba5060489,0x00003183bcaf92c4,0x00051063325bb838,0x000624a227afade7,0x000d611fad61ce2f,0x0001f27e1c057fe8,0x000426a808156374,0x00051e188cc3f494,0x000e601fb19202dc,0x0000000000000001}, {0x000f5c4ba35ecd6e,0x000c838b90f28423,0x000ecc8f9f7eac00,0x0004ae3bc63ca5b1,0x0000a61f4eb49abd,0x000e5e94c7586825,0x00050828aa62e59d,0x000ca27ce17d2e20,0x000f7dcd24d94b7e,0x0004ed84ff72ff3c,0x0000000000000001}},
    {{0x000dae22413fe9d4,0x000881c93ceb2c9e,0x000376b68f1c40b8,0x0004d107493ec443,0x000de2613f0552fe,0x000264177a2adbc0,0x00044456850f4d4c,0x000c024b1759999b,0x00032c490b5528e8,0x0004e4fe9cb25fa5,0x0000000000000001}, {0x0002401de7dabddf,0x00056529f2c840ea,0x0006004e218ae4f0,0x00026d7d9745c833,0x000bc1aa8e8c745a,0x000254366c2e1e3a,0x0009a65d176c592f,0x000575f2ce2f5dba,0x000390121cb70eda,0x000ad4df3bd7c9ef,0x0000000000000001}},
    {{0x00052f406338228b,0x00000044f05c5be3,0x0003a7061d336069,0x000371f2e7fd3e15,0x000ddb123a32ed82,0x000a15e8eec0c29b,0x00046b80938b2d11,0x000ba2ae38c19bba,0x0000c4e7466a69b9,0x000ba8e7a0607a47,0x0000000000000001}, {0x000e250e34d513c2,0x0009900d3d611604,0x0002850e69a99aa8,0x000ea018e87aacf0,0x0008ea9b70f5d0f5,0x0009dfec50e62995,0x000ef7267ad0ad8c,0x0009fbbc4dd8a19f,0x000ef73af4e91334,0x000d0636506a6e44,0x0000000000000000}},
    {{0x000533f2ba0eb14a,0x000b9fc6b2073504,0x00059889c71f37ca,0x000d3e3b2957243a,0x00033cd4ef031ee6,0x000e1fa792c82e2f,0x000936a9431aaa2b,0x00075897dee2d5df,0x0005c1a2769038db,0x0004c149337ba93c,0x0000000000000000}, {0x000ff077c9595fa2,0x000b4e92632965da,0x00073090129d489d,0x00024c2f940397cb,0x0000f08747c463ab,0x000063f57ea7844d,0x000a687de4ab15b4,0x000d7bdc8db9dfb6,0x0000393c5c4b7272,0x0002b3cc129fac67,0x0000000000000001}},
    {{0x000d85352986f86b,0x000b3bb5e1a9d134,0x00096ed674c04b6f,0x0001eaebc5869197,0x0001ec13b24f0220,0x0005acb88043fe14,0x0006b2f77717702d,0x0001f913c28eb4c3,0x0008bc0cbbd9e8fe,0x000014871dc376bb,0x0000000000000000}, {0x000b182392919d22,0x0005619062a004b3,0x00084b9c0aa0d96f,0x000e6a14d38134a4,0x000b962e9b9dd384,0x000d2a3f87434945,0x000e17c26111d5b0,0x000cca088afb0558,0x0004109b67e83601,0x000ebef3372d865f,0x0000000000000000}},
    {{0x000c5a0356b17ac7,0x000f616fb80668c9,0x000f7001431d3037,0x0006786061783bd7,0x000e2a8db044a7eb,0x000d63e80e687c5b,0x0006dba72619e19b,0x000b3f54433d79bd,0x000179eabd3da5ab,0x000fcebeded88553,0x0000000000000001}, {0x0001156c4d223604,0x0006fa0e48c3398c,0x000d70c895f6a870,0x0000aa32def1e5d8,0x000a3628036e774e,0x0006fa3b42b31a93,0x0003f15e7bb3f2aa,0x000fd667e0a491ab,0x0002f04b61d5276e,0x0001fdac2e330e17,0x0000000000000001}},
    {{0x000760d231c36820,0x0008bd2a50426c8d,0x000d4451d722fd74,0x0001877484a5084a,0x00019395bd1ac7d5,0x000dc03d6541ad77,0x00068a254b40eaa5,0x000dc699a962f42c,0x000f2ecdd481b2b4,0x000345d9badbf178,0x0000000000000000}, {0x00090c94035684fe,0x000e517a9849bb68,0x0005822be91e8615,0x00067ca7e3c3e516,0x0004c5ebee67a9ed,0x000f03236f5438f4,0x000029ef9e45ec0b,0x0003412d001129c5,0x000bad0b64fd4f4e,0x0000e15f591e3c09,0x0000000000000000}},
},
{   /* digit=35 [{1,2,3,..,}]*([2^140]*G)  */
    {{0x00067ca62dd9afd4,0x000678b2e8cc8368,0x000d7d6c96a2abfd,0x00075f62bb6c702c,0x000988eb9ab34b7b,0x0007b382272a8eb6,0x0005e40ee1d17286,0x000b6f600751bff1,0x000ff996b4ec3001,0x00015d7fb8efdf30,0x0000000000000000}, {0x00062d76a29a2746,0x000f091c80dd81fc,0x000c1a9825d4a2f2,0x000a4fb54ae9b61a,0x000db71a812fcb05,0x000bb96eaaa7baf2,0x000dfd9cc434e4e8,0x000b8fce567253c2,0x000b948eeceeb8e7,0x000abac787b7e9d6,0x0000000000000001}},
    {{0x000566d2087a8f7e,0x000f8d816dab3c44,0x00068ad0a5ea555e,0x000ab76093fa3eae,0x000bcad51a41fb45,0x000c784a1114a732,0x0002d99cd96f3573,0x000f7808bc957e91,0x00022a461547dff3,0x000e9dd3f93d98d0,0x0000000000000001}, {0x000f5792b3bed20d,0x0003199e50e443dc,0x000ab35921f1c5d0,0x000cb763ce7e3777,0x0009ec69a2c8061a,0x0004921d8bd5a1f1,0x000d3f186d49b86d,0x0003d287849a3eff,0x00019a1d3969ee2c,0x00097e7987e8d923,0x0000000000000001}},
    {{0x000e6b3554a3f3c4,0x000c8b48d7c64666,0x0004319bb26494ce,0x00023bd53c15f132,0x000a4b25b7340a49,0x0002c82187e36296,0x00076cb62a70b23d,0x00013ce0a44b3a26,0x000e1376215ada95,0x0004bdcdd5bfa093,0x0000000000000000}, {0x0006f0577c34a522,0x0002d6eb1d23f2e1,0x00074b1ae5a563bc,0x00076c1922ce417d,0x0008d8b56e586f06,0x0003d2111864665c,0x0007a1f4a9d1f08d,0x00009ad18a2eb5b5,0x000f16f69121b144,0x00055ad3dba51f31,0x0000000000000001}},
    {{0x000a0990f6c14c34,0x0002ae1571f4bd14,0x000a7e981428a12a,0x0008a57064ea4bd5,0x0005ec2f56d89f54,0x0004fcfb513a99f0,0x00081deb029c28b2,0x000c16eb364a4688,0x000f6df6754a22d8,0x00039a8e7ba7c29d,0x0000000000000001}, {0x000585b840875f9d,0x0006688b87eab66d,0x00061b8a4aef8f2e,0x000968d01b210ab1,0x0007a38c32d9fcd5,0x000170203f9469f2,0x00027ba7e65bf262,0x0003268e8f3ddf53,0x000d5d6a50d743f2,0x0006f76866dcf3bb,0x0000000000000001}},
    {{0x00075ceb39ee406f,0x000fddc2dbf93cfe,0x00005aa3d0f7d044,0x000c04043459ab15,0x000bfbea051fd1e4,0x0005c86723eeca2c,0x000dd90428637a5a,0x0006d3aca9d581d9,0x000277709f646127,0x000d9e5fdc588878,0x0000000000000000}, {0x0005fdeadee7c5a7,0x000b59b799ae3c10,0x0005e3595acc919d,0x000b6f6b2aa1f7f7,0x000cc519dab324e9,0x00070aa0c81054ee,0x0006840dab1fa02d,0x000ce8162c464504,0x0007fc117382d8fa,0x00079cc63a2e343f,0x0000000000000001}},
    {{0x000f45643ca65cbd,0x0007305e42072e40,0x0006980bc47b22b4,0x00091f480c0959ae,0x000df17382117d00,0x000fb6755fe76ce6,0x0008195083b13716,0x00053ce928778e33,0x000eadd235784446,0x0005f288650fd122,0x0000000000000001}, {0x00032d4f966b7e9c,0x0006ec40795011b8,0x00056106a162f5eb,0x00060472439d72fa,0x000ed9a6959807a3,0x000d3315f177c4b5,0x000b196cd83808fb,0x000c21f3f41dc773,0x000518607dcca40d,0x000920d975bf1042,0x0000000000000000}},
    {{0x00043d0a4a0b7f26,0x000c9bca61488d76,0x00078d40864c9a4e,0x0009191208ac32aa,0x00065e2c33dbbd1f,0x0006b041d84ce172,0x00022f6c73e5e84a,0x0000caf07f551302,0x000e0bc76bc20bdd,0x000a43482195b22f,0x0000000000000000}, {0x000f04c8745c6a12,0x0002b2bdd6ee1437,0x000b9431fd260182,0x000e54b7f10879b1,0x000a6b8d5c027ebe,0x0002358509530c61,0x00071ee3b953e075,0x0001d055e247c05d,0x000f78c21fc120f3,0x000c40b71a77f551,0x0000000000000000}},
    {{0x000ca1655dd01fc4,0x00023cfcdcd83fdc,0x0006fe01dad6f137,0x000a92f448fc724e,0x00071e9506b3510e,0x0002c50316bacd31,0x000812e5b9c38263,0x0005b06a2041b525,0x000d1e51d6095bd3,0x00018f8c9f2aff29,0x0000000000000000}, {0x000e8440d9f6b1c5,0x000d8f5815a76ff5,0x0000ba6e7eb4652d,0x0000cfa7a2d772d1,0x000e12c2c10a367d,0x000122408a9134fb,0x0006be74d3fc999e,0x0007f158ed729839,0x000445a86f173644,0x0008103589b3e72e,0x0000000000000000}},
},
{   /* digit=36 [{1,2,3,..,}]*([2^144]*G)  */
    {{0x00002ef5664a50e9,0x000569e6626b5584,0x000bb9dc4c85c34e,0x0006cac4009d6dab,0x00047cf68656c674,0x000e65ab973336b9,0x000ecf3e266a898f,0x000b5830a2ee0371,0x0007109821d57e75,0x0002643e097669c9,0x0000000000000001}, {0x000e2ad77fec8187,0x0001deddfb754e78,0x0004aaa3d5328431,0x000f5938ac9d56ca,0x0000419e9ec29fe5,0x00089e92d324185a,0x00068c4746f628de,0x00086959a461fd09,0x00039e1752cc1b19,0x000f685c4efa867f,0x0000000000000000}},
    {{0x000578941d3daa6e,0x0001e81a86314a15,0x000e2ec49066a742,0x00085f37e975bc97,0x000abd59fd20aa74,0x000b001318e5e712,0x000bdca951133a15,0x0006057f57ee1259,0x000dad04acbd3b2c,0x0009e7ef3153ef33,0x0000000000000001}, {0x000d37d508c6263d,0x000d87a4e81e7b2e,0x0005a01a3eff8f36,0x000726730288c3e4,0x0009b846f52088b3,0x000f560651a99118,0x000aeef71db52e56,0x000e58e36c06431c,0x000d03f83a3f98d5,0x000adc020099b8d8,0x0000000000000000}},
    {{0x000d0b7b6a8a3320,0x0007c1820c541666,0x000008d89959635c,0x0006f6b2d261e2b0,0x000b20857dc9286c,0x0008490da31aca2d,0x00001835ecf8b430,0x000769b376d5c408,0x0006c3593326d702,0x000ae359276d5c27,0x0000000000000000}, {0x000052b955ccca9f,0x000132f8bdb8b0e1,0x0001fc788aac66dc,0x0007aff377f81134,0x0005f3f5c42cf8fe,0x00063a0cd5ec56c8,0x00044e19f92551b9,0x0005a03e4e9df2c1,0x0005981a18a9c38e,0x00038410aaa01483,0x0000000000000001}},
    {{0x000ab1b79d73f8b8,0x0002c67e2040bd52,0x00089ab066095a12,0x00020058f1cb78af,0x00035c77cb75101a,0x000e13361531375e,0x00075eaea159ba65,0x000a7ecbfca3524c,0x00019d039ab8ae0f,0x00099c623ac91c57,0x0000000000000001}, {0x0001430a249d36df,0x000efe8450eb5d6b,0x000afb92b30c47b9,0x00024beea9991147,0x00039e1752c3ff68,0x000fd6a6252b160b,0x00046e76256f4b47,0x0009076f7bff5746,0x0003f350ce5bbdfa,0x000da84642b5dbcc,0x0000000000000001}},
    {{0x000f59f034423df4,0x0000c74c6502a253,0x00051f6b04936dd5,0x000ac1dfa20fd420,0x000a26ee480942df,0x000b8f32c2aa1793,0x0008f9fd5819aba5,0x000593ae9a68c3be,0x000809f95c514dfc,0x0005832a0100c51d,0x0000000000000000}, {0x00084df91d0b9d7b,0x00019af96dda8b28,0x0009e06515fe82b7,0x0004e7882cd87d52,0x000d3f4a8cd84bcd,0x0005a839e5e4c173,0x000eace8b4e2b402,0x00009c378fed4c2c,0x000b8a183c245522,0x00026032daca8b53,0x0000000000000001}},
    {{0x00021d74b7f15174,0x000b1737719209fa,0x00000c8bba28cfe5,0x0000523f1c2878b2,0x000c0170331c9a62,0x000cd83b50a5843a,0x000131d0381135b8,0x0003a643b75eb047,0x000ef1464d2ab54c,0x0007f362ed0e42c5,0x0000000000000000}, {0x000bb20fbad15614,0x00040a78f8613291,0x000895f7e0d7805c,0x0004b54ca2a8624a,0x0000e6579a8713ce,0x000626e2cc1b0cde,0x00093c66377df41d,0x0009cd6454de0451,0x00009db1f1c3ca34,0x000d91b047b0a149,0x0000000000000001}},
    {{0x0006148c3607c309,0x00072dd5c6a1cd15,0x0004ea2e6d51f4ab,0x000bb9012a38398f,0x00025cc1f09df84a,0x0009c3bace064bf4,0x000f3b1a1aeaac49,0x0008ba0e470586b9,0x00026aca2a7b1cc0,0x00037064de7e58e0,0x0000000000000001}, {0x000f70f6864c071b,0x000cebbcde808997,0x00042d9268c9d10f,0x0001f3646bf97f61,0x00099c6124289f61,0x000f65308f5fa877,0x0003b1cbe10f2164,0x000db1cfb717f6c1,0x0002178fd0705446,0x00053784aa2a3cca,0x0000000000000000}},
    {{0x00032b93eb6bf0f8,0x0008d44a6f35d7f4,0x00062f74f5a61124,0x0008d968ff45509d,0x00090f78b11dcef9,0x000e0fdb4e540d2d,0x000178df19486918,0x000b775c9c48f839,0x000a4516e1546952,0x000548b05a9a422d,0x0000000000000001}, {0x0000e6542e705240,0x000ea85c40801a5a,0x0008cf4381fc9bfc,0x00026551ecff5ed1,0x00006e3765708042,0x000f10bb393addaf,0x0004c0be6d6327db,0x000ade98dcbda7a9,0x00045d1d2c9cc265,0x0001d23919800694,0x0000000000000000}},
},
{   /* digit=37 [{1,2,3,..,}]*([2^148]*G)  */
    {{0x000136d3adf7c0d8,0x000a615150ed1e22,0x00048b602d1f12f4,0x000a438f58c86ca8,0x0006c2ad94dbc8f3,0x0001741520fd2861,0x0006926fc8f344fa,0x000aa2867b7697e9,0x00063769f3f74f49,0x0003389eafe4ecc9,0x0000000000000000}, {0x0003271ab880c04c,0x0007eceb904c8b8d,0x000cf0e8b6b36124,0x000b8dfe9dc846a9,0x000c71bd5a3dcf58,0x000bb872ef46766e,0x000ea257028f76aa,0x00037d56cad75976,0x000e6e410a7a4c1e,0x000aa4d9ef6dff50,0x0000000000000000}},
    {{0x0003f21a068b1990,0x00028b83926d837e,0x00046424f5058ff9,0x000540b150a21088,0x0007bd69839e2656,0x000836bb43217215,0x0008f5d34535e3bc,0x000a61ec6b271f81,0x00014bd57f4cd40a,0x0009c8fdb8302a87,0x0000000000000000}, {0x0006b22f2553a3a3,0x0003b58b7033af0a,0x000213a07cddbf4f,0x000434d1d71e271e,0x0003ac069f3affa9,0x0004ccd448d5d23e,0x0005a3de785990cc,0x0009500536e9dd21,0x0005a1f484316890,0x0008d39f92d8e2e4,0x0000000000000000}},
    {{0x000e463b75bb6ea5,0x000ed0a11789a549,0x000dd32eea4152e4,0x000b779f3244c612,0x000a765d467497f7,0x0001f2317d762ed2,0x000fb479fdc0f1f6,0x0005b625c778a26f,0x00086e4279e293c7,0x000778007cc51b6a,0x0000000000000000}, {0x0008d10c9ca3a103,0x000303626747aa01,0x0009d0d1059a4b9c,0x00047b992888178d,0x0005dee73f8df999,0x0003009b79f58ee6,0x00095bbb19efb6cd,0x000ee364f704fdad,0x00075210ba101581,0x0009e1f5ffb0008b,0x0000000000000000}},
    {{0x00061dbbf0d6ad65,0x00037943121ba6f6,0x000176edfca2325e,0x00061e28f0cef68c,0x00084617ac6eda38,0x0007535e8ca77e7f,0x00023d1d31f498d5,0x0000546d78b2f36e,0x000c7d55e2c3f881,0x000891156a1cb9cf,0x0000000000000000}, {0x0004ce76bf8c0b46,0x000f73894a4c0a97,0x000e4d65f8fc178a,0x000cb9405d4f42d7,0x00089f73dac29f71,0x00028141921d35c6,0x00055dee3cb66f43,0x0003af9effca7532,0x0004e3d9ea981425,0x00042022e23b71d3,0x0000000000000000}},
    {{0x000d0b7e99b465d6,0x000dcdbbc6a7f631,0x000fdb4862b8d0eb,0x0002d00e72a3f599,0x0003fff9e95d96f0,0x00098b66f4cdbc62,0x000ac921634cb2b5,0x000ec0deea0b5c81,0x0005b0a27a76f063,0x0001e02d30431834,0x0000000000000000}, {0x000c98aa1c9ac7a1,0x0007c5a7466568e8,0x000fb66755607c49,0x000ef99d83842e7b,0x0003f63d03b04212,0x000eea39bde1d43a,0x000c0a3d0947a656,0x000da642406f1e3f,0x000c396f50ca4ece,0x00002261add500ea,0x0000000000000000}},
    {{0x000faccc08dd24e3,0x0002a75b2039c36b,0x0007b00e10c370cd,0x000decd44a6f8b5d,0x0005623fd6ab9f44,0x00019a1ddd85e65f,0x0007f5f2f27bfaa2,0x000934e1d6c8baa2,0x0002398cf5bc3e40,0x000936e76ebca08a,0x0000000000000001}, {0x000b72cc3defb1bf,0x0007c48e0f8a00ef,0x000b50a281abffca,0x000290112a957074,0x000c6cc0bcd2913c,0x00080828c73f9cbe,0x0002b7332c142bad,0x000b82fd75dcc17d,0x00071d9dc563b115,0x000fa46eb1fc833d,0x0000000000000000}},
    {{0x000293af2196db74,0x000aa8f516dffa78,0x000ab476917c3f2d,0x000a17a44ba1c0ca,0x000771d0d213b4e6,0x000872d37a8c50d3,0x000a9d4f31d594dc,0x00020ae17df8f34d,0x00012ccecab30c4d,0x000fa5e5b7722b87,0x0000000000000000}, {0x000e6e4b1df4a900,0x0005d66c421f23c8,0x000473d466e42335,0x000dad17c61ddae2,0x000ed279fa7168cb,0x000addca2ea2657f,0x0004d479a5bdfda6,0x0009ec1a80eb84e8,0x0001a95ca1a89847,0x000f2ca605fdb8f2,0x0000000000000001}},
    {{0x0000bda5161e9684,0x00055c62c59939aa,0x0001e39fae89d4f2,0x00072aef74c49bbe,0x00060180fc9e6093,0x00063da12ade7248,0x00028defa823f501,0x000a965a30e8a72a,0x0005cf1083c600ec,0x0004af9f8b968790,0x0000000000000001}, {0x000afd7d7d936a7a,0x00003b13810cfd26,0x00037d1ddbf986aa,0x0005d035eede05c2,0x00071b7ae0b88271,0x000812487895ef9e,0x000f170e50423460,0x00003054f1639f87,0x0002e674eebc0936,0x000654593b42f2ce,0x0000000000000000}},
},
{   /* digit=38 [{1,2,3,..,}]*([2^152]*G)  */
    {{0x000a2f3a1cbc282c,0x000e19a09feeb1c6,0x000c54628c6180b5,0x000cefbae8c61be2,0x00031054eeedc773,0x000005e41190648d,0x0004925364893510,0x000a54e9064644b7,0x00026639e573a22c,0x0003b5a6074dacd6,0x0000000000000001}, {0x0002e1f28cb4398c,0x000fba11161ac99e,0x000aaf012b04f328,0x00060a6cb74a91c1,0x000690cf3c48dadb,0x0007c4e07d1b8182,0x000bed19eb0dacbf,0x0001aba090482e6f,0x000b8c6fb9ea1ef8,0x000d6d4b567809aa,0x0000000000000000}},
    {{0x0006de757b8ee9dd,0x0004f4a9eb572b8b,0x000650813f9e5a92,0x000081024cddfbbc,0x0003e750529ae0f8,0x000c407a678dbdc2,0x0005c643db36c6df,0x0009adee9ab1549e,0x000add1f855d46bd,0x000aedf68182d8ac,0x0000000000000001}, {0x000e2fb66eef3f12,0x00004b24a7282866,0x00050b3c877e75f1,0x000590fae38bb301,0x00008b7b5535d2f8,0x0001b50eaef87c62,0x0000c4541ba355de,0x00098bfe96023f0d,0x000dcf2eadc15969,0x000f41ab8c033f3c,0x0000000000000001}},
    {{0x0001bfbe835763b7,0x000da08736745919,0x000d000c52158859,0x000dbafd4373d9cc,0x0003efeee235e560,0x000fe980f98d303a,0x0004f012a6082ad1,0x000e567ed43eb524,0x000eddca68306748,0x000f954e531e38a7,0x0000000000000000}, {0x0000101b465ee778,0x000f8f4e95956310,0x000bcb6c6057ab1d,0x00052b140218cd6f,0x0000a217b7b093a1,0x000924c99c9b3267,0x0000b388550cfd67,0x000eda396f8cf9af,0x00035154327557bf,0x00098cf74a0d9f01,0x0000000000000000}},
    {{0x000cd9335dea0190,0x00015fcbf855836a,0x0007808f96352fb5,0x0005c5cb374fc6d2,0x0001eebbbb50f586,0x0007f3a5b9a4d0c8,0x000bc6329ed702e4,0x000264f0fada97b4,0x0005e3bbcf73be9b,0x000dd442f9f14de6,0x0000000000000000}, {0x00029cdbcd6414f5,0x000db247ce590b47,0x0005be836ddf363c,0x00032e4b6a8da968,0x000c049bdb9815fd,0x000d8f7528076e41,0x000d50b097db4cb8,0x0007f829470b7fc1,0x000b6caef75b1cc6,0x000ed3d55324b1d2,0x0000000000000001}},
    {{0x0002ed4b0886efde,0x0002e69216f70caa,0x000a19fc084c43fa,0x000bf1fcd447360e,0x00088b44bef17255,0x000c941e542e92c6,0x000c9462ab05687b,0x000f4a55ed27b06d,0x00006c4879438508,0x000b3f5a16cdbf59,0x0000000000000001}, {0x00090da308f335bb,0x0002c62f75607156,0x000ac3878c204f5d,0x00019a70e1d9ebee,0x00065ce18d8dd345,0x00053d4a7a6a59b3,0x000ab840d7a66249,0x000e9f8efc3edfda,0x0006a32d022f5317,0x00072a29be1120dd,0x0000000000000001}},
    {{0x000bdbfdee3c7792,0x000b747684a7e37c,0x0006fd64e032b7ae,0x00031287b0371790,0x0003245ed96aa7b2,0x000bcb2d9689dd51,0x0009eceb1d9918cd,0x00053e6e8dbeb445,0x0003cd8435c2226c,0x000a212888b11938,0x0000000000000000}, {0x0001020457ce98be,0x0009fbe80ddb3555,0x000e385ff7a0d009,0x000821584b1de3c2,0x000f36cd64d47bdf,0x000d2c6d2f0d97c5,0x000126f061319f64,0x00050f118e4e9aeb,0x000dd0fd66a1918b,0x0008c9bb60247ff9,0x0000000000000000}},
    {{0x00006452a69b40ef,0x000a58916404d8d3,0x000489351fe54188,0x00083228fc171eb7,0x000410e07508f15f,0x000b2d0bdc317f64,0x00075755181b0c85,0x000c4ca35cc09ad3,0x000bdec4e4688b7b,0x000ec2f6e18ec10c,0x0000000000000000}, {0x0000b91ff7109c43,0x0001353357108dc1,0x0006db397b6c17eb,0x00038d3f418ed53c,0x000a1a7d0d6f5104,0x000558963fe8aa2f,0x000629ed52f70d0f,0x00070987dde60b3f,0x000b95a72bb4ccee,0x000aae64e168b593,0x0000000000000000}},
    {{0x0009ff50fcb47b0c,0x000001fc1e2456f6,0x0001c124be702b84,0x0007f671a6c9b545,0x0000e07337c72285,0x000d3661d0b0a89f,0x0007db2af0223087,0x0001d9b173b261f1,0x000c65404d0457b5,0x00086eefc1cd30f8,0x0000000000000001}, {0x000fafb34fbb3972,0x000db4c5bd6770ff,0x0000de59815fc7a7,0x000b5602342e8ca8,0x000220e1c9e4f843,0x000b0b7c5b3bfe91,0x000b313a1e2826c8,0x000988ce465ce442,0x000217ce5f2ef9e9,0x000682a10ff59077,0x0000000000000001}},
},
{   /* digit=39 [{1,2,3,..,}]*([2^156]*G)  */
    {{0x00041390c3361b6e,0x000b58054f802294,0x0009b74e1597143a,0x000652a48a901ba0,0x0004b9b4f3635116,0x0005e2ee300afb31,0x00079f7d46228864,0x0001b66e61674d2f,0x00005aad2298ff3c,0x000bd327d6400925,0x0000000000000001}, {0x000b20dd543f093d,0x000dac4b51c2ba0e,0x000bf1d364874c9c,0x0002601310d4063e,0x000c6c8c6fbaa6b7,0x000ce6639ff8b94a,0x000066c91f488ec6,0x000524c600b8f454,0x000ff656ef37706e,0x0008a0434286c21c,0x0000000000000001}},
    {{0x00077e284b1fd44f,0x0001dc37f60445d8,0x00069f0b4dfca419,0x000aa285358c7759,0x0003172cf55e112a,0x000ffea4f47f71ae,0x000412afc352eb30,0x000bc7ffc3d95b8d,0x0009ccbacabdbf74,0x00030dd4b6acd123,0x0000000000000001}, {0x000870d6326f819d,0x0001f9d1598751a6,0x000c925f0b6c6b0d,0x000c309ba890fd44,0x000f1cedd20fe106,0x000408588dc46673,0x00053cbebfbcf6f2,0x000da52fed53b541,0x0002bbf3f7b4aace,0x0008d484a22a2167,0x0000000000000000}},
    {{0x000d633fc6b2523f,0x0003c8573eaf11ae,0x0005f254d2bc0511,0x0001c7fd283764aa,0x000f770135776ee7,0x0003df5ba988759f,0x00065da842051883,0x000b809c0705d522,0x0001067f4912507f,0x000fb628d91a9464,0x0000000000000000}, {0x000e6e2ac33e3aac,0x00065c0000ebfac5,0x000ced796bda6c05,0x000a32836c90c0d4,0x000d2ee187fc8100,0x000d7848e982bcb3,0x000be08290e6b628,0x00085ab586db4a59,0x000b07e2fb9a0080,0x000d56210d8de2f4,0x0000000000000001}},
    {{0x0000ac7a2fd05258,0x00034c744e57f4bf,0x0002edb448a88343,0x0004d56a4c1f9523,0x0003b85d4cde6c8e,0x0003063d710bd23e,0x000833d45b52f378,0x000d2012d08a14ca,0x000ccbe55ff85aae,0x000e919fa9b95c02,0x0000000000000001}, {0x000999b76646e255,0x0001f5f355b09a04,0x00000d64b669309a,0x00089605b2bd55ad,0x000656b121bac578,0x000d693b7220d91b,0x00053ea1faab888e,0x000745d07a303444,0x000e7a52e75e36d6,0x000a7986433618f7,0x0000000000000000}},
    {{0x0002484fcef15b60,0x000485fc2dc91c4b,0x000d7e9f8403b5be,0x0005ec8542217cb5,0x0003f3deede9d858,0x0008c56ddda1f005,0x0009028845902ce4,0x000cdbb111feb2e9,0x000537c2b8f6659b,0x00075d89960f5bf1,0x0000000000000000}, {0x000a9e85b9799e89,0x0001de39c6986f88,0x0000fa555ee69af1,0x000f3b270c555b9d,0x0004c62266b30411,0x00084a11940b0e86,0x0005b26112da8247,0x000fc56950bfb7ec,0x00066d81f8a57ba0,0x0003b772e0aa0038,0x0000000000000000}},
    {{0x000710f55ddf9e13,0x00018f67ff0e8dc1,0x000601481b67ef67,0x00009ffab39b462d,0x000b5ad90ba1057d,0x00018d94f2f83bbb,0x0008d2eed4c7a169,0x00019ddb61a12bee,0x00096ab74dadd029,0x0003902e5753e9de,0x0000000000000001}, {0x000926dcd7de034d,0x000eab5af3e375a3,0x000eb250dce827a6,0x00008bd108623cdc,0x000d49a7d0e9c524,0x00066e3019236fda,0x00040ab55ed033af,0x000667077bc755cf,0x0006972e633b49be,0x00095334396ea43d,0x0000000000000001}},
    {{0x000671c0c20009e5,0x000956db94fffef7,0x000bca8fdc30361d,0x000ebfa5860aa7a6,0x000feca2b724bff4,0x000572f34fd506fb,0x00048ff2e88a7d1e,0x000874822e19430c,0x0003c0129eb20b17,0x0003db07cc6f0162,0x0000000000000000}, {0x000244f5da60b490,0x000fbd8954a885e9,0x000f39699542bf3b,0x000c93a6a7e331fd,0x0009816b29c5180d,0x000ad960c8e85d80,0x0003a3a7931b35df,0x00092e570f2974ab,0x000904daaf442234,0x000cf25e1f700754,0x0000000000000000}},
    {{0x00056e1b7ae8ee13,0x0009b65f8128c4ea,0x000e5e0d92d02840,0x00074f688ed0e1c4,0x000f9c55f66d6f3b,0x000eb2ab8035d3f9,0x0006b643bde4296d,0x000f25e29f7ea7cb,0x0007f5f239b9d057,0x0001af17e3fac208,0x0000000000000001}, {0x00063cbb323c7d21,0x0002b6d926fd3ed4,0x000ab9ee679014b1,0x0007e6093a1bcb9a,0x000dc171705931f4,0x000b0a4387f44f73,0x000c7cdd2a12e513,0x000a473ec3b73ce5,0x000ef17967f341e3,0x000a3809a474c86a,0x0000000000000000}},
},
{   /* digit=40 [{1,2,3,..,}]*([2^160]*G)  */
    {{0x000dc98081f0b504,0x0002377f1bc655c2,0x00067de245fb688a,0x000260cdd7a61e34,0x000d89aaf28a330b,0x0004e078039aeae5,0x000a42253d349d8d,0x000438cabcfed7ae,0x000a9960f3728bd2,0x000af658af568325,0x0000000000000001}, {0x0006e52ab17d640b,0x00019d1bc21ee481,0x00026613d4c31a58,0x000c14072a5969b3,0x0005babfa75ee1a8,0x000c563bc4d35701,0x0000425d2086ecb7,0x000c9b8fafb1a4a8,0x0007ef737c2661a2,0x000c20e7afb2d654,0x0000000000000000}},
    {{0x000726f329838a5e,0x000204b7a9942b65,0x0004a26b80fa33e2,0x0006f40abbf82a56,0x00026970dfcc973c,0x0001c38e96f95485,0x00019abd2bbae55f,0x000c1edd71d62ecb,0x00020adf26d97496,0x0000d917e1cf322e,0x0000000000000000}, {0x000aaf44ac399116,0x00067bb67e29ba76,0x0003d1213c21031c,0x0003b345e37fdfde,0x000dab46f2bbeb4f,0x0003442227ef5d5b,0x0005c11bdace9105,0x00060e12dac175a6,0x000cdb1cf99010c3,0x00087106f2502658,0x0000000000000000}},
    {{0x00044188249a4961,0x000eb8deb1c61cee,0x0006080b71cf8ff5,0x000b75b57b2ccc29,0x000b9ffb3c6aa214,0x0000a50e70e80f53,0x000fd2ffeb156be9,0x0005a94620e80211,0x0005db41e15422e5,0x00055d2030526508,0x0000000000000001}, {0x0009e1933e619307,0x00086b5084131313,0x000b6d55898976e9,0x0003f79536a0866b,0x000b8e06bc0b2a44,0x00034e542863ba00,0x00040e4dd7a73a37,0x0008b2efa3822134,0x0005312ecb0905af,0x0008efb084f884e9,0x0000000000000000}},
    {{0x000172c5ec6e6f32,0x000784d8ddaafa3f,0x000785f2ae4eb6e8,0x000db162f77d65ef,0x00085dec5c58d4e5,0x000a30bffa2375c7,0x0000bb7c92e0f7f4,0x0002294b17a00c92,0x0009107e026f93d7,0x000911ce9dc0950a,0x0000000000000000}, {0x000841c6766f1f49,0x000079724523292b,0x0000e7ddb4cb0490,0x000d47f955646515,0x000b44b2a0877c3a,0x0004c3de4bd8708d,0x0009d24b4a9131fa,0x000585e650ae938e,0x000bb2e4980176c4,0x0001820248559a60,0x0000000000000001}},
    {{0x000cef71c9a9281b,0x00078b2e3e260928,0x000b15a4e8453115,0x000c76cc66031c77,0x000e2f2c06ffcc30,0x000a471db8c352a0,0x000184b9a687b94e,0x0009b19798642e1e,0x0001d84cf08e1a1c,0x000462a36c823a7d,0x0000000000000000}, {0x000b775551fedfb4,0x000c921b0d298e47,0x000071e1319e7833,0x000e6f4ce5e5ae43,0x0001348ff7cbdbf6,0x000c042f31447260,0x00061f1861a992ae,0x00020e5f80d48204,0x0008846b75b72853,0x0005ef4edf14c058,0x0000000000000001}},
    {{0x00051608c9277436,0x00036641c6cf4e0f,0x000263e7b7515b1b,0x000a50636eb6d459,0x000df53679a56041,0x000b4abcaa6ef1d0,0x0005077b47a03019,0x0009d2d427efae97,0x0003dfa9162f30c4,0x000f8bc801e5655a,0x0000000000000001}, {0x000202783ac347e0,0x00001a26d59f4868,0x0003895e6664e175,0x000031f4202e3866,0x00069d2af7613aa8,0x00021cc1e58ddf28,0x000159ee13d84ffa,0x000c8f6eb59a5da3,0x0005df9b7b87bbc9,0x000771b8b6006cdc,0x0000000000000001}},
    {{0x0006aa5bb86ea29f,0x0000e29e7a21c03e,0x0009e430844ee3c4,0x000584b091ca8307,0x0006afb05a033420,0x00015d7ef65dc354,0x000acb0dfae44d05,0x000bad35608c8e97,0x000a78e5d1c181a0,0x0007cad8ba90d885,0x0000000000000000}, {0x0001cba5026e7f38,0x0009593d89eff94b,0x000b88834191828d,0x000881379cd1acbe,0x000c4d9c16250e77,0x000f4d66dbf51b1f,0x000703cbf985d682,0x000998e4fae0e78a,0x000e124668125e5c,0x00095c7096d1799f,0x0000000000000001}},
    {{0x000c267dbe90f79a,0x000a682de8af3a96,0x000fc2373c7d7a0d,0x00046c045ae71058,0x00067b05a94e6008,0x0009ec9a78879108,0x000973f0df20f654,0x0003d4a6c168aecf,0x00050f6bc30604ed,0x000f342722d4210b,0x0000000000000001}, {0x00089badc8348ffd,0x0005ea32767a9d3c,0x000dc1a4baa76ac9,0x000219cd3eced60d,0x0007d2d3cddf3114,0x000c14e1ea557cfa,0x000c466d40b6e234,0x000224ae183077a3,0x000e59e159bfca75,0x0004c30d62fa0c8e,0x0000000000000001}},
},
{   /* digit=41 [{1,2,3,..,}]*([2^164]*G)  */
    {{0x000acef3fd9ab352,0x000a04dda16fb097,0x000e90de3351fbdc,0x0001f9baff197a3e,0x0003610909fc0701,0x0003d538e2bf8355,0x000fbd9d3c214c4a,0x00064b2db047d1ad,0x0000b9e3fa7800e1,0x0001033ba0bb0ce3,0x0000000000000001}, {0x000cb2552f015a84,0x000cdab20301de3c,0x000af7c3af2c8c0d,0x000fe99606c79c8a,0x000d638fb52847ee,0x0009bf56737cb586,0x00000b1ec4f260f5,0x000362ff887d36f2,0x000ed3b693913291,0x0006e3c40f0d7ae5,0x0000000000000000}},
    {{0x0008a516e5648dad,0x00047202a3fb8a9d,0x000ecb3edff5fedd,0x000220d17fb9838f,0x000dc8b9ac40f762,0x0009a8311e23ad98,0x00084edfb615d6c5,0x0004e6c85dc486c7,0x000bf81a7ee5f8f8,0x000ecc58d5bb866b,0x0000000000000001}, {0x000d41ef176fcfa3,0x00078f007acce1a1,0x000d8b8126b20e97,0x000a71b3438944de,0x000134e76c73c437,0x0004a56abd9a1b4b,0x000de8db7385f9b1,0x00043115d58229b4,0x00034725891b4078,0x000c55ba8c32f815,0x0000000000000000}},
    {{0x0008e051939a3b7d,0x00010361ba38d482,0x0009c9a686091017,0x00050f6456db6700,0x00031ba66d450ac6,0x000e0bdd4225b759,0x0006e52d315738bc,0x000d21403d74797c,0x000a041eb53ed58e,0x0002f948ee60c564,0x0000000000000001}, {0x00014e408d1cd601,0x000cfebde9152461,0x0004123bd5f4532c,0x00083ab7b9fe9b7a,0x0009704a01b31e49,0x00040d9c79a4402d,0x0009ff5b8e0a168a,0x00048d442aea1790,0x0001410d782cc3c0,0x0002bf2d98ba10cb,0x0000000000000000}},
    {{0x000943818d1af858,0x0005d42684f68399,0x00068a5f9139d27b,0x000d03a1a3ed9c84,0x00024e699de7f9f9,0x000ddd7e41e31174,0x00089cc967769d86,0x000a0e9e00b5f6fd,0x0007b63934a6926e,0x00011c5b068a8b3d,0x0000000000000001}, {0x0007d21cfa86aa41,0x000f529a2aecb429,0x000251f8677cf147,0x000bad3bd2a35774,0x00090bedc57bbf0b,0x000a31f1dbfe5b37,0x0001e75b3cb7422a,0x0006476bcd9901bb,0x000278bd8b31cdbf,0x00082a6fb171258c,0x0000000000000000}},
    {{0x0009d9b88bd44811,0x00086c7bafe985de,0x000eb018e7fc2f20,0x00037a5b53cb3738,0x0000a097f28e364d,0x0000b5541e546ab4,0x000530e972bd2ec0,0x000b65a95e020994,0x000221ddc10db4cf,0x000295000b94fc68,0x0000000000000000}, {0x0006ace5e2ed6000,0x0008ffd606613047,0x0002a24af3b853da,0x000aba583e1b87cd,0x0004618719533717,0x000d61f56ae2be40,0x00025ef5e9069ea8,0x000f94027fe98e78,0x000db6fc7d9c1583,0x00075271696c0d71,0x0000000000000001}},
    {{0x000f12734c3ec92d,0x0002bb3d48fbed19,0x00049bdd26ff69ad,0x000fbf26985b989b,0x000ad451c21eb61b,0x000237a30e35f12c,0x000a3b3680a082df,0x000188ebe4c92751,0x00087a8fbc731694,0x000b03a8bdfe9408,0x0000000000000001}, {0x0006f89f4e0d5883,0x000d80de19c8b935,0x00077afef27eab9c,0x000538f8f941390d,0x0002b8c79f62a16f,0x0004a907ee9a2c1a,0x000951eb7aa5d968,0x0001fe7d75aa9877,0x0007b983b59fbafe,0x0002bab437db42c1,0x0000000000000001}},
    {{0x000bf512d363aeb8,0x000e0db50c6d9411,0x0000e1101f753fc2,0x0006d62a0ded1b7d,0x0004a1ec0fcb3b8e,0x0000a9719f9cb02e,0x000fa60331be1189,0x000525c569643656,0x00081aa5691f4f2d,0x000a963a9ea530b1,0x0000000000000000}, {0x000098b88fd83f01,0x0009e9aed5969329,0x000769c1597dbeae,0x0003f34dc1aadb7c,0x0006d041d0f773cd,0x000dcc7a18555ae3,0x00057b66cab6672b,0x000c3dbd797513fa,0x000ec420f27eb3f3,0x0003c62ce13b7853,0x0000000000000000}},
    {{0x00057f7ec577ceaf,0x0009584ce56b583a,0x000ce15377e1306d,0x0005b26b1e23a49b,0x000f42d98c317bad,0x000c523283ae8b11,0x00081ddf50073f0d,0x0004ab516099e7af,0x00029299e519277c,0x000c0d8cb7cfdd6a,0x0000000000000001}, {0x00029a85f4a1c822,0x000b7e9213cb42ad,0x000364e5e4a37030,0x000a3941f8a54d03,0x00050b7d507ec771,0x000db1def4d6f8ad,0x000eab3bd493bf4d,0x0009716822a9c65e,0x0005d463b7e2f601,0x000728062fa75d1d,0x0000000000000000}},
},
{   /* digit=42 [{1,2,3,..,}]*([2^168]*G)  */
    {{0x0002ee214ad0e3d6,0x000d51de6a66c4a4,0x000c1ce94446c6c7,0x000c0d5dd2eee21b,0x000e88f8f4a8deaa,0x00055296fd5914a3,0x000dd876c3945207,0x00083798ebb4e647,0x000fd6484696a7a6,0x0001d866ec9d8ec9,0x0000000000000001}, {0x000ca34e120495f9,0x00050701e46446f4,0x0004431e6d90fc27,0x0006b7610b310d40,0x00086e5199614976,0x000e7e80f704e266,0x000aa764f7efe74a,0x0003d9535c6d9829,0x0005a23c25702e18,0x0000a0457bd92a75,0x0000000000000001}},
    {{0x0009cf085024c2f1,0x000c0aff178cc9fb,0x000cd1f6670717cd,0x000588548870fa8c,0x0001a99c44c6bc4d,0x0007a4c31ed62743,0x000f88c552f232dd,0x0008940140f085da,0x000a8211a1d88681,0x00041216e4c1b09a,0x0000000000000001}, {0x0006cac59e6c3159,0x0000ba3374279c4b,0x0008991eda2c878a,0x0003b4cf84ea0b3f,0x000025e729a3932e,0x00047222c0cc5f31,0x000ba94b4346c5bd,0x000e2995032ec5c9,0x000db493f41a4bab,0x00024e7b6e042b7d,0x0000000000000000}},
    {{0x000aefc5789d3eda,0x000070117b5af24b,0x000a5c6b9c3050d4,0x000dbfc9621085b7,0x0006f4c0b7973deb,0x00006f6cf4b4e834,0x000082f092a35673,0x0002d877db7b37b4,0x000c2eac8682b506,0x000eac10f86afedc,0x0000000000000000}, {0x0002caf651b8b0a4,0x0008310eef2a1934,0x00026025b8808ec6,0x000dcff1e64f055a,0x000a67192e09ae5e,0x000d785482258125,0x0007daa7d24e92c4,0x000a9c45e5162876,0x000fc7c72fb7aba4,0x000522976bb5f88c,0x0000000000000001}},
    {{0x000921c0f982798b,0x0001a2079475b7fe,0x000ea0fd52e410ea,0x000e44af77d4bbcb,0x0001f260a54b0212,0x000269af2ec66a7d,0x00034794993bda84,0x00050b15e358d04f,0x00067a4d30bdfadc,0x000e912250ea3d1c,0x0000000000000001}, {0x00083de4fe7bebfa,0x0004fdfb63579e27,0x0001abe0cbad5ac8,0x000820014b8a145c,0x000a85d987c51840,0x0009eba9aacfadab,0x000291af5fccfd5d,0x000785e551a982de,0x0002bcee4372c455,0x00049c9d89842d5e,0x0000000000000001}},
    {{0x0000817678d00826,0x0003072fc12b3906,0x000fabe24fd4868f,0x000b2a4f9e0b8813,0x000ccd87b27441cf,0x000e7fd0a48234db,0x000ea747d9a2a9fe,0x000c91ba0d4add56,0x000c9d0dd2d3e7c8,0x00005660e4fd17f4,0x0000000000000000}, {0x000a904f88c1be1b,0x000e5cce4c6964ff,0x0005fb6194a74952,0x0000f033d222444b,0x0008c26fbb11965c,0x00055ed1ac1d1bab,0x00020c09d970630d,0x00075b608324cefd,0x00050cf259835d15,0x000462cd49bc1143,0x0000000000000001}},
    {{0x000b46239d54de36,0x00013af2871bf6df,0x000bb6d9f31a1b7c,0x000528b0f5b2569d,0x0006b9497778a81b,0x000c963043af6788,0x0003bf9954a12672,0x00059feeec8df36a,0x000d60c22b5fdead,0x00060d265f0f8b6f,0x0000000000000001}, {0x00050d0b6534b1ea,0x000703b71e08797c,0x000d2bd35e284a7c,0x000105aa68827a45,0x000902245c12e4ca,0x000f1afdb8eeeba0,0x000caa7693b8db6c,0x000824a39f45018e,0x000945d0c9d12756,0x00055f86289ff82e,0x0000000000000000}},
    {{0x000f246813a5e2f3,0x0004d2dd1bc96870,0x0005743352958a8b,0x00007a9386d4a79c,0x0008b4a29091d043,0x00059ba9e47bd2da,0x000478de8a606e11,0x0008c9f2a8c27ae1,0x0002946224c1c93c,0x0003ef3adcff2ded,0x0000000000000001}, {0x0005100b79546483,0x000ac268f6c48348,0x000e4b2ec17a54ad,0x000f85818d6815bf,0x0004f425318546e1,0x00013cbacecaadf3,0x0006d908fa2a9c92,0x000e8808196d6c46,0x000ad801f4a291fd,0x000b7ecba0623fa6,0x0000000000000000}},
    {{0x0007b0f39088ef39,0x000a435ae74e03d1,0x000fbdcdaf3b17b1,0x00090868e5084910,0x000019102285b63c,0x0005454d88d8e63c,0x0009e2380d185fed,0x000af9e19dfe50f9,0x0008e09d7ce8d3eb,0x0000155127749872,0x0000000000000000}, {0x0007fda1b031ef4b,0x000dfd7188feeb77,0x0006801e0f6f597f,0x000e9d1729652f82,0x0009d58dec034252,0x0003cc68d0c6aa0c,0x000a4e76779b37e4,0x00008d509f569c62,0x0000c41330558ca7,0x00056956b5657bd9,0x0000000000000000}},
},
{   /* digit=43 [{1,2,3,..,}]*([2^172]*G)  */
    {{0x0009008a556937c2,0x000f76241f10378e,0x0004e7ecf0092193,0x00097f48f8905d70,0x000c86b4870ad280,0x000f86eb6f389aca,0x0003ffbc3b9a3132,0x000a9c6b9598fe5a,0x000429f1014fb463,0x000e06408908552f,0x0000000000000000}, {0x0000c94ae41024de,0x000a6dd0399afa53,0x0007da5ef17ac70c,0x00080b49854eb299,0x000104afd62b1e2c,0x0000b1375777d7cf,0x000794db8dbecfef,0x000ff21b1b05dfbd,0x000f1e68e47404db,0x00080928abdaf296,0x0000000000000001}},
    {{0x0001636898bf4d11,0x000fb75ab01bffaa,0x000ba4b1f3e58bf7,0x00059cab50bc67e3,0x0008acea4689ce8b,0x000f1932a30d30cf,0x0006e5cb3d1d8eda,0x0005fa7949e492c0,0x00041db2db16d8b2,0x000b0610d851b96f,0x0000000000000001}, {0x00054a2b36667691,0x000ca196d36fe2b1,0x000766e2a6109d47,0x000f9263f1863dba,0x0003be92b5a5ba8e,0x000aad9918a5da16,0x0009189520c8298c,0x00010a27963af5e7,0x000b8c3b84ab05f9,0x0007bafd0103c420,0x0000000000000000}},
    {{0x000e3e45f8d73683,0x000eb8ebb6d11caa,0x0000f274ee508fde,0x00020c83562c576b,0x0008510e47baeee6,0x00079b810588c571,0x000894a919ff42e2,0x00007edf259b927c,0x0009d16a223100a0,0x000a5b2acb9ccb16,0x0000000000000001}, {0x000e8415a9179d06,0x0004b594d74f07fe,0x0004fb6e0e5cacca,0x000788b708cc549b,0x000c0c62edae508e,0x000b9ef886c2847d,0x000e40664c8eee69,0x0003ed24b57a9dee,0x0002b9d44a547432,0x000a6f16f12261ca,0x0000000000000001}},
    {{0x0005496bc42e6e51,0x000d33d320585033,0x000cf402bd388067,0x0003e6730074be0b,0x00043e8db4e94291,0x000f7beef462a0cb,0x000e58a8c2ead81c,0x000b97eccd5df06d,0x0005954e3501f23b,0x0004b4a8b8e4e11d,0x0000000000000000}, {0x000598c1e025da1b,0x000b09bf9648fc1d,0x000d224f8ad9987c,0x00065a60d88fba1f,0x00054d86a1d9f606,0x0006c4ad1df1e7f7,0x000e1da4acf77f72,0x0000938971a27713,0x0007fc94e0f78da1,0x00083992811d7d3b,0x0000000000000000}},
    {{0x000c9cc6dd4a5914,0x000862d80be96443,0x00008c7a249fd0f7,0x0001ea54a0d2c9f8,0x00048d9e55013f6b,0x0007ab76e8d002ac,0x000cbf4462d73cac,0x000faf5cdb58c492,0x000ca322b819e5c1,0x000b840745406425,0x0000000000000001}, {0x0005f739a14940b4,0x00097d20ee2a886c,0x00035ab04c341a53,0x000f7a9d2904ba7b,0x000d9cae762f47f9,0x00007d2eaeeeb5be,0x00070ab079042e0b,0x00060a339ed63e5f,0x000c7b9658ba8e43,0x0002d18d85499745,0x0000000000000001}},
    {{0x000b401e3813737f,0x000ff61118cf0239,0x000909b65cbad1c8,0x000da081fe099573,0x00028cfc70caa9fc,0x0002bfc31062db69,0x000e85af4aac9c83,0x000ba3d1d4e51a7e,0x000363dd1405fca7,0x0009117097ec2370,0x0000000000000001}, {0x00065c78edf4f376,0x000f36321b45daed,0x0003283085bc71ee,0x00018a85f5b5aa08,0x00055758f2c2f181,0x0001623497212c90,0x0006ecdfee014f92,0x0000a48aadb790d1,0x000881e12f4528d4,0x0004482acaa286a1,0x0000000000000000}},
    {{0x00050bbeb7940a25,0x000eb62b0dec1d2e,0x000f7146dd0fa42c,0x00051beef911c829,0x0009947cccb28e02,0x0009505362c5e903,0x000767ef06d55451,0x0003dcda2ee6b16e,0x000b2373652d7be8,0x000cb5af116c86d2,0x0000000000000001}, {0x000d36b874b6449e,0x0002d7bb963c1def,0x000de8609229e57d,0x000375fd0ce127b2,0x000b5890dc213b70,0x000a1d88db3c82d4,0x0007b583b09ebdc9,0x000cc6b137b10089,0x000cf29a5fc13efd,0x0001907605ca17a3,0x0000000000000001}},
    {{0x000665e2bbfdb04a,0x00017e4232c5cb5c,0x00026232f5f9a245,0x0007a0275981cd79,0x0005ae253d4d80a2,0x0006c00bb7783b1d,0x0004c2589b5ab0bd,0x000f6c48caf740ea,0x00082e177fc5351c,0x0000fd2b0e714ba4,0x0000000000000000}, {0x00052b5ad6ac73dd,0x0007a311881ba785,0x0004ccac10cfb206,0x0003dcbe5d449097,0x0008b8873accd901,0x00080d70e5b2cf2a,0x000440b2c2817333,0x00067c3b711d4631,0x000b996623747bc6,0x000383423c70b2d6,0x0000000000000001}},
},
{   /* digit=44 [{1,2,3,..,}]*([2^176]*G)  */
    {{0x000b11d1789dc869,0x00016c2eed227fa8,0x000916842cb7fd9a,0x0008564ce12a5d02,0x000bee59ed474675,0x000e675f354b48f9,0x0005d69ece126be8,0x00018ce3aca2f7c7,0x000768d6000f88d2,0x00090f26ea6ff29a,0x0000000000000000}, {0x00096ef4ce69e270,0x000f2da0efb2f05d,0x000a99dc276ac3a2,0x000e0342757c443d,0x0003b390d2a5e23c,0x000e7ea78e9b674e,0x00085e132e72b987,0x0006b6c21856dca4,0x0005bed8cda17d0d,0x000237220788bdee,0x0000000000000001}},
    {{0x0002364996ca25a6,0x0007ec8d70cd440e,0x000d8467c5161afc,0x000408724c9aa882,0x000b962a215cbbc1,0x000c4986c1ad6d3c,0x0001332912aaf7a6,0x000d6db2702d8369,0x000a17e017d4a1ec,0x000f2dbf2405e93f,0x0000000000000000}, {0x0000641168090c5e,0x0006fce42ae3e68a,0x00039938713395b0,0x000394a15bb1098f,0x000db97734c1bca3,0x000edfc62ae8c0be,0x000bc2f9b0452cb1,0x000304c79c90c661,0x0000dada4e625332,0x0006fc2e4ae4342a,0x0000000000000000}},
    {{0x0001bd7fc156252b,0x0000ddb25b337fb0,0x000ac5d025ae1e66,0x000c26056a73c379,0x00095dede6af2b69,0x0001ae9121b7e81b,0x000754f6cd030d2a,0x0008b47d1e9a5f7f,0x00025d238c9b7c0f,0x000d32d6fa902ce9,0x0000000000000000}, {0x0005ace423d94184,0x00056f6ab6a655f9,0x0008fa78d47709a3,0x0003f5d39d32f258,0x000beab0a90b8c58,0x000bc517995d68b6,0x000ea4acae9d65d8,0x000fd569fb104a80,0x000b09db02cb3b12,0x000c624b3e1e5f67,0x0000000000000000}},
    {{0x00093cbca6dca0b6,0x0004a2146559221e,0x0006c357ebc20032,0x000e73dafbe29569,0x00073f1c77b70537,0x0002b0a8e959d415,0x00055d9c50a71dc1,0x00037c9b3656d184,0x000283b617fcbc17,0x0000976acf8093d9,0x0000000000000000}, {0x0008b573715b4734,0x000173f0027024fa,0x000386bfccf3b38a,0x00095480bbc99c54,0x000668bfbf241bdb,0x000353dffbcc88d5,0x000216b7968e8858,0x000de22f661faa2a,0x000189437f0cc373,0x000c1f5601679c0c,0x0000000000000001}},
    {{0x000a86967182c501,0x0001f634e40148fc,0x0001c864ffbfa398,0x0009d6d142879632,0x000443e4b6047507,0x000e1e5a879eef57,0x000d2b8fd7f7f136,0x000d19b6378838d5,0x0007815ed1c2726d,0x00042ef17abcb4c1,0x0000000000000000}, {0x000b9a5999895b25,0x000be140e558227b,0x0007f28ae923d146,0x000d00a58852f582,0x0000e60ada16c8cd,0x000158a85a7def11,0x000e5c61d1152d28,0x000d4be61bf1a55a,0x000cf413c0a31606,0x000b3cd625cdfd8f,0x0000000000000001}},
    {{0x0003f2f8ccce2027,0x000fd5cd45c4a564,0x000a6b2411224a0a,0x0007a5ca2258c4c8,0x000678f855fedfa8,0x00055199f43975cb,0x000e9a39edc6298c,0x00007312684e5a48,0x000adaeb9f55daba,0x000b39c9f5f377bf,0x0000000000000001}, {0x0003e0968382a7ce,0x000869c70ffd115a,0x000ba001f2afcccb,0x000107bdfe8068fd,0x0000206868f7c124,0x000821a90928b9fe,0x000afc533728dac3,0x000b3e9edff0ac94,0x000d10c697f67565,0x000bea250773ba0b,0x0000000000000001}},
    {{0x000275a2c8f91400,0x000bb4c241f78224,0x000c4fd93b4ba60f,0x0002941b616268c1,0x00020107f7964087,0x00031b438825e04f,0x00019247786625f8,0x00028de20083c5f6,0x000abde39791c6d5,0x000b3b75c25ecfb0,0x0000000000000001}, {0x0008e09f47b9d8c3,0x0009374c6bc5ceb5,0x00038e27941b3112,0x000e3235cee2666e,0x000ea8dbee896ca0,0x00030660009b498d,0x0005f8f0f2897645,0x0000fb5ee44458ff,0x000fb559aa7b5e14,0x000272ac85e138f9,0x0000000000000000}},
    {{0x0009f0c6193905a5,0x00013e99256667bb,0x00027fdbbfc34892,0x0000d2c71218ca33,0x000915a83f00e563,0x000d628331bdc8df,0x0003e8128ee96b80,0x00016a5f7e06bfe7,0x00016364a2a7cd33,0x000c748cd2a08bdd,0x0000000000000001}, {0x0001d90fa51d3800,0x00020c814ecb8822,0x00000fc79208b5df,0x000f252076343a10,0x0008a14b68032c99,0x00054fe0dc71413b,0x000d97c9a173cb46,0x000c85a386e9a9ac,0x000bf160a14a40bf,0x000032849e997087,0x0000000000000001}},
},
{   /* digit=45 [{1,2,3,..,}]*([2^180]*G)  */
    {{0x000384b0dc2ffbb2,0x000e0c16c289b477,0x0009eabe48cf9601,0x000199d671ddca51,0x0006f3fce7863b3f,0x000e01be3ea3ecba,0x000b70167c58c7d2,0x000f4893679afbf4,0x00019a4362cb78d1,0x00061515a3d7fee0,0x0000000000000000}, {0x000f2840f746e722,0x0002ef160c51fc25,0x00097156a16516e7,0x000e8398d9625db3,0x000d63f5b2c0ebf6,0x000c5b6523651404,0x000476dd10c4d87f,0x0001f40ffa318eef,0x000788025e5d3977,0x0003c298fa2547e3,0x0000000000000000}},
    {{0x000523e81658a625,0x000aef8e050759b2,0x000b0377d5042659,0x000b9ae72b36823c,0x0007eff957169419,0x0009705cebf46fc1,0x000bd18b61ce7ad5,0x0007a7135b602fff,0x000f2e092fe9192a,0x00074d30a3a8e596,0x0000000000000000}, {0x0007c895ead96751,0x0006523da4889766,0x000467afe86eb732,0x000a5ee25b7a7cf8,0x00000f2568e46393,0x00079a3304b15dd0,0x00036bd203f1569b,0x0009a5e938c0d91a,0x0001da1271a34645,0x0004c688c575bf52,0x0000000000000000}},
    {{0x000c62a6b633bf04,0x0003c0eaef0121c8,0x00058d7354098cc5,0x000448cc925273a9,0x0006f73c56bf4c04,0x00042b800bc52be4,0x0008d6b39147d475,0x000444cb5cfe3029,0x000d4247fb2312e0,0x0007054c4d89dd9e,0x0000000000000001}, {0x0000edd6a97a9163,0x000582ed4f4d5b46,0x000b9ca61309206a,0x000fafa93e18c6dd,0x000bda68f9bb8a3e,0x00070a52c8b2d783,0x0007728c0dda564b,0x000c0dc789e7dbe4,0x000119aa3e8a6481,0x000bed27f421a4e4,0x0000000000000001}},
    {{0x00001ee133405081,0x000b94055dadf3f3,0x0008803374bd3d6a,0x0000e431a078817f,0x0000ae1298465c73,0x000a08da98aae817,0x00076bc8b779119b,0x000c1b8f7410f128,0x000bc98dcbe46247,0x0001761805980867,0x0000000000000001}, {0x0009de67dab5cae2,0x0003d2d0125b70f5,0x0008c5ad3a01682d,0x000cf59a9c7c1b26,0x000ada095cf6362f,0x000b79b1ed6482c8,0x0002b3bc253c84e5,0x000756917d1dd695,0x0008f439fdfad9c3,0x000651a63232aa5c,0x0000000000000000}},
    {{0x0003a055275e1f13,0x000bce620ca4b51f,0x000765c9fcc48133,0x000387e5710e23a7,0x00041d9c294797a6,0x000fe4eedda6621b,0x0009f733bf9d9ac9,0x000e4cb8a3045df1,0x000d5c96c4f51d70,0x00041a25c50ad245,0x0000000000000000}, {0x000acd86687a04f6,0x0009bc4b6a5c45b3,0x0003f85a2b09f7d1,0x000f69420758494b,0x0007e554c9337d50,0x000ccb9c2f40c240,0x000e482c5dfc1a60,0x00016ad44e8b11e7,0x000d080e60fea531,0x0001889fd549f4ed,0x0000000000000001}},
    {{0x0007e29c5ef5cdd9,0x00046b2b2e558b7e,0x0004702314f3e6bc,0x00026fae56eeaa30,0x000145ca44a1b067,0x000ea8da792ee6f2,0x0007e4c829cf9680,0x000d723cb279141e,0x000c514c645b326c,0x000b3d5e8e8931da,0x0000000000000001}, {0x000e5ed0862bd48f,0x0009404a34e74e61,0x000e1d4a98483644,0x000f45001f65c56b,0x0008e062ee7183e5,0x000a39ef75aa764b,0x000f4509012ed646,0x000742837f0ebdde,0x0009ab588faa786a,0x0008d7474accf0f8,0x0000000000000001}},
    {{0x000f31aa7add26e0,0x000b5f70683b341e,0x0002190eb5f5ed33,0x000e3b2bf3278604,0x0002cdb29e4008f6,0x00042f0700c911a6,0x000f5e3688f5189d,0x0007c2de5c257eff,0x00089c193e2d4667,0x000cca5de47c9861,0x0000000000000001}, {0x000dddac10383cca,0x000803caddccaca7,0x0000778df17cf555,0x0009278c5faf93e7,0x0000e7cfbb523b02,0x0003ef004ba7546c,0x0007290d52d052d3,0x000f54a34c36c895,0x000e1b89dcc555fa,0x00058777136cbca3,0x0000000000000001}},
    {{0x00060b5ef6c20e82,0x000bf430fe1ead47,0x0003a480e70d1479,0x00097c0aba684ec7,0x000549990971954c,0x000a1c5645d306cb,0x000cc85cc5c264ce,0x000739efac323d9e,0x0003b20c4465cbfa,0x000b4ee9cad749e6,0x0000000000000000}, {0x000242934808827e,0x0008a9860bc18213,0x0007a452bdb41b29,0x0006c3f651ceda44,0x000f153ca2965078,0x000e0cd8cc7845a5,0x000c9cd5913baf87,0x00050312de2e060b,0x000a1444279bfb31,0x000ff8a16f8265f7,0x0000000000000000}},
},
{   /* digit=46 [{1,2,3,..,}]*([2^184]*G)  */
    {{0x00033bcc8924eb55,0x0002e9d518ffb740,0x0001ae0cd732da2c,0x000cfbc19a4290d6,0x000d8784c1f06357,0x000fe209893ca1ae,0x000969a85a8dedb3,0x0009c8eb2e932f87,0x000bcc740550ff52,0x0004f554bf85aafb,0x0000000000000000}, {0x000bc6372d7f8438,0x000dc0557f4f2ed5,0x0009d0c30f3c2efb,0x000ddabb262ac2fc,0x000f7a05b87d4d5d,0x000c91e745769d1c,0x0008c994d0a4907f,0x000889250072dcd3,0x000ffae1ac453a28,0x0002a8e72458000d,0x0000000000000000}},
    {{0x000d9177fbc76a5c,0x0003975e3cbf7406,0x0002f09def039ed5,0x00034da80caf736f,0x0008efcc790febc5,0x0000ad47e746448c,0x0001ca336b92fa7b,0x000b90e92c64c767,0x000dfd8d6637080a,0x00032f5711517b52,0x0000000000000001}, {0x000a0257ff4a1581,0x000bc02441238656,0x000364971ed77234,0x0008b1d09b2d316f,0x000bfdf4ae5e00cc,0x000468fa8d307856,0x000805be3791c041,0x0003fa589236fc69,0x000a337620c1fe73,0x0001e737b5760989,0x0000000000000001}},
    {{0x000e1990ae2c44bd,0x00083ee2175b6a29,0x00005d1fb5989698,0x0001375eaf1c4bd3,0x0009f54aec5725cd,0x00017c1f0f7d222f,0x000f9f96b74e2d73,0x00053fff253f88e6,0x000b31a11aea1b12,0x000aa32748b4a307,0x0000000000000001}, {0x00007b074c7b461c,0x000258e6e4224b52,0x000162fc7af983c9,0x0004966825052f5a,0x000f9138a0346a4a,0x000a7041242b7952,0x0000a366f5699476,0x000460c88c7d5eb7,0x0003f2b3125e31d3,0x0002a892d14ada09,0x0000000000000000}},
    {{0x00001e6a21a7b432,0x000c3971b4886b8a,0x000dae7cb7883120,0x00059d28f3efe6ce,0x00028e1699713fd6,0x000252af65756250,0x0002a3acd7c4a210,0x000f7efc9c5a81fe,0x000e2a5f82fab4ec,0x0005c0924441558a,0x0000000000000001}, {0x000495dd493563c9,0x000ccadf9b0e7295,0x000ab5a8f70bb0fa,0x0005b32501ed29d2,0x00036f439adfe6b6,0x0000a6c7202e9c24,0x0006531bcd403e24,0x00064526a2b69777,0x0001dc2d590cd125,0x000b64170acdcfa6,0x0000000000000000}},
    {{0x000b0bb5e03ac48f,0x0009bb5837030273,0x000a05cded5e6ec1,0x0008034dce79ed12,0x0000fc54532094d5,0x0008fcc6c534a769,0x000bca87d8be0fee,0x00041150d981f9e6,0x000222345254c456,0x000b2aa496b6e112,0x0000000000000001}, {0x000d2c8de5bb7e5b,0x000278f0be2794e5,0x0001b31bbb57b1c7,0x00001958330187ab,0x000f5dd751abf9bc,0x0002de4b57d090a0,0x0009cb74fbe565f2,0x000f83e310b95170,0x000d1301cd0ee2f4,0x00049fd2006501c7,0x0000000000000000}},
    {{0x000e8d883bcef9f8,0x000be3770de7cc8b,0x00007c65e3e95107,0x000ac96f780e3eca,0x000413d615089cf6,0x000585b5b22549b6,0x0008b5facd5da79f,0x000f3c8b5c5a4c0d,0x000d6dfaa970b49f,0x00065cc025c0e7ad,0x0000000000000000}, {0x0003c64dd34154da,0x000343c797b7cd0b,0x0001f367813bc308,0x000fbf3f138ae118,0x0006f1f8c6302e7b,0x000f35ea2ee3cc54,0x0003a0b904ac34ee,0x00052596f106852c,0x0006e533ab1310ec,0x000abf763b19381e,0x0000000000000000}},
    {{0x000d9a73e24c887c,0x000707461d095f01,0x0005d3ad552ce968,0x000f402b6c527f5f,0x000818672d6016b3,0x000279bc4633dd66,0x0000c571c90fed28,0x000cee78b5512020,0x00048d6ae97b4812,0x00055292fa8b91d9,0x0000000000000000}, {0x0004608b8c1577cc,0x00058615049c4716,0x00077fa05c3b187a,0x0000d33110dc1846,0x000554a923122c03,0x00015b3d3cf40b2d,0x0005e05a3843c4de,0x0006438408a6964a,0x0005f646af7c591a,0x000ae89a0f7132ab,0x0000000000000000}},
    {{0x000b5e462dd556b6,0x000f3aab5e9c2f29,0x00040c3ae00c87a1,0x000aade98fdfc7cb,0x000f2f671ec86f72,0x00069dd7b2aa376f,0x000b6f90c4b07483,0x000ae5c39e831a9e,0x000ef6929b8bdb31,0x0007125a4c5224c9,0x0000000000000000}, {0x00080ab908d10b8d,0x000b7c8a32a9943d,0x00051b7d4fd0edbb,0x0008eaa89eb83ad0,0x000fb343de0ebbe0,0x000d3c4d0cc33cc9,0x000b15124b0953fa,0x0007582773fc9c30,0x000ab2c193a021a4,0x000b73ddfb881675,0x0000000000000000}},
},
{   /* digit=47 [{1,2,3,..,}]*([2^188]*G)  */
    {{0x000f014ad29ca649,0x00075a10e7e9c3d6,0x000042dda6a91edf,0x00069276fbe9047f,0x0005a497f91416df,0x000b982ab7fce403,0x000b8b61e6adadfa,0x000d218a9fd9d973,0x0001c8c04e2c23f1,0x000cb12274d47d9e,0x0000000000000000}, {0x0000ec3de397b98a,0x000d9a272cecd709,0x00050e492db6d724,0x00082a50e32d2f19,0x000db6bf40e9c68f,0x000b25727f0678af,0x0007a36e6ae78194,0x000cbb096d1806b7,0x0001afd3feedfa35,0x000e57c17d9b9ff4,0x0000000000000001}},
    {{0x00078e57ab05c549,0x00081a123d2b219f,0x000ecb0183ca3cf9,0x0008ed9f1eddfd07,0x0002f8f90e3c6699,0x000ad41bb20e0515,0x00019c77dab5c5ef,0x0002ca7830069394,0x000ae5cd1de605b3,0x0003933d6039cc98,0x0000000000000001}, {0x0000ae5b05bb2b74,0x00071168c4bf8259,0x00001a66f3efdf4f,0x000e1da4a65b0015,0x000ba0665dbdf241,0x00015f360d4c3387,0x0004e85c88fe301f,0x000c061a8e048acf,0x000bcc0119ca9957,0x0009ea8585dfcf51,0x0000000000000001}},
    {{0x000c2a4869f8ca68,0x0005748af64adfdd,0x00044c661ce61bf4,0x000fa33532bda5e6,0x0004409ebd1c4df9,0x00063b107af0f45d,0x00013ef2dc8804b9,0x000a186c6c3f3d75,0x0005a7ed73f6b67c,0x0000b525bc5b72fc,0x0000000000000001}, {0x00008fa0f93430b8,0x000bf3cdf63616c2,0x000a2ed8b79415ed,0x00008df169f3be1c,0x00006a9b7669442a,0x000be581a2acda6a,0x00093d2dae365779,0x0006ea987608134d,0x00059b31b3052589,0x000d8078ebfe0716,0x0000000000000000}},
    {{0x000a0e4faa59f069,0x000d33d96e52e437,0x00029f2632f3aebd,0x0000c85e4fd15682,0x000de4f3be7892c7,0x0007d9fb180a1634,0x000b175638b44c2c,0x0002e33499b53e6c,0x000cdad290b60dc3,0x0009d1cf1fcbab2e,0x0000000000000001}, {0x0001854cefb1da9f,0x000257b5b7539f5d,0x00096df1240b9d47,0x000f9e9a561ffc72,0x0000d6d9452715e9,0x0005aea9109f0df3,0x0005d521e814b452,0x000c7037d6e74c47,0x00060afbb2239aca,0x000dfe3a178a1e6b,0x0000000000000001}},
    {{0x00085fac7aac5d24,0x000e6efcd816f4de,0x00001aa65b85ec90,0x00042ef288a94272,0x000527aa3e5baff2,0x0002c225dbf973aa,0x00073237d80e262e,0x000ac84d268b446c,0x0000056980d17882,0x000089041c6047c7,0x0000000000000001}, {0x000f5b36106ae92d,0x000b658d82ab92e5,0x00036754a0792779,0x00032fae5cee6721,0x000bd0394c90fe6b,0x0001825f86d43336,0x000fa2e7d57eb880,0x00022294f3c7cd21,0x00070bb4a5b81f76,0x000e5c797152fbf7,0x0000000000000001}},
    {{0x000d4560b8c46ee0,0x000b73ca40a188f7,0x000b593661397fde,0x00026cffd18ba8cc,0x000c47a735170abd,0x0002887e49a94d3e,0x0002a2ec01caeb9b,0x0007426e36269901,0x000522aa9c52b5bf,0x00066af9e1ef518f,0x0000000000000001}, {0x000d742afa309fe0,0x0006f810d9df60b6,0x000084e739c300f5,0x00056da63d1a036a,0x000cd4f33c2df42f,0x0000b456fee1f0f2,0x0008f569e5589fab,0x00062492c9b09b89,0x000079adb7885960,0x000cf412b618c75e,0x0000000000000000}},
    {{0x000e60d6e9faeb2f,0x000298054778495c,0x0000f99d00d5919a,0x00052dad049c1204,0x000e8b4f342e902f,0x000c225bd4b3fa2a,0x0004f48aaba21576,0x0009d33ad4b48b96,0x000a24fa9d5b26df,0x000f2799a4fd763d,0x0000000000000001}, {0x00017650a566263d,0x000e25ee8cfe1893,0x000763623662e408,0x000a4360ad7e6d05,0x0000ba65a8e233ee,0x000338261baaa5ea,0x000af51b8dde194d,0x000003aaa23ac37d,0x000ab55391298a43,0x0008f52d2a4172a8,0x0000000000000000}},
    {{0x000760e887bee904,0x0009f91c8cff613a,0x0003af1d33766225,0x0002f55a798ee44c,0x0002c7171b76304c,0x00051b89de6b4202,0x000754ce995dc454,0x000a5d7e90f40166,0x00037fe2c45f5e9e,0x000d835f81a1be14,0x0000000000000001}, {0x000c04a7dafbcd8e,0x0007d22e0b1aaf34,0x000ad92815662ecd,0x000b88ed3ef4d947,0x0000190778cccdc8,0x000ea32bf7d0a755,0x00094ed615d6df41,0x00066cdce7de3703,0x0005d94b6a5a2d85,0x000869b1500a755b,0x0000000000000001}},
},
{   /* digit=48 [{1,2,3,..,}]*([2^192]*G)  */
    {{0x000556d5fcb0ca3e,0x000bb40eb6f5de7b,0x00092b00751e1fef,0x000d985badf10d77,0x000bda78c0fd8245,0x00097cec621ec6c5,0x0009de36f6534761,0x000929578b20f59e,0x00008129148b6a34,0x000260858df1e4dd,0x0000000000000001}, {0x0002df7b80140bb6,0x000f0872cf54b64a,0x0005ba02c9e702cc,0x0006a4694fa2136f,0x000ae62ca46c9431,0x000a69d6c72a601f,0x000ff0af210ce686,0x000a108647e23ca9,0x00072d54b7301dc8,0x000b4fc0d011e4bc,0x0000000000000001}},
    {{0x000c2c9272139ecb,0x0008248890056b04,0x000319a82e4c5944,0x000bd6a55d37d95b,0x00074d80dfb735a8,0x000b368732a7edec,0x000dbb960fac47dd,0x0009b7d149244f46,0x0005c8153e4ae15b,0x000dd7d6f5637025,0x0000000000000000}, {0x00023077c37f59fa,0x000e01c814ef1183,0x000d2dfe1b52b965,0x000d66c5cad600e8,0x00064cd44f8d02cd,0x000b170f04ad1f49,0x000b95d6b03da74b,0x0009721ac42809f8,0x0003fd08dc3ee705,0x0005bd69cd062aab,0x0000000000000001}},
    {{0x000b883d845a0ae0,0x000afbae353f2a2f,0x000473d0adeb61aa,0x00037ae3890f51bd,0x000480f0c4103d1b,0x000087e22deca493,0x000ae96c669a58f0,0x0000d7ec27b93462,0x0005f63a771fe3af,0x0004035d6f692734,0x0000000000000001}, {0x00047ce82b6063a3,0x000a032d78ca1a20,0x000ffe80d92bf2a2,0x000357128144148d,0x00065f437565141e,0x000044794e70453a,0x000ed9d74d6e72f4,0x0002c9dec888c3b6,0x000d35b1703c9efa,0x0005564a8b5ee101,0x0000000000000001}},
    {{0x000408c0ef420ccb,0x0003751466bdddb5,0x000686318317d090,0x000f5c351d77faab,0x000e6e1c56990fd6,0x00044f54fded7bc7,0x0007a03658746405,0x000acb87ac9e9b1f,0x000e1a951d060b45,0x0002d4d46b22b133,0x0000000000000000}, {0x000b308639e1f9dd,0x00088fb9f340687c,0x000545e0d0da3dfc,0x0007c0127b5897e6,0x000708cdc1322bbf,0x0003ce8bdc5bfb35,0x0009aefe13ad9991,0x0006b6cb7333e158,0x0005d1b9d92265f8,0x00065e9dfffba15f,0x0000000000000001}},
    {{0x000dfc8b990a47ce,0x00010afcf7dc8ef3,0x000e84517ba6c8fc,0x0002906aab79d6ea,0x000563aab2198045,0x00005b6fc1e2c314,0x000e1c75139c8775,0x000f87b03c5339f9,0x00013db5c7dd8d56,0x000be729d4f04194,0x0000000000000001}, {0x0003ca2969a49a45,0x0003d7263734a805,0x000a96220f01659f,0x000a81ea503a05cb,0x0009a4b1e826b6e7,0x000b9124852cc317,0x000a53155592390b,0x000adcbcb9064287,0x000f6cda7ecb3423,0x000745fa7b75f585,0x0000000000000000}},
    {{0x000020f9870c5652,0x0008ed2cf4bf5440,0x00043a293130a211,0x000b5775772ea602,0x00033659b8c321b9,0x000b8b914e8eddd5,0x00016d7acd2ea084,0x000600a84078289a,0x000073293df2fe16,0x000f1b7632be02d1,0x0000000000000000}, {0x000ae60c00fc41df,0x000dee1aec5298cf,0x000dc3a384668cb0,0x00039330262dc7a6,0x0008200480e942b2,0x0007f1ad6908e660,0x0004d8902ca00250,0x0009dfae47555ead,0x000dd7fb7e96dfa4,0x0004d09336664145,0x0000000000000001}},
    {{0x000d1eaa79614564,0x0008f53026152677,0x0004e1ef41c569ec,0x0009c61bebc6f47b,0x0005a764d392b91a,0x00081c91fd03bca4,0x000d12e91e91f33f,0x000ceb9cb7de2868,0x0000e9b7cc6516bd,0x000c8bcc47c28272,0x0000000000000000}, {0x0007539aee683a33,0x000df86171edb94b,0x000cb40fe4798476,0x000b93f35533bd14,0x0009da702f13dc6d,0x000ba7ad4d348188,0x000a392741f6a108,0x000c52b97e5c2cce,0x000568205c383605,0x000d4f58766e7a6c,0x0000000000000000}},
    {{0x000d3d9203521aef,0x0003dde5091b5f60,0x000ec304735ae314,0x000afe69e360b755,0x000f3119298c9f78,0x000c6a7738e3ed2f,0x000298a24d640365,0x00078b486bf006b1,0x000e9050b3448a96,0x000ac46d50f02b81,0x0000000000000001}, {0x000b1ce68a1d8699,0x000b8559ff13a9f1,0x00023011f5efc1bf,0x0004e57b1d2b17a5,0x0008efdcb9ac6bec,0x00009c3a1153d5a5,0x0006b2a4b16461a1,0x0005a5edc709e6c0,0x000d62c80c93e99c,0x000b0218529aa94e,0x0000000000000001}},
},
{   /* digit=49 [{1,2,3,..,}]*([2^196]*G)  */
    {{0x000e7cc655ddb9f3,0x00013549c78f7abc,0x0006489c7f6e90f1,0x000e52627145775f,0x00027c353f1cebe8,0x000a2f29fc36a4b9,0x0000acc3ef5baced,0x000fb8074e6a3d4c,0x0008d3fd643a9c64,0x0004c070fffe4c63,0x0000000000000001}, {0x000fbd2cdf57826f,0x0005bd9bf19e6e5e,0x0007942ab0ce8665,0x0000c790e82b0e8c,0x0001e2f2b552cb1c,0x00090a098c9dab8e,0x0009810a67eba463,0x000c6a4756fc9b4d,0x000e8cb25c97785e,0x000215f5f5b6c18f,0x0000000000000000}},
    {{0x0002bf06c6b067f9,0x000a2b3dcbcaa8f7,0x000559f9fa4cedc2,0x00001ff4707cbdc6,0x0005eb59f1a1d653,0x000b9620b3fc409d,0x00091f76c53a5feb,0x000e766a3eea48b5,0x00013597ec3fc458,0x000a5eb4cf309e19,0x0000000000000000}, {0x000b24162ae5ce89,0x000e57dda1da6f8b,0x00092393366cd895,0x000d0cbc02de8414,0x0007365ce8f0759a,0x000cfa2564893b65,0x000a74873186b40b,0x0004d0156cb04fbe,0x000490f66512a03d,0x00036b328165e70e,0x0000000000000000}},
    {{0x000d63dbde7982b9,0x000c29e4cd39f5d1,0x000aa87372309f98,0x000951ea561fec44,0x0001afd07b42ddc9,0x00045755866c4665,0x000b2e07bf78c6a3,0x000e9284f87ca447,0x00035d4199cdea2e,0x00049a677e175372,0x0000000000000001}, {0x000229ff95010f5f,0x0003cbc8f306c814,0x0001a7861e7a79e9,0x0002d63c05616521,0x000d995f90f64784,0x0000e16cd8cf737e,0x0001408ff0413e3c,0x0009c3a4f30dedcf,0x000a0a6b443a170a,0x0006e0cc49b5c711,0x0000000000000001}},
    {{0x000ac308c74d834c,0x000a8dd825f7406b,0x0000fbb496f34b0d,0x000075e1de870fb5,0x000227841bcf2365,0x000b8e05ffd3c983,0x000e33dc39c86d83,0x0009f0fd6d0e74cb,0x000d62a5a8904ae1,0x0008c32b1e28056e,0x0000000000000000}, {0x000d2a2671b67c79,0x0004494c1cde5597,0x000c0326e9105031,0x000b1ee150606033,0x00061f18317b0423,0x000cc474ed398c9c,0x000df4796a972375,0x000696b52ef07eb4,0x000ed96071372ae4,0x0005ffabf9d1feb1,0x0000000000000000}},
    {{0x00045b8e28f19059,0x000286054435bd90,0x00012ddcca1e377c,0x0009f510d747b1a8,0x000d3775c0ea63eb,0x000865c7834fcce9,0x0007bbad37d19f75,0x0007bbc7cb402eb6,0x000530a0f5327111,0x000908600a1a8bd5,0x0000000000000001}, {0x000abbe5e02132c6,0x000b17b10fe3c6dd,0x00011b655993587d,0x0008aa4f1c163208,0x00092e7539751ad7,0x000229bfb751c187,0x00003ce5719f77dc,0x0009dd5c3eedf84f,0x000b8c257bb9c60b,0x000345e60da1b9c4,0x0000000000000000}},
    {{0x000e7d40935779ea,0x0002b583ea2a70e6,0x000137328e54c9ba,0x000501ecd4654390,0x000e5d733683ab93,0x0009f374dd118e98,0x000b90700d407bd8,0x000c13b0afb65295,0x00048095857db6bf,0x00070895fc47c66b,0x0000000000000000}, {0x00037df304273762,0x00053684543a49aa,0x000af1483095c127,0x000176dbbf08a1c2,0x000fbbab267dccb7,0x000bd6efdfa7bbd2,0x000abfc8aeeb27ea,0x0008c902ad03e86e,0x0009e682a4e44e71,0x000fe0064991f1f0,0x0000000000000000}},
    {{0x000aed77f4d8e151,0x000d64f6fa111299,0x000d4feb2e79c04e,0x0007b4f97a120999,0x000d370550af65d5,0x0001340660d07357,0x000084ce4afb7c64,0x00040826e57205ac,0x000a7fc0bae197ca,0x0008238f07d6803e,0x0000000000000000}, {0x000454a02cb353a2,0x0000deb5cdf6d6af,0x000f3bb89c8b32bd,0x000b355a1bd8c3f6,0x000e63db355ab5de,0x0005c6b3982f043a,0x000910f0e90987dd,0x0001380521adabe8,0x000fa044a4bf6a24,0x000fd8fb752ed23d,0x0000000000000001}},
    {{0x000fdd1be70b4926,0x0009a826f6dba658,0x000cb4e95121bc79,0x000f676af00f6eae,0x000cee75a521d56d,0x000eca7d7729d333,0x0002e5027fb68ac4,0x0004a49aec5f206d,0x0006a988faa272aa,0x00047f341efc691b,0x0000000000000000}, {0x000df0f078415461,0x0006ca3afd9193e6,0x000e7785c7d78268,0x00030f1e3c2a9148,0x000aaa49f1fa54c3,0x000e96229782ded4,0x00093b6b845da08d,0x00020729c99179a9,0x000904b0df8fef02,0x0009cee6016c6aad,0x0000000000000001}},
},
{   /* digit=50 [{1,2,3,..,}]*([2^200]*G)  */
    {{0x0008c22f80cbfbe4,0x000130943a347193,0x000e2773aac837e8,0x000010c64a3c4f46,0x000be2b750229f24,0x00007131ff138446,0x0000ce7731813b90,0x0000e94672d6c2c9,0x000dcb075dd149a0,0x0006d07531381b69,0x0000000000000001}, {0x000b38c7be8e6de0,0x000a9739ced7c6b6,0x000a61fbc4fb63d5,0x000fe4d18f6b6bae,0x000bd6ae1dbab075,0x0002c3dbf8c1ebed,0x000b0516dce109a1,0x000e4a2962c4c087,0x0000db685a1e1733,0x0001ad9f800e79f4,0x0000000000000001}},
    {{0x0003feea78bb9ff0,0x00046e4fde5cbe66,0x0003f440437dd027,0x0002a08933232942,0x000e421f2f6038cb,0x0008d7b95a50b4f0,0x00073ae18c0b0f4a,0x000bc9451cc035a4,0x0005154ba8955b22,0x000d349d1fd0859c,0x0000000000000001}, {0x000f04652c1a8bcf,0x000b73e19db868af,0x000eea574f2961dc,0x00027664f8c3e1f9,0x000839b512b73f43,0x00002a0ec5b683e4,0x000b38a0fb615a0b,0x0001b1e55bb87991,0x0003094173f71955,0x000d3c0ba8f16419,0x0000000000000001}},
    {{0x000ed0fcb63247bd,0x000c61e26950f920,0x0008ac76960a5916,0x00049cfc2ae5b02a,0x0008cda5eb1a5171,0x000118595b5c8f4a,0x000c88e0004518e9,0x00089dcbce699e0c,0x000dca7cdb0b0583,0x0009678f7a0d455e,0x0000000000000001}, {0x0003e3080d452c74,0x00067cd9ebc5ab77,0x00092748ad132f85,0x0000eb812f890896,0x0009083d0c649d6e,0x000d13cd26dc1732,0x000539d6815ffdae,0x0007727168b4775e,0x000ad256509166ff,0x0001747a36c1d3bf,0x0000000000000001}},
    {{0x000e6e936a559258,0x000787f262712646,0x0007ee8f55296d6c,0x000b44326540e78b,0x000ef2fb8850453e,0x000e4739b6073a9c,0x00032c19bbfb39a0,0x0005bec805ba5b65,0x000b74df44331c49,0x0009d3002e8ec8ed,0x0000000000000001}, {0x000d7ba6c48685b3,0x00073d4bae18cecb,0x000a9e818b43a66d,0x000e109d5a439da7,0x00084e2bd60c3422,0x00082785ad715748,0x0009a5bf6bd330b4,0x00066c8383da8c0c,0x0009a00bf0007cc5,0x000256a489783e2a,0x0000000000000001}},
    {{0x0004a8e407a2ccd9,0x00086ad221fba29d,0x000fddda1e9d46ad,0x0008643114fcb5bf,0x0005a60db0e24f96,0x000659be98b0468c,0x0000c785c91bca8a,0x000b1e072204cabd,0x000ebbe04d9453df,0x0007688aef77cf50,0x0000000000000000}, {0x000b62e349b426c5,0x0004467872d194b8,0x000ddbd4e1c43334,0x00024117aad0f260,0x000ea7d8cfb9c423,0x00083e18f4bd6c92,0x0008dd5687682258,0x000359ac483a7289,0x000ec708225923bd,0x00062148de2e57ff,0x0000000000000000}},
    {{0x0004d07f78796d38,0x000a0307a33d42f6,0x0008948a2a44d434,0x000f90db03ccc6f0,0x000696ff7592ebb8,0x0007ff2ae969af49,0x00014fcec7fca3c8,0x0000d6cec6f56874,0x0009ae9c6b325541,0x0003ea961c98239a,0x0000000000000001}, {0x00084bbf91f7e4e9,0x0009ac472d023742,0x000d63ca5a686ea8,0x000614346cd552ac,0x000072fb24ab8e61,0x00080d3677dc07d1,0x000c8c0d1833f7c8,0x000717c50635d225,0x000f8a2192bf84ae,0x00027f2e83c678c1,0x0000000000000001}},
    {{0x0007ea965c0d1be3,0x000dffe0762dd1bf,0x000d60aa7917e003,0x0002fc7262c54da8,0x0004421eaa7edfa9,0x0002c86ea7ff6dc2,0x000473729f82d5e6,0x000d535c6df46821,0x0004bda6bb69bc00,0x000b33f34e260149,0x0000000000000001}, {0x00096ecec3563dba,0x0004fd12da169210,0x0002f945903cc5db,0x00014cb4c4f95586,0x0007af70f6fbb150,0x000a6967e23d80e4,0x0003ebeadb489f20,0x0006a009490665a1,0x000afaa96a28958e,0x000a31da82221f9f,0x0000000000000001}},
    {{0x000b5dfd8f4cc713,0x0009de59f2c453ba,0x0000c9b2cc1e3fa6,0x00033c17b6318b0b,0x000e92d5d399a56b,0x00008f8a6f6dc3c1,0x000b7f39e28633ff,0x000ff1fbcd4351ff,0x000013e8c77388ee,0x00066a953e5ebf9d,0x0000000000000001}, {0x000bfd2f419a3879,0x0001d195e5a481bd,0x0001ef3e1ae017a3,0x0008b706b5b37267,0x0003f748e8ba9898,0x000e9de7d3391698,0x0007cde6e3e3c930,0x0009ee4ca324e7e3,0x000b6a772ae3cdd9,0x0004235fda48d82f,0x0000000000000001}},
},
{   /* digit=51 [{1,2,3,..,}]*([2^204]*G)  */
    {{0x000ce56e11c7765f,0x000fe4cfdef6377d,0x00035b399363df3d,0x000ca630a715e9e9,0x000a21011f820ffa,0x00022d3bc633f64d,0x000dab0c59875522,0x000dc95736a8523a,0x0008fef5b787c715,0x00032a66393c6305,0x0000000000000000}, {0x00034ecf897f6f48,0x000d40891f4ace54,0x00051c5f6bf7708a,0x0007ca62fe89ee25,0x000eae6011a07c37,0x000028c949d24cd2,0x000ab99c094a1a4d,0x00031fed19d9cf84,0x00051c154036f7f0,0x0003d437b50c3205,0x0000000000000001}},
    {{0x00036aa0bf5fef4c,0x000b4bb069d26c89,0x0002e3dd1d0d3718,0x000bf3daeaaab400,0x00076315a34c426e,0x000eb5f38604c676,0x000805197e2eb1b1,0x00037226db1abc31,0x0009ad73df5e17eb,0x000d3797d098f510,0x0000000000000000}, {0x00082cf0882acea0,0x00006b48806f5a59,0x000abd275055f094,0x00049a504db94328,0x000ec38e43c40b3c,0x00082b99e608d386,0x000cf443b07fe475,0x000b7186cac29089,0x000d982cfac474a1,0x0009aa7b0368d422,0x0000000000000000}},
    {{0x0006f1287e600c1a,0x000cffcc5624ecb0,0x0002d1ca07fb78a4,0x000a1f9666cc7bc9,0x0008539fb634b6eb,0x000c73e361397798,0x00014a496c8d68c2,0x000d7ca4181be620,0x00069a299a451732,0x0001c06004061fe8,0x0000000000000000}, {0x00029e4b308242d0,0x000a13eeecee128a,0x000f659548ea451c,0x000490cf14707b99,0x000362f80a26ba79,0x000292eee64971fe,0x000871b89c8fc38f,0x000d6dc0d122e55c,0x000979f11919fbb1,0x000f85c98fe350a4,0x0000000000000000}},
    {{0x0006cb60e51b31a9,0x0009c2f6d82cb3ba,0x000f86e04fd98949,0x00087bb6cb66fb0c,0x000cb7e6257cf354,0x000caa5a38dbe642,0x0007ff70132dd977,0x000a9fe7cec8cf0c,0x000f2a9f98b24a15,0x000c7552eb7ce954,0x0000000000000000}, {0x000aec9e842f8ae5,0x00096d766fc55447,0x00099065768ced0e,0x000adad9493166bd,0x000c328be045e2b9,0x000e70d305222a08,0x000ec1d4f554727a,0x0002fed1873d61d8,0x0001c46d541e23d8,0x00042ef348b3f19f,0x0000000000000001}},
    {{0x000ccf976377d19f,0x000f1cf68ff2fc1a,0x000d98b274ba0faf,0x000788c074f0bd37,0x000a798f5cd04250,0x0003cafaaeab508b,0x0009fd1e881c2856,0x000dd63706ee8361,0x0001b79794f0ad14,0x0006f33d5c0505bc,0x0000000000000000}, {0x000090b50612a9e3,0x0003e3a662f706ea,0x000cdebf25eed8bb,0x000d3a7d888eb094,0x000fdc87a6c4d17f,0x000574531e25001b,0x0007e6d823c00762,0x00014c6a486f9d98,0x0006d2d6573a4d0f,0x00074c191e9a8851,0x0000000000000000}},
    {{0x000d58220482e6f9,0x000c77488e8bdb82,0x000ba1084c7aabd7,0x000ae76567c7272c,0x00079ab82a151ca6,0x000826c75c1ca84a,0x000434806316ad0a,0x00040dd7f329f3c6,0x00033bd2dde3d6a0,0x000c43689c3e453f,0x0000000000000001}, {0x00061be6ee98af37,0x000291b8361cc48c,0x000b8a7b622624c3,0x0000547d4c3e4e24,0x000c937a21d5f3c1,0x00007a153ffa09bf,0x000a63d54fa325a4,0x00048d13bea75c7f,0x000e1e55bfb7c45a,0x00055a1a8b85312f,0x0000000000000000}},
    {{0x000094bb55dffec6,0x000b1ee483a0b1a7,0x000e63531718eed4,0x0009354c0be15b59,0x00029a3b937fed84,0x000295e4506353d0,0x000205f7b6d68fbd,0x000e59b3375fdbda,0x000b4aaddd0cb573,0x000348c879da0f51,0x0000000000000000}, {0x000afd066ea2106e,0x000ee293d8c45af2,0x000bc67374a1f66a,0x00016d7c0fd1fd2b,0x0002493231dcd541,0x00019502a277efda,0x0003c7872e2fab64,0x000a95c3d06567be,0x000fa48d7ff41d2a,0x0001cc69c52d2e6d,0x0000000000000000}},
    {{0x00046d25ca0b12ed,0x0003e7af11f36102,0x000d246f5c00ca56,0x0005f2713dbda22c,0x000571517fe92c1f,0x000e558aff5b82f3,0x000852ec7e4811aa,0x000a0a7d7a0cfe93,0x0009a571e80c69ef,0x000d5ecf0c8dc85a,0x0000000000000000}, {0x000629e0362ea61b,0x00019570463933fa,0x0004d8bdb2997e91,0x0008d16c1670ff63,0x00042ac0e352c375,0x000bf5c218c31489,0x0009269789d4077e,0x000eedd9111468df,0x0009e59bdc949bb1,0x000694a97ced001c,0x0000000000000000}},
},
{   /* digit=52 [{1,2,3,..,}]*([2^208]*G)  */
    {{0x0000e658f63653aa,0x000362a4e263b15e,0x000f1a72f5cb787e,0x0008dd85ade21c8a,0x0009351d6c477346,0x000ea4254fd69f8f,0x000c982ae15e0af4,0x0005dd836935db86,0x00023278398d3a2d,0x00082c5ffb0769dc,0x0000000000000000}, {0x0002ae6ecd27779d,0x000456043db3d94c,0x00073642e7c09230,0x000692df6f9dd795,0x000422cd985762a8,0x0006ac0a49a83e72,0x00059cfa2e9e20f1,0x0000d0093708d3fe,0x000c84d0b10a4692,0x00035fa5bda12a10,0x0000000000000000}},
    {{0x0009924edfb9aeab,0x00028a46d2968a10,0x000fe84ed7a9147a,0x000478aa49744c91,0x00030fd88965188e,0x000dc8d99e65a34f,0x00006f221fd955c8,0x00027ea7cd997402,0x000f83ab9dedce89,0x0006e8a7c26d23d4,0x0000000000000000}, {0x000728e182c8cb8b,0x00078b0fa5f32091,0x000760a4e2a3ad9d,0x0002b50f65aca369,0x0003d46ee027e681,0x0005a7e2b8db993f,0x00003752acac076e,0x0003a179054a6029,0x0007bff0fddbfa0d,0x0008feee0dfeeff8,0x0000000000000001}},
    {{0x000e1e66266af2df,0x0002e36c081c96d8,0x0002c3c896d714ef,0x0002acfe977ac59e,0x0001a95d1b3f90be,0x00003c79555da335,0x000ac68d1f4138b3,0x000d2dc5e8301aff,0x0007f5144ad06837,0x0000d0ff81349a59,0x0000000000000001}, {0x0003ebad0af48caf,0x0005e5d9aadd9976,0x00026bfaeb96c7e8,0x000c9ceb03564b50,0x000254586ab1371e,0x00038a2ddf7b0228,0x000ca35a77209961,0x0003fd9f60e7f5a6,0x000f0eb7073273c4,0x000a1bce76f5e62d,0x0000000000000001}},
    {{0x000a60a63bd16196,0x00077f090aae19bd,0x000e7638c32cb3f5,0x0002a6ddf59abf93,0x0001d3548613634b,0x0001b5e6513c50db,0x000b5bd49476ec89,0x000a83b636d2f4bb,0x000071e3a3dd95f7,0x000ef977c02f69d5,0x0000000000000000}, {0x0008603799531d83,0x000ec49c9ad3cfc6,0x0004e50cb9635f1e,0x0003ca9d26b39588,0x0006f3bd6a0e5d70,0x0008ef03a93fe903,0x000aad2605b0ecc0,0x000b6abd3a9b070f,0x000a81977f3494ea,0x000831164f95f67f,0x0000000000000001}},
    {{0x000d576c129bba19,0x000dc781b1958f67,0x0004c725830444b8,0x000d772989a02957,0x0003160191e1f14a,0x000b3aba62ef31af,0x000a9c026782cae3,0x0005e2df9de1d797,0x0007d5d393897669,0x000e09de2e3f7f60,0x0000000000000001}, {0x0002f590d9230f6d,0x0008e59ce71ff8f2,0x00065bfab0b97ecb,0x0005b773840ae894,0x0005df550efa55da,0x000a03525e361e4f,0x00032a275d9fd4c6,0x000f30d16226c4bb,0x000512eb88ebc1cc,0x000a048dd37790a6,0x0000000000000000}},
    {{0x0005c82e7c82fe0b,0x000b6b153f48688a,0x00079cad28ce32c1,0x0004dd65d7330f19,0x0005fd6ce0841643,0x0004ad25ddac7886,0x0007705833e0df48,0x0008294753bb4502,0x000ad8dbbbf63937,0x00019b436c10a463,0x0000000000000001}, {0x0005b7516a304d40,0x0008185865f25816,0x000cfc1c163a4965,0x000ed7eed35d77f6,0x0002d2246fce8e80,0x00064fa59660ff02,0x000081304ce77dc8,0x000c6fc813dd85ee,0x000db13057fabb84,0x0008d66a509ef64a,0x0000000000000000}},
    {{0x000ae85bb3c1e90e,0x0001923787b4a031,0x0009e575e9892a6e,0x00074c2ebb769eea,0x00063064d9df4bf8,0x000e1bf584f54d2f,0x0007ecc49f863e83,0x0003213fe023848a,0x000c07e3d527042f,0x000c51626ab6da53,0x0000000000000000}, {0x000783a377f5ac26,0x00010cfafa402a74,0x000f762b70abfb39,0x000eac42e208b3a1,0x000497274db0b567,0x000b54ede1f18ddf,0x0001de4808fda6ea,0x0002ceac81237a87,0x0007edd6e7428e9d,0x0000cb9fb5801abb,0x0000000000000001}},
    {{0x000205d81676b493,0x0001cfe8f546e257,0x00087afe8b644287,0x000676bad5e346c5,0x000f4a964afa3748,0x0001422f71ca39ba,0x000328b0e9e0a58e,0x0001d31cca18d62c,0x000787f6507714d7,0x0009ad810168e375,0x0000000000000001}, {0x00030f78aa1440c8,0x000f7e509d6354b7,0x000beae80e0ec14f,0x000f7cc09793053f,0x00025b6b1fd1b019,0x0004558d48e4fca0,0x0002aae7ed4a0374,0x00070e2db1c48699,0x0007f4b02f033375,0x000af43011764955,0x0000000000000001}},
},
{   /* digit=53 [{1,2,3,..,}]*([2^212]*G)  */
    {{0x00015e37a2d438c7,0x0006bb436c808cd7,0x000782325918615d,0x000d68ce58c6e6b2,0x00075a40e8f75ca6,0x00001da381c4c378,0x00055d9be962879c,0x00075dd3d4cf58a1,0x00099fd85847d5de,0x000e158f7f76b4ee,0x0000000000000000}, {0x000c9f66a4cec18d,0x0006e45302a76bd4,0x0001b679cdf64708,0x0002c24293b84a7e,0x000a092243bc4d41,0x0005c3c375519ccb,0x000d06b585371f2d,0x000590f4c0f28ba3,0x00073b4091daa768,0x00073c6342e78bf5,0x0000000000000001}},
    {{0x000dcb7fa9fca3c3,0x00047144679a2a9d,0x0003be369b38069c,0x000a82620de84dbc,0x00098d5e1f28d82c,0x000205de8989e877,0x000abac84051f10a,0x000ac26a5b9c5c22,0x00074ecbb99bba5f,0x000253359fa6c2dd,0x0000000000000001}, {0x0002ac09a82c210a,0x000b422ac08c572e,0x000c5c720e071535,0x00095966a7bd1c3d,0x0003a0a4b0c9e18f,0x000faa6c6449a62e,0x000bdd44f85595c2,0x00047bb9f75f529c,0x000f46a6493955cf,0x000622defa5af650,0x0000000000000001}},
    {{0x0006df335e8acd01,0x0009b6996f91a727,0x0008be8a5f6bba5b,0x0006ef24a13311be,0x000b7fe2a95d51f2,0x00084a38b4ee11ba,0x000caf93233a4f76,0x00073771e4762ff2,0x00024adb050176c1,0x000a9e7e6a96ea5e,0x0000000000000000}, {0x000540fbecee1541,0x0003f39f444fded1,0x0006ce01534c5cef,0x000a886125f5b460,0x000b437e2199b1d8,0x000a994fb5a77157,0x000fcae599e6b65e,0x0002599cf24da91d,0x0009f0d7248964c9,0x0007ac171d21915d,0x0000000000000000}},
    {{0x000ca4b8955dde0b,0x000f850c9b5cc251,0x000b99572d6cb500,0x000f8952b82356c8,0x00088575ebe209ee,0x00089253a4607df2,0x000ff9ba421a6b33,0x000799f0eb4dd513,0x0003ed789c84b56b,0x000293e6a5c4d425,0x0000000000000001}, {0x000ff217c0f18530,0x0008986930ae0198,0x00012fd1e778abc5,0x000f509594fad4d8,0x000656733dccef2f,0x0006afad83f10fab,0x00078f717d75c593,0x00018a1a313cd995,0x000cd73871602741,0x000f5446078ec40b,0x0000000000000001}},
    {{0x00034871165b0407,0x00041aa1bdd6d509,0x000fcc9e894c7b1e,0x000369e1389494fd,0x00087f5116c5472d,0x0000a1b0d04b3663,0x0000b4c49058303b,0x0002bdbdc1d8cd26,0x000ae8f01c121d9d,0x000dc1d8c7270b76,0x0000000000000001}, {0x000d922f0e06b7cb,0x000f07bd16843c5d,0x000c01dd32245ab8,0x000fa9f6081477df,0x000c2db624f56ea9,0x000b2fb3e2bccdb5,0x000cb3b768793cb3,0x000c8d894f04384c,0x00010a3af20b15d0,0x00045ab5af8411db,0x0000000000000000}},
    {{0x0006b9ed8590e4a5,0x0008a58a2974d283,0x0001c7668bc64c35,0x000acc81cd837cfc,0x000fc7b9eb02f729,0x000fee9d6ad1171e,0x000a8d7ca7eeb433,0x000a79ea2e79ed5e,0x0001fb8522e38381,0x000cc8162a76e7a5,0x0000000000000001}, {0x000c67543c98a4ea,0x0001f713941c4de6,0x00081dc75d38a3eb,0x000374ce9c459cdd,0x000bdd7ff2d1d555,0x0000d7b03a560a54,0x000ad6193d7f976c,0x000099ff27e977d0,0x000749edcba5d394,0x0002c6804ed826ed,0x0000000000000000}},
    {{0x0003e3bd3291cd15,0x0006a26271a72635,0x0001ef4581082f50,0x000cb6109637a812,0x00043e376f158b63,0x000e1fb8b4f92150,0x000fd4238523b166,0x000edb09ffe09019,0x000a7d8e27b82fb2,0x0001989a4df94f9f,0x0000000000000000}, {0x000410feb007ca74,0x000ed314198cb45e,0x000e234a35b4b72c,0x000c1779579fdfb5,0x000da54f63558ebf,0x000b68211f279305,0x000b7f7a88ea265f,0x0000914728cae4ca,0x0002ed65205137c3,0x00045ed6df45a086,0x0000000000000000}},
    {{0x0001cfb71cb23bf8,0x00067b25479ac001,0x0002f48bcdb785ff,0x000da267c454fd25,0x000154e460f65f62,0x0006fa21e0ac759a,0x000770bdb56d239e,0x000db91d7ccefa07,0x000f07f46fe275a8,0x000527a152927368,0x0000000000000001}, {0x000969a0d74d64a1,0x00059c36f066b2d7,0x0003a664061d81a7,0x0008c41d929c3e1c,0x000a4033ad63b5ba,0x000387b665fdb5a8,0x0002e2c2b433c84f,0x000e4f2d4d931e74,0x000631141b030d2d,0x00086de3845c248d,0x0000000000000000}},
},
{   /* digit=54 [{1,2,3,..,}]*([2^216]*G)  */
    {{0x0000c039d020c1dd,0x000d44ab7b690765,0x00026b42700b4f64,0x0002c1e20576d051,0x0009e70d2ad712c7,0x00015f46314322ae,0x000dfb189904b573,0x000124905a45ef02,0x00026cce68a7b470,0x0004ac5f0db2cade,0x0000000000000000}, {0x00042cd205524778,0x0000d86fcfeb993a,0x0001cc7f2d2ee992,0x000c209546bdb299,0x000531516a6eab71,0x0005f1492f99e62c,0x0002cf5197ae7709,0x0002013e12e8e95c,0x000b78cb72aad7be,0x0000320e70b96760,0x0000000000000000}},
    {{0x00011fae297851e8,0x0004f69afd113575,0x000ab322fa242843,0x000f361ecbe5e3de,0x000b7c1b08880d89,0x000a50aa80c1fbd2,0x000104d9e40537e6,0x000ed4f51df57fdf,0x0008a6cfbe707164,0x000f36d887e3d0b7,0x0000000000000000}, {0x000365e7f9a5983b,0x0003c6129d87d996,0x0002952186a64aad,0x00009284f8224d3c,0x0007bc689c1d4452,0x0003f44aec2c194d,0x00057e00e7c6b2d0,0x000de28c9eb3f18a,0x0008b7de6fac4981,0x000009552159064b,0x0000000000000001}},
    {{0x000147285c5f1e84,0x00054bbe273f4c79,0x000ec66bd4d71c06,0x000771b4dd0505e9,0x0002d4c891619ed4,0x00021a0542316ff1,0x000ffae0c65ede48,0x000db678c0c5a23c,0x000bbf48abf05e02,0x00032691ff4f9e32,0x0000000000000000}, {0x0004ec586f495f39,0x0007665c351b2d94,0x0003939c0c800e74,0x0000a9b2fe310474,0x000c05e63ba55b78,0x00011119c911cfce,0x0000043322972c9c,0x000235f5ba3b0c8e,0x0002b78daa0946bc,0x000a82622257dc22,0x0000000000000001}},
    {{0x00053147b3b22c3b,0x00004897a83e73cf,0x000d11d0f510fba4,0x000de4abfcf9128e,0x00047095c92d56df,0x000f3cd334bcfa2a,0x0000038a5b6f4d4f,0x00095df73169a249,0x000aba80e663bcbc,0x000c64a47769e841,0x0000000000000001}, {0x00004365a62c4cf6,0x000531a582938f21,0x00043321e6dc439a,0x00061253f7387146,0x0008352424fe3ee8,0x000a676302135902,0x000702fe71ab2ae0,0x0005f460396ca837,0x000882e04f7bce51,0x000f93d936239901,0x0000000000000001}},
    {{0x000dc17de84a8cec,0x0000802c374c6c6c,0x000bd6a5b20e3454,0x00046c40337b0f58,0x0003431d7aff9402,0x0001dba6a849292d,0x000f90b37486a260,0x000c12d61cbe41a0,0x00033f828782067d,0x000486ebc39fcd30,0x0000000000000001}, {0x0006818da93cb68a,0x00039ef42673be02,0x00040e906d3f2e27,0x0000e1f1d8ecf6f0,0x000655c024d3837b,0x000417cf596708c0,0x0000946c57882083,0x00058942a1031702,0x0009752bc7086a40,0x000474bd8d65b027,0x0000000000000001}},
    {{0x00057bccc2137aff,0x0003cdce9d3ef437,0x000021aa7d7b10a8,0x00014071804bf03e,0x0005009822fa479a,0x000c4d2fe91adecf,0x000bad18fc3b061e,0x0002ffe82ea4479f,0x000b0bed7b70c576,0x000d5c8a667da425,0x0000000000000001}, {0x00036c22b574750b,0x0001a79beeade4d8,0x000d7c41634d28e0,0x00030d7e124715f6,0x000b28e33c4f983d,0x000442a0682ee2bd,0x0000a48a18cfc1f5,0x0009a6cb16376839,0x000ecc58844abd78,0x000383bd6682cba8,0x0000000000000001}},
    {{0x000c36944a224339,0x0002221a86a3568f,0x000a933230388a55,0x0002ca0cfc1f186c,0x000051f24d4d5f8c,0x00053ac024a82a69,0x000e4e0b6761f2a7,0x0006b4a03fa98a0f,0x000862d5fd1d2058,0x0006922bcb9949cb,0x0000000000000001}, {0x00085574f50da47c,0x000f8cb1192295a2,0x0002436f1d423eb5,0x000f6ae23f4febd2,0x000640f1f266f842,0x000e94d3498091b2,0x00016f1f4561f25e,0x000c6e303b526f4a,0x000bbc14e80ed7ff,0x0009ac6f957c1908,0x0000000000000001}},
    {{0x00089a398d206da8,0x000e6a92326c61c3,0x0000b658149c80b1,0x000f4f6423067f4a,0x00022c96735aed5c,0x0003cb53c31cf4dd,0x000c7214b478ba14,0x000d3b1bbb1eb353,0x0005aa79b46f2e84,0x0007d44a4fa3d67b,0x0000000000000000}, {0x000d31f07cf711e2,0x00031e5402e45d5a,0x0005565057819f0b,0x00050ebe214cdf81,0x000e63efd8e063fd,0x000c82d63ad808de,0x000d0ee39ccec300,0x00085249be7d39df,0x000e9271ab6c788e,0x000a727ffa3cadeb,0x0000000000000001}},
},
{   /* digit=55 [{1,2,3,..,}]*([2^220]*G)  */
    {{0x00061361be3ee97b,0x0006e1f3125658fd,0x00096b636a1d69b6,0x000b9e470c7ac9e9,0x0005bf9bb3617e69,0x0002050a8c1b1e89,0x0002213fa5a11a51,0x000bc2919affa249,0x000be1b1008d55c3,0x0003926dcf2c08c4,0x0000000000000001}, {0x000fb57fda93efc6,0x0008276ce4aac2b4,0x0009277cab16292f,0x000e677dc90518a9,0x000ab0432d015144,0x0005d9214eea4408,0x000b8a649b20eb23,0x000b48a45d8a2560,0x000cf7d1d37dd269,0x00049d71a47616ce,0x0000000000000001}},
    {{0x00034d86d189072b,0x0000b9475ac257a7,0x0003a9d12f132433,0x000adf08cecaa5dc,0x000dc33641cc3048,0x00040352a6bfcc4f,0x000dac876f01bade,0x00035bd7dfb06e93,0x0001d4494c0e1ca5,0x000219b51965b8b2,0x0000000000000001}, {0x000f90e9be7f6998,0x00040776cb857a46,0x00031907caf1b517,0x0007040038843e17,0x00014b3c14ab5377,0x0008c99d12b47cfe,0x0001590d18daa185,0x000f84db2817d455,0x0008544bbc4d8f7e,0x000ee1752b595c5a,0x0000000000000001}},
    {{0x000718c9c3382876,0x000798d016412ea8,0x000c7059eeb3d459,0x000e910707afd251,0x000366ae603f57f6,0x000f1d424b7c29b3,0x000f4591f08b6d11,0x0004fa0b188406f8,0x000a09ce46dfa46f,0x000f3e1ee6193a22,0x0000000000000001}, {0x000ef37aacfd9628,0x00044abc282a7b59,0x00016eca5fb04908,0x0002a4a0fa414af6,0x00010748c915edd4,0x0003d4af5a6f1ab8,0x000aff331ef86bba,0x0006d8ffc35ce768,0x000278d36b6c4e53,0x0006238f61ddd56e,0x0000000000000000}},
    {{0x0008204ec1fe994f,0x000a401febacf810,0x000a1fbe66e0a0c3,0x000654b72570b727,0x0007b5299d8ae343,0x00058b323a83e064,0x00034d13d86ee0d1,0x000be946224b7585,0x000a38321cb77d0e,0x000ea9b845ec39e9,0x0000000000000000}, {0x00021327ccd07b3e,0x000b9c13edfc5044,0x000efee69b80c4b9,0x000b9736ce07a452,0x000de2779de28110,0x0009cb506b810433,0x00009831468d2371,0x000fb54615eed293,0x000a72f30895d360,0x0000822a939f9fa6,0x0000000000000000}},
    {{0x0003613a0bad2c78,0x000a2841479bab61,0x000ae853dfe64b3b,0x000c5d69d7d5f8f3,0x000913c023c98edd,0x000e51c064c2af1c,0x000caf23e811beb5,0x000a297f73a13e28,0x0002c2db1b2c63f7,0x000869272783c6e9,0x0000000000000000}, {0x0009e33e7c2b0e8b,0x000a6e2930859a4d,0x00021c82319f96d2,0x00062855234b3a37,0x000cfe1e952c7999,0x0009fff526834c3f,0x00082932d66290aa,0x000ed0618b6fc1aa,0x000f51b1765d795b,0x0000fa7ad3a784d8,0x0000000000000001}},
    {{0x000b99ec5345605e,0x000d705b03ab3b6f,0x000d514df02df673,0x000d979497926d51,0x000327f3cad9968b,0x00007b8edfa7bbd7,0x000fc5c1dee65278,0x00036db8f1709072,0x000d430f38a088d0,0x000f9df3373c9bfa,0x0000000000000001}, {0x0002932b26523f7a,0x000a4698ce826d56,0x000d64992b915d43,0x000f137e0e1471fe,0x0006811a1c25612c,0x0007e5e74619907c,0x0000f455dcff6a59,0x0006fe503afcb4d1,0x000af47382daf8e9,0x00085e51a1e9e2bf,0x0000000000000001}},
    {{0x000c899ed52c7ebf,0x000805309ddc9f57,0x000f9ec0561000b8,0x0005599061be65ad,0x000c7c6ac2e8bdb7,0x000546a9f7f8f392,0x000b38f709f90fbc,0x0005b81ee256aa4e,0x0000cd9ffe3bb73d,0x000ad1e54f791392,0x0000000000000000}, {0x000e432eaecfeb4f,0x000efd7d99d4376f,0x000ecbf257042314,0x0006524d0d11bf19,0x00070c070e8811a2,0x0009bb46ac80db71,0x0005deced6976256,0x0001f5d4f1996e7f,0x000c6d1bc35c855b,0x000b7fcfaf131b63,0x0000000000000001}},
    {{0x0007faf89dff5e6d,0x000701e289504c4c,0x000c21c143d7c67c,0x000b8b1051104808,0x0001a8547ea3f429,0x00042d1597643f8b,0x000c20d8e30463a4,0x00019700b9ca1322,0x000c7c74112313e3,0x00021d429e582d53,0x0000000000000001}, {0x000df174dc25e320,0x000421f30a9c65a6,0x000cca7bd70734a8,0x000970e912f441c1,0x000b0da35c85642e,0x000fbc6108990f29,0x00004f9201a5ca87,0x0000b4ba5b8a0067,0x00032f15dd79c420,0x0001dcaa2c572053,0x0000000000000001}},
},
{   /* digit=56 [{1,2,3,..,}]*([2^224]*G)  */
    {{0x0009f88e8ef42daf,0x000fa3828b99d9e1,0x00051fa512ec2bee,0x0004d684d33e3c3c,0x000ae34a6c37abe1,0x0009d4bea55b5936,0x000e6492802583c8,0x000098da605bd938,0x000288cfc1f04542,0x000ed0659c47e455,0x0000000000000001}, {0x000ddaea5046a68e,0x0003e422472a49b9,0x000c2da95690aefe,0x000dcef36e21cee3,0x000eab14f0abf0c7,0x00064941e198c3c9,0x000fcf64819eee0b,0x000dbfe77fa8433c,0x000c3b28a2f7686d,0x0009c3dbfd233403,0x0000000000000001}},
    {{0x000b7107c522fbbd,0x000c42e8887082c3,0x000cd304c29d218c,0x0004d8477a96d44b,0x000ecee7f483ff1c,0x000951d19c530d4b,0x000d68d4d6bf1fdc,0x000fe03d009b71d2,0x0005537694d3bd1d,0x0003c3db4cb1a2c4,0x0000000000000000}, {0x00086f0e3fa15f33,0x000388caf5fb4c5e,0x000b2f14ba7715c3,0x0002610381191db4,0x000e0f68a08e3384,0x000342059cb75d25,0x0002bd292f767fcd,0x000a7a696b414dec,0x000dfb67016057d6,0x00035999c277b18a,0x0000000000000000}},
    {{0x0008ba73e1f475e0,0x000dd3f1b783f77c,0x0007375b491b116c,0x0007d166e4a377a6,0x00011bc5434f7131,0x000a2dbe9d40b215,0x0001220856a6b5e6,0x0007b890e757f7e0,0x000f02578a944660,0x0004883ff77008f5,0x0000000000000001}, {0x000a3e2632a212b7,0x000302b8f038a3d8,0x000a306506181a49,0x000301702b3192c1,0x0002c30f8e6d2d73,0x0002a0c5b0c340d2,0x000f8bfe6e8c90fd,0x000e8d703d0478e5,0x0005135b5979aaf2,0x00034da81fa7add8,0x0000000000000001}},
    {{0x000f16b10733860a,0x00007e088e20bfd6,0x000859fdd39b30d0,0x00096072d4c40b6e,0x0007d0a59d2a4c91,0x000f5b531a3c4f60,0x00005885c546c30a,0x000ddc1d5df2fdc4,0x00026f4df2971b1a,0x000bb67cb15104fb,0x0000000000000001}, {0x000f74646d17eec9,0x000e3de3bee8f39f,0x000560fc63e96143,0x000d7aab2e0395d9,0x0003f099cc808fd9,0x000e3c3dca422f15,0x0002c61efabb0d74,0x0008d736943aed2c,0x000d74e4178f87c1,0x0003d1b76afadf96,0x0000000000000000}},
    {{0x0009583eea912fe1,0x0006a5587f3b9010,0x0002a020829ea8e9,0x000b82ec346b73a8,0x0001f44eda406972,0x00067b4504fbb553,0x000e7a6189bcd268,0x00039bdb40c39e05,0x0005c436a03e5e06,0x0007019eedb498d3,0x0000000000000000}, {0x000662e3f77764f2,0x000cda79a7c8507e,0x00040c75e0594299,0x000bed938a93a1fb,0x000829d1bab3f2df,0x000df99ce48d52d8,0x00032fb8c4092f5f,0x000036b5fa768aef,0x000201a9ee7997be,0x000ca0344038e8d5,0x0000000000000000}},
    {{0x0004ae17c6c4ef83,0x000409ab5b4b2b20,0x000c4c863d0780e0,0x0003a003f73d00d9,0x000f7d17b97edd24,0x000335ec2eca6e6e,0x0007def3f246d97d,0x000f0e2518ced6c0,0x000f728fdb8b0595,0x0006dcc1ccb10bfd,0x0000000000000001}, {0x0009f012dd02f504,0x0009d50a767d8e86,0x0001bbb0510be6fa,0x000cdab7deeebbfe,0x000f08332cdf98f4,0x000468782175d651,0x000610add0fc83f5,0x0004965277afa428,0x000ff5c3438635dc,0x0001fc0961df5b9d,0x0000000000000001}},
    {{0x00069bd3ef1fabd9,0x00064fe7b00b747c,0x000195c6097cd6a8,0x000470709e13f896,0x0002cf79709fe958,0x000b72450de744f3,0x000df3f80fb1524e,0x000527ea0bf24b8d,0x0001b2774e7c3f06,0x00031ad38e7aad24,0x0000000000000001}, {0x000b784c1f4489c7,0x000f2a889f589505,0x000a5a3175ee6df1,0x00047a68c157fe56,0x000497f7b784bd67,0x0005ed8ff0792025,0x0001528aca7e0427,0x000d473d7c41594f,0x000cb017e35b5669,0x000f1ce78bb2a52b,0x0000000000000000}},
    {{0x000290556eb6cb2d,0x0005feea12a072e4,0x000d082bac976238,0x0007c4331be16424,0x00021f06c7a59869,0x000de72b68a812dd,0x000652502f900697,0x000d9acaec02a2e5,0x0009120c4a89c7ef,0x000a1bdf713a324f,0x0000000000000001}, {0x00067220e1027a34,0x000cabc964145333,0x00029a9fac99b048,0x0001c2850e9e757a,0x00057de9cc170cb2,0x000d017c03bef969,0x0008cbf0f3534a37,0x00085a627fd6a9c1,0x000c29da8ed78ac5,0x000ae4ef092acab9,0x0000000000000001}},
},
{   /* digit=57 [{1,2,3,..,}]*([2^228]*G)  */
    {{0x00060edf11bb374f,0x00007883a0baf3f0,0x000eb8cb2a326de7,0x00095554f5a8d631,0x000236ba14fb5cfa,0x00053769e29d950c,0x00043eac3b6e6d4c,0x000400e396b6857d,0x000b3b40a28cc2c6,0x000f0142ca52de79,0x0000000000000000}, {0x000536d43744d95a,0x00080dbb696fec4e,0x00086879c7360fe9,0x0006d4736a564e15,0x0001262e7ce9d679,0x0004cced89ee75c8,0x0005fe2dd4f732cd,0x00004a4d97d2a3a7,0x000e046cc62def6c,0x000c590bfe781afc,0x0000000000000001}},
    {{0x0001e39da3d53729,0x000c68258dcf68b5,0x000b1289a021c50c,0x00028ef654112229,0x000f4c73b83c7489,0x000a0ebdbdf0df33,0x00033245f1663936,0x0006bdfac3bf0988,0x0001bcc9c21bceec,0x000bcb64a15de987,0x0000000000000001}, {0x000fb2f27cba002c,0x0002f0ce8d66f97e,0x000c4f49e106a48e,0x000720d60d05177f,0x0001b9e35427304e,0x00008c355b746f84,0x00061577b7b7cd5e,0x0008586eb9a88122,0x00003b21c38ce383,0x000aec02872c5a8c,0x0000000000000000}},
    {{0x0003ee736c032ac5,0x000efdfdb4c3d4de,0x0006ff01d94dbf41,0x000a0bb5ee1889b9,0x0009e7a8dc456a87,0x000c2bb8ca379bb9,0x0000100b2eae0668,0x000d2063b0184325,0x0006daafabf5c71a,0x000da2051e835c68,0x0000000000000001}, {0x000eaacab83acf78,0x000761a09a5ec30c,0x000838055c361c20,0x0002e34e4fa05860,0x0001b9a7a3c102c4,0x000f91746c97086b,0x000c731ba10529e6,0x000e8a7f6450292d,0x00076f3144af4061,0x00077cacdce041a7,0x0000000000000001}},
    {{0x0004b67237f032bd,0x0003fda08c68528a,0x000c719571479a5b,0x00011c75d8054fed,0x000bf503c35807c6,0x00037b9ea9e88e5d,0x000c9422b4c4521b,0x0002950eb17e75f1,0x0008eca427950847,0x000c0f845c91f923,0x0000000000000001}, {0x000c1e80ea8c1010,0x0002e1978ae396a0,0x0002c0d00f914b24,0x0004e43fb47bf7bf,0x00034b416e50ae94,0x0007c8d114906c36,0x0000ad0347f03a3e,0x0006a6eba25165b0,0x00021e9dc53a14e2,0x00076911eb83f4f5,0x0000000000000000}},
    {{0x000bb95adc5ef776,0x0008da0ab8c5f233,0x000a4ab915fb3034,0x000423a63a5dffb8,0x00063715aa2304a4,0x000018304840df01,0x00037b80028296bc,0x000854f7402fb23a,0x0006ebdeaf3e5fac,0x00005463cd3d8406,0x0000000000000000}, {0x000c9468fa481453,0x0003a0abd61a0348,0x00047c025f468b21,0x00090d7078cd984d,0x0005284e72a10788,0x000156fa2b542f64,0x0003b3c956017512,0x000991f2c57b982f,0x000989b3c05c1c45,0x0001ce6eb96dccdb,0x0000000000000001}},
    {{0x000c0c76c91a3d86,0x00001a3cab8eb5fd,0x000752ec9cff796c,0x0003f81d37bdda1a,0x000e12c746df5d95,0x00027c38d512fd50,0x0004e23ce093d983,0x0004adeb3545f200,0x0008acce0db1764a,0x0004097d3ea0eee0,0x0000000000000000}, {0x00057c8acd0df62f,0x000a235a3f7e354d,0x00043547a0eeee98,0x000831405ee1adbc,0x0006a916c043f6f0,0x000e4844ab1da766,0x0000728cc7b74a71,0x0007192544b4fdc6,0x0009d41decd4aad8,0x000497605d2bc303,0x0000000000000000}},
    {{0x000c16253894ed63,0x00072cd0f6a2350d,0x000412983f7baee8,0x00009f78d054975c,0x000d7bad42e9614f,0x0005f2ac60d67eaa,0x000622d671f099d8,0x00021f07bed1e830,0x00081424aeea7845,0x000f7592014c5f2e,0x0000000000000001}, {0x000619d3fbb4d7a6,0x000a9269d1beee9e,0x0002e4ef27debfd4,0x00069156fc40ac5c,0x000b31c86af27730,0x000f4aa3fc30b8ff,0x000bfd86f500b895,0x000c9dccb88b68a2,0x0003b7832b9f66f8,0x000853497ba1895e,0x0000000000000000}},
    {{0x0000b0ab29d3bde4,0x0009c71ea0d8e5cf,0x0004b6204df30d49,0x000d3f548f748b9e,0x0006eba95c754c4d,0x0007ad6cc9c44387,0x0009e2d08e10896d,0x000ea9428b4a544e,0x000fe71891a2d3e1,0x0006b905c7660eb6,0x0000000000000000}, {0x00066e6414125179,0x000e2877106f8fb3,0x0002d9d82f542b36,0x000b4eca63743c2e,0x000cfc887146aaf2,0x000ed669e0b28d08,0x000c885c73913714,0x000914ee1f56da28,0x000d4479d84424da,0x00015e3364622742,0x0000000000000000}},
},
{   /* digit=58 [{1,2,3,..,}]*([2^232]*G)  */
    {{0x000bd25b5edea690,0x000347c3abc5bd1f,0x00078a11d29a3138,0x000c6d62f2283223,0x0007b4af4ece3ada,0x0001c75e4372b0dc,0x0009560a7308e28f,0x000d0ea7127d9913,0x0000172da9cb3c31,0x000c36c69386a7ee,0x0000000000000000}, {0x0003be2a2cae0b56,0x0000778293313929,0x00041cdee07af8d3,0x0000895f4118b415,0x000b9b3a9502ad6d,0x00004e1d44242767,0x0001a843924f3834,0x000a3c5c40dce7a9,0x000443e9e0f30db5,0x000c5338df60b62d,0x0000000000000000}},
    {{0x000d88264070b39a,0x00060f5a265bdb95,0x000717063ef771ed,0x0004ca000dd813de,0x0005a4d348196d97,0x000def16129d2691,0x000bcbbfcdfb3523,0x00057290d6981eca,0x0000c5d2444e08c7,0x00091c65a063c65c,0x0000000000000000}, {0x0001941d0c9b7cd3,0x000cc0a5845e0e75,0x000c51c09cc90c04,0x000ce8aff11f3a2b,0x000303944ca09536,0x0005cb9d10d614a2,0x00062674cf73a00e,0x000639b5262911f3,0x000379f49e681d43,0x000ea07634bb0927,0x0000000000000000}},
    {{0x000aea3b47740815,0x000ede22e76e20e2,0x0007e03afde6eca1,0x000f70d608d1c44e,0x0000b88d585444ed,0x00074d298cd8ec39,0x0001146c4c3f6754,0x00073274110e9ce2,0x0009cf1f4b12ae7e,0x0004fa67e9f4b4ce,0x0000000000000000}, {0x0002ef9318bf7948,0x0004cb3efdaff610,0x00059bd31047a8b9,0x000fad7c4b8b1235,0x000a02488482725a,0x0003b462badd939d,0x0009f8945cb99ab4,0x000c0f6b65c66a4b,0x000e97dd0bddb4b1,0x0009d75a1f797639,0x0000000000000001}},
    {{0x0000ec0aca9d0f94,0x0002fb13ee984570,0x000e5ad047be55b4,0x00073a0845bc6993,0x000ffee41f2aee8f,0x0003c832041ac680,0x000bb4a740b12fcd,0x000521ebc1645e36,0x000dfcc7735a45c9,0x0008ef92b0fbdab8,0x0000000000000000}, {0x000805ed4e45e0eb,0x000584829d754db5,0x00036cc488a6c810,0x00060f1ec9632468,0x000c0f2ebc30d39f,0x000e960758390502,0x000f4626d1feec9d,0x0004f944bca363ad,0x000375dbfdeea282,0x00050ba887d0959c,0x0000000000000000}},
    {{0x000857ce82a61386,0x000fab480b18fa40,0x000223002b9297b0,0x000f9b41f698e6a5,0x0005eb688e33b253,0x000cc09f30bec2ad,0x000eeb6333a5ffe4,0x000bc81e94524303,0x000091b660b277fb,0x0008fd03ed404dad,0x0000000000000001}, {0x0005dd59faaf5be9,0x000abe017edd5410,0x000aaa4856720e0a,0x000d987f4b1178d8,0x000fe5e556ef405d,0x00081f659d8f4002,0x000f7836cb450ed9,0x000350d35c2f69df,0x00095c15741d4705,0x0004c982d30172da,0x0000000000000001}},
    {{0x000f854cfa0f1b9c,0x00036c27f5709e7d,0x0002fcca4c8efcec,0x000a965fa53691ad,0x000f70705ad9f4c9,0x0006ca89080d5043,0x0005cff60c807ea8,0x000ff2e47ec8fa95,0x000846288bda4094,0x00003dd7b4f68fa6,0x0000000000000000}, {0x000c953f0c60b7aa,0x000060469787d616,0x0009579f0ed52085,0x000faf3c529ad3be,0x0006f18223d47482,0x000c07ac1ad869d6,0x000437b5cb0dcd56,0x0004dc765feb592a,0x00004a294944df05,0x000184cb4ad2de82,0x0000000000000000}},
    {{0x00003d153000960d,0x0008f85dc5ffb696,0x00009b3d9302c4f3,0x000fd9668bf9ae36,0x000a25bdc3c8ecf4,0x0005c1a7bbfdb2a9,0x000393a4a4463083,0x000a4d41df85c97b,0x000d92cc6610ea8e,0x000bee7a14446540,0x0000000000000001}, {0x000fe7092ab307cd,0x00055b75f48236e0,0x0009f206af987311,0x000191b95f1aca72,0x000b01a57a7e9b13,0x000784300caa5513,0x0001b4e8ad08534f,0x000e7a92df980dd1,0x000edd78871ce4ff,0x000f2fbe3e6a8b6a,0x0000000000000000}},
    {{0x000cf8b0ae3366de,0x000c06074154422f,0x00007a17d21e5dad,0x00001e78c237ee85,0x000d108f5fd2183c,0x00098eec2dada49a,0x0001c303e35f7659,0x00091f2075445a12,0x0007426d8f5fdddb,0x0006af1dd7a92c53,0x0000000000000001}, {0x000c31da2f658936,0x000e72228504949a,0x0007646877ed3189,0x000cbac9e04fe426,0x00093f8802494ee0,0x000975ea85d9fdf7,0x00038fb0c9c6045a,0x000802b88cb118cf,0x00057e39ea12c877,0x0002548e571e0697,0x0000000000000001}},
},
{   /* digit=59 [{1,2,3,..,}]*([2^236]*G)  */
    {{0x0001f89eed993384,0x000860d77e7f7ed9,0x000e9a249862cf0f,0x00026963705ade19,0x0005d0f929eafa4b,0x000a12f7eef6f18b,0x0009d590ff1861d1,0x000d6b67d2954ef5,0x000540dd418bcbd0,0x00096e83b51e5170,0x0000000000000000}, {0x0000a67de6f33ef5,0x000d0f090cb0d50b,0x000b8b3eeba89c8f,0x00026dc5289c0d96,0x000e0e6dd7431a8a,0x0000a660c8afde18,0x000cfa02cc76374f,0x000b7654494d397b,0x000476b8fd958a15,0x00097d53a314e324,0x0000000000000000}},
    {{0x0005d2d913938d7d,0x0006d9d471ad5a92,0x00018a88bdce6ad3,0x000b90be599734aa,0x00099aa6c0fb7b20,0x000eda14b233c887,0x00024ee7dad41f1c,0x000cb7c643d13bb9,0x000e7d84ea63db6f,0x0003a846de4666cf,0x0000000000000001}, {0x000e6128e81e8c45,0x0001464a9235f4eb,0x0002db34ea2780d1,0x000ad3e8b3ecdbc0,0x000f8cdbe120731f,0x000f4318097ab5eb,0x00079ebbf1d4990d,0x0007e93c15830f8e,0x000c40a1cfba03ee,0x00068df76de664ef,0x0000000000000001}},
    {{0x000267eeb458a4eb,0x000e492a1279f17f,0x000c76f729af11c0,0x0007339e92b8f2a3,0x00014e00c8ca3543,0x000dbcc01641f96b,0x000755e449dde571,0x000a0a0df11e5fa3,0x00031770742dc646,0x0006f53610d1c65d,0x0000000000000001}, {0x000e5b808553c438,0x000499c99fe83176,0x00019eef1a061f75,0x0007deb8d4c21a60,0x00033192fdd7ecc6,0x0003250ef2ec37ce,0x000aff8f6ed93441,0x00058d1e9777ac4b,0x00083407f0d67d5c,0x00079fd1b5287171,0x0000000000000000}},
    {{0x0009d6152b9c90b3,0x000aff28f438100d,0x0000a2146e64ecd5,0x0009ad5b7e0c0df1,0x0003f6775181b0d1,0x0003c7a1b8151d7c,0x00035c338a3ef9f4,0x000e1fdd81712dd2,0x00034726a1f2597e,0x000cb3083971de47,0x0000000000000001}, {0x000c041200d9bef5,0x00067c85ff590dfa,0x0008b72aaea952b7,0x000265e7843ae9c1,0x00032307d7542004,0x0002dea503395a89,0x000e1eec7f73a8fc,0x0004b86c7eb53399,0x00021cf862926b2c,0x00019347a4f0820d,0x0000000000000001}},
    {{0x0004f7b384cd7297,0x000acc1a4787e2cb,0x000a5590739ea069,0x000be73fa99d3f7a,0x000e7cf6cca23601,0x000960cc53aa83e6,0x000b86b5920b1173,0x000fa7ac9dbe20e0,0x00068bb6f6b3ef99,0x00064060ac6c56f4,0x0000000000000001}, {0x000626c189f97eeb,0x00092eb7dd82a1dc,0x000142f8425008f8,0x0004b241705cbf37,0x000c04c8483d101a,0x0002075cfd275951,0x000f282a7dae45a8,0x000263c98e81a9d9,0x000c331b130bf290,0x000c95c5f55addef,0x0000000000000000}},
    {{0x000ac9a1c36e3c24,0x0008e09fb461cd04,0x0007bca251b2abd0,0x00098ad8fa6e8384,0x000087e953f04f5d,0x000d9f6c57ca3dcc,0x000f179679c5992f,0x000cc9cf93cdfac8,0x0000d1a320e29622,0x000580703c650a05,0x0000000000000000}, {0x000188e58d397fdc,0x00021860a160b5c1,0x000be9a3f426d729,0x000f8747311911d3,0x000b78a79eb1a864,0x0006b881dee2ff5e,0x000fc87ef83107b6,0x000ed139997a8784,0x00080e84fd894e5e,0x0003aa1a2f41979a,0x0000000000000000}},
    {{0x00031707560bd53c,0x000c9501712fc58e,0x00010e30ced00607,0x000465e677b023a2,0x00067620a31c653b,0x0008ea62e5b10af4,0x000d99048d08ca5a,0x000d65af877831dd,0x00029f5ab5be8899,0x00028321d38a082b,0x0000000000000001}, {0x0006bb42378c6e38,0x000fb8ba4bc4d5d5,0x000a4ef2e4b28b7a,0x000b41f7c314822c,0x000a2882d9a51ae9,0x000e6c2280f2b327,0x00019697ce965ab1,0x00075708dae4a49d,0x000f1175eea346d9,0x0000e9572d2fbccf,0x0000000000000000}},
    {{0x0007d4bad9839247,0x0002744af0bab5bd,0x000cd1e04b0ade61,0x00080a7fe21c3a53,0x000864b9871244ec,0x0003f6fd1428f483,0x000889d63b180bf2,0x0006acf748b0e2b4,0x000a061072996dea,0x0006607cdec9d5f3,0x0000000000000000}, {0x000a9858e242fc0a,0x0001fa2d38ce4fc2,0x00087521e69c709b,0x0005bae8f5996fd9,0x0005e131ac99f4d0,0x0002578fe3c3bad7,0x0002279c9d139206,0x0004b6fbac903ada,0x000292885696da36,0x000ddbd02ce1356c,0x0000000000000000}},
},
{   /* digit=60 [{1,2,3,..,}]*([2^240]*G)  */
    {{0x0001074e0ee1b4c2,0x0001a0ff10eeb73d,0x000c77549f2e087c,0x0006808a5e2e0837,0x000e948c7156c74d,0x000c13bf7c11f82c,0x000a51472ee287eb,0x000b28c4e6f906f6,0x0000fef0b165038c,0x0002d8b6f1c9d932,0x0000000000000001}, {0x000d310ce2cf5a19,0x000c08add6b6df57,0x000dcd4cb28cd825,0x000e1cbe48bebf85,0x00051f1d5aa6a644,0x00008ba85cbebbd3,0x0001bc84d8a2aa19,0x000d343d2d77518b,0x000a9098229b988e,0x000a9f940fc8d07e,0x0000000000000001}},
    {{0x00096ebc173a5d8b,0x0000ed54a67c958f,0x000ef67809a984cd,0x000abb728dd8453d,0x0009f4fe5f363de0,0x000e4fc4614b7360,0x000fee4aab1b83c8,0x000606d2158cb989,0x000096597fe56f7d,0x00057270734a0c52,0x0000000000000001}, {0x0004ef503a18dccd,0x0009b732b2f44d09,0x0002c29898debd6d,0x0005ffd4e0ef3ff7,0x0003830b99ae2e5d,0x000dd5fca5e1c94a,0x000e97015b084de2,0x0000e94504be6d08,0x00079eaed90fe0fe,0x00051eafa2897ddb,0x0000000000000001}},
    {{0x000dd470cee4255c,0x0008ea907208e445,0x0001157ba3e551b3,0x000f94c51b72b693,0x000b183c616c9cf9,0x000fe84fcaaf1c59,0x00077c97ed67f1d2,0x000a1d1e1a09f1bd,0x000c2f47751550da,0x00038d58d345e7ba,0x0000000000000001}, {0x000d95b5f854d3f8,0x0004daa404c99ba5,0x0005a1bac7d29f41,0x000da46981c9d673,0x000652c1bc49956f,0x000e505f2a66bdcd,0x00081069783eab5f,0x00036f9996ab9237,0x000238170a7330e6,0x000670fa70e33da6,0x0000000000000000}},
    {{0x000e86a58386cf1e,0x000572f15be04bfe,0x000e35f663e32b87,0x000f5c5294b48632,0x0001362fb4267165,0x00007dadeb7d3b94,0x000012e189d86c34,0x000d63e5f7805689,0x000b7e33561c7907,0x0003c0c0dc085fa2,0x0000000000000000}, {0x000cbe4f2b4f6916,0x0002f30cfb081da9,0x00011fe0a525ac2d,0x000bbd4632662679,0x000223e344c2d8fc,0x0000a08757b1ff41,0x00001c0a48229e9a,0x000456b8c92c6f71,0x0009a086c4af0e80,0x000d74c21360d8bb,0x0000000000000001}},
    {{0x00000ce7164d30ca,0x000fedb34ef3a45a,0x000800620f8ac5c1,0x000c7c79ba6237c0,0x00088ff56f44997d,0x0008ab94745563d5,0x000df21b2b00a9ae,0x00086a286295b8d1,0x000426dbb4cf9b37,0x000ec830b7004300,0x0000000000000001}, {0x000a97f98f792db1,0x000f9d5a4e4b251f,0x00061b4d385d3a62,0x000b4cdaad987701,0x0002341727a73b90,0x000c4abf7e84f908,0x000f0ded814c4a3e,0x0002c453671bed3d,0x000a888690c8945f,0x00019a94087855dd,0x0000000000000000}},
    {{0x000e5f28e7fb0752,0x0005ca705e5e780c,0x00093ca952d3af74,0x000eccdc7351cb28,0x000bfc12e9837fed,0x00014b93567e7bfb,0x000546247999f34d,0x000a3f729887c629,0x0006edd285692b0d,0x000fc9812e383cc9,0x0000000000000000}, {0x0001bc941d72f110,0x0009ba70199860ef,0x0002d090c33493b9,0x000503ff279e0c37,0x0005c3fbe286bbe1,0x0006d81c3e80f646,0x0008d3a0a9257bf0,0x000e402ee72a2a44,0x00092b91c6a5669f,0x000ad95315497ce5,0x0000000000000000}},
    {{0x000b397c9c0b3f5e,0x0008573318572b93,0x0000e667f17a3327,0x0000b9137af5bff7,0x00017fb65a96b2e6,0x000188dfee9e25ef,0x0002c9edd117ab29,0x00015472d03d830a,0x000512ca1063aa4e,0x000adf9593f42bd8,0x0000000000000000}, {0x00043be475ba796e,0x00023dbbccf7b7a1,0x00080d4a4b140a81,0x000247748562ea6a,0x0002f53e144c7e84,0x0009ac8b6fa39d88,0x000b1eab451fe154,0x000ec4538f34ffe4,0x00076cc290527aed,0x000d83bcd8efdc10,0x0000000000000001}},
    {{0x0000c5c5bcdaef57,0x000720046d980167,0x0000601ff33f7b5e,0x000e6b0aa07084cc,0x00007791af83b900,0x000dd856fdd2391e,0x0008d880430654d2,0x000f826068896340,0x000a4b443c176e8b,0x000c4e18c663e62f,0x0000000000000001}, {0x000d8ae0441a598d,0x00065c950e8cec48,0x0001316d53d11b80,0x000cd6863a5ccc8c,0x0008ced41a668fee,0x00076ba771bb4164,0x000b49a9a4bb4b6f,0x000e370974d5a9b2,0x0000485def9f130a,0x0001b84c25f49d20,0x0000000000000000}},
},
{   /* digit=61 [{1,2,3,..,}]*([2^244]*G)  */
    {{0x000f43bc2dfb404c,0x0008b314169ebb20,0x0004d9ce016776ec,0x000b6f3c40cc814f,0x00075de6701fd64d,0x000be16687bc27b3,0x000c8ca41b2641f1,0x000e5c7ebdd8aaf1,0x00021918a667e429,0x000d9384d2d4cd92,0x0000000000000001}, {0x0009667398bc8b35,0x00026c502a6f1f65,0x000612fc65ae7726,0x00047588d1717c45,0x000b0cd0bd27306b,0x0007b68702fd9dbc,0x000a43a5beaed3af,0x0008d9e3bfb560d2,0x000c14b9b618c615,0x0002421dad1537ee,0x0000000000000000}},
    {{0x0009e7889bf8b6ea,0x000292e957ebe27b,0x0002bd715ca3ae1f,0x000ea4756ae08fea,0x000f5cab67aaf3b2,0x00047caa37f247c9,0x0001b8953af0925d,0x000557e7bd1f409f,0x000979eb14ee5b8e,0x0008bb0e2890300b,0x0000000000000001}, {0x00078d6b71ea9467,0x0000c63dfcb1d01d,0x0008e6aaf05595db,0x00006ff49217ec90,0x000b8ab12df36451,0x0004207aff8489ad,0x000b85d257b835bc,0x0003706e08a1abbb,0x0002a5b7d71ad10a,0x00056ae224792f6d,0x0000000000000001}},
    {{0x00028daca765356a,0x0000ee74680323bf,0x00005f51f95b6f29,0x000c6656c3eab37e,0x00038ce239752348,0x000cf8aff4ec8ff2,0x0003adc6745b80af,0x000e56c344a76be9,0x0006011d48a9f827,0x000ed4a3e016c1c3,0x0000000000000001}, {0x00096e22c7a80fb0,0x000891624b09ab2c,0x00049f6d4616a383,0x000b275d1cd7006e,0x000adb9075332618,0x000586e58c4079b5,0x000645e2b19bf36f,0x000f76906dc5820f,0x000f6bdd7a51a11b,0x000b67dd8137d034,0x0000000000000000}},
    {{0x00095b8b650fd71f,0x00014965b39aaa82,0x0001270c9510690f,0x000b3a9f763e6fce,0x000be3f839143baf,0x000866c1890dc990,0x00074c8a0d6a0e73,0x0004b520d476087b,0x00081006ed8910a1,0x00052b16e6fb91bd,0x0000000000000000}, {0x00057756a63f7354,0x000a1ebe4b13d097,0x0003f1884cec54fb,0x000503924519ff97,0x00059fb9e4f42689,0x0002ce5e202d309b,0x00098e0004b85f0f,0x000b05c20b1735d8,0x000add1fbd4f54e0,0x000dcb178e2a7f34,0x0000000000000000}},
    {{0x000b4ec871f1c2e0,0x0003b5de22756058,0x0000837f536100e3,0x0000c16f1ccaf424,0x00056dcf857da01f,0x00038c07ebb5fb6d,0x00096a096d6242a9,0x0003055c2b2c30cf,0x000a782e55f66ac8,0x0004f012cc9c2c3a,0x0000000000000001}, {0x000506352d9bc635,0x000b06aeaaa56b9a,0x000095186c35174d,0x0002167f537385d7,0x000cf421a089f0ea,0x00022c37dc99678c,0x000356bf33a69466,0x0003e97eafc66d63,0x000e3c0197b16669,0x000d912a0fa3fee5,0x0000000000000000}},
    {{0x000a52c892d50f2a,0x000dfd8fc48ea89f,0x0004b09bae86a680,0x000a1e1278d67917,0x000370f37ae3b7ce,0x000f51107a8383d3,0x0005c8e157913dc9,0x0004c347e479bbd0,0x0007dfb63e7f7f02,0x000ac4a32c2410c2,0x0000000000000001}, {0x000c5983d275b47a,0x000f3ebc8a42a9a0,0x000db0533ac31f03,0x000cb9b707b4440f,0x00064522041e91b5,0x000076367218816d,0x00023be78c44489a,0x00060289668fa7d8,0x000b7bda9a033e06,0x000c041bf9880e14,0x0000000000000000}},
    {{0x000df487e3ac46f1,0x00026f6aeda132f0,0x000f9138020c745f,0x000a8841334fb2d5,0x000c66722bd6a712,0x0005a1ea4533d309,0x000636323c57e66d,0x00008eb26f26bbe3,0x000fa479b5dc3fac,0x0008f02e50177e02,0x0000000000000000}, {0x000c92b56635aa25,0x0007f4d610ada23b,0x00010104e5566f0f,0x0004f4b30ea26b57,0x0004efd9675fd322,0x0001af8f50ca2f0b,0x000382d177aefb1d,0x000538151171ef73,0x0003347891a319cf,0x000711dcdab779a2,0x0000000000000001}},
    {{0x0002b024db8d3d78,0x000aa5cc47fd4499,0x0004ca3c2ae301e6,0x000f6635a239d460,0x0001e72a93968b59,0x000f3e7cb493da74,0x00057a0e451c8476,0x00090539a4ae9584,0x000df123a0ccc6f4,0x000f3e4b36ee4a70,0x0000000000000001}, {0x000bf5964aec0226,0x0008d0d54e934ea5,0x000838881f3a4f9d,0x0001904c5759057f,0x00054f74d21e3d23,0x0009110e0965fa28,0x00025473e3fbb9d0,0x00066659568773f8,0x000e05953c3213d4,0x000de0c6c9fbf74e,0x0000000000000001}},
},
{   /* digit=62 [{1,2,3,..,}]*([2^248]*G)  */
    {{0x00023dd4a823eac8,0x000e2984db5faf62,0x000d39d495d0b0f5,0x000841ce0a14e52d,0x000cb365ed8de723,0x000bcb1fe9b4ef0f,0x00047ee3aa7d5d2d,0x00032d33c7e0b190,0x000d3b9dde2978f5,0x0005329dbc97d12a,0x0000000000000001}, {0x000d165556c00ac2,0x00057fb3172c7a02,0x000beeb32c48804b,0x00099dadad774958,0x0007934b2bc9659e,0x0003fd281f90ab3c,0x00013abe477effe3,0x000378b329a3faa7,0x00036cbb9f3df235,0x00014562e824d0ac,0x0000000000000001}},
    {{0x00078de5aeb19662,0x000d1f458b071bd2,0x0000313ed9b5b584,0x000ce5fe5f476cd6,0x00077007678c1c54,0x000258964a6d145a,0x000420c0c62f8fee,0x0008595f7056fa68,0x00089119263621f2,0x00019c5d8cf9f82d,0x0000000000000000}, {0x0000243d2e6cb7a7,0x0008d78d5a87bb13,0x000c4e517b3bcf90,0x0000f65dd0ef67bc,0x000d930e5dd35ba7,0x000eb9fb0741af2f,0x00075eb448314eea,0x00003702fdd3f71f,0x0002c0a91bac4835,0x0008e91ebd11ec1d,0x0000000000000001}},
    {{0x000160f761d5cda1,0x000d737ebbdcd5d3,0x000d7809f98ac1a9,0x000dcdbd555d558c,0x000fa398a682b263,0x0004f2c8dcb516cf,0x0003f1fdc39fa308,0x000c8f35f0892119,0x000b1a2e7b6b0e00,0x00060305cb4b78de,0x0000000000000000}, {0x0005dc3804225ef5,0x000a4dd0142d36ef,0x0006183af50e0ed5,0x0006c670fcbeb371,0x0008629b90cb9a81,0x0002af3261b35739,0x0008aa6b6e9823af,0x000fbd19a0ec458b,0x000311a98270a0a9,0x000299fe388efd5b,0x0000000000000000}},
    {{0x000bf04df8057734,0x000b1031cb2cfcf4,0x00013e25b6e0c3ad,0x000fa4cf3dd2ab40,0x00007758e2edfff8,0x00031ad907feffd3,0x000b4564baf111bf,0x00073c4f6a12eba1,0x000fad75513a8160,0x00074de7fc43bd94,0x0000000000000001}, {0x000d44eee593810b,0x000f1e369ffff5b8,0x00064f19da65334d,0x00021d0f5c2b9ceb,0x00091c5ca3390013,0x0005689acf02b87e,0x000bf7c3a49c8b54,0x000093f7ed7c049d,0x000a0a1d58d27784,0x0003d7726f20ba73,0x0000000000000001}},
    {{0x000ec366cfe8b8dc,0x0005109510bbe0e0,0x000aea6451541d52,0x0007f0a613f8478f,0x0000f85f758544a0,0x000f2b250e479f86,0x000b98246494bdaa,0x000483bd40872db5,0x0001ef43cbf9eee7,0x000bc8abec7ccf7e,0x0000000000000001}, {0x0005c21b7bfcf30c,0x0003ee117f493af1,0x000fdb4b0534832d,0x0001fa1bf55f45c9,0x00078f7e3c1efc43,0x0008a7de78a32d11,0x000dc3559e7ee791,0x0004e7a865c863d0,0x0007e1e671e05898,0x0005634bd3bf85ef,0x0000000000000000}},
    {{0x000d81691c2ab48f,0x0002541bcc0607cd,0x000da791a7f87cac,0x0008347771261610,0x0008e3bac250c120,0x000659e04001e2db,0x00052cf1b9282899,0x0009b392289990cc,0x000164d7d417f75a,0x000945df41fb11a9,0x0000000000000000}, {0x0009c07103c6ae84,0x000480fee72710d4,0x000b8360a2b9d155,0x0000e0d3d7e07da2,0x000d149f0388daf1,0x0002f71dfdfd1523,0x000418130ff86f14,0x0009f7346c3e8b09,0x000b2e35c5e699a7,0x00052b1c1fdc6ba3,0x0000000000000001}},
    {{0x0003345adc3b52d1,0x00068ceb5ac071d1,0x000e11041a7e60d2,0x00074a2a70677323,0x00040734a03353e1,0x00041105a4c9d8da,0x00044e1f19873918,0x00091f314a743285,0x000322e1b26f9179,0x000d3d1613ed69ba,0x0000000000000001}, {0x0004543cf00ed5fb,0x00053fab663cf4cd,0x000be8cc8843f104,0x000f74fe45dc2276,0x0004319b78ce0e03,0x000389520a05dc90,0x000cbb592960d2ca,0x00026ed0dfe3e1c7,0x0009036fca8841aa,0x000549d9ea193025,0x0000000000000000}},
    {{0x000d95d4b57fe6e7,0x000237e45eed99e3,0x000ddc0cb978fe19,0x00073f687eb46e14,0x0006f57bdaf6e4df,0x00047741a18670ac,0x0004925a46fbe2b8,0x000282f9632d0245,0x0002e144fc15a10d,0x000815c55aed10af,0x0000000000000000}, {0x0004dce0659c9bac,0x000b25a506cebbc4,0x00048b6559b03aaa,0x0008048a933863a2,0x00020d37a9de4c34,0x00020f440226cd5e,0x00074e9ee95db69c,0x00082f425e1eff1c,0x00033a6f8d820bb8,0x000ef06f95cad219,0x0000000000000000}},
},
{   /* digit=63 [{1,2,3,..,}]*([2^252]*G)  */
    {{0x000e4e5c561d5097,0x000b584aedde8b8f,0x000aba27830c0d36,0x000c7d59c0f869dc,0x000b714a35cbc32b,0x0004bed4bc22d71a,0x000061f00680d9e0,0x00033bf0836adf25,0x0000d7fedb3d768c,0x00095c616b984e3b,0x0000000000000001}, {0x0008c5d5c16b3659,0x0009b2bd923c283c,0x000fbaf03219a32e,0x0005bdb0f0d8e95a,0x00027d3039b5fed1,0x000c59ce26d89427,0x000676fa1dec9a4c,0x000121992696f0b3,0x000260c98b8c7cfb,0x000541c1c9792927,0x0000000000000000}},
    {{0x0002f821dc52854f,0x00009f01e839c81b,0x000f9520b0acb7e7,0x0005ef6ec4857ab9,0x0007209f9eda63a8,0x0006daca6651f475,0x000d6976e7173379,0x000240b37bfaccec,0x000b4437229f4ce0,0x0001910fe8a0ffcb,0x0000000000000001}, {0x0007819702adce4e,0x000559cf2ed75ea3,0x000524a7d80f948f,0x000a15733e1fceef,0x0008e25fd5510058,0x0004c29ed3586531,0x0004e51cb7d9fa11,0x0006f171b487caa6,0x0006163b82558054,0x000686de74000000,0x0000000000000001}},
    {{0x000b150deff72861,0x0006369a87c08222,0x000222ff210ad76f,0x000b4d66f2177234,0x0006ffb6d673f874,0x00059b847a7a63aa,0x00088181fb601b85,0x00061d5a56e17f52,0x0009cad3b2dceae5,0x000b7064799ea515,0x0000000000000000}, {0x00071777678fbf96,0x000ee3fb840953c6,0x0006c82ee1fe6943,0x0000476345986586,0x00027b2c01a1da88,0x0001dd9ed1d2e620,0x00093b57ac9ecf98,0x000aea3ed52ca86a,0x00083c732ab42d43,0x0005274badd57297,0x0000000000000000}},
    {{0x000860f86c3463c3,0x000fa451b92975d3,0x000e9c89aced751f,0x00082df00fff3b8f,0x0004d44ceed1d22e,0x00022e7d389ef4bd,0x000e91dec43e5b63,0x00003ac6cd725daf,0x0003c7139385f22e,0x000deeecc87ca1c2,0x0000000000000000}, {0x00051580221e0fc8,0x000941fbf97dbfd6,0x000689ac9e872372,0x000740f84611974e,0x00046e04ba0c6ce7,0x000419caa07a8f97,0x000565905b0cdaf7,0x0003cd2570033075,0x0003b2c015af7e40,0x0003287d54b47d8e,0x0000000000000000}},
    {{0x000087653c1971e3,0x00077f0a153e5f28,0x0003ed97c2828991,0x000095935157a12d,0x0003722663e4ec8c,0x0008ec4fe824b403,0x000dd44aff641d97,0x0006da087485323c,0x00044e2cb2c2b861,0x0006eba170078d74,0x0000000000000001}, {0x000b5b83303bc746,0x00013dec62dad85e,0x000eb52890ef39fd,0x0007414a67a192cc,0x000ca32294492ed1,0x000e1460a8a16787,0x00024c190537d3f9,0x0004d8dd49fa5c1c,0x00025dcc6564966f,0x000872ce77f122af,0x0000000000000001}},
    {{0x000f907cb543fab3,0x000c69a83a50077e,0x000cb4bde1d63e29,0x000c33fc44a3bb56,0x000f82a91020da98,0x00021551aca18ce5,0x0000524e8061c783,0x00030bbde84c8ff8,0x00080aaffd7e7a07,0x00025503d2cefb4d,0x0000000000000001}, {0x000d489c09cd7406,0x0003bbf72e670d86,0x000584e3d6cd578d,0x000c5357fb7dc505,0x00078eb6069dbc02,0x0003d4fa59d19b85,0x0000398d29e9ce8a,0x000efb99649fd29d,0x000ce49c616fbd54,0x000860686cd02ccf,0x0000000000000001}},
    {{0x000b5280bf38c012,0x000b16e5d0e927a5,0x000e0fabbb77cb27,0x0009a5fc1a89a6d3,0x000a92cdb34cf1fa,0x000464dc9a9cf793,0x000eb464387be7aa,0x0007fbfde96cd4d4,0x000232f3e162772a,0x000656aee57c0a02,0x0000000000000000}, {0x000a4f88de057838,0x00017126373b6048,0x000e4a0f6263ace7,0x0001d00ce841a9eb,0x0004964f3fadfdda,0x00053a6795df2847,0x0007970db46fe5d6,0x000fc5cc5ee32eac,0x000634cedbf5f3ce,0x000fca10e755fd0e,0x0000000000000001}},
    {{0x000aeb844e0e5a47,0x000278171b725206,0x0003ef95a8f2f67f,0x0001fdfb411d7c3d,0x0002cbc9db5d5134,0x0004cd3d499c831f,0x00090a75fa0db406,0x00072c8d72cfb8bb,0x00070a986050fdef,0x000f2a584d26e897,0x0000000000000001}, {0x000357b6cd8cc5f7,0x0006b375fe114c8a,0x000aa2296d0e1fc2,0x0007cba1e2fe623c,0x000b8ca73315ce03,0x0007e86db236843e,0x0005e04b5b70ddfb,0x000420198f9d4b15,0x000535cfa0692139,0x0005a2aa06d43751,0x0000000000000000}},
},
{   /* digit=64 [{1,2,3,..,}]*([2^256]*G)  */
    {{0x000cc45663bc9f5b,0x000b2868f57feb89,0x0004bd3cbd6a2543,0x000a5e560bf63c0e,0x0000e648f4a5666d,0x000591427cb7d9cc,0x0005977ab848b1a7,0x000af4656829e85c,0x000ae8f7a4025667,0x0003b4ab876527cd,0x0000000000000001}, {0x0004ed81840ffbcd,0x000e4830db96c420,0x00026c352dd1b3e5,0x00003369497308c9,0x000023370174e547,0x000c6d8497a95345,0x000ecbfae86058c7,0x0008a32e4cdcae7a,0x0004e9eb567daf0b,0x00085eaf8dd7df3a,0x0000000000000001}},
    {{0x000deae24e7511a4,0x000762cb23734ed7,0x00066bcd84d23939,0x000c037c989a46bd,0x000c06543988385e,0x0003f08c8acc808e,0x00000e7680dc66ca,0x000e4c3c5332a768,0x00063204acc98ee9,0x000db0a0ef46de86,0x0000000000000000}, {0x000b4a4e27fff289,0x0007eeb14e22b305,0x000e9d3141e930a3,0x0004f15435f5cd09,0x00052f55ccf3f336,0x0006c9377055f313,0x0000f610c74549ef,0x000c8d0207da4bf8,0x000b6ee97b1c2b15,0x0000920992fd2caf,0x0000000000000001}},
    {{0x00043f2525d2ebb4,0x000811edb2cca106,0x000c996f27900e32,0x00092edb6f6af92c,0x0002dbdef8275bf9,0x0004dd3d26338446,0x0004401818a7ff9a,0x000d60e7694d8e21,0x00054e87fa7aec62,0x000f988bdd22449d,0x0000000000000001}, {0x00063c9fbe4e6775,0x00026d7e7ff11afb,0x000c6b3e18f7eec0,0x0005c983e08b80f1,0x000b75d6b5a4c84b,0x0005f99e3a4b0fd4,0x0005a7cfc4904ce8,0x0006c336a99a7afd,0x000e4a736ba1e62f,0x000595be20ba2924,0x0000000000000000}},
    {{0x0008c92f010fc781,0x0002463423f6e871,0x0005f129e35dae8d,0x000d59f4aeff7db0,0x0000c963932f5dba,0x0005e468db3cf82c,0x000e23c6b7d10e1f,0x00006e08595910e6,0x0008880e8c76fb1b,0x000134e8c1259453,0x0000000000000000}, {0x000506649d87b671,0x00014c272ea4f089,0x000aa2740669dd1a,0x000622f8a6cc0d62,0x000e392244f6f191,0x0003dcbd9dd28338,0x0000c61a8dd7166c,0x000e4930a90ca39c,0x000d41296b979b8c,0x000037aa5c88b76c,0x0000000000000000}},
    {{0x00051d16f31cd955,0x0003fd720fff5e54,0x0006c62e42ceacd9,0x000b72856f74fc83,0x0002b8a51db93ff9,0x0006ca983e7b6bb4,0x000e06f8fd893a36,0x0002491c6c8908ee,0x0008e9f64e123094,0x0005764984e58063,0x0000000000000001}, {0x000ad9aba979f347,0x0005557b9d835c0b,0x00089b7877984846,0x000ce8c3c6bb325d,0x0002e0fb571c388f,0x0007185f17237c5f,0x000ac5737bcf4832,0x0005f037df6f53b0,0x000b6f7ae34a972e,0x000821f685c7b273,0x0000000000000001}},
    {{0x000e5575bc0dd4ad,0x00028eabf66053ac,0x00054861cbd6dc53,0x0005b123ea9fdaff,0x000c00ecf823c855,0x0005d8934d09e411,0x000eb090ae97a01a,0x000591dabc9c170c,0x000f751f273c40a7,0x000f0f52861011d8,0x0000000000000000}, {0x0002bc9a33075cd8,0x000bb779de4fde35,0x0002eb1b199f0130,0x000e29003c4457b6,0x0009ff04878d3a95,0x00004ebfeec1a9dc,0x0007d0d097a6545e,0x0008673c7b41f5aa,0x0007894e63c5c4ce,0x00005b385d1700a6,0x0000000000000001}},
    {{0x00046d7efcbdeae0,0x000fbb2f349cfbe6,0x00022f14a9cfd187,0x000ef46f7fb5a2ff,0x000d8084df701781,0x000b2e7da6ada115,0x000273537b36285a,0x000d779e5cbe2143,0x0007b1bb342159b5,0x000321182d17ef98,0x0000000000000000}, {0x000974b9395d5c1b,0x000a203e9046670c,0x000c9fa51be4f31c,0x0000167fed87df23,0x0006d7ab1aee3553,0x0006c8a7b334d671,0x00037b8b3f821601,0x000677ee013df3eb,0x0007a3a1013ff132,0x000a7ed7d1a2e9a5,0x0000000000000001}},
    {{0x000b3fd002806466,0x000fd4605cfac818,0x00085d2f0b811efd,0x000167145bb41efb,0x0006e3c03cac7ee2,0x00085c4b2dade36a,0x000220dcd3725a14,0x00032cf525a550bc,0x00014db66b11c84f,0x000013664e47ace3,0x0000000000000001}, {0x000a48858e7d464c,0x0002276f7bbfd1a7,0x000e24ada567d04c,0x0006a941adced466,0x000c270addbb103a,0x000761ca82f14e02,0x0004d0794b62798c,0x0007a0bec3f90326,0x000caf618966e8d4,0x00021a1f211c02e6,0x0000000000000000}},
},
{   /* digit=65 [{1,2,3,..,}]*([2^260]*G)  */
    {{0x000c24408b5b4bc1,0x000d861e48c2aa26,0x0008746f93b2fb6c,0x0005f018515690c4,0x0008d76a3c1b771e,0x00093035c899fbb2,0x000d18ac338e0049,0x0001b4e7f02fa3d8,0x000fabf9b804c035,0x0002f83e6175e309,0x0000000000000001}, {0x000830680485a054,0x000962c1a8a622f6,0x000f94a3f3450d94,0x0007a83e0a44d62d,0x0000105319e21805,0x000a4a1ebdd2bed2,0x000f4863d6076c13,0x00034672ca137368,0x0006135e4ef4b1a4,0x00020b6692537ff9,0x0000000000000001}},
    {{0x0001b7a5e08fe30e,0x00029eb048815ab8,0x0002e0a161f11e12,0x0001801becb84207,0x000ad5b394a58f8e,0x0007512807890edf,0x000f675b3e4e4773,0x0008c99841055d81,0x0003ed35c1050ce1,0x0006c217bd56acf4,0x0000000000000000}, {0x0000d6c8c5a1e005,0x000ddbaf53db5dcf,0x000c6ab4e4f6ee72,0x000e686032c8481a,0x000415c545af61b4,0x0003595ad60e7c0e,0x000f59b261ffe75c,0x000cf66fa7cfbf47,0x0002e7097fa1aaf6,0x000a8386b7977f21,0x0000000000000000}},
    {{0x0000029a7619e46f,0x000f29f5c333074b,0x0009e45f3bb1eec5,0x00035aadf8396133,0x0000825d3e2a3176,0x00034ef799bdaba5,0x0007f38574f4d09c,0x0009085e808678d4,0x0004a57483db0387,0x00054465ae9f6d1c,0x0000000000000001}, {0x0002fb74fcaebc4b,0x000ef4b901e46eb5,0x00068ec4a861868e,0x000f51a07bab1199,0x000748f19df109f2,0x000d75da4f6a75a0,0x000f255613859652,0x000e60c8067759f7,0x000b663826b7b569,0x000f450533f4d440,0x0000000000000001}},
    {{0x0008e66704c4911e,0x000b5ad20de07d3b,0x000dab27e9b7aafa,0x00052dbe3fb66eb5,0x000cf7ce856345ac,0x000025496cdf84c8,0x00082f095b8e1e29,0x000e8e6db4cd7761,0x000b0faa321aaa54,0x00088ae73fef003b,0x0000000000000000}, {0x000d643fd4fac454,0x000c4870e138d616,0x00069ca59b85612f,0x000a26a00889a9e6,0x000c093e3dad6fb3,0x0006ce66bb43df1b,0x000244dae036271e,0x000c05182a82fcd4,0x0002559d8958ca2a,0x000a7526838c8510,0x0000000000000001}},
    {{0x00084b954cc2f383,0x000a776cd88b3801,0x00070c99422dcf3b,0x000bd45086f66f43,0x0005f7b81c0e8bc4,0x00004cad2493575c,0x00070ce4091825d7,0x0004f1ff4bbf4b9f,0x000d28bd9ac2a0a2,0x000c23e5ebf7a3b5,0x0000000000000000}, {0x000270e7ebdf9c15,0x000050eb783548eb,0x00081562bc5fd0b1,0x0005f68896b8a59a,0x00073bc130375edb,0x0001c5bd938ab1fc,0x000c19c89b28feaa,0x000f8d6e4b1c7f18,0x0009f7384e98a494,0x000a3f55131bf640,0x0000000000000000}},
    {{0x000a27923d9331dc,0x000f04ffb6351b25,0x0007f29f1e1c9bc2,0x00069b7d91e80528,0x000d48a56cb26370,0x000d9a9a20ff75d6,0x0000b393f52dd397,0x0003703dee3c5227,0x000f9c1c267288a6,0x00083849651d4713,0x0000000000000001}, {0x000d56c853c2dd2e,0x000a93bc1a8d521c,0x0008735173646598,0x000967ee4685de4b,0x0004cf35701ef418,0x00080b116b6dbbce,0x0006b03c5acf7cf3,0x000fe839b4243541,0x000841fbd8d1a9cf,0x0003a6e1730d1f15,0x0000000000000000}},
    {{0x000fdbea99958b96,0x000e01f76bf65ac0,0x0000c6778adf573b,0x000d0f51ffd85a6f,0x0004afe98c72d927,0x00087e8ec8173887,0x000d76d032ae57d1,0x0004df95e88800c6,0x000ec4042dee55d1,0x0008e8cd5760c30d,0x0000000000000000}, {0x000eac1084c10f00,0x0001c37bdb463a14,0x00076281603cbf77,0x00034037d48543b5,0x000f3b965ac3efc6,0x0009a7be5b6e5426,0x0003d0f87fba3664,0x0004ddb5ca9f2e20,0x000052649abbc317,0x0004b72eb6083655,0x0000000000000000}},
    {{0x0001bc4f61438294,0x00002964a43b5d5c,0x0005d7c26171c634,0x000967cc93c0fb82,0x0004b96145dca1b7,0x000b5c4ddfd06836,0x0007f0eec5bd3c73,0x00082d7bf8f0d500,0x0005b93c7771d6fd,0x000475f222990f21,0x0000000000000001}, {0x00026e01b4722367,0x000926340c9a0a1d,0x0007edb2bec04b5b,0x0005d17d0417ca25,0x00072b41c7280efd,0x0003c942f670df33,0x0007910fbfcef999,0x000437ef3a577e3d,0x0004d4c9039005c5,0x000edddb0ceb3a8c,0x0000000000000000}},
},
{   /* digit=66 [{1,2,3,..,}]*([2^264]*G)  */
    {{0x000a3a0634a3ce07,0x0008f38d14324956,0x0002232fc3562771,0x000d389e5a0479ef,0x000b882744b806a6,0x0000bd687af4d435,0x000d3172792b960b,0x0001f792e60e4cec,0x0009dcb17063be91,0x000c5902f6ffb4b0,0x0000000000000000}, {0x0004fbf6f215ba3d,0x000918e7c66f8fb0,0x00095b38bbb07b90,0x000022d201c5b207,0x000344fdf3937c67,0x0005a11142ee01b8,0x000cb5fc7b97506e,0x000c2ae4043311b8,0x000e1937f2450b7b,0x00045fa26a70cfe3,0x0000000000000001}},
    {{0x000fdc4396bfa539,0x00092b7edbcb88f2,0x00019d35421db912,0x0000a538d5dee79a,0x0003b035e9ea2a42,0x00021709fe9cf14f,0x000a5b749703f94e,0x0002495b47e8690c,0x0002ef0574deb7af,0x000dd4b09d6324cc,0x0000000000000000}, {0x000f7df3b9fe6e0b,0x000f9e25c764e67f,0x000b9153d851593e,0x000822d7ef6d9489,0x000c9238e5449117,0x000bd3333b1e34e4,0x0006cfb58cc8198b,0x000b7b487650416c,0x000068c07a8085b4,0x000b7b5e20cc8eb3,0x0000000000000000}},
    {{0x000af6a4691425a8,0x000eb7a958bb9efe,0x00085a7002151b0a,0x0006a8775208123e,0x000055575f5446b3,0x000528fdeea0c896,0x000a43b1b4d824bd,0x00096f550c5c7315,0x00050cdbb6610168,0x000b9c3638cd4a93,0x0000000000000001}, {0x00039bfed8d0ec30,0x000230c0cb3e1745,0x0004b3cb7f69dddc,0x000a60a97d0d2a3a,0x000c6d61d74827e9,0x00048c2e237c10e2,0x000c78dae64ccf95,0x00031e036445ee96,0x000bee13f244e4cb,0x00012ec220b81c78,0x0000000000000000}},
    {{0x0008b837d4bef687,0x000919e15922b2f9,0x000c8afde9c62c29,0x0009534c95a1a3c5,0x0008f604b1043ffe,0x0007a01a13fa2f63,0x000393b04cd8a8d2,0x0006e26fd0c22660,0x0000808a072545d9,0x0003871dd10699cf,0x0000000000000000}, {0x0007dfe3a4ea56b7,0x000094c38223ef03,0x000e8b66c87d36e2,0x0002766ee28405ae,0x000f0a065b535e3e,0x00084a317ded4b87,0x000866d3f53ac0b0,0x0007a0ee55860ca5,0x000a7080382b21bd,0x0002f3ff1d58cf1f,0x0000000000000000}},
    {{0x000760a0d077a674,0x000256d1eb02b933,0x000a86e63e76464f,0x000e22b473632441,0x000db481034e4b15,0x000914ef870834a6,0x0004c2dffa8bbf34,0x000d9d0466943feb,0x00031a2dbf893cc1,0x000615fa26911a87,0x0000000000000000}, {0x0002f76d13211f86,0x000b53e5f9871239,0x000bd8e3f6da4b87,0x000367de3555d6f5,0x00095ebc54c2b323,0x000413dbb2bd8e48,0x000ddef4e974c105,0x000de08da1d15f48,0x000eb47f901deb65,0x0004f245e4c32880,0x0000000000000001}},
    {{0x0005b2c93a39a68f,0x00012def13c9b690,0x000a5eaf60ed34ff,0x000eed4546115d13,0x000acc0704820ad4,0x0000c499c60761b0,0x00013af5dd51e45f,0x0007a978e5524abd,0x0009f811db1ec09b,0x0005900dab7d3aa7,0x0000000000000001}, {0x0005f21e6490481e,0x0009c0ea3d3b19a7,0x00068df5edf0364a,0x000c93c95e1d6b4a,0x0008333e2dcc0b44,0x000a8fc7be078322,0x000350437cb9512e,0x0005c965c20fe9e1,0x000d3176a887068c,0x000004e870a54162,0x0000000000000001}},
    {{0x00005c3b211947b8,0x00027fda98024305,0x000832a6aa27a459,0x00057be3feea006c,0x000ba0bb599ef407,0x0009c187eff74059,0x00032aa4ef6180b7,0x00072b398f55afe2,0x000cc5ddc46af4a2,0x000e611d5ea71271,0x0000000000000001}, {0x00085981da5484c4,0x0002661fa0fa34a4,0x00025e8fb282c8f6,0x00009d9542344d00,0x0005e720cc73e773,0x00081ad0388c6b65,0x00097a5b5f85f411,0x0006173a273c5fde,0x0000126c0a036ea1,0x00030085c778a65a,0x0000000000000001}},
    {{0x000dd3a67c2984a5,0x00072c7824703af1,0x000bf0c69c5b39c7,0x0000901a46f942bc,0x000f89e0174be31d,0x000b6326f7d38bdf,0x000eadb91bfcc1ea,0x0002541868bb8787,0x000a48a8ba038566,0x0004606d8787616b,0x0000000000000001}, {0x000e290f5d5f8e88,0x000eb41d33d54569,0x000662b634f1ba52,0x000fc5049dfd1d1b,0x00059be51c909876,0x000b7406ba93e420,0x000475a49355b9dc,0x00048963ea182651,0x000985ceebcf7670,0x00062eaa85c80508,0x0000000000000000}},
},
{   /* digit=67 [{1,2,3,..,}]*([2^268]*G)  */
    {{0x000b5648e1eb2291,0x000ba734c2f6e413,0x0008535398b202b7,0x000a8b23ebd7f177,0x0009fd3b0fc5e7ee,0x0003df55ddc7a0f1,0x000261d577641e2a,0x0008f496646ecb9f,0x000f2be9c112454e,0x000e02c23da6a9da,0x0000000000000000}, {0x0009d35c52fed679,0x0007671efd66d8e5,0x000904f29b91b401,0x000c352b084f27ae,0x0000123e88566129,0x000229faaea32636,0x00087f4c04620cfd,0x0005535f695ec91c,0x000fc2a2127c5854,0x000fa1c94873fa3c,0x0000000000000001}},
    {{0x0004b028b8f44cc5,0x000fa18c73e470d1,0x00046af781c684d5,0x000aadf0eb44feae,0x000604610320e3e3,0x0008fffa44fd9c59,0x000908270d9d9d3d,0x00088a6283f3ebbc,0x00060d649fcec534,0x000e1d44a603fadd,0x0000000000000000}, {0x000740ae33023df3,0x0000135f6a91ebce,0x0003780772b2000b,0x0004747ae7ea71ec,0x0007f6f03b13d0e5,0x0006603e33fc299d,0x0000d28b6e9df68d,0x000a2043747f8604,0x0006089683aeee37,0x00024e9926fb8de4,0x0000000000000000}},
    {{0x0006c9f15018542e,0x00079fb1f6fe5f6f,0x0005889ab7c13ba5,0x000129b7c5358418,0x000a9ac0306d8ad0,0x00008b37c84cfb84,0x000acf7da701dcb0,0x00014bb42427b3eb,0x0006e318d3d02d27,0x000958db234da419,0x0000000000000001}, {0x00031a9f2e6d1d68,0x0000ba7009240e02,0x00063eb8c05422c8,0x00081b3a6ec6a77b,0x000bc58689a5aa19,0x0006306dfb930061,0x00007013549ec203,0x0005410416293e63,0x0001a4d303fabd7a,0x000ac172f1e81c7f,0x0000000000000001}},
    {{0x000b9ad3970b9e18,0x0000bf6af8e430ab,0x000f59d55e652348,0x0002bd614bc56b8b,0x000183df0a6ecc07,0x000ee1786d25c98f,0x0003feabcc84059b,0x0007b20a09a6f26f,0x000d600ce79a2dfb,0x000f39cf2e6f0393,0x0000000000000001}, {0x00072a39f3507cb8,0x0007042b1470af9b,0x0007da313b04804a,0x0000e590e67c9622,0x000cabec90cccc29,0x0005e76e6a796f29,0x0001637cadb620bf,0x000d15b03af38ec0,0x000dcf7634087520,0x0001906c0ca6b7d8,0x0000000000000000}},
    {{0x0007eccab473c8b5,0x000354c80ff211e0,0x00045d2bf3c3aaa3,0x0005bdea352cfb52,0x00016f804d4fc256,0x000e5ad706ca34f0,0x0006619c96cff608,0x000490525e689857,0x0004163c78de4a6f,0x0007e4b87dad9b7c,0x0000000000000000}, {0x00035a48ce31e1e3,0x000c4a6aef85129a,0x0002e4b9afe02466,0x000a8b4fb7e5c1b3,0x000e4ea65ec8abb1,0x0009979db25393ba,0x00064b047eeb2086,0x000d6e5e56906ac0,0x0008d958b203281d,0x000de4155ed9842b,0x0000000000000001}},
    {{0x00019bc174c6d988,0x000cf4d9f702e572,0x000883fd073431fc,0x000f7c52e0996638,0x000331a7f7f18050,0x000e9196a2374342,0x00087a7400e71f3a,0x0003791b5d724c12,0x000499ca89fe518a,0x000e565820d945a9,0x0000000000000001}, {0x00035b7cb9fac00e,0x000a632b3417a9e4,0x000077b9768bc095,0x000afb46dde432fd,0x00032553ea0ffde2,0x0000725529dbe056,0x00071cbdddb8ca1c,0x000edb41a198fcb3,0x000f5060041dd314,0x0009a1fe368a743c,0x0000000000000000}},
    {{0x00059195e6de2d3f,0x00030ea9f4518076,0x000e3f066c30b9f7,0x0003bd981db2f294,0x00046e95c601e580,0x000782f5d49b6ae4,0x000f2a24bea15da5,0x000d57d82c482be0,0x000747b852b55a3b,0x000400c12ad66ee4,0x0000000000000000}, {0x000106fc9ab22be0,0x000f3ff85e4be397,0x00064c04ee049a9a,0x00068c1771b2f4aa,0x0009c56a4f6e25c6,0x0006c0243a7cc3be,0x000082558b6f8b1c,0x000d25ba47737910,0x0009a82551abc22c,0x00044f195c4a902e,0x0000000000000000}},
    {{0x00037e57ac34630d,0x000fc2c030f2d54f,0x000b84aa880649ef,0x000b55a13ad19d77,0x0002091bd296d1ca,0x0008f7f0b28c0816,0x000d7580c469726c,0x00021840b8cfb847,0x000fd3c1cc59a8b1,0x0008b90e2778fdc8,0x0000000000000000}, {0x0006cc1f42f98900,0x00026c3bf2f82644,0x0008d5f8bb74fc86,0x00077c747df08423,0x0005d41c77ea13a8,0x000556d8fe471d93,0x0008287e98cde5b5,0x000c068f4d40279a,0x000305a88e400538,0x000e77c091d74bdb,0x0000000000000001}},
},
{   /* digit=68 [{1,2,3,..,}]*([2^272]*G)  */
    {{0x000190a6f12cf864,0x0009e0eee766f86e,0x0005b775cd536070,0x00057c69d4566a98,0x0005745df1e07e40,0x00047733f9c06722,0x0006e2b1b1c2a5a9,0x000fc80987a24bcd,0x000f4061ae7293fb,0x0007d711f7042b89,0x0000000000000000}, {0x0003c1b0341e791c,0x000537daedd9c1c5,0x000495a12d7c48bf,0x0002d4a32c8c9765,0x0005a662fe9dfe7c,0x0007c6bad9faed52,0x000660c5c4df70a2,0x000bba7fb07624dd,0x00091b1d621abac8,0x000771b618ce5d4a,0x0000000000000001}},
    {{0x000c915030a7a399,0x00068b673999f751,0x00008c22b2afe146,0x000bf6a5fc300d5b,0x000b3e178c0bceca,0x0009d38258020b90,0x000176381c171fe7,0x000e86f32623a2f1,0x000f64b9bf3a66cd,0x0002c55668f5ac6f,0x0000000000000001}, {0x0001812516e735d9,0x000aea3ea58c5dac,0x000356a5f10de279,0x000295b07e9f7153,0x000f586ce9eb4d08,0x000daab1a3f7c783,0x00000a0030b2d7c4,0x000c2198f3166033,0x000184aa9d0c0475,0x000b11a6fe88caba,0x0000000000000000}},
    {{0x000ba5c8d0193b1f,0x0007644c52e9d2ec,0x000084d971b1a2c0,0x0000ba2904071452,0x00016420810c95b0,0x000726c12ee37ace,0x0005cdbfb3b34658,0x0001ddb8f12176e9,0x0002665465a782ea,0x0005989e91fb9ee1,0x0000000000000000}, {0x0000c16d55245f9b,0x000a5ab01d1b1ade,0x000186cc016cdfa5,0x000f20c1907f643d,0x000b819ce2692951,0x0001e463db499758,0x000551bae173a15a,0x000c9960164a1a60,0x0005b509da7db4de,0x000254d9cec8875c,0x0000000000000000}},
    {{0x000b44e11c323d06,0x000fd5d6d986113f,0x000894e506cf902d,0x00052247fd0b1d00,0x000a2782247b185a,0x0003bd1827ee7a96,0x00075cc817a81ab7,0x000d58e21da1b5a6,0x0006b1f8c96f3b0a,0x0005eb0b4feab1ba,0x0000000000000000}, {0x000e1e70f2721b75,0x000160a2caaa6a94,0x000c595ff3de4a5a,0x000a75c84e2aab67,0x000e555f145b7c4c,0x000c6003a47731be,0x0008f07e7fe03b5f,0x0007c95ac06b0bfb,0x0000ec8f9062bb21,0x000d58a73aafef97,0x0000000000000000}},
    {{0x000123c6709431e0,0x00010ae6e4e2793d,0x00084b28d12b01b7,0x0007bca51962e973,0x000f98e6a52dea7f,0x0002d8bb8dd35519,0x00063c8d202bed1f,0x00009ec87640cd7a,0x000e8802cf11aa3f,0x0002789d1734b8f7,0x0000000000000000}, {0x00015a8a3e8d859e,0x000534ae889a29d5,0x000da86637742cb4,0x0005ee22c15c8252,0x000ad4f9397a87f5,0x00093d8a684e2ab5,0x0006af7ba63ff2ec,0x0004f0fe6a52e297,0x000effff8321e195,0x000d2957562f8dbd,0x0000000000000001}},
    {{0x00023e7069e42e0e,0x000d2239c3ca8089,0x00005746ae0d546f,0x0009bcbb8ee8194a,0x0005279f5c84f339,0x000373c06a06d19b,0x000c70d34e701108,0x0008ba438171e418,0x0007c7306769b5b5,0x000064bf193f46da,0x0000000000000000}, {0x0005544b033a42d2,0x00061e556329a54d,0x0006aab67ee7a477,0x000c61bcc63287d0,0x00034397f22f1672,0x00021907d612d307,0x000ccf64c77cc188,0x000f80df2be0b759,0x0001db9d853899e4,0x0007cb0c4b9b73aa,0x0000000000000000}},
    {{0x000ff9f36c3349d4,0x000c3db537864c16,0x000d990835ee2990,0x0003c5fb1d408a12,0x0004b5ff931b6504,0x000452158a1b1e0b,0x000db8a2c29f72a6,0x0009d61be31c5985,0x0007a2320489621d,0x000480174d202617,0x0000000000000000}, {0x000294c195148880,0x0009ed88751bd34b,0x000f46ac8a70ae99,0x000917e5c0560f97,0x0002525c8ba24922,0x00048c3502a88bf3,0x000ee6a458ba7134,0x0003f607a14e42a8,0x000dd29054842573,0x0009c1acd66ae0e2,0x0000000000000000}},
    {{0x000edee700e2b9a1,0x000ca05fd3e47e10,0x000775354363597f,0x000b8ab9d14d9e5f,0x0009809ae6cb63e8,0x0008a4dd84740965,0x000dd249f1a5c96c,0x0004d2f79af0cb6e,0x000166e5361d2b7a,0x000692fe3d22a60e,0x0000000000000000}, {0x0002fa6f8995a329,0x0006e396d7a363f7,0x000d92f57cc488ad,0x0009d1958510a286,0x000c0b888aa8bf0a,0x00042decec317136,0x0008b9bdf9fc71bf,0x000ac0298d41b6cc,0x0009ecbb249e5d99,0x0004db314b57f810,0x0000000000000001}},
},
{   /* digit=69 [{1,2,3,..,}]*([2^276]*G)  */
    {{0x000d708c668b7357,0x000d96ce839038b2,0x00020e1ea62ce28e,0x000713c58763eab5,0x000e2c4523fd6ed2,0x000eae1cb271027f,0x0005e4f9c4b8cf67,0x0009601ad02024a9,0x0007d73ac0716494,0x00064337442ffcdd,0x0000000000000000}, {0x0007851b23ec84bf,0x000beedb8574d7b7,0x000286ebfe9b645b,0x000e45ce0c8710d8,0x00056a79aecb4766,0x000f379f83c2d312,0x000bbc5340ea164b,0x000df851521a164b,0x0009d5d5e1ac3081,0x000081b205779b7e,0x0000000000000001}},
    {{0x0003e4b56c489ffe,0x0000450823173431,0x000479ae5276717f,0x000cb05ce3d436d8,0x000ddf2257834d02,0x0007cf804300a63f,0x00048d555acde6aa,0x000b3233d0de457f,0x000aa55b4de5db66,0x0008a60379d9ac81,0x0000000000000000}, {0x000e90717067058f,0x000132c47bead613,0x00090e8a449f2111,0x0001c278b92dfa6c,0x000a20e5052e4286,0x000d62ef7fbb21a8,0x0005d03da29cea2d,0x0002b105405706ce,0x000dda27b321921a,0x000d13a8070a212b,0x0000000000000000}},
    {{0x000d23cf55c45926,0x0005b98778f5f299,0x0001705a5c8c8b02,0x000b88f43919b71b,0x0001fcb92372e0d5,0x00043296e160fa37,0x000a4970a89cc719,0x000334a3ae695fe1,0x00051e4b95dec2f9,0x0004d6275a594212,0x0000000000000001}, {0x00047e08dd859c11,0x000f2faa12f1b2ff,0x000ffb55ea0ad152,0x0005927a2d49016e,0x00063e898a743956,0x0007e768ee6cdbde,0x0009ce79201bbe74,0x000b64e8832a0a06,0x000cff0774d3af5c,0x00081d58cc25a522,0x0000000000000001}},
    {{0x00027f0e1b46fd00,0x0003f1c1b9a1af5b,0x0003c2c754fc491a,0x0007d3165cbaab1f,0x000360310665c2a7,0x000a6d64bd760e64,0x0004ce1abfa1968d,0x000d2b0e1701fb5f,0x000d3c4d7b466c4e,0x000f912ebf21257e,0x0000000000000000}, {0x000f6e44d2ef47a9,0x000cdeddd0d09650,0x000acd3234c8ca37,0x000cba5fb7244def,0x000f3acca56c2d39,0x0004d3ff0e42e4fe,0x0003498d03959e10,0x000b101ed923e651,0x0000842e240deada,0x00047140cf65c53a,0x0000000000000000}},
    {{0x000420de7a3cca92,0x00078c40b5d961dc,0x0000669c0650c56a,0x0006512b20ea2fcd,0x000c80cfdc1ced7d,0x0002dc4c42793f28,0x00014af2a2c66b61,0x00038712d0f465ef,0x000a3e10f498de28,0x000eefd43378b1ab,0x0000000000000001}, {0x000182339af2de22,0x0000f52743e62529,0x0007cb967f975c8a,0x000a495f3b942e5d,0x000442c93c4c7a6f,0x0005ea4e81af911e,0x0001c3361393032e,0x00046ad975cf453b,0x0008fb85fbd84437,0x000e9f19bef58359,0x0000000000000000}},
    {{0x0001c8a03a758373,0x0002ff5d3c5d987b,0x0008d28755f9b053,0x000696c9a6811aec,0x000671a05c762526,0x000b50917885c6fe,0x000e435b1cd97329,0x0007d6424b129ce1,0x000fb69b5d25c001,0x0005bf8fd3449e7d,0x0000000000000000}, {0x0003b3b4745aa0fc,0x000a304f13caa8db,0x000c42581d38c65d,0x000a26e3f1637449,0x00075086fb17831b,0x00070bccf51f20a3,0x000ec67794f66bbe,0x00008759114e8fb9,0x000e55fefba15c3e,0x0006b06274e840ba,0x0000000000000000}},
    {{0x0001392a85eee65b,0x00037ebdba8a73a9,0x00057c70feb31623,0x000f9841fe6064d0,0x000abb8ea58571cb,0x000f4d78e10f9265,0x00010194ea34ee68,0x000ee932bccc86c6,0x00018b05ba4d88af,0x000c7f1b666c9e95,0x0000000000000001}, {0x000bfc49e59e8fd1,0x000ae405208c75f8,0x000d373c5a99df54,0x000a977279933e71,0x000da64aa0b3f5b8,0x00036d2c0da96b6a,0x0002eed5227ca046,0x000b6e0ffb64c414,0x000baa05111d0f26,0x0006496cce8a3203,0x0000000000000001}},
    {{0x000c440343aef952,0x00019eda15115cbf,0x0004c0ca17c7be65,0x000b899e1e404697,0x0006bd56cb968d39,0x00077f25afafaffc,0x000e8460c48baa89,0x000cb8ddcae733c5,0x0004e7b4d8db3dd6,0x000d4730c42ef0ea,0x0000000000000001}, {0x000ded4336e0e996,0x0007761c36485b3b,0x0003a9ef9b460a85,0x000ea119c163b2e2,0x000f8699c32d39ca,0x0009afc21d6fbf2a,0x0006105b2f30acbc,0x000d2782e1795cd4,0x000bd0296c5de1eb,0x0003f540db331e94,0x0000000000000001}},
},
{   /* digit=70 [{1,2,3,..,}]*([2^280]*G)  */
    {{0x000566c4dd75c1b4,0x000a0570856265b3,0x000cbace31affa63,0x0002b4ed64645336,0x0006de49945b2d79,0x000ffedb2ccdc41c,0x0001239fc3fec1e4,0x00056c094341fb38,0x00028185bb5868f9,0x000adaf680572da8,0x0000000000000000}, {0x000e0585aa2d876a,0x000b95480f8f0fbf,0x0005be334d530bd3,0x0002f278c2d3c86e,0x0006b676d6c82d76,0x00039dec8e1488b5,0x0003e4b756194ec5,0x00094e5ad8a2c0fc,0x0001d4129e01cce4,0x000c459cb7e94c1e,0x0000000000000000}},
    {{0x000e172f71314c57,0x00073776d707122e,0x00007937b43cc86b,0x0005775ac42e1bf4,0x00055e0abab130a1,0x000a4930e58a6f41,0x0005a237af5f75c8,0x0004f7ffdb8ee4d2,0x0008fe7af47745ba,0x000467da1f09c11c,0x0000000000000000}, {0x000ab833ab90a6b8,0x000669bed4019358,0x00007b7fe4d74f45,0x000d834f00a5516c,0x000f035a36d318fe,0x000f8a31bb46f3d5,0x000972946e1df3bc,0x0001ef24a7e886c9,0x00085864c383ab5e,0x000a5b85a50c0d32,0x0000000000000001}},
    {{0x000d65b66d82688c,0x0003872c2925e382,0x00080fde81ac79d0,0x000a2b38a2432027,0x0005fa34422b6bc3,0x000948d55e24a659,0x0004efa7ed8f149b,0x00071011867cfac1,0x000bd1e94e578bbe,0x000803efa0276501,0x0000000000000000}, {0x000f7389f88ed003,0x00099b4f58dfa2c9,0x00027af2024d3bff,0x000a0ca5e0ca7fb1,0x00083782dbf7ba09,0x0009fa5d6101098d,0x0005231abdbaa4b1,0x0009c03b0d70ddb8,0x000cba60cbb85949,0x0003ba8d596ce326,0x0000000000000001}},
    {{0x000ec042211830fd,0x000f78b67d56f78a,0x000d0dd5f0085f0a,0x00077ef6d1879493,0x00009d412929cede,0x000f8f47fc6254c3,0x00038136cfbb6a12,0x00090a561c304af6,0x00064012770283e0,0x0006e8c77dd363b1,0x0000000000000000}, {0x0009730231689c1a,0x00078a2910104065,0x0006adb22ec70366,0x00007eaa5919dc9a,0x0000eff75ea6bb96,0x0001b154022f103f,0x0002e9dc4300dcfa,0x00023ebbf1abfdcf,0x000c7610a1be47bf,0x000ee8e48e43b23b,0x0000000000000000}},
    {{0x000366222079ff20,0x000dd6c255282fb1,0x000e5f65eafcf45b,0x0009b30515c02959,0x000efd5074c2f0d5,0x000460bf3169d34d,0x000d88198c4daf0f,0x00042d35aae9cd4d,0x0006f8fb3a3e2b92,0x000e5b7ee19179cd,0x0000000000000000}, {0x00015c0c8bdd26b4,0x0009fc2499885330,0x000c27ee4ed9b18e,0x000e30d901ee8c44,0x000a438c4d057961,0x0007a847d74e4722,0x0005e9ebd34c3ce2,0x00049ec1f371fc17,0x00062cfa628ad626,0x0000258cb8ba2199,0x0000000000000001}},
    {{0x000414eef61746f8,0x0002f44b16d63548,0x00091c53690466a2,0x000700b4b9b4826e,0x00069ba41d6fddfa,0x000f48b184a9d1c2,0x000af1a9a1ae5623,0x000688445e2f1d66,0x00028a0ef16e7621,0x000ea0a509e87455,0x0000000000000000}, {0x00016c4ebf9d1f30,0x000002405c88d64d,0x00021995ea2cb159,0x000476f59206340d,0x0007fbdb47138c1b,0x0001fc51a673c4a8,0x000c132d81d7d81f,0x00033035e2c568d2,0x0001981e0c2e86c3,0x000c9f25fcaa15dd,0x0000000000000001}},
    {{0x000b2a49ca5dfb81,0x0008d370aadb7c4a,0x0009f4ebf1398343,0x0004d610d25c9ac8,0x000b49c7f0f75d8d,0x000cfed5c3ca14e0,0x000cd7f4d6f7590d,0x0007d93cbfaa36f5,0x000dce79a65cb3d1,0x0004b4bd97f1011d,0x0000000000000000}, {0x00001207087dd6cd,0x00049477a85a518b,0x0007671964d279a4,0x0001d11aff88af2c,0x000a1dbb6c2c5f27,0x0005ba326b82395c,0x0003c2898f431018,0x000463dc513c0cb7,0x00069f2786b20305,0x00061fc5c18db944,0x0000000000000001}},
    {{0x00080adc636061c1,0x0006244e403a263d,0x000ad04e1deab320,0x00059720dcbb6130,0x000d66e8505322a2,0x00060fb3f5231b1a,0x00049e1cd79b6e2a,0x0006179c366e663d,0x000c6ea0d01277eb,0x000473883c4ffde6,0x0000000000000001}, {0x00040167fca5210d,0x000d95aec71f687e,0x0001c63bde59a231,0x00074dfa4af79a44,0x00060fd79e68ddec,0x000b613ae2a19527,0x000036b08e61ca70,0x0003e30d2b549e73,0x0008fb383d922e0f,0x000aa028c146216d,0x0000000000000001}},
},
{   /* digit=71 [{1,2,3,..,}]*([2^284]*G)  */
    {{0x000090e2290855e3,0x000c63856faf70c3,0x000a537fff7cf9c3,0x00002007d0317a7a,0x00010dc853b3261c,0x0006ccdf2c616875,0x000385cd6f188d53,0x000a2955fa1d26fd,0x00087bdaef2d7d6e,0x000b0f3173148e30,0x0000000000000000}, {0x00084c9a254216ed,0x00047cc0770de6d7,0x00035e4c8fa4bf8c,0x0000f637aece660d,0x000adedb7b99e891,0x00082ce72b5ced4f,0x0001d4d0fa07446a,0x000194600c851570,0x0004ffcea4152f30,0x000c96f31c15edf3,0x0000000000000001}},
    {{0x0005b1c7831bdcc8,0x000d027bafc7d23f,0x00050c19efdbe5d1,0x0007a7533cdce225,0x000573af279d2535,0x0006015a5e144120,0x000803b571412097,0x000eb203384ac91c,0x000edd68012ba72d,0x00091d825c3d8d2b,0x0000000000000000}, {0x00023553a39f8385,0x0005b8eaf27fe164,0x000c4539fb7ef933,0x000adc9ffa5830e5,0x000950a5e503466b,0x0003a2a96a1dcbb8,0x0001a89a62dca0dd,0x0001d5f98db48a88,0x000554b9506e0a31,0x000dcd69efeec8e2,0x0000000000000001}},
    {{0x000b8cbe4b97fc6c,0x000e5a71915ba245,0x00044263935f5290,0x000ce189775a8de5,0x000cd0549c8def51,0x00027c89477b9645,0x00047cfbc54728e8,0x0000c7cb6412bf4c,0x00016bf97806ea22,0x000feea61b447d92,0x0000000000000000}, {0x000a3fafee06d0a1,0x00032a2cf4c624fa,0x000baceff4ee9dd4,0x0007411d429aa2e7,0x000d154759f7bffe,0x00091cde409d4d9c,0x000a9a31ac9508e0,0x000deb0f736891db,0x000c17f78c058b52,0x000b43e218c9736e,0x0000000000000001}},
    {{0x0000f4f238352945,0x000f07d445a023b0,0x000551441addd54c,0x00008f85e62fb5bf,0x000ffd275f3aa334,0x00001eb4ed1f4e87,0x0000af1b08c2f8d7,0x00093b5987facbec,0x000542336f0bc311,0x000587219a8c1237,0x0000000000000001}, {0x00052f04dae724bc,0x000e221a68b0a55d,0x0005bdff6f9d5fa5,0x0007e3f2da24e831,0x000628b43c649948,0x000a393f548cc549,0x000acee934d621cc,0x000e0ce12d1b52e8,0x0000b93c4f0e6025,0x00077116663ffdcb,0x0000000000000001}},
    {{0x000b53f717a44956,0x0002c65fee76e1bb,0x000ae70d2da363ec,0x000cd6887a61f9c3,0x0002283a4e23325b,0x000ae6d909c60aab,0x000702a1dcca3dd1,0x000938d6a31c5517,0x0003e01f167bc2d3,0x00067596be65d549,0x0000000000000000}, {0x0007978a4e132cb0,0x0005df10adf1702e,0x000364f7e05324c1,0x000693e3866569f8,0x00082e303b6c9df3,0x000298933d134854,0x0003d7696e64c215,0x0000f465322046cb,0x000e839e686c1c09,0x000b7f8ac2e6f682,0x0000000000000001}},
    {{0x000e71627b708629,0x00012bf54385d85d,0x0007bb4ab478b057,0x000a3b2ccc6b5489,0x000f67fa6f6a05a9,0x00073cd5233bfef8,0x000c4c4f505a80c7,0x0006a3fe8c185c9c,0x00059e110f37ae33,0x00054cb440dc7a62,0x0000000000000000}, {0x00050c98bc7b0e1e,0x0005a04b3793331e,0x0003b8d31034a8aa,0x000c95dac900df01,0x000fd52027ee1c99,0x000b5be3aeb891a1,0x00042f3b68574224,0x000ae00bb37d5ba8,0x000a7f31f3f36375,0x0008c304743a2813,0x0000000000000001}},
    {{0x000c7e03b7aa645a,0x00091f7e39a28977,0x000995d7d443d68e,0x0009f39216c442e1,0x000b376cc21c4025,0x000705644f75967c,0x000592e3b90bca20,0x00056be0ef613507,0x00097f2f7456e836,0x0004b46438409baf,0x0000000000000001}, {0x0005a21df85e1c6c,0x000b0ab454500393,0x0004c5912b476c6d,0x00065a0d1aa49d94,0x00059cdd7e7069d5,0x00090a402b7eeef8,0x000283db40b228bb,0x0005dcdf2c268733,0x0005a42d37d44810,0x000b80e5d1af0360,0x0000000000000000}},
    {{0x000c14cb537e819c,0x0005f2b3bf6b7569,0x000cc275187a0bac,0x000925ef6c2d559b,0x00025a54533380eb,0x00019f0d6cd0382a,0x0001433bbf74a021,0x000bbd994d4caf68,0x00027772c53999a9,0x0003af249226a38d,0x0000000000000001}, {0x0006a46b5b493127,0x000bee887c8f7779,0x00045dd063eabbf7,0x00029199a0a8e117,0x000918d22e28aea4,0x0000ecebe77e69a9,0x0007cecb0ed2deab,0x000637aa98d20edf,0x000a194790e52888,0x00060c73078fbd0c,0x0000000000000001}},
},
{   /* digit=72 [{1,2,3,..,}]*([2^288]*G)  */
    {{0x0009af391a8697ed,0x0007fe5bb7320546,0x00080d05ad03f5f9,0x000f9b7973b1a3ca,0x00033b52add9800a,0x0003cc487ccc82c5,0x000f71a0da2ae069,0x000c060c7047e46c,0x000a21503aeb64ab,0x0004ed0075b1d33a,0x0000000000000001}, {0x000a2bed91298551,0x0000c49a79f6b129,0x00022374a19da463,0x0001305962f001a1,0x000a3a3cc4dcc90a,0x000188b4cc026cef,0x0002ff30fbb1d3fb,0x000c36e3761cad09,0x000dbdbdc6354b93,0x000b2ab73317cff3,0x0000000000000000}},
    {{0x00003f3665635e4e,0x0004e17fd85da26c,0x00052fd006ed5f69,0x00032d252f043a61,0x0005c8bc9cc74510,0x000f5370ca9348d5,0x000540b56333c4c6,0x000bc9a5ca533610,0x000d8071b716d25c,0x0002367337f70a39,0x0000000000000001}, {0x000db6fc5387c11b,0x000cfd3251b14397,0x000d84aa2bfdb755,0x000e38100cc3e62a,0x000046071f1f89e9,0x000e7012d9e47fb1,0x000e6ad97ec5c7c3,0x000698bc4de4f6c7,0x0000c6a07a4e7cef,0x000198a03a3a1224,0x0000000000000000}},
    {{0x0003b8713123ec24,0x0000419a51d2d151,0x000c8ee7e2c9c855,0x00039f110d3d8f17,0x0008ce870e320ac3,0x0000d4e71030e599,0x000ace1a5cbbd4da,0x0007c15bfcfe41d9,0x000408b36096093d,0x0006b26a0c56d39a,0x0000000000000001}, {0x00035ac9181317f5,0x0008d46d26280ae2,0x0003c29370c4bff6,0x000addee48f7eaa2,0x00030f605627b203,0x0003e03ba6674883,0x000cdd81ae186660,0x000d8bc04a9667b4,0x000cbc45ee0c1b5b,0x0003d34e81dc5ff7,0x0000000000000000}},
    {{0x00063b161dddd94b,0x0003d7c93f0cc576,0x00022d6ac11071af,0x00012d84b9149bdc,0x00088e44e4632e63,0x000448cc8ec50d4c,0x000f89a6c85277ac,0x000e128700eabfe4,0x00042928ea38e5f2,0x000e293e261880b7,0x0000000000000000}, {0x00051028cc113b68,0x0001919b6a14e2fa,0x00082dfd5da09549,0x000ca662e13022a3,0x0002996fafc24233,0x00018dea4f505fe4,0x0005a2d96182166a,0x0000199ba55815ea,0x00077232622a4ac8,0x000311b13c3b8133,0x0000000000000001}},
    {{0x0008673adf41d204,0x000e2a0a390575d9,0x000dcb844f35fe0b,0x000b6f4f917550d3,0x000fc6ecf7285d09,0x000925f580342d9d,0x0008746022d9fb4c,0x0001b6b73d4bc619,0x0004aa1c30d7a3bb,0x00003bf32bccb3c5,0x0000000000000000}, {0x000783e73d6e9052,0x00006db6e57f7b8e,0x0005d1afd274f869,0x000318770758e016,0x000290175b314342,0x000e6d25df464413,0x000da9ee1f0d5093,0x000297855e553138,0x0007c7b64937a717,0x00057ccbf262664b,0x0000000000000001}},
    {{0x000d9056eeba30b5,0x000355a8c404c7b9,0x00039ffec5e11fca,0x000c3ac7b4f4c637,0x0001ace1869851e4,0x000e1816afc7de47,0x000d517fb7e6978f,0x00040e256f62bd56,0x0004bb4c53034a6f,0x000aa98eb4b9ad2d,0x0000000000000000}, {0x000fd2909662ab1d,0x000c55f8463596cd,0x000074f62f74b11c,0x0004dfc43f12c5ee,0x000ad69405653ae5,0x00089f1d6e4668a4,0x000187ca431697ab,0x000831cc4eed080d,0x0003a69f7d775edf,0x0004e434435eef6f,0x0000000000000000}},
    {{0x000a1403851eb93a,0x00085c9ae49b53f2,0x000926a512455b57,0x000ca729dbef4a6b,0x000b8440248e399a,0x000191c77a9a0e66,0x000873c8f27a8296,0x0005408861a08ed7,0x0002bbe9c5e3865f,0x0003549235be42ba,0x0000000000000001}, {0x000a46fbe3334020,0x000abf1524bdbc9e,0x000b376fa382ce55,0x00075b35cc1fb214,0x0000910d13b19369,0x000cf5d3212ad3b7,0x000c7e93b691b3bd,0x0001ba22d0312eb4,0x000285b3975e5da3,0x000c999e2ec96eee,0x0000000000000001}},
    {{0x0005bf15f46be575,0x000a1061cb09c821,0x000ae2de789e5912,0x000cecccd84851c6,0x00001b95ccd21d74,0x00032dddf26a2851,0x00049210122d3f6d,0x000f02c5d952db55,0x0004be99796a4aa1,0x0004078cde88aab2,0x0000000000000001}, {0x000d753b80855f9f,0x00078288aff9b92c,0x000f7cdce61cc49d,0x00048cc3dac4e445,0x000cb0ac2a937fad,0x0008c5bdda956fdf,0x000bb3e81841ce29,0x0005170e6c819f12,0x000efd73ecab58ad,0x0000f476a3a48130,0x0000000000000001}},
},
{   /* digit=73 [{1,2,3,..,}]*([2^292]*G)  */
    {{0x0004f332dc67a3c5,0x0003213d82a4383a,0x0000fc0621356af6,0x0004ca32ca05acfd,0x000c1e80103ea886,0x0009dd0ff4c2e9c7,0x0009d764c64b7589,0x000680c128a8c988,0x000fdb7cd881a125,0x000ec5f09f58ad77,0x0000000000000000}, {0x000ecd4f9cda86d6,0x000c4c41a633a8c6,0x000847c2f58ecb1f,0x0007b29592dae51a,0x0006e268f50e3a7d,0x000a27de2a3b5eef,0x0006d540d7a599e3,0x0000d01f9b571491,0x0005e52e5204fbca,0x0003d9eb48615c67,0x0000000000000000}},
    {{0x000d9eaa867420c4,0x0002f7f5caa2ddb0,0x000c31038c0ddc32,0x0001596a08fb4b57,0x000a6d9ca6980a65,0x00095c78a8ab32e2,0x000ba78e5808eeac,0x0004f5f9923d5a32,0x000ad1c8d3bbece3,0x0007098f8b845926,0x0000000000000001}, {0x000843645beef787,0x000fa28875d75316,0x000e13608c5a90e9,0x0005556eaf90c364,0x000dacc40e05857e,0x000c5012b59e332d,0x000230b2b76768f9,0x00032932d53c8a76,0x000999fbd573bdff,0x000840eee9300114,0x0000000000000001}},
    {{0x0002362363f6901a,0x000be66748446167,0x0005f5c47c0db36f,0x0002fbb39fb54024,0x000e344525a7871f,0x00071375bdbedf63,0x0000bd89f085fb8e,0x00001c59b6e647d5,0x0008031fa2f2ea43,0x000d9b58012b6657,0x0000000000000000}, {0x0003015fd48eca8d,0x00082cfde2151d47,0x000e4d908c99616e,0x00004977d4ec3b2f,0x000f513df9ad204a,0x000b66641e3ee923,0x0009df2175bb5d92,0x0004cdb5c3c90fcd,0x000de8809fac5725,0x000985c6981a627f,0x0000000000000001}},
    {{0x0001a0d912586411,0x0001b0d49fbe5702,0x000bb57b277de5b2,0x000a4b2d7291e7e7,0x0008c16da29ce1e6,0x0008f8b71f4426f8,0x000fbf76a6ebaff6,0x000cab510adb9995,0x0004b996a6ec18d2,0x0003bc3ce11f1f8d,0x0000000000000001}, {0x00004c4051321f3c,0x0003af34703d798e,0x000dd55e68b6b0a3,0x0007f09cb14161e8,0x0005357558d9c473,0x000d9a485a90c00b,0x000dac2508e73fc9,0x000ed252e5f5bb09,0x000b1efcb4ba2132,0x000593c58bf23933,0x0000000000000001}},
    {{0x000d1217cba9c6d8,0x00087cb7a562f7c7,0x00004fa0d0ea0e23,0x000c05e3acd8379e,0x0006d159e80cdee0,0x000029ffd63834d6,0x000500f3ee777b61,0x0007b75be130d659,0x0003756de768a261,0x000a541b809584c6,0x0000000000000001}, {0x000af54a67204972,0x00085857b547d484,0x000954a25746036a,0x000bc1881e0295bb,0x000d3d231831b4de,0x00002708fd517190,0x000b1e9571812770,0x000c3e25dfa6c88c,0x000fb3c57a9f5467,0x0001d404949d8103,0x0000000000000001}},
    {{0x000a34fad1eabbbf,0x000de71fa7ad8210,0x000d67acfecf1047,0x0005ec7ec527279f,0x0007906ba2abc3a7,0x00066a25ce54f7d9,0x0001e7d558ddfb44,0x000ba77bccd91efa,0x0005405027796dc3,0x00072f9ae8e511f6,0x0000000000000000}, {0x000feaa4cfcc2a79,0x000d60cf749b854d,0x000ac1632a7218b2,0x000a7ce21f4e0ce3,0x000550325628caf5,0x0006b7d84c8e6b8a,0x00081d8e5bd9a461,0x000bb7affd9d5730,0x000dca775afff520,0x0006a52e629d73fb,0x0000000000000000}},
    {{0x0008f6b8297fa26e,0x000d76f386ac99ac,0x000ce235f3a2acb0,0x000620801a076df3,0x000c62031f455ef8,0x000d6e488b1627c3,0x0008ebc5bf3c9afb,0x000c4512c254ea59,0x000abb87bcef237d,0x000cb4dcacb5a5ed,0x0000000000000001}, {0x0008e7718ef189e7,0x0004207cf70cc015,0x000e9a66810fd747,0x000d69bb7c99d1b5,0x000454409a3962cd,0x00014e1d3b541825,0x0008bec33aca5afe,0x000a9c5e4a92268e,0x000bf2e95060a307,0x00093a289c336375,0x0000000000000001}},
    {{0x000781a84aba36d2,0x000ad7584291d55b,0x000992c0a266ea73,0x000e02af20e9954c,0x000ca4d73d175169,0x0001612ee12718e0,0x000cf1ded50926de,0x0008c1060d91c638,0x0007dc332b5998df,0x0002624eb7dc884b,0x0000000000000000}, {0x0008eae21aadf4bc,0x0005c2a9f4bf2cd7,0x00086c74c6b37272,0x000a4de4b5b5158f,0x00093ba4800d6736,0x000138590e451f46,0x000263ed2239cb95,0x000545bdc4c56f5d,0x0006676d4c0f8acf,0x0004038bbd0743d0,0x0000000000000001}},
},
{   /* digit=74 [{1,2,3,..,}]*([2^296]*G)  */
    {{0x0004fe80d04c169d,0x0001452da244cb71,0x000cda8b72206f04,0x0005887084ee9fa6,0x000920e111da7c3d,0x0003bb35ef1c2673,0x0008e61906e57c45,0x00073eebaa206a85,0x000dd3b5bf458238,0x00015dcf71c4a720,0x0000000000000001}, {0x000605cdd81e2955,0x000ac0e98756fb91,0x000f0286c4ccda7a,0x00017819b4372718,0x00031dae0a5d8a40,0x000720f8cb219351,0x0003217261dafa40,0x00006fb18c8c40e0,0x0003c7d483485194,0x000d46e02770cacd,0x0000000000000001}},
    {{0x000b16ebe5676f0c,0x0006e7f47e5b4652,0x00071c81701e6ae3,0x0007f8d6e3a4cc33,0x00067b29431c31ae,0x000869125faeb29c,0x000fd62e16be2afb,0x0004934ce6d0052c,0x000cd74901063882,0x0002e62b021800e1,0x0000000000000001}, {0x000a39e3523a9de5,0x00076121f34b3253,0x000d9c36b4aaa3b5,0x000b23992e0442ed,0x00023d2725144419,0x000ced8d6e4d3747,0x00011186d58a7080,0x00050cd63ed11b1f,0x000c6faa6d7a4d0b,0x0002559c897561f4,0x0000000000000001}},
    {{0x000657d806465325,0x00095fd29c362706,0x000e70b9e028365a,0x000fa40d084d6b18,0x0009d80bbbcfec68,0x000a06728aae56df,0x000361eb62533738,0x000dc77e1c92bd4a,0x0004fbeefd3c11b1,0x000cfba52dffafa9,0x0000000000000000}, {0x0009acb1f00a47f4,0x000024e668d3f2f1,0x000095d2d5d23cbf,0x00076b697f105b84,0x000da5b550d7489f,0x000c9d3a15e73345,0x00093e0d2b26a8fb,0x0001e4494adfd6a2,0x0008e6417e038745,0x000fb0b051833181,0x0000000000000001}},
    {{0x00013685fee3f167,0x00059193a123f397,0x000f28bae616ef5a,0x000d2c6567b33050,0x0004dae5b6596da7,0x000481adbd59fc9e,0x0002c1618dde4a40,0x0001f2a194682fe9,0x000c05bc15adc043,0x00013edb30fcceea,0x0000000000000001}, {0x00047d7a2900c6ea,0x000e954cf35b8dee,0x00074908606c425e,0x00094a88cdac359e,0x000fbef2c858622c,0x000d0f745810d20b,0x00041d71ca77f658,0x000782f59f1e4267,0x0004af36c640314c,0x000e35ec0709c829,0x0000000000000001}},
    {{0x000c5c739f094c18,0x000b75fcd89a8d55,0x00071a4d047c0dcd,0x000ef9a3d498ccfb,0x0008f669e7edb8ba,0x0008d6b13c20d8ae,0x000a564d16a48c79,0x000250d241703f4c,0x000680ef9509f9dc,0x000970b2c17a388c,0x0000000000000000}, {0x000778808942861e,0x0009abe8d8d33c23,0x0009bd2fb189dd26,0x000112581e8769b1,0x0009d657bacd662b,0x00084fbcaa8521c1,0x00091c546adc05d5,0x000c68fad3f4e938,0x00057bce78617aeb,0x000701e39a422608,0x0000000000000000}},
    {{0x000d79f624f8eb1a,0x0008e9c5d103b9cf,0x00071b65a5829554,0x00034991b8462f3d,0x000b51453c2b2409,0x000cf62fb341c087,0x0006cdb37eea50d1,0x00027ada571b02ab,0x0009e677d1b49b69,0x000004b52dc4d6da,0x0000000000000001}, {0x00042f171b839d5a,0x000765b6cceda32e,0x00009960889dbcc6,0x00040e8e2e336d9f,0x0001f34cefd7de54,0x0008bc6b5ab410a8,0x0000cbb91782d60d,0x000a95e22f3046d8,0x000775cf7c99291e,0x000282ca473be09e,0x0000000000000001}},
    {{0x000b6a03ba3e1ec6,0x0006b7fefa851ec2,0x0003a92f6680a7bf,0x00075deabf4905c0,0x00096ff483a6ae8a,0x000c163b2b784673,0x000be098999b6fbd,0x0009c4a535388968,0x000b8e919419a12c,0x000b0bd87c889640,0x0000000000000000}, {0x000f69e3681b9e47,0x0008fc5971b3c868,0x000bd601db453ea0,0x000aee960ff01a96,0x000a0347158b6a72,0x0008994151ef1dc3,0x0007de4b70d9ea4c,0x0005a29068423993,0x000e4276c73a1788,0x0008a834f8bee71a,0x0000000000000001}},
    {{0x00059366b70a0b8b,0x000d60abadb72457,0x00087caf5b975b84,0x000cc3f1983f793d,0x0002e94d8de541ce,0x00090b687cd8885c,0x0006b6cd952f2acf,0x000016cc05b6d504,0x000f97cdb266e5bb,0x0007c95959c78452,0x0000000000000000}, {0x0001e70e0efd1f63,0x000528c8989bfc93,0x000c244410e36663,0x000645d5f14f2667,0x0008cf8059cc8bca,0x000d2134f71c94e0,0x000ba7b1d1a84e91,0x000e21c35b983489,0x00003bfc5dddbab1,0x00099886156a8fa3,0x0000000000000000}},
},
{   /* digit=75 [{1,2,3,..,}]*([2^300]*G)  */
    {{0x00083fd796b1a72b,0x000c549640b910ec,0x0001f3c076c5166d,0x000b7e4e553ff932,0x000e97e2f7e676d2,0x000a2cdad5097c11,0x0004bc0c5cedff5a,0x000757d09eef397f,0x0007434958d95f66,0x0004eee32eada9e7,0x0000000000000001}, {0x00041f85b3f06836,0x0003aba0e3496ce6,0x0007931548ea6b77,0x000149273aecbf5b,0x0001858c42c5d2ef,0x000ddc70d91528b8,0x0008d341c157c1ef,0x000a690e10df0a32,0x00064f5d30760fd8,0x0000d14ec3b44ea3,0x0000000000000001}},
    {{0x00087f011572bb6c,0x0000d126f1e48db1,0x0000d05c4b7b6201,0x000a2ba1e0fbe5e8,0x0000224d802f13f0,0x000e0b8698189e96,0x0001b4bc0b8af43d,0x000c706b742b2859,0x000d9196336bf7ae,0x00007fec0d2fd363,0x0000000000000001}, {0x0000b0b6ce7179b1,0x0007cde982e3e244,0x000d814a6fad99d6,0x0007d3497edfbb4d,0x0007a46c6afc84ac,0x0004cd907a63bbd7,0x000909a18bcc3d68,0x000d756b5193f098,0x000f37ab5d6e0581,0x000ffb06adf4d102,0x0000000000000001}},
    {{0x0000415e4f4b1ce2,0x0002f16bd8544ce9,0x0003e7600d6c664d,0x000d9aa401912f05,0x000dd3e0c268e1e8,0x000f14013443dcda,0x000f59cbf936e212,0x0004b8aaec39252c,0x000d652c200b8cef,0x0000aac64c11e47e,0x0000000000000001}, {0x000c08e2e7a2dfe0,0x00048459176893a7,0x000c7c5a8f0afe8a,0x000e999b6f043d0d,0x00000b3c3cfd6e33,0x000b4fbc5e2a496c,0x000f5eee2690de5c,0x00073d2db4511dfa,0x000fecdd2743e927,0x0004f4ade6a1948b,0x0000000000000001}},
    {{0x000039609cadf211,0x000339488fdf258d,0x0000e39945a1e037,0x0009a8444d16fa60,0x000c454408c23f53,0x000ef729fbf7f8cc,0x0001fe369b8abc6b,0x00053dbd87a47666,0x0000f6266a890341,0x000de3c7b4bcd279,0x0000000000000000}, {0x00006e205ec9aa47,0x00063cce1af477a4,0x000f7fcf64572e77,0x000c931743d00999,0x0003902adccdc1f7,0x00041be26f8b87a1,0x00006779ffcb96f5,0x0001c0636264bb59,0x000484331c0db1d6,0x00076e5585c8ae19,0x0000000000000001}},
    {{0x0005899b377cc15c,0x000f315fff92e2e8,0x000a8cf599eb4a44,0x0002e4cfca1a3e87,0x0003f205f34e217a,0x0009eb1362e4f28f,0x00061c84aa7c205e,0x0006fa76515b6ace,0x00083aca37e55058,0x00030435e870f8ec,0x0000000000000000}, {0x00002203ed113de7,0x000655318327d42e,0x0005d903904004d9,0x00094adb7cd1d2f1,0x000ebca1242c89d2,0x000af2a1423b5bb4,0x00066f393818e824,0x00079a30444115e3,0x000183b2cd6a53de,0x00047bfd324d8249,0x0000000000000001}},
    {{0x0001ee196db2cf29,0x000718a1d049034d,0x000acaf386ae53d6,0x00006d746605e4e6,0x000c4458e136fcc3,0x000b7a1ac677dc40,0x0006ee4bb331955a,0x0007b95c386ed47f,0x0006640fb4384103,0x00081000a37bb752,0x0000000000000001}, {0x0008cc55b8f1bcdb,0x00025171d84cd78b,0x0001b8eb12ee7e03,0x000bd8c564c45f59,0x00076c2283df12d7,0x0008a36461b03bfc,0x0000c8cafd6fc812,0x000ae72b6275a058,0x000438282511c376,0x0008780ca3213fce,0x0000000000000000}},
    {{0x0002c0f6f353cadb,0x00056c17179cb81e,0x000af140db008101,0x0001bb5e63cd1fa8,0x000b0729533d8217,0x0006676827544c77,0x000fe1b0143af56f,0x00045a759df2599e,0x000962b593accffd,0x0007a3c61321e555,0x0000000000000001}, {0x000e58a6aa5358dc,0x000739bb4d42d566,0x000e6ef3760e0cfd,0x0004fb370620ef46,0x000c2253e0f9e680,0x000b5c8c64f4e9cd,0x00008daec6f6658c,0x000504153037a80d,0x000215b47cc959be,0x000e4e7aaaa8653d,0x0000000000000000}},
    {{0x0002bc233166381e,0x0000199700029af5,0x0003201dddf2a837,0x00085cdad02e2c74,0x0006daea6cd36d88,0x000c3f784e7e3512,0x000e882fa40cea6b,0x0001eec16a3a5130,0x000c43706ace2f12,0x0009ccf3c3a16a13,0x0000000000000000}, {0x00064823f9e7a6c2,0x0007bae8e4729ac9,0x0003fe54edfeed8d,0x000a4e7bcfba42bd,0x00039e917bf88ec6,0x00004163c606be20,0x00009b017d5a63a6,0x000c276869bd6bdf,0x00094144ff021410,0x000a13f038cdd94b,0x0000000000000000}},
},
{   /* digit=76 [{1,2,3,..,}]*([2^304]*G)  */
    {{0x0002f8bd1741a941,0x000d4f3177637189,0x00060a2c8b16c0b1,0x00012ea49a688a19,0x0004556eef3eca0d,0x0000c833814746c3,0x0008d8b842db71e9,0x000b1bf4ae9e3fdb,0x0000ee706bc576b9,0x00054e85a8de649e,0x0000000000000000}, {0x00032799b9f19edf,0x000975259805923c,0x00076f95241c4760,0x000d3b18d6c8d637,0x000fa677dee0ddd3,0x0002ad9334e5bcea,0x000ceb27ca464781,0x000594d56dac3990,0x000338deb39d6e55,0x00096c7a9d83d78e,0x0000000000000001}},
    {{0x000d7b49014b2147,0x000f134215e0ae52,0x00084df8cb33a781,0x000b10bfaf858985,0x00065449e13a9c3a,0x000859368bea1a4d,0x000d78c2c8134dfb,0x000ba7d94439b51f,0x0003f1c754b1e6f5,0x000d464cf5d47b00,0x0000000000000000}, {0x000c286403cdb3ba,0x000c15d6597a8e6d,0x000e5e853fbe3d2a,0x0004c9898bd192da,0x0003c76032d13f80,0x00038d5e8bdb66ee,0x0007ea1349bcb167,0x0001e4001679e16c,0x000f1f584d22ec20,0x0007b7d9f317a982,0x0000000000000001}},
    {{0x000196d862941c7f,0x00015fd4c9380d4d,0x0000a23a9cf4968a,0x00039223ad85ace8,0x000b20fbe77f6374,0x0003ae3be886de7e,0x000a36dd5eea175a,0x00061d0a78e19da4,0x000a64f9638a5733,0x00007bdb82dd1f3a,0x0000000000000000}, {0x0007fe74ebe49201,0x000a7702be0b4d0b,0x0000cad19bf2f6ec,0x000d6c0b5b514f13,0x000c08518708375c,0x00035c8f337b8d0b,0x00055fc06adb3974,0x00083bfc4b137fa3,0x00045b3d91207a07,0x0009d53cd23a6fdf,0x0000000000000000}},
    {{0x0000a67f092fe026,0x000e142efbca10ec,0x000cc433a343767e,0x000f6b9e68131944,0x000e836fcc884370,0x0005328231b4d1b5,0x000895d85b956e68,0x000117afd7ce3e4b,0x00028a48e23cd96a,0x0007756cbf1cc4fc,0x0000000000000001}, {0x000c45bb98d0ddee,0x0002774201b8565c,0x000b4f52020bec2c,0x000bda65cd76ab62,0x000ae2fb221ac3aa,0x0007ba962fd348e9,0x000e7c381d5e875b,0x00068ae119edacdd,0x000b495d57186eb9,0x00056fdf795bd0d5,0x0000000000000001}},
    {{0x0003ca5ab59ddb41,0x000f7f1ebc9c6cc7,0x000f57e85f634cbe,0x0005a16eddf122c7,0x000c8a63efc695ac,0x0003541555a07f9c,0x0002a4d80e98783f,0x0006230998aabf3c,0x0008cb24667129fc,0x0002de1b3b8ba86c,0x0000000000000000}, {0x00062aec0af56692,0x0007719a7045c1fc,0x0005b9718436f251,0x000c9b5d581f4e26,0x00069b5489f5725c,0x00051e7c1aa8e91e,0x00028ec256fe93ea,0x000487a680376ebe,0x00030e63df392cad,0x0009887cd96ae342,0x0000000000000001}},
    {{0x000e42367a9d725f,0x00039383477d80ab,0x0009bf84781ae655,0x000527eaf1389d3f,0x0004102ffac6350d,0x000a3b0583300052,0x0001cf3332af83e5,0x0006d633aac030a5,0x00033508c7e87b5f,0x00094e54cf554461,0x0000000000000000}, {0x000f352ebddfa61b,0x00025e3d5e304a79,0x000673478bec8a85,0x00072acfcd082890,0x000446528a7ef652,0x000120a7a607746b,0x000c8aaaa126f2d6,0x000e0714c411ed8d,0x000219322242ecc1,0x00076f4dd29b9909,0x0000000000000001}},
    {{0x000c19050d8003bd,0x0000966c18887790,0x000653ed598ed239,0x000bbd18179a89ab,0x00050e32e18d6ebb,0x0003a242275a6e33,0x000cf9fda141c240,0x000cba7fbc6f732a,0x0007d9042bdcaed5,0x0004cddd17f09749,0x0000000000000000}, {0x000dc494bed8e1aa,0x00072f9b4efbdcb4,0x000846e40ceacaf0,0x0008e7a08c964b79,0x000b697992c6dba0,0x000a31236d2a3b33,0x000f13c67e503cfa,0x000758371b2297ad,0x000a30fe4d1b0d5b,0x000937f2f3ba13a0,0x0000000000000000}},
    {{0x0001e3e792f54f5e,0x0002d66e1c349e9d,0x000411c782a7cb86,0x0004b067774f6f73,0x000f3d88b7029f91,0x0008ac9342be145f,0x000fba10730a2fc6,0x00017ace014c77dc,0x0006ebecfe34f062,0x000f04b7a85b9087,0x0000000000000001}, {0x000e45d39d99da4a,0x0006122af68cfe2b,0x000beab553aeda14,0x000338ecc8cf47bb,0x0007a9f26575d185,0x000dafc93ebcf570,0x0006b569b4f26152,0x000a1c5170968500,0x00059575a58e4408,0x000d43a451b6b327,0x0000000000000000}},
},
{   /* digit=77 [{1,2,3,..,}]*([2^308]*G)  */
    {{0x00031eea8652aa77,0x00075a9b33eda2b8,0x000ccb42fd2dd1ac,0x0005ab8fe55769fc,0x000ee2ea2c9e4a86,0x0008effb93c60208,0x0001522321dff3f2,0x000e5124fb782d6b,0x000f961e96e29dc3,0x000a6d2f39193c4c,0x0000000000000001}, {0x0005e63b7e317479,0x0009d667da851f03,0x0007183aa797e9f3,0x00059f9fe886c75f,0x000d96d9e68574aa,0x000ee25277706045,0x000aa94b18ceb8f2,0x000d5bc3971ae4bc,0x0007b608157fc8f0,0x000150dd6428487b,0x0000000000000000}},
    {{0x0003f45b89aa7776,0x00091f2af99e2d25,0x00076414d1e112b4,0x000800014a8e2b12,0x000ffa17691a71c3,0x000bd4233ab0f6f9,0x000bd49cf4e764a4,0x0004012735f0ccb8,0x000037d3dc7fc071,0x000ae03da811ddf6,0x0000000000000000}, {0x0004a8fb960d3228,0x00048eb39e1a42f2,0x00007ea05b5a3c40,0x000b7bd9d581bb93,0x0008feeb6ce36fa0,0x0000329bb28b7b8d,0x000e608fcc8cab6a,0x000504c03b085c44,0x000593cce3f2c4c9,0x00093bb2ef5a3d51,0x0000000000000001}},
    {{0x0005eee4a29b9e00,0x000dc20740482d3d,0x000e9ca5a465e210,0x000dbcf9b04be3f8,0x000cf79a10d11c21,0x00098890d16c757a,0x000df4eccacfdb2e,0x000f11b8ece9836e,0x000bc4d7a9a35695,0x0009ee2c9b7d003b,0x0000000000000000}, {0x000e2dd26ff13203,0x000133cc51c6bc72,0x0009ca679c2a2da6,0x000951011dc4426e,0x00093bedba6ea308,0x00088d9217c2a099,0x0000e9979694eb83,0x000d521e97150620,0x000035d356c66be4,0x000161e2cef90abf,0x0000000000000001}},
    {{0x0002a5d7a2fe5424,0x000c5abd77fdcc05,0x0007ae8084591e67,0x0006481030c17511,0x0001f92e55b534fb,0x0006bd1eba6c21b3,0x00096514d056aef9,0x000df597cfd93bd8,0x000c4de2939ce9f5,0x0004ef6737cbaf10,0x0000000000000001}, {0x0006ccf17f5b4aa6,0x00049ba070d7b272,0x00033084cb0ef8a2,0x00018fa7fece71d7,0x000e7f11b328ddbf,0x000b8c5b898e7f8f,0x000699bc5842d33d,0x000944b7141938ef,0x00039a13d619477d,0x000d5228db36f5cd,0x0000000000000001}},
    {{0x000b8747f420dd4b,0x000fb52bb177eca6,0x000f43dcaa9b6760,0x0007a3f15a0ec05a,0x000736800fc5d305,0x000bb74572a151d8,0x00065a96cf22ff7d,0x00019519394cd42f,0x0008227699f90840,0x00068419e24fe2e2,0x0000000000000000}, {0x00025578363927ed,0x000574db66d688d6,0x000d409ddc1459fb,0x0007f82b70d69f87,0x000cb67c0931340b,0x000a17e9ba495398,0x00095f5bb6fc86af,0x000372330a201b0b,0x0002bfb684331f96,0x000759b31f0fa4ba,0x0000000000000001}},
    {{0x0008a9686e50ea9a,0x000fa53caf16bb29,0x0001e6775d854b08,0x00037450aecb3742,0x000a7e3971ac67a8,0x000916720ee3a053,0x0007ef527af5a2ad,0x0008c78907d26a51,0x0000187ff88dddeb,0x000580501085ffc1,0x0000000000000000}, {0x000bd54c631b5ef7,0x0000a533ff81bdf1,0x0000234fa962cf5c,0x000a7f99121d8411,0x0004d769fb90a1f3,0x0005f3f42e621b7c,0x0007e5f02655798a,0x000d995fc9fe9a95,0x000560ed712fc645,0x00059000f20fc194,0x0000000000000001}},
    {{0x000ca8aff309b100,0x0000c85dcacc4c44,0x000282732cee9318,0x000efc73a9f020ed,0x00070ac2ec46ccda,0x0004edd612a22d61,0x000fb7673b4cf6d2,0x0000510828deb00f,0x000a061d4c49e843,0x00016c8aea6c342b,0x0000000000000000}, {0x000ffaa28b87e79b,0x0001bb9617a5663f,0x00097f1ba9e99062,0x0002ee20742a4b1f,0x0000500e34cdf43b,0x0002b6de4ad6c0ab,0x00002eba08ef6f81,0x0004e0bbfd3a6364,0x00094460899a3582,0x0008335d3e07b17d,0x0000000000000001}},
    {{0x0005a71e395d239e,0x00026a160db974ae,0x0004df55ba5b2671,0x00091fe0f2bfd214,0x00027e4215d39cf2,0x000849498b3dc0a6,0x0000c7dfec311ed8,0x00029fbb50995b22,0x0005f9ca4a3d83cc,0x00085332f62dd6c5,0x0000000000000001}, {0x0003278db69ec48f,0x000c56caebf5d4e7,0x000e4ab979b38b01,0x00005e1e7e210f66,0x000e800e35bf7fe3,0x00041625bdbbd247,0x000140764eabbcaf,0x000ae49d3fb6b3c0,0x000bed09dc31a840,0x00044a6c67185e6e,0x0000000000000000}},
},
{   /* digit=78 [{1,2,3,..,}]*([2^312]*G)  */
    {{0x000976185cedb78e,0x00000d5ac29ab973,0x0005376ef5010492,0x000fcfdeb7cabe96,0x000e82ebeaa6eb29,0x000856863e849702,0x0002b7dd5820c1d9,0x00080b85b8b6adb3,0x000cc2bebcb2a1da,0x0001cb911240a24e,0x0000000000000001}, {0x0009339d66471f42,0x00086865738f288e,0x000ec9ab31ac9389,0x0006dfc0b78b477c,0x000d22531d4c9b75,0x000957b1f72bea7b,0x000f90819668750a,0x000023544082b7ac,0x00010dd35fa97aa9,0x0000657c9376d4d3,0x0000000000000001}},
    {{0x000d393a7e12c9a1,0x00087315af1e7695,0x0005dad48c909f6c,0x00065a7e168b010a,0x00026d86fdc5603c,0x0008f52d5373f51c,0x000a497697c8b7d8,0x0006670982debc64,0x0009f942aaf7a067,0x0000beb15cc57a80,0x0000000000000000}, {0x000728397fd456a4,0x000c8ff5563ef971,0x0004e73a2dd305f3,0x000cc516a80ae4a1,0x000352258160b828,0x00008533e6e74db7,0x000028314ad68011,0x0007541598a03b32,0x000c3d815763ab10,0x000089f632644f56,0x0000000000000001}},
    {{0x00096953520ee092,0x000306d200f67521,0x0008a20dfb41aa95,0x000ecbdc450070d5,0x00044a73c2aa2e56,0x000cf15e09936979,0x00039822bf1cc5f8,0x000ba98dee98b81e,0x00049763f39d2614,0x000dce88bf80d042,0x0000000000000001}, {0x00090be494194f3d,0x00009eeb5f7526ea,0x00042892f629d76e,0x000de6b9665e7661,0x000e4db45bef0dd2,0x000f0c29ede66edd,0x000cdcbd947a3fe0,0x0009dc0bb66739bc,0x000aa185f9760092,0x000d98f355b62fee,0x0000000000000000}},
    {{0x00095d178d8fc8db,0x00088ab909e6143a,0x00089b7600c18603,0x0000f4aa942112c1,0x0008b5a1967f7a08,0x0003543a0e5057c0,0x000cafbf9ac78fd1,0x00049408a20a1598,0x000b58bcdfa7974b,0x00036217ad4e198f,0x0000000000000000}, {0x000138c5bd603cb6,0x00072af896026457,0x000ea9d78b2185f1,0x000482318652917b,0x0008b9b757159621,0x000f2c7ae3b7470a,0x000d10f532d77474,0x000d6b40b8bfc96f,0x0004da23277081db,0x0005192cd44f13a5,0x0000000000000001}},
    {{0x000210b018203491,0x00081f7f56d37ef1,0x0003499eb28c2bde,0x000d16d800ddf3bd,0x0001a8ad11d2638e,0x00081f6ac5a19953,0x00073cbdac06d819,0x00089e5df343701d,0x00080e56132b9d88,0x0008f82b847a3187,0x0000000000000001}, {0x000ae2fb5a3b782f,0x000dfec66b9766a4,0x0003802b7f84c2ba,0x0002adc75633f423,0x0009ba300fd1c729,0x000a85bdc16e7491,0x000bea7ecdc049f9,0x0008cba7fd0e8182,0x000a5a9aa8bce3aa,0x00008a0977d90d48,0x0000000000000000}},
    {{0x000ee51072d71e54,0x000e9e2a68ca9bef,0x000a9707bfc11ef4,0x000ae91635e6d8f0,0x000dd87435cc0e00,0x0002d6a89b217b9e,0x000c5bada1452b8b,0x000d602de29b175c,0x0003f43b9bd73fb3,0x0000724373642133,0x0000000000000000}, {0x0002c3dc04031002,0x000c73ba54808162,0x00084fe7d46fa018,0x000e61eb44ff91a6,0x000448f89778fb3a,0x000d0dc5c96379eb,0x000f26ee0588d9eb,0x000aafd623f750bb,0x000b6e0aafb4a855,0x000ab06c0e1eab53,0x0000000000000001}},
    {{0x0001292993c3f0c9,0x0009243ce8e0477f,0x00002cd6d125a6a7,0x000424b8f8d2f4dd,0x0000e036966f98b0,0x000b28d9609c6ed4,0x0006f54dde908ae8,0x0001261395876628,0x0001a89f477ea392,0x000b89a6253dab22,0x0000000000000001}, {0x0000776cda9e2906,0x0004dd51a83a13fd,0x00024cb69c0833d7,0x000afa9f2d0d7515,0x000d5068104d274c,0x000b1536c256cfc3,0x00005c2c5a3bb4ea,0x000e695b252297e0,0x000674ad5032178b,0x0007afaaac5118a0,0x0000000000000000}},
    {{0x000b5f87444140a9,0x00070937761e89c1,0x000052402d8c768e,0x000e0d8fa7063fcc,0x000065032ca28437,0x0000560b81d70497,0x000a63bfcc5af72e,0x0007abb68cfddac1,0x0007b3b85e89f391,0x000e3880d7454a25,0x0000000000000001}, {0x0001d4cbebc9cca5,0x00014fe965181800,0x00064d65a9766b10,0x000646ec511b3639,0x000cc26e7c4e0d56,0x00094ae11adfae8d,0x0001a6886e8d406a,0x000547bbf4ad6e9a,0x000e8901b3004a68,0x000c8d5981c48013,0x0000000000000001}},
},
{   /* digit=79 [{1,2,3,..,}]*([2^316]*G)  */
    {{0x0003223ffb7f0034,0x00056eeed01f7ec6,0x000a95759d3b10c6,0x0008fe9fc8ceacdd,0x00036b6ab8ec35f6,0x0008c0b21550e979,0x0008e1de4ccc3b92,0x0007fc6be17e92be,0x0001bdb6320828c7,0x0009d213352a78b8,0x0000000000000001}, {0x0009b3c1ecfa9e13,0x000b3a0b5daa423d,0x0006bf95aa594567,0x000fbfb5a3d149d4,0x0003d4e9979588d0,0x0001e08ca45e636b,0x0005c358fa3b11bc,0x0003552e11b17364,0x000b67bc8931ab99,0x0002d3ce614c5f0d,0x0000000000000000}},
    {{0x000ed714844f3544,0x000cc4bb9010843a,0x000996ac0026321b,0x0003453553c74ad5,0x00041741982c7cb6,0x000196d8fedc48a0,0x00020d244c9f0921,0x00070a8fce97fabc,0x000a6d44732828d2,0x00060bcab0c77562,0x0000000000000001}, {0x00061da3943969d2,0x000d674b749d7b3a,0x0009df6dae1fb5b6,0x00005c30ec275083,0x000ae7da1a9284fd,0x000c82a28eb7bd6d,0x000a71d66cd19bae,0x0002d599b2c6a08c,0x000faa1546c312c5,0x0007f06795e3065b,0x0000000000000001}},
    {{0x000fff9188aa7d8c,0x000deb80ad064a0a,0x0007114ab9689af5,0x000fad0b4dbde778,0x00055fd29cd3c099,0x000d379d42525d60,0x00016d04df50e85b,0x00053602e006dfc1,0x000e6c63f374d96b,0x0000f26509a7f32e,0x0000000000000000}, {0x000822c176aa9790,0x000f58fc039cb1ee,0x0005872cad56c2fd,0x000e8ae0ea665324,0x0004daf2e64bf3b9,0x0008f96bb4b8314c,0x00090e063c57f41a,0x000d5149d3063df9,0x000ba61281d5f9b0,0x0004ba3d6cc9c608,0x0000000000000000}},
    {{0x0005d4a76da49005,0x000c3b224e91125c,0x00062ab184a74621,0x000b682a17406495,0x00053c3f7c8cdedf,0x0008e38d4416ae20,0x0009c28df044060d,0x000f86143e5739ed,0x00095f9f7f327b97,0x000872538531478b,0x0000000000000000}, {0x000b98e468155010,0x0001fc05661b3943,0x0009ee23198c1bcc,0x000744fc64ff1647,0x000560f20d871115,0x0002c9feeacdf5ac,0x00070b263cba9c39,0x000badbac8fda72f,0x0001aad35365c71d,0x0002f99d51687d17,0x0000000000000000}},
    {{0x000acd4ec9302acf,0x00046876812a6969,0x00062f921abd47ef,0x00030834c8ee3434,0x00087c08c033bb79,0x000e51d0a2369c3e,0x000c1fbd98cac8fe,0x0006a309b704c675,0x000a173a43fcbb3c,0x00009432c4949569,0x0000000000000000}, {0x0005e781f2ef36de,0x000e3479bd3a702b,0x000d74e86eb68837,0x0003849622881aa5,0x000ba91b89a84ecb,0x000caeee87dd2964,0x0000f40b0230b757,0x000e7853cadc83a1,0x0005f5ad1465657a,0x000e75100e5033e4,0x0000000000000000}},
    {{0x000e44f3911651e4,0x00088f7f22b492d2,0x00072f850dbf1662,0x0003ab2a45a14853,0x000e1480b82ee674,0x000ca609c8235a84,0x00085d8422668b9b,0x000a5d6f0bf02f4e,0x000afb880792321d,0x000cb82c095f0261,0x0000000000000000}, {0x000bc2f5725cea9c,0x000e1f43f99381e6,0x000e6089c844a832,0x00000aa951ad7011,0x000282a695207656,0x00007e689c114477,0x0000e537bb9a4c6a,0x0009df06eaf0cd7b,0x0007c474d7895232,0x000f0710d2b00b77,0x0000000000000001}},
    {{0x00093c8e0aebae92,0x0001a4248ef98180,0x0005353d71384b97,0x000564228ab8dd10,0x000ee9e95615cf3f,0x000dbed91f163427,0x000ff8c7cd8d83e1,0x00002a117b26a05b,0x000d651309094b7c,0x0005fa8d73f3a728,0x0000000000000001}, {0x00045cf4f3fc6c29,0x00069a5dd01b3bfb,0x000e3b24278a983b,0x000ba6e8dda15e64,0x0007ceabdafeb0be,0x00028dd1f4ce3cbe,0x00083c003c3a01ee,0x0004286b68f03154,0x0003661bd44cc13c,0x0006d7a5a2b18a65,0x0000000000000001}},
    {{0x000f4f2d2f859a83,0x000584cf466ff03e,0x00078dc82b847044,0x000110dcb52d320e,0x0007adfe140d78b5,0x000b45fd46e07b11,0x000943939af65810,0x000f26b6d5c5bda1,0x00091095a8309f53,0x0000d4aad23c7d80,0x0000000000000000}, {0x000dd82bca9e7ca1,0x0001551ee78b6090,0x000453fc776839c5,0x0001d0262966b875,0x000729e2a29966bf,0x0008c49cfc825d3c,0x00009961345ab1d4,0x00007e6049f3ad60,0x000007da4f1b3985,0x000c382c8f36cb0b,0x0000000000000000}},
},
{   /* digit=80 [{1,2,3,..,}]*([2^320]*G)  */
    {{0x000a284c690646dd,0x0003eedcd5cc91eb,0x000ea471fd6292fa,0x00023a125841cc32,0x0002e35810a749fb,0x00061336484e18eb,0x000b6f65228a2bfd,0x000207542e7452ca,0x000526cd940c7469,0x000d2936b9b32962,0x0000000000000001}, {0x000573e4f063ef2a,0x000418ca996c2a17,0x00033e1f9c1c3d42,0x000b3cbf970fbd47,0x000088c0b1561246,0x0006e93234f08535,0x0009d7f8ff901881,0x0000aa556f8574d9,0x000a5d989d3b1d29,0x000ed0ab78218edd,0x0000000000000000}},
    {{0x000233d6557077d6,0x000f2b32cea9ff87,0x0006963e65db1454,0x000b05b7d5f2627e,0x0005a68cad15bd15,0x0009679cfef2c921,0x000cc1f982da4ecf,0x000673910763dd21,0x000110fdc3925aff,0x000a3cad0858b1ce,0x0000000000000000}, {0x0000c51bfdb7b566,0x000e8b88f58f7516,0x000713a7cf39e39e,0x0004ac365af813ed,0x00040a788e43e8ac,0x00010b5e01e789c0,0x000ddf33d0cb49ec,0x000a3f2d9bd726fd,0x0006e3c30504e525,0x000e51a456acdf77,0x0000000000000000}},
    {{0x000707d7da6499d4,0x000c004b6d85bc23,0x0004b483dd72372e,0x000b15c9838f63c9,0x000dd40b6584e869,0x0005bb5ad6291644,0x00069be693ec1c90,0x0007b5c6018dc109,0x000c9c113b81150c,0x00040bbd460de804,0x0000000000000001}, {0x000d558a1b81757d,0x00046da356589b5a,0x000f093ea9cf88e0,0x000cd54eede9de0f,0x0001f19ec3f8839a,0x0004ec243ffcbf45,0x000d0d1f8b02c0e4,0x000a42d2cc07981f,0x000363b43f4701bc,0x0007f930f2e9e43f,0x0000000000000001}},
    {{0x0006b0772d9f5845,0x000f28a8c7c3d700,0x000c1d96b231ba3f,0x0000f432c17a4f5f,0x00014ca88f653da5,0x0001ac5da9fce5ef,0x000105dd10257bb3,0x000206b910de18d3,0x000d121d64f95008,0x000e83748b9a298e,0x0000000000000001}, {0x000dc94560ad3e4a,0x000b34cda193affe,0x000f39dff5030add,0x000d72c1a3a58a0d,0x0001ad7c02e84586,0x0006dddddd7190f7,0x000431dd7f7815ab,0x0001b059af2893fd,0x0006d66ebdb90a30,0x000ac5b55b254562,0x0000000000000001}},
    {{0x000a7032755a2cc5,0x00087b60173b4c02,0x000853a0c8b700e1,0x000d3fcbebfa5d41,0x000106636a248a74,0x000d439df17f1529,0x0001a48433bf866c,0x000ed52b92a93d36,0x000de5dbf96508fc,0x00064c08fb48dbcd,0x0000000000000001}, {0x000e6d70757d607d,0x00099aa287bad741,0x000aca83d8bc1d01,0x000a6deb3248272c,0x0006281490886dee,0x00003b3e7ed5830e,0x000b8f50b5515018,0x000ee61ae410329b,0x000dd209b1b1ec67,0x0009f79d8f057d2a,0x0000000000000001}},
    {{0x0009240ac4aeeb4f,0x0009de701cba0d15,0x0001e2030d5be49e,0x000f5b9fa8d80ea6,0x0009e389aa0a7891,0x000f08f46a281d5c,0x0003d8942c2a6a9b,0x000dcae5c6263013,0x0006ed6f226d80fb,0x000e7cd744527397,0x0000000000000000}, {0x00064112eebe5a16,0x0005561ba10f054b,0x000076de3983c715,0x000338a0051c721c,0x00017ed93ec2b1b6,0x00040d08e30b18e6,0x00086d02546a805e,0x000b289546bf39d9,0x00029a40d87fe36c,0x00003828ca6d96cb,0x0000000000000000}},
    {{0x000888aaaf08b61b,0x0004baeb89b8a3b8,0x00013c31ce0504b2,0x000084891577d88f,0x0001501541da01d3,0x000be18906c31edb,0x000cf8acb88a0c0f,0x000de0a54814b123,0x000d30b10ce17eb8,0x0003c65435ad1112,0x0000000000000001}, {0x0003c3081d6e0b2e,0x000bd1198cbd6e7a,0x0009feff60218481,0x0009559a8a4e33b7,0x000ae242155d34dc,0x000458dbdb49b265,0x0003688660033750,0x000853753ede19c3,0x000b6969aac09e0c,0x000a5225b275670e,0x0000000000000001}},
    {{0x0004c030e13db910,0x000b8e4bb182d8fd,0x00024d5733c45ba7,0x000e09929bbae322,0x000c5e18395c5857,0x000beb34317a4b7e,0x00065979d2ffacfb,0x00000dac7ff47099,0x0002ac181634b33c,0x000b325a113dabd2,0x0000000000000000}, {0x000f6d0b44a18451,0x000ebd4b60b5e31a,0x0007c6c236a60067,0x000b1be8ccf47b3d,0x000a21dbd1cc7199,0x0004932466e888eb,0x0001dee034c21f8b,0x000ff9da169619ff,0x0007e95c7e040c95,0x000b5a9dbe56efee,0x0000000000000000}},
},
{   /* digit=81 [{1,2,3,..,}]*([2^324]*G)  */
    {{0x0008f08161486b22,0x000be755ab4efe68,0x00048d9609c012b1,0x00098843db068e78,0x0002d958488ad0fb,0x0003f6d23cff5eda,0x000c41d3ec7372a8,0x00035d185ec0b176,0x0006314a5925e490,0x000a3de4ff957947,0x0000000000000000}, {0x00029cc94c1b43aa,0x000d43d2ad417dd5,0x000360ab4fa2dfe7,0x000e9eb552cc454d,0x00035a4732c24fb2,0x0008d1e843cf82a2,0x000ab8e67bb7a406,0x000191877eafbca2,0x000574ab099566cd,0x0009f922f9872f62,0x0000000000000000}},
    {{0x00085f8208bbe4fe,0x000ecc287db7bb2d,0x000e568667e702fb,0x000cbeb7a157f36d,0x000bf484f3352f4e,0x00058da014941bbf,0x000586c3d5fe38d5,0x000a8a8ef1b37b22,0x0005949627a9e7fe,0x0004740c422ebeba,0x0000000000000000}, {0x000c2ec0fe63724c,0x000be0eb88269034,0x00016f607ed8c7ff,0x000b235b0a729f09,0x000b2fb783d219ca,0x000a1f91a0e85a3b,0x000f36eaf1659ef7,0x00023c3d4be9067e,0x0005e5bd92b43e99,0x0001e3e81391aa3b,0x0000000000000000}},
    {{0x000cdab06c0f497a,0x000ba682d62fd58a,0x000624d8816a960e,0x0006c48669b75099,0x0001fb169d6d2670,0x0009d5b924784941,0x000361b9811c3888,0x00005ccc21278392,0x000173173a0f5de5,0x000862da0030f596,0x0000000000000000}, {0x000580503b5bd1a6,0x000460a53f77d734,0x0009ac0fc516703a,0x000cc1b1f0c1292d,0x000599d98d3204b9,0x000365fabf012bdb,0x0001f82c240390bf,0x0007f3c05cb807a9,0x0001aacb4486b03f,0x0002d4bf3cd7e64a,0x0000000000000000}},
    {{0x000cf4fb66902a59,0x0006522d970cf058,0x0008db985646108b,0x0005bd091c524ec7,0x0001c8ded01bac37,0x000a7571d5eaf41a,0x0003ae41513bf75c,0x0000831a58ce8343,0x000b5c1d0b1cbad6,0x000a127e3558b4d4,0x0000000000000001}, {0x000c5bcaa2423577,0x000e95cd90416c5f,0x000f9cd3e851fd11,0x00043cec77429d71,0x00033818263e74b1,0x000b0bed2ab694e3,0x0009d3b078fef207,0x000322c62d90900d,0x00013057fb2dcc39,0x000b0aee2cd8c7f7,0x0000000000000001}},
    {{0x000ca837cf1af373,0x0003ae0bc7638546,0x0005fbd88b9c057e,0x0000f14623993437,0x000d8418b02866d1,0x000938602b2a7398,0x000d172bab8e8fb6,0x00001960cc17eb57,0x0000f437b4d86f8d,0x0000c3266073d8a3,0x0000000000000001}, {0x000b4a64de3a3170,0x000d07d300586858,0x000590b48d2c8237,0x00064608c48f8521,0x00055a4fad372745,0x000ad1664c3cb9d0,0x0000e5148678bfbc,0x000ce1f67995bdb9,0x0000ce6b82ba0137,0x000865e65d5e9060,0x0000000000000001}},
    {{0x000a3697b62e274a,0x0004f036666b6cc6,0x0004615de0a77111,0x000d1a544656bc00,0x0004cfe1b0ffd27e,0x0007b011fe7a367a,0x000028f9395287ba,0x0000e474d2cd1539,0x000df81c967ab663,0x000809d416f7d850,0x0000000000000000}, {0x0004ff0171522411,0x000cb614e9eb99cd,0x000efe5013168ce9,0x00000068878690dc,0x0003ea58b25b4f05,0x000697bfbefe708a,0x00061484cbc18871,0x000fd61b572d109e,0x000507a67ea6e538,0x000c108cf0642bcd,0x0000000000000000}},
    {{0x00073712d28f1037,0x000dcbb85bee07b2,0x0002d427b383b0b0,0x000886a4c921569c,0x000a22bb54a08b63,0x00016efd18019f62,0x000be30e896a901a,0x000b1c79b63790d0,0x0007550d4ad3f339,0x000c014ebb2a7324,0x0000000000000000}, {0x0000eb80b7360646,0x0004292a8064819e,0x0001aa8d66966eba,0x000cb5433c6786ce,0x000c176010116f6a,0x00042b7f40b26c85,0x000bb51bb431c00e,0x00079fd699bb4a71,0x00083711f2c2acd8,0x0008a64b1e3905a7,0x0000000000000000}},
    {{0x0004f281744c4f31,0x000fb974f0427525,0x00022ee390de534c,0x000caed9f368e25e,0x000470d3f5a1ebc4,0x0006bb7427d70104,0x000830891f024042,0x0006993cd5f37f0d,0x000a9d89f4ebe578,0x000c7b2549a02c1b,0x0000000000000000}, {0x0005527d2ef3c160,0x000aa733afd2d857,0x000200435a36240e,0x000dbed50df72a8e,0x00064e9f3dcc7104,0x00084041401f5c34,0x000b281791b398c9,0x000ad77cd49e1581,0x00029530ca203aa2,0x00024a7004073823,0x0000000000000000}},
},
{   /* digit=82 [{1,2,3,..,}]*([2^328]*G)  */
    {{0x0004b896de83f7b2,0x000dd1b2e000727a,0x000d43d965547a68,0x000c1f1e1ce79a50,0x000e5ec87252c6ab,0x00060d6a5ae7160f,0x000985fdcf45caab,0x00091b3180d9d235,0x000646ab8f898256,0x0009f0446d6798dc,0x0000000000000000}, {0x000ec719b8387586,0x0001de5f9db6636e,0x00038f4a187cc943,0x000ac366ef383b03,0x000022fa366743db,0x000760fac1cc0b0d,0x000265067948b1b5,0x000693934495e8d4,0x000c64b8f4f88921,0x0005281cd8ec2ed3,0x0000000000000001}},
    {{0x0008479d81fdc38a,0x00096a893e0d1c8a,0x000972cecee045ea,0x0000ed0b37445b26,0x000bf1c0a16a9b25,0x000509c76808e477,0x00070c4c826b6837,0x0008008a3f9fb748,0x00088d0f74d58040,0x00063d18d474fc4b,0x0000000000000000}, {0x000a143fb2178ecd,0x000ee2726dcabd2f,0x000e017d3cb36d39,0x000d77e2d8d9e011,0x00069332c865043b,0x000231a13fc89650,0x000e078f7a775c43,0x0002e93c91cf1e3d,0x000d48604e0f7c89,0x00031d2709749250,0x0000000000000001}},
    {{0x0006fca2f24da625,0x000adeacc535625c,0x00020bfcd99308f2,0x000732872a2697fb,0x0007578b9abdd39d,0x000d7e3c3e30d29a,0x000dc63c314955de,0x0002de0cf2a14e6d,0x0002e4f4d6b0bbff,0x0008423dc75d4cf8,0x0000000000000001}, {0x000dc6563086abd4,0x0007f2e300951d8c,0x000a989054197751,0x000a88edbb68daee,0x000ee17db6bcc0fa,0x000d996d71fcc36f,0x00038a1dafea4a84,0x000fc8d72ef68c32,0x000c6b07cf974baf,0x000b2a140ef1e1e5,0x0000000000000001}},
    {{0x0006034713a3e42b,0x00008cfb50e4479e,0x000f617634a25363,0x000ba17f9549272f,0x000163e264556302,0x000db056ef0f6ed9,0x0009449c67d2e92d,0x00027bf608bef04b,0x000a41494e0fd2d6,0x000ecafaa0f9ad5b,0x0000000000000001}, {0x0000394a908a0374,0x0002739ed3e6c1ac,0x0002bf950e49017e,0x0006ca69441c9b0d,0x0003c717b7978985,0x0006f1bf123315b5,0x000d5ffc5bce1316,0x0000f7b0dacbdc85,0x0005306a73236570,0x0000fc22ce0f19f8,0x0000000000000000}},
    {{0x000a6e6af09b8eae,0x000343b43c513568,0x0003425270500040,0x000fb4508580e8a3,0x000b307fa3d1f99e,0x000113638a6f65cd,0x000be36db7f5ca63,0x000ede447eb7ec8b,0x00022e6ed48cec2c,0x0007bb1afd7c927f,0x0000000000000000}, {0x000c11f9a334fdc7,0x00026ae8011e9b06,0x000ba4fc7ee152d9,0x0005ebe2d92b45f4,0x000643466d3d6908,0x000a09e637a743ca,0x000aba719664e4ce,0x0003162cc6d5e41c,0x00060cdf202e7dd3,0x000c307d09d0c5c7,0x0000000000000001}},
    {{0x000b621fceac0c99,0x000cd9f0c6398393,0x000246af19db94f8,0x000def03f4511189,0x0007e278282d9eea,0x0005d51872d67451,0x00069251c97cb275,0x000152306520f8d9,0x000f0746e9696ce9,0x0009ec26638c1b12,0x0000000000000000}, {0x0006fbb28d6db318,0x000282f1e3fd8169,0x0001638aa745ba97,0x000741cbd6f6afe6,0x000674be06f9a37c,0x000f0e4d5ef37aa1,0x000c66c847151102,0x00086ff305cd0c0a,0x000dec0bec87dfaa,0x0006e29a33525521,0x0000000000000000}},
    {{0x0009e94294764d17,0x0002085b396e5ed1,0x000a114f1c4a72c2,0x0007528c8545f538,0x000963b0d0aaa085,0x0000ee6c82fe930c,0x0009cc321991f876,0x000bfd79b22e04e6,0x000e404e5103af68,0x0009a8126bf818d5,0x0000000000000000}, {0x0006f18c56b9245c,0x000be8cf2d749759,0x000d0534792607af,0x000737082c9ac67b,0x000b81d246c242f3,0x0004a1675a873285,0x000b8be65c0f0c83,0x00031f4367aaf8a7,0x000eeb7fdd2c4760,0x000b71b7bc940b35,0x0000000000000000}},
    {{0x000e474b29bda866,0x000e2b3a2640ed4a,0x00021f91da93684d,0x0005df67424bab62,0x000b550d60209995,0x00096c99d55193b4,0x0003c748e9f27481,0x000631e6b3fe7e7f,0x000f47f4e257248f,0x000f8f56db9ba373,0x0000000000000000}, {0x000bc357ebc4dd12,0x0003a33556892c48,0x000b72124cffa435,0x000e35056ea40bee,0x000a1b37aa3c71db,0x000ddc96c72e951c,0x000291c71de6fcaa,0x000ff88244eb58ae,0x00089a7bf96fd42a,0x000eb41c5d8ae97e,0x0000000000000001}},
},
{   /* digit=83 [{1,2,3,..,}]*([2^332]*G)  */
    {{0x0008ac7511fc1235,0x0005af51e9a589c7,0x000c09d63e56a5f8,0x00055b518ce24a89,0x000a75441652a9b6,0x0004ffab489b445d,0x00071289523b0e9f,0x000290aaf7cb23e7,0x000c9bc7899234af,0x0001dda65dc198b5,0x0000000000000000}, {0x000eeaccabd5a6f7,0x000d5900e72c44fa,0x00047a63782a2bbb,0x000393bbf531aecb,0x00009c7dda45067c,0x000719fa6f31630b,0x000f3a0c95e46b2e,0x0004deaf5d70f849,0x0007dd5d46829965,0x00096c286bc1f082,0x0000000000000001}},
    {{0x00012d5838ca6af1,0x000964e9241a8a04,0x00024077ab2ac6aa,0x00089da3e1536c1d,0x00001df56af4aad1,0x0006ef9e57fbfb6e,0x000b17f8ca8e6244,0x0009cbcb351a7c9e,0x00085fb54f3eda4f,0x000c296970873909,0x0000000000000000}, {0x00056d8d32e5fdd1,0x0006814d7980be46,0x00065dbc6a68d7ed,0x000cebebe9b6528d,0x000269dfcc27d433,0x00073aec8225c88d,0x000d90643f7caaf2,0x00041c78327e8662,0x000763fdae4a09eb,0x000b0ead9bd2f604,0x0000000000000000}},
    {{0x0008f42a8c29bd6f,0x0001879cf21db610,0x000555cfe2bddcfd,0x0004d452af269c11,0x000fcc4011856e7b,0x000e6e45593cb7c3,0x000b215415957c0f,0x000d3b983b2c8996,0x00012f953be5cf31,0x000f7078abc3a003,0x0000000000000001}, {0x0002c0d6b39b80ab,0x0007b2847e724ed5,0x000cfdfc83942bcb,0x000c1c0a2ddac314,0x0001da690e67e2aa,0x000310507c60736a,0x0008b8515f2f407e,0x000203447dd4a30b,0x000208fe5f3ddc7c,0x000470482e113587,0x0000000000000001}},
    {{0x000d7682eb5538d3,0x00058bd8734ac8b7,0x00075fcdec6d3223,0x000ffc3556d9d86e,0x0003a6c363b61e72,0x000d03c2ead1066f,0x00074fd7095dbd73,0x0002b42f9972cd16,0x00070acc2acc3e68,0x0006fd80c7114993,0x0000000000000001}, {0x00049c09589c235f,0x000294e10709485a,0x000e55bcaedd0d2a,0x00084da3a073e38c,0x0004725346561d28,0x000ed8195e95d347,0x00001ec990b2c19b,0x000817664aecefe7,0x0005f12464c59ce8,0x000f85a23cc1c6cb,0x0000000000000000}},
    {{0x000fb48cd5b9dd85,0x000ea5640b16ec8e,0x0004991733d00d1c,0x000e2230142b823b,0x000d1646ff2bfccb,0x000e87a4efbbe898,0x0007933417bfbbcd,0x0002ac0c744278e4,0x00079c8483d8b4b3,0x000fafae62ecea8b,0x0000000000000001}, {0x00063d47c065003b,0x0004185cb3cef55d,0x000bfcfe8d3872f3,0x0009112c490c5e61,0x0003b1e7d4274313,0x000517366c9c6308,0x000bc9bb53389bc7,0x00025afa81750fe0,0x000afda6e1b71dc2,0x000c6a9aba51c85b,0x0000000000000000}},
    {{0x00000e070af57b1c,0x000441246548fb7a,0x000c563ead66464d,0x0007508f0851b47e,0x000f31999ecfeae6,0x000f85797a3840b6,0x000c74080d60c378,0x000f3eaf1e242bf3,0x00003ca35d886cbe,0x00022754c9a357ba,0x0000000000000000}, {0x000982d0aaae9f75,0x000176d1b4b6ca3d,0x0007980f7d421826,0x000979133a61fcc4,0x000cb63f41cac3bc,0x00079bb4b9516419,0x00033cd18a279569,0x00075e18895b57d5,0x00063599127b0d23,0x00063dbbded01670,0x0000000000000000}},
    {{0x000342ad817f361c,0x000cb1bd9eb81b06,0x000c7b97a0843c43,0x00083f804f029e13,0x000b3486644af0ff,0x0002a64dc632346d,0x0002a39cc0dcbed6,0x00056457b2ff9c5a,0x0000fe8536001cce,0x000def7d14af048a,0x0000000000000000}, {0x0006c4115861eef1,0x0006a14bad6b1ac1,0x0005dee3e9d201f9,0x0002b396cf147ed1,0x000f4643f8a21b3b,0x0004c9915584149b,0x000a893cfd7ba449,0x00027a8a4eb7aef9,0x000cc4fa992b1d31,0x000eec6c99a8fa7f,0x0000000000000001}},
    {{0x000a8d985f7ab9a0,0x000b7d39a70c2f72,0x000f6f8acabea7d5,0x00095d0273f642dc,0x0007d8a54bc56deb,0x000a63f1883f3cc3,0x0004b831ef1bba05,0x0008e112f14c8c07,0x00089737917f937a,0x0004874d335ca229,0x0000000000000000}, {0x0008374f770af11f,0x000cad8ee96d7e99,0x000bff9e11a7d432,0x00056384e6665366,0x0004a9b692423f6d,0x00075f044efc7e34,0x000ee60ee1b3dddf,0x00039cd00df7a827,0x000529eb5b2612c9,0x000cd7c4ffa6a13d,0x0000000000000000}},
},
{   /* digit=84 [{1,2,3,..,}]*([2^336]*G)  */
    {{0x000c16671a6774f1,0x000af03753ce5839,0x00054c5f8c07356f,0x0001afc71165a356,0x000f9d6adf86cf5c,0x000a6b4966903b89,0x0009f4ebff86c3fb,0x0004a87b0151b151,0x000efd27bbe4f95b,0x000b040513d26385,0x0000000000000000}, {0x000622a63fa5d90d,0x0008d92aca99c7d4,0x0001d6acf3aa6efd,0x0001b7387e55d6dd,0x00010db119c2295a,0x00011a67dad9703d,0x000eedb427c0f52d,0x0001e055192fe412,0x0004a5758174c7a3,0x00055cfd4b1dde40,0x0000000000000000}},
    {{0x0000d119f7fe9853,0x000fe49990254b37,0x0008a86cb40764d3,0x000820af39be0e2c,0x00027458321b04b9,0x000c2ba583294752,0x000ae89a07a5c7f2,0x0008fa6d520652e9,0x0005604c9bdc0eee,0x0000c06f2e484243,0x0000000000000000}, {0x00014a30a2bfa81c,0x000cbd6640003017,0x000ab87a938a3f37,0x000e1c91f3132874,0x000e57e9d7ac6ecb,0x000e33fb881734fa,0x000073b600765b07,0x0009428cbfb5edfc,0x00029028585e9a20,0x0001e077ef7692bd,0x0000000000000000}},
    {{0x000cf34a0d6f6ffe,0x000370c22b280291,0x000e87a26b1fd975,0x0008088a662b3666,0x000eea746601046d,0x0008edbdfb0988f2,0x000f2131f7fc1ebd,0x0009266b6d41f4b2,0x0003c1c020089694,0x000be27c849de8c8,0x0000000000000000}, {0x000bcda37f3a594e,0x000726480ec74a90,0x00026216e2ddde9d,0x00064b02bef16495,0x000aafba3c749a5c,0x000a872930c3f630,0x000654a8695df3be,0x000cb5372491b21d,0x00017f3b3a2f3f6f,0x00094613fe01cfe9,0x0000000000000000}},
    {{0x0008937b47b39090,0x000415bb7112fdec,0x00066e9e19d3ed5a,0x0006597801eab0fa,0x0005e740c409bbbe,0x000050b19bba9267,0x000df2c3e8b56daa,0x00012fbcf099e6ee,0x000195262a55e069,0x000ee2f2c7d1e980,0x0000000000000001}, {0x000c1384c013e53c,0x00074951ffea5bee,0x000d0ad477deaca6,0x0004ee3245756473,0x00030808642161fd,0x00050c8b97a30694,0x000340f405f653b8,0x000d5a543cae9de4,0x00031ca24347d550,0x00092a75f4312ea3,0x0000000000000001}},
    {{0x000c8162c746ef6f,0x000f6715dbf9ea58,0x0005523d8217dd87,0x0000b2c52bc5b0b4,0x0005db8903ecd878,0x0004296f75f92e78,0x0003c6e6397e4045,0x000e84bad1cccce3,0x000b82162d3c5f54,0x00009333f935ae95,0x0000000000000001}, {0x0004ff1c33e26a2e,0x000785b4ec10e1f5,0x000a1634274c2886,0x000b5d5ee5822d49,0x0002fbe9122e0bfa,0x00003c2cc2955a06,0x000e08e579ad9b7f,0x0001dd6ee255f2e5,0x0004f08f71b65e70,0x000c9dcd7d23cb93,0x0000000000000000}},
    {{0x000927819d85c389,0x00088dd986cf5001,0x000eb6ebdddab174,0x000a1e388628281f,0x000014511bc0392f,0x000b79c2a5e1691b,0x000d866b842f8440,0x0000343c71a48805,0x0002ac5c5d5d795d,0x0004aaedd8558804,0x0000000000000000}, {0x000896067875f110,0x00080b0d43dab8fa,0x0009a3104ecd6f15,0x00017c31840b3b59,0x0007841201091767,0x0008de871b2243eb,0x0003f7be2323a388,0x000f764799c353ac,0x0009d244edaf476f,0x000513c595b87c99,0x0000000000000001}},
    {{0x000800832e6fdb7c,0x000df2ceb7712003,0x000625cbf7ec3398,0x0007b9eb4c74b442,0x00090424f2515df6,0x000abc10516b9778,0x0005df82462b4902,0x000a6d60d9807c8f,0x000606aee1bb838c,0x00030e1e7a2ff1ff,0x0000000000000000}, {0x0008fce9b8ce853f,0x000b7049a4c20923,0x000ae2b39f773f7b,0x0002f55bcfbf4b1e,0x000b07309ae9653e,0x000cf869d6026775,0x00099fe1b0e83daf,0x000202f8a21d72ed,0x00037619de81bf7a,0x000b7b2bf238b7d7,0x0000000000000000}},
    {{0x0008ca9dd54298a1,0x0000e1308270c47f,0x0002be3ff9743378,0x000471b0b186cdf8,0x000b1747ce696eb6,0x00015fe31005f60a,0x000ac1b5a457da88,0x000f4901af0f6bb9,0x0002f972c925bd14,0x000186acd8b58a65,0x0000000000000001}, {0x0000f355372184c6,0x0005e1f7ba0c693e,0x0005b11db3d6dbda,0x00051b89e46fae1c,0x000c97c0b46b0f1f,0x000cc037caa48d5e,0x0000355bdcc75991,0x000f28784dc0e5f4,0x000837eadd1a3fa4,0x0009eeb5a1926d0b,0x0000000000000000}},
},
{   /* digit=85 [{1,2,3,..,}]*([2^340]*G)  */
    {{0x000847fc397e26dd,0x000de02cc0ff17de,0x00063e6fe388ee8b,0x0001e73a774123d0,0x000daf8cb9f5597b,0x000b938535ee20c8,0x0000d7da8b1bfac8,0x0008e2a819363df1,0x00079861ae7d4273,0x00003eaf0a677999,0x0000000000000000}, {0x000611141de00c8a,0x0001d2aefc5b58bb,0x00033633ce29b3d9,0x0004bfef0d5e3306,0x000d78956c10a254,0x000fa84101beaa2d,0x000f9588ba22402c,0x000e0df8f46296a5,0x000c7018734ace12,0x000ca8e0e00d25c6,0x0000000000000000}},
    {{0x000c26d9a28cda66,0x000ac34788e2808c,0x000a2e3c895ddb52,0x00092cc3305bc55d,0x00086ee8076376e7,0x000da2d9cb5f9d99,0x000f0d8aea185a30,0x00068ef462b956f8,0x0000f61c2096bebd,0x00044e7be11b5930,0x0000000000000000}, {0x000ea58bb15fdd13,0x000d5b2585fb779d,0x000d75c3d978271c,0x000e827a5ac1a4b5,0x0006c6fe4d4804ee,0x000f66c09f0147df,0x000b3203f6a4c217,0x00081eeb950292c3,0x000da3f441776841,0x00071712f688beeb,0x0000000000000000}},
    {{0x0004586de8027c8d,0x0003b7dc25b073ea,0x00049b36fccf2477,0x000032458466e794,0x0006f36f854043cc,0x00051e24c902d71d,0x000ec681a81ea4c2,0x00060e710d119e39,0x000dfa8e50e27e69,0x000bc96885ae0f44,0x0000000000000001}, {0x00072cc7ee3e54e0,0x000e54b8224b0f78,0x000e5d4bd3db5696,0x000d27cc64ead37d,0x0009b5b2f36d2cba,0x00021210e2a45e52,0x0002c8d788fbf745,0x000440c5440be1bd,0x000157b392b99018,0x00045deeecc510bc,0x0000000000000001}},
    {{0x0001f34441941c1e,0x000786af242ed224,0x00082ffb7bd73f71,0x00040040ee8f684b,0x0000b0e0a77660b9,0x00055090773cb918,0x0003b4341ff934d0,0x000efe154397d7e6,0x000566086597b1f2,0x00038e115dad8d73,0x0000000000000001}, {0x000320279e97eed7,0x00092b44ad3c59a0,0x0009546c02d95d0b,0x000317d617644016,0x000b3b1278de80cf,0x000150eec20cc035,0x0004047a454911ca,0x000eb15350f140f3,0x000297dd664a854c,0x000c1545fd389a24,0x0000000000000000}},
    {{0x00054c6d42f4ddeb,0x0001a5d46442b31b,0x0008eb97dd3c9497,0x000f35259e3e1ff6,0x00049058db0b2e2d,0x0006968077e0b694,0x000456e4ea6ec9f4,0x00098457796aba76,0x0005412cc7718336,0x000c5eb4e4306f25,0x0000000000000000}, {0x000f4a91bf2060dc,0x000e9a57dadc33ce,0x00051f56adeb934d,0x000b29d22e8fe341,0x0000f85723b5e49a,0x000ee66b41fabf52,0x0005253bffe67611,0x000c50202f550a60,0x0006d250b9e49468,0x0001a2956ea13fef,0x0000000000000000}},
    {{0x0000dc097ea2b524,0x000c5eb5323240e3,0x000082d33c53dd49,0x000c5d6917c692b6,0x000337e9d695a12b,0x00078372d602c7fd,0x000ef2985e92117b,0x0008ceacebcbefa0,0x00068cc3e9b4e8e1,0x000db3e3e50ee13d,0x0000000000000000}, {0x000980bec0d2f5e3,0x000eaa9b062f585f,0x00083ee3b5103eda,0x000605534f1f8028,0x000add292d29ee4a,0x000f9ba28df95f8d,0x000d134fb5785f57,0x000f0fe162fe54b8,0x00047f0902bd8287,0x000de3769ce1a122,0x0000000000000000}},
    {{0x0006e3d538c32c91,0x000eb774341e7141,0x0009e6b225ba2b4e,0x000824dcff742236,0x0004d5e3b9c67d3c,0x0006e4276dd54722,0x0001d2dcc105d46c,0x000392da4b3a8a00,0x000e2f3953b25248,0x0002fecbb5174b67,0x0000000000000000}, {0x00008d720508826b,0x000b9b4e2e807123,0x0001bf6b1169562d,0x0006d2acb14e6841,0x0008cbfd3257245f,0x000189ac1c8cdf45,0x000ee493f894fd3e,0x000fa59cbf0ab5d6,0x000476d8e672a0c8,0x000ed9fbb78753d8,0x0000000000000000}},
    {{0x00039334c1cd9788,0x0008ab0560e3e74e,0x000fa2ff6e2c62b5,0x000acd7d25b0cfee,0x000c456f469aee3d,0x000a862fad6476d0,0x000688f0d8d2340a,0x000b648a9494468a,0x000f4ed209d4d2fe,0x0008a93e7c5890e9,0x0000000000000001}, {0x000cdd07e3f60721,0x0002466078437612,0x000ea1835868d6d1,0x0005ba6a85400753,0x000f7f252808d5c3,0x0007b45d6857ba4d,0x000d683048ddde70,0x000c759393e38c60,0x0000c630e919b183,0x0007209017172576,0x0000000000000000}},
},
{   /* digit=86 [{1,2,3,..,}]*([2^344]*G)  */
    {{0x00060ead50b81885,0x000bcef73cb6f0c1,0x00053fb7eb3e2cd2,0x00062b319bb7bc05,0x000a38a471706b6b,0x00046c6b42daf298,0x00005e59d404cf98,0x00048fac2e73085e,0x000ff0af6c53893b,0x000de9e3d8eea7a8,0x0000000000000001}, {0x00034470acd5b055,0x0000c4c1af94ede9,0x0004fba6b3889b3f,0x00023ee49af80496,0x000f0d89fd53a3e4,0x00053cc302793fad,0x000b36dcd463b613,0x0003782e102e51fb,0x000c63732d6d1c6c,0x00059dc97f604bbb,0x0000000000000001}},
    {{0x000db31484a7e177,0x0001740a1bc3a05f,0x000c265e95ebda07,0x000546d643b1d3c4,0x000c2611b9709edc,0x00015784fc807b04,0x000e5bd473ceec4e,0x0003c97fb33e58af,0x000d6d5327b94dc5,0x00062a914fc6dc39,0x0000000000000000}, {0x000cbcf73d880ddb,0x000029df80627a67,0x00091ccf95a67d3e,0x000ec7aefd91b52d,0x0003aa855273ca53,0x0007213a95113157,0x000b98a49db550c0,0x000b470643affa5f,0x000f0628a0fa67f5,0x000d2cf906186e6b,0x0000000000000000}},
    {{0x00039cff07a9f5bc,0x000b27814ba6cdbc,0x0008da0e67469efd,0x0004ccf0a198fcd4,0x000cbf71a6e5b71a,0x000500eabe51b9c8,0x0007908463c5cf80,0x0004962539aa0260,0x0001de61db956e33,0x0004f9e2c1ac338f,0x0000000000000000}, {0x0005f37dc080da53,0x000c1c2a74369386,0x000025722593f4e4,0x000a4e09b626a8d5,0x0004b1e7f8c96db6,0x0002c5a75c187079,0x000cb91e644a3045,0x00024e7eb18af641,0x000fb48086d9cefa,0x000b4dd6532fa3f7,0x0000000000000001}},
    {{0x0001be067e3e2f37,0x0007737f152d2c7f,0x000242f8dec8659f,0x000c7d958df47d63,0x0001b91c63b0acba,0x000c2c6ad3f62088,0x00099adda54c0028,0x000a3012f6937019,0x00014f4c499516f6,0x000da068d44cb73c,0x0000000000000001}, {0x000209ec58d1b414,0x0008e876dcc7401d,0x0009323106751dc5,0x000f75f24e14fe98,0x000ac88f5086e5a4,0x000294dbdb4ccd6a,0x000be99edf86543f,0x0003767f48ab30e3,0x0007667c622dcd0b,0x000d7fd6615681d8,0x0000000000000001}},
    {{0x0008c453ac10be58,0x0006d75a48dfcf2c,0x000c4944bc5042f3,0x000e7ad5c9cee1eb,0x000996c45d109bc9,0x000689f02d424fbf,0x00023528e926c326,0x000e84ac793d58e5,0x0008eeaddb5a4ed0,0x0005d31f9ea2560c,0x0000000000000000}, {0x0007ba171a6ebc35,0x000d39e242ba28da,0x0000694f0cc97464,0x000d7fb496b0d2fb,0x000d7e1b5b66b3d8,0x00001db81788dc1a,0x0003854dd5fe4e9e,0x000f9965063e6021,0x0003751c74ab4631,0x00006945420e7941,0x0000000000000001}},
    {{0x0005b110bb6dcc9c,0x000e9d1e6c13e60d,0x00058585159a0842,0x000b46fe443356f4,0x000853b25c086265,0x000ebbff20877291,0x000136ec71c4d1d0,0x00003ebeca5e79c2,0x000a0af3b3a96ed2,0x000f93012e330a32,0x0000000000000001}, {0x00017ed67dacd4b6,0x000ceade583a567d,0x000316840b4e5703,0x000c414303d396ce,0x000ed6970ea480cf,0x00063761b9b1974c,0x000788f3de4383da,0x000ad07d6726e400,0x0003056bda545993,0x000385d3fe822ea3,0x0000000000000000}},
    {{0x000285c58225166f,0x00072d2451ec99f6,0x0005efbddf5101b0,0x000dbc066e055890,0x0002c29985ac7cd6,0x000f1839b6caca94,0x00093cafd8d9c1ce,0x000b177ba7911d6a,0x00098fc762e30d5d,0x00067686b89a78b5,0x0000000000000001}, {0x000dff4557a32b93,0x00037e16c6af191e,0x0007ad7362550f1a,0x000983cb772b5537,0x000b0746f50f2068,0x000dbb42f7ee6b8c,0x000f0cdda882070d,0x000a732384a13e83,0x00055b3be67dc4f2,0x0003cf20d84f4cbc,0x0000000000000001}},
    {{0x00007348004e40c0,0x000448f78fb0602f,0x000c2ac8aebb2604,0x00064b78277ca03f,0x000eb2c6f473d278,0x000cb793a9eb1664,0x000e2b358eee9a37,0x000194f18cbc9c2c,0x000f6078bc87a3dc,0x0006220e93cd112d,0x0000000000000001}, {0x000d1ed5d96d6d2f,0x000b72be10752f3f,0x000d1e476660c38f,0x000b1d6d9b093c35,0x00026d898dff773a,0x0004b445df00e4cf,0x000d1ce422c1136c,0x000db6e821b59ee0,0x000de6252e82511e,0x0002f481c804e41a,0x0000000000000000}},
},
{   /* digit=87 [{1,2,3,..,}]*([2^348]*G)  */
    {{0x000d7989af2b44ed,0x0006f91b1a9086f8,0x0002b4d5672b30f1,0x00072009919c3dae,0x000003b6ec0a964f,0x00012b7f4f64ce56,0x00076bfe0f0d4fbc,0x00043eb40f821444,0x000cbb4480332a8a,0x000f3ff375566080,0x0000000000000001}, {0x00018caf35e5d712,0x0009aba53d6591e5,0x0004f1b1b50e170d,0x000f9eca3e56ed3e,0x000288dfe4cc67c4,0x00059c7726fa0dd0,0x000a0660a01f234a,0x000a704007db6c8f,0x00070b32e8366767,0x00096994810fb845,0x0000000000000000}},
    {{0x00092a1897b4c0b5,0x0009027fe35612df,0x000a5105c7f9f97d,0x00021853ba021326,0x0005dd2cadb219c5,0x0003ab9d259b3ed4,0x000857fddadc1ebb,0x0004addab0607b4a,0x000ff916fbbc92a3,0x000721ee7e6c527d,0x0000000000000001}, {0x000ba1dabc6f5958,0x0000087b0e564aa3,0x000b9c963dd27f6c,0x00028eca3c030970,0x000c23cd7a457768,0x00017b833d0834d3,0x000be25f44c50d54,0x000a153d4a6bf0d8,0x000e9c71da49590e,0x000d43f3a30dc247,0x0000000000000001}},
    {{0x0009bd585a57c01e,0x000ee844d7078c7b,0x0006c16cb258be3e,0x000a3282f9caf55b,0x000e08d004fc2ebd,0x0009db3ca2d054d0,0x000ff89010ddde2b,0x0006615b9b156d6c,0x00000ee87cbb5e96,0x0000965826673f04,0x0000000000000000}, {0x0005c973c58e4e2f,0x000bfed17990af45,0x000982806a235d03,0x0003a7e6203578b6,0x0002679d20d4837e,0x000fa09a67212915,0x0001e993e548aecf,0x000034e7752d33de,0x0008c0133b8d99be,0x0005d644443ed88b,0x0000000000000001}},
    {{0x0005d09795891669,0x00055ce0c6b8f799,0x000cdfa7a67baad2,0x0009a5462a84102f,0x000ca5fff322b2ed,0x00016895f0238b4c,0x000e1fc27a1fc8f3,0x0007399300db4369,0x00016f718708ed71,0x000aa4931503fe5f,0x0000000000000001}, {0x00040da9e1ff0c6b,0x00022af9967269a0,0x0005871908b86944,0x000801c88350fa73,0x000f680cd1b5d61c,0x000f0b415826cc63,0x0008b363474f5f7a,0x00027800e5401e93,0x0002305262f20f7f,0x0005e6d27bb44c56,0x0000000000000000}},
    {{0x000dab714dbca0be,0x000450d634bc786d,0x000d2802c42f3afb,0x000ef6e542d9994d,0x000946669336b0ea,0x0006a8fe65059b68,0x000f702cce1812e5,0x00030e3c70e359c5,0x0009fd5b9f2069d5,0x000093f3f0186d75,0x0000000000000001}, {0x0006d10e2b40858b,0x000a417e22a4fbc2,0x00013ba0de831401,0x000d41a31a86b763,0x000893ad0b78b7c2,0x000aacf20f1564cd,0x000bac0041297947,0x0004ac69dc2da24d,0x000ba071987933c2,0x0007176068dfbd75,0x0000000000000000}},
    {{0x000c8b4eb4601064,0x00099a991f16e053,0x0005bcf58e425bfa,0x000b1e6fefc21bff,0x0005da04d7e97cf6,0x0003f93bddaedacc,0x000336130ff2741f,0x00028f428d033ae2,0x000b98d58f0cc054,0x000281be6796c6ea,0x0000000000000001}, {0x000562d3cd261bc6,0x000c4e652831be2e,0x0007f84fc06f2ac2,0x000b078d9ca13774,0x000d2b248e882f5c,0x0006981dfa0231e8,0x0005f7dcfabfd673,0x000f3658f51759de,0x000d6a68de41452d,0x00038358c049f993,0x0000000000000000}},
    {{0x000dba36a11f468b,0x000ddefecb4596c7,0x00004044ba328343,0x000e3d89658e943c,0x000955f5e1aeb372,0x00008650d658c0f4,0x0004309aed6ff5c1,0x0000ad875f7bb480,0x000c35156e670707,0x00066875cf1c6033,0x0000000000000000}, {0x000bceb289713705,0x000a8a9a03fa8061,0x000cac052e91978c,0x000b61eb6bb99c20,0x000e50fb8f33460f,0x000ec61a887398ae,0x0007437f45e3c633,0x000fcf4c74c22971,0x0004691a2d9b4866,0x0009004647f4a64b,0x0000000000000000}},
    {{0x0004f3cfa7e54e73,0x00076a7075c33047,0x000b446bdd4b3ee5,0x0003371a1b7efe90,0x00013826a3c98a14,0x000412cdba45fcf1,0x00048a44b5601caa,0x000206ebe3f76143,0x00050e4439f111b6,0x0008451f6bb4a9d7,0x0000000000000000}, {0x000c0d59b5f2d48b,0x00029bcb29ae2863,0x0003a9a3c78e216b,0x0007856c2465c5b5,0x0004736d155fd956,0x0001ce6b07dfbfe0,0x0008361c3a4fa43a,0x000d0e9f03c0f19b,0x000e803f9b21f548,0x0002f885460ccb9d,0x0000000000000001}},
},
{   /* digit=88 [{1,2,3,..,}]*([2^352]*G)  */
    {{0x0006b287cbed671f,0x00071c978130d6d2,0x0007aadd881d433a,0x0004f45fb4ad7bb1,0x000d7b1940d6b52e,0x0002d44569722e2b,0x000de70f91dc84e7,0x000ed42546436d3f,0x00047e41abd1bc41,0x00010f544a7be2b8,0x0000000000000000}, {0x000e82545325818a,0x0003cf3d8e5d2be2,0x0005f30317d1c986,0x00015ce098fb8ec2,0x000158947db8581f,0x00055d8793f3e6c3,0x000f50843a7feb50,0x0008ac153d3d8417,0x0004329e7248bbc3,0x000d2ffcfbcb0366,0x0000000000000000}},
    {{0x000b91e88872c802,0x0009859329a6f390,0x000332091e85e0fd,0x000d0a1fc7233994,0x000c07172741e069,0x000870fafc953488,0x000d8073b040fb91,0x00089e841e1bbb2f,0x000f582161687272,0x0007bfa72dc0f548,0x0000000000000001}, {0x000c2f4044695d52,0x000e9fc898f3ae4e,0x000d6d16346893df,0x000cc356cfc2a2d6,0x0008f9780e14adcf,0x00040c34a952a0f5,0x000bf1f1f74017fe,0x000ae85cc7e49637,0x0002400547db8273,0x000eafd4e119d7f7,0x0000000000000000}},
    {{0x000a5355afe08a2e,0x000687a2f29baf29,0x000653058a23e11c,0x000110b2ab5abb63,0x000e4ead1d1b9533,0x0005d1b7b6254324,0x00074059ad5a8616,0x00090712ab62d100,0x000e9d5016f88f2a,0x000afeefd62c6b78,0x0000000000000000}, {0x000d2d42ce0d173b,0x0009198d15289e62,0x0004baf7b535d68b,0x0008566e4a9af773,0x000402c278158bfd,0x000603f6310f0f5b,0x000331a366d639ea,0x0007457655beed79,0x0004b46175b5f4bc,0x00048f6ced012274,0x0000000000000001}},
    {{0x000b20efdb706d0d,0x000c40117c40b081,0x0000a6d9c2aec008,0x0004d3e0693270e3,0x000674266a5ea611,0x0001ebf62144a6af,0x0003d45ee3917e38,0x0008c35ff5d67fca,0x0006e79dba352604,0x00081a7e7bfed40f,0x0000000000000000}, {0x00006eb8dc692380,0x000fe33343c5a20c,0x0003e67d0a53418c,0x0008959e15eb001a,0x000ac0ead5e7c7e4,0x0002e4162f0962e6,0x00017bb3e28513c3,0x0004317568fafb81,0x000912ceb3a2e303,0x000102559381740c,0x0000000000000001}},
    {{0x0005f372c77f1047,0x000b3d958eb7b744,0x00069ac2a8ab1157,0x00057d2ec5015809,0x0007f4db5c158ff6,0x000e3fc15a71737f,0x00048e949735c5de,0x0003845758233ed6,0x000e91137608f198,0x000720cc72b9199c,0x0000000000000000}, {0x000b050528cb006d,0x000ac29d53a71cfd,0x0009a1f2ad6eb262,0x0006c829676f56dc,0x0003dd6ddbfb591a,0x000c61cac801979f,0x00031b13cd6cc83a,0x0003cf1a5e5c85bc,0x0007cff1f95623b3,0x0004f7b2cd595d6e,0x0000000000000001}},
    {{0x000699fc8b3dab7b,0x000229f393f97b3f,0x000012376dbad08a,0x00038a797638cccb,0x0006110a40e7e328,0x000e3d1acf08dea4,0x00003f85adfc07de,0x000fffa8d9d37eb4,0x000db3ca114eff2b,0x000b41dd72c79e23,0x0000000000000001}, {0x000822fbbe3ad3af,0x000ddd71461cfcd7,0x000d3d8f03aedaa8,0x000f069c35282be1,0x0009283f776eb004,0x000746b05b9838ad,0x0002fcc85c205f31,0x000bd9143e61b0eb,0x0004e7f4435b3321,0x000a673088e100ce,0x0000000000000001}},
    {{0x00052e132b686982,0x000419eaf166734f,0x000edb4ffc59ba11,0x0004fda13f9e0e45,0x0000c12226a0efde,0x00070adf716ee2a5,0x000402012f467257,0x000f2ecf2b32d94e,0x000205b1386ade63,0x000b3bc779c31b50,0x0000000000000001}, {0x000cbbdbe0875f47,0x000a208dcda3e65d,0x00048b61b40cb945,0x0002b16480725e0f,0x000aa186079b7359,0x0007e306ab144462,0x0004b09effdc0e10,0x000a76ab4395ae17,0x0008c3ddeeefeec9,0x000216cdb5d669d6,0x0000000000000001}},
    {{0x000c70f6d4b2fef7,0x000c0c92ef06acfe,0x000790f3344c38aa,0x0000fed753c30edf,0x0003dfc8006501b4,0x000df722f2f6da80,0x000c340284a42e2f,0x0002a0f154005cec,0x00082f0dfb36ac65,0x0007bed1506b21ef,0x0000000000000000}, {0x000d76b785906061,0x000edca1c3d7b884,0x000307e9a89c6050,0x000e0ccc1519baa6,0x000663495eff88c7,0x000a17475b22e916,0x000c39e69639f1ce,0x000b1f0e827f8c53,0x000066355ede8121,0x000d5b91249281eb,0x0000000000000000}},
},
{   /* digit=89 [{1,2,3,..,}]*([2^356]*G)  */
    {{0x000ccccf35a37229,0x000465167517203a,0x0001bf938eaa2ac7,0x000d73d683a983dd,0x0007f598a6f1db73,0x000235f9ed630b4f,0x000f332db784cb56,0x0003b330540f52bd,0x0005843b0221e5e8,0x00044a09499b4ec2,0x0000000000000000}, {0x0000fb3cab0a1b02,0x0008968b6e52dc01,0x00022c046dc60a24,0x000695beae1e187a,0x000d3006acf49482,0x000960f10535934b,0x000df011e1d0143b,0x00085de371d84cfd,0x00082841456c439e,0x000585582ff3b564,0x0000000000000001}},
    {{0x000e94ac6fbf17fb,0x00044289803b61bc,0x0002e798f31e8afe,0x0005e43d9a42f37b,0x000f377aef7a7947,0x00003a6947a8f685,0x000c1b4969c3b8c2,0x000b9c542cdbdf0d,0x000501682c76bc8f,0x0006972a768660ff,0x0000000000000000}, {0x000f9daec5f3009b,0x000325c4a46652c8,0x000b09499ac89b1c,0x0003ccd5721c0cae,0x00098da46e3445e6,0x0002db691caca0b9,0x000845a793a1fc73,0x000ad927f614049e,0x000024bf07aea310,0x0007245359be8b80,0x0000000000000001}},
    {{0x0000db1596cc9e80,0x0009a231d0f49f13,0x000f1d499d6bd9c7,0x000757ac7ea9b7cf,0x0005305a4d545367,0x000f2c85480a42a4,0x00029efd461a5b51,0x000fe691c9e6b8ed,0x00090ea1ca549541,0x00058f09c0153e64,0x0000000000000000}, {0x000525f593f9a0ed,0x000edbc140a1f67f,0x000f5bef166a98aa,0x0007a559750be5c2,0x000fb8cba58b2d45,0x00014d93d0c5d96c,0x000723470bfa2f95,0x0004f6b79058b86d,0x000d58f11a8a7858,0x000fe32b2d0ad418,0x0000000000000001}},
    {{0x00016f6d1a0d42ca,0x0000a7c2c062afb4,0x0001630676c3dacb,0x000c297ad74ee6b3,0x000d18f736e4995f,0x00064edc2548a7a2,0x00031596b5d5f53d,0x00040e945b2c8330,0x000587c06dfaa52c,0x00037c462a8f05b0,0x0000000000000000}, {0x000cd636b4f0d870,0x000b2b0835ddc02f,0x000d233347086482,0x000bf92bc7f1c7b2,0x00050d5f30c92b32,0x000ce136c0491539,0x000254d29288cec9,0x000c34eb38494ac8,0x000ba2a1b0b3117a,0x000c473a85376a14,0x0000000000000001}},
    {{0x0002a61629b67537,0x000edcfef26d3aba,0x0004bac42f2af22b,0x0004da8b32bd0514,0x000be474d59e6af5,0x000c190f17846ca3,0x000f3e17e7c79bfa,0x000a13543ecbaea0,0x000e74acd0ff996b,0x000cbde27a5f5aab,0x0000000000000000}, {0x000ccc73ffeccff0,0x00082b1e746179a8,0x000b19b717d62af8,0x0005045a4e0895be,0x0006b8f194a8bb25,0x00089f1cd50b3736,0x000f2a57b3da3e10,0x000691e4f67468b1,0x0008976ca9c4602f,0x0005e53ed98ad969,0x0000000000000000}},
    {{0x000f79bf523ecdd9,0x00097ebf36d74486,0x0000fe48147bf45f,0x000868d46235b3ae,0x00073a9b13d93d40,0x0004e9264c45fa91,0x0008c79b5705f4c3,0x0000fd4b166fd0d5,0x000aca2edaf4ff87,0x000955b68a488f7a,0x0000000000000000}, {0x000f3e0b19951fb2,0x000c26747dd972f5,0x00092d84bc8f6fc0,0x000255f7088102b5,0x000c984970893201,0x000a6791707f6288,0x00072769309b54e6,0x0006389f4da5d532,0x000c1eb23c48b5de,0x000d1bac794b858f,0x0000000000000000}},
    {{0x000e2d8dfd2d5a87,0x000e5a708c918328,0x0009b9fb00f1dbe8,0x000fe9c7a3695cb8,0x000749205b4caaea,0x00056f204bd6ec0b,0x0001a73a9e0254c7,0x0004152441cfd51d,0x0000d2b8b0ca9156,0x0004dee3cdd9e937,0x0000000000000001}, {0x000ab13754dec146,0x000b5d5322d78e9d,0x0000adbfc5578b8a,0x0000ce27a2b97f9c,0x000b49cd573f2d5d,0x0006ee23d2e94e39,0x00061ea213bd15a0,0x000e561b9d34708d,0x000fb576c6271f59,0x0001669ae9450741,0x0000000000000001}},
    {{0x0001a66376c54f37,0x000a06b888102e23,0x000430b0efaaecdf,0x0003b1e3d888793c,0x0004f8beed2dbb12,0x000ea5e72a8887df,0x000d4aa2425e9853,0x0009d98e93f3ccc7,0x000cba97fe918171,0x0006b08ea6eef307,0x0000000000000001}, {0x00019b171f51c344,0x000d5e5d9f40be57,0x000fea96313e16ec,0x0001461efe1e359f,0x00043de9904f3d9f,0x00081bb7a038f6d9,0x000ed552c5787d58,0x000a67fc2cd9a74e,0x000643f377ccb483,0x0009db7070b5762c,0x0000000000000000}},
},
{   /* digit=90 [{1,2,3,..,}]*([2^360]*G)  */
    {{0x000188556b53942b,0x000736bd7c7672ca,0x000a466705820ced,0x00039ba4b83d6897,0x000af174ecbf7e3f,0x00003dc58b34188f,0x000b453db5dba0b2,0x000ef54df32d5206,0x000d08e3c52fcf51,0x0003732f551f3408,0x0000000000000000}, {0x000937ade92603b2,0x000b6a7f7f5dfd6b,0x0003151876b632c9,0x0009040d3ee4a789,0x0007441b009fd7a5,0x0008b427fedfc2d2,0x0007f921c0ceded6,0x0002220fc8f207d5,0x0000f675383c79a4,0x000d6f410a2e837b,0x0000000000000001}},
    {{0x000fb8b792ff9c0f,0x00062d82addc4301,0x000b9cdf1d9fdb00,0x00042255b1cf25ad,0x0009daaea42ebb5a,0x000dffd105199066,0x00001d688f207641,0x0001da7769bd6130,0x0004ea507a275aa1,0x000073ea612e43e0,0x0000000000000000}, {0x000f18b4b24386fb,0x000f72268a5e0821,0x000ad126436a7554,0x000ba02f714fe1c3,0x00019b7c7cde45b5,0x000c576f09f2da35,0x000aef34fb328e0f,0x0001a0386e0f185f,0x0007a6bb32adc73d,0x000733da21be9ac9,0x0000000000000001}},
    {{0x00023d540d542b80,0x0004cc500040b26a,0x000e6a09fa7f8755,0x00027fbb548aea96,0x00065fa1d8c060cf,0x000943cfee1a6187,0x00061bce6a8c7ea1,0x000d99730b0b20bf,0x000eac170744528d,0x000423d049742c42,0x0000000000000000}, {0x0002bba636da345a,0x000a62e601cd801e,0x000c9e240a6cbeef,0x000103af8106469f,0x00007c7109e54da8,0x000b9a3ec3dcc449,0x0007788e44b6df8d,0x000d0e67c93ee34b,0x000e8347b4a58495,0x00037223b5096e63,0x0000000000000001}},
    {{0x000417e035b970b5,0x000ca1b60364c1bf,0x000ea847f52dda37,0x000517fb28527f5c,0x00007a1e399f798d,0x000452c79fff102f,0x000688a87dfab3cc,0x0006490b0295c5aa,0x000d17acd0dbc605,0x0005acb4f6972c3d,0x0000000000000001}, {0x000fa35559042635,0x0004e33a903ffa23,0x000c46f6e3526281,0x0007bc6b1cec4214,0x0004bca2e1dc8726,0x000b50045720b747,0x000c697f394811de,0x000ba5001f3d4304,0x0009ea7fd0f7a5e2,0x00090dead3d0124c,0x0000000000000000}},
    {{0x000e47c23d19de00,0x0009afd475bc3cb7,0x0001acc6490ff459,0x0009f5dc39b1950f,0x00064d14540f1ee0,0x0001b75050e51c95,0x0005647bebd088ff,0x000f240dba4c1789,0x0009b95e8097400c,0x00085b5d4b842055,0x0000000000000001}, {0x000986a76d06fbfb,0x000d7fc2ffb65385,0x00018e264c5a478e,0x0005a2784841d184,0x000fe21d9e8a017a,0x000bf52154297fe2,0x0007dad072d6d911,0x000eae77c8ea8832,0x000786b6a02d1fcb,0x000e682555450013,0x0000000000000000}},
    {{0x000de731f9f48a0a,0x000a357753cff617,0x00073655403972b7,0x0000484d28d73a10,0x000c846d46c140c7,0x00055b7ef1516a9d,0x00014890b5525944,0x0005f418ade1b816,0x000a465f264a9164,0x000ed37693e9a176,0x0000000000000001}, {0x000e5c3bfdcbca2f,0x000121dc135bc4e5,0x0003d39b5c7ca946,0x000be46855877498,0x000879fb5d801318,0x000afd92b1e5cb62,0x00024aecd7f80343,0x0004a3835c8434ed,0x00025764c6aa7d95,0x000a0241780668d3,0x0000000000000000}},
    {{0x000c0928cf2280c1,0x000f2c37933b1734,0x0006bae2a2974a56,0x0001e8bdb1d26ac8,0x0009c84c336cb6bd,0x000ca41014cdaa1b,0x00024b87838c44fa,0x000f525239cae2ce,0x000cb0507515f204,0x000993dbd0e0a58b,0x0000000000000001}, {0x0001411bdc3926ce,0x00087f3e15aa5363,0x000ade47bf68672c,0x000028e493da50d5,0x000120048f8cd148,0x0005ecfaeb03c756,0x000e1347b7867aab,0x000ba0208953afcd,0x000be9b23e2411e3,0x000a2e848d40b424,0x0000000000000001}},
    {{0x000583ec08d4ad28,0x0007687b7ba7d916,0x0002b3f0b4e2bbb4,0x0002caace0e4b3fb,0x000b0e6fb63a6917,0x00000520c822aab4,0x000f41f7930e37aa,0x00046bfa91da4dcb,0x0008bd604f521a69,0x00040fa707c1f0b8,0x0000000000000001}, {0x000520b880d23952,0x000bb822333018d8,0x000aa6a00bca6bc2,0x000f3469011553af,0x000c20ed5fc0a5de,0x000ee0e8c5bcfec7,0x000476e2f464224d,0x0002d844542e8adb,0x00009924fd3c1bdb,0x000f2fac98d161a7,0x0000000000000001}},
},
{   /* digit=91 [{1,2,3,..,}]*([2^364]*G)  */
    {{0x000c9a655367407c,0x00001acf48b04d30,0x00004344830b68ea,0x00058a53174d6fa7,0x000f59044eeb31ac,0x00087d51a60524d6,0x000a344fb882d4df,0x000d1ed41d08aa0b,0x00086b6aea85fb93,0x0007f27fa57f4860,0x0000000000000001}, {0x0006f6fa7b7febd7,0x000ef92aae956259,0x000abc183c404813,0x00011be4ded30d2a,0x000e220b7ae966a0,0x000c3e6cfc88e77b,0x000a92b77d5e0cab,0x0003d7f99c6dac06,0x0000a6be4c76c302,0x00032d1d55150da8,0x0000000000000001}},
    {{0x0000d37f0300cf42,0x000564d1a1ebfaea,0x000bce4cf04b07ea,0x00084f2b4677d784,0x000db14a4f867741,0x0000b95ce93b8741,0x000a31735b5960b0,0x0003d2c80a76fae4,0x00022c4d123107ec,0x0006cd8678a9d705,0x0000000000000001}, {0x0004b58dcaec13d9,0x00067d88c3d5f230,0x000f847248f45f52,0x0003da2628ef4e85,0x000e37945a7b9c0f,0x000a2da387ea2c17,0x0008e98e84de9888,0x00038290c88f211a,0x0004ce3667557434,0x000040ca4612f56b,0x0000000000000000}},
    {{0x0009e872c584974d,0x0006ca75132450c3,0x0006c420ca2dafbb,0x00069da0e632e68f,0x00018e1d45c5a963,0x0000394fa7a8601f,0x00098adcea6c9852,0x0001b23e3c6dad95,0x000f0655b2b99628,0x0001992529d81db4,0x0000000000000000}, {0x00000b6625e14e8c,0x0006611065dd0a46,0x0000a833140f2868,0x000735d82490f09d,0x000326d182482735,0x00074f69a678ac02,0x000e336a3425366d,0x0000093a8f215358,0x000644f6ddf3569b,0x000d19beff776a6e,0x0000000000000000}},
    {{0x0007a73bd7975b73,0x0004ba1e3ef4b56c,0x000835871e0104fc,0x000ed4624759b57a,0x000eed3c95d4d9b4,0x00029d8353648a71,0x0006bedece81ad28,0x0001452c12f2b2a5,0x000ab19b8b67ec3e,0x000ccd3f8f88bf35,0x0000000000000000}, {0x000062e0d5c7f0b6,0x000dd34abff69676,0x0009b89962a6641c,0x0002be1c0add12e1,0x00014a078191a9f4,0x000c488cf972d9da,0x00090e9607f65fc7,0x000d5cdadd7da7e7,0x0001ca37f83b3584,0x000dd43c6df02d38,0x0000000000000000}},
    {{0x0003f8ca58799292,0x000601d1cbef0700,0x000f41308b0cefb1,0x00090de4387a468e,0x00035f90ae8d18bb,0x000b356306c0a768,0x0005e167044866de,0x000114237a5a47dc,0x000143e3b4bbc084,0x000c1c6d0277c186,0x0000000000000000}, {0x000c81887bc12544,0x0006af4b6c2a8e8c,0x000ba5958fe82cbe,0x00067cd479340299,0x000d360f1809e7e6,0x000de77ee94fcc0f,0x0009d25d201341ff,0x000fac2af6e20977,0x000dfea19f8974a2,0x000fba7a5252c712,0x0000000000000001}},
    {{0x0001e6367ded4905,0x000fd6fd8b41173a,0x0000c717ef3cdcf0,0x000608fdb3300d01,0x0000d527d7c8e07e,0x00039cd9ece69c0a,0x000677211bdaf48d,0x000b5d520c7fa557,0x000bf842692f3c61,0x000055814bffe31f,0x0000000000000001}, {0x000c94502a0e0f49,0x0000528193bb953d,0x000d7bdda5ab1a23,0x0007c4a219650b25,0x0000f78abb7ba4c6,0x000eb157bdb9dbe1,0x000ace6b3d0ff943,0x00048180c4dc1a32,0x0000124b69e9b36a,0x000da7fee72796eb,0x0000000000000001}},
    {{0x000530dbdddc111e,0x0004131a0423e417,0x0002a2fcd4c890b5,0x000685a6ffdb8021,0x0001c68bcc7cf314,0x000fb29a153281e3,0x00090775f2e2a729,0x000fe4fc20716627,0x0005fa8915460a5d,0x000b7744dbded762,0x0000000000000001}, {0x00058330ded93a3e,0x0002ad9ca2943c52,0x00031d21ab8030d0,0x000fe30e76f64897,0x0002b30fd418c647,0x000815868a20f82e,0x00098d35bf8cbd5b,0x000facccde412b85,0x000358ff02bb4ec8,0x000fa54fb1673bc1,0x0000000000000001}},
    {{0x000aed08c7bd3b0c,0x0004e546195fa3ed,0x000c31c13efbcb9e,0x000f2eaeb2cc8a6a,0x000a1912ca200483,0x000f0ff27a5ee60f,0x0000a7b9e9c56cff,0x00044977503cdac7,0x00064deabbda5a3e,0x00038efe3a9fcba5,0x0000000000000001}, {0x000821113784eeb7,0x000a12560a5e577e,0x000ae4b9aaf4ec38,0x0005c9a38358d926,0x000497b69c24b1cb,0x00007485410e5464,0x00026fb660a2d50c,0x000987263ee5a4c4,0x000b3ba20c286e0b,0x000ae54bed6c50f7,0x0000000000000000}},
},
{   /* digit=92 [{1,2,3,..,}]*([2^368]*G)  */
    {{0x000e2418ebe8f2ee,0x000f4560bac026d4,0x00008c6a85ee3153,0x000c7d7d8e05a0fb,0x000d35867d053abe,0x000ebaaa06ca6918,0x00022207d8627f01,0x000fdfe74b9c6ea9,0x000478deb27dc332,0x0006b633ddba7b54,0x0000000000000000}, {0x000eb3b84da8ae44,0x000dced254321c2f,0x000ae0be12cbd92c,0x000b5fae91edd7e2,0x000adacef448565a,0x0003f288c1607c22,0x000ea8d01e22b70e,0x0004e3598c73a3ba,0x0009cd9f6c24e3c9,0x0007a5595791d3f8,0x0000000000000000}},
    {{0x000cd049d3a9026e,0x000dbe859af0b3a1,0x000d9aa6b9632b70,0x00029dc483656cba,0x0007d02bc7ba1a52,0x000fc68a06574b48,0x000470a9518ff35f,0x000aaf20c720ad36,0x0003bb49ecf8b908,0x000f66f8b9d88aee,0x0000000000000001}, {0x0004ae92aaca41ff,0x0009e2ff799aa5c0,0x00048de6d0a352ca,0x0008f5f2eb0f3051,0x000fea98f1062e2b,0x000285eca4dfe726,0x00044d322419400c,0x0001441ba1f95272,0x000c0f6113ec0c84,0x000b67f7b093769a,0x0000000000000001}},
    {{0x00010c16516e4d3c,0x000611e277c39f9f,0x00040673dd719aec,0x000e007e471514eb,0x0006cb0a884f04c5,0x0007cdfc977e1e7d,0x00096fd19b101b5e,0x0008b661589b4413,0x0006ee58455ad5da,0x00030384dfd6a666,0x0000000000000001}, {0x000dcee7cc09a195,0x000f049d8452fc3f,0x000453637f0d8b3f,0x0001dc43d12fc712,0x000f4b97aa7b885d,0x00030970db43c87b,0x000015eb8214e6b6,0x0006a5744b5ac5b8,0x0008d3fab8987808,0x0008438a227d82a5,0x0000000000000000}},
    {{0x0002d58e6de7c70e,0x000a184fd2b399ce,0x000d46ffafde56a0,0x0003266443a772e3,0x0009e5e99ec73618,0x00068acc975a652a,0x000b99dda22ced10,0x000f17534159829e,0x000ab0176c94c616,0x000fbda334609df6,0x0000000000000001}, {0x000e586ebac6018e,0x000f2f03144a03f0,0x00070d82d13df49e,0x000fad35f054795a,0x000bfca4e83c93d4,0x000ccd2e817178dc,0x00006d906f96d5dd,0x000999860a4c0599,0x0007c4473b0cc898,0x0002a9c7a2422f0b,0x0000000000000001}},
    {{0x0002b09542f251bc,0x000e9c6a4a88693c,0x000ca160d5142fa0,0x000a8912377d1615,0x000e8a6efbddaae6,0x000a4c058235658a,0x000f27a6a6dd7c56,0x00070769ea7bd61f,0x0006f5dde4e365fe,0x000d56d5c0ff87a3,0x0000000000000000}, {0x000ceae2e0074d51,0x0000c081ba44424f,0x000d9e0eec434166,0x000bbc85793c6ecf,0x0000cfdda19dc769,0x0009ff9b44e244b1,0x00055190f00a8e3e,0x000a30e6f1e94105,0x0002df24f630f9cd,0x000164028859bc1d,0x0000000000000001}},
    {{0x00091d8b229586b3,0x00062d4212a9d0d7,0x000a44dcf82dea37,0x000886a8066a0e31,0x000c8d5c7f9428cd,0x000e7fa7c681f5e4,0x000db54aa6ccbecd,0x000e8442c468c6ab,0x000eb0d35eb4fd66,0x000ecc62bfda1f45,0x0000000000000000}, {0x00043fbb4e2cb5f4,0x000b78f0a96488d5,0x0000f4585ef033e7,0x000ccf9f3f7c9386,0x0002c56f736843a4,0x0003c2a98300d2f8,0x000d0e9651445c74,0x0006ad9774234178,0x000b0d7d2ff89fee,0x0002dc8f018f3a2c,0x0000000000000001}},
    {{0x000a0b1e42fb1d75,0x0005875ba8ec633c,0x0009652adf59ccbb,0x000c9a8c4da98461,0x000058421fa35715,0x000861494cf70c21,0x0001a367a4a6e22b,0x000f1f29e364cf7f,0x0002eb8412063103,0x000046241f101761,0x0000000000000001}, {0x00035295fd113dfe,0x00087ca26d83dc56,0x00009b60485e1379,0x0006992ee53da791,0x0003f63e81d304b9,0x0005e83c82169ed5,0x000cdfc2181cd77e,0x0002864256eb4e4a,0x000dd24e836cab6d,0x0000560017a3ed5b,0x0000000000000000}},
    {{0x0000d40ea7dbd218,0x0000bffd292d5f99,0x0000b3c033efe2aa,0x0003caf5350ffa07,0x00062cba18d05709,0x000de1ef348e77aa,0x00050628dcafce95,0x000654c13b978d30,0x0004b7581a218420,0x000aebc1eed7a302,0x0000000000000000}, {0x000467c3cff7787c,0x000cc65919f6e7d2,0x000e4ef4ee66f3a2,0x0005339dd95dc335,0x00083538624188b1,0x000c9f6ee9c47f71,0x000c2d00164075ad,0x0000fb8c9b9b8fc3,0x000ab425082f15ec,0x0003706da80b242c,0x0000000000000001}},
},
{   /* digit=93 [{1,2,3,..,}]*([2^372]*G)  */
    {{0x000981c54aaf54da,0x000345cebb5e6933,0x000544b1b1632546,0x0001b01f84cafbc6,0x000115cddc181798,0x000378ad86aa1393,0x00075fe68cbb4941,0x0009588ce3ac7e26,0x000708d627f2694e,0x000a9deda381ddab,0x0000000000000001}, {0x000d5f56fe3c020f,0x00064c1a13df6f31,0x00002f2a54ccdb45,0x00018f47586ae362,0x000f6db9ebb1f191,0x000b71b6517fa3e3,0x000f8c282c695b00,0x000758306aa882ec,0x000bb71fac8a72bb,0x0005351671f4f924,0x0000000000000001}},
    {{0x0008318350691a0c,0x000b269d0103c9cb,0x000bca486ca47a18,0x0001af062d151fe9,0x000e7c2bcd6c38a3,0x000a2dd4944c38da,0x000d5e2d0cab5f56,0x0001aaffb6b80e8d,0x000b4ab87f1aa045,0x000baad7ec926bd1,0x0000000000000000}, {0x0001499620b24214,0x0007f0d276179361,0x0005f42f5e14dbe6,0x000a3745bdaa4d19,0x000b02770c1ff9ae,0x00030746fe336a10,0x0005a19965986ef7,0x000598b61ae7500d,0x000c2b7c92c56a5b,0x0007c0f20ece26fb,0x0000000000000000}},
    {{0x00087e69d72ded5b,0x000cbed0493c7849,0x00059557a83ba0a5,0x000cabc475bbdb17,0x0003d65e4a623f2a,0x00071fb7df8bf3c5,0x000f576c8eb2466d,0x0003c6d8140f7545,0x00002bd4e620a012,0x000cb967837a469f,0x0000000000000001}, {0x000871f9216cfc43,0x000a4dc25382488b,0x000ef93af7d4b3a3,0x0003ed77dbf730c3,0x000a6f764526ebfd,0x000b6152b407f935,0x00025711c016476c,0x0003dee3ad5a2bf3,0x00009ed5688aaec7,0x0007cb5a614fc9fb,0x0000000000000001}},
    {{0x000d2983eb57fb01,0x0006f8090fc8d49a,0x00055cd8ed43313e,0x000063128651d168,0x0009d55315e356a9,0x0003731bdb591a91,0x00090f35172884d8,0x000ce2ac6b9b209c,0x000e9deccfbd125c,0x0004c67d19839d92,0x0000000000000000}, {0x0007835fb081749a,0x00038c29318405ed,0x000c88969fe7858c,0x000d9e6b39c13839,0x0001a193b85889e3,0x0000167b73a0e542,0x000e3a6c6ebad78e,0x000fea5061213cbb,0x000f99af7a8cbcf0,0x000934dbdf82d320,0x0000000000000001}},
    {{0x000dd97cee516977,0x000fc49266fa93ba,0x000b3371de037896,0x000f3467c9ec4ba4,0x000bff13f9988671,0x000c0500963fcb88,0x0009447add0b56dd,0x0005dc495e382a32,0x000c531e8e3d8f13,0x0003f8ab53419d64,0x0000000000000001}, {0x0005999b06e01bce,0x0004ac4c86e9d1b3,0x0001acac55379f5c,0x000ed5f60cf793db,0x000deecc778efaf8,0x0005438ff64587a9,0x000da09df4f7f063,0x00095b550b56ea7d,0x000d4a2f2118371b,0x000897f5ee846337,0x0000000000000001}},
    {{0x000e73c876ead4f8,0x000074f77e1ef006,0x00068e9d113a8d10,0x00068c4c79701512,0x000c8af63c9e4975,0x0001a355ba1ddb87,0x000a7f69e6cd38b6,0x0001a9ae068bd113,0x000bc3a633214952,0x000e40b4f3b0cfc9,0x0000000000000001}, {0x000dc3573f4bb5e4,0x000ce2ef087b7068,0x000ffeeffd386368,0x000053bd77e46931,0x0008c8fd63c43732,0x0009915ece7b6a54,0x0009d1980b122996,0x0000807d3a509f62,0x000abb80ee8c76fd,0x000ea6d20af82699,0x0000000000000001}},
    {{0x00023cc70a1b7646,0x000fb2fea8f69076,0x00051b6f61d27313,0x00053b59960e18ea,0x0003b52c79117607,0x0003c4870ae1dead,0x000b0ba34bd1f16b,0x000eb6ec0bc7a291,0x000e48716fbdf694,0x000f3b9ceb0fbb83,0x0000000000000001}, {0x000f4df150c14682,0x0004d73e71ecfad2,0x0001f4eed11e2bf5,0x000e8f7ba0e6130a,0x000d0ee611881177,0x0004b3748fb1ee0f,0x00018bc0f1b2681f,0x000d95b14d7b81f4,0x0005715bb9df9123,0x00010458047bf5c1,0x0000000000000001}},
    {{0x0007c0378bc40ed7,0x000325851811caa9,0x0000425fd5a042ad,0x00083181ae223e37,0x000dcf721e5a193b,0x000e3457f090e949,0x000bab83df6a8520,0x00045f22447cb654,0x0000dfbcc720ad35,0x00030064eddb51ec,0x0000000000000001}, {0x0007e2d48a4ebf78,0x00086d5a22dda9a9,0x0004ad7ed63a6603,0x000bdfd6f4eac86c,0x0006ea0b3cfe90e9,0x0009746e43f3d057,0x000247c38598edeb,0x00066c63f53c5a4f,0x0007de7ce9110d7d,0x000580edc5628f93,0x0000000000000001}},
},
{   /* digit=94 [{1,2,3,..,}]*([2^376]*G)  */
    {{0x000ceb75a39240f6,0x000cd422d17ed307,0x000816d46db1d003,0x0000a452acb6fef8,0x000cb9bbe93acb00,0x000e7044e1a33425,0x000fc32d94105ed8,0x00077b448d72bf04,0x000527b278a8006d,0x0003f3ce1c27af77,0x0000000000000001}, {0x000e21a0404fea41,0x000ba2bea8a562ed,0x0007dcaa390fe905,0x000e3be58bd01814,0x00024ad37906a8c2,0x0004147c934bd6ba,0x0008700ab35993ee,0x0003eb32c19654b1,0x000e9fb6dc4b6283,0x000fffefce4982fd,0x0000000000000000}},
    {{0x0008ddce89d919a0,0x000c8653953842cb,0x000510be22ec94ea,0x0004fc6818af52b2,0x000d36cd384c6520,0x0000918e38b08bd4,0x0008cd3bbca8f664,0x000f9b3d5866c2ac,0x00015b5a22e4fdae,0x00028fcebfa696bd,0x0000000000000001}, {0x00086becff5dbeff,0x0002b0a9f4f0a089,0x0002781857ab5bde,0x000f7d34f623a384,0x000ab2fc32d5df48,0x000357b29a5aed2e,0x0002a4f85d8000c3,0x000a47c091a8d7a0,0x0008c875883e2289,0x00004c78f3991d74,0x0000000000000000}},
    {{0x0006929bd70c6394,0x00085f2018c22473,0x0004be72094183d0,0x00086c43b8504d5a,0x00086b6f18e21a1b,0x000ad297dd4ff469,0x0000f368a9142ac6,0x000e09fe86beaf09,0x0008c552b3b6921a,0x000bce953006e93c,0x0000000000000000}, {0x00072ac6e0006309,0x00015780956c6baf,0x000c4c2c5f7fa741,0x0001eba55e9870c9,0x00060f57cfca17ec,0x0006e490ccc10b4b,0x0008a9db0618cc6a,0x000131fe5f0039e9,0x000970dbcf0f5361,0x000700a442baa6b1,0x0000000000000001}},
    {{0x0003ec842981eb23,0x0008fb16678799e5,0x000db8c26f2eb3f7,0x000307e41091298b,0x000c2265d3b22e09,0x000829161a79682b,0x00094108a62536ff,0x0002002fb6dedea9,0x00079fdbc3d369ec,0x0002baf58b2f20ca,0x0000000000000000}, {0x00056d9fea698757,0x00041a61419646f7,0x000308b017c99346,0x0002b76a5de627fc,0x000cb23ee7d29bea,0x000ab47900ba8603,0x00096bb85c794766,0x000df41684cc004b,0x0007656ed94d547e,0x000e302003142b8b,0x0000000000000000}},
    {{0x0005cdf0222a69bc,0x0005e1e346fabbc8,0x000e07629de2b094,0x0005724f76a1e2b5,0x0006b43bc885c45e,0x000d1f53506f8c50,0x000458ec4a247aeb,0x000ee8c49a8e9759,0x000961f24ad9f81f,0x000c780789ce81ef,0x0000000000000000}, {0x000ac3a5a536c8ac,0x000fe30d120ebbbd,0x00029a29c912f38c,0x000d27e5470f8673,0x000f785f54b6aa93,0x00069bc2c6347ce7,0x00091c1681c6e838,0x00015f8951322402,0x00054c132d778a68,0x0009133565718293,0x0000000000000001}},
    {{0x000f8e71a3d24acd,0x000de7f8ccaa4039,0x0004a565eb389f9f,0x0001445b3a88c7c8,0x000b1b88e20b6224,0x00022d8db00479b1,0x000369096695cdce,0x000d48a7013202fe,0x000e3713baba6a66,0x0009b65be868e0af,0x0000000000000000}, {0x00018718a6375d71,0x0003fe3e38b8c6c5,0x000ee16d3bd00a61,0x0001a73a8bab2dac,0x0001decd0dde75f5,0x0009a19d5d5d598b,0x0002f5dcc2ed8e1f,0x0007b66c768674ed,0x000717b781a03645,0x000cd5eb14d9fd45,0x0000000000000001}},
    {{0x0009a4c40a33f00c,0x000d2d3bef2c63e1,0x000922215ae57c68,0x000763ee03e85348,0x000337a4a0d2cb54,0x00047d23204381fb,0x000be443d9712227,0x0007d96627f6c828,0x000fb6b5f6d1199b,0x000a433d2170b3ab,0x0000000000000001}, {0x0001d3366971bb69,0x0007a38c946a2ebb,0x000b29fb103a111d,0x00047d3675997def,0x000fd82824e10a96,0x00029d6d05a45fde,0x000500fa9b94f37f,0x0002317e08c1e35c,0x0006ed9214c60102,0x000ee0a2afcd4a2a,0x0000000000000001}},
    {{0x0003291f02ce62ff,0x0005b8a731176ae1,0x00053e5b4c8c2f09,0x000d5a2322d8f01b,0x00092f09c90539b8,0x000c4c22646cfad1,0x0008df5016016f3a,0x0002500c56f4c2d4,0x0006618c9bed5731,0x000f52249d380720,0x0000000000000000}, {0x00052bb2164b93c6,0x00009ba854f0dba7,0x0002bd9fbffad821,0x0002cee339d0e928,0x000515cfc63fee61,0x0008541bf33aca9e,0x0001f0f0fd5f8231,0x0008dccc44f51df1,0x000e26d92e5d7f0f,0x000334dc204c43c8,0x0000000000000000}},
},
{   /* digit=95 [{1,2,3,..,}]*([2^380]*G)  */
    {{0x000df775a4cea698,0x00057fa877dfb590,0x000f628f95d0e8c6,0x0004b622c58775b2,0x000e755966c521f9,0x000b826bcad94ba3,0x000585e536e18362,0x00056a8bf64e1429,0x000c0d065ab9cff4,0x000c6b7ad254f1fd,0x0000000000000001}, {0x000be22413e6824f,0x0009f5a869cd6010,0x000399cde94b5cc4,0x000c96f6029dfb84,0x00068c7d0822053b,0x0006cb5f4bf3d33d,0x00090bad70bd72fb,0x000c5f85b78281e7,0x000fbd3aad6b87dd,0x00067e9bddab2fd6,0x0000000000000000}},
    {{0x000f0963f658551e,0x0002ea1215b91acf,0x000276c4b8c7ce3e,0x0002c599ae4d76fd,0x00006cf3a3b9f27c,0x00006667b3985a81,0x00095ab3dd5545f7,0x000e9ae8ea63e5bf,0x0008eb3015a494d9,0x00014b36df8e2aac,0x0000000000000000}, {0x0001e0605f96eb43,0x000d54ec384ae024,0x000bfb3e2ee19fc3,0x000c041bce0a2d7c,0x000b57e0aa0d1a5a,0x000f6adf1022b978,0x000452550508726c,0x000b77d6d81e1380,0x000536c9802fbac9,0x0007d16666d2c234,0x0000000000000000}},
    {{0x000d75964c31ca58,0x0004e22c167fba0f,0x0006865896879fb3,0x00085f113d2ac14b,0x000fcf92650326bb,0x0009815c6ae567c4,0x000703330478f2d0,0x000c2d4e045bb2da,0x0004917027450186,0x0001cb3d6ff5bbeb,0x0000000000000000}, {0x0006aee5ed6230d6,0x0006f57fa7f974a9,0x000d445b19954b86,0x000cc41b7edd540d,0x0002f6672b9eada3,0x0005adb45c3c302e,0x00085355ea3de1bf,0x000a70efd3fa201f,0x0002e28049bc11d2,0x000a9e4d97e0553d,0x0000000000000000}},
    {{0x0005aaa83e0b7193,0x000ef4020dd38cdb,0x0000a2db89cf16c4,0x0008b727a5cd426b,0x000baf5617c8e43e,0x00043d6e5823ddc0,0x000180e259e17f2b,0x000506737413c826,0x0004e741255f63ef,0x00009623e6163c43,0x0000000000000001}, {0x00095e5ae0c64c88,0x0006e547505a1996,0x00074ec16e26e1e3,0x0001814a43d8b0e2,0x0004c037ed439483,0x00075672e85b1a10,0x00064a05bc4b4563,0x0004f4e8604b9fdc,0x000d8d54cdb5b099,0x0008d7035e5850a1,0x0000000000000000}},
    {{0x0006358cac1e1dd9,0x000326ae97ec9d6b,0x00096931bf3f89cd,0x0008a8a20db33ff8,0x000f15df6988b172,0x0009cd5efc8b413b,0x000bb187876052fc,0x0004662d8014980d,0x000d9235f7d44d41,0x000edff0c8921456,0x0000000000000000}, {0x0002553d46a6bdb6,0x000a25d43349dd7d,0x00098c5095dc275f,0x000e81697e9d6a23,0x00021486070955da,0x000de66e5e004d62,0x00061fc887538530,0x000b0cbeddeb407e,0x000968acbb1e576a,0x000ee36df6504685,0x0000000000000000}},
    {{0x0001376b4df2834d,0x0009122c927fc01d,0x000cb3e3200f4b1b,0x00077db8d6a633a1,0x000324c991410544,0x0009a4d4ddbf0c1c,0x0004f89da008df0a,0x000df68e550730c0,0x000e5c51e1a10f51,0x0008da410315475c,0x0000000000000001}, {0x000c76b031581137,0x000f3f4ca12b9bde,0x0004e3a329753a8b,0x000499c86ef86a89,0x000c838a372fcc5a,0x000ec44e4a97d666,0x0000ea241b991236,0x0001650c8dbf9560,0x0007627fd4eb71cc,0x00078654f79c844c,0x0000000000000000}},
    {{0x000ce7225c38fca0,0x000cf6f1a6e96969,0x0009cc6268e77785,0x000308efc7d8303c,0x0008a6b0e52762b8,0x0004bf9968cba9dc,0x000db7c416fd26fa,0x0000e7d932fa8c4c,0x0002063b5de7df0b,0x000a1bd8e36d9447,0x0000000000000000}, {0x0002f11b9d88f945,0x000b6a528d0c6d85,0x0000491c222e34eb,0x0005246f572cf3b4,0x000826a507a97323,0x00051b49545419c4,0x000f246a45d14681,0x0008555cac591e9f,0x00067c66c74cf909,0x000c814d10852a3f,0x0000000000000001}},
    {{0x0004d6495109aae5,0x000c4b86a81e7f4d,0x0004316eb1054df2,0x0006877c19b90005,0x0007963ac12d941b,0x000bdc46a9dbe383,0x000befbe68280f87,0x00071d97d1dc04af,0x000aabbcc64f8fe9,0x0008543ef9d7ecfd,0x0000000000000001}, {0x00056ebb21998e32,0x000ab05f744a3f42,0x000c6587a4d462bb,0x000c14a18de305cc,0x00056d2c0e8c5f7c,0x0007f552fd1c2fa4,0x000165b93096db0d,0x0003eef9e935df5d,0x00013440e0a7d4ef,0x00020c2ecbc3b683,0x0000000000000000}},
},
{   /* digit=96 [{1,2,3,..,}]*([2^384]*G)  */
    {{0x0003ac5243ed86b5,0x00075f9805e79dc4,0x0002bee2dfe95a21,0x000284b06125c31c,0x000a0103195082b6,0x000cedfa4a2264eb,0x000afa325bc143e8,0x000ae3ae24853199,0x000ebe96963067c6,0x00096c54a7cecdeb,0x0000000000000000}, {0x000e3a5229434e36,0x00055f3a1a50446d,0x000644f2db4f7215,0x000ad43f6dc38924,0x0002239beb126b72,0x000840de05e7dd77,0x0002862d6caacd0d,0x000bce6fa639c67a,0x000087602ba53021,0x000679ec9b598271,0x0000000000000000}},
    {{0x0005ed4dab9a7e9f,0x0006797aaab2f5b7,0x000301593051ee37,0x000962a30b02f44a,0x000a1d622cf13021,0x000a7dfa0555a3ee,0x0006aca4fcd685c9,0x000ad2e750777a2a,0x0006aa905bd4c914,0x0008ffeec52d7b1e,0x0000000000000001}, {0x00095204a3f6fa1e,0x000c34539f85e4fa,0x000e8ddc16e36eee,0x00044a9e74599d1c,0x0007ab343c6c5502,0x00007951ae714c01,0x0005c8c4503f92db,0x0006830499e544d1,0x000188a7b94680ff,0x000147d6c4809fe7,0x0000000000000000}},
    {{0x000e6ff25ab97af1,0x000ec754ac7f57b5,0x000607a92403e802,0x0000eca9aece9592,0x00080834b57b8bd9,0x000e2fcd37a127de,0x000ed63155d3ec1e,0x000f99b11a3b9b54,0x000db302a147172f,0x0005d9290b10d36a,0x0000000000000000}, {0x000eee6089f16e1a,0x000772f210e83cea,0x0002496230bbfc3c,0x000c1fbbcea01caa,0x00032cc99a5937d0,0x00074603f91be511,0x0003cfecb00c641e,0x000ef833255bc0f0,0x00085cab2f6311c8,0x000c7fcc61e9c871,0x0000000000000000}},
    {{0x000f147189a2546b,0x00070bf89fcfd41b,0x000a403ed89c0790,0x0003f861a107b324,0x0009b4dade6e318c,0x00032b6327665e9f,0x00016ecb408e3b33,0x000c11ee2181f62f,0x000ba590467bbd1b,0x000a0f4b5440b9d0,0x0000000000000001}, {0x000b1aa7ade86660,0x000d1a8a32a33d9c,0x0009ae722d5edb96,0x0004c7770654bd1b,0x0001d03d0e5a5166,0x000b01ee816a4a63,0x00015843d1d9344f,0x000c1e1821b3c769,0x000c22520be2d285,0x000fe7e0834d6faf,0x0000000000000001}},
    {{0x000a30d8168852db,0x0007853d06621fd0,0x0000e561a31ba03d,0x000e2351f7abbee6,0x000bfa802185d2d6,0x000a8cb11d19a8eb,0x000b4f2b7623f602,0x000f149b3db4a55d,0x000399a66e1d6eee,0x000dded7de613b1a,0x0000000000000000}, {0x000694da4aed0861,0x00013409999d11ea,0x00021cefe8e175cf,0x000ca47b4e5a0420,0x0008274d934ac552,0x000e270720e741b5,0x0003c0a8bd69787c,0x000e75f9cc756f74,0x0003e654e1ea2208,0x00040979701ca5a9,0x0000000000000000}},
    {{0x000d12f4d256a679,0x000fb6f240706408,0x0001c6799f2d7255,0x0002b1c7ad7d86d9,0x000c6259fb2898c3,0x000dc9f2eb172083,0x000f61ec85a5a26c,0x0002303eee79dca9,0x0003cc24582cff2b,0x000018aea38a1c28,0x0000000000000001}, {0x000fee514ac3447b,0x00004db0b385f6f7,0x000785b0f880a482,0x0006256aaff858dd,0x0005224f69e65ae6,0x00099c8d9092f5e3,0x000a4d5b2e1cceee,0x00065201f6ee40cf,0x000abc908fefbb83,0x000f4461f21689bc,0x0000000000000000}},
    {{0x0006ba04a3b21865,0x000b257a4daf424e,0x000a3bec5e4ad4b6,0x0001bf9b577cca5f,0x000e764bad272e02,0x0003f73ae3883e3d,0x00078df5e21be44c,0x00046e6d9107b020,0x00009a9e8ecf5414,0x00062dbf7ce0cbdd,0x0000000000000001}, {0x000ed268a93dd876,0x0001345efa0e6741,0x000a124edec5cb04,0x0002301ceb5830ec,0x000c074b8d138854,0x0003717a195a4b92,0x00078d388cdf3e4c,0x000aa6e0172f6f1a,0x000474fe593756f7,0x00063e14f10ad2f4,0x0000000000000000}},
    {{0x00056d8ef5183d33,0x0006d4aef07505d7,0x000fd1d5c09dd4c2,0x00026645b43bb4e7,0x000876a817eb253c,0x000209c32af92f54,0x00083a63e205a086,0x000d802502f8b9b8,0x00069b5a7a6f9cb8,0x000e8d87089ec121,0x0000000000000000}, {0x000c2981d5c3f78b,0x000fd7c0b6dcff4c,0x000e2051e1d39135,0x00056f990f800ca1,0x000bbae12c766764,0x000fc5fcbf987a86,0x000db02cbf344cfd,0x000965a4f55ea853,0x000d8cf4b24b115f,0x000ddb28cffa2bf4,0x0000000000000000}},
},
{   /* digit=97 [{1,2,3,..,}]*([2^388]*G)  */
    {{0x0004c9f1b01bbcb1,0x0008c564ba5d43cd,0x000b6d345ac26289,0x000156220f11b91d,0x000dcfa53c395f80,0x000e8f0647eb32e3,0x00071de125c49a24,0x00035c7837015374,0x000bc6a877a9741e,0x000a3e1c5d3aa600,0x0000000000000000}, {0x000eae31d5cbf2fb,0x000ff21336f73218,0x00063097ec47555d,0x000e41ac8f16a8d5,0x00010c063790a928,0x000842e2a872cf72,0x000d214bed4668e2,0x000e7b5aab91e7f0,0x0002089cbbd94783,0x000d7755df6f3c47,0x0000000000000000}},
    {{0x000c45be80c5ceff,0x0008b5f3a736f81d,0x000f684853db7b94,0x0007af37a1d8a120,0x000c1e37602997de,0x0001ba866cadb401,0x000496a24e3e6caa,0x0002c3eae9d6cd94,0x00074e14e06f82a8,0x000343069d99834a,0x0000000000000001}, {0x00060baf525e3e5c,0x000adc3855bae42a,0x00020017824fbb6a,0x000d2439950ab7cd,0x0001396b971049df,0x000925d16b65cd1e,0x0000815f2ec4dd14,0x00099059e2e1d82c,0x0007231633ba03a7,0x000c17f35a3c602f,0x0000000000000000}},
    {{0x0005cd392892c72b,0x000067c79588a466,0x0003e61043554996,0x000e4fea3dc40ec6,0x0006245b592ed7ab,0x000d5fddb91366af,0x0005bcef5cf9183d,0x0006f2afe7d93c79,0x00038f789bd81e98,0x000a24ae25969d23,0x0000000000000000}, {0x00015df628bff28b,0x0008b0238f67e086,0x000debae13d569b1,0x000537b081c52561,0x000e3e637e8d5f7e,0x0000b558a9b4dba0,0x00092e9e6c338cb1,0x00054c7742924ded,0x0001b877e357069a,0x00077dfb12df7675,0x0000000000000000}},
    {{0x000eac10daa6fc06,0x000a451d0d93fa05,0x00030dbe3663fb80,0x0003df5569a67246,0x000583a7b7740137,0x000a1bf5763b688d,0x00007976f4ce0d19,0x000972348a80c203,0x000296b9dd874e74,0x000ad726fc872424,0x0000000000000001}, {0x000626a33acca649,0x00019c0b206a34a4,0x000597e1cfe661fc,0x000915e61f98c11b,0x0006400c41adb010,0x000ed21859bdcb2d,0x000247507de82c2f,0x0007ba1295daeffa,0x0000842d673a4f29,0x0001721fc083b457,0x0000000000000000}},
    {{0x00034490e59e8714,0x0004db94a827c594,0x000be5c43f7b8f49,0x0005c1ed99f38332,0x000c89e5a5eae6d0,0x0007a328c3f873b0,0x000b195eb0205cc5,0x000957c8e1b9bcde,0x000a9c05764ec15f,0x0003785ee6082c58,0x0000000000000000}, {0x0006efc5f7d22a96,0x000c221343eb9e1a,0x000752365f225594,0x00006ed92aaffd4a,0x00047b4ac0a51a79,0x00034752a1b444db,0x0000b01d86935b36,0x000ff91905b43171,0x000a16a9f33a34ae,0x00098febd2ea9993,0x0000000000000000}},
    {{0x0009425bd3be24b1,0x000ddf604bb70186,0x00004732993f7d31,0x0003e481243d40e7,0x000cdd085631cbfd,0x00020a779443a447,0x0005a3d17a4bd6e9,0x000c2ba013a6f159,0x000091ba40454351,0x000bd45892d66dc6,0x0000000000000000}, {0x000413e025588ac6,0x0006b5fdc28cccb3,0x0001b7df9aa499d4,0x000dec43b5bc5fae,0x00066d0478edbc5a,0x000c5c7523db595f,0x000f66c3689cc921,0x000369286e3460ae,0x0009f5650aae055f,0x000ecf05c2d82ed3,0x0000000000000001}},
    {{0x0002dc4c335595b5,0x00087d3146806d12,0x000280502c85e0da,0x0006080ca34c63d6,0x00057bee19e4fbfb,0x000b329c24618627,0x00059c63cee44932,0x000729a1018b673d,0x00038096ab196705,0x0008deabcefcd004,0x0000000000000000}, {0x0008d702c45db29c,0x000164a83c7ff2f7,0x00004bdcc8d9c10d,0x0006a51badde1985,0x0007b3d628a8f0d9,0x000238514e884060,0x0003ad2af9123d94,0x0001c02c79997897,0x000547f0e64e4ad3,0x0009546706bd2921,0x0000000000000000}},
    {{0x000474c793f4e626,0x0001b9f27eccc505,0x0004061bf3c9bbd8,0x000776661385eed6,0x000ca2d5cbcfee54,0x000b0a8618a0f415,0x000c45418675f88a,0x000e0d5df7ae47e7,0x000f8808275324e3,0x0005bfe818ccf0e2,0x0000000000000000}, {0x000d8f452acbfbda,0x000031ef224de6c2,0x00070dcb7f79ce12,0x00097b18d958660b,0x000224dfd1c89c45,0x000d69ce10da0fa5,0x0001b65989afa822,0x00094e1b3fa146e8,0x0002ae217dcac503,0x0006327d3eef4183,0x0000000000000000}},
},
{   /* digit=98 [{1,2,3,..,}]*([2^392]*G)  */
    {{0x000f424e1d9c6487,0x0001fab2d1847091,0x000c18abe11482b3,0x00002a204548d244,0x000d2901117bfc9e,0x00086c34a4b1dc1c,0x00025a48ee98a6d2,0x000cb76b3ae604c3,0x0001c8298db518ae,0x00008fb7194b2498,0x0000000000000001}, {0x000055d976a5cca1,0x000a2cc7061a3bfd,0x0005a667bf88a107,0x00028dc3af0a63ac,0x000873e8641fb210,0x00040a558da80d94,0x000fc0963f8d8c7d,0x0009ccc465473acc,0x0005ce362fbd5307,0x00081d15006f15e8,0x0000000000000001}},
    {{0x00022141cc3287fc,0x00038266149a76c1,0x000fdcc4f6ec602d,0x000673e316b23844,0x0002f7ff0591cea0,0x000226449753082d,0x0008c9cafeaf6b58,0x000801a84f6bca52,0x000738672e240363,0x0000fb54c4174c43,0x0000000000000000}, {0x00005f340ab8f558,0x0003c50b6de62a42,0x000c67ea2a5a8485,0x000584f292e0d583,0x000976bb7a441296,0x000e6eb31fa9f0cd,0x0005886d0d33dfac,0x0005ca9b5dbb850b,0x0003bbd95e75a3fb,0x000aa9fc35ee4214,0x0000000000000000}},
    {{0x00048296df946f82,0x000d1ae0f7178948,0x0009fea01e8f3835,0x00032c83af761a04,0x000c81060dc76c7d,0x00037519156c5ff4,0x000bd4aec6a8a45c,0x000cdf6166cd6f1d,0x00042edd4a64bcec,0x00087353c4d352a9,0x0000000000000000}, {0x0007c5d100fac674,0x000db9e757c12a95,0x0005aae530260819,0x00099d6efbc64c70,0x00069b00bbd4972a,0x0000b755c13bf68d,0x000c9bf125fdc71f,0x0002e7e830894502,0x000fe09937e20c9f,0x00002b5fa7bc0dae,0x0000000000000000}},
    {{0x0006f3e4a3b653b6,0x000d1a688f6e0a4c,0x0009e0c6a622a9b6,0x00092759febdd4b3,0x0007de14d66ca7fb,0x000a2edb8e3d698e,0x0001ab808ea4d110,0x00080f85570610b2,0x0004c29e8f8405b0,0x00027dadf7ff6310,0x0000000000000001}, {0x00057c2f52f741db,0x0008e2e671ed8847,0x000d5288875b3801,0x000d96a8629331d9,0x0005a7e602196279,0x0001f2dc09559eca,0x0008fe5f274c1468,0x0006483d04249681,0x000f5286b1c8246f,0x00077944ba105276,0x0000000000000001}},
    {{0x00065afeabf73b11,0x0008c74def9ab376,0x00022e8ebbf2f73b,0x000cbc3cc29566a6,0x000e491e3c34a56e,0x0005e3e30062fb22,0x0008f34bd61c9faa,0x0006ad9002a6b766,0x0001e57f55fbc947,0x00052212e9e41cf0,0x0000000000000001}, {0x0000895f7a4eff76,0x00077650f0c0269a,0x000b638552f2435d,0x000cabbe1734cb6d,0x000ac1912708cc1d,0x00051cb37cd08219,0x0002a65eea8444e1,0x000bbf996f86f52b,0x000fc6bb767f7430,0x000d61b13f4e2c8e,0x0000000000000001}},
    {{0x000d5ccc9d50240d,0x00084d2e5496b2b0,0x000f884405e473c3,0x00057903c51b5ae8,0x000d55afcc0675e0,0x000125af4b250a76,0x000937bc2b1d7e99,0x000a633470b9206a,0x0000cfe28137ad4e,0x0002cd8906210714,0x0000000000000000}, {0x000877153680ec3c,0x00019913626b5dae,0x000bd89f532b2d72,0x000d578470af1c82,0x000b3f975bb94d7b,0x000f53a6076b8092,0x000db22bb5b744d5,0x000f43f924c34cb2,0x0006114e078b5812,0x000fb3e3de49501e,0x0000000000000000}},
    {{0x00028536905d5e34,0x00092fdd83e93bc7,0x0001a64b28a1f75a,0x000a170fe5a66cb3,0x0001e6a59754016b,0x000c5178f6263ade,0x000bc78f0892f5d7,0x0002723285c0f5f3,0x000ce420f8de3807,0x0004c264b36ac9d2,0x0000000000000001}, {0x000334fb73061393,0x000f6bbeabea50b7,0x000a60e0b4b57374,0x000565e15377dc7c,0x000ef0ff94b0e964,0x000e47e49a96f0ea,0x00030ac68d3dc2bc,0x0009347ee5d6453c,0x000eac1f6901d599,0x000086abf91bda19,0x0000000000000000}},
    {{0x000d441660f7e89b,0x0004d20a8f4b5442,0x000f7bf31e592476,0x0002835026e4af60,0x000359fc53bdf7be,0x00012726ea080568,0x00075b1726e147ea,0x0001ca2a0207d5e1,0x000322cae833e591,0x000e936cba51a14d,0x0000000000000001}, {0x000a1d6534e7b937,0x00065ce0948dd2da,0x0002f88e2acca2b5,0x00091e6c94ccb3a4,0x000c7d8fe477585d,0x000807f46db59ceb,0x000b940f42378210,0x000e402ecff0fc9e,0x0007bc598d173f94,0x000f16af975145bf,0x0000000000000001}},
},
{   /* digit=99 [{1,2,3,..,}]*([2^396]*G)  */
    {{0x000942a4c75e9fe7,0x000c673dad29e115,0x000e6be55a2350de,0x00045659ca3c399f,0x0003c87e22652712,0x000bd4c4458f51c6,0x00057db758ae1a11,0x000c547db810319b,0x000c8ba847d5c89d,0x000239959a5bbe62,0x0000000000000001}, {0x0003d490f3876f02,0x000521482b690e8c,0x00083aada0850d48,0x0004a53582c13331,0x0007bae5a342545c,0x0001c50d6f31c146,0x000d97c2d093b815,0x000e82d6fbdb84a7,0x00053468edb41ffb,0x0009e6ae0e9fad49,0x0000000000000000}},
    {{0x00060773f6c223a7,0x000ee1e8255739aa,0x000672547b158459,0x0000639d3f4e65fb,0x000635059b89e003,0x000ffb7b9ac29a4f,0x000cad3267e18233,0x000a7f7d6bbb6854,0x000d91b6e79c3b99,0x00065ebec22c4720,0x0000000000000000}, {0x0002fbb0f6be8071,0x0006dc307d9b73d7,0x000c6fa2f527f8c4,0x000e537cfbf3d06f,0x00018d7888122d62,0x0001ea61a84ebd38,0x0005532479a6f831,0x0004a4bf3325eafa,0x000717809c7a3155,0x0000399520a8095a,0x0000000000000001}},
    {{0x000b807898f2ae67,0x000d7e4f60fc8927,0x000bd2ecac1c97bb,0x00075b365b008578,0x000f53b54d53eaaf,0x000e5a0ab86540b6,0x00009c6ac54c1d9c,0x000267e6b65d52d9,0x000a061126607ea0,0x00011c0a94e0f97e,0x0000000000000000}, {0x000dd52c7077ac64,0x000e6849bb24e97f,0x000e60101c7fc9b8,0x000e52f0dcbe3ce9,0x000023c779930c2a,0x00050df58185f016,0x000a6864a7c2cfea,0x000d52f720dc8c89,0x0006aecf1e2d3b3f,0x000fe51ac6cabd56,0x0000000000000000}},
    {{0x0002f47341f417ba,0x000cd8bb740324e4,0x000e45bfed89909b,0x00089a7fe9550616,0x000b7861f9828778,0x0008946a71446a53,0x0006502fbe6cdbfc,0x000f70373dcf7291,0x000b59a0e59c8ba5,0x0004ed07606ee31a,0x0000000000000001}, {0x0003f237a7cf7e71,0x000f61b5ddd50efa,0x00056f3a63a0f211,0x0004dae68319e664,0x00090e5acc6a3312,0x000d6c5fe3f2c7d0,0x0005f435cc8df625,0x000420f4229fa016,0x0009c92c95adf8ff,0x000c03d951affc2e,0x0000000000000000}},
    {{0x0008e856f1a63237,0x000c38cfb4864e09,0x000a9b6c8ef2a48d,0x000565ee070c9954,0x000b247d25c31c3e,0x000d383653eec5d7,0x00033815ac0ce45d,0x0001d40035f31f5f,0x00016fd77486c728,0x0002145bbe546eb5,0x0000000000000000}, {0x000f8a00f9535f58,0x0006793f432f2f0d,0x000a22b5ed0740ff,0x00046e71ff907935,0x0006ed013a6683d4,0x0006c4dc5feeee1f,0x000e49d371167831,0x000c07fabe848ed6,0x000dbccd8d710493,0x0003939263e99e29,0x0000000000000001}},
    {{0x0009123d0b7caf2a,0x00010c9813e058eb,0x000b14ecd8d170c4,0x000aafb543a445ef,0x00066b13251ba12c,0x000a58ee44692c76,0x0009f4193734f736,0x000a0ff39b6d1ecf,0x00049d16c582e2c3,0x000a54bc874e11dd,0x0000000000000000}, {0x00086c1422f1debe,0x000be6be161bed99,0x00094c11992adb85,0x0007d02a974392b1,0x000dc1355dd0b472,0x00001779ff9ef84f,0x0008dc1dbbcd1c30,0x0007615360f70921,0x000cd90cece2bff5,0x000a085b2b4772a1,0x0000000000000000}},
    {{0x000bac8ffc9b1cbb,0x00041fbeb1c7a5f9,0x00032bb744d70f6e,0x0006377a1f50a7aa,0x00008611c61b42a6,0x000ce936f3324a60,0x000a084c3dc201c1,0x0002b70db700c5bc,0x000f0caf347988c8,0x00025e2dfe3675fe,0x0000000000000001}, {0x000fee427e9f9424,0x00069a165d8d1c76,0x000dc1fbe1e937f2,0x000db180dfee35cc,0x000b55475d4c9745,0x00036d0a2fefc6cd,0x000476726ccd4e8b,0x000f3783e580f7ab,0x0005d079b31ff3c1,0x00009ced18ab19ce,0x0000000000000001}},
    {{0x0000806a0ffa1183,0x000b368c8ad93735,0x00045322006bc207,0x000356cef3feb2a7,0x0000d9772041b29b,0x00015326534db436,0x000c3a4ffd400337,0x0004525bb0cb62b4,0x0003dfc1aef8cba9,0x00023c5f95e7e7b2,0x0000000000000001}, {0x0009f0d5faafe7a7,0x00079f056236883a,0x000e0f2e02fe7ca4,0x00020a75821e669e,0x000fc3208dc12d93,0x000c95bd4d2a90f1,0x000127ab836d5d0a,0x0006a56f1f5b0f15,0x00053533b35a8c80,0x000e1db5d6ee484b,0x0000000000000000}},
},
{   /* digit=100 [{1,2,3,..,}]*([2^400]*G)  */
    {{0x000b291af321cc48,0x0000d263480c29b1,0x000ec9060276afae,0x000489d0d90afac7,0x000ec62d3da37067,0x00088f38b3e31b78,0x0007f35ff5fafe7d,0x0007885361013dfa,0x000270f897a6237d,0x000c2a42a2eac980,0x0000000000000000}, {0x000b6527c69198d0,0x0008c038b2196095,0x00056c8573aab3e2,0x000c299349dbf002,0x0009c016fc238b06,0x000c26c63dc550c5,0x000712822cb43957,0x00044a5765b7d6c8,0x0000be87f42f34ea,0x00061a9436ed5036,0x0000000000000000}},
    {{0x0006c0f3c9200410,0x000c1523b6d0c7cf,0x000b2a524b701323,0x00080e1d445c4f05,0x000cfb721bd24fb2,0x0004d74f5043a450,0x000c3ca459a36903,0x0001f8a997769ed3,0x0004569349bd35cd,0x000fa7a1b94559af,0x0000000000000000}, {0x000479e9fda50d86,0x00039193e5dd5ac7,0x000fcfc382ffdaf1,0x0006e937727251e2,0x000819f976e0e477,0x000e0dea37faf936,0x0002b3218ec38c97,0x00020308bb264566,0x000441534d581e3f,0x000046c275dc071a,0x0000000000000001}},
    {{0x000cb5968e20ed2c,0x000a52702c5bb89b,0x00033f897addfb47,0x000f030ce16c51a7,0x000945e8bc092078,0x0000a224a9b9a4c1,0x00074fb0d2a2dbea,0x000a00b01506244c,0x000403180ef3b3ed,0x0000d544f09c72f4,0x0000000000000001}, {0x0007f0289c261b7e,0x000d803c0211ff4a,0x0001ffe93b188323,0x000b503181a127a4,0x000960bd651117de,0x000f238b1565ffd2,0x000706280cef133f,0x0004ddb33d18643d,0x00057a46393ccc6e,0x00011d1fcc4678c9,0x0000000000000001}},
    {{0x000cb18067eb6c9c,0x000904e0e232321c,0x000c2c362eb5eae4,0x0004f20ada675b34,0x0009513d2fa912c1,0x000c8c7ff960f4ae,0x000ea3278df20646,0x0004b702cc146790,0x000b87bb57608da3,0x000f1fadae0fb9e2,0x0000000000000001}, {0x0006a843b0ca7a84,0x000ffac89f77d5a2,0x000265d14c35a368,0x000486e7957c89a9,0x000f9514b7e05bd1,0x00037cf3d5a9030e,0x0002008b9ea39985,0x00050c45cfba4fb3,0x0008d5a1561ff956,0x000bc01cc6a56407,0x0000000000000001}},
    {{0x0005bb52ea9ac7ec,0x000e28f7ce0ec366,0x0004c059fd569d2f,0x0000e89276b354dc,0x00013674b639e129,0x00051c92206d8283,0x0005fd8d62852509,0x00083a0ba16eee81,0x00023ff408ee3851,0x000e736678fced53,0x0000000000000001}, {0x000a8b28dba67d24,0x000216ba84ecb673,0x00034998afbbd048,0x0004e06cfb264967,0x00064c024c958fcd,0x000c3e07fdd668c7,0x000e902ee5004559,0x000c7be484240ea9,0x00085d1cbdf78504,0x00001fc315ffe9b1,0x0000000000000000}},
    {{0x0003f67e6d554604,0x000a7edbdf25d6db,0x0004a86faf823503,0x000561d458cbd82a,0x000fd50ad1fb2727,0x000d57e2f00994b8,0x0006a571b2b47251,0x00025dcba3cd1573,0x0003351634df5819,0x000f90f716e579ec,0x0000000000000001}, {0x00015c741fd15e62,0x000782e4509eb436,0x000bb1dede8ef754,0x000e32d87a793f6d,0x000cb27d972fea02,0x0000af4ace00b65e,0x000665980ede0c9d,0x000f6c809dcb9681,0x0003f6f1f979a653,0x000fa70638c8e694,0x0000000000000001}},
    {{0x00069573569a82f9,0x00074c79907894c3,0x000923a4f546a942,0x0003c148a698895f,0x000c357afe3d1621,0x0000597be114eca3,0x0008bde57638ac14,0x000ab1f30c4d2325,0x000c1e648b9d09ce,0x000b5b544e3974e2,0x0000000000000000}, {0x000a45f392d296b8,0x0008740111ad4028,0x000c3e262fdbe28f,0x000c3453830a9ee4,0x000ae0fdaa4f4e3c,0x000db8b9c8044def,0x000827b06665f64c,0x0004b0bfa5e94a06,0x000288ab3926f336,0x00095cd9d3c3ecaf,0x0000000000000000}},
    {{0x000b181f2f210670,0x0009ac047db30c5e,0x000f0b9977abb73f,0x000685fec5355db3,0x000cba356655da26,0x00050bb7fd48c1a2,0x000094ac2c2dc459,0x0002437ff8a8e766,0x00026425d80146ca,0x000d215b7aafe50b,0x0000000000000001}, {0x0008a54b77260e44,0x000200683c3c461c,0x000806c758fee244,0x000ee02fb90af5d8,0x0005167ac6f6571d,0x000f1dfed253aeab,0x00051fc762d73380,0x000f059d556559bf,0x0001430491432973,0x00077ebf133e93a9,0x0000000000000001}},
},
{   /* digit=101 [{1,2,3,..,}]*([2^404]*G)  */
    {{0x0002ff226442343f,0x000cd833f176501e,0x00095759918597f6,0x0008de415f1a7fb7,0x000e4316d41dcb51,0x00029d89c6966644,0x000513d7775eaca8,0x000a9d45da4eed7a,0x0002852aadd14ef8,0x00062ec016fff623,0x0000000000000001}, {0x00091f95c7b230dd,0x000a732cc46d0d07,0x00004775f23d4641,0x000d9d15b9dcdfdd,0x0007a727ace99c9b,0x00077fe3e5aec6f6,0x00023beeac1ee2fa,0x00008f21d63275b9,0x00065885355852cf,0x000ce1be6d4550b6,0x0000000000000000}},
    {{0x0006e321251c61dc,0x0002560a1fff242c,0x000a45d55894b5a6,0x000bc8f1bc1ece0d,0x00099655945af852,0x00081d51a6f4152e,0x00048184573b7d9f,0x000f69e42e8015c7,0x000b2c20669dba53,0x000e9f9624512355,0x0000000000000000}, {0x000c96019553b866,0x000abe8a5146d011,0x0006c8e83c7c8d9f,0x000d33f93fede45c,0x0006fb87d2fad3d5,0x0007a48456e1fe30,0x000e6e9f030c2436,0x000ab8f59e2c2aa7,0x000e2ecee8097392,0x000ce7dbed7e8f7a,0x0000000000000001}},
    {{0x0009869c0eb3066b,0x000607798fe984da,0x000507796822415b,0x000b35e4cf4e7bb0,0x00043514e2eac3dd,0x0006f5f2ec73d5e0,0x00073c55dac4fc5a,0x00009ae9d9b66b29,0x000e7849157dbfd1,0x000a5482a9437d4b,0x0000000000000001}, {0x000c4e943ae95512,0x0006cf652253cdb5,0x000d6ec12d70a741,0x000569eacfb8355d,0x000eedc557ace0f2,0x00079ed65a726737,0x000cbaa427929f79,0x000f9f7b12d69985,0x000f61768135719d,0x000ae5a402492b60,0x0000000000000001}},
    {{0x000feaf2d1e3892c,0x000ab68c7ed96e8e,0x0003cb959b9f3e2f,0x000c2e34fe65989c,0x00089b397dfd24ce,0x0005a4f7a72a8210,0x0003d4d194fcfc29,0x0004009eac36cd18,0x0004df54ac2005f3,0x00037ac4355ce338,0x0000000000000000}, {0x00018f15a5288002,0x00084aab158f0c62,0x000919d3c1cc9db6,0x000c654f22157c5c,0x00061a5d7e7c5733,0x000dc89cd41bb67f,0x00046690cac1f786,0x000f2b55f183f6e7,0x000f41e4cb445fa4,0x0005a969c4dd429d,0x0000000000000000}},
    {{0x000f3df64800b6f3,0x000d7480b73133bc,0x000b600425660d57,0x000b837e3aef4df6,0x0005fb5d2c2dd02d,0x00011fe018b03d5a,0x000c71322317085a,0x000d374ad3a452d3,0x000a4d81aa830346,0x0004a3299709ce7b,0x0000000000000001}, {0x00016776ed8701be,0x0009a6af0a211f00,0x000ee5799e2d0b99,0x0004ffaa89dc73ac,0x0005974371ca9e1e,0x000e0cc77bcb98c1,0x000c6b4ceea4b327,0x000a8308bd6b7617,0x000c8a4f2fabfb14,0x0006930491f45b7a,0x0000000000000000}},
    {{0x000d9bdcbcf79471,0x00074d3dd4ca53d8,0x0001af7d8d51306c,0x000b82f03e680d58,0x000a7884ca0be9c6,0x000c62e3720aacdb,0x000ad9ad633f5955,0x0000c84d067a1c4c,0x000e24eee54e3c55,0x00019dbe3f67b54f,0x0000000000000001}, {0x00099b839c026b9e,0x000bc7d75cb7b6b9,0x0005e6b4aa8a5275,0x000156cdfaa9f40a,0x0004a1992d1c2e6b,0x000b18092816e51f,0x00027a900c94afd0,0x00010f9d0fb16b34,0x0008f98b409eefa5,0x000aaed3cae46309,0x0000000000000001}},
    {{0x00060d5e996dc11b,0x000619082845b56f,0x0006ef36f7ab0ecb,0x000d028f81fdfa6c,0x000060da295844af,0x0009596e31cc9ebb,0x000308c32eb79211,0x0001ea951754105b,0x00008750f063690e,0x00083b8a021ee964,0x0000000000000001}, {0x000d813e43ebc1f3,0x000af78ecca7ac06,0x000d8eb52a4c2d59,0x00067d3099d75877,0x0005b00d48668cb3,0x0002755481aaf570,0x0000b8ddd277a751,0x000dd4573c6cfa3c,0x00075e83624bf68a,0x000ee89ee03e9ce2,0x0000000000000001}},
    {{0x0001adc31d17fe65,0x000ba5bb3a93b688,0x000b603dd9e8ce1c,0x0008b0cf4f5b70c1,0x000175f958dd3aed,0x00070f44e15eae25,0x000177aa5b942f5b,0x000302efb949c526,0x0002ba3a2c8dd115,0x000b89f9288a9513,0x0000000000000001}, {0x0005972ebede20db,0x0005b1bc841aedc4,0x000933a99b87853d,0x000597276e1536aa,0x000a0238abf3c852,0x000485ab1105488f,0x0006d521debe07d8,0x0002f1ad18f16d6f,0x000d3c55a54637f9,0x000804a2b58773df,0x0000000000000000}},
},
{   /* digit=102 [{1,2,3,..,}]*([2^408]*G)  */
    {{0x00085142795b0fc9,0x00032b75a8973a1f,0x000125d27c2f65e5,0x000245efb7e6ca7e,0x000a3d37a1c1d680,0x0008ed8871c0ac3f,0x000f92273ed1f61c,0x000f1c0619b125a3,0x000c151e1baaf99b,0x000b5fb9c92ca12f,0x0000000000000001}, {0x000d45f1302c2800,0x00028a46eca65c4c,0x000181d940c2f16b,0x00008156dae561c3,0x000ffdb51b5dbdef,0x0007d0f3f05aff9f,0x000216756731470d,0x000d3e4323b09f64,0x000c256f1c5c736f,0x000c46af757ebac2,0x0000000000000000}},
    {{0x0008b99d3a5cf086,0x000a6f7dad9f189d,0x0009613956296f2e,0x00029ebaf5d410b4,0x000d4c6b1f46d86c,0x0001709ad92dbba6,0x0000cc09de07504b,0x0006c7c9ec95eea8,0x00007648647d01eb,0x000b3919b1d6cd99,0x0000000000000000}, {0x0005f9f34e61ba7e,0x000eff53cc24a00a,0x000672781ea5e367,0x0005266f275cfce0,0x0009992d98139edc,0x0002c0efd50d9e20,0x000de18f3d9cb26c,0x000b647d23fe687b,0x00054a71ad97b9cc,0x00027a258eaff20c,0x0000000000000001}},
    {{0x0008f39dfcb8ed4b,0x000811922f1fcd37,0x000a2846f7edab95,0x000566857a64449b,0x0005d6755b91a9b1,0x00033e748b542e81,0x00055f4eecb18a57,0x0006c4663a3a4f59,0x00052acaf4bb5b32,0x00079a0d2cfa0bdf,0x0000000000000001}, {0x000a0b89e0ca131f,0x000be75df1d52db6,0x000534480e6cb8fa,0x000be7af1d438291,0x000ad1a493673eca,0x000a16c7e34998f0,0x000d3ab56804db13,0x000479fc142bd461,0x000daa988aca4c3a,0x0001acd3bd93e84a,0x0000000000000001}},
    {{0x000cbad8f99ea394,0x000cf3fa23022a30,0x0009f3a186b0f3c6,0x000e922b33420e3c,0x000c1bffbbdb1dc6,0x000aa59cdeeac227,0x0003dd943d5b8787,0x0005513a5be5e367,0x0004c0fefae77a5b,0x0003518e4c10fcbc,0x0000000000000000}, {0x00024505728229a8,0x00014b020fe0ed2a,0x00039e8625b5e8e9,0x000ac893dbd2dbf4,0x0002a5bf5b95c3df,0x0009c6d879c2cfde,0x000a75fca30a3152,0x000f3ac05ce905a9,0x000445553894b84c,0x000dc2eb87696cb5,0x0000000000000000}},
    {{0x000c1e6489e4e3ff,0x000e40fadb280ee1,0x0009bea8383ad81c,0x000e1b3d235f576b,0x000a3198405d1a52,0x00058352c1e2f66a,0x0004288cd9077fa6,0x000dbd50c9d00a90,0x0009bd9a7d893793,0x000b363fd16ecce4,0x0000000000000001}, {0x00020eac52973702,0x0003e0c70e76207c,0x00006b2a996d0f74,0x000f4f6a44bb0744,0x000df28bc6807b4d,0x00017b088a4a4664,0x000ec1355d57eb8f,0x000182cf9ce6cfbc,0x000610a314e418de,0x00010173ffff5e3f,0x0000000000000001}},
    {{0x000165051d386e1e,0x000bd47b826f3a9b,0x000a1c2b86d2360d,0x0009b8835ea5cf34,0x0009783bb9260611,0x0002b789b3e982a5,0x000e987100210011,0x00097fc2b9ab3e6b,0x000ba0e81d76b916,0x0007fbcd1d8d4518,0x0000000000000000}, {0x00091e776c559b38,0x0004c1e4fe7c517d,0x0006b3ca068cf1e7,0x0001a6fbc371e38f,0x0003b1539a3d7c5a,0x000cd0c3d50e8468,0x000c7e40ea4660b7,0x00012b9d873faeb0,0x0007f3ea3f2ff663,0x000c8c52e58fcf13,0x0000000000000001}},
    {{0x000e0d1c0e7b0a6e,0x000182d5a79223c1,0x0002d07160d41c08,0x000de95d46cca38e,0x0004d00dd9df759c,0x0001f3ff3dc94e0c,0x000ad18e4b33fc34,0x000d2cfdbdfdd807,0x000c70a120714770,0x0005cb86265c3704,0x0000000000000001}, {0x0002e095e7588e93,0x000bb0fc7a7538c8,0x00049b1bf8ce184d,0x0006eac46bad884f,0x000da577205521af,0x00073592b9bc40d1,0x000dae6302c8fae5,0x000e9a408dc07f7a,0x000d86c203a973c3,0x000db4c1145f0edb,0x0000000000000000}},
    {{0x000b134fd6bc3c71,0x00030305a92256f9,0x0007ccfce0b23245,0x000ca36a6d8cb621,0x000236d0ef54fd61,0x000a182b1b210c1e,0x000e2c48ae4f2531,0x000aa16671b7b1f2,0x0001cf556d29f38d,0x0001c83fa6c8eaae,0x0000000000000000}, {0x000a18df67396e49,0x000978a098406db9,0x000d15a5ed3d588a,0x0008786d781ea818,0x000c4ad06fce15e6,0x0006d7a550f98680,0x0004140981589bd6,0x000f7ff83976d3ff,0x00088eabc6ffe6df,0x00031647479f189c,0x0000000000000001}},
},
{   /* digit=103 [{1,2,3,..,}]*([2^412]*G)  */
    {{0x0000d7e3378fb507,0x000c9bb0731c42eb,0x0005dc372a3657ba,0x00074ab3d967282a,0x00057f9ac8856a93,0x000b740967bdf210,0x0003024fec8274b3,0x00015596459a5693,0x000d21c1794a1687,0x000a98ef7bcfc7c8,0x0000000000000000}, {0x000af7b9ab0a89f0,0x000a24bfd8b660f9,0x0009cb13ed97b728,0x0000fd15ee5e0227,0x000febd3b7d28a45,0x000367bf5b972ff1,0x00091b608f71ea2f,0x000f496276edaa41,0x000a6a4c152d016b,0x0000bf52e7daddc4,0x0000000000000001}},
    {{0x000ed176dc4c781a,0x000f2149979e6d8c,0x000b3c390a71d8f2,0x0009ec42d1cc9018,0x00013805d407dff4,0x00092c79f656592d,0x000250a69b4fae8b,0x0009ea40b75d7816,0x000e49fbb9c23c18,0x000630012080c698,0x0000000000000001}, {0x000297ec2f3d27ef,0x0009b4394adc76de,0x000084a2dca39d2e,0x0004162fa4a3c98c,0x000de4df52d9fff5,0x0006af6c27847a48,0x00049729a4d9dcca,0x000b96ed3609128a,0x0002001168323c41,0x00051e81fed2290a,0x0000000000000000}},
    {{0x00023ceeaf6fda5e,0x000fb751aba8d27a,0x00058878762241c7,0x0009d28160069d96,0x0001830ade2dd51c,0x0001c3eb509b6317,0x000cb86f909879a9,0x000dee7eb48aca8d,0x00028bf799244bc3,0x0009202a06470538,0x0000000000000000}, {0x00015f7fc2843df9,0x0002f53ba48f85a0,0x00095ae129c2b6a1,0x000ddb2a444e10a6,0x0006aecfba54d8ae,0x0007c39b4f0e8bdf,0x000e6010a72c4d1c,0x000d5cdfd0f373b3,0x00068c9e099b50a0,0x0001c8bed1929d51,0x0000000000000001}},
    {{0x000c2c46683ba5b5,0x00057c57128a2090,0x000dbf610a813452,0x000009fdd16c4a33,0x000c78f1d5b65bff,0x000560ad02b49af8,0x000ea450eb8499df,0x0003a52dc630fb45,0x000da8ac57e35202,0x000fb72fd6cb3d8a,0x0000000000000001}, {0x0006d77839d10202,0x000f1f4a52a42a8f,0x0004175b2fd3f44a,0x000ac14905fe7f14,0x000701757d0c0079,0x0008ae6d1c475fac,0x000d56b7bfd93878,0x0001b7dbf13b33f3,0x000d1df20cacad13,0x0006098aef62c8eb,0x0000000000000000}},
    {{0x000224c02776a096,0x000fdf0428bd2668,0x000824486a9c4320,0x0009f3de8bb8cb98,0x00008a99c85515ad,0x00087cd9c5ea0fc3,0x00030bd0c213cb33,0x00075f7ddf36e0e9,0x0008b09a16a3e9e2,0x000ff92ba0c69ed0,0x0000000000000001}, {0x000dd8b8dacd787a,0x00044526b1b4ed23,0x000c4fcde2872824,0x000a0aecc5884baf,0x0000edf7e8ded34b,0x000a4bc010f4ef7d,0x0007a006485cbfe6,0x000ba70311a2f225,0x00032199cd733758,0x000ee0992d474968,0x0000000000000001}},
    {{0x000d4dc4b29d1e7e,0x000ced039d3b8a01,0x000815590ff2c2bd,0x00021d5655ef3773,0x0006fddb06996f34,0x0006f2915cab4832,0x0005a14903f506e5,0x0004bd51fa3522da,0x0009df3d4ada1113,0x00041c2c8aabe985,0x0000000000000001}, {0x000708b80fba1a02,0x00028b6a0afd8d60,0x00058773df43d0b1,0x000ecec358a258ce,0x0008b0ae7440af59,0x0000e74789fcab99,0x0007429cf7b8fd56,0x000584c72e545e3c,0x0001897264b148aa,0x000a07b9a2d9b131,0x0000000000000000}},
    {{0x000edce9ca1286ed,0x000ff3a46b7fad16,0x000535c9d7d2b840,0x0003708d5ca958c2,0x0005420c1e063332,0x000713a6fa0fa9a8,0x000918405a51ff70,0x000da85f855da776,0x000d1bea73da5e0f,0x00064183a6508fa4,0x0000000000000001}, {0x00083d4f23ca730b,0x000725501529af4b,0x0008000d1b6d21a0,0x000a7b3eee3507cb,0x00022a88a07a33b4,0x000540f9d09c28e9,0x0004983b28faa40e,0x000f54edb432d0fc,0x000ce23569311803,0x000d266759b9bb64,0x0000000000000001}},
    {{0x000fd03e2a0c4500,0x000d5cf3f782f796,0x0003ffeae620bf4a,0x000ca0158514f603,0x000545633e085e39,0x0004884fbea88f4e,0x000882a85fc77f29,0x00012678c646f605,0x0009ba323a505f9b,0x00029223217b4379,0x0000000000000000}, {0x0002e8744f4170bf,0x00081a29194f6c03,0x000a932a7916cab1,0x000fb0f9f60ec063,0x000ff217a0ff0b94,0x00003ea56b8f066a,0x000ed4a56ee8b26d,0x0005efbf8ce2c1ff,0x0002eb114ed13051,0x00043d7447433992,0x0000000000000000}},
},
{   /* digit=104 [{1,2,3,..,}]*([2^416]*G)  */
    {{0x000affb50d183763,0x000c1c5fc7f37a88,0x000a1f73a2f170a0,0x0001192983474ff9,0x0006b4738ed4fea8,0x0004d293dcdd7868,0x0000cd916188a232,0x000bc585fd523667,0x000b67188a2e54db,0x0008ed10b37344d3,0x0000000000000000}, {0x000548b086336003,0x000991fbe0b348b4,0x000ef3cdca5ad120,0x000cfcd2034c9a59,0x0004f56699960d16,0x0006df1f5f10f252,0x00000324733c5f1f,0x000a757f84ed98a5,0x0002f7eec2ce4fa9,0x000ae3d296f3ba03,0x0000000000000001}},
    {{0x0004e9382b32007c,0x000d81cd77eae7c3,0x00013604a2dad7f0,0x00043d13d0e3fde5,0x0004c6cb59871704,0x000a8441d1c5f3e6,0x0002361adfd909c7,0x0004efba78610053,0x0001559070eb9abb,0x000708ee4fe6fb05,0x0000000000000001}, {0x00079200ca4f6cc8,0x000579128ad5ec75,0x000c265973749006,0x000f0a7f8cf2fa39,0x0002ddb548c37c9d,0x000da31069648b65,0x0006a7e075eeef13,0x000504d0e4093491,0x000fd613bea6b782,0x00055bba92eb2c08,0x0000000000000001}},
    {{0x0005ab4da4a4107d,0x000f0dbf85411a8b,0x000a933992a7b991,0x0000accdce47a748,0x000c5662f2eb8c82,0x00064b5fdd12508c,0x000db73adddfe6b9,0x000af97a44a31358,0x00044c5ddfefeaca,0x0003403a084f6ff5,0x0000000000000000}, {0x000ad406fec21428,0x000e8954cddbeba4,0x00092a7fe19ec844,0x00084bffa4c49f5f,0x000ec8eb76b96304,0x00014948f0f75a70,0x000dff2c139503c4,0x00032fdf031b7606,0x000fa11a5ead6208,0x00047ef7a1eba7c5,0x0000000000000001}},
    {{0x00073a3dabdb3534,0x0006dd5d8f611c69,0x000799bf33f3f4e8,0x00026f63749fb625,0x00092667bd3584a3,0x00060fa9fea81613,0x000999ea3a8de550,0x0004dd75d71ac4af,0x00078319418b1e64,0x000c67e995c857c8,0x0000000000000000}, {0x000c7afa552eb541,0x000a7222bb4a0732,0x000c7e0e1a608c59,0x00009057e1132506,0x0009c5c6a19981fa,0x00019205096b7bf3,0x000a7d38ab7490c4,0x00099e016ba7462b,0x00007f474dc3595d,0x0006636a3d8c9f12,0x0000000000000001}},
    {{0x000058d88f35f241,0x000a59b2e8d2532f,0x00015502597aca02,0x000fb1e8bd7d1caf,0x00055680e361da0d,0x000ed31cfd9355f1,0x00047c0b0064d2b2,0x0004f348830f3080,0x000b7440fbffaf7d,0x000a5a553b98e17b,0x0000000000000001}, {0x0000f6eacb637570,0x000d4925881bc39f,0x000d655e7e9a7105,0x0002f09a033db883,0x000e97d5a4975dc8,0x000036e619a17847,0x00079d0e9b209304,0x000434fdadf80484,0x000412216e6c7daa,0x0000eb152f330b19,0x0000000000000001}},
    {{0x000362cca8e2db27,0x000b58fb4260cc2d,0x000e2d527b899614,0x0001f0b467cb8aa3,0x000d1ef71b82f08c,0x000dc68072c4649a,0x00098aa11a9313c4,0x000165002fbe1ac2,0x0000bf5399f23796,0x00024b537dfdd6e9,0x0000000000000001}, {0x000f6c830ade2b53,0x00074af2e76469fc,0x00051f1bc5f4ed41,0x0000406c3a450f7e,0x00002b53708a683c,0x000428a6e3aa7dce,0x000c0df44b377b62,0x000e9c1a58f5f1ab,0x000c5458b0f02c35,0x000b16ea8718da27,0x0000000000000000}},
    {{0x000134d37c05c59c,0x0007233d57586878,0x0006cf5af7409f53,0x0008ae6dfc4fd018,0x000e8b54df4cc39a,0x0005f3046db1d402,0x000312aeece717b2,0x000da13a0c5d98af,0x00073d6305f96c47,0x000587c80a3e3a7f,0x0000000000000001}, {0x00027d5a2516f5d0,0x000f9338bbf8fa7f,0x0002109c7d0c4360,0x0006004be57b26a1,0x000da32aad5aeeea,0x00041aa5daf9dede,0x000b0a16abc83073,0x000088080bdafdd6,0x0004fa8814cecd6e,0x000f5f24b2b7fe1d,0x0000000000000000}},
    {{0x000cc19d6d74494a,0x0009296d31ebaa05,0x0003edd43b02f30e,0x000c79aac72cbbb4,0x000d57829df3e827,0x0008bb62624e4cf8,0x0004f05ffe745fb9,0x000950b350aaad89,0x000ea5e2db566ef1,0x000e1e37f6dcf4f2,0x0000000000000001}, {0x00034202ee7f3c59,0x000ed5d748da48fa,0x000e1cf505b68fd9,0x00031b86c7778cb3,0x000dbdadb45073af,0x0004b6e80bfe717f,0x0001ee413036b30b,0x0003482b138b2c3f,0x000e1ed1e4fc0159,0x000e84d788bd2771,0x0000000000000001}},
},
{   /* digit=105 [{1,2,3,..,}]*([2^420]*G)  */
    {{0x0009afb73836ce2c,0x00035d1c0854627d,0x000acf6649f2eb9d,0x000acf4c38a8a9ec,0x0002178be52c0095,0x0008f6e06df7d7ea,0x0008285115ce7bb4,0x000b7f232680bedc,0x0004103a6e51e8f4,0x000aaa09aa0bc0d2,0x0000000000000001}, {0x0001c4bc539f42b1,0x0009f1f757159ce1,0x0000e9e10c0bc8d0,0x0007345be3621884,0x000d1822e5e0a60d,0x000ae792acddc802,0x0006be0f49763d76,0x000dff0f1717868a,0x0004437867cae1bc,0x00070e8bfe19f269,0x0000000000000000}},
    {{0x0001b8994b02326b,0x00031ce496416ae0,0x000dc0825cea213f,0x00050bdf0281aa93,0x00059236853f9e44,0x00041e294dc8c09e,0x000b03a595c72a58,0x000c2bc6e5381e14,0x00020b03546b3008,0x0008eca57d1874ef,0x0000000000000000}, {0x00051a61ce5948af,0x000925d36a169359,0x0001712f7655b84b,0x0002f3fdc1e05016,0x0009aa758020ba42,0x0006927405b02281,0x0009822fced2aa8b,0x00019ae63d9313a7,0x000d9c07887cbebb,0x00065e13e45febcd,0x0000000000000001}},
    {{0x00034f1f7e499842,0x000a48878049fec4,0x000692a3fe1f0c9c,0x00048261277fbbb0,0x00032263dc0fe7ad,0x000e09052ac6fec0,0x000683804d38aeb7,0x000d6c55fb1237fd,0x000bce4b453925e9,0x00056ac33e2d8263,0x0000000000000000}, {0x000a764c5c6d3730,0x000ed9705b2adb70,0x0003bab4631b9f1b,0x00014535b4850149,0x0009c2385e82937a,0x0007aa5ebdcd9ea7,0x000656517e5b5eb0,0x00078fb6885fd321,0x00087f791c6b2bd8,0x000bcad44bfcfcce,0x0000000000000001}},
    {{0x000a7c1bbda99502,0x000d13ad86ee95d4,0x0001edd6edef741f,0x0001221485b8fada,0x00062b65b3c0a089,0x000583aac0300922,0x000ec2e6716727e3,0x0006d6729d8a817e,0x0002ad34233bfe29,0x000806779921dca9,0x0000000000000000}, {0x000373f0b0bc37c3,0x0006835632a2bfc1,0x000a8cd4f472c2b1,0x0004b6c9a4cedeb1,0x00076180690c132a,0x000eca05f9fa510c,0x0004e0551eb02c41,0x000e63213fc52e0f,0x0001b429bb6165cd,0x0002bc1fdd188cd9,0x0000000000000000}},
    {{0x000629f7658d599b,0x000b1e87d39d0d52,0x000caaa997607dbd,0x000fcf23eb7d6dd2,0x000857e0cd30a02f,0x0003ecd22778d510,0x0005c5e961e1f158,0x00068aa70a145465,0x000c8fb1ff96ec7c,0x0009b464d2f55e62,0x0000000000000001}, {0x000e904d20ac7941,0x000e4f0bec2602b6,0x00080f6effaef59a,0x00060688330793e6,0x000db2442ae08549,0x0005e3d773ff5a5f,0x000cecbc6ac0199c,0x00012fa7a795cacf,0x000d6f9bfc57e52d,0x000ce32e4eaeafdf,0x0000000000000000}},
    {{0x000eeeccbba2a7d7,0x000ad1d77ed0ffef,0x0005e752d769db74,0x00015b240b6200a7,0x000597b48ab8cfc3,0x000f97504538ef48,0x0005a2e980da41b6,0x000c0010c2010969,0x0007fe53f0d2b23a,0x000a1efe8b48887b,0x0000000000000001}, {0x0007b952e8dd021c,0x00026e6b8cb163c9,0x000d62feeed16bdd,0x0007e3db6129cfd5,0x0009dcfa4489e9be,0x000f551707d804ec,0x00012a2adb1fbcf8,0x000c05be22830553,0x000c9f74b7d87937,0x0008d7e5edd3be33,0x0000000000000000}},
    {{0x0004b2f4546a8f7e,0x000d2a223a807885,0x000155358a6954ae,0x00086e4b30349ae5,0x000a5982c7a2aae1,0x0006ca4f6415564a,0x000013abb73fd2e2,0x00092d10cb063fca,0x0006104963b01aea,0x000bbcd0f1f68f33,0x0000000000000000}, {0x00069aedbf43f1a2,0x000ebe1ef2c9b47f,0x0003246ee727e6d3,0x0003f5bd1a5a6120,0x000987e829b05fc2,0x000b70444c023806,0x000f0d6e903fa23f,0x000baba52743b14c,0x0009994d97e9872d,0x000a52cbf74f834a,0x0000000000000000}},
    {{0x0007ea3240feb8cc,0x000792ae77094407,0x0001201418e13db8,0x0003920cbc07e7f8,0x000aed56c93837f4,0x00013ae3d2a87da3,0x00044b8ddc44f1df,0x00069328fcaa2209,0x000b928d8e381964,0x0007313e55f26bee,0x0000000000000001}, {0x000ec4f451bd8008,0x0007bdfe195b7e42,0x000e12b70e68b680,0x000159222b99f5fa,0x0000c4e0659127ea,0x000efe86909b5076,0x0008c58b9b667112,0x00047b7026cf16a3,0x0007373740ea01a9,0x0000153963989580,0x0000000000000001}},
},
{   /* digit=106 [{1,2,3,..,}]*([2^424]*G)  */
    {{0x000546c7f70bcb2f,0x0007212027084052,0x00013f0d6d83c3eb,0x000eaca7142e7b62,0x00029f973a763019,0x000be00c2a025efc,0x0003eca6f6199ab8,0x0002b5618bcc0394,0x000b02749fbfb9ab,0x00013c0ae9ab795f,0x0000000000000001}, {0x000f295b93c3d712,0x000bf1ab6d0e9f50,0x000bf53d7cb083d8,0x000d744e07076abe,0x0005a51a53561f29,0x000d647b915c2fc1,0x0009ead253f84287,0x000e91bd9d6251a2,0x00006dd74006b7bc,0x000c92c770e4efe1,0x0000000000000001}},
    {{0x0002703ae4d5c812,0x000427e95afaa341,0x000271961d1eb61e,0x0000fb71509a4412,0x0007bef04644ecf6,0x00044d4556d64abf,0x0002a7bfd03e651f,0x00094add4bdd9b05,0x000438d74bb2156b,0x000fa36c6c16572a,0x0000000000000001}, {0x000ae16f96be2911,0x000d52afa2d73a0e,0x0005bc81a5a44951,0x0000fc89324d90b4,0x00018cab36337849,0x000cb411d87db838,0x00021f7d6cb710ad,0x0006ad26521480af,0x00094a666f370ca0,0x000375d8bc966e31,0x0000000000000000}},
    {{0x00082baa7d62ed15,0x000a2a0c35293a3e,0x00068a91eba6b63e,0x000715c2cd81a65b,0x000ed39839d20270,0x0001cd1c736c49a2,0x00023b8eae3fee67,0x000006012e0a11a6,0x0006b901f0657746,0x0003944e0864a739,0x0000000000000000}, {0x00089e4689d04d8a,0x00060efa98dca953,0x000708ea3f1bf018,0x000f379e0740bbd3,0x000ab07cf1111586,0x00040f6bae4389cc,0x000c0c62ec14d78f,0x000a8ca2edc050cd,0x000eb9e22353ae3b,0x000221497d609a22,0x0000000000000000}},
    {{0x000dc15d0ed0cc63,0x0001ce35b540e1bb,0x000973de7aa979e9,0x0005e965745fa684,0x0008a999e957c84d,0x00071ead702675f7,0x0002beeec63eb2b6,0x00062262a9349f4e,0x0005b027fa151a2d,0x0005b45a63374388,0x0000000000000000}, {0x000ade9fdcbfe121,0x00019964a13f4063,0x000ea6e576b23957,0x0009fa2021e1e294,0x000f93e8e8d0c1a3,0x000627a8aaeb1db8,0x0001c83a239f73f2,0x0009dc2704f34ba1,0x00053062be1591a1,0x0004c975cd21326d,0x0000000000000001}},
    {{0x0006b8fb25e6414b,0x0003f3c35210ef6c,0x000fcf4305218c66,0x00044c1aba52d092,0x000ad9ddbd46b892,0x000a630015bf7459,0x000b32b246737751,0x000ced081a65d447,0x0002e2e5f643a94b,0x00044927f131866d,0x0000000000000001}, {0x0004645014a53592,0x0009ee4e5661d1ca,0x0009024d9b573293,0x000159f5f55c84df,0x000a0100b8c24f2c,0x0002de6a0aef0178,0x0009e7eedb7e96ff,0x0002067fc1f195df,0x000897eb377d8a42,0x000f1229a3daed81,0x0000000000000000}},
    {{0x0005287cf2f5961b,0x000cef9beb6f8461,0x000a7eaedc75201f,0x000d39dfabd8969f,0x0004252116284485,0x0002945b419a298f,0x0000f03b98d985bc,0x0007be292f990254,0x0007d1f59fb5c829,0x00002d379bfc2592,0x0000000000000000}, {0x0001179af2527211,0x000f2724128932bd,0x000920719e949c7f,0x000f184c1ce441c4,0x00091d4d77a7c7bd,0x00086d6826d00ec0,0x000125b3901be8d2,0x000c6d7da5fd8de5,0x00084f0587b71c09,0x000ecbd13d8a200a,0x0000000000000001}},
    {{0x00034258888b309d,0x000da5700df117ec,0x000eecc1e03d3856,0x000d69afef5df311,0x000ced3bd1e65823,0x0009ca00a3d94409,0x00053de41e7eb569,0x00002f1291722236,0x000dbd2ee0ded7b4,0x000a909f40f6e980,0x0000000000000001}, {0x00082d95c76e2f3a,0x0006d18779f8f974,0x000021eeb4e7e5b3,0x00070089298e7654,0x00003aa90b7f11d4,0x00020fd2c120d0de,0x000ddfdcf3b2e6f9,0x000134293b957e6e,0x000d5361a94456e0,0x0004bc62d97be2a1,0x0000000000000000}},
    {{0x00047691dfe1ac32,0x00095bb25141cf40,0x000cb8b02c59109a,0x000eb57046b0d286,0x000a8b7de816343c,0x000109a4f745b33c,0x000bf34e4de2617d,0x000950869270fe1e,0x000a3a1b01ca6170,0x00012e38634a9ad0,0x0000000000000001}, {0x000f079109fbe1e8,0x00071bce15260c38,0x00059aca1efc1bab,0x0006c7ad5da68584,0x000030bec54d9816,0x0009a9c32e8f4612,0x0001154d88a51704,0x000ebe8180a7efea,0x00008abc6ec5ede1,0x000d7de0d26459ad,0x0000000000000001}},
},
{   /* digit=107 [{1,2,3,..,}]*([2^428]*G)  */
    {{0x000019394140932c,0x0009a362bec3a200,0x0005ab884c7a2c57,0x000cab2ba06cf4c6,0x0003ee7eda004083,0x000107bb12f5f6cd,0x0008a0ae8649e92a,0x000a5a344683492e,0x000cfb24291fc3fb,0x000c3894cfd1718d,0x0000000000000001}, {0x000751b1b1d1f30f,0x00043fce22373903,0x00023da45dac2f10,0x0000105df9307b4a,0x000892b6d1b2c311,0x000f645131b39e6a,0x0006331d8e317be2,0x0000b2f395de9046,0x000d56345f1e436a,0x0001b0547fe7481c,0x0000000000000000}},
    {{0x00078f4b7084325f,0x000727f8bc0fa450,0x0001eb36b7bf5948,0x0004268cea0106cf,0x000e8c80e06d4c70,0x000c216323300186,0x000b3016e94d5075,0x000d882e86c372cc,0x00048a28a053b8cf,0x000343d171001931,0x0000000000000001}, {0x000c0287664ae003,0x0002766d8c63b224,0x000b8220989c0738,0x000b967cd418521b,0x0004152d761e7a59,0x000fa019e4601efc,0x000f11b41cb4d7c0,0x000dcac0131d9d52,0x000c991e4e27a162,0x000789975ffa76aa,0x0000000000000001}},
    {{0x000adcdaf64c0019,0x0002a5ef0c2175ba,0x0001cfec89a01d6c,0x000b25fa94296a25,0x00089c7ef16afeec,0x000c007e24585f16,0x000bbbc143cb4742,0x000531bcdafbbc24,0x000013773a99937c,0x000e19b7d849db6c,0x0000000000000001}, {0x000e83417610eec6,0x000e934e9e9d81b9,0x000af4480e73d7b1,0x00086003aa3fea2a,0x00079c57f5c52d5f,0x000495c2aa9268f2,0x000922e4d082c9f5,0x000448a981d714f5,0x000bdf27622c6821,0x0001ae01e6436230,0x0000000000000001}},
    {{0x0007602120347ad3,0x000dd3e9ad407753,0x0002f89c76c52251,0x00044aaf5957d5e2,0x0006157c28051b58,0x00069eb597630bd3,0x000a387acac6af33,0x0002aad0ef875611,0x000ccba64de2edc3,0x000ff1731d170b0b,0x0000000000000000}, {0x000557f665f21957,0x00064548e1ee52c2,0x0000cf955615f44f,0x0002bf2c64b6036a,0x0008d89213e751e5,0x0005aa570d34bd85,0x0005ae3bf1cb2e71,0x0003f29e703acc20,0x000a34a47fb1911e,0x00089578616fc498,0x0000000000000000}},
    {{0x000dc828f86252e4,0x000d09ec8dfb2555,0x0005077092f2430a,0x00078d5b0c56862b,0x0002f9b2b116f869,0x0007b998e4dcbf23,0x000fbcf91af3491c,0x00056f1110038af4,0x000e0888ba8f38ec,0x00043daf07963a9c,0x0000000000000001}, {0x0008da925a008487,0x0004f369188e0311,0x000ec8e641278107,0x000a270db9969754,0x00072aaa78c429c9,0x0001a344c1da5196,0x0003087bd58c2f7e,0x00088aeffcfb4dad,0x000fbcec5f2532f6,0x000a809230f905b4,0x0000000000000000}},
    {{0x0000b4a0ddb8dfab,0x0009deda0e27481d,0x000949ab745b2f9c,0x000dc2842dbe3df2,0x00059b98be5c35da,0x0002ed3249c0c912,0x000dc475c0841958,0x0005a3cc60128529,0x000078110f67e016,0x00017fe4fa3624ca,0x0000000000000000}, {0x0006abd2bfebf71d,0x000617fcd7e4413e,0x000ac8bf7c39197b,0x00022ac8be897f87,0x000878bd60d51691,0x000ed69bb2587c48,0x000a51aae1defc49,0x0003d1f77705c7ae,0x00021ab01c739c3e,0x000801dacd9f17c4,0x0000000000000000}},
    {{0x0002a912967cbb3e,0x000f46687e4df221,0x00007e4eef350ebe,0x000e38a4de052972,0x0009d5282d27fb20,0x0006e64b3686af97,0x00067350cb71692e,0x0008437b220d3baf,0x00042c826bce6850,0x000642d60e139b00,0x0000000000000000}, {0x0004eb43ead3cd1c,0x0007d1cbedb5fe6f,0x0001b45fb1ca7933,0x000a503cea7b46bd,0x000fef3868c8b110,0x000f9fe2cde99fc9,0x0006dd89f348e20b,0x00022d25b6cd54cf,0x00051adcb2128528,0x000ea79e7afb9c6c,0x0000000000000000}},
    {{0x0001fc12e7ca5055,0x00025e91d6adbf30,0x000587a0d31dc42e,0x000cc8a9cecd10d8,0x0009d8d1b41ccf88,0x0003b3f96490bd95,0x000e028999c5a513,0x0004c3a0882547be,0x000fc3438b39f5f7,0x000fa75af39ed4d4,0x0000000000000000}, {0x00002b54c1f9ad9d,0x000dbd0a29ee5fbf,0x00057045bbc4f0d6,0x0000fce2e6fde293,0x00033040027dfc7d,0x0003be51ffcda45a,0x00054869841c14d2,0x000156ff1e336d04,0x000a634d9fdc8522,0x0003ae619b696b5e,0x0000000000000001}},
},
{   /* digit=108 [{1,2,3,..,}]*([2^432]*G)  */
    {{0x000019f2fc6beb7f,0x000666646b70deb9,0x00090a5717d2e533,0x0006810fd38f5274,0x000233bb33bad791,0x0009b6b88efd9526,0x000d5745dad71c05,0x0004ca300788fe6e,0x000ed4a6a21a98ac,0x000e10eeff58916d,0x0000000000000001}, {0x000da52e803a67cf,0x0007d398c1a5fc48,0x00042b185c01901e,0x0004eda6cb2700b0,0x0004eeec867cdaca,0x000dcb7e930a19ae,0x00010a288471dcc7,0x0003198ed17517e0,0x0004e8756bb36f68,0x00027df915ed36bb,0x0000000000000001}},
    {{0x0009d95ae2bd1168,0x000fb9d6f73873c0,0x00027b3bc9e7cafd,0x00005fa81f14d40f,0x000ed4eebf4e66fc,0x000bb6036a4e6b76,0x0009e3f736cb7387,0x000b2277b08a58e1,0x00055c0d7a4986be,0x0004d18f830adabb,0x0000000000000000}, {0x0005e59f982356bc,0x0000599a3ae563b2,0x000d06e16bf18997,0x00088dac7505891e,0x0004c76b3eb973d6,0x0006498b2d10cb08,0x00074af2d6e8e95c,0x000a503f71b8afa5,0x00066999bc16133c,0x000bd76f3443fa99,0x0000000000000001}},
    {{0x0009cc5a1fdf300d,0x0000ede5aa101a8c,0x00053342a7d32907,0x000bb4fe852398fa,0x00036673ceb9c007,0x000c9247b3a94312,0x0001ee51cb682683,0x00075c07f2ef115b,0x00083b0143f6486b,0x000d101585ec3771,0x0000000000000000}, {0x00080da54d84cedc,0x000e569a2e8c0006,0x000e94c0472e41a7,0x000a41c1b7c713ec,0x000e5742d18ccf2a,0x000df3c3763e3162,0x0006b9977417a84e,0x000f165b44c75791,0x00045d988246f2e2,0x00095c8287828d1c,0x0000000000000001}},
    {{0x000f9c015fdb1c06,0x00099f25767d4418,0x00077c536b749d61,0x00054bfdb54e847b,0x000237979776c1af,0x0001eefa220b8386,0x00018acdf9bb4a75,0x0008ce45beb5028f,0x00030f98a7dd8621,0x0003023f055e3ab9,0x0000000000000001}, {0x000f321b72c7f6a2,0x000659eeb57c141d,0x0000b2255cf53902,0x0009dbecf2a776fd,0x000e6453cf8ab4cc,0x0002d5647863e94e,0x00049fe93a4007af,0x00039cf116d00271,0x000dc8184a637605,0x00061de7465f7317,0x0000000000000000}},
    {{0x000dae8508371ab1,0x0009f5759cf42671,0x0001705cf63d991b,0x000e90ca5edd0265,0x000af5c715a86e95,0x00096331dd94a89f,0x0005808565c73b46,0x0004c9ca8a595723,0x000561170be646eb,0x000a57b5fc879ce5,0x0000000000000000}, {0x00080540adb44437,0x000abb97c57c16dd,0x000be7baf4488307,0x00019e753dbf21d2,0x000ac5be29dc51e1,0x000df21c9ad3cc57,0x000a9aa74fbb9193,0x000a11ec7b8e665f,0x000c01bfce350115,0x0009909f2c73b53a,0x0000000000000000}},
    {{0x000744ab95b71183,0x0005aa6c81566c3d,0x00033310fbbacd74,0x00006a2dd55a7d6d,0x0002db05de914221,0x0001ffd4282301fd,0x0008cf7489b2de85,0x000c6f0a02baf309,0x0002ce9af0a85604,0x000261197b0884c2,0x0000000000000000}, {0x000e2c60da7deb89,0x0008d4b2f2e54489,0x0002e5dee75d5785,0x0005e0e953899934,0x000ecd968f2eb742,0x000229cbd8cbbbd2,0x0008dcc6b871d5e3,0x000490c7582e68a9,0x000cde3999720429,0x0005eaec58ffb639,0x0000000000000001}},
    {{0x00028ab59549216b,0x00005d61d82596b8,0x0009fa679fcfc930,0x000ccf438ed2cad9,0x000a40190b3069f6,0x0007f5af4bb6d49c,0x00002f9e7c50f6a7,0x00019940efdd8671,0x00002add96c554a6,0x000e007d80786684,0x0000000000000001}, {0x000ad0fb54ef0a37,0x00046af5d15fc57d,0x000b825452e8ccd9,0x00044232c710cb6b,0x000cf88855ecdc6f,0x0001d6d2b8f40b3c,0x000436e2bc3e510d,0x00007b1ff42aeddf,0x0000ed88484552b4,0x00075c1505c18430,0x0000000000000000}},
    {{0x000a55f734e8c16e,0x00026ef042fa2f6e,0x000b24c1848ab1d2,0x000acbe86862a1dd,0x000651f4168e7413,0x000d596e07914083,0x00079ca23961d189,0x000e6d53679701b3,0x000cf35fa05ec7b7,0x000d20d7f6b70713,0x0000000000000000}, {0x00018785b4c707b1,0x00038676095f2dbc,0x000e28a0370a0054,0x000af09e50c89610,0x0000f144bba0bfee,0x0004cf6dd7455cf1,0x000e722f509d9783,0x000b05c279e5f94f,0x0001244fe8092deb,0x000153b314f061e7,0x0000000000000001}},
},
{   /* digit=109 [{1,2,3,..,}]*([2^436]*G)  */
    {{0x000803868bfafe94,0x0002ddeb7719717f,0x000911e1ad005b4c,0x00076f1e0df34f87,0x000b29958d5da570,0x0005d1ebf66f49ec,0x000f5712ca7b49e5,0x0005b2ff1b32fcb4,0x000f97d3d42a971c,0x000804838bb32749,0x0000000000000001}, {0x0002e7908789eb65,0x000af786529c3ba5,0x000e71594737ddd9,0x0005400f6dd64d51,0x00039922bf016830,0x000db4bbaa21ca42,0x000935d8c94ee851,0x000c80623440afda,0x000110efc0a576c9,0x000396d79f58dcd9,0x0000000000000000}},
    {{0x000b38ccc9df95f7,0x000d1849ee6062ae,0x000164333dec1411,0x000e81b4a4a4727a,0x0009c74b241dc566,0x0005069fb7290aa5,0x0009d322865cb6d8,0x000ecbd648392838,0x000909864ce3c8f7,0x000ac9fef248d28c,0x0000000000000001}, {0x00061d435126259d,0x0005a6b96bec8542,0x0001f509bbc62a6f,0x000ddbc8b43f9c90,0x0005e94118466c53,0x0002a386779ad388,0x000db58d109dd2e2,0x000aeef4f2af60b6,0x000bc0cd7adf1adc,0x0008220fb47811d5,0x0000000000000001}},
    {{0x000f1b4d9b2b9d58,0x000635d4601e4549,0x0005712ad28d37e9,0x000e19b42c3143dd,0x000fdc6366f04af7,0x0004b34637aa565a,0x0005b2ac12b452bc,0x000277fe7f5bdd13,0x000c6ff31feea8b4,0x0000c45cdaec8e9e,0x0000000000000000}, {0x0007813178366af1,0x000e83664c221b3f,0x000afac4ecd652c3,0x0007c4666da93d03,0x000652ceac0d6cfa,0x000b1a4cf4039d2b,0x0005c58a6eb1946c,0x0007422c9b53a228,0x0007349ed1b4d836,0x000afa4c55a379cc,0x0000000000000000}},
    {{0x0009ee173ac4010e,0x000fb942f467a4b5,0x0005770a30141b66,0x0004198802513df6,0x0002c7e0148f2f1d,0x0009a1b6c6f54abf,0x00056f2bb47b51bd,0x0004f5846505fba9,0x0002a3ddcb02618f,0x000a7b69ec8c6450,0x0000000000000000}, {0x0004b69533aa9231,0x000b0804316d8f19,0x000006107c58f7bc,0x000310f29f43afd0,0x000e7a15ea5dc32f,0x000849a363e2b91a,0x00074452b4966c63,0x00071d63455b6a45,0x00039b535b8835c1,0x0005091ae86f54cd,0x0000000000000001}},
    {{0x000de1ec8614daa5,0x000f0834c4db4a7b,0x00048a29f6ba70a6,0x000be231587d1015,0x000bb998c9a2049d,0x0005eedcf88aceaf,0x0008878e6b738f7e,0x00019b693ecfcab0,0x0008dd1ddb374ede,0x0003be7a6cd94f00,0x0000000000000001}, {0x000bd130c16a2f12,0x000343c20757ed83,0x000228e06b217bff,0x000046a91bef19ad,0x000400e88da5cc51,0x0000a9f961011b58,0x0003f9049ae6f047,0x000e9d079a03c6f8,0x000401435912f072,0x0007490b78fe3f9a,0x0000000000000000}},
    {{0x00081fdfff4245fc,0x00050168c14a6614,0x000764d4d2b84edc,0x000aaa60be356501,0x00030e6771588736,0x000714d50c0c40e3,0x00029157b8fe8875,0x000a9215aac4fbdf,0x000b4091b549e25d,0x0001ad442d2b0058,0x0000000000000001}, {0x000ee6a91c584138,0x000d84934568ba88,0x00010dd1585307ef,0x0009b046cb644b24,0x000dc2bd376e1321,0x000cecc49bef0c68,0x000f76556c2d2d1d,0x000d810f8810c907,0x000a20da5052b3dd,0x00079ec3448a3c1b,0x0000000000000000}},
    {{0x000084366f4dadcf,0x00087f5cc0a55e0e,0x000a139c3fe7ef01,0x0003f2e749d53f7b,0x000ffd809a727542,0x0002e74f9e5a94a4,0x0001929541f08d0e,0x000114dd07932254,0x000f53ad14915984,0x00078a408f5bb7db,0x0000000000000000}, {0x000b74adedde4d64,0x000eeb46e287111d,0x0001ad3605f3b22d,0x000070fc8863541b,0x00093fdd530f51fe,0x000f3d69c04af47e,0x000f551d93cb6477,0x0002bc684cde6d16,0x000154a9f50cd685,0x000e9f16ac0cc2b5,0x0000000000000001}},
    {{0x0006190bccf09089,0x000de2a4a386bf1b,0x00095703cbb17c47,0x00013d223bf84891,0x0007a124742673f0,0x000290f2b86fdb82,0x000f44e50e9b7e10,0x000ecc65826079a8,0x0004d12b589a9228,0x0001b683a119d1ab,0x0000000000000001}, {0x00025950f93cc637,0x000b7a6b02229a2d,0x000fb0617d538c46,0x0001dd7b6bc581dc,0x0005b6b522d590ce,0x000133e3f5d0dcdf,0x0005bdf5cce47e79,0x000e21b8ecd0d71f,0x000ac21b717d9aef,0x000b887b6090257a,0x0000000000000000}},
},
{   /* digit=110 [{1,2,3,..,}]*([2^440]*G)  */
    {{0x0009fcba235d8a1e,0x000ca359a63f98f8,0x000f60025c086d07,0x00018d4e590915cb,0x000c915cc7c3b68c,0x000933480185575e,0x000511ae8d10d820,0x000082704b904789,0x000a4e997db2e76c,0x0008c3f5824d99f6,0x0000000000000001}, {0x00053628d8f32dc9,0x00000ea757555069,0x0008537e14185044,0x0007f7a0609d8295,0x000c55da70118c7b,0x0009ad1223c50379,0x0008629c936f6ea7,0x00054f7f839cbde4,0x000f8def61ba0172,0x000f5c1bef09ebdf,0x0000000000000001}},
    {{0x0002eeedc5fe3f41,0x0004f9330d665ae8,0x0003f5e64a30753a,0x000e92f39e477096,0x000aa07f9d297ef9,0x00048c3ddf388062,0x000e61e60ab0df5c,0x00095a47567e55e6,0x00066d0129872a6f,0x000953425f368c3a,0x0000000000000001}, {0x000b7cc7bf66ffa4,0x000f16b2825eba03,0x00090e67535ba3ce,0x0004aef14aec5704,0x00001511ac67bcc3,0x0001002739d95c0e,0x00029220f4f36575,0x0001465557ab45e9,0x0009abecf1baabf9,0x000fe98337c9760e,0x0000000000000000}},
    {{0x000025751d2b325a,0x000cde6a01039da1,0x0005ba8462228499,0x0003490747232500,0x0001a523417ab4da,0x0003451baf54b07c,0x000516f3fa7e4ffd,0x00042fbff2147ce5,0x0003f1b0afc522cc,0x000cb395c7010ca3,0x0000000000000001}, {0x0005ed5f55af51c6,0x00015b980e568466,0x000a5a1b30bd5964,0x000bb04e8834a37b,0x000becf282494fee,0x00040dc6ceb29d17,0x0004a868d5399a53,0x000276012bcea50f,0x000c769aa83faa31,0x000d8e6550a0654b,0x0000000000000000}},
    {{0x00066fa0ef4dbc14,0x00071d134a53f7ec,0x0001ee39cdaa7b28,0x0009b3f183070c04,0x000c76da77991974,0x000916f1eb867841,0x000b27421e5438ae,0x00051b0e12d8e409,0x0005e08b83842a6e,0x00094374b9e008de,0x0000000000000000}, {0x000a4cba763a6340,0x00013308e07acdfe,0x000db2143a906789,0x000fe6dd815c887a,0x000e2a9d2043c85f,0x0003ceab79a68d05,0x000986393674d33d,0x000d12ee73ca7a8a,0x00003b9bbd54b7af,0x000b702eead11264,0x0000000000000000}},
    {{0x0000b987f57f80d5,0x000d4367c06145fa,0x00034438e79fd55d,0x0000f9f8e8ca9c52,0x00036810f12c2fad,0x0003ec5af1a97a71,0x00085613d0eababb,0x000aecb3da01b7b5,0x0000150798aadf26,0x0008029cce9cadbb,0x0000000000000000}, {0x0005a72e54383960,0x000decd025e95126,0x0005b2c914390e3d,0x000864784955e972,0x0008cdae63ed0053,0x000aa5ded860c28f,0x0001dd80fb99e774,0x00020f07854bb74c,0x00091581c2caae0f,0x000d48069f6ba766,0x0000000000000000}},
    {{0x000f135836126647,0x0004208b738df6f5,0x000786c7341e91f4,0x00084ed91ae2188a,0x0000b08e3293bda3,0x000e09af3119b1a0,0x0003662652676669,0x000fd07b9f37322f,0x000ae129d764ea40,0x000b85c16a911b11,0x0000000000000001}, {0x000021aec95ad18b,0x00080eeb3197c759,0x000dfd4a4334daed,0x000ff78d606234ad,0x0003ff98a1d73ab3,0x000c9cac669f90a4,0x00063cf99bed1762,0x00028f03fcd45e80,0x000b17bf750672a2,0x000879027e080bfd,0x0000000000000001}},
    {{0x0006a647cfcf8e23,0x000d745dafe04723,0x000c3212b4d30081,0x000945780f548f13,0x000a0d885e14f51f,0x0006ed3092941059,0x000651e189c478f0,0x00007a26e8c75042,0x000a14b52f36b6ee,0x0001a032dfdec009,0x0000000000000000}, {0x0008ca67379eb582,0x000b6f527f0a50be,0x000adaba76e4c6be,0x0009b987fc7fd1fd,0x000a047c90091990,0x0006d6f45b992155,0x000e37e2da697e00,0x00011a38bcd1740d,0x0009b93e8ce3867f,0x000b60503be8b250,0x0000000000000001}},
    {{0x000c16ca71ab9de2,0x000d4b4d3bbd16e8,0x00053785c45519f4,0x000fab776454947e,0x00019d9b9416f1aa,0x000337e34e6883b4,0x00041570208ba8ab,0x000cab67774a7e58,0x0008ac5165a84d18,0x0003a977b69d3110,0x0000000000000000}, {0x000e5bcfd652943f,0x000743cd5e892a91,0x000502744c85aa27,0x000bb91ba0414bf5,0x000f8bc4ef773e26,0x000f9e301b8bcd45,0x00028983589038c8,0x00019a5f5e5a30d4,0x0005c6671a609f77,0x000a3aade09eb4af,0x0000000000000001}},
},
{   /* digit=111 [{1,2,3,..,}]*([2^444]*G)  */
    {{0x0008fa162e0dbf60,0x0003f486c08a442e,0x000d94f9cd2b15f8,0x000f2a2350bb6a89,0x0005b606cc5727bb,0x00003f198a74b132,0x0001a6f73b79d3ab,0x0001c95046a9cf73,0x0005ed71e298efd1,0x000274d622bb2409,0x0000000000000001}, {0x000c383b3b59eae1,0x000e81b2f1927508,0x0000d888be6e14de,0x000fb612ce4b12e8,0x0001378248f53213,0x000330dbca43092c,0x0009ef5e40c52b24,0x000e9d869889952b,0x000c05f4131f1126,0x000503fd03ae1dfb,0x0000000000000000}},
    {{0x000868b8bbdfd1e3,0x00069e244e266c6e,0x0007c7bf40b05a43,0x0003b7e1e296776b,0x000e22cfd9c18aed,0x000ea90d63ddbc31,0x000929198abb7bc1,0x0005791f36a5e50b,0x000737c71c2f87e5,0x00024f75c6d8e7fe,0x0000000000000000}, {0x0004c9eb7d596ad7,0x0001e1a0fb486ad5,0x000d820f02c91d1e,0x000160179160a67f,0x00057f1163f25e5d,0x000cbc9a928b61c5,0x000df9b84ed79f2f,0x000854ba69556a33,0x000c5cb8ac8febe1,0x0009a7ec5a344343,0x0000000000000001}},
    {{0x000a1f2d5d90dce2,0x00048086d7fdecb8,0x00005e3d618ccc17,0x00081c1e93d5b7f5,0x000a9cc469c44a02,0x000561bd59d9df3b,0x000788578aa5fba5,0x000f6a295757cdc7,0x000387a16bd50e1c,0x00029d1a6695b773,0x0000000000000001}, {0x000b40770bcc13d9,0x000a0b4cb7c0701f,0x00058a0433c71ad0,0x000e93cd5406bd3d,0x00098c999eda26c3,0x000092f416481951,0x00047a1b9bfd4b10,0x000f450e0ae46263,0x000aa14d201a717d,0x000a1f0cadae7402,0x0000000000000000}},
    {{0x00025a8ecef36f15,0x0000495828c615a7,0x000ac113424f603a,0x00042c1687a77e81,0x00098761c2762346,0x0009b1a4749d0db2,0x00097828ac3391f2,0x0005050c5b69143a,0x00078b0a25ae0092,0x000d6c144730edc5,0x0000000000000001}, {0x000bfa3844e6437c,0x000f55606aeb933b,0x00097e413566e3da,0x0001c1ae4263527e,0x000823a0378934ac,0x0002143f588c3363,0x00027262bb7d997b,0x00082419935b6941,0x0004eeef99cb555c,0x0009b82ef7f7cb72,0x0000000000000000}},
    {{0x000f0062dfac9c48,0x00002d81a18ce131,0x000ddcf23a0713ab,0x000a1fcdc4c43fef,0x0007bce6f244518e,0x000ad87348b34742,0x0006967b2b850180,0x00045248a8e5aac5,0x000029c18af90606,0x000027d44e26ac08,0x0000000000000001}, {0x000cb47b7d6fa01c,0x0000fa06669eb12a,0x000ba3426d87d938,0x000cc362d25b1811,0x0005c938c9a5e9c2,0x000513be5311d61f,0x000c741f99e49306,0x000858e6ea44630f,0x00001034df68ea15,0x0009fda601eea831,0x0000000000000000}},
    {{0x0001335ca463c947,0x000056d6526151f8,0x0003c494f0f999ff,0x00082dc10a7433ca,0x000067fa3bcdc41b,0x000c803bb39af11e,0x00031fc0ac7bb35e,0x0005b5e185aa457b,0x0006ab2cbed55591,0x000c973304481958,0x0000000000000000}, {0x000c07b3b2112108,0x00057bae813666bf,0x0008eee1f424f0a9,0x0002122582cf0958,0x000314daeb7bdc33,0x0004de4e23458ec0,0x000a768d0f97884e,0x000a1655c201fc50,0x000f1a537b424f36,0x000a6c0cdff48114,0x0000000000000001}},
    {{0x0007e2caf6bd29ac,0x0003376357d313a7,0x0007372bec99c462,0x000dae50c449ad64,0x000a9851fff00473,0x00047fec5d20efdd,0x000826de033e859f,0x000f46311785804a,0x000104e3184caf5e,0x0001ecedcc25e31e,0x0000000000000001}, {0x000e47c0beec6da0,0x0001b1920715db74,0x000ae32e6188b124,0x000b5dfc6ee77c87,0x0006b132638e4040,0x000b86b665e1c6f4,0x00028fe14b060006,0x000b71efffb869b7,0x0006eab86370f188,0x0003e80379ec88c1,0x0000000000000001}},
    {{0x000f8cb24f3b637b,0x00076af131c20322,0x000815ccfff0c2b0,0x000fbdbff056364e,0x00060c8028853dbd,0x000af0ee0841ab57,0x000da56ca93ac088,0x000d301350923094,0x000228a255054010,0x000a058e7dde6774,0x0000000000000000}, {0x0005176aa5c512c3,0x00020d3779fd868a,0x0007658fb3dbe164,0x000cf13041f45c5c,0x0005049dea64d110,0x0003f6746e19e0e3,0x000a39087ca45757,0x0008108ab4e2fe7d,0x0009cce4e874c545,0x000b791d64965ce3,0x0000000000000001}},
},
{   /* digit=112 [{1,2,3,..,}]*([2^448]*G)  */
    {{0x0001f7c72b336855,0x000f76e247b483cf,0x000202781dc97b6b,0x0005bb58c0f81747,0x0000c92efba888b6,0x0009612af59611a6,0x000ccbeaf54a57cd,0x000ef8689ba520d7,0x00091cc366d3cbf9,0x000056dc1abfe905,0x0000000000000000}, {0x000a04beccd53894,0x00021b1e600b02d4,0x0006c3ebe8f2a150,0x00007cfe9586be60,0x00062f4028af5b85,0x000d392e8954dda7,0x000dadc519d37584,0x000b58c3813ebde8,0x000557ce681db641,0x00006323fa3b9991,0x0000000000000000}},
    {{0x000327209a17e11d,0x000d294da0ba85ba,0x0002e3b7145fac1e,0x000fef1248cf218d,0x00034de112f175cb,0x00094a8f1676f3e2,0x000f9c2657870861,0x000518958d56de1a,0x0003dbcba495c76a,0x000cbfa5e9c9c9dd,0x0000000000000000}, {0x000fcebaff9f1e95,0x00070930a1b712b1,0x0008296f1f273d82,0x00071eddfa6e1f41,0x000af7dd190815ef,0x000f6fda9bc4a2f8,0x000482585b1234b2,0x000e23556036541a,0x0001ac1cc79e6b22,0x00079988ea71f991,0x0000000000000000}},
    {{0x000a9c0f0a888100,0x0007d24e7957d723,0x000347cf9592bff9,0x000365bb77516430,0x000532639eeab522,0x00075ffdcf80bee0,0x000715b06a25a527,0x000f841be2cacf87,0x000bc301ef1a4c9c,0x000be09159817e68,0x0000000000000000}, {0x000ae077a00f18c6,0x00066d4baba09883,0x00026a600e57c245,0x000d614baadec7ac,0x000df9f1c7a24538,0x0006e61c4241b694,0x000e25d7cba200ff,0x0002e6c811de028a,0x000a7a2ca09bc137,0x0004b214e3d38684,0x0000000000000000}},
    {{0x0002cc5d8d86efa4,0x00086c8ee779a0a2,0x000fd2159545dd5d,0x000c7262fd5e2c81,0x0008275f13cf7ab1,0x000759a0b74f36ad,0x0003c0c8c3ddc91e,0x000d10948a51d222,0x0007160cf9b2c7f7,0x00060f285822b597,0x0000000000000001}, {0x0001e962392851c3,0x000b50d7c127ef1a,0x000d984c5287e5e2,0x0005ce7d3999dfdf,0x0006fd1373907aad,0x0007f8f0825c8472,0x000b5c55ebbc32d9,0x0002bd51b3a068dc,0x000935287a1b4f59,0x0006c8f3eb9dca36,0x0000000000000000}},
    {{0x000e20e45266c880,0x000d20d089ee45a2,0x000924531cdc6e8e,0x000f7ce2e1fa4436,0x0002517f9a18e676,0x000d570398bec610,0x000dea4d0f9eb1c1,0x000c9914ddf30f65,0x000cb21d0d421e9a,0x0002d38fb5fd0304,0x0000000000000000}, {0x000db46cd0b507ab,0x000ba53f3ce83b8d,0x000a8aca81c50a03,0x000245a83198cc38,0x0008bb4ffb6faabe,0x000c93601934e1ba,0x000061b676968674,0x000710e9ebcf5033,0x000185f4475389bc,0x000687b9bd9763f5,0x0000000000000001}},
    {{0x00029514447f1de3,0x000d950771604321,0x0003a8cfdfffb078,0x00022ba412e08811,0x00097ef9f248a108,0x000b82c1196accaa,0x0001f8d1787041bc,0x000ec8430565e6d4,0x000eacea7ff3e1c3,0x000896b9bec2206b,0x0000000000000001}, {0x000508946b504e8a,0x00067cc71474da28,0x0009ad4094d373bd,0x00068f87798411db,0x000b0b90d5d507cc,0x0000617d88846f61,0x000a437ea42aac2f,0x00012a4ea205a926,0x000adcb25d613e80,0x000fb7ef615aab09,0x0000000000000000}},
    {{0x000127afd82f8260,0x000f4ea3f09c69bf,0x000b49f3f0e43a3e,0x00052457b8b9c3f9,0x0004fe6ce00409f0,0x00044efa3e31f441,0x000e3e0240cf1253,0x0001f0b4a170983e,0x000d166b0cc9e8c1,0x000b455417a2207f,0x0000000000000000}, {0x0000fd522cdf167d,0x000b48039daf9a36,0x0007cdbcd7341cc4,0x000c7db3b7805076,0x000641b0db786edf,0x0006ea9b69b8bccc,0x000eded2a4e25e3e,0x000651b8f0911cf0,0x000614b601e95ba9,0x0005000aeb19e877,0x0000000000000001}},
    {{0x000c0c51d56f967b,0x0008dddbb7684495,0x00035dbc45f7bb76,0x000f9e6deda49098,0x000e73639006a39d,0x000878e5a247f77e,0x000cd83d141b2c8d,0x000804a47e332c8c,0x0009dc7a02d4027f,0x000b1b9934bb002c,0x0000000000000001}, {0x000777a838efe004,0x000368d9919c1d8d,0x0009dd721650f685,0x0002b1de892863f1,0x000d78f2b25a32a9,0x0002a4320690ff3d,0x00005a4af7bb8bc1,0x000cd763efcfe035,0x000701c70cf4f256,0x000443ef26775353,0x0000000000000000}},
},
{   /* digit=113 [{1,2,3,..,}]*([2^452]*G)  */
    {{0x000e0800cd422057,0x000077d1b7504d49,0x00004fd80e159ebe,0x000a18a8714afb4f,0x000de28810d8b90e,0x00019cff83f02c3c,0x000eb9e19367a867,0x0009952bac438786,0x0000e0748ecceb4e,0x000faa55aefa6646,0x0000000000000000}, {0x000aa315b1f2623e,0x0002b544f96e097a,0x0005dae237e7a5db,0x000873d0a9362519,0x0005569799223163,0x0001a58ea84d0fbf,0x000d43fd3bb728ac,0x000f100cfe43661e,0x0004f55c6f1cd21a,0x00091825dcbe9fa2,0x0000000000000000}},
    {{0x000fc794a5858d75,0x000a4affcd84d641,0x0005082ece4f5985,0x000b4853cf3bb3f4,0x0000bb1d8af65850,0x000953dc3e670d98,0x000424ef579458a6,0x0008ac2f2e4a7963,0x0000d771e540b685,0x0009be1f5fed2292,0x0000000000000001}, {0x0001be223c4864af,0x000fbb662c4dc573,0x000a57017521419c,0x000c0240d65099ca,0x000b13af88f3bfbc,0x000bc4861e1643ac,0x00067ed67405bcdf,0x000d9351f1c835f0,0x000d0e188cb8018e,0x0001f8d276f971ee,0x0000000000000000}},
    {{0x0006a9e449621f3d,0x00052e91ee418d60,0x0007e5ea0e7d2dd0,0x0006f73c92e787f3,0x000cc4508ea4869d,0x0002d461acfe248e,0x000bd24529ffcc1a,0x0002f90dc5dc22dc,0x0002f8abba336456,0x00056cd254e4f954,0x0000000000000001}, {0x0000aa036c0262fa,0x0002edc4f4234a99,0x0001031cef9b59ee,0x000145d5d5d4b081,0x00087df2c037b984,0x000a2d6af2c7b077,0x0006ff431d568532,0x000e309a7c9b6d5e,0x0006a3ee9bb40c66,0x000c81af9db41cda,0x0000000000000000}},
    {{0x0000f6f067a194c8,0x00066d7ad7abcf3a,0x00041cf832b531ca,0x000f470a4ac4965a,0x000cbe00766a00f9,0x000432af80a92657,0x0008968ac40c892b,0x000cbd44ededa94b,0x0008d46204be8b74,0x0005dd98f760bd2a,0x0000000000000001}, {0x0007f464f2479db1,0x000c0fdb3e7dcb2a,0x0001a96b28900b58,0x0000a2993c1d7ee5,0x00057bf0ce9357a3,0x0001f5d39eb49f5f,0x000fb8b8f0c1970f,0x00060718d4faac9c,0x000ec4ed9e1c25a3,0x00004bb0d7504b66,0x0000000000000000}},
    {{0x000c9e1b2fe9b1f5,0x0008d34221feb754,0x00042a589958e706,0x00008c19119e3c31,0x00021ac738645a87,0x0004d7be72a33383,0x000a72a39907dc71,0x000beb5759bb91f8,0x0009abd4b13e9374,0x000b96398db67d76,0x0000000000000000}, {0x0000945a75d3799d,0x00031dd530ad32ad,0x0000c605c645aa0c,0x000c247141d0f230,0x000876cc8fca8350,0x000943188b899279,0x0001484afb9ffa8c,0x000536d0aa571f07,0x0002b7a0c7fbe8ba,0x000c736f36c17e51,0x0000000000000000}},
    {{0x000618a7bb29e0e4,0x000c09c2bff10aed,0x000781dbe57f3993,0x000965b0e2b9baeb,0x00005cf5dc5bd4b3,0x000ce5975c6e0f92,0x000471ab0fcf2bf8,0x0002a2d43bae9f5d,0x000bcafa18f22cc7,0x0005911e3b357902,0x0000000000000001}, {0x00057df200a9fe3a,0x000b50d956c845fd,0x0007f211bf361887,0x0009b4007c382ac0,0x000ee4f517e7f4f0,0x0008256df5e905bd,0x000fa86a9368d1c3,0x000a7df56d37c426,0x000efab6ec26a5b8,0x0005cdfe9cfac9c1,0x0000000000000001}},
    {{0x00082202f99826cc,0x0004867eca10dd40,0x00071f5c4e281cfc,0x0007b5da880b8221,0x000325e5cd3e67f8,0x000671c0e0906564,0x000df4bd6ef65d7c,0x000c8a693695da96,0x00076e79dcdb1aea,0x0005bd96f080eaaf,0x0000000000000000}, {0x000240c6e69e5a49,0x00080c138884ae0a,0x0002f7e55e87844e,0x000a57d17ee0d45e,0x00033a1990475a82,0x0004fc5139e3efb1,0x000093a8d1fcb820,0x0007e2fdf23f8eaf,0x000aec2eac127538,0x000a0742581e77ed,0x0000000000000001}},
    {{0x000de604b9db6d8d,0x000262da62b65572,0x0009db8d0d3fb7d9,0x00067b7f8e9c2aa3,0x00074f2912d3c9b8,0x00079e6d831a5ad6,0x0006f3cc6935b1c2,0x00009a75e08b8223,0x000aaa28cfcf8f6f,0x0004f75ff407271b,0x0000000000000000}, {0x00024706c120a90c,0x000b4f991d9aa4ab,0x000767e06952ed85,0x00006ffc0793e3c1,0x0003d6115d975f7d,0x000c57472c131644,0x00024430b8651df9,0x000bda1a64f28b97,0x0006db846f1bbd8d,0x0002f562aea1650c,0x0000000000000000}},
},
{   /* digit=114 [{1,2,3,..,}]*([2^456]*G)  */
    {{0x000d810c86eab937,0x0008e6e6eb51bdd5,0x0009bc2e3a0e4219,0x0007e391c4b3dc48,0x000736ed77fe5eda,0x0005e60972cd0e3d,0x0001aaa05f70f41c,0x000db07669f426a5,0x0005914839830a47,0x00029045b98cf434,0x0000000000000001}, {0x0009d9c576932524,0x000409f4c3b8bddc,0x000d467dc9295086,0x000bdef23e6cf0fa,0x000729684c1e0fbe,0x000c3a23011daa3a,0x0008c4ef40ca0da8,0x00034dda12c0850f,0x0002c5e51990ccbe,0x000494c2f0adaf8f,0x0000000000000000}},
    {{0x00087b36a390065e,0x000c93a9bb0064f8,0x0004572329d651f2,0x00010e01d988aed3,0x000be48541e9e6f5,0x0000ac10a8abc023,0x000b700a8621efc9,0x0003eb208400f943,0x000d85b1c768bb3b,0x000f42634af0db64,0x0000000000000000}, {0x000e0a10a250b4be,0x0000634e42e593a7,0x000adef0026acaa8,0x000002da6f2f96cb,0x0008dca66aa2e955,0x0005a69e8157271d,0x000f32666dc76291,0x000c378977ddcf29,0x0000e5eaa07d6619,0x0002a548e47a94e1,0x0000000000000000}},
    {{0x000cd510985c6ead,0x000d1cc399a1876d,0x000fc77243f5c966,0x000c3b2c4abf82c9,0x0001efaf22c713ae,0x000a22e1704988df,0x0002a2d8f28a287a,0x0000f724ea967d19,0x000ed48e76179ade,0x000ff318acdc5b8c,0x0000000000000001}, {0x00063196ac8ad685,0x0002708e70052b0c,0x000d8ff45f4a08be,0x00064862e9bd37fa,0x000efcc39748e461,0x000dcfa2843cc067,0x0006ae8688367317,0x000b8aabfd38c458,0x0005642ea85ecef5,0x000873af78e84b81,0x0000000000000001}},
    {{0x000b763fd4a23b33,0x00004ce905f61100,0x000ad5b3ffa31c96,0x000817bf059b27d0,0x0004f957d997fe85,0x0008adabfcc9cea6,0x0002fa1bf24cb58a,0x000afe218a3174dd,0x000ee69ca08cb0de,0x000fdf310fed00cf,0x0000000000000000}, {0x0006e131eb000160,0x000a4d18c779a4d6,0x00013180dd747a1f,0x0009340c23f27ad3,0x00004df4a2f35316,0x000ec77b35a8c2be,0x0007fb23a1f8aa1a,0x0009e69edc272eed,0x000d58ddb6110abc,0x00042ae7590226a5,0x0000000000000000}},
    {{0x000f3cc8ae818a77,0x000f54ede150dbf6,0x000c2f06bc371295,0x0006ab2d173c2266,0x0007fda0b8b46bd2,0x00070909e3958aad,0x0005242beb035184,0x00006b5aad800c13,0x0003a70dce6b782b,0x0007761ebe42a4f4,0x0000000000000001}, {0x000ee87f40792877,0x00080b5c7acfe8e9,0x0007c5775efcb053,0x0007bf0a2d540e71,0x0008c839d644d450,0x000d1ff451c6b81a,0x0001b7ea45f8834b,0x000306bfc9c3c653,0x000cabe92f1a607c,0x000c13152a3731fa,0x0000000000000001}},
    {{0x000ad1ff805361f9,0x0003b3536327ce4d,0x0005b0b62672d1bf,0x000ddf3847367af0,0x000278798d158f13,0x0004fbc252a948f1,0x0006fc03d0fe92b8,0x000c0138676b978e,0x000ea4ba8ef9334e,0x000f98b13cf22496,0x0000000000000001}, {0x000ac5c627d693fd,0x00015f19d6d21fa8,0x000b4a2fb70b6705,0x0002c39928de441a,0x000db0fd9e912476,0x00096888c13371fc,0x00013f185fb68ee8,0x00092d86c189d0e2,0x0001cf6facea1f84,0x0005b949b94eff15,0x0000000000000000}},
    {{0x0003e85508c930d5,0x00050167c798885c,0x00018ef2850f4f27,0x000547f00d7f6b01,0x000899cb15ed2f40,0x000bc417a989d6f1,0x00008165c9378941,0x000bb0e0c28f2218,0x000839d9572ddfe6,0x000d6ab0b70e2e95,0x0000000000000001}, {0x00092c31b5a755fc,0x0005623261be8d00,0x0002ed776ec81547,0x000ed7b92bc72da3,0x0006d943fbdb47af,0x00096c45167b5a5d,0x0006fef44f208158,0x000d5bd5c28e23f0,0x000da432e8f4f6c6,0x0007b3355da25eae,0x0000000000000001}},
    {{0x00076c8ab8c349a0,0x000850693d15749f,0x000d18a6991254fd,0x000f60f54944e4ef,0x000febc73879cf78,0x0004c63e00125696,0x00042f68e1e2dbe0,0x000b688fd93a88e1,0x000f1e83abbe7321,0x0003aaa7b2fa13d6,0x0000000000000001}, {0x000caa293a9d97c5,0x00059519ff3b97cb,0x000cedb5893b39ad,0x00064ed07e59369f,0x0003315852af3473,0x000d5a40d47c32e9,0x000386582768fe34,0x000453f8e4c60653,0x0004a96dcf43bf2b,0x000e332542e1828b,0x0000000000000000}},
},
{   /* digit=115 [{1,2,3,..,}]*([2^460]*G)  */
    {{0x00011a7aae3fec0f,0x00081883626ec806,0x000aebe504491b56,0x00031dd2ecc113fd,0x0001068171e0f3fc,0x000d2fbb6b5fdadf,0x0000ee0e94a492b4,0x00090723f06e06c2,0x00016b906e2fed2d,0x00033b2f32d5d083,0x0000000000000001}, {0x000731c43f27e685,0x000c912924bed063,0x00058df5bd8f8996,0x00080e3a04d16a64,0x000303ff6f14cb47,0x000f56c8175aed03,0x0003011b62e0f3ec,0x000eee8bd1d8f816,0x000a055be5c28fa8,0x0005635edb8d9c9f,0x0000000000000001}},
    {{0x000eb4c2e9d6a36d,0x000f1c0e66e6ba0d,0x000058a747cb2451,0x0004b10a20962d66,0x000e1da104e82021,0x0004693d32e594ca,0x0003bb7f837609cb,0x000e53eda7c5059d,0x000b602751dd16ca,0x00007ac67ede2a3e,0x0000000000000000}, {0x00038202cc49b145,0x00003535c208aec8,0x00056079145b2fb2,0x000814d455be9713,0x00082fd8f0bb395c,0x000c755426c09f67,0x0000b748edafadbc,0x000deaf4bc3a4ecf,0x000bff049553943e,0x00057ee542c407a2,0x0000000000000000}},
    {{0x00058193376e77cb,0x000e72c0bba4380d,0x000bc54c3a89ddc3,0x000dd63a1bbc6d0f,0x000bf1518f660f2c,0x0007e5bf5faf2f62,0x0004682bfe7727a2,0x000da33defeb7b16,0x00032b5ef40ec257,0x000a0e902b2e8961,0x0000000000000000}, {0x000ab468387524e3,0x00024e69a88271e3,0x0004545479e82998,0x000121a7373761e0,0x00093e3b1f753397,0x000463acb40aaebe,0x000cb721af707dad,0x000c14e152331d6d,0x00065553048e5280,0x000612aaad009d91,0x0000000000000001}},
    {{0x00092b39f964e28f,0x000fa7cfd7976897,0x000f279c07ec556d,0x0001cf40d7670e8c,0x0007b5e04abdedad,0x0006fcc19990b137,0x0008572f5067ad94,0x000a28101c966a08,0x000b5e33c2ad58ac,0x000eb0e333e24c43,0x0000000000000001}, {0x000f0361a475ac89,0x0002dcf79463ef54,0x000dd053538c22ce,0x0001013b4e6817ca,0x000b44b01a6e12bc,0x000d109d85844a6e,0x000b985bfdaef54a,0x000f6830be544481,0x000fd8dd0297f121,0x0007cb6d0b67a68b,0x0000000000000001}},
    {{0x000ba65ede23b338,0x00026845dcbcdc45,0x0000a0b1cdddd83e,0x000092ea63968b4f,0x0004b71e6e72d35e,0x00046c5ed03f1ddc,0x0006efc5a166bbfa,0x00090de0b5f6b7c7,0x000445136c1387b7,0x000ba78923450ab6,0x0000000000000000}, {0x000a850194005e74,0x0009c00cae44ea99,0x000e5e17b631e4af,0x0001c80d51c0dae8,0x000120c3cbe08ee9,0x00023c8041a40936,0x000ada73446b0eda,0x000643d14026f215,0x0006fbac37813fb6,0x000fc70031b68bb2,0x0000000000000000}},
    {{0x00075ab901660b40,0x0001e645ee7e0ee2,0x00037b06a37399f2,0x00080496e9bd12b1,0x00026a5d50d58960,0x000c1e3f3705ba3f,0x000274a1d4a00817,0x000d2d00866a4d39,0x000f146bf0317c40,0x00024e2ec71ea064,0x0000000000000001}, {0x0003c199f5c7f563,0x00062e4f78f16893,0x000a194ad2a3fb13,0x000080225259655c,0x000bc5898f9da5f4,0x000553edffd8a6c1,0x000e20b2793c4797,0x00041ea73083e26d,0x000a2971a533d937,0x0000e54fd22035b2,0x0000000000000000}},
    {{0x000f9d4de9a27585,0x000400debb5987f8,0x000d526ec09e3156,0x0008bd03e0023f66,0x000aed7d715cc557,0x00058cc9c03099f2,0x000506b4417ca0c8,0x000d23b4df572ea5,0x000c5dc147420ffb,0x00032899652bdfe0,0x0000000000000000}, {0x00031987cf8e9148,0x000b259461ad7d0d,0x000c859a4a7e6bba,0x00030e2b3d2a289c,0x000e9be629139087,0x0003904cf1cf6e14,0x000cca9dab045a7c,0x00082a43de3eacb2,0x000d82c3afa439f6,0x000decd187ae70d4,0x0000000000000001}},
    {{0x00087b4497808581,0x00012be293d33455,0x0004ce4906c6f8ad,0x000a66938d521bfa,0x00046a914bdb3b26,0x000ae5f6e99dc3e7,0x00059dbb0881c2e3,0x00009191a1b5ac25,0x000c6a97a72e5343,0x000ddd07226ad4a6,0x0000000000000000}, {0x00039e249234483b,0x000669419af2063a,0x00042122752c72bc,0x000aa7e19a44c7a3,0x00011188ac573c28,0x0009a3360e14ec6b,0x000bc0bc86245880,0x000741e192993af7,0x000d8d75742bd481,0x0006cd8768555ba8,0x0000000000000000}},
},
{   /* digit=116 [{1,2,3,..,}]*([2^464]*G)  */
    {{0x000ebaeb9266fcb3,0x0006c49166afc8c7,0x000b1a4fb9f8df09,0x0003a2759ef63e0b,0x000ded0e62d1d0a6,0x000215cb79a13c16,0x000942482d5b46ef,0x000a5cf390334543,0x00039ce21c9b239a,0x0000a2fcf03ed34a,0x0000000000000000}, {0x000466a8adf517f0,0x000775523be0b6d8,0x00074759167493a7,0x000284c64894bb12,0x000e2864e9ca25e2,0x0008b7f98fd07d26,0x0003fdb6d6620610,0x000ef64b5a668e1e,0x000d31c44a0ba6ca,0x000891dac14a11ed,0x0000000000000001}},
    {{0x0007e005c5b2f805,0x00010b6d99c24dd3,0x000813da1409fa02,0x0008bf13d53cbcd5,0x0005bb6d8655f948,0x00021f224e5b2d05,0x00077dd3ba305b4b,0x00005337f568059a,0x0008b4b1e783aa9f,0x000d6ce8c56442b8,0x0000000000000001}, {0x0007e0acb71f23b1,0x0007f2e0e90fde9b,0x000336f8ff1da186,0x0004751614e3d072,0x0003187e51c7e8e6,0x0007ef17101ca72a,0x0008a9761c42d892,0x000ebb69cc0c641d,0x0002903e96138250,0x0006b8d2873a54c1,0x0000000000000000}},
    {{0x0007b97b6b68155f,0x000799e78b707b09,0x000e1f75bd19e80f,0x00035096285e6628,0x000d9b8661ae0f1a,0x000fe90a8911dc8a,0x00018180a1d7fb12,0x000733dbb76ae258,0x000085cc47bdbf1a,0x0008c417eada4711,0x0000000000000001}, {0x0006498715c0f18b,0x0008cd3093549e44,0x0007888a48d3a384,0x000a0d971c9394dd,0x000f79cc4aa385aa,0x000d44729501e42f,0x0002ea4042d9ad6a,0x000c1e43ab081b30,0x0002a374ef11901b,0x0009de3ad60e42b4,0x0000000000000000}},
    {{0x00023f47f06415e1,0x000ec51fe7219c05,0x000bd8a88f411a49,0x000308976713e8b2,0x0006ee0f84892d3f,0x000957e9fa410c61,0x000903d60b015584,0x000f41fc07f1fce0,0x000fa3ce182117ef,0x000654b039b5693f,0x0000000000000000}, {0x000f700d59c0d688,0x000bcc693fd9aa04,0x000b8b0e7fea0743,0x000182c181c35812,0x0008864896cc8fcb,0x000c77cf499f019f,0x00010bba6594c508,0x000e88406e142c41,0x000b45fd50fcaee7,0x0009894dc1ba3eb8,0x0000000000000000}},
    {{0x0007488ba3fe2367,0x000752106ad62ea4,0x000980bc62d3b8ad,0x000328ef733708df,0x000d47b00f88c069,0x000f6bb0176a2cf3,0x0009f6480ef1ba36,0x000ac0712001822e,0x00032f8aac418a68,0x000ff326047c12c9,0x0000000000000001}, {0x00039bbf3cc8d8c5,0x00091d5e4cf0789b,0x00042078d73c679f,0x000b71a650f7aeca,0x00082a530b74abff,0x000a71711bd8405b,0x000c3bb0ac95d510,0x00094cee94894b3c,0x000906c5e7b66990,0x00030a027cdba56d,0x0000000000000001}},
    {{0x000c446c47eef0c8,0x00044a0878421c07,0x0008722c55cf2755,0x000ec763424a48fb,0x000f4f6b5b3b9028,0x00078d4fe3ca8f7b,0x0003f4277d82e20f,0x000fbc6300a704e2,0x000a908b8f5f71bb,0x000b090bc8e8a53a,0x0000000000000001}, {0x000dcad6549fc8da,0x0004e635d31de3d0,0x0009ac9c9dae5fbc,0x0005d812525deba7,0x00028465a1ffb0b8,0x000039c002085422,0x000d1431962a343c,0x0001729577d460c9,0x000befcdb0fe4b63,0x000f982552806705,0x0000000000000000}},
    {{0x000c16470afeefa0,0x000c0df482969752,0x000988294a6b7345,0x000192c323f56fda,0x000ece866a0fbb9d,0x0003fb58e433eb87,0x00044e600bdf291f,0x000bc9a43f5fab4d,0x00060683951124ce,0x00065a7c641677f4,0x0000000000000001}, {0x000ce490f8bb04ea,0x0002e7ad3382ee72,0x000272231533e6b8,0x000186b13ffe5f10,0x000cc8faf0cc5e1a,0x000c709ed2b173b2,0x00067e514381962f,0x000cd58bc198455b,0x0006402864604346,0x0009d46f62db1463,0x0000000000000000}},
    {{0x0007bb607e896c28,0x000e0a894887a4bc,0x0006eb1e97614230,0x00003e71e2c653f8,0x00096dded494be93,0x0008ac95d09fc0dd,0x000bea563fba0619,0x0008f3c1624d738a,0x0009df64d4a0ea98,0x0001d5c6ae182338,0x0000000000000001}, {0x000eeeb900454516,0x0006377d7a8b0a7f,0x000a9c345a7de36c,0x000100d5611067e9,0x000806bcdcedd0a9,0x0002b5dec6f6c68c,0x00051f38d7d4a349,0x00022d5061b9ad36,0x0005c9ea7f739c0f,0x000ee734e6cedbd1,0x0000000000000001}},
},
{   /* digit=117 [{1,2,3,..,}]*([2^468]*G)  */
    {{0x000eb05013cb5aab,0x0009afca55bd420f,0x0009c3c71fd8695f,0x00000cafcc6e5ed1,0x000728edc89ca3d5,0x00076471854e21b8,0x000201f0ff872ac7,0x0003e23036d8ee45,0x0002c13f7c8bee8b,0x000707a1d51a1e5f,0x0000000000000000}, {0x00022b011bf68532,0x0000cf529ed8e280,0x000b8a477a52b6ff,0x000cd2f63b6e8238,0x0007c291c55c9cf5,0x000f4796ab42ab24,0x000c0989f93937b3,0x000bca7b47aa5dbf,0x0006f0a6b7620e79,0x000f58dd4ea00729,0x0000000000000000}},
    {{0x0004f87aac9cea1d,0x000fabffc3ba2342,0x000a3b2b167162b1,0x00073da5b86c7978,0x000769b5f991d83e,0x000cb3d9088d484c,0x0004542e085b4392,0x0004eba2ea8f2806,0x000c46cb82b91d2b,0x0008c0e83321f8cd,0x0000000000000000}, {0x00097601a9d31426,0x0009ef4a0c50dffd,0x000fc4b8056305e9,0x0000c1c8a29f6e86,0x000d4be1babedf5b,0x0005e98d4d558d2c,0x0007fd7d17d7bc87,0x00009a0a33b745e5,0x0008c2a2bc3cf9b6,0x0006235277b76d2d,0x0000000000000001}},
    {{0x000ad9eb395de05c,0x00050bddffa75224,0x0008d48f88a50e57,0x0005bffe3c2175d5,0x000aded74a44ab8f,0x000f36097483dc36,0x00041e5290fdaaf9,0x00051f0f28ee6aea,0x00006d6a082ff0ae,0x000068e3568c35a6,0x0000000000000000}, {0x00052b137174e56f,0x000a242808c3c521,0x000cee713ccf3a0d,0x0007f4523126e210,0x0009790a26049fad,0x000293cb237c8c65,0x000391754b82c700,0x0005060129b75ceb,0x000ad78c9cbc1be8,0x000452fab6d7a60a,0x0000000000000000}},
    {{0x000614e7a62b479f,0x00091b1806f1503e,0x000c937295d07735,0x000468f3b432690c,0x000027af2bc376d3,0x0001568b1fc765b5,0x00004c84508081cf,0x00093b08d2fa4f2d,0x000aa23530d43841,0x000eddd4118eb0fd,0x0000000000000000}, {0x00095d916a74bf7e,0x00052f879c30fb73,0x00033e906c3732a6,0x0009ecd6d707078b,0x000764fe7914feb0,0x000164429576e244,0x00070601ef70830f,0x00038d1a94c290ff,0x0007e067e8e38b39,0x00004d7b7a7e7934,0x0000000000000000}},
    {{0x00092dd8b3c6e87d,0x0006c49275954a31,0x00016b291ceab935,0x0002ae4fca80283b,0x0002ae3f769e974a,0x00047d8e3a1a96a2,0x000875bc17f080fc,0x000a5eabb84f45c1,0x000e2f2661df31c8,0x000663147f43e69b,0x0000000000000000}, {0x0002716571c12164,0x000b5580b0b11754,0x000bedf056c51a6e,0x00019d3572bd29fd,0x0006ce46ac6d5756,0x000d711d909ced7c,0x00056c0ec115b51f,0x0005ebe8c1ea4d63,0x0005d77cf7a0032e,0x000ddbec9919b1e6,0x0000000000000000}},
    {{0x0002437a972f2c78,0x00015b5e5010e549,0x000fb968e48079c6,0x000ee7041338af95,0x0007cad3cea2147a,0x00063a330c01aad8,0x000ecdd3002cfb58,0x000bf58e568343ac,0x0007567e97251d0a,0x000b568be5a71fbd,0x0000000000000001}, {0x0003982ec0a47e47,0x000862df20207b07,0x0002c656e08dda4d,0x0005ad59afe9aa6b,0x000ee04d8bf8d524,0x000d84cab42cc2b5,0x000ee837ff8c6d4a,0x0008b691af448525,0x0003b100c345fb36,0x0000d061abec1e80,0x0000000000000001}},
    {{0x000c9cc4477a0393,0x0002f0a9ecb165af,0x0008a80444bd4fb6,0x000a9d4dd001619b,0x0000b10c19a21051,0x000801b4ef3f9384,0x00076219bc4d71f3,0x000ea7190314526d,0x000da93e188e8697,0x0000967b67776acf,0x0000000000000000}, {0x0006ab2717f542c5,0x000ae82426abc0aa,0x000641af35023777,0x0005dcf6c7153a96,0x000977e0ee60ca55,0x000c371732ddcc64,0x000063579dd744f3,0x0004f34c496af4bc,0x00000f9df0536028,0x000b1c2a26167cf5,0x0000000000000000}},
    {{0x00061fdc0b1fc134,0x00059fe59da03f7e,0x00051831e7698bd3,0x0009f81df982fb68,0x0001c64253ce4407,0x00084a0c0fffbd0a,0x000fd2724ab08376,0x000aaefd7b900fa3,0x000017be08cd54b9,0x000359398932034f,0x0000000000000000}, {0x0008bfed571b358d,0x0006e5bd73f12c5f,0x0007574722cbd9b4,0x000789de672fc532,0x000cf9d4c5de795b,0x0008e00647313e84,0x00001e2002f19344,0x0007649a15d6dda4,0x000a4f04c96114ef,0x000ac34a9dc08537,0x0000000000000001}},
},
{   /* digit=118 [{1,2,3,..,}]*([2^472]*G)  */
    {{0x0005e5ed4ea72f88,0x000dc27eafbd5d75,0x0008274c8f222817,0x000e4b956ed11c56,0x0002ac506cd96a0b,0x000c56121cfca3c6,0x000e3c5160f64376,0x0001cd969d9794e1,0x0002818ba2a1b9ac,0x000bbd5d12cb946a,0x0000000000000001}, {0x000065269838f81f,0x000a256eaf242367,0x000743908912f4af,0x00048d332342e954,0x000f75565f855ec0,0x000e4ec59a3a8816,0x000505255b015d48,0x0006bf898ef06a71,0x000af90ae385313b,0x0001d5415dc8688b,0x0000000000000001}},
    {{0x000115486df6f2ba,0x000803b08c738eec,0x0002302443593e59,0x000e60eb4f00e934,0x000e57c91438ebdb,0x00080e89c523e859,0x000d75cba0053e05,0x0000d11317c9b329,0x00035e5703d38955,0x0003845aac6426d2,0x0000000000000000}, {0x000349105fa06b94,0x000e9b21c69e6c42,0x000f70eb1519a81d,0x000827ae2990539b,0x00048fe9bf0bbafc,0x0008dbb3c1ee9dd5,0x0002a908c4d4274b,0x000cb7224476f3be,0x00028346b6e6842b,0x0003ad39da0c7384,0x0000000000000001}},
    {{0x000a9a342fa007b1,0x00065415bb7a90ea,0x000dcc6aa0c26771,0x000a1f0bc720264a,0x000b5e93f7bc1986,0x000bf6b3fca182f9,0x0009a7b5c22f84c1,0x00087bdec7ad14eb,0x0008902c942c3b07,0x000a69d7973e7810,0x0000000000000000}, {0x000230ff44676602,0x000d3064b8821220,0x000d730a5228928d,0x000ea087c0f54e1a,0x0000abe8035de528,0x000d9e98d62188b8,0x000d85f12fe3f391,0x00095d1c13b3c4b4,0x000c9a4940436d0a,0x0007d2cc5f243602,0x0000000000000001}},
    {{0x000c484e2708d61a,0x000e14446b62d85c,0x0009c0fff451d84c,0x000a49ca08f1ae70,0x0003d71899e1ae53,0x000709a90d9917f9,0x000f39b12fbb0503,0x000038af72a2045e,0x000817cd90b8cc9a,0x0002f352b4ed83f0,0x0000000000000001}, {0x000a71d48ae023ef,0x000d8744e50d53a7,0x000192ec22667e7a,0x0002e19437867d3b,0x0007124825f0cce3,0x000aa41f07fce902,0x000fc674b8262125,0x000d1f602e03c9ce,0x000f93cc0c071ae6,0x0003fae4c52caef9,0x0000000000000001}},
    {{0x000d102ba58b5201,0x000cb021f49742da,0x00078984de6430a2,0x0005002098f1e552,0x000c9b804a37766b,0x00095479cd052eaa,0x00083f87dcee9cc2,0x000ce159b125b614,0x00001a384dc69331,0x0002e4ec5a2f8699,0x0000000000000001}, {0x00049fffc681e26f,0x00001b52ea90f687,0x00080117445f69ef,0x00093fb5f32e704c,0x000d36110b81abea,0x000a3e64f4ffada3,0x0000ff99dcba475c,0x0000eb1b968c2040,0x000ded29d4be59cb,0x000ba78061ed859d,0x0000000000000000}},
    {{0x0004949755c59603,0x000c796691a84904,0x000a8445d0aabdba,0x0002396cff6a7bd7,0x000562547f935def,0x0009038b91c344b0,0x0001f20274812ef2,0x000e1fe565e5087b,0x00074866fd902829,0x00032844aad6b8f8,0x0000000000000001}, {0x00092e9251d05a0d,0x000328420cd4a328,0x000e00dfce4ccaef,0x000beca3a94d516d,0x0000fce64bd11bb9,0x00054cb1e99e5269,0x000cfc1bfec9624a,0x0004e634fe2023b3,0x000e53481128c3b5,0x000cd2258147276f,0x0000000000000000}},
    {{0x000e9ad8d783865a,0x0008e5a58d54402a,0x000e236d64e3be62,0x000daf46f4aae16f,0x000049ba7000cd7f,0x000deb437c36e86b,0x00025e5a9179d63e,0x000fb30e5ec5adff,0x000fc4d691408156,0x000d8b4dff418608,0x0000000000000000}, {0x000c4eed479219ce,0x0008e4d5ead8e114,0x0005f4f71316535a,0x0001c636b70e9489,0x0008aa2310479eec,0x0004e1dcd4f2eb70,0x000474c99b5134b7,0x000ce4754e99035c,0x000218919b4c0dad,0x000e1d1dd3f97981,0x0000000000000001}},
    {{0x000cc18c358773b9,0x00036bf6385f12eb,0x0008a0c24ba8caf5,0x0003093cd83891ca,0x000f5b8c3762108b,0x00041e3399b26a0e,0x000fadfca8c426db,0x0004173bf6760263,0x000a6677ad40bf58,0x0004eca4760acdd8,0x0000000000000001}, {0x000c42b8b4207fa1,0x0006dc5a60d34efb,0x000a367e08d67868,0x0008cead3e942c85,0x000409d289bdc2dd,0x0004b034c3a6d1bb,0x000889304955940a,0x00080034f3684e43,0x000808a7cddeee0c,0x0001148f3d9aa263,0x0000000000000000}},
},
{   /* digit=119 [{1,2,3,..,}]*([2^476]*G)  */
    {{0x000df4a3fd3e1bab,0x0006287d84daca3d,0x000d7eaf57017e3e,0x000d1a4e4870b354,0x0004c26a3e3ca9fe,0x000ce1ea5e5710e0,0x000709e17a2ff920,0x0000f8a3bc06ee67,0x000788ab8c019a66,0x0006f43d909c0fdb,0x0000000000000001}, {0x000c0c61eebda5c3,0x000395c130704b51,0x000762ffbcb5d086,0x000f660bf6639983,0x0001646d9fb03337,0x00065cf06a8fa37c,0x0005f2e3f14b6d28,0x00088227d360e736,0x000a48fcdc5c3e58,0x00059e8c2eaf07b6,0x0000000000000001}},
    {{0x0001ce2b5f2dc50d,0x0007e39f8c4d01b0,0x00078d34284f417d,0x000d157acbf04214,0x000c0c4238071f59,0x000b0a1e05f8a594,0x000d81bbaf85cdc7,0x000d1d1329e8c9cf,0x00068fc55c9be4f2,0x00029b5c20884e31,0x0000000000000000}, {0x0009fd4109cb4727,0x00021d96d542276e,0x000d61e57db16c16,0x00052da58656adf3,0x00089d546ecce2da,0x00041508ee2098e0,0x00011997499c874b,0x0006f525839d9cf3,0x000de08e59654896,0x000e511cdd85c0a0,0x0000000000000000}},
    {{0x000db13610c4d993,0x000192018344e51f,0x000cb8a7e81016f0,0x000425ff1ca2c27e,0x00047a8df5318c36,0x0004872bcd56d5d2,0x000d142a2e0d2618,0x000a83feb22e4866,0x00013dac70999b14,0x000ed007863be6ab,0x0000000000000000}, {0x000023bbbd62b467,0x000e6ef8f48d21ce,0x000ea9c5f9c35940,0x0009af532bd76e0a,0x0000f8ff97911a1f,0x000efcff41750c50,0x0007cfa3985ad13d,0x000136812ef99c02,0x000319ee534694b3,0x000b9d9722dca85d,0x0000000000000001}},
    {{0x00040d25bac4c923,0x0005026132b9fa82,0x000ddc2ef3e74ec9,0x000151b0a9db4e16,0x000ff5ad95c1429d,0x0008144cde9bb57b,0x0000c02f2a19e480,0x0005655b0b6aef98,0x00038725b1f2df6c,0x000672346457ed21,0x0000000000000000}, {0x0003077ffe12bd18,0x000e682804b9bb8e,0x000b8a3a7328db75,0x0007b6f50cb1bbec,0x0007a823e8549b58,0x000d7be7a7e70575,0x0007103b60b8617d,0x0004131d7bc32367,0x000713f91128ac22,0x0000deadb3b9bf03,0x0000000000000000}},
    {{0x000b46eea58e4f6c,0x000e8500cef9c4a5,0x000e36179b50381a,0x000498cb317e7dbb,0x000df2d824ab9ac6,0x000aa97d96328707,0x00068fd80e79f5f6,0x000ee03799c5c193,0x000688d4b109d20b,0x000fae5dfd91a5a4,0x0000000000000001}, {0x000e4aa8649aaa1b,0x000caf8a4a894ffc,0x000f0a6af855f3c5,0x000fa6ef0a082826,0x000564cf46392869,0x000d9060255a7500,0x0007688b437590a1,0x0005fa2a21425afd,0x000dd69d65b91f19,0x0008045302895146,0x0000000000000000}},
    {{0x0009a872aecfc094,0x000c8cde3af050fb,0x000ebe6b500bec0f,0x0004d4b7e7c4ef2e,0x00094b38a6c4228e,0x0004f9fb0e82362d,0x0000dbf4e229d20c,0x0003a6e45bdfa369,0x000b1c90f730c74e,0x000306f2fc481fa7,0x0000000000000000}, {0x000e496c4b887a36,0x000e6ae46148f8e5,0x0004268188f16f8a,0x000cf1b360936452,0x000ea828f2ec9dce,0x000a581be5eec097,0x0000a093e062b3a8,0x000e4da12b498543,0x000b50541562092d,0x000eae33c27b17cb,0x0000000000000001}},
    {{0x000bed4ffad0684c,0x000bb264e57bfffb,0x0009eb6b035825f2,0x00013466fd8b6643,0x000ab9c3537903c2,0x000b0366be7313de,0x00096ae2121723c9,0x0005953e87c3ac29,0x000b6974bbd38278,0x0003e43a30236cf9,0x0000000000000001}, {0x0003b2707ffdea7f,0x0002da68809f795f,0x000374c5228ca4a1,0x000ef9a132cc5a86,0x0002bae5f8c0d15c,0x00061ce20672616f,0x000abed75c41da6e,0x0006a5fc5af7de33,0x00076a4d15065912,0x000ed44c16e78857,0x0000000000000001}},
    {{0x0003498018e534a0,0x00031b029f064c8f,0x000b893aedc07be9,0x000b0eea14f71f6a,0x000eee179067b242,0x0009f6bf528af895,0x00020985e852a279,0x000b94bc19691d5c,0x00005deba296ab7d,0x0000b231b9475f76,0x0000000000000001}, {0x000c45d63f8d3bc5,0x000aab0d9145a0f8,0x000bc0cd8bbb3a1d,0x0001299d614875d3,0x0008bad650d624f5,0x000b91d8407baf74,0x00054a383b9d385d,0x0006840ae765f5cc,0x0005a54bdbe2653a,0x0002865728a0edab,0x0000000000000000}},
},
{   /* digit=120 [{1,2,3,..,}]*([2^480]*G)  */
    {{0x000e419064732d33,0x0000fb9f1fdd6e2b,0x000b458dd169ab15,0x000b79def3f55fa5,0x0001fd9b88ebfb1b,0x000b8b17a8c1d98e,0x000e6b37f6beb8b7,0x000dbc72340b6c86,0x0007c19d37bb70ed,0x000f6867a99418dc,0x0000000000000001}, {0x000a4a09f22c0fb3,0x000bb19cb6bc1256,0x00077d8b51c8ded9,0x000574809f35ca45,0x000bef1168ba7eb2,0x0002cdae11770b52,0x000ff68ed4f42bd1,0x0003d326b225de9d,0x00037f1445631a8c,0x00012cb14a3c371d,0x0000000000000001}},
    {{0x000b0b95f0603f03,0x000fa7f969adad66,0x0001acf774657813,0x000a2615220707f6,0x0002f71d4cd53712,0x000f82a44a2fd4ef,0x000773fd9e262931,0x0002f763ad200681,0x0009b206fe31fd70,0x000765c3a8767fa9,0x0000000000000000}, {0x000a7f8ce84569e5,0x0009a821c3dd4741,0x000e90e3290cc915,0x000cf99306b623fa,0x000d7531760ae9e8,0x0009e7cf282874af,0x0006e1ae6527ae8c,0x0008f99eef73293d,0x00037109e03d3d87,0x00036ee1efdba892,0x0000000000000000}},
    {{0x00051928ed074ce9,0x000b292af7a58dcc,0x0005ec5d4bdfb374,0x000cdd85d01fb1db,0x0006e626365656d8,0x00074fc478641e47,0x00016a5e28d244d6,0x000adbaa94ddb39d,0x0007fdde95fd5183,0x000b47ea66d8626b,0x0000000000000000}, {0x0004c9d4962ab02a,0x00021388f7fd2b57,0x0006c23d66031232,0x000a1a6ab2ca0c2c,0x00017664a406bce3,0x000f5497442ca199,0x000866b6f2fc1498,0x000a41cbc3b0ab32,0x000557ca37a277ae,0x000af01602653825,0x0000000000000000}},
    {{0x000db75622a8dfc2,0x0005479be9e5c74f,0x000548d39ec29bd5,0x0007942d29c79da4,0x00079c4bc1f5df3f,0x0004a7cecb948e1f,0x0008793b63229ed3,0x000939c1a7d67689,0x00057ad78be3b341,0x00052f2801351b91,0x0000000000000000}, {0x000cbeae6fece889,0x000b3085ddee3b59,0x000eeab1d348140d,0x0006bba941a033c2,0x000b685703aafb67,0x0005046b6423a9d8,0x00075dab832a7c83,0x00015b8c259b9e24,0x00018a6bbb51f863,0x0003a253eb5dc8db,0x0000000000000000}},
    {{0x000cca37a85cafbb,0x000b3657f26e3623,0x000787ec793c4d2a,0x000337f7520b9137,0x0000dbcfb7906436,0x00018cfaf22caa7a,0x00044625a502d754,0x0000066c6a130ba1,0x0001212f51d083e4,0x0004ebb9541e99d2,0x0000000000000000}, {0x0009384f4e2ab22a,0x000ff707cf7953a3,0x000aa5f9b05bdfba,0x000626e81b083e95,0x000defb350599782,0x00092399d206f421,0x0008bd9415729d3e,0x0008cf10387904ad,0x0006e0bc19370ad7,0x000b48f2c002a076,0x0000000000000000}},
    {{0x000b8bb85d8adb3e,0x00067b9a142f9bd6,0x000fc51be0f979dc,0x000cb118f84e32d8,0x000a7f5b6ca36f9c,0x000a900f565e79ab,0x0003143fcfd2df63,0x000122db9b751516,0x00086015e5f85f9f,0x000bf0e7c48af6d8,0x0000000000000001}, {0x000cbc466d0dec7f,0x000fcfc13f4daf5d,0x000613ac2b0043ae,0x0007d2ec60909041,0x000eff4b79cb6956,0x000e04188e57b5e5,0x00045aa9dd05dcf8,0x0007cd8106c6759c,0x0004b84b0c6c633a,0x00041ee796334569,0x0000000000000001}},
    {{0x0008ed21f68b4a3f,0x0009e0f39b982afe,0x000ef033664df945,0x0006109c1245ad2f,0x0004d6578f9c34c2,0x0008e9fc097b7383,0x0007b3121a085c72,0x000365666df584bd,0x0007af58ed558596,0x0007e9fd1e18ec9d,0x0000000000000000}, {0x00017df29af6bc16,0x000dbbf468848de7,0x000d747cd3b7c888,0x000801a051097e9d,0x000f68bb9b824e70,0x00027a8a5f172bbf,0x00074f9f45d5351c,0x00080ba6fcc24020,0x000d4e050d7e5a57,0x000cebcb9d2f1cc1,0x0000000000000001}},
    {{0x000b990fe3b9d773,0x000eb81096bf3df2,0x000eb580e653b2d5,0x000cfd31a2ad7396,0x00065cddd150bca4,0x000cde916b4cdae8,0x00019b56ffe74e35,0x00021e7dc0b21b6f,0x00099d8bf333016e,0x000eb146cec318c7,0x0000000000000000}, {0x00030acdbab36d51,0x00089ddd1e911c98,0x000891db5801a0df,0x000f1a5d646bbddd,0x0000ac4d27510e25,0x00044af2f910d55b,0x00024a75bcea08e1,0x00037ae5f37d50da,0x000d372739ad211e,0x0002a2d9d5c41773,0x0000000000000001}},
},
{   /* digit=121 [{1,2,3,..,}]*([2^484]*G)  */
    {{0x000ce74763660052,0x000da3e409da1731,0x000098b5f715b328,0x0003538d607382a2,0x0007bc3ee7b0651c,0x0006d5eed9abf1dd,0x000eb18e8c0d16d9,0x000e3fe464dc1a4c,0x00030d6fa6b9f8f1,0x000cfa359d987d0c,0x0000000000000001}, {0x00047d09810803ed,0x0007b5b97b578929,0x000cc27fc5005d73,0x00040feb2087e2c1,0x000b7dd0d960662d,0x00025ee555f37345,0x000d7c17f3858a72,0x000a0cf2ae739ae8,0x00000ee77dcf4e1a,0x000c12649e41ecee,0x0000000000000000}},
    {{0x0008de672d619b61,0x0000ea8326922a80,0x0001a0841b015626,0x0000f8a963e3e317,0x00037806aeb44acb,0x000d9d8a14334837,0x00026bd761a3419a,0x000d2e7a343fbffd,0x00086e32c6d361b6,0x00023ef433219c4d,0x0000000000000000}, {0x00025620f22d4f25,0x00067dd5c03d381f,0x00080f734643a87f,0x00006c5ee876505e,0x0002b491baac4e49,0x0003e07deb178a01,0x000ad060f735b869,0x000576ce5dd8d75f,0x000dd4cd9c97cb18,0x000cbc634bbb55f5,0x0000000000000001}},
    {{0x000b9733710e8e01,0x000e73a5711788b8,0x000bf8afcacf73a9,0x000d6725ee57149b,0x000e7fe486c64e2e,0x000322f9087bd5a6,0x00009af08709418b,0x000084990390cb99,0x000a6bb3ab911d03,0x000d2868a69e665b,0x0000000000000001}, {0x0005e749b382f6d2,0x000a9a1034406b89,0x000826ec06265b52,0x000e64e9aec95b07,0x0003982f9a9c5d16,0x0000698b37d7e83c,0x00050d8bbdbeb42b,0x0007c82f4fbc8ae9,0x000adc1e63d423d5,0x000b249310802372,0x0000000000000000}},
    {{0x0007033614a6d5dd,0x000fddc5f2fac137,0x000e014aa4b4dee5,0x0004a9b72218fde8,0x000c10e229612a68,0x000cb5b99f1d9b66,0x000eff01796c1307,0x000ec087152271c7,0x0009f171d27930b1,0x000dd53091f21ad1,0x0000000000000001}, {0x0004c873e4172f54,0x0006ecbd512368a7,0x000d3ea21d4bc31a,0x0003a95f62eff689,0x0007c73a33474bd4,0x00088fa97a141350,0x000b4d3b01846eff,0x0005fbac8f6a8f06,0x0009ddd58dc2a301,0x00001f7b911f1a15,0x0000000000000000}},
    {{0x0002e681058bcd0b,0x000ecb766f6bc98d,0x000866fedccaaef5,0x000b2e2473204d11,0x000f6e18757016ad,0x00011d59effc1a8a,0x0002050629e88cfc,0x00093c7bdc024782,0x000a9b2aeb9bb00e,0x000336991f06d2c0,0x0000000000000000}, {0x0001568955531744,0x0008281170681859,0x00050d7be99cf6e1,0x0008cb9d185c0963,0x000f49cfc22a2afc,0x000f9d20626a2a56,0x000ad87b48f04b95,0x000bd1441cc30d3e,0x0003e9b72d43f56f,0x000e3b3843d17383,0x0000000000000001}},
    {{0x000e873b05f77e97,0x00071d5ebf3c8d2f,0x0005b9ca7cc32fe3,0x0008798cc245b054,0x000e6eaf83f8b265,0x00061d87bdf09afd,0x00048a529e1b9707,0x00001501c97ba4fd,0x000ca96655ab0a10,0x00042f0ec7beee1d,0x0000000000000001}, {0x000296b82c7a9289,0x00070c171dfdb228,0x0001dac3a3a171bb,0x000b7ea6ad9a13af,0x000251fe361dde21,0x000cea9acd2f8b81,0x0008480e8df3c1ec,0x00038a5f495ca4b4,0x000fd225cb8ecc78,0x000454bc6bffc707,0x0000000000000000}},
    {{0x000af33412f12687,0x00015e41163cf0f3,0x000967fdc5a6a476,0x0004235cf9f62e34,0x000b314d06a6a848,0x000820f5665619a2,0x000f11a14ea427a8,0x000ce9a80c44b6a1,0x000f92bed7985fca,0x000dc713540bdff6,0x0000000000000001}, {0x00065826c0cb51e6,0x00030220ec95e76a,0x00064aea77a786d0,0x000cb5ba9e93c602,0x000f020c5b781189,0x000e7b4655282299,0x000e97af8ea95e4d,0x000a8a80a0f194a4,0x0006433581c41d62,0x00066e34a29ca8e3,0x0000000000000001}},
    {{0x000cef36ab807b63,0x000040cdf4c99984,0x000c211953a5f8d7,0x000ab4c0faefc5ed,0x0005ca17066a1563,0x000fb2c0940c339a,0x000b1e8517a5667a,0x000c3d2a94a0b135,0x000185e4d4526e2e,0x0001b53c05d493d9,0x0000000000000001}, {0x000c5ced3676f843,0x000195ff470fab2f,0x000ed29f4a221ddb,0x0000868b2d94f5fe,0x0003caf8fcc5069f,0x000dcfc1418631be,0x000998943a070623,0x0009bafa5f731c9d,0x000c5c56c1cc4a06,0x000a82f502e626e1,0x0000000000000000}},
},
{   /* digit=122 [{1,2,3,..,}]*([2^488]*G)  */
    {{0x0009edf282d019ec,0x00099e8e335e18d2,0x0004ace8ce0e046e,0x00001d0f72c0503a,0x0007e9c6d09e242f,0x000998b6c2fcb456,0x0000be40686ceb13,0x000db8fca6af9143,0x000c77e852236ef5,0x000ba3718e1a2901,0x0000000000000001}, {0x0005ae430ab427d9,0x0003d8a843a1b6ab,0x000c9500fb6025f6,0x000b9cb8d803e788,0x000fcea023d9bfb7,0x00003f3ec5cdad70,0x000188da7e50d4c8,0x000f9eb540fd9c07,0x00014ab57822ee2a,0x000574aff12ba00d,0x0000000000000001}},
    {{0x0003c20dbe0952a3,0x000480b6013f7fd5,0x000447348d109d4a,0x000fe6fecb6a7da1,0x0006564e8c529d8b,0x000034045fa60672,0x0003ee2a8df68fa9,0x00021796dbc7ff3f,0x000a130fededc279,0x000fe24c3f368ae9,0x0000000000000001}, {0x0002961eb9eed66d,0x000919ed55f27279,0x0000068193a9b014,0x000f317444cb0bf8,0x00096e22227ee32e,0x00047c8b854cb4a8,0x000bf6dc6a73b281,0x000d6804296e2ed1,0x0003e6f8a77be001,0x00084c89b143ab22,0x0000000000000000}},
    {{0x0008d791f2d40215,0x00003b05d1fd525c,0x00037b16b3ca30ae,0x00070792a856131f,0x000b7639faf0f678,0x00006b7cf12eff42,0x00098ab7a44f2173,0x0006714e846ec06d,0x000eac350874a266,0x000b56e5920dc3ae,0x0000000000000000}, {0x000d703e34853d1e,0x0002cd53a7cce717,0x000410bff4f394e1,0x00074ecb0bba0cc1,0x000de8fa9da2c436,0x000f5e3f74e2caa0,0x000cc28b148d1eb1,0x0009fc1ac5bad585,0x0001220666fb73af,0x0000c3241a57ee07,0x0000000000000001}},
    {{0x0000e99218ea1f1f,0x000ccf21044500ec,0x0000c873630cba88,0x00064f806fd4e4b8,0x000a7056645dd457,0x0002ed87394551a9,0x0008987025ba6b17,0x0005dd01b45fa9a7,0x000ccea3a1f9f135,0x000592807cbab8d2,0x0000000000000001}, {0x0006c96e8e24e119,0x000d921a51e8134c,0x0002ab9759957065,0x0004035ca89e1baa,0x000df057c2aafabc,0x000c0890aa1a6716,0x0006bd3f802387d9,0x0006a39383e5c778,0x000601e4e1f62705,0x000096f226577900,0x0000000000000001}},
    {{0x0001d3b5076ee66b,0x000068e996c31106,0x00063f8bf5d922ca,0x00008ed44203a2fa,0x0001df0821d991eb,0x00019d54e602f04f,0x000bf35cd4ee7bb8,0x00015f2609e3729a,0x0009e8e65b2fcd60,0x0001df9e9c109298,0x0000000000000001}, {0x00058eae5edc3042,0x000fe31ba09cdc97,0x0006f52853b56fdb,0x0003df0f5ca36adc,0x0000a54940d61878,0x000902cef58665ba,0x0004efbb68e67641,0x00036806e0aaf0f5,0x000194a89e785e8c,0x0008883379ceb241,0x0000000000000000}},
    {{0x0001a19f7b341ee3,0x000076e0e5354bd1,0x0001806a485286dc,0x000d2bf681431840,0x0002c82334b1343e,0x000b6908add258b2,0x000737bf47a5dbe4,0x0007303c531a0b11,0x0003a29d6501615d,0x0009313aaea01e10,0x0000000000000000}, {0x0007b22b906a725c,0x00024ad4ce011033,0x000bf242639d28fc,0x000fa39cd38de6c9,0x000a72beeb0f8fd8,0x0009a0ad9b93380e,0x000c8221fc799b7c,0x000be51116d9d8de,0x000a10526402ca53,0x000777aa2c9ac3b1,0x0000000000000001}},
    {{0x0001a723455b8da2,0x0001d0c7c777796b,0x000fb41cc9b1644a,0x0000ef5ce0972939,0x000637a26ddcdf7a,0x0008cf1a639f0844,0x000023a3ce642ca3,0x00098f7db827cdb3,0x0005279eee7f6f0d,0x000565523e47e762,0x0000000000000001}, {0x000fd1b034828d4a,0x0000721a61eafcaf,0x0001ce95f4ec0ae3,0x0003ba2db4a66fba,0x0006525e6f06fee9,0x000817b26fcb0ef3,0x0000265db68ac06f,0x000f74e811cb24b3,0x0006550f9c2bf885,0x0003940f2d2fcd83,0x0000000000000000}},
    {{0x000e8955d1b109b2,0x000e1de1d0f381d4,0x0006407a6cf45a79,0x000f2393e689a76d,0x000d3d92aed2a407,0x0005547cc6ac261b,0x0005e0b9e62fcac9,0x00081e2910774983,0x0003d6780dde8f90,0x0003c5c4cab77f7b,0x0000000000000000}, {0x000e052d3f3dc82c,0x00039caa1aeecdbd,0x00024153092958c9,0x000c11b7ca5c0f7b,0x00027c92847965c0,0x000732af643698d8,0x0000367351c0ba1d,0x000f1b1bf491a3ee,0x000df3514ec2302c,0x000b4c4436d640af,0x0000000000000001}},
},
{   /* digit=123 [{1,2,3,..,}]*([2^492]*G)  */
    {{0x0004265bd7179d88,0x00032014b97128c5,0x000fd3dafdfe0b08,0x000b1956b3fd6699,0x00091416a87bbb8b,0x0001dd4344038f86,0x000566c88826c840,0x000f07a8a4b77456,0x0007671e1b2fca59,0x000200797dc52a03,0x0000000000000000}, {0x0007843bbe8d7f70,0x0004f9ee9b4c465d,0x000303b1652fa39c,0x000ae7c4c4a55ae2,0x000263ccdcb67c15,0x000a17fd06da8ac5,0x000c10d8d1d1e927,0x000e5bfc6232685a,0x0003162cd048bbb8,0x000b11c2cffebb23,0x0000000000000000}},
    {{0x0002cb202ec3c178,0x000285de81ad92d1,0x000b71b77497dfd0,0x0007a8a10c150a03,0x000bbe99f4ad3f59,0x000f4533b0aef51d,0x0003b27838ed4931,0x0008ffc95a8ebcf1,0x0002cefcf5623ddf,0x00010737c166832b,0x0000000000000000}, {0x000e740d8da2ff7e,0x000624f3d3ab048c,0x000376415ced03ed,0x000fbe5676391c7d,0x00081671ffe7b22f,0x0000390438cc5f49,0x00084a5ae289dd49,0x0008f9a1f5bbef09,0x000b05c4941c6652,0x00083aef77ff073e,0x0000000000000000}},
    {{0x000604a9bc6900b6,0x000878e5f51ce9df,0x000b763f98cad97f,0x000f5a1389d3ab54,0x000ab3d0efdef6fe,0x0009be5cf0df2543,0x0002a0d518696763,0x000134850193d832,0x000860abf9047761,0x0004b4f04b3d8de0,0x0000000000000000}, {0x000e57c44a551894,0x000a3fa66238e065,0x000d140af7878a12,0x000de14d55dcc858,0x00061c7b391cc65f,0x000d7dbf324d8825,0x0005d09aa74e78f2,0x0008ed166a4503f8,0x000da0c2a7ad860c,0x0002048d8fe387e6,0x0000000000000000}},
    {{0x000505ddc7162a8e,0x0001fb5ed0deab66,0x0005e972cc689dc5,0x000e495fb69dc78b,0x000ca3f1826690c6,0x0005f6186896d605,0x000fd32f66789288,0x0008863f96f8edfb,0x000e644e5dece22e,0x0009b7f857a4d564,0x0000000000000000}, {0x000691ddbeebfc5d,0x0005901566a70055,0x000e1f4e6067fa43,0x00086e62796a672c,0x000b4e5ee14cf308,0x000b327c1a40aaca,0x0002fed3294bd689,0x0009103e56992c00,0x000b1323df8494f5,0x000d7b51fec2bb9e,0x0000000000000001}},
    {{0x0009f1b91641749a,0x000415c17bca5ff6,0x000c6d3a845d2248,0x0005f9b6f404856a,0x000cbf400b63630d,0x0003b4ba273b60be,0x0005d238fa843e67,0x00015df9fe916d32,0x000747b338f22dd6,0x000213df0dde0478,0x0000000000000000}, {0x0000235c1fe8e923,0x0003196a6c0855b8,0x0009e7caa33347ee,0x000bc0a45596b47b,0x00011e3fa8377c58,0x000acaedbc6f8b16,0x000fc365c99edd72,0x0002dbbec0f6e0a6,0x0002b70a4b7723c1,0x000a4bf65f3c20c8,0x0000000000000001}},
    {{0x0004bf14c1a4d603,0x00062d773ba946d2,0x000a858973ed2e17,0x000af47e821e4637,0x000c4e2f1b685a3b,0x000a24d7fe743f00,0x00011c916f0b3711,0x00019d3f29631796,0x000070eeb3ea27a8,0x000fcf9d0e9d8d24,0x0000000000000001}, {0x000a9e0cc6d6de0a,0x0007d8c5fca34ad4,0x000c81d46494c7d6,0x0008c618856d1751,0x000ea22fc514e835,0x000e085f741c8235,0x000c321d004a049d,0x000bcb516087e553,0x0002d6363ccbbe68,0x00083e572fe7f6b5,0x0000000000000000}},
    {{0x000e20ba96faf5c5,0x000e8d8c8a0cc4ab,0x0009b5c593a344d4,0x000c6c34af049395,0x0005aa8d456d94a3,0x000ed953bf7c9473,0x000962cd0b8cc1dd,0x0000c01bb3088b5c,0x000c82c42c7d7139,0x0005bd26c576d9ee,0x0000000000000001}, {0x000ee2f364e79144,0x000e681f5a9a561f,0x00014c6812d4021d,0x000e552f50051d32,0x000f6a99f35033a6,0x000e505a2349153d,0x0001622a1be8e97e,0x00067971f625164b,0x000d441d9fc2328e,0x000d2eb0550478b4,0x0000000000000001}},
    {{0x000769c73aea3c08,0x000df9a9593240cb,0x0004e8217f3b057c,0x000ceca2220054ab,0x000c95ba1c2a734d,0x0006500d1322b719,0x000ec571b4360381,0x0006f76e87cb0ba1,0x000c5938559db2c7,0x000397be033b5877,0x0000000000000000}, {0x000b6a77feb075ca,0x000d9cc6a6cde3dd,0x000e49872538f578,0x000e469feaf37819,0x0002ddc9c48cda10,0x0001a6e5450f9883,0x0002d31bf05ea5f5,0x000375cd216a195d,0x0008007e689987c4,0x000cbc358f3e07d1,0x0000000000000000}},
},
{   /* digit=124 [{1,2,3,..,}]*([2^496]*G)  */
    {{0x0006a73f6f2770c4,0x0000f968ca281cd6,0x000827efca6a0867,0x0003a96b180e8f32,0x000809979b757eac,0x000d9223bfbff7df,0x00047dd166015fc2,0x00065475a88730d7,0x000ce16229ea9d12,0x00076d23756de3fb,0x0000000000000000}, {0x000ed537bee27c6e,0x000943e46c7c15a8,0x0004b3f87656d7df,0x000a9213335be530,0x00076cb0ee208db8,0x0004f5fc16b61ee3,0x000c1114ee85495a,0x000253ced62c2d47,0x000641c92453ad35,0x0003e4e1a21d73af,0x0000000000000001}},
    {{0x000483ff2c9de102,0x00017f0cb9492bab,0x0001999673c19107,0x0005c7a75ba40ad7,0x00022ec8c1ec861f,0x00078704457a9540,0x0001194ab6d023c8,0x0000daf5008c607c,0x000d394925361233,0x0005ab5bf20a934a,0x0000000000000001}, {0x0008ed3301b16277,0x000b31045574d7ab,0x000ed11cb44f38e3,0x0001af67ab10bb4e,0x000d033cee10ca51,0x000549874c9fe7c1,0x000392d6999489f1,0x000ffcfe4a15a85b,0x000b006a13684dec,0x0007b8baefda3eb3,0x0000000000000001}},
    {{0x000e82cbfe7306a8,0x00002e52832eb494,0x000b381c8b461b41,0x000a6e877f0afbca,0x0006b8482ae88f1b,0x000709eb28c8cc07,0x0000cd45fc8e5ced,0x000b1363d1cf0c64,0x00093a63d6be8f78,0x0001407a8e7f6a49,0x0000000000000000}, {0x000fd703c088bf64,0x000708b3415df01b,0x000f82eeb2c8b57f,0x0003ed35407aa69d,0x000449767c6b4a72,0x0002e1a8184dbc3f,0x000d25edffc3e965,0x0003e8855e29ad89,0x000c695a889f2e49,0x00025dae2a995ab2,0x0000000000000000}},
    {{0x000c300d63dacf22,0x000f84149cc93249,0x0004f71e87a984e1,0x000ebeada635f884,0x000cac51f48942eb,0x00076c6b878d815d,0x000587460dede95b,0x000883c91cf8c3f2,0x00013e9be5375387,0x00076d4ce987a56d,0x0000000000000000}, {0x000fb20151675f42,0x000bf54bf1c2d622,0x00022da7f9e8bc4a,0x000051b0e7b83f3a,0x00073eda536a6e42,0x000ce8431a9d89d5,0x0002b7a64d23c5a3,0x000007a6be7b3eec,0x000672919b5fb43a,0x000c454a7d18005b,0x0000000000000001}},
    {{0x0009f484a29e97a0,0x0005e90aa411ba92,0x00016fc135a72a99,0x0006cfa3c8dd8a3a,0x00066efeed6df222,0x000e66eb40ebb1a2,0x0000f8ad15ad7b0b,0x000e0c3a19929e39,0x00051e3404d13a05,0x000175cf393bacd1,0x0000000000000000}, {0x0006cdbeb4d89814,0x000b884f6ce10295,0x0003138d1321a20d,0x0006528c4bd065b9,0x0003d082878ee395,0x00029465651ab383,0x000cb4e49e6b0dcc,0x000710248d30e955,0x0006e01a51ae9cc3,0x0002fc5567eab89e,0x0000000000000001}},
    {{0x000c59218072f54a,0x000195bad5f014fe,0x000deabd55429cb3,0x000b2ab5fb9c1406,0x0006cf39524ff8ca,0x000fbb57c01480bd,0x00018cbc932f5376,0x000c9e4e5da034f1,0x000fb16c36eb8d83,0x000048c80fc4eaa6,0x0000000000000000}, {0x000668aa11e1cfe6,0x000d4f614afa98be,0x0004cadab479a412,0x000864b0b94d7822,0x0002651053a74933,0x000dd43fe6424e5f,0x0004f2c600bdaac3,0x000ec0b432ccf8a0,0x0004d82574257110,0x00024e58edc3e12f,0x0000000000000001}},
    {{0x000d5163c2f29845,0x000271b8856ff717,0x000a79d0557c5c08,0x0001484032810d21,0x000a5a6e95174165,0x00093b8782ce8f06,0x000a6f7f14b15d03,0x000ca398eeacdf3d,0x000eb31c7c040c1a,0x0003ace9ed34f4d2,0x0000000000000000}, {0x00086bac2cc4ff50,0x0008d5294f7bd063,0x000ec0b7a55f986d,0x0006868155592285,0x000e215833824965,0x0003366d9a307162,0x0001de9196efa150,0x00076afbb75f7833,0x00046ce65ce11aa8,0x0002f7a207e31942,0x0000000000000001}},
    {{0x000d6129f7d0fa54,0x000150bddf5a7cf8,0x000b4988625b2f43,0x0009bbfb3c2f3809,0x000f5b080f7b3129,0x0000ab0abb84ed45,0x000510d824f7bed2,0x0006d6447243533e,0x000c576b7b64fbbb,0x000e16caa9ee8267,0x0000000000000001}, {0x00053a269ea0b07f,0x000e06f68fe62242,0x000a777b6874572d,0x000d5f86cf599bf5,0x000fe2a811045a16,0x000873264294a33d,0x0007a04ac970a0c0,0x000ceb2b7d05d686,0x00029a28a0e51a57,0x000bacbf79a38ead,0x0000000000000001}},
},
{   /* digit=125 [{1,2,3,..,}]*([2^500]*G)  */
    {{0x0003efe866dc2f62,0x000853cb9e407c10,0x0000e6c71edaaa13,0x00018f751b70a2af,0x000b0cf7e3e825ae,0x0005c36a5a1ec11b,0x000487f56ab4b564,0x000a86df052ea4e5,0x000d750313868ef9,0x000e60ee422740c7,0x0000000000000000}, {0x000ee652bd47edd5,0x000397faa97f40b7,0x000294d2d1ba3dd7,0x000344d3453daecf,0x000d324bd3f56e65,0x00078c6f611c9985,0x000e24f2675985ec,0x00038b4060d38ad7,0x000dfb7496c92821,0x000be627a6ad57ff,0x0000000000000001}},
    {{0x0009be6a7e5a166a,0x000d06313031bd58,0x000704962d984289,0x0002ec5b522512df,0x000386a669eef493,0x000fe747674db075,0x0004dbaabd7aebbc,0x0004d27fb22ce794,0x000e70494458ef81,0x000fadc96805636a,0x0000000000000000}, {0x0005b60c511b3ff8,0x000584915adb1e6c,0x000f8937e8e108c6,0x0008406d64ea3a9f,0x0004461d268f9ab8,0x000e3ff279d6126f,0x000d3b3ed1f3032a,0x00023a1b63af22a5,0x000caf9282fd7a53,0x000d99f7a42a7590,0x0000000000000001}},
    {{0x000dfb005014a6bc,0x000d36179f05f79f,0x0001f0a00c591c70,0x00009f861bdb8aa0,0x000851877e4cc13b,0x00004921bdab098b,0x000265f47ca34718,0x000478a5d59cb874,0x0008aac74eb734d8,0x0002f6a87e5bc7bb,0x0000000000000001}, {0x0005dd559082ec4f,0x000fd3340b409a63,0x000e395e6174cff9,0x00035fdf83237476,0x0006e995df5d90e4,0x000535beb0acf902,0x000ddc2f60fe3f20,0x000821d68a60c3ba,0x0008005435d079f0,0x00084ef7a20c388b,0x0000000000000000}},
    {{0x0001ce9624902c85,0x000dacee54d7fc06,0x0008e982883e676d,0x000cea68fc5997cf,0x000b94f3d06f1e8c,0x0007b80d8242831b,0x000ec2e625c36045,0x00015466a1d87389,0x000c5009313ff25b,0x00045efb5d45d1f9,0x0000000000000001}, {0x0004e32c6f246301,0x00064608ec78b5ab,0x00053a9c0b324014,0x0004ddead5ffb795,0x0008bf933bdcc559,0x0005249289dc110f,0x00047d25d52f652d,0x000d95ab06c0cb41,0x000bbff17968adb2,0x0002664039be6fa1,0x0000000000000000}},
    {{0x0006c159dee64527,0x000d486c1da85118,0x0002ffecac887f87,0x000401c5326e8ac4,0x000fe68a082d270a,0x000b17b4ec0bd703,0x0009b1a9fe82427b,0x0008f75c6b25d502,0x000ac56e28859df5,0x000bc70f97f9bffa,0x0000000000000001}, {0x00073b932e4e3e21,0x0005f8e721dc13af,0x000825bde1498f11,0x00080fd3102f60c7,0x000f292e5a9e9f07,0x0006a4edbc9fcac3,0x0008f2651ae44279,0x0002622ca1bb123f,0x000a4ca103d2d6a7,0x000ca577d0f1994f,0x0000000000000000}},
    {{0x000e577af10e1302,0x000156bf557eaa33,0x000ca7cba0f98005,0x0001e9d6e3d41486,0x000ad3a30b9f973d,0x0009856b55aa3443,0x000724f819219409,0x0008250cf13f0ca4,0x0006f0f69ba1696b,0x00063bba1deb1e9b,0x0000000000000001}, {0x00037cb6672f9435,0x000d7e7437eb08a0,0x000579149c6faf55,0x000e4c6943f7c61c,0x00026eba03e36921,0x000a3ade34c342ab,0x000052386264eb60,0x0000ffc57653cf12,0x00070eec7914e6e2,0x0004912d67845657,0x0000000000000001}},
    {{0x00006fc3e072e1bd,0x00066e9739a62b31,0x0006ea97e6ad1669,0x0002aa2bbc843284,0x000871768bc4f0fb,0x000a51f2d1bd1f5f,0x000245a8890f99b0,0x000b6a0000aa5f53,0x000547c1538e0dc0,0x0001c33dbece2149,0x0000000000000000}, {0x000b56de17b97c51,0x0000fccb15a8e3ea,0x000c00352a78e0ff,0x000e7d480dae3bf3,0x00092273cee30716,0x0000962a4283dde8,0x000e674e18ae53b0,0x0002b8c78835cb2c,0x000faee271217641,0x00046294e0f5e7c6,0x0000000000000000}},
    {{0x0005697612d854d6,0x000590266d871a78,0x000015aa94be7df9,0x000482ac4e8bbf72,0x0007c12880439150,0x0003495f23aa4b2f,0x00074815ef777bb5,0x000838a798c004a6,0x0008a425cc7aadc8,0x000c432ccb5f5730,0x0000000000000001}, {0x00006af85640f288,0x0003a6718ebc6cb5,0x0002c50bba9dd21e,0x000e3c4d56098fde,0x000a4a8a721857b6,0x000218f9c402f4d7,0x000a6f255530e5d9,0x0000bf7b3c63a541,0x000f0181b97421bb,0x00023de7a08f2804,0x0000000000000000}},
},
{   /* digit=126 [{1,2,3,..,}]*([2^504]*G)  */
    {{0x00061ebad9ee2c24,0x000dd46aced3ddaa,0x0000bd3e3fde5fe2,0x00020569fe14f9f4,0x00088d818d1a2095,0x0002f0bdc9b4968b,0x000e3de0b8b77328,0x0007fe9e8edc6520,0x000017cf0272ff76,0x000eda0f65dc99bc,0x0000000000000000}, {0x0009b50b03dc034f,0x000ff04ea634ab0a,0x0007b191db6e6308,0x000a9de7ee04399a,0x000e6da7bdea8dde,0x00054c55ae492d45,0x000f4e939e666b7b,0x00090c925a51f573,0x000f916220292c15,0x0002d380fc7f5071,0x0000000000000001}},
    {{0x000639a92b83d191,0x000b3a1ce7b1b453,0x0000d260e431474f,0x00032954aefab808,0x0006dfaf9e670c4e,0x000e42d0d7b5bae7,0x000bfa89eb4687fd,0x000c7d89b1ca5f45,0x000ecce4fba638bb,0x0008a21de873fcc0,0x0000000000000001}, {0x000c9c2b49165fd5,0x0005fb318f9f9636,0x0006f676d6c2cb81,0x000c633a7560919e,0x00011e2d4752541c,0x000199c5999a79e2,0x000515dfbee081ee,0x00053107dec5265f,0x0002bdc9ed0ea4e2,0x00041c5a539ab36f,0x0000000000000001}},
    {{0x00009de7ecb2ac56,0x0002d837bb7a345c,0x0004863cfd4369c7,0x00077c66a5755a3b,0x000682ccc872cef3,0x000bc1363c743442,0x0008b997f1a0d907,0x000d72224eed734a,0x000d1850457f924f,0x000f3bbd996258f2,0x0000000000000001}, {0x0004953714391350,0x0002a08de1fb04ea,0x0009bb0ca7d3f0e3,0x00020e2fc4a54760,0x000d525812eece55,0x000dc3c7c680f4ea,0x00064f097079b269,0x0001e81a267b891a,0x0002df53061afa20,0x0007339d7335dbc1,0x0000000000000000}},
    {{0x000fa11c22d57017,0x0007061bfc65866f,0x000e25c9a781f882,0x00052d54eb5d1a25,0x00034e5fcb1fe128,0x0008c5dfb74f3317,0x000cca2e48b7e54d,0x0005e9b41639cfad,0x000e1f8c2193402d,0x000348c49e8f71b8,0x0000000000000001}, {0x00033ca43943f50d,0x00016ce98a1f644e,0x000bd595ac8a7cb4,0x000d4eb1e328cd45,0x000e8ec3fd8cbf8f,0x000eb626b0f768cf,0x0001524476b1bbc9,0x000d8d0ffe31069d,0x00025aa89220edd8,0x00063660b3755829,0x0000000000000000}},
    {{0x0003a78191abe914,0x000aed083110e37c,0x00072de9a657b228,0x0003d434d0dfafec,0x0009778c8ba568ce,0x00021f193e09ab8a,0x00032b59891165df,0x00090a0e20c8f7ac,0x0005b8a1f64088c4,0x000b717ed2f2d69f,0x0000000000000001}, {0x000ac4849a39a0ab,0x000e9224368b5d72,0x0009a57abd9c0589,0x000f04bfeb21218d,0x00049bfe57f2080a,0x00082fbca66b72d8,0x000f0c09eaa93852,0x000e04db305e15a6,0x000bb2bcc4365052,0x000d0e18047907b5,0x0000000000000000}},
    {{0x0003c1031f4f778c,0x0009bbc5cc621ce8,0x000ac957c67434bc,0x000a368627bcbc47,0x000adace0a905430,0x0008aa0831ed2cb5,0x000c11d0f4f5d323,0x0001c48e91c91fa3,0x000229765edbfb35,0x00032bdf2591e498,0x0000000000000000}, {0x0008e455572bcfd0,0x000ecba53bea9ae3,0x000196518c997db1,0x0005c33258970b56,0x000a3c6b46d1e689,0x0008e44ad30fe772,0x0005dd6482160561,0x000b86d1933faf1a,0x0005a53d718ae6de,0x000e4e4345a6badf,0x0000000000000001}},
    {{0x0009f15950170034,0x0008a7d9e0681bfb,0x0002dc602830c283,0x000e8af178838dfd,0x000987d3f8bcc134,0x0008904081cb94f3,0x000a460c0da2bca6,0x000f718b8913d63c,0x00022ed274e647de,0x000ff3a58fd52338,0x0000000000000001}, {0x0002950ff4836dad,0x000fe4a51fa111b5,0x000e13de206b61a9,0x000941373ab42508,0x000c7bf8c1651d7a,0x000dbd9276666a02,0x00056dcdd411c37b,0x000f5a9ab3e87536,0x0000f464671775e6,0x000bc59bc827eaae,0x0000000000000000}},
    {{0x000eafce57fbc903,0x00072ba11885f40d,0x000d640aa98f9421,0x000bfcf817ce6b52,0x000389d8e40bcdc1,0x000c804e7d14a7d6,0x0008fa880e955163,0x00034af7c92b6304,0x000fd685115381b0,0x000faf73ec6a9688,0x0000000000000001}, {0x000f85d1af3848b2,0x0008716ba36666f4,0x000fbfc6c17f47de,0x00003b35f9474540,0x0004b72b1ddc670e,0x000f48bdd3ad6387,0x000d7cfd249ea687,0x0009c16141926a15,0x000d8d963e9d101f,0x0000771b9b1c2fac,0x0000000000000000}},
},
{   /* digit=127 [{1,2,3,..,}]*([2^508]*G)  */
    {{0x0006bccc65f30461,0x0006e44b51d15f3b,0x00061b0ed084d989,0x000f84c9df4f3be0,0x000626ed8e29bced,0x000a49395cf45bde,0x0001bfb128499bea,0x000d30e7b9a9812a,0x0000016d9442e44b,0x000577251b4710e5,0x0000000000000000}, {0x000c58ea8faa5f8e,0x0006398972e1afb4,0x0002d603c3a6a3b7,0x000090f464b41953,0x0003e1c1cc6d5ad6,0x0009fc4551644bda,0x0003bf0e003b3c67,0x0004879a2d4dc4fe,0x0002492059f3993d,0x00089490933a0bd0,0x0000000000000000}},
    {{0x0003d39ba21abe88,0x000b8dfe497366b8,0x0003fb2e32d1a08b,0x00040dcc68fadea4,0x0009bc78d9e5b900,0x000999242f620135,0x000e38d4ca94e098,0x000f3e9a937783f1,0x000c271edf5e42de,0x000cdad3d42e09c5,0x0000000000000001}, {0x00014caf1b7e4897,0x00092052b710207f,0x000840b578b42fb2,0x000c859d4e0acb78,0x000efbd1059c69f5,0x000fc0d187f5ce1f,0x000018dd99b98e1d,0x000fd9d695b6b702,0x00087f7037056ff1,0x00080b73121d9b11,0x0000000000000000}},
    {{0x00078d674ce9ba28,0x00098667edd1931d,0x0007a2c798ce814e,0x00054444ef1eef63,0x000bbc4342cdf2cd,0x0008690dad1f9bf2,0x000e17a85c72b72f,0x00027215c615b685,0x000ab98eb37dbb69,0x00072850ebda62ab,0x0000000000000000}, {0x000b543dc482d1d8,0x00066dc72bee2f05,0x000576c719cbc26f,0x000bf9361970fe88,0x00012aede3868858,0x000d0a81339054e9,0x00050f3227db12ff,0x00054f85925da234,0x0007c4995e06e9ee,0x000343899d0c96c8,0x0000000000000001}},
    {{0x000622bfd7a6e63b,0x000ca212bebe9c89,0x000487abee2cafd2,0x000143f4d290457b,0x0007d05d13bf4c04,0x00067f0ae3716aab,0x000a3097740d4130,0x000debe6d02d5925,0x000ef2c2714370b8,0x000fcffae20be9e8,0x0000000000000001}, {0x00009dc727eac0b8,0x000802b463618a8d,0x000e00f824949d83,0x00021e8850666aae,0x000a354be3730d5a,0x0006ce164b258522,0x000386cbf3fd223a,0x0000b7ba5ba4fefa,0x0008ecff5479bc6a,0x000ec6ece410bb37,0x0000000000000001}},
    {{0x000fb0fd2b03ceeb,0x000c34d346742d91,0x0007fb1da808f925,0x00014c3e50e576d5,0x00045dde45aec274,0x0007634b06ff5225,0x000e8f635cfee4ae,0x0006af16b33722c1,0x000b6c9512df9861,0x00087905f5ba1ed3,0x0000000000000001}, {0x0006849e44fd7308,0x000ca8c188190c88,0x000568eece8b82ee,0x000afcede37dce03,0x000956f0105616d6,0x000fcd4f42159b96,0x00016a63204d42e3,0x000f90e66b95446b,0x0003ff7137d7895f,0x00015f08ed8c3b6a,0x0000000000000000}},
    {{0x000080c877cdc551,0x00063fd88170e394,0x000069a5394fa226,0x000fe13aafd4abd3,0x000aac77685a1a56,0x0002270caf504acd,0x000b15ab3b28bcb6,0x000ff30df2535d28,0x000dad1836a25af3,0x000fa6c25940501a,0x0000000000000001}, {0x00072e0f5dfd0431,0x000680aa3b20ecdb,0x000be825e1b5fe43,0x0005a5c2422130db,0x000f0dc02a5e8b8e,0x00053d6d0a6ed0ac,0x0007b39bd52bad22,0x000defc7beec9197,0x000d80e249e46059,0x0009869fd32b5153,0x0000000000000000}},
    {{0x000d5488a9c159ea,0x000c7c99f362daa9,0x000520e4056562a1,0x000f58587c3780d4,0x000cf122d12decdc,0x00066fa3df2e094a,0x0006c99c7f2dc2a5,0x0005a3f3e1f8fe88,0x000ead106c542a2f,0x0001bd548c70f9bd,0x0000000000000000}, {0x00025e9e39905a6d,0x000d9b4651431540,0x0007d3343ac64109,0x00071e3dd6b3d33e,0x000a550593155d88,0x0005e988444776c0,0x00092c204b5ef211,0x000132ec6af46f8f,0x0000975bc42ba82e,0x0000ec605e3e60a7,0x0000000000000000}},
    {{0x000ebdae497fc314,0x000068fcc42342b8,0x0002e8a76fa0addd,0x000d98aa1ba58a99,0x0006f585d2056972,0x0001a667125a290a,0x000e664a47990be5,0x0003e44696beab19,0x0000ab4a22f64d1c,0x00054a0b8ce48449,0x0000000000000000}, {0x000cf9a538895145,0x000e7e3b3fd1990a,0x0001c1f1592daaaf,0x000016843015bdb3,0x00095b2dbb2d0adb,0x000f77ef5d670d12,0x0008bf1b3f98aca3,0x0003b5280fd35140,0x0007a58660b5ee9d,0x000f86e58791223a,0x0000000000000000}},
},
{   /* digit=128 [{1,2,3,..,}]*([2^512]*G)  */
    {{0x00031c51f5b59b03,0x000c7665ab584951,0x0008739b754d5115,0x000b253e840523eb,0x000078a1f77e3b96,0x000742a046765d97,0x000823d7e942e5b8,0x00080b3194bd1539,0x0002679bf560b997,0x00061abda6ff32b5,0x0000000000000001}, {0x000820e93e66dad8,0x000f2c881e08a892,0x0007e5fd839208f9,0x000d25804e86968c,0x000fc76aeb554305,0x0004c686c9b44037,0x0002e51b80d02e02,0x000e5774d5a620e6,0x000000eae653df90,0x00072ac9b31961f0,0x0000000000000000}},
    {{0x000f8d7860917b4f,0x000bb3357359429f,0x000995f4b0a05d76,0x000e0f1c58d0fe01,0x0002921dccd2ee40,0x0000ab0ca33af9c6,0x000637c074069c34,0x0002098a102fa30b,0x00037701844888bc,0x000d6cb2e96e33de,0x0000000000000000}, {0x00070d506a96d190,0x000f2ce57ed3ba0f,0x0002492cf26e59c4,0x000305995879a0eb,0x0000675760ae93d1,0x0009f9d0d04103b2,0x000d618a2b740898,0x000e723e7b444b0a,0x000b80451ab5c813,0x000616305a1f27eb,0x0000000000000000}},
    {{0x000b480b60680f46,0x00097a71a65ccb4a,0x0002360920f061e1,0x000428aeb306dab3,0x0005aee5267509d9,0x00058e47b1cbaf9d,0x0003350d9a6f7e9f,0x00035af36c30696a,0x000ff438c1f66ddb,0x000119d4937e17ea,0x0000000000000000}, {0x0009df61e7821be6,0x000b8322655044ac,0x0001ae7bb1e106e2,0x00039508343bc8e6,0x000a2bc1e06e0991,0x00066bd6b8166453,0x00044e23756d0eb9,0x00003795c5a1b4bb,0x000605deb625fe17,0x000248426f42f1b7,0x0000000000000000}},
    {{0x000ebb49b8b6d8d8,0x000c9576edd0b2c0,0x000089746d87ef78,0x000ee54686ff89a1,0x000cd51992a8e30d,0x000fcb70ff8362ad,0x00008d8883f2631a,0x0002a13e25b5a551,0x000d32baa9313847,0x00049764387fbe1f,0x0000000000000000}, {0x000652373d0f2fcd,0x0007e9e1299928e8,0x00016c54d21ce8fd,0x000e62d7938b0123,0x000ce4d602bacad0,0x00055138cbf9df41,0x000e0e625dfe098c,0x000dbf9a6851bc01,0x0000b0da12bdbc63,0x000aec8b07cebaa7,0x0000000000000000}},
    {{0x0006a52b356ba3e0,0x000fa486ee1abbf6,0x00074bf145f1f28e,0x000ef4af39b6c538,0x00084376c3d3f698,0x00007cbe4b46d363,0x0003db26e35a57f0,0x000ecc45a1933b62,0x0007b9610a9a44f8,0x000057b84f95bccb,0x0000000000000001}, {0x000bdacb48b9bb6b,0x000642a5eb931fe7,0x00097c327f5fbd2e,0x000a3062ea3deca5,0x000a3dad9ef787fc,0x00092f83b35a8216,0x00042427945728d9,0x0007537c6394f3cf,0x000b615698a93762,0x0001f468793ceb99,0x0000000000000000}},
    {{0x000217c6562eea14,0x000a6a042cb3da1e,0x00060f9ac91e9595,0x00013fef00e33063,0x0001954b4b6c8a05,0x00007e6bb37592ca,0x00018fef0e569527,0x000f4449441c7534,0x0003c8e93a050abd,0x00050bb02598e0eb,0x0000000000000000}, {0x00044683d956af18,0x000340076bbbf06c,0x00006b8e5826911d,0x000bd47b4442693c,0x000bdbfb4883b7be,0x000a67f8d229f111,0x000eceec785481be,0x000d18ec8ccc0a58,0x000ed2b1cc9fd671,0x000ee9b77fbdfe40,0x0000000000000000}},
    {{0x00033f2848525772,0x0002def8aeb9f6cd,0x0009c738e373fa1e,0x000ca3f54bf1bb33,0x0000dd3b12e5c621,0x000856fbe6604112,0x0004fa2d98399489,0x0000ba4686140d31,0x000be8a65034e7d6,0x000fc1d2c9034f2b,0x0000000000000000}, {0x0002e0e02cbac5de,0x00036d1bbef4bfe6,0x000db812e9ceffa7,0x000c4f097569d138,0x000c2795f975ff41,0x000cfa1a794c9978,0x000e1e65c9b377a9,0x000e6d66f7a547fd,0x00058785dc7270ac,0x000b34d6e188dec1,0x0000000000000000}},
    {{0x000a511d09de2eac,0x000031698e16faac,0x0002e96a74ccb4d0,0x000b85017b609854,0x0005887d91373679,0x00039fd4a56f39c3,0x000f60f3aea2bb2a,0x00084e8edd3fc7ee,0x000e1d001d481288,0x0003732f4d1fa989,0x0000000000000001}, {0x000629c27855b7b6,0x000652d6fdccbf0a,0x0005f32800f6bc14,0x0007f62ad29c1358,0x000dbf3a9fdce69e,0x000aa9f4b69418d0,0x000e5fef492796fd,0x000332f4a27a525a,0x0001a7293d91d135,0x0006fadc6b1bb1cc,0x0000000000000001}},
},
{   /* digit=129 [{1,2,3,..,}]*([2^516]*G)  */
    {{0x00076fe9e4b410aa,0x0002e2e46e8257e7,0x000285dece1c90ea,0x0004f07e02e70a0d,0x0007d9e22652fd2e,0x000325ca4b7fb066,0x0001305e36daaa95,0x000feebe9d3d04df,0x0000e3be0fcd0755,0x0005f74f74e60357,0x0000000000000001}, {0x000a7ff33f158714,0x00012737b93b28b8,0x000a408dc4f02791,0x0009c78d219fcf52,0x0008fbf0f03e3758,0x000d6cdb0c0bb10f,0x0007428d517b4d78,0x000d37e06b1f9904,0x000f8786ba69f3ae,0x000b508624d39698,0x0000000000000000}},
    {{0x000314e66fead340,0x0009f5c35e0de977,0x00086281b424220d,0x00095c9d69b8f421,0x000075fd90a74e5f,0x000c09fc499a89c7,0x0004b64e12f34808,0x00068c161166a676,0x000f40cf1886f3c3,0x000c4968ad8aaa55,0x0000000000000000}, {0x0001f4bec36790bc,0x000d77489002d4f9,0x0001759ca38e8177,0x000e759ae14e5a1f,0x000289005868dab2,0x000a1dff8ca02b41,0x000a4d82b9cd06ea,0x0004578741ea12d6,0x000343e8d641aef6,0x0002d4c6a85c8b1a,0x0000000000000001}},
    {{0x0007c33639a0b3f1,0x000010f791b828fa,0x00069b98b785836e,0x000f9367ba2d3b6c,0x0005ecea4290d504,0x0003dd0621586083,0x000de6622ac6245f,0x0002d8153e71208b,0x00091cd77d2a1a55,0x0007ebc7df7c52cd,0x0000000000000001}, {0x000fe4e1268ac84e,0x000d05fdf620f30b,0x00078c9c26de9aa6,0x000fef3a7d0e875e,0x0001f45acf57d581,0x0009769d1b4f2f3f,0x000f8a2b516d4fb8,0x000ca50e2afa7161,0x00069ea98a831731,0x000a4069e2a679a5,0x0000000000000001}},
    {{0x000573b5ab69b37b,0x00099e464e098a37,0x0004b6ae9bd2eac1,0x0007e83941109e44,0x000b3638c710996c,0x0005b0374099e6be,0x000e0cd0943a1c3a,0x0008fab6ecb18490,0x0009f0eb14e71bae,0x00011229f06246b6,0x0000000000000001}, {0x0006e2d865b8fa8c,0x000e4ba2a3d8ca53,0x0004c428120f4f50,0x00003e5bcb6eaa4c,0x0006c69871129b42,0x00018bdacf6da13d,0x0006a314f621f852,0x00031ea900e85204,0x000d280193a13fa0,0x000437167b70a8c7,0x0000000000000001}},
    {{0x000e47d41aa029d1,0x00083c1c1e4e8c82,0x000819d110bf6923,0x00080e340caaa47b,0x000e4f6e315e8cb2,0x000865960449f5a7,0x0002a736db3e3bf6,0x0008b38233a8c18d,0x0006ab95cab54c2d,0x0007b4670af6e721,0x0000000000000000}, {0x0009cd8d15df2f21,0x000c9e95f873ccf7,0x000d4ae259b8946e,0x0003026a352c8cec,0x000c84b6773b4638,0x000327edc3574f14,0x000980243f9e1167,0x000c58a2e8d3fc2d,0x000e789b426360b9,0x00084beac487c72a,0x0000000000000001}},
    {{0x000a504d7a128f19,0x000bec706161d077,0x0008d3f449e0d717,0x00027553cd6aa437,0x00023bfa097584c3,0x00031032e9ecfed0,0x000de734abfe6661,0x0005972524c62301,0x00068a20ad67cd7b,0x0001d7d8e4bd981b,0x0000000000000001}, {0x000dd411d75c8560,0x00020a136bd0f9a0,0x000e9c06f6a8521a,0x0001770134117a07,0x000c6625cc2c0b14,0x0006f01c93534fec,0x000bcd3698e9742e,0x000543a9724acea5,0x000820ced54b554d,0x00005a7954cbcc77,0x0000000000000001}},
    {{0x00060a7aed1a8afb,0x00037a6526a7b404,0x000f752335e80ab0,0x000a8f65f14c43bd,0x0004f9b989eabd11,0x000976a80f23fa92,0x0000171f16dad870,0x000d3baaac454e44,0x000f34704b9635c0,0x00051b0e1ca863f0,0x0000000000000000}, {0x000fcc07647c957a,0x0007e8420a4e5f40,0x000cec847e324cf5,0x000db2fe1f189869,0x0009827f88deeb20,0x00023c17a4487124,0x0009568284e63444,0x000010b9bfa3fe02,0x000626ee2d426c18,0x0006c496cbf2d807,0x0000000000000001}},
    {{0x000a48e1016cc257,0x000e7a08472093bf,0x000b7492e4ec8ac9,0x0001bd1c471d73ed,0x000a7243428ce53d,0x0007d49d1740adec,0x000c66dd60077c0b,0x0005737593cb7a95,0x0007c6f6ef237e1e,0x000660a7929ff06a,0x0000000000000001}, {0x0004bcc2e6c3da59,0x0003e87b3c416f89,0x00021231992a493d,0x0006d0824c0a5993,0x000e60d5c6c61f37,0x000a3430f29e1550,0x0005e81f1d1beb92,0x00027b6bc5ab11f9,0x000858c60a78bae0,0x000f95bdd9ea9017,0x0000000000000001}},
},
{   /* digit=130 [{1,2,3,..,}]*([2^520]*G)  */
    {{0x0008b69f6c0a103c,0x00014cb96747cd0b,0x0009e707ed23f30c,0x00092336029690c8,0x0002b884265ced12,0x00087e627555cfec,0x0008f62a097ab7dc,0x000df635118ea555,0x00070b69e23dda1a,0x00011d1b70ffff57,0x0000000000000000}, {0x0002606bce985157,0x000cf38c9c6bbd4f,0x00058d1b308ccb92,0x000fb6fe2ce6913c,0x0005b1967bfefbbd,0x00053132fce5cb51,0x000b2f22527584e4,0x00082a1591dfc389,0x0002d57610460d61,0x000dc57498b0d160,0x0000000000000000}},
    {{0x0008cffee5938175,0x000028a135a61fb3,0x0002c9fe1a18ac17,0x000b968e30418249,0x0000b4c958b813ec,0x00023285e86f834a,0x000b05e54df836f5,0x0008f77b5fb229e4,0x000371505e864d89,0x000fb3cce3c32e48,0x0000000000000000}, {0x000a0e5e3ce8bcd8,0x000dc2fb74fd48c4,0x000875aaa2018996,0x000827185e9f86f5,0x000196642422b5eb,0x0006d6f0dd874310,0x000f5719d7e7982d,0x0005346044e6cb46,0x00002d250a348c67,0x0009ec517508afdc,0x0000000000000001}},
    {{0x000145140a7a865f,0x000095ded9f8c118,0x00040df2b19ba498,0x0007dec03834dace,0x0009e3687e664a0c,0x0009d971f2feee9a,0x0008796a032ee720,0x0003a0b2cc310714,0x000067d48b65bcec,0x0007f5d8c2af6546,0x0000000000000001}, {0x00015c856b094864,0x0004f779c821c5d7,0x00062cf6310bebe0,0x00086c833844c220,0x000322644f899899,0x00080ac439439357,0x0009f2dfd741ec2f,0x000c3022b589299a,0x000663af1bcf4790,0x000a46767587f6f5,0x0000000000000001}},
    {{0x000cdfa0667f8929,0x00055eda7b7826f1,0x000dd93845997fea,0x00073f54c39699cc,0x000d85971fbd417d,0x000631f8049f08e1,0x0003b8e65a870ee3,0x000aa3cdc8e351a7,0x00099901454f69b2,0x0002d659cbe0fe85,0x0000000000000001}, {0x0005bfaeb9c77879,0x00078817f6a7aa08,0x0001e5f6c61e07f9,0x000a5dffb271762a,0x000df5d3e3cd3cc6,0x000eadd52e895eb0,0x0003b342cd665b46,0x000393078c5b9252,0x0006202122ebcff3,0x0005f4777dd50c48,0x0000000000000000}},
    {{0x0003fcdbd57bfa90,0x000d1b118dee98fe,0x0000a524ceccfc4a,0x0007420c6d1ffa5c,0x00053919d859de0d,0x00081fb74544af55,0x0007c3f0981d6def,0x00076680c297a17a,0x000d22135e0cc4fe,0x000d15de36e57af6,0x0000000000000001}, {0x0008ae03fd78b0a1,0x000c06ac0c41950b,0x000c994e2c7c2638,0x00075a944523ebb6,0x0002bdb72a76549b,0x0007a73d0573310e,0x000ae4c8ce6d6b85,0x000e4309eb9e1e23,0x0008aedc0842f06a,0x0006ededf71264f9,0x0000000000000001}},
    {{0x00047c62f7f81bbb,0x000568d4c38f8cbe,0x000085a52c049173,0x000151d87d057b19,0x000462de5c929612,0x0004036de18a4ea9,0x000290b0a8300ddc,0x000e195518bc5a6e,0x000e21097894ed83,0x000a74d8dd898c35,0x0000000000000001}, {0x000eee2e29a47676,0x000325c0b89ddfd0,0x0000c5c995a8a7bf,0x0003e514a5131a24,0x00078e5998b6e957,0x000ba59336939798,0x00032157906f3c87,0x0001093cead5ff51,0x0003bc2e1b76588a,0x000a055abc03c824,0x0000000000000001}},
    {{0x000c9d2081074b7d,0x000b4b234d223107,0x000c6fe7d17524b8,0x000b3e26469a9182,0x0001d35461f18688,0x0008f9ef1eb0f49d,0x00072164bb2130a7,0x00069240661ee72b,0x0004674d4ec1e4e4,0x000df195346b1529,0x0000000000000001}, {0x00094d4cd2beae09,0x00021cf533e3fea5,0x00099051c26db75a,0x0000237aea1a808b,0x00066230cfcd19c1,0x0000aedfcfe63965,0x000965518cdd9349,0x0000446502d88c39,0x0006de0650de6be1,0x000c487b3640aa4a,0x0000000000000000}},
    {{0x000315f2c4f3b202,0x000844f2e07c55f6,0x0009040fc8f62ee6,0x0006bb02af168881,0x000eea1922677aec,0x0003b90132968e4d,0x000b75f92b21f9e5,0x000b4ae4c1d62b9c,0x0000f373265408d1,0x00013d70be8f94d2,0x0000000000000000}, {0x000c00995b2d1ac5,0x000acf4e16ae2b05,0x000d04ee882f20b5,0x000b5e061f8c5834,0x00040c9dbfe4135d,0x000f7b55b63a42f5,0x0003b47500e266e3,0x0004da6911e652ce,0x00043c4db0c53d0a,0x0009946052a6d7ee,0x0000000000000001}},
}
};
/* clang-format on */

#endif /* #if (_MBX>=_MBX_K1) */

#endif /* IFMA_ECPRECOMP4_P521_H */
