/*
        linuxinfo_riscv.c

	Copyright (C) 2022 Alan Beadle <ab.beadle@gmail.com>
	          (C) 2022 Helge Kreutzmann <debian@helgefjell.de>
	see git history for changes
        This is the RiscV port of linuxinfo
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "linuxinfo.h"

#ifdef system_riscv

void GetHardwareInfo(int fd, struct hw_stat *hw)
{
	int processors = 0;
	float bogomips = 0.0, tempbogo;
	char temp_string[BUFSIZ], temp_string2[BUFSIZ];
	char family[BUFSIZ]="Unknown";
	char clock[BUFSIZ]="Unknown";
	char *cval;

	while (read_line(fd, temp_string, BUFSIZ) != 0)
	{
		splitstring(temp_string, temp_string2);

		/* CPU count */
		if (strncmp(temp_string, "processor", strlen("processor")) == 0)
			processors++;

		/* clock if present */
                if (!(strncmp(temp_string, "freq", strlen("freq")))) {
			strcpy(clock, temp_string2);
                }
		/* cpu family */ /* Algorithm according to Alan Beadle */
		if (!(strncmp(temp_string, "uarch", strlen("uarch"))) || !(strncmp(temp_string, "model name", strlen("model name"))))
			strcpy(family, temp_string2);

	}

	sprintf(hw->hw_memory, LONGSPEC, getphysicalmemory());
	hw->hw_processors = processors;
	sprintf(hw->hw_cpuinfo, "%s", family);
	if (bogomips == 0.0)
	    sprintf(hw->hw_bogomips, "?");
	else
	    sprintf(hw->hw_bogomips, "%0.2f", bogomips);

	cval = strchr(clock, 'G');
	if  (!cval)
	{
		sprintf(hw->hw_megahertz, "%s", "? ");
	}
	else
	{
	    // *(cval-1) = '\0';
	    // printf("%s",clock);
	    sprintf(hw->hw_megahertz,"%.2f",atof(clock)*1000);
	}
}
#endif /* system_riscv */
