/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *                 Jehan <jehan@girinstud.io>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "nsSBCharSetProber.h"

/********* Language model for: French *********/

/**
 * Generated by BuildLangModel.py
 * On: 2016-05-04 10:50:59.881284
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static unsigned char Latin15CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  1, 17, 11, 10,  0, 18, 15, 19,  3, 24, 26,  7, 12,  4,  8, /* 4X */
   13, 20,  5,  2,  6,  9, 16, 29, 21, 22, 27,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  1, 17, 11, 10,  0, 18, 15, 19,  3, 24, 26,  7, 12,  4,  8, /* 6X */
   13, 20,  5,  2,  6,  9, 16, 29, 21, 22, 27,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM, 49,SYM, 49,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM, 53, 54,SYM,SYM, 55,SYM,SYM,SYM, 38, 38, 56,SYM, /* BX */
   25, 39, 33, 37, 46, 57, 51, 30, 23, 14, 28, 44, 47, 40, 32, 35, /* CX */
   58, 50, 52, 41, 31, 59, 42,SYM, 60, 36, 45, 34, 43, 61, 62, 48, /* DX */
   25, 39, 33, 37, 46, 63, 51, 30, 23, 14, 28, 44, 47, 40, 32, 35, /* EX */
   64, 50, 52, 41, 31, 65, 42,SYM, 66, 36, 45, 34, 43, 67, 68, 69, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static unsigned char Windows1252CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  1, 17, 11, 10,  0, 18, 15, 19,  3, 24, 26,  7, 12,  4,  8, /* 4X */
   13, 20,  5,  2,  6,  9, 16, 29, 21, 22, 27,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  1, 17, 11, 10,  0, 18, 15, 19,  3, 24, 26,  7, 12,  4,  8, /* 6X */
   13, 20,  5,  2,  6,  9, 16, 29, 21, 22, 27,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM,ILL,SYM, 70,SYM,SYM,SYM,SYM,SYM,SYM, 49,SYM, 38,ILL, 71,ILL, /* 8X */
  ILL,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 49,SYM, 38,ILL, 72, 73, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 74,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   25, 39, 33, 37, 46, 75, 51, 30, 23, 14, 28, 44, 47, 40, 32, 35, /* CX */
   76, 50, 52, 41, 31, 77, 42,SYM, 78, 36, 45, 34, 43, 79, 80, 48, /* DX */
   25, 39, 33, 37, 46, 81, 51, 30, 23, 14, 28, 44, 47, 40, 32, 35, /* EX */
   82, 50, 52, 41, 31, 83, 42,SYM, 84, 36, 45, 34, 43, 85, 86, 87, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static unsigned char Latin1CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  1, 17, 11, 10,  0, 18, 15, 19,  3, 24, 26,  7, 12,  4,  8, /* 4X */
   13, 20,  5,  2,  6,  9, 16, 29, 21, 22, 27,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  1, 17, 11, 10,  0, 18, 15, 19,  3, 24, 26,  7, 12,  4,  8, /* 6X */
   13, 20,  5,  2,  6,  9, 16, 29, 21, 22, 27,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 88,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   25, 39, 33, 37, 46, 89, 51, 30, 23, 14, 28, 44, 47, 40, 32, 35, /* CX */
   90, 50, 52, 41, 31, 91, 42,SYM, 92, 36, 45, 34, 43, 93, 94, 48, /* DX */
   25, 39, 33, 37, 46, 95, 51, 30, 23, 14, 28, 44, 47, 40, 32, 35, /* EX */
   96, 50, 52, 41, 31, 97, 42,SYM, 98, 36, 45, 34, 43, 99,100,101, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */


/* Model Table:
 * Total sequences: 955
 * First 512 sequences: 0.9964629873582833
 * Next 512 sequences (512-1024): 0.0035370126417167387
 * Rest: -5.2909066017292616e-17
 * Negative sequences: TODO
 */
static char FrenchLangModel[] =
{
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,0,3,0,3,3,0,3,3,0,0,0,2,2,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,0,3,3,0,3,3,2,3,2,0,3,0,0,0,
  3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,2,2,3,3,3,3,0,3,3,0,0,3,2,0,3,0,0,0,0,2,0,0,3,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,3,3,2,2,2,2,0,0,0,0,0,2,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,2,3,3,3,0,3,3,2,2,3,0,2,2,0,0,0,2,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,2,0,3,3,3,2,3,3,2,3,2,0,0,2,0,
  3,3,3,3,2,3,3,3,3,3,2,3,3,2,3,2,2,3,2,3,0,0,3,3,2,2,2,3,3,2,0,3,0,2,0,0,0,2,0,
  3,3,3,3,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,2,3,3,2,0,2,0,2,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,0,3,2,2,2,0,3,3,3,2,0,
  3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,0,3,3,3,2,2,0,0,0,0,2,0,0,0,
  3,3,3,3,3,3,2,2,3,3,3,2,3,2,3,3,3,2,2,3,0,0,3,3,3,0,2,2,0,3,0,2,2,0,2,0,0,0,0,
  3,3,3,3,2,3,3,3,3,3,3,3,2,0,3,2,2,2,2,3,3,2,3,3,2,2,3,2,2,0,0,3,0,2,0,0,0,0,2,
  3,3,3,3,3,2,2,2,3,3,2,3,3,3,3,2,2,3,2,2,0,2,3,3,0,0,2,2,3,2,0,2,0,2,2,0,0,2,2,
  3,3,3,3,0,3,3,3,3,3,2,3,2,3,3,2,2,2,2,3,0,0,2,3,0,0,3,2,2,0,2,3,0,2,0,0,0,0,0,
  3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,2,3,0,2,2,0,0,2,0,0,2,0,2,0,0,0,
  3,3,3,3,3,3,3,3,3,3,2,2,3,2,3,3,2,2,2,3,0,2,3,3,0,2,2,2,2,2,0,0,0,2,0,0,0,0,0,
  3,3,2,3,0,3,2,2,3,3,2,2,0,2,3,2,0,2,2,0,0,0,2,3,0,0,0,0,3,0,0,2,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,2,2,3,0,2,0,0,3,2,3,0,2,0,2,0,0,0,2,3,2,0,0,0,2,
  3,3,3,3,2,3,3,3,3,3,0,2,3,2,3,3,0,2,3,0,0,2,2,3,0,0,0,0,3,0,0,0,0,0,2,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,2,2,3,2,3,0,0,2,0,2,0,0,3,3,2,0,2,2,2,2,0,3,0,3,2,0,0,2,2,
  0,2,0,2,0,0,0,0,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,
  3,3,0,3,0,0,3,2,3,2,0,3,0,3,3,0,3,2,0,2,2,3,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,2,2,3,2,2,2,2,2,2,0,0,2,2,0,2,0,0,0,2,0,0,0,0,0,
  0,0,3,0,3,3,3,3,0,0,3,3,3,2,0,3,3,3,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,2,3,0,3,2,0,3,3,2,2,0,2,3,0,0,2,0,0,0,0,0,0,2,3,0,0,2,0,0,0,0,2,0,0,0,0,0,
  0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,2,3,2,3,3,3,0,2,3,2,3,2,2,2,2,3,0,2,2,0,2,0,3,2,0,2,0,0,0,0,0,0,0,0,0,
  3,3,0,3,2,2,2,2,3,3,0,0,2,0,2,2,0,2,0,2,2,0,3,0,0,0,2,3,0,2,0,0,0,0,0,0,0,0,0,
  0,0,2,0,2,0,3,2,0,0,0,2,3,0,0,0,2,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,2,2,0,2,3,2,2,2,2,2,0,0,0,2,2,2,0,0,2,0,0,0,2,0,0,2,0,0,0,0,0,0,0,0,0,
  0,3,0,0,0,0,0,2,3,3,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,
  0,0,2,2,3,0,3,3,0,0,0,0,2,2,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,3,0,3,3,0,0,0,2,2,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  2,0,0,0,3,0,3,2,0,0,2,3,2,2,0,3,0,2,0,3,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,3,3,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  2,2,2,0,2,2,2,2,0,0,2,2,2,0,0,2,0,2,0,0,2,0,0,0,0,0,2,0,0,2,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,2,0,0,0,0,0,3,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};


SequenceModel Latin15_FrenchModel =
{
  Latin15CharToOrderMap,
  FrenchLangModel,
  39,
  (float)0.9964629873582833,
  PR_TRUE,
  "ISO-8859-15"
};

SequenceModel Windows1252_FrenchModel =
{
  Windows1252CharToOrderMap,
  FrenchLangModel,
  39,
  (float)0.9964629873582833,
  PR_TRUE,
  "windows-1252"
};

SequenceModel Latin1_FrenchModel =
{
  Latin1CharToOrderMap,
  FrenchLangModel,
  39,
  (float)0.9964629873582833,
  PR_TRUE,
  "ISO-8859-1"
};
