
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file MarkerShadingTechniqueAttributes.h
    \\brief Definition of MarkerShadingTechnique Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "MagRequest.h" 
#include "MarkerShadingTechniqueWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


MarkerShadingTechniqueWrapper::MarkerShadingTechniqueWrapper(): markershadingtechnique_(new MarkerShadingTechnique())

{

	
	
	ShadingTechniqueWrapper::object(markershadingtechnique_);
	
	
} 
MarkerShadingTechniqueWrapper::MarkerShadingTechniqueWrapper(MarkerShadingTechnique* markershadingtechnique): markershadingtechnique_(markershadingtechnique)
{
	
	
	ShadingTechniqueWrapper::object(markershadingtechnique_);
	
} 

MarkerShadingTechniqueWrapper::~MarkerShadingTechniqueWrapper()
{
	
}

void MarkerShadingTechniqueWrapper::set(const MagRequest& request)
{
	
	
	
	ShadingTechniqueWrapper::set(request);
	

	stringarray  colour_value;
	for (int i = 0; i < request.countValues("CONTOUR_SHADE_COLOUR_TABLE"); i++)
		colour_value.push_back((string)request("CONTOUR_SHADE_COLOUR_TABLE", i));
	if ( !colour_value.empty() ) 
		markershadingtechnique_->colour_ = colour_value;
	doublearray  height_value;
	for (int i = 0; i < request.countValues("CONTOUR_SHADE_HEIGHT_TABLE"); i++)
		height_value.push_back((double)request("CONTOUR_SHADE_HEIGHT_TABLE", i));
	if ( !height_value.empty() ) 
		markershadingtechnique_->height_ = height_value;
	if  (request.countValues("CONTOUR_SHADE_MARKER_TABLE_TYPE") ) {
		string type_value = request("CONTOUR_SHADE_MARKER_TABLE_TYPE");
		markershadingtechnique_->type_ = type_value;
		}
	intarray marker_value;
	for (int i = 0; i < request.countValues("CONTOUR_SHADE_MARKER_TABLE"); i++)
		marker_value.push_back((int)request("CONTOUR_SHADE_MARKER_TABLE", i));
	if ( !marker_value.empty() ) 
		markershadingtechnique_->marker_ = marker_value;
	stringarray  symbol_value;
	for (int i = 0; i < request.countValues("CONTOUR_SHADE_MARKER_NAME_TABLE"); i++)
		symbol_value.push_back((string)request("CONTOUR_SHADE_MARKER_NAME_TABLE", i));
	if ( !symbol_value.empty() ) 
		markershadingtechnique_->symbol_ = symbol_value;
	
	
}

void MarkerShadingTechniqueWrapper::print(ostream& out)  const
{
	out << "MarkerShadingTechniqueWrapper[]";
}


    



