/* Generated By:JavaCC: Do not edit this line. SQL.java */
package com.mckoi.database.sql;

import com.mckoi.database.TType;
import com.mckoi.database.Assignment;
import com.mckoi.database.JoiningSet;
import com.mckoi.database.Expression;
import com.mckoi.database.Variable;
import com.mckoi.database.FunctionDef;
import com.mckoi.database.FunctionFactory;
import com.mckoi.database.Operator;
import com.mckoi.database.StatementTree;
import com.mckoi.database.ParameterSubstitution;
import com.mckoi.database.global.*;
import com.mckoi.database.interpret.*;
import com.mckoi.database.TObject;
import java.util.ArrayList;
import java.util.Stack;

public class SQL implements SQLConstants {

  // State variables for the parser,

  /**
   * Set to true if the SQL identifiers are converted to upper case.
   * NOTE: Purely experimental feature!
   */
  private boolean case_insensitive_identifiers = false;

  /**
   * The parameter id.
   */
  private int parameter_id = 0;


  /**
   * Resets the parameter id.  This MUST be called before a parser is used
   * to parse a statement.
   */
  public void reset() {
    parameter_id = 0;
  }

  /**
   * Creates and returns a parameter substitution.  This is called when the
   * parser comes across a '?' style object.  This object is used to mark an
   * expression with a place mark that can be substituted for a value later.
   */
  public ParameterSubstitution createSubstitution(String image) {
    ParameterSubstitution ps = new ParameterSubstitution(parameter_id);
    ++parameter_id;
    return ps;
  }


  /**
   * If the parser has been defined as case insensitive then this
   * returns the uppercase version of the given string.
   *
   * NOTE: This actually doesn't do anything because the case is now resolved
   *   outside the parser.
   */
  public String caseCheck(String identif) {
//    if (case_insensitive_identifiers) {
//      return identif.toUpperCase();
//    }
    return identif;
  }

  /**
   * Helper for expression parsing.
   * Called when an end parenthese has been found.
   */
  public void expEndParen(Expression exp, Stack stack) {
    Operator op = (Operator) stack.pop();
    while (!op.is("(")) {
      addOperatorToExpression(exp, op);
      op = (Operator) stack.pop();
    }
  }

  /**
   * Helper for expression parsing.
   * Called when an operator has been read in.  This needs to check precedence
   * and add the operator to the expression as appropriate.
   */
  public void expOperator(Expression exp, Stack stack, Operator op) {
    int precedence = op.precedence();
    flushOperatorStack(exp, stack, precedence);
    stack.push(op);
  }

  /**
   * Flush the operator stack until the stack is either empty or the top
   * element is either a "(" or of a precedence lower than the given
   * precedence.
   */
  public void flushOperatorStack(Expression exp, Stack stack, int precedence) {
    if (!stack.empty()) {
      Operator top_op = (Operator) stack.pop();
      while (!top_op.is("(") && top_op.precedence() >= precedence) {
        addOperatorToExpression(exp, top_op);
        if (stack.empty()) {
          return;
        }
        top_op = (Operator) stack.pop();
      }
      stack.push(top_op);
    }
  }

  /**
   * Helper for expression parsing.
   * Called when an entire expression has been read in.  We need to empty
   * the stack.
   */
  public void expEnd(Expression exp, Stack stack) {
    while (!stack.empty()) {
      Operator op = (Operator) stack.pop();
      addOperatorToExpression(exp, op);
    }
  }

  /**
   * Helper for expression parsing.
   * Adds an operator to the given expression.
   */
  public void addOperatorToExpression(Expression exp, Operator op) {
    if (op.is("not")) {
      exp.addElement(null);
    }
    exp.addOperator(op);
  }



  public static void main(String args[]) throws ParseException {
    SQL parser = new SQL(System.in);
    parser.Test();
  }

  final public void Test() throws ParseException {
    parseExpression();
    jj_consume_token(207);

  }

// Parses a single expression.  Useed in 'com.mckoi.database.Expression.parse' method.
  final public Expression parseExpression() throws ParseException {
  Expression exp;
    exp = DoExpression();
    jj_consume_token(0);
    {if (true) return exp;}
    throw new Error("Missing return statement in function");
  }

// Statement that ends with a ';'
  final public StatementTree Statement() throws ParseException {
  StatementTree ob;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
      ob = Select();
      break;
    case UPDATE:
      ob = Update();
      break;
    case ALTER:
      ob = Alter();
      break;
    case COMPACT:
      ob = Compact();
      break;
    case CREATE:
      ob = Create();
      break;
    case DROP:
      ob = Drop();
      break;
    case DELETE:
      ob = Delete();
      break;
    case INSERT:
      ob = Insert();
      break;
    case DESCRIBE:
      ob = Describe();
      break;
    case SHOW:
      ob = Show();
      break;
    case CALL:
      ob = Call();
      break;
    case GRANT:
      ob = Grant();
      break;
    case REVOKE:
      ob = Revoke();
      break;
    case COMMIT:
    case ROLLBACK:
      ob = CompleteTransaction();
      break;
    case SET:
      ob = Set();
      break;
    case SHUTDOWN:
      ob = ShutDown();
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 207:
      jj_consume_token(207);
      break;
    case 0:
      jj_consume_token(0);
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return ob;}
    throw new Error("Missing return statement in function");
  }

// All statements that start with <CREATE>
  final public StatementTree Create() throws ParseException {
  StatementTree ob;
    jj_consume_token(CREATE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TABLE:
    case TEMPORARY:
      ob = CreateTable();
      break;
    case TRIGGER:
    case CALLBACK:
      ob = CreateTrigger();
      break;
    case FUNCTION:
      ob = CreateFunction();
      break;
    case INDEX:
    case UNIQUE:
      ob = CreateIndex();
      break;
    case SCHEMA:
      ob = CreateSchema();
      break;
    case SEQUENCE:
      ob = CreateSequence();
      break;
    case USER:
      ob = CreateUser();
      break;
    case VIEW:
      ob = CreateView();
      break;
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return ob;}
    throw new Error("Missing return statement in function");
  }

// All statements that start with <DROP>
  final public StatementTree Drop() throws ParseException {
  StatementTree ob;
    jj_consume_token(DROP);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TABLE:
      ob = DropTable();
      break;
    case TRIGGER:
    case CALLBACK:
      ob = DropTrigger();
      break;
    case FUNCTION:
      ob = DropFunction();
      break;
    case INDEX:
      ob = DropIndex();
      break;
    case SCHEMA:
      ob = DropSchema();
      break;
    case SEQUENCE:
      ob = DropSequence();
      break;
    case USER:
      ob = DropUser();
      break;
    case VIEW:
      ob = DropView();
      break;
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return ob;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree Select() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.Select");
  TableSelectExpression table_expr;
  ArrayList order_by = new ArrayList();
    table_expr = GetTableSelectExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDERBY:
      jj_consume_token(ORDERBY);
      SelectOrderByList(order_by);
      break;
    default:
      jj_la1[4] = jj_gen;
      ;
    }
    cmd.putObject("table_expression", table_expr);
    cmd.putObject("order_by", order_by);
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree Update() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.UpdateTable");
  String table_name;
  ArrayList assignments = new ArrayList();
  SearchExpression where_clause = new SearchExpression();
  int limit = -1;
    jj_consume_token(UPDATE);
    table_name = TableName();
    jj_consume_token(SET);
    AssignmentList(assignments);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHERE:
      jj_consume_token(WHERE);
      ConditionsExpression(where_clause);
      break;
    default:
      jj_la1[5] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LIMIT:
      jj_consume_token(LIMIT);
      limit = PositiveIntegerConstant();
      break;
    default:
      jj_la1[6] = jj_gen;
      ;
    }
    cmd.putObject("table_name", table_name);
    cmd.putObject("assignments", assignments);
    cmd.putObject("where_clause", where_clause);
    cmd.putInt("limit", limit);
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree Alter() throws ParseException {
  StatementTree cmd;
    jj_consume_token(ALTER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CREATE:
    case TABLE:
      cmd = AlterTable();
      break;
    case USER:
      cmd = AlterUser();
      break;
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree AlterTable() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.AlterTable");
  String table_name;
  AlterTableAction action;
  StatementTree create_statement;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TABLE:
      jj_consume_token(TABLE);
      table_name = TableName();
      action = GetAlterTableAction();
        cmd.putObject("table_name", table_name);
        cmd.putObject("alter_action", action);
      break;
    case CREATE:
      jj_consume_token(CREATE);
      create_statement = CreateTable();
        cmd.putObject("create_statement", create_statement);
      break;
    default:
      jj_la1[8] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree Compact() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.Compact");
  String table_name;
    jj_consume_token(COMPACT);
    jj_consume_token(TABLE);
    table_name = TableName();
    cmd.putObject("table_name", table_name);
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree CreateTable() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.CreateTable");
  boolean temporary = false;
  boolean only_if_not_exists = false;
  String table_name;
  ArrayList column_list = new ArrayList();
  ArrayList constraint_list = new ArrayList();
  Expression check_expression;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TEMPORARY:
      jj_consume_token(TEMPORARY);
                     temporary = true;
      break;
    default:
      jj_la1[9] = jj_gen;
      ;
    }
    jj_consume_token(TABLE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF:
      jj_consume_token(IF);
      jj_consume_token(NOT);
      jj_consume_token(EXISTS);
                             only_if_not_exists = true;
      break;
    default:
      jj_la1[10] = jj_gen;
      ;
    }
    table_name = TableName();
    ColumnDeclarationList(column_list, constraint_list);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHECK:
      jj_consume_token(CHECK);
      check_expression = DoExpression();
              ConstraintDef check_constraint = new ConstraintDef();
              check_constraint.setCheck(check_expression);
              constraint_list.add(check_constraint);
      break;
    default:
      jj_la1[11] = jj_gen;
      ;
    }
    cmd.putBoolean("temporary", temporary);
    cmd.putBoolean("only_if_not_exists", only_if_not_exists);
    cmd.putObject("table_name", table_name);
    cmd.putObject("column_list", column_list);
    cmd.putObject("constraint_list", constraint_list);
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree CreateTrigger() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.CreateTrigger");
  boolean callback;
  String trigger_name;
  ArrayList trigger_types = new ArrayList();
  String table_name;
  String before_after;
  String procedure_name;
  Expression[] procedure_args;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CALLBACK:
      jj_consume_token(CALLBACK);
      jj_consume_token(TRIGGER);
      trigger_name = TriggerName();
      TriggerTypes(trigger_types);
      jj_consume_token(ON);
      table_name = TableName();
      cmd.putObject("type", "callback_trigger");
      break;
    case TRIGGER:
      jj_consume_token(TRIGGER);
      trigger_name = TriggerName();
      before_after = BeforeOrAfter();
      TriggerTypes(trigger_types);
      jj_consume_token(ON);
      table_name = TableName();
      jj_consume_token(FOR);
      jj_consume_token(EACH);
      jj_consume_token(ROW);
      jj_consume_token(EXECUTE);
      jj_consume_token(PROCEDURE);
      procedure_name = FunctionName();
      jj_consume_token(208);
      procedure_args = ExpressionList();
      jj_consume_token(209);
      cmd.putObject("type", "procedure_trigger");
      cmd.putObject("before_after", before_after);
      cmd.putObject("procedure_name", procedure_name);
      cmd.putObject("procedure_args", procedure_args);
      break;
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    cmd.putObject("trigger_name", trigger_name);
    cmd.putObject("trigger_types", trigger_types);
    cmd.putObject("table_name", table_name);
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree DropTrigger() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.DropTrigger");
  String trigger_name;
  String type = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CALLBACK:
      jj_consume_token(CALLBACK);
      jj_consume_token(TRIGGER);
      trigger_name = TriggerName();
                                                            type = "callback_trigger";
      break;
    case TRIGGER:
      jj_consume_token(TRIGGER);
      trigger_name = TriggerName();
                                                 type = "procedure_trigger";
    cmd.putObject("trigger_name", trigger_name);
    cmd.putObject("type", type);
    {if (true) return cmd;}
      break;
    default:
      jj_la1[13] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public StatementTree CreateFunction() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.Function");
  cmd.putObject("type", "create");
  String function_name;
  ArrayList arg_names = new ArrayList();
  ArrayList arg_types = new ArrayList();
  Token loc_name;
  TType return_type = null;
    jj_consume_token(FUNCTION);
    function_name = FunctionName();
    jj_consume_token(208);
    ProcParameterList(arg_names, arg_types);
    jj_consume_token(209);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RETURNS:
      jj_consume_token(RETURNS);
      return_type = GetTType();
      break;
    default:
      jj_la1[14] = jj_gen;
      ;
    }
    jj_consume_token(LANGUAGE);
    jj_consume_token(JAVA);
    jj_consume_token(NAME);
    loc_name = jj_consume_token(STRING_LITERAL);
    cmd.putObject("function_name", function_name);
    cmd.putObject("arg_names", arg_names);
    cmd.putObject("arg_types", arg_types);
    // Note that 'location_name' will be a TObject
    cmd.putObject("location_name",
                  Util.toParamObject(loc_name, case_insensitive_identifiers));
    cmd.putObject("return_type", return_type);
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree DropFunction() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.Function");
  cmd.putObject("type", "drop");
  String function_name;
    jj_consume_token(FUNCTION);
    function_name = FunctionName();
    cmd.putObject("function_name", function_name);
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree CreateSchema() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.Schema");
  cmd.putObject("type", "create");
  String schema_name;
    jj_consume_token(SCHEMA);
    schema_name = SchemaName();
    cmd.putObject("schema_name", schema_name);
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree DropSchema() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.Schema");
  cmd.putObject("type", "drop");
  String schema_name;
    jj_consume_token(SCHEMA);
    schema_name = SchemaName();
    cmd.putObject("schema_name", schema_name);
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree CreateView() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.ViewManager");
  String view_name;
  TableSelectExpression select_cmd;
  ArrayList col_list = new ArrayList();
    jj_consume_token(VIEW);
    view_name = TableName();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 208:
      jj_consume_token(208);
      BasicColumnList(col_list);
      jj_consume_token(209);
      break;
    default:
      jj_la1[15] = jj_gen;
      ;
    }
    jj_consume_token(AS);
    select_cmd = GetTableSelectExpression();
    cmd.putObject("type", "create");
    cmd.putObject("view_name", view_name);
    cmd.putObject("column_list", col_list);
    cmd.putObject("select_expression", select_cmd);
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree DropView() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.ViewManager");
  String view_name;
    jj_consume_token(VIEW);
    view_name = TableName();
    cmd.putObject("type", "drop");
    cmd.putObject("view_name", view_name);
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree CreateIndex() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.NoOp");
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNIQUE:
      jj_consume_token(UNIQUE);
      break;
    default:
      jj_la1[16] = jj_gen;
      ;
    }
    jj_consume_token(INDEX);
    IndexName();
    jj_consume_token(ON);
    TableName();
    jj_consume_token(208);
    BasicColumnList(new ArrayList());
    jj_consume_token(209);
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree DropTable() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.DropTable");
  boolean only_if_exists = false;
  String table_name;
  ArrayList table_list = new ArrayList();
    jj_consume_token(TABLE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF:
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
                           only_if_exists = true;
      break;
    default:
      jj_la1[17] = jj_gen;
      ;
    }
    table_name = TableName();
                                    table_list.add(table_name);
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 210:
        ;
        break;
      default:
        jj_la1[18] = jj_gen;
        break label_1;
      }
      jj_consume_token(210);
      table_name = TableName();
                                            table_list.add(table_name);
    }
    cmd.putBoolean("only_if_exists", only_if_exists);
    cmd.putObject("table_list", table_list);
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree DropIndex() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.NoOp");
    jj_consume_token(INDEX);
    IndexName();
    jj_consume_token(ON);
    TableName();
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree Call() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.Call");
  String proc_name;
  Expression[] args = null;
    jj_consume_token(CALL);
    proc_name = ProcedureName();
    jj_consume_token(208);
    args = ExpressionList();
    jj_consume_token(209);
    cmd.putObject("proc_name", proc_name);
    cmd.putObject("args", args);
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree CreateSequence() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.Sequence");
  cmd.putObject("type", "create");
  String seq_name;
  Expression v;
    jj_consume_token(SEQUENCE);
    seq_name = SequenceName();
                                       cmd.putObject("seq_name", seq_name);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INCREMENT:
      jj_consume_token(INCREMENT);
      v = DoExpression();
                                     cmd.putObject("increment", v);
      break;
    default:
      jj_la1[19] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINVALUE:
      jj_consume_token(MINVALUE);
      v = DoExpression();
                                    cmd.putObject("min_value", v);
      break;
    default:
      jj_la1[20] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MAXVALUE:
      jj_consume_token(MAXVALUE);
      v = DoExpression();
                                    cmd.putObject("max_value", v);
      break;
    default:
      jj_la1[21] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case START:
      jj_consume_token(START);
      v = DoExpression();
                                 cmd.putObject("start", v);
      break;
    default:
      jj_la1[22] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CACHE:
      jj_consume_token(CACHE);
      v = DoExpression();
                                 cmd.putObject("cache", v);
      break;
    default:
      jj_la1[23] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CYCLE:
      jj_consume_token(CYCLE);
              cmd.putObject("cycle", "yes");
      break;
    default:
      jj_la1[24] = jj_gen;
      ;
    }
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree DropSequence() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.Sequence");
  cmd.putObject("type", "drop");
  String seq_name;
    jj_consume_token(SEQUENCE);
    seq_name = SequenceName();
                                       cmd.putObject("seq_name", seq_name);
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree CreateUser() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.UserManager");
  cmd.putObject("type", "CREATE USER");
    jj_consume_token(USER);
    UserManagerCommand(cmd);
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree AlterUser() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.UserManager");
  cmd.putObject("type", "ALTER USER");
    jj_consume_token(USER);
    UserManagerCommand(cmd);
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree DropUser() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.UserManager");
  cmd.putObject("type", "DROP USER");
  String username;
    jj_consume_token(USER);
    username = UserName();
    cmd.putObject("username", username);
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public void UserManagerCommand(StatementTree cmd) throws ParseException {
  String username;
  Expression password_exp;
  Expression[] groups_list = null;
  String lock_status = null;
    username = UserName();
    jj_consume_token(SET);
    jj_consume_token(PASSWORD);
    password_exp = DoExpression();
    if (jj_2_1(2)) {
      jj_consume_token(SET);
      jj_consume_token(GROUPS);
      groups_list = ExpressionList();
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SET:
      jj_consume_token(SET);
      jj_consume_token(ACCOUNT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOCK:
        jj_consume_token(LOCK);
                                   lock_status="LOCK";
        break;
      case UNLOCK:
        jj_consume_token(UNLOCK);
                                                                      lock_status="UNLOCK";
        break;
      default:
        jj_la1[25] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[26] = jj_gen;
      ;
    }
    cmd.putObject("username", username);
    cmd.putObject("password_expression", password_exp);
    cmd.putObject("groups_list", groups_list);
    cmd.putObject("lock_status", lock_status);
  }

  final public StatementTree Delete() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.Delete");
  String table_name;
  SearchExpression where_clause = new SearchExpression();
  int limit = -1;
    jj_consume_token(DELETE);
    jj_consume_token(FROM);
    table_name = TableName();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHERE:
      jj_consume_token(WHERE);
      ConditionsExpression(where_clause);
      break;
    default:
      jj_la1[27] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LIMIT:
      jj_consume_token(LIMIT);
      limit = PositiveIntegerConstant();
      break;
    default:
      jj_la1[28] = jj_gen;
      ;
    }
    cmd.putObject("table_name", table_name);
    cmd.putObject("where_clause", where_clause);
    cmd.putInt("limit", limit);
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree Insert() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.Insert");
  String table_name;
  ArrayList col_list = new ArrayList();
  ArrayList data_list = new ArrayList(); // ( Array of Expression[] )
  StatementTree select = null;
  ArrayList assignments = new ArrayList();
  String type;
    jj_consume_token(INSERT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTO:
      jj_consume_token(INTO);
      break;
    default:
      jj_la1[29] = jj_gen;
      ;
    }
    table_name = TableName();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
    case VALUES:
    case 208:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 208:
        jj_consume_token(208);
        BasicColumnList(col_list);
        jj_consume_token(209);
        break;
      default:
        jj_la1[30] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VALUES:
        jj_consume_token(VALUES);
        InsertDataList(data_list);
                                                     type = "from_values";
        break;
      case SELECT:
        select = Select();
                                                     type = "from_select";
        break;
      default:
        jj_la1[31] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case SET:
      jj_consume_token(SET);
      AssignmentList(assignments);
                                                     type = "from_set";
      break;
    default:
      jj_la1[32] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    cmd.putObject("table_name", table_name);
    cmd.putObject("col_list", col_list);
    cmd.putObject("data_list", data_list);
    cmd.putObject("select", select);
    cmd.putObject("assignments", assignments);
    cmd.putObject("type", type);
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree Describe() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.Show");
  cmd.putObject("show", "describe_table");
  String table_name;
    jj_consume_token(DESCRIBE);
    table_name = TableName();
    cmd.putObject("table_name", table_name);
    cmd.putObject("where_clause", new SearchExpression());
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree Show() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.Show");
  Expression[] args = null;
  SearchExpression where_clause = new SearchExpression();
  Token t;
    jj_consume_token(SHOW);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      t = jj_consume_token(IDENTIFIER);
      break;
    case SCHEMA:
      t = jj_consume_token(SCHEMA);
      break;
    default:
      jj_la1[33] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 208:
      jj_consume_token(208);
      args = ExpressionList();
      jj_consume_token(209);
      break;
    default:
      jj_la1[34] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHERE:
      jj_consume_token(WHERE);
      ConditionsExpression(where_clause);
      break;
    default:
      jj_la1[35] = jj_gen;
      ;
    }
    cmd.putObject("show", t.image);
    cmd.putObject("args", args);
    cmd.putObject("where_clause", where_clause);
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree Grant() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.PrivManager");
  ArrayList priv_list = new ArrayList();
  String priv_object;
  ArrayList grant_to;
  boolean grant_option = false;
    jj_consume_token(GRANT);
    PrivList(priv_list);
    jj_consume_token(ON);
    priv_object = PrivObject();
    jj_consume_token(TO);
    grant_to = UserNameList(new ArrayList());
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITH:
      jj_consume_token(WITH);
      jj_consume_token(GRANT);
      jj_consume_token(OPTION);
                                grant_option = true;
      break;
    default:
      jj_la1[36] = jj_gen;
      ;
    }
    cmd.putObject("command", "GRANT");
    cmd.putObject("priv_list", priv_list);
    cmd.putObject("priv_object", priv_object);
    cmd.putObject("grant_to", grant_to);
    cmd.putBoolean("grant_option", grant_option);
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree Revoke() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.PrivManager");
  ArrayList priv_list = new ArrayList();
  String priv_object;
  ArrayList revoke_from;
  boolean revoke_grant_option = false;
    jj_consume_token(REVOKE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case GRANT:
      jj_consume_token(GRANT);
      jj_consume_token(OPTION);
      jj_consume_token(FOR);
                                        revoke_grant_option = true;
      break;
    default:
      jj_la1[37] = jj_gen;
      ;
    }
    PrivList(priv_list);
    jj_consume_token(ON);
    priv_object = PrivObject();
    jj_consume_token(FROM);
    revoke_from = UserNameList(new ArrayList());
    cmd.putObject("command", "REVOKE");
    cmd.putObject("priv_list", priv_list);
    cmd.putObject("priv_object", priv_object);
    cmd.putObject("revoke_from", revoke_from);
    cmd.putBoolean("revoke_grant_option", revoke_grant_option);
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree CompleteTransaction() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.CompleteTransaction");
  String command;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMIT:
      jj_consume_token(COMMIT);
                   command = "commit";
      break;
    case ROLLBACK:
      jj_consume_token(ROLLBACK);
                   command = "rollback";
      break;
    default:
      jj_la1[38] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    cmd.putObject("command", command);
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree Set() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.Set");
  Token t1;
  String value;
  Expression exp;
  String name;
    jj_consume_token(SET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      t1 = jj_consume_token(IDENTIFIER);
      jj_consume_token(ASSIGNMENT);
      exp = DoExpression();
          cmd.putObject("type", "VARSET");
          cmd.putObject("var_name", t1.image);
          cmd.putObject("exp", exp);
      break;
    case TRANSACTIONISOLATIONLEVEL:
      jj_consume_token(TRANSACTIONISOLATIONLEVEL);
      t1 = jj_consume_token(SERIALIZABLE);
          cmd.putObject("type", "ISOLATIONSET");
          cmd.putObject("var_name", "TRANSACTION ISOLATION LEVEL");
          cmd.putObject("value", t1.image);
      break;
    case AUTOCOMMIT:
      jj_consume_token(AUTOCOMMIT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ON:
        t1 = jj_consume_token(ON);
        break;
      case IDENTIFIER:
        t1 = jj_consume_token(IDENTIFIER);
        break;
      default:
        jj_la1[39] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
          cmd.putObject("type", "AUTOCOMMIT");
          cmd.putObject("value", t1.image);
      break;
    case SCHEMA:
      jj_consume_token(SCHEMA);
      name = SchemaName();
          cmd.putObject("type", "SCHEMA");
          cmd.putObject("value", name);
      break;
    default:
      jj_la1[40] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public StatementTree ShutDown() throws ParseException {
  StatementTree cmd = new StatementTree("com.mckoi.database.interpret.Misc");
    jj_consume_token(SHUTDOWN);
    cmd.putObject("command", "shutdown");
    {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

// ----------
  final public String TriggerType() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INSERT:
      jj_consume_token(INSERT);
                 {if (true) return "insert";}
      break;
    case DELETE:
      jj_consume_token(DELETE);
                 {if (true) return "delete";}
      break;
    case UPDATE:
      jj_consume_token(UPDATE);
                 {if (true) return "update";}
      break;
    default:
      jj_la1[41] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String BeforeOrAfter() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BEFORE:
      jj_consume_token(BEFORE);
                 {if (true) return "before";}
      break;
    case AFTER:
      jj_consume_token(AFTER);
                {if (true) return "after";}
      break;
    default:
      jj_la1[42] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// A list of triggered actions separated by 'OR' delimination, for example,
// INSERT OR DELETE OR UPDATE
  final public void TriggerTypes(ArrayList list) throws ParseException {
  String trig_type;
    trig_type = TriggerType();
                              list.add(trig_type);
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OR:
        ;
        break;
      default:
        jj_la1[43] = jj_gen;
        break label_2;
      }
      jj_consume_token(OR);
      trig_type = TriggerType();
                                       list.add(trig_type);
    }
  }

// A priv object
// Note we add a 2 character prefix to the priv object for future enhancements.
// In the future an object may be something other than a table.
  final public String PrivObject() throws ParseException {
  String table_name;
  String schema_name;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OLD:
    case NEW:
    case NAME:
    case JAVA:
    case TABLE:
    case ACTION:
    case GROUPS:
    case OPTION:
    case ACCOUNT:
    case PASSWORD:
    case LANGUAGE:
    case PRIVILEGES:
    case QUOTED_VARIABLE:
    case IDENTIFIER:
    case DOT_DELIMINATED_REF:
    case QUOTED_DELIMINATED_REF:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TABLE:
        jj_consume_token(TABLE);
        break;
      default:
        jj_la1[44] = jj_gen;
        ;
      }
      table_name = TableName();
                                           {if (true) return "T:" + table_name;}
      break;
    case SCHEMA:
      jj_consume_token(SCHEMA);
      schema_name = SchemaName();
                                          {if (true) return "S:" + schema_name;}
      break;
    default:
      jj_la1[45] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// A list of privs
  final public ArrayList PrivList(ArrayList list) throws ParseException {
    PrivListItem(list);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 210:
        ;
        break;
      default:
        jj_la1[46] = jj_gen;
        break label_3;
      }
      jj_consume_token(210);
      PrivListItem(list);
    }
    {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

// Adds an item in a priv list
  final public void PrivListItem(ArrayList list) throws ParseException {
  Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
      t = jj_consume_token(SELECT);
      break;
    case INSERT:
      t = jj_consume_token(INSERT);
      break;
    case UPDATE:
      t = jj_consume_token(UPDATE);
      break;
    case DELETE:
      t = jj_consume_token(DELETE);
      break;
    case REFERENCES:
      t = jj_consume_token(REFERENCES);
      break;
    case USAGE:
      t = jj_consume_token(USAGE);
      break;
    case ALL:
      t = jj_consume_token(ALL);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PRIVILEGES:
        jj_consume_token(PRIVILEGES);
        break;
      default:
        jj_la1[47] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[48] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    list.add(t.image);
  }

// A table expression 
  final public TableSelectExpression GetTableSelectExpression() throws ParseException {
  TableSelectExpression table_expr = new TableSelectExpression();
  String composite = "";
  boolean is_all = false;
  TableSelectExpression next_composite_expression;
    jj_consume_token(SELECT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALL:
    case DISTINCT:
      table_expr.distinct = SetQuantifier();
      break;
    default:
      jj_la1[49] = jj_gen;
      ;
    }
    SelectColumnList(table_expr.columns);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FROM:
      jj_consume_token(FROM);
      SelectTableList(table_expr.from_clause);
      break;
    default:
      jj_la1[50] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHERE:
      jj_consume_token(WHERE);
      ConditionsExpression(table_expr.where_clause);
      break;
    default:
      jj_la1[51] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case GROUPBY:
      jj_consume_token(GROUPBY);
      SelectGroupByList(table_expr.group_by);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GROUPMAX:
        jj_consume_token(GROUPMAX);
        table_expr.group_max = GroupMaxColumn();
        break;
      default:
        jj_la1[52] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HAVING:
        jj_consume_token(HAVING);
        ConditionsExpression(table_expr.having_clause);
        break;
      default:
        jj_la1[53] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[54] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNION:
    case EXCEPT:
    case INTERSECT:
      composite = GetComposite();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
        jj_consume_token(ALL);
                                               is_all = true;
        break;
      default:
        jj_la1[55] = jj_gen;
        ;
      }
      next_composite_expression = GetTableSelectExpression();
            table_expr.chainComposite(next_composite_expression, composite, is_all);
      break;
    default:
      jj_la1[56] = jj_gen;
      ;
    }
    {if (true) return table_expr;}
    throw new Error("Missing return statement in function");
  }

  final public AlterTableAction GetAlterTableAction() throws ParseException {
  String col_name, con_name;
  ColumnDef column_def;
  ConstraintDef constraint_def;
  Expression default_exp;
  AlterTableAction action = new AlterTableAction();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SQLADD:
      jj_consume_token(SQLADD);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NAME:
      case JAVA:
      case ACTION:
      case GROUPS:
      case OPTION:
      case SQLCOLUMN:
      case ACCOUNT:
      case PASSWORD:
      case LANGUAGE:
      case PRIVILEGES:
      case QUOTED_VARIABLE:
      case IDENTIFIER:
      case DOT_DELIMINATED_REF:
      case QUOTED_DELIMINATED_REF:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SQLCOLUMN:
          jj_consume_token(SQLCOLUMN);
          break;
        default:
          jj_la1[57] = jj_gen;
          ;
        }
        column_def = ColumnDefinition();
            action.setAction("ADD");
            action.addElement(column_def);
        break;
      case CHECK:
      case UNIQUE:
      case CONSTRAINT:
      case PRIMARY:
      case FOREIGN:
        constraint_def = TableConstraintDefinition();
            action.setAction("ADD_CONSTRAINT");
            action.addElement(constraint_def);
        break;
      default:
        jj_la1[58] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case ALTER:
      jj_consume_token(ALTER);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQLCOLUMN:
        jj_consume_token(SQLCOLUMN);
        break;
      default:
        jj_la1[59] = jj_gen;
        ;
      }
      col_name = ColumnName();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SET:
        jj_consume_token(SET);
        default_exp = DoExpression();
            action.setAction("ALTERSET");
            action.addElement(col_name);
            action.addElement(default_exp);
        break;
      case DROP:
        jj_consume_token(DROP);
        jj_consume_token(SQLDEFAULT);
            action.setAction("DROPDEFAULT");
            action.addElement(col_name);
        break;
      default:
        jj_la1[60] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case DROP:
      jj_consume_token(DROP);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NAME:
      case JAVA:
      case ACTION:
      case GROUPS:
      case OPTION:
      case SQLCOLUMN:
      case ACCOUNT:
      case PASSWORD:
      case LANGUAGE:
      case PRIVILEGES:
      case QUOTED_VARIABLE:
      case IDENTIFIER:
      case DOT_DELIMINATED_REF:
      case QUOTED_DELIMINATED_REF:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SQLCOLUMN:
          jj_consume_token(SQLCOLUMN);
          break;
        default:
          jj_la1[61] = jj_gen;
          ;
        }
        col_name = ColumnName();
            action.setAction("DROP");
            action.addElement(col_name);
        break;
      case CONSTRAINT:
        jj_consume_token(CONSTRAINT);
        con_name = ConstraintName();
            action.setAction("DROP_CONSTRAINT");
            action.addElement(con_name);
        break;
      case PRIMARY:
        jj_consume_token(PRIMARY);
        jj_consume_token(KEY);
            action.setAction("DROP_CONSTRAINT_PRIMARY_KEY");
        break;
      default:
        jj_la1[62] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[63] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return action;}
    throw new Error("Missing return statement in function");
  }

// An element to insert, either an expression or DEFAULT for the default
// element.
  final public Object InsertElement() throws ParseException {
  Expression e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SQLDEFAULT:
      jj_consume_token(SQLDEFAULT);
                            {if (true) return "DEFAULT";}
      break;
    case ADD:
    case SUBTRACT:
    case BOOLEAN_LITERAL:
    case NULL_LITERAL:
    case IF:
    case NEW:
    case TRIM:
    case USER:
    case CAST:
    case NAME:
    case JAVA:
    case COUNT:
    case ACTION:
    case GROUPS:
    case OPTION:
    case ACCOUNT:
    case PASSWORD:
    case LANGUAGE:
    case PRIVILEGES:
    case DATE:
    case TIME:
    case TIMESTAMP:
    case CURRENT_TIME:
    case CURRENT_DATE:
    case CURRENT_TIMESTAMP:
    case NOT:
    case NUMBER_LITERAL:
    case STRING_LITERAL:
    case QUOTED_VARIABLE:
    case IDENTIFIER:
    case DOT_DELIMINATED_REF:
    case QUOTED_DELIMINATED_REF:
    case PARAMETER_REF:
    case 208:
      e = DoExpression();
                            {if (true) return e;}
      break;
    default:
      jj_la1[64] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ArrayList InsertExpressionList() throws ParseException {
  ArrayList list = new ArrayList();
  Object elem;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ADD:
    case SUBTRACT:
    case BOOLEAN_LITERAL:
    case NULL_LITERAL:
    case IF:
    case NEW:
    case TRIM:
    case USER:
    case CAST:
    case NAME:
    case JAVA:
    case COUNT:
    case ACTION:
    case GROUPS:
    case OPTION:
    case ACCOUNT:
    case SQLDEFAULT:
    case PASSWORD:
    case LANGUAGE:
    case PRIVILEGES:
    case DATE:
    case TIME:
    case TIMESTAMP:
    case CURRENT_TIME:
    case CURRENT_DATE:
    case CURRENT_TIMESTAMP:
    case NOT:
    case NUMBER_LITERAL:
    case STRING_LITERAL:
    case QUOTED_VARIABLE:
    case IDENTIFIER:
    case DOT_DELIMINATED_REF:
    case QUOTED_DELIMINATED_REF:
    case PARAMETER_REF:
    case 208:
      elem = InsertElement();
                             list.add(elem);
      label_4:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 210:
          ;
          break;
        default:
          jj_la1[65] = jj_gen;
          break label_4;
        }
        jj_consume_token(210);
        elem = InsertElement();
                                   list.add(elem);
      }
      break;
    default:
      jj_la1[66] = jj_gen;
      ;
    }
    {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

// The list of columns to insert formatted as; eg.  (9, 4), (3, 2), (9, 9), ....
  final public void InsertDataList(ArrayList data_list) throws ParseException {
  ArrayList insert_vals;
    jj_consume_token(208);
    insert_vals = InsertExpressionList();
    jj_consume_token(209);
                                                   data_list.add(insert_vals);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 210:
        ;
        break;
      default:
        jj_la1[67] = jj_gen;
        break label_5;
      }
      jj_consume_token(210);
      jj_consume_token(208);
      insert_vals = InsertExpressionList();
      jj_consume_token(209);
                                                       data_list.add(insert_vals);
    }
  }

// Returning true means distinct, false means all.
  final public boolean SetQuantifier() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DISTINCT:
      jj_consume_token(DISTINCT);
                  {if (true) return true;}
      break;
    case ALL:
      jj_consume_token(ALL);
                  {if (true) return false;}
      break;
    default:
      jj_la1[68] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public void SelectColumnList(ArrayList list) throws ParseException {
  SelectColumn col;
    col = SelectColumn();
                           list.add(col);
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 210:
        ;
        break;
      default:
        jj_la1[69] = jj_gen;
        break label_6;
      }
      jj_consume_token(210);
      col = SelectColumn();
                               list.add(col);
    }
  }

  final public SelectColumn SelectColumn() throws ParseException {
  SelectColumn col = new SelectColumn();
  String aliased_name;
  Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ADD:
    case SUBTRACT:
    case BOOLEAN_LITERAL:
    case NULL_LITERAL:
    case IF:
    case NEW:
    case TRIM:
    case USER:
    case CAST:
    case NAME:
    case JAVA:
    case COUNT:
    case ACTION:
    case GROUPS:
    case OPTION:
    case ACCOUNT:
    case PASSWORD:
    case LANGUAGE:
    case PRIVILEGES:
    case DATE:
    case TIME:
    case TIMESTAMP:
    case CURRENT_TIME:
    case CURRENT_DATE:
    case CURRENT_TIMESTAMP:
    case NOT:
    case NUMBER_LITERAL:
    case STRING_LITERAL:
    case QUOTED_VARIABLE:
    case IDENTIFIER:
    case DOT_DELIMINATED_REF:
    case QUOTED_DELIMINATED_REF:
    case PARAMETER_REF:
    case 208:
      col.expression = DoExpression();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[70] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NAME:
      case JAVA:
      case ACTION:
      case GROUPS:
      case OPTION:
      case ACCOUNT:
      case PASSWORD:
      case LANGUAGE:
      case PRIVILEGES:
      case QUOTED_VARIABLE:
      case IDENTIFIER:
        col.alias = TableAliasName();
        break;
      default:
        jj_la1[71] = jj_gen;
        ;
      }
      break;
    case STAR:
      jj_consume_token(STAR);
               col.glob_name = "*";
      break;
    case GLOBVARIABLE:
      t = jj_consume_token(GLOBVARIABLE);
                           col.glob_name = caseCheck(t.image);
      break;
    case QUOTEDGLOBVARIABLE:
      t = jj_consume_token(QUOTEDGLOBVARIABLE);
                                 col.glob_name = caseCheck(Util.asNonQuotedRef(t));
      break;
    default:
      jj_la1[72] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return col;}
    throw new Error("Missing return statement in function");
  }

  final public void SelectGroupByList(ArrayList list) throws ParseException {
  ByColumn col;
  Expression exp;
    exp = DoExpression();
                           col = new ByColumn();
                           col.exp = exp;
                           list.add(col);
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 210:
        ;
        break;
      default:
        jj_la1[73] = jj_gen;
        break label_7;
      }
      jj_consume_token(210);
      exp = DoExpression();
                               col = new ByColumn();
                               col.exp = exp;
                               list.add(col);
    }
  }

/**
 * NOTE: This is an extension, allows for us to specify a column to return the
 *  max value for each row representing a group.
 */
  final public Variable GroupMaxColumn() throws ParseException {
  Variable var;
    var = ColumnNameVariable();
    {if (true) return var;}
    throw new Error("Missing return statement in function");
  }

  final public void SelectOrderByList(ArrayList list) throws ParseException {
  ByColumn col;
  Expression exp;
  boolean ascending = true;
    exp = DoExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASC:
    case DESC:
      ascending = OrderingSpec();
      break;
    default:
      jj_la1[74] = jj_gen;
      ;
    }
                           col = new ByColumn();
                           col.exp = exp;
                           col.ascending = ascending;
                           list.add(col);
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 210:
        ;
        break;
      default:
        jj_la1[75] = jj_gen;
        break label_8;
      }
      jj_consume_token(210);
      exp = DoExpression();
                               ascending=true;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASC:
      case DESC:
        ascending = OrderingSpec();
        break;
      default:
        jj_la1[76] = jj_gen;
        ;
      }
                           col = new ByColumn();
                           col.exp = exp;
                           col.ascending = ascending;
                           list.add(col);
    }
  }

  final public boolean OrderingSpec() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASC:
      jj_consume_token(ASC);
            {if (true) return true;}
      break;
    case DESC:
      jj_consume_token(DESC);
                                      {if (true) return false;}
      break;
    default:
      jj_la1[77] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return true;}
    throw new Error("Missing return statement in function");
  }

  final public void TableDeclaration(FromClause from_clause) throws ParseException {
  String table=null, declare_as = null;
  TableSelectExpression select_stmt = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OLD:
    case NEW:
    case NAME:
    case JAVA:
    case ACTION:
    case GROUPS:
    case OPTION:
    case ACCOUNT:
    case PASSWORD:
    case LANGUAGE:
    case PRIVILEGES:
    case QUOTED_VARIABLE:
    case IDENTIFIER:
    case DOT_DELIMINATED_REF:
    case QUOTED_DELIMINATED_REF:
      table = TableName();
      break;
    case 208:
      jj_consume_token(208);
      select_stmt = GetTableSelectExpression();
      jj_consume_token(209);
      break;
    default:
      jj_la1[78] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
    case OLD:
    case NEW:
    case NAME:
    case JAVA:
    case ACTION:
    case GROUPS:
    case OPTION:
    case ACCOUNT:
    case PASSWORD:
    case LANGUAGE:
    case PRIVILEGES:
    case QUOTED_VARIABLE:
    case IDENTIFIER:
    case DOT_DELIMINATED_REF:
    case QUOTED_DELIMINATED_REF:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[79] = jj_gen;
        ;
      }
      declare_as = TableName();
      break;
    default:
      jj_la1[80] = jj_gen;
      ;
    }
    from_clause.addTableDeclaration(table, select_stmt, declare_as);
  }

  final public void SelectTableList(FromClause from_clause) throws ParseException {
    TableDeclaration(from_clause);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LEFT:
    case JOIN:
    case RIGHT:
    case INNER:
    case 210:
      FromClauseJoin(from_clause);
      break;
    default:
      jj_la1[81] = jj_gen;
      ;
    }
  }

  final public void FromClauseJoin(FromClause from_clause) throws ParseException {
  Expression on_expression;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 210:
      jj_consume_token(210);
          from_clause.addJoin(JoiningSet.INNER_JOIN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OLD:
      case NEW:
      case NAME:
      case JAVA:
      case ACTION:
      case GROUPS:
      case OPTION:
      case ACCOUNT:
      case PASSWORD:
      case LANGUAGE:
      case PRIVILEGES:
      case QUOTED_VARIABLE:
      case IDENTIFIER:
      case DOT_DELIMINATED_REF:
      case QUOTED_DELIMINATED_REF:
      case 208:
        SelectTableList(from_clause);
        break;
      default:
        jj_la1[82] = jj_gen;
        ;
      }
      break;
    case JOIN:
    case INNER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INNER:
        jj_consume_token(INNER);
        break;
      default:
        jj_la1[83] = jj_gen;
        ;
      }
      jj_consume_token(JOIN);
      TableDeclaration(from_clause);
      jj_consume_token(ON);
      on_expression = DoExpression();
          from_clause.addPreviousJoin(JoiningSet.INNER_JOIN, on_expression);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LEFT:
      case JOIN:
      case RIGHT:
      case INNER:
      case 210:
        FromClauseJoin(from_clause);
        break;
      default:
        jj_la1[84] = jj_gen;
        ;
      }
      break;
    case LEFT:
      jj_consume_token(LEFT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OUTER:
        jj_consume_token(OUTER);
        break;
      default:
        jj_la1[85] = jj_gen;
        ;
      }
      jj_consume_token(JOIN);
      TableDeclaration(from_clause);
      jj_consume_token(ON);
      on_expression = DoExpression();
          from_clause.addPreviousJoin(JoiningSet.LEFT_OUTER_JOIN, on_expression);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LEFT:
      case JOIN:
      case RIGHT:
      case INNER:
      case 210:
        FromClauseJoin(from_clause);
        break;
      default:
        jj_la1[86] = jj_gen;
        ;
      }
      break;
    case RIGHT:
      jj_consume_token(RIGHT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OUTER:
        jj_consume_token(OUTER);
        break;
      default:
        jj_la1[87] = jj_gen;
        ;
      }
      jj_consume_token(JOIN);
      TableDeclaration(from_clause);
      jj_consume_token(ON);
      on_expression = DoExpression();
          from_clause.addPreviousJoin(JoiningSet.RIGHT_OUTER_JOIN, on_expression);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LEFT:
      case JOIN:
      case RIGHT:
      case INNER:
      case 210:
        FromClauseJoin(from_clause);
        break;
      default:
        jj_la1[88] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[89] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

// A list of parameters in a function or procedure declaration.  For example,
// ' p1 NUMERIC, p2 NUMERIC, s1 CHARACTER VARYING '
// First array contains parameter names, and second contains TType representing
// the type.
  final public void ProcParameterList(ArrayList decl_names, ArrayList decl_types) throws ParseException {
  String name;
  TType type;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LONG:
    case NAME:
    case JAVA:
    case ACTION:
    case GROUPS:
    case OPTION:
    case ACCOUNT:
    case PASSWORD:
    case LANGUAGE:
    case CHARACTER:
    case PRIVILEGES:
    case BIT:
    case INT:
    case REAL:
    case CLOB:
    case BLOB:
    case CHAR:
    case TEXT:
    case DATE:
    case TIME:
    case FLOAT:
    case BIGINT:
    case DOUBLE:
    case STRING:
    case BINARY:
    case NUMERIC:
    case DECIMAL:
    case BOOLEAN:
    case TINYINT:
    case INTEGER:
    case VARCHAR:
    case SMALLINT:
    case VARBINARY:
    case TIMESTAMP:
    case JAVA_OBJECT:
    case LONGVARCHAR:
    case LONGVARBINARY:
    case QUOTED_VARIABLE:
    case IDENTIFIER:
      name = null;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NAME:
      case JAVA:
      case ACTION:
      case GROUPS:
      case OPTION:
      case ACCOUNT:
      case PASSWORD:
      case LANGUAGE:
      case PRIVILEGES:
      case QUOTED_VARIABLE:
      case IDENTIFIER:
        name = ProcArgumentName();
        break;
      default:
        jj_la1[90] = jj_gen;
        ;
      }
      type = GetTType();
                                                          decl_names.add(name);
                                                          decl_types.add(type);
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 210:
          ;
          break;
        default:
          jj_la1[91] = jj_gen;
          break label_9;
        }
        jj_consume_token(210);
              name = null;
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NAME:
        case JAVA:
        case ACTION:
        case GROUPS:
        case OPTION:
        case ACCOUNT:
        case PASSWORD:
        case LANGUAGE:
        case PRIVILEGES:
        case QUOTED_VARIABLE:
        case IDENTIFIER:
          name = ProcArgumentName();
          break;
        default:
          jj_la1[92] = jj_gen;
          ;
        }
        type = GetTType();
                                                            decl_names.add(name);
                                                            decl_types.add(type);
      }
      break;
    default:
      jj_la1[93] = jj_gen;
      ;
    }
  }

// The ' set a = (a * 9), b = concat(b, "aa") ' part of the 'update', 'insert' statement
  final public void AssignmentList(ArrayList assignment_list) throws ParseException {
  String column;
  Expression exp;
    column = ColumnName();
    jj_consume_token(ASSIGNMENT);
    exp = DoExpression();
      assignment_list.add(new Assignment(Variable.resolve(column), exp));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 210:
      jj_consume_token(210);
      AssignmentList(assignment_list);
      break;
    default:
      jj_la1[94] = jj_gen;
      ;
    }
  }

// Parses a list of column declarations.  eg. ' id NUMERIC(5, 20), number VARCHAR(90), ... '
// and also any constraints.
  final public void ColumnDeclarationList(ArrayList column_list, ArrayList constraint_list) throws ParseException {
    jj_consume_token(208);
    ColumnOrConstraintDefinition(column_list, constraint_list);
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 210:
        ;
        break;
      default:
        jj_la1[95] = jj_gen;
        break label_10;
      }
      jj_consume_token(210);
      ColumnOrConstraintDefinition(column_list, constraint_list);
    }
    jj_consume_token(209);
  }

  final public void ColumnOrConstraintDefinition(ArrayList column_list, ArrayList constraint_list) throws ParseException {
  ColumnDef coldef = null;
  ConstraintDef condef = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NAME:
    case JAVA:
    case ACTION:
    case GROUPS:
    case OPTION:
    case ACCOUNT:
    case PASSWORD:
    case LANGUAGE:
    case PRIVILEGES:
    case QUOTED_VARIABLE:
    case IDENTIFIER:
    case DOT_DELIMINATED_REF:
    case QUOTED_DELIMINATED_REF:
      coldef = ColumnDefinition();
                                              column_list.add(coldef);
      break;
    case CHECK:
    case UNIQUE:
    case CONSTRAINT:
    case PRIMARY:
    case FOREIGN:
      condef = TableConstraintDefinition();
                                              constraint_list.add(condef);
      break;
    default:
      jj_la1[96] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public ColumnDef ColumnDefinition() throws ParseException {
  ColumnDef column = new ColumnDef();
  Token t;
  Token col_constraint;
  Expression default_exp;
  String col_name;
    col_name = ColumnName();
                              column.setName(col_name);
    ColumnDataType(column);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SQLDEFAULT:
      jj_consume_token(SQLDEFAULT);
      default_exp = DoExpression();
                                                  column.setDefaultExpression(default_exp);
      break;
    default:
      jj_la1[97] = jj_gen;
      ;
    }
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NULL_LITERAL:
      case UNIQUE:
      case PRIMARY:
      case NOT:
        ;
        break;
      default:
        jj_la1[98] = jj_gen;
        break label_11;
      }
      ColumnConstraint(column);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INDEX_NONE:
    case INDEX_BLIST:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INDEX_BLIST:
        t = jj_consume_token(INDEX_BLIST);
        break;
      case INDEX_NONE:
        t = jj_consume_token(INDEX_NONE);
        break;
      default:
        jj_la1[99] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                             column.setIndex(t);
      break;
    default:
      jj_la1[100] = jj_gen;
      ;
    }
    {if (true) return column;}
    throw new Error("Missing return statement in function");
  }

// Constraint on a column, eg. 'NOT NULL', 'NULL', 'PRIMARY KEY', 'UNIQUE', etc.
  final public void ColumnConstraint(ColumnDef column) throws ParseException {
  Token t;
  String table_name;
  ArrayList col_list = new ArrayList();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
      jj_consume_token(NULL_LITERAL);
                                column.addConstraint("NOT NULL");
      break;
    case NULL_LITERAL:
      jj_consume_token(NULL_LITERAL);
                         column.addConstraint("NULL");
      break;
    case PRIMARY:
      jj_consume_token(PRIMARY);
      jj_consume_token(KEY);
                          column.addConstraint("PRIMARY");
      break;
    case UNIQUE:
      jj_consume_token(UNIQUE);
                   column.addConstraint("UNIQUE");
      break;
    default:
      jj_la1[101] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public int GetCollateStrength() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PRIMARY_STRENGTH:
      jj_consume_token(PRIMARY_STRENGTH);
                              {if (true) return java.text.Collator.PRIMARY;}
      break;
    case SECONDARY_STRENGTH:
      jj_consume_token(SECONDARY_STRENGTH);
                              {if (true) return java.text.Collator.SECONDARY;}
      break;
    case TERTIARY_STRENGTH:
      jj_consume_token(TERTIARY_STRENGTH);
                              {if (true) return java.text.Collator.TERTIARY;}
      break;
    case IDENTICAL_STRENGTH:
      jj_consume_token(IDENTICAL_STRENGTH);
                              {if (true) return java.text.Collator.IDENTICAL;}
      break;
    default:
      jj_la1[102] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public int GetCollateDecomposition() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NO_DECOMPOSITION:
      jj_consume_token(NO_DECOMPOSITION);
                                  {if (true) return java.text.Collator.NO_DECOMPOSITION;}
      break;
    case CANONICAL_DECOMPOSITION:
      jj_consume_token(CANONICAL_DECOMPOSITION);
                                  {if (true) return java.text.Collator.CANONICAL_DECOMPOSITION;}
      break;
    case FULL_DECOMPOSITION:
      jj_consume_token(FULL_DECOMPOSITION);
                                  {if (true) return java.text.Collator.FULL_DECOMPOSITION;}
      break;
    default:
      jj_la1[103] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public int GetStringSQLType() throws ParseException {
    if (jj_2_2(2)) {
      jj_consume_token(CHARACTER);
      jj_consume_token(VARYING);
                                             {if (true) return SQLTypes.VARCHAR;}
    } else if (jj_2_3(3)) {
      jj_consume_token(LONG);
      jj_consume_token(CHARACTER);
      jj_consume_token(VARYING);
                                                    {if (true) return SQLTypes.LONGVARCHAR;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TEXT:
      case STRING:
      case LONGVARCHAR:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TEXT:
          jj_consume_token(TEXT);
          break;
        case STRING:
          jj_consume_token(STRING);
          break;
        case LONGVARCHAR:
          jj_consume_token(LONGVARCHAR);
          break;
        default:
          jj_la1[104] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                                            {if (true) return SQLTypes.LONGVARCHAR;}
        break;
      case CHARACTER:
      case CHAR:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CHAR:
          jj_consume_token(CHAR);
          break;
        case CHARACTER:
          jj_consume_token(CHARACTER);
          break;
        default:
          jj_la1[105] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                               {if (true) return SQLTypes.CHAR;}
        break;
      case VARCHAR:
        jj_consume_token(VARCHAR);
                {if (true) return SQLTypes.VARCHAR;}
        break;
      case CLOB:
        jj_consume_token(CLOB);
             {if (true) return SQLTypes.CLOB;}
        break;
      default:
        jj_la1[106] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public int GetNumericSQLType() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INT:
    case INTEGER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INT:
        jj_consume_token(INT);
        break;
      case INTEGER:
        jj_consume_token(INTEGER);
        break;
      default:
        jj_la1[107] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                            {if (true) return SQLTypes.INTEGER;}
      break;
    case TINYINT:
      jj_consume_token(TINYINT);
                {if (true) return SQLTypes.TINYINT;}
      break;
    case SMALLINT:
      jj_consume_token(SMALLINT);
                 {if (true) return SQLTypes.SMALLINT;}
      break;
    case BIGINT:
      jj_consume_token(BIGINT);
               {if (true) return SQLTypes.BIGINT;}
      break;
    case FLOAT:
      jj_consume_token(FLOAT);
              {if (true) return SQLTypes.FLOAT;}
      break;
    case REAL:
      jj_consume_token(REAL);
             {if (true) return SQLTypes.REAL;}
      break;
    case DOUBLE:
      jj_consume_token(DOUBLE);
               {if (true) return SQLTypes.DOUBLE;}
      break;
    case NUMERIC:
      jj_consume_token(NUMERIC);
                {if (true) return SQLTypes.NUMERIC;}
      break;
    case DECIMAL:
      jj_consume_token(DECIMAL);
                {if (true) return SQLTypes.DECIMAL;}
      break;
    default:
      jj_la1[108] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public int GetBooleanSQLType() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BOOLEAN:
      jj_consume_token(BOOLEAN);
      break;
    case BIT:
      jj_consume_token(BIT);
      break;
    default:
      jj_la1[109] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                          {if (true) return SQLTypes.BOOLEAN;}
    throw new Error("Missing return statement in function");
  }

  final public int GetDateSQLType() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TIMESTAMP:
      jj_consume_token(TIMESTAMP);
                  {if (true) return SQLTypes.TIMESTAMP;}
      break;
    case TIME:
      jj_consume_token(TIME);
             {if (true) return SQLTypes.TIME;}
      break;
    case DATE:
      jj_consume_token(DATE);
             {if (true) return SQLTypes.DATE;}
      break;
    default:
      jj_la1[110] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public int GetBinarySQLType() throws ParseException {
    if (jj_2_4(2)) {
      jj_consume_token(BINARY);
      jj_consume_token(VARYING);
                                          {if (true) return SQLTypes.VARBINARY;}
    } else if (jj_2_5(3)) {
      jj_consume_token(LONG);
      jj_consume_token(BINARY);
      jj_consume_token(VARYING);
                                                 {if (true) return SQLTypes.LONGVARBINARY;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LONGVARBINARY:
        jj_consume_token(LONGVARBINARY);
                      {if (true) return SQLTypes.LONGVARBINARY;}
        break;
      case VARBINARY:
        jj_consume_token(VARBINARY);
                  {if (true) return SQLTypes.VARBINARY;}
        break;
      case BINARY:
        jj_consume_token(BINARY);
               {if (true) return SQLTypes.BINARY;}
        break;
      case BLOB:
        jj_consume_token(BLOB);
             {if (true) return SQLTypes.BLOB;}
        break;
      default:
        jj_la1[111] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

// Parses an SQL type and forms a TType object.  For example, "CHAR(500)" is
// parsed to a TStringType with a maximum size of 500 and lexicographical
// collation.
  final public TType GetTType() throws ParseException {
  Token t;
  int data_type;
  int size = -1;
  int scale = -1;
  Token class_tok = null;
  int strength = -1;
  int decomposition = -1;
  String loc = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case JAVA_OBJECT:
      jj_consume_token(JAVA_OBJECT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 208:
        jj_consume_token(208);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DOT_DELIMINATED_REF:
          class_tok = jj_consume_token(DOT_DELIMINATED_REF);
          break;
        case JAVA_OBJECT_ARRAY_REF:
          class_tok = jj_consume_token(JAVA_OBJECT_ARRAY_REF);
          break;
        default:
          jj_la1[112] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(209);
        break;
      default:
        jj_la1[113] = jj_gen;
        ;
      }
        String class_str = "java.lang.Object";
        if (class_tok != null) {
          class_str = class_tok.image;
        }
        {if (true) return TType.javaObjectType(class_str);}
      break;
    default:
      jj_la1[121] = jj_gen;
      if (jj_2_6(2147483647)) {
        data_type = GetStringSQLType();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 208:
          jj_consume_token(208);
          size = PositiveIntegerConstant();
          jj_consume_token(209);
          break;
        default:
          jj_la1[114] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COLLATE:
          jj_consume_token(COLLATE);
          t = jj_consume_token(STRING_LITERAL);
                                       loc = ((TObject) Util.toParamObject(t, case_insensitive_identifiers)).toString();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case PRIMARY_STRENGTH:
          case SECONDARY_STRENGTH:
          case TERTIARY_STRENGTH:
          case IDENTICAL_STRENGTH:
            strength = GetCollateStrength();
            break;
          default:
            jj_la1[115] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case NO_DECOMPOSITION:
          case CANONICAL_DECOMPOSITION:
          case FULL_DECOMPOSITION:
            decomposition = GetCollateDecomposition();
            break;
          default:
            jj_la1[116] = jj_gen;
            ;
          }
          break;
        default:
          jj_la1[117] = jj_gen;
          ;
        }
        {if (true) return TType.stringType(data_type, size, loc, strength, decomposition);}
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INT:
        case REAL:
        case FLOAT:
        case BIGINT:
        case DOUBLE:
        case NUMERIC:
        case DECIMAL:
        case TINYINT:
        case INTEGER:
        case SMALLINT:
          data_type = GetNumericSQLType();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case 208:
            jj_consume_token(208);
            size = PositiveIntegerConstant();
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case 210:
              jj_consume_token(210);
              scale = PositiveIntegerConstant();
              break;
            default:
              jj_la1[118] = jj_gen;
              ;
            }
            jj_consume_token(209);
            break;
          default:
            jj_la1[119] = jj_gen;
            ;
          }
        {if (true) return TType.numericType(data_type, size, scale);}
          break;
        case BIT:
        case BOOLEAN:
          data_type = GetBooleanSQLType();
        {if (true) return TType.booleanType(data_type);}
          break;
        case DATE:
        case TIME:
        case TIMESTAMP:
          data_type = GetDateSQLType();
        {if (true) return TType.dateType(data_type);}
          break;
        case LONG:
        case BLOB:
        case BINARY:
        case VARBINARY:
        case LONGVARBINARY:
          data_type = GetBinarySQLType();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case 208:
            jj_consume_token(208);
            size = PositiveIntegerConstant();
            jj_consume_token(209);
            break;
          default:
            jj_la1[120] = jj_gen;
            ;
          }
        {if (true) return TType.binaryType(data_type, size);}
          break;
        default:
          jj_la1[122] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

// Data type of a ColumnDef (eg. "varchar(50)", etc)
  final public void ColumnDataType(ColumnDef column) throws ParseException {
  TType type;
    type = GetTType();
                      column.setDataType(type);
  }

  final public ConstraintDef TableConstraintDefinition() throws ParseException {
  ConstraintDef constraint = new ConstraintDef();
  ArrayList column_list = new ArrayList();
  ArrayList column_list2 = new ArrayList();
  String constraint_name;
  String update_rule = "NO ACTION";
  String delete_rule = "NO ACTION";
  Expression expression;
  String name;
  String reference_table;
  Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONSTRAINT:
      jj_consume_token(CONSTRAINT);
      constraint_name = ConstraintName();
                                                        constraint.setName(constraint_name);
      break;
    default:
      jj_la1[123] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PRIMARY:
      jj_consume_token(PRIMARY);
      jj_consume_token(KEY);
      jj_consume_token(208);
      BasicColumnList(column_list);
      jj_consume_token(209);
                                                               constraint.setPrimaryKey(column_list);
      break;
    case UNIQUE:
      jj_consume_token(UNIQUE);
      jj_consume_token(208);
      BasicColumnList(column_list);
      jj_consume_token(209);
                                                             constraint.setUnique(column_list);
      break;
    case CHECK:
      jj_consume_token(CHECK);
      jj_consume_token(208);
      expression = DoExpression();
      jj_consume_token(209);
                                                             constraint.setCheck(expression);
      break;
    case FOREIGN:
      jj_consume_token(FOREIGN);
      jj_consume_token(KEY);
      jj_consume_token(208);
      BasicColumnList(column_list);
      jj_consume_token(209);
      jj_consume_token(REFERENCES);
      reference_table = TableName();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 208:
        jj_consume_token(208);
        BasicColumnList(column_list2);
        jj_consume_token(209);
        break;
      default:
        jj_la1[124] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ON:
        if (jj_2_7(2)) {
          jj_consume_token(ON);
          jj_consume_token(DELETE);
          delete_rule = ReferentialTrigger();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case ON:
            jj_consume_token(ON);
            jj_consume_token(UPDATE);
            update_rule = ReferentialTrigger();
            break;
          default:
            jj_la1[125] = jj_gen;
            ;
          }
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case ON:
            jj_consume_token(ON);
            jj_consume_token(UPDATE);
            update_rule = ReferentialTrigger();
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case ON:
              jj_consume_token(ON);
              jj_consume_token(DELETE);
              delete_rule = ReferentialTrigger();
              break;
            default:
              jj_la1[126] = jj_gen;
              ;
            }
            break;
          default:
            jj_la1[127] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
      default:
        jj_la1[128] = jj_gen;
        ;
      }
          constraint.setForeignKey(reference_table, column_list, column_list2, delete_rule, update_rule);
      break;
    default:
      jj_la1[129] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INITIALLY:
    case DEFERRABLE:
    case NOT:
      ConstraintAttributes(constraint);
      break;
    default:
      jj_la1[130] = jj_gen;
      ;
    }
    {if (true) return constraint;}
    throw new Error("Missing return statement in function");
  }

  final public String ReferentialTrigger() throws ParseException {
  Token t;
  String trigger_str;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NO:
      jj_consume_token(NO);
      jj_consume_token(ACTION);
                                          trigger_str="NO ACTION";
      break;
    case RESTRICT:
      jj_consume_token(RESTRICT);
                                          trigger_str="NO ACTION";
      break;
    case CASCADE:
      jj_consume_token(CASCADE);
                                          trigger_str="CASCADE";
      break;
    default:
      jj_la1[131] = jj_gen;
      if (jj_2_8(2)) {
        jj_consume_token(SET);
        jj_consume_token(NULL_LITERAL);
                                          trigger_str="SET NULL";
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SET:
          jj_consume_token(SET);
          jj_consume_token(SQLDEFAULT);
                                          trigger_str="SET DEFAULT";
          break;
        default:
          jj_la1[132] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    {if (true) return trigger_str;}
    throw new Error("Missing return statement in function");
  }

  final public void ConstraintAttributes(ConstraintDef constraint) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INITIALLY:
      jj_consume_token(INITIALLY);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DEFERRED:
        jj_consume_token(DEFERRED);
                                      constraint.setInitiallyDeferred();
        break;
      case IMMEDIATE:
        jj_consume_token(IMMEDIATE);
        break;
      default:
        jj_la1[133] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DEFERRABLE:
      case NOT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NOT:
          jj_consume_token(NOT);
          jj_consume_token(DEFERRABLE);
                                  constraint.setNotDeferrable();
          break;
        case DEFERRABLE:
          jj_consume_token(DEFERRABLE);
          break;
        default:
          jj_la1[134] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[135] = jj_gen;
        ;
      }
      break;
    case DEFERRABLE:
    case NOT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
        jj_consume_token(DEFERRABLE);
                                constraint.setNotDeferrable();
        break;
      case DEFERRABLE:
        jj_consume_token(DEFERRABLE);
        break;
      default:
        jj_la1[136] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INITIALLY:
        jj_consume_token(INITIALLY);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DEFERRED:
          jj_consume_token(DEFERRED);
                                        constraint.setInitiallyDeferred();
          break;
        case IMMEDIATE:
          jj_consume_token(IMMEDIATE);
          break;
        default:
          jj_la1[137] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[138] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[139] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

// A list of column names
  final public ArrayList BasicColumnList(ArrayList list) throws ParseException {
  String col_name;
    col_name = ColumnName();
                                  list.add(col_name);
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 210:
        ;
        break;
      default:
        jj_la1[140] = jj_gen;
        break label_12;
      }
      jj_consume_token(210);
      col_name = ColumnName();
                                  list.add(col_name);
    }
    {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

// A list of user names
  final public ArrayList UserNameList(ArrayList list) throws ParseException {
  String username;
    username = UserName();
                                list.add(username);
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 210:
        ;
        break;
      default:
        jj_la1[141] = jj_gen;
        break label_13;
      }
      jj_consume_token(210);
      username = UserName();
                                list.add(username);
    }
    {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public void ConditionsExpression(SearchExpression se) throws ParseException {
  Expression exp;
    exp = DoExpression();
    se.setFromExpression(exp);
  }

  final public Expression ExpressionTest() throws ParseException {
  Expression exp;
    exp = DoExpression();
    jj_consume_token(207);
    {if (true) return exp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression DoExpression() throws ParseException {
  Stack stack = new Stack();
  Expression exp = new Expression();
    expression(exp, stack);
    expEnd(exp, stack);
    // Normalize the expression (remove any NOT operators)
    Expression normalized_exp = Util.normalize(exp);
    normalized_exp.copyTextFrom(exp);
    {if (true) return normalized_exp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression DoNonBooleanExpression() throws ParseException {
  Stack stack = new Stack();
  Expression exp = new Expression();
    nonBooleanExpression(exp, stack);
    expEnd(exp, stack);
    {if (true) return exp;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parse an expression.
 */
  final public void expression(Expression exp, Stack stack) throws ParseException {
    Operand(exp, stack);
    label_14:
    while (true) {
      if (jj_2_9(2)) {
        ;
      } else {
        break label_14;
      }
      OpPart(exp, stack);
    }
  }

/**
 * Parses a non-boolean expression.
 */
  final public void nonBooleanExpression(Expression exp, Stack stack) throws ParseException {
    Operand(exp, stack);
    label_15:
    while (true) {
      if (jj_2_10(2)) {
        ;
      } else {
        break label_15;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CONCAT:
        StringOperator(exp, stack);
        break;
      case STAR:
      case DIVIDE:
      case ADD:
      case SUBTRACT:
        NumericOperator(exp, stack);
        break;
      default:
        jj_la1[142] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      Operand(exp, stack);
    }
  }

  final public void OpPart(Expression exp, Stack stack) throws ParseException {
  Token t;
//  SelectStatement select;
//  Expression[] exp_arr;
  Expression regex_expression;
  Object regex_ob;
    if (jj_2_11(3)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASSIGNMENT:
      case EQUALS:
      case GR:
      case LE:
      case GREQ:
      case LEEQ:
      case NOTEQ:
      case IS:
      case LIKE:
      case AND:
      case OR:
      case NOT:
        BooleanOperator(exp, stack);
        break;
      case STAR:
      case DIVIDE:
      case ADD:
      case SUBTRACT:
        NumericOperator(exp, stack);
        break;
      case CONCAT:
        StringOperator(exp, stack);
        break;
      default:
        jj_la1[143] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      Operand(exp, stack);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case REGEX_LITERAL:
      case REGEX:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case REGEX:
          jj_consume_token(REGEX);
                    exp.text().append(" regex ");
                                 expOperator(exp, stack, Operator.get("regex"));
          expression(exp, stack);
          break;
        case REGEX_LITERAL:
          t = jj_consume_token(REGEX_LITERAL);
                          regex_ob = Util.toParamObject(t, case_insensitive_identifiers);
                          exp.text().append(" regex " + regex_ob);
                          expOperator(exp, stack, Operator.get("regex"));
                          exp.addElement(regex_ob);
          break;
        default:
          jj_la1[144] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[145] = jj_gen;
        if (jj_2_12(2)) {
          SubQueryOperator(exp, stack);
          SubQueryExpression(exp, stack);
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case BETWEEN:
          case NOT:
            BetweenPredicate(exp, stack);
            break;
          default:
            jj_la1[146] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
  }

  final public void Operand(Expression exp, Stack stack) throws ParseException {
  Token t, tt;
  FunctionDef f;
  Expression[] exp_list;
  String time_fname;
  boolean negative = false;
  Object param_ob;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 208:
      jj_consume_token(208);
            stack.push(Operator.get("(")); exp.text().append("(");
      expression(exp, stack);
      jj_consume_token(209);
                                     expEndParen(exp, stack); exp.text().append(")");
      break;
    case PARAMETER_REF:
      t = jj_consume_token(PARAMETER_REF);
            Object param_resolve = createSubstitution(t.image);
            exp.addElement(param_resolve);
            exp.text().append('?');
      break;
    default:
      jj_la1[153] = jj_gen;
      if (jj_2_13(2)) {
        jj_consume_token(NOT);
        expOperator(exp, stack, Operator.get("not"));
        exp.text().append(" not ");
        Operand(exp, stack);
      } else if (jj_2_14(3)) {
        f = Function();
            exp.addElement(f); exp.text().append(f);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DATE:
        case TIME:
        case TIMESTAMP:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case DATE:
            tt = jj_consume_token(DATE);
                    time_fname="DATEOB";
            break;
          case TIME:
            tt = jj_consume_token(TIME);
                    time_fname="TIMEOB";
            break;
          case TIMESTAMP:
            tt = jj_consume_token(TIMESTAMP);
                         time_fname="TIMESTAMPOB";
            break;
          default:
            jj_la1[147] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          t = jj_consume_token(STRING_LITERAL);
      Object param_ob1 = Util.toParamObject(t, case_insensitive_identifiers);
      exp_list = new Expression[] { new Expression(param_ob1) };
      f = Util.resolveFunctionName(time_fname, exp_list);
      exp.addElement(f);
      exp.text().append(tt.image).append(" ").append(t.image);
          break;
        case CURRENT_TIME:
        case CURRENT_DATE:
        case CURRENT_TIMESTAMP:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case CURRENT_TIMESTAMP:
            tt = jj_consume_token(CURRENT_TIMESTAMP);
                                 time_fname="TIMESTAMPOB";
            break;
          case CURRENT_TIME:
            tt = jj_consume_token(CURRENT_TIME);
                                 time_fname="TIMEOB";
            break;
          case CURRENT_DATE:
            tt = jj_consume_token(CURRENT_DATE);
                                 time_fname="DATEOB";
            break;
          default:
            jj_la1[148] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
      exp_list = new Expression[0];
      f = Util.resolveFunctionName(time_fname, exp_list);
      exp.addElement(f);
      exp.text().append(tt.image);
          break;
        case NEW:
          jj_consume_token(NEW);
          f = JavaInstantiation();
            exp.addElement(f); exp.text().append(f);
          break;
        case BOOLEAN_LITERAL:
        case NULL_LITERAL:
        case STRING_LITERAL:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case STRING_LITERAL:
            t = jj_consume_token(STRING_LITERAL);
            break;
          case BOOLEAN_LITERAL:
            t = jj_consume_token(BOOLEAN_LITERAL);
            break;
          case NULL_LITERAL:
            t = jj_consume_token(NULL_LITERAL);
            break;
          default:
            jj_la1[149] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          param_ob = Util.toParamObject(t, case_insensitive_identifiers);
          exp.addElement(param_ob);
          exp.text().append(t.image);
          break;
        case ADD:
        case SUBTRACT:
        case NAME:
        case JAVA:
        case ACTION:
        case GROUPS:
        case OPTION:
        case ACCOUNT:
        case PASSWORD:
        case LANGUAGE:
        case PRIVILEGES:
        case NUMBER_LITERAL:
        case QUOTED_VARIABLE:
        case IDENTIFIER:
        case DOT_DELIMINATED_REF:
        case QUOTED_DELIMINATED_REF:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case ADD:
          case SUBTRACT:
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case ADD:
              jj_consume_token(ADD);
              break;
            case SUBTRACT:
              jj_consume_token(SUBTRACT);
                               negative = true;
              break;
            default:
              jj_la1[150] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
          default:
            jj_la1[151] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case NUMBER_LITERAL:
            t = jj_consume_token(NUMBER_LITERAL);
            break;
          case QUOTED_VARIABLE:
            t = jj_consume_token(QUOTED_VARIABLE);
            break;
          case DOT_DELIMINATED_REF:
            t = jj_consume_token(DOT_DELIMINATED_REF);
            break;
          case QUOTED_DELIMINATED_REF:
            t = jj_consume_token(QUOTED_DELIMINATED_REF);
            break;
          case NAME:
          case JAVA:
          case ACTION:
          case GROUPS:
          case OPTION:
          case ACCOUNT:
          case PASSWORD:
          case LANGUAGE:
          case PRIVILEGES:
          case IDENTIFIER:
            t = SQLIdentifier();
            break;
          default:
            jj_la1[152] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          if (t.kind == SQLConstants.NUMBER_LITERAL) {
            param_ob = Util.parseNumberToken(t, negative);
            exp.addElement(param_ob);
          }
          else {
            param_ob = Util.toParamObject(t, case_insensitive_identifiers);
            if (negative) {
              exp.addElement(Util.zeroNumber());
              exp.addElement(param_ob);
              exp.addElement(Operator.get("-"));
            }
            else {
              exp.addElement(param_ob);
            }
          }
          if (negative) {
            exp.text().append('-');
          }
          exp.text().append(t.image);
          break;
        default:
          jj_la1[154] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

  final public void SubQueryExpression(Expression exp, Stack stack) throws ParseException {
  TableSelectExpression select;
  Expression[] exp_arr;
    jj_consume_token(208);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
      select = GetTableSelectExpression();
        exp.addElement(select);
        exp.text().append(" [SELECT]");
      break;
    default:
      jj_la1[155] = jj_gen;
      exp_arr = ExpressionList();
        exp.addElement(Util.toArrayParamObject(exp_arr));
        exp.text().append(" (" + Util.expressionListToString(exp_arr) + ")");
    }
    jj_consume_token(209);
  }

// Parses a simple positive integer constant.
  final public int PositiveIntegerConstant() throws ParseException {
  Token t;
    t = jj_consume_token(NUMBER_LITERAL);
    int val = Integer.parseInt(t.image);
    if (val < 0) generateParseException();
    {if (true) return val;}
    throw new Error("Missing return statement in function");
  }

  final public void SubQueryOperator(Expression exp, Stack stack) throws ParseException {
  Token t;
  String op_string;
  String query_type = "SINGLE";
  Operator op;
    if (jj_2_15(2)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IN:
        jj_consume_token(IN);
                              op = Operator.get("IN");
        break;
      case NOT:
        jj_consume_token(NOT);
        jj_consume_token(IN);
                                    op = Operator.get("NOT IN");
        break;
      default:
        jj_la1[156] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASSIGNMENT:
      case EQUALS:
      case GR:
      case LE:
      case GREQ:
      case LEEQ:
      case NOTEQ:
        op_string = GetSubQueryBooleanOperator();
                                                    op = Operator.get(op_string);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALL:
        case ANY:
        case SOME:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case ANY:
            t = jj_consume_token(ANY);
            break;
          case ALL:
            t = jj_consume_token(ALL);
            break;
          case SOME:
            t = jj_consume_token(SOME);
            break;
          default:
            jj_la1[157] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
                                         query_type=t.image;
          break;
        default:
          jj_la1[158] = jj_gen;
          ;
        }
      op = op.getSubQueryForm(query_type);
        break;
      default:
        jj_la1[159] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    expOperator(exp, stack, op);
    exp.text().append(" " + op + " ");
  }

  final public void BetweenPredicate(Expression exp, Stack stack) throws ParseException {
  boolean not_s = false;
  Expression exp1, exp2;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
              not_s = true;
      break;
    default:
      jj_la1[160] = jj_gen;
      ;
    }
    jj_consume_token(BETWEEN);
    exp1 = DoNonBooleanExpression();
    jj_consume_token(AND);
    exp2 = DoNonBooleanExpression();
    // Flush the operator stack to precedence 8
    flushOperatorStack(exp, stack, 8);
    // Get the end expression
    Expression end_exp = exp.getEndExpression();
    if (not_s) {
      exp.concat(exp1);
      exp.addElement(Operator.get("<"));
      exp.concat(end_exp);
      exp.concat(exp2);
      exp.addElement(Operator.get(">"));
      exp.addElement(Operator.get("or"));
      exp.text().append(" not between ");
    }
    else {
      exp.concat(exp1);
      exp.addElement(Operator.get(">="));
      exp.concat(end_exp);
      exp.concat(exp2);
      exp.addElement(Operator.get("<="));
      exp.addElement(Operator.get("and"));
      exp.text().append(" between ");
    }
    exp.text().append(exp1.text().toString());
    exp.text().append(" and ");
    exp.text().append(exp2.text().toString());
  }

  final public void BooleanOperator(Expression exp, Stack stack) throws ParseException {
  Token t;
  String op_string;
  Operator op;
    op_string = GetBooleanOperator();
                                         op = Operator.get(op_string);
    expOperator(exp, stack, op);
    exp.text().append(" " + op + " ");
  }

  final public void NumericOperator(Expression exp, Stack stack) throws ParseException {
  Token t;
  String op_string;
  Operator op;
    op_string = GetNumericOperator();
                                         op = Operator.get(op_string);
    expOperator(exp, stack, op);
    exp.text().append(" " + op + " ");
  }

  final public void StringOperator(Expression exp, Stack stack) throws ParseException {
  Token t;
  String op_string;
  Operator op;
    op_string = GetStringOperator();
                                        op = Operator.get(op_string);
    expOperator(exp, stack, op);
    exp.text().append(" " + op + " ");
  }

  final public String GetBooleanOperator() throws ParseException {
  Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASSIGNMENT:
      t = jj_consume_token(ASSIGNMENT);
      break;
    case EQUALS:
      t = jj_consume_token(EQUALS);
      break;
    case GR:
      t = jj_consume_token(GR);
      break;
    case LE:
      t = jj_consume_token(LE);
      break;
    case GREQ:
      t = jj_consume_token(GREQ);
      break;
    case LEEQ:
      t = jj_consume_token(LEEQ);
      break;
    case NOTEQ:
      t = jj_consume_token(NOTEQ);
      break;
    default:
      jj_la1[161] = jj_gen;
      if (jj_2_16(2)) {
        jj_consume_token(IS);
        jj_consume_token(NOT);
                                {if (true) return "IS NOT";}
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IS:
          t = jj_consume_token(IS);
          break;
        case LIKE:
          t = jj_consume_token(LIKE);
          break;
        case NOT:
          jj_consume_token(NOT);
          jj_consume_token(LIKE);
                                {if (true) return "NOT LIKE";}
          break;
        case AND:
          t = jj_consume_token(AND);
          break;
        case OR:
          t = jj_consume_token(OR);
          break;
        default:
          jj_la1[162] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    {if (true) return t.image;}
    throw new Error("Missing return statement in function");
  }

  final public String GetSubQueryBooleanOperator() throws ParseException {
  Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASSIGNMENT:
      t = jj_consume_token(ASSIGNMENT);
      break;
    case EQUALS:
      t = jj_consume_token(EQUALS);
      break;
    case GR:
      t = jj_consume_token(GR);
      break;
    case LE:
      t = jj_consume_token(LE);
      break;
    case GREQ:
      t = jj_consume_token(GREQ);
      break;
    case LEEQ:
      t = jj_consume_token(LEEQ);
      break;
    case NOTEQ:
      t = jj_consume_token(NOTEQ);
      break;
    default:
      jj_la1[163] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return t.image;}
    throw new Error("Missing return statement in function");
  }

  final public String GetNumericOperator() throws ParseException {
  Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIVIDE:
      t = jj_consume_token(DIVIDE);
      break;
    case ADD:
      t = jj_consume_token(ADD);
      break;
    case SUBTRACT:
      t = jj_consume_token(SUBTRACT);
      break;
    case STAR:
      t = jj_consume_token(STAR);
      break;
    default:
      jj_la1[164] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
     {if (true) return t.image;}
    throw new Error("Missing return statement in function");
  }

  final public String GetStringOperator() throws ParseException {
  Token t;
    t = jj_consume_token(CONCAT);
     {if (true) return t.image;}
    throw new Error("Missing return statement in function");
  }

  final public Token FunctionIdentifier() throws ParseException {
  Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF:
      t = jj_consume_token(IF);
      break;
    case USER:
      t = jj_consume_token(USER);
      break;
    case IDENTIFIER:
      t = jj_consume_token(IDENTIFIER);
      break;
    default:
      jj_la1[165] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public FunctionDef Function() throws ParseException {
  Token t, t2 = null, t3 = null;
  FunctionDef f;
  Expression exp1, exp2;
  Expression[] exp_list;
  TType cast_type;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COUNT:
      t = jj_consume_token(COUNT);
      jj_consume_token(208);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DISTINCT:
        jj_consume_token(DISTINCT);
                                       t.image="distinct_count";
        break;
      default:
        jj_la1[166] = jj_gen;
        ;
      }
      exp_list = FunctionParams();
      jj_consume_token(209);
      break;
    case TRIM:
      t = jj_consume_token(TRIM);
      jj_consume_token(208);
      if (jj_2_17(3)) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BOTH:
        case LEADING:
        case TRAILING:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LEADING:
            t2 = jj_consume_token(LEADING);
            break;
          case BOTH:
            t2 = jj_consume_token(BOTH);
            break;
          case TRAILING:
            t2 = jj_consume_token(TRAILING);
            break;
          default:
            jj_la1[167] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          jj_la1[168] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STRING_LITERAL:
          t3 = jj_consume_token(STRING_LITERAL);
          break;
        default:
          jj_la1[169] = jj_gen;
          ;
        }
        jj_consume_token(FROM);
      } else {
        ;
      }
      exp1 = DoExpression();
      jj_consume_token(209);
                          exp_list = new Expression[3];
                          String ttype = t2 == null ? "both" : t2.image.toLowerCase();
                          Object str_char = t3 == null ? TObject.stringVal(" ") :
                                                         Util.toParamObject(t3, case_insensitive_identifiers);
                          exp_list[0] = new Expression(TObject.stringVal(ttype));
                          exp_list[0].text().append("'" + ttype + "'");
                          exp_list[1] = new Expression(str_char);
                          exp_list[1].text().append("'" + str_char + "'");
                          exp_list[2] = exp1;
                          {if (true) return Util.resolveFunctionName("sql_trim", exp_list);}
      break;
    case CAST:
      t = jj_consume_token(CAST);
      jj_consume_token(208);
      exp1 = DoExpression();
      jj_consume_token(AS);
      cast_type = GetTType();
      jj_consume_token(209);
                          exp_list = new Expression[2];
                          String enc_form = TType.asEncodedString(cast_type);
                          exp_list[0] = exp1;
                          exp_list[1] = new Expression(TObject.stringVal(enc_form));
                          exp_list[1].text().append("'" + enc_form + "'");
                          {if (true) return Util.resolveFunctionName("sql_cast", exp_list);}
      break;
    case IF:
    case USER:
    case IDENTIFIER:
      t = FunctionIdentifier();
      jj_consume_token(208);
      exp_list = FunctionParams();
      jj_consume_token(209);
      break;
    default:
      jj_la1[170] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return Util.resolveFunctionName(t.image, exp_list);}
    throw new Error("Missing return statement in function");
  }

// An instantiation of a java object.  For example, 'java.awt.Point(40, 30)'
  final public FunctionDef JavaInstantiation() throws ParseException {
  Token t;
  Expression[] args;
    // PENDING: Handling arrays (eg. 'java.lang.String[] { 'Tobias', 'Downer' }' or 'double[] { 25, 2, 75, 26 }' )
      t = jj_consume_token(DOT_DELIMINATED_REF);
    jj_consume_token(208);
    args = ExpressionList();
    jj_consume_token(209);
    Expression[] comp_args = new Expression[args.length + 1];
    System.arraycopy(args, 0, comp_args, 1, args.length);
    comp_args[0] = new Expression(TObject.stringVal(t.image));
    comp_args[0].text().append("'" + t.image + "'");
    {if (true) return Util.resolveFunctionName("_new_JavaObject", comp_args);}
    throw new Error("Missing return statement in function");
  }

// Parameters for a function
  final public Expression[] FunctionParams() throws ParseException {
  Expression[] exp_list;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STAR:
      jj_consume_token(STAR);
             exp_list = FunctionFactory.GLOB_LIST;
      break;
    default:
      jj_la1[171] = jj_gen;
      exp_list = ExpressionList();
    }
    {if (true) return exp_list;}
    throw new Error("Missing return statement in function");
  }

  final public Expression[] ExpressionList() throws ParseException {
  ArrayList list = new ArrayList();
  Expression e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ADD:
    case SUBTRACT:
    case BOOLEAN_LITERAL:
    case NULL_LITERAL:
    case IF:
    case NEW:
    case TRIM:
    case USER:
    case CAST:
    case NAME:
    case JAVA:
    case COUNT:
    case ACTION:
    case GROUPS:
    case OPTION:
    case ACCOUNT:
    case PASSWORD:
    case LANGUAGE:
    case PRIVILEGES:
    case DATE:
    case TIME:
    case TIMESTAMP:
    case CURRENT_TIME:
    case CURRENT_DATE:
    case CURRENT_TIMESTAMP:
    case NOT:
    case NUMBER_LITERAL:
    case STRING_LITERAL:
    case QUOTED_VARIABLE:
    case IDENTIFIER:
    case DOT_DELIMINATED_REF:
    case QUOTED_DELIMINATED_REF:
    case PARAMETER_REF:
    case 208:
      e = DoExpression();
                         list.add(e);
      label_16:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 210:
          ;
          break;
        default:
          jj_la1[172] = jj_gen;
          break label_16;
        }
        jj_consume_token(210);
        e = DoExpression();
                               list.add(e);
      }
      break;
    default:
      jj_la1[173] = jj_gen;
      ;
    }
    {if (true) return (Expression[]) list.toArray(new Expression[list.size()]);}
    throw new Error("Missing return statement in function");
  }

  final public String GetComposite() throws ParseException {
  Token name;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNION:
      name = jj_consume_token(UNION);
      break;
    case INTERSECT:
      name = jj_consume_token(INTERSECT);
      break;
    case EXCEPT:
      name = jj_consume_token(EXCEPT);
      break;
    default:
      jj_la1[174] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return name.image;}
    throw new Error("Missing return statement in function");
  }

  final public String TableName() throws ParseException {
  Token name;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_VARIABLE:
      name = jj_consume_token(QUOTED_VARIABLE);
      break;
    case NAME:
    case JAVA:
    case ACTION:
    case GROUPS:
    case OPTION:
    case ACCOUNT:
    case PASSWORD:
    case LANGUAGE:
    case PRIVILEGES:
    case IDENTIFIER:
      name = SQLIdentifier();
      break;
    case OLD:
      name = jj_consume_token(OLD);
      break;
    case NEW:
      name = jj_consume_token(NEW);
      break;
    case DOT_DELIMINATED_REF:
      name = jj_consume_token(DOT_DELIMINATED_REF);
      break;
    case QUOTED_DELIMINATED_REF:
      name = jj_consume_token(QUOTED_DELIMINATED_REF);
      break;
    default:
      jj_la1[175] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return caseCheck(Util.asNonQuotedRef(name));}
    throw new Error("Missing return statement in function");
  }

  final public String SequenceName() throws ParseException {
  Token name;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_VARIABLE:
      name = jj_consume_token(QUOTED_VARIABLE);
      break;
    case NAME:
    case JAVA:
    case ACTION:
    case GROUPS:
    case OPTION:
    case ACCOUNT:
    case PASSWORD:
    case LANGUAGE:
    case PRIVILEGES:
    case IDENTIFIER:
      name = SQLIdentifier();
      break;
    case DOT_DELIMINATED_REF:
      name = jj_consume_token(DOT_DELIMINATED_REF);
      break;
    case QUOTED_DELIMINATED_REF:
      name = jj_consume_token(QUOTED_DELIMINATED_REF);
      break;
    default:
      jj_la1[176] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return caseCheck(Util.asNonQuotedRef(name));}
    throw new Error("Missing return statement in function");
  }

  final public String TriggerName() throws ParseException {
  Token name;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_VARIABLE:
      name = jj_consume_token(QUOTED_VARIABLE);
      break;
    case NAME:
    case JAVA:
    case ACTION:
    case GROUPS:
    case OPTION:
    case ACCOUNT:
    case PASSWORD:
    case LANGUAGE:
    case PRIVILEGES:
    case IDENTIFIER:
      name = SQLIdentifier();
      break;
    default:
      jj_la1[177] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return caseCheck(Util.asNonQuotedRef(name));}
    throw new Error("Missing return statement in function");
  }

  final public String IndexName() throws ParseException {
  Token name;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_VARIABLE:
      name = jj_consume_token(QUOTED_VARIABLE);
      break;
    case NAME:
    case JAVA:
    case ACTION:
    case GROUPS:
    case OPTION:
    case ACCOUNT:
    case PASSWORD:
    case LANGUAGE:
    case PRIVILEGES:
    case IDENTIFIER:
      name = SQLIdentifier();
      break;
    default:
      jj_la1[178] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return caseCheck(Util.asNonQuotedRef(name));}
    throw new Error("Missing return statement in function");
  }

// A username
  final public String UserName() throws ParseException {
  Token name;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_VARIABLE:
      name = jj_consume_token(QUOTED_VARIABLE);
      break;
    case IDENTIFIER:
      name = jj_consume_token(IDENTIFIER);
      break;
    case PUBLIC:
      name = jj_consume_token(PUBLIC);
      break;
    default:
      jj_la1[179] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return caseCheck(Util.asNonQuotedRef(name));}
    throw new Error("Missing return statement in function");
  }

// Name of a schema
  final public String SchemaName() throws ParseException {
  Token name;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_VARIABLE:
      name = jj_consume_token(QUOTED_VARIABLE);
      break;
    case NAME:
    case JAVA:
    case ACTION:
    case GROUPS:
    case OPTION:
    case ACCOUNT:
    case PASSWORD:
    case LANGUAGE:
    case PRIVILEGES:
    case IDENTIFIER:
      name = SQLIdentifier();
      break;
    default:
      jj_la1[180] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return caseCheck(Util.asNonQuotedRef(name));}
    throw new Error("Missing return statement in function");
  }

// Name of a constraint name
  final public String ConstraintName() throws ParseException {
  Token name;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_VARIABLE:
      name = jj_consume_token(QUOTED_VARIABLE);
      break;
    case NAME:
    case JAVA:
    case ACTION:
    case GROUPS:
    case OPTION:
    case ACCOUNT:
    case PASSWORD:
    case LANGUAGE:
    case PRIVILEGES:
    case IDENTIFIER:
      name = SQLIdentifier();
      break;
    default:
      jj_la1[181] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return caseCheck(Util.asNonQuotedRef(name));}
    throw new Error("Missing return statement in function");
  }

// Parses a column name  
  final public String ColumnName() throws ParseException {
  Token name;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_VARIABLE:
      name = jj_consume_token(QUOTED_VARIABLE);
      break;
    case NAME:
    case JAVA:
    case ACTION:
    case GROUPS:
    case OPTION:
    case ACCOUNT:
    case PASSWORD:
    case LANGUAGE:
    case PRIVILEGES:
    case IDENTIFIER:
      name = SQLIdentifier();
      break;
    case DOT_DELIMINATED_REF:
      name = jj_consume_token(DOT_DELIMINATED_REF);
      break;
    case QUOTED_DELIMINATED_REF:
      name = jj_consume_token(QUOTED_DELIMINATED_REF);
      break;
    default:
      jj_la1[182] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return caseCheck(Util.asNonQuotedRef(name));}
    throw new Error("Missing return statement in function");
  }

// Parses a column name as a Variable object  
  final public Variable ColumnNameVariable() throws ParseException {
  Token name;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_VARIABLE:
      name = jj_consume_token(QUOTED_VARIABLE);
      break;
    case NAME:
    case JAVA:
    case ACTION:
    case GROUPS:
    case OPTION:
    case ACCOUNT:
    case PASSWORD:
    case LANGUAGE:
    case PRIVILEGES:
    case IDENTIFIER:
      name = SQLIdentifier();
      break;
    case DOT_DELIMINATED_REF:
      name = jj_consume_token(DOT_DELIMINATED_REF);
      break;
    case QUOTED_DELIMINATED_REF:
      name = jj_consume_token(QUOTED_DELIMINATED_REF);
      break;
    default:
      jj_la1[183] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return (Variable) Util.toParamObject(name, case_insensitive_identifiers);}
    throw new Error("Missing return statement in function");
  }

// Parses an aliased table name  
  final public String TableAliasName() throws ParseException {
  Token name;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_VARIABLE:
      name = jj_consume_token(QUOTED_VARIABLE);
      break;
    case NAME:
    case JAVA:
    case ACTION:
    case GROUPS:
    case OPTION:
    case ACCOUNT:
    case PASSWORD:
    case LANGUAGE:
    case PRIVILEGES:
    case IDENTIFIER:
      name = SQLIdentifier();
      break;
    default:
      jj_la1[184] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return caseCheck(Util.asNonQuotedRef(name));}
    throw new Error("Missing return statement in function");
  }

// Parses a procedure name  
  final public String ProcedureName() throws ParseException {
  Token name;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_VARIABLE:
      name = jj_consume_token(QUOTED_VARIABLE);
      break;
    case NAME:
    case JAVA:
    case ACTION:
    case GROUPS:
    case OPTION:
    case ACCOUNT:
    case PASSWORD:
    case LANGUAGE:
    case PRIVILEGES:
    case IDENTIFIER:
      name = SQLIdentifier();
      break;
    case DOT_DELIMINATED_REF:
      name = jj_consume_token(DOT_DELIMINATED_REF);
      break;
    case QUOTED_DELIMINATED_REF:
      name = jj_consume_token(QUOTED_DELIMINATED_REF);
      break;
    default:
      jj_la1[185] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return caseCheck(Util.asNonQuotedRef(name));}
    throw new Error("Missing return statement in function");
  }

// Parses a function name
  final public String FunctionName() throws ParseException {
  Token name;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_VARIABLE:
      name = jj_consume_token(QUOTED_VARIABLE);
      break;
    case NAME:
    case JAVA:
    case ACTION:
    case GROUPS:
    case OPTION:
    case ACCOUNT:
    case PASSWORD:
    case LANGUAGE:
    case PRIVILEGES:
    case IDENTIFIER:
      name = SQLIdentifier();
      break;
    case DOT_DELIMINATED_REF:
      name = jj_consume_token(DOT_DELIMINATED_REF);
      break;
    case QUOTED_DELIMINATED_REF:
      name = jj_consume_token(QUOTED_DELIMINATED_REF);
      break;
    default:
      jj_la1[186] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return caseCheck(Util.asNonQuotedRef(name));}
    throw new Error("Missing return statement in function");
  }

// Parses the name of an argument in a procedure/function declaration
  final public String ProcArgumentName() throws ParseException {
  Token name;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_VARIABLE:
      name = jj_consume_token(QUOTED_VARIABLE);
      break;
    case NAME:
    case JAVA:
    case ACTION:
    case GROUPS:
    case OPTION:
    case ACCOUNT:
    case PASSWORD:
    case LANGUAGE:
    case PRIVILEGES:
    case IDENTIFIER:
      name = SQLIdentifier();
      break;
    default:
      jj_la1[187] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return caseCheck(Util.asNonQuotedRef(name));}
    throw new Error("Missing return statement in function");
  }

// Parses an SQL identifier
  final public Token SQLIdentifier() throws ParseException {
  Token name;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      name = jj_consume_token(IDENTIFIER);
      break;
    case OPTION:
      name = jj_consume_token(OPTION);
      break;
    case ACCOUNT:
      name = jj_consume_token(ACCOUNT);
      break;
    case PASSWORD:
      name = jj_consume_token(PASSWORD);
      break;
    case PRIVILEGES:
      name = jj_consume_token(PRIVILEGES);
      break;
    case GROUPS:
      name = jj_consume_token(GROUPS);
      break;
    case LANGUAGE:
      name = jj_consume_token(LANGUAGE);
      break;
    case NAME:
      name = jj_consume_token(NAME);
      break;
    case JAVA:
      name = jj_consume_token(JAVA);
      break;
    case ACTION:
      name = jj_consume_token(ACTION);
      break;
    default:
      jj_la1[188] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return name;}
    throw new Error("Missing return statement in function");
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_1();
    jj_save(0, xla);
    return retval;
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_2();
    jj_save(1, xla);
    return retval;
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_3();
    jj_save(2, xla);
    return retval;
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_4();
    jj_save(3, xla);
    return retval;
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_5();
    jj_save(4, xla);
    return retval;
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_6();
    jj_save(5, xla);
    return retval;
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_7();
    jj_save(6, xla);
    return retval;
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_8();
    jj_save(7, xla);
    return retval;
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_9();
    jj_save(8, xla);
    return retval;
  }

  final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_10();
    jj_save(9, xla);
    return retval;
  }

  final private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_11();
    jj_save(10, xla);
    return retval;
  }

  final private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_12();
    jj_save(11, xla);
    return retval;
  }

  final private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_13();
    jj_save(12, xla);
    return retval;
  }

  final private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_14();
    jj_save(13, xla);
    return retval;
  }

  final private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_15();
    jj_save(14, xla);
    return retval;
  }

  final private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_16();
    jj_save(15, xla);
    return retval;
  }

  final private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_17();
    jj_save(16, xla);
    return retval;
  }

  final private boolean jj_3R_137() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_138()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_36() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_61()) {
    jj_scanpos = xsp;
    if (jj_3R_62()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_130() {
    if (jj_scan_token(PASSWORD)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_120() {
    if (jj_scan_token(SOME)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_55() {
    if (jj_scan_token(TRAILING)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_20() {
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_136() {
    if (jj_scan_token(ACTION)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_19() {
    if (jj_3R_38()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_11() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_22()) {
    jj_scanpos = xsp;
    if (jj_3R_23()) {
    jj_scanpos = xsp;
    if (jj_3R_24()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_21()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_122() {
    if (jj_3R_137()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_90() {
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_18() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_11()) {
    jj_scanpos = xsp;
    if (jj_3R_36()) {
    jj_scanpos = xsp;
    if (jj_3_12()) {
    jj_scanpos = xsp;
    if (jj_3R_37()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_63() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_90()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(BETWEEN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_91()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_121() {
    if (jj_scan_token(STAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_29() {
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(IN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_119() {
    if (jj_scan_token(ALL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_28() {
    if (jj_scan_token(IN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_87() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_121()) {
    jj_scanpos = xsp;
    if (jj_3R_122()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_54() {
    if (jj_scan_token(BOTH)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_132() {
    if (jj_scan_token(GROUPS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_9() {
    if (jj_3R_18()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_135() {
    if (jj_scan_token(JAVA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_129() {
    if (jj_scan_token(ACCOUNT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_10() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_19()) {
    jj_scanpos = xsp;
    if (jj_3R_20()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_21()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_118() {
    if (jj_scan_token(ANY)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_3R_17()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_85() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_118()) {
    jj_scanpos = xsp;
    if (jj_3R_119()) {
    jj_scanpos = xsp;
    if (jj_3R_120()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_48() {
    if (jj_3R_84()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_85()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_126() {
    if (jj_3R_21()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_83() {
    if (jj_scan_token(DOT_DELIMINATED_REF)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_15() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_28()) {
    jj_scanpos = xsp;
    if (jj_3R_29()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_30() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_53()) {
    jj_scanpos = xsp;
    if (jj_3R_54()) {
    jj_scanpos = xsp;
    if (jj_3R_55()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_53() {
    if (jj_scan_token(LEADING)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_25() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_15()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_134() {
    if (jj_scan_token(NAME)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_131() {
    if (jj_scan_token(PRIVILEGES)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_117() {
    if (jj_scan_token(NOTEQ)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_128() {
    if (jj_scan_token(OPTION)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_82() {
    if (jj_3R_21()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_127() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_52() {
    if (jj_3R_89()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(208)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_87()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(209)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_31() {
    if (jj_scan_token(STRING_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_98() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_127()) {
    jj_scanpos = xsp;
    if (jj_3R_128()) {
    jj_scanpos = xsp;
    if (jj_3R_129()) {
    jj_scanpos = xsp;
    if (jj_3R_130()) {
    jj_scanpos = xsp;
    if (jj_3R_131()) {
    jj_scanpos = xsp;
    if (jj_3R_132()) {
    jj_scanpos = xsp;
    if (jj_3R_133()) {
    jj_scanpos = xsp;
    if (jj_3R_134()) {
    jj_scanpos = xsp;
    if (jj_3R_135()) {
    jj_scanpos = xsp;
    if (jj_3R_136()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_17() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_30()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_31()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(FROM)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_86() {
    if (jj_scan_token(DISTINCT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_116() {
    if (jj_scan_token(LEEQ)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_51() {
    if (jj_scan_token(CAST)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(208)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_88()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_91() {
    if (jj_3R_126()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_125() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_115() {
    if (jj_scan_token(GREQ)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_104() {
    if (jj_scan_token(LEEQ)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_50() {
    if (jj_scan_token(TRIM)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(208)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_17()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_88()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_scan_token(LONG)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(BINARY)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(VARYING)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_scan_token(BINARY)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(VARYING)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_49() {
    if (jj_scan_token(COUNT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(208)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_86()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_87()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(209)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_26() {
    if (jj_scan_token(208)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_114() {
    if (jj_scan_token(LE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_124() {
    if (jj_scan_token(USER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_88() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_27() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_49()) {
    jj_scanpos = xsp;
    if (jj_3R_50()) {
    jj_scanpos = xsp;
    if (jj_3R_51()) {
    jj_scanpos = xsp;
    if (jj_3R_52()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_106() {
    if (jj_scan_token(IS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_103() {
    if (jj_scan_token(GREQ)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_94() {
    if (jj_scan_token(SUBTRACT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_113() {
    if (jj_scan_token(GR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_123() {
    if (jj_scan_token(IF)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_58() {
    if (jj_scan_token(LONGVARCHAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_102() {
    if (jj_scan_token(LE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_89() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_123()) {
    jj_scanpos = xsp;
    if (jj_3R_124()) {
    jj_scanpos = xsp;
    if (jj_3R_125()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_93() {
    if (jj_scan_token(ADD)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_112() {
    if (jj_scan_token(EQUALS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_101() {
    if (jj_scan_token(GR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_60() {
    if (jj_scan_token(CHARACTER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_97() {
    if (jj_scan_token(SUBTRACT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_80() {
    if (jj_3R_98()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_57() {
    if (jj_scan_token(STRING)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_64() {
    if (jj_scan_token(CONCAT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_79() {
    if (jj_scan_token(QUOTED_DELIMINATED_REF)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_78() {
    if (jj_scan_token(DOT_DELIMINATED_REF)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_77() {
    if (jj_scan_token(QUOTED_VARIABLE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_76() {
    if (jj_scan_token(NUMBER_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_95() {
    if (jj_scan_token(STAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_92() {
    if (jj_scan_token(DIVIDE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_96() {
    if (jj_scan_token(ADD)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_75() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_96()) {
    jj_scanpos = xsp;
    if (jj_3R_97()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_35() {
    if (jj_scan_token(CLOB)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_59() {
    if (jj_scan_token(CHAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_34() {
    if (jj_scan_token(VARCHAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_56() {
    if (jj_scan_token(TEXT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_33() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_59()) {
    jj_scanpos = xsp;
    if (jj_3R_60()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_65() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_92()) {
    jj_scanpos = xsp;
    if (jj_3R_93()) {
    jj_scanpos = xsp;
    if (jj_3R_94()) {
    jj_scanpos = xsp;
    if (jj_3R_95()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_32() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_56()) {
    jj_scanpos = xsp;
    if (jj_3R_57()) {
    jj_scanpos = xsp;
    if (jj_3R_58()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_100() {
    if (jj_scan_token(EQUALS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_46() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_75()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_76()) {
    jj_scanpos = xsp;
    if (jj_3R_77()) {
    jj_scanpos = xsp;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) {
    jj_scanpos = xsp;
    if (jj_3R_80()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_scan_token(LONG)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(CHARACTER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(VARYING)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_17() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_2()) {
    jj_scanpos = xsp;
    if (jj_3_3()) {
    jj_scanpos = xsp;
    if (jj_3R_32()) {
    jj_scanpos = xsp;
    if (jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) {
    jj_scanpos = xsp;
    if (jj_3R_35()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_scan_token(CHARACTER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(VARYING)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_74() {
    if (jj_scan_token(NULL_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_110() {
    if (jj_scan_token(OR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_108() {
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LIKE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_73() {
    if (jj_scan_token(BOOLEAN_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_111() {
    if (jj_scan_token(ASSIGNMENT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_72() {
    if (jj_scan_token(STRING_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_84() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_111()) {
    jj_scanpos = xsp;
    if (jj_3R_112()) {
    jj_scanpos = xsp;
    if (jj_3R_113()) {
    jj_scanpos = xsp;
    if (jj_3R_114()) {
    jj_scanpos = xsp;
    if (jj_3R_115()) {
    jj_scanpos = xsp;
    if (jj_3R_116()) {
    jj_scanpos = xsp;
    if (jj_3R_117()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_45() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3R_74()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_44() {
    if (jj_scan_token(NEW)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_109() {
    if (jj_scan_token(AND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_107() {
    if (jj_scan_token(LIKE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_16() {
    if (jj_scan_token(IS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_105() {
    if (jj_scan_token(NOTEQ)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_99() {
    if (jj_scan_token(ASSIGNMENT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_71() {
    if (jj_scan_token(CURRENT_DATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_81() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_99()) {
    jj_scanpos = xsp;
    if (jj_3R_100()) {
    jj_scanpos = xsp;
    if (jj_3R_101()) {
    jj_scanpos = xsp;
    if (jj_3R_102()) {
    jj_scanpos = xsp;
    if (jj_3R_103()) {
    jj_scanpos = xsp;
    if (jj_3R_104()) {
    jj_scanpos = xsp;
    if (jj_3R_105()) {
    jj_scanpos = xsp;
    if (jj_3_16()) {
    jj_scanpos = xsp;
    if (jj_3R_106()) {
    jj_scanpos = xsp;
    if (jj_3R_107()) {
    jj_scanpos = xsp;
    if (jj_3R_108()) {
    jj_scanpos = xsp;
    if (jj_3R_109()) {
    jj_scanpos = xsp;
    if (jj_3R_110()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_70() {
    if (jj_scan_token(CURRENT_TIME)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_69() {
    if (jj_scan_token(CURRENT_TIMESTAMP)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_43() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_69()) {
    jj_scanpos = xsp;
    if (jj_3R_70()) {
    jj_scanpos = xsp;
    if (jj_3R_71()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_38() {
    if (jj_3R_64()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_68() {
    if (jj_scan_token(TIMESTAMP)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_67() {
    if (jj_scan_token(TIME)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_66() {
    if (jj_scan_token(DATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_42() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_66()) {
    jj_scanpos = xsp;
    if (jj_3R_67()) {
    jj_scanpos = xsp;
    if (jj_3R_68()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(STRING_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_8() {
    if (jj_scan_token(SET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(NULL_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_14() {
    if (jj_3R_27()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_39() {
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_13() {
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_21()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_scan_token(SET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(GROUPS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_41() {
    if (jj_scan_token(PARAMETER_REF)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_40() {
    if (jj_scan_token(208)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_21() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_40()) {
    jj_scanpos = xsp;
    if (jj_3R_41()) {
    jj_scanpos = xsp;
    if (jj_3_13()) {
    jj_scanpos = xsp;
    if (jj_3_14()) {
    jj_scanpos = xsp;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) {
    jj_scanpos = xsp;
    if (jj_3R_44()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) {
    jj_scanpos = xsp;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_47() {
    if (jj_3R_81()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_scan_token(ON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(DELETE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_62() {
    if (jj_scan_token(REGEX_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_37() {
    if (jj_3R_63()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_24() {
    if (jj_3R_38()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_12() {
    if (jj_3R_25()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_26()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_23() {
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_22() {
    if (jj_3R_47()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_61() {
    if (jj_scan_token(REGEX)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_138() {
    if (jj_3R_88()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_133() {
    if (jj_scan_token(LANGUAGE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  public SQLTokenManager token_source;
  SimpleCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[189];
  final private int[] jj_la1_0 = {0xffc00000,0x1,0x0,0x0,0x0,0x0,0x0,0x8000000,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x34000000,0x0,0x0,0x0,0x0,0x0,0x0,0x36000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x1400000,0x1b0000,0x0,0x1b0000,0x0,0x0,0x0,0x0,0x0,0x1b0080,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x78080,0x7ff80,0x200000,0x200000,0x0,0x0,0x0,0x180000,0x30000,0x30000,0x0,0x0,0x1b0000,0x2000000,0x0,0x0,0x0,0x7f00,0x0,0x7f00,0x0,0x7f00,0x38080,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x1b0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
  final private int[] jj_la1_1 = {0x40201a,0x0,0x80000000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x10000000,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x2,0x80,0x0,0x0,0x0,0x0,0x0,0x30000,0x0,0x0,0x800,0x800,0x2000000,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x40000,0x40020100,0x0,0x40020100,0x0,0x800,0x0,0x40,0x0,0x40020100,0x0,0x8008000,0x0,0x8008000,0x8008000,0x30000,0x40,0x30040,0x24000000,0x30000,0x0,0x24000000,0x0,0x24000000,0x0,0x24000000,0x24000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x80,0x80,0x80,0x0,0x0,0x400,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x1001800,0x1001800,0x0,0x0,0x0,0x20,0x0,0x0,0x100,0x0,0x800000,0x800000,0x0,0x40000100,0x0,0x0,0x40020100,0x0,0x30000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
  final private int[] jj_la1_2 = {0x40800000,0x0,0x24004,0x24004,0x0,0x400,0x8000,0x4004,0x4000,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x1000,0x800,0x8000001,0x0,0x400,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x2,0x800000,0x0,0x0,0x0,0x0,0x4000080,0x0,0x4000,0xb0004060,0x0,0x0,0x1000000,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x400000,0x0,0xb0100060,0x0,0x0,0x0,0xb0000060,0x0,0xb000026c,0x0,0xb000026c,0x0,0x0,0x0,0x0,0xb0000060,0xb000026c,0x0,0x0,0x0,0x0,0x0,0xb0000060,0x0,0xb0000060,0x12000,0xb0000060,0x10000,0x12000,0x80000,0x12000,0x80000,0x12000,0x12000,0xb0000060,0x0,0xb0000060,0xb0000070,0x0,0x0,0xb0100060,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xb0000060,0x0,0xb0000060,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x20c,0x0,0x0,0xb000026c,0x400000,0xb0000060,0xb0000060,0xb0000060,0xb0000060,0x0,0xb0000060,0xb0000060,0xb0000060,0xb0000060,0xb0000060,0xb0000060,0xb0000060,0xb0000060,0xb0000060,};
  final private int[] jj_la1_3 = {0x0,0x0,0x644088,0x644008,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x44000,0x44000,0x200,0x0,0x80,0x0,0x0,0x80000000,0x80000,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x20,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x41000408,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x40,0x4000000,0x0,0x2,0x100,0x41000580,0x100,0x0,0x100,0x41000500,0x0,0x41008400,0x0,0x41008400,0x0,0x20000000,0x0,0x0,0x41000400,0x41000400,0x0,0x0,0x0,0x0,0x0,0x41000400,0x0,0x41000400,0x0,0x41000400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x41000400,0x0,0x41000400,0x41000400,0x0,0x0,0x41000480,0x8000,0x80,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x800000,0x0,0x10000000,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x41000400,0x0,0x41000400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x2000800,0x2000800,0x0,0x0,0x0,0x0,0x41000400,0x2,0x41000400,0x41000400,0x41000400,0x41000400,0x1,0x41000400,0x41000400,0x41000400,0x41000400,0x41000400,0x41000400,0x41000400,0x41000400,0x41000400,};
  final private int[] jj_la1_4 = {0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x40,0x200,0x0,0x0,0x0,0x8000,0x0,0x0,0x0,0x20,0x0,0xcc0,0x0,0x0,0x0,0x4c0,0x0,0x80000040,0x0,0x80000040,0x0,0x0,0x0,0x0,0x40,0x80000040,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x40,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x40,0xff000042,0x0,0x0,0xcc0,0x0,0x400,0x6000,0x6000,0x400,0x1e0000,0xe00000,0x40000000,0x20000002,0x68000002,0x2000000,0x6000000,0x1000000,0x80000000,0x10000000,0x0,0x0,0x0,0x1e0000,0xe00000,0x10000,0x0,0x0,0x0,0x0,0x97000000,0x80,0x0,0x0,0x0,0x0,0x0,0xc00,0x108,0x0,0x0,0x4,0x100,0x100,0x100,0x4,0x8,0x108,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x40,0x0,0x80000040,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000040,0x20,0x40,0x40,0x40,0x40,0x0,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,};
  final private int[] jj_la1_5 = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe004001,0x0,0xe004001,0x0,0x0,0x0,0x0,0x0,0xe004001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10010,0x0,0x10810,0x400,0x16ce,0x100,0x4001,0x22020,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x277ef,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xd0000000,0x20000000,0x20000000,0x0,0x4001,0xe000000,0x0,0x0,0x0,0x0,0x0,0xe004001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xd0000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe004001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
  final private int[] jj_la1_6 = {0x0,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x10000,0x20,0x10000,0x0,0x0,0x0,0x0,0x20,0x20,0x0,0x0,0x0,0x0,0xf0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf0,0x0,0x0,0x0,0xf0,0x0,0x110fe,0x40000,0x110fe,0x40000,0x0,0x40000,0x0,0x30,0x11cfe,0x40000,0x0,0x40000,0x0,0x0,0x100f0,0x0,0xf0,0x40000,0x100f0,0x0,0x40000,0x0,0x40000,0x0,0x40000,0x40000,0x30,0x40000,0x30,0x30,0x40000,0x40000,0xf0,0x0,0x2,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x140,0x10000,0x10000,0x0,0x0,0x0,0x40000,0x10000,0x10000,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x2,0x2,0x2,0x0,0x0,0x2,0x40000,0x40000,0x0,0x2,0x0,0x0,0x2,0x0,0x0,0x8,0x0,0x0,0xf4,0x11000,0xfc,0x0,0x3,0x0,0x0,0x0,0x2,0x0,0x2,0x0,0x0,0x20,0x0,0x0,0x0,0x8,0x20,0x0,0x40000,0x110fe,0x0,0xf0,0xf0,0x30,0x30,0x30,0x30,0x30,0xf0,0xf0,0x30,0xf0,0xf0,0x30,0x20,};
  final private JJCalls[] jj_2_rtns = new JJCalls[17];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public SQL(java.io.InputStream stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new SQLTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 189; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 189; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public SQL(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new SQLTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 189; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 189; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public SQL(SQLTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 189; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(SQLTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 189; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    return (jj_scanpos.kind != kind);
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration en = jj_expentries.elements(); en.hasMoreElements();) {
        int[] oldentry = (int[])(en.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[211];
    for (int i = 0; i < 211; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 189; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
          if ((jj_la1_5[i] & (1<<j)) != 0) {
            la1tokens[160+j] = true;
          }
          if ((jj_la1_6[i] & (1<<j)) != 0) {
            la1tokens[192+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 211; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 17; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
