
// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

// DO NOT EDIT THIS FILE! It IS AUTOGENERATED
#include "corinfoexception.h"

struct CORINFO_LOOKUP_KIND;

struct JitInterfaceCallbacks
{
    unsigned int (* getMethodAttribs)(void * thisHandle, CorInfoException** ppException, void* ftn);
    void (* setMethodAttribs)(void * thisHandle, CorInfoException** ppException, void* ftn, int attribs);
    void (* getMethodSig)(void * thisHandle, CorInfoException** ppException, void* ftn, void* sig, void* memberParent);
    bool (* getMethodInfo)(void * thisHandle, CorInfoException** ppException, void* ftn, void* info);
    int (* canInline)(void * thisHandle, CorInfoException** ppException, void* callerHnd, void* calleeHnd, unsigned int* pRestrictions);
    void (* reportInliningDecision)(void * thisHandle, CorInfoException** ppException, void* inlinerHnd, void* inlineeHnd, int inlineResult, const char* reason);
    bool (* canTailCall)(void * thisHandle, CorInfoException** ppException, void* callerHnd, void* declaredCalleeHnd, void* exactCalleeHnd, bool fIsTailPrefix);
    void (* reportTailCallDecision)(void * thisHandle, CorInfoException** ppException, void* callerHnd, void* calleeHnd, bool fIsTailPrefix, int tailCallResult, const char* reason);
    void (* getEHinfo)(void * thisHandle, CorInfoException** ppException, void* ftn, unsigned EHnumber, void* clause);
    void* (* getMethodClass)(void * thisHandle, CorInfoException** ppException, void* method);
    void* (* getMethodModule)(void * thisHandle, CorInfoException** ppException, void* method);
    void (* getMethodVTableOffset)(void * thisHandle, CorInfoException** ppException, void* method, unsigned* offsetOfIndirection, unsigned* offsetAfterIndirection, bool* isRelative);
    void* (* resolveVirtualMethod)(void * thisHandle, CorInfoException** ppException, void* virtualMethod, void* implementingClass, void* ownerType);
    void* (* getUnboxedEntry)(void * thisHandle, CorInfoException** ppException, void* ftn, bool* requiresInstMethodTableArg);
    void* (* getDefaultEqualityComparerClass)(void * thisHandle, CorInfoException** ppException, void* elemType);
    void (* expandRawHandleIntrinsic)(void * thisHandle, CorInfoException** ppException, void* pResolvedToken, void* pResult);
    int (* getIntrinsicID)(void * thisHandle, CorInfoException** ppException, void* method, bool* pMustExpand);
    bool (* isInSIMDModule)(void * thisHandle, CorInfoException** ppException, void* classHnd);
    int (* getUnmanagedCallConv)(void * thisHandle, CorInfoException** ppException, void* method);
    int (* pInvokeMarshalingRequired)(void * thisHandle, CorInfoException** ppException, void* method, void* callSiteSig);
    int (* satisfiesMethodConstraints)(void * thisHandle, CorInfoException** ppException, void* parent, void* method);
    int (* isCompatibleDelegate)(void * thisHandle, CorInfoException** ppException, void* objCls, void* methodParentCls, void* method, void* delegateCls, int* pfIsOpenDelegate);
    int (* isInstantiationOfVerifiedGeneric)(void * thisHandle, CorInfoException** ppException, void* method);
    void (* initConstraintsForVerification)(void * thisHandle, CorInfoException** ppException, void* method, int* pfHasCircularClassConstraints, int* pfHasCircularMethodConstraint);
    int (* canSkipMethodVerification)(void * thisHandle, CorInfoException** ppException, void* ftnHandle);
    void (* methodMustBeLoadedBeforeCodeIsRun)(void * thisHandle, CorInfoException** ppException, void* method);
    void* (* mapMethodDeclToMethodImpl)(void * thisHandle, CorInfoException** ppException, void* method);
    void (* getGSCookie)(void * thisHandle, CorInfoException** ppException, void* pCookieVal, void** ppCookieVal);
    void (* resolveToken)(void * thisHandle, CorInfoException** ppException, void* pResolvedToken);
    void (* tryResolveToken)(void * thisHandle, CorInfoException** ppException, void* pResolvedToken);
    void (* findSig)(void * thisHandle, CorInfoException** ppException, void* module, unsigned sigTOK, void* context, void* sig);
    void (* findCallSiteSig)(void * thisHandle, CorInfoException** ppException, void* module, unsigned methTOK, void* context, void* sig);
    void* (* getTokenTypeAsHandle)(void * thisHandle, CorInfoException** ppException, void* pResolvedToken);
    int (* canSkipVerification)(void * thisHandle, CorInfoException** ppException, void* module);
    int (* isValidToken)(void * thisHandle, CorInfoException** ppException, void* module, unsigned metaTOK);
    int (* isValidStringRef)(void * thisHandle, CorInfoException** ppException, void* module, unsigned metaTOK);
    int (* shouldEnforceCallvirtRestriction)(void * thisHandle, CorInfoException** ppException, void* scope);
    int (* asCorInfoType)(void * thisHandle, CorInfoException** ppException, void* cls);
    const char* (* getClassName)(void * thisHandle, CorInfoException** ppException, void* cls);
    const char* (* getClassNameFromMetadata)(void * thisHandle, CorInfoException** ppException, void* cls, const char** namespaceName);
    void* (* getTypeInstantiationArgument)(void * thisHandle, CorInfoException** ppException, void* cls, unsigned index);
    int (* appendClassName)(void * thisHandle, CorInfoException** ppException, wchar_t** ppBuf, int* pnBufLen, void* cls, int fNamespace, int fFullInst, int fAssembly);
    int (* isValueClass)(void * thisHandle, CorInfoException** ppException, void* cls);
    int (* canInlineTypeCheckWithObjectVTable)(void * thisHandle, CorInfoException** ppException, void* cls);
    unsigned int (* getClassAttribs)(void * thisHandle, CorInfoException** ppException, void* cls);
    int (* isStructRequiringStackAllocRetBuf)(void * thisHandle, CorInfoException** ppException, void* cls);
    void* (* getClassModule)(void * thisHandle, CorInfoException** ppException, void* cls);
    void* (* getModuleAssembly)(void * thisHandle, CorInfoException** ppException, void* mod);
    const char* (* getAssemblyName)(void * thisHandle, CorInfoException** ppException, void* assem);
    void* (* LongLifetimeMalloc)(void * thisHandle, CorInfoException** ppException, size_t sz);
    void (* LongLifetimeFree)(void * thisHandle, CorInfoException** ppException, void* obj);
    size_t (* getClassModuleIdForStatics)(void * thisHandle, CorInfoException** ppException, void* cls, void* pModule, void** ppIndirection);
    unsigned (* getClassSize)(void * thisHandle, CorInfoException** ppException, void* cls);
    unsigned (* getClassAlignmentRequirement)(void * thisHandle, CorInfoException** ppException, void* cls, int fDoubleAlignHint);
    unsigned (* getClassGClayout)(void * thisHandle, CorInfoException** ppException, void* cls, unsigned char* gcPtrs);
    unsigned (* getClassNumInstanceFields)(void * thisHandle, CorInfoException** ppException, void* cls);
    void* (* getFieldInClass)(void * thisHandle, CorInfoException** ppException, void* clsHnd, int num);
    int (* checkMethodModifier)(void * thisHandle, CorInfoException** ppException, void* hMethod, const char* modifier, int fOptional);
    int (* getNewHelper)(void * thisHandle, CorInfoException** ppException, void* pResolvedToken, void* callerHandle);
    int (* getNewArrHelper)(void * thisHandle, CorInfoException** ppException, void* arrayCls);
    int (* getCastingHelper)(void * thisHandle, CorInfoException** ppException, void* pResolvedToken, bool fThrowing);
    int (* getSharedCCtorHelper)(void * thisHandle, CorInfoException** ppException, void* clsHnd);
    int (* getSecurityPrologHelper)(void * thisHandle, CorInfoException** ppException, void* ftn);
    void* (* getTypeForBox)(void * thisHandle, CorInfoException** ppException, void* cls);
    int (* getBoxHelper)(void * thisHandle, CorInfoException** ppException, void* cls);
    int (* getUnBoxHelper)(void * thisHandle, CorInfoException** ppException, void* cls);
    bool (* getReadyToRunHelper)(void * thisHandle, CorInfoException** ppException, void* pResolvedToken, void* pGenericLookupKind, int id, void* pLookup);
    void (* getReadyToRunDelegateCtorHelper)(void * thisHandle, CorInfoException** ppException, void* pTargetMethod, void* delegateType, void* pLookup);
    const char* (* getHelperName)(void * thisHandle, CorInfoException** ppException, int helpFunc);
    int (* initClass)(void * thisHandle, CorInfoException** ppException, void* field, void* method, void* context, int speculative);
    void (* classMustBeLoadedBeforeCodeIsRun)(void * thisHandle, CorInfoException** ppException, void* cls);
    void* (* getBuiltinClass)(void * thisHandle, CorInfoException** ppException, int classId);
    int (* getTypeForPrimitiveValueClass)(void * thisHandle, CorInfoException** ppException, void* cls);
    int (* getTypeForPrimitiveNumericClass)(void * thisHandle, CorInfoException** ppException, void* cls);
    int (* canCast)(void * thisHandle, CorInfoException** ppException, void* child, void* parent);
    int (* areTypesEquivalent)(void * thisHandle, CorInfoException** ppException, void* cls1, void* cls2);
    int (* compareTypesForCast)(void * thisHandle, CorInfoException** ppException, void* fromClass, void* toClass);
    int (* compareTypesForEquality)(void * thisHandle, CorInfoException** ppException, void* cls1, void* cls2);
    void* (* mergeClasses)(void * thisHandle, CorInfoException** ppException, void* cls1, void* cls2);
    void* (* getParentType)(void * thisHandle, CorInfoException** ppException, void* cls);
    int (* getChildType)(void * thisHandle, CorInfoException** ppException, void* clsHnd, void* clsRet);
    int (* satisfiesClassConstraints)(void * thisHandle, CorInfoException** ppException, void* cls);
    int (* isSDArray)(void * thisHandle, CorInfoException** ppException, void* cls);
    unsigned (* getArrayRank)(void * thisHandle, CorInfoException** ppException, void* cls);
    void* (* getArrayInitializationData)(void * thisHandle, CorInfoException** ppException, void* field, unsigned int size);
    int (* canAccessClass)(void * thisHandle, CorInfoException** ppException, void* pResolvedToken, void* callerHandle, void* pAccessHelper);
    const char* (* getFieldName)(void * thisHandle, CorInfoException** ppException, void* ftn, const char** moduleName);
    void* (* getFieldClass)(void * thisHandle, CorInfoException** ppException, void* field);
    int (* getFieldType)(void * thisHandle, CorInfoException** ppException, void* field, void* structType, void* memberParent);
    unsigned (* getFieldOffset)(void * thisHandle, CorInfoException** ppException, void* field);
    bool (* isWriteBarrierHelperRequired)(void * thisHandle, CorInfoException** ppException, void* field);
    void (* getFieldInfo)(void * thisHandle, CorInfoException** ppException, void* pResolvedToken, void* callerHandle, int flags, void* pResult);
    bool (* isFieldStatic)(void * thisHandle, CorInfoException** ppException, void* fldHnd);
    void (* getBoundaries)(void * thisHandle, CorInfoException** ppException, void* ftn, unsigned int* cILOffsets, unsigned int** pILOffsets, void* implictBoundaries);
    void (* setBoundaries)(void * thisHandle, CorInfoException** ppException, void* ftn, unsigned int cMap, void* pMap);
    void (* getVars)(void * thisHandle, CorInfoException** ppException, void* ftn, unsigned int* cVars, void* vars, bool* extendOthers);
    void (* setVars)(void * thisHandle, CorInfoException** ppException, void* ftn, unsigned int cVars, void* vars);
    void* (* allocateArray)(void * thisHandle, CorInfoException** ppException, unsigned int cBytes);
    void (* freeArray)(void * thisHandle, CorInfoException** ppException, void* array);
    void* (* getArgNext)(void * thisHandle, CorInfoException** ppException, void* args);
    int (* getArgType)(void * thisHandle, CorInfoException** ppException, void* sig, void* args, void* vcTypeRet);
    void* (* getArgClass)(void * thisHandle, CorInfoException** ppException, void* sig, void* args);
    int (* getHFAType)(void * thisHandle, CorInfoException** ppException, void* hClass);
    int (* GetErrorHRESULT)(void * thisHandle, CorInfoException** ppException, void* pExceptionPointers);
    unsigned int (* GetErrorMessage)(void * thisHandle, CorInfoException** ppException, wchar_t* buffer, unsigned int bufferLength);
    int (* FilterException)(void * thisHandle, CorInfoException** ppException, void* pExceptionPointers);
    void (* HandleException)(void * thisHandle, CorInfoException** ppException, void* pExceptionPointers);
    void (* ThrowExceptionForJitResult)(void * thisHandle, CorInfoException** ppException, int result);
    void (* ThrowExceptionForHelper)(void * thisHandle, CorInfoException** ppException, const void* throwHelper);
    bool (* runWithErrorTrap)(void * thisHandle, CorInfoException** ppException, void* function, void* parameter);
    void (* getEEInfo)(void * thisHandle, CorInfoException** ppException, void* pEEInfoOut);
    const wchar_t* (* getJitTimeLogFilename)(void * thisHandle, CorInfoException** ppException);
    unsigned int (* getMethodDefFromMethod)(void * thisHandle, CorInfoException** ppException, void* hMethod);
    const char* (* getMethodName)(void * thisHandle, CorInfoException** ppException, void* ftn, const char** moduleName);
    const char* (* getMethodNameFromMetadata)(void * thisHandle, CorInfoException** ppException, void* ftn, const char** className, const char** namespaceName);
    unsigned (* getMethodHash)(void * thisHandle, CorInfoException** ppException, void* ftn);
    size_t (* findNameOfToken)(void * thisHandle, CorInfoException** ppException, void* moduleHandle, unsigned int token, char* szFQName, size_t FQNameCapacity);
    bool (* getSystemVAmd64PassStructInRegisterDescriptor)(void * thisHandle, CorInfoException** ppException, void* structHnd, void* structPassInRegDescPtr);
    unsigned int (* getThreadTLSIndex)(void * thisHandle, CorInfoException** ppException, void** ppIndirection);
    const void* (* getInlinedCallFrameVptr)(void * thisHandle, CorInfoException** ppException, void** ppIndirection);
    long* (* getAddrOfCaptureThreadGlobal)(void * thisHandle, CorInfoException** ppException, void** ppIndirection);
    void* (* getHelperFtn)(void * thisHandle, CorInfoException** ppException, int ftnNum, void** ppIndirection);
    void (* getFunctionEntryPoint)(void * thisHandle, CorInfoException** ppException, void* ftn, void* pResult, int accessFlags);
    void (* getFunctionFixedEntryPoint)(void * thisHandle, CorInfoException** ppException, void* ftn, void* pResult);
    void* (* getMethodSync)(void * thisHandle, CorInfoException** ppException, void* ftn, void** ppIndirection);
    int (* getLazyStringLiteralHelper)(void * thisHandle, CorInfoException** ppException, void* handle);
    void* (* embedModuleHandle)(void * thisHandle, CorInfoException** ppException, void* handle, void** ppIndirection);
    void* (* embedClassHandle)(void * thisHandle, CorInfoException** ppException, void* handle, void** ppIndirection);
    void* (* embedMethodHandle)(void * thisHandle, CorInfoException** ppException, void* handle, void** ppIndirection);
    void* (* embedFieldHandle)(void * thisHandle, CorInfoException** ppException, void* handle, void** ppIndirection);
    void (* embedGenericHandle)(void * thisHandle, CorInfoException** ppException, void* pResolvedToken, int fEmbedParent, void* pResult);
    void (* getLocationOfThisType)(void * thisHandle, CorInfoException** ppException, CORINFO_LOOKUP_KIND* _return, void* context);
    void* (* getPInvokeUnmanagedTarget)(void * thisHandle, CorInfoException** ppException, void* method, void** ppIndirection);
    void* (* getAddressOfPInvokeFixup)(void * thisHandle, CorInfoException** ppException, void* method, void** ppIndirection);
    void (* getAddressOfPInvokeTarget)(void * thisHandle, CorInfoException** ppException, void* method, void* pLookup);
    void* (* GetCookieForPInvokeCalliSig)(void * thisHandle, CorInfoException** ppException, void* szMetaSig, void** ppIndirection);
    bool (* canGetCookieForPInvokeCalliSig)(void * thisHandle, CorInfoException** ppException, void* szMetaSig);
    void* (* getJustMyCodeHandle)(void * thisHandle, CorInfoException** ppException, void* method, void** ppIndirection);
    void (* GetProfilingHandle)(void * thisHandle, CorInfoException** ppException, int* pbHookFunction, void** pProfilerHandle, int* pbIndirectedHandles);
    void (* getCallInfo)(void * thisHandle, CorInfoException** ppException, void* pResolvedToken, void* pConstrainedResolvedToken, void* callerHandle, int flags, void* pResult);
    int (* canAccessFamily)(void * thisHandle, CorInfoException** ppException, void* hCaller, void* hInstanceType);
    int (* isRIDClassDomainID)(void * thisHandle, CorInfoException** ppException, void* cls);
    unsigned (* getClassDomainID)(void * thisHandle, CorInfoException** ppException, void* cls, void** ppIndirection);
    void* (* getFieldAddress)(void * thisHandle, CorInfoException** ppException, void* field, void** ppIndirection);
    void* (* getVarArgsHandle)(void * thisHandle, CorInfoException** ppException, void* pSig, void** ppIndirection);
    bool (* canGetVarArgsHandle)(void * thisHandle, CorInfoException** ppException, void* pSig);
    int (* constructStringLiteral)(void * thisHandle, CorInfoException** ppException, void* module, unsigned int metaTok, void** ppValue);
    int (* emptyStringLiteral)(void * thisHandle, CorInfoException** ppException, void** ppValue);
    unsigned int (* getFieldThreadLocalStoreID)(void * thisHandle, CorInfoException** ppException, void* field, void** ppIndirection);
    void (* setOverride)(void * thisHandle, CorInfoException** ppException, void* pOverride, void* currentMethod);
    void (* addActiveDependency)(void * thisHandle, CorInfoException** ppException, void* moduleFrom, void* moduleTo);
    void* (* GetDelegateCtor)(void * thisHandle, CorInfoException** ppException, void* methHnd, void* clsHnd, void* targetMethodHnd, void* pCtorData);
    void (* MethodCompileComplete)(void * thisHandle, CorInfoException** ppException, void* methHnd);
    void* (* getTailCallCopyArgsThunk)(void * thisHandle, CorInfoException** ppException, void* pSig, int flags);
    bool (* convertPInvokeCalliToCall)(void * thisHandle, CorInfoException** ppException, void* pResolvedToken, bool mustConvert);
    void* (* getMemoryManager)(void * thisHandle, CorInfoException** ppException);
    void (* allocMem)(void * thisHandle, CorInfoException** ppException, unsigned int hotCodeSize, unsigned int coldCodeSize, unsigned int roDataSize, unsigned int xcptnsCount, int flag, void** hotCodeBlock, void** coldCodeBlock, void** roDataBlock);
    void (* reserveUnwindInfo)(void * thisHandle, CorInfoException** ppException, int isFunclet, int isColdCode, unsigned int unwindSize);
    void (* allocUnwindInfo)(void * thisHandle, CorInfoException** ppException, unsigned char* pHotCode, unsigned char* pColdCode, unsigned int startOffset, unsigned int endOffset, unsigned int unwindSize, unsigned char* pUnwindBlock, int funcKind);
    void* (* allocGCInfo)(void * thisHandle, CorInfoException** ppException, size_t size);
    void (* yieldExecution)(void * thisHandle, CorInfoException** ppException);
    void (* setEHcount)(void * thisHandle, CorInfoException** ppException, unsigned cEH);
    void (* setEHinfo)(void * thisHandle, CorInfoException** ppException, unsigned EHnumber, void* clause);
    int (* logMsg)(void * thisHandle, CorInfoException** ppException, unsigned level, const char* fmt, va_list args);
    int (* doAssert)(void * thisHandle, CorInfoException** ppException, const char* szFile, int iLine, const char* szExpr);
    void (* reportFatalError)(void * thisHandle, CorInfoException** ppException, int result);
    int (* allocBBProfileBuffer)(void * thisHandle, CorInfoException** ppException, unsigned int count, void** profileBuffer);
    int (* getBBProfileData)(void * thisHandle, CorInfoException** ppException, void* ftnHnd, unsigned long* count, void** profileBuffer, unsigned long* numRuns);
    void (* recordCallSite)(void * thisHandle, CorInfoException** ppException, unsigned int instrOffset, void* callSig, void* methodHandle);
    void (* recordRelocation)(void * thisHandle, CorInfoException** ppException, void* location, void* target, unsigned short fRelocType, unsigned short slotNum, int addlDelta);
    unsigned short (* getRelocTypeHint)(void * thisHandle, CorInfoException** ppException, void* target);
    void (* getModuleNativeEntryPointRange)(void * thisHandle, CorInfoException** ppException, void** pStart, void** pEnd);
    unsigned int (* getExpectedTargetArchitecture)(void * thisHandle, CorInfoException** ppException);
    unsigned int (* getJitFlags)(void * thisHandle, CorInfoException** ppException, void* flags, unsigned int sizeInBytes);

};

class JitInterfaceWrapper
{
    void * _thisHandle;
    JitInterfaceCallbacks * _callbacks;

public:
    JitInterfaceWrapper(void * thisHandle, void ** callbacks)
        : _thisHandle(thisHandle), _callbacks((JitInterfaceCallbacks *)callbacks)
    {
    }

    virtual unsigned int getMethodAttribs(void* ftn)
    {
        CorInfoException* pException = nullptr;
        unsigned int _ret = _callbacks->getMethodAttribs(_thisHandle, &pException, ftn);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void setMethodAttribs(void* ftn, int attribs)
    {
        CorInfoException* pException = nullptr;
        _callbacks->setMethodAttribs(_thisHandle, &pException, ftn, attribs);
        if (pException != nullptr)
            throw pException;
    }

    virtual void getMethodSig(void* ftn, void* sig, void* memberParent)
    {
        CorInfoException* pException = nullptr;
        _callbacks->getMethodSig(_thisHandle, &pException, ftn, sig, memberParent);
        if (pException != nullptr)
            throw pException;
    }

    virtual bool getMethodInfo(void* ftn, void* info)
    {
        CorInfoException* pException = nullptr;
        bool _ret = _callbacks->getMethodInfo(_thisHandle, &pException, ftn, info);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int canInline(void* callerHnd, void* calleeHnd, unsigned int* pRestrictions)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->canInline(_thisHandle, &pException, callerHnd, calleeHnd, pRestrictions);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void reportInliningDecision(void* inlinerHnd, void* inlineeHnd, int inlineResult, const char* reason)
    {
        CorInfoException* pException = nullptr;
        _callbacks->reportInliningDecision(_thisHandle, &pException, inlinerHnd, inlineeHnd, inlineResult, reason);
        if (pException != nullptr)
            throw pException;
    }

    virtual bool canTailCall(void* callerHnd, void* declaredCalleeHnd, void* exactCalleeHnd, bool fIsTailPrefix)
    {
        CorInfoException* pException = nullptr;
        bool _ret = _callbacks->canTailCall(_thisHandle, &pException, callerHnd, declaredCalleeHnd, exactCalleeHnd, fIsTailPrefix);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void reportTailCallDecision(void* callerHnd, void* calleeHnd, bool fIsTailPrefix, int tailCallResult, const char* reason)
    {
        CorInfoException* pException = nullptr;
        _callbacks->reportTailCallDecision(_thisHandle, &pException, callerHnd, calleeHnd, fIsTailPrefix, tailCallResult, reason);
        if (pException != nullptr)
            throw pException;
    }

    virtual void getEHinfo(void* ftn, unsigned EHnumber, void* clause)
    {
        CorInfoException* pException = nullptr;
        _callbacks->getEHinfo(_thisHandle, &pException, ftn, EHnumber, clause);
        if (pException != nullptr)
            throw pException;
    }

    virtual void* getMethodClass(void* method)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->getMethodClass(_thisHandle, &pException, method);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void* getMethodModule(void* method)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->getMethodModule(_thisHandle, &pException, method);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void getMethodVTableOffset(void* method, unsigned* offsetOfIndirection, unsigned* offsetAfterIndirection, bool* isRelative)
    {
        CorInfoException* pException = nullptr;
        _callbacks->getMethodVTableOffset(_thisHandle, &pException, method, offsetOfIndirection, offsetAfterIndirection, isRelative);
        if (pException != nullptr)
            throw pException;
    }

    virtual void* resolveVirtualMethod(void* virtualMethod, void* implementingClass, void* ownerType)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->resolveVirtualMethod(_thisHandle, &pException, virtualMethod, implementingClass, ownerType);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void* getUnboxedEntry(void* ftn, bool* requiresInstMethodTableArg)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->getUnboxedEntry(_thisHandle, &pException, ftn, requiresInstMethodTableArg);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void* getDefaultEqualityComparerClass(void* elemType)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->getDefaultEqualityComparerClass(_thisHandle, &pException, elemType);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void expandRawHandleIntrinsic(void* pResolvedToken, void* pResult)
    {
        CorInfoException* pException = nullptr;
        _callbacks->expandRawHandleIntrinsic(_thisHandle, &pException, pResolvedToken, pResult);
        if (pException != nullptr)
            throw pException;
    }

    virtual int getIntrinsicID(void* method, bool* pMustExpand)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->getIntrinsicID(_thisHandle, &pException, method, pMustExpand);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual bool isInSIMDModule(void* classHnd)
    {
        CorInfoException* pException = nullptr;
        bool _ret = _callbacks->isInSIMDModule(_thisHandle, &pException, classHnd);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int getUnmanagedCallConv(void* method)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->getUnmanagedCallConv(_thisHandle, &pException, method);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int pInvokeMarshalingRequired(void* method, void* callSiteSig)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->pInvokeMarshalingRequired(_thisHandle, &pException, method, callSiteSig);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int satisfiesMethodConstraints(void* parent, void* method)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->satisfiesMethodConstraints(_thisHandle, &pException, parent, method);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int isCompatibleDelegate(void* objCls, void* methodParentCls, void* method, void* delegateCls, int* pfIsOpenDelegate)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->isCompatibleDelegate(_thisHandle, &pException, objCls, methodParentCls, method, delegateCls, pfIsOpenDelegate);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int isInstantiationOfVerifiedGeneric(void* method)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->isInstantiationOfVerifiedGeneric(_thisHandle, &pException, method);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void initConstraintsForVerification(void* method, int* pfHasCircularClassConstraints, int* pfHasCircularMethodConstraint)
    {
        CorInfoException* pException = nullptr;
        _callbacks->initConstraintsForVerification(_thisHandle, &pException, method, pfHasCircularClassConstraints, pfHasCircularMethodConstraint);
        if (pException != nullptr)
            throw pException;
    }

    virtual int canSkipMethodVerification(void* ftnHandle)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->canSkipMethodVerification(_thisHandle, &pException, ftnHandle);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void methodMustBeLoadedBeforeCodeIsRun(void* method)
    {
        CorInfoException* pException = nullptr;
        _callbacks->methodMustBeLoadedBeforeCodeIsRun(_thisHandle, &pException, method);
        if (pException != nullptr)
            throw pException;
    }

    virtual void* mapMethodDeclToMethodImpl(void* method)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->mapMethodDeclToMethodImpl(_thisHandle, &pException, method);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void getGSCookie(void* pCookieVal, void** ppCookieVal)
    {
        CorInfoException* pException = nullptr;
        _callbacks->getGSCookie(_thisHandle, &pException, pCookieVal, ppCookieVal);
        if (pException != nullptr)
            throw pException;
    }

    virtual void resolveToken(void* pResolvedToken)
    {
        CorInfoException* pException = nullptr;
        _callbacks->resolveToken(_thisHandle, &pException, pResolvedToken);
        if (pException != nullptr)
            throw pException;
    }

    virtual void tryResolveToken(void* pResolvedToken)
    {
        CorInfoException* pException = nullptr;
        _callbacks->tryResolveToken(_thisHandle, &pException, pResolvedToken);
        if (pException != nullptr)
            throw pException;
    }

    virtual void findSig(void* module, unsigned sigTOK, void* context, void* sig)
    {
        CorInfoException* pException = nullptr;
        _callbacks->findSig(_thisHandle, &pException, module, sigTOK, context, sig);
        if (pException != nullptr)
            throw pException;
    }

    virtual void findCallSiteSig(void* module, unsigned methTOK, void* context, void* sig)
    {
        CorInfoException* pException = nullptr;
        _callbacks->findCallSiteSig(_thisHandle, &pException, module, methTOK, context, sig);
        if (pException != nullptr)
            throw pException;
    }

    virtual void* getTokenTypeAsHandle(void* pResolvedToken)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->getTokenTypeAsHandle(_thisHandle, &pException, pResolvedToken);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int canSkipVerification(void* module)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->canSkipVerification(_thisHandle, &pException, module);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int isValidToken(void* module, unsigned metaTOK)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->isValidToken(_thisHandle, &pException, module, metaTOK);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int isValidStringRef(void* module, unsigned metaTOK)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->isValidStringRef(_thisHandle, &pException, module, metaTOK);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int shouldEnforceCallvirtRestriction(void* scope)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->shouldEnforceCallvirtRestriction(_thisHandle, &pException, scope);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int asCorInfoType(void* cls)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->asCorInfoType(_thisHandle, &pException, cls);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual const char* getClassName(void* cls)
    {
        CorInfoException* pException = nullptr;
        const char* _ret = _callbacks->getClassName(_thisHandle, &pException, cls);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual const char* getClassNameFromMetadata(void* cls, const char** namespaceName)
    {
        CorInfoException* pException = nullptr;
        const char* _ret = _callbacks->getClassNameFromMetadata(_thisHandle, &pException, cls, namespaceName);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void* getTypeInstantiationArgument(void* cls, unsigned index)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->getTypeInstantiationArgument(_thisHandle, &pException, cls, index);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int appendClassName(wchar_t** ppBuf, int* pnBufLen, void* cls, int fNamespace, int fFullInst, int fAssembly)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->appendClassName(_thisHandle, &pException, ppBuf, pnBufLen, cls, fNamespace, fFullInst, fAssembly);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int isValueClass(void* cls)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->isValueClass(_thisHandle, &pException, cls);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int canInlineTypeCheckWithObjectVTable(void* cls)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->canInlineTypeCheckWithObjectVTable(_thisHandle, &pException, cls);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual unsigned int getClassAttribs(void* cls)
    {
        CorInfoException* pException = nullptr;
        unsigned int _ret = _callbacks->getClassAttribs(_thisHandle, &pException, cls);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int isStructRequiringStackAllocRetBuf(void* cls)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->isStructRequiringStackAllocRetBuf(_thisHandle, &pException, cls);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void* getClassModule(void* cls)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->getClassModule(_thisHandle, &pException, cls);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void* getModuleAssembly(void* mod)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->getModuleAssembly(_thisHandle, &pException, mod);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual const char* getAssemblyName(void* assem)
    {
        CorInfoException* pException = nullptr;
        const char* _ret = _callbacks->getAssemblyName(_thisHandle, &pException, assem);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void* LongLifetimeMalloc(size_t sz)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->LongLifetimeMalloc(_thisHandle, &pException, sz);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void LongLifetimeFree(void* obj)
    {
        CorInfoException* pException = nullptr;
        _callbacks->LongLifetimeFree(_thisHandle, &pException, obj);
        if (pException != nullptr)
            throw pException;
    }

    virtual size_t getClassModuleIdForStatics(void* cls, void* pModule, void** ppIndirection)
    {
        CorInfoException* pException = nullptr;
        size_t _ret = _callbacks->getClassModuleIdForStatics(_thisHandle, &pException, cls, pModule, ppIndirection);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual unsigned getClassSize(void* cls)
    {
        CorInfoException* pException = nullptr;
        unsigned _ret = _callbacks->getClassSize(_thisHandle, &pException, cls);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual unsigned getClassAlignmentRequirement(void* cls, int fDoubleAlignHint)
    {
        CorInfoException* pException = nullptr;
        unsigned _ret = _callbacks->getClassAlignmentRequirement(_thisHandle, &pException, cls, fDoubleAlignHint);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual unsigned getClassGClayout(void* cls, unsigned char* gcPtrs)
    {
        CorInfoException* pException = nullptr;
        unsigned _ret = _callbacks->getClassGClayout(_thisHandle, &pException, cls, gcPtrs);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual unsigned getClassNumInstanceFields(void* cls)
    {
        CorInfoException* pException = nullptr;
        unsigned _ret = _callbacks->getClassNumInstanceFields(_thisHandle, &pException, cls);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void* getFieldInClass(void* clsHnd, int num)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->getFieldInClass(_thisHandle, &pException, clsHnd, num);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int checkMethodModifier(void* hMethod, const char* modifier, int fOptional)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->checkMethodModifier(_thisHandle, &pException, hMethod, modifier, fOptional);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int getNewHelper(void* pResolvedToken, void* callerHandle)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->getNewHelper(_thisHandle, &pException, pResolvedToken, callerHandle);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int getNewArrHelper(void* arrayCls)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->getNewArrHelper(_thisHandle, &pException, arrayCls);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int getCastingHelper(void* pResolvedToken, bool fThrowing)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->getCastingHelper(_thisHandle, &pException, pResolvedToken, fThrowing);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int getSharedCCtorHelper(void* clsHnd)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->getSharedCCtorHelper(_thisHandle, &pException, clsHnd);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int getSecurityPrologHelper(void* ftn)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->getSecurityPrologHelper(_thisHandle, &pException, ftn);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void* getTypeForBox(void* cls)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->getTypeForBox(_thisHandle, &pException, cls);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int getBoxHelper(void* cls)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->getBoxHelper(_thisHandle, &pException, cls);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int getUnBoxHelper(void* cls)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->getUnBoxHelper(_thisHandle, &pException, cls);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual bool getReadyToRunHelper(void* pResolvedToken, void* pGenericLookupKind, int id, void* pLookup)
    {
        CorInfoException* pException = nullptr;
        bool _ret = _callbacks->getReadyToRunHelper(_thisHandle, &pException, pResolvedToken, pGenericLookupKind, id, pLookup);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void getReadyToRunDelegateCtorHelper(void* pTargetMethod, void* delegateType, void* pLookup)
    {
        CorInfoException* pException = nullptr;
        _callbacks->getReadyToRunDelegateCtorHelper(_thisHandle, &pException, pTargetMethod, delegateType, pLookup);
        if (pException != nullptr)
            throw pException;
    }

    virtual const char* getHelperName(int helpFunc)
    {
        CorInfoException* pException = nullptr;
        const char* _ret = _callbacks->getHelperName(_thisHandle, &pException, helpFunc);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int initClass(void* field, void* method, void* context, int speculative)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->initClass(_thisHandle, &pException, field, method, context, speculative);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void classMustBeLoadedBeforeCodeIsRun(void* cls)
    {
        CorInfoException* pException = nullptr;
        _callbacks->classMustBeLoadedBeforeCodeIsRun(_thisHandle, &pException, cls);
        if (pException != nullptr)
            throw pException;
    }

    virtual void* getBuiltinClass(int classId)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->getBuiltinClass(_thisHandle, &pException, classId);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int getTypeForPrimitiveValueClass(void* cls)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->getTypeForPrimitiveValueClass(_thisHandle, &pException, cls);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int getTypeForPrimitiveNumericClass(void* cls)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->getTypeForPrimitiveNumericClass(_thisHandle, &pException, cls);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int canCast(void* child, void* parent)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->canCast(_thisHandle, &pException, child, parent);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int areTypesEquivalent(void* cls1, void* cls2)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->areTypesEquivalent(_thisHandle, &pException, cls1, cls2);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int compareTypesForCast(void* fromClass, void* toClass)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->compareTypesForCast(_thisHandle, &pException, fromClass, toClass);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int compareTypesForEquality(void* cls1, void* cls2)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->compareTypesForEquality(_thisHandle, &pException, cls1, cls2);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void* mergeClasses(void* cls1, void* cls2)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->mergeClasses(_thisHandle, &pException, cls1, cls2);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void* getParentType(void* cls)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->getParentType(_thisHandle, &pException, cls);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int getChildType(void* clsHnd, void* clsRet)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->getChildType(_thisHandle, &pException, clsHnd, clsRet);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int satisfiesClassConstraints(void* cls)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->satisfiesClassConstraints(_thisHandle, &pException, cls);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int isSDArray(void* cls)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->isSDArray(_thisHandle, &pException, cls);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual unsigned getArrayRank(void* cls)
    {
        CorInfoException* pException = nullptr;
        unsigned _ret = _callbacks->getArrayRank(_thisHandle, &pException, cls);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void* getArrayInitializationData(void* field, unsigned int size)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->getArrayInitializationData(_thisHandle, &pException, field, size);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int canAccessClass(void* pResolvedToken, void* callerHandle, void* pAccessHelper)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->canAccessClass(_thisHandle, &pException, pResolvedToken, callerHandle, pAccessHelper);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual const char* getFieldName(void* ftn, const char** moduleName)
    {
        CorInfoException* pException = nullptr;
        const char* _ret = _callbacks->getFieldName(_thisHandle, &pException, ftn, moduleName);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void* getFieldClass(void* field)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->getFieldClass(_thisHandle, &pException, field);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int getFieldType(void* field, void* structType, void* memberParent)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->getFieldType(_thisHandle, &pException, field, structType, memberParent);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual unsigned getFieldOffset(void* field)
    {
        CorInfoException* pException = nullptr;
        unsigned _ret = _callbacks->getFieldOffset(_thisHandle, &pException, field);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual bool isWriteBarrierHelperRequired(void* field)
    {
        CorInfoException* pException = nullptr;
        bool _ret = _callbacks->isWriteBarrierHelperRequired(_thisHandle, &pException, field);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void getFieldInfo(void* pResolvedToken, void* callerHandle, int flags, void* pResult)
    {
        CorInfoException* pException = nullptr;
        _callbacks->getFieldInfo(_thisHandle, &pException, pResolvedToken, callerHandle, flags, pResult);
        if (pException != nullptr)
            throw pException;
    }

    virtual bool isFieldStatic(void* fldHnd)
    {
        CorInfoException* pException = nullptr;
        bool _ret = _callbacks->isFieldStatic(_thisHandle, &pException, fldHnd);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void getBoundaries(void* ftn, unsigned int* cILOffsets, unsigned int** pILOffsets, void* implictBoundaries)
    {
        CorInfoException* pException = nullptr;
        _callbacks->getBoundaries(_thisHandle, &pException, ftn, cILOffsets, pILOffsets, implictBoundaries);
        if (pException != nullptr)
            throw pException;
    }

    virtual void setBoundaries(void* ftn, unsigned int cMap, void* pMap)
    {
        CorInfoException* pException = nullptr;
        _callbacks->setBoundaries(_thisHandle, &pException, ftn, cMap, pMap);
        if (pException != nullptr)
            throw pException;
    }

    virtual void getVars(void* ftn, unsigned int* cVars, void* vars, bool* extendOthers)
    {
        CorInfoException* pException = nullptr;
        _callbacks->getVars(_thisHandle, &pException, ftn, cVars, vars, extendOthers);
        if (pException != nullptr)
            throw pException;
    }

    virtual void setVars(void* ftn, unsigned int cVars, void* vars)
    {
        CorInfoException* pException = nullptr;
        _callbacks->setVars(_thisHandle, &pException, ftn, cVars, vars);
        if (pException != nullptr)
            throw pException;
    }

    virtual void* allocateArray(unsigned int cBytes)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->allocateArray(_thisHandle, &pException, cBytes);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void freeArray(void* array)
    {
        CorInfoException* pException = nullptr;
        _callbacks->freeArray(_thisHandle, &pException, array);
        if (pException != nullptr)
            throw pException;
    }

    virtual void* getArgNext(void* args)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->getArgNext(_thisHandle, &pException, args);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int getArgType(void* sig, void* args, void* vcTypeRet)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->getArgType(_thisHandle, &pException, sig, args, vcTypeRet);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void* getArgClass(void* sig, void* args)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->getArgClass(_thisHandle, &pException, sig, args);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int getHFAType(void* hClass)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->getHFAType(_thisHandle, &pException, hClass);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int GetErrorHRESULT(void* pExceptionPointers)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->GetErrorHRESULT(_thisHandle, &pException, pExceptionPointers);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual unsigned int GetErrorMessage(wchar_t* buffer, unsigned int bufferLength)
    {
        CorInfoException* pException = nullptr;
        unsigned int _ret = _callbacks->GetErrorMessage(_thisHandle, &pException, buffer, bufferLength);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int FilterException(void* pExceptionPointers);
    virtual void HandleException(void* pExceptionPointers);
    virtual void ThrowExceptionForJitResult(int result)
    {
        CorInfoException* pException = nullptr;
        _callbacks->ThrowExceptionForJitResult(_thisHandle, &pException, result);
        if (pException != nullptr)
            throw pException;
    }

    virtual void ThrowExceptionForHelper(const void* throwHelper)
    {
        CorInfoException* pException = nullptr;
        _callbacks->ThrowExceptionForHelper(_thisHandle, &pException, throwHelper);
        if (pException != nullptr)
            throw pException;
    }

    virtual bool runWithErrorTrap(void* function, void* parameter);
    virtual void getEEInfo(void* pEEInfoOut)
    {
        CorInfoException* pException = nullptr;
        _callbacks->getEEInfo(_thisHandle, &pException, pEEInfoOut);
        if (pException != nullptr)
            throw pException;
    }

    virtual const wchar_t* getJitTimeLogFilename()
    {
        CorInfoException* pException = nullptr;
        const wchar_t* _ret = _callbacks->getJitTimeLogFilename(_thisHandle, &pException);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual unsigned int getMethodDefFromMethod(void* hMethod)
    {
        CorInfoException* pException = nullptr;
        unsigned int _ret = _callbacks->getMethodDefFromMethod(_thisHandle, &pException, hMethod);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual const char* getMethodName(void* ftn, const char** moduleName)
    {
        CorInfoException* pException = nullptr;
        const char* _ret = _callbacks->getMethodName(_thisHandle, &pException, ftn, moduleName);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual const char* getMethodNameFromMetadata(void* ftn, const char** className, const char** namespaceName)
    {
        CorInfoException* pException = nullptr;
        const char* _ret = _callbacks->getMethodNameFromMetadata(_thisHandle, &pException, ftn, className, namespaceName);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual unsigned getMethodHash(void* ftn)
    {
        CorInfoException* pException = nullptr;
        unsigned _ret = _callbacks->getMethodHash(_thisHandle, &pException, ftn);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual size_t findNameOfToken(void* moduleHandle, unsigned int token, char* szFQName, size_t FQNameCapacity)
    {
        CorInfoException* pException = nullptr;
        size_t _ret = _callbacks->findNameOfToken(_thisHandle, &pException, moduleHandle, token, szFQName, FQNameCapacity);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual bool getSystemVAmd64PassStructInRegisterDescriptor(void* structHnd, void* structPassInRegDescPtr)
    {
        CorInfoException* pException = nullptr;
        bool _ret = _callbacks->getSystemVAmd64PassStructInRegisterDescriptor(_thisHandle, &pException, structHnd, structPassInRegDescPtr);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual unsigned int getThreadTLSIndex(void** ppIndirection)
    {
        CorInfoException* pException = nullptr;
        unsigned int _ret = _callbacks->getThreadTLSIndex(_thisHandle, &pException, ppIndirection);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual const void* getInlinedCallFrameVptr(void** ppIndirection)
    {
        CorInfoException* pException = nullptr;
        const void* _ret = _callbacks->getInlinedCallFrameVptr(_thisHandle, &pException, ppIndirection);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual long* getAddrOfCaptureThreadGlobal(void** ppIndirection)
    {
        CorInfoException* pException = nullptr;
        long* _ret = _callbacks->getAddrOfCaptureThreadGlobal(_thisHandle, &pException, ppIndirection);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void* getHelperFtn(int ftnNum, void** ppIndirection)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->getHelperFtn(_thisHandle, &pException, ftnNum, ppIndirection);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void getFunctionEntryPoint(void* ftn, void* pResult, int accessFlags)
    {
        CorInfoException* pException = nullptr;
        _callbacks->getFunctionEntryPoint(_thisHandle, &pException, ftn, pResult, accessFlags);
        if (pException != nullptr)
            throw pException;
    }

    virtual void getFunctionFixedEntryPoint(void* ftn, void* pResult)
    {
        CorInfoException* pException = nullptr;
        _callbacks->getFunctionFixedEntryPoint(_thisHandle, &pException, ftn, pResult);
        if (pException != nullptr)
            throw pException;
    }

    virtual void* getMethodSync(void* ftn, void** ppIndirection)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->getMethodSync(_thisHandle, &pException, ftn, ppIndirection);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int getLazyStringLiteralHelper(void* handle)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->getLazyStringLiteralHelper(_thisHandle, &pException, handle);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void* embedModuleHandle(void* handle, void** ppIndirection)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->embedModuleHandle(_thisHandle, &pException, handle, ppIndirection);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void* embedClassHandle(void* handle, void** ppIndirection)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->embedClassHandle(_thisHandle, &pException, handle, ppIndirection);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void* embedMethodHandle(void* handle, void** ppIndirection)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->embedMethodHandle(_thisHandle, &pException, handle, ppIndirection);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void* embedFieldHandle(void* handle, void** ppIndirection)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->embedFieldHandle(_thisHandle, &pException, handle, ppIndirection);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void embedGenericHandle(void* pResolvedToken, int fEmbedParent, void* pResult)
    {
        CorInfoException* pException = nullptr;
        _callbacks->embedGenericHandle(_thisHandle, &pException, pResolvedToken, fEmbedParent, pResult);
        if (pException != nullptr)
            throw pException;
    }

    virtual CORINFO_LOOKUP_KIND getLocationOfThisType(void* context);
    virtual void* getPInvokeUnmanagedTarget(void* method, void** ppIndirection)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->getPInvokeUnmanagedTarget(_thisHandle, &pException, method, ppIndirection);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void* getAddressOfPInvokeFixup(void* method, void** ppIndirection)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->getAddressOfPInvokeFixup(_thisHandle, &pException, method, ppIndirection);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void getAddressOfPInvokeTarget(void* method, void* pLookup)
    {
        CorInfoException* pException = nullptr;
        _callbacks->getAddressOfPInvokeTarget(_thisHandle, &pException, method, pLookup);
        if (pException != nullptr)
            throw pException;
    }

    virtual void* GetCookieForPInvokeCalliSig(void* szMetaSig, void** ppIndirection)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->GetCookieForPInvokeCalliSig(_thisHandle, &pException, szMetaSig, ppIndirection);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual bool canGetCookieForPInvokeCalliSig(void* szMetaSig)
    {
        CorInfoException* pException = nullptr;
        bool _ret = _callbacks->canGetCookieForPInvokeCalliSig(_thisHandle, &pException, szMetaSig);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void* getJustMyCodeHandle(void* method, void** ppIndirection)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->getJustMyCodeHandle(_thisHandle, &pException, method, ppIndirection);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void GetProfilingHandle(int* pbHookFunction, void** pProfilerHandle, int* pbIndirectedHandles)
    {
        CorInfoException* pException = nullptr;
        _callbacks->GetProfilingHandle(_thisHandle, &pException, pbHookFunction, pProfilerHandle, pbIndirectedHandles);
        if (pException != nullptr)
            throw pException;
    }

    virtual void getCallInfo(void* pResolvedToken, void* pConstrainedResolvedToken, void* callerHandle, int flags, void* pResult)
    {
        CorInfoException* pException = nullptr;
        _callbacks->getCallInfo(_thisHandle, &pException, pResolvedToken, pConstrainedResolvedToken, callerHandle, flags, pResult);
        if (pException != nullptr)
            throw pException;
    }

    virtual int canAccessFamily(void* hCaller, void* hInstanceType)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->canAccessFamily(_thisHandle, &pException, hCaller, hInstanceType);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int isRIDClassDomainID(void* cls)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->isRIDClassDomainID(_thisHandle, &pException, cls);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual unsigned getClassDomainID(void* cls, void** ppIndirection)
    {
        CorInfoException* pException = nullptr;
        unsigned _ret = _callbacks->getClassDomainID(_thisHandle, &pException, cls, ppIndirection);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void* getFieldAddress(void* field, void** ppIndirection)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->getFieldAddress(_thisHandle, &pException, field, ppIndirection);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void* getVarArgsHandle(void* pSig, void** ppIndirection)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->getVarArgsHandle(_thisHandle, &pException, pSig, ppIndirection);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual bool canGetVarArgsHandle(void* pSig)
    {
        CorInfoException* pException = nullptr;
        bool _ret = _callbacks->canGetVarArgsHandle(_thisHandle, &pException, pSig);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int constructStringLiteral(void* module, unsigned int metaTok, void** ppValue)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->constructStringLiteral(_thisHandle, &pException, module, metaTok, ppValue);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int emptyStringLiteral(void** ppValue)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->emptyStringLiteral(_thisHandle, &pException, ppValue);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual unsigned int getFieldThreadLocalStoreID(void* field, void** ppIndirection)
    {
        CorInfoException* pException = nullptr;
        unsigned int _ret = _callbacks->getFieldThreadLocalStoreID(_thisHandle, &pException, field, ppIndirection);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void setOverride(void* pOverride, void* currentMethod)
    {
        CorInfoException* pException = nullptr;
        _callbacks->setOverride(_thisHandle, &pException, pOverride, currentMethod);
        if (pException != nullptr)
            throw pException;
    }

    virtual void addActiveDependency(void* moduleFrom, void* moduleTo)
    {
        CorInfoException* pException = nullptr;
        _callbacks->addActiveDependency(_thisHandle, &pException, moduleFrom, moduleTo);
        if (pException != nullptr)
            throw pException;
    }

    virtual void* GetDelegateCtor(void* methHnd, void* clsHnd, void* targetMethodHnd, void* pCtorData)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->GetDelegateCtor(_thisHandle, &pException, methHnd, clsHnd, targetMethodHnd, pCtorData);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void MethodCompileComplete(void* methHnd)
    {
        CorInfoException* pException = nullptr;
        _callbacks->MethodCompileComplete(_thisHandle, &pException, methHnd);
        if (pException != nullptr)
            throw pException;
    }

    virtual void* getTailCallCopyArgsThunk(void* pSig, int flags)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->getTailCallCopyArgsThunk(_thisHandle, &pException, pSig, flags);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual bool convertPInvokeCalliToCall(void* pResolvedToken, bool mustConvert)
    {
        CorInfoException* pException = nullptr;
        bool _ret = _callbacks->convertPInvokeCalliToCall(_thisHandle, &pException, pResolvedToken, mustConvert);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void* getMemoryManager();
    virtual void allocMem(unsigned int hotCodeSize, unsigned int coldCodeSize, unsigned int roDataSize, unsigned int xcptnsCount, int flag, void** hotCodeBlock, void** coldCodeBlock, void** roDataBlock)
    {
        CorInfoException* pException = nullptr;
        _callbacks->allocMem(_thisHandle, &pException, hotCodeSize, coldCodeSize, roDataSize, xcptnsCount, flag, hotCodeBlock, coldCodeBlock, roDataBlock);
        if (pException != nullptr)
            throw pException;
    }

    virtual void reserveUnwindInfo(int isFunclet, int isColdCode, unsigned int unwindSize)
    {
        CorInfoException* pException = nullptr;
        _callbacks->reserveUnwindInfo(_thisHandle, &pException, isFunclet, isColdCode, unwindSize);
        if (pException != nullptr)
            throw pException;
    }

    virtual void allocUnwindInfo(unsigned char* pHotCode, unsigned char* pColdCode, unsigned int startOffset, unsigned int endOffset, unsigned int unwindSize, unsigned char* pUnwindBlock, int funcKind)
    {
        CorInfoException* pException = nullptr;
        _callbacks->allocUnwindInfo(_thisHandle, &pException, pHotCode, pColdCode, startOffset, endOffset, unwindSize, pUnwindBlock, funcKind);
        if (pException != nullptr)
            throw pException;
    }

    virtual void* allocGCInfo(size_t size)
    {
        CorInfoException* pException = nullptr;
        void* _ret = _callbacks->allocGCInfo(_thisHandle, &pException, size);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void yieldExecution()
    {
        CorInfoException* pException = nullptr;
        _callbacks->yieldExecution(_thisHandle, &pException);
        if (pException != nullptr)
            throw pException;
    }

    virtual void setEHcount(unsigned cEH)
    {
        CorInfoException* pException = nullptr;
        _callbacks->setEHcount(_thisHandle, &pException, cEH);
        if (pException != nullptr)
            throw pException;
    }

    virtual void setEHinfo(unsigned EHnumber, void* clause)
    {
        CorInfoException* pException = nullptr;
        _callbacks->setEHinfo(_thisHandle, &pException, EHnumber, clause);
        if (pException != nullptr)
            throw pException;
    }

    virtual int logMsg(unsigned level, const char* fmt, va_list args)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->logMsg(_thisHandle, &pException, level, fmt, args);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int doAssert(const char* szFile, int iLine, const char* szExpr)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->doAssert(_thisHandle, &pException, szFile, iLine, szExpr);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void reportFatalError(int result)
    {
        CorInfoException* pException = nullptr;
        _callbacks->reportFatalError(_thisHandle, &pException, result);
        if (pException != nullptr)
            throw pException;
    }

    virtual int allocBBProfileBuffer(unsigned int count, void** profileBuffer)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->allocBBProfileBuffer(_thisHandle, &pException, count, profileBuffer);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual int getBBProfileData(void* ftnHnd, unsigned long* count, void** profileBuffer, unsigned long* numRuns)
    {
        CorInfoException* pException = nullptr;
        int _ret = _callbacks->getBBProfileData(_thisHandle, &pException, ftnHnd, count, profileBuffer, numRuns);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void recordCallSite(unsigned int instrOffset, void* callSig, void* methodHandle)
    {
        CorInfoException* pException = nullptr;
        _callbacks->recordCallSite(_thisHandle, &pException, instrOffset, callSig, methodHandle);
        if (pException != nullptr)
            throw pException;
    }

    virtual void recordRelocation(void* location, void* target, unsigned short fRelocType, unsigned short slotNum, int addlDelta)
    {
        CorInfoException* pException = nullptr;
        _callbacks->recordRelocation(_thisHandle, &pException, location, target, fRelocType, slotNum, addlDelta);
        if (pException != nullptr)
            throw pException;
    }

    virtual unsigned short getRelocTypeHint(void* target)
    {
        CorInfoException* pException = nullptr;
        unsigned short _ret = _callbacks->getRelocTypeHint(_thisHandle, &pException, target);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual void getModuleNativeEntryPointRange(void** pStart, void** pEnd)
    {
        CorInfoException* pException = nullptr;
        _callbacks->getModuleNativeEntryPointRange(_thisHandle, &pException, pStart, pEnd);
        if (pException != nullptr)
            throw pException;
    }

    virtual unsigned int getExpectedTargetArchitecture()
    {
        CorInfoException* pException = nullptr;
        unsigned int _ret = _callbacks->getExpectedTargetArchitecture(_thisHandle, &pException);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

    virtual unsigned int getJitFlags(void* flags, unsigned int sizeInBytes)
    {
        CorInfoException* pException = nullptr;
        unsigned int _ret = _callbacks->getJitFlags(_thisHandle, &pException, flags, sizeInBytes);
        if (pException != nullptr)
            throw pException;
        return _ret;
    }

};
