.TH PICK %manext1% 2016-03-12 "%nmhversion%"
.
.\" %nmhwarning%
.
.SH NAME
pick \- search nmh messages
.SH SYNOPSIS
.HP 5
.na
.B pick
.RB [ \-help ]
.RB [ \-version ]
.RI [ +folder ]
.RI [ msgs ]
.RB [ \-reverse
\&...]
.RB [ \-and
\&...]
.RB [ \-or
\&...]
.RB [ \-not
\&...]
.RB [ \-lbrace
\&...
.BR \-rbrace ]
.RB [ \-\|\-component
.IR pattern ]
.RB [ \-cc
.IR pattern ]
.RB [ \-date
.IR pattern ]
.RB [ \-from
.IR pattern ]
.RB [ \-search
.IR pattern ]
.RB [ \-subject
.IR pattern ]
.RB [ \-to
.IR pattern ]
.RB [ \-after
.IR date ]
.RB [ \-before
.IR date ]
.RB [ \-datefield
.IR field ]
.RB [ \-sequence
.I name
\&...]
.RB [ \-nosequence ]
.RB [ \-public " | " \-nopublic ]
.RB [ \-zero " | " \-nozero ]
.RB [ \-list " | " \-nolist ]
.RB [ \-debug ]
.PP
typical usage:
.PP
.RS 5
.nf
scan\0\`pick\0\-from\0jones\`
pick\0\-to\0holloway\0\-sequence\0select
show\0\`pick\0\-before\0friday\`
.fi
.RE
.ad
.SH DESCRIPTION
.B pick
searches within a folder for messages with the specified
contents, and then identifies those messages.  Two types of search
primitives are available: pattern matching and date constraint
operations.
.PP
A modified
.IR grep (1)
is used to perform the matching, so the full regular expression (see
.IR ed (1))
facility is available within
.IR pattern .
With
.BR \-search ,
.I pattern
is used directly, and with the others, the grep pattern constructed is:
.PP
.RS 5
`component[ \\t]*:.*pattern'
.RE
.PP
This means that the pattern specified for a
.B \-search
will be found everywhere in the message, including the header and the body,
while the other pattern matching requests are limited to the single specified
component.  The expression
.PP
.RS 5
`\-\|\-component\ pattern'
.RE
.PP
is a shorthand for specifying
.PP
.RS 5
`\-search \*(lqcomponent[ \\t]*:.*pattern\*(rq\ '
.RE
.PP
It is used to pick a component which is not one of \*(lqTo:\*(rq,
\*(lqcc:\*(rq, \*(lqDate:\*(rq, \*(lqFrom:\*(rq, or \*(lqSubject:\*(rq.
An example is
.RB \*(lq "pick\0\-\|\-reply\-to\0pooh" \*(rq.
.PP
Pattern matching is performed on a per-line basis.  Within the header
of the message, each component is treated as one long line, but in the
body, each line is separate.  Lower-case letters in the search pattern
will match either lower or upper case in the message, while upper case
will match only upper case.
.PP
Note that since the
.B \-date
switch is a pattern matching operation (as described above),
to find messages sent on a certain date the pattern string must match
the text of the \*(lqDate:\*(rq field of the message.
.PP
Independent of any pattern matching operations requested, the switches
.B \-after
.I date
or
.B \-before
.I date
may also be used to introduce date/time constraints on all of the messages.
By default, the \*(lqDate:\*(rq field is consulted, but if another
date-yielding field (such as \*(lqBB\-Posted:\*(rq or
\*(lqDelivery\-Date:\*(rq) should be used, the
.B \-datefield
.I field
switch may be used.
.PP
With
.B \-before
and
.BR \-after ,
.B pick
will actually parse the date fields in each of the messages specified in
`msgs' and compare them to the date/time specified.  If
.B \-after
is given, then only those messages whose \*(lqDate:\*(rq field value is
chronologically after the date specified will be considered.  The
.B \-before
switch specifies the complementary action.
.PP
Both the
.B \-after
and
.B \-before
switches take legal RFC 822-style date specifications as arguments.
.B pick
will default certain missing fields so that the entire date need not
be specified.  These fields are (in order of defaulting): timezone,
time and timezone, date, date and timezone.
All defaults are taken from the current date, time, and timezone.
.PP
In addition to RFC 822-style dates,
.B pick
will also recognize any of the days of the week (\*(lqsunday\*(rq,
\*(lqmonday\*(rq, and so on), and the special dates \*(lqtoday\*(rq,
\*(lqyesterday\*(rq (24 hours ago), and \*(lqtomorrow\*(rq
(24 hours from now).
All days of the week are judged to refer to a day in the past
(e.g., telling \fIpick\fR \*(lqsaturday\*(rq on a \*(lqtuesday\*(rq
means \*(lqlast\ saturday\*(rq not \*(lqthis\ saturday\*(rq).
.PP
Finally, in addition to these special specifications,
.B pick
will also honor a specification of the form \*(lq\-dd\*(rq, which means
\*(lqdd days ago\*(rq.
.PP
Use the
.B \-reverse
switch to make
.B pick
find matching messages in reverse order, working from the highest message
number down to the lowest.  This can be useful in searching for recent
messages in large folders, for example,
.PP
.RS 5
.nf
pick\0\-reverse\0\-from\0frated\0|\0xargs\0\-n1\0scan
.fi
.RE
.PP
.B pick
supports complex boolean operations on the searching primitives with the
.BR \-and ,
.BR \-or ,
.BR \-not ,
and
.B \-lbrace
.B \&...
.B \-rbrace
switches.
For example,
.PP
.RS 5
.nf
pick\0\-after\0yesterday\0\-and
     \-lbrace\0\-from\0freida\0\-or\0\-from\0fear\0\-rbrace
.fi
.RE
.PP
identifies messages recently sent by \*(lqfrieda\*(rq or \*(lqfear\*(rq.
.PP
The matching primitives take precedence over the
.B \-not
switch, which in turn takes precedence over
.B \-and
which in turn takes precedence over
.BR \-or .
To override the default precedence, the
.B \-lbrace
and
.B \-rbrace
switches are provided, which act just like opening and closing
parentheses in logical expressions.
.PP
If no search criteria are given, all the messages specified on the
command line are selected (this defaults to \*(lqall\*(rq).
.PP
Once the search has been performed, if the
.B \-list
switch is given, the message numbers of the selected messages are
written to the standard output separated by newlines.  This is
.I extremely
useful for quickly generating arguments for other
.B nmh
programs by using the \*(lqbackquoting\*(rq syntax of the shell.
For example, the command
.PP
.RS 5
scan\0\`pick\0+todo\0\-after\0\*(lq31 Mar 83 0123 PST\*(rq\`
.RE
.PP
says to
.B scan
those messages in the indicated folder which meet the appropriate
criterion.  Note that since
.BR pick 's
context changes are written out prior to
.BR scan 's
invocation, you need not give the folder argument to
.B scan
as well.
.PP
The
.B \-sequence
.I name
switch may be given once for each sequence the user wishes to define.
For each sequence named, that sequence will be defined to mean exactly
those messages selected by
.BR pick .
For example,
.PP
.RS 5
pick\0\-from\0frated\0\-seq\0fred
.RE
.PP
defines a new message sequence for the current folder called
\*(lqfred\*(rq which contains exactly those messages that were selected.
.PP
The
.B \-nosequence
switch will disable all previously named sequences, allowing
those established by a profile component to be overridden.
.PP
By default,
.B pick
will zero a sequence before adding it.  This action can be disabled with the
.B \-nozero
switch, which means that the messages selected by
.B pick
will be added to the sequence, if it already exists, and any messages
already a part of that sequence will remain so.
.PP
The
.B \-public
and
.B \-nopublic
switches are used by
.B pick
in the same way
.B mark
uses them.
.PP
The
.B \-debug
switch causes pick to output a representation of the search pattern.
.SS "Output when no messages are matched"
If
.B pick
is used in a backquoted operation, such as
.PP
.RS 5
scan\0\`pick\0\-from\0jones\`
.RE
.PP
and
.B pick
selects no messages (e.g., no messages are from \*(lqjones\*(rq),
then the shell will still run the outer command (e.g.,
.BR scan ).
Since no messages were matched,
.B pick
produced no output, and the argument given to the outer command as a
result of backquoting
.B pick
is empty.  In the case of
.B nmh
programs, the outer command now acts as if the default `msg' or `msgs'
should be used (e.g., \*(lqall\*(rq in the case of
.BR scan ).
To prevent this unexpected behavior, if
.B \-list
was given, and if its standard output is not a tty, then
.B pick
outputs the illegal message number \*(lq0\*(rq when it fails.
This lets the outer command fail gracefully as well.
.SH FILES
.fc ^ ~
.nf
.ta \w'%nmhetcdir%/ExtraBigFileName  'u
^$HOME/.mh_profile~^The user profile
.fi
.SH "PROFILE COMPONENTS"
.fc ^ ~
.nf
.ta 2.4i
.ta \w'ExtraBigProfileName  'u
^Path:~^To determine the user's nmh directory
^Current\-Folder:~^To find the default current folder
.fi
.SH "SEE ALSO"
.IR mark (1)
.SH DEFAULTS
.nf
.RB ` +folder "' defaults to the current folder"
.RB ` msgs "' defaults to all"
.RB ` "\-datefield date" '
.RB ` \-zero '
.RB ` \-list "' is the default if no `\-sequence', `\-nolist' otherwise"
.fi
.SH CONTEXT
If a folder is given, it will become the current folder.
.SH HISTORY
In previous versions of
.BR MH ,
the
.B pick
command would
.BR show ,
.BR scan ,
or
.B refile
the selected messages.  This was rather
\*(lqinverted logic\*(rq from the Unix point of view, so
.B pick
was changed to define sequences and output those sequences.  Hence,
.B pick
can be used to generate the arguments for all other
.B MH
commands, instead of giving
.B pick
endless switches for invoking those commands
itself.
.PP
Also, previous versions of
.B pick
balked if you didn't specify
a search string or a date/time constraint.  The current version does
not, and merely matches the messages you specify.  This lets you type
something like:
.PP
.RS 5
show\0\`pick\0last:20\0\-seq\0fear\`
.RE
.PP
instead of typing
.PP
.RS 5
.nf
mark\0\-add\0\-nozero\0\-seq\0fear\0last:20
show\0fear
.fi
.RE
.PP
Finally, timezones used to be ignored when comparing dates: they aren't
any more.
.SH "HELPFUL HINTS"
Use
.RB \*(lq "pick sequence \-list" \*(rq
to enumerate the messages in a sequence
(such as for use by a shell script).
.SH BUGS
Any occurrence of
.B \-datefield
must occur prior to the
.B \-after
or
.B \-before
switch it applies to.
.PP
The pattern syntax \*(lq[l-r]\*(rq is not supported; each letter to be
matched must be included within the square brackets.
