"use strict";
class Base {
}

let called = false;
class Obj extends Base {
  get test() {
    called = true;
  }

  set() {
    return super.test = 3;
  }
}

const obj = new Obj();
// This is incorrect according to the spec,
// but close enough for loose.
// expect(obj.set()).toBe(3);
expect(() => {
  obj.set();
}).toThrow(TypeError);

expect(called).toBe(false);
expect(Base.prototype.test).toBeUndefined();
expect(Obj.prototype.test).toBeUndefined();
expect(obj.test).toBe(undefined);
