// Generated by LiveScript 1.6.0
var ref$, max, min, negate, abs, signum, quot, rem, div, mod, recip, pi, tau, exp, sqrt, ln, pow, sin, tan, cos, acos, asin, atan, atan2, truncate, round, ceiling, floor, isItNaN, even, odd, gcd, lcm, eq, deepEq, ok;
ref$ = require('../..'), max = ref$.max, min = ref$.min, negate = ref$.negate, abs = ref$.abs, signum = ref$.signum, quot = ref$.quot, rem = ref$.rem, div = ref$.div, mod = ref$.mod, recip = ref$.recip, pi = ref$.pi, tau = ref$.tau, exp = ref$.exp, sqrt = ref$.sqrt, ln = ref$.ln, pow = ref$.pow, sin = ref$.sin, tan = ref$.tan, cos = ref$.cos, acos = ref$.acos, asin = ref$.asin, atan = ref$.atan, atan2 = ref$.atan2, truncate = ref$.truncate, round = ref$.round, ceiling = ref$.ceiling, floor = ref$.floor, isItNaN = ref$.isItNaN, even = ref$.even, odd = ref$.odd, gcd = ref$.gcd, lcm = ref$.lcm;
ref$ = require('assert'), eq = ref$.strictEqual, deepEq = ref$.deepEqual, ok = ref$.ok;
suite('max', function(){
  test('numbers', function(){
    eq(3, max(3, 3));
    eq(3, max(2, 3));
    return eq(3, max(3, 2));
  });
  test('characters', function(){
    return eq('b', max('a', 'b'));
  });
  return test('curried', function(){
    var f;
    f = max(2);
    return eq(3, f(3));
  });
});
suite('min', function(){
  test('numbers', function(){
    return eq(0, min(9, 0));
  });
  test('characters', function(){
    return eq('a', min('a', 'b'));
  });
  return test('curried', function(){
    var f;
    f = min(9);
    return eq(0, f(0));
  });
});
suite('negate', function(){
  test('zero', function(){
    return eq(-0, negate(0));
  });
  test('negative number', function(){
    return eq(-2, negate(2));
  });
  return test('positive number', function(){
    return eq(3, negate(-3));
  });
});
suite('abs', function(){
  test('zero', function(){
    return eq(0, abs(0));
  });
  test('negative number', function(){
    return eq(4, abs(-4));
  });
  return test('positive number', function(){
    return eq(4, abs(4));
  });
});
suite('signum', function(){
  test('zero', function(){
    return eq(0, signum(0));
  });
  test('negative number', function(){
    return eq(-1, signum(-5.3));
  });
  return test('positive number', function(){
    return eq(1, signum(8));
  });
});
suite('quot', function(){
  test('simple', function(){
    return eq(-6, quot(-20, 3));
  });
  return test('curried', function(){
    var f;
    f = quot(-20);
    return eq(-6, f(3));
  });
});
suite('rem', function(){
  test('simple', function(){
    return eq(-2, rem(-20, 3));
  });
  return test('curried', function(){
    var f;
    f = rem(-20);
    return eq(-2, f(3));
  });
});
suite('div', function(){
  test('simple', function(){
    return eq(-7, div(-20, 3));
  });
  return test('curried', function(){
    var f;
    f = div(-20);
    return eq(-7, f(3));
  });
});
suite('mod', function(){
  test('simple', function(){
    return eq(1, mod(-20, 3));
  });
  return test('curried', function(){
    var f;
    f = mod(-20);
    return eq(1, f(3));
  });
});
suite('recip', function(){
  test('zero', function(){
    return eq(Infinity, recip(0));
  });
  test('larger than 1', function(){
    return eq(0.5, recip(2));
  });
  return test('between 0 and 1', function(){
    return eq(2, recip(0.5));
  });
});
suite('pi', function(){
  return test('constant', function(){
    return eq(3.141592653589793, pi);
  });
});
suite('tau', function(){
  return test('constant', function(){
    return eq(6.283185307179586, tau);
  });
});
suite('exp', function(){
  return test('simple', function(){
    return eq(2.718281828459045, exp(1));
  });
});
suite('sqrt', function(){
  test('negative numbers', function(){
    return ok(isItNaN(sqrt(-1)));
  });
  return test('simple', function(){
    return eq(2, sqrt(4));
  });
});
suite('ln', function(){
  return test('simple', function(){
    return eq(0.6931471805599453, ln(2));
  });
});
suite('pow', function(){
  test('simple', function(){
    eq(4, pow(2, 2));
    return eq(4, pow(-2, 2));
  });
  test('with negative numbers', function(){
    return eq(0.25, pow(2, -2));
  });
  test('between one and zero', function(){
    return eq(4, pow(16, 0.5));
  });
  return test('curried', function(){
    var f;
    f = pow(2);
    return eq(4, f(2));
  });
});
suite('sin', function(){
  test('zero', function(){
    return eq(0, sin(0));
  });
  return test('pi/2', function(){
    return eq(1, sin(pi / 2));
  });
});
suite('tan', function(){
  return test('zero', function(){
    return eq(0, tan(0));
  });
});
suite('cos', function(){
  test('zero', function(){
    return eq(1, cos(0));
  });
  return test('pi', function(){
    return eq(-1, cos(pi));
  });
});
suite('acos', function(){
  return test('number', function(){
    return eq(1.4706289056333368, acos(0.1));
  });
});
suite('asin', function(){
  return test('number', function(){
    return eq(1.5707963267948966, asin(1));
  });
});
suite('atan', function(){
  return test('number', function(){
    return eq(0.7853981633974483, atan(1));
  });
});
suite('atan2', function(){
  test('number', function(){
    return eq(0.4636476090008061, atan2(1, 2));
  });
  return test('curried', function(){
    var f;
    f = atan2(1);
    return eq(0.4636476090008061, f(2));
  });
});
suite('truncate', function(){
  test('zero', function(){
    return eq(0, truncate(0));
  });
  test('positive number', function(){
    return eq(1, truncate(1.5));
  });
  return test('negative number', function(){
    return eq(-1, truncate(-1.5));
  });
});
suite('round', function(){
  test('up', function(){
    eq(1, round(0.6));
    return eq(1, round(0.5));
  });
  return test('down', function(){
    return eq(0, round(0.4));
  });
});
suite('ceiling', function(){
  test('zero', function(){
    return eq(0, ceiling(0));
  });
  test('positive number', function(){
    return eq(1, ceiling(0.1));
  });
  return test('negative number', function(){
    return eq(-0, ceiling(-0.9));
  });
});
suite('floor', function(){
  test('zero', function(){
    return eq(0, floor(0));
  });
  test('positive number', function(){
    return eq(0, floor(0.9));
  });
  return test('negative number', function(){
    return eq(-1, floor(-0.1));
  });
});
suite('is-it-NaN', function(){
  test('true', function(){
    return ok(isItNaN(Math.sqrt(-1)));
  });
  return test('false', function(){
    return ok(!isItNaN('0'));
  });
});
suite('even', function(){
  test('true', function(){
    ok(even(0));
    return ok(even(-2));
  });
  return test('false', function(){
    return ok(!even(7));
  });
});
suite('odd', function(){
  test('true', function(){
    return ok(odd(3));
  });
  return test('false', function(){
    ok(!odd(-4));
    return ok(!odd(0));
  });
});
suite('gcd', function(){
  test('some numbers', function(){
    return eq(6, gcd(12, 18));
  });
  return test('curried', function(){
    var f;
    f = gcd(12);
    return eq(6, f(18));
  });
});
suite('lcm', function(){
  test('some numbers', function(){
    return eq(36, lcm(12, 18));
  });
  return test('curried', function(){
    var f;
    f = lcm(12);
    return eq(36, f(18));
  });
});
