/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.validator;

import java.util.Map;
import org.apache.turbine.om.NumberKey;
import org.apache.turbine.services.intake.validator.Constraint;
import org.apache.turbine.services.intake.validator.NumberValidator;
import org.apache.turbine.services.intake.validator.ValidationException;
import org.apache.turbine.util.TurbineException;

public class NumberKeyValidator
extends NumberValidator {
    private static String INVALID_NUMBER = "Entry was not valid.";
    private NumberKey minValue;
    private NumberKey maxValue;

    protected void doInit(Map paramMap) {
        String param;
        this.minValue = null;
        this.maxValue = null;
        Constraint constraint = (Constraint)paramMap.get("minValue");
        if (constraint != null) {
            param = constraint.getValue();
            this.minValue = new NumberKey(param);
            this.minValueMessage = constraint.getMessage();
        }
        if ((constraint = (Constraint)paramMap.get("maxValue")) != null) {
            param = constraint.getValue();
            this.maxValue = new NumberKey(param);
            this.maxValueMessage = constraint.getMessage();
        }
    }

    protected String getInvalidNumberMessage() {
        return INVALID_NUMBER;
    }

    protected void doAssertValidity(String testValue) throws ValidationException {
        NumberKey nk = null;
        try {
            nk = new NumberKey(testValue);
        }
        catch (RuntimeException e) {
            this.message = this.invalidNumberMessage;
            throw new ValidationException(this.invalidNumberMessage);
        }
        if (this.minValue != null && nk.compareTo(this.minValue) < 0) {
            this.message = this.minValueMessage;
            throw new ValidationException(this.minValueMessage);
        }
        if (this.maxValue != null && nk.compareTo(this.maxValue) > 0) {
            this.message = this.maxValueMessage;
            throw new ValidationException(this.maxValueMessage);
        }
    }

    public NumberKeyValidator(Map paramMap) throws TurbineException {
        this.init(paramMap);
    }

    public NumberKeyValidator() {
    }
}

