C> \ingroup nwxc 
C> @{ 
C> 
C> \file nwxcm_c_b97.F 
C> The nwxcm_c_b97 functional 
C> 
C> @} 
C> 
C> \ingroup nwxc_priv 
C> @{ 
C> 
C> \brief Evaluate the nwxcm_c_b97 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\alpha^{0.3333333333333333}\\\\ 
C>   {\it t_2} &=& \sqrt{{\it t_1}}\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_5} &=& \log \left({{1.269642451250142\,{\it t_2}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.02414199311453321\,{\it t_3}+0.10186556948\right)\,{
C>    \it t_3}+0.22308199064\right)\,{\it t_3}+0.47231125998}}
C>    +1.0\right)\\\\ 
C>   {\it t_6} &=& 0.1325688999052018\,{\it t_4}+1.0\\\\ 
C>   {\it t_7} &=& \log \left({{1.269642451250142\,{\it t_2}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01321299881039884\,{\it t_3}+0.029729725188\right)
C>    \,{\it t_3}+0.12236585478\right)\,{\it t_3}+0.3497952466}}
C>    +1.0\right)\\\\ 
C>   {\it t_8} &=& 0.06901399211255826\,{\it t_4}+1.0\\\\ 
C>   {\it t_9} &=& 0.5848223622634643\,\left(0.0337738\,{\it t_7}
C>    \,{\it t_8}+1.0\,\left(1.709920934161365\,\left(0.0621814\,{
C>    \it t_5}\,{\it t_6}-0.0310907\,\log \left({{1.269642451250142
C>    \,{\it t_2}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01530901310039024\,{\it t_3}+0.10465751434\right)
C>    \,{\it t_3}+0.19269083139\right)\,{\it t_3}+0.43896648423}}
C>    +1.0\right)\,\left(0.1274696188700087\,{\it t_4}
C>    +1.0\right)\right)-0.0337738\,{\it t_7}\,{\it t_8}\right)\right)
C>    -0.0621814\,{\it t_5}\,{\it t_6}\\\\ 
C>   {\it t_{10}} &=& {\it param}\left(2\right)\\\\ 
C>   {\it t_{11}} &=& {\it param}\left(6\right)\\\\ 
C>   {\it t_{12}} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{13}} &=& 0.2\,{\it t_{12}}\,\sigma_{\alpha\alpha}+1.0\\\\ 
C>   {\it t_{14}} &=& {\it param}\left(4\right)\\\\ 
C>   {\it t_{15}} &=& \rho_\beta^{0.3333333333333333}\\\\ 
C>   {\it t_{16}} &=& \sqrt{{\it t_{15}}}\\\\ 
C>   {\it t_{17}} &=& {{1}\over{{\it t_{16}}}}\\\\ 
C>   {\it t_{18}} &=& {{1}\over{{\it t_{15}}}}\\\\ 
C>   {\it t_{19}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{16}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{17}}+0.10186556948\right)
C>    \,{\it t_{17}}+0.22308199064\right)\,{\it t_{17}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{20}} &=& 0.1325688999052018\,{\it t_{18}}+1.0\\\\ 
C>   {\it t_{21}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{16}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01321299881039884\,{\it t_{17}}
C>    +0.029729725188\right)\,{\it t_{17}}+0.12236585478\right)\,{
C>    \it t_{17}}+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{22}} &=& 0.06901399211255826\,{\it t_{18}}+1.0\\\\ 
C>   {\it t_{23}} &=& 0.5848223622634643\,\left(0.0337738\,{
C>    \it t_{21}}\,{\it t_{22}}+1.0\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{19}}\,{\it t_{20}}-0.0310907
C>    \,\log \left({{1.269642451250142\,{\it t_{16}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{17}}+0.10465751434\right)
C>    \,{\it t_{17}}+0.19269083139\right)\,{\it t_{17}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{18}}+1.0\right)\right)-0.0337738\,{\it t_{21}}\,{
C>    \it t_{22}}\right)\right)-0.0621814\,{\it t_{19}}\,{
C>    \it t_{20}}\\\\ 
C>   {\it t_{24}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{25}} &=& 0.2\,{\it t_{24}}\,\sigma_{\beta\beta}+1.0\\\\ 
C>   {\it t_{26}} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_{27}} &=& {\it t_{26}}^{0.3333333333333333}\\\\ 
C>   {\it t_{28}} &=& {{1}\over{{\it t_{27}}}}\\\\ 
C>   {\it t_{29}} &=& 0.1325688999052018\,{\it t_{28}}+1.0\\\\ 
C>   {\it t_{30}} &=& \sqrt{{\it t_{27}}}\\\\ 
C>   {\it t_{31}} &=& {{1}\over{{\it t_{30}}}}\\\\ 
C>   {\it t_{32}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{30}}}\over{0.7876233178997433\,{\it t_{31}}\,
C>    \left(0.7876233178997433\,{\it t_{31}}\,
C>    \left(0.02414199311453321\,{\it t_{31}}+0.10186556948\right)
C>    +0.22308199064\right)+0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{33}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{34}} &=& {{1}\over{{\it t_{26}}}}\\\\ 
C>   {\it t_{35}} &=& 0.06901399211255826\,{\it t_{28}}+1.0\\\\ 
C>   {\it t_{36}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{30}}}\over{0.7876233178997433\,{\it t_{31}}\,
C>    \left(0.7876233178997433\,{\it t_{31}}\,
C>    \left(0.01321299881039884\,{\it t_{31}}+0.029729725188\right)
C>    +0.12236585478\right)+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{37}} &=& {\it t_{24}}\,\sigma_{\beta\beta}+{\it t_{12}}
C>    \,\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{38}} &=& 0.003\,{\it t_{37}}+1.0\\\\ 
C>   {\it t_{39}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{40}} &=& \sqrt{{\it t_{39}}}\\\\ 
C>   {\it t_{41}} &=& {{1}\over{{\it t_{40}}}}\\\\ 
C>   {\it t_{42}} &=& {{1}\over{{\it t_{39}}}}\\\\ 
C>   {\it t_{43}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{40}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{41}}+0.10186556948\right)
C>    \,{\it t_{41}}+0.22308199064\right)\,{\it t_{41}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{44}} &=& 0.1325688999052018\,{\it t_{42}}+1.0\\\\ 
C>   {\it t_{45}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{40}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01321299881039884\,{\it t_{41}}
C>    +0.029729725188\right)\,{\it t_{41}}+0.12236585478\right)\,{
C>    \it t_{41}}+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{46}} &=& 0.06901399211255826\,{\it t_{42}}+1.0\\\\ 
C>   {\it t_{47}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{48}} &=& 0.2\,{\it t_{47}}\,\sigma_{ss}+1.0\\\\ 
C>   f &=& 1.0\,\left(\left(1.0\,{\it t_{26}}\,
C>    \left(0.5848223622634648\,\left(1.923661050931536\,\left({
C>    \it t_{33}}\,{\it t_{34}}+1.0\right)^{{{4}\over{3}}}
C>    +1.923661050931536\,\left(1.0-{\it t_{33}}\,{
C>    \it t_{34}}\right)^{{{4}\over{3}}}-3.847322101863072\right)
C>    \,\left({{{\it t_{33}}^4\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{29}}\,{\it t_{32}}-0.0310907\,
C>    \left(0.1274696188700087\,{\it t_{28}}+1.0\right)\,\log 
C>    \left({{1.269642451250142\,{\it t_{30}}}
C>    \over{0.7876233178997433\,{\it t_{31}}\,
C>    \left(0.7876233178997433\,{\it t_{31}}\,
C>    \left(0.01530901310039024\,{\it t_{31}}+0.10465751434\right)
C>    +0.19269083139\right)+0.43896648423}}+1.0\right)\right)
C>    -0.0337738\,{\it t_{35}}\,{\it t_{36}}\right)}\over{{
C>    \it t_{26}}^4}}+0.0337738\,{\it t_{35}}\,{\it t_{36}}\right)
C>    -0.0621814\,{\it t_{29}}\,{\it t_{32}}\right)-1.0\,{
C>    \it t_{23}}\,\rho_\beta-1.0\,{\it t_9}\,\rho_\alpha\right)
C>    \,\left({{0.003\,{\it param}\left(5\right)\,{
C>    \it t_{37}}}\over{{\it t_{38}}}}+{{9.0 \times 10^{-6}\,{
C>    \it param}\left(7\right)\,{\it t_{37}}^2}\over{{\it t_{38}}^2}}
C>    +{\it param}\left(3\right)\right)+1.0\,{\it t_{23}}
C>    \,\rho_\beta\,\left({{0.2\,{\it t_{14}}\,{\it t_{24}}
C>    \,\sigma_{\beta\beta}}\over{{\it t_{25}}}}
C>    +{{0.04000000000000001\,{\it t_{11}}\,
C>    \sigma_{\beta\beta}^2}\over{\rho_\beta^{{{16}\over{3}}}\,{
C>    \it t_{25}}^2}}+{\it t_{10}}\right)+1.0\,{\it t_9}
C>    \,\rho_\alpha\,\left({{0.2\,{\it t_{14}}\,{\it t_{12}}
C>    \,\sigma_{\alpha\alpha}}\over{{\it t_{13}}}}
C>    +{{0.04000000000000001\,{\it t_{11}}\,
C>    \sigma_{\alpha\alpha}^2}\over{\rho_\alpha^{{{16}\over{3}}}
C>    \,{\it t_{13}}^2}}+{\it t_{10}}\right)\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(0.5848223622634643\,\left(0.0337738\,{
C>    \it t_{45}}\,{\it t_{46}}+1.0\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{43}}\,{\it t_{44}}-0.0310907
C>    \,\log \left({{1.269642451250142\,{\it t_{40}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{41}}+0.10465751434\right)
C>    \,{\it t_{41}}+0.19269083139\right)\,{\it t_{41}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{42}}+1.0\right)\right)-0.0337738\,{\it t_{45}}\,{
C>    \it t_{46}}\right)\right)-0.0621814\,{\it t_{43}}\,{
C>    \it t_{44}}\right)\,\rho_s\,\left({{0.2\,{\it t_{14}}\,{
C>    \it t_{47}}\,\sigma_{ss}}\over{{\it t_{48}}}}
C>    +{{0.04000000000000001\,{\it t_{11}}\,\sigma_{ss}^2}
C>    \over{\rho_s^{{{16}\over{3}}}\,{\it t_{48}}^2}}+{
C>    \it t_{10}}\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] AD Becke, J.Chem.Phys. 107, 8554 (1997)  , DOI: 
C> <a href="https://doi.org/10.1063/1.475007 "> 
C> 10.1063/1.475007 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_b97(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,fnc,Amat,Cmat) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision rgamma(nq,*) !< [Input] The norm of the density 
                                    !< gradients 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,*)   !< [Output] The derivative wrt rgamma 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          if (rhoa.gt.tol_rho) then 
            t1 = param(6)
            t2 = gammaaa**2
            t3 = 1/rhoa**2.6666666666666666d+0
            t4 = 2.0d-1*gammaaa*t3+1.0d+0
            t5 = 1/t4**2
            t6 = 1/rhoa**5.333333333333333d+0
            t7 = param(4)
            t8 = 1/t4
            t9 = 2.0d-1*gammaaa*t3*t7*t8+4.000000000000001d-2*t1*t2*t5*t
     1         6+param(2)
            t10 = rhoa**3.333333333333333d-1
            t11 = t10**5.0d-1
            t12 = 1/t11
            t13 = 1.530901310039024d-2*t12+1.0465751434d-1
            t14 = 7.876233178997433d-1*t12*t13+1.9269083139d-1
            t15 = 7.876233178997433d-1*t12*t14+4.3896648423d-1
            t16 = 1/t15
            t17 = 1.269642451250142d+0*t11*t16+1.0d+0
            t18 = log(t17)
            t19 = 1/t10
            t20 = 1.2746961887000874d-1*t19+1.0d+0
            t21 = 2.4141993114533214d-2*t12+1.0186556948d-1
            t22 = 7.876233178997433d-1*t12*t21+2.2308199064d-1
            t23 = 7.876233178997433d-1*t12*t22+4.7231125998d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t11*t24+1.0d+0
            t26 = log(t25)
            t27 = 1.325688999052018d-1*t19+1.0d+0
            t28 = 1.3212998810398843d-2*t12+2.9729725188d-2
            t29 = 7.876233178997433d-1*t12*t28+1.2236585478d-1
            t30 = 7.876233178997433d-1*t12*t29+3.497952466d-1
            t31 = 1/t30
            t32 = 1.269642451250142d+0*t11*t31+1.0d+0
            t33 = log(t32)
            t34 = 6.901399211255826d-2*t19+1.0d+0
            t35 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t26*t27-3.10907d-2*t18*t20)-3.37738d-2*t33*t34)+
     2         3.37738d-2*t33*t34)-6.21814d-2*t26*t27
            t36 = param(7)
            t37 = 6.0d-3*gammaaa*t3+1.0d+0
            t38 = 1/t37**2
            t39 = param(5)
            t40 = 1/t37
            t41 = 3.6d-5*t2*t36*t38*t6+6.0d-3*gammaaa*t3*t39*t40+param(3
     1         )
            t42 = -2.0d+0*rhoa*t35
            t43 = gammaaa**3
            t44 = 1/t4**3
            t45 = 1/rhoa**9
            t46 = 1/rhoa**6.333333333333333d+0
            t47 = 1/rhoa**3.6666666666666664d+0
            t48 = 1/rhoa**1.3333333333333333d+0
            t49 = 1/rhoa**1.3333333333333336d+0
            t50 = 1/t11**3
            t51 = 1/rhoa**6.666666666666667d-1
            t52 = 1/t25
            t53 = 2.11607075208357d-1*t12*t24*t51-1.269642451250142d+0*t
     1         11*(7.876233178997433d-1*t12*(-1.3127055298329054d-1*t21*
     2         t50*t51-3.169132786263567d-3*t49)-1.3127055298329054d-1*t
     3         22*t50*t51)/t23**2
            t54 = 1/t32
            t55 = 2.11607075208357d-1*t12*t31*t51-1.269642451250142d+0*t
     1         11*(7.876233178997433d-1*t12*(-1.3127055298329054d-1*t28*
     2         t50*t51-1.7344776604086162d-3*t49)-1.3127055298329054d-1*
     3         t29*t50*t51)/t30**2
            t56 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t34*t54*t55+
     1         1.709920934161365d+0*(6.21814d-2*t27*t52*t53-3.10907d-2*t
     2         20*(2.11607075208357d-1*t12*t16*t51-1.269642451250142d+0*
     3         t11*(7.876233178997433d-1*t12*(-1.3127055298329054d-1*t13
     4         *t50*t51-2.0096226153166658d-3*t49)-1.3127055298329054d-1
     5         *t14*t50*t51)/t15**2)/t17-2.747773264188438d-3*t26*t48+1.
     6         3210398931339265d-3*t18*t48)+7.769549222703733d-4*t33*t48
     7         )+3.37738d-2*t34*t54*t55-7.769549222703733d-4*t33*t48)-6.
     8         21814d-2*t27*t52*t53+2.747773264188438d-3*t26*t48
            t57 = 2.1508070719090538d-2*t12+1.0186556948d-1
            t58 = 7.016926042943222d-1*t12*t57+2.2308199064d-1
            t59 = 7.016926042943222d-1*t12*t58+4.7231125998d-1
            t60 = 1/t59
            t61 = 1.425125466450768d+0*t11*t60+1.0d+0
            t62 = log(t61)
            t63 = 1.0522000558389213d-1*t19+1.0d+0
            t64 = 1/t37**3
            t65 = t42-1.243628d-1*rhoa*t62*t63
            t66 = 1/rhoa**8
            fnc(iq) = 1.0d+0*(2.0d+0*rhoa*t35*t9+t41*(t42-1.243628d-1*rh
     1         oa*log(1.4251254664507676d+0*t11/(7.016926042943223d-1*t1
     2         2*(7.016926042943223d-1*(2.150807071909054d-2*t12+1.01865
     3         56948d-1)*t12+2.2308199064d-1)+4.7231125998d-1)+1.0d+0)*(
     4         1.0522000558389215d-1*t19+1.0d+0)))*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(1.0d+0*rhoa*t56*t9+1.0d+0*t35*t9+1.
     1         0d+0*rhoa*t35*(-5.333333333333333d-1*gammaaa*t47*t7*t8+1.
     2         0666666666666667d-1*t2*t46*t5*t7-2.1333333333333337d-1*t1
     3         *t2*t46*t5+4.2666666666666675d-2*t1*t43*t44*t45)+(5.76000
     4         0000000001d-7*t36*t43*t45*t64-8.0d-3*gammaaa*t39*t40*t47+
     5         4.8000000000000004d-5*t2*t38*t39*t46-9.600000000000001d-5
     6         *t2*t36*t38*t46)*t65+t41*(2.0d+0*rhoa*(1.090454542535705d
     7         -3*t48*t62-6.21814d-2*(1.1876045553756398d-1*t12*t51*t60-
     8         1.425125466450768d+0*t11*(7.016926042943222d-1*t12*(-5.84
     9         7438369119352d-2*t50*t51*t57-1.2576711796854242d-3*t49)-5
     :         .847438369119352d-2*t50*t51*t58)/t59**2)*t63/t61)-6.21814
     ;         d-2*t62*t63-1.0d+0*rhoa*t56-1.0d+0*t35))*wght+Amat(iq,D1_
     <         RA)
            Cmat(iq,D1_GAA) = 1.0d+0*(1.0d+0*rhoa*t35*(2.0d-1*t3*t7*t8-4
     1         .000000000000001d-2*gammaaa*t5*t6*t7-1.6000000000000003d-
     2         2*t1*t2*t44*t66+8.000000000000002d-2*gammaaa*t1*t5*t6)+t6
     3         5*(-2.16d-7*t2*t36*t64*t66-1.8d-5*gammaaa*t38*t39*t6+3.6d
     4         -5*gammaaa*t36*t38*t6+3.0d-3*t3*t39*t40))*wght+Cmat(iq,D1
     5         _GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = param(2)
            t2 = param(6)
            t3 = gammaaa**2
            t4 = 1/rhoa**2.6666666666666666d+0
            t5 = 2.0d-1*gammaaa*t4+1.0d+0
            t6 = 1/t5**2
            t7 = 1/rhoa**5.333333333333333d+0
            t8 = param(4)
            t9 = 1/t5
            t10 = 2.0d-1*gammaaa*t4*t8*t9+4.000000000000001d-2*t2*t3*t6*
     1         t7+t1
            t11 = rhoa**3.333333333333333d-1
            t12 = t11**5.0d-1
            t13 = 1/t12
            t14 = 1.530901310039024d-2*t13+1.0465751434d-1
            t15 = 7.876233178997433d-1*t13*t14+1.9269083139d-1
            t16 = 7.876233178997433d-1*t13*t15+4.3896648423d-1
            t17 = 1/t16
            t18 = 1.269642451250142d+0*t12*t17+1.0d+0
            t19 = log(t18)
            t20 = 1/t11
            t21 = 1.2746961887000874d-1*t20+1.0d+0
            t22 = 2.4141993114533214d-2*t13+1.0186556948d-1
            t23 = 7.876233178997433d-1*t13*t22+2.2308199064d-1
            t24 = 7.876233178997433d-1*t13*t23+4.7231125998d-1
            t25 = 1/t24
            t26 = 1.269642451250142d+0*t12*t25+1.0d+0
            t27 = log(t26)
            t28 = 1.325688999052018d-1*t20+1.0d+0
            t29 = 1.3212998810398843d-2*t13+2.9729725188d-2
            t30 = 7.876233178997433d-1*t13*t29+1.2236585478d-1
            t31 = 7.876233178997433d-1*t13*t30+3.497952466d-1
            t32 = 1/t31
            t33 = 1.269642451250142d+0*t12*t32+1.0d+0
            t34 = log(t33)
            t35 = 6.901399211255826d-2*t20+1.0d+0
            t36 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t27*t28-3.10907d-2*t19*t21)-3.37738d-2*t34*t35)+
     2         3.37738d-2*t34*t35)-6.21814d-2*t27*t28
            t37 = gammabb**2
            t38 = 1/rhob**2.6666666666666666d+0
            t39 = 2.0d-1*gammabb*t38+1.0d+0
            t40 = 1/t39**2
            t41 = 1/rhob**5.333333333333333d+0
            t42 = 1/t39
            t43 = 2.0d-1*gammabb*t38*t42*t8+4.000000000000001d-2*t2*t37*
     1         t40*t41+t1
            t44 = rhob**3.333333333333333d-1
            t45 = t44**5.0d-1
            t46 = 1/t45
            t47 = 1.530901310039024d-2*t46+1.0465751434d-1
            t48 = 7.876233178997433d-1*t46*t47+1.9269083139d-1
            t49 = 7.876233178997433d-1*t46*t48+4.3896648423d-1
            t50 = 1/t49
            t51 = 1.269642451250142d+0*t45*t50+1.0d+0
            t52 = log(t51)
            t53 = 1/t44
            t54 = 1.2746961887000874d-1*t53+1.0d+0
            t55 = 2.4141993114533214d-2*t46+1.0186556948d-1
            t56 = 7.876233178997433d-1*t46*t55+2.2308199064d-1
            t57 = 7.876233178997433d-1*t46*t56+4.7231125998d-1
            t58 = 1/t57
            t59 = 1.269642451250142d+0*t45*t58+1.0d+0
            t60 = log(t59)
            t61 = 1.325688999052018d-1*t53+1.0d+0
            t62 = 1.3212998810398843d-2*t46+2.9729725188d-2
            t63 = 7.876233178997433d-1*t46*t62+1.2236585478d-1
            t64 = 7.876233178997433d-1*t46*t63+3.497952466d-1
            t65 = 1/t64
            t66 = 1.269642451250142d+0*t45*t65+1.0d+0
            t67 = log(t66)
            t68 = 6.901399211255826d-2*t53+1.0d+0
            t69 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t60*t61-3.10907d-2*t52*t54)-3.37738d-2*t67*t68)+
     2         3.37738d-2*t67*t68)-6.21814d-2*t60*t61
            t70 = param(7)
            t71 = gammaaa*t4+gammabb*t38
            t72 = t71**2
            t73 = 3.0d-3*t71+1.0d+0
            t74 = 1/t73**2
            t75 = param(5)
            t76 = 1/t73
            t77 = 3.0d-3*t71*t75*t76+9.0d-6*t70*t72*t74+param(3)
            t78 = rhob+rhoa
            t79 = t78**3.333333333333333d-1
            t80 = 1/t79
            t81 = 1.325688999052018d-1*t80+1.0d+0
            t82 = t79**5.0d-1
            t83 = 1/t82
            t84 = 2.4141993114533214d-2*t83+1.0186556948d-1
            t85 = 7.876233178997433d-1*t83*t84+2.2308199064d-1
            t86 = 7.876233178997433d-1*t83*t85+4.7231125998d-1
            t87 = 1/t86
            t88 = 1.269642451250142d+0*t82*t87+1.0d+0
            t89 = log(t88)
            t90 = rhoa-rhob
            t91 = 1/t78
            t92 = 1.0d+0-t90*t91
            t93 = t90*t91+1.0d+0
            t94 = 1.923661050931536d+0*t93**1.3333333333333333d+0+1.9236
     1         61050931536d+0*t92**1.3333333333333333d+0-3.8473221018630
     2         72d+0
            t95 = 6.901399211255826d-2*t80+1.0d+0
            t96 = 1.3212998810398843d-2*t83+2.9729725188d-2
            t97 = 7.876233178997433d-1*t83*t96+1.2236585478d-1
            t98 = 7.876233178997433d-1*t83*t97+3.497952466d-1
            t99 = 1/t98
            t100 = 1.269642451250142d+0*t82*t99+1.0d+0
            t101 = log(t100)
            t102 = t90**4
            t103 = 1/t78**4
            t104 = 1.2746961887000874d-1*t80+1.0d+0
            t105 = 1.530901310039024d-2*t83+1.0465751434d-1
            t106 = 7.876233178997433d-1*t105*t83+1.9269083139d-1
            t107 = 7.876233178997433d-1*t106*t83+4.3896648423d-1
            t108 = 1/t107
            t109 = 1.269642451250142d+0*t108*t82+1.0d+0
            t110 = log(t109)
            t111 = 1.709920934161365d+0*(6.21814d-2*t81*t89-3.10907d-2*t
     1         104*t110)-3.37738d-2*t101*t95
            t112 = 3.37738d-2*t101*t95+t102*t103*t111
            t113 = 5.848223622634648d-1*t112*t94-6.21814d-2*t81*t89
            t114 = 1.0d+0*t113*t78-1.0d+0*rhob*t69-1.0d+0*rhoa*t36
            t115 = 1/t5**3
            t116 = 1/rhoa**6.333333333333333d+0
            t117 = 1/rhoa**3.6666666666666664d+0
            t118 = 1/rhoa**1.3333333333333333d+0
            t119 = 1/rhoa**1.3333333333333336d+0
            t120 = 1/t12**3
            t121 = 1/rhoa**6.666666666666667d-1
            t122 = 1/t26
            t123 = 2.11607075208357d-1*t121*t13*t25-1.269642451250142d+0
     1         *t12*(7.876233178997433d-1*t13*(-1.3127055298329054d-1*t1
     2         20*t121*t22-3.169132786263567d-3*t119)-1.3127055298329054
     3         d-1*t120*t121*t23)/t24**2
            t124 = 1/t33
            t125 = 2.11607075208357d-1*t121*t13*t32-1.269642451250142d+0
     1         *t12*(7.876233178997433d-1*t13*(-1.3127055298329054d-1*t1
     2         20*t121*t29-1.7344776604086162d-3*t119)-1.312705529832905
     3         4d-1*t120*t121*t30)/t31**2
            t126 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t124*t125*t
     1         35+7.769549222703733d-4*t118*t34+1.709920934161365d+0*(6.
     2         21814d-2*t122*t123*t28-2.747773264188438d-3*t118*t27-3.10
     3         907d-2*(2.11607075208357d-1*t121*t13*t17-1.26964245125014
     4         2d+0*t12*(7.876233178997433d-1*t13*(-1.3127055298329054d-
     5         1*t120*t121*t14-2.0096226153166658d-3*t119)-1.31270552983
     6         29054d-1*t120*t121*t15)/t16**2)*t21/t18+1.321039893133926
     7         5d-3*t118*t19))+3.37738d-2*t124*t125*t35-7.76954922270373
     8         3d-4*t118*t34)-6.21814d-2*t122*t123*t28+2.747773264188438
     9         d-3*t118*t27
            t127 = 1/t78**1.3333333333333336d+0
            t128 = 1/t78**6.666666666666667d-1
            t129 = 1/t82**3
            t130 = 2.11607075208357d-1*t128*t83*t87-1.269642451250142d+0
     1         *t82*(7.876233178997433d-1*t83*(-1.3127055298329054d-1*t1
     2         28*t129*t84-3.169132786263567d-3*t127)-1.3127055298329054
     3         d-1*t128*t129*t85)/t86**2
            t131 = 1/t88
            t132 = -6.21814d-2*t130*t131*t81
            t133 = 1/t78**1.3333333333333333d+0
            t134 = 2.747773264188438d-3*t133*t89
            t135 = 2.11607075208357d-1*t128*t83*t99-1.269642451250142d+0
     1         *t82*(7.876233178997433d-1*t83*(-1.3127055298329054d-1*t1
     2         28*t129*t96-1.7344776604086162d-3*t127)-1.312705529832905
     3         4d-1*t128*t129*t97)/t98**2
            t136 = 1/t100
            t137 = 3.37738d-2*t135*t136*t95
            t138 = -7.769549222703733d-4*t101*t133
            t139 = t102*t103*(-3.37738d-2*t135*t136*t95+1.70992093416136
     1         5d+0*(-2.747773264188438d-3*t133*t89-3.10907d-2*t104*(2.1
     2         1607075208357d-1*t108*t128*t83-1.269642451250142d+0*t82*(
     3         7.876233178997433d-1*(-1.3127055298329054d-1*t105*t128*t1
     4         29-2.0096226153166658d-3*t127)*t83-1.3127055298329054d-1*
     5         t106*t128*t129)/t107**2)/t109+6.21814d-2*t130*t131*t81+1.
     6         3210398931339265d-3*t110*t133)+7.769549222703733d-4*t101*
     7         t133)
            t140 = -4*t102*t111/t78**5
            t141 = t90**3
            t142 = 1/t78**2
            t143 = t142*t90
            t144 = -t91
            t145 = t92**3.333333333333333d-1
            t146 = -t142*t90
            t147 = t93**3.333333333333333d-1
            t148 = 1.0d+0*t113
            t149 = 1/t73**3
            t150 = 1/t39**3
            t151 = 1/rhob**6.333333333333333d+0
            t152 = 1/rhob**3.6666666666666664d+0
            t153 = 1/rhob**1.3333333333333333d+0
            t154 = 1/rhob**1.3333333333333336d+0
            t155 = 1/t45**3
            t156 = 1/rhob**6.666666666666667d-1
            t157 = 1/t59
            t158 = 2.11607075208357d-1*t156*t46*t58-1.269642451250142d+0
     1         *t45*(7.876233178997433d-1*t46*(-1.3127055298329054d-1*t1
     2         55*t156*t55-3.169132786263567d-3*t154)-1.3127055298329054
     3         d-1*t155*t156*t56)/t57**2
            t159 = 1/t66
            t160 = 2.11607075208357d-1*t156*t46*t65-1.269642451250142d+0
     1         *t45*(7.876233178997433d-1*t46*(-1.3127055298329054d-1*t1
     2         55*t156*t62-1.7344776604086162d-3*t154)-1.312705529832905
     3         4d-1*t155*t156*t63)/t64**2
            t161 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t159*t160*t
     1         68+7.769549222703733d-4*t153*t67+1.709920934161365d+0*(6.
     2         21814d-2*t157*t158*t61-2.747773264188438d-3*t153*t60-3.10
     3         907d-2*(2.11607075208357d-1*t156*t46*t50-1.26964245125014
     4         2d+0*t45*(7.876233178997433d-1*t46*(-1.3127055298329054d-
     5         1*t155*t156*t47-2.0096226153166658d-3*t154)-1.31270552983
     6         29054d-1*t155*t156*t48)/t49**2)*t54/t51+1.321039893133926
     7         5d-3*t153*t52))+3.37738d-2*t159*t160*t68-7.76954922270373
     8         3d-4*t153*t67)-6.21814d-2*t157*t158*t61+2.747773264188438
     9         d-3*t153*t60
            fnc(iq) = 1.0d+0*(t114*t77+1.0d+0*rhob*t43*t69+1.0d+0*rhoa*t
     1         10*t36)*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(t77*(1.0d+0*t78*(5.848223622634648d
     1         -1*(4*t103*t111*t141+t140+t139+t138+t137)*t94+5.848223622
     2         634648d-1*t112*(2.564881401242048d+0*t147*(t91+t146)+2.56
     3         4881401242048d+0*(t144+t143)*t145)+t134+t132)-1.0d+0*t36+
     4         t148-1.0d+0*rhoa*t126)+1.0d+0*rhoa*t36*(-5.33333333333333
     5         3d-1*gammaaa*t117*t8*t9+1.0666666666666667d-1*t116*t3*t6*
     6         t8-2.1333333333333337d-1*t116*t2*t3*t6+4.2666666666666675
     7         d-2*gammaaa**3*t115*t2/rhoa**9)+t114*(-8.0d-3*gammaaa*t11
     8         7*t75*t76+2.4000000000000002d-5*gammaaa*t117*t71*t74*t75-
     9         4.8000000000000004d-5*gammaaa*t117*t70*t71*t74+1.44000000
     :         00000002d-7*gammaaa*t117*t149*t70*t72)+1.0d+0*t10*t36+1.0
     ;         d+0*rhoa*t10*t126)*wght+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 1.0d+0*(t77*(1.0d+0*t78*(5.848223622634648d
     1         -1*(-4*t103*t111*t141+t140+t139+t138+t137)*t94+5.84822362
     2         2634648d-1*t112*(2.564881401242048d+0*t145*(t91+t143)+2.5
     3         64881401242048d+0*(t146+t144)*t147)+t134+t132)-1.0d+0*t69
     4         -1.0d+0*rhob*t161+t148)+1.0d+0*rhob*t69*(-5.3333333333333
     5         33d-1*gammabb*t152*t42*t8+1.0666666666666667d-1*t151*t37*
     6         t40*t8-2.1333333333333337d-1*t151*t2*t37*t40+4.2666666666
     7         666675d-2*gammabb**3*t150*t2/rhob**9)+t114*(-8.0d-3*gamma
     8         bb*t152*t75*t76+2.4000000000000002d-5*gammabb*t152*t71*t7
     9         4*t75-4.8000000000000004d-5*gammabb*t152*t70*t71*t74+1.44
     :         00000000000002d-7*gammabb*t149*t152*t70*t72)+1.0d+0*t43*t
     ;         69+1.0d+0*rhob*t161*t43)*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GAA) = 1.0d+0*(1.0d+0*rhoa*t36*(2.0d-1*t4*t8*t9-4
     1         .000000000000001d-2*gammaaa*t6*t7*t8+8.000000000000002d-2
     2         *gammaaa*t2*t6*t7-1.6000000000000003d-2*t115*t2*t3/rhoa**
     3         8)+t114*(3.0d-3*t4*t75*t76-9.0d-6*t4*t71*t74*t75+1.8d-5*t
     4         4*t70*t71*t74-5.4d-8*t149*t4*t70*t72))*wght+Cmat(iq,D1_GA
     5         A)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = 1.0d+0*(1.0d+0*rhob*t69*(2.0d-1*t38*t42*t8
     1         -4.000000000000001d-2*gammabb*t40*t41*t8+8.00000000000000
     2         2d-2*gammabb*t2*t40*t41-1.6000000000000003d-2*t150*t2*t37
     3         /rhob**8)+t114*(3.0d-3*t38*t75*t76-9.0d-6*t38*t71*t74*t75
     4         +1.8d-5*t38*t70*t71*t74-5.4d-8*t149*t38*t70*t72))*wght+Cm
     5         at(iq,D1_GBB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = param(6)
            t2 = gammaaa**2
            t3 = 1/rhoa**2.6666666666666666d+0
            t4 = 2.0d-1*gammaaa*t3+1.0d+0
            t5 = 1/t4**2
            t6 = 1/rhoa**5.333333333333333d+0
            t7 = param(4)
            t8 = 1/t4
            t9 = 2.0d-1*gammaaa*t3*t7*t8+4.000000000000001d-2*t1*t2*t5*t
     1         6+param(2)
            t10 = rhoa**3.333333333333333d-1
            t11 = t10**5.0d-1
            t12 = 1/t11
            t13 = 1.530901310039024d-2*t12+1.0465751434d-1
            t14 = 7.876233178997433d-1*t12*t13+1.9269083139d-1
            t15 = 7.876233178997433d-1*t12*t14+4.3896648423d-1
            t16 = 1/t15
            t17 = 1.269642451250142d+0*t11*t16+1.0d+0
            t18 = log(t17)
            t19 = 1/t10
            t20 = 1.2746961887000874d-1*t19+1.0d+0
            t21 = 2.4141993114533214d-2*t12+1.0186556948d-1
            t22 = 7.876233178997433d-1*t12*t21+2.2308199064d-1
            t23 = 7.876233178997433d-1*t12*t22+4.7231125998d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t11*t24+1.0d+0
            t26 = log(t25)
            t27 = 1.325688999052018d-1*t19+1.0d+0
            t28 = 1.3212998810398843d-2*t12+2.9729725188d-2
            t29 = 7.876233178997433d-1*t12*t28+1.2236585478d-1
            t30 = 7.876233178997433d-1*t12*t29+3.497952466d-1
            t31 = 1/t30
            t32 = 1.269642451250142d+0*t11*t31+1.0d+0
            t33 = log(t32)
            t34 = 6.901399211255826d-2*t19+1.0d+0
            t35 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t26*t27-3.10907d-2*t18*t20)-3.37738d-2*t33*t34)+
     2         3.37738d-2*t33*t34)-6.21814d-2*t26*t27
            t36 = 1/t4**3
            t37 = 1/rhoa**6.333333333333333d+0
            t38 = 1/rhoa**1.3333333333333333d+0
            t39 = 1/rhoa**1.3333333333333336d+0
            t40 = 1/t11**3
            t41 = 1/rhoa**6.666666666666667d-1
            t42 = 1/t25
            t43 = 2.11607075208357d-1*t12*t24*t41-1.269642451250142d+0*t
     1         11*(7.876233178997433d-1*t12*(-1.3127055298329054d-1*t21*
     2         t40*t41-3.169132786263567d-3*t39)-1.3127055298329054d-1*t
     3         22*t40*t41)/t23**2
            t44 = 1/t32
            t45 = 2.11607075208357d-1*t12*t31*t41-1.269642451250142d+0*t
     1         11*(7.876233178997433d-1*t12*(-1.3127055298329054d-1*t28*
     2         t40*t41-1.7344776604086162d-3*t39)-1.3127055298329054d-1*
     3         t29*t40*t41)/t30**2
            fnc(iq) = 1.0d+0*rhoa*t35*t9*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*rhoa*(5.848223622634643d-1*(1.0d+0*(
     1         -3.37738d-2*t34*t44*t45+1.709920934161365d+0*(6.21814d-2*
     2         t27*t42*t43-3.10907d-2*t20*(2.11607075208357d-1*t12*t16*t
     3         41-1.269642451250142d+0*t11*(7.876233178997433d-1*t12*(-1
     4         .3127055298329054d-1*t13*t40*t41-2.0096226153166658d-3*t3
     5         9)-1.3127055298329054d-1*t14*t40*t41)/t15**2)/t17-2.74777
     6         3264188438d-3*t26*t38+1.3210398931339265d-3*t18*t38)+7.76
     7         9549222703733d-4*t33*t38)+3.37738d-2*t34*t44*t45-7.769549
     8         222703733d-4*t33*t38)-6.21814d-2*t27*t42*t43+2.7477732641
     9         88438d-3*t26*t38)*t9*wght+1.0d+0*t35*t9*wght+1.0d+0*rhoa*
     :         t35*(-5.333333333333333d-1*gammaaa*t7*t8/rhoa**3.66666666
     ;         66666664d+0+1.0666666666666667d-1*t2*t37*t5*t7-2.13333333
     <         33333337d-1*t1*t2*t37*t5+4.2666666666666675d-2*gammaaa**3
     =         *t1*t36/rhoa**9)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.0d+0*rhoa*t35*(2.0d-1*t3*t7*t8+t5*t6*(8.
     1         000000000000002d-2*gammaaa*t1-4.000000000000001d-2*gammaa
     2         a*t7)-1.6000000000000003d-2*t1*t2*t36/rhoa**8)*wght+Cmat(
     3         iq,D1_GAA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = param(6)
            t2 = gammabb**2
            t3 = 1/rhob**2.6666666666666666d+0
            t4 = 2.0d-1*gammabb*t3+1.0d+0
            t5 = 1/t4**2
            t6 = 1/rhob**5.333333333333333d+0
            t7 = param(4)
            t8 = 1/t4
            t9 = 2.0d-1*gammabb*t3*t7*t8+4.000000000000001d-2*t1*t2*t5*t
     1         6+param(2)
            t10 = rhob**3.333333333333333d-1
            t11 = t10**5.0d-1
            t12 = 1/t11
            t13 = 1.530901310039024d-2*t12+1.0465751434d-1
            t14 = 7.876233178997433d-1*t12*t13+1.9269083139d-1
            t15 = 7.876233178997433d-1*t12*t14+4.3896648423d-1
            t16 = 1/t15
            t17 = 1.269642451250142d+0*t11*t16+1.0d+0
            t18 = log(t17)
            t19 = 1/t10
            t20 = 1.2746961887000874d-1*t19+1.0d+0
            t21 = 2.4141993114533214d-2*t12+1.0186556948d-1
            t22 = 7.876233178997433d-1*t12*t21+2.2308199064d-1
            t23 = 7.876233178997433d-1*t12*t22+4.7231125998d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t11*t24+1.0d+0
            t26 = log(t25)
            t27 = 1.325688999052018d-1*t19+1.0d+0
            t28 = 1.3212998810398843d-2*t12+2.9729725188d-2
            t29 = 7.876233178997433d-1*t12*t28+1.2236585478d-1
            t30 = 7.876233178997433d-1*t12*t29+3.497952466d-1
            t31 = 1/t30
            t32 = 1.269642451250142d+0*t11*t31+1.0d+0
            t33 = log(t32)
            t34 = 6.901399211255826d-2*t19+1.0d+0
            t35 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t26*t27-3.10907d-2*t18*t20)-3.37738d-2*t33*t34)+
     2         3.37738d-2*t33*t34)-6.21814d-2*t26*t27
            t36 = 1/t4**3
            t37 = 1/rhob**6.333333333333333d+0
            t38 = 1/rhob**1.3333333333333333d+0
            t39 = 1/rhob**1.3333333333333336d+0
            t40 = 1/t11**3
            t41 = 1/rhob**6.666666666666667d-1
            t42 = 1/t25
            t43 = 2.11607075208357d-1*t12*t24*t41-1.269642451250142d+0*t
     1         11*(7.876233178997433d-1*t12*(-1.3127055298329054d-1*t21*
     2         t40*t41-3.169132786263567d-3*t39)-1.3127055298329054d-1*t
     3         22*t40*t41)/t23**2
            t44 = 1/t32
            t45 = 2.11607075208357d-1*t12*t31*t41-1.269642451250142d+0*t
     1         11*(7.876233178997433d-1*t12*(-1.3127055298329054d-1*t28*
     2         t40*t41-1.7344776604086162d-3*t39)-1.3127055298329054d-1*
     3         t29*t40*t41)/t30**2
            fnc(iq) = 1.0d+0*rhob*t35*t9*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*rhob*(5.848223622634643d-1*(1.0d+0*(
     1         -3.37738d-2*t34*t44*t45+1.709920934161365d+0*(6.21814d-2*
     2         t27*t42*t43-3.10907d-2*t20*(2.11607075208357d-1*t12*t16*t
     3         41-1.269642451250142d+0*t11*(7.876233178997433d-1*t12*(-1
     4         .3127055298329054d-1*t13*t40*t41-2.0096226153166658d-3*t3
     5         9)-1.3127055298329054d-1*t14*t40*t41)/t15**2)/t17-2.74777
     6         3264188438d-3*t26*t38+1.3210398931339265d-3*t18*t38)+7.76
     7         9549222703733d-4*t33*t38)+3.37738d-2*t34*t44*t45-7.769549
     8         222703733d-4*t33*t38)-6.21814d-2*t27*t42*t43+2.7477732641
     9         88438d-3*t26*t38)*t9*wght+1.0d+0*t35*t9*wght+1.0d+0*rhob*
     :         t35*(-5.333333333333333d-1*gammabb*t7*t8/rhob**3.66666666
     ;         66666664d+0+1.0666666666666667d-1*t2*t37*t5*t7-2.13333333
     <         33333337d-1*t1*t2*t37*t5+4.2666666666666675d-2*gammabb**3
     =         *t1*t36/rhob**9)*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = 1.0d+0*rhob*t35*(2.0d-1*t3*t7*t8+t5*t6*(8.
     1         000000000000002d-2*gammabb*t1-4.000000000000001d-2*gammab
     2         b*t7)-1.6000000000000003d-2*t1*t2*t36/rhob**8)*wght+Cmat(
     3         iq,D1_GBB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_b97 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\alpha^{0.3333333333333333}\\\\ 
C>   {\it t_2} &=& \sqrt{{\it t_1}}\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_5} &=& \log \left({{1.269642451250142\,{\it t_2}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.02414199311453321\,{\it t_3}+0.10186556948\right)\,{
C>    \it t_3}+0.22308199064\right)\,{\it t_3}+0.47231125998}}
C>    +1.0\right)\\\\ 
C>   {\it t_6} &=& 0.1325688999052018\,{\it t_4}+1.0\\\\ 
C>   {\it t_7} &=& \log \left({{1.269642451250142\,{\it t_2}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01321299881039884\,{\it t_3}+0.029729725188\right)
C>    \,{\it t_3}+0.12236585478\right)\,{\it t_3}+0.3497952466}}
C>    +1.0\right)\\\\ 
C>   {\it t_8} &=& 0.06901399211255826\,{\it t_4}+1.0\\\\ 
C>   {\it t_9} &=& 0.5848223622634643\,\left(0.0337738\,{\it t_7}
C>    \,{\it t_8}+1.0\,\left(1.709920934161365\,\left(0.0621814\,{
C>    \it t_5}\,{\it t_6}-0.0310907\,\log \left({{1.269642451250142
C>    \,{\it t_2}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01530901310039024\,{\it t_3}+0.10465751434\right)
C>    \,{\it t_3}+0.19269083139\right)\,{\it t_3}+0.43896648423}}
C>    +1.0\right)\,\left(0.1274696188700087\,{\it t_4}
C>    +1.0\right)\right)-0.0337738\,{\it t_7}\,{\it t_8}\right)\right)
C>    -0.0621814\,{\it t_5}\,{\it t_6}\\\\ 
C>   {\it t_{10}} &=& {\it param}\left(2\right)\\\\ 
C>   {\it t_{11}} &=& {\it param}\left(6\right)\\\\ 
C>   {\it t_{12}} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{13}} &=& 0.2\,{\it t_{12}}\,\sigma_{\alpha\alpha}+1.0\\\\ 
C>   {\it t_{14}} &=& {\it param}\left(4\right)\\\\ 
C>   {\it t_{15}} &=& \rho_\beta^{0.3333333333333333}\\\\ 
C>   {\it t_{16}} &=& \sqrt{{\it t_{15}}}\\\\ 
C>   {\it t_{17}} &=& {{1}\over{{\it t_{16}}}}\\\\ 
C>   {\it t_{18}} &=& {{1}\over{{\it t_{15}}}}\\\\ 
C>   {\it t_{19}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{16}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{17}}+0.10186556948\right)
C>    \,{\it t_{17}}+0.22308199064\right)\,{\it t_{17}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{20}} &=& 0.1325688999052018\,{\it t_{18}}+1.0\\\\ 
C>   {\it t_{21}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{16}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01321299881039884\,{\it t_{17}}
C>    +0.029729725188\right)\,{\it t_{17}}+0.12236585478\right)\,{
C>    \it t_{17}}+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{22}} &=& 0.06901399211255826\,{\it t_{18}}+1.0\\\\ 
C>   {\it t_{23}} &=& 0.5848223622634643\,\left(0.0337738\,{
C>    \it t_{21}}\,{\it t_{22}}+1.0\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{19}}\,{\it t_{20}}-0.0310907
C>    \,\log \left({{1.269642451250142\,{\it t_{16}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{17}}+0.10465751434\right)
C>    \,{\it t_{17}}+0.19269083139\right)\,{\it t_{17}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{18}}+1.0\right)\right)-0.0337738\,{\it t_{21}}\,{
C>    \it t_{22}}\right)\right)-0.0621814\,{\it t_{19}}\,{
C>    \it t_{20}}\\\\ 
C>   {\it t_{24}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{25}} &=& 0.2\,{\it t_{24}}\,\sigma_{\beta\beta}+1.0\\\\ 
C>   {\it t_{26}} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_{27}} &=& {\it t_{26}}^{0.3333333333333333}\\\\ 
C>   {\it t_{28}} &=& {{1}\over{{\it t_{27}}}}\\\\ 
C>   {\it t_{29}} &=& 0.1325688999052018\,{\it t_{28}}+1.0\\\\ 
C>   {\it t_{30}} &=& \sqrt{{\it t_{27}}}\\\\ 
C>   {\it t_{31}} &=& {{1}\over{{\it t_{30}}}}\\\\ 
C>   {\it t_{32}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{30}}}\over{0.7876233178997433\,{\it t_{31}}\,
C>    \left(0.7876233178997433\,{\it t_{31}}\,
C>    \left(0.02414199311453321\,{\it t_{31}}+0.10186556948\right)
C>    +0.22308199064\right)+0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{33}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{34}} &=& {{1}\over{{\it t_{26}}}}\\\\ 
C>   {\it t_{35}} &=& 0.06901399211255826\,{\it t_{28}}+1.0\\\\ 
C>   {\it t_{36}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{30}}}\over{0.7876233178997433\,{\it t_{31}}\,
C>    \left(0.7876233178997433\,{\it t_{31}}\,
C>    \left(0.01321299881039884\,{\it t_{31}}+0.029729725188\right)
C>    +0.12236585478\right)+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{37}} &=& {\it t_{24}}\,\sigma_{\beta\beta}+{\it t_{12}}
C>    \,\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{38}} &=& 0.003\,{\it t_{37}}+1.0\\\\ 
C>   {\it t_{39}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{40}} &=& \sqrt{{\it t_{39}}}\\\\ 
C>   {\it t_{41}} &=& {{1}\over{{\it t_{40}}}}\\\\ 
C>   {\it t_{42}} &=& {{1}\over{{\it t_{39}}}}\\\\ 
C>   {\it t_{43}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{40}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{41}}+0.10186556948\right)
C>    \,{\it t_{41}}+0.22308199064\right)\,{\it t_{41}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{44}} &=& 0.1325688999052018\,{\it t_{42}}+1.0\\\\ 
C>   {\it t_{45}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{40}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01321299881039884\,{\it t_{41}}
C>    +0.029729725188\right)\,{\it t_{41}}+0.12236585478\right)\,{
C>    \it t_{41}}+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{46}} &=& 0.06901399211255826\,{\it t_{42}}+1.0\\\\ 
C>   {\it t_{47}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{48}} &=& 0.2\,{\it t_{47}}\,\sigma_{ss}+1.0\\\\ 
C>   f &=& 1.0\,\left(\left(1.0\,{\it t_{26}}\,
C>    \left(0.5848223622634648\,\left(1.923661050931536\,\left({
C>    \it t_{33}}\,{\it t_{34}}+1.0\right)^{{{4}\over{3}}}
C>    +1.923661050931536\,\left(1.0-{\it t_{33}}\,{
C>    \it t_{34}}\right)^{{{4}\over{3}}}-3.847322101863072\right)
C>    \,\left({{{\it t_{33}}^4\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{29}}\,{\it t_{32}}-0.0310907\,
C>    \left(0.1274696188700087\,{\it t_{28}}+1.0\right)\,\log 
C>    \left({{1.269642451250142\,{\it t_{30}}}
C>    \over{0.7876233178997433\,{\it t_{31}}\,
C>    \left(0.7876233178997433\,{\it t_{31}}\,
C>    \left(0.01530901310039024\,{\it t_{31}}+0.10465751434\right)
C>    +0.19269083139\right)+0.43896648423}}+1.0\right)\right)
C>    -0.0337738\,{\it t_{35}}\,{\it t_{36}}\right)}\over{{
C>    \it t_{26}}^4}}+0.0337738\,{\it t_{35}}\,{\it t_{36}}\right)
C>    -0.0621814\,{\it t_{29}}\,{\it t_{32}}\right)-1.0\,{
C>    \it t_{23}}\,\rho_\beta-1.0\,{\it t_9}\,\rho_\alpha\right)
C>    \,\left({{0.003\,{\it param}\left(5\right)\,{
C>    \it t_{37}}}\over{{\it t_{38}}}}+{{9.0 \times 10^{-6}\,{
C>    \it param}\left(7\right)\,{\it t_{37}}^2}\over{{\it t_{38}}^2}}
C>    +{\it param}\left(3\right)\right)+1.0\,{\it t_{23}}
C>    \,\rho_\beta\,\left({{0.2\,{\it t_{14}}\,{\it t_{24}}
C>    \,\sigma_{\beta\beta}}\over{{\it t_{25}}}}
C>    +{{0.04000000000000001\,{\it t_{11}}\,
C>    \sigma_{\beta\beta}^2}\over{\rho_\beta^{{{16}\over{3}}}\,{
C>    \it t_{25}}^2}}+{\it t_{10}}\right)+1.0\,{\it t_9}
C>    \,\rho_\alpha\,\left({{0.2\,{\it t_{14}}\,{\it t_{12}}
C>    \,\sigma_{\alpha\alpha}}\over{{\it t_{13}}}}
C>    +{{0.04000000000000001\,{\it t_{11}}\,
C>    \sigma_{\alpha\alpha}^2}\over{\rho_\alpha^{{{16}\over{3}}}
C>    \,{\it t_{13}}^2}}+{\it t_{10}}\right)\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(0.5848223622634643\,\left(0.0337738\,{
C>    \it t_{45}}\,{\it t_{46}}+1.0\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{43}}\,{\it t_{44}}-0.0310907
C>    \,\log \left({{1.269642451250142\,{\it t_{40}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{41}}+0.10465751434\right)
C>    \,{\it t_{41}}+0.19269083139\right)\,{\it t_{41}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{42}}+1.0\right)\right)-0.0337738\,{\it t_{45}}\,{
C>    \it t_{46}}\right)\right)-0.0621814\,{\it t_{43}}\,{
C>    \it t_{44}}\right)\,\rho_s\,\left({{0.2\,{\it t_{14}}\,{
C>    \it t_{47}}\,\sigma_{ss}}\over{{\it t_{48}}}}
C>    +{{0.04000000000000001\,{\it t_{11}}\,\sigma_{ss}^2}
C>    \over{\rho_s^{{{16}\over{3}}}\,{\it t_{48}}^2}}+{
C>    \it t_{10}}\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] AD Becke, J.Chem.Phys. 107, 8554 (1997)  , DOI: 
C> <a href="https://doi.org/10.1063/1.475007 "> 
C> 10.1063/1.475007 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_b97_d2(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,fnc,Amat,Amat2,Cmat,Cmat2) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision rgamma(nq,*) !< [Input] The norm of the density 
                                    !< gradients 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,*)   !< [Output] The derivative wrt rgamma 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,*)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,*)  !< [Output] The 2nd derivative wrt rgamma 
                                    !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          if (rhoa.gt.tol_rho) then 
            t1 = param(6)
            t2 = gammaaa**2
            t3 = 1/rhoa**2.6666666666666666d+0
            t4 = 2.0d-1*gammaaa*t3+1.0d+0
            t5 = 1/t4**2
            t6 = 1/rhoa**5.333333333333333d+0
            t7 = param(4)
            t8 = 1/t4
            t9 = 2.0d-1*gammaaa*t3*t7*t8+4.000000000000001d-2*t1*t2*t5*t
     1         6+param(2)
            t10 = rhoa**3.333333333333333d-1
            t11 = t10**5.0d-1
            t12 = 1/t11
            t13 = 1.530901310039024d-2*t12+1.0465751434d-1
            t14 = 7.876233178997433d-1*t12*t13+1.9269083139d-1
            t15 = 7.876233178997433d-1*t12*t14+4.3896648423d-1
            t16 = 1/t15
            t17 = 1.269642451250142d+0*t11*t16+1.0d+0
            t18 = log(t17)
            t19 = 1/t10
            t20 = 1.2746961887000874d-1*t19+1.0d+0
            t21 = 2.4141993114533214d-2*t12+1.0186556948d-1
            t22 = 7.876233178997433d-1*t12*t21+2.2308199064d-1
            t23 = 7.876233178997433d-1*t12*t22+4.7231125998d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t11*t24+1.0d+0
            t26 = log(t25)
            t27 = 1.325688999052018d-1*t19+1.0d+0
            t28 = 1.3212998810398843d-2*t12+2.9729725188d-2
            t29 = 7.876233178997433d-1*t12*t28+1.2236585478d-1
            t30 = 7.876233178997433d-1*t12*t29+3.497952466d-1
            t31 = 1/t30
            t32 = 1.269642451250142d+0*t11*t31+1.0d+0
            t33 = log(t32)
            t34 = 6.901399211255826d-2*t19+1.0d+0
            t35 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t26*t27-3.10907d-2*t18*t20)-3.37738d-2*t33*t34)+
     2         3.37738d-2*t33*t34)-6.21814d-2*t26*t27
            t36 = param(7)
            t37 = 6.0d-3*gammaaa*t3+1.0d+0
            t38 = 1/t37**2
            t39 = param(5)
            t40 = 1/t37
            t41 = 3.6d-5*t2*t36*t38*t6+6.0d-3*gammaaa*t3*t39*t40+param(3
     1         )
            t42 = -2.0d+0*rhoa*t35
            t43 = gammaaa**3
            t44 = 1/t4**3
            t45 = 1/rhoa**9
            t46 = 1/rhoa**6.333333333333333d+0
            t47 = 1/rhoa**3.6666666666666664d+0
            t48 = -5.333333333333333d-1*gammaaa*t47*t7*t8+1.066666666666
     1         6667d-1*t2*t46*t5*t7-2.1333333333333337d-1*t1*t2*t46*t5+4
     2         .2666666666666675d-2*t1*t43*t44*t45
            t49 = 1/rhoa**1.3333333333333333d+0
            t50 = 1/t17
            t51 = 1/t15**2
            t52 = 1/rhoa**1.3333333333333336d+0
            t53 = 1/t11**3
            t54 = 1/rhoa**6.666666666666667d-1
            t55 = -1.3127055298329054d-1*t13*t53*t54-2.0096226153166658d
     1         -3*t52
            t56 = 7.876233178997433d-1*t12*t55-1.3127055298329054d-1*t14
     1         *t53*t54
            t57 = 2.11607075208357d-1*t12*t16*t54-1.269642451250142d+0*t
     1         11*t51*t56
            t58 = 1/t25
            t59 = 1/t23**2
            t60 = -1.3127055298329054d-1*t21*t53*t54-3.169132786263567d-
     1         3*t52
            t61 = 7.876233178997433d-1*t12*t60-1.3127055298329054d-1*t22
     1         *t53*t54
            t62 = 2.11607075208357d-1*t12*t24*t54-1.269642451250142d+0*t
     1         11*t59*t61
            t63 = 1/t32
            t64 = 1/t30**2
            t65 = -1.3127055298329054d-1*t28*t53*t54-1.7344776604086162d
     1         -3*t52
            t66 = 7.876233178997433d-1*t12*t65-1.3127055298329054d-1*t29
     1         *t53*t54
            t67 = 2.11607075208357d-1*t12*t31*t54-1.269642451250142d+0*t
     1         11*t64*t66
            t68 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t34*t63*t67+
     1         1.709920934161365d+0*(6.21814d-2*t27*t58*t62-3.10907d-2*t
     2         20*t50*t57-2.747773264188438d-3*t26*t49+1.321039893133926
     3         5d-3*t18*t49)+7.769549222703733d-4*t33*t49)+3.37738d-2*t3
     4         4*t63*t67-7.769549222703733d-4*t33*t49)-6.21814d-2*t27*t5
     5         8*t62+2.747773264188438d-3*t26*t49
            t69 = 2.1508070719090538d-2*t12+1.0186556948d-1
            t70 = 7.016926042943222d-1*t12*t69+2.2308199064d-1
            t71 = 7.016926042943222d-1*t12*t70+4.7231125998d-1
            t72 = 1/t71
            t73 = 1.425125466450768d+0*t11*t72+1.0d+0
            t74 = log(t73)
            t75 = 1.0522000558389213d-1*t19+1.0d+0
            t76 = 1/t73
            t77 = 1/t71**2
            t78 = -5.847438369119352d-2*t53*t54*t69-1.2576711796854242d-
     1         3*t52
            t79 = 7.016926042943222d-1*t12*t78-5.847438369119352d-2*t53*
     1         t54*t70
            t80 = 1.1876045553756398d-1*t12*t54*t72-1.425125466450768d+0
     1         *t11*t77*t79
            t81 = 1.090454542535705d-3*t49*t74-6.21814d-2*t75*t76*t80
            t82 = 2.0d+0*rhoa*t81-6.21814d-2*t74*t75-1.0d+0*rhoa*t68-1.0
     1         d+0*t35
            t83 = 1/t37**3
            t84 = 5.760000000000001d-7*t36*t43*t45*t83-8.0d-3*gammaaa*t3
     1         9*t40*t47+4.8000000000000004d-5*t2*t38*t39*t46-9.60000000
     2         0000001d-5*t2*t36*t38*t46
            t85 = t42-1.243628d-1*rhoa*t74*t75
            t86 = 1/rhoa**8
            t87 = -1.6000000000000003d-2*t1*t2*t44*t86+2.0d-1*t3*t7*t8-4
     1         .000000000000001d-2*gammaaa*t5*t6*t7+8.000000000000002d-2
     2         *gammaaa*t1*t5*t6
            t88 = -2.16d-7*t2*t36*t83*t86-1.8d-5*gammaaa*t38*t39*t6+3.6d
     1         -5*gammaaa*t36*t38*t6+3.0d-3*t3*t39*t40
            t89 = gammaaa**4
            t90 = 1/t4**4
            t91 = 1/rhoa**1.2666666666666665d+1
            t92 = 1/rhoa**10
            t93 = 1/rhoa**7.333333333333333d+0
            t94 = 1/rhoa**4.666666666666667d+0
            t95 = 1/rhoa**2.333333333333333d+0
            t96 = 1/rhoa**2.3333333333333334d+0
            t97 = 1/rhoa**1.6666666666666669d+0
            t98 = 1/t11**5
            t99 = 1/t25**2
            t100 = t62**2
            t101 = -1.269642451250142d+0*t11*t59*(7.876233178997433d-1*t
     1         12*(6.563527649164527d-2*t21*t52*t98+8.751370198886037d-2
     2         *t21*t53*t97+4.753699179395351d-3*t96)+6.563527649164527d
     3         -2*t22*t52*t98+8.751370198886037d-2*t22*t53*t97-2.6254110
     4         59665811d-1*t53*t54*t60)-1.4107138347223802d-1*t12*t24*t9
     5         7+2.539284902500284d+0*t11*t61**2/t23**3-4.23214150416714
     6         d-1*t12*t54*t59*t61-3.52678458680595d-2*t24*t52*t53
            t102 = 1/t32**2
            t103 = t67**2
            t104 = -1.269642451250142d+0*t11*t64*(7.876233178997433d-1*t
     1         12*(6.563527649164527d-2*t28*t52*t98+8.751370198886037d-2
     2         *t28*t53*t97+2.601716490612924d-3*t96)+6.563527649164527d
     3         -2*t29*t52*t98+8.751370198886037d-2*t29*t53*t97-2.6254110
     4         59665811d-1*t53*t54*t65)-1.4107138347223802d-1*t12*t31*t9
     5         7+2.539284902500284d+0*t11*t66**2/t30**3-4.23214150416714
     6         d-1*t12*t54*t64*t66-3.52678458680595d-2*t31*t52*t53
            t105 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-
     1         6.21814d-2*t100*t27*t99-3.10907d-2*t20*t50*(-1.2696424512
     2         50142d+0*t11*t51*(7.876233178997433d-1*t12*(6.56352764916
     3         4527d-2*t13*t52*t98+8.751370198886037d-2*t13*t53*t97+3.01
     4         44339229749983d-3*t96)+6.563527649164527d-2*t14*t52*t98+8
     5         .751370198886037d-2*t14*t53*t97-2.625411059665811d-1*t53*
     6         t54*t55)-1.4107138347223802d-1*t12*t16*t97+2.539284902500
     7         284d+0*t11*t56**2/t15**3-4.23214150416714d-1*t12*t51*t54*
     8         t56-3.52678458680595d-2*t16*t52*t53)+3.663697685584584d-3
     9         *t26*t95-1.7613865241785687d-3*t18*t95-5.495546528376876d
     :         -3*t49*t58*t62+6.21814d-2*t101*t27*t58+3.10907d-2*t20*t57
     ;         **2/t17**2+2.642079786267853d-3*t49*t50*t57)-1.0359398963
     <         604977d-3*t33*t95+1.5539098445407465d-3*t49*t63*t67-3.377
     =         38d-2*t104*t34*t63+3.37738d-2*t102*t103*t34)+1.0359398963
     >         604977d-3*t33*t95-1.5539098445407465d-3*t49*t63*t67+3.377
     ?         38d-2*t104*t34*t63-3.37738d-2*t102*t103*t34)+6.21814d-2*t
     @         100*t27*t99-3.663697685584584d-3*t26*t95+5.49554652837687
     1         6d-3*t49*t58*t62-6.21814d-2*t101*t27*t58
            t106 = 2*t82*t84
            t107 = 2.0d+0*t81
            t108 = -7.269696950238034d-4*t74*t95
            t109 = log(1.425125466450768d+0*t11/(7.016926042943222d-1*t1
     1         2*(7.016926042943222d-1*(1.1771443702974158d-2*t12+2.9729
     2         725188d-2)*t12+1.2236585478d-1)+3.497952466d-1)+1.0d+0)
            t110 = 5.477644184000001d-2*t19+1.0d+0
            t111 = 1/rhoa**2
            t112 = 2.18090908507141d-3*t49*t76*t80
            t113 = 6.21814d-2*t75*t80**2/t73**2
            t114 = -6.21814d-2*t75*t76*(-1.425125466450768d+0*t11*t77*(7
     1         .016926042943222d-1*t12*(1.4618595922798375d-2*t52*t69*t9
     2         8+1.949146123039784d-2*t53*t69*t97+9.432533847640683d-4*t
     3         96)+1.4618595922798375d-2*t52*t70*t98+1.949146123039784d-
     4         2*t53*t70*t97-1.1694876738238703d-1*t53*t54*t78)-3.958681
     5         8512521327d-2*t12*t72*t97+2.850250932901536d+0*t11*t79**2
     6         /t71**3-2.3752091107512796d-1*t12*t54*t77*t79-9.896704628
     7         130328d-3*t52*t53*t72)
            t115 = 1/t37**4
            t116 = 1.3824000000000003d-8*t115*t36*t89*t91
            t117 = 7.68d-7*t39*t43*t83*t92
            t118 = 1/rhoa**1.1666666666666665d+1
            t119 = t82*t88
            t120 = -5.184000000000001d-9*t115*t118*t36*t43
            t121 = -2.8800000000000003d-7*t2*t39*t45*t83
            t122 = 1/rhoa**1.0666666666666666d+1
            t123 = 1.9440000000000004d-9*t115*t122*t2*t36
            fnc(iq) = 1.0d+0*(2.0d+0*rhoa*t35*t9+t41*(t42-1.243628d-1*rh
     1         oa*log(1.4251254664507676d+0*t11/(7.016926042943223d-1*t1
     2         2*(7.016926042943223d-1*(2.150807071909054d-2*t12+1.01865
     3         56948d-1)*t12+2.2308199064d-1)+4.7231125998d-1)+1.0d+0)*(
     4         1.0522000558389215d-1*t19+1.0d+0)))*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(1.0d+0*rhoa*t68*t9+1.0d+0*t35*t9+t8
     1         4*t85+t41*t82+1.0d+0*rhoa*t35*t48)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.0d+0*(t85*t88+1.0d+0*rhoa*t35*t87)*wght+
     1         Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Amat2(iq,D2_RA_RA) = 1.0d+0*(1.0d+0*rhoa*t35*(1.955555555555
     1         5554d+0*gammaaa*t7*t8*t94-9.6d-1*t2*t5*t7*t93+1.351111111
     2         1111113d+0*t1*t2*t5*t93+1.1377777777777778d-1*t43*t44*t7*
     3         t92-6.115555555555556d-1*t1*t43*t44*t92+6.826666666666669
     4         d-2*t1*t89*t90*t91)+t85*(2.9333333333333333d-2*gammaaa*t3
     5         9*t40*t94-3.04d-4*t2*t38*t39*t93+4.8d-4*t2*t36*t38*t93-5.
     6         184000000000001d-6*t36*t43*t83*t92+t117+t116)+2.0d+0*t68*
     7         t9+1.0d+0*rhoa*t105*t9+2.0d+0*rhoa*t48*t68+t41*(-2.0d+0*t
     8         68+2.0d+0*rhoa*(t114+t113+t112+8.443450000000001d-3*t109*
     9         t110*t111+t108)+t107-1.0d+0*rhoa*t105)+2.0d+0*t35*t48+t10
     :         6)*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = 1.0d+0*(t85*(-1.28d-4*t2*t38*t39*t93+1.
     1         28d-4*t2*t36*t38*t93-3.0720000000000003d-6*t36*t43*t83*t9
     2         2+t117+t116)+(2.0d+0*rhoa*(t114+t113+t112-8.44345d-3*t109
     3         *t110*t111+t108)+t107)*t41+t106)*wght+Amat2(iq,D2_RA_RB)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*(1.0d+0*rhoa*t35*(-2.5600000000
     1         000006d-2*t1*t118*t43*t90-5.333333333333333d-1*t47*t7*t8+
     2         3.2d-1*gammaaa*t46*t5*t7-4.2666666666666675d-2*t2*t44*t45
     3         *t7-4.2666666666666675d-1*gammaaa*t1*t46*t5+2.13333333333
     4         33337d-1*t1*t2*t44*t45)+1.0d+0*rhoa*t68*t87+1.0d+0*t35*t8
     5         7+(1.728d-6*t2*t36*t45*t83-8.0d-3*t39*t40*t47+9.600000000
     6         000001d-5*gammaaa*t38*t39*t46-1.4400000000000002d-4*gamma
     7         aa*t36*t38*t46+t121+t120)*t85+t119)*wght+Cmat2(iq,D2_RA_G
     8         AA)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = 1.0d+0*((1.1520000000000001d-6*t2*t36*
     1         t45*t83+4.8000000000000004d-5*gammaaa*t38*t39*t46-4.80000
     2         00000000004d-5*gammaaa*t36*t38*t46+t121+t120)*t85+t119)*w
     3         ght+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_GAA_GAA) = 1.0d+0*(1.0d+0*rhoa*t35*(9.6000000000
     1         00004d-3*t1*t122*t2*t90+1.6000000000000003d-2*gammaaa*t44
     2         *t7*t86-6.400000000000001d-2*gammaaa*t1*t44*t86-8.0000000
     3         00000002d-2*t5*t6*t7+8.000000000000002d-2*t1*t5*t6)+t85*(
     4         1.08d-7*gammaaa*t39*t83*t86-4.32d-7*gammaaa*t36*t83*t86-1
     5         .8d-5*t38*t39*t6+1.8d-5*t36*t38*t6+t123))*wght+Cmat2(iq,D
     6         2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = 1.0d+0*((1.08d-7*gammaaa*t3*t39-4.32d
     1         -7*gammaaa*t3*t36)*t6*t83+t38*(1.8d-5*t36-1.8d-5*t39)*t6+
     2         t123)*t85*wght+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = param(2)
            t2 = param(6)
            t3 = gammaaa**2
            t4 = 1/rhoa**2.6666666666666666d+0
            t5 = 2.0d-1*gammaaa*t4+1.0d+0
            t6 = 1/t5**2
            t7 = 1/rhoa**5.333333333333333d+0
            t8 = param(4)
            t9 = 1/t5
            t10 = 2.0d-1*gammaaa*t4*t8*t9+4.000000000000001d-2*t2*t3*t6*
     1         t7+t1
            t11 = rhoa**3.333333333333333d-1
            t12 = t11**5.0d-1
            t13 = 1/t12
            t14 = 1.530901310039024d-2*t13+1.0465751434d-1
            t15 = 7.876233178997433d-1*t13*t14+1.9269083139d-1
            t16 = 7.876233178997433d-1*t13*t15+4.3896648423d-1
            t17 = 1/t16
            t18 = 1.269642451250142d+0*t12*t17+1.0d+0
            t19 = log(t18)
            t20 = 1/t11
            t21 = 1.2746961887000874d-1*t20+1.0d+0
            t22 = 2.4141993114533214d-2*t13+1.0186556948d-1
            t23 = 7.876233178997433d-1*t13*t22+2.2308199064d-1
            t24 = 7.876233178997433d-1*t13*t23+4.7231125998d-1
            t25 = 1/t24
            t26 = 1.269642451250142d+0*t12*t25+1.0d+0
            t27 = log(t26)
            t28 = 1.325688999052018d-1*t20+1.0d+0
            t29 = 1.3212998810398843d-2*t13+2.9729725188d-2
            t30 = 7.876233178997433d-1*t13*t29+1.2236585478d-1
            t31 = 7.876233178997433d-1*t13*t30+3.497952466d-1
            t32 = 1/t31
            t33 = 1.269642451250142d+0*t12*t32+1.0d+0
            t34 = log(t33)
            t35 = 6.901399211255826d-2*t20+1.0d+0
            t36 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t27*t28-3.10907d-2*t19*t21)-3.37738d-2*t34*t35)+
     2         3.37738d-2*t34*t35)-6.21814d-2*t27*t28
            t37 = gammabb**2
            t38 = 1/rhob**2.6666666666666666d+0
            t39 = 2.0d-1*gammabb*t38+1.0d+0
            t40 = 1/t39**2
            t41 = 1/rhob**5.333333333333333d+0
            t42 = 1/t39
            t43 = 2.0d-1*gammabb*t38*t42*t8+4.000000000000001d-2*t2*t37*
     1         t40*t41+t1
            t44 = rhob**3.333333333333333d-1
            t45 = t44**5.0d-1
            t46 = 1/t45
            t47 = 1.530901310039024d-2*t46+1.0465751434d-1
            t48 = 7.876233178997433d-1*t46*t47+1.9269083139d-1
            t49 = 7.876233178997433d-1*t46*t48+4.3896648423d-1
            t50 = 1/t49
            t51 = 1.269642451250142d+0*t45*t50+1.0d+0
            t52 = log(t51)
            t53 = 1/t44
            t54 = 1.2746961887000874d-1*t53+1.0d+0
            t55 = 2.4141993114533214d-2*t46+1.0186556948d-1
            t56 = 7.876233178997433d-1*t46*t55+2.2308199064d-1
            t57 = 7.876233178997433d-1*t46*t56+4.7231125998d-1
            t58 = 1/t57
            t59 = 1.269642451250142d+0*t45*t58+1.0d+0
            t60 = log(t59)
            t61 = 1.325688999052018d-1*t53+1.0d+0
            t62 = 1.3212998810398843d-2*t46+2.9729725188d-2
            t63 = 7.876233178997433d-1*t46*t62+1.2236585478d-1
            t64 = 7.876233178997433d-1*t46*t63+3.497952466d-1
            t65 = 1/t64
            t66 = 1.269642451250142d+0*t45*t65+1.0d+0
            t67 = log(t66)
            t68 = 6.901399211255826d-2*t53+1.0d+0
            t69 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t60*t61-3.10907d-2*t52*t54)-3.37738d-2*t67*t68)+
     2         3.37738d-2*t67*t68)-6.21814d-2*t60*t61
            t70 = param(7)
            t71 = gammaaa*t4+gammabb*t38
            t72 = t71**2
            t73 = 3.0d-3*t71+1.0d+0
            t74 = 1/t73**2
            t75 = param(5)
            t76 = 1/t73
            t77 = 3.0d-3*t71*t75*t76+9.0d-6*t70*t72*t74+param(3)
            t78 = rhob+rhoa
            t79 = t78**3.333333333333333d-1
            t80 = 1/t79
            t81 = 1.325688999052018d-1*t80+1.0d+0
            t82 = t79**5.0d-1
            t83 = 1/t82
            t84 = 2.4141993114533214d-2*t83+1.0186556948d-1
            t85 = 7.876233178997433d-1*t83*t84+2.2308199064d-1
            t86 = 7.876233178997433d-1*t83*t85+4.7231125998d-1
            t87 = 1/t86
            t88 = 1.269642451250142d+0*t82*t87+1.0d+0
            t89 = log(t88)
            t90 = rhoa-rhob
            t91 = 1/t78
            t92 = 1.0d+0-t90*t91
            t93 = t90*t91+1.0d+0
            t94 = 1.923661050931536d+0*t93**1.3333333333333333d+0+1.9236
     1         61050931536d+0*t92**1.3333333333333333d+0-3.8473221018630
     2         72d+0
            t95 = 6.901399211255826d-2*t80+1.0d+0
            t96 = 1.3212998810398843d-2*t83+2.9729725188d-2
            t97 = 7.876233178997433d-1*t83*t96+1.2236585478d-1
            t98 = 7.876233178997433d-1*t83*t97+3.497952466d-1
            t99 = 1/t98
            t100 = 1.269642451250142d+0*t82*t99+1.0d+0
            t101 = log(t100)
            t102 = t90**4
            t103 = 1/t78**4
            t104 = 1.2746961887000874d-1*t80+1.0d+0
            t105 = 1.530901310039024d-2*t83+1.0465751434d-1
            t106 = 7.876233178997433d-1*t105*t83+1.9269083139d-1
            t107 = 7.876233178997433d-1*t106*t83+4.3896648423d-1
            t108 = 1/t107
            t109 = 1.269642451250142d+0*t108*t82+1.0d+0
            t110 = log(t109)
            t111 = 1.709920934161365d+0*(6.21814d-2*t81*t89-3.10907d-2*t
     1         104*t110)-3.37738d-2*t101*t95
            t112 = 3.37738d-2*t101*t95+t102*t103*t111
            t113 = 5.848223622634648d-1*t112*t94-6.21814d-2*t81*t89
            t114 = 1.0d+0*t113*t78-1.0d+0*rhob*t69-1.0d+0*rhoa*t36
            t115 = gammaaa**3
            t116 = 1/t5**3
            t117 = 1/rhoa**9
            t118 = 1/rhoa**6.333333333333333d+0
            t119 = 1/rhoa**3.6666666666666664d+0
            t120 = -5.333333333333333d-1*gammaaa*t119*t8*t9+1.0666666666
     1         666667d-1*t118*t3*t6*t8-2.1333333333333337d-1*t118*t2*t3*
     2         t6+4.2666666666666675d-2*t115*t116*t117*t2
            t121 = 1/rhoa**1.3333333333333333d+0
            t122 = 1/t18
            t123 = 1/t16**2
            t124 = 1/rhoa**1.3333333333333336d+0
            t125 = 1/t12**3
            t126 = 1/rhoa**6.666666666666667d-1
            t127 = -1.3127055298329054d-1*t125*t126*t14-2.00962261531666
     1         58d-3*t124
            t128 = 7.876233178997433d-1*t127*t13-1.3127055298329054d-1*t
     1         125*t126*t15
            t129 = 2.11607075208357d-1*t126*t13*t17-1.269642451250142d+0
     1         *t12*t123*t128
            t130 = 1/t26
            t131 = 1/t24**2
            t132 = -1.3127055298329054d-1*t125*t126*t22-3.16913278626356
     1         7d-3*t124
            t133 = 7.876233178997433d-1*t13*t132-1.3127055298329054d-1*t
     1         125*t126*t23
            t134 = 2.11607075208357d-1*t126*t13*t25-1.269642451250142d+0
     1         *t12*t131*t133
            t135 = 1/t33
            t136 = 1/t31**2
            t137 = -1.3127055298329054d-1*t125*t126*t29-1.73447766040861
     1         62d-3*t124
            t138 = 7.876233178997433d-1*t13*t137-1.3127055298329054d-1*t
     1         125*t126*t30
            t139 = 2.11607075208357d-1*t126*t13*t32-1.269642451250142d+0
     1         *t12*t136*t138
            t140 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t135*t139*t
     1         35+7.769549222703733d-4*t121*t34+1.709920934161365d+0*(6.
     2         21814d-2*t130*t134*t28-2.747773264188438d-3*t121*t27-3.10
     3         907d-2*t122*t129*t21+1.3210398931339265d-3*t121*t19))+3.3
     4         7738d-2*t135*t139*t35-7.769549222703733d-4*t121*t34)-6.21
     5         814d-2*t130*t134*t28+2.747773264188438d-3*t121*t27
            t141 = 1/t78**1.3333333333333336d+0
            t142 = 1/t78**6.666666666666667d-1
            t143 = 1/t82**3
            t144 = -1.3127055298329054d-1*t142*t143*t84-3.16913278626356
     1         7d-3*t141
            t145 = 7.876233178997433d-1*t144*t83-1.3127055298329054d-1*t
     1         142*t143*t85
            t146 = 1/t86**2
            t147 = 2.11607075208357d-1*t142*t83*t87-1.269642451250142d+0
     1         *t145*t146*t82
            t148 = 1/t88
            t149 = -6.21814d-2*t147*t148*t81
            t150 = 1/t78**1.3333333333333333d+0
            t151 = 2.747773264188438d-3*t150*t89
            t152 = -1.3127055298329054d-1*t142*t143*t96-1.73447766040861
     1         62d-3*t141
            t153 = 7.876233178997433d-1*t152*t83-1.3127055298329054d-1*t
     1         142*t143*t97
            t154 = 1/t98**2
            t155 = 2.11607075208357d-1*t142*t83*t99-1.269642451250142d+0
     1         *t153*t154*t82
            t156 = 1/t100
            t157 = 3.37738d-2*t155*t156*t95
            t158 = -7.769549222703733d-4*t101*t150
            t159 = -1.3127055298329054d-1*t105*t142*t143-2.0096226153166
     1         658d-3*t141
            t160 = 7.876233178997433d-1*t159*t83-1.3127055298329054d-1*t
     1         106*t142*t143
            t161 = 1/t107**2
            t162 = 2.11607075208357d-1*t108*t142*t83-1.269642451250142d+
     1         0*t160*t161*t82
            t163 = 1/t109
            t164 = -3.37738d-2*t155*t156*t95+1.709920934161365d+0*(-2.74
     1         7773264188438d-3*t150*t89+6.21814d-2*t147*t148*t81-3.1090
     2         7d-2*t104*t162*t163+1.3210398931339265d-3*t110*t150)+7.76
     3         9549222703733d-4*t101*t150
            t165 = t102*t103*t164
            t166 = 1/t78**5
            t167 = -4*t102*t111*t166
            t168 = t90**3
            t169 = 4*t103*t111*t168+t167+t165+t158+t157
            t170 = 1/t78**2
            t171 = t170*t90
            t172 = -t91
            t173 = t172+t171
            t174 = t92**3.333333333333333d-1
            t175 = -t170*t90
            t176 = t91+t175
            t177 = t93**3.333333333333333d-1
            t178 = 2.564881401242048d+0*t176*t177+2.564881401242048d+0*t
     1         173*t174
            t179 = 5.848223622634648d-1*t169*t94+5.848223622634648d-1*t1
     1         12*t178+t151+t149
            t180 = 1.0d+0*t113
            t181 = 1.0d+0*t179*t78-1.0d+0*t36+t180-1.0d+0*rhoa*t140
            t182 = 1/t73**3
            t183 = -8.0d-3*gammaaa*t119*t75*t76+2.4000000000000002d-5*ga
     1         mmaaa*t119*t71*t74*t75-4.8000000000000004d-5*gammaaa*t119
     2         *t70*t71*t74+1.4400000000000002d-7*gammaaa*t119*t182*t70*
     3         t72
            t184 = gammabb**3
            t185 = 1/t39**3
            t186 = 1/rhob**9
            t187 = 1/rhob**6.333333333333333d+0
            t188 = 1/rhob**3.6666666666666664d+0
            t189 = -5.333333333333333d-1*gammabb*t188*t42*t8+1.066666666
     1         6666667d-1*t187*t37*t40*t8-2.1333333333333337d-1*t187*t2*
     2         t37*t40+4.2666666666666675d-2*t184*t185*t186*t2
            t190 = 1/rhob**1.3333333333333333d+0
            t191 = 1/t51
            t192 = 1/t49**2
            t193 = 1/rhob**1.3333333333333336d+0
            t194 = 1/t45**3
            t195 = 1/rhob**6.666666666666667d-1
            t196 = -1.3127055298329054d-1*t194*t195*t47-2.00962261531666
     1         58d-3*t193
            t197 = 7.876233178997433d-1*t196*t46-1.3127055298329054d-1*t
     1         194*t195*t48
            t198 = 2.11607075208357d-1*t195*t46*t50-1.269642451250142d+0
     1         *t192*t197*t45
            t199 = 1/t59
            t200 = 1/t57**2
            t201 = -1.3127055298329054d-1*t194*t195*t55-3.16913278626356
     1         7d-3*t193
            t202 = 7.876233178997433d-1*t201*t46-1.3127055298329054d-1*t
     1         194*t195*t56
            t203 = 2.11607075208357d-1*t195*t46*t58-1.269642451250142d+0
     1         *t200*t202*t45
            t204 = 1/t66
            t205 = 1/t64**2
            t206 = -1.3127055298329054d-1*t194*t195*t62-1.73447766040861
     1         62d-3*t193
            t207 = 7.876233178997433d-1*t206*t46-1.3127055298329054d-1*t
     1         194*t195*t63
            t208 = 2.11607075208357d-1*t195*t46*t65-1.269642451250142d+0
     1         *t205*t207*t45
            t209 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t204*t208*t
     1         68+7.769549222703733d-4*t190*t67+1.709920934161365d+0*(6.
     2         21814d-2*t199*t203*t61-2.747773264188438d-3*t190*t60-3.10
     3         907d-2*t191*t198*t54+1.3210398931339265d-3*t190*t52))+3.3
     4         7738d-2*t204*t208*t68-7.769549222703733d-4*t190*t67)-6.21
     5         814d-2*t199*t203*t61+2.747773264188438d-3*t190*t60
            t210 = -4*t103*t111*t168+t167+t165+t158+t157
            t211 = t91+t171
            t212 = t175+t172
            t213 = 2.564881401242048d+0*t177*t212+2.564881401242048d+0*t
     1         174*t211
            t214 = 5.848223622634648d-1*t210*t94+5.848223622634648d-1*t1
     1         12*t213+t151+t149
            t215 = 1.0d+0*t214*t78-1.0d+0*t69-1.0d+0*rhob*t209+t180
            t216 = -8.0d-3*gammabb*t188*t75*t76+2.4000000000000002d-5*ga
     1         mmabb*t188*t71*t74*t75-4.8000000000000004d-5*gammabb*t188
     2         *t70*t71*t74+1.4400000000000002d-7*gammabb*t182*t188*t70*
     3         t72
            t217 = 1/rhoa**8
            t218 = 2.0d-1*t4*t8*t9-4.000000000000001d-2*gammaaa*t6*t7*t8
     1         +8.000000000000002d-2*gammaaa*t2*t6*t7-1.6000000000000003
     2         d-2*t116*t2*t217*t3
            t219 = 3.0d-3*t4*t75*t76-9.0d-6*t4*t71*t74*t75+1.8d-5*t4*t70
     1         *t71*t74-5.4d-8*t182*t4*t70*t72
            t220 = 1/rhob**8
            t221 = 2.0d-1*t38*t42*t8-4.000000000000001d-2*gammabb*t40*t4
     1         1*t8+8.000000000000002d-2*gammabb*t2*t40*t41-1.6000000000
     2         000003d-2*t185*t2*t220*t37
            t222 = 3.0d-3*t38*t75*t76-9.0d-6*t38*t71*t74*t75+1.8d-5*t38*
     1         t70*t71*t74-5.4d-8*t182*t38*t70*t72
            t223 = 1/t5**4
            t224 = 1/rhoa**10
            t225 = 1/rhoa**7.333333333333333d+0
            t226 = 1/rhoa**4.666666666666667d+0
            t227 = 1/rhoa**2.333333333333333d+0
            t228 = 1/rhoa**2.3333333333333334d+0
            t229 = 1/rhoa**1.6666666666666669d+0
            t230 = 1/t12**5
            t231 = 1/t26**2
            t232 = t134**2
            t233 = -1.4107138347223802d-1*t13*t229*t25-3.52678458680595d
     1         -2*t124*t125*t25+2.539284902500284d+0*t12*t133**2/t24**3-
     2         1.269642451250142d+0*t12*t131*(7.876233178997433d-1*t13*(
     3         6.563527649164527d-2*t124*t22*t230+8.751370198886037d-2*t
     4         125*t22*t229+4.753699179395351d-3*t228)+6.563527649164527
     5         d-2*t124*t23*t230+8.751370198886037d-2*t125*t229*t23-2.62
     6         5411059665811d-1*t125*t126*t132)-4.23214150416714d-1*t126
     7         *t13*t131*t133
            t234 = 1/t33**2
            t235 = t139**2
            t236 = -1.4107138347223802d-1*t13*t229*t32-3.52678458680595d
     1         -2*t124*t125*t32+2.539284902500284d+0*t12*t138**2/t31**3-
     2         1.269642451250142d+0*t12*t136*(6.563527649164527d-2*t124*
     3         t230*t30+8.751370198886037d-2*t125*t229*t30+7.87623317899
     4         7433d-1*t13*(6.563527649164527d-2*t124*t230*t29+8.7513701
     5         98886037d-2*t125*t229*t29+2.601716490612924d-3*t228)-2.62
     6         5411059665811d-1*t125*t126*t137)-4.23214150416714d-1*t126
     7         *t13*t136*t138
            t237 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t135*t236*t
     1         35+3.37738d-2*t234*t235*t35-1.0359398963604977d-3*t227*t3
     2         4+1.709920934161365d+0*(6.21814d-2*t130*t233*t28-6.21814d
     3         -2*t231*t232*t28+3.663697685584584d-3*t227*t27-3.10907d-2
     4         *t122*t21*(-1.269642451250142d+0*t12*t123*(7.876233178997
     5         433d-1*t13*(6.563527649164527d-2*t124*t14*t230+8.75137019
     6         8886037d-2*t125*t14*t229+3.0144339229749983d-3*t228)+6.56
     7         3527649164527d-2*t124*t15*t230+8.751370198886037d-2*t125*
     8         t15*t229-2.625411059665811d-1*t125*t126*t127)-1.410713834
     9         7223802d-1*t13*t17*t229-3.52678458680595d-2*t124*t125*t17
     :         +2.539284902500284d+0*t12*t128**2/t16**3-4.23214150416714
     ;         d-1*t123*t126*t128*t13)-1.7613865241785687d-3*t19*t227+3.
     <         10907d-2*t129**2*t21/t18**2-5.495546528376876d-3*t121*t13
     =         0*t134+2.642079786267853d-3*t121*t122*t129)+1.55390984454
     >         07465d-3*t121*t135*t139)+3.37738d-2*t135*t236*t35-3.37738
     ?         d-2*t234*t235*t35+1.0359398963604977d-3*t227*t34-1.553909
     @         8445407465d-3*t121*t135*t139)-6.21814d-2*t130*t233*t28+6.
     1         21814d-2*t231*t232*t28-3.663697685584584d-3*t227*t27+5.49
     2         5546528376876d-3*t121*t130*t134
            t238 = t147**2
            t239 = 1/t88**2
            t240 = 6.21814d-2*t238*t239*t81
            t241 = 1/t78**2.3333333333333334d+0
            t242 = 1/t82**5
            t243 = 1/t78**1.6666666666666669d+0
            t244 = -1.4107138347223802d-1*t243*t83*t87-3.52678458680595d
     1         -2*t141*t143*t87+2.539284902500284d+0*t145**2*t82/t86**3-
     2         1.269642451250142d+0*t146*t82*(8.751370198886037d-2*t143*
     3         t243*t85+6.563527649164527d-2*t141*t242*t85+7.87623317899
     4         7433d-1*t83*(8.751370198886037d-2*t143*t243*t84+6.5635276
     5         49164527d-2*t141*t242*t84+4.753699179395351d-3*t241)-2.62
     6         5411059665811d-1*t142*t143*t144)-4.23214150416714d-1*t142
     7         *t145*t146*t83
            t245 = -6.21814d-2*t148*t244*t81
            t246 = 5.495546528376876d-3*t147*t148*t150
            t247 = 1/t78**2.333333333333333d+0
            t248 = -3.663697685584584d-3*t247*t89
            t249 = t155**2
            t250 = 1/t100**2
            t251 = -3.37738d-2*t249*t250*t95
            t252 = -1.4107138347223802d-1*t243*t83*t99-3.52678458680595d
     1         -2*t141*t143*t99+2.539284902500284d+0*t153**2*t82/t98**3-
     2         1.269642451250142d+0*t154*t82*(8.751370198886037d-2*t143*
     3         t243*t97+6.563527649164527d-2*t141*t242*t97+7.87623317899
     4         7433d-1*t83*(8.751370198886037d-2*t143*t243*t96+6.5635276
     5         49164527d-2*t141*t242*t96+2.601716490612924d-3*t241)-2.62
     6         5411059665811d-1*t142*t143*t152)-4.23214150416714d-1*t142
     7         *t153*t154*t83
            t253 = 3.37738d-2*t156*t252*t95
            t254 = -1.5539098445407465d-3*t150*t155*t156
            t255 = 1.0359398963604977d-3*t101*t247
            t256 = t102*t103*(-3.37738d-2*t156*t252*t95+3.37738d-2*t249*
     1         t250*t95+1.709920934161365d+0*(3.663697685584584d-3*t247*
     2         t89-3.10907d-2*t104*t163*(-1.269642451250142d+0*t161*t82*
     3         (7.876233178997433d-1*(8.751370198886037d-2*t105*t143*t24
     4         3+6.563527649164527d-2*t105*t141*t242+3.0144339229749983d
     5         -3*t241)*t83+8.751370198886037d-2*t106*t143*t243+6.563527
     6         649164527d-2*t106*t141*t242-2.625411059665811d-1*t142*t14
     7         3*t159)-1.4107138347223802d-1*t108*t243*t83-4.23214150416
     8         714d-1*t142*t160*t161*t83+2.539284902500284d+0*t160**2*t8
     9         2/t107**3-3.52678458680595d-2*t108*t141*t143)+6.21814d-2*
     :         t148*t244*t81-6.21814d-2*t238*t239*t81-1.7613865241785687
     ;         d-3*t110*t247+2.642079786267853d-3*t150*t162*t163+3.10907
     <         d-2*t104*t162**2/t109**2-5.495546528376876d-3*t147*t148*t
     =         150)-1.0359398963604977d-3*t101*t247+1.5539098445407465d-
     >         3*t150*t155*t156)
            t257 = -8*t102*t164*t166
            t258 = 20*t102*t111/t78**6
            t259 = t90**2
            t260 = 12*t103*t111*t259
            t261 = 1/t92**6.666666666666666d-1
            t262 = 1/t78**3
            t263 = -2*t262*t90
            t264 = 2*t170
            t265 = 1/t93**6.666666666666666d-1
            t266 = 2*t262*t90
            t267 = -2*t170
            t268 = 1/t73**4
            t269 = 1/t39**4
            t270 = 1/rhob**10
            t271 = 1/rhob**7.333333333333333d+0
            t272 = 1/rhob**4.666666666666667d+0
            t273 = 1/rhob**2.333333333333333d+0
            t274 = 1/rhob**2.3333333333333334d+0
            t275 = 1/rhob**1.6666666666666669d+0
            t276 = 1/t45**5
            t277 = 1/t59**2
            t278 = t203**2
            t279 = -1.4107138347223802d-1*t275*t46*t58-3.52678458680595d
     1         -2*t193*t194*t58+2.539284902500284d+0*t202**2*t45/t57**3-
     2         1.269642451250142d+0*t200*t45*(6.563527649164527d-2*t193*
     3         t276*t56+8.751370198886037d-2*t194*t275*t56+7.87623317899
     4         7433d-1*t46*(6.563527649164527d-2*t193*t276*t55+8.7513701
     5         98886037d-2*t194*t275*t55+4.753699179395351d-3*t274)-2.62
     6         5411059665811d-1*t194*t195*t201)-4.23214150416714d-1*t195
     7         *t200*t202*t46
            t280 = 1/t66**2
            t281 = t208**2
            t282 = -1.4107138347223802d-1*t275*t46*t65-3.52678458680595d
     1         -2*t193*t194*t65+2.539284902500284d+0*t207**2*t45/t64**3-
     2         1.269642451250142d+0*t205*t45*(6.563527649164527d-2*t193*
     3         t276*t63+8.751370198886037d-2*t194*t275*t63+7.87623317899
     4         7433d-1*t46*(6.563527649164527d-2*t193*t276*t62+8.7513701
     5         98886037d-2*t194*t275*t62+2.601716490612924d-3*t274)-2.62
     6         5411059665811d-1*t194*t195*t206)-4.23214150416714d-1*t195
     7         *t205*t207*t46
            t283 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t204*t282*t
     1         68+3.37738d-2*t280*t281*t68-1.0359398963604977d-3*t273*t6
     2         7+1.709920934161365d+0*(6.21814d-2*t199*t279*t61-6.21814d
     3         -2*t277*t278*t61+3.663697685584584d-3*t273*t60+3.10907d-2
     4         *t198**2*t54/t51**2-3.10907d-2*t191*(-1.4107138347223802d
     5         -1*t275*t46*t50-3.52678458680595d-2*t193*t194*t50+2.53928
     6         4902500284d+0*t197**2*t45/t49**3-1.269642451250142d+0*t19
     7         2*t45*(6.563527649164527d-2*t193*t276*t48+8.7513701988860
     8         37d-2*t194*t275*t48+7.876233178997433d-1*t46*(6.563527649
     9         164527d-2*t193*t276*t47+8.751370198886037d-2*t194*t275*t4
     :         7+3.0144339229749983d-3*t274)-2.625411059665811d-1*t194*t
     ;         195*t196)-4.23214150416714d-1*t192*t195*t197*t46)*t54-1.7
     <         613865241785687d-3*t273*t52-5.495546528376876d-3*t190*t19
     =         9*t203+2.642079786267853d-3*t190*t191*t198)+1.55390984454
     >         07465d-3*t190*t204*t208)+3.37738d-2*t204*t282*t68-3.37738
     ?         d-2*t280*t281*t68+1.0359398963604977d-3*t273*t67-1.553909
     @         8445407465d-3*t190*t204*t208)-6.21814d-2*t199*t279*t61+6.
     1         21814d-2*t277*t278*t61-3.663697685584584d-3*t273*t60+5.49
     2         5546528376876d-3*t190*t199*t203
            fnc(iq) = 1.0d+0*(t114*t77+1.0d+0*rhob*t43*t69+1.0d+0*rhoa*t
     1         10*t36)*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(t181*t77+1.0d+0*rhoa*t120*t36+1.0d+
     1         0*t10*t36+t114*t183+1.0d+0*rhoa*t10*t140)*wght+Amat(iq,D1
     2         _RA)
            Amat(iq,D1_RB) = 1.0d+0*(t215*t77+1.0d+0*t43*t69+1.0d+0*rhob
     1         *t189*t69+1.0d+0*rhob*t209*t43+t114*t216)*wght+Amat(iq,D1
     2         _RB)
            Cmat(iq,D1_GAA) = 1.0d+0*(1.0d+0*rhoa*t218*t36+t114*t219)*wg
     1         ht+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = 1.0d+0*(1.0d+0*rhob*t221*t69+t114*t222)*wg
     1         ht+Cmat(iq,D1_GBB)
            Amat2(iq,D2_RA_RA) = 1.0d+0*(t77*(1.0d+0*t78*(5.848223622634
     1         648d-1*(t260+t258+t257+t256+t255+t254+t253+t251-32*t111*t
     2         166*t168+8*t103*t164*t168)*t94+5.848223622634648d-1*t112*
     3         (2.564881401242048d+0*t177*(t267+t266)+8.549604670806825d
     4         -1*t176**2*t265+2.564881401242048d+0*t174*(t264+t263)+8.5
     5         49604670806825d-1*t173**2*t261)+t248+t246+t245+t240+1.169
     6         6447245269297d+0*t169*t178)-1.0d+0*rhoa*t237+2.0d+0*t179-
     7         2.0d+0*t140)+1.0d+0*rhoa*t36*(1.9555555555555554d+0*gamma
     8         aa*t226*t8*t9-9.6d-1*t225*t3*t6*t8+1.1377777777777778d-1*
     9         t115*t116*t224*t8+1.3511111111111113d+0*t2*t225*t3*t6-6.1
     :         15555555555556d-1*t115*t116*t2*t224+6.826666666666669d-2*
     ;         gammaaa**4*t2*t223/rhoa**1.2666666666666665d+1)+t114*(2.9
     <         333333333333333d-2*gammaaa*t226*t75*t76-8.8d-5*gammaaa*t2
     =         26*t71*t74*t75-1.28d-4*t225*t3*t74*t75+3.84d-7*t182*t225*
     >         t3*t71*t75+1.76d-4*gammaaa*t226*t70*t71*t74+1.28d-4*t225*
     ?         t3*t70*t74+3.456000000000001d-9*t225*t268*t3*t70*t72-5.28
     @         d-7*gammaaa*t182*t226*t70*t72-1.5360000000000001d-6*t182*
     1         t225*t3*t70*t71)+2.0d+0*t120*t36+1.0d+0*rhoa*t10*t237+2*t
     2         181*t183+2.0d+0*rhoa*t120*t140+2.0d+0*t10*t140)*wght+Amat
     3         2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = 1.0d+0*(t77*(1.0d+0*t78*(5.848223622634
     1         648d-1*(-12*t103*t111*t259+t258+t257+t256+t255+t254+t253+
     2         t251)*t94+5.848223622634648d-1*t112*(5.129762802484096d+0
     3         *t177*t262*t90-5.129762802484096d+0*t174*t262*t90+8.54960
     4         4670806825d-1*t176*t212*t265+8.549604670806825d-1*t173*t2
     5         11*t261)+t248+t246+t245+t240+5.848223622634648d-1*t169*t2
     6         13+5.848223622634648d-1*t178*t210)+1.0d+0*t214+1.0d+0*t17
     7         9)+t114*(-1.28d-4*gammaaa*gammabb*t119*t188*t74*t75+3.84d
     8         -7*gammaaa*gammabb*t119*t182*t188*t71*t75+1.28d-4*gammaaa
     9         *gammabb*t119*t188*t70*t74+3.456000000000001d-9*gammaaa*g
     :         ammabb*t119*t188*t268*t70*t72-1.5360000000000001d-6*gamma
     ;         aa*gammabb*t119*t182*t188*t70*t71)+t181*t216+t183*t215)*w
     <         ght+Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*(t77*(1.0d+0*t78*(5.848223622634
     1         648d-1*(t260+t258+t257+t256+t255+t254+t253+t251+32*t111*t
     2         166*t168-8*t103*t164*t168)*t94+5.848223622634648d-1*t112*
     3         (2.564881401242048d+0*t174*(t267+t263)+2.564881401242048d
     4         +0*t177*(t266+t264)+8.549604670806825d-1*t212**2*t265+8.5
     5         49604670806825d-1*t211**2*t261)+t248+t246+t245+t240+1.169
     6         6447245269297d+0*t210*t213)-1.0d+0*rhob*t283+2.0d+0*t214-
     7         2.0d+0*t209)+1.0d+0*rhob*t69*(1.9555555555555554d+0*gamma
     8         bb*t272*t42*t8-9.6d-1*t271*t37*t40*t8+1.1377777777777778d
     9         -1*t184*t185*t270*t8+1.3511111111111113d+0*t2*t271*t37*t4
     :         0-6.115555555555556d-1*t184*t185*t2*t270+6.82666666666666
     ;         9d-2*gammabb**4*t2*t269/rhob**1.2666666666666665d+1)+t114
     <         *(2.9333333333333333d-2*gammabb*t272*t75*t76-8.8d-5*gamma
     =         bb*t272*t71*t74*t75-1.28d-4*t271*t37*t74*t75+3.84d-7*t182
     >         *t271*t37*t71*t75+1.76d-4*gammabb*t272*t70*t71*t74+1.28d-
     ?         4*t271*t37*t70*t74+3.456000000000001d-9*t268*t271*t37*t70
     @         *t72-5.28d-7*gammabb*t182*t272*t70*t72-1.5360000000000001
     1         d-6*t182*t271*t37*t70*t71)+2.0d+0*t189*t69+1.0d+0*rhob*t2
     2         83*t43+2.0d+0*t209*t43+2*t215*t216+2.0d+0*rhob*t189*t209)
     3         *wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*(1.0d+0*rhoa*t36*(-5.3333333333
     1         33333d-1*t119*t8*t9+3.2d-1*gammaaa*t118*t6*t8-4.266666666
     2         6666675d-2*t116*t117*t3*t8-4.2666666666666675d-1*gammaaa*
     3         t118*t2*t6+2.1333333333333337d-1*t116*t117*t2*t3-2.560000
     4         0000000006d-2*t115*t2*t223/rhoa**1.1666666666666665d+1)+t
     5         114*(-8.0d-3*t119*t75*t76+2.4000000000000002d-5*t119*t71*
     6         t74*t75+4.8000000000000004d-5*gammaaa*t118*t74*t75-1.4400
     7         000000000002d-7*gammaaa*t118*t182*t71*t75-4.8000000000000
     8         004d-5*t119*t70*t71*t74-4.8000000000000004d-5*gammaaa*t11
     9         8*t70*t74-1.2960000000000002d-9*gammaaa*t118*t268*t70*t72
     :         +1.4400000000000002d-7*t119*t182*t70*t72+5.76000000000000
     ;         1d-7*gammaaa*t118*t182*t70*t71)+1.0d+0*t218*t36+t181*t219
     <         +1.0d+0*rhoa*t140*t218)*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = 1.0d+0*(t114*(4.8000000000000004d-5*ga
     1         mmaaa*t119*t38*t74*t75-1.4400000000000002d-7*gammaaa*t119
     2         *t182*t38*t71*t75-4.8000000000000004d-5*gammaaa*t119*t38*
     3         t70*t74-1.2960000000000002d-9*gammaaa*t119*t268*t38*t70*t
     4         72+5.760000000000001d-7*gammaaa*t119*t182*t38*t70*t71)+t1
     5         81*t222)*wght+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_RB_GAA) = 1.0d+0*(t114*(4.8000000000000004d-5*ga
     1         mmabb*t188*t4*t74*t75-1.4400000000000002d-7*gammabb*t182*
     2         t188*t4*t71*t75-4.8000000000000004d-5*gammabb*t188*t4*t70
     3         *t74-1.2960000000000002d-9*gammabb*t188*t268*t4*t70*t72+5
     4         .760000000000001d-7*gammabb*t182*t188*t4*t70*t71)+t215*t2
     5         19)*wght+Cmat2(iq,D2_RB_GAA)
            Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
            Cmat2(iq,D2_RB_GBB) = 1.0d+0*(1.0d+0*rhob*t69*(-5.3333333333
     1         33333d-1*t188*t42*t8+3.2d-1*gammabb*t187*t40*t8-4.2666666
     2         666666675d-2*t185*t186*t37*t8-4.2666666666666675d-1*gamma
     3         bb*t187*t2*t40+2.1333333333333337d-1*t185*t186*t2*t37-2.5
     4         600000000000006d-2*t184*t2*t269/rhob**1.1666666666666665d
     5         +1)+t114*(-8.0d-3*t188*t75*t76+2.4000000000000002d-5*t188
     6         *t71*t74*t75+4.8000000000000004d-5*gammabb*t187*t74*t75-1
     7         .4400000000000002d-7*gammabb*t182*t187*t71*t75-4.80000000
     8         00000004d-5*t188*t70*t71*t74-4.8000000000000004d-5*gammab
     9         b*t187*t70*t74-1.2960000000000002d-9*gammabb*t187*t268*t7
     :         0*t72+1.4400000000000002d-7*t182*t188*t70*t72+5.760000000
     ;         000001d-7*gammabb*t182*t187*t70*t71)+1.0d+0*t221*t69+t215
     <         *t222+1.0d+0*rhob*t209*t221)*wght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GAA_GAA) = 1.0d+0*(1.0d+0*rhoa*t36*(-8.000000000
     1         000002d-2*t6*t7*t8+1.6000000000000003d-2*gammaaa*t116*t21
     2         7*t8+8.000000000000002d-2*t2*t6*t7+9.600000000000004d-3*t
     3         2*t223*t3/rhoa**1.0666666666666666d+1-6.400000000000001d-
     4         2*gammaaa*t116*t2*t217)+t114*(-1.8d-5*t7*t74*t75+5.4d-8*t
     5         182*t7*t71*t75+1.8d-5*t7*t70*t74+4.860000000000001d-10*t2
     6         68*t7*t70*t72-2.16d-7*t182*t7*t70*t71))*wght+Cmat2(iq,D2_
     7         GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = 1.0d+0*t114*(t182*t38*t4*(5.4d-8*t71*
     1         t75-2.16d-7*t70*t71)+t38*t4*t74*(1.8d-5*t70-1.8d-5*t75)+4
     2         .860000000000001d-10*t268*t38*t4*t70*t72)*wght+Cmat2(iq,D
     3         2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
            Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
            Cmat2(iq,D2_GBB_GBB) = 1.0d+0*(1.0d+0*rhob*t69*(-8.000000000
     1         000002d-2*t40*t41*t8+1.6000000000000003d-2*gammabb*t185*t
     2         220*t8+8.000000000000002d-2*t2*t40*t41+9.600000000000004d
     3         -3*t2*t269*t37/rhob**1.0666666666666666d+1-6.400000000000
     4         001d-2*gammabb*t185*t2*t220)+t114*(-1.8d-5*t41*t74*t75+5.
     5         4d-8*t182*t41*t71*t75+1.8d-5*t41*t70*t74+4.86000000000000
     6         1d-10*t268*t41*t70*t72-2.16d-7*t182*t41*t70*t71))*wght+Cm
     7         at2(iq,D2_GBB_GBB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = param(6)
            t2 = gammaaa**2
            t3 = 1/rhoa**2.6666666666666666d+0
            t4 = 2.0d-1*gammaaa*t3+1.0d+0
            t5 = 1/t4**2
            t6 = 1/rhoa**5.333333333333333d+0
            t7 = param(4)
            t8 = 1/t4
            t9 = 2.0d-1*gammaaa*t3*t7*t8+4.000000000000001d-2*t1*t2*t5*t
     1         6+param(2)
            t10 = rhoa**3.333333333333333d-1
            t11 = t10**5.0d-1
            t12 = 1/t11
            t13 = 1.530901310039024d-2*t12+1.0465751434d-1
            t14 = 7.876233178997433d-1*t12*t13+1.9269083139d-1
            t15 = 7.876233178997433d-1*t12*t14+4.3896648423d-1
            t16 = 1/t15
            t17 = 1.269642451250142d+0*t11*t16+1.0d+0
            t18 = log(t17)
            t19 = 1/t10
            t20 = 1.2746961887000874d-1*t19+1.0d+0
            t21 = 2.4141993114533214d-2*t12+1.0186556948d-1
            t22 = 7.876233178997433d-1*t12*t21+2.2308199064d-1
            t23 = 7.876233178997433d-1*t12*t22+4.7231125998d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t11*t24+1.0d+0
            t26 = log(t25)
            t27 = 1.325688999052018d-1*t19+1.0d+0
            t28 = 1.3212998810398843d-2*t12+2.9729725188d-2
            t29 = 7.876233178997433d-1*t12*t28+1.2236585478d-1
            t30 = 7.876233178997433d-1*t12*t29+3.497952466d-1
            t31 = 1/t30
            t32 = 1.269642451250142d+0*t11*t31+1.0d+0
            t33 = log(t32)
            t34 = 6.901399211255826d-2*t19+1.0d+0
            t35 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t26*t27-3.10907d-2*t18*t20)-3.37738d-2*t33*t34)+
     2         3.37738d-2*t33*t34)-6.21814d-2*t26*t27
            t36 = gammaaa**3
            t37 = 1/t4**3
            t38 = 1/rhoa**9
            t39 = 1/rhoa**6.333333333333333d+0
            t40 = 1/rhoa**3.6666666666666664d+0
            t41 = -5.333333333333333d-1*gammaaa*t40*t7*t8+1.066666666666
     1         6667d-1*t2*t39*t5*t7-2.1333333333333337d-1*t1*t2*t39*t5+4
     2         .2666666666666675d-2*t1*t36*t37*t38
            t42 = 1/rhoa**1.3333333333333333d+0
            t43 = 1/t17
            t44 = 1/t15**2
            t45 = 1/rhoa**1.3333333333333336d+0
            t46 = 1/t11**3
            t47 = 1/rhoa**6.666666666666667d-1
            t48 = -1.3127055298329054d-1*t13*t46*t47-2.0096226153166658d
     1         -3*t45
            t49 = 7.876233178997433d-1*t12*t48-1.3127055298329054d-1*t14
     1         *t46*t47
            t50 = 2.11607075208357d-1*t12*t16*t47-1.269642451250142d+0*t
     1         11*t44*t49
            t51 = 1/t25
            t52 = 1/t23**2
            t53 = -1.3127055298329054d-1*t21*t46*t47-3.169132786263567d-
     1         3*t45
            t54 = 7.876233178997433d-1*t12*t53-1.3127055298329054d-1*t22
     1         *t46*t47
            t55 = 2.11607075208357d-1*t12*t24*t47-1.269642451250142d+0*t
     1         11*t52*t54
            t56 = 1/t32
            t57 = 1/t30**2
            t58 = -1.3127055298329054d-1*t28*t46*t47-1.7344776604086162d
     1         -3*t45
            t59 = 7.876233178997433d-1*t12*t58-1.3127055298329054d-1*t29
     1         *t46*t47
            t60 = 2.11607075208357d-1*t12*t31*t47-1.269642451250142d+0*t
     1         11*t57*t59
            t61 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t34*t56*t60+
     1         1.709920934161365d+0*(6.21814d-2*t27*t51*t55-3.10907d-2*t
     2         20*t43*t50-2.747773264188438d-3*t26*t42+1.321039893133926
     3         5d-3*t18*t42)+7.769549222703733d-4*t33*t42)+3.37738d-2*t3
     4         4*t56*t60-7.769549222703733d-4*t33*t42)-6.21814d-2*t27*t5
     5         1*t55+2.747773264188438d-3*t26*t42
            t62 = 1/rhoa**8
            t63 = -1.6000000000000003d-2*t1*t2*t37*t62
            t64 = 8.000000000000002d-2*gammaaa*t1-4.000000000000001d-2*g
     1         ammaaa*t7
            t65 = 2.0d-1*t3*t7*t8
            t66 = 1/t4**4
            t67 = 1/rhoa**10
            t68 = 1/rhoa**7.333333333333333d+0
            t69 = 1/rhoa**2.333333333333333d+0
            t70 = 1/rhoa**2.3333333333333334d+0
            t71 = 1/rhoa**1.6666666666666669d+0
            t72 = 1/t11**5
            t73 = 1/t25**2
            t74 = t55**2
            t75 = -1.269642451250142d+0*t11*t52*(7.876233178997433d-1*t1
     1         2*(6.563527649164527d-2*t21*t45*t72+8.751370198886037d-2*
     2         t21*t46*t71+4.753699179395351d-3*t70)+6.563527649164527d-
     3         2*t22*t45*t72+8.751370198886037d-2*t22*t46*t71-2.62541105
     4         9665811d-1*t46*t47*t53)-1.4107138347223802d-1*t12*t24*t71
     5         +2.539284902500284d+0*t11*t54**2/t23**3-4.23214150416714d
     6         -1*t12*t47*t52*t54-3.52678458680595d-2*t24*t45*t46
            t76 = 1/t32**2
            t77 = t60**2
            t78 = -1.269642451250142d+0*t11*t57*(7.876233178997433d-1*t1
     1         2*(6.563527649164527d-2*t28*t45*t72+8.751370198886037d-2*
     2         t28*t46*t71+2.601716490612924d-3*t70)+6.563527649164527d-
     3         2*t29*t45*t72+8.751370198886037d-2*t29*t46*t71-2.62541105
     4         9665811d-1*t46*t47*t58)-1.4107138347223802d-1*t12*t31*t71
     5         +2.539284902500284d+0*t11*t59**2/t30**3-4.23214150416714d
     6         -1*t12*t47*t57*t59-3.52678458680595d-2*t31*t45*t46
            t79 = -4.000000000000001d-2*gammaaa*t5*t6*t7+t65+t63+8.00000
     1         0000000002d-2*gammaaa*t1*t5*t6
            fnc(iq) = 1.0d+0*rhoa*t35*t9*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*rhoa*t61*t9*wght+1.0d+0*t35*t9*wght+
     1         1.0d+0*rhoa*t35*t41*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.0d+0*rhoa*t35*(t65+t5*t6*t64+t63)*wght+C
     1         mat(iq,D1_GAA)
            Amat2(iq,D2_RA_RA) = 1.0d+0*rhoa*(5.848223622634643d-1*(1.0d
     1         +0*(-3.37738d-2*t34*t56*t78+3.37738d-2*t34*t76*t77+1.7099
     2         20934161365d+0*(6.21814d-2*t27*t51*t75-6.21814d-2*t27*t73
     3         *t74-3.10907d-2*t20*t43*(-1.269642451250142d+0*t11*t44*(7
     4         .876233178997433d-1*t12*(6.563527649164527d-2*t13*t45*t72
     5         +8.751370198886037d-2*t13*t46*t71+3.0144339229749983d-3*t
     6         70)+6.563527649164527d-2*t14*t45*t72+8.751370198886037d-2
     7         *t14*t46*t71-2.625411059665811d-1*t46*t47*t48)-1.41071383
     8         47223802d-1*t12*t16*t71+2.539284902500284d+0*t11*t49**2/t
     9         15**3-4.23214150416714d-1*t12*t44*t47*t49-3.5267845868059
     :         5d-2*t16*t45*t46)+3.663697685584584d-3*t26*t69-1.76138652
     ;         41785687d-3*t18*t69-5.495546528376876d-3*t42*t51*t55+3.10
     <         907d-2*t20*t50**2/t17**2+2.642079786267853d-3*t42*t43*t50
     =         )-1.0359398963604977d-3*t33*t69+1.5539098445407465d-3*t42
     >         *t56*t60)+3.37738d-2*t34*t56*t78-3.37738d-2*t34*t76*t77+1
     ?         .0359398963604977d-3*t33*t69-1.5539098445407465d-3*t42*t5
     @         6*t60)-6.21814d-2*t27*t51*t75+6.21814d-2*t27*t73*t74-3.66
     1         3697685584584d-3*t26*t69+5.495546528376876d-3*t42*t51*t55
     2         )*t9*wght+2.0d+0*t61*t9*wght+1.0d+0*rhoa*t35*(1.955555555
     3         5555554d+0*gammaaa*t7*t8/rhoa**4.666666666666667d+0-9.6d-
     4         1*t2*t5*t68*t7+1.1377777777777778d-1*t36*t37*t67*t7+1.351
     5         1111111111113d+0*t1*t2*t5*t68-6.115555555555556d-1*t1*t36
     6         *t37*t67+6.826666666666669d-2*gammaaa**4*t1*t66/rhoa**1.2
     7         666666666666665d+1)*wght+2.0d+0*rhoa*t41*t61*wght+2.0d+0*
     8         t35*t41*wght+Amat2(iq,D2_RA_RA)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*rhoa*t35*(-5.333333333333333d-1
     1         *t40*t7*t8+3.2d-1*gammaaa*t39*t5*t7-4.2666666666666675d-2
     2         *t2*t37*t38*t7-2.5600000000000006d-2*t1*t36*t66/rhoa**1.1
     3         666666666666665d+1-4.2666666666666675d-1*gammaaa*t1*t39*t
     4         5+2.1333333333333337d-1*t1*t2*t37*t38)*wght+1.0d+0*rhoa*t
     5         61*t79*wght+1.0d+0*t35*t79*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_GAA_GAA) = 1.0d+0*rhoa*t35*(t5*t6*(8.00000000000
     1         0002d-2*t1-8.000000000000002d-2*t7)+9.600000000000004d-3*
     2         t1*t2*t66/rhoa**1.0666666666666666d+1+t37*t62*(-4.0d-1*t6
     3         4-3.2000000000000006d-2*gammaaa*t1))*wght+Cmat2(iq,D2_GAA
     4         _GAA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = param(6)
            t2 = gammabb**2
            t3 = 1/rhob**2.6666666666666666d+0
            t4 = 2.0d-1*gammabb*t3+1.0d+0
            t5 = 1/t4**2
            t6 = 1/rhob**5.333333333333333d+0
            t7 = param(4)
            t8 = 1/t4
            t9 = 2.0d-1*gammabb*t3*t7*t8+4.000000000000001d-2*t1*t2*t5*t
     1         6+param(2)
            t10 = rhob**3.333333333333333d-1
            t11 = t10**5.0d-1
            t12 = 1/t11
            t13 = 1.530901310039024d-2*t12+1.0465751434d-1
            t14 = 7.876233178997433d-1*t12*t13+1.9269083139d-1
            t15 = 7.876233178997433d-1*t12*t14+4.3896648423d-1
            t16 = 1/t15
            t17 = 1.269642451250142d+0*t11*t16+1.0d+0
            t18 = log(t17)
            t19 = 1/t10
            t20 = 1.2746961887000874d-1*t19+1.0d+0
            t21 = 2.4141993114533214d-2*t12+1.0186556948d-1
            t22 = 7.876233178997433d-1*t12*t21+2.2308199064d-1
            t23 = 7.876233178997433d-1*t12*t22+4.7231125998d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t11*t24+1.0d+0
            t26 = log(t25)
            t27 = 1.325688999052018d-1*t19+1.0d+0
            t28 = 1.3212998810398843d-2*t12+2.9729725188d-2
            t29 = 7.876233178997433d-1*t12*t28+1.2236585478d-1
            t30 = 7.876233178997433d-1*t12*t29+3.497952466d-1
            t31 = 1/t30
            t32 = 1.269642451250142d+0*t11*t31+1.0d+0
            t33 = log(t32)
            t34 = 6.901399211255826d-2*t19+1.0d+0
            t35 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t26*t27-3.10907d-2*t18*t20)-3.37738d-2*t33*t34)+
     2         3.37738d-2*t33*t34)-6.21814d-2*t26*t27
            t36 = gammabb**3
            t37 = 1/t4**3
            t38 = 1/rhob**9
            t39 = 1/rhob**6.333333333333333d+0
            t40 = 1/rhob**3.6666666666666664d+0
            t41 = -5.333333333333333d-1*gammabb*t40*t7*t8+1.066666666666
     1         6667d-1*t2*t39*t5*t7-2.1333333333333337d-1*t1*t2*t39*t5+4
     2         .2666666666666675d-2*t1*t36*t37*t38
            t42 = 1/rhob**1.3333333333333333d+0
            t43 = 1/t17
            t44 = 1/t15**2
            t45 = 1/rhob**1.3333333333333336d+0
            t46 = 1/t11**3
            t47 = 1/rhob**6.666666666666667d-1
            t48 = -1.3127055298329054d-1*t13*t46*t47-2.0096226153166658d
     1         -3*t45
            t49 = 7.876233178997433d-1*t12*t48-1.3127055298329054d-1*t14
     1         *t46*t47
            t50 = 2.11607075208357d-1*t12*t16*t47-1.269642451250142d+0*t
     1         11*t44*t49
            t51 = 1/t25
            t52 = 1/t23**2
            t53 = -1.3127055298329054d-1*t21*t46*t47-3.169132786263567d-
     1         3*t45
            t54 = 7.876233178997433d-1*t12*t53-1.3127055298329054d-1*t22
     1         *t46*t47
            t55 = 2.11607075208357d-1*t12*t24*t47-1.269642451250142d+0*t
     1         11*t52*t54
            t56 = 1/t32
            t57 = 1/t30**2
            t58 = -1.3127055298329054d-1*t28*t46*t47-1.7344776604086162d
     1         -3*t45
            t59 = 7.876233178997433d-1*t12*t58-1.3127055298329054d-1*t29
     1         *t46*t47
            t60 = 2.11607075208357d-1*t12*t31*t47-1.269642451250142d+0*t
     1         11*t57*t59
            t61 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t34*t56*t60+
     1         1.709920934161365d+0*(6.21814d-2*t27*t51*t55-3.10907d-2*t
     2         20*t43*t50-2.747773264188438d-3*t26*t42+1.321039893133926
     3         5d-3*t18*t42)+7.769549222703733d-4*t33*t42)+3.37738d-2*t3
     4         4*t56*t60-7.769549222703733d-4*t33*t42)-6.21814d-2*t27*t5
     5         1*t55+2.747773264188438d-3*t26*t42
            t62 = 1/rhob**8
            t63 = -1.6000000000000003d-2*t1*t2*t37*t62
            t64 = 8.000000000000002d-2*gammabb*t1-4.000000000000001d-2*g
     1         ammabb*t7
            t65 = 2.0d-1*t3*t7*t8
            t66 = 1/t4**4
            t67 = 1/rhob**10
            t68 = 1/rhob**7.333333333333333d+0
            t69 = 1/rhob**2.333333333333333d+0
            t70 = 1/rhob**2.3333333333333334d+0
            t71 = 1/rhob**1.6666666666666669d+0
            t72 = 1/t11**5
            t73 = 1/t25**2
            t74 = t55**2
            t75 = -1.269642451250142d+0*t11*t52*(7.876233178997433d-1*t1
     1         2*(6.563527649164527d-2*t21*t45*t72+8.751370198886037d-2*
     2         t21*t46*t71+4.753699179395351d-3*t70)+6.563527649164527d-
     3         2*t22*t45*t72+8.751370198886037d-2*t22*t46*t71-2.62541105
     4         9665811d-1*t46*t47*t53)-1.4107138347223802d-1*t12*t24*t71
     5         +2.539284902500284d+0*t11*t54**2/t23**3-4.23214150416714d
     6         -1*t12*t47*t52*t54-3.52678458680595d-2*t24*t45*t46
            t76 = 1/t32**2
            t77 = t60**2
            t78 = -1.269642451250142d+0*t11*t57*(7.876233178997433d-1*t1
     1         2*(6.563527649164527d-2*t28*t45*t72+8.751370198886037d-2*
     2         t28*t46*t71+2.601716490612924d-3*t70)+6.563527649164527d-
     3         2*t29*t45*t72+8.751370198886037d-2*t29*t46*t71-2.62541105
     4         9665811d-1*t46*t47*t58)-1.4107138347223802d-1*t12*t31*t71
     5         +2.539284902500284d+0*t11*t59**2/t30**3-4.23214150416714d
     6         -1*t12*t47*t57*t59-3.52678458680595d-2*t31*t45*t46
            t79 = -4.000000000000001d-2*gammabb*t5*t6*t7+t65+t63+8.00000
     1         0000000002d-2*gammabb*t1*t5*t6
            fnc(iq) = 1.0d+0*rhob*t35*t9*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*rhob*t61*t9*wght+1.0d+0*t35*t9*wght+
     1         1.0d+0*rhob*t35*t41*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = 1.0d+0*rhob*t35*(t65+t5*t6*t64+t63)*wght+C
     1         mat(iq,D1_GBB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*rhob*(5.848223622634643d-1*(1.0d
     1         +0*(-3.37738d-2*t34*t56*t78+3.37738d-2*t34*t76*t77+1.7099
     2         20934161365d+0*(6.21814d-2*t27*t51*t75-6.21814d-2*t27*t73
     3         *t74-3.10907d-2*t20*t43*(-1.269642451250142d+0*t11*t44*(7
     4         .876233178997433d-1*t12*(6.563527649164527d-2*t13*t45*t72
     5         +8.751370198886037d-2*t13*t46*t71+3.0144339229749983d-3*t
     6         70)+6.563527649164527d-2*t14*t45*t72+8.751370198886037d-2
     7         *t14*t46*t71-2.625411059665811d-1*t46*t47*t48)-1.41071383
     8         47223802d-1*t12*t16*t71+2.539284902500284d+0*t11*t49**2/t
     9         15**3-4.23214150416714d-1*t12*t44*t47*t49-3.5267845868059
     :         5d-2*t16*t45*t46)+3.663697685584584d-3*t26*t69-1.76138652
     ;         41785687d-3*t18*t69-5.495546528376876d-3*t42*t51*t55+3.10
     <         907d-2*t20*t50**2/t17**2+2.642079786267853d-3*t42*t43*t50
     =         )-1.0359398963604977d-3*t33*t69+1.5539098445407465d-3*t42
     >         *t56*t60)+3.37738d-2*t34*t56*t78-3.37738d-2*t34*t76*t77+1
     ?         .0359398963604977d-3*t33*t69-1.5539098445407465d-3*t42*t5
     @         6*t60)-6.21814d-2*t27*t51*t75+6.21814d-2*t27*t73*t74-3.66
     1         3697685584584d-3*t26*t69+5.495546528376876d-3*t42*t51*t55
     2         )*t9*wght+2.0d+0*t61*t9*wght+1.0d+0*rhob*t35*(1.955555555
     3         5555554d+0*gammabb*t7*t8/rhob**4.666666666666667d+0-9.6d-
     4         1*t2*t5*t68*t7+1.1377777777777778d-1*t36*t37*t67*t7+1.351
     5         1111111111113d+0*t1*t2*t5*t68-6.115555555555556d-1*t1*t36
     6         *t37*t67+6.826666666666669d-2*gammabb**4*t1*t66/rhob**1.2
     7         666666666666665d+1)*wght+2.0d+0*rhob*t41*t61*wght+2.0d+0*
     8         t35*t41*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RB_GBB) = 1.0d+0*rhob*t35*(-5.333333333333333d-1
     1         *t40*t7*t8+3.2d-1*gammabb*t39*t5*t7-4.2666666666666675d-2
     2         *t2*t37*t38*t7-2.5600000000000006d-2*t1*t36*t66/rhob**1.1
     3         666666666666665d+1-4.2666666666666675d-1*gammabb*t1*t39*t
     4         5+2.1333333333333337d-1*t1*t2*t37*t38)*wght+1.0d+0*rhob*t
     5         61*t79*wght+1.0d+0*t35*t79*wght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GBB_GBB) = 1.0d+0*rhob*t35*(t5*t6*(8.00000000000
     1         0002d-2*t1-8.000000000000002d-2*t7)+9.600000000000004d-3*
     2         t1*t2*t66/rhob**1.0666666666666666d+1+t37*t62*(-4.0d-1*t6
     3         4-3.2000000000000006d-2*gammabb*t1))*wght+Cmat2(iq,D2_GBB
     4         _GBB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_b97 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\alpha^{0.3333333333333333}\\\\ 
C>   {\it t_2} &=& \sqrt{{\it t_1}}\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_5} &=& \log \left({{1.269642451250142\,{\it t_2}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.02414199311453321\,{\it t_3}+0.10186556948\right)\,{
C>    \it t_3}+0.22308199064\right)\,{\it t_3}+0.47231125998}}
C>    +1.0\right)\\\\ 
C>   {\it t_6} &=& 0.1325688999052018\,{\it t_4}+1.0\\\\ 
C>   {\it t_7} &=& \log \left({{1.269642451250142\,{\it t_2}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01321299881039884\,{\it t_3}+0.029729725188\right)
C>    \,{\it t_3}+0.12236585478\right)\,{\it t_3}+0.3497952466}}
C>    +1.0\right)\\\\ 
C>   {\it t_8} &=& 0.06901399211255826\,{\it t_4}+1.0\\\\ 
C>   {\it t_9} &=& 0.5848223622634643\,\left(0.0337738\,{\it t_7}
C>    \,{\it t_8}+1.0\,\left(1.709920934161365\,\left(0.0621814\,{
C>    \it t_5}\,{\it t_6}-0.0310907\,\log \left({{1.269642451250142
C>    \,{\it t_2}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01530901310039024\,{\it t_3}+0.10465751434\right)
C>    \,{\it t_3}+0.19269083139\right)\,{\it t_3}+0.43896648423}}
C>    +1.0\right)\,\left(0.1274696188700087\,{\it t_4}
C>    +1.0\right)\right)-0.0337738\,{\it t_7}\,{\it t_8}\right)\right)
C>    -0.0621814\,{\it t_5}\,{\it t_6}\\\\ 
C>   {\it t_{10}} &=& {\it param}\left(2\right)\\\\ 
C>   {\it t_{11}} &=& {\it param}\left(6\right)\\\\ 
C>   {\it t_{12}} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{13}} &=& 0.2\,{\it t_{12}}\,\sigma_{\alpha\alpha}+1.0\\\\ 
C>   {\it t_{14}} &=& {\it param}\left(4\right)\\\\ 
C>   {\it t_{15}} &=& \rho_\beta^{0.3333333333333333}\\\\ 
C>   {\it t_{16}} &=& \sqrt{{\it t_{15}}}\\\\ 
C>   {\it t_{17}} &=& {{1}\over{{\it t_{16}}}}\\\\ 
C>   {\it t_{18}} &=& {{1}\over{{\it t_{15}}}}\\\\ 
C>   {\it t_{19}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{16}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{17}}+0.10186556948\right)
C>    \,{\it t_{17}}+0.22308199064\right)\,{\it t_{17}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{20}} &=& 0.1325688999052018\,{\it t_{18}}+1.0\\\\ 
C>   {\it t_{21}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{16}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01321299881039884\,{\it t_{17}}
C>    +0.029729725188\right)\,{\it t_{17}}+0.12236585478\right)\,{
C>    \it t_{17}}+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{22}} &=& 0.06901399211255826\,{\it t_{18}}+1.0\\\\ 
C>   {\it t_{23}} &=& 0.5848223622634643\,\left(0.0337738\,{
C>    \it t_{21}}\,{\it t_{22}}+1.0\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{19}}\,{\it t_{20}}-0.0310907
C>    \,\log \left({{1.269642451250142\,{\it t_{16}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{17}}+0.10465751434\right)
C>    \,{\it t_{17}}+0.19269083139\right)\,{\it t_{17}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{18}}+1.0\right)\right)-0.0337738\,{\it t_{21}}\,{
C>    \it t_{22}}\right)\right)-0.0621814\,{\it t_{19}}\,{
C>    \it t_{20}}\\\\ 
C>   {\it t_{24}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{25}} &=& 0.2\,{\it t_{24}}\,\sigma_{\beta\beta}+1.0\\\\ 
C>   {\it t_{26}} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_{27}} &=& {\it t_{26}}^{0.3333333333333333}\\\\ 
C>   {\it t_{28}} &=& {{1}\over{{\it t_{27}}}}\\\\ 
C>   {\it t_{29}} &=& 0.1325688999052018\,{\it t_{28}}+1.0\\\\ 
C>   {\it t_{30}} &=& \sqrt{{\it t_{27}}}\\\\ 
C>   {\it t_{31}} &=& {{1}\over{{\it t_{30}}}}\\\\ 
C>   {\it t_{32}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{30}}}\over{0.7876233178997433\,{\it t_{31}}\,
C>    \left(0.7876233178997433\,{\it t_{31}}\,
C>    \left(0.02414199311453321\,{\it t_{31}}+0.10186556948\right)
C>    +0.22308199064\right)+0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{33}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{34}} &=& {{1}\over{{\it t_{26}}}}\\\\ 
C>   {\it t_{35}} &=& 0.06901399211255826\,{\it t_{28}}+1.0\\\\ 
C>   {\it t_{36}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{30}}}\over{0.7876233178997433\,{\it t_{31}}\,
C>    \left(0.7876233178997433\,{\it t_{31}}\,
C>    \left(0.01321299881039884\,{\it t_{31}}+0.029729725188\right)
C>    +0.12236585478\right)+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{37}} &=& {\it t_{24}}\,\sigma_{\beta\beta}+{\it t_{12}}
C>    \,\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{38}} &=& 0.003\,{\it t_{37}}+1.0\\\\ 
C>   {\it t_{39}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{40}} &=& \sqrt{{\it t_{39}}}\\\\ 
C>   {\it t_{41}} &=& {{1}\over{{\it t_{40}}}}\\\\ 
C>   {\it t_{42}} &=& {{1}\over{{\it t_{39}}}}\\\\ 
C>   {\it t_{43}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{40}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{41}}+0.10186556948\right)
C>    \,{\it t_{41}}+0.22308199064\right)\,{\it t_{41}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{44}} &=& 0.1325688999052018\,{\it t_{42}}+1.0\\\\ 
C>   {\it t_{45}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{40}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01321299881039884\,{\it t_{41}}
C>    +0.029729725188\right)\,{\it t_{41}}+0.12236585478\right)\,{
C>    \it t_{41}}+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{46}} &=& 0.06901399211255826\,{\it t_{42}}+1.0\\\\ 
C>   {\it t_{47}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{48}} &=& 0.2\,{\it t_{47}}\,\sigma_{ss}+1.0\\\\ 
C>   f &=& 1.0\,\left(\left(1.0\,{\it t_{26}}\,
C>    \left(0.5848223622634648\,\left(1.923661050931536\,\left({
C>    \it t_{33}}\,{\it t_{34}}+1.0\right)^{{{4}\over{3}}}
C>    +1.923661050931536\,\left(1.0-{\it t_{33}}\,{
C>    \it t_{34}}\right)^{{{4}\over{3}}}-3.847322101863072\right)
C>    \,\left({{{\it t_{33}}^4\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{29}}\,{\it t_{32}}-0.0310907\,
C>    \left(0.1274696188700087\,{\it t_{28}}+1.0\right)\,\log 
C>    \left({{1.269642451250142\,{\it t_{30}}}
C>    \over{0.7876233178997433\,{\it t_{31}}\,
C>    \left(0.7876233178997433\,{\it t_{31}}\,
C>    \left(0.01530901310039024\,{\it t_{31}}+0.10465751434\right)
C>    +0.19269083139\right)+0.43896648423}}+1.0\right)\right)
C>    -0.0337738\,{\it t_{35}}\,{\it t_{36}}\right)}\over{{
C>    \it t_{26}}^4}}+0.0337738\,{\it t_{35}}\,{\it t_{36}}\right)
C>    -0.0621814\,{\it t_{29}}\,{\it t_{32}}\right)-1.0\,{
C>    \it t_{23}}\,\rho_\beta-1.0\,{\it t_9}\,\rho_\alpha\right)
C>    \,\left({{0.003\,{\it param}\left(5\right)\,{
C>    \it t_{37}}}\over{{\it t_{38}}}}+{{9.0 \times 10^{-6}\,{
C>    \it param}\left(7\right)\,{\it t_{37}}^2}\over{{\it t_{38}}^2}}
C>    +{\it param}\left(3\right)\right)+1.0\,{\it t_{23}}
C>    \,\rho_\beta\,\left({{0.2\,{\it t_{14}}\,{\it t_{24}}
C>    \,\sigma_{\beta\beta}}\over{{\it t_{25}}}}
C>    +{{0.04000000000000001\,{\it t_{11}}\,
C>    \sigma_{\beta\beta}^2}\over{\rho_\beta^{{{16}\over{3}}}\,{
C>    \it t_{25}}^2}}+{\it t_{10}}\right)+1.0\,{\it t_9}
C>    \,\rho_\alpha\,\left({{0.2\,{\it t_{14}}\,{\it t_{12}}
C>    \,\sigma_{\alpha\alpha}}\over{{\it t_{13}}}}
C>    +{{0.04000000000000001\,{\it t_{11}}\,
C>    \sigma_{\alpha\alpha}^2}\over{\rho_\alpha^{{{16}\over{3}}}
C>    \,{\it t_{13}}^2}}+{\it t_{10}}\right)\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(0.5848223622634643\,\left(0.0337738\,{
C>    \it t_{45}}\,{\it t_{46}}+1.0\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{43}}\,{\it t_{44}}-0.0310907
C>    \,\log \left({{1.269642451250142\,{\it t_{40}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{41}}+0.10465751434\right)
C>    \,{\it t_{41}}+0.19269083139\right)\,{\it t_{41}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{42}}+1.0\right)\right)-0.0337738\,{\it t_{45}}\,{
C>    \it t_{46}}\right)\right)-0.0621814\,{\it t_{43}}\,{
C>    \it t_{44}}\right)\,\rho_s\,\left({{0.2\,{\it t_{14}}\,{
C>    \it t_{47}}\,\sigma_{ss}}\over{{\it t_{48}}}}
C>    +{{0.04000000000000001\,{\it t_{11}}\,\sigma_{ss}^2}
C>    \over{\rho_s^{{{16}\over{3}}}\,{\it t_{48}}^2}}+{
C>    \it t_{10}}\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] AD Becke, J.Chem.Phys. 107, 8554 (1997)  , DOI: 
C> <a href="https://doi.org/10.1063/1.475007 "> 
C> 10.1063/1.475007 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_b97_d3(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,fnc,Amat,Amat2,Amat3, 
     +Cmat,Cmat2,Cmat3) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision rgamma(nq,*) !< [Input] The norm of the density 
                                    !< gradients 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,*)   !< [Output] The derivative wrt rgamma 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,*)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,*)  !< [Output] The 2nd derivative wrt rgamma 
                                    !< and possibly rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat3(nq,*)  !< [Output] The 3rd derivative wrt rho 
      double precision Cmat3(nq,*)  !< [Output] The 3rd derivative wrt rgamma 
                                    !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          if (rhoa.gt.tol_rho) then 
            t1 = param(6)
            t2 = gammaaa**2
            t3 = 1/rhoa**2.6666666666666666d+0
            t4 = 2.0d-1*gammaaa*t3+1.0d+0
            t5 = 1/t4**2
            t6 = 1/rhoa**5.333333333333333d+0
            t7 = param(4)
            t8 = 1/t4
            t9 = 2.0d-1*gammaaa*t3*t7*t8+4.000000000000001d-2*t1*t2*t5*t
     1         6+param(2)
            t10 = rhoa**3.333333333333333d-1
            t11 = t10**5.0d-1
            t12 = 1/t11
            t13 = 1.530901310039024d-2*t12+1.0465751434d-1
            t14 = 7.876233178997433d-1*t12*t13+1.9269083139d-1
            t15 = 7.876233178997433d-1*t12*t14+4.3896648423d-1
            t16 = 1/t15
            t17 = 1.269642451250142d+0*t11*t16+1.0d+0
            t18 = log(t17)
            t19 = 1/t10
            t20 = 1.2746961887000874d-1*t19+1.0d+0
            t21 = 2.4141993114533214d-2*t12+1.0186556948d-1
            t22 = 7.876233178997433d-1*t12*t21+2.2308199064d-1
            t23 = 7.876233178997433d-1*t12*t22+4.7231125998d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t11*t24+1.0d+0
            t26 = log(t25)
            t27 = 1.325688999052018d-1*t19+1.0d+0
            t28 = 1.3212998810398843d-2*t12+2.9729725188d-2
            t29 = 7.876233178997433d-1*t12*t28+1.2236585478d-1
            t30 = 7.876233178997433d-1*t12*t29+3.497952466d-1
            t31 = 1/t30
            t32 = 1.269642451250142d+0*t11*t31+1.0d+0
            t33 = log(t32)
            t34 = 6.901399211255826d-2*t19+1.0d+0
            t35 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t26*t27-3.10907d-2*t18*t20)-3.37738d-2*t33*t34)+
     2         3.37738d-2*t33*t34)-6.21814d-2*t26*t27
            t36 = param(7)
            t37 = 6.0d-3*gammaaa*t3+1.0d+0
            t38 = 1/t37**2
            t39 = param(5)
            t40 = 1/t37
            t41 = 3.6d-5*t2*t36*t38*t6+6.0d-3*gammaaa*t3*t39*t40+param(3
     1         )
            t42 = -2.0d+0*rhoa*t35
            t43 = gammaaa**3
            t44 = 1/t4**3
            t45 = 1/rhoa**9
            t46 = 1/rhoa**6.333333333333333d+0
            t47 = 1/rhoa**3.6666666666666664d+0
            t48 = -5.333333333333333d-1*gammaaa*t47*t7*t8+1.066666666666
     1         6667d-1*t2*t46*t5*t7-2.1333333333333337d-1*t1*t2*t46*t5+4
     2         .2666666666666675d-2*t1*t43*t44*t45
            t49 = 1/rhoa**1.3333333333333333d+0
            t50 = 1/t17
            t51 = 1/t15**2
            t52 = 1/rhoa**1.3333333333333336d+0
            t53 = 1/t11**3
            t54 = 1/rhoa**6.666666666666667d-1
            t55 = -1.3127055298329054d-1*t13*t53*t54-2.0096226153166658d
     1         -3*t52
            t56 = 7.876233178997433d-1*t12*t55-1.3127055298329054d-1*t14
     1         *t53*t54
            t57 = 2.11607075208357d-1*t12*t16*t54-1.269642451250142d+0*t
     1         11*t51*t56
            t58 = 1/t25
            t59 = 1/t23**2
            t60 = -1.3127055298329054d-1*t21*t53*t54-3.169132786263567d-
     1         3*t52
            t61 = 7.876233178997433d-1*t12*t60-1.3127055298329054d-1*t22
     1         *t53*t54
            t62 = 2.11607075208357d-1*t12*t24*t54-1.269642451250142d+0*t
     1         11*t59*t61
            t63 = 1/t32
            t64 = 1/t30**2
            t65 = -1.3127055298329054d-1*t28*t53*t54-1.7344776604086162d
     1         -3*t52
            t66 = 7.876233178997433d-1*t12*t65-1.3127055298329054d-1*t29
     1         *t53*t54
            t67 = 2.11607075208357d-1*t12*t31*t54-1.269642451250142d+0*t
     1         11*t64*t66
            t68 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t34*t63*t67+
     1         1.709920934161365d+0*(6.21814d-2*t27*t58*t62-3.10907d-2*t
     2         20*t50*t57-2.747773264188438d-3*t26*t49+1.321039893133926
     3         5d-3*t18*t49)+7.769549222703733d-4*t33*t49)+3.37738d-2*t3
     4         4*t63*t67-7.769549222703733d-4*t33*t49)-6.21814d-2*t27*t5
     5         8*t62+2.747773264188438d-3*t26*t49
            t69 = 2.1508070719090538d-2*t12+1.0186556948d-1
            t70 = 7.016926042943222d-1*t12*t69+2.2308199064d-1
            t71 = 7.016926042943222d-1*t12*t70+4.7231125998d-1
            t72 = 1/t71
            t73 = 1.425125466450768d+0*t11*t72+1.0d+0
            t74 = log(t73)
            t75 = 1.0522000558389213d-1*t19+1.0d+0
            t76 = 1/t73
            t77 = 1/t71**2
            t78 = -5.847438369119352d-2*t53*t54*t69-1.2576711796854242d-
     1         3*t52
            t79 = 7.016926042943222d-1*t12*t78-5.847438369119352d-2*t53*
     1         t54*t70
            t80 = 1.1876045553756398d-1*t12*t54*t72-1.425125466450768d+0
     1         *t11*t77*t79
            t81 = 1.090454542535705d-3*t49*t74-6.21814d-2*t75*t76*t80
            t82 = 2.0d+0*rhoa*t81-6.21814d-2*t74*t75-1.0d+0*rhoa*t68-1.0
     1         d+0*t35
            t83 = 1/t37**3
            t84 = 5.760000000000001d-7*t36*t43*t45*t83-8.0d-3*gammaaa*t3
     1         9*t40*t47+4.8000000000000004d-5*t2*t38*t39*t46-9.60000000
     2         0000001d-5*t2*t36*t38*t46
            t85 = t42-1.243628d-1*rhoa*t74*t75
            t86 = 1/rhoa**8
            t87 = -1.6000000000000003d-2*t1*t2*t44*t86+2.0d-1*t3*t7*t8-4
     1         .000000000000001d-2*gammaaa*t5*t6*t7+8.000000000000002d-2
     2         *gammaaa*t1*t5*t6
            t88 = -2.16d-7*t2*t36*t83*t86-1.8d-5*gammaaa*t38*t39*t6+3.6d
     1         -5*gammaaa*t36*t38*t6+3.0d-3*t3*t39*t40
            t89 = gammaaa**4
            t90 = 1/t4**4
            t91 = 1/rhoa**1.2666666666666665d+1
            t92 = 1/rhoa**10
            t93 = 1/rhoa**7.333333333333333d+0
            t94 = 1/rhoa**4.666666666666667d+0
            t95 = 1.9555555555555554d+0*gammaaa*t7*t8*t94-9.6d-1*t2*t5*t
     1         7*t93+1.3511111111111113d+0*t1*t2*t5*t93+1.13777777777777
     2         78d-1*t43*t44*t7*t92-6.115555555555556d-1*t1*t43*t44*t92+
     3         6.826666666666669d-2*t1*t89*t90*t91
            t96 = 1/rhoa**2.333333333333333d+0
            t97 = 1/t17**2
            t98 = t57**2
            t99 = 1/t15**3
            t100 = t56**2
            t101 = 1/rhoa**2.3333333333333334d+0
            t102 = 1/rhoa**1.6666666666666669d+0
            t103 = 1/t11**5
            t104 = 8.751370198886037d-2*t102*t13*t53+6.563527649164527d-
     1         2*t103*t13*t52+3.0144339229749983d-3*t101
            t105 = -2.625411059665811d-1*t53*t54*t55+8.751370198886037d-
     1         2*t102*t14*t53+6.563527649164527d-2*t103*t14*t52+7.876233
     2         178997433d-1*t104*t12
            t106 = 2.539284902500284d+0*t100*t11*t99-4.23214150416714d-1
     1         *t12*t51*t54*t56-3.52678458680595d-2*t16*t52*t53-1.269642
     2         451250142d+0*t105*t11*t51-1.4107138347223802d-1*t102*t12*
     3         t16
            t107 = 1/t25**2
            t108 = t62**2
            t109 = 1/t23**3
            t110 = t61**2
            t111 = 8.751370198886037d-2*t102*t21*t53+6.563527649164527d-
     1         2*t103*t21*t52+4.753699179395351d-3*t101
            t112 = -2.625411059665811d-1*t53*t54*t60+8.751370198886037d-
     1         2*t102*t22*t53+6.563527649164527d-2*t103*t22*t52+7.876233
     2         178997433d-1*t111*t12
            t113 = -4.23214150416714d-1*t12*t54*t59*t61-1.26964245125014
     1         2d+0*t11*t112*t59-3.52678458680595d-2*t24*t52*t53-1.41071
     2         38347223802d-1*t102*t12*t24+2.539284902500284d+0*t109*t11
     3         *t110
            t114 = 1/t32**2
            t115 = t67**2
            t116 = 1/t30**3
            t117 = t66**2
            t118 = 8.751370198886037d-2*t102*t28*t53+6.563527649164527d-
     1         2*t103*t28*t52+2.601716490612924d-3*t101
            t119 = -2.625411059665811d-1*t53*t54*t65+8.751370198886037d-
     1         2*t102*t29*t53+6.563527649164527d-2*t103*t29*t52+7.876233
     2         178997433d-1*t118*t12
            t120 = -4.23214150416714d-1*t12*t54*t64*t66-1.26964245125014
     1         2d+0*t11*t119*t64-3.52678458680595d-2*t31*t52*t53-1.41071
     2         38347223802d-1*t102*t12*t31+2.539284902500284d+0*t11*t116
     3         *t117
            t121 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(3
     1         .10907d-2*t20*t97*t98+3.663697685584584d-3*t26*t96-1.7613
     2         865241785687d-3*t18*t96-5.495546528376876d-3*t49*t58*t62+
     3         6.21814d-2*t113*t27*t58+2.642079786267853d-3*t49*t50*t57-
     4         3.10907d-2*t106*t20*t50-6.21814d-2*t107*t108*t27)-1.03593
     5         98963604977d-3*t33*t96+1.5539098445407465d-3*t49*t63*t67-
     6         3.37738d-2*t120*t34*t63+3.37738d-2*t114*t115*t34)+1.03593
     7         98963604977d-3*t33*t96-1.5539098445407465d-3*t49*t63*t67+
     8         3.37738d-2*t120*t34*t63-3.37738d-2*t114*t115*t34)-3.66369
     9         7685584584d-3*t26*t96+5.495546528376876d-3*t49*t58*t62-6.
     :         21814d-2*t113*t27*t58+6.21814d-2*t107*t108*t27
            t122 = 2*t82*t84
            t123 = 2.0d+0*t81
            t124 = -7.269696950238034d-4*t74*t96
            t125 = 1.1771443702974158d-2*t12+2.9729725188d-2
            t126 = 7.016926042943222d-1*t12*t125+1.2236585478d-1
            t127 = 7.016926042943222d-1*t12*t126+3.497952466d-1
            t128 = 1/t127
            t129 = 1.425125466450768d+0*t11*t128+1.0d+0
            t130 = log(t129)
            t131 = 5.477644184000001d-2*t19+1.0d+0
            t132 = 1/rhoa**2
            t133 = 2.18090908507141d-3*t49*t76*t80
            t134 = 1/t73**2
            t135 = t80**2
            t136 = 6.21814d-2*t134*t135*t75
            t137 = 1/t71**3
            t138 = t79**2
            t139 = 1.949146123039784d-2*t102*t53*t69+1.4618595922798375d
     1         -2*t103*t52*t69+9.432533847640683d-4*t101
            t140 = -1.1694876738238703d-1*t53*t54*t78+1.949146123039784d
     1         -2*t102*t53*t70+1.4618595922798375d-2*t103*t52*t70+7.0169
     2         26042943222d-1*t12*t139
            t141 = -2.3752091107512796d-1*t12*t54*t77*t79-1.425125466450
     1         768d+0*t11*t140*t77-9.896704628130328d-3*t52*t53*t72-3.95
     2         86818512521327d-2*t102*t12*t72+2.850250932901536d+0*t11*t
     3         137*t138
            t142 = -6.21814d-2*t141*t75*t76
            t143 = t142+t136+t133+8.443450000000001d-3*t130*t131*t132+t1
     1         24
            t144 = -2.0d+0*t68+2.0d+0*rhoa*t143+t123-1.0d+0*rhoa*t121
            t145 = 1/t37**4
            t146 = 1.3824000000000003d-8*t145*t36*t89*t91
            t147 = 7.68d-7*t39*t43*t83*t92
            t148 = 2.9333333333333333d-2*gammaaa*t39*t40*t94-3.04d-4*t2*
     1         t38*t39*t93+4.8d-4*t2*t36*t38*t93-5.184000000000001d-6*t3
     2         6*t43*t83*t92+t147+t146
            t149 = t142+t136+t133-8.44345d-3*t130*t131*t132+t124
            t150 = 2.0d+0*rhoa*t149+t123
            t151 = -1.28d-4*t2*t38*t39*t93+1.28d-4*t2*t36*t38*t93-3.0720
     1         000000000003d-6*t36*t43*t83*t92+t147+t146
            t152 = 1/rhoa**1.1666666666666665d+1
            t153 = -2.5600000000000006d-2*t1*t152*t43*t90-5.333333333333
     1         333d-1*t47*t7*t8+3.2d-1*gammaaa*t46*t5*t7-4.2666666666666
     2         675d-2*t2*t44*t45*t7-4.2666666666666675d-1*gammaaa*t1*t46
     3         *t5+2.1333333333333337d-1*t1*t2*t44*t45
            t154 = t82*t88
            t155 = -5.184000000000001d-9*t145*t152*t36*t43
            t156 = -2.8800000000000003d-7*t2*t39*t45*t83
            t157 = 1.728d-6*t2*t36*t45*t83-8.0d-3*t39*t40*t47+9.60000000
     1         0000001d-5*gammaaa*t38*t39*t46-1.4400000000000002d-4*gamm
     2         aaa*t36*t38*t46+t156+t155
            t158 = 1.1520000000000001d-6*t2*t36*t45*t83+4.80000000000000
     1         04d-5*gammaaa*t38*t39*t46-4.8000000000000004d-5*gammaaa*t
     2         36*t38*t46+t156+t155
            t159 = 1/rhoa**1.0666666666666666d+1
            t160 = 9.600000000000004d-3*t1*t159*t2*t90+1.600000000000000
     1         3d-2*gammaaa*t44*t7*t86-6.400000000000001d-2*gammaaa*t1*t
     2         44*t86-8.000000000000002d-2*t5*t6*t7+8.000000000000002d-2
     3         *t1*t5*t6
            t161 = 1.9440000000000004d-9*t145*t159*t2*t36
            t162 = 1.08d-7*gammaaa*t39*t83*t86-4.32d-7*gammaaa*t36*t83*t
     1         86-1.8d-5*t38*t39*t6+1.8d-5*t36*t38*t6+t161
            t163 = gammaaa**5
            t164 = 1/t4**5
            t165 = 1/rhoa**1.6333333333333333d+1
            t166 = 1/rhoa**1.3666666666666666d+1
            t167 = 1/rhoa**11
            t168 = 1/rhoa**8.333333333333334d+0
            t169 = 1/rhoa**5.666666666666667d+0
            t170 = 1/rhoa**3.333333333333333d+0
            t171 = 1/rhoa**3.3333333333333337d+0
            t172 = 1/rhoa**2.666666666666667d+0
            t173 = 1/t11**7
            t174 = 1/rhoa**2.0d+0
            t175 = 1/t25**3
            t176 = t62**3
            t177 = -7.617854707500852d+0*t11*t61**3/t23**4+1.05803537604
     1         17849d-1*t52*t53*t59*t61+4.2321415041671406d-1*t102*t12*t
     2         59*t61+7.617854707500852d+0*t109*t11*t112*t61-1.269642451
     3         250142d+0*t11*t59*(2.625411059665811d-1*t102*t53*t60+1.96
     4         90582947493582d-1*t103*t52*t60-3.9381165894987163d-1*t111
     5         *t53*t54+7.876233178997433d-1*t12*(-1.4585616998143394d-1
     6         *t172*t21*t53-5.469606374303773d-2*t173*t174*t21-1.312705
     7         5298329054d-1*t101*t103*t21-1.1708185015918181d-2*t171)-1
     8         .4585616998143394d-1*t172*t22*t53-5.469606374303773d-2*t1
     9         73*t174*t22-1.3127055298329054d-1*t101*t103*t22)-6.348212
     :         25625071d-1*t112*t12*t54*t59+1.269642451250142d+0*t109*t1
     ;         10*t12*t54+7.053569173611901d-2*t101*t24*t53+1.7633922934
     <         02975d-2*t103*t174*t24+2.3511897245373004d-1*t12*t172*t24
            t178 = 1/t32**3
            t179 = t67**3
            t180 = -7.617854707500852d+0*t11*t66**3/t30**4+1.05803537604
     1         17849d-1*t52*t53*t64*t66+4.2321415041671406d-1*t102*t12*t
     2         64*t66+7.617854707500852d+0*t11*t116*t119*t66-1.269642451
     3         250142d+0*t11*t64*(2.625411059665811d-1*t102*t53*t65+1.96
     4         90582947493582d-1*t103*t52*t65-3.9381165894987163d-1*t118
     5         *t53*t54+7.876233178997433d-1*t12*(-1.4585616998143394d-1
     6         *t172*t28*t53-5.469606374303773d-2*t173*t174*t28-1.312705
     7         5298329054d-1*t101*t103*t28-6.407931356509611d-3*t171)-1.
     8         4585616998143394d-1*t172*t29*t53-5.469606374303773d-2*t17
     9         3*t174*t29-1.3127055298329054d-1*t101*t103*t29)-6.3482122
     :         5625071d-1*t119*t12*t54*t64+1.269642451250142d+0*t116*t11
     ;         7*t12*t54+7.053569173611901d-2*t101*t31*t53+1.76339229340
     <         2975d-2*t103*t174*t31+2.3511897245373004d-1*t12*t172*t31
            t181 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-
     1         3.10907d-2*t20*t50*(7.617854707500852d+0*t105*t11*t56*t99
     2         +1.269642451250142d+0*t100*t12*t54*t99-7.617854707500852d
     3         +0*t11*t56**3/t15**4+1.0580353760417849d-1*t51*t52*t53*t5
     4         6+4.2321415041671406d-1*t102*t12*t51*t56-1.26964245125014
     5         2d+0*t11*t51*(2.625411059665811d-1*t102*t53*t55+1.9690582
     6         947493582d-1*t103*t52*t55-3.9381165894987163d-1*t104*t53*
     7         t54+7.876233178997433d-1*t12*(-1.4585616998143394d-1*t13*
     8         t172*t53-5.469606374303773d-2*t13*t173*t174-7.42443910658
     9         6571d-3*t171-1.3127055298329054d-1*t101*t103*t13)-1.45856
     :         16998143394d-1*t14*t172*t53-5.469606374303773d-2*t14*t173
     ;         *t174-1.3127055298329054d-1*t101*t103*t14)-6.348212256250
     <         71d-1*t105*t12*t51*t54+7.053569173611901d-2*t101*t16*t53+
     =         1.763392293402975d-2*t103*t16*t174+2.3511897245373004d-1*
     >         t12*t16*t172)-3.96311967940178d-3*t49*t97*t98+9.327209999
     ?         999999d-2*t106*t20*t57*t97+1.0991093056753751d-2*t58*t62*
     @         t96-5.284159572535706d-3*t50*t57*t96-1.865442d-1*t107*t11
     1         3*t27*t62-8.243319792565315d-3*t113*t49*t58+6.21814d-2*t1
     2         77*t27*t58-6.21814d-2*t20*t57**3/t17**3+3.96311967940178d
     3         -3*t106*t49*t50+8.243319792565315d-3*t107*t108*t49+1.2436
     4         28d-1*t175*t176*t27-8.548627933030694d-3*t170*t26+4.10990
     5         18897499934d-3*t170*t18)-3.107819689081493d-3*t63*t67*t96
     6         +1.013214d-1*t114*t120*t34*t67+2.33086476681112d-3*t120*t
     7         49*t63-3.37738d-2*t180*t34*t63-2.33086476681112d-3*t114*t
     8         115*t49-6.75476d-2*t178*t179*t34+2.4171930915078277d-3*t1
     9         70*t33)+3.107819689081493d-3*t63*t67*t96-1.013214d-1*t114
     :         *t120*t34*t67-2.33086476681112d-3*t120*t49*t63+3.37738d-2
     ;         *t180*t34*t63+2.33086476681112d-3*t114*t115*t49+6.75476d-
     <         2*t178*t179*t34-2.4171930915078277d-3*t170*t33)-1.0991093
     =         056753751d-2*t58*t62*t96+1.865442d-1*t107*t113*t27*t62+8.
     >         243319792565315d-3*t113*t49*t58-6.21814d-2*t177*t27*t58-8
     ?         .243319792565315d-3*t107*t108*t49-1.243628d-1*t175*t176*t
     @         27+8.548627933030694d-3*t170*t26
            t182 = 8.48131310861104d-4*t170*t74
            t183 = 1/rhoa**3
            t184 = -2.1809090850714105d-3*t76*t80*t96
            t185 = 3.37738d-2*t131*(1.1876045553756398d-1*t12*t128*t54-1
     1         .425125466450768d+0*t11*(7.016926042943222d-1*t12*(-5.847
     2         438369119352d-2*t125*t53*t54-6.883279156869946d-4*t52)-5.
     3         847438369119352d-2*t126*t53*t54)/t127**2)/t129-3.08334765
     4         2359653d-4*t130*t49
            t186 = -3.2713636276071156d-3*t134*t135*t49
            t187 = 3.2713636276071156d-3*t141*t49*t76
            t188 = -1.243628d-1*t75*t80**3/t73**3
            t189 = 1.865442d-1*t134*t141*t75*t80
            t190 = -6.21814d-2*t75*t76*(-8.550752798704606d+0*t11*t79**3
     1         /t71**4+2.969011388439098d-2*t52*t53*t77*t79+1.1876045553
     2         756398d-1*t102*t12*t77*t79+8.550752798704606d+0*t11*t137*
     3         t140*t79-1.425125466450768d+0*t11*t77*(5.847438369119352d
     4         -2*t102*t53*t78+4.385578776839513d-2*t103*t52*t78-1.62428
     5         84358664864d-2*t172*t53*t70-6.091081634499322d-3*t173*t17
     6         4*t70-1.4618595922798375d-2*t101*t103*t70+7.0169260429432
     7         22d-1*t12*(-1.6242884358664864d-2*t172*t53*t69-6.09108163
     8         4499322d-3*t173*t174*t69-1.4618595922798375d-2*t101*t103*
     9         t69-1.161599075681677d-3*t171)-1.7542315107358056d-1*t139
     :         *t53*t54)-3.5628136661269194d-1*t12*t140*t54*t77+9.896704
     ;         62813033d-3*t101*t53*t72+2.474176157032582d-3*t103*t174*t
     <         72+3.29890154271011d-2*t12*t172*t72+7.125627332253839d-1*
     =         t12*t137*t138*t54)
            t191 = 1/t37**5
            t192 = 4.423680000000001d-10*t163*t165*t191*t36
            t193 = 1.8431999999999998d-8*t145*t166*t39*t89
            t194 = 1/rhoa**1.5333333333333335d+1
            t195 = t144*t88
            t196 = -1.65888d-10*t191*t194*t36*t89
            t197 = -6.912000000000001d-9*t145*t39*t43*t91
            t198 = 1/rhoa**1.4333333333333334d+1
            t199 = t162*t82
            t200 = 6.220800000000002d-11*t191*t198*t36*t43
            t201 = 2.5920000000000004d-9*t145*t152*t2*t39
            t202 = 1/rhoa**1.3333333333333333d+1
            t203 = -2.3328000000000004d-11*t191*t2*t202*t36
            fnc(iq) = 1.0d+0*(2.0d+0*rhoa*t35*t9+t41*(t42-1.243628d-1*rh
     1         oa*log(1.4251254664507676d+0*t11/(7.016926042943223d-1*t1
     2         2*(7.016926042943223d-1*(2.150807071909054d-2*t12+1.01865
     3         56948d-1)*t12+2.2308199064d-1)+4.7231125998d-1)+1.0d+0)*(
     4         1.0522000558389215d-1*t19+1.0d+0)))*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(1.0d+0*rhoa*t68*t9+1.0d+0*t35*t9+t8
     1         4*t85+t41*t82+1.0d+0*rhoa*t35*t48)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.0d+0*(t85*t88+1.0d+0*rhoa*t35*t87)*wght+
     1         Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Amat2(iq,D2_RA_RA) = 1.0d+0*(1.0d+0*rhoa*t35*t95+2.0d+0*t68*
     1         t9+1.0d+0*rhoa*t121*t9+t148*t85+2.0d+0*rhoa*t48*t68+2.0d+
     2         0*t35*t48+t144*t41+t122)*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = 1.0d+0*(t151*t85+t150*t41+t122)*wght+Am
     1         at2(iq,D2_RA_RB)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*(1.0d+0*rhoa*t68*t87+1.0d+0*t35
     1         *t87+t157*t85+1.0d+0*rhoa*t153*t35+t154)*wght+Cmat2(iq,D2
     2         _RA_GAA)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = 1.0d+0*(t158*t85+t154)*wght+Cmat2(iq,D
     1         2_RA_GBB)
            Cmat2(iq,D2_GAA_GAA) = 1.0d+0*(t162*t85+1.0d+0*rhoa*t160*t35
     1         )*wght+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = 1.0d+0*((1.08d-7*gammaaa*t3*t39-4.32d
     1         -7*gammaaa*t3*t36)*t6*t83+t38*(1.8d-5*t36-1.8d-5*t39)*t6+
     2         t161)*t85*wght+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
            Amat3(iq,D3_RA_RA_RA) = 1.0d+0*(3.0d+0*rhoa*t68*t95+3.0d+0*t
     1         35*t95+1.0d+0*rhoa*t35*(1.8204444444444445d-1*t166*t7*t89
     2         *t90-1.8432000000000004d+0*t1*t166*t89*t90-9.125925925925
     3         926d+0*gammaaa*t169*t7*t8+8.082962962962963d+0*t168*t2*t5
     4         *t7-2.161777777777778d+0*t167*t43*t44*t7-9.90814814814815
     5         d+0*t1*t168*t2*t5+7.556740740740742d+0*t1*t167*t43*t44+1.
     6         456355555555556d-1*t1*t163*t164*t165)+1.0d+0*rhoa*t181*t9
     7         +3.0d+0*t121*t9+t85*(-2.62656d-7*t145*t166*t36*t89-1.152d
     8         -5*t167*t39*t43*t83+4.979200000000001d-5*t167*t36*t43*t83
     9         -1.368888888888889d-1*gammaaa*t169*t39*t40+2.229333333333
     :         3332d-3*t168*t2*t38*t39-3.050666666666667d-3*t168*t2*t36*
     ;         t38+t193+t192)+3*t144*t84+3*t148*t82+6.0d+0*t48*t68+3.0d+
     <         0*rhoa*t121*t48+(2.0d+0*rhoa*(t190+t189+t188+t187+t186+7.
     =         500000000000002d-1*t132*t185+t184-2.533035d-2*t130*t131*t
     >         183+t182)-1.0d+0*rhoa*t181+3.0d+0*t143-3.0d+0*t121)*t41)*
     ?         wght+Amat3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = 1.0d+0*(t85*(-1.6128000000000003d-7*
     1         t145*t166*t36*t89-5.888d-6*t167*t39*t43*t83+1.7408d-5*t16
     2         7*t36*t43*t83+4.693333333333333d-4*t168*t2*t38*t39-4.6933
     3         33333333333d-4*t168*t2*t36*t38+t193+t192)+2*t150*t84+t144
     4         *t84+2*t151*t82+t148*t82+(2.0d+0*rhoa*(t190+t189+t188+t18
     5         7+t186-2.4999999999999994d-1*t132*t185+t184+8.44345d-3*t1
     6         30*t131*t183+t182)+2.0d+0*t149+1.0d+0*t143)*t41)*wght+Ama
     7         t3(iq,D3_RA_RA_RB)
            Cmat3(iq,D3_RA_RA_GAA) = 1.0d+0*(1.0d+0*rhoa*t35*(1.95555555
     1         55555554d+0*t7*t8*t94-2.311111111111111d+0*gammaaa*t5*t7*
     2         t93+2.7022222222222225d+0*gammaaa*t1*t5*t93+7.25333333333
     3         3334d-1*t2*t44*t7*t92-2.3751111111111115d+0*t1*t2*t44*t92
     4         -6.826666666666669d-2*t43*t7*t90*t91+6.400000000000001d-1
     5         *t1*t43*t90*t91-5.461333333333335d-2*t1*t164*t194*t89)+t8
     6         5*(2.9333333333333333d-2*t39*t40*t94-6.08d-4*gammaaa*t38*
     7         t39*t93+7.84d-4*gammaaa*t36*t38*t93+3.744d-6*t2*t39*t83*t
     8         92-1.4784d-5*t2*t36*t83*t92+8.812800000000001d-8*t145*t36
     9         *t43*t91+t197+t196)+2.0d+0*t68*t87+1.0d+0*rhoa*t121*t87+2
     :         *t157*t82+2.0d+0*rhoa*t153*t68+2.0d+0*t153*t35+t195)*wght
     ;         +Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
            Cmat3(iq,D3_RA_RA_GBB) = 1.0d+0*(t85*(-1.76d-4*gammaaa*t38*t
     1         39*t93+1.76d-4*gammaaa*t36*t38*t93+2.208d-6*t2*t39*t83*t9
     2         2-6.528d-6*t2*t36*t83*t92+6.048000000000001d-8*t145*t36*t
     3         43*t91+t197+t196)+2*t158*t82+t195)*wght+Cmat3(iq,D3_RA_RA
     4         _GBB)
            Cmat3(iq,D3_RA_RB_GAA) = 1.0d+0*(t85*(-1.28d-4*gammaaa*t38*t
     1         39*t93+1.28d-4*gammaaa*t36*t38*t93+1.9199999999999998d-6*
     2         t2*t39*t83*t92-5.376000000000001d-6*t2*t36*t83*t92+5.5296
     3         00000000001d-8*t145*t36*t43*t91+t197+t196)+t150*t88+t158*
     4         t82+t157*t82)*wght+Cmat3(iq,D3_RA_RB_GAA)
            Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
            Cmat3(iq,D3_RA_GAA_GAA) = 1.0d+0*(1.0d+0*rhoa*t35*(2.5600000
     1         000000006d-2*t152*t2*t7*t90-2.0480000000000004d-1*t1*t152
     2         *t2*t90+4.266666666666667d-1*t46*t5*t7-2.1333333333333335
     3         d-1*gammaaa*t44*t45*t7-4.2666666666666675d-1*t1*t46*t5+5.
     4         973333333333335d-1*gammaaa*t1*t44*t45+2.048000000000001d-
     5         2*t1*t164*t198*t43)+(-1.0080000000000001d-6*gammaaa*t39*t
     6         45*t83+3.168d-6*gammaaa*t36*t45*t83+9.600000000000001d-5*
     7         t38*t39*t46-9.600000000000001d-5*t36*t38*t46-2.5920000000
     8         000004d-8*t145*t152*t2*t36+t201+t200)*t85+1.0d+0*rhoa*t16
     9         0*t68+1.0d+0*t160*t35+t199)*wght+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
            Cmat3(iq,D3_RA_GAA_GBB) = 1.0d+0*((-7.200000000000001d-7*gam
     1         maaa*t39*t45*t83+2.0160000000000003d-6*gammaaa*t36*t45*t8
     2         3+4.8000000000000004d-5*t38*t39*t46-4.8000000000000004d-5
     3         *t36*t38*t46-2.0736000000000004d-8*t145*t152*t2*t36+t201+
     4         t200)*t85+t199)*wght+Cmat3(iq,D3_RA_GAA_GBB)
            Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
            Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
            Cmat3(iq,D3_RA_GBB_GBB) = 1.0d+0*((-4.3200000000000005d-7*ga
     1         mmaaa*t39*t45*t83+8.640000000000001d-7*gammaaa*t36*t45*t8
     2         3-1.5552000000000002d-8*t145*t152*t2*t36+t201+t200)*t85+t
     3         199)*wght+Cmat3(iq,D3_RA_GBB_GBB)
            Cmat3(iq,D3_GAA_GAA_GAA) = 1.0d+0*(1.0d+0*rhoa*t35*(-9.60000
     1         0000000004d-3*gammaaa*t159*t7*t90+5.760000000000003d-2*ga
     2         mmaaa*t1*t159*t90+4.8000000000000015d-2*t44*t7*t86-9.6000
     3         00000000003d-2*t1*t44*t86-7.680000000000003d-3*t1*t164*t2
     4         *t202)+t85*(1.62d-7*t39*t83*t86-3.24d-7*t36*t83*t86-9.720
     5         000000000002d-10*gammaaa*t145*t159*t39+5.832d-9*gammaaa*t
     6         145*t159*t36+t203))*wght+Cmat3(iq,D3_GAA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
            Cmat3(iq,D3_GAA_GAA_GBB) = 1.0d+0*t85*((1.62d-7*t39-3.24d-7*
     1         t36)*t83*t86+t145*(5.832d-9*gammaaa*t3*t36-9.720000000000
     2         002d-10*gammaaa*t3*t39)*t86+t203)*wght+Cmat3(iq,D3_GAA_GA
     3         A_GBB)
            Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
            Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
            Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = param(2)
            t2 = param(6)
            t3 = gammaaa**2
            t4 = 1/rhoa**2.6666666666666666d+0
            t5 = 2.0d-1*gammaaa*t4+1.0d+0
            t6 = 1/t5**2
            t7 = 1/rhoa**5.333333333333333d+0
            t8 = param(4)
            t9 = 1/t5
            t10 = 2.0d-1*gammaaa*t4*t8*t9+4.000000000000001d-2*t2*t3*t6*
     1         t7+t1
            t11 = rhoa**3.333333333333333d-1
            t12 = t11**5.0d-1
            t13 = 1/t12
            t14 = 1.530901310039024d-2*t13+1.0465751434d-1
            t15 = 7.876233178997433d-1*t13*t14+1.9269083139d-1
            t16 = 7.876233178997433d-1*t13*t15+4.3896648423d-1
            t17 = 1/t16
            t18 = 1.269642451250142d+0*t12*t17+1.0d+0
            t19 = log(t18)
            t20 = 1/t11
            t21 = 1.2746961887000874d-1*t20+1.0d+0
            t22 = 2.4141993114533214d-2*t13+1.0186556948d-1
            t23 = 7.876233178997433d-1*t13*t22+2.2308199064d-1
            t24 = 7.876233178997433d-1*t13*t23+4.7231125998d-1
            t25 = 1/t24
            t26 = 1.269642451250142d+0*t12*t25+1.0d+0
            t27 = log(t26)
            t28 = 1.325688999052018d-1*t20+1.0d+0
            t29 = 1.3212998810398843d-2*t13+2.9729725188d-2
            t30 = 7.876233178997433d-1*t13*t29+1.2236585478d-1
            t31 = 7.876233178997433d-1*t13*t30+3.497952466d-1
            t32 = 1/t31
            t33 = 1.269642451250142d+0*t12*t32+1.0d+0
            t34 = log(t33)
            t35 = 6.901399211255826d-2*t20+1.0d+0
            t36 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t27*t28-3.10907d-2*t19*t21)-3.37738d-2*t34*t35)+
     2         3.37738d-2*t34*t35)-6.21814d-2*t27*t28
            t37 = gammabb**2
            t38 = 1/rhob**2.6666666666666666d+0
            t39 = 2.0d-1*gammabb*t38+1.0d+0
            t40 = 1/t39**2
            t41 = 1/rhob**5.333333333333333d+0
            t42 = 1/t39
            t43 = 2.0d-1*gammabb*t38*t42*t8+4.000000000000001d-2*t2*t37*
     1         t40*t41+t1
            t44 = rhob**3.333333333333333d-1
            t45 = t44**5.0d-1
            t46 = 1/t45
            t47 = 1.530901310039024d-2*t46+1.0465751434d-1
            t48 = 7.876233178997433d-1*t46*t47+1.9269083139d-1
            t49 = 7.876233178997433d-1*t46*t48+4.3896648423d-1
            t50 = 1/t49
            t51 = 1.269642451250142d+0*t45*t50+1.0d+0
            t52 = log(t51)
            t53 = 1/t44
            t54 = 1.2746961887000874d-1*t53+1.0d+0
            t55 = 2.4141993114533214d-2*t46+1.0186556948d-1
            t56 = 7.876233178997433d-1*t46*t55+2.2308199064d-1
            t57 = 7.876233178997433d-1*t46*t56+4.7231125998d-1
            t58 = 1/t57
            t59 = 1.269642451250142d+0*t45*t58+1.0d+0
            t60 = log(t59)
            t61 = 1.325688999052018d-1*t53+1.0d+0
            t62 = 1.3212998810398843d-2*t46+2.9729725188d-2
            t63 = 7.876233178997433d-1*t46*t62+1.2236585478d-1
            t64 = 7.876233178997433d-1*t46*t63+3.497952466d-1
            t65 = 1/t64
            t66 = 1.269642451250142d+0*t45*t65+1.0d+0
            t67 = log(t66)
            t68 = 6.901399211255826d-2*t53+1.0d+0
            t69 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t60*t61-3.10907d-2*t52*t54)-3.37738d-2*t67*t68)+
     2         3.37738d-2*t67*t68)-6.21814d-2*t60*t61
            t70 = param(7)
            t71 = gammaaa*t4+gammabb*t38
            t72 = t71**2
            t73 = 3.0d-3*t71+1.0d+0
            t74 = 1/t73**2
            t75 = param(5)
            t76 = 1/t73
            t77 = 3.0d-3*t71*t75*t76+9.0d-6*t70*t72*t74+param(3)
            t78 = rhob+rhoa
            t79 = t78**3.333333333333333d-1
            t80 = 1/t79
            t81 = 1.325688999052018d-1*t80+1.0d+0
            t82 = t79**5.0d-1
            t83 = 1/t82
            t84 = 2.4141993114533214d-2*t83+1.0186556948d-1
            t85 = 7.876233178997433d-1*t83*t84+2.2308199064d-1
            t86 = 7.876233178997433d-1*t83*t85+4.7231125998d-1
            t87 = 1/t86
            t88 = 1.269642451250142d+0*t82*t87+1.0d+0
            t89 = log(t88)
            t90 = rhoa-rhob
            t91 = 1/t78
            t92 = 1.0d+0-t90*t91
            t93 = t90*t91+1.0d+0
            t94 = 1.923661050931536d+0*t93**1.3333333333333333d+0+1.9236
     1         61050931536d+0*t92**1.3333333333333333d+0-3.8473221018630
     2         72d+0
            t95 = 6.901399211255826d-2*t80+1.0d+0
            t96 = 1.3212998810398843d-2*t83+2.9729725188d-2
            t97 = 7.876233178997433d-1*t83*t96+1.2236585478d-1
            t98 = 7.876233178997433d-1*t83*t97+3.497952466d-1
            t99 = 1/t98
            t100 = 1.269642451250142d+0*t82*t99+1.0d+0
            t101 = log(t100)
            t102 = t90**4
            t103 = 1/t78**4
            t104 = 1.2746961887000874d-1*t80+1.0d+0
            t105 = 1.530901310039024d-2*t83+1.0465751434d-1
            t106 = 7.876233178997433d-1*t105*t83+1.9269083139d-1
            t107 = 7.876233178997433d-1*t106*t83+4.3896648423d-1
            t108 = 1/t107
            t109 = 1.269642451250142d+0*t108*t82+1.0d+0
            t110 = log(t109)
            t111 = 1.709920934161365d+0*(6.21814d-2*t81*t89-3.10907d-2*t
     1         104*t110)-3.37738d-2*t101*t95
            t112 = 3.37738d-2*t101*t95+t102*t103*t111
            t113 = 5.848223622634648d-1*t112*t94-6.21814d-2*t81*t89
            t114 = 1.0d+0*t113*t78-1.0d+0*rhob*t69-1.0d+0*rhoa*t36
            t115 = gammaaa**3
            t116 = 1/t5**3
            t117 = 1/rhoa**9
            t118 = 1/rhoa**6.333333333333333d+0
            t119 = 1/rhoa**3.6666666666666664d+0
            t120 = -5.333333333333333d-1*gammaaa*t119*t8*t9+1.0666666666
     1         666667d-1*t118*t3*t6*t8-2.1333333333333337d-1*t118*t2*t3*
     2         t6+4.2666666666666675d-2*t115*t116*t117*t2
            t121 = 1/rhoa**1.3333333333333333d+0
            t122 = 1/t18
            t123 = 1/t16**2
            t124 = 1/rhoa**1.3333333333333336d+0
            t125 = 1/t12**3
            t126 = 1/rhoa**6.666666666666667d-1
            t127 = -1.3127055298329054d-1*t125*t126*t14-2.00962261531666
     1         58d-3*t124
            t128 = 7.876233178997433d-1*t127*t13-1.3127055298329054d-1*t
     1         125*t126*t15
            t129 = 2.11607075208357d-1*t126*t13*t17-1.269642451250142d+0
     1         *t12*t123*t128
            t130 = 1/t26
            t131 = 1/t24**2
            t132 = -1.3127055298329054d-1*t125*t126*t22-3.16913278626356
     1         7d-3*t124
            t133 = 7.876233178997433d-1*t13*t132-1.3127055298329054d-1*t
     1         125*t126*t23
            t134 = 2.11607075208357d-1*t126*t13*t25-1.269642451250142d+0
     1         *t12*t131*t133
            t135 = 1/t33
            t136 = 1/t31**2
            t137 = -1.3127055298329054d-1*t125*t126*t29-1.73447766040861
     1         62d-3*t124
            t138 = 7.876233178997433d-1*t13*t137-1.3127055298329054d-1*t
     1         125*t126*t30
            t139 = 2.11607075208357d-1*t126*t13*t32-1.269642451250142d+0
     1         *t12*t136*t138
            t140 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t135*t139*t
     1         35+7.769549222703733d-4*t121*t34+1.709920934161365d+0*(6.
     2         21814d-2*t130*t134*t28-2.747773264188438d-3*t121*t27-3.10
     3         907d-2*t122*t129*t21+1.3210398931339265d-3*t121*t19))+3.3
     4         7738d-2*t135*t139*t35-7.769549222703733d-4*t121*t34)-6.21
     5         814d-2*t130*t134*t28+2.747773264188438d-3*t121*t27
            t141 = 1/t78**1.3333333333333336d+0
            t142 = 1/t78**6.666666666666667d-1
            t143 = 1/t82**3
            t144 = -1.3127055298329054d-1*t142*t143*t84-3.16913278626356
     1         7d-3*t141
            t145 = 7.876233178997433d-1*t144*t83-1.3127055298329054d-1*t
     1         142*t143*t85
            t146 = 1/t86**2
            t147 = 2.11607075208357d-1*t142*t83*t87-1.269642451250142d+0
     1         *t145*t146*t82
            t148 = 1/t88
            t149 = -6.21814d-2*t147*t148*t81
            t150 = 1/t78**1.3333333333333333d+0
            t151 = 2.747773264188438d-3*t150*t89
            t152 = -1.3127055298329054d-1*t142*t143*t96-1.73447766040861
     1         62d-3*t141
            t153 = 7.876233178997433d-1*t152*t83-1.3127055298329054d-1*t
     1         142*t143*t97
            t154 = 1/t98**2
            t155 = 2.11607075208357d-1*t142*t83*t99-1.269642451250142d+0
     1         *t153*t154*t82
            t156 = 1/t100
            t157 = 3.37738d-2*t155*t156*t95
            t158 = -7.769549222703733d-4*t101*t150
            t159 = -1.3127055298329054d-1*t105*t142*t143-2.0096226153166
     1         658d-3*t141
            t160 = 7.876233178997433d-1*t159*t83-1.3127055298329054d-1*t
     1         106*t142*t143
            t161 = 1/t107**2
            t162 = 2.11607075208357d-1*t108*t142*t83-1.269642451250142d+
     1         0*t160*t161*t82
            t163 = 1/t109
            t164 = -3.37738d-2*t155*t156*t95+1.709920934161365d+0*(-2.74
     1         7773264188438d-3*t150*t89+6.21814d-2*t147*t148*t81-3.1090
     2         7d-2*t104*t162*t163+1.3210398931339265d-3*t110*t150)+7.76
     3         9549222703733d-4*t101*t150
            t165 = t102*t103*t164
            t166 = 1/t78**5
            t167 = -4*t102*t111*t166
            t168 = t90**3
            t169 = 4*t103*t111*t168+t167+t165+t158+t157
            t170 = 1/t78**2
            t171 = t170*t90
            t172 = -t91
            t173 = t172+t171
            t174 = t92**3.333333333333333d-1
            t175 = -t170*t90
            t176 = t91+t175
            t177 = t93**3.333333333333333d-1
            t178 = 2.564881401242048d+0*t176*t177+2.564881401242048d+0*t
     1         173*t174
            t179 = 5.848223622634648d-1*t169*t94+5.848223622634648d-1*t1
     1         12*t178+t151+t149
            t180 = 1.0d+0*t113
            t181 = 1.0d+0*t179*t78-1.0d+0*t36+t180-1.0d+0*rhoa*t140
            t182 = 1/t73**3
            t183 = -8.0d-3*gammaaa*t119*t75*t76+2.4000000000000002d-5*ga
     1         mmaaa*t119*t71*t74*t75-4.8000000000000004d-5*gammaaa*t119
     2         *t70*t71*t74+1.4400000000000002d-7*gammaaa*t119*t182*t70*
     3         t72
            t184 = gammabb**3
            t185 = 1/t39**3
            t186 = 1/rhob**9
            t187 = 1/rhob**6.333333333333333d+0
            t188 = 1/rhob**3.6666666666666664d+0
            t189 = -5.333333333333333d-1*gammabb*t188*t42*t8+1.066666666
     1         6666667d-1*t187*t37*t40*t8-2.1333333333333337d-1*t187*t2*
     2         t37*t40+4.2666666666666675d-2*t184*t185*t186*t2
            t190 = 1/rhob**1.3333333333333333d+0
            t191 = 1/t51
            t192 = 1/t49**2
            t193 = 1/rhob**1.3333333333333336d+0
            t194 = 1/t45**3
            t195 = 1/rhob**6.666666666666667d-1
            t196 = -1.3127055298329054d-1*t194*t195*t47-2.00962261531666
     1         58d-3*t193
            t197 = 7.876233178997433d-1*t196*t46-1.3127055298329054d-1*t
     1         194*t195*t48
            t198 = 2.11607075208357d-1*t195*t46*t50-1.269642451250142d+0
     1         *t192*t197*t45
            t199 = 1/t59
            t200 = 1/t57**2
            t201 = -1.3127055298329054d-1*t194*t195*t55-3.16913278626356
     1         7d-3*t193
            t202 = 7.876233178997433d-1*t201*t46-1.3127055298329054d-1*t
     1         194*t195*t56
            t203 = 2.11607075208357d-1*t195*t46*t58-1.269642451250142d+0
     1         *t200*t202*t45
            t204 = 1/t66
            t205 = 1/t64**2
            t206 = -1.3127055298329054d-1*t194*t195*t62-1.73447766040861
     1         62d-3*t193
            t207 = 7.876233178997433d-1*t206*t46-1.3127055298329054d-1*t
     1         194*t195*t63
            t208 = 2.11607075208357d-1*t195*t46*t65-1.269642451250142d+0
     1         *t205*t207*t45
            t209 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t204*t208*t
     1         68+7.769549222703733d-4*t190*t67+1.709920934161365d+0*(6.
     2         21814d-2*t199*t203*t61-2.747773264188438d-3*t190*t60-3.10
     3         907d-2*t191*t198*t54+1.3210398931339265d-3*t190*t52))+3.3
     4         7738d-2*t204*t208*t68-7.769549222703733d-4*t190*t67)-6.21
     5         814d-2*t199*t203*t61+2.747773264188438d-3*t190*t60
            t210 = -4*t103*t111*t168+t167+t165+t158+t157
            t211 = t91+t171
            t212 = t175+t172
            t213 = 2.564881401242048d+0*t177*t212+2.564881401242048d+0*t
     1         174*t211
            t214 = 5.848223622634648d-1*t210*t94+5.848223622634648d-1*t1
     1         12*t213+t151+t149
            t215 = 1.0d+0*t214*t78-1.0d+0*t69-1.0d+0*rhob*t209+t180
            t216 = -8.0d-3*gammabb*t188*t75*t76+2.4000000000000002d-5*ga
     1         mmabb*t188*t71*t74*t75-4.8000000000000004d-5*gammabb*t188
     2         *t70*t71*t74+1.4400000000000002d-7*gammabb*t182*t188*t70*
     3         t72
            t217 = 1/rhoa**8
            t218 = 2.0d-1*t4*t8*t9-4.000000000000001d-2*gammaaa*t6*t7*t8
     1         +8.000000000000002d-2*gammaaa*t2*t6*t7-1.6000000000000003
     2         d-2*t116*t2*t217*t3
            t219 = 3.0d-3*t4*t75*t76-9.0d-6*t4*t71*t74*t75+1.8d-5*t4*t70
     1         *t71*t74-5.4d-8*t182*t4*t70*t72
            t220 = 1/rhob**8
            t221 = 2.0d-1*t38*t42*t8-4.000000000000001d-2*gammabb*t40*t4
     1         1*t8+8.000000000000002d-2*gammabb*t2*t40*t41-1.6000000000
     2         000003d-2*t185*t2*t220*t37
            t222 = 3.0d-3*t38*t75*t76-9.0d-6*t38*t71*t74*t75+1.8d-5*t38*
     1         t70*t71*t74-5.4d-8*t182*t38*t70*t72
            t223 = gammaaa**4
            t224 = 1/t5**4
            t225 = 1/rhoa**1.2666666666666665d+1
            t226 = 1/rhoa**10
            t227 = 1/rhoa**7.333333333333333d+0
            t228 = 1/rhoa**4.666666666666667d+0
            t229 = 1.9555555555555554d+0*gammaaa*t228*t8*t9-9.6d-1*t227*
     1         t3*t6*t8+1.1377777777777778d-1*t115*t116*t226*t8+1.351111
     2         1111111113d+0*t2*t227*t3*t6-6.115555555555556d-1*t115*t11
     3         6*t2*t226+6.826666666666669d-2*t2*t223*t224*t225
            t230 = 1/rhoa**2.333333333333333d+0
            t231 = 1/t18**2
            t232 = t129**2
            t233 = 1/t16**3
            t234 = t128**2
            t235 = 1/rhoa**2.3333333333333334d+0
            t236 = 1/rhoa**1.6666666666666669d+0
            t237 = 1/t12**5
            t238 = 6.563527649164527d-2*t124*t14*t237+8.751370198886037d
     1         -2*t125*t14*t236+3.0144339229749983d-3*t235
            t239 = 7.876233178997433d-1*t13*t238+6.563527649164527d-2*t1
     1         24*t15*t237+8.751370198886037d-2*t125*t15*t236-2.62541105
     2         9665811d-1*t125*t126*t127
            t240 = -1.269642451250142d+0*t12*t123*t239-1.410713834722380
     1         2d-1*t13*t17*t236+2.539284902500284d+0*t12*t233*t234-3.52
     2         678458680595d-2*t124*t125*t17-4.23214150416714d-1*t123*t1
     3         26*t128*t13
            t241 = 1/t26**2
            t242 = t134**2
            t243 = 1/t24**3
            t244 = t133**2
            t245 = 6.563527649164527d-2*t124*t22*t237+8.751370198886037d
     1         -2*t125*t22*t236+4.753699179395351d-3*t235
            t246 = 7.876233178997433d-1*t13*t245+6.563527649164527d-2*t1
     1         24*t23*t237+8.751370198886037d-2*t125*t23*t236-2.62541105
     2         9665811d-1*t125*t126*t132
            t247 = -1.4107138347223802d-1*t13*t236*t25-3.52678458680595d
     1         -2*t124*t125*t25-1.269642451250142d+0*t12*t131*t246+2.539
     2         284902500284d+0*t12*t243*t244-4.23214150416714d-1*t126*t1
     3         3*t131*t133
            t248 = 1/t33**2
            t249 = t139**2
            t250 = 1/t31**3
            t251 = t138**2
            t252 = 6.563527649164527d-2*t124*t237*t29+8.751370198886037d
     1         -2*t125*t236*t29+2.601716490612924d-3*t235
            t253 = 6.563527649164527d-2*t124*t237*t30+8.751370198886037d
     1         -2*t125*t236*t30+7.876233178997433d-1*t13*t252-2.62541105
     2         9665811d-1*t125*t126*t137
            t254 = -1.4107138347223802d-1*t13*t236*t32-3.52678458680595d
     1         -2*t124*t125*t32-1.269642451250142d+0*t12*t136*t253+2.539
     2         284902500284d+0*t12*t250*t251-4.23214150416714d-1*t126*t1
     3         3*t136*t138
            t255 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t135*t254*t
     1         35+3.37738d-2*t248*t249*t35-1.0359398963604977d-3*t230*t3
     2         4+1.709920934161365d+0*(6.21814d-2*t130*t247*t28-6.21814d
     3         -2*t241*t242*t28+3.663697685584584d-3*t230*t27-3.10907d-2
     4         *t122*t21*t240+3.10907d-2*t21*t231*t232-1.761386524178568
     5         7d-3*t19*t230-5.495546528376876d-3*t121*t130*t134+2.64207
     6         9786267853d-3*t121*t122*t129)+1.5539098445407465d-3*t121*
     7         t135*t139)+3.37738d-2*t135*t254*t35-3.37738d-2*t248*t249*
     8         t35+1.0359398963604977d-3*t230*t34-1.5539098445407465d-3*
     9         t121*t135*t139)-6.21814d-2*t130*t247*t28+6.21814d-2*t241*
     :         t242*t28-3.663697685584584d-3*t230*t27+5.495546528376876d
     ;         -3*t121*t130*t134
            t256 = t147**2
            t257 = 1/t88**2
            t258 = 6.21814d-2*t256*t257*t81
            t259 = t145**2
            t260 = 1/t86**3
            t261 = 1/t78**2.3333333333333334d+0
            t262 = 1/t82**5
            t263 = 1/t78**1.6666666666666669d+0
            t264 = 8.751370198886037d-2*t143*t263*t84+6.563527649164527d
     1         -2*t141*t262*t84+4.753699179395351d-3*t261
            t265 = 8.751370198886037d-2*t143*t263*t85+6.563527649164527d
     1         -2*t141*t262*t85+7.876233178997433d-1*t264*t83-2.62541105
     2         9665811d-1*t142*t143*t144
            t266 = -1.4107138347223802d-1*t263*t83*t87-3.52678458680595d
     1         -2*t141*t143*t87-4.23214150416714d-1*t142*t145*t146*t83-1
     2         .269642451250142d+0*t146*t265*t82+2.539284902500284d+0*t2
     3         59*t260*t82
            t267 = -6.21814d-2*t148*t266*t81
            t268 = 5.495546528376876d-3*t147*t148*t150
            t269 = 1/t78**2.333333333333333d+0
            t270 = -3.663697685584584d-3*t269*t89
            t271 = t155**2
            t272 = 1/t100**2
            t273 = -3.37738d-2*t271*t272*t95
            t274 = t153**2
            t275 = 1/t98**3
            t276 = 8.751370198886037d-2*t143*t263*t96+6.563527649164527d
     1         -2*t141*t262*t96+2.601716490612924d-3*t261
            t277 = 8.751370198886037d-2*t143*t263*t97+6.563527649164527d
     1         -2*t141*t262*t97+7.876233178997433d-1*t276*t83-2.62541105
     2         9665811d-1*t142*t143*t152
            t278 = -1.4107138347223802d-1*t263*t83*t99-3.52678458680595d
     1         -2*t141*t143*t99-4.23214150416714d-1*t142*t153*t154*t83-1
     2         .269642451250142d+0*t154*t277*t82+2.539284902500284d+0*t2
     3         74*t275*t82
            t279 = 3.37738d-2*t156*t278*t95
            t280 = -1.5539098445407465d-3*t150*t155*t156
            t281 = 1.0359398963604977d-3*t101*t269
            t282 = t162**2
            t283 = 1/t109**2
            t284 = t160**2
            t285 = 1/t107**3
            t286 = 8.751370198886037d-2*t105*t143*t263+6.563527649164527
     1         d-2*t105*t141*t262+3.0144339229749983d-3*t261
            t287 = 7.876233178997433d-1*t286*t83+8.751370198886037d-2*t1
     1         06*t143*t263+6.563527649164527d-2*t106*t141*t262-2.625411
     2         059665811d-1*t142*t143*t159
            t288 = -1.4107138347223802d-1*t108*t263*t83-4.23214150416714
     1         d-1*t142*t160*t161*t83-1.269642451250142d+0*t161*t287*t82
     2         +2.539284902500284d+0*t284*t285*t82-3.52678458680595d-2*t
     3         108*t141*t143
            t289 = -3.37738d-2*t156*t278*t95+3.37738d-2*t271*t272*t95+1.
     1         709920934161365d+0*(3.663697685584584d-3*t269*t89+6.21814
     2         d-2*t148*t266*t81-6.21814d-2*t256*t257*t81-3.10907d-2*t10
     3         4*t163*t288+3.10907d-2*t104*t282*t283-1.7613865241785687d
     4         -3*t110*t269+2.642079786267853d-3*t150*t162*t163-5.495546
     5         528376876d-3*t147*t148*t150)-1.0359398963604977d-3*t101*t
     6         269+1.5539098445407465d-3*t150*t155*t156
            t290 = t102*t103*t289
            t291 = -8*t102*t164*t166
            t292 = 1/t78**6
            t293 = 20*t102*t111*t292
            t294 = t90**2
            t295 = 12*t103*t111*t294
            t296 = t295+t293+t291+t290+t281+t280+t279+t273-32*t111*t166*
     1         t168+8*t103*t164*t168
            t297 = t173**2
            t298 = 1/t92**6.666666666666666d-1
            t299 = 1/t78**3
            t300 = -2*t299*t90
            t301 = 2*t170
            t302 = t301+t300
            t303 = t176**2
            t304 = 1/t93**6.666666666666666d-1
            t305 = 2*t299*t90
            t306 = -2*t170
            t307 = t306+t305
            t308 = 2.564881401242048d+0*t177*t307+8.549604670806825d-1*t
     1         303*t304+2.564881401242048d+0*t174*t302+8.549604670806825
     2         d-1*t297*t298
            t309 = 5.848223622634648d-1*t296*t94+5.848223622634648d-1*t1
     1         12*t308+t270+t268+t267+t258+1.1696447245269297d+0*t169*t1
     2         78
            t310 = 1.0d+0*t309*t78-1.0d+0*rhoa*t255+2.0d+0*t179-2.0d+0*t
     1         140
            t311 = 1/t73**4
            t312 = 2.9333333333333333d-2*gammaaa*t228*t75*t76-8.8d-5*gam
     1         maaa*t228*t71*t74*t75-1.28d-4*t227*t3*t74*t75+3.84d-7*t18
     2         2*t227*t3*t71*t75+1.76d-4*gammaaa*t228*t70*t71*t74+1.28d-
     3         4*t227*t3*t70*t74+3.456000000000001d-9*t227*t3*t311*t70*t
     4         72-5.28d-7*gammaaa*t182*t228*t70*t72-1.5360000000000001d-
     5         6*t182*t227*t3*t70*t71
            t313 = -12*t103*t111*t294+t293+t291+t290+t281+t280+t279+t273
            t314 = 5.129762802484096d+0*t177*t299*t90-5.129762802484096d
     1         +0*t174*t299*t90+8.549604670806825d-1*t176*t212*t304+8.54
     2         9604670806825d-1*t173*t211*t298
            t315 = 5.848223622634648d-1*t313*t94+5.848223622634648d-1*t1
     1         12*t314+t270+t268+t267+t258+5.848223622634648d-1*t169*t21
     2         3+5.848223622634648d-1*t178*t210
            t316 = 1.0d+0*t315*t78+1.0d+0*t214+1.0d+0*t179
            t317 = -1.28d-4*gammaaa*gammabb*t119*t188*t74*t75+3.84d-7*ga
     1         mmaaa*gammabb*t119*t182*t188*t71*t75+1.28d-4*gammaaa*gamm
     2         abb*t119*t188*t70*t74+3.456000000000001d-9*gammaaa*gammab
     3         b*t119*t188*t311*t70*t72-1.5360000000000001d-6*gammaaa*ga
     4         mmabb*t119*t182*t188*t70*t71
            t318 = gammabb**4
            t319 = 1/t39**4
            t320 = 1/rhob**1.2666666666666665d+1
            t321 = 1/rhob**10
            t322 = 1/rhob**7.333333333333333d+0
            t323 = 1/rhob**4.666666666666667d+0
            t324 = 1.9555555555555554d+0*gammabb*t323*t42*t8-9.6d-1*t322
     1         *t37*t40*t8+1.1377777777777778d-1*t184*t185*t321*t8+1.351
     2         1111111111113d+0*t2*t322*t37*t40-6.115555555555556d-1*t18
     3         4*t185*t2*t321+6.826666666666669d-2*t2*t318*t319*t320
            t325 = 1/rhob**2.333333333333333d+0
            t326 = 1/t51**2
            t327 = t198**2
            t328 = 1/t49**3
            t329 = t197**2
            t330 = 1/rhob**2.3333333333333334d+0
            t331 = 1/rhob**1.6666666666666669d+0
            t332 = 1/t45**5
            t333 = 6.563527649164527d-2*t193*t332*t47+8.751370198886037d
     1         -2*t194*t331*t47+3.0144339229749983d-3*t330
            t334 = 6.563527649164527d-2*t193*t332*t48+8.751370198886037d
     1         -2*t194*t331*t48+7.876233178997433d-1*t333*t46-2.62541105
     2         9665811d-1*t194*t195*t196
            t335 = -1.4107138347223802d-1*t331*t46*t50-3.52678458680595d
     1         -2*t193*t194*t50-4.23214150416714d-1*t192*t195*t197*t46-1
     2         .269642451250142d+0*t192*t334*t45+2.539284902500284d+0*t3
     3         28*t329*t45
            t336 = 1/t59**2
            t337 = t203**2
            t338 = 1/t57**3
            t339 = t202**2
            t340 = 6.563527649164527d-2*t193*t332*t55+8.751370198886037d
     1         -2*t194*t331*t55+4.753699179395351d-3*t330
            t341 = 6.563527649164527d-2*t193*t332*t56+8.751370198886037d
     1         -2*t194*t331*t56+7.876233178997433d-1*t340*t46-2.62541105
     2         9665811d-1*t194*t195*t201
            t342 = -1.4107138347223802d-1*t331*t46*t58-3.52678458680595d
     1         -2*t193*t194*t58-4.23214150416714d-1*t195*t200*t202*t46-1
     2         .269642451250142d+0*t200*t341*t45+2.539284902500284d+0*t3
     3         38*t339*t45
            t343 = 1/t66**2
            t344 = t208**2
            t345 = 1/t64**3
            t346 = t207**2
            t347 = 6.563527649164527d-2*t193*t332*t62+8.751370198886037d
     1         -2*t194*t331*t62+2.601716490612924d-3*t330
            t348 = 6.563527649164527d-2*t193*t332*t63+8.751370198886037d
     1         -2*t194*t331*t63+7.876233178997433d-1*t347*t46-2.62541105
     2         9665811d-1*t194*t195*t206
            t349 = -1.4107138347223802d-1*t331*t46*t65-3.52678458680595d
     1         -2*t193*t194*t65-4.23214150416714d-1*t195*t205*t207*t46-1
     2         .269642451250142d+0*t205*t348*t45+2.539284902500284d+0*t3
     3         45*t346*t45
            t350 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t204*t349*t
     1         68+3.37738d-2*t343*t344*t68-1.0359398963604977d-3*t325*t6
     2         7+1.709920934161365d+0*(6.21814d-2*t199*t342*t61-6.21814d
     3         -2*t336*t337*t61+3.663697685584584d-3*t325*t60-3.10907d-2
     4         *t191*t335*t54+3.10907d-2*t326*t327*t54-1.761386524178568
     5         7d-3*t325*t52-5.495546528376876d-3*t190*t199*t203+2.64207
     6         9786267853d-3*t190*t191*t198)+1.5539098445407465d-3*t190*
     7         t204*t208)+3.37738d-2*t204*t349*t68-3.37738d-2*t343*t344*
     8         t68+1.0359398963604977d-3*t325*t67-1.5539098445407465d-3*
     9         t190*t204*t208)-6.21814d-2*t199*t342*t61+6.21814d-2*t336*
     :         t337*t61-3.663697685584584d-3*t325*t60+5.495546528376876d
     ;         -3*t190*t199*t203
            t351 = t295+t293+t291+t290+t281+t280+t279+t273+32*t111*t166*
     1         t168-8*t103*t164*t168
            t352 = t211**2
            t353 = t306+t300
            t354 = t212**2
            t355 = t305+t301
            t356 = 2.564881401242048d+0*t177*t355+8.549604670806825d-1*t
     1         304*t354+2.564881401242048d+0*t174*t353+8.549604670806825
     2         d-1*t298*t352
            t357 = 5.848223622634648d-1*t351*t94+5.848223622634648d-1*t1
     1         12*t356+t270+t268+t267+t258+1.1696447245269297d+0*t210*t2
     2         13
            t358 = 1.0d+0*t357*t78-1.0d+0*rhob*t350+2.0d+0*t214-2.0d+0*t
     1         209
            t359 = 2.9333333333333333d-2*gammabb*t323*t75*t76-8.8d-5*gam
     1         mabb*t323*t71*t74*t75-1.28d-4*t322*t37*t74*t75+3.84d-7*t1
     2         82*t322*t37*t71*t75+1.76d-4*gammabb*t323*t70*t71*t74+1.28
     3         d-4*t322*t37*t70*t74+3.456000000000001d-9*t311*t322*t37*t
     4         70*t72-5.28d-7*gammabb*t182*t323*t70*t72-1.53600000000000
     5         01d-6*t182*t322*t37*t70*t71
            t360 = 1/rhoa**1.1666666666666665d+1
            t361 = -5.333333333333333d-1*t119*t8*t9+3.2d-1*gammaaa*t118*
     1         t6*t8-4.2666666666666675d-2*t116*t117*t3*t8-4.26666666666
     2         66675d-1*gammaaa*t118*t2*t6-2.5600000000000006d-2*t115*t2
     3         *t224*t360+2.1333333333333337d-1*t116*t117*t2*t3
            t362 = -8.0d-3*t119*t75*t76+2.4000000000000002d-5*t119*t71*t
     1         74*t75+4.8000000000000004d-5*gammaaa*t118*t74*t75-1.44000
     2         00000000002d-7*gammaaa*t118*t182*t71*t75-4.80000000000000
     3         04d-5*t119*t70*t71*t74-4.8000000000000004d-5*gammaaa*t118
     4         *t70*t74-1.2960000000000002d-9*gammaaa*t118*t311*t70*t72+
     5         1.4400000000000002d-7*t119*t182*t70*t72+5.760000000000001
     6         d-7*gammaaa*t118*t182*t70*t71
            t363 = 4.8000000000000004d-5*gammaaa*t119*t38*t74*t75-1.4400
     1         000000000002d-7*gammaaa*t119*t182*t38*t71*t75-4.800000000
     2         0000004d-5*gammaaa*t119*t38*t70*t74-1.2960000000000002d-9
     3         *gammaaa*t119*t311*t38*t70*t72+5.760000000000001d-7*gamma
     4         aa*t119*t182*t38*t70*t71
            t364 = 4.8000000000000004d-5*gammabb*t188*t4*t74*t75-1.44000
     1         00000000002d-7*gammabb*t182*t188*t4*t71*t75-4.80000000000
     2         00004d-5*gammabb*t188*t4*t70*t74-1.2960000000000002d-9*ga
     3         mmabb*t188*t311*t4*t70*t72+5.760000000000001d-7*gammabb*t
     4         182*t188*t4*t70*t71
            t365 = 1/rhob**1.1666666666666665d+1
            t366 = -5.333333333333333d-1*t188*t42*t8+3.2d-1*gammabb*t187
     1         *t40*t8-4.2666666666666675d-2*t185*t186*t37*t8-4.26666666
     2         66666675d-1*gammabb*t187*t2*t40+2.1333333333333337d-1*t18
     3         5*t186*t2*t37-2.5600000000000006d-2*t184*t2*t319*t365
            t367 = -8.0d-3*t188*t75*t76+2.4000000000000002d-5*t188*t71*t
     1         74*t75+4.8000000000000004d-5*gammabb*t187*t74*t75-1.44000
     2         00000000002d-7*gammabb*t182*t187*t71*t75-4.80000000000000
     3         04d-5*t188*t70*t71*t74-4.8000000000000004d-5*gammabb*t187
     4         *t70*t74-1.2960000000000002d-9*gammabb*t187*t311*t70*t72+
     5         1.4400000000000002d-7*t182*t188*t70*t72+5.760000000000001
     6         d-7*gammabb*t182*t187*t70*t71
            t368 = 1/rhoa**1.0666666666666666d+1
            t369 = -8.000000000000002d-2*t6*t7*t8+1.6000000000000003d-2*
     1         gammaaa*t116*t217*t8+8.000000000000002d-2*t2*t6*t7+9.6000
     2         00000000004d-3*t2*t224*t3*t368-6.400000000000001d-2*gamma
     3         aa*t116*t2*t217
            t370 = -1.8d-5*t7*t74*t75+5.4d-8*t182*t7*t71*t75+1.8d-5*t7*t
     1         70*t74+4.860000000000001d-10*t311*t7*t70*t72-2.16d-7*t182
     2         *t7*t70*t71
            t371 = 4.860000000000001d-10*t311*t38*t4*t70*t72
            t372 = 1.8d-5*t70-1.8d-5*t75
            t373 = 5.4d-8*t71*t75-2.16d-7*t70*t71
            t374 = 1/rhob**1.0666666666666666d+1
            t375 = -8.000000000000002d-2*t40*t41*t8+1.6000000000000003d-
     1         2*gammabb*t185*t220*t8+8.000000000000002d-2*t2*t40*t41+9.
     2         600000000000004d-3*t2*t319*t37*t374-6.400000000000001d-2*
     3         gammabb*t185*t2*t220
            t376 = -1.8d-5*t41*t74*t75+5.4d-8*t182*t41*t71*t75+1.8d-5*t4
     1         1*t70*t74+4.860000000000001d-10*t311*t41*t70*t72-2.16d-7*
     2         t182*t41*t70*t71
            t377 = 1/t5**5
            t378 = 1/rhoa**1.3666666666666666d+1
            t379 = 1/rhoa**11
            t380 = 1/rhoa**8.333333333333334d+0
            t381 = 1/rhoa**5.666666666666667d+0
            t382 = 1/rhoa**3.333333333333333d+0
            t383 = 1/rhoa**3.3333333333333337d+0
            t384 = 1/rhoa**2.666666666666667d+0
            t385 = 1/t12**7
            t386 = 1/rhoa**2.0d+0
            t387 = 1/t26**3
            t388 = t134**3
            t389 = -1.269642451250142d+0*t12*t131*(7.876233178997433d-1*
     1         t13*(-5.469606374303773d-2*t22*t385*t386-1.45856169981433
     2         94d-1*t125*t22*t384-1.1708185015918181d-2*t383-1.31270552
     3         98329054d-1*t22*t235*t237)-5.469606374303773d-2*t23*t385*
     4         t386-1.4585616998143394d-1*t125*t23*t384-3.93811658949871
     5         63d-1*t125*t126*t245-1.3127055298329054d-1*t23*t235*t237+
     6         1.9690582947493582d-1*t124*t132*t237+2.625411059665811d-1
     7         *t125*t132*t236)+1.763392293402975d-2*t237*t25*t386+2.351
     8         1897245373004d-1*t13*t25*t384+7.053569173611901d-2*t125*t
     9         235*t25+7.617854707500852d+0*t12*t133*t243*t246-6.3482122
     :         5625071d-1*t126*t13*t131*t246+1.269642451250142d+0*t126*t
     ;         13*t243*t244-7.617854707500852d+0*t12*t133**3/t24**4+4.23
     <         21415041671406d-1*t13*t131*t133*t236+1.0580353760417849d-
     =         1*t124*t125*t131*t133
            t390 = 1/t33**3
            t391 = t139**3
            t392 = -1.269642451250142d+0*t12*t136*(7.876233178997433d-1*
     1         t13*(-5.469606374303773d-2*t29*t385*t386-1.45856169981433
     2         94d-1*t125*t29*t384-6.407931356509611d-3*t383-1.312705529
     3         8329054d-1*t235*t237*t29)-5.469606374303773d-2*t30*t385*t
     4         386-1.4585616998143394d-1*t125*t30*t384-1.312705529832905
     5         4d-1*t235*t237*t30-3.9381165894987163d-1*t125*t126*t252+1
     6         .9690582947493582d-1*t124*t137*t237+2.625411059665811d-1*
     7         t125*t137*t236)+1.763392293402975d-2*t237*t32*t386+2.3511
     8         897245373004d-1*t13*t32*t384+7.053569173611901d-2*t125*t2
     9         35*t32-7.617854707500852d+0*t12*t138**3/t31**4+7.61785470
     :         7500852d+0*t12*t138*t250*t253-6.34821225625071d-1*t126*t1
     ;         3*t136*t253+1.269642451250142d+0*t126*t13*t250*t251+4.232
     <         1415041671406d-1*t13*t136*t138*t236+1.0580353760417849d-1
     =         *t124*t125*t136*t138
            t393 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t135*t35*t3
     1         92-6.75476d-2*t35*t390*t391+1.709920934161365d+0*(6.21814
     2         d-2*t130*t28*t389+1.243628d-1*t28*t387*t388-3.10907d-2*t1
     3         22*t21*(-1.269642451250142d+0*t12*t123*(7.876233178997433
     4         d-1*t13*(-5.469606374303773d-2*t14*t385*t386-1.4585616998
     5         143394d-1*t125*t14*t384-7.424439106586571d-3*t383-1.31270
     6         55298329054d-1*t14*t235*t237)-5.469606374303773d-2*t15*t3
     7         85*t386-1.4585616998143394d-1*t125*t15*t384-3.93811658949
     8         87163d-1*t125*t126*t238-1.3127055298329054d-1*t15*t235*t2
     9         37+1.9690582947493582d-1*t124*t127*t237+2.625411059665811
     :         d-1*t125*t127*t236)+1.763392293402975d-2*t17*t237*t386+2.
     ;         3511897245373004d-1*t13*t17*t384+7.617854707500852d+0*t12
     <         *t128*t233*t239-6.34821225625071d-1*t123*t126*t13*t239+4.
     =         2321415041671406d-1*t123*t128*t13*t236+7.053569173611901d
     >         -2*t125*t17*t235+1.269642451250142d+0*t126*t13*t233*t234-
     ?         7.617854707500852d+0*t12*t128**3/t16**4+1.058035376041784
     @         9d-1*t123*t124*t125*t128)-8.548627933030694d-3*t27*t382+4
     1         .1099018897499934d-3*t19*t382-1.865442d-1*t134*t241*t247*
     2         t28-8.243319792565315d-3*t121*t130*t247+8.243319792565315
     3         d-3*t121*t241*t242+9.327209999999999d-2*t129*t21*t231*t24
     4         0+3.96311967940178d-3*t121*t122*t240-3.96311967940178d-3*
     5         t121*t231*t232+1.0991093056753751d-2*t130*t134*t230-5.284
     6         159572535706d-3*t122*t129*t230-6.21814d-2*t129**3*t21/t18
     7         **3)+2.4171930915078277d-3*t34*t382+1.013214d-1*t139*t248
     8         *t254*t35+2.33086476681112d-3*t121*t135*t254-2.3308647668
     9         1112d-3*t121*t248*t249-3.107819689081493d-3*t135*t139*t23
     :         0)+3.37738d-2*t135*t35*t392+6.75476d-2*t35*t390*t391-2.41
     ;         71930915078277d-3*t34*t382-1.013214d-1*t139*t248*t254*t35
     <         -2.33086476681112d-3*t121*t135*t254+2.33086476681112d-3*t
     =         121*t248*t249+3.107819689081493d-3*t135*t139*t230)-6.2181
     >         4d-2*t130*t28*t389-1.243628d-1*t28*t387*t388+8.5486279330
     ?         30694d-3*t27*t382+1.865442d-1*t134*t241*t247*t28+8.243319
     @         792565315d-3*t121*t130*t247-8.243319792565315d-3*t121*t24
     1         1*t242-1.0991093056753751d-2*t130*t134*t230
            t394 = 1/t73**5
            t395 = t147**3
            t396 = 1/t88**3
            t397 = -1.243628d-1*t395*t396*t81
            t398 = 1.865442d-1*t147*t257*t266*t81
            t399 = -8.243319792565315d-3*t150*t256*t257
            t400 = 1/t78**3.3333333333333337d+0
            t401 = 1/t78**2.0d+0
            t402 = 1/t82**7
            t403 = 1/t78**2.666666666666667d+0
            t404 = 2.3511897245373004d-1*t403*t83*t87+1.763392293402975d
     1         -2*t262*t401*t87+7.053569173611901d-2*t143*t261*t87-7.617
     2         854707500852d+0*t145**3*t82/t86**4-1.269642451250142d+0*t
     3         146*t82*(-1.4585616998143394d-1*t143*t403*t85-5.469606374
     4         303773d-2*t401*t402*t85-1.3127055298329054d-1*t261*t262*t
     5         85+7.876233178997433d-1*t83*(-1.4585616998143394d-1*t143*
     6         t403*t84-5.469606374303773d-2*t401*t402*t84-1.31270552983
     7         29054d-1*t261*t262*t84-1.1708185015918181d-2*t400)-3.9381
     8         165894987163d-1*t142*t143*t264+2.625411059665811d-1*t143*
     9         t144*t263+1.9690582947493582d-1*t141*t144*t262)-6.3482122
     :         5625071d-1*t142*t146*t265*t83+4.2321415041671406d-1*t145*
     ;         t146*t263*t83+1.269642451250142d+0*t142*t259*t260*t83+7.6
     <         17854707500852d+0*t145*t260*t265*t82+1.0580353760417849d-
     =         1*t141*t143*t145*t146
            t405 = -6.21814d-2*t148*t404*t81
            t406 = 8.243319792565315d-3*t148*t150*t266
            t407 = -1.0991093056753751d-2*t147*t148*t269
            t408 = 1/t78**3.333333333333333d+0
            t409 = 8.548627933030694d-3*t408*t89
            t410 = 1/t92**1.6666666666666669d+0
            t411 = 6*t103*t90
            t412 = -6*t299
            t413 = 1/t93**1.6666666666666669d+0
            t414 = -6*t103*t90
            t415 = 6*t299
            t416 = t155**3
            t417 = 1/t100**3
            t418 = 6.75476d-2*t416*t417*t95
            t419 = -1.013214d-1*t155*t272*t278*t95
            t420 = 2.33086476681112d-3*t150*t271*t272
            t421 = 2.3511897245373004d-1*t403*t83*t99+1.763392293402975d
     1         -2*t262*t401*t99+7.053569173611901d-2*t143*t261*t99-7.617
     2         854707500852d+0*t153**3*t82/t98**4-1.269642451250142d+0*t
     3         154*t82*(-1.4585616998143394d-1*t143*t403*t97-5.469606374
     4         303773d-2*t401*t402*t97-1.3127055298329054d-1*t261*t262*t
     5         97+7.876233178997433d-1*t83*(-1.4585616998143394d-1*t143*
     6         t403*t96-5.469606374303773d-2*t401*t402*t96-1.31270552983
     7         29054d-1*t261*t262*t96-6.407931356509611d-3*t400)-3.93811
     8         65894987163d-1*t142*t143*t276+2.625411059665811d-1*t143*t
     9         152*t263+1.9690582947493582d-1*t141*t152*t262)-6.34821225
     :         625071d-1*t142*t154*t277*t83+1.269642451250142d+0*t142*t2
     ;         74*t275*t83+4.2321415041671406d-1*t153*t154*t263*t83+7.61
     <         7854707500852d+0*t153*t275*t277*t82+1.0580353760417849d-1
     =         *t141*t143*t153*t154
            t422 = 3.37738d-2*t156*t421*t95
            t423 = -2.33086476681112d-3*t150*t156*t278
            t424 = 3.107819689081493d-3*t155*t156*t269
            t425 = -2.4171930915078277d-3*t101*t408
            t426 = t102*t103*(-3.37738d-2*t156*t421*t95-6.75476d-2*t416*
     1         t417*t95+1.013214d-1*t155*t272*t278*t95+1.709920934161365
     2         d+0*(-8.548627933030694d-3*t408*t89-3.10907d-2*t104*t163*
     3         (-1.269642451250142d+0*t161*t82*(7.876233178997433d-1*(-1
     4         .4585616998143394d-1*t105*t143*t403-5.469606374303773d-2*
     5         t105*t401*t402-7.424439106586571d-3*t400-1.31270552983290
     6         54d-1*t105*t261*t262)*t83-1.4585616998143394d-1*t106*t143
     7         *t403-5.469606374303773d-2*t106*t401*t402-3.9381165894987
     8         163d-1*t142*t143*t286+2.625411059665811d-1*t143*t159*t263
     9         -1.3127055298329054d-1*t106*t261*t262+1.9690582947493582d
     :         -1*t141*t159*t262)+2.3511897245373004d-1*t108*t403*t83-6.
     ;         34821225625071d-1*t142*t161*t287*t83+1.269642451250142d+0
     <         *t142*t284*t285*t83+4.2321415041671406d-1*t160*t161*t263*
     =         t83+7.617854707500852d+0*t160*t285*t287*t82-7.61785470750
     >         0852d+0*t160**3*t82/t107**4+1.763392293402975d-2*t108*t26
     ?         2*t401+7.053569173611901d-2*t108*t143*t261+1.058035376041
     @         7849d-1*t141*t143*t160*t161)+6.21814d-2*t148*t404*t81+1.2
     1         43628d-1*t395*t396*t81-1.865442d-1*t147*t257*t266*t81+4.1
     2         099018897499934d-3*t110*t408+9.327209999999999d-2*t104*t1
     3         62*t283*t288+3.96311967940178d-3*t150*t163*t288-3.9631196
     4         7940178d-3*t150*t282*t283-5.284159572535706d-3*t162*t163*
     5         t269+1.0991093056753751d-2*t147*t148*t269-8.2433197925653
     6         15d-3*t148*t150*t266+8.243319792565315d-3*t150*t256*t257-
     7         6.21814d-2*t104*t162**3/t109**3)+2.4171930915078277d-3*t1
     8         01*t408+2.33086476681112d-3*t150*t156*t278-2.330864766811
     9         12d-3*t150*t271*t272-3.107819689081493d-3*t155*t156*t269)
            t427 = -12*t102*t166*t289
            t428 = 60*t102*t164*t292
            t429 = 36*t103*t164*t294
            t430 = -120*t102*t111/t78**7
            t431 = -144*t111*t166*t294
            t432 = 24*t103*t111*t90
            t433 = 2.0d+0*t315
            t434 = -12*t103*t164*t294
            t435 = 48*t111*t166*t294
            t436 = -24*t103*t111*t90
            t437 = 1/t39**5
            t438 = 1/rhob**1.3666666666666666d+1
            t439 = 1/rhob**11
            t440 = 1/rhob**8.333333333333334d+0
            t441 = 1/rhob**5.666666666666667d+0
            t442 = 1/rhob**3.333333333333333d+0
            t443 = 1/rhob**3.3333333333333337d+0
            t444 = 1/rhob**2.666666666666667d+0
            t445 = 1/t45**7
            t446 = 1/rhob**2.0d+0
            t447 = 1/t59**3
            t448 = t203**3
            t449 = 2.3511897245373004d-1*t444*t46*t58+1.763392293402975d
     1         -2*t332*t446*t58+7.053569173611901d-2*t194*t330*t58-7.617
     2         854707500852d+0*t202**3*t45/t57**4-1.269642451250142d+0*t
     3         200*t45*(-5.469606374303773d-2*t445*t446*t56-1.4585616998
     4         143394d-1*t194*t444*t56-1.3127055298329054d-1*t330*t332*t
     5         56+7.876233178997433d-1*t46*(-5.469606374303773d-2*t445*t
     6         446*t55-1.4585616998143394d-1*t194*t444*t55-1.31270552983
     7         29054d-1*t330*t332*t55-1.1708185015918181d-2*t443)-3.9381
     8         165894987163d-1*t194*t195*t340+1.9690582947493582d-1*t193
     9         *t201*t332+2.625411059665811d-1*t194*t201*t331)-6.3482122
     :         5625071d-1*t195*t200*t341*t46+1.269642451250142d+0*t195*t
     ;         338*t339*t46+4.2321415041671406d-1*t200*t202*t331*t46+7.6
     <         17854707500852d+0*t202*t338*t341*t45+1.0580353760417849d-
     =         1*t193*t194*t200*t202
            t450 = 1/t66**3
            t451 = t208**3
            t452 = 2.3511897245373004d-1*t444*t46*t65+1.763392293402975d
     1         -2*t332*t446*t65+7.053569173611901d-2*t194*t330*t65-7.617
     2         854707500852d+0*t207**3*t45/t64**4-1.269642451250142d+0*t
     3         205*t45*(-5.469606374303773d-2*t445*t446*t63-1.4585616998
     4         143394d-1*t194*t444*t63-1.3127055298329054d-1*t330*t332*t
     5         63+7.876233178997433d-1*t46*(-5.469606374303773d-2*t445*t
     6         446*t62-1.4585616998143394d-1*t194*t444*t62-1.31270552983
     7         29054d-1*t330*t332*t62-6.407931356509611d-3*t443)-3.93811
     8         65894987163d-1*t194*t195*t347+1.9690582947493582d-1*t193*
     9         t206*t332+2.625411059665811d-1*t194*t206*t331)-6.34821225
     :         625071d-1*t195*t205*t348*t46+1.269642451250142d+0*t195*t3
     ;         45*t346*t46+4.2321415041671406d-1*t205*t207*t331*t46+7.61
     <         7854707500852d+0*t207*t345*t348*t45+1.0580353760417849d-1
     =         *t193*t194*t205*t207
            t453 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t204*t452*t
     1         68-6.75476d-2*t450*t451*t68+1.013214d-1*t208*t343*t349*t6
     2         8+2.4171930915078277d-3*t442*t67+1.709920934161365d+0*(6.
     3         21814d-2*t199*t449*t61+1.243628d-1*t447*t448*t61-1.865442
     4         d-1*t203*t336*t342*t61-8.548627933030694d-3*t442*t60-6.21
     5         814d-2*t198**3*t54/t51**3-3.10907d-2*t191*(2.351189724537
     6         3004d-1*t444*t46*t50+1.763392293402975d-2*t332*t446*t50+7
     7         .053569173611901d-2*t194*t330*t50-7.617854707500852d+0*t1
     8         97**3*t45/t49**4-1.269642451250142d+0*t192*t45*(-5.469606
     9         374303773d-2*t445*t446*t48-1.4585616998143394d-1*t194*t44
     :         4*t48-1.3127055298329054d-1*t330*t332*t48+7.8762331789974
     ;         33d-1*t46*(-5.469606374303773d-2*t445*t446*t47-1.45856169
     <         98143394d-1*t194*t444*t47-1.3127055298329054d-1*t330*t332
     =         *t47-7.424439106586571d-3*t443)-3.9381165894987163d-1*t19
     >         4*t195*t333+1.9690582947493582d-1*t193*t196*t332+2.625411
     ?         059665811d-1*t194*t196*t331)-6.34821225625071d-1*t192*t19
     @         5*t334*t46+4.2321415041671406d-1*t192*t197*t331*t46+1.269
     1         642451250142d+0*t195*t328*t329*t46+7.617854707500852d+0*t
     2         197*t328*t334*t45+1.0580353760417849d-1*t192*t193*t194*t1
     3         97)*t54+9.327209999999999d-2*t198*t326*t335*t54+4.1099018
     4         897499934d-3*t442*t52-8.243319792565315d-3*t190*t199*t342
     5         +8.243319792565315d-3*t190*t336*t337+3.96311967940178d-3*
     6         t190*t191*t335-3.96311967940178d-3*t190*t326*t327+1.09910
     7         93056753751d-2*t199*t203*t325-5.284159572535706d-3*t191*t
     8         198*t325)+2.33086476681112d-3*t190*t204*t349-2.3308647668
     9         1112d-3*t190*t343*t344-3.107819689081493d-3*t204*t208*t32
     :         5)+3.37738d-2*t204*t452*t68+6.75476d-2*t450*t451*t68-1.01
     ;         3214d-1*t208*t343*t349*t68-2.4171930915078277d-3*t442*t67
     <         -2.33086476681112d-3*t190*t204*t349+2.33086476681112d-3*t
     =         190*t343*t344+3.107819689081493d-3*t204*t208*t325)-6.2181
     >         4d-2*t199*t449*t61-1.243628d-1*t447*t448*t61+1.865442d-1*
     ?         t203*t336*t342*t61+8.548627933030694d-3*t442*t60+8.243319
     @         792565315d-3*t190*t199*t342-8.243319792565315d-3*t190*t33
     1         6*t337-1.0991093056753751d-2*t199*t203*t325
            t454 = -1.8d-5*t38*t4*t74*t75+5.4d-8*t182*t38*t4*t71*t75+1.8
     1         d-5*t38*t4*t70*t74-2.16d-7*t182*t38*t4*t70*t71+t371
            fnc(iq) = 1.0d+0*(t114*t77+1.0d+0*rhob*t43*t69+1.0d+0*rhoa*t
     1         10*t36)*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(t181*t77+1.0d+0*rhoa*t120*t36+1.0d+
     1         0*t10*t36+t114*t183+1.0d+0*rhoa*t10*t140)*wght+Amat(iq,D1
     2         _RA)
            Amat(iq,D1_RB) = 1.0d+0*(t215*t77+1.0d+0*t43*t69+1.0d+0*rhob
     1         *t189*t69+1.0d+0*rhob*t209*t43+t114*t216)*wght+Amat(iq,D1
     2         _RB)
            Cmat(iq,D1_GAA) = 1.0d+0*(1.0d+0*rhoa*t218*t36+t114*t219)*wg
     1         ht+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = 1.0d+0*(1.0d+0*rhob*t221*t69+t114*t222)*wg
     1         ht+Cmat(iq,D1_GBB)
            Amat2(iq,D2_RA_RA) = 1.0d+0*(t310*t77+1.0d+0*rhoa*t229*t36+2
     1         .0d+0*t120*t36+t114*t312+1.0d+0*rhoa*t10*t255+2*t181*t183
     2         +2.0d+0*rhoa*t120*t140+2.0d+0*t10*t140)*wght+Amat2(iq,D2_
     3         RA_RA)
            Amat2(iq,D2_RA_RB) = 1.0d+0*(t316*t77+t114*t317+t181*t216+t1
     1         83*t215)*wght+Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*(t358*t77+1.0d+0*rhob*t324*t69+2
     1         .0d+0*t189*t69+1.0d+0*rhob*t350*t43+2.0d+0*t209*t43+t114*
     2         t359+2*t215*t216+2.0d+0*rhob*t189*t209)*wght+Amat2(iq,D2_
     3         RB_RB)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*(t114*t362+1.0d+0*rhoa*t36*t361
     1         +1.0d+0*t218*t36+t181*t219+1.0d+0*rhoa*t140*t218)*wght+Cm
     2         at2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = 1.0d+0*(t114*t363+t181*t222)*wght+Cmat
     1         2(iq,D2_RA_GBB)
            Cmat2(iq,D2_RB_GAA) = 1.0d+0*(t114*t364+t215*t219)*wght+Cmat
     1         2(iq,D2_RB_GAA)
            Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
            Cmat2(iq,D2_RB_GBB) = 1.0d+0*(1.0d+0*rhob*t366*t69+1.0d+0*t2
     1         21*t69+t114*t367+t215*t222+1.0d+0*rhob*t209*t221)*wght+Cm
     2         at2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GAA_GAA) = 1.0d+0*(t114*t370+1.0d+0*rhoa*t36*t36
     1         9)*wght+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = 1.0d+0*t114*(t372*t38*t4*t74+t182*t37
     1         3*t38*t4+t371)*wght+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
            Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
            Cmat2(iq,D2_GBB_GBB) = 1.0d+0*(1.0d+0*rhob*t375*t69+t114*t37
     1         6)*wght+Cmat2(iq,D2_GBB_GBB)
            Amat3(iq,D3_RA_RA_RA) = 1.0d+0*(t77*(1.0d+0*t78*(5.848223622
     1         634648d-1*(t432+t431+t430+t429+t428+t427+t426+t425+t424+t
     2         423+t422+t420+t419+t418+240*t111*t168*t292+12*t103*t168*t
     3         289-96*t164*t166*t168)*t94+5.848223622634648d-1*t112*(2.5
     4         64881401242048d+0*t177*(t415+t414)-5.69973644720455d-1*t1
     5         76**3*t413+2.564881401242048d+0*t174*(t412+t411)-5.699736
     6         44720455d-1*t173**3*t410+2.5648814012420473d+0*t176*t304*
     7         t307+2.5648814012420473d+0*t173*t298*t302)+t409+t407+t406
     8         +t405+t399+t398+t397+1.7544670867903944d+0*t169*t308+1.75
     9         44670867903944d+0*t178*t296)-1.0d+0*rhoa*t393+3.0d+0*t309
     :         -3.0d+0*t255)+1.0d+0*rhoa*t36*(-9.125925925925926d+0*gamm
     ;         aaa*t381*t8*t9+8.082962962962963d+0*t3*t380*t6*t8-2.16177
     <         7777777778d+0*t115*t116*t379*t8+1.8204444444444445d-1*t22
     =         3*t224*t378*t8-9.90814814814815d+0*t2*t3*t380*t6+7.556740
     >         740740742d+0*t115*t116*t2*t379-1.8432000000000004d+0*t2*t
     ?         223*t224*t378+1.456355555555556d-1*gammaaa**5*t2*t377/rho
     @         a**1.6333333333333333d+1)+t114*(-1.368888888888889d-1*gam
     1         maaa*t381*t75*t76+4.106666666666667d-4*gammaaa*t381*t71*t
     2         74*t75+1.4079999999999998d-3*t3*t380*t74*t75-4.224d-6*t18
     3         2*t3*t380*t71*t75+9.216d-9*t115*t311*t379*t71*t75-3.072d-
     4         6*t115*t182*t379*t75-8.213333333333334d-4*gammaaa*t381*t7
     5         0*t71*t74-1.408d-3*t3*t380*t70*t74+1.1059200000000002d-10
     6         *t115*t379*t394*t70*t72+2.4640000000000004d-6*gammaaa*t18
     7         2*t381*t70*t72-3.8016d-8*t3*t311*t380*t70*t72+1.689600000
     8         0000003d-5*t182*t3*t380*t70*t71-5.529600000000001d-8*t115
     9         *t311*t379*t70*t71+6.144000000000001d-6*t115*t182*t379*t7
     :         0)+1.0d+0*rhoa*t10*t393+3.0d+0*t229*t36+3*t181*t312+3*t18
     ;         3*t310+3.0d+0*rhoa*t120*t255+3.0d+0*t10*t255+3.0d+0*rhoa*
     <         t140*t229+6.0d+0*t120*t140)*wght+Amat3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = 1.0d+0*(t77*(1.0d+0*t78*(5.848223622
     1         634648d-1*(t436+t435+t434+t430+t428+t427+t426+t425+t424+t
     2         423+t422+t420+t419+t418+80*t111*t168*t292+4*t103*t168*t28
     3         9-32*t164*t166*t168)*t94+5.848223622634648d-1*t112*(3.419
     4         84186832273d+0*t176*t299*t304*t90-3.41984186832273d+0*t17
     5         3*t298*t299*t90+2.564881401242048d+0*t177*(t414+2*t299)-5
     6         .69973644720455d-1*t212*t303*t413+2.564881401242048d+0*t1
     7         74*(t411-2*t299)-5.69973644720455d-1*t211*t297*t410+8.549
     8         604670806825d-1*t212*t304*t307+8.549604670806825d-1*t211*
     9         t298*t302)+t409+t407+t406+t405+t399+t398+t397+1.169644724
     :         5269297d+0*t169*t314+1.1696447245269297d+0*t178*t313+5.84
     ;         8223622634648d-1*t210*t308+5.848223622634648d-1*t213*t296
     <         )+t433+1.0d+0*t309)+t114*(4.693333333333333d-4*gammaaa*ga
     =         mmabb*t188*t228*t74*t75+9.216d-9*gammabb*t188*t227*t3*t31
     >         1*t71*t75-1.4079999999999998d-6*gammaaa*gammabb*t182*t188
     ?         *t228*t71*t75-3.072d-6*gammabb*t182*t188*t227*t3*t75-4.69
     @         3333333333333d-4*gammaaa*gammabb*t188*t228*t70*t74+1.1059
     1         200000000002d-10*gammabb*t188*t227*t3*t394*t70*t72-1.2672
     2         000000000003d-8*gammaaa*gammabb*t188*t228*t311*t70*t72-5.
     3         529600000000001d-8*gammabb*t188*t227*t3*t311*t70*t71+5.63
     4         1999999999999d-6*gammaaa*gammabb*t182*t188*t228*t70*t71+6
     5         .144000000000001d-6*gammabb*t182*t188*t227*t3*t70)+2*t181
     6         *t317+2*t183*t316+t215*t312+t216*t310)*wght+Amat3(iq,D3_R
     7         A_RA_RB)
            Amat3(iq,D3_RA_RB_RB) = 1.0d+0*(t77*(1.0d+0*t78*(5.848223622
     1         634648d-1*(t435+t434+t432+t430+t428+t427+t426+t425+t424+t
     2         423+t422+t420+t419+t418-80*t111*t168*t292-4*t103*t168*t28
     3         9+32*t164*t166*t168)*t94+5.848223622634648d-1*t112*(3.419
     4         84186832273d+0*t212*t299*t304*t90-3.41984186832273d+0*t21
     5         1*t298*t299*t90-1.5389288407452287d+1*t103*t177*t90+1.538
     6         9288407452287d+1*t103*t174*t90-5.69973644720455d-1*t176*t
     7         354*t413-5.69973644720455d-1*t173*t352*t410+8.54960467080
     8         6825d-1*t176*t304*t355+8.549604670806825d-1*t173*t298*t35
     9         3-5.129762802484096d+0*t177*t299+5.129762802484096d+0*t17
     :         4*t299)+t409+t407+t406+t405+t399+t398+t397+5.848223622634
     ;         648d-1*t169*t356+5.848223622634648d-1*t178*t351+1.1696447
     <         245269297d+0*t210*t314+1.1696447245269297d+0*t213*t313)+t
     =         433+1.0d+0*t357)+t114*(4.6933333333333327d-4*gammaaa*gamm
     >         abb*t119*t323*t74*t75+9.216d-9*gammaaa*t119*t311*t322*t37
     ?         *t71*t75-1.4079999999999998d-6*gammaaa*gammabb*t119*t182*
     @         t323*t71*t75-3.072d-6*gammaaa*t119*t182*t322*t37*t75-4.69
     1         33333333333327d-4*gammaaa*gammabb*t119*t323*t70*t74+1.105
     2         9200000000002d-10*gammaaa*t119*t322*t37*t394*t70*t72-1.26
     3         72d-8*gammaaa*gammabb*t119*t311*t323*t70*t72-5.5296000000
     4         00001d-8*gammaaa*t119*t311*t322*t37*t70*t71+5.632d-6*gamm
     5         aaa*gammabb*t119*t182*t323*t70*t71+6.144000000000001d-6*g
     6         ammaaa*t119*t182*t322*t37*t70)+t181*t359+t183*t358+2*t215
     7         *t317+2*t216*t316)*wght+Amat3(iq,D3_RA_RB_RB)
            Amat3(iq,D3_RB_RB_RB) = 1.0d+0*(t77*(1.0d+0*t78*(5.848223622
     1         634648d-1*(t436+t431+t430+t429+t428+t427+t426+t425+t424+t
     2         423+t422+t420+t419+t418-240*t111*t168*t292-12*t103*t168*t
     3         289+96*t164*t166*t168)*t94+5.848223622634648d-1*t112*(2.5
     4         64881401242048d+0*t174*(t415+t411)+2.564881401242048d+0*t
     5         177*(t414+t412)-5.69973644720455d-1*t212**3*t413-5.699736
     6         44720455d-1*t211**3*t410+2.5648814012420473d+0*t212*t304*
     7         t355+2.5648814012420473d+0*t211*t298*t353)+t409+t407+t406
     8         +t405+t399+t398+t397+1.7544670867903944d+0*t210*t356+1.75
     9         44670867903944d+0*t213*t351)-1.0d+0*rhob*t453+3.0d+0*t357
     :         -3.0d+0*t350)+1.0d+0*rhob*t69*(-9.125925925925926d+0*gamm
     ;         abb*t42*t441*t8+8.082962962962963d+0*t37*t40*t440*t8-2.16
     <         1777777777778d+0*t184*t185*t439*t8+1.8204444444444445d-1*
     =         t318*t319*t438*t8-9.90814814814815d+0*t2*t37*t40*t440+7.5
     >         56740740740742d+0*t184*t185*t2*t439-1.8432000000000004d+0
     ?         *t2*t318*t319*t438+1.456355555555556d-1*gammabb**5*t2*t43
     @         7/rhob**1.6333333333333333d+1)+t114*(-1.368888888888889d-
     1         1*gammabb*t441*t75*t76+4.106666666666667d-4*gammabb*t441*
     2         t71*t74*t75+1.4079999999999998d-3*t37*t440*t74*t75-4.224d
     3         -6*t182*t37*t440*t71*t75+9.216d-9*t184*t311*t439*t71*t75-
     4         3.072d-6*t182*t184*t439*t75-8.213333333333334d-4*gammabb*
     5         t441*t70*t71*t74-1.408d-3*t37*t440*t70*t74+2.464000000000
     6         0004d-6*gammabb*t182*t441*t70*t72-3.8016d-8*t311*t37*t440
     7         *t70*t72+1.1059200000000002d-10*t184*t394*t439*t70*t72+1.
     8         6896000000000003d-5*t182*t37*t440*t70*t71-5.5296000000000
     9         01d-8*t184*t311*t439*t70*t71+6.144000000000001d-6*t182*t1
     :         84*t439*t70)+3.0d+0*t324*t69+1.0d+0*rhob*t43*t453+3.0d+0*
     ;         t350*t43+3*t215*t359+3*t216*t358+3.0d+0*rhob*t189*t350+3.
     <         0d+0*rhob*t209*t324+6.0d+0*t189*t209)*wght+Amat3(iq,D3_RB
     =         _RB_RB)
            Cmat3(iq,D3_RA_RA_GAA) = 1.0d+0*(1.0d+0*rhoa*t36*(1.95555555
     1         55555554d+0*t228*t8*t9-2.311111111111111d+0*gammaaa*t227*
     2         t6*t8+7.253333333333334d-1*t116*t226*t3*t8-6.826666666666
     3         669d-2*t115*t224*t225*t8+2.7022222222222225d+0*gammaaa*t2
     4         *t227*t6-5.461333333333335d-2*t2*t223*t377/rhoa**1.533333
     5         3333333335d+1-2.3751111111111115d+0*t116*t2*t226*t3+6.400
     6         000000000001d-1*t115*t2*t224*t225)+t114*(2.93333333333333
     7         33d-2*t228*t75*t76-8.8d-5*t228*t71*t74*t75-4.32d-4*gammaa
     8         a*t227*t74*t75-3.456000000000001d-9*t226*t3*t311*t71*t75+
     9         1.296d-6*gammaaa*t182*t227*t71*t75+1.152d-6*t182*t226*t3*
     :         t75+1.76d-4*t228*t70*t71*t74+4.32d-4*gammaaa*t227*t70*t74
     ;         -4.1472000000000003d-11*t226*t3*t394*t70*t72+1.1664000000
     <         000001d-8*gammaaa*t227*t311*t70*t72-5.28d-7*t182*t228*t70
     =         *t72+2.0736000000000004d-8*t226*t3*t311*t70*t71-5.184d-6*
     >         gammaaa*t182*t227*t70*t71-2.3040000000000002d-6*t182*t226
     ?         *t3*t70)+2*t181*t362+2.0d+0*t36*t361+2.0d+0*rhoa*t140*t36
     @         1+t219*t310+1.0d+0*rhoa*t218*t255+2.0d+0*t140*t218)*wght+
     1         Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
            Cmat3(iq,D3_RA_RA_GBB) = 1.0d+0*(t114*(-1.76d-4*gammaaa*t228
     1         *t38*t74*t75-3.456000000000001d-9*t227*t3*t311*t38*t71*t7
     2         5+5.279999999999999d-7*gammaaa*t182*t228*t38*t71*t75+1.15
     3         2d-6*t182*t227*t3*t38*t75+1.76d-4*gammaaa*t228*t38*t70*t7
     4         4-4.1472000000000003d-11*t227*t3*t38*t394*t70*t72+4.75200
     5         0000000001d-9*gammaaa*t228*t311*t38*t70*t72+2.07360000000
     6         00004d-8*t227*t3*t311*t38*t70*t71-2.1120000000000003d-6*g
     7         ammaaa*t182*t228*t38*t70*t71-2.3040000000000002d-6*t182*t
     8         227*t3*t38*t70)+2*t181*t363+t222*t310)*wght+Cmat3(iq,D3_R
     9         A_RA_GBB)
            Cmat3(iq,D3_RA_RB_GAA) = 1.0d+0*(t114*(-1.28d-4*gammabb*t119
     1         *t188*t74*t75-3.456000000000001d-9*gammaaa*gammabb*t118*t
     2         188*t311*t71*t75+3.84d-7*gammabb*t119*t182*t188*t71*t75+1
     3         .152d-6*gammaaa*gammabb*t118*t182*t188*t75+1.28d-4*gammab
     4         b*t119*t188*t70*t74-4.1472000000000003d-11*gammaaa*gammab
     5         b*t118*t188*t394*t70*t72+3.456000000000001d-9*gammabb*t11
     6         9*t188*t311*t70*t72+2.0736000000000004d-8*gammaaa*gammabb
     7         *t118*t188*t311*t70*t71-1.5360000000000001d-6*gammabb*t11
     8         9*t182*t188*t70*t71-2.3040000000000002d-6*gammaaa*gammabb
     9         *t118*t182*t188*t70)+t181*t364+t215*t362+t219*t316)*wght+
     :         Cmat3(iq,D3_RA_RB_GAA)
            Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
            Cmat3(iq,D3_RA_RB_GBB) = 1.0d+0*(t114*(-1.28d-4*gammaaa*t119
     1         *t188*t74*t75-3.456000000000001d-9*gammaaa*gammabb*t119*t
     2         187*t311*t71*t75+3.84d-7*gammaaa*t119*t182*t188*t71*t75+1
     3         .152d-6*gammaaa*gammabb*t119*t182*t187*t75+1.28d-4*gammaa
     4         a*t119*t188*t70*t74-4.1472000000000003d-11*gammaaa*gammab
     5         b*t119*t187*t394*t70*t72+3.456000000000001d-9*gammaaa*t11
     6         9*t188*t311*t70*t72+2.0736000000000004d-8*gammaaa*gammabb
     7         *t119*t187*t311*t70*t71-1.5360000000000001d-6*gammaaa*t11
     8         9*t182*t188*t70*t71-2.3040000000000002d-6*gammaaa*gammabb
     9         *t119*t182*t187*t70)+t181*t367+t215*t363+t222*t316)*wght+
     :         Cmat3(iq,D3_RA_RB_GBB)
            Cmat3(iq,D3_RB_RB_GAA) = 1.0d+0*(t114*(-1.76d-4*gammabb*t323
     1         *t4*t74*t75-3.456000000000001d-9*t311*t322*t37*t4*t71*t75
     2         +5.279999999999999d-7*gammabb*t182*t323*t4*t71*t75+1.152d
     3         -6*t182*t322*t37*t4*t75+1.76d-4*gammabb*t323*t4*t70*t74-4
     4         .1472000000000003d-11*t322*t37*t394*t4*t70*t72+4.75200000
     5         0000001d-9*gammabb*t311*t323*t4*t70*t72+2.073600000000000
     6         4d-8*t311*t322*t37*t4*t70*t71-2.1120000000000003d-6*gamma
     7         bb*t182*t323*t4*t70*t71-2.3040000000000002d-6*t182*t322*t
     8         37*t4*t70)+2*t215*t364+t219*t358)*wght+Cmat3(iq,D3_RB_RB_
     9         GAA)
            Cmat3(iq,D3_RB_RB_GAB) = Cmat3(iq,D3_RB_RB_GAB)
            Cmat3(iq,D3_RB_RB_GBB) = 1.0d+0*(1.0d+0*rhob*t69*(1.95555555
     1         55555554d+0*t323*t42*t8-2.311111111111111d+0*gammabb*t322
     2         *t40*t8+7.253333333333334d-1*t185*t321*t37*t8-6.826666666
     3         666669d-2*t184*t319*t320*t8-5.461333333333335d-2*t2*t318*
     4         t437/rhob**1.5333333333333335d+1+2.7022222222222225d+0*ga
     5         mmabb*t2*t322*t40-2.3751111111111115d+0*t185*t2*t321*t37+
     6         6.400000000000001d-1*t184*t2*t319*t320)+t114*(2.933333333
     7         3333333d-2*t323*t75*t76-8.8d-5*t323*t71*t74*t75-4.32d-4*g
     8         ammabb*t322*t74*t75-3.456000000000001d-9*t311*t321*t37*t7
     9         1*t75+1.296d-6*gammabb*t182*t322*t71*t75+1.152d-6*t182*t3
     :         21*t37*t75+1.76d-4*t323*t70*t71*t74+4.32d-4*gammabb*t322*
     ;         t70*t74-4.1472000000000003d-11*t321*t37*t394*t70*t72-5.28
     <         d-7*t182*t323*t70*t72+1.1664000000000001d-8*gammabb*t311*
     =         t322*t70*t72+2.0736000000000004d-8*t311*t321*t37*t70*t71-
     >         5.184d-6*gammabb*t182*t322*t70*t71-2.3040000000000002d-6*
     ?         t182*t321*t37*t70)+2.0d+0*t366*t69+2*t215*t367+2.0d+0*rho
     @         b*t209*t366+t222*t358+1.0d+0*rhob*t221*t350+2.0d+0*t209*t
     1         221)*wght+Cmat3(iq,D3_RB_RB_GBB)
            Cmat3(iq,D3_RA_GAA_GAA) = 1.0d+0*(1.0d+0*rhoa*t36*(4.2666666
     1         66666667d-1*t118*t6*t8+2.5600000000000006d-2*t224*t3*t360
     2         *t8-2.1333333333333335d-1*gammaaa*t116*t117*t8-4.26666666
     3         66666675d-1*t118*t2*t6+2.048000000000001d-2*t115*t2*t377/
     4         rhoa**1.4333333333333334d+1-2.0480000000000004d-1*t2*t224
     5         *t3*t360+5.973333333333335d-1*gammaaa*t116*t117*t2)+t114*
     6         (9.600000000000001d-5*t118*t74*t75+1.2960000000000002d-9*
     7         gammaaa*t117*t311*t71*t75-2.8800000000000003d-7*t118*t182
     8         *t71*t75-4.3200000000000005d-7*gammaaa*t117*t182*t75-9.60
     9         0000000000001d-5*t118*t70*t74+1.5552000000000005d-11*gamm
     :         aaa*t117*t394*t70*t72-2.5920000000000004d-9*t118*t311*t70
     ;         *t72-7.776000000000002d-9*gammaaa*t117*t311*t70*t71+1.152
     <         0000000000001d-6*t118*t182*t70*t71+8.640000000000001d-7*g
     =         ammaaa*t117*t182*t70)+t181*t370+1.0d+0*t36*t369+1.0d+0*rh
     >         oa*t140*t369)*wght+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
            Cmat3(iq,D3_RA_GAA_GBB) = 1.0d+0*(t114*(4.8000000000000004d-
     1         5*t119*t38*t74*t75+1.2960000000000002d-9*gammaaa*t118*t31
     2         1*t38*t71*t75-1.4400000000000002d-7*t119*t182*t38*t71*t75
     3         -4.3200000000000005d-7*gammaaa*t118*t182*t38*t75-4.800000
     4         0000000004d-5*t119*t38*t70*t74+1.5552000000000005d-11*gam
     5         maaa*t118*t38*t394*t70*t72-1.2960000000000002d-9*t119*t31
     6         1*t38*t70*t72-7.776000000000002d-9*gammaaa*t118*t311*t38*
     7         t70*t71+5.760000000000001d-7*t119*t182*t38*t70*t71+8.6400
     8         00000000001d-7*gammaaa*t118*t182*t38*t70)+t181*t454)*wght
     9         +Cmat3(iq,D3_RA_GAA_GBB)
            Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
            Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
            Cmat3(iq,D3_RA_GBB_GBB) = 1.0d+0*(t114*(1.2960000000000002d-
     1         9*gammaaa*t119*t311*t41*t71*t75-4.3200000000000005d-7*gam
     2         maaa*t119*t182*t41*t75+1.5552000000000005d-11*gammaaa*t11
     3         9*t394*t41*t70*t72-7.776000000000002d-9*gammaaa*t119*t311
     4         *t41*t70*t71+8.640000000000001d-7*gammaaa*t119*t182*t41*t
     5         70)+t181*t376)*wght+Cmat3(iq,D3_RA_GBB_GBB)
            Cmat3(iq,D3_RB_GAA_GAA) = 1.0d+0*(t114*(1.2960000000000002d-
     1         9*gammabb*t188*t311*t7*t71*t75-4.3200000000000005d-7*gamm
     2         abb*t182*t188*t7*t75+1.5552000000000005d-11*gammabb*t188*
     3         t394*t7*t70*t72-7.776000000000002d-9*gammabb*t188*t311*t7
     4         *t70*t71+8.640000000000001d-7*gammabb*t182*t188*t7*t70)+t
     5         215*t370)*wght+Cmat3(iq,D3_RB_GAA_GAA)
            Cmat3(iq,D3_RB_GAA_GAB) = Cmat3(iq,D3_RB_GAA_GAB)
            Cmat3(iq,D3_RB_GAA_GBB) = 1.0d+0*(t114*(4.8000000000000004d-
     1         5*t188*t4*t74*t75+1.2960000000000002d-9*gammabb*t187*t311
     2         *t4*t71*t75-1.4400000000000002d-7*t182*t188*t4*t71*t75-4.
     3         3200000000000005d-7*gammabb*t182*t187*t4*t75-4.8000000000
     4         000004d-5*t188*t4*t70*t74+1.5552000000000005d-11*gammabb*
     5         t187*t394*t4*t70*t72-1.2960000000000002d-9*t188*t311*t4*t
     6         70*t72-7.776000000000002d-9*gammabb*t187*t311*t4*t70*t71+
     7         5.760000000000001d-7*t182*t188*t4*t70*t71+8.6400000000000
     8         01d-7*gammabb*t182*t187*t4*t70)+t215*t454)*wght+Cmat3(iq,
     9         D3_RB_GAA_GBB)
            Cmat3(iq,D3_RB_GAB_GAB) = Cmat3(iq,D3_RB_GAB_GAB)
            Cmat3(iq,D3_RB_GAB_GBB) = Cmat3(iq,D3_RB_GAB_GBB)
            Cmat3(iq,D3_RB_GBB_GBB) = 1.0d+0*(1.0d+0*rhob*t69*(4.2666666
     1         66666667d-1*t187*t40*t8+2.5600000000000006d-2*t319*t365*t
     2         37*t8-2.1333333333333335d-1*gammabb*t185*t186*t8+2.048000
     3         000000001d-2*t184*t2*t437/rhob**1.4333333333333334d+1-4.2
     4         666666666666675d-1*t187*t2*t40-2.0480000000000004d-1*t2*t
     5         319*t365*t37+5.973333333333335d-1*gammabb*t185*t186*t2)+t
     6         114*(9.600000000000001d-5*t187*t74*t75+1.2960000000000002
     7         d-9*gammabb*t186*t311*t71*t75-2.8800000000000003d-7*t182*
     8         t187*t71*t75-4.3200000000000005d-7*gammabb*t182*t186*t75-
     9         9.600000000000001d-5*t187*t70*t74+1.5552000000000005d-11*
     :         gammabb*t186*t394*t70*t72-2.5920000000000004d-9*t187*t311
     ;         *t70*t72-7.776000000000002d-9*gammabb*t186*t311*t70*t71+1
     <         .1520000000000001d-6*t182*t187*t70*t71+8.640000000000001d
     =         -7*gammabb*t182*t186*t70)+1.0d+0*t375*t69+t215*t376+1.0d+
     >         0*rhob*t209*t375)*wght+Cmat3(iq,D3_RB_GBB_GBB)
            Cmat3(iq,D3_GAA_GAA_GAA) = 1.0d+0*(1.0d+0*rhoa*t36*(-9.60000
     1         0000000004d-3*gammaaa*t224*t368*t8+4.8000000000000015d-2*
     2         t116*t217*t8-7.680000000000003d-3*t2*t3*t377/rhoa**1.3333
     3         333333333333d+1+5.760000000000003d-2*gammaaa*t2*t224*t368
     4         -9.600000000000003d-2*t116*t2*t217)+t114*(-4.860000000000
     5         001d-10*t217*t311*t71*t75+1.62d-7*t182*t217*t75-5.832d-12
     6         *t217*t394*t70*t72+2.916d-9*t217*t311*t70*t71-3.24d-7*t18
     7         2*t217*t70))*wght+Cmat3(iq,D3_GAA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
            Cmat3(iq,D3_GAA_GAA_GBB) = 1.0d+0*t114*(t311*t38*t7*(2.916d-
     1         9*t70*t71-4.860000000000001d-10*t71*t75)+t182*t38*t7*(1.6
     2         2d-7*t75-3.24d-7*t70)-5.832d-12*t38*t394*t7*t70*t72)*wght
     3         +Cmat3(iq,D3_GAA_GAA_GBB)
            Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
            Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
            Cmat3(iq,D3_GAA_GBB_GBB) = 1.0d+0*t114*(t182*t38*t4*(5.4d-8*
     1         t38*t75-2.16d-7*t38*t70)-5.832d-12*t394*t4*t41*t70*t72+t3
     2         11*t4*t41*(9.720000000000002d-10*t70*t71-9.00000000000000
     3         1d-3*t373)-6.0d-3*t182*t372*t4*t41)*wght+Cmat3(iq,D3_GAA_
     4         GBB_GBB)
            Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
            Cmat3(iq,D3_GAB_GAB_GBB) = Cmat3(iq,D3_GAB_GAB_GBB)
            Cmat3(iq,D3_GAB_GBB_GBB) = Cmat3(iq,D3_GAB_GBB_GBB)
            Cmat3(iq,D3_GBB_GBB_GBB) = 1.0d+0*(1.0d+0*rhob*t69*(-9.60000
     1         0000000004d-3*gammabb*t319*t374*t8+4.8000000000000015d-2*
     2         t185*t220*t8-7.680000000000003d-3*t2*t37*t437/rhob**1.333
     3         3333333333333d+1+5.760000000000003d-2*gammabb*t2*t319*t37
     4         4-9.600000000000003d-2*t185*t2*t220)+t114*(-4.86000000000
     5         0001d-10*t220*t311*t71*t75+1.62d-7*t182*t220*t75-5.832d-1
     6         2*t220*t394*t70*t72+2.916d-9*t220*t311*t70*t71-3.24d-7*t1
     7         82*t220*t70))*wght+Cmat3(iq,D3_GBB_GBB_GBB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = param(6)
            t2 = gammaaa**2
            t3 = 1/rhoa**2.6666666666666666d+0
            t4 = 2.0d-1*gammaaa*t3+1.0d+0
            t5 = 1/t4**2
            t6 = 1/rhoa**5.333333333333333d+0
            t7 = param(4)
            t8 = 1/t4
            t9 = 2.0d-1*gammaaa*t3*t7*t8+4.000000000000001d-2*t1*t2*t5*t
     1         6+param(2)
            t10 = rhoa**3.333333333333333d-1
            t11 = t10**5.0d-1
            t12 = 1/t11
            t13 = 1.530901310039024d-2*t12+1.0465751434d-1
            t14 = 7.876233178997433d-1*t12*t13+1.9269083139d-1
            t15 = 7.876233178997433d-1*t12*t14+4.3896648423d-1
            t16 = 1/t15
            t17 = 1.269642451250142d+0*t11*t16+1.0d+0
            t18 = log(t17)
            t19 = 1/t10
            t20 = 1.2746961887000874d-1*t19+1.0d+0
            t21 = 2.4141993114533214d-2*t12+1.0186556948d-1
            t22 = 7.876233178997433d-1*t12*t21+2.2308199064d-1
            t23 = 7.876233178997433d-1*t12*t22+4.7231125998d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t11*t24+1.0d+0
            t26 = log(t25)
            t27 = 1.325688999052018d-1*t19+1.0d+0
            t28 = 1.3212998810398843d-2*t12+2.9729725188d-2
            t29 = 7.876233178997433d-1*t12*t28+1.2236585478d-1
            t30 = 7.876233178997433d-1*t12*t29+3.497952466d-1
            t31 = 1/t30
            t32 = 1.269642451250142d+0*t11*t31+1.0d+0
            t33 = log(t32)
            t34 = 6.901399211255826d-2*t19+1.0d+0
            t35 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t26*t27-3.10907d-2*t18*t20)-3.37738d-2*t33*t34)+
     2         3.37738d-2*t33*t34)-6.21814d-2*t26*t27
            t36 = gammaaa**3
            t37 = 1/t4**3
            t38 = 1/rhoa**9
            t39 = 1/rhoa**6.333333333333333d+0
            t40 = 1/rhoa**3.6666666666666664d+0
            t41 = -5.333333333333333d-1*gammaaa*t40*t7*t8+1.066666666666
     1         6667d-1*t2*t39*t5*t7-2.1333333333333337d-1*t1*t2*t39*t5+4
     2         .2666666666666675d-2*t1*t36*t37*t38
            t42 = 1/rhoa**1.3333333333333333d+0
            t43 = 1/t17
            t44 = 1/t15**2
            t45 = 1/rhoa**1.3333333333333336d+0
            t46 = 1/t11**3
            t47 = 1/rhoa**6.666666666666667d-1
            t48 = -1.3127055298329054d-1*t13*t46*t47-2.0096226153166658d
     1         -3*t45
            t49 = 7.876233178997433d-1*t12*t48-1.3127055298329054d-1*t14
     1         *t46*t47
            t50 = 2.11607075208357d-1*t12*t16*t47-1.269642451250142d+0*t
     1         11*t44*t49
            t51 = 1/t25
            t52 = 1/t23**2
            t53 = -1.3127055298329054d-1*t21*t46*t47-3.169132786263567d-
     1         3*t45
            t54 = 7.876233178997433d-1*t12*t53-1.3127055298329054d-1*t22
     1         *t46*t47
            t55 = 2.11607075208357d-1*t12*t24*t47-1.269642451250142d+0*t
     1         11*t52*t54
            t56 = 1/t32
            t57 = 1/t30**2
            t58 = -1.3127055298329054d-1*t28*t46*t47-1.7344776604086162d
     1         -3*t45
            t59 = 7.876233178997433d-1*t12*t58-1.3127055298329054d-1*t29
     1         *t46*t47
            t60 = 2.11607075208357d-1*t12*t31*t47-1.269642451250142d+0*t
     1         11*t57*t59
            t61 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t34*t56*t60+
     1         1.709920934161365d+0*(6.21814d-2*t27*t51*t55-3.10907d-2*t
     2         20*t43*t50-2.747773264188438d-3*t26*t42+1.321039893133926
     3         5d-3*t18*t42)+7.769549222703733d-4*t33*t42)+3.37738d-2*t3
     4         4*t56*t60-7.769549222703733d-4*t33*t42)-6.21814d-2*t27*t5
     5         1*t55+2.747773264188438d-3*t26*t42
            t62 = 1/rhoa**8
            t63 = -1.6000000000000003d-2*t1*t2*t37*t62
            t64 = 8.000000000000002d-2*gammaaa*t1-4.000000000000001d-2*g
     1         ammaaa*t7
            t65 = 2.0d-1*t3*t7*t8
            t66 = gammaaa**4
            t67 = 1/t4**4
            t68 = 1/rhoa**1.2666666666666665d+1
            t69 = 1/rhoa**10
            t70 = 1/rhoa**7.333333333333333d+0
            t71 = 1/rhoa**4.666666666666667d+0
            t72 = 1.9555555555555554d+0*gammaaa*t7*t71*t8-9.6d-1*t2*t5*t
     1         7*t70+1.3511111111111113d+0*t1*t2*t5*t70+1.13777777777777
     2         78d-1*t36*t37*t69*t7-6.115555555555556d-1*t1*t36*t37*t69+
     3         6.826666666666669d-2*t1*t66*t67*t68
            t73 = 1/rhoa**2.333333333333333d+0
            t74 = 1/t17**2
            t75 = t50**2
            t76 = 1/t15**3
            t77 = t49**2
            t78 = 1/rhoa**2.3333333333333334d+0
            t79 = 1/rhoa**1.6666666666666669d+0
            t80 = 1/t11**5
            t81 = 6.563527649164527d-2*t13*t45*t80+8.751370198886037d-2*
     1         t13*t46*t79+3.0144339229749983d-3*t78
            t82 = 7.876233178997433d-1*t12*t81+6.563527649164527d-2*t14*
     1         t45*t80+8.751370198886037d-2*t14*t46*t79-2.62541105966581
     2         1d-1*t46*t47*t48
            t83 = -1.269642451250142d+0*t11*t44*t82-1.4107138347223802d-
     1         1*t12*t16*t79+2.539284902500284d+0*t11*t76*t77-4.23214150
     2         416714d-1*t12*t44*t47*t49-3.52678458680595d-2*t16*t45*t46
            t84 = 1/t25**2
            t85 = t55**2
            t86 = 1/t23**3
            t87 = t54**2
            t88 = 6.563527649164527d-2*t21*t45*t80+8.751370198886037d-2*
     1         t21*t46*t79+4.753699179395351d-3*t78
            t89 = 7.876233178997433d-1*t12*t88+6.563527649164527d-2*t22*
     1         t45*t80+8.751370198886037d-2*t22*t46*t79-2.62541105966581
     2         1d-1*t46*t47*t53
            t90 = -1.269642451250142d+0*t11*t52*t89+2.539284902500284d+0
     1         *t11*t86*t87-1.4107138347223802d-1*t12*t24*t79-4.23214150
     2         416714d-1*t12*t47*t52*t54-3.52678458680595d-2*t24*t45*t46
            t91 = 1/t32**2
            t92 = t60**2
            t93 = 1/t30**3
            t94 = t59**2
            t95 = 6.563527649164527d-2*t28*t45*t80+8.751370198886037d-2*
     1         t28*t46*t79+2.601716490612924d-3*t78
            t96 = 7.876233178997433d-1*t12*t95+6.563527649164527d-2*t29*
     1         t45*t80+8.751370198886037d-2*t29*t46*t79-2.62541105966581
     2         1d-1*t46*t47*t58
            t97 = -1.269642451250142d+0*t11*t57*t96+2.539284902500284d+0
     1         *t11*t93*t94-1.4107138347223802d-1*t12*t31*t79-4.23214150
     2         416714d-1*t12*t47*t57*t59-3.52678458680595d-2*t31*t45*t46
            t98 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t34*t56*t97+
     1         3.37738d-2*t34*t91*t92+1.709920934161365d+0*(6.21814d-2*t
     2         27*t51*t90-6.21814d-2*t27*t84*t85-3.10907d-2*t20*t43*t83+
     3         3.10907d-2*t20*t74*t75+3.663697685584584d-3*t26*t73-1.761
     4         3865241785687d-3*t18*t73-5.495546528376876d-3*t42*t51*t55
     5         +2.642079786267853d-3*t42*t43*t50)-1.0359398963604977d-3*
     6         t33*t73+1.5539098445407465d-3*t42*t56*t60)+3.37738d-2*t34
     7         *t56*t97-3.37738d-2*t34*t91*t92+1.0359398963604977d-3*t33
     8         *t73-1.5539098445407465d-3*t42*t56*t60)-6.21814d-2*t27*t5
     9         1*t90+6.21814d-2*t27*t84*t85-3.663697685584584d-3*t26*t73
     :         +5.495546528376876d-3*t42*t51*t55
            t99 = -4.000000000000001d-2*gammaaa*t5*t6*t7+t65+t63+8.00000
     1         0000000002d-2*gammaaa*t1*t5*t6
            t100 = 1/rhoa**1.1666666666666665d+1
            t101 = -5.333333333333333d-1*t40*t7*t8+3.2d-1*gammaaa*t39*t5
     1         *t7-4.2666666666666675d-2*t2*t37*t38*t7-2.560000000000000
     2         6d-2*t1*t100*t36*t67-4.2666666666666675d-1*gammaaa*t1*t39
     3         *t5+2.1333333333333337d-1*t1*t2*t37*t38
            t102 = 1/rhoa**1.0666666666666666d+1
            t103 = 9.600000000000004d-3*t1*t102*t2*t67
            t104 = -4.0d-1*t64-3.2000000000000006d-2*gammaaa*t1
            t105 = 8.000000000000002d-2*t1
            t106 = t105-8.000000000000002d-2*t7
            t107 = 1/t4**5
            t108 = 1/rhoa**1.3666666666666666d+1
            t109 = 1/rhoa**11
            t110 = 1/rhoa**8.333333333333334d+0
            t111 = 1/rhoa**3.333333333333333d+0
            t112 = 1/rhoa**3.3333333333333337d+0
            t113 = 1/rhoa**2.666666666666667d+0
            t114 = 1/t11**7
            t115 = 1/rhoa**2.0d+0
            t116 = 1/t25**3
            t117 = t55**3
            t118 = 7.617854707500852d+0*t11*t54*t86*t89-6.34821225625071
     1         d-1*t12*t47*t52*t89-1.269642451250142d+0*t11*t52*(-3.9381
     2         165894987163d-1*t46*t47*t88+7.876233178997433d-1*t12*(-1.
     3         3127055298329054d-1*t21*t78*t80-1.4585616998143394d-1*t11
     4         3*t21*t46-5.469606374303773d-2*t114*t115*t21-1.1708185015
     5         918181d-2*t112)-1.3127055298329054d-1*t22*t78*t80+1.96905
     6         82947493582d-1*t45*t53*t80+2.625411059665811d-1*t46*t53*t
     7         79-1.4585616998143394d-1*t113*t22*t46-5.469606374303773d-
     8         2*t114*t115*t22)+1.269642451250142d+0*t12*t47*t86*t87+1.7
     9         63392293402975d-2*t115*t24*t80+4.2321415041671406d-1*t12*
     :         t52*t54*t79+7.053569173611901d-2*t24*t46*t78-7.6178547075
     ;         00852d+0*t11*t54**3/t23**4+1.0580353760417849d-1*t45*t46*
     <         t52*t54+2.3511897245373004d-1*t113*t12*t24
            t119 = 1/t32**3
            t120 = t60**3
            t121 = 7.617854707500852d+0*t11*t59*t93*t96-6.34821225625071
     1         d-1*t12*t47*t57*t96-1.269642451250142d+0*t11*t57*(-3.9381
     2         165894987163d-1*t46*t47*t95+7.876233178997433d-1*t12*(-1.
     3         3127055298329054d-1*t28*t78*t80-1.4585616998143394d-1*t11
     4         3*t28*t46-5.469606374303773d-2*t114*t115*t28-6.4079313565
     5         09611d-3*t112)-1.3127055298329054d-1*t29*t78*t80+1.969058
     6         2947493582d-1*t45*t58*t80+2.625411059665811d-1*t46*t58*t7
     7         9-1.4585616998143394d-1*t113*t29*t46-5.469606374303773d-2
     8         *t114*t115*t29)+1.269642451250142d+0*t12*t47*t93*t94+1.76
     9         3392293402975d-2*t115*t31*t80+4.2321415041671406d-1*t12*t
     :         57*t59*t79+7.053569173611901d-2*t31*t46*t78-7.61785470750
     ;         0852d+0*t11*t59**3/t30**4+1.0580353760417849d-1*t45*t46*t
     <         57*t59+2.3511897245373004d-1*t113*t12*t31
            t122 = 1.6000000000000003d-2*gammaaa*t37*t62*t7-8.0000000000
     1         00002d-2*t5*t6*t7-6.400000000000001d-2*gammaaa*t1*t37*t62
     2         +8.000000000000002d-2*t1*t5*t6+t103
            fnc(iq) = 1.0d+0*rhoa*t35*t9*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*rhoa*t61*t9*wght+1.0d+0*t35*t9*wght+
     1         1.0d+0*rhoa*t35*t41*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.0d+0*rhoa*t35*(t65+t5*t6*t64+t63)*wght+C
     1         mat(iq,D1_GAA)
            Amat2(iq,D2_RA_RA) = 1.0d+0*rhoa*t9*t98*wght+2.0d+0*t61*t9*w
     1         ght+1.0d+0*rhoa*t35*t72*wght+2.0d+0*rhoa*t41*t61*wght+2.0
     2         d+0*t35*t41*wght+Amat2(iq,D2_RA_RA)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*rhoa*t61*t99*wght+1.0d+0*t35*t9
     1         9*wght+1.0d+0*rhoa*t101*t35*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_GAA_GAA) = 1.0d+0*rhoa*t35*(t104*t37*t62+t106*t5
     1         *t6+t103)*wght+Cmat2(iq,D2_GAA_GAA)
            Amat3(iq,D3_RA_RA_RA) = 3.0d+0*t9*t98*wght+3.0d+0*rhoa*t41*t
     1         98*wght+1.0d+0*rhoa*t9*(5.848223622634643d-1*(1.0d+0*(1.0
     2         13214d-1*t34*t60*t91*t97+2.33086476681112d-3*t42*t56*t97-
     3         2.33086476681112d-3*t42*t91*t92+1.709920934161365d+0*(-1.
     4         865442d-1*t27*t55*t84*t90-8.243319792565315d-3*t42*t51*t9
     5         0+8.243319792565315d-3*t42*t84*t85+9.327209999999999d-2*t
     6         20*t50*t74*t83+3.96311967940178d-3*t42*t43*t83-3.10907d-2
     7         *t20*t43*(7.617854707500852d+0*t11*t49*t76*t82-6.34821225
     8         625071d-1*t12*t44*t47*t82-1.269642451250142d+0*t11*t44*(-
     9         3.9381165894987163d-1*t46*t47*t81+7.876233178997433d-1*t1
     :         2*(-1.3127055298329054d-1*t13*t78*t80-1.4585616998143394d
     ;         -1*t113*t13*t46-5.469606374303773d-2*t114*t115*t13-7.4244
     <         39106586571d-3*t112)-1.3127055298329054d-1*t14*t78*t80+1.
     =         9690582947493582d-1*t45*t48*t80+2.625411059665811d-1*t46*
     >         t48*t79-1.4585616998143394d-1*t113*t14*t46-5.469606374303
     ?         773d-2*t114*t115*t14)+1.763392293402975d-2*t115*t16*t80+4
     @         .2321415041671406d-1*t12*t44*t49*t79+7.053569173611901d-2
     1         *t16*t46*t78+1.269642451250142d+0*t12*t47*t76*t77-7.61785
     2         4707500852d+0*t11*t49**3/t15**4+1.0580353760417849d-1*t44
     3         *t45*t46*t49+2.3511897245373004d-1*t113*t12*t16)-3.963119
     4         67940178d-3*t42*t74*t75+1.0991093056753751d-2*t51*t55*t73
     5         -5.284159572535706d-3*t43*t50*t73+6.21814d-2*t118*t27*t51
     6         -6.21814d-2*t20*t50**3/t17**3+1.243628d-1*t116*t117*t27-8
     7         .548627933030694d-3*t111*t26+4.1099018897499934d-3*t111*t
     8         18)-3.107819689081493d-3*t56*t60*t73-3.37738d-2*t121*t34*
     9         t56-6.75476d-2*t119*t120*t34+2.4171930915078277d-3*t111*t
     :         33)-1.013214d-1*t34*t60*t91*t97-2.33086476681112d-3*t42*t
     ;         56*t97+2.33086476681112d-3*t42*t91*t92+3.107819689081493d
     <         -3*t56*t60*t73+3.37738d-2*t121*t34*t56+6.75476d-2*t119*t1
     =         20*t34-2.4171930915078277d-3*t111*t33)+1.865442d-1*t27*t5
     >         5*t84*t90+8.243319792565315d-3*t42*t51*t90-8.243319792565
     ?         315d-3*t42*t84*t85-1.0991093056753751d-2*t51*t55*t73-6.21
     @         814d-2*t118*t27*t51-1.243628d-1*t116*t117*t27+8.548627933
     1         030694d-3*t111*t26)*wght+1.0d+0*rhoa*t35*(-9.125925925925
     2         926d+0*gammaaa*t7*t8/rhoa**5.666666666666667d+0+1.8204444
     3         444444445d-1*t108*t66*t67*t7+8.082962962962963d+0*t110*t2
     4         *t5*t7-2.161777777777778d+0*t109*t36*t37*t7-1.84320000000
     5         00004d+0*t1*t108*t66*t67-9.90814814814815d+0*t1*t110*t2*t
     6         5+7.556740740740742d+0*t1*t109*t36*t37+1.456355555555556d
     7         -1*gammaaa**5*t1*t107/rhoa**1.6333333333333333d+1)*wght+3
     8         .0d+0*rhoa*t61*t72*wght+3.0d+0*t35*t72*wght+6.0d+0*t41*t6
     9         1*wght+Amat3(iq,D3_RA_RA_RA)
            Cmat3(iq,D3_RA_RA_GAA) = 1.0d+0*rhoa*t98*t99*wght+2.0d+0*t61
     1         *t99*wght+1.0d+0*rhoa*t35*(1.9555555555555554d+0*t7*t71*t
     2         8-2.311111111111111d+0*gammaaa*t5*t7*t70+2.70222222222222
     3         25d+0*gammaaa*t1*t5*t70+7.253333333333334d-1*t2*t37*t69*t
     4         7-6.826666666666669d-2*t36*t67*t68*t7-2.3751111111111115d
     5         +0*t1*t2*t37*t69+6.400000000000001d-1*t1*t36*t67*t68-5.46
     6         1333333333335d-2*t1*t107*t66/rhoa**1.5333333333333335d+1)
     7         *wght+2.0d+0*rhoa*t101*t61*wght+2.0d+0*t101*t35*wght+Cmat
     8         3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_GAA_GAA) = 1.0d+0*rhoa*t35*(2.560000000000000
     1         6d-2*t100*t2*t67*t7+4.266666666666667d-1*t39*t5*t7-2.1333
     2         333333333335d-1*gammaaa*t37*t38*t7-2.0480000000000004d-1*
     3         t1*t100*t2*t67-4.2666666666666675d-1*t1*t39*t5+5.97333333
     4         3333335d-1*gammaaa*t1*t37*t38+2.048000000000001d-2*t1*t10
     5         7*t36/rhoa**1.4333333333333334d+1)*wght+1.0d+0*rhoa*t122*
     6         t61*wght+1.0d+0*t122*t35*wght+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAA) = 1.0d+0*rhoa*t35*(t37*t62*(-4.0d-1
     1         *(t105-4.000000000000001d-2*t7)-4.0d-1*t106-3.20000000000
     2         00006d-2*t1)+t102*(1.920000000000001d-2*gammaaa*t1-6.0000
     3         00000000001d-1*t104)*t67-7.680000000000003d-3*t1*t107*t2/
     4         rhoa**1.3333333333333333d+1)*wght+Cmat3(iq,D3_GAA_GAA_GAA
     5         )
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = param(6)
            t2 = gammabb**2
            t3 = 1/rhob**2.6666666666666666d+0
            t4 = 2.0d-1*gammabb*t3+1.0d+0
            t5 = 1/t4**2
            t6 = 1/rhob**5.333333333333333d+0
            t7 = param(4)
            t8 = 1/t4
            t9 = 2.0d-1*gammabb*t3*t7*t8+4.000000000000001d-2*t1*t2*t5*t
     1         6+param(2)
            t10 = rhob**3.333333333333333d-1
            t11 = t10**5.0d-1
            t12 = 1/t11
            t13 = 1.530901310039024d-2*t12+1.0465751434d-1
            t14 = 7.876233178997433d-1*t12*t13+1.9269083139d-1
            t15 = 7.876233178997433d-1*t12*t14+4.3896648423d-1
            t16 = 1/t15
            t17 = 1.269642451250142d+0*t11*t16+1.0d+0
            t18 = log(t17)
            t19 = 1/t10
            t20 = 1.2746961887000874d-1*t19+1.0d+0
            t21 = 2.4141993114533214d-2*t12+1.0186556948d-1
            t22 = 7.876233178997433d-1*t12*t21+2.2308199064d-1
            t23 = 7.876233178997433d-1*t12*t22+4.7231125998d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t11*t24+1.0d+0
            t26 = log(t25)
            t27 = 1.325688999052018d-1*t19+1.0d+0
            t28 = 1.3212998810398843d-2*t12+2.9729725188d-2
            t29 = 7.876233178997433d-1*t12*t28+1.2236585478d-1
            t30 = 7.876233178997433d-1*t12*t29+3.497952466d-1
            t31 = 1/t30
            t32 = 1.269642451250142d+0*t11*t31+1.0d+0
            t33 = log(t32)
            t34 = 6.901399211255826d-2*t19+1.0d+0
            t35 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t26*t27-3.10907d-2*t18*t20)-3.37738d-2*t33*t34)+
     2         3.37738d-2*t33*t34)-6.21814d-2*t26*t27
            t36 = gammabb**3
            t37 = 1/t4**3
            t38 = 1/rhob**9
            t39 = 1/rhob**6.333333333333333d+0
            t40 = 1/rhob**3.6666666666666664d+0
            t41 = -5.333333333333333d-1*gammabb*t40*t7*t8+1.066666666666
     1         6667d-1*t2*t39*t5*t7-2.1333333333333337d-1*t1*t2*t39*t5+4
     2         .2666666666666675d-2*t1*t36*t37*t38
            t42 = 1/rhob**1.3333333333333333d+0
            t43 = 1/t17
            t44 = 1/t15**2
            t45 = 1/rhob**1.3333333333333336d+0
            t46 = 1/t11**3
            t47 = 1/rhob**6.666666666666667d-1
            t48 = -1.3127055298329054d-1*t13*t46*t47-2.0096226153166658d
     1         -3*t45
            t49 = 7.876233178997433d-1*t12*t48-1.3127055298329054d-1*t14
     1         *t46*t47
            t50 = 2.11607075208357d-1*t12*t16*t47-1.269642451250142d+0*t
     1         11*t44*t49
            t51 = 1/t25
            t52 = 1/t23**2
            t53 = -1.3127055298329054d-1*t21*t46*t47-3.169132786263567d-
     1         3*t45
            t54 = 7.876233178997433d-1*t12*t53-1.3127055298329054d-1*t22
     1         *t46*t47
            t55 = 2.11607075208357d-1*t12*t24*t47-1.269642451250142d+0*t
     1         11*t52*t54
            t56 = 1/t32
            t57 = 1/t30**2
            t58 = -1.3127055298329054d-1*t28*t46*t47-1.7344776604086162d
     1         -3*t45
            t59 = 7.876233178997433d-1*t12*t58-1.3127055298329054d-1*t29
     1         *t46*t47
            t60 = 2.11607075208357d-1*t12*t31*t47-1.269642451250142d+0*t
     1         11*t57*t59
            t61 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t34*t56*t60+
     1         1.709920934161365d+0*(6.21814d-2*t27*t51*t55-3.10907d-2*t
     2         20*t43*t50-2.747773264188438d-3*t26*t42+1.321039893133926
     3         5d-3*t18*t42)+7.769549222703733d-4*t33*t42)+3.37738d-2*t3
     4         4*t56*t60-7.769549222703733d-4*t33*t42)-6.21814d-2*t27*t5
     5         1*t55+2.747773264188438d-3*t26*t42
            t62 = 1/rhob**8
            t63 = -1.6000000000000003d-2*t1*t2*t37*t62
            t64 = 8.000000000000002d-2*gammabb*t1-4.000000000000001d-2*g
     1         ammabb*t7
            t65 = 2.0d-1*t3*t7*t8
            t66 = gammabb**4
            t67 = 1/t4**4
            t68 = 1/rhob**1.2666666666666665d+1
            t69 = 1/rhob**10
            t70 = 1/rhob**7.333333333333333d+0
            t71 = 1/rhob**4.666666666666667d+0
            t72 = 1.9555555555555554d+0*gammabb*t7*t71*t8-9.6d-1*t2*t5*t
     1         7*t70+1.3511111111111113d+0*t1*t2*t5*t70+1.13777777777777
     2         78d-1*t36*t37*t69*t7-6.115555555555556d-1*t1*t36*t37*t69+
     3         6.826666666666669d-2*t1*t66*t67*t68
            t73 = 1/rhob**2.333333333333333d+0
            t74 = 1/t17**2
            t75 = t50**2
            t76 = 1/t15**3
            t77 = t49**2
            t78 = 1/rhob**2.3333333333333334d+0
            t79 = 1/rhob**1.6666666666666669d+0
            t80 = 1/t11**5
            t81 = 6.563527649164527d-2*t13*t45*t80+8.751370198886037d-2*
     1         t13*t46*t79+3.0144339229749983d-3*t78
            t82 = 7.876233178997433d-1*t12*t81+6.563527649164527d-2*t14*
     1         t45*t80+8.751370198886037d-2*t14*t46*t79-2.62541105966581
     2         1d-1*t46*t47*t48
            t83 = -1.269642451250142d+0*t11*t44*t82-1.4107138347223802d-
     1         1*t12*t16*t79+2.539284902500284d+0*t11*t76*t77-4.23214150
     2         416714d-1*t12*t44*t47*t49-3.52678458680595d-2*t16*t45*t46
            t84 = 1/t25**2
            t85 = t55**2
            t86 = 1/t23**3
            t87 = t54**2
            t88 = 6.563527649164527d-2*t21*t45*t80+8.751370198886037d-2*
     1         t21*t46*t79+4.753699179395351d-3*t78
            t89 = 7.876233178997433d-1*t12*t88+6.563527649164527d-2*t22*
     1         t45*t80+8.751370198886037d-2*t22*t46*t79-2.62541105966581
     2         1d-1*t46*t47*t53
            t90 = -1.269642451250142d+0*t11*t52*t89+2.539284902500284d+0
     1         *t11*t86*t87-1.4107138347223802d-1*t12*t24*t79-4.23214150
     2         416714d-1*t12*t47*t52*t54-3.52678458680595d-2*t24*t45*t46
            t91 = 1/t32**2
            t92 = t60**2
            t93 = 1/t30**3
            t94 = t59**2
            t95 = 6.563527649164527d-2*t28*t45*t80+8.751370198886037d-2*
     1         t28*t46*t79+2.601716490612924d-3*t78
            t96 = 7.876233178997433d-1*t12*t95+6.563527649164527d-2*t29*
     1         t45*t80+8.751370198886037d-2*t29*t46*t79-2.62541105966581
     2         1d-1*t46*t47*t58
            t97 = -1.269642451250142d+0*t11*t57*t96+2.539284902500284d+0
     1         *t11*t93*t94-1.4107138347223802d-1*t12*t31*t79-4.23214150
     2         416714d-1*t12*t47*t57*t59-3.52678458680595d-2*t31*t45*t46
            t98 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t34*t56*t97+
     1         3.37738d-2*t34*t91*t92+1.709920934161365d+0*(6.21814d-2*t
     2         27*t51*t90-6.21814d-2*t27*t84*t85-3.10907d-2*t20*t43*t83+
     3         3.10907d-2*t20*t74*t75+3.663697685584584d-3*t26*t73-1.761
     4         3865241785687d-3*t18*t73-5.495546528376876d-3*t42*t51*t55
     5         +2.642079786267853d-3*t42*t43*t50)-1.0359398963604977d-3*
     6         t33*t73+1.5539098445407465d-3*t42*t56*t60)+3.37738d-2*t34
     7         *t56*t97-3.37738d-2*t34*t91*t92+1.0359398963604977d-3*t33
     8         *t73-1.5539098445407465d-3*t42*t56*t60)-6.21814d-2*t27*t5
     9         1*t90+6.21814d-2*t27*t84*t85-3.663697685584584d-3*t26*t73
     :         +5.495546528376876d-3*t42*t51*t55
            t99 = -4.000000000000001d-2*gammabb*t5*t6*t7+t65+t63+8.00000
     1         0000000002d-2*gammabb*t1*t5*t6
            t100 = 1/rhob**1.1666666666666665d+1
            t101 = -5.333333333333333d-1*t40*t7*t8+3.2d-1*gammabb*t39*t5
     1         *t7-4.2666666666666675d-2*t2*t37*t38*t7-2.560000000000000
     2         6d-2*t1*t100*t36*t67-4.2666666666666675d-1*gammabb*t1*t39
     3         *t5+2.1333333333333337d-1*t1*t2*t37*t38
            t102 = 1/rhob**1.0666666666666666d+1
            t103 = 9.600000000000004d-3*t1*t102*t2*t67
            t104 = -4.0d-1*t64-3.2000000000000006d-2*gammabb*t1
            t105 = 8.000000000000002d-2*t1
            t106 = t105-8.000000000000002d-2*t7
            t107 = 1/t4**5
            t108 = 1/rhob**1.3666666666666666d+1
            t109 = 1/rhob**11
            t110 = 1/rhob**8.333333333333334d+0
            t111 = 1/rhob**3.333333333333333d+0
            t112 = 1/rhob**3.3333333333333337d+0
            t113 = 1/rhob**2.666666666666667d+0
            t114 = 1/t11**7
            t115 = 1/rhob**2.0d+0
            t116 = 1/t25**3
            t117 = t55**3
            t118 = 7.617854707500852d+0*t11*t54*t86*t89-6.34821225625071
     1         d-1*t12*t47*t52*t89-1.269642451250142d+0*t11*t52*(-3.9381
     2         165894987163d-1*t46*t47*t88+7.876233178997433d-1*t12*(-1.
     3         3127055298329054d-1*t21*t78*t80-1.4585616998143394d-1*t11
     4         3*t21*t46-5.469606374303773d-2*t114*t115*t21-1.1708185015
     5         918181d-2*t112)-1.3127055298329054d-1*t22*t78*t80+1.96905
     6         82947493582d-1*t45*t53*t80+2.625411059665811d-1*t46*t53*t
     7         79-1.4585616998143394d-1*t113*t22*t46-5.469606374303773d-
     8         2*t114*t115*t22)+1.269642451250142d+0*t12*t47*t86*t87+1.7
     9         63392293402975d-2*t115*t24*t80+4.2321415041671406d-1*t12*
     :         t52*t54*t79+7.053569173611901d-2*t24*t46*t78-7.6178547075
     ;         00852d+0*t11*t54**3/t23**4+1.0580353760417849d-1*t45*t46*
     <         t52*t54+2.3511897245373004d-1*t113*t12*t24
            t119 = 1/t32**3
            t120 = t60**3
            t121 = 7.617854707500852d+0*t11*t59*t93*t96-6.34821225625071
     1         d-1*t12*t47*t57*t96-1.269642451250142d+0*t11*t57*(-3.9381
     2         165894987163d-1*t46*t47*t95+7.876233178997433d-1*t12*(-1.
     3         3127055298329054d-1*t28*t78*t80-1.4585616998143394d-1*t11
     4         3*t28*t46-5.469606374303773d-2*t114*t115*t28-6.4079313565
     5         09611d-3*t112)-1.3127055298329054d-1*t29*t78*t80+1.969058
     6         2947493582d-1*t45*t58*t80+2.625411059665811d-1*t46*t58*t7
     7         9-1.4585616998143394d-1*t113*t29*t46-5.469606374303773d-2
     8         *t114*t115*t29)+1.269642451250142d+0*t12*t47*t93*t94+1.76
     9         3392293402975d-2*t115*t31*t80+4.2321415041671406d-1*t12*t
     :         57*t59*t79+7.053569173611901d-2*t31*t46*t78-7.61785470750
     ;         0852d+0*t11*t59**3/t30**4+1.0580353760417849d-1*t45*t46*t
     <         57*t59+2.3511897245373004d-1*t113*t12*t31
            t122 = 1.6000000000000003d-2*gammabb*t37*t62*t7-8.0000000000
     1         00002d-2*t5*t6*t7-6.400000000000001d-2*gammabb*t1*t37*t62
     2         +8.000000000000002d-2*t1*t5*t6+t103
            fnc(iq) = 1.0d+0*rhob*t35*t9*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*rhob*t61*t9*wght+1.0d+0*t35*t9*wght+
     1         1.0d+0*rhob*t35*t41*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = 1.0d+0*rhob*t35*(t65+t5*t6*t64+t63)*wght+C
     1         mat(iq,D1_GBB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*rhob*t9*t98*wght+2.0d+0*t61*t9*w
     1         ght+1.0d+0*rhob*t35*t72*wght+2.0d+0*rhob*t41*t61*wght+2.0
     2         d+0*t35*t41*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RB_GBB) = 1.0d+0*rhob*t61*t99*wght+1.0d+0*t35*t9
     1         9*wght+1.0d+0*rhob*t101*t35*wght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GBB_GBB) = 1.0d+0*rhob*t35*(t104*t37*t62+t106*t5
     1         *t6+t103)*wght+Cmat2(iq,D2_GBB_GBB)
            Amat3(iq,D3_RB_RB_RB) = 3.0d+0*t9*t98*wght+3.0d+0*rhob*t41*t
     1         98*wght+1.0d+0*rhob*t9*(5.848223622634643d-1*(1.0d+0*(1.0
     2         13214d-1*t34*t60*t91*t97+2.33086476681112d-3*t42*t56*t97-
     3         2.33086476681112d-3*t42*t91*t92+1.709920934161365d+0*(-1.
     4         865442d-1*t27*t55*t84*t90-8.243319792565315d-3*t42*t51*t9
     5         0+8.243319792565315d-3*t42*t84*t85+9.327209999999999d-2*t
     6         20*t50*t74*t83+3.96311967940178d-3*t42*t43*t83-3.10907d-2
     7         *t20*t43*(7.617854707500852d+0*t11*t49*t76*t82-6.34821225
     8         625071d-1*t12*t44*t47*t82-1.269642451250142d+0*t11*t44*(-
     9         3.9381165894987163d-1*t46*t47*t81+7.876233178997433d-1*t1
     :         2*(-1.3127055298329054d-1*t13*t78*t80-1.4585616998143394d
     ;         -1*t113*t13*t46-5.469606374303773d-2*t114*t115*t13-7.4244
     <         39106586571d-3*t112)-1.3127055298329054d-1*t14*t78*t80+1.
     =         9690582947493582d-1*t45*t48*t80+2.625411059665811d-1*t46*
     >         t48*t79-1.4585616998143394d-1*t113*t14*t46-5.469606374303
     ?         773d-2*t114*t115*t14)+1.763392293402975d-2*t115*t16*t80+4
     @         .2321415041671406d-1*t12*t44*t49*t79+7.053569173611901d-2
     1         *t16*t46*t78+1.269642451250142d+0*t12*t47*t76*t77-7.61785
     2         4707500852d+0*t11*t49**3/t15**4+1.0580353760417849d-1*t44
     3         *t45*t46*t49+2.3511897245373004d-1*t113*t12*t16)-3.963119
     4         67940178d-3*t42*t74*t75+1.0991093056753751d-2*t51*t55*t73
     5         -5.284159572535706d-3*t43*t50*t73+6.21814d-2*t118*t27*t51
     6         -6.21814d-2*t20*t50**3/t17**3+1.243628d-1*t116*t117*t27-8
     7         .548627933030694d-3*t111*t26+4.1099018897499934d-3*t111*t
     8         18)-3.107819689081493d-3*t56*t60*t73-3.37738d-2*t121*t34*
     9         t56-6.75476d-2*t119*t120*t34+2.4171930915078277d-3*t111*t
     :         33)-1.013214d-1*t34*t60*t91*t97-2.33086476681112d-3*t42*t
     ;         56*t97+2.33086476681112d-3*t42*t91*t92+3.107819689081493d
     <         -3*t56*t60*t73+3.37738d-2*t121*t34*t56+6.75476d-2*t119*t1
     =         20*t34-2.4171930915078277d-3*t111*t33)+1.865442d-1*t27*t5
     >         5*t84*t90+8.243319792565315d-3*t42*t51*t90-8.243319792565
     ?         315d-3*t42*t84*t85-1.0991093056753751d-2*t51*t55*t73-6.21
     @         814d-2*t118*t27*t51-1.243628d-1*t116*t117*t27+8.548627933
     1         030694d-3*t111*t26)*wght+1.0d+0*rhob*t35*(-9.125925925925
     2         926d+0*gammabb*t7*t8/rhob**5.666666666666667d+0+1.8204444
     3         444444445d-1*t108*t66*t67*t7+8.082962962962963d+0*t110*t2
     4         *t5*t7-2.161777777777778d+0*t109*t36*t37*t7-1.84320000000
     5         00004d+0*t1*t108*t66*t67-9.90814814814815d+0*t1*t110*t2*t
     6         5+7.556740740740742d+0*t1*t109*t36*t37+1.456355555555556d
     7         -1*gammabb**5*t1*t107/rhob**1.6333333333333333d+1)*wght+3
     8         .0d+0*rhob*t61*t72*wght+3.0d+0*t35*t72*wght+6.0d+0*t41*t6
     9         1*wght+Amat3(iq,D3_RB_RB_RB)
            Cmat3(iq,D3_RB_RB_GBB) = 1.0d+0*rhob*t98*t99*wght+2.0d+0*t61
     1         *t99*wght+1.0d+0*rhob*t35*(1.9555555555555554d+0*t7*t71*t
     2         8-2.311111111111111d+0*gammabb*t5*t7*t70+2.70222222222222
     3         25d+0*gammabb*t1*t5*t70+7.253333333333334d-1*t2*t37*t69*t
     4         7-6.826666666666669d-2*t36*t67*t68*t7-2.3751111111111115d
     5         +0*t1*t2*t37*t69+6.400000000000001d-1*t1*t36*t67*t68-5.46
     6         1333333333335d-2*t1*t107*t66/rhob**1.5333333333333335d+1)
     7         *wght+2.0d+0*rhob*t101*t61*wght+2.0d+0*t101*t35*wght+Cmat
     8         3(iq,D3_RB_RB_GBB)
            Cmat3(iq,D3_RB_GBB_GBB) = 1.0d+0*rhob*t35*(2.560000000000000
     1         6d-2*t100*t2*t67*t7+4.266666666666667d-1*t39*t5*t7-2.1333
     2         333333333335d-1*gammabb*t37*t38*t7-2.0480000000000004d-1*
     3         t1*t100*t2*t67-4.2666666666666675d-1*t1*t39*t5+5.97333333
     4         3333335d-1*gammabb*t1*t37*t38+2.048000000000001d-2*t1*t10
     5         7*t36/rhob**1.4333333333333334d+1)*wght+1.0d+0*rhob*t122*
     6         t61*wght+1.0d+0*t122*t35*wght+Cmat3(iq,D3_RB_GBB_GBB)
            Cmat3(iq,D3_GBB_GBB_GBB) = 1.0d+0*rhob*t35*(t37*t62*(-4.0d-1
     1         *(t105-4.000000000000001d-2*t7)-4.0d-1*t106-3.20000000000
     2         00006d-2*t1)+t102*(1.920000000000001d-2*gammabb*t1-6.0000
     3         00000000001d-1*t104)*t67-7.680000000000003d-3*t1*t107*t2/
     4         rhob**1.3333333333333333d+1)*wght+Cmat3(iq,D3_GBB_GBB_GBB
     5         )
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> @} 
