/*
 * Copyright (c) 2018, 2022, Intel Corporation. All rights reserved.
 * Intel Short Vector Math Library (SVML) Source Code
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 *
 */
#include "globals_vectorApiSupport_linux.S.inc"
#ifdef __VECTOR_API_MATH_INTRINSICS_LINUX
# -- Machine type EM64t
        .text
..TXTST0:
.L_2__routine_start___jsvml_cos2_ha_ex_0:
# -- Begin  __jsvml_cos2_ha_ex
        .text
# mark_begin;
        .align    16,0x90
        .globl __jsvml_cos2_ha_ex
# --- __jsvml_cos2_ha_ex(__m128d)
__jsvml_cos2_ha_ex:
# parameter 1: %xmm0
..B1.1:                         # Preds ..B1.0
                                # Execution count [1.00e+00]
        .byte     243                                           #2777.1
        .byte     15                                            #3139.18
        .byte     30                                            #3139.18
        .byte     250                                           #3139.18
        .cfi_startproc
..___tag_value___jsvml_cos2_ha_ex.1:
..L2:
                                                          #2777.1
        pushq     %rbp                                          #2777.1
        .cfi_def_cfa_offset 16
        movq      %rsp, %rbp                                    #2777.1
        .cfi_def_cfa 6, 16
        .cfi_offset 6, -16
        andq      $-64, %rsp                                    #2777.1
        subq      $192, %rsp                                    #2777.1
        movaps    %xmm0, %xmm2                                  #2777.1
        movups    16576+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm13 #2837.25
        movaps    %xmm2, %xmm6                                  #2840.14
        mulpd     %xmm2, %xmm13                                 #2837.25
        movups    16640+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm8 #2836.51
        lea       __jsvml_dcos_ha_data_internal_ha(%rip), %rax   #2851.370
        addpd     %xmm8, %xmm13                                 #2837.13
        movaps    %xmm13, %xmm11                                #2838.13
        xorl      %edx, %edx                                    #2829.1
        subpd     %xmm8, %xmm11                                 #2838.13
        movups    16768+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm9 #2839.48
        mulpd     %xmm11, %xmm9                                 #2840.34
        movups    16832+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm10 #2842.19
        mulpd     %xmm11, %xmm10                                #2842.19
        subpd     %xmm9, %xmm6                                  #2840.14
        movaps    %xmm6, %xmm5                                  #2843.17
        subpd     %xmm10, %xmm5                                 #2843.17
        andps     16704+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm13 #2850.17
        movaps    %xmm5, %xmm3                                  #2855.22
        movd      %xmm13, %ecx                                  #2851.128
        movaps    %xmm5, %xmm8                                  #2854.19
        movups    16896+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm12 #2846.50
        movups    16384+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm7 #2832.13
        subpd     %xmm5, %xmm6                                  #2844.17
        mulpd     %xmm11, %xmm12                                #2847.32
        pextrw    $4, %xmm13, %esi                              #2851.184
        subpd     %xmm10, %xmm6                                 #2845.17
        shll      $5, %ecx                                      #2851.285
        movaps    %xmm5, %xmm11                                 #2863.15
        shll      $5, %esi                                      #2851.336
        andps     %xmm2, %xmm7                                  #2832.13
        movq      8(%rcx,%rax), %xmm9                           #2853.601
        movaps    %xmm7, %xmm1                                  #2833.26
        mulpd     %xmm5, %xmm11                                 #2863.15
        subpd     %xmm12, %xmm6                                 #2847.13
        cmpnlepd  16448+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm1 #2833.26
        movhpd    8(%rsi,%rax), %xmm9                           #2853.569
        mulpd     %xmm9, %xmm3                                  #2855.22
        movmskpd  %xmm1, %edi                                   #2883.78
        movq      16(%rcx,%rax), %xmm12                         #2852.599
        movups    17216+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm10 #2873.26
        movhpd    16(%rsi,%rax), %xmm12                         #2852.567
        mulpd     %xmm11, %xmm10                                #2873.26
        movaps    %xmm12, %xmm15                                #2856.22
        movaps    %xmm12, %xmm14                                #2858.18
        addpd     %xmm3, %xmm15                                 #2856.22
        addpd     17152+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm10 #2873.14
        subpd     %xmm15, %xmm14                                #2858.18
        mulpd     %xmm11, %xmm10                                #2875.26
        addpd     %xmm14, %xmm3                                 #2859.18
        addpd     17088+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm10 #2875.14
        movups    17024+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm14 #2866.26
        movaps    %xmm15, %xmm0                                 #2857.21
        mulpd     %xmm11, %xmm14                                #2866.26
        movq      (%rcx,%rax), %xmm4                            #2851.599
        movhpd    (%rsi,%rax), %xmm4                            #2851.567
        mulpd     %xmm4, %xmm8                                  #2854.19
        addpd     16960+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm14 #2866.14
        addpd     %xmm8, %xmm0                                  #2857.21
        addpd     %xmm9, %xmm4                                  #2869.13
        mulpd     %xmm11, %xmm14                                #2867.14
        mulpd     %xmm10, %xmm11                                #2876.14
        subpd     %xmm0, %xmm15                                 #2860.18
        mulpd     %xmm5, %xmm14                                 #2868.14
        mulpd     %xmm12, %xmm11                                #2877.29
        mulpd     %xmm5, %xmm12                                 #2878.32
        addpd     %xmm15, %xmm8                                 #2861.18
        mulpd     %xmm4, %xmm14                                 #2870.29
        subpd     %xmm12, %xmm4                                 #2878.13
        addpd     %xmm8, %xmm3                                  #2862.21
        mulpd     %xmm4, %xmm6                                  #2880.28
        addpd     %xmm14, %xmm3                                 #2870.17
        movq      24(%rcx,%rax), %xmm5                          #2879.599
        movhpd    24(%rsi,%rax), %xmm5                          #2879.567
        addpd     %xmm11, %xmm3                                 #2877.17
        addpd     %xmm6, %xmm5                                  #2880.16
        addpd     %xmm5, %xmm3                                  #2881.17
        addpd     %xmm3, %xmm0                                  #2882.14
        testl     %edi, %edi                                    #2884.66
        jne       ..B1.12       # Prob 5%                       #2884.66
                                # LOE rax rbx r12 r13 r14 r15 edx xmm0 xmm1 xmm2 xmm7
..B1.2:                         # Preds ..B1.12 ..B1.1
                                # Execution count [1.00e+00]
        testl     %edx, %edx                                    #3142.52
        jne       ..B1.4        # Prob 5%                       #3142.52
                                # LOE rbx r12 r13 r14 r15 edx xmm0 xmm2
..B1.3:                         # Preds ..B1.4 ..B1.10 ..B1.2
                                # Execution count [1.00e+00]
        movq      %rbp, %rsp                                    #3145.12
        popq      %rbp                                          #3145.12
        .cfi_def_cfa 7, 8
        .cfi_restore 6
        ret                                                     #3145.12
        .cfi_def_cfa 6, 16
        .cfi_offset 6, -16
                                # LOE
..B1.4:                         # Preds ..B1.2
                                # Execution count [5.00e-02]: Infreq
        movups    %xmm2, 64(%rsp)                               #3142.197
        movups    %xmm0, 128(%rsp)                              #3142.270
        je        ..B1.3        # Prob 95%                      #3142.374
                                # LOE rbx r12 r13 r14 r15 edx xmm0
..B1.7:                         # Preds ..B1.4
                                # Execution count [2.25e-03]: Infreq
        xorl      %eax, %eax                                    #3142.454
        movq      %r12, 8(%rsp)                                 #3142.454[spill]
        .cfi_escape 0x10, 0x0c, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x48, 0xff, 0xff, 0xff, 0x22
        movl      %eax, %r12d                                   #3142.454
        movq      %r13, (%rsp)                                  #3142.454[spill]
        .cfi_escape 0x10, 0x0d, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x40, 0xff, 0xff, 0xff, 0x22
        movl      %edx, %r13d                                   #3142.454
                                # LOE rbx r12 r14 r15 r13d
..B1.8:                         # Preds ..B1.9 ..B1.7
                                # Execution count [1.25e-02]: Infreq
        btl       %r12d, %r13d                                  #3142.517
        jc        ..B1.11       # Prob 5%                       #3142.517
                                # LOE rbx r12 r14 r15 r13d
..B1.9:                         # Preds ..B1.11 ..B1.8
                                # Execution count [1.25e-02]: Infreq
        incl      %r12d                                         #3142.470
        cmpl      $2, %r12d                                     #3142.465
        jl        ..B1.8        # Prob 82%                      #3142.465
                                # LOE rbx r12 r14 r15 r13d
..B1.10:                        # Preds ..B1.9
                                # Execution count [2.25e-03]: Infreq
        movq      8(%rsp), %r12                                 #[spill]
        .cfi_restore 12
        movq      (%rsp), %r13                                  #[spill]
        .cfi_restore 13
        movups    128(%rsp), %xmm0                              #3142.673
        jmp       ..B1.3        # Prob 100%                     #3142.673
        .cfi_escape 0x10, 0x0c, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x48, 0xff, 0xff, 0xff, 0x22
        .cfi_escape 0x10, 0x0d, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x40, 0xff, 0xff, 0xff, 0x22
                                # LOE rbx r12 r13 r14 r15 xmm0
..B1.11:                        # Preds ..B1.8
                                # Execution count [6.25e-04]: Infreq
        lea       64(%rsp,%r12,8), %rdi                         #3142.546
        lea       128(%rsp,%r12,8), %rsi                        #3142.546
..___tag_value___jsvml_cos2_ha_ex.19:
#       __jsvml_dcos_ha_cout_rare_internal(const double *, double *)
        call      __jsvml_dcos_ha_cout_rare_internal             #3142.546
..___tag_value___jsvml_cos2_ha_ex.20:
        jmp       ..B1.9        # Prob 100%                     #3142.546
        .cfi_restore 12
        .cfi_restore 13
                                # LOE rbx r14 r15 r12d r13d
..B1.12:                        # Preds ..B1.1
                                # Execution count [5.00e-02]: Infreq
        movups    %xmm0, (%rsp)                                 #[spill]
        lea       __jsvml_dcos_ha_reduction_data_internal(%rip), %r9 #2979.372
        movdqu    .L_2il0floatpacket.34(%rip), %xmm0            #2977.16
        pand      %xmm2, %xmm0                                  #2977.16
        psrlq     $52, %xmm0                                    #2978.16
        movups    16512+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm9 #2887.55
        movd      %xmm0, %ecx                                   #2979.124
        andps     %xmm9, %xmm7                                  #2888.17
        movdqu    .L_2il0floatpacket.35(%rip), %xmm4            #2987.19
        pand      %xmm2, %xmm4                                  #2987.19
        pextrw    $4, %xmm0, %edi                               #2979.183
        cmpeqpd   %xmm9, %xmm7                                  #2889.25
        paddq     .L_2il0floatpacket.36(%rip), %xmm4            #2988.19
        movmskpd  %xmm7, %edx                                   #2891.48
        movdqa    %xmm4, %xmm7                                  #2996.10
        movdqu    .L_2il0floatpacket.37(%rip), %xmm8            #2989.15
        psrlq     $32, %xmm7                                    #2996.10
        pand      %xmm8, %xmm4                                  #2997.10
        lea       (%rcx,%rcx,2), %esi                           #2979.287
        shll      $3, %esi                                      #2979.287
        lea       (%rdi,%rdi,2), %r8d                           #2979.338
        shll      $3, %r8d                                      #2979.338
        movdqa    %xmm7, %xmm9                                  #3002.11
        movq      16(%rsi,%r9), %xmm6                           #2981.626
        movdqa    %xmm4, %xmm12                                 #3007.11
        movhpd    16(%r8,%r9), %xmm6                            #2981.594
        movdqa    %xmm4, %xmm13                                 #3006.11
        movaps    %xmm6, %xmm11                                 #2994.10
        pand      %xmm8, %xmm6                                  #2995.10
        movq      8(%rsi,%r9), %xmm14                           #2980.627
        psrlq     $32, %xmm11                                   #2994.10
        movhpd    8(%r8,%r9), %xmm14                            #2980.595
        movdqa    %xmm8, %xmm0                                  #3018.11
        pmuludq   %xmm11, %xmm9                                 #3002.11
        movaps    %xmm14, %xmm15                                #2992.10
        pmuludq   %xmm4, %xmm11                                 #3008.11
        pmuludq   %xmm7, %xmm6                                  #3003.11
        pand      %xmm8, %xmm14                                 #2993.10
        psrlq     $32, %xmm11                                   #3010.11
        pmuludq   %xmm14, %xmm12                                #3007.11
        psrlq     $32, %xmm15                                   #2992.10
        pmuludq   %xmm7, %xmm14                                 #3001.11
        pmuludq   %xmm15, %xmm13                                #3006.11
        pmuludq   %xmm7, %xmm15                                 #3000.11
        paddq     %xmm11, %xmm9                                 #3014.11
        pand      %xmm12, %xmm0                                 #3018.11
        movdqa    %xmm8, %xmm3                                  #2991.10
        movq      (%rsi,%r9), %xmm10                            #2979.626
        psrlq     $32, %xmm6                                    #3028.11
        paddq     %xmm9, %xmm0                                  #3023.11
        movhpd    (%r8,%r9), %xmm10                             #2979.594
        psrlq     $32, %xmm12                                   #3011.11
        pand      %xmm10, %xmm3                                 #2991.10
        movdqa    %xmm4, %xmm5                                  #3005.11
        paddq     %xmm0, %xmm6                                  #3029.11
        paddq     %xmm12, %xmm14                                #3015.11
        pmuludq   %xmm3, %xmm5                                  #3005.11
        pmuludq   %xmm3, %xmm7                                  #2999.11
        movdqa    %xmm8, %xmm11                                 #3019.11
        movaps    %xmm6, %xmm0                                  #3030.11
        pand      %xmm13, %xmm11                                #3019.11
        psrlq     $32, %xmm0                                    #3030.11
        paddq     %xmm14, %xmm11                                #3024.11
        psrlq     $32, %xmm13                                   #3012.11
        psrlq     $32, %xmm10                                   #2990.10
        paddq     %xmm11, %xmm0                                 #3031.11
        paddq     %xmm13, %xmm15                                #3016.11
        pmuludq   %xmm10, %xmm4                                 #3004.11
        movdqa    %xmm8, %xmm12                                 #3020.11
        movdqa    %xmm0, %xmm14                                 #3032.11
        pand      %xmm5, %xmm12                                 #3020.11
        psrlq     $32, %xmm14                                   #3032.11
        paddq     %xmm15, %xmm12                                #3025.11
        psrlq     $32, %xmm5                                    #3013.11
        pand      %xmm8, %xmm4                                  #3021.11
        paddq     %xmm12, %xmm14                                #3033.11
        paddq     %xmm5, %xmm7                                  #3017.11
        movdqa    %xmm14, %xmm11                                #3034.11
        pand      %xmm8, %xmm14                                 #3037.11
        paddq     %xmm7, %xmm4                                  #3026.11
        psrlq     $32, %xmm11                                   #3034.11
        psllq     $32, %xmm0                                    #3039.17
        paddq     %xmm4, %xmm11                                 #3035.11
        psllq     $32, %xmm11                                   #3038.17
        pand      %xmm8, %xmm6                                  #3036.11
        paddq     %xmm14, %xmm11                                #3040.17
        paddq     %xmm6, %xmm0                                  #3041.17
        movdqu    .L_2il0floatpacket.38(%rip), %xmm3            #3043.15
        movdqa    %xmm11, %xmm5                                 #3046.18
        movdqu    .L_2il0floatpacket.39(%rip), %xmm13           #3045.20
        pand      %xmm2, %xmm3                                  #3043.15
        movups    .L_2il0floatpacket.40(%rip), %xmm15           #3049.15
        psrlq     $12, %xmm5                                    #3046.18
        pxor      %xmm3, %xmm13                                 #3045.20
        movaps    %xmm15, %xmm10                                #3050.19
        por       %xmm13, %xmm5                                 #3047.18
        addpd     %xmm5, %xmm10                                 #3050.19
        movaps    %xmm10, %xmm6                                 #3051.9
        subpd     %xmm15, %xmm6                                 #3051.9
        movdqu    .L_2il0floatpacket.45(%rip), %xmm7            #3068.18
        movdqu    .L_2il0floatpacket.43(%rip), %xmm9            #3059.18
        pand      %xmm11, %xmm7                                 #3068.18
        movdqu    .L_2il0floatpacket.42(%rip), %xmm8            #3057.20
        pand      %xmm0, %xmm9                                  #3059.18
        psllq     $40, %xmm7                                    #3069.18
        psrlq     $24, %xmm0                                    #3070.17
        pxor      %xmm3, %xmm8                                  #3057.20
        por       %xmm0, %xmm7                                  #3071.18
        pxor      .L_2il0floatpacket.44(%rip), %xmm3            #3066.20
        psllq     $28, %xmm9                                    #3060.18
        subpd     %xmm6, %xmm5                                  #3052.17
        por       %xmm3, %xmm7                                  #3072.18
        movaps    %xmm5, %xmm11                                 #3076.11
        subpd     %xmm3, %xmm7                                  #3075.18
        addpd     %xmm7, %xmm11                                 #3076.11
        subpd     %xmm11, %xmm5                                 #3077.17
        por       %xmm8, %xmm9                                  #3061.18
        subpd     %xmm8, %xmm9                                  #3064.17
        addpd     %xmm5, %xmm7                                  #3078.18
        movups    .L_2il0floatpacket.49(%rip), %xmm12           #3084.16
        andps     %xmm11, %xmm12                                #3084.16
        addpd     %xmm7, %xmm9                                  #3079.11
        subpd     %xmm12, %xmm11                                #3085.17
        mulpd     .L_2il0floatpacket.46(%rip), %xmm9            #3089.12
        movups    .L_2il0floatpacket.47(%rip), %xmm4            #3081.16
        movaps    %xmm12, %xmm14                                #3086.16
        movups    .L_2il0floatpacket.48(%rip), %xmm0            #3082.17
        mulpd     %xmm4, %xmm14                                 #3086.16
        mulpd     %xmm11, %xmm4                                 #3087.12
        mulpd     %xmm0, %xmm12                                 #3088.12
        mulpd     %xmm11, %xmm0                                 #3090.12
        addpd     %xmm12, %xmm4                                 #3091.13
        addpd     %xmm0, %xmm9                                  #3092.13
        addpd     %xmm9, %xmm4                                  #3093.13
        movaps    %xmm4, %xmm6                                  #3094.13
        addpd     %xmm14, %xmm6                                 #3094.13
        movups    .L_2il0floatpacket.51(%rip), %xmm9            #3098.16
        movups    .L_2il0floatpacket.50(%rip), %xmm7            #3099.11
        movaps    %xmm9, %xmm8                                  #3100.17
        andps     %xmm2, %xmm7                                  #3099.11
        cmpltpd   %xmm7, %xmm8                                  #3100.17
        cmplepd   %xmm9, %xmm7                                  #3101.20
        subpd     %xmm6, %xmm14                                 #3095.16
        andps     .L_2il0floatpacket.41(%rip), %xmm10           #3055.13
        andps     %xmm2, %xmm7                                  #3102.24
        movd      %xmm10, %r10d                                 #3107.132
        andps     %xmm8, %xmm6                                  #3103.25
        orps      %xmm6, %xmm7                                  #3104.9
        movaps    %xmm7, %xmm3                                  #3111.26
        movaps    %xmm7, %xmm9                                  #3110.23
        pextrw    $4, %xmm10, %r11d                             #3107.188
        addpd     %xmm14, %xmm4                                 #3096.13
        shll      $5, %r10d                                     #3107.289
        andps     %xmm4, %xmm8                                  #3105.9
        shll      $5, %r11d                                     #3107.340
        movq      8(%r10,%rax), %xmm12                          #3109.605
        movhpd    8(%r11,%rax), %xmm12                          #3109.573
        mulpd     %xmm12, %xmm3                                 #3111.26
        movq      (%r10,%rax), %xmm5                            #3107.603
        movq      16(%r10,%rax), %xmm4                          #3108.603
        movhpd    (%r11,%rax), %xmm5                            #3107.571
        movhpd    16(%r11,%rax), %xmm4                          #3108.571
        mulpd     %xmm5, %xmm9                                  #3110.23
        addpd     %xmm12, %xmm5                                 #3125.17
        movaps    %xmm4, %xmm0                                  #3112.26
        movaps    %xmm4, %xmm10                                 #3114.22
        addpd     %xmm3, %xmm0                                  #3112.26
        movaps    %xmm0, %xmm6                                  #3113.25
        addpd     %xmm9, %xmm6                                  #3113.25
        subpd     %xmm0, %xmm10                                 #3114.22
        subpd     %xmm6, %xmm0                                  #3116.22
        addpd     %xmm10, %xmm3                                 #3115.22
        addpd     %xmm0, %xmm9                                  #3117.22
        movaps    %xmm7, %xmm0                                  #3119.19
        mulpd     %xmm7, %xmm0                                  #3119.19
        addpd     %xmm9, %xmm3                                  #3118.25
        movups    17024+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm11 #3122.30
        movups    17216+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm14 #3129.30
        mulpd     %xmm0, %xmm11                                 #3122.30
        mulpd     %xmm0, %xmm14                                 #3129.30
        movups    17152+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm15 #3129.18
        movups    16960+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm13 #3122.18
        addpd     %xmm11, %xmm13                                #3122.18
        addpd     %xmm14, %xmm15                                #3129.18
        mulpd     %xmm0, %xmm13                                 #3123.18
        mulpd     %xmm0, %xmm15                                 #3131.30
        mulpd     %xmm7, %xmm13                                 #3124.18
        mulpd     %xmm4, %xmm7                                  #3134.36
        mulpd     %xmm5, %xmm13                                 #3126.33
        subpd     %xmm7, %xmm5                                  #3134.17
        addpd     %xmm13, %xmm3                                 #3126.21
        mulpd     %xmm5, %xmm8                                  #3136.32
        movups    17088+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm11 #3131.18
        addpd     %xmm15, %xmm11                                #3131.18
        mulpd     %xmm11, %xmm0                                 #3132.18
        mulpd     %xmm4, %xmm0                                  #3133.33
        movq      24(%r10,%rax), %xmm4                          #3135.603
        movhpd    24(%r11,%rax), %xmm4                          #3135.571
        addpd     %xmm0, %xmm3                                  #3133.21
        addpd     %xmm8, %xmm4                                  #3136.20
        addpd     %xmm4, %xmm3                                  #3137.21
        addpd     %xmm3, %xmm6                                  #3138.24
        movaps    %xmm1, %xmm0                                  #3139.29
        andps     %xmm1, %xmm6                                  #3139.78
        andnps    (%rsp), %xmm0                                 #3139.29[spill]
        orps      %xmm6, %xmm0                                  #3139.18
        jmp       ..B1.2        # Prob 100%                     #3139.18
        .align    16,0x90
                                # LOE rbx r12 r13 r14 r15 edx xmm0 xmm2
        .cfi_endproc
# mark_end;
        .type   __jsvml_cos2_ha_ex,@function
        .size   __jsvml_cos2_ha_ex,.-__jsvml_cos2_ha_ex
..LN__jsvml_cos2_ha_ex.0:
        .data
# -- End  __jsvml_cos2_ha_ex
        .text
.L_2__routine_start___jsvml_cos8_ha_z0_1:
# -- Begin  __jsvml_cos8_ha_z0
        .text
# mark_begin;
        .align    16,0x90
        .globl __jsvml_cos8_ha_z0
# --- __jsvml_cos8_ha_z0(__m512d)
__jsvml_cos8_ha_z0:
# parameter 1: %zmm0
..B2.1:                         # Preds ..B2.0
                                # Execution count [1.00e+00]
        .byte     243                                           #3150.1
        .byte     15                                            #3528.18
        .byte     30                                            #3528.18
        .byte     250                                           #3528.18
        .cfi_startproc
..___tag_value___jsvml_cos8_ha_z0.26:
..L27:
                                                         #3150.1
        pushq     %rbp                                          #3150.1
        .cfi_def_cfa_offset 16
        movq      %rsp, %rbp                                    #3150.1
        .cfi_def_cfa 6, 16
        .cfi_offset 6, -16
        andq      $-64, %rsp                                    #3150.1
        subq      $192, %rsp                                    #3150.1
        xorl      %esi, %esi                                    #3229.5
        vmovups   192+__jsvml_dcos_ha_data_internal(%rip), %zmm13 #3234.52
        vmovups   128+__jsvml_dcos_ha_data_internal(%rip), %zmm6 #3235.13
        vmovups   256+__jsvml_dcos_ha_data_internal(%rip), %zmm8 #3239.51
        vmovups   320+__jsvml_dcos_ha_data_internal(%rip), %zmm10 #3240.51
        vmovups   384+__jsvml_dcos_ha_data_internal(%rip), %zmm14 #3241.51
        vmovups   64+__jsvml_dcos_ha_data_internal(%rip), %zmm5  #3231.61
        vmovups   896+__jsvml_dcos_ha_data_internal(%rip), %zmm12 #3254.50
        vmovups   512+__jsvml_dcos_ha_data_internal(%rip), %zmm2 #3244.270
        vmovups   640+__jsvml_dcos_ha_data_internal(%rip), %zmm1 #3245.270
        vmovaps   %zmm0, %zmm11                                 #3150.1
        vfmadd213pd {rn-sae}, %zmm13, %zmm11, %zmm6             #3235.13
        vmovups   768+__jsvml_dcos_ha_data_internal(%rip), %zmm0 #3246.273
        vandpd    __jsvml_dcos_ha_data_internal(%rip), %zmm11, %zmm4 #3232.16
        vsubpd    {rn-sae}, %zmm13, %zmm6, %zmm9                #3238.15
        vpermt2pd 576+__jsvml_dcos_ha_data_internal(%rip), %zmm6, %zmm2 #3244.270
        vpermt2pd 704+__jsvml_dcos_ha_data_internal(%rip), %zmm6, %zmm1 #3245.270
        vpermt2pd 832+__jsvml_dcos_ha_data_internal(%rip), %zmm6, %zmm0 #3246.273
        vfnmadd213pd {rn-sae}, %zmm11, %zmm9, %zmm8             #3242.18
        vcmppd    $22, {sae}, %zmm5, %zmm4, %k1                 #3236.30
        vpsrlq    $4, %zmm6, %zmm6                              #3280.44
        kmovw     %k1, %eax                                     #3237.75
        vmovaps   %zmm10, %zmm7                                 #3247.18
        vfnmadd213pd {rn-sae}, %zmm8, %zmm9, %zmm7              #3247.18
        vmovaps   %zmm14, %zmm3                                 #3248.17
        vfnmadd213pd {rn-sae}, %zmm7, %zmm9, %zmm3              #3248.17
        vsubpd    {rn-sae}, %zmm7, %zmm8, %zmm15                #3249.21
        vmovups   1152+__jsvml_dcos_ha_data_internal(%rip), %zmm8 #3262.50
        vmulpd    {rn-sae}, %zmm3, %zmm3, %zmm4                 #3250.21
        vfnmadd231pd {rn-sae}, %zmm9, %zmm10, %zmm15            #3252.18
        vsubpd    {rn-sae}, %zmm7, %zmm3, %zmm13                #3251.21
        vmovups   960+__jsvml_dcos_ha_data_internal(%rip), %zmm7 #3256.21
        vfmadd213pd {rn-sae}, %zmm13, %zmm14, %zmm9             #3257.19
        vmovups   1024+__jsvml_dcos_ha_data_internal(%rip), %zmm14 #3258.50
        vmovups   1088+__jsvml_dcos_ha_data_internal(%rip), %zmm13 #3260.21
        vfmadd231pd {rn-sae}, %zmm4, %zmm12, %zmm7              #3256.21
        vsubpd    {rn-sae}, %zmm9, %zmm15, %zmm10               #3264.20
        vfmadd231pd {rn-sae}, %zmm4, %zmm14, %zmm13             #3260.21
        vfmadd213pd {rn-sae}, %zmm8, %zmm4, %zmm7               #3263.21
        vmovups   1280+__jsvml_dcos_ha_data_internal(%rip), %zmm8 #3269.50
        vmovups   1216+__jsvml_dcos_ha_data_internal(%rip), %zmm15 #3265.50
        vmovups   1344+__jsvml_dcos_ha_data_internal(%rip), %zmm14 #3272.50
        vpsllq    $32, %zmm0, %zmm9                             #3268.39
        vfmadd213pd {rn-sae}, %zmm8, %zmm4, %zmm7               #3270.21
        vfmadd213pd {rn-sae}, %zmm15, %zmm4, %zmm13             #3266.21
        vmovaps   %zmm2, %zmm5                                  #3253.20
        vfnmadd213pd {rn-sae}, %zmm1, %zmm3, %zmm5              #3253.20
        vfmadd213pd {rn-sae}, %zmm14, %zmm4, %zmm13             #3273.21
        vsubpd    {rn-sae}, %zmm5, %zmm1, %zmm12                #3261.23
        vmovaps   %zmm1, %zmm8                                  #3271.23
        vfmsub231pd {rn-sae}, %zmm2, %zmm3, %zmm12              #3267.21
        vfmadd213pd {rn-sae}, %zmm2, %zmm3, %zmm8               #3271.23
        vmulpd    {rn-sae}, %zmm3, %zmm2, %zmm2                 #3275.21
        vmulpd    {rn-sae}, %zmm7, %zmm1, %zmm1                 #3277.26
        vfmadd213pd {rn-sae}, %zmm12, %zmm3, %zmm9              #3274.19
        vfnmadd213pd {rn-sae}, %zmm0, %zmm10, %zmm8             #3276.18
        vpsllq    $63, %zmm6, %zmm0                             #3281.44
        vfnmadd213pd {rn-sae}, %zmm1, %zmm2, %zmm13             #3279.20
        vsubpd    {rn-sae}, %zmm9, %zmm8, %zmm3                 #3278.21
        vfmadd213pd {rn-sae}, %zmm3, %zmm4, %zmm13              #3282.20
        vaddpd    {rn-sae}, %zmm13, %zmm5, %zmm3                #3283.22
        vxorpd    %zmm0, %zmm3, %zmm0                           #3284.18
        testl     %eax, %eax                                    #3285.70
        jne       ..B2.17       # Prob 5%                       #3285.70
                                # LOE rbx r12 r13 r14 r15 esi zmm0 zmm11 k1
..B2.2:                         # Preds ..B2.17 ..B2.1
                                # Execution count [1.00e+00]
        testl     %esi, %esi                                    #3531.52
        jne       ..B2.4        # Prob 5%                       #3531.52
                                # LOE rbx r12 r13 r14 r15 esi zmm0 zmm11
..B2.3:                         # Preds ..B2.10 ..B2.8 ..B2.2
                                # Execution count [1.00e+00]
        movq      %rbp, %rsp                                    #3534.12
        popq      %rbp                                          #3534.12
        .cfi_def_cfa 7, 8
        .cfi_restore 6
        ret                                                     #3534.12
        .cfi_def_cfa 6, 16
        .cfi_offset 6, -16
                                # LOE
..B2.4:                         # Preds ..B2.2
                                # Execution count [5.00e-02]: Infreq
        vstmxcsr  32(%rsp)                                      #3531.249
                                # LOE rbx r12 r13 r14 r15 esi zmm0 zmm11
..B2.5:                         # Preds ..B2.4
                                # Execution count [5.00e-02]: Infreq
        movzwl    32(%rsp), %edx                                #3531.249
        movl      %edx, %eax                                    #3531.303
        orl       $8064, %eax                                   #3531.303
        cmpl      %eax, %edx                                    #3531.332
        je        ..B2.7        # Prob 78%                      #3531.332
                                # LOE rbx r12 r13 r14 r15 eax edx esi zmm0 zmm11
..B2.6:                         # Preds ..B2.5
                                # Execution count [1.10e-02]: Infreq
        movl      %eax, 32(%rsp)                                #3531.344
        vldmxcsr  32(%rsp)                                      #3531.344
                                # LOE rbx r12 r13 r14 r15 eax edx esi zmm0 zmm11
..B2.7:                         # Preds ..B2.6 ..B2.5
                                # Execution count [5.00e-02]: Infreq
        vmovups   %zmm11, 64(%rsp)                              #3531.406
        vmovups   %zmm0, 128(%rsp)                              #3531.481
        testl     %esi, %esi                                    #3531.587
        jne       ..B2.12       # Prob 5%                       #3531.587
                                # LOE rbx r12 r13 r14 r15 eax edx esi zmm0
..B2.8:                         # Preds ..B2.15 ..B2.7
                                # Execution count [5.00e-02]: Infreq
        cmpl      %eax, %edx                                    #3531.930
        je        ..B2.3        # Prob 78%                      #3531.930
                                # LOE rbx r12 r13 r14 r15 edx zmm0
..B2.9:                         # Preds ..B2.8
                                # Execution count [1.10e-02]: Infreq
        vstmxcsr  32(%rsp)                                      #3531.955
        movl      32(%rsp), %eax                                #3531.955
                                # LOE rbx r12 r13 r14 r15 eax edx zmm0
..B2.10:                        # Preds ..B2.9
                                # Execution count [1.10e-02]: Infreq
        andl      $-8065, %eax                                  #3531.942
        orl       %edx, %eax                                    #3531.942
        movl      %eax, 32(%rsp)                                #3531.942
        vldmxcsr  32(%rsp)                                      #3531.942
        jmp       ..B2.3        # Prob 100%                     #3531.942
                                # LOE rbx r12 r13 r14 r15 zmm0
..B2.12:                        # Preds ..B2.7
                                # Execution count [2.25e-03]: Infreq
        xorl      %ecx, %ecx                                    #3531.667
                                # LOE rbx r12 r13 r14 r15 eax edx ecx esi
..B2.20:                        # Preds ..B2.12
                                # Execution count [2.25e-03]: Infreq
        vzeroupper                                              #
        movq      %r12, 16(%rsp)                                #[spill]
        .cfi_escape 0x10, 0x0c, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x50, 0xff, 0xff, 0xff, 0x22
        movl      %eax, %r12d                                   #
        movq      %r13, 8(%rsp)                                 #[spill]
        .cfi_escape 0x10, 0x0d, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x48, 0xff, 0xff, 0xff, 0x22
        movl      %edx, %r13d                                   #
        movq      %r14, (%rsp)                                  #[spill]
        .cfi_escape 0x10, 0x0e, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x40, 0xff, 0xff, 0xff, 0x22
        movl      %esi, %r14d                                   #
        movq      %rbx, 24(%rsp)                                #[spill]
        .cfi_escape 0x10, 0x03, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x58, 0xff, 0xff, 0xff, 0x22
        movl      %ecx, %ebx                                    #
                                # LOE rbx r15 r12d r13d r14d
..B2.13:                        # Preds ..B2.14 ..B2.20
                                # Execution count [1.25e-02]: Infreq
        btl       %ebx, %r14d                                   #3531.730
        jc        ..B2.16       # Prob 5%                       #3531.730
                                # LOE rbx r15 r12d r13d r14d
..B2.14:                        # Preds ..B2.16 ..B2.13
                                # Execution count [1.25e-02]: Infreq
        incl      %ebx                                          #3531.683
        cmpl      $8, %ebx                                      #3531.678
        jl        ..B2.13       # Prob 82%                      #3531.678
                                # LOE rbx r15 r12d r13d r14d
..B2.15:                        # Preds ..B2.14
                                # Execution count [2.25e-03]: Infreq
        movq      (%rsp), %r14                                  #[spill]
        .cfi_restore 14
        movl      %r12d, %eax                                   #
        movq      16(%rsp), %r12                                #[spill]
        .cfi_restore 12
        movl      %r13d, %edx                                   #
        movq      8(%rsp), %r13                                 #[spill]
        .cfi_restore 13
        movq      24(%rsp), %rbx                                #[spill]
        .cfi_restore 3
        vmovups   128(%rsp), %zmm0                              #3531.886
        jmp       ..B2.8        # Prob 100%                     #3531.886
        .cfi_escape 0x10, 0x03, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x58, 0xff, 0xff, 0xff, 0x22
        .cfi_escape 0x10, 0x0c, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x50, 0xff, 0xff, 0xff, 0x22
        .cfi_escape 0x10, 0x0d, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x48, 0xff, 0xff, 0xff, 0x22
        .cfi_escape 0x10, 0x0e, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x40, 0xff, 0xff, 0xff, 0x22
                                # LOE rbx r12 r13 r14 r15 eax edx zmm0
..B2.16:                        # Preds ..B2.13
                                # Execution count [6.25e-04]: Infreq
        lea       64(%rsp,%rbx,8), %rdi                         #3531.759
        lea       128(%rsp,%rbx,8), %rsi                        #3531.759
..___tag_value___jsvml_cos8_ha_z0.54:
#       __jsvml_dcos_ha_cout_rare_internal(const double *, double *)
        call      __jsvml_dcos_ha_cout_rare_internal             #3531.759
..___tag_value___jsvml_cos8_ha_z0.55:
        jmp       ..B2.14       # Prob 100%                     #3531.759
        .cfi_restore 3
        .cfi_restore 12
        .cfi_restore 13
        .cfi_restore 14
                                # LOE r15 ebx r12d r13d r14d
..B2.17:                        # Preds ..B2.1
                                # Execution count [5.00e-02]: Infreq
        vmovups   16512+__jsvml_dcos_ha_data_internal_ha(%rip), %zmm7 #3289.56
        lea       __jsvml_dcos_ha_reduction_data_internal(%rip), %rax #3381.406
        vmovups   %zmm0, (%rsp)                                 #[spill]
        vpbroadcastq .L_2il0floatpacket.52(%rip), %zmm9         #3291.71
        vandpd    %zmm11, %zmm7, %zmm8                          #3290.17
        vcmppd    $4, {sae}, %zmm7, %zmm8, %k2                  #3291.122
        lea       __jsvml_dcos_ha_data_internal_ha(%rip), %rdx   #3498.210
        vmovaps   %zmm9, %zmm6                                  #3291.46
        vpandq    .L_2il0floatpacket.53(%rip){1to8}, %zmm11, %zmm3 #3379.16
        vpsrlq    $52, %zmm3, %zmm12                            #3380.18
        vpsllq    $1, %zmm12, %zmm1                             #3381.134
        vpaddq    %zmm12, %zmm1, %zmm10                         #3381.194
        vpsllq    $3, %zmm10, %zmm4                             #3381.262
        vpmovqd   %zmm4, %ymm0                                  #3381.355
        vpandnq   %zmm8, %zmm8, %zmm6{%k2}                      #3291.46
        vcmppd    $3, {sae}, %zmm6, %zmm6, %k0                  #3293.37
        vpbroadcastq .L_2il0floatpacket.56(%rip), %zmm6         #3391.15
        kxnorw    %k0, %k0, %k4                                 #3382.407
        kxnorw    %k0, %k0, %k5                                 #3383.406
        kxnorw    %k0, %k0, %k3                                 #3381.406
        kxnorw    %k0, %k0, %k2                                 #3498.210
        kmovw     %k0, %esi                                     #3293.37
        vpxord    %zmm8, %zmm8, %zmm8                           #3382.407
        vpxord    %zmm2, %zmm2, %zmm2                           #3383.406
        vgatherdpd 8(%rax,%ymm0), %zmm8{%k4}                    #3382.407
        vgatherdpd 16(%rax,%ymm0), %zmm2{%k5}                   #3383.406
        kxnorw    %k0, %k0, %k4                                 #3500.212
        kxnorw    %k0, %k0, %k5                                 #3524.210
        vpsrlq    $32, %zmm8, %zmm15                            #3394.12
        vpsrlq    $32, %zmm2, %zmm13                            #3396.12
        vpxord    %zmm7, %zmm7, %zmm7                           #3381.406
        vgatherdpd (%rax,%ymm0), %zmm7{%k3}                     #3381.406
        kxnorw    %k0, %k0, %k3                                 #3499.210
        vpsrlq    $32, %zmm7, %zmm0                             #3392.12
        vpandq    .L_2il0floatpacket.54(%rip){1to8}, %zmm11, %zmm5 #3389.19
        vpaddq    .L_2il0floatpacket.55(%rip){1to8}, %zmm5, %zmm3 #3390.19
        vpsrlq    $32, %zmm3, %zmm10                            #3398.12
        vpmullq   %zmm13, %zmm10, %zmm1                         #3404.13
        vpandq    %zmm6, %zmm7, %zmm5                           #3393.10
        vpandq    %zmm6, %zmm8, %zmm12                          #3395.10
        vpandq    %zmm6, %zmm2, %zmm7                           #3397.10
        vpandq    %zmm6, %zmm3, %zmm14                          #3399.10
        vpmullq   %zmm5, %zmm10, %zmm4                          #3401.13
        vpmullq   %zmm15, %zmm10, %zmm3                         #3402.13
        vpmullq   %zmm12, %zmm10, %zmm2                         #3403.13
        vpmullq   %zmm7, %zmm10, %zmm8                          #3405.13
        vpmullq   %zmm15, %zmm14, %zmm10                        #3408.13
        vpmullq   %zmm13, %zmm14, %zmm15                        #3410.13
        vpmullq   %zmm0, %zmm14, %zmm7                          #3406.13
        vpmullq   %zmm12, %zmm14, %zmm0                         #3409.13
        vpmullq   %zmm5, %zmm14, %zmm5                          #3407.13
        vpsrlq    $32, %zmm15, %zmm13                           #3412.13
        vpsrlq    $32, %zmm0, %zmm14                            #3413.13
        vpsrlq    $32, %zmm5, %zmm12                            #3415.13
        vpsrlq    $32, %zmm10, %zmm15                           #3414.13
        vpaddq    %zmm13, %zmm1, %zmm1                          #3416.11
        vpaddq    %zmm14, %zmm2, %zmm13                         #3417.11
        vpaddq    %zmm12, %zmm4, %zmm4                          #3419.11
        vpaddq    %zmm15, %zmm3, %zmm2                          #3418.11
        vpandq    %zmm6, %zmm0, %zmm14                          #3420.11
        vpandq    %zmm6, %zmm10, %zmm12                         #3421.11
        vpandq    %zmm6, %zmm5, %zmm10                          #3422.11
        vpaddq    %zmm1, %zmm14, %zmm5                          #3425.11
        vpaddq    %zmm2, %zmm10, %zmm2                          #3427.11
        vpsrlq    $32, %zmm8, %zmm1                             #3430.13
        vpaddq    %zmm5, %zmm1, %zmm8                           #3431.11
        vpsrlq    $32, %zmm8, %zmm10                            #3432.13
        vpandq    %zmm6, %zmm7, %zmm0                           #3423.11
        vpaddq    %zmm13, %zmm12, %zmm7                         #3426.11
        vpaddq    %zmm4, %zmm0, %zmm3                           #3428.11
        vpaddq    %zmm7, %zmm10, %zmm14                         #3433.11
        vpbroadcastq .L_2il0floatpacket.59(%rip), %zmm7         #3451.36
        vpsrlq    $32, %zmm14, %zmm4                            #3434.13
        vpaddq    %zmm2, %zmm4, %zmm15                          #3435.11
        vpsllq    $32, %zmm14, %zmm4                            #3441.19
        vpsrlq    $32, %zmm15, %zmm0                            #3436.13
        vpaddq    %zmm3, %zmm0, %zmm13                          #3437.11
        vpandq    %zmm6, %zmm8, %zmm1                           #3438.11
        vpandq    %zmm6, %zmm15, %zmm10                         #3439.11
        vpsllq    $32, %zmm13, %zmm6                            #3440.19
        vpaddq    %zmm1, %zmm4, %zmm13                          #3443.17
        vpaddq    %zmm10, %zmm6, %zmm10                         #3442.17
        vpsrlq    $12, %zmm10, %zmm0                            #3448.20
        vpandq    .L_2il0floatpacket.62(%rip){1to8}, %zmm13, %zmm3 #3461.18
        vpsllq    $28, %zmm3, %zmm12                            #3462.20
        vpsrlq    $24, %zmm13, %zmm13                           #3472.19
        vpandq    .L_2il0floatpacket.57(%rip){1to8}, %zmm11, %zmm14 #3445.15
        vpxorq    .L_2il0floatpacket.58(%rip){1to8}, %zmm14, %zmm5 #3447.20
        vporq     %zmm5, %zmm0, %zmm8                           #3449.18
        vaddpd    {rn-sae}, %zmm8, %zmm7, %zmm2                 #3452.21
        vsubpd    {rn-sae}, %zmm7, %zmm2, %zmm6                 #3453.11
        vsubpd    {rn-sae}, %zmm6, %zmm8, %zmm15                #3454.19
        vpbroadcastq .L_2il0floatpacket.68(%rip), %zmm8         #3489.37
        vandpd    .L_2il0floatpacket.67(%rip){1to8}, %zmm11, %zmm6 #3490.11
        vcmppd    $26, {sae}, %zmm8, %zmm6, %k6                 #3491.114
        vcmppd    $22, {sae}, %zmm8, %zmm6, %k7                 #3492.117
        vpxorq    .L_2il0floatpacket.61(%rip){1to8}, %zmm14, %zmm0 #3459.20
        vporq     %zmm0, %zmm12, %zmm4                          #3463.18
        vsubpd    {rn-sae}, %zmm0, %zmm4, %zmm3                 #3466.19
        vpxorq    .L_2il0floatpacket.63(%rip){1to8}, %zmm14, %zmm0 #3468.20
        vpandq    .L_2il0floatpacket.64(%rip){1to8}, %zmm10, %zmm14 #3470.18
        vpsllq    $40, %zmm14, %zmm10                           #3471.20
        vmovups   17152+__jsvml_dcos_ha_data_internal_ha(%rip), %zmm14 #3517.50
        vporq     %zmm13, %zmm10, %zmm10                        #3473.18
        vporq     %zmm0, %zmm10, %zmm4                          #3474.18
        vsubpd    {rn-sae}, %zmm0, %zmm4, %zmm5                 #3477.20
        vpbroadcastq .L_2il0floatpacket.66(%rip), %zmm4         #3483.38
        vaddpd    {rn-sae}, %zmm5, %zmm15, %zmm7                #3478.13
        vsubpd    {rn-sae}, %zmm7, %zmm15, %zmm15               #3479.19
        vaddpd    {rn-sae}, %zmm15, %zmm5, %zmm10               #3480.20
        vpbroadcastq .L_2il0floatpacket.65(%rip), %zmm5         #3482.37
        vaddpd    {rn-sae}, %zmm3, %zmm10, %zmm12               #3481.13
        vmulpd    {rn-sae}, %zmm5, %zmm7, %zmm1                 #3484.15
        vmovaps   %zmm5, %zmm0                                  #3485.13
        vfmsub213pd {rn-sae}, %zmm1, %zmm7, %zmm0               #3485.13
        vfmadd213pd {rn-sae}, %zmm0, %zmm4, %zmm7               #3486.13
        vfmadd213pd {rn-sae}, %zmm7, %zmm5, %zmm12              #3487.13
        vmovaps   %zmm9, %zmm3                                  #3491.38
        vpandq    .L_2il0floatpacket.60(%rip){1to8}, %zmm2, %zmm2 #3457.13
        vpsllq    $5, %zmm2, %zmm5                              #3498.78
        vpmovqd   %zmm5, %ymm5                                  #3498.160
        vpandnq   %zmm6, %zmm6, %zmm3{%k6}                      #3491.38
        vpandnq   %zmm6, %zmm6, %zmm9{%k7}                      #3492.41
        vpxord    %zmm7, %zmm7, %zmm7                           #3499.210
        vpxord    %zmm6, %zmm6, %zmm6                           #3500.212
        vgatherdpd 16(%rdx,%ymm5), %zmm7{%k3}                   #3499.210
        vgatherdpd 8(%rdx,%ymm5), %zmm6{%k4}                    #3500.212
        vandpd    %zmm11, %zmm9, %zmm10                         #3493.24
        vandpd    %zmm1, %zmm3, %zmm4                           #3494.25
        vandpd    %zmm12, %zmm3, %zmm0                          #3496.9
        vmovups   16960+__jsvml_dcos_ha_data_internal_ha(%rip), %zmm3 #3510.50
        vorpd     %zmm4, %zmm10, %zmm4                          #3495.9
        vmovaps   %zmm4, %zmm2                                  #3501.26
        vfmadd213pd {rn-sae}, %zmm7, %zmm6, %zmm2               #3501.26
        vmovaps   %zmm4, %zmm10                                 #3502.25
        vsubpd    {rn-sae}, %zmm2, %zmm7, %zmm1                 #3503.24
        vfmadd231pd {rn-sae}, %zmm4, %zmm6, %zmm1               #3504.22
        vpxord    %zmm9, %zmm9, %zmm9                           #3498.210
        vgatherdpd (%rdx,%ymm5), %zmm9{%k2}                     #3498.210
        vfmadd132pd {rn-sae}, %zmm9, %zmm2, %zmm10              #3502.25
        vsubpd    {rn-sae}, %zmm10, %zmm2, %zmm8                #3505.24
        vmovups   17024+__jsvml_dcos_ha_data_internal_ha(%rip), %zmm2 #3509.50
        vfmadd231pd {rn-sae}, %zmm9, %zmm4, %zmm8               #3506.22
        vaddpd    {rn-sae}, %zmm1, %zmm8, %zmm13                #3507.27
        vaddpd    {rn-sae}, %zmm6, %zmm9, %zmm1                 #3514.19
        vmulpd    {rn-sae}, %zmm4, %zmm4, %zmm8                 #3508.21
        vmovups   17216+__jsvml_dcos_ha_data_internal_ha(%rip), %zmm6 #3516.50
        vmovups   17088+__jsvml_dcos_ha_data_internal_ha(%rip), %zmm9 #3519.50
        vfmadd231pd {rn-sae}, %zmm8, %zmm2, %zmm3               #3511.18
        vfmadd231pd {rn-sae}, %zmm8, %zmm6, %zmm14              #3518.18
        vmulpd    {rn-sae}, %zmm8, %zmm3, %zmm12                #3512.20
        vfmadd213pd {rn-sae}, %zmm9, %zmm8, %zmm14              #3520.18
        vmulpd    {rn-sae}, %zmm4, %zmm12, %zmm15               #3513.20
        vmulpd    {rn-sae}, %zmm8, %zmm14, %zmm2                #3521.20
        vfnmadd213pd {rn-sae}, %zmm1, %zmm7, %zmm4              #3523.17
        vfmadd213pd {rn-sae}, %zmm13, %zmm1, %zmm15             #3515.21
        vfmadd213pd {rn-sae}, %zmm15, %zmm7, %zmm2              #3522.21
        vpxord    %zmm7, %zmm7, %zmm7                           #3524.210
        vgatherdpd 24(%rdx,%ymm5), %zmm7{%k5}                   #3524.210
        vfmadd213pd {rn-sae}, %zmm7, %zmm4, %zmm0               #3525.20
        vaddpd    {rn-sae}, %zmm0, %zmm2, %zmm1                 #3526.23
        vmovups   (%rsp), %zmm0                                 #3528.18[spill]
        vaddpd    {rn-sae}, %zmm1, %zmm10, %zmm0{%k1}           #3528.18
        jmp       ..B2.2        # Prob 100%                     #3528.18
        .align    16,0x90
                                # LOE rbx r12 r13 r14 r15 esi zmm0 zmm11
        .cfi_endproc
# mark_end;
        .type   __jsvml_cos8_ha_z0,@function
        .size   __jsvml_cos8_ha_z0,.-__jsvml_cos8_ha_z0
..LN__jsvml_cos8_ha_z0.1:
        .data
# -- End  __jsvml_cos8_ha_z0
        .text
.L_2__routine_start___jsvml_cos1_ha_l9_2:
# -- Begin  __jsvml_cos1_ha_l9
        .text
# mark_begin;
        .align    16,0x90
        .globl __jsvml_cos1_ha_l9
# --- __jsvml_cos1_ha_l9(__m128d)
__jsvml_cos1_ha_l9:
# parameter 1: %xmm0
..B3.1:                         # Preds ..B3.0
                                # Execution count [1.00e+00]
        .byte     243                                           #3539.1
        .byte     15                                            #3885.18
        .byte     30                                            #3885.18
        .byte     250                                           #3885.18
        .cfi_startproc
..___tag_value___jsvml_cos1_ha_l9.63:
..L64:
                                                         #3539.1
        pushq     %rbp                                          #3539.1
        .cfi_def_cfa_offset 16
        movq      %rsp, %rbp                                    #3539.1
        .cfi_def_cfa 6, 16
        .cfi_offset 6, -16
        andq      $-64, %rsp                                    #3539.1
        subq      $128, %rsp                                    #3539.1
        vmovapd   %xmm0, %xmm14                                 #3539.1
        vmovsd    16640+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm8 #3598.20
        vmovapd   %xmm14, %xmm13                                #3599.13
        vfmadd132sd 16576+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm8, %xmm13 #3599.13
        lea       __jsvml_dcos_ha_data_internal_ha(%rip), %rcx   #3612.371
        vmovq     16704+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm15 #3610.23
        vmovsd    16832+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm10 #3603.17
        vmovsd    16384+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm7 #3592.19
        vandpd    %xmm7, %xmm14, %xmm7                          #3594.13
        vpand     %xmm15, %xmm13, %xmm4                         #3611.19
        xorl      %eax, %eax                                    #3591.1
        vmovd     %xmm4, %edx                                   #3612.128
        vsubsd    %xmm8, %xmm13, %xmm6                          #3600.13
        vcmpnlesd 16448+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm7, %xmm0 #3595.26
        vmovapd   %xmm6, %xmm9                                  #3602.14
        vmovapd   %xmm6, %xmm5                                  #3604.17
        vfnmadd132sd 16768+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm14, %xmm9 #3602.14
        vmovapd   %xmm6, %xmm12                                 #3606.17
        vmovsd    17024+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm13 #3625.14
        vmovmskpd %xmm0, %esi                                   #3642.78
        vfnmadd213sd %xmm9, %xmm10, %xmm5                       #3604.17
        shll      $5, %edx                                      #3612.231
        vsubsd    %xmm5, %xmm9, %xmm11                          #3605.17
        vmovq     16(%rcx,%rdx), %xmm2                          #3613.371
        vmovapd   %xmm5, %xmm9                                  #3615.22
        vmovq     8(%rcx,%rdx), %xmm1                           #3614.373
        vfmadd213sd %xmm2, %xmm1, %xmm9                         #3615.22
        vmovq     (%rdx,%rcx), %xmm3                            #3612.371
        vmovdqa   %xmm3, %xmm4                                  #3616.21
        vfnmadd213sd %xmm11, %xmm10, %xmm12                     #3606.17
        vmovdqa   %xmm3, %xmm11                                 #3620.18
        vaddsd    %xmm1, %xmm3, %xmm3                           #3628.13
        vfmadd213sd %xmm9, %xmm5, %xmm4                         #3616.21
        vsubsd    %xmm9, %xmm2, %xmm8                           #3617.18
        vfnmadd132sd 16896+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm12, %xmm6 #3608.13
        vmovapd   %xmm5, %xmm12                                 #3618.18
        vsubsd    %xmm4, %xmm9, %xmm10                          #3619.18
        vmulsd    %xmm5, %xmm5, %xmm9                           #3622.15
        vfmadd213sd %xmm8, %xmm1, %xmm12                        #3618.18
        vfmadd213sd %xmm10, %xmm5, %xmm11                       #3620.18
        vfmadd213sd 16960+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm9, %xmm13 #3625.14
        vmovsd    17216+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm1 #3632.14
        vfmadd213sd 17152+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm9, %xmm1 #3632.14
        vaddsd    %xmm12, %xmm11, %xmm8                         #3621.21
        vmulsd    %xmm9, %xmm13, %xmm15                         #3626.14
        vfmadd213sd 17088+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm9, %xmm1 #3634.14
        vmulsd    %xmm5, %xmm15, %xmm10                         #3627.14
        vfnmadd213sd %xmm3, %xmm2, %xmm5                        #3637.13
        vmulsd    %xmm9, %xmm1, %xmm1                           #3635.14
        vfmadd213sd %xmm8, %xmm3, %xmm10                        #3629.17
        vfmadd213sd 24(%rcx,%rdx), %xmm5, %xmm6                 #3639.16
        vfmadd213sd %xmm10, %xmm2, %xmm1                        #3636.17
        vaddsd    %xmm6, %xmm1, %xmm2                           #3640.17
        vaddsd    %xmm2, %xmm4, %xmm1                           #3641.14
        testl     $1, %esi                                      #3643.55
        jne       ..B3.8        # Prob 5%                       #3643.66
                                # LOE rbx r12 r13 r14 r15 eax xmm0 xmm1 xmm7 xmm14
..B3.2:                         # Preds ..B3.8 ..B3.1
                                # Execution count [1.00e+00]
        testl     %eax, %eax                                    #3888.52
        jne       ..B3.4        # Prob 5%                       #3888.52
                                # LOE rbx r12 r13 r14 r15 eax xmm1 xmm14
..B3.3:                         # Preds ..B3.5 ..B3.2
                                # Execution count [1.00e+00]
        vmovapd   %xmm1, %xmm0                                  #3891.12
        movq      %rbp, %rsp                                    #3891.12
        popq      %rbp                                          #3891.12
        .cfi_def_cfa 7, 8
        .cfi_restore 6
        ret                                                     #3891.12
        .cfi_def_cfa 6, 16
        .cfi_offset 6, -16
                                # LOE
..B3.4:                         # Preds ..B3.2
                                # Execution count [5.00e-02]: Infreq
        vmovsd    %xmm14, (%rsp)                                #3888.160
        vmovsd    %xmm1, 64(%rsp)                               #3888.233
        jne       ..B3.6        # Prob 5%                       #3888.374
                                # LOE rbx r12 r13 r14 r15 eax
..B3.5:                         # Preds ..B3.7 ..B3.6 ..B3.4
                                # Execution count [5.00e-02]: Infreq
        vmovsd    64(%rsp), %xmm1                               #3888.625
        jmp       ..B3.3        # Prob 100%                     #3888.625
                                # LOE rbx r12 r13 r14 r15 xmm1
..B3.6:                         # Preds ..B3.4
                                # Execution count [2.50e-03]: Infreq
        je        ..B3.5        # Prob 95%                      #3888.517
                                # LOE rbx r12 r13 r14 r15
..B3.7:                         # Preds ..B3.6
                                # Execution count [6.25e-04]: Infreq
        lea       (%rsp), %rdi                                  #3888.546
        lea       64(%rsp), %rsi                                #3888.546
..___tag_value___jsvml_cos1_ha_l9.72:
#       __jsvml_dcos_ha_cout_rare_internal(const double *, double *)
        call      __jsvml_dcos_ha_cout_rare_internal             #3888.546
..___tag_value___jsvml_cos1_ha_l9.73:
        jmp       ..B3.5        # Prob 100%                     #3888.546
                                # LOE rbx r12 r13 r14 r15
..B3.8:                         # Preds ..B3.1
                                # Execution count [5.00e-02]: Infreq
        vpand     .L_2il0floatpacket.34(%rip), %xmm14, %xmm8    #3736.18
        lea       __jsvml_dcos_ha_reduction_data_internal(%rip), %rsi #3738.383
        vpsrlq    $52, %xmm8, %xmm10                            #3737.18
        lea       __jsvml_dcos_ha_data_internal_ha(%rip), %r8    #3855.375
        vmovd     %xmm10, %edx                                  #3738.124
        vmovsd    16512+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm13 #3646.24
        vpand     .L_2il0floatpacket.35(%rip), %xmm14, %xmm4    #3746.21
        vandpd    %xmm7, %xmm13, %xmm9                          #3647.17
        vpaddq    .L_2il0floatpacket.36(%rip), %xmm4, %xmm2     #3747.21
        vcmpeqsd  %xmm13, %xmm9, %xmm11                         #3648.25
        vmovdqu   .L_2il0floatpacket.37(%rip), %xmm13           #3748.17
        lea       (%rdx,%rdx,2), %ecx                           #3738.230
        shll      $3, %ecx                                      #3738.230
        vpsrlq    $32, %xmm2, %xmm10                            #3755.12
        vmovq     8(%rsi,%rcx), %xmm7                           #3739.384
        vmovq     16(%rsi,%rcx), %xmm12                         #3740.383
        vpsrlq    $32, %xmm7, %xmm5                             #3751.12
        vmovupd   %xmm1, (%rsp)                                 #[spill]
        vpand     %xmm13, %xmm7, %xmm3                          #3752.12
        vpsrlq    $32, %xmm12, %xmm1                            #3753.12
        vpand     %xmm13, %xmm2, %xmm7                          #3756.12
        vpand     %xmm13, %xmm12, %xmm12                        #3754.12
        vpmuludq  %xmm12, %xmm10, %xmm6                         #3762.13
        vpmuludq  %xmm1, %xmm10, %xmm12                         #3761.13
        vpmuludq  %xmm1, %xmm7, %xmm1                           #3767.13
        vpmuludq  %xmm3, %xmm7, %xmm2                           #3766.13
        vpmuludq  %xmm3, %xmm10, %xmm3                          #3760.13
        vpmuludq  %xmm5, %xmm7, %xmm4                           #3765.13
        vpmuludq  %xmm5, %xmm10, %xmm5                          #3759.13
        vmovmskpd %xmm11, %eax                                  #3650.48
        vpsrlq    $32, %xmm1, %xmm1                             #3769.13
        vpsrlq    $32, %xmm6, %xmm15                            #3787.13
        vpaddq    %xmm1, %xmm12, %xmm12                         #3773.13
        vpand     %xmm13, %xmm2, %xmm6                          #3777.13
        vpsrlq    $32, %xmm2, %xmm2                             #3770.13
        vpaddq    %xmm12, %xmm6, %xmm6                          #3782.13
        vpaddq    %xmm2, %xmm3, %xmm1                           #3774.13
        vpaddq    %xmm6, %xmm15, %xmm12                         #3788.13
        vmovq     (%rcx,%rsi), %xmm11                           #3738.383
        vpand     %xmm13, %xmm4, %xmm6                          #3778.13
        vpand     %xmm13, %xmm11, %xmm8                         #3750.12
        vpsrlq    $32, %xmm12, %xmm15                           #3789.13
        vpmuludq  %xmm8, %xmm7, %xmm9                           #3764.13
        vpsrlq    $32, %xmm11, %xmm11                           #3749.12
        vpmuludq  %xmm8, %xmm10, %xmm8                          #3758.13
        vpmuludq  %xmm11, %xmm7, %xmm7                          #3763.13
        vpaddq    %xmm1, %xmm6, %xmm6                           #3783.13
        vpaddq    %xmm6, %xmm15, %xmm6                          #3790.13
        vpsrlq    $32, %xmm4, %xmm15                            #3771.13
        vpand     %xmm13, %xmm9, %xmm3                          #3779.13
        vpaddq    %xmm15, %xmm5, %xmm4                          #3775.13
        vpaddq    %xmm4, %xmm3, %xmm2                           #3784.13
        vpsrlq    $32, %xmm9, %xmm9                             #3772.13
        vpsrlq    $32, %xmm6, %xmm1                             #3791.13
        vpaddq    %xmm9, %xmm8, %xmm10                          #3776.13
        vpaddq    %xmm2, %xmm1, %xmm2                           #3792.13
        vpand     %xmm13, %xmm7, %xmm3                          #3780.13
        vpsrlq    $32, %xmm2, %xmm5                             #3793.13
        vpaddq    %xmm10, %xmm3, %xmm9                          #3785.13
        vpaddq    %xmm9, %xmm5, %xmm1                           #3794.13
        vpsllq    $32, %xmm1, %xmm5                             #3797.19
        vpand     %xmm13, %xmm2, %xmm9                          #3796.13
        vpaddq    %xmm9, %xmm5, %xmm4                           #3799.19
        vpand     .L_2il0floatpacket.38(%rip), %xmm14, %xmm7    #3802.17
        vpsllq    $32, %xmm6, %xmm6                             #3798.19
        vpand     %xmm13, %xmm12, %xmm12                        #3795.13
        vpsrlq    $12, %xmm4, %xmm13                            #3805.20
        vpaddq    %xmm12, %xmm6, %xmm10                         #3800.19
        vpxor     .L_2il0floatpacket.39(%rip), %xmm7, %xmm12    #3804.22
        andl      $1, %eax                                      #3650.102
        vmovups   .L_2il0floatpacket.40(%rip), %xmm9            #3808.15
        vpor      %xmm12, %xmm13, %xmm6                         #3806.20
        vpand     .L_2il0floatpacket.45(%rip), %xmm4, %xmm4     #3827.20
        vaddsd    %xmm6, %xmm9, %xmm11                          #3809.19
        vpand     .L_2il0floatpacket.43(%rip), %xmm10, %xmm15   #3818.20
        vpsllq    $40, %xmm4, %xmm5                             #3828.20
        vpsrlq    $24, %xmm10, %xmm10                           #3829.19
        vpsllq    $28, %xmm15, %xmm1                            #3819.20
        vpxor     .L_2il0floatpacket.42(%rip), %xmm7, %xmm3     #3816.22
        vsubsd    %xmm9, %xmm11, %xmm13                         #3810.9
        vpxor     .L_2il0floatpacket.44(%rip), %xmm7, %xmm9     #3825.22
        vpor      %xmm10, %xmm5, %xmm7                          #3830.20
        vpor      %xmm9, %xmm7, %xmm12                          #3831.20
        vpor      %xmm3, %xmm1, %xmm2                           #3820.20
        vandpd    .L_2il0floatpacket.50(%rip), %xmm14, %xmm1    #3847.11
        vsubsd    %xmm13, %xmm6, %xmm8                          #3811.17
        vsubsd    %xmm9, %xmm12, %xmm6                          #3834.18
        vsubsd    %xmm3, %xmm2, %xmm15                          #3823.17
        vaddsd    %xmm6, %xmm8, %xmm13                          #3835.11
        vmovapd   %xmm13, %xmm9                                 #3842.13
        vsubsd    %xmm13, %xmm8, %xmm8                          #3836.17
        vmovups   .L_2il0floatpacket.51(%rip), %xmm2            #3846.16
        vaddsd    %xmm8, %xmm6, %xmm12                          #3837.18
        vcmplesd  %xmm2, %xmm1, %xmm3                           #3849.20
        vaddsd    %xmm15, %xmm12, %xmm10                        #3838.11
        vcmpltsd  %xmm1, %xmm2, %xmm15                          #3848.17
        vmovups   .L_2il0floatpacket.46(%rip), %xmm6            #3839.16
        vmovsd    %xmm15, %xmm1, %xmm8                          #3848.17
        vmulsd    %xmm6, %xmm13, %xmm4                          #3841.13
        vandpd    %xmm14, %xmm3, %xmm5                          #3850.24
        vfmsub213sd %xmm4, %xmm6, %xmm9                         #3842.13
        vandpd    %xmm4, %xmm8, %xmm7                           #3851.25
        vandps    .L_2il0floatpacket.41(%rip), %xmm11, %xmm11   #3814.15
        vmovd     %xmm11, %edi                                  #3855.132
        vfmadd132sd .L_2il0floatpacket.69(%rip), %xmm9, %xmm13  #3843.13
        vorpd     %xmm7, %xmm5, %xmm9                           #3852.9
        vmovapd   %xmm9, %xmm2                                  #3858.26
        vmovapd   %xmm9, %xmm5                                  #3861.22
        vmovsd    17024+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm7 #3868.18
        vmulsd    %xmm9, %xmm9, %xmm11                          #3865.19
        vfmadd213sd %xmm13, %xmm6, %xmm10                       #3844.13
        vfmadd213sd 16960+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm11, %xmm7 #3868.18
        vandpd    %xmm10, %xmm8, %xmm6                          #3853.9
        shll      $5, %edi                                      #3855.235
        vmovq     16(%r8,%rdi), %xmm13                          #3856.375
        vfmadd132sd 8(%r8,%rdi), %xmm13, %xmm2                  #3858.26
        vmovq     (%rdi,%r8), %xmm15                            #3855.375
        vmovdqa   %xmm15, %xmm12                                #3859.25
        vmovdqa   %xmm15, %xmm4                                 #3863.22
        vmulsd    %xmm11, %xmm7, %xmm8                          #3869.18
        vfmadd213sd %xmm2, %xmm9, %xmm12                        #3859.25
        vsubsd    %xmm2, %xmm13, %xmm1                          #3860.22
        vfmadd132sd 8(%r8,%rdi), %xmm1, %xmm5                   #3861.22
        vsubsd    %xmm12, %xmm2, %xmm3                          #3862.22
        vmulsd    %xmm9, %xmm8, %xmm1                           #3870.18
        vaddsd    8(%r8,%rdi), %xmm15, %xmm2                    #3871.17
        vfmadd213sd %xmm3, %xmm9, %xmm4                         #3863.22
        vmovsd    17216+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm15 #3875.18
        vfmadd213sd 17152+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm11, %xmm15 #3875.18
        vfnmadd213sd %xmm2, %xmm13, %xmm9                       #3880.17
        vaddsd    %xmm5, %xmm4, %xmm10                          #3864.25
        vfmadd213sd 17088+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm11, %xmm15 #3877.18
        vfmadd213sd 24(%r8,%rdi), %xmm9, %xmm6                  #3882.20
        vfmadd213sd %xmm10, %xmm2, %xmm1                        #3872.21
        vmulsd    %xmm11, %xmm15, %xmm3                         #3878.18
        vfmadd213sd %xmm1, %xmm13, %xmm3                        #3879.21
        vmovupd   (%rsp), %xmm1                                 #3885.18[spill]
        vaddsd    %xmm6, %xmm3, %xmm6                           #3883.21
        vaddsd    %xmm6, %xmm12, %xmm9                          #3884.24
        blendvpd  %xmm0, %xmm9, %xmm1                           #3885.18
        jmp       ..B3.2        # Prob 100%                     #3885.18
        .align    16,0x90
                                # LOE rbx r12 r13 r14 r15 eax xmm1 xmm14
        .cfi_endproc
# mark_end;
        .type   __jsvml_cos1_ha_l9,@function
        .size   __jsvml_cos1_ha_l9,.-__jsvml_cos1_ha_l9
..LN__jsvml_cos1_ha_l9.2:
        .data
# -- End  __jsvml_cos1_ha_l9
        .text
.L_2__routine_start___jsvml_cos2_ha_e9_3:
# -- Begin  __jsvml_cos2_ha_e9
        .text
# mark_begin;
        .align    16,0x90
        .globl __jsvml_cos2_ha_e9
# --- __jsvml_cos2_ha_e9(__m128d)
__jsvml_cos2_ha_e9:
# parameter 1: %xmm0
..B4.1:                         # Preds ..B4.0
                                # Execution count [1.00e+00]
        .byte     243                                           #3896.1
        .byte     15                                            #4258.18
        .byte     30                                            #4258.18
        .byte     250                                           #4258.18
        .cfi_startproc
..___tag_value___jsvml_cos2_ha_e9.77:
..L78:
                                                         #3896.1
        pushq     %rbp                                          #3896.1
        .cfi_def_cfa_offset 16
        movq      %rsp, %rbp                                    #3896.1
        .cfi_def_cfa 6, 16
        .cfi_offset 6, -16
        andq      $-64, %rsp                                    #3896.1
        subq      $192, %rsp                                    #3896.1
        movaps    %xmm0, %xmm2                                  #3896.1
        movups    16576+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm12 #3956.25
        movaps    %xmm2, %xmm6                                  #3959.14
        mulpd     %xmm2, %xmm12                                 #3956.25
        movups    16640+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm4 #3955.51
        lea       __jsvml_dcos_ha_data_internal_ha(%rip), %rax   #3970.383
        addpd     %xmm4, %xmm12                                 #3956.13
        movaps    %xmm12, %xmm10                                #3957.13
        xorl      %edx, %edx                                    #3948.1
        subpd     %xmm4, %xmm10                                 #3957.13
        movups    16768+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm8 #3958.48
        mulpd     %xmm10, %xmm8                                 #3959.34
        movups    16832+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm9 #3961.19
        mulpd     %xmm10, %xmm9                                 #3961.19
        subpd     %xmm8, %xmm6                                  #3959.14
        movaps    %xmm6, %xmm5                                  #3962.17
        andps     16704+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm12 #3969.23
        subpd     %xmm9, %xmm5                                  #3962.17
        movd      %xmm12, %ecx                                  #3970.128
        movaps    %xmm5, %xmm1                                  #3974.22
        movaps    %xmm5, %xmm15                                 #3973.19
        shll      $5, %ecx                                      #3970.298
        pextrd    $2, %xmm12, %esi                              #3970.190
        shll      $5, %esi                                      #3970.349
        movq      8(%rcx,%rax), %xmm8                           #3972.614
        movhpd    8(%rsi,%rax), %xmm8                           #3972.582
        mulpd     %xmm8, %xmm1                                  #3974.22
        subpd     %xmm5, %xmm6                                  #3963.17
        movups    16896+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm11 #3965.50
        movq      (%rcx,%rax), %xmm3                            #3970.612
        mulpd     %xmm10, %xmm11                                #3966.32
        subpd     %xmm9, %xmm6                                  #3964.17
        movq      16(%rcx,%rax), %xmm10                         #3971.612
        movaps    %xmm5, %xmm9                                  #3982.15
        movhpd    (%rsi,%rax), %xmm3                            #3970.580
        movhpd    16(%rsi,%rax), %xmm10                         #3971.580
        mulpd     %xmm3, %xmm15                                 #3973.19
        mulpd     %xmm5, %xmm9                                  #3982.15
        addpd     %xmm8, %xmm3                                  #3988.13
        subpd     %xmm11, %xmm6                                 #3966.13
        movaps    %xmm10, %xmm14                                #3975.22
        movaps    %xmm10, %xmm13                                #3977.18
        addpd     %xmm1, %xmm14                                 #3975.22
        movaps    %xmm14, %xmm4                                 #3976.21
        addpd     %xmm15, %xmm4                                 #3976.21
        subpd     %xmm14, %xmm13                                #3977.18
        subpd     %xmm4, %xmm14                                 #3979.18
        addpd     %xmm13, %xmm1                                 #3978.18
        addpd     %xmm14, %xmm15                                #3980.18
        movups    17216+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm14 #3992.26
        mulpd     %xmm9, %xmm14                                 #3992.26
        addpd     %xmm15, %xmm1                                 #3981.21
        addpd     17152+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm14 #3992.14
        movups    17024+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm13 #3985.26
        mulpd     %xmm9, %xmm13                                 #3985.26
        mulpd     %xmm9, %xmm14                                 #3994.26
        addpd     16960+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm13 #3985.14
        addpd     17088+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm14 #3994.14
        mulpd     %xmm9, %xmm13                                 #3986.14
        mulpd     %xmm14, %xmm9                                 #3995.14
        mulpd     %xmm5, %xmm13                                 #3987.14
        mulpd     %xmm10, %xmm9                                 #3996.29
        mulpd     %xmm5, %xmm10                                 #3997.32
        mulpd     %xmm3, %xmm13                                 #3989.29
        subpd     %xmm10, %xmm3                                 #3997.13
        addpd     %xmm13, %xmm1                                 #3989.17
        mulpd     %xmm3, %xmm6                                  #3999.28
        addpd     %xmm9, %xmm1                                  #3996.17
        movq      24(%rcx,%rax), %xmm5                          #3998.612
        movhpd    24(%rsi,%rax), %xmm5                          #3998.580
        movups    16384+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm7 #3951.13
        addpd     %xmm6, %xmm5                                  #3999.16
        andps     %xmm2, %xmm7                                  #3951.13
        movaps    %xmm7, %xmm0                                  #3952.26
        cmpnlepd  16448+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm0 #3952.26
        addpd     %xmm5, %xmm1                                  #4000.17
        movmskpd  %xmm0, %edi                                   #4002.78
        addpd     %xmm1, %xmm4                                  #4001.14
        testl     %edi, %edi                                    #4003.66
        jne       ..B4.12       # Prob 5%                       #4003.66
                                # LOE rax rbx r12 r13 r14 r15 edx xmm0 xmm2 xmm4 xmm7
..B4.2:                         # Preds ..B4.12 ..B4.1
                                # Execution count [1.00e+00]
        testl     %edx, %edx                                    #4261.52
        jne       ..B4.4        # Prob 5%                       #4261.52
                                # LOE rbx r12 r13 r14 r15 edx xmm2 xmm4
..B4.3:                         # Preds ..B4.4 ..B4.10 ..B4.2
                                # Execution count [1.00e+00]
        movaps    %xmm4, %xmm0                                  #4264.12
        movq      %rbp, %rsp                                    #4264.12
        popq      %rbp                                          #4264.12
        .cfi_def_cfa 7, 8
        .cfi_restore 6
        ret                                                     #4264.12
        .cfi_def_cfa 6, 16
        .cfi_offset 6, -16
                                # LOE
..B4.4:                         # Preds ..B4.2
                                # Execution count [5.00e-02]: Infreq
        movups    %xmm2, 64(%rsp)                               #4261.197
        movups    %xmm4, 128(%rsp)                              #4261.270
        je        ..B4.3        # Prob 95%                      #4261.374
                                # LOE rbx r12 r13 r14 r15 edx xmm4
..B4.7:                         # Preds ..B4.4
                                # Execution count [2.25e-03]: Infreq
        xorl      %eax, %eax                                    #4261.454
        movq      %r12, 8(%rsp)                                 #4261.454[spill]
        .cfi_escape 0x10, 0x0c, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x48, 0xff, 0xff, 0xff, 0x22
        movl      %eax, %r12d                                   #4261.454
        movq      %r13, (%rsp)                                  #4261.454[spill]
        .cfi_escape 0x10, 0x0d, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x40, 0xff, 0xff, 0xff, 0x22
        movl      %edx, %r13d                                   #4261.454
                                # LOE rbx r12 r14 r15 r13d
..B4.8:                         # Preds ..B4.9 ..B4.7
                                # Execution count [1.25e-02]: Infreq
        btl       %r12d, %r13d                                  #4261.517
        jc        ..B4.11       # Prob 5%                       #4261.517
                                # LOE rbx r12 r14 r15 r13d
..B4.9:                         # Preds ..B4.11 ..B4.8
                                # Execution count [1.25e-02]: Infreq
        incl      %r12d                                         #4261.470
        cmpl      $2, %r12d                                     #4261.465
        jl        ..B4.8        # Prob 82%                      #4261.465
                                # LOE rbx r12 r14 r15 r13d
..B4.10:                        # Preds ..B4.9
                                # Execution count [2.25e-03]: Infreq
        movq      8(%rsp), %r12                                 #[spill]
        .cfi_restore 12
        movq      (%rsp), %r13                                  #[spill]
        .cfi_restore 13
        movups    128(%rsp), %xmm4                              #4261.673
        jmp       ..B4.3        # Prob 100%                     #4261.673
        .cfi_escape 0x10, 0x0c, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x48, 0xff, 0xff, 0xff, 0x22
        .cfi_escape 0x10, 0x0d, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x40, 0xff, 0xff, 0xff, 0x22
                                # LOE rbx r12 r13 r14 r15 xmm4
..B4.11:                        # Preds ..B4.8
                                # Execution count [6.25e-04]: Infreq
        lea       64(%rsp,%r12,8), %rdi                         #4261.546
        lea       128(%rsp,%r12,8), %rsi                        #4261.546
..___tag_value___jsvml_cos2_ha_e9.95:
#       __jsvml_dcos_ha_cout_rare_internal(const double *, double *)
        call      __jsvml_dcos_ha_cout_rare_internal             #4261.546
..___tag_value___jsvml_cos2_ha_e9.96:
        jmp       ..B4.9        # Prob 100%                     #4261.546
        .cfi_restore 12
        .cfi_restore 13
                                # LOE rbx r14 r15 r12d r13d
..B4.12:                        # Preds ..B4.1
                                # Execution count [5.00e-02]: Infreq
        movdqu    .L_2il0floatpacket.34(%rip), %xmm1            #4096.22
        lea       __jsvml_dcos_ha_reduction_data_internal(%rip), %r9 #4098.385
        pand      %xmm2, %xmm1                                  #4096.22
        psrlq     $52, %xmm1                                    #4097.22
        movups    16512+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm9 #4006.55
        movd      %xmm1, %ecx                                   #4098.124
        andps     %xmm9, %xmm7                                  #4007.17
        movups    %xmm4, (%rsp)                                 #[spill]
        movdqu    .L_2il0floatpacket.35(%rip), %xmm4            #4106.25
        pextrd    $2, %xmm1, %edi                               #4098.189
        pand      %xmm2, %xmm4                                  #4106.25
        cmpeqpd   %xmm9, %xmm7                                  #4008.25
        paddq     .L_2il0floatpacket.36(%rip), %xmm4            #4107.25
        movmskpd  %xmm7, %edx                                   #4010.48
        movdqa    %xmm4, %xmm7                                  #4115.16
        movdqu    .L_2il0floatpacket.37(%rip), %xmm3            #4108.21
        psrlq     $32, %xmm7                                    #4115.16
        pand      %xmm3, %xmm4                                  #4116.16
        lea       (%rcx,%rcx,2), %esi                           #4098.300
        shll      $3, %esi                                      #4098.300
        lea       (%rdi,%rdi,2), %r8d                           #4098.351
        shll      $3, %r8d                                      #4098.351
        movdqa    %xmm7, %xmm9                                  #4121.17
        movq      16(%rsi,%r9), %xmm8                           #4100.639
        movdqa    %xmm4, %xmm12                                 #4126.17
        movhpd    16(%r8,%r9), %xmm8                            #4100.607
        movdqa    %xmm4, %xmm13                                 #4125.17
        movaps    %xmm8, %xmm11                                 #4113.16
        pand      %xmm3, %xmm8                                  #4114.16
        movq      8(%rsi,%r9), %xmm14                           #4099.640
        psrlq     $32, %xmm11                                   #4113.16
        movhpd    8(%r8,%r9), %xmm14                            #4099.608
        movdqa    %xmm3, %xmm1                                  #4137.17
        pmuludq   %xmm11, %xmm9                                 #4121.17
        movaps    %xmm14, %xmm15                                #4111.16
        pmuludq   %xmm4, %xmm11                                 #4127.17
        pmuludq   %xmm7, %xmm8                                  #4122.17
        pand      %xmm3, %xmm14                                 #4112.16
        psrlq     $32, %xmm11                                   #4129.17
        pmuludq   %xmm14, %xmm12                                #4126.17
        psrlq     $32, %xmm15                                   #4111.16
        pmuludq   %xmm7, %xmm14                                 #4120.17
        pmuludq   %xmm15, %xmm13                                #4125.17
        pmuludq   %xmm7, %xmm15                                 #4119.17
        paddq     %xmm11, %xmm9                                 #4133.17
        pand      %xmm12, %xmm1                                 #4137.17
        movdqa    %xmm3, %xmm5                                  #4110.16
        movq      (%rsi,%r9), %xmm10                            #4098.639
        psrlq     $32, %xmm8                                    #4147.17
        paddq     %xmm9, %xmm1                                  #4142.17
        movhpd    (%r8,%r9), %xmm10                             #4098.607
        psrlq     $32, %xmm12                                   #4130.17
        pand      %xmm10, %xmm5                                 #4110.16
        movdqa    %xmm4, %xmm6                                  #4124.17
        paddq     %xmm1, %xmm8                                  #4148.17
        paddq     %xmm12, %xmm14                                #4134.17
        pmuludq   %xmm5, %xmm6                                  #4124.17
        pmuludq   %xmm5, %xmm7                                  #4118.17
        movdqa    %xmm3, %xmm11                                 #4138.17
        movaps    %xmm8, %xmm1                                  #4149.17
        pand      %xmm13, %xmm11                                #4138.17
        psrlq     $32, %xmm1                                    #4149.17
        paddq     %xmm14, %xmm11                                #4143.17
        psrlq     $32, %xmm13                                   #4131.17
        psrlq     $32, %xmm10                                   #4109.16
        paddq     %xmm11, %xmm1                                 #4150.17
        paddq     %xmm13, %xmm15                                #4135.17
        pmuludq   %xmm10, %xmm4                                 #4123.17
        movdqa    %xmm3, %xmm12                                 #4139.17
        movdqa    %xmm1, %xmm14                                 #4151.17
        pand      %xmm6, %xmm12                                 #4139.17
        psrlq     $32, %xmm14                                   #4151.17
        paddq     %xmm15, %xmm12                                #4144.17
        psrlq     $32, %xmm6                                    #4132.17
        pand      %xmm3, %xmm4                                  #4140.17
        paddq     %xmm12, %xmm14                                #4152.17
        paddq     %xmm6, %xmm7                                  #4136.17
        movdqa    %xmm14, %xmm11                                #4153.17
        pand      %xmm3, %xmm14                                 #4156.17
        paddq     %xmm7, %xmm4                                  #4145.17
        psrlq     $32, %xmm11                                   #4153.17
        psllq     $32, %xmm1                                    #4158.23
        paddq     %xmm4, %xmm11                                 #4154.17
        psllq     $32, %xmm11                                   #4157.23
        pand      %xmm3, %xmm8                                  #4155.17
        paddq     %xmm14, %xmm11                                #4159.23
        paddq     %xmm8, %xmm1                                  #4160.23
        movdqu    .L_2il0floatpacket.38(%rip), %xmm5            #4162.21
        movdqa    %xmm11, %xmm6                                 #4165.24
        movdqu    .L_2il0floatpacket.39(%rip), %xmm13           #4164.26
        pand      %xmm2, %xmm5                                  #4162.21
        movups    .L_2il0floatpacket.40(%rip), %xmm15           #4168.15
        psrlq     $12, %xmm6                                    #4165.24
        pxor      %xmm5, %xmm13                                 #4164.26
        movaps    %xmm15, %xmm10                                #4169.19
        por       %xmm13, %xmm6                                 #4166.24
        addpd     %xmm6, %xmm10                                 #4169.19
        movaps    %xmm10, %xmm8                                 #4170.9
        subpd     %xmm15, %xmm8                                 #4170.9
        movdqu    .L_2il0floatpacket.45(%rip), %xmm7            #4187.24
        movdqu    .L_2il0floatpacket.43(%rip), %xmm9            #4178.24
        pand      %xmm11, %xmm7                                 #4187.24
        movdqu    .L_2il0floatpacket.42(%rip), %xmm3            #4176.26
        pand      %xmm1, %xmm9                                  #4178.24
        psllq     $40, %xmm7                                    #4188.24
        psrlq     $24, %xmm1                                    #4189.23
        pxor      %xmm5, %xmm3                                  #4176.26
        por       %xmm1, %xmm7                                  #4190.24
        pxor      .L_2il0floatpacket.44(%rip), %xmm5            #4185.26
        psllq     $28, %xmm9                                    #4179.24
        subpd     %xmm8, %xmm6                                  #4171.17
        por       %xmm5, %xmm7                                  #4191.24
        movaps    %xmm6, %xmm11                                 #4195.11
        subpd     %xmm5, %xmm7                                  #4194.18
        addpd     %xmm7, %xmm11                                 #4195.11
        subpd     %xmm11, %xmm6                                 #4196.17
        por       %xmm3, %xmm9                                  #4180.24
        subpd     %xmm3, %xmm9                                  #4183.17
        addpd     %xmm6, %xmm7                                  #4197.18
        movups    .L_2il0floatpacket.49(%rip), %xmm12           #4203.16
        andps     %xmm11, %xmm12                                #4203.16
        addpd     %xmm7, %xmm9                                  #4198.11
        subpd     %xmm12, %xmm11                                #4204.17
        mulpd     .L_2il0floatpacket.46(%rip), %xmm9            #4208.12
        movups    .L_2il0floatpacket.47(%rip), %xmm4            #4200.16
        movaps    %xmm12, %xmm14                                #4205.16
        movups    .L_2il0floatpacket.48(%rip), %xmm1            #4201.17
        mulpd     %xmm4, %xmm14                                 #4205.16
        mulpd     %xmm11, %xmm4                                 #4206.12
        mulpd     %xmm1, %xmm12                                 #4207.12
        mulpd     %xmm11, %xmm1                                 #4209.12
        addpd     %xmm12, %xmm4                                 #4210.13
        addpd     %xmm1, %xmm9                                  #4211.13
        addpd     %xmm9, %xmm4                                  #4212.13
        movaps    %xmm4, %xmm3                                  #4213.13
        addpd     %xmm14, %xmm3                                 #4213.13
        movups    .L_2il0floatpacket.51(%rip), %xmm9            #4217.16
        movups    .L_2il0floatpacket.50(%rip), %xmm7            #4218.11
        movaps    %xmm9, %xmm8                                  #4219.17
        andps     %xmm2, %xmm7                                  #4218.11
        cmpltpd   %xmm7, %xmm8                                  #4219.17
        cmplepd   %xmm9, %xmm7                                  #4220.20
        subpd     %xmm3, %xmm14                                 #4214.16
        andps     .L_2il0floatpacket.41(%rip), %xmm10           #4174.19
        andps     %xmm2, %xmm7                                  #4221.24
        movd      %xmm10, %r10d                                 #4226.132
        andps     %xmm8, %xmm3                                  #4222.25
        orps      %xmm3, %xmm7                                  #4223.9
        movaps    %xmm7, %xmm3                                  #4230.26
        movaps    %xmm7, %xmm9                                  #4229.23
        shll      $5, %r10d                                     #4226.302
        pextrd    $2, %xmm10, %r11d                             #4226.194
        shll      $5, %r11d                                     #4226.353
        movq      8(%r10,%rax), %xmm12                          #4228.618
        movhpd    8(%r11,%rax), %xmm12                          #4228.586
        addpd     %xmm14, %xmm4                                 #4215.13
        mulpd     %xmm12, %xmm3                                 #4230.26
        movq      (%r10,%rax), %xmm5                            #4226.616
        andps     %xmm4, %xmm8                                  #4224.9
        movq      16(%r10,%rax), %xmm4                          #4227.616
        movhpd    (%r11,%rax), %xmm5                            #4226.584
        movhpd    16(%r11,%rax), %xmm4                          #4227.584
        mulpd     %xmm5, %xmm9                                  #4229.23
        addpd     %xmm12, %xmm5                                 #4244.17
        movaps    %xmm4, %xmm1                                  #4231.26
        movaps    %xmm4, %xmm10                                 #4233.22
        addpd     %xmm3, %xmm1                                  #4231.26
        movaps    %xmm1, %xmm6                                  #4232.25
        addpd     %xmm9, %xmm6                                  #4232.25
        subpd     %xmm1, %xmm10                                 #4233.22
        subpd     %xmm6, %xmm1                                  #4235.22
        addpd     %xmm10, %xmm3                                 #4234.22
        addpd     %xmm1, %xmm9                                  #4236.22
        movaps    %xmm7, %xmm1                                  #4238.19
        mulpd     %xmm7, %xmm1                                  #4238.19
        addpd     %xmm9, %xmm3                                  #4237.25
        movups    17024+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm11 #4241.30
        movups    17216+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm14 #4248.30
        mulpd     %xmm1, %xmm11                                 #4241.30
        mulpd     %xmm1, %xmm14                                 #4248.30
        movups    17152+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm15 #4248.18
        movups    16960+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm13 #4241.18
        addpd     %xmm11, %xmm13                                #4241.18
        addpd     %xmm14, %xmm15                                #4248.18
        mulpd     %xmm1, %xmm13                                 #4242.18
        mulpd     %xmm1, %xmm15                                 #4250.30
        mulpd     %xmm7, %xmm13                                 #4243.18
        mulpd     %xmm4, %xmm7                                  #4253.36
        mulpd     %xmm5, %xmm13                                 #4245.33
        subpd     %xmm7, %xmm5                                  #4253.17
        addpd     %xmm13, %xmm3                                 #4245.21
        mulpd     %xmm5, %xmm8                                  #4255.32
        movups    17088+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm11 #4250.18
        addpd     %xmm15, %xmm11                                #4250.18
        mulpd     %xmm11, %xmm1                                 #4251.18
        mulpd     %xmm4, %xmm1                                  #4252.33
        movq      24(%r10,%rax), %xmm4                          #4254.616
        movhpd    24(%r11,%rax), %xmm4                          #4254.584
        addpd     %xmm1, %xmm3                                  #4252.21
        addpd     %xmm8, %xmm4                                  #4255.20
        addpd     %xmm4, %xmm3                                  #4256.21
        addpd     %xmm3, %xmm6                                  #4257.24
        movups    (%rsp), %xmm4                                 #4258.18[spill]
        blendvpd  %xmm0, %xmm6, %xmm4                           #4258.18
        jmp       ..B4.2        # Prob 100%                     #4258.18
        .align    16,0x90
                                # LOE rbx r12 r13 r14 r15 edx xmm2 xmm4
        .cfi_endproc
# mark_end;
        .type   __jsvml_cos2_ha_e9,@function
        .size   __jsvml_cos2_ha_e9,.-__jsvml_cos2_ha_e9
..LN__jsvml_cos2_ha_e9.3:
        .data
# -- End  __jsvml_cos2_ha_e9
        .text
.L_2__routine_start___jsvml_cos4_ha_l9_4:
# -- Begin  __jsvml_cos4_ha_l9
        .text
# mark_begin;
        .align    16,0x90
        .globl __jsvml_cos4_ha_l9
# --- __jsvml_cos4_ha_l9(__m256d)
__jsvml_cos4_ha_l9:
# parameter 1: %ymm0
..B5.1:                         # Preds ..B5.0
                                # Execution count [1.00e+00]
        .byte     243                                           #4269.1
        .byte     15                                            #4615.18
        .byte     30                                            #4615.18
        .byte     250                                           #4615.18
        .cfi_startproc
..___tag_value___jsvml_cos4_ha_l9.102:
..L103:
                                                        #4269.1
        pushq     %rbp                                          #4269.1
        .cfi_def_cfa_offset 16
        movq      %rsp, %rbp                                    #4269.1
        .cfi_def_cfa 6, 16
        .cfi_offset 6, -16
        andq      $-64, %rsp                                    #4269.1
        subq      $192, %rsp                                    #4269.1
        lea       __jsvml_dcos_ha_data_internal_ha(%rip), %r8    #4342.728
        vmovupd   16576+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm11 #4327.49
        xorl      %esi, %esi                                    #4321.1
        vmovupd   16640+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm7 #4328.54
        vmovupd   16768+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm8 #4331.51
        vmovupd   16832+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm9 #4333.51
        vmovapd   %ymm0, %ymm14                                 #4269.1
        vfmadd213pd %ymm7, %ymm14, %ymm11                       #4329.13
        vsubpd    %ymm7, %ymm11, %ymm5                          #4330.13
        vfnmadd213pd %ymm14, %ymm5, %ymm8                       #4332.14
        vmovapd   %ymm9, %ymm4                                  #4334.17
        vfnmadd213pd %ymm8, %ymm5, %ymm4                        #4334.17
        vandps    16704+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm11, %ymm12 #4341.19
        vsubpd    %ymm4, %ymm8, %ymm10                          #4335.17
        vfnmadd231pd %ymm5, %ymm9, %ymm10                       #4336.17
        vfnmadd132pd 16896+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm10, %ymm5 #4338.13
        vandpd    16384+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm14, %ymm6 #4324.13
        vcmpnle_uqpd 16448+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm6, %ymm13 #4325.26
        vmovmskpd %ymm13, %r9d                                  #4372.78
        vextractf128 $1, %ymm12, %xmm2                          #4342.326
        vmovd     %xmm12, %eax                                  #4342.128
        vmovd     %xmm2, %ecx                                   #4342.307
        shll      $5, %eax                                      #4342.539
        vpextrd   $2, %xmm12, %edx                              #4342.216
        shll      $5, %ecx                                      #4342.641
        vpextrd   $2, %xmm2, %edi                               #4342.400
        shll      $5, %edx                                      #4342.590
        vmovq     (%rax,%r8), %xmm15                            #4342.1227
        vmovq     16(%rax,%r8), %xmm7                           #4343.1227
        shll      $5, %edi                                      #4342.692
        vmovq     (%rcx,%r8), %xmm3                             #4342.1427
        vmovq     16(%rcx,%r8), %xmm9                           #4343.1427
        vmovhpd   (%rdx,%r8), %xmm15, %xmm1                     #4342.1195
        vmovhpd   16(%rdx,%r8), %xmm7, %xmm8                    #4343.1195
        vmovq     8(%rax,%r8), %xmm11                           #4344.1229
        vmovhpd   (%rdi,%r8), %xmm3, %xmm0                      #4342.1395
        vmovhpd   16(%rdi,%r8), %xmm9, %xmm10                   #4343.1395
        vmovq     8(%rcx,%r8), %xmm15                           #4344.1429
        vmovhpd   8(%rdx,%r8), %xmm11, %xmm12                   #4344.1197
        vinsertf128 $1, %xmm0, %ymm1, %ymm3                     #4342.1149
        vinsertf128 $1, %xmm10, %ymm8, %ymm2                    #4343.1149
        vmovhpd   8(%rdi,%r8), %xmm15, %xmm1                    #4344.1397
        vmovaps   %ymm2, %ymm7                                  #4345.22
        vmovupd   16960+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm10 #4355.14
        vinsertf128 $1, %xmm1, %ymm12, %ymm0                    #4344.1151
        vfmadd231pd %ymm4, %ymm0, %ymm7                         #4345.22
        vmovaps   %ymm3, %ymm1                                  #4346.21
        vfmadd213pd %ymm7, %ymm4, %ymm1                         #4346.21
        vsubpd    %ymm7, %ymm2, %ymm8                           #4347.18
        vsubpd    %ymm1, %ymm7, %ymm9                           #4349.18
        vmulpd    %ymm4, %ymm4, %ymm7                           #4352.15
        vfmadd231pd %ymm4, %ymm0, %ymm8                         #4348.18
        vfmadd231pd %ymm3, %ymm4, %ymm9                         #4350.18
        vaddpd    %ymm0, %ymm3, %ymm3                           #4358.13
        vfmadd231pd 17024+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm7, %ymm10 #4355.14
        vmovupd   17152+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm0 #4362.14
        vaddpd    %ymm9, %ymm8, %ymm15                          #4351.21
        vmulpd    %ymm10, %ymm7, %ymm11                         #4356.14
        vfmadd231pd 17216+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm7, %ymm0 #4362.14
        vmulpd    %ymm11, %ymm4, %ymm8                          #4357.14
        vfmadd213pd 17088+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm7, %ymm0 #4364.14
        vfnmadd213pd %ymm3, %ymm2, %ymm4                        #4367.13
        vfmadd213pd %ymm15, %ymm3, %ymm8                        #4359.17
        vmulpd    %ymm0, %ymm7, %ymm7                           #4365.14
        vmovq     24(%rcx,%r8), %xmm3                           #4368.1427
        vfmadd213pd %ymm8, %ymm2, %ymm7                         #4366.17
        vmovq     24(%rax,%r8), %xmm2                           #4368.1227
        vmovhpd   24(%rdx,%r8), %xmm2, %xmm2                    #4368.1195
        vmovhpd   24(%rdi,%r8), %xmm3, %xmm8                    #4368.1395
        vinsertf128 $1, %xmm8, %ymm2, %ymm0                     #4368.1149
        vfmadd213pd %ymm0, %ymm4, %ymm5                         #4369.16
        vaddpd    %ymm5, %ymm7, %ymm4                           #4370.17
        vaddpd    %ymm4, %ymm1, %ymm0                           #4371.14
        testl     %r9d, %r9d                                    #4373.66
        jne       ..B5.12       # Prob 5%                       #4373.66
                                # LOE rbx r12 r13 r14 r15 esi ymm0 ymm6 ymm13 ymm14
..B5.2:                         # Preds ..B5.12 ..B5.1
                                # Execution count [1.00e+00]
        testl     %esi, %esi                                    #4618.52
        jne       ..B5.4        # Prob 5%                       #4618.52
                                # LOE rbx r12 r13 r14 r15 esi ymm0 ymm14
..B5.3:                         # Preds ..B5.4 ..B5.10 ..B5.2
                                # Execution count [1.00e+00]
        movq      %rbp, %rsp                                    #4621.12
        popq      %rbp                                          #4621.12
        .cfi_def_cfa 7, 8
        .cfi_restore 6
        ret                                                     #4621.12
        .cfi_def_cfa 6, 16
        .cfi_offset 6, -16
                                # LOE
..B5.4:                         # Preds ..B5.2
                                # Execution count [5.00e-02]: Infreq
        vmovupd   %ymm14, 64(%rsp)                              #4618.200
        vmovupd   %ymm0, 128(%rsp)                              #4618.276
        je        ..B5.3        # Prob 95%                      #4618.380
                                # LOE rbx r12 r13 r14 r15 esi ymm0
..B5.7:                         # Preds ..B5.4
                                # Execution count [2.25e-03]: Infreq
        xorl      %eax, %eax                                    #4618.460
                                # LOE rbx r12 r13 r14 r15 eax esi
..B5.15:                        # Preds ..B5.7
                                # Execution count [2.25e-03]: Infreq
        vzeroupper                                              #
        movq      %r12, 8(%rsp)                                 #[spill]
        .cfi_escape 0x10, 0x0c, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x48, 0xff, 0xff, 0xff, 0x22
        movl      %eax, %r12d                                   #
        movq      %r13, (%rsp)                                  #[spill]
        .cfi_escape 0x10, 0x0d, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x40, 0xff, 0xff, 0xff, 0x22
        movl      %esi, %r13d                                   #
                                # LOE rbx r12 r14 r15 r13d
..B5.8:                         # Preds ..B5.9 ..B5.15
                                # Execution count [1.25e-02]: Infreq
        btl       %r12d, %r13d                                  #4618.523
        jc        ..B5.11       # Prob 5%                       #4618.523
                                # LOE rbx r12 r14 r15 r13d
..B5.9:                         # Preds ..B5.11 ..B5.8
                                # Execution count [1.25e-02]: Infreq
        incl      %r12d                                         #4618.476
        cmpl      $4, %r12d                                     #4618.471
        jl        ..B5.8        # Prob 82%                      #4618.471
                                # LOE rbx r12 r14 r15 r13d
..B5.10:                        # Preds ..B5.9
                                # Execution count [2.25e-03]: Infreq
        movq      8(%rsp), %r12                                 #[spill]
        .cfi_restore 12
        movq      (%rsp), %r13                                  #[spill]
        .cfi_restore 13
        vmovupd   128(%rsp), %ymm0                              #4618.682
        jmp       ..B5.3        # Prob 100%                     #4618.682
        .cfi_escape 0x10, 0x0c, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x48, 0xff, 0xff, 0xff, 0x22
        .cfi_escape 0x10, 0x0d, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x40, 0xff, 0xff, 0xff, 0x22
                                # LOE rbx r12 r13 r14 r15 ymm0
..B5.11:                        # Preds ..B5.8
                                # Execution count [6.25e-04]: Infreq
        lea       64(%rsp,%r12,8), %rdi                         #4618.552
        lea       128(%rsp,%r12,8), %rsi                        #4618.552
..___tag_value___jsvml_cos4_ha_l9.120:
#       __jsvml_dcos_ha_cout_rare_internal(const double *, double *)
        call      __jsvml_dcos_ha_cout_rare_internal             #4618.552
..___tag_value___jsvml_cos4_ha_l9.121:
        jmp       ..B5.9        # Prob 100%                     #4618.552
        .cfi_restore 12
        .cfi_restore 13
                                # LOE rbx r14 r15 r12d r13d
..B5.12:                        # Preds ..B5.1
                                # Execution count [5.00e-02]: Infreq
        vmovupd   16512+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm12 #4376.58
        lea       __jsvml_dcos_ha_reduction_data_internal(%rip), %rcx #4468.736
        vmovupd   %ymm0, (%rsp)                                 #[spill]
        vpand     .L_2il0floatpacket.70(%rip), %ymm14, %ymm7    #4466.18
        vandpd    %ymm6, %ymm12, %ymm8                          #4377.17
        vpsrlq    $52, %ymm7, %ymm6                             #4467.18
        vcmpeqpd  %ymm12, %ymm8, %ymm9                          #4378.25
        vmovmskpd %ymm9, %esi                                   #4380.48
        vextractf128 $1, %ymm6, %xmm1                           #4468.328
        vmovd     %xmm6, %edi                                   #4468.124
        vmovd     %xmm1, %r9d                                   #4468.309
        vpextrd   $2, %xmm6, %r8d                               #4468.215
        lea       (%rdi,%rdi,2), %edx                           #4468.547
        vpextrd   $2, %xmm1, %r11d                              #4468.405
        lea       (%r9,%r9,2), %r10d                            #4468.649
        vpand     .L_2il0floatpacket.71(%rip), %ymm14, %ymm6    #4476.21
        lea       __jsvml_dcos_ha_data_internal_ha(%rip), %r9    #4585.732
        shll      $3, %edx                                      #4468.547
        lea       (%r8,%r8,2), %eax                             #4468.598
        shll      $3, %eax                                      #4468.598
        lea       (%r11,%r11,2), %edi                           #4468.700
        vmovq     16(%rdx,%rcx), %xmm12                         #4470.1284
        vmovhpd   16(%rax,%rcx), %xmm12, %xmm11                 #4470.1252
        shll      $3, %r10d                                     #4468.649
        vmovdqu   .L_2il0floatpacket.73(%rip), %ymm12           #4478.17
        vmovq     16(%r10,%rcx), %xmm9                          #4470.1484
        vpaddq    .L_2il0floatpacket.72(%rip), %ymm6, %ymm1     #4477.21
        vmovq     (%rdx,%rcx), %xmm3                            #4468.1284
        vmovq     (%r10,%rcx), %xmm4                            #4468.1484
        vmovhpd   (%rax,%rcx), %xmm3, %xmm10                    #4468.1252
        shll      $3, %edi                                      #4468.700
        vmovhpd   16(%rdi,%rcx), %xmm9, %xmm7                   #4470.1452
        vmovhpd   (%rdi,%rcx), %xmm4, %xmm0                     #4468.1452
        vpsrlq    $32, %ymm1, %ymm9                             #4485.12
        vpand     %ymm12, %ymm1, %ymm6                          #4486.12
        vmovq     8(%rdx,%rcx), %xmm2                           #4469.1285
        vmovq     8(%r10,%rcx), %xmm8                           #4469.1485
        vmovhpd   8(%rax,%rcx), %xmm2, %xmm15                   #4469.1253
        vmovhpd   8(%rdi,%rcx), %xmm8, %xmm5                    #4469.1453
        vinsertf128 $1, %xmm7, %ymm11, %ymm11                   #4470.1206
        vinsertf128 $1, %xmm0, %ymm10, %ymm10                   #4468.1206
        vpsrlq    $32, %ymm11, %ymm0                            #4483.12
        vpand     %ymm12, %ymm10, %ymm7                         #4480.12
        vpsrlq    $32, %ymm10, %ymm10                           #4479.12
        vpmuludq  %ymm7, %ymm6, %ymm8                           #4494.13
        vinsertf128 $1, %xmm5, %ymm15, %ymm3                    #4469.1207
        vpand     %ymm12, %ymm3, %ymm2                          #4482.12
        vpand     %ymm12, %ymm11, %ymm15                        #4484.12
        vpsrlq    $32, %ymm3, %ymm4                             #4481.12
        vpmuludq  %ymm0, %ymm9, %ymm11                          #4491.13
        vpmuludq  %ymm0, %ymm6, %ymm0                           #4497.13
        vpsrlq    $32, %ymm0, %ymm0                             #4499.13
        vpmuludq  %ymm2, %ymm6, %ymm1                           #4496.13
        vpmuludq  %ymm15, %ymm9, %ymm5                          #4492.13
        vpand     %ymm12, %ymm1, %ymm15                         #4507.13
        vpaddq    %ymm0, %ymm11, %ymm11                         #4503.13
        vpsrlq    $32, %ymm5, %ymm5                             #4517.13
        vpsrlq    $32, %ymm1, %ymm1                             #4500.13
        vpaddq    %ymm11, %ymm15, %ymm15                        #4512.13
        vpmuludq  %ymm4, %ymm6, %ymm3                           #4495.13
        vpmuludq  %ymm2, %ymm9, %ymm2                           #4490.13
        vpaddq    %ymm15, %ymm5, %ymm11                         #4518.13
        vpand     %ymm12, %ymm3, %ymm15                         #4508.13
        vpaddq    %ymm1, %ymm2, %ymm0                           #4504.13
        vpand     %ymm12, %ymm8, %ymm2                          #4509.13
        vpsrlq    $32, %ymm11, %ymm5                            #4519.13
        vpsrlq    $32, %ymm8, %ymm8                             #4502.13
        vpaddq    %ymm0, %ymm15, %ymm15                         #4513.13
        vpaddq    %ymm15, %ymm5, %ymm5                          #4520.13
        vpsrlq    $32, %ymm3, %ymm15                            #4501.13
        vpsrlq    $32, %ymm5, %ymm0                             #4521.13
        vpsllq    $32, %ymm5, %ymm5                             #4528.19
        vpmuludq  %ymm4, %ymm9, %ymm4                           #4489.13
        vpaddq    %ymm15, %ymm4, %ymm3                          #4505.13
        vpaddq    %ymm3, %ymm2, %ymm1                           #4514.13
        vpmuludq  %ymm10, %ymm6, %ymm15                         #4493.13
        vpmuludq  %ymm7, %ymm9, %ymm9                           #4488.13
        vpaddq    %ymm1, %ymm0, %ymm1                           #4522.13
        vpand     %ymm12, %ymm15, %ymm6                         #4510.13
        vpaddq    %ymm8, %ymm9, %ymm7                           #4506.13
        vpsrlq    $32, %ymm1, %ymm4                             #4523.13
        vpand     %ymm12, %ymm1, %ymm1                          #4526.13
        vpaddq    %ymm7, %ymm6, %ymm3                           #4515.13
        vpand     %ymm12, %ymm11, %ymm12                        #4525.13
        vpaddq    %ymm3, %ymm4, %ymm10                          #4524.13
        vpaddq    %ymm12, %ymm5, %ymm6                          #4530.19
        vmovupd   .L_2il0floatpacket.76(%rip), %ymm4            #4538.15
        vpsllq    $32, %ymm10, %ymm0                            #4527.19
        vpand     .L_2il0floatpacket.74(%rip), %ymm14, %ymm10   #4532.17
        vpand     .L_2il0floatpacket.79(%rip), %ymm6, %ymm12    #4548.20
        vpsrlq    $24, %ymm6, %ymm6                             #4559.19
        vpaddq    %ymm1, %ymm0, %ymm3                           #4529.19
        vpxor     .L_2il0floatpacket.75(%rip), %ymm10, %ymm2    #4534.22
        vpxor     .L_2il0floatpacket.78(%rip), %ymm10, %ymm1    #4546.22
        vpsrlq    $12, %ymm3, %ymm11                            #4535.20
        vpand     .L_2il0floatpacket.81(%rip), %ymm3, %ymm3     #4557.20
        vpor      %ymm2, %ymm11, %ymm15                         #4536.20
        vpsllq    $40, %ymm3, %ymm2                             #4558.20
        vpsllq    $28, %ymm12, %ymm11                           #4549.20
        vaddpd    %ymm4, %ymm15, %ymm5                          #4539.19
        vpor      %ymm1, %ymm11, %ymm0                          #4550.20
        vsubpd    %ymm4, %ymm5, %ymm8                           #4540.9
        vpor      %ymm6, %ymm2, %ymm4                           #4560.20
        vsubpd    %ymm8, %ymm15, %ymm7                          #4541.17
        vsubpd    %ymm1, %ymm0, %ymm15                          #4553.17
        vpxor     .L_2il0floatpacket.80(%rip), %ymm10, %ymm8    #4555.22
        vmovupd   .L_2il0floatpacket.85(%rip), %ymm0            #4576.16
        vpor      %ymm8, %ymm4, %ymm10                          #4561.20
        vandps    .L_2il0floatpacket.77(%rip), %ymm5, %ymm9     #4544.15
        vsubpd    %ymm8, %ymm10, %ymm5                          #4564.18
        vaddpd    %ymm5, %ymm7, %ymm12                          #4565.11
        vsubpd    %ymm12, %ymm7, %ymm7                          #4566.17
        vaddpd    %ymm7, %ymm5, %ymm8                           #4567.18
        vmovupd   .L_2il0floatpacket.82(%rip), %ymm5            #4569.16
        vaddpd    %ymm8, %ymm15, %ymm10                         #4568.11
        vmulpd    %ymm12, %ymm5, %ymm2                          #4571.13
        vmovapd   %ymm5, %ymm15                                 #4572.13
        vfmsub213pd %ymm2, %ymm12, %ymm15                       #4572.13
        vfmadd132pd .L_2il0floatpacket.83(%rip), %ymm15, %ymm12 #4573.13
        vandpd    .L_2il0floatpacket.84(%rip), %ymm14, %ymm11   #4577.11
        vcmpgt_oqpd %ymm0, %ymm11, %ymm6                        #4578.17
        vcmple_oqpd %ymm0, %ymm11, %ymm1                        #4579.20
        vfmadd213pd %ymm12, %ymm5, %ymm10                       #4574.13
        vandpd    %ymm14, %ymm1, %ymm3                          #4580.24
        vandpd    %ymm2, %ymm6, %ymm4                           #4581.25
        vorpd     %ymm4, %ymm3, %ymm8                           #4582.9
        vandpd    %ymm10, %ymm6, %ymm5                          #4583.9
        vextractf128 $1, %ymm9, %xmm11                          #4585.330
        vmovd     %xmm9, %eax                                   #4585.132
        vmovd     %xmm11, %ecx                                  #4585.311
        shll      $5, %eax                                      #4585.543
        vpextrd   $2, %xmm9, %edx                               #4585.220
        shll      $5, %ecx                                      #4585.645
        vpextrd   $2, %xmm11, %r8d                              #4585.404
        shll      $5, %edx                                      #4585.594
        vmovq     (%rax,%r9), %xmm15                            #4585.1231
        vmovq     16(%rax,%r9), %xmm2                           #4586.1231
        vmovq     8(%rax,%r9), %xmm7                            #4587.1233
        shll      $5, %r8d                                      #4585.696
        vmovq     (%rcx,%r9), %xmm0                             #4585.1431
        vmovq     16(%rcx,%r9), %xmm4                           #4586.1431
        vmovq     8(%rcx,%r9), %xmm10                           #4587.1433
        vmovhpd   (%rdx,%r9), %xmm15, %xmm12                    #4585.1199
        vmovhpd   16(%rdx,%r9), %xmm2, %xmm3                    #4586.1199
        vmovhpd   8(%rdx,%r9), %xmm7, %xmm9                     #4587.1201
        vmovhpd   (%r8,%r9), %xmm0, %xmm1                       #4585.1399
        vmovhpd   16(%r8,%r9), %xmm4, %xmm6                     #4586.1399
        vmovhpd   8(%r8,%r9), %xmm10, %xmm15                    #4587.1401
        vmovapd   %ymm8, %ymm0                                  #4588.26
        vmulpd    %ymm8, %ymm8, %ymm10                          #4595.19
        vinsertf128 $1, %xmm1, %ymm12, %ymm11                   #4585.1153
        vinsertf128 $1, %xmm6, %ymm3, %ymm12                    #4586.1153
        vinsertf128 $1, %xmm15, %ymm9, %ymm6                    #4587.1155
        vfmadd213pd %ymm12, %ymm6, %ymm0                        #4588.26
        vmovupd   16960+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm3 #4598.18
        vsubpd    %ymm0, %ymm12, %ymm1                          #4590.22
        vfmadd231pd 17024+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm10, %ymm3 #4598.18
        vfmadd231pd %ymm8, %ymm6, %ymm1                         #4591.22
        vmulpd    %ymm3, %ymm10, %ymm4                          #4599.18
        vmovaps   %ymm11, %ymm15                                #4589.25
        vfmadd213pd %ymm0, %ymm8, %ymm15                        #4589.25
        vsubpd    %ymm15, %ymm0, %ymm2                          #4592.22
        vmulpd    %ymm4, %ymm8, %ymm0                           #4600.18
        vfmadd231pd %ymm11, %ymm8, %ymm2                        #4593.22
        vaddpd    %ymm2, %ymm1, %ymm7                           #4594.25
        vaddpd    %ymm6, %ymm11, %ymm1                          #4601.17
        vmovupd   17152+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm11 #4605.18
        vfmadd213pd %ymm7, %ymm1, %ymm0                         #4602.21
        vfnmadd213pd %ymm1, %ymm12, %ymm8                       #4610.17
        vmovq     24(%rcx,%r9), %xmm1                           #4611.1431
        vfmadd231pd 17216+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm10, %ymm11 #4605.18
        vfmadd213pd 17088+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm10, %ymm11 #4607.18
        vmulpd    %ymm11, %ymm10, %ymm3                         #4608.18
        vfmadd213pd %ymm0, %ymm12, %ymm3                        #4609.21
        vmovq     24(%rax,%r9), %xmm12                          #4611.1231
        vmovhpd   24(%rdx,%r9), %xmm12, %xmm0                   #4611.1199
        vmovhpd   24(%r8,%r9), %xmm1, %xmm12                    #4611.1399
        vinsertf128 $1, %xmm12, %ymm0, %ymm2                    #4611.1153
        vfmadd213pd %ymm2, %ymm8, %ymm5                         #4612.20
        vmovupd   (%rsp), %ymm0                                 #4615.18[spill]
        vaddpd    %ymm5, %ymm3, %ymm5                           #4613.21
        vaddpd    %ymm5, %ymm15, %ymm8                          #4614.24
        vblendvpd %ymm13, %ymm8, %ymm0, %ymm0                   #4615.18
        jmp       ..B5.2        # Prob 100%                     #4615.18
        .align    16,0x90
                                # LOE rbx r12 r13 r14 r15 esi ymm0 ymm14
        .cfi_endproc
# mark_end;
        .type   __jsvml_cos4_ha_l9,@function
        .size   __jsvml_cos4_ha_l9,.-__jsvml_cos4_ha_l9
..LN__jsvml_cos4_ha_l9.4:
        .data
# -- End  __jsvml_cos4_ha_l9
        .text
.L_2__routine_start___jsvml_cos2_ha_l9_5:
# -- Begin  __jsvml_cos2_ha_l9
        .text
# mark_begin;
        .align    16,0x90
        .globl __jsvml_cos2_ha_l9
# --- __jsvml_cos2_ha_l9(__m128d)
__jsvml_cos2_ha_l9:
# parameter 1: %xmm0
..B6.1:                         # Preds ..B6.0
                                # Execution count [1.00e+00]
        .byte     243                                           #4626.1
        .byte     15                                            #4972.18
        .byte     30                                            #4972.18
        .byte     250                                           #4972.18
        .cfi_startproc
..___tag_value___jsvml_cos2_ha_l9.127:
..L128:
                                                        #4626.1
        pushq     %rbp                                          #4626.1
        .cfi_def_cfa_offset 16
        movq      %rsp, %rbp                                    #4626.1
        .cfi_def_cfa 6, 16
        .cfi_offset 6, -16
        andq      $-64, %rsp                                    #4626.1
        subq      $192, %rsp                                    #4626.1
        vmovapd   %xmm0, %xmm14                                 #4626.1
        vmovupd   16576+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm12 #4684.46
        lea       __jsvml_dcos_ha_data_internal_ha(%rip), %rsi   #4699.383
        vmovupd   16640+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm8 #4685.51
        xorl      %eax, %eax                                    #4678.1
        vfmadd213pd %xmm8, %xmm14, %xmm12                       #4686.13
        vmovupd   16768+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm9 #4688.48
        vmovupd   16832+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm10 #4690.48
        vandpd    16384+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm14, %xmm7 #4681.13
        vcmpnlepd 16448+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm7, %xmm0 #4682.26
        vsubpd    %xmm8, %xmm12, %xmm5                          #4687.13
        vmovmskpd %xmm0, %edi                                   #4729.78
        vandps    16704+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm12, %xmm13 #4698.19
        vfnmadd213pd %xmm14, %xmm5, %xmm9                       #4689.14
        vmovd     %xmm13, %edx                                  #4699.128
        vmovapd   %xmm9, %xmm6                                  #4691.17
        vfnmadd231pd %xmm5, %xmm10, %xmm6                       #4691.17
        shll      $5, %edx                                      #4699.298
        vmovapd   %xmm6, %xmm8                                  #4702.22
        vpextrd   $2, %xmm13, %ecx                              #4699.190
        vsubpd    %xmm6, %xmm9, %xmm11                          #4692.17
        shll      $5, %ecx                                      #4699.349
        vmovq     16(%rdx,%rsi), %xmm2                          #4700.612
        vmovq     8(%rdx,%rsi), %xmm1                           #4701.614
        vmovhpd   16(%rcx,%rsi), %xmm2, %xmm3                   #4700.580
        vmovhpd   8(%rcx,%rsi), %xmm1, %xmm1                    #4701.582
        vmovq     (%rdx,%rsi), %xmm15                           #4699.612
        vfmadd213pd %xmm3, %xmm1, %xmm8                         #4702.22
        vmovhpd   (%rcx,%rsi), %xmm15, %xmm4                    #4699.580
        vmulpd    %xmm6, %xmm6, %xmm15                          #4709.15
        vfnmadd231pd %xmm5, %xmm10, %xmm11                      #4693.17
        vmovapd   %xmm8, %xmm2                                  #4703.21
        vfmadd231pd %xmm4, %xmm6, %xmm2                         #4703.21
        vsubpd    %xmm8, %xmm3, %xmm9                           #4704.18
        vfnmadd132pd 16896+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm11, %xmm5 #4695.13
        vsubpd    %xmm2, %xmm8, %xmm10                          #4706.18
        vfmadd231pd %xmm6, %xmm1, %xmm9                         #4705.18
        vaddpd    %xmm1, %xmm4, %xmm1                           #4715.13
        vfmadd231pd %xmm4, %xmm6, %xmm10                        #4707.18
        vmovupd   16960+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm11 #4712.14
        vmovupd   17152+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm4 #4719.14
        vfmadd231pd 17024+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm15, %xmm11 #4712.14
        vfmadd231pd 17216+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm15, %xmm4 #4719.14
        vaddpd    %xmm10, %xmm9, %xmm13                         #4708.21
        vmulpd    %xmm11, %xmm15, %xmm12                        #4713.14
        vfmadd213pd 17088+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm15, %xmm4 #4721.14
        vmulpd    %xmm12, %xmm6, %xmm8                          #4714.14
        vmulpd    %xmm4, %xmm15, %xmm9                          #4722.14
        vfmadd213pd %xmm13, %xmm1, %xmm8                        #4716.17
        vfnmadd213pd %xmm1, %xmm3, %xmm6                        #4724.13
        vfmadd213pd %xmm8, %xmm3, %xmm9                         #4723.17
        vmovq     24(%rdx,%rsi), %xmm3                          #4725.612
        vmovhpd   24(%rcx,%rsi), %xmm3, %xmm1                   #4725.580
        vfmadd213pd %xmm1, %xmm6, %xmm5                         #4726.16
        vaddpd    %xmm5, %xmm9, %xmm5                           #4727.17
        vaddpd    %xmm5, %xmm2, %xmm1                           #4728.14
        testl     %edi, %edi                                    #4730.66
        jne       ..B6.12       # Prob 5%                       #4730.66
                                # LOE rbx r12 r13 r14 r15 eax xmm0 xmm1 xmm7 xmm14
..B6.2:                         # Preds ..B6.12 ..B6.1
                                # Execution count [1.00e+00]
        testl     %eax, %eax                                    #4975.52
        jne       ..B6.4        # Prob 5%                       #4975.52
                                # LOE rbx r12 r13 r14 r15 eax xmm1 xmm14
..B6.3:                         # Preds ..B6.4 ..B6.10 ..B6.2
                                # Execution count [1.00e+00]
        movaps    %xmm1, %xmm0                                  #4978.12
        movq      %rbp, %rsp                                    #4978.12
        popq      %rbp                                          #4978.12
        .cfi_def_cfa 7, 8
        .cfi_restore 6
        ret                                                     #4978.12
        .cfi_def_cfa 6, 16
        .cfi_offset 6, -16
                                # LOE
..B6.4:                         # Preds ..B6.2
                                # Execution count [5.00e-02]: Infreq
        vmovupd   %xmm14, 64(%rsp)                              #4975.197
        vmovupd   %xmm1, 128(%rsp)                              #4975.270
        je        ..B6.3        # Prob 95%                      #4975.374
                                # LOE rbx r12 r13 r14 r15 eax xmm1
..B6.7:                         # Preds ..B6.4
                                # Execution count [2.25e-03]: Infreq
        xorl      %edx, %edx                                    #4975.454
        movq      %r12, 8(%rsp)                                 #4975.454[spill]
        .cfi_escape 0x10, 0x0c, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x48, 0xff, 0xff, 0xff, 0x22
        movl      %edx, %r12d                                   #4975.454
        movq      %r13, (%rsp)                                  #4975.454[spill]
        .cfi_escape 0x10, 0x0d, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x40, 0xff, 0xff, 0xff, 0x22
        movl      %eax, %r13d                                   #4975.454
                                # LOE rbx r12 r14 r15 r13d
..B6.8:                         # Preds ..B6.9 ..B6.7
                                # Execution count [1.25e-02]: Infreq
        btl       %r12d, %r13d                                  #4975.517
        jc        ..B6.11       # Prob 5%                       #4975.517
                                # LOE rbx r12 r14 r15 r13d
..B6.9:                         # Preds ..B6.11 ..B6.8
                                # Execution count [1.25e-02]: Infreq
        incl      %r12d                                         #4975.470
        cmpl      $2, %r12d                                     #4975.465
        jl        ..B6.8        # Prob 82%                      #4975.465
                                # LOE rbx r12 r14 r15 r13d
..B6.10:                        # Preds ..B6.9
                                # Execution count [2.25e-03]: Infreq
        movq      8(%rsp), %r12                                 #[spill]
        .cfi_restore 12
        movq      (%rsp), %r13                                  #[spill]
        .cfi_restore 13
        movups    128(%rsp), %xmm1                              #4975.673
        jmp       ..B6.3        # Prob 100%                     #4975.673
        .cfi_escape 0x10, 0x0c, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x48, 0xff, 0xff, 0xff, 0x22
        .cfi_escape 0x10, 0x0d, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x40, 0xff, 0xff, 0xff, 0x22
                                # LOE rbx r12 r13 r14 r15 xmm1
..B6.11:                        # Preds ..B6.8
                                # Execution count [6.25e-04]: Infreq
        lea       64(%rsp,%r12,8), %rdi                         #4975.546
        lea       128(%rsp,%r12,8), %rsi                        #4975.546
..___tag_value___jsvml_cos2_ha_l9.145:
#       __jsvml_dcos_ha_cout_rare_internal(const double *, double *)
        call      __jsvml_dcos_ha_cout_rare_internal             #4975.546
..___tag_value___jsvml_cos2_ha_l9.146:
        jmp       ..B6.9        # Prob 100%                     #4975.546
        .cfi_restore 12
        .cfi_restore 13
                                # LOE rbx r14 r15 r12d r13d
..B6.12:                        # Preds ..B6.1
                                # Execution count [5.00e-02]: Infreq
        vmovupd   16512+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm13 #4733.55
        lea       __jsvml_dcos_ha_reduction_data_internal(%rip), %r8 #4825.385
        vpand     .L_2il0floatpacket.34(%rip), %xmm14, %xmm8    #4823.18
        vandpd    %xmm7, %xmm13, %xmm9                          #4734.17
        vpsrlq    $52, %xmm8, %xmm7                             #4824.18
        lea       __jsvml_dcos_ha_data_internal_ha(%rip), %r11   #4942.387
        vmovd     %xmm7, %edx                                   #4825.124
        vmovupd   %xmm1, (%rsp)                                 #[spill]
        vpand     .L_2il0floatpacket.35(%rip), %xmm14, %xmm1    #4833.21
        vpextrd   $2, %xmm7, %esi                               #4825.189
        vcmpeqpd  %xmm13, %xmm9, %xmm10                         #4735.25
        vpaddq    .L_2il0floatpacket.36(%rip), %xmm1, %xmm15    #4834.21
        vmovmskpd %xmm10, %eax                                  #4737.48
        vmovdqu   .L_2il0floatpacket.37(%rip), %xmm13           #4835.17
        vpsrlq    $32, %xmm15, %xmm10                           #4842.12
        vpand     %xmm13, %xmm15, %xmm7                         #4843.12
        lea       (%rdx,%rdx,2), %ecx                           #4825.300
        shll      $3, %ecx                                      #4825.300
        lea       (%rsi,%rsi,2), %edi                           #4825.351
        shll      $3, %edi                                      #4825.351
        vmovq     16(%rcx,%r8), %xmm5                           #4827.639
        vmovhpd   16(%rdi,%r8), %xmm5, %xmm12                   #4827.607
        vpand     %xmm13, %xmm12, %xmm6                         #4841.12
        vpsrlq    $32, %xmm12, %xmm1                            #4840.12
        vpmuludq  %xmm6, %xmm10, %xmm12                         #4849.13
        vmovq     8(%rcx,%r8), %xmm2                            #4826.640
        vpsrlq    $32, %xmm12, %xmm6                            #4874.13
        vmovhpd   8(%rdi,%r8), %xmm2, %xmm3                     #4826.608
        vpmuludq  %xmm1, %xmm10, %xmm12                         #4848.13
        vpsrlq    $32, %xmm3, %xmm5                             #4838.12
        vpmuludq  %xmm1, %xmm7, %xmm1                           #4854.13
        vpand     %xmm13, %xmm3, %xmm3                          #4839.12
        vpsrlq    $32, %xmm1, %xmm1                             #4856.13
        vpmuludq  %xmm3, %xmm7, %xmm2                           #4853.13
        vpmuludq  %xmm3, %xmm10, %xmm3                          #4847.13
        vpaddq    %xmm1, %xmm12, %xmm12                         #4860.13
        vmovq     (%rcx,%r8), %xmm4                             #4825.639
        vpand     %xmm13, %xmm2, %xmm15                         #4864.13
        vmovhpd   (%rdi,%r8), %xmm4, %xmm11                     #4825.607
        vpsrlq    $32, %xmm2, %xmm2                             #4857.13
        vpmuludq  %xmm5, %xmm7, %xmm4                           #4852.13
        vpand     %xmm13, %xmm11, %xmm8                         #4837.12
        vpmuludq  %xmm5, %xmm10, %xmm5                          #4846.13
        vpmuludq  %xmm8, %xmm7, %xmm9                           #4851.13
        vpmuludq  %xmm8, %xmm10, %xmm10                         #4845.13
        vpaddq    %xmm12, %xmm15, %xmm15                        #4869.13
        vpaddq    %xmm2, %xmm3, %xmm2                           #4861.13
        vpaddq    %xmm15, %xmm6, %xmm12                         #4875.13
        vpand     %xmm13, %xmm4, %xmm15                         #4865.13
        vpsrlq    $32, %xmm12, %xmm6                            #4876.13
        vpaddq    %xmm2, %xmm15, %xmm15                         #4870.13
        vpsrlq    $32, %xmm4, %xmm4                             #4858.13
        vpand     %xmm13, %xmm9, %xmm3                          #4866.13
        vpaddq    %xmm15, %xmm6, %xmm6                          #4877.13
        vpaddq    %xmm4, %xmm5, %xmm15                          #4862.13
        vpsrlq    $32, %xmm11, %xmm11                           #4836.12
        vpsrlq    $32, %xmm9, %xmm9                             #4859.13
        vpaddq    %xmm15, %xmm3, %xmm4                          #4871.13
        vpaddq    %xmm9, %xmm10, %xmm8                          #4863.13
        vpmuludq  %xmm11, %xmm7, %xmm15                         #4850.13
        vpsrlq    $32, %xmm6, %xmm1                             #4878.13
        vpand     %xmm13, %xmm15, %xmm7                         #4867.13
        vpaddq    %xmm4, %xmm1, %xmm2                           #4879.13
        vpaddq    %xmm8, %xmm7, %xmm4                           #4872.13
        vpsrlq    $32, %xmm2, %xmm5                             #4880.13
        vpand     %xmm13, %xmm2, %xmm2                          #4883.13
        vpaddq    %xmm4, %xmm5, %xmm11                          #4881.13
        vpsllq    $32, %xmm11, %xmm1                            #4884.19
        vpsllq    $32, %xmm6, %xmm6                             #4885.19
        vpaddq    %xmm2, %xmm1, %xmm4                           #4886.19
        vpand     .L_2il0floatpacket.38(%rip), %xmm14, %xmm11   #4889.17
        vpand     %xmm13, %xmm12, %xmm13                        #4882.13
        vpxor     .L_2il0floatpacket.39(%rip), %xmm11, %xmm9    #4891.22
        vpsrlq    $12, %xmm4, %xmm15                            #4892.20
        vpaddq    %xmm13, %xmm6, %xmm7                          #4887.19
        vmovups   .L_2il0floatpacket.40(%rip), %xmm6            #4895.15
        vpor      %xmm9, %xmm15, %xmm13                         #4893.20
        vaddpd    %xmm6, %xmm13, %xmm10                         #4896.19
        vsubpd    %xmm6, %xmm10, %xmm12                         #4897.9
        vpand     .L_2il0floatpacket.45(%rip), %xmm4, %xmm9     #4914.20
        vsubpd    %xmm12, %xmm13, %xmm8                         #4898.17
        vpand     .L_2il0floatpacket.43(%rip), %xmm7, %xmm1     #4905.20
        vpsllq    $40, %xmm9, %xmm6                             #4915.20
        vpsrlq    $24, %xmm7, %xmm13                            #4916.19
        vpsllq    $28, %xmm1, %xmm2                             #4906.20
        vpxor     .L_2il0floatpacket.44(%rip), %xmm11, %xmm1    #4912.22
        vpor      %xmm13, %xmm6, %xmm12                         #4917.20
        vpxor     .L_2il0floatpacket.42(%rip), %xmm11, %xmm5    #4903.22
        vpor      %xmm1, %xmm12, %xmm4                          #4918.20
        vpor      %xmm5, %xmm2, %xmm3                           #4907.20
        vsubpd    %xmm1, %xmm4, %xmm2                           #4921.18
        vsubpd    %xmm5, %xmm3, %xmm15                          #4910.17
        vaddpd    %xmm2, %xmm8, %xmm7                           #4922.11
        vsubpd    %xmm7, %xmm8, %xmm8                           #4923.17
        vmovups   .L_2il0floatpacket.46(%rip), %xmm5            #4926.16
        vmulpd    %xmm7, %xmm5, %xmm6                           #4928.13
        vaddpd    %xmm8, %xmm2, %xmm3                           #4924.18
        vaddpd    %xmm3, %xmm15, %xmm1                          #4925.11
        vmovaps   %xmm5, %xmm15                                 #4929.13
        vfmsub213pd %xmm6, %xmm7, %xmm15                        #4929.13
        vandpd    .L_2il0floatpacket.50(%rip), %xmm14, %xmm11   #4934.11
        vandps    .L_2il0floatpacket.41(%rip), %xmm10, %xmm10   #4901.15
        vmovd     %xmm10, %r9d                                  #4942.132
        vmovupd   16960+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm4 #4955.18
        vfmadd132pd .L_2il0floatpacket.69(%rip), %xmm15, %xmm7  #4930.13
        vmovups   .L_2il0floatpacket.51(%rip), %xmm15           #4933.16
        vcmplepd  %xmm15, %xmm11, %xmm9                         #4936.20
        vfmadd213pd %xmm7, %xmm5, %xmm1                         #4931.13
        vcmpltpd  %xmm11, %xmm15, %xmm5                         #4935.17
        shll      $5, %r9d                                      #4942.302
        vandpd    %xmm14, %xmm9, %xmm13                         #4937.24
        vpextrd   $2, %xmm10, %r10d                             #4942.194
        vandpd    %xmm6, %xmm5, %xmm12                          #4938.25
        shll      $5, %r10d                                     #4942.353
        vorpd     %xmm12, %xmm13, %xmm9                         #4939.9
        vmovq     16(%r9,%r11), %xmm10                          #4943.616
        vandpd    %xmm1, %xmm5, %xmm6                           #4940.9
        vmovq     8(%r9,%r11), %xmm15                           #4944.618
        vmovapd   %xmm9, %xmm1                                  #4945.26
        vmovhpd   16(%r10,%r11), %xmm10, %xmm13                 #4943.584
        vmovhpd   8(%r10,%r11), %xmm15, %xmm7                   #4944.586
        vmovapd   %xmm9, %xmm15                                 #4946.25
        vmulpd    %xmm9, %xmm9, %xmm10                          #4952.19
        vfmadd213pd %xmm13, %xmm7, %xmm1                        #4945.26
        vmovq     (%r9,%r11), %xmm2                             #4942.616
        vmovhpd   (%r10,%r11), %xmm2, %xmm12                    #4942.584
        vfmadd231pd 17024+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm10, %xmm4 #4955.18
        vfmadd132pd %xmm12, %xmm1, %xmm15                       #4946.25
        vsubpd    %xmm1, %xmm13, %xmm2                          #4947.22
        vmulpd    %xmm4, %xmm10, %xmm5                          #4956.18
        vsubpd    %xmm15, %xmm1, %xmm3                          #4949.22
        vaddpd    %xmm7, %xmm12, %xmm1                          #4958.17
        vmulpd    %xmm5, %xmm9, %xmm11                          #4957.18
        vfmadd231pd %xmm12, %xmm9, %xmm3                        #4950.22
        vmovupd   17152+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm12 #4962.18
        vfmadd231pd 17216+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm10, %xmm12 #4962.18
        vfmadd231pd %xmm9, %xmm7, %xmm2                         #4948.22
        vfnmadd213pd %xmm1, %xmm13, %xmm9                       #4967.17
        vfmadd213pd 17088+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm10, %xmm12 #4964.18
        vaddpd    %xmm3, %xmm2, %xmm8                           #4951.25
        vmulpd    %xmm12, %xmm10, %xmm2                         #4965.18
        vfmadd213pd %xmm8, %xmm1, %xmm11                        #4959.21
        vfmadd213pd %xmm11, %xmm13, %xmm2                       #4966.21
        vmovq     24(%r9,%r11), %xmm13                          #4968.616
        vmovhpd   24(%r10,%r11), %xmm13, %xmm1                  #4968.584
        vfmadd213pd %xmm1, %xmm9, %xmm6                         #4969.20
        vmovupd   (%rsp), %xmm1                                 #4972.18[spill]
        vaddpd    %xmm6, %xmm2, %xmm6                           #4970.21
        vaddpd    %xmm6, %xmm15, %xmm9                          #4971.24
        blendvpd  %xmm0, %xmm9, %xmm1                           #4972.18
        jmp       ..B6.2        # Prob 100%                     #4972.18
        .align    16,0x90
                                # LOE rbx r12 r13 r14 r15 eax xmm1 xmm14
        .cfi_endproc
# mark_end;
        .type   __jsvml_cos2_ha_l9,@function
        .size   __jsvml_cos2_ha_l9,.-__jsvml_cos2_ha_l9
..LN__jsvml_cos2_ha_l9.5:
        .data
# -- End  __jsvml_cos2_ha_l9
        .text
.L_2__routine_start___jsvml_cos1_ha_ex_6:
# -- Begin  __jsvml_cos1_ha_ex
        .text
# mark_begin;
        .align    16,0x90
        .globl __jsvml_cos1_ha_ex
# --- __jsvml_cos1_ha_ex(__m128d)
__jsvml_cos1_ha_ex:
# parameter 1: %xmm0
..B7.1:                         # Preds ..B7.0
                                # Execution count [1.00e+00]
        .byte     243                                           #4983.1
        .byte     15                                            #5345.18
        .byte     30                                            #5345.18
        .byte     250                                           #5345.18
        .cfi_startproc
..___tag_value___jsvml_cos1_ha_ex.152:
..L153:
                                                        #4983.1
        pushq     %rbp                                          #4983.1
        .cfi_def_cfa_offset 16
        movq      %rsp, %rbp                                    #4983.1
        .cfi_def_cfa 6, 16
        .cfi_offset 6, -16
        andq      $-64, %rsp                                    #4983.1
        subq      $128, %rsp                                    #4983.1
        movaps    %xmm0, %xmm2                                  #4983.1
        movaps    %xmm2, %xmm11                                 #5043.25
        movaps    %xmm2, %xmm4                                  #5046.14
        mulsd     16576+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm11 #5043.25
        lea       __jsvml_dcos_ha_data_internal_ha(%rip), %rax   #5057.365
        movsd     16640+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm6 #5042.20
        xorl      %edx, %edx                                    #5035.1
        movq      16704+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm10 #5055.21
        addsd     %xmm6, %xmm11                                 #5043.13
        movaps    %xmm11, %xmm9                                 #5044.13
        pand      %xmm10, %xmm11                                #5056.17
        movd      %xmm11, %ecx                                  #5057.128
        subsd     %xmm6, %xmm9                                  #5044.13
        movaps    %xmm9, %xmm7                                  #5046.34
        movaps    %xmm9, %xmm8                                  #5048.19
        mulsd     16768+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm7 #5046.34
        mulsd     16832+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm8 #5048.19
        mulsd     16896+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm9 #5053.32
        subsd     %xmm7, %xmm4                                  #5046.14
        movaps    %xmm4, %xmm3                                  #5049.17
        shll      $5, %ecx                                      #5057.225
        subsd     %xmm8, %xmm3                                  #5049.17
        movq      8(%rax,%rcx), %xmm15                          #5059.367
        movaps    %xmm3, %xmm12                                 #5061.22
        mulsd     %xmm15, %xmm12                                #5061.22
        subsd     %xmm3, %xmm4                                  #5050.17
        movq      16(%rax,%rcx), %xmm7                          #5058.365
        subsd     %xmm8, %xmm4                                  #5051.17
        movq      (%rcx,%rax), %xmm8                            #5057.365
        movdqa    %xmm7, %xmm6                                  #5062.22
        movdqa    %xmm8, %xmm13                                 #5060.19
        movdqa    %xmm7, %xmm14                                 #5064.18
        mulsd     %xmm3, %xmm13                                 #5060.19
        addsd     %xmm12, %xmm6                                 #5062.22
        subsd     %xmm9, %xmm4                                  #5053.13
        addsd     %xmm15, %xmm8                                 #5075.13
        subsd     %xmm6, %xmm14                                 #5064.18
        movaps    %xmm13, %xmm0                                 #5063.21
        addsd     %xmm12, %xmm14                                #5065.18
        addsd     %xmm6, %xmm0                                  #5063.21
        movaps    %xmm3, %xmm12                                 #5069.15
        subsd     %xmm0, %xmm6                                  #5066.18
        mulsd     %xmm3, %xmm12                                 #5069.15
        addsd     %xmm13, %xmm6                                 #5067.18
        movsd     17024+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm13 #5072.26
        addsd     %xmm14, %xmm6                                 #5068.21
        mulsd     %xmm12, %xmm13                                #5072.26
        movsd     17216+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm9 #5079.26
        mulsd     %xmm12, %xmm9                                 #5079.26
        addsd     16960+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm13 #5072.14
        mulsd     %xmm12, %xmm13                                #5073.14
        addsd     17152+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm9 #5079.14
        mulsd     %xmm12, %xmm9                                 #5081.26
        mulsd     %xmm3, %xmm13                                 #5074.14
        mulsd     %xmm7, %xmm3                                  #5084.32
        addsd     17088+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm9 #5081.14
        mulsd     %xmm8, %xmm13                                 #5076.29
        subsd     %xmm3, %xmm8                                  #5084.13
        mulsd     %xmm12, %xmm9                                 #5082.14
        addsd     %xmm6, %xmm13                                 #5076.17
        mulsd     %xmm8, %xmm4                                  #5086.28
        mulsd     %xmm7, %xmm9                                  #5083.29
        addsd     24(%rax,%rcx), %xmm4                          #5086.16
        addsd     %xmm13, %xmm9                                 #5083.17
        movsd     16384+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm5 #5038.13
        addsd     %xmm4, %xmm9                                  #5087.17
        andps     %xmm2, %xmm5                                  #5038.13
        addsd     %xmm9, %xmm0                                  #5088.14
        movaps    %xmm5, %xmm1                                  #5039.26
        cmpnlesd  16448+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm1 #5039.26
        movmskpd  %xmm1, %esi                                   #5089.78
        testl     $1, %esi                                      #5090.55
        jne       ..B7.8        # Prob 5%                       #5090.66
                                # LOE rax rbx r12 r13 r14 r15 edx xmm0 xmm1 xmm2 xmm5
..B7.2:                         # Preds ..B7.8 ..B7.1
                                # Execution count [1.00e+00]
        testl     %edx, %edx                                    #5348.52
        jne       ..B7.4        # Prob 5%                       #5348.52
                                # LOE rbx r12 r13 r14 r15 edx xmm0 xmm2
..B7.3:                         # Preds ..B7.2
                                # Execution count [1.00e+00]
        movq      %rbp, %rsp                                    #5351.12
        popq      %rbp                                          #5351.12
        .cfi_def_cfa 7, 8
        .cfi_restore 6
        ret                                                     #5351.12
        .cfi_def_cfa 6, 16
        .cfi_offset 6, -16
                                # LOE
..B7.4:                         # Preds ..B7.2
                                # Execution count [5.00e-02]: Infreq
        movsd     %xmm2, (%rsp)                                 #5348.160
        movsd     %xmm0, 64(%rsp)                               #5348.233
        jne       ..B7.6        # Prob 5%                       #5348.374
                                # LOE rbx r12 r13 r14 r15 edx
..B7.5:                         # Preds ..B7.7 ..B7.6 ..B7.4
                                # Execution count [5.00e-02]: Infreq
        movsd     64(%rsp), %xmm0                               #5348.625
        movq      %rbp, %rsp                                    #5348.625
        popq      %rbp                                          #5348.625
        .cfi_def_cfa 7, 8
        .cfi_restore 6
        ret                                                     #5348.625
        .cfi_def_cfa 6, 16
        .cfi_offset 6, -16
                                # LOE rbx r12 r13 r14 r15 xmm0
..B7.6:                         # Preds ..B7.4
                                # Execution count [2.50e-03]: Infreq
        je        ..B7.5        # Prob 95%                      #5348.517
                                # LOE rbx r12 r13 r14 r15
..B7.7:                         # Preds ..B7.6
                                # Execution count [6.25e-04]: Infreq
        lea       (%rsp), %rdi                                  #5348.546
        lea       64(%rsp), %rsi                                #5348.546
..___tag_value___jsvml_cos1_ha_ex.165:
#       __jsvml_dcos_ha_cout_rare_internal(const double *, double *)
        call      __jsvml_dcos_ha_cout_rare_internal             #5348.546
..___tag_value___jsvml_cos1_ha_ex.166:
        jmp       ..B7.5        # Prob 100%                     #5348.546
                                # LOE rbx r12 r13 r14 r15
..B7.8:                         # Preds ..B7.1
                                # Execution count [5.00e-02]: Infreq
        movups    %xmm0, (%rsp)                                 #[spill]
        lea       __jsvml_dcos_ha_reduction_data_internal(%rip), %rdi #5185.377
        movsd     16512+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm0 #5093.24
        andps     %xmm0, %xmm5                                  #5094.17
        movdqu    .L_2il0floatpacket.34(%rip), %xmm6            #5183.16
        cmpeqsd   %xmm0, %xmm5                                  #5095.25
        pand      %xmm2, %xmm6                                  #5183.16
        psrlq     $52, %xmm6                                    #5184.16
        movd      %xmm6, %ecx                                   #5185.124
        movmskpd  %xmm5, %edx                                   #5097.48
        movdqu    .L_2il0floatpacket.35(%rip), %xmm5            #5193.19
        pand      %xmm2, %xmm5                                  #5193.19
        paddq     .L_2il0floatpacket.36(%rip), %xmm5            #5194.19
        movdqa    %xmm5, %xmm4                                  #5202.10
        lea       (%rcx,%rcx,2), %esi                           #5185.224
        shll      $3, %esi                                      #5185.224
        psrlq     $32, %xmm4                                    #5202.10
        movq      16(%rdi,%rsi), %xmm13                         #5187.377
        movdqa    %xmm4, %xmm0                                  #5208.11
        movdqu    .L_2il0floatpacket.37(%rip), %xmm14           #5195.15
        movdqa    %xmm13, %xmm8                                 #5200.10
        psrlq     $32, %xmm8                                    #5200.10
        pand      %xmm14, %xmm5                                 #5203.10
        movq      8(%rdi,%rsi), %xmm11                          #5186.378
        movdqa    %xmm5, %xmm9                                  #5213.11
        pmuludq   %xmm8, %xmm0                                  #5208.11
        movdqa    %xmm11, %xmm12                                #5198.10
        pmuludq   %xmm5, %xmm8                                  #5214.11
        pand      %xmm14, %xmm11                                #5199.10
        pand      %xmm14, %xmm13                                #5201.10
        pmuludq   %xmm11, %xmm9                                 #5213.11
        psrlq     $32, %xmm8                                    #5216.11
        pmuludq   %xmm4, %xmm13                                 #5209.11
        pmuludq   %xmm4, %xmm11                                 #5207.11
        paddq     %xmm8, %xmm0                                  #5220.11
        psrlq     $32, %xmm12                                   #5198.10
        movdqa    %xmm5, %xmm10                                 #5212.11
        movdqa    %xmm14, %xmm6                                 #5224.11
        movdqa    %xmm14, %xmm15                                #5197.10
        pmuludq   %xmm12, %xmm10                                #5212.11
        pand      %xmm9, %xmm6                                  #5224.11
        pmuludq   %xmm4, %xmm12                                 #5206.11
        paddq     %xmm0, %xmm6                                  #5229.11
        movq      (%rsi,%rdi), %xmm7                            #5185.377
        psrlq     $32, %xmm13                                   #5234.11
        psrlq     $32, %xmm9                                    #5217.11
        pand      %xmm7, %xmm15                                 #5197.10
        movdqa    %xmm5, %xmm3                                  #5211.11
        movdqa    %xmm14, %xmm8                                 #5225.11
        paddq     %xmm6, %xmm13                                 #5235.11
        paddq     %xmm9, %xmm11                                 #5221.11
        pmuludq   %xmm15, %xmm3                                 #5211.11
        pmuludq   %xmm15, %xmm4                                 #5205.11
        pand      %xmm10, %xmm8                                 #5225.11
        movdqa    %xmm13, %xmm0                                 #5236.11
        paddq     %xmm11, %xmm8                                 #5230.11
        psrlq     $32, %xmm0                                    #5236.11
        psrlq     $32, %xmm10                                   #5218.11
        psrlq     $32, %xmm7                                    #5196.10
        movdqa    %xmm14, %xmm9                                 #5226.11
        paddq     %xmm8, %xmm0                                  #5237.11
        paddq     %xmm10, %xmm12                                #5222.11
        pmuludq   %xmm7, %xmm5                                  #5210.11
        pand      %xmm3, %xmm9                                  #5226.11
        movdqa    %xmm0, %xmm11                                 #5238.11
        paddq     %xmm12, %xmm9                                 #5231.11
        psrlq     $32, %xmm11                                   #5238.11
        psrlq     $32, %xmm3                                    #5219.11
        paddq     %xmm9, %xmm11                                 #5239.11
        paddq     %xmm3, %xmm4                                  #5223.11
        pand      %xmm14, %xmm5                                 #5227.11
        movdqa    %xmm11, %xmm8                                 #5240.11
        paddq     %xmm4, %xmm5                                  #5232.11
        psrlq     $32, %xmm8                                    #5240.11
        pand      %xmm14, %xmm11                                #5243.11
        paddq     %xmm5, %xmm8                                  #5241.11
        psllq     $32, %xmm8                                    #5244.17
        psllq     $32, %xmm0                                    #5245.17
        paddq     %xmm11, %xmm8                                 #5246.17
        movdqu    .L_2il0floatpacket.38(%rip), %xmm3            #5249.15
        movdqa    %xmm8, %xmm4                                  #5252.18
        movdqu    .L_2il0floatpacket.39(%rip), %xmm10           #5251.20
        pand      %xmm2, %xmm3                                  #5249.15
        movups    .L_2il0floatpacket.40(%rip), %xmm12           #5255.15
        psrlq     $12, %xmm4                                    #5252.18
        pxor      %xmm3, %xmm10                                 #5251.20
        movaps    %xmm12, %xmm7                                 #5256.19
        por       %xmm10, %xmm4                                 #5253.18
        pand      %xmm14, %xmm13                                #5242.11
        paddq     %xmm13, %xmm0                                 #5247.17
        addsd     %xmm4, %xmm7                                  #5256.19
        movaps    %xmm7, %xmm13                                 #5257.9
        andl      $1, %edx                                      #5097.102
        movdqu    .L_2il0floatpacket.45(%rip), %xmm6            #5274.18
        subsd     %xmm12, %xmm13                                #5257.9
        movdqu    .L_2il0floatpacket.43(%rip), %xmm5            #5265.18
        pand      %xmm8, %xmm6                                  #5274.18
        movdqu    .L_2il0floatpacket.42(%rip), %xmm14           #5263.20
        pand      %xmm0, %xmm5                                  #5265.18
        psllq     $40, %xmm6                                    #5275.18
        psrlq     $24, %xmm0                                    #5276.17
        pxor      %xmm3, %xmm14                                 #5263.20
        por       %xmm0, %xmm6                                  #5277.18
        pxor      .L_2il0floatpacket.44(%rip), %xmm3            #5272.20
        psllq     $28, %xmm5                                    #5266.18
        por       %xmm3, %xmm6                                  #5278.18
        por       %xmm14, %xmm5                                 #5267.18
        movups    .L_2il0floatpacket.49(%rip), %xmm0            #5290.16
        subsd     %xmm13, %xmm4                                 #5258.17
        subsd     %xmm3, %xmm6                                  #5281.18
        subsd     %xmm14, %xmm5                                 #5270.17
        movaps    %xmm4, %xmm8                                  #5282.11
        movups    .L_2il0floatpacket.47(%rip), %xmm15           #5287.16
        addsd     %xmm6, %xmm8                                  #5282.11
        andps     %xmm8, %xmm0                                  #5290.16
        subsd     %xmm8, %xmm4                                  #5283.17
        subsd     %xmm0, %xmm8                                  #5291.17
        addsd     %xmm4, %xmm6                                  #5284.18
        movups    .L_2il0floatpacket.48(%rip), %xmm4            #5288.17
        addsd     %xmm5, %xmm6                                  #5285.11
        movups    .L_2il0floatpacket.46(%rip), %xmm10           #5295.12
        movaps    %xmm4, %xmm9                                  #5294.12
        mulsd     %xmm0, %xmm9                                  #5294.12
        movaps    %xmm15, %xmm5                                 #5292.16
        mulsd     %xmm8, %xmm15                                 #5293.12
        mulsd     %xmm6, %xmm10                                 #5295.12
        mulsd     %xmm8, %xmm4                                  #5296.12
        addsd     %xmm9, %xmm15                                 #5297.13
        mulsd     %xmm0, %xmm5                                  #5292.16
        addsd     %xmm4, %xmm10                                 #5298.13
        movaps    %xmm5, %xmm12                                 #5300.13
        addsd     %xmm10, %xmm15                                #5299.13
        movups    .L_2il0floatpacket.51(%rip), %xmm11           #5304.16
        addsd     %xmm15, %xmm12                                #5300.13
        movups    .L_2il0floatpacket.50(%rip), %xmm3            #5305.11
        movaps    %xmm11, %xmm6                                 #5306.17
        andps     %xmm2, %xmm3                                  #5305.11
        subsd     %xmm12, %xmm5                                 #5301.16
        cmpltsd   %xmm3, %xmm6                                  #5306.17
        addsd     %xmm15, %xmm5                                 #5302.13
        movaps    %xmm3, %xmm4                                  #5306.17
        cmplesd   %xmm11, %xmm3                                 #5307.20
        andps     .L_2il0floatpacket.41(%rip), %xmm7            #5261.13
        movsd     %xmm6, %xmm4                                  #5306.17
        movd      %xmm7, %r8d                                   #5313.132
        andps     %xmm2, %xmm3                                  #5308.24
        andps     %xmm4, %xmm12                                 #5309.25
        andps     %xmm5, %xmm4                                  #5311.9
        orps      %xmm12, %xmm3                                 #5310.9
        shll      $5, %r8d                                      #5313.229
        movaps    %xmm3, %xmm7                                  #5317.26
        mulsd     8(%rax,%r8), %xmm7                            #5317.26
        movq      16(%rax,%r8), %xmm14                          #5314.369
        movdqa    %xmm14, %xmm5                                 #5318.26
        movdqa    %xmm14, %xmm0                                 #5320.22
        movq      (%r8,%rax), %xmm8                             #5313.369
        addsd     %xmm7, %xmm5                                  #5318.26
        movdqa    %xmm8, %xmm13                                 #5316.23
        subsd     %xmm5, %xmm0                                  #5320.22
        mulsd     %xmm3, %xmm13                                 #5316.23
        addsd     8(%rax,%r8), %xmm8                            #5331.17
        addsd     %xmm7, %xmm0                                  #5321.22
        movaps    %xmm3, %xmm7                                  #5325.19
        movaps    %xmm13, %xmm10                                #5319.25
        mulsd     %xmm3, %xmm7                                  #5325.19
        addsd     %xmm5, %xmm10                                 #5319.25
        movsd     17024+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm6 #5328.30
        subsd     %xmm10, %xmm5                                 #5322.22
        mulsd     %xmm7, %xmm6                                  #5328.30
        addsd     %xmm13, %xmm5                                 #5323.22
        addsd     16960+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm6 #5328.18
        addsd     %xmm0, %xmm5                                  #5324.25
        mulsd     %xmm7, %xmm6                                  #5329.18
        movsd     17216+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm9 #5335.30
        movaps    %xmm1, %xmm0                                  #5345.29
        mulsd     %xmm7, %xmm9                                  #5335.30
        mulsd     %xmm3, %xmm6                                  #5330.18
        mulsd     %xmm14, %xmm3                                 #5340.36
        addsd     17152+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm9 #5335.18
        mulsd     %xmm8, %xmm6                                  #5332.33
        subsd     %xmm3, %xmm8                                  #5340.17
        mulsd     %xmm7, %xmm9                                  #5337.30
        addsd     %xmm5, %xmm6                                  #5332.21
        mulsd     %xmm8, %xmm4                                  #5342.32
        addsd     17088+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm9 #5337.18
        addsd     24(%rax,%r8), %xmm4                           #5342.20
        mulsd     %xmm7, %xmm9                                  #5338.18
        mulsd     %xmm14, %xmm9                                 #5339.33
        andnps    (%rsp), %xmm0                                 #5345.29[spill]
        addsd     %xmm6, %xmm9                                  #5339.21
        addsd     %xmm4, %xmm9                                  #5343.21
        addsd     %xmm9, %xmm10                                 #5344.24
        andps     %xmm1, %xmm10                                 #5345.78
        orps      %xmm10, %xmm0                                 #5345.18
        jmp       ..B7.2        # Prob 100%                     #5345.18
        .align    16,0x90
                                # LOE rbx r12 r13 r14 r15 edx xmm0 xmm2
        .cfi_endproc
# mark_end;
        .type   __jsvml_cos1_ha_ex,@function
        .size   __jsvml_cos1_ha_ex,.-__jsvml_cos1_ha_ex
..LN__jsvml_cos1_ha_ex.6:
        .data
# -- End  __jsvml_cos1_ha_ex
        .text
.L_2__routine_start___jsvml_cos1_ha_e9_7:
# -- Begin  __jsvml_cos1_ha_e9
        .text
# mark_begin;
        .align    16,0x90
        .globl __jsvml_cos1_ha_e9
# --- __jsvml_cos1_ha_e9(__m128d)
__jsvml_cos1_ha_e9:
# parameter 1: %xmm0
..B8.1:                         # Preds ..B8.0
                                # Execution count [1.00e+00]
        .byte     243                                           #5356.1
        .byte     15                                            #5718.18
        .byte     30                                            #5718.18
        .byte     250                                           #5718.18
        .cfi_startproc
..___tag_value___jsvml_cos1_ha_e9.170:
..L171:
                                                        #5356.1
        pushq     %rbp                                          #5356.1
        .cfi_def_cfa_offset 16
        movq      %rsp, %rbp                                    #5356.1
        .cfi_def_cfa 6, 16
        .cfi_offset 6, -16
        andq      $-64, %rsp                                    #5356.1
        subq      $128, %rsp                                    #5356.1
        movaps    %xmm0, %xmm2                                  #5356.1
        movaps    %xmm2, %xmm10                                 #5416.25
        movaps    %xmm2, %xmm4                                  #5419.14
        mulsd     16576+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm10 #5416.25
        lea       __jsvml_dcos_ha_data_internal_ha(%rip), %rax   #5430.371
        movsd     16640+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm1 #5415.20
        xorl      %edx, %edx                                    #5408.1
        movq      16704+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm9 #5428.27
        addsd     %xmm1, %xmm10                                 #5416.13
        movaps    %xmm10, %xmm8                                 #5417.13
        pand      %xmm9, %xmm10                                 #5429.23
        movd      %xmm10, %ecx                                  #5430.128
        subsd     %xmm1, %xmm8                                  #5417.13
        movaps    %xmm8, %xmm6                                  #5419.34
        movaps    %xmm8, %xmm7                                  #5421.19
        mulsd     16768+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm6 #5419.34
        mulsd     16832+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm7 #5421.19
        mulsd     16896+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm8 #5426.32
        subsd     %xmm6, %xmm4                                  #5419.14
        movaps    %xmm4, %xmm3                                  #5422.17
        shll      $5, %ecx                                      #5430.231
        subsd     %xmm7, %xmm3                                  #5422.17
        movq      8(%rax,%rcx), %xmm14                          #5432.373
        movaps    %xmm3, %xmm11                                 #5434.22
        mulsd     %xmm14, %xmm11                                #5434.22
        subsd     %xmm3, %xmm4                                  #5423.17
        movq      16(%rax,%rcx), %xmm6                          #5431.371
        subsd     %xmm7, %xmm4                                  #5424.17
        movq      (%rcx,%rax), %xmm7                            #5430.371
        movdqa    %xmm6, %xmm15                                 #5435.22
        movdqa    %xmm7, %xmm12                                 #5433.19
        movdqa    %xmm6, %xmm13                                 #5437.18
        mulsd     %xmm3, %xmm12                                 #5433.19
        addsd     %xmm11, %xmm15                                #5435.22
        subsd     %xmm8, %xmm4                                  #5426.13
        addsd     %xmm14, %xmm7                                 #5448.13
        subsd     %xmm15, %xmm13                                #5437.18
        movaps    %xmm12, %xmm1                                 #5436.21
        addsd     %xmm11, %xmm13                                #5438.18
        addsd     %xmm15, %xmm1                                 #5436.21
        movaps    %xmm3, %xmm11                                 #5442.15
        subsd     %xmm1, %xmm15                                 #5439.18
        mulsd     %xmm3, %xmm11                                 #5442.15
        addsd     %xmm12, %xmm15                                #5440.18
        movsd     17024+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm12 #5445.26
        addsd     %xmm13, %xmm15                                #5441.21
        mulsd     %xmm11, %xmm12                                #5445.26
        movsd     17216+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm8 #5452.26
        mulsd     %xmm11, %xmm8                                 #5452.26
        addsd     16960+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm12 #5445.14
        mulsd     %xmm11, %xmm12                                #5446.14
        addsd     17152+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm8 #5452.14
        mulsd     %xmm11, %xmm8                                 #5454.26
        mulsd     %xmm3, %xmm12                                 #5447.14
        mulsd     %xmm6, %xmm3                                  #5457.32
        addsd     17088+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm8 #5454.14
        mulsd     %xmm7, %xmm12                                 #5449.29
        subsd     %xmm3, %xmm7                                  #5457.13
        mulsd     %xmm11, %xmm8                                 #5455.14
        addsd     %xmm15, %xmm12                                #5449.17
        mulsd     %xmm7, %xmm4                                  #5459.28
        mulsd     %xmm6, %xmm8                                  #5456.29
        addsd     24(%rax,%rcx), %xmm4                          #5459.16
        addsd     %xmm12, %xmm8                                 #5456.17
        movsd     16384+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm5 #5411.13
        addsd     %xmm4, %xmm8                                  #5460.17
        andps     %xmm2, %xmm5                                  #5411.13
        addsd     %xmm8, %xmm1                                  #5461.14
        movaps    %xmm5, %xmm0                                  #5412.26
        cmpnlesd  16448+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm0 #5412.26
        movmskpd  %xmm0, %esi                                   #5462.78
        testl     $1, %esi                                      #5463.55
        jne       ..B8.8        # Prob 5%                       #5463.66
                                # LOE rax rbx r12 r13 r14 r15 edx xmm0 xmm1 xmm2 xmm5
..B8.2:                         # Preds ..B8.8 ..B8.1
                                # Execution count [1.00e+00]
        testl     %edx, %edx                                    #5721.52
        jne       ..B8.4        # Prob 5%                       #5721.52
                                # LOE rbx r12 r13 r14 r15 edx xmm1 xmm2
..B8.3:                         # Preds ..B8.5 ..B8.2
                                # Execution count [1.00e+00]
        movaps    %xmm1, %xmm0                                  #5724.12
        movq      %rbp, %rsp                                    #5724.12
        popq      %rbp                                          #5724.12
        .cfi_def_cfa 7, 8
        .cfi_restore 6
        ret                                                     #5724.12
        .cfi_def_cfa 6, 16
        .cfi_offset 6, -16
                                # LOE
..B8.4:                         # Preds ..B8.2
                                # Execution count [5.00e-02]: Infreq
        movsd     %xmm2, (%rsp)                                 #5721.160
        movsd     %xmm1, 64(%rsp)                               #5721.233
        jne       ..B8.6        # Prob 5%                       #5721.374
                                # LOE rbx r12 r13 r14 r15 edx
..B8.5:                         # Preds ..B8.7 ..B8.6 ..B8.4
                                # Execution count [5.00e-02]: Infreq
        movsd     64(%rsp), %xmm1                               #5721.625
        jmp       ..B8.3        # Prob 100%                     #5721.625
                                # LOE rbx r12 r13 r14 r15 xmm1
..B8.6:                         # Preds ..B8.4
                                # Execution count [2.50e-03]: Infreq
        je        ..B8.5        # Prob 95%                      #5721.517
                                # LOE rbx r12 r13 r14 r15
..B8.7:                         # Preds ..B8.6
                                # Execution count [6.25e-04]: Infreq
        lea       (%rsp), %rdi                                  #5721.546
        lea       64(%rsp), %rsi                                #5721.546
..___tag_value___jsvml_cos1_ha_e9.179:
#       __jsvml_dcos_ha_cout_rare_internal(const double *, double *)
        call      __jsvml_dcos_ha_cout_rare_internal             #5721.546
..___tag_value___jsvml_cos1_ha_e9.180:
        jmp       ..B8.5        # Prob 100%                     #5721.546
                                # LOE rbx r12 r13 r14 r15
..B8.8:                         # Preds ..B8.1
                                # Execution count [5.00e-02]: Infreq
        movups    %xmm1, (%rsp)                                 #[spill]
        lea       __jsvml_dcos_ha_reduction_data_internal(%rip), %rdi #5558.383
        movsd     16512+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm1 #5466.24
        andps     %xmm1, %xmm5                                  #5467.17
        movdqu    .L_2il0floatpacket.34(%rip), %xmm6            #5556.22
        cmpeqsd   %xmm1, %xmm5                                  #5468.25
        pand      %xmm2, %xmm6                                  #5556.22
        psrlq     $52, %xmm6                                    #5557.22
        movd      %xmm6, %ecx                                   #5558.124
        movmskpd  %xmm5, %edx                                   #5470.48
        movdqu    .L_2il0floatpacket.35(%rip), %xmm5            #5566.25
        pand      %xmm2, %xmm5                                  #5566.25
        paddq     .L_2il0floatpacket.36(%rip), %xmm5            #5567.25
        movdqa    %xmm5, %xmm4                                  #5575.16
        lea       (%rcx,%rcx,2), %esi                           #5558.230
        shll      $3, %esi                                      #5558.230
        psrlq     $32, %xmm4                                    #5575.16
        movq      16(%rdi,%rsi), %xmm13                         #5560.383
        movdqa    %xmm4, %xmm1                                  #5581.17
        movdqu    .L_2il0floatpacket.37(%rip), %xmm14           #5568.21
        movdqa    %xmm13, %xmm8                                 #5573.16
        psrlq     $32, %xmm8                                    #5573.16
        pand      %xmm14, %xmm5                                 #5576.16
        movq      8(%rdi,%rsi), %xmm11                          #5559.384
        movdqa    %xmm5, %xmm9                                  #5586.17
        pmuludq   %xmm8, %xmm1                                  #5581.17
        movdqa    %xmm11, %xmm12                                #5571.16
        pmuludq   %xmm5, %xmm8                                  #5587.17
        pand      %xmm14, %xmm11                                #5572.16
        pand      %xmm14, %xmm13                                #5574.16
        pmuludq   %xmm11, %xmm9                                 #5586.17
        psrlq     $32, %xmm8                                    #5589.17
        pmuludq   %xmm4, %xmm13                                 #5582.17
        pmuludq   %xmm4, %xmm11                                 #5580.17
        paddq     %xmm8, %xmm1                                  #5593.17
        psrlq     $32, %xmm12                                   #5571.16
        movdqa    %xmm5, %xmm10                                 #5585.17
        movdqa    %xmm14, %xmm6                                 #5597.17
        movdqa    %xmm14, %xmm15                                #5570.16
        pmuludq   %xmm12, %xmm10                                #5585.17
        pand      %xmm9, %xmm6                                  #5597.17
        pmuludq   %xmm4, %xmm12                                 #5579.17
        paddq     %xmm1, %xmm6                                  #5602.17
        movq      (%rsi,%rdi), %xmm7                            #5558.383
        psrlq     $32, %xmm13                                   #5607.17
        psrlq     $32, %xmm9                                    #5590.17
        pand      %xmm7, %xmm15                                 #5570.16
        movdqa    %xmm5, %xmm3                                  #5584.17
        movdqa    %xmm14, %xmm8                                 #5598.17
        paddq     %xmm6, %xmm13                                 #5608.17
        paddq     %xmm9, %xmm11                                 #5594.17
        pmuludq   %xmm15, %xmm3                                 #5584.17
        pmuludq   %xmm15, %xmm4                                 #5578.17
        pand      %xmm10, %xmm8                                 #5598.17
        movdqa    %xmm13, %xmm1                                 #5609.17
        paddq     %xmm11, %xmm8                                 #5603.17
        psrlq     $32, %xmm1                                    #5609.17
        psrlq     $32, %xmm10                                   #5591.17
        psrlq     $32, %xmm7                                    #5569.16
        movdqa    %xmm14, %xmm9                                 #5599.17
        paddq     %xmm8, %xmm1                                  #5610.17
        paddq     %xmm10, %xmm12                                #5595.17
        pmuludq   %xmm7, %xmm5                                  #5583.17
        pand      %xmm3, %xmm9                                  #5599.17
        movdqa    %xmm1, %xmm11                                 #5611.17
        paddq     %xmm12, %xmm9                                 #5604.17
        psrlq     $32, %xmm11                                   #5611.17
        psrlq     $32, %xmm3                                    #5592.17
        paddq     %xmm9, %xmm11                                 #5612.17
        paddq     %xmm3, %xmm4                                  #5596.17
        pand      %xmm14, %xmm5                                 #5600.17
        movdqa    %xmm11, %xmm8                                 #5613.17
        paddq     %xmm4, %xmm5                                  #5605.17
        psrlq     $32, %xmm8                                    #5613.17
        pand      %xmm14, %xmm11                                #5616.17
        paddq     %xmm5, %xmm8                                  #5614.17
        psllq     $32, %xmm8                                    #5617.23
        psllq     $32, %xmm1                                    #5618.23
        paddq     %xmm11, %xmm8                                 #5619.23
        movdqu    .L_2il0floatpacket.38(%rip), %xmm3            #5622.21
        movdqa    %xmm8, %xmm4                                  #5625.24
        movdqu    .L_2il0floatpacket.39(%rip), %xmm10           #5624.26
        pand      %xmm2, %xmm3                                  #5622.21
        movups    .L_2il0floatpacket.40(%rip), %xmm12           #5628.15
        psrlq     $12, %xmm4                                    #5625.24
        pxor      %xmm3, %xmm10                                 #5624.26
        movaps    %xmm12, %xmm7                                 #5629.19
        por       %xmm10, %xmm4                                 #5626.24
        pand      %xmm14, %xmm13                                #5615.17
        paddq     %xmm13, %xmm1                                 #5620.23
        addsd     %xmm4, %xmm7                                  #5629.19
        movaps    %xmm7, %xmm13                                 #5630.9
        andl      $1, %edx                                      #5470.102
        movdqu    .L_2il0floatpacket.45(%rip), %xmm6            #5647.24
        subsd     %xmm12, %xmm13                                #5630.9
        movdqu    .L_2il0floatpacket.43(%rip), %xmm5            #5638.24
        pand      %xmm8, %xmm6                                  #5647.24
        movdqu    .L_2il0floatpacket.42(%rip), %xmm14           #5636.26
        pand      %xmm1, %xmm5                                  #5638.24
        psllq     $40, %xmm6                                    #5648.24
        psrlq     $24, %xmm1                                    #5649.23
        pxor      %xmm3, %xmm14                                 #5636.26
        por       %xmm1, %xmm6                                  #5650.24
        pxor      .L_2il0floatpacket.44(%rip), %xmm3            #5645.26
        psllq     $28, %xmm5                                    #5639.24
        por       %xmm3, %xmm6                                  #5651.24
        por       %xmm14, %xmm5                                 #5640.24
        movups    .L_2il0floatpacket.49(%rip), %xmm1            #5663.16
        subsd     %xmm13, %xmm4                                 #5631.17
        subsd     %xmm3, %xmm6                                  #5654.18
        subsd     %xmm14, %xmm5                                 #5643.17
        movaps    %xmm4, %xmm8                                  #5655.11
        movups    .L_2il0floatpacket.47(%rip), %xmm15           #5660.16
        addsd     %xmm6, %xmm8                                  #5655.11
        andps     %xmm8, %xmm1                                  #5663.16
        subsd     %xmm8, %xmm4                                  #5656.17
        subsd     %xmm1, %xmm8                                  #5664.17
        addsd     %xmm4, %xmm6                                  #5657.18
        movups    .L_2il0floatpacket.48(%rip), %xmm4            #5661.17
        addsd     %xmm5, %xmm6                                  #5658.11
        movups    .L_2il0floatpacket.46(%rip), %xmm10           #5668.12
        movaps    %xmm4, %xmm9                                  #5667.12
        mulsd     %xmm1, %xmm9                                  #5667.12
        movaps    %xmm15, %xmm5                                 #5665.16
        mulsd     %xmm8, %xmm15                                 #5666.12
        mulsd     %xmm6, %xmm10                                 #5668.12
        mulsd     %xmm8, %xmm4                                  #5669.12
        addsd     %xmm9, %xmm15                                 #5670.13
        mulsd     %xmm1, %xmm5                                  #5665.16
        addsd     %xmm4, %xmm10                                 #5671.13
        movaps    %xmm5, %xmm12                                 #5673.13
        addsd     %xmm10, %xmm15                                #5672.13
        movups    .L_2il0floatpacket.51(%rip), %xmm11           #5677.16
        addsd     %xmm15, %xmm12                                #5673.13
        movups    .L_2il0floatpacket.50(%rip), %xmm3            #5678.11
        movaps    %xmm11, %xmm6                                 #5679.17
        andps     %xmm2, %xmm3                                  #5678.11
        subsd     %xmm12, %xmm5                                 #5674.16
        cmpltsd   %xmm3, %xmm6                                  #5679.17
        addsd     %xmm15, %xmm5                                 #5675.13
        movaps    %xmm3, %xmm4                                  #5679.17
        cmplesd   %xmm11, %xmm3                                 #5680.20
        andps     .L_2il0floatpacket.41(%rip), %xmm7            #5634.19
        movsd     %xmm6, %xmm4                                  #5679.17
        movd      %xmm7, %r8d                                   #5686.132
        andps     %xmm2, %xmm3                                  #5681.24
        andps     %xmm4, %xmm12                                 #5682.25
        andps     %xmm5, %xmm4                                  #5684.9
        orps      %xmm12, %xmm3                                 #5683.9
        shll      $5, %r8d                                      #5686.235
        movaps    %xmm3, %xmm7                                  #5690.26
        mulsd     8(%rax,%r8), %xmm7                            #5690.26
        movq      16(%rax,%r8), %xmm14                          #5687.375
        movdqa    %xmm14, %xmm5                                 #5691.26
        movdqa    %xmm14, %xmm1                                 #5693.22
        movq      (%r8,%rax), %xmm8                             #5686.375
        addsd     %xmm7, %xmm5                                  #5691.26
        movdqa    %xmm8, %xmm13                                 #5689.23
        subsd     %xmm5, %xmm1                                  #5693.22
        mulsd     %xmm3, %xmm13                                 #5689.23
        addsd     8(%rax,%r8), %xmm8                            #5704.17
        addsd     %xmm7, %xmm1                                  #5694.22
        movaps    %xmm3, %xmm7                                  #5698.19
        movaps    %xmm13, %xmm10                                #5692.25
        mulsd     %xmm3, %xmm7                                  #5698.19
        addsd     %xmm5, %xmm10                                 #5692.25
        movsd     17024+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm6 #5701.30
        subsd     %xmm10, %xmm5                                 #5695.22
        mulsd     %xmm7, %xmm6                                  #5701.30
        addsd     %xmm13, %xmm5                                 #5696.22
        addsd     16960+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm6 #5701.18
        addsd     %xmm1, %xmm5                                  #5697.25
        mulsd     %xmm7, %xmm6                                  #5702.18
        movsd     17216+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm9 #5708.30
        mulsd     %xmm7, %xmm9                                  #5708.30
        mulsd     %xmm3, %xmm6                                  #5703.18
        mulsd     %xmm14, %xmm3                                 #5713.36
        addsd     17152+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm9 #5708.18
        mulsd     %xmm8, %xmm6                                  #5705.33
        subsd     %xmm3, %xmm8                                  #5713.17
        mulsd     %xmm7, %xmm9                                  #5710.30
        addsd     %xmm5, %xmm6                                  #5705.21
        mulsd     %xmm8, %xmm4                                  #5715.32
        addsd     17088+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm9 #5710.18
        addsd     24(%rax,%r8), %xmm4                           #5715.20
        mulsd     %xmm7, %xmm9                                  #5711.18
        mulsd     %xmm14, %xmm9                                 #5712.33
        movups    (%rsp), %xmm1                                 #5718.18[spill]
        addsd     %xmm6, %xmm9                                  #5712.21
        addsd     %xmm4, %xmm9                                  #5716.21
        addsd     %xmm9, %xmm10                                 #5717.24
        blendvpd  %xmm0, %xmm10, %xmm1                          #5718.18
        jmp       ..B8.2        # Prob 100%                     #5718.18
        .align    16,0x90
                                # LOE rbx r12 r13 r14 r15 edx xmm1 xmm2
        .cfi_endproc
# mark_end;
        .type   __jsvml_cos1_ha_e9,@function
        .size   __jsvml_cos1_ha_e9,.-__jsvml_cos1_ha_e9
..LN__jsvml_cos1_ha_e9.7:
        .data
# -- End  __jsvml_cos1_ha_e9
        .text
.L_2__routine_start___jsvml_cos4_ha_e9_8:
# -- Begin  __jsvml_cos4_ha_e9
        .text
# mark_begin;
        .align    16,0x90
        .globl __jsvml_cos4_ha_e9
# --- __jsvml_cos4_ha_e9(__m256d)
__jsvml_cos4_ha_e9:
# parameter 1: %ymm0
..B9.1:                         # Preds ..B9.0
                                # Execution count [1.00e+00]
        .byte     243                                           #5729.1
        .byte     15                                            #6091.18
        .byte     30                                            #6091.18
        .byte     250                                           #6091.18
        .cfi_startproc
..___tag_value___jsvml_cos4_ha_e9.184:
..L185:
                                                        #5729.1
        pushq     %rbp                                          #5729.1
        .cfi_def_cfa_offset 16
        movq      %rsp, %rbp                                    #5729.1
        .cfi_def_cfa 6, 16
        .cfi_offset 6, -16
        andq      $-64, %rsp                                    #5729.1
        subq      $320, %rsp                                    #5729.1
        lea       __jsvml_dcos_ha_data_internal_ha(%rip), %r8    #5803.613
        vmovapd   %ymm0, %ymm6                                  #5729.1
        xorl      %esi, %esi                                    #5781.1
        vmovupd   16640+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm7 #5788.54
        vmulpd    16576+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm6, %ymm5 #5789.28
        vaddpd    %ymm5, %ymm7, %ymm13                          #5789.13
        vmovupd   16704+__jsvml_dcos_ha_data_internal_ha(%rip), %xmm5 #5801.27
        vsubpd    %ymm7, %ymm13, %ymm11                         #5790.13
        vmulpd    16768+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm11, %ymm3 #5792.37
        vmulpd    16832+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm11, %ymm8 #5794.19
        vmulpd    16896+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm11, %ymm14 #5799.35
        vsubpd    %ymm3, %ymm6, %ymm9                           #5792.14
        vsubpd    %ymm8, %ymm9, %ymm0                           #5795.17
        vsubpd    %ymm0, %ymm9, %ymm4                           #5796.17
        vsubpd    %ymm8, %ymm4, %ymm10                          #5797.17
        vsubpd    %ymm14, %ymm10, %ymm3                         #5799.13
        vandpd    16384+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm6, %ymm1 #5784.13
        vcmpnle_uqpd 16448+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm1, %ymm15 #5785.26
        vandps    %xmm5, %xmm13, %xmm7                          #5802.23
        vextractf128 $1, %ymm13, %xmm12                         #5800.104
        vmovd     %xmm7, %eax                                   #5803.128
        vandps    %xmm5, %xmm12, %xmm8                          #5802.92
        vmovd     %xmm8, %ecx                                   #5803.255
        shll      $5, %eax                                      #5803.424
        vpextrd   $2, %xmm7, %edx                               #5803.190
        shll      $5, %ecx                                      #5803.526
        vpextrd   $2, %xmm8, %edi                               #5803.316
        shll      $5, %edx                                      #5803.475
        vmovq     (%rax,%r8), %xmm9                             #5803.1112
        shll      $5, %edi                                      #5803.577
        vmovq     (%rcx,%r8), %xmm11                            #5803.1312
        vmovhpd   (%rdx,%r8), %xmm9, %xmm4                      #5803.1080
        vmovhpd   (%rdi,%r8), %xmm11, %xmm10                    #5803.1280
        vmovq     8(%rax,%r8), %xmm9                            #5805.1114
        vmovq     8(%rcx,%r8), %xmm11                           #5805.1314
        vmovq     16(%rax,%r8), %xmm13                          #5804.1112
        vmovhpd   8(%rdx,%r8), %xmm9, %xmm8                     #5805.1082
        vmovq     16(%rcx,%r8), %xmm5                           #5804.1312
        vmovhpd   16(%rdx,%r8), %xmm13, %xmm12                  #5804.1080
        vmovhpd   16(%rdi,%r8), %xmm5, %xmm7                    #5804.1280
        vinsertf128 $1, %xmm10, %ymm4, %ymm14                   #5803.1034
        vmovhpd   8(%rdi,%r8), %xmm11, %xmm10                   #5805.1282
        vinsertf128 $1, %xmm10, %ymm8, %ymm13                   #5805.1036
        vinsertf128 $1, %xmm7, %ymm12, %ymm4                    #5804.1034
        vmulpd    %ymm0, %ymm13, %ymm7                          #5807.22
        vmulpd    %ymm0, %ymm14, %ymm12                         #5806.19
        vaddpd    %ymm7, %ymm4, %ymm8                           #5808.22
        vaddpd    %ymm8, %ymm12, %ymm5                          #5809.21
        vsubpd    %ymm8, %ymm4, %ymm9                           #5810.18
        vsubpd    %ymm5, %ymm8, %ymm11                          #5812.18
        vaddpd    %ymm9, %ymm7, %ymm10                          #5811.18
        vaddpd    %ymm11, %ymm12, %ymm12                        #5813.18
        vmulpd    %ymm0, %ymm0, %ymm11                          #5815.15
        vaddpd    %ymm12, %ymm10, %ymm10                        #5814.21
        vmulpd    17024+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm11, %ymm7 #5818.29
        vaddpd    16960+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm7, %ymm9 #5818.14
        vmulpd    17216+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm11, %ymm7 #5825.29
        vmulpd    %ymm9, %ymm11, %ymm8                          #5819.14
        vaddpd    %ymm13, %ymm14, %ymm9                         #5821.13
        vmulpd    %ymm8, %ymm0, %ymm12                          #5820.14
        vmulpd    %ymm0, %ymm4, %ymm0                           #5830.35
        vmulpd    %ymm9, %ymm12, %ymm14                         #5822.32
        vaddpd    %ymm14, %ymm10, %ymm8                         #5822.17
        vaddpd    17152+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm7, %ymm10 #5825.14
        vmulpd    %ymm10, %ymm11, %ymm12                        #5827.29
        vsubpd    %ymm0, %ymm9, %ymm10                          #5830.13
        vmovq     24(%rax,%r8), %xmm0                           #5831.1112
        vaddpd    17088+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm12, %ymm13 #5827.14
        vmulpd    %ymm10, %ymm3, %ymm3                          #5832.31
        vmulpd    %ymm13, %ymm11, %ymm11                        #5828.14
        vmulpd    %ymm11, %ymm4, %ymm14                         #5829.32
        vmovhpd   24(%rdx,%r8), %xmm0, %xmm4                    #5831.1080
        vaddpd    %ymm14, %ymm8, %ymm7                          #5829.17
        vmovq     24(%rcx,%r8), %xmm8                           #5831.1312
        vmovhpd   24(%rdi,%r8), %xmm8, %xmm9                    #5831.1280
        vextractf128 $1, %ymm15, %xmm2                          #5786.151
        vshufps   $221, %xmm2, %xmm15, %xmm2                    #5835.95
        vmovmskps %xmm2, %r9d                                   #5835.78
        vinsertf128 $1, %xmm9, %ymm4, %ymm11                    #5831.1034
        vaddpd    %ymm3, %ymm11, %ymm0                          #5832.16
        vaddpd    %ymm0, %ymm7, %ymm3                           #5833.17
        vaddpd    %ymm3, %ymm5, %ymm0                           #5834.14
        testl     %r9d, %r9d                                    #5836.66
        jne       ..B9.12       # Prob 5%                       #5836.66
                                # LOE rbx r12 r13 r14 r15 esi ymm0 ymm1 ymm6 ymm15
..B9.2:                         # Preds ..B9.12 ..B9.1
                                # Execution count [1.00e+00]
        testl     %esi, %esi                                    #6094.52
        jne       ..B9.4        # Prob 5%                       #6094.52
                                # LOE rbx r12 r13 r14 r15 esi ymm0 ymm6
..B9.3:                         # Preds ..B9.4 ..B9.10 ..B9.2
                                # Execution count [1.00e+00]
        movq      %rbp, %rsp                                    #6097.12
        popq      %rbp                                          #6097.12
        .cfi_def_cfa 7, 8
        .cfi_restore 6
        ret                                                     #6097.12
        .cfi_def_cfa 6, 16
        .cfi_offset 6, -16
                                # LOE
..B9.4:                         # Preds ..B9.2
                                # Execution count [5.00e-02]: Infreq
        vmovupd   %ymm6, 64(%rsp)                               #6094.200
        vmovupd   %ymm0, 128(%rsp)                              #6094.276
        je        ..B9.3        # Prob 95%                      #6094.380
                                # LOE rbx r12 r13 r14 r15 esi ymm0
..B9.7:                         # Preds ..B9.4
                                # Execution count [2.25e-03]: Infreq
        xorl      %eax, %eax                                    #6094.460
                                # LOE rbx r12 r13 r14 r15 eax esi
..B9.15:                        # Preds ..B9.7
                                # Execution count [2.25e-03]: Infreq
        vzeroupper                                              #
        movq      %r12, 8(%rsp)                                 #[spill]
        .cfi_escape 0x10, 0x0c, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0xc8, 0xfe, 0xff, 0xff, 0x22
        movl      %eax, %r12d                                   #
        movq      %r13, (%rsp)                                  #[spill]
        .cfi_escape 0x10, 0x0d, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0xc0, 0xfe, 0xff, 0xff, 0x22
        movl      %esi, %r13d                                   #
                                # LOE rbx r12 r14 r15 r13d
..B9.8:                         # Preds ..B9.9 ..B9.15
                                # Execution count [1.25e-02]: Infreq
        btl       %r12d, %r13d                                  #6094.523
        jc        ..B9.11       # Prob 5%                       #6094.523
                                # LOE rbx r12 r14 r15 r13d
..B9.9:                         # Preds ..B9.11 ..B9.8
                                # Execution count [1.25e-02]: Infreq
        incl      %r12d                                         #6094.476
        cmpl      $4, %r12d                                     #6094.471
        jl        ..B9.8        # Prob 82%                      #6094.471
                                # LOE rbx r12 r14 r15 r13d
..B9.10:                        # Preds ..B9.9
                                # Execution count [2.25e-03]: Infreq
        movq      8(%rsp), %r12                                 #[spill]
        .cfi_restore 12
        movq      (%rsp), %r13                                  #[spill]
        .cfi_restore 13
        vmovupd   128(%rsp), %ymm0                              #6094.682
        jmp       ..B9.3        # Prob 100%                     #6094.682
        .cfi_escape 0x10, 0x0c, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0xc8, 0xfe, 0xff, 0xff, 0x22
        .cfi_escape 0x10, 0x0d, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0xc0, 0xfe, 0xff, 0xff, 0x22
                                # LOE rbx r12 r13 r14 r15 ymm0
..B9.11:                        # Preds ..B9.8
                                # Execution count [6.25e-04]: Infreq
        lea       64(%rsp,%r12,8), %rdi                         #6094.552
        lea       128(%rsp,%r12,8), %rsi                        #6094.552
..___tag_value___jsvml_cos4_ha_e9.202:
#       __jsvml_dcos_ha_cout_rare_internal(const double *, double *)
        call      __jsvml_dcos_ha_cout_rare_internal             #6094.552
..___tag_value___jsvml_cos4_ha_e9.203:
        jmp       ..B9.9        # Prob 100%                     #6094.552
        .cfi_restore 12
        .cfi_restore 13
                                # LOE rbx r14 r15 r12d r13d
..B9.12:                        # Preds ..B9.1
                                # Execution count [5.00e-02]: Infreq
        vmovupd   16512+__jsvml_dcos_ha_data_internal_ha(%rip), %ymm4 #5839.58
        lea       __jsvml_dcos_ha_reduction_data_internal(%rip), %rcx #5931.621
        vmovupd   %ymm15, 32(%rsp)                              #[spill]
        vmovupd   %ymm6, (%rsp)                                 #[spill]
        vmovdqu   .L_2il0floatpacket.34(%rip), %xmm7            #5928.22
        vmovupd   %ymm0, 64(%rsp)                               #[spill]
        vandpd    %ymm1, %ymm4, %ymm11                          #5840.17
        vcmpeqpd  %ymm4, %ymm11, %ymm9                          #5841.25
        vextractf128 $1, %ymm9, %xmm15                          #5842.132
        vshufps   $221, %xmm15, %xmm9, %xmm13                   #5843.65
        vmovmskps %xmm13, %esi                                  #5843.48
        vmovdqu   .L_2il0floatpacket.35(%rip), %xmm15           #5937.25
        vpand     %xmm6, %xmm7, %xmm1                           #5929.22
        vextractf128 $1, %ymm6, %xmm13                          #5927.109
        vpsrlq    $52, %xmm1, %xmm2                             #5930.22
        vmovd     %xmm2, %edi                                   #5931.124
        vmovups   %xmm6, 96(%rsp)                               #5927.37[spill]
        vpand     %xmm6, %xmm15, %xmm6                          #5939.25
        vpand     %xmm13, %xmm7, %xmm8                          #5929.97
        vpsrlq    $52, %xmm8, %xmm14                            #5930.85
        vmovd     %xmm14, %r9d                                  #5931.257
        lea       (%rdi,%rdi,2), %edx                           #5931.432
        vmovdqu   .L_2il0floatpacket.36(%rip), %xmm7            #5938.24
        vmovups   %xmm13, 112(%rsp)                             #5927.109[spill]
        vpextrd   $2, %xmm14, %r11d                             #5931.321
        vpextrd   $2, %xmm2, %r8d                               #5931.189
        lea       (%r9,%r9,2), %r10d                            #5931.534
        shll      $3, %r10d                                     #5931.534
        lea       __jsvml_dcos_ha_data_internal_ha(%rip), %r9    #6059.617
        vmovq     (%r10,%rcx), %xmm11                           #5931.1369
        shll      $3, %edx                                      #5931.432
        lea       (%r11,%r11,2), %edi                           #5931.585
        shll      $3, %edi                                      #5931.585
        lea       (%r8,%r8,2), %eax                             #5931.483
        vmovhpd   (%rdi,%rcx), %xmm11, %xmm2                    #5931.1337
        vpaddq    %xmm7, %xmm6, %xmm11                          #5940.25
        vpand     %xmm13, %xmm15, %xmm6                         #5939.106
        shll      $3, %eax                                      #5931.483
        vmovq     8(%rdx,%rcx), %xmm3                           #5932.1170
        vpaddq    %xmm7, %xmm6, %xmm7                           #5940.111
        vmovq     16(%rdx,%rcx), %xmm12                         #5933.1169
        vmovhpd   8(%rax,%rcx), %xmm3, %xmm9                    #5932.1138
        vmovdqu   .L_2il0floatpacket.37(%rip), %xmm13           #5941.21
        vmovq     8(%r10,%rcx), %xmm0                           #5932.1370
        vpand     %xmm13, %xmm2, %xmm14                         #5943.83
        vmovhpd   16(%rax,%rcx), %xmm12, %xmm1                  #5933.1137
        vpsrlq    $32, %xmm9, %xmm12                            #5944.16
        vpand     %xmm13, %xmm9, %xmm6                          #5945.16
        vpsrlq    $32, %xmm11, %xmm9                            #5948.16
        vpand     %xmm13, %xmm11, %xmm8                         #5949.16
        vpand     %xmm13, %xmm7, %xmm11                         #5949.90
        vmovq     (%rdx,%rcx), %xmm10                           #5931.1169
        vmovhpd   8(%rdi,%rcx), %xmm0, %xmm4                    #5932.1338
        vmovdqu   %xmm14, 176(%rsp)                             #5943.83[spill]
        vpand     %xmm13, %xmm4, %xmm0                          #5945.84
        vpmuludq  %xmm14, %xmm11, %xmm14                        #5957.78
        vmovhpd   (%rax,%rcx), %xmm10, %xmm10                   #5931.1137
        vmovupd   %xmm2, 144(%rsp)                              #5931.1337[spill]
        vpsrlq    $32, %xmm1, %xmm2                             #5946.16
        vpand     %xmm13, %xmm1, %xmm1                          #5947.16
        vpand     %xmm13, %xmm10, %xmm15                        #5943.16
        vmovq     16(%r10,%rcx), %xmm5                          #5933.1369
        vmovupd   %xmm10, 128(%rsp)                             #5931.1137[spill]
        vpsrlq    $32, %xmm7, %xmm10                            #5948.76
        vmovdqu   %xmm0, 224(%rsp)                              #5945.84[spill]
        vpmuludq  %xmm0, %xmm11, %xmm7                          #5959.78
        vpmuludq  %xmm1, %xmm9, %xmm0                           #5955.17
        vpmuludq  %xmm2, %xmm9, %xmm1                           #5954.17
        vpmuludq  %xmm2, %xmm8, %xmm2                           #5960.17
        vmovhpd   16(%rdi,%rcx), %xmm5, %xmm3                   #5933.1337
        vpsrlq    $32, %xmm4, %xmm5                             #5944.70
        vmovdqu   %xmm5, 208(%rsp)                              #5944.70[spill]
        vpsrlq    $32, %xmm2, %xmm2                             #5962.17
        vmovdqu   %xmm14, 256(%rsp)                             #5957.78[spill]
        vpsrlq    $32, %xmm3, %xmm4                             #5946.69
        vpmuludq  %xmm5, %xmm11, %xmm14                         #5958.78
        vpand     %xmm13, %xmm3, %xmm3                          #5947.83
        vpmuludq  %xmm6, %xmm8, %xmm5                           #5959.17
        vpmuludq  %xmm6, %xmm9, %xmm6                           #5953.17
        vpaddq    %xmm2, %xmm1, %xmm1                           #5966.17
        vmovdqu   %xmm15, 160(%rsp)                             #5943.16[spill]
        vpmuludq  %xmm15, %xmm8, %xmm15                         #5957.17
        vmovdqu   %xmm15, 240(%rsp)                             #5957.17[spill]
        vpsrlq    $32, %xmm0, %xmm15                            #5980.17
        vpand     %xmm13, %xmm5, %xmm0                          #5970.17
        vpsrlq    $32, %xmm5, %xmm5                             #5963.17
        vpaddq    %xmm1, %xmm0, %xmm0                           #5975.17
        vpaddq    %xmm5, %xmm6, %xmm6                           #5967.17
        vpaddq    %xmm0, %xmm15, %xmm2                          #5981.17
        vpmuludq  %xmm3, %xmm10, %xmm15                         #5955.78
        vpmuludq  %xmm4, %xmm10, %xmm3                          #5954.78
        vpmuludq  %xmm4, %xmm11, %xmm4                          #5960.78
        vpsrlq    $32, %xmm4, %xmm4                             #5962.70
        vpand     %xmm13, %xmm7, %xmm0                          #5970.84
        vmovdqu   %xmm12, 192(%rsp)                             #5944.16[spill]
        vpsrlq    $32, %xmm15, %xmm15                           #5980.70
        vpmuludq  %xmm12, %xmm8, %xmm12                         #5958.17
        vpsrlq    $32, %xmm7, %xmm7                             #5963.70
        vpaddq    %xmm4, %xmm3, %xmm1                           #5966.80
        vpaddq    %xmm1, %xmm0, %xmm3                           #5975.80
        vpaddq    %xmm3, %xmm15, %xmm4                          #5981.80
        vpand     %xmm13, %xmm12, %xmm15                        #5971.17
        vpsrlq    $32, %xmm2, %xmm1                             #5982.17
        vpaddq    %xmm6, %xmm15, %xmm15                         #5976.17
        vpaddq    %xmm15, %xmm1, %xmm15                         #5983.17
        vpmuludq  224(%rsp), %xmm10, %xmm1                      #5953.78[spill]
        vpaddq    %xmm7, %xmm1, %xmm5                           #5967.80
        vpmuludq  192(%rsp), %xmm9, %xmm1                       #5952.17[spill]
        vpmuludq  160(%rsp), %xmm9, %xmm9                       #5951.17[spill]
        vpand     %xmm13, %xmm14, %xmm0                         #5971.84
        vpsrlq    $32, %xmm12, %xmm12                           #5964.17
        vpaddq    %xmm5, %xmm0, %xmm6                           #5976.80
        vpaddq    %xmm12, %xmm1, %xmm1                          #5968.17
        vpmuludq  208(%rsp), %xmm10, %xmm12                     #5952.78[spill]
        vpmuludq  176(%rsp), %xmm10, %xmm10                     #5951.78[spill]
        vpsrlq    $32, %xmm4, %xmm3                             #5982.70
        vpsrlq    $32, %xmm15, %xmm0                            #5984.17
        vpaddq    %xmm6, %xmm3, %xmm7                           #5983.80
        vmovdqu   240(%rsp), %xmm3                              #5972.17[spill]
        vpsrlq    $32, %xmm14, %xmm14                           #5964.70
        vpand     %xmm13, %xmm3, %xmm6                          #5972.17
        vpsrlq    $32, %xmm3, %xmm3                             #5965.17
        vpaddq    %xmm1, %xmm6, %xmm6                           #5977.17
        vpaddq    %xmm14, %xmm12, %xmm12                        #5968.80
        vpaddq    %xmm6, %xmm0, %xmm6                           #5985.17
        vpaddq    %xmm3, %xmm9, %xmm9                           #5969.17
        vmovdqu   256(%rsp), %xmm0                              #5972.84[spill]
        vpsrlq    $32, %xmm7, %xmm1                             #5984.70
        vpand     %xmm13, %xmm0, %xmm5                          #5972.84
        vpsrlq    $32, %xmm6, %xmm14                            #5986.17
        vpaddq    %xmm12, %xmm5, %xmm5                          #5977.80
        vmovupd   128(%rsp), %xmm12                             #5942.16[spill]
        vpand     %xmm13, %xmm6, %xmm6                          #5989.17
        vpaddq    %xmm5, %xmm1, %xmm1                           #5985.80
        vpsrlq    $32, %xmm12, %xmm5                            #5942.16
        vpand     %xmm13, %xmm2, %xmm2                          #5988.17
        vpmuludq  %xmm5, %xmm8, %xmm8                           #5956.17
        vpsllq    $32, %xmm15, %xmm15                           #5991.23
        vpand     %xmm13, %xmm8, %xmm8                          #5973.17
        vpsllq    $32, %xmm7, %xmm7                             #5991.82
        vpaddq    %xmm9, %xmm8, %xmm8                           #5978.17
        vmovupd   144(%rsp), %xmm5                              #5942.69[spill]
        vpsrlq    $32, %xmm1, %xmm9                             #5986.70
        vpaddq    %xmm8, %xmm14, %xmm14                         #5987.17
        vpsrlq    $32, %xmm5, %xmm8                             #5942.69
        vpsllq    $32, %xmm14, %xmm12                           #5990.23
        vpmuludq  %xmm8, %xmm11, %xmm11                         #5956.78
        vpsrlq    $32, %xmm0, %xmm8                             #5965.70
        vpaddq    %xmm8, %xmm10, %xmm10                         #5969.80
        vpaddq    %xmm6, %xmm12, %xmm6                          #5992.23
        vmovupd   .L_2il0floatpacket.76(%rip), %ymm12           #6001.15
        vpand     %xmm13, %xmm11, %xmm14                        #5973.84
        vpand     %xmm13, %xmm1, %xmm1                          #5989.84
        vpaddq    %xmm10, %xmm14, %xmm11                        #5978.80
        vpaddq    %xmm2, %xmm15, %xmm10                         #5993.23
        vpaddq    %xmm11, %xmm9, %xmm9                          #5987.80
        vpsllq    $32, %xmm9, %xmm3                             #5990.82
        vpand     %xmm13, %xmm4, %xmm13                         #5988.84
        vmovdqu   .L_2il0floatpacket.38(%rip), %xmm4            #5994.21
        vpsrlq    $12, %xmm6, %xmm9                             #5998.24
        vpaddq    %xmm1, %xmm3, %xmm8                           #5992.98
        vpaddq    %xmm13, %xmm7, %xmm7                          #5993.98
        vpand     96(%rsp), %xmm4, %xmm1                        #5995.21[spill]
        vpsrlq    $12, %xmm8, %xmm11                            #5998.90
        vmovdqu   .L_2il0floatpacket.39(%rip), %xmm14           #5996.26
        vpand     112(%rsp), %xmm4, %xmm15                      #5995.94[spill]
        vpxor     %xmm14, %xmm1, %xmm13                         #5997.26
        vpxor     %xmm14, %xmm15, %xmm3                         #5997.111
        vpor      %xmm13, %xmm9, %xmm2                          #5999.24
        vpor      %xmm3, %xmm11, %xmm0                          #5999.109
        vmovups   .L_2il0floatpacket.41(%rip), %xmm14           #6006.19
        vmovdqu   .L_2il0floatpacket.42(%rip), %xmm11           #6008.26
        vinsertf128 $1, %xmm0, %ymm2, %ymm5                     #6000.17
        vaddpd    %ymm12, %ymm5, %ymm9                          #6002.19
        vsubpd    %ymm12, %ymm9, %ymm4                          #6003.9
        vpxor     %xmm11, %xmm15, %xmm12                        #6009.111
        vsubpd    %ymm4, %ymm5, %ymm4                           #6004.17
        vpxor     %xmm11, %xmm1, %xmm5                          #6009.26
        vandps    %xmm14, %xmm9, %xmm13                         #6007.19
        vextractf128 $1, %ymm9, %xmm2                           #6005.118
        vmovd     %xmm13, %eax                                  #6059.132
        vandps    %xmm14, %xmm2, %xmm9                          #6007.88
        vmovdqu   .L_2il0floatpacket.43(%rip), %xmm14           #6010.24
        vpand     %xmm10, %xmm14, %xmm3                         #6011.24
        vpand     %xmm7, %xmm14, %xmm11                         #6011.107
        vpsllq    $28, %xmm3, %xmm0                             #6012.24
        vpsllq    $28, %xmm11, %xmm3                            #6012.91
        vpor      %xmm5, %xmm0, %xmm2                           #6013.24
        vpor      %xmm12, %xmm3, %xmm0                          #60