!***********************************************************************
! This file is part of OpenMolcas.                                     *
!                                                                      *
! OpenMolcas is free software; you can redistribute it and/or modify   *
! it under the terms of the GNU Lesser General Public License, v. 2.1. *
! OpenMolcas is distributed in the hope that it will be useful, but it *
! is provided "as is" and without any express or implied warranties.   *
! For more details see the full text of the license in the file        *
! LICENSE or in <http://www.gnu.org/licenses/>.                        *
!***********************************************************************

subroutine RdCmo_motra(CMO,Ovlp)
!***********************************************************************
!                                                                      *
! Purpose:                                                             *
! Read molecular orbitals from input                                   *
! iVecTyp=1  : obsolete, regarded as error                             *
! iVecTyp=2  : read from unit INPORB in the same format                *
! iVecTyp=3  : read from an old casscf interface unit JOBIPH.          *
!                                                                      *
!***********************************************************************

#include "intent.fh"

use motra_global, only: FnInpOrb, FnJobIph, iortho, iVecTyp, LuInpOrb, LuJobIph, MxTit, nBas, nDel, nSym, nTot2, VecTit
use stdalloc, only: mma_allocate, mma_deallocate
use Definitions, only: wp, iwp, u6

implicit none
real(kind=wp), intent(_OUT_) :: CMO(*)
real(kind=wp), intent(in) :: Ovlp(*)
#include "Molcas.fh"
integer(kind=iwp) :: iDisk, iDummy(1), iErr, iPt2, TcJobIph(10)
real(kind=wp) :: Dummy(1)
integer(kind=iwp), allocatable :: itemp2(:)
real(kind=wp), allocatable :: temp2(:)
character, allocatable :: ctemp2(:)
logical(kind=iwp) :: okay

!----------------------------------------------------------------------*
! Read MO coefficients from input                                      *
!----------------------------------------------------------------------*
if (iVecTyp == 1) then
  write(u6,*) 'RdCmo_motra: iVecTyp == 1'
  write(u6,*) 'This error means someone has put a bug into MOTRA!'
  call Abend()
end if
!----------------------------------------------------------------------*
! Read MO coefficients from a formatted vector file                    *
!----------------------------------------------------------------------*
if (iVecTyp == 2) then
  call f_Inquire(FnInpOrb,okay)
  if (okay) then
    call RdVec(FnInpOrb,LuInpOrb,'C',nSym,nBas,nBas,Cmo,Dummy,Dummy,iDummy,VecTit,0,iErr)
  else
    write(u6,*) 'RdCMO_motra: Error finding MO file'
    call Abend()
  end if
end if
!----------------------------------------------------------------------*
! Read MO coefficients from JOBIPH generated by RASSCF                 *
!----------------------------------------------------------------------*
if (iVecTyp == 3) then
  call f_Inquire(FnJobIph,okay)
  if (okay) then
    call DaName(LuJobIph,FnJobIph)
    iDisk = 0
    call iDaFile(LuJobIph,2,TcJobIph,10,iDisk)
    iDisk = TcJobIph(1)
    call mma_allocate(itemp2,max(9,MxSym,MxRoot),label='itemp2')
    call mma_allocate(temp2,MxRoot,label='temp2')
    call mma_allocate(ctemp2,max(LenIn8*mxOrb,144,4*18*mxTit),label='ctemp2')
    call WR_RASSCF_Info(LuJobIph,2,iDisk,itemp2(1),itemp2(2),itemp2(3),itemp2(4),itemp2,itemp2,itemp2,itemp2,itemp2,mxSym,ctemp2, &
                        LenIn8*mxOrb,itemp2(5),ctemp2,144,ctemp2,4*18*mxTit,temp2(1),itemp2(6),itemp2(7),itemp2,mxRoot,itemp2, &
                        itemp2,itemp2,itemp2(8),itemp2(9),iPt2,temp2)
    call mma_deallocate(itemp2)
    call mma_deallocate(temp2)
    call mma_deallocate(ctemp2)
    iDisk = TcJobIph(2)
    if (iPt2 /= 0) iDisk = TcJobIph(9)
    call dDaFile(LuJobIph,2,Cmo,nTot2,iDisk)
    call DaClos(LuJobIph)
    VecTit = 'JOBIPH'
  else
    write(u6,*) 'RdCMO_motra: Error finding JOBIPH file'
    call Abend()
  end if
end if
!----------------------------------------------------------------------*
! Normal termination                                                   *
!----------------------------------------------------------------------*
if (iortho == 0) then
  call Ortho_Motra(nSym,nBas,nDel,Ovlp,Cmo)
else
  write(u6,*) 'WARNING: Molecular orbitals are not orthogonalized'
end if

return

end subroutine RdCmo_motra
