/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "encryptedfile.h"

static const uint8 XOR_TABLE[] = {
	0x41, 0x2b, 0x7a, 0x0c, 0xc8, 0xe5, 0x0c, 0xde, 0x45, 0xa8, 0x00, 0xad,
	0x70, 0xac, 0x23, 0xe0, 0x0c, 0xde, 0xac, 0x16, 0xa1, 0x1a, 0x70, 0x17,
	0x1b, 0x90, 0x34, 0x6e, 0x53, 0xfe, 0xdd, 0x3c, 0xef, 0x74, 0x75, 0x3e,
	0x2e, 0xb0, 0x3d, 0x2b, 0x74, 0x6d, 0x59, 0xde, 0xc6, 0x20, 0xb8, 0xf3,
	0x7d, 0xfa, 0x4d, 0xbd, 0xdb, 0x3c, 0xc5, 0xcb, 0x57, 0x13, 0x40, 0x6b,
	0xb8, 0xad, 0xb9, 0xc1, 0x6a, 0x37, 0x39, 0x80, 0x94, 0xd3, 0xdf, 0x4b,
	0xe4, 0xe4, 0x7a, 0x4c, 0x0f, 0x21, 0x27, 0x9a, 0x7e, 0x52, 0x35, 0x58,
	0xb4, 0xbc, 0x5a, 0xc9, 0x48, 0x7f, 0xcc, 0xb6, 0x97, 0x7b, 0xf1, 0xd5,
	0x88, 0x8c, 0xa9, 0x27, 0xf7, 0x20, 0x68, 0x65, 0xad, 0x6f, 0x9e, 0x07,
	0xf8, 0xf6, 0x2c, 0x65, 0x4a, 0xe9, 0xd8, 0x13, 0x6a, 0xb5, 0x14, 0x6f,
	0x29, 0xdc, 0x68, 0xf8, 0xa0, 0xb6, 0x73, 0x03, 0x69, 0xe3, 0x4f, 0xb6,
	0x59, 0x79, 0xae, 0x93, 0xad, 0x40, 0x27, 0xd0, 0xb5, 0x7a, 0x68, 0x5d,
	0x5e, 0x19, 0x53, 0x4f, 0x40, 0x56, 0x3d, 0x10, 0xf8, 0x0a, 0xc6, 0x90,
	0x06, 0x45, 0x13, 0x4a, 0x6a, 0xfe, 0x56, 0xeb, 0xbc, 0xd9, 0xee, 0xe0,
	0x85, 0x5e, 0x98, 0x23, 0xf9, 0x19, 0x60, 0xf9, 0x7e, 0x8d, 0x61, 0xa0,
	0x7c, 0xe1, 0x84, 0xf2, 0x7a, 0xb8, 0xbe, 0x8e, 0x81, 0x9e, 0x87, 0x20,
	0x32, 0xf3, 0x8c, 0xb4, 0x2c, 0x4d, 0xc8, 0x50, 0x9b, 0xa5, 0x9c, 0x27,
	0x02, 0xd6, 0x7f, 0x2a, 0xaf, 0x46, 0x65, 0xd0, 0x6a, 0xae, 0xfa, 0x53,
	0x37, 0x6c, 0x49, 0xb9, 0x4d, 0xcd, 0x6c, 0x6b, 0xa7, 0x2d, 0x66, 0x32,
	0xb4, 0xf5, 0x41, 0xd5, 0x18, 0xc4, 0xfd, 0xbe, 0x8a, 0x47, 0x11, 0x50,
	0x3d, 0x97, 0x64, 0xda, 0x5a, 0x27, 0x18, 0x60, 0x78, 0x80, 0x86, 0x8a,
	0x2a, 0x72, 0x40, 0x89
};

namespace MutationOfJB {

uint32 EncryptedFile::read(void *dataPtr, uint32 dataSize) {
	uint8 xorPos = static_cast<uint8>(pos() % ARRAYSIZE(XOR_TABLE));
	const uint32 readBytes = Common::File::read(dataPtr, dataSize);

	for (uint32 i = 0; i < readBytes; ++i) {
		static_cast<uint8 *>(dataPtr)[i] ^= XOR_TABLE[xorPos];
		xorPos++;
	}

	return readBytes;
}

}
