use std::process::Command;
fn main() {
    if std::env::var("SHOTMAN_VERSION").is_err() {
        let version = Command::new("git")
            .args(["describe", "--tags"])
            .output()
            .map(|o| {
                if o.status.success() {
                    String::from_utf8_lossy(&o.stdout).trim().to_owned()
                } else {
                    String::from("unversioned") // git exited non-zero
                }
            })
            .unwrap_or(String::from("unknown")); // failed to run git

        println!("cargo:rustc-env=SHOTMAN_VERSION={version}");
    }
}
