/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Thu Mar  3 12:51:49 2022

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_35 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 6814, "epsg", 6814,
        "NAD83(2011) / Oregon Cottage Grove-Canyonville zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-123.3333333");
    add_proj4text (p, 1,
        "333333 +k=1.000023 +x_0=50000 +y_0=0 +ellps=GRS80 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Cottage Grove-Canyonville ");
    add_srs_wkt (p, 1,
        "zone (m)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National");
    add_srs_wkt (p, 2,
        "_Spatial_Reference_System_2011\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 3,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",42.8333333333333],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",-123.333333333333],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1.000023],PARAMETER[\"false_easting\",50000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"6814\"]]");
    p = add_epsg_def_ex (filter, first, last, 6815, "epsg", 6815,
        "NAD83(2011) / Oregon Cottage Grove-Canyonville zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-123.3333333");
    add_proj4text (p, 1,
        "333333 +k=1.000023 +x_0=50000.00001504 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Cottage Grove-Canyonville ");
    add_srs_wkt (p, 1,
        "zone (ft)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_Nationa");
    add_srs_wkt (p, 2,
        "l_Spatial_Reference_System_2011\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 3,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"631");
    add_srs_wkt (p, 7,
        "8\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",42.8333333333333],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-123.333333333333],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1.000023],PARAMETER[\"false_easting\",164041.9948],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"foot\",0.3048,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 13,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"6815\"]]");
    p = add_epsg_def_ex (filter, first, last, 6816, "epsg", 6816,
        "NAD83(CORS96) / Oregon Dufur-Madras zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.5 +lon_0=-121 +k=1.00011 +x_0=8000");
    add_proj4text (p, 1,
        "0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Dufur-Madras zone (m)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Oper");
    add_srs_wkt (p, 2,
        "ating_Reference_Station_1996\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 3,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6783\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",44.5],PARAMETER[\"central_meridian\",-12");
    add_srs_wkt (p, 9,
        "1],PARAMETER[\"scale_factor\",1.00011],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",80000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"681");
    add_srs_wkt (p, 13,
        "6\"]]");
    p = add_epsg_def_ex (filter, first, last, 6817, "epsg", 6817,
        "NAD83(CORS96) / Oregon Dufur-Madras zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.5 +lon_0=-121 +k=1.00011 +x_0=7999");
    add_proj4text (p, 1,
        "9.99999968 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Dufur-Madras zone (ft)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Ope");
    add_srs_wkt (p, 2,
        "rating_Reference_Station_1996\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 3,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6783\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",44.5],PARAMETER[\"central_meridian\",-12");
    add_srs_wkt (p, 9,
        "1],PARAMETER[\"scale_factor\",1.00011],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",262467.1916],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"6817\"]]");
    p = add_epsg_def_ex (filter, first, last, 6818, "epsg", 6818,
        "NAD83(2011) / Oregon Dufur-Madras zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.5 +lon_0=-121 +k=1.00011 +x_0=8000");
    add_proj4text (p, 1,
        "0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Dufur-Madras zone (m)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refe");
    add_srs_wkt (p, 2,
        "rence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",44.5],PARAMETER[\"central_meridian\",-121],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1.00011],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "80000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6818\"]]");
    p = add_epsg_def_ex (filter, first, last, 6819, "epsg", 6819,
        "NAD83(2011) / Oregon Dufur-Madras zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.5 +lon_0=-121 +k=1.00011 +x_0=7999");
    add_proj4text (p, 1,
        "9.99999968 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Dufur-Madras zone (ft)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",44.5],PARAMETER[\"central_meridian\",-121],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1.00011],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "262467.1916],PARAMETER[\"false_northing\",0],UNIT[\"foot");
    add_srs_wkt (p, 11,
        "\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"681");
    add_srs_wkt (p, 13,
        "9\"]]");
    p = add_epsg_def_ex (filter, first, last, 6820, "epsg", 6820,
        "NAD83(CORS96) / Oregon Eugene zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.75 +lon_0=-123.1666666666667 +k=1.");
    add_proj4text (p, 1,
        "000015 +x_0=50000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Eugene zone (m)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operating_");
    add_srs_wkt (p, 2,
        "Reference_Station_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6783\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",43.75],PARAMETER[\"central_meridian\",-123.166");
    add_srs_wkt (p, 9,
        "666666667],PARAMETER[\"scale_factor\",1.000015],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",50000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"6820\"]]");
    p = add_epsg_def_ex (filter, first, last, 6821, "epsg", 6821,
        "NAD83(CORS96) / Oregon Eugene zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.75 +lon_0=-123.1666666666667 +k=1.");
    add_proj4text (p, 1,
        "000015 +x_0=50000.00001504 +y_0=0 +ellps=GRS80 +units=ft");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Eugene zone (ft)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operating");
    add_srs_wkt (p, 2,
        "_Reference_Station_1996\",SPHEROID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 3,
        "298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6783\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",43.75],PARAMETER[\"central_meridian\",-123.16");
    add_srs_wkt (p, 9,
        "6666666667],PARAMETER[\"scale_factor\",1.000015],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",164041.9948],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"6821\"]]");
    p = add_epsg_def_ex (filter, first, last, 6822, "epsg", 6822,
        "NAD83(2011) / Oregon Eugene zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.75 +lon_0=-123.1666666666667 +k=1.");
    add_proj4text (p, 1,
        "000015 +x_0=50000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Eugene zone (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",43");
    add_srs_wkt (p, 8,
        ".75],PARAMETER[\"central_meridian\",-123.166666666667],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"scale_factor\",1.000015],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",50000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6822\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 6823, "epsg", 6823,
        "NAD83(2011) / Oregon Eugene zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.75 +lon_0=-123.1666666666667 +k=1.");
    add_proj4text (p, 1,
        "000015 +x_0=50000.00001504 +y_0=0 +ellps=GRS80 +units=ft");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Eugene zone (ft)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "16\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",4");
    add_srs_wkt (p, 8,
        "3.75],PARAMETER[\"central_meridian\",-123.166666666667],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1.000015],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",164041.9948],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 11,
        "IT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"6823\"]]");
    p = add_epsg_def_ex (filter, first, last, 6824, "epsg", 6824,
        "NAD83(CORS96) / Oregon Grants Pass-Ashland zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.75 +lon_0=-123.3333333333333 +k=1.");
    add_proj4text (p, 1,
        "000043 +x_0=50000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Grants Pass-Ashland zone");
    add_srs_wkt (p, 1,
        " (m)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuous");
    add_srs_wkt (p, 2,
        "ly_Operating_Reference_Station_1996\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "6783\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",41.75],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",-123.333333333333],PARAMETER[\"scale_factor\",1.00004");
    add_srs_wkt (p, 10,
        "3],PARAMETER[\"false_easting\",50000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"6824\"]]");
    p = add_epsg_def_ex (filter, first, last, 6825, "epsg", 6825,
        "NAD83(CORS96) / Oregon Grants Pass-Ashland zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.75 +lon_0=-123.3333333333333 +k=1.");
    add_proj4text (p, 1,
        "000043 +x_0=50000.00001504 +y_0=0 +ellps=GRS80 +units=ft");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Grants Pass-Ashland zone");
    add_srs_wkt (p, 1,
        " (ft)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuou");
    add_srs_wkt (p, 2,
        "sly_Operating_Reference_Station_1996\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"6783\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",41.75],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",-123.333333333333],PARAMETER[\"scale_factor\",1.00");
    add_srs_wkt (p, 10,
        "0043],PARAMETER[\"false_easting\",164041.9948],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"6825\"]]");
    p = add_epsg_def_ex (filter, first, last, 6826, "epsg", 6826,
        "NAD83(2011) / Oregon Grants Pass-Ashland zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.75 +lon_0=-123.3333333333333 +k=1.");
    add_proj4text (p, 1,
        "000043 +x_0=50000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Grants Pass-Ashland zone (");
    add_srs_wkt (p, 1,
        "m)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spati");
    add_srs_wkt (p, 2,
        "al_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",41.75],PARAMETER[\"central_meridian\",-123.33");
    add_srs_wkt (p, 9,
        "3333333333],PARAMETER[\"scale_factor\",1.000043],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",50000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"6826\"]]");
    p = add_epsg_def_ex (filter, first, last, 6827, "epsg", 6827,
        "NAD83(2011) / Oregon Grants Pass-Ashland zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.75 +lon_0=-123.3333333333333 +k=1.");
    add_proj4text (p, 1,
        "000043 +x_0=50000.00001504 +y_0=0 +ellps=GRS80 +units=ft");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Grants Pass-Ashland zone (");
    add_srs_wkt (p, 1,
        "ft)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spat");
    add_srs_wkt (p, 2,
        "ial_Reference_System_2011\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 3,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",41.75],PARAMETER[\"central_meridian\",-123.");
    add_srs_wkt (p, 9,
        "333333333333],PARAMETER[\"scale_factor\",1.000043],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",164041.9948],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "02\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"6827\"]]");
    p = add_epsg_def_ex (filter, first, last, 6828, "epsg", 6828,
        "NAD83(CORS96) / Oregon Gresham-Warm Springs zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45 +lon_0=-122.3333333333333 +k=1.000");
    add_proj4text (p, 1,
        "05 +x_0=10000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Gresham-Warm Springs zon");
    add_srs_wkt (p, 1,
        "e (m)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuou");
    add_srs_wkt (p, 2,
        "sly_Operating_Reference_Station_1996\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"6783\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",45],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",-122.333333333333],PARAMETER[\"scale_factor\",1.00005");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",10000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6828\"]]");
    p = add_epsg_def_ex (filter, first, last, 6829, "epsg", 6829,
        "NAD83(CORS96) / Oregon Gresham-Warm Springs zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45 +lon_0=-122.3333333333333 +k=1.000");
    add_proj4text (p, 1,
        "05 +x_0=10000.0000152 +y_0=0 +ellps=GRS80 +units=ft +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Gresham-Warm Springs zon");
    add_srs_wkt (p, 1,
        "e (ft)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuo");
    add_srs_wkt (p, 2,
        "usly_Operating_Reference_Station_1996\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 3,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"6783\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",45],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 9,
        "n\",-122.333333333333],PARAMETER[\"scale_factor\",1.0000");
    add_srs_wkt (p, 10,
        "5],PARAMETER[\"false_easting\",32808.399],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"6829\"]]");
    p = add_epsg_def_ex (filter, first, last, 6830, "epsg", 6830,
        "NAD83(2011) / Oregon Gresham-Warm Springs zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45 +lon_0=-122.3333333333333 +k=1.000");
    add_proj4text (p, 1,
        "05 +x_0=10000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Gresham-Warm Springs zone ");
    add_srs_wkt (p, 1,
        "(m)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spat");
    add_srs_wkt (p, 2,
        "ial_Reference_System_2011\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 3,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",45],PARAMETER[\"central_meridian\",-122.333");
    add_srs_wkt (p, 9,
        "333333333],PARAMETER[\"scale_factor\",1.00005],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",10000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"6830\"]]");
    p = add_epsg_def_ex (filter, first, last, 6831, "epsg", 6831,
        "NAD83(2011) / Oregon Gresham-Warm Springs zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45 +lon_0=-122.3333333333333 +k=1.000");
    add_proj4text (p, 1,
        "05 +x_0=10000.0000152 +y_0=0 +ellps=GRS80 +units=ft +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Gresham-Warm Springs zone ");
    add_srs_wkt (p, 1,
        "(ft)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spa");
    add_srs_wkt (p, 2,
        "tial_Reference_System_2011\",SPHEROID[\"GRS 1980\",63781");
    add_srs_wkt (p, 3,
        "37,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",45],PARAMETER[\"central_meridian\",-122.33");
    add_srs_wkt (p, 9,
        "3333333333],PARAMETER[\"scale_factor\",1.00005],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",32808.399],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"6831\"]]");
    p = add_epsg_def_ex (filter, first, last, 6832, "epsg", 6832,
        "NAD83(CORS96) / Oregon La Grande zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45 +lon_0=-118 +k=1.00013 +x_0=40000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon La Grande zone (m)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operati");
    add_srs_wkt (p, 2,
        "ng_Reference_Station_1996\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 3,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6783\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",45],PARAMETER[\"central_meridian\",-118],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",1.00013],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",40000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6832\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 6833, "epsg", 6833,
        "NAD83(CORS96) / Oregon La Grande zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45 +lon_0=-118 +k=1.00013 +x_0=39999.");
    add_proj4text (p, 1,
        "99999984 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon La Grande zone (ft)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operat");
    add_srs_wkt (p, 2,
        "ing_Reference_Station_1996\",SPHEROID[\"GRS 1980\",63781");
    add_srs_wkt (p, 3,
        "37,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6783\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",45],PARAMETER[\"central_meridian\",-118],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"scale_factor\",1.00013],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",131233.5958],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 11,
        "[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"6833\"]]");
    p = add_epsg_def_ex (filter, first, last, 6834, "epsg", 6834,
        "NAD83(2011) / Oregon La Grande zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45 +lon_0=-118 +k=1.00013 +x_0=40000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon La Grande zone (m)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",45],PARAMETER[\"central_meridian\",-118],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",1.00013],PARAMETER[\"false_easting\",40000]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"6834\"]]");
    p = add_epsg_def_ex (filter, first, last, 6835, "epsg", 6835,
        "NAD83(2011) / Oregon La Grande zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45 +lon_0=-118 +k=1.00013 +x_0=39999.");
    add_proj4text (p, 1,
        "99999984 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon La Grande zone (ft)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refere");
    add_srs_wkt (p, 2,
        "nce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 3,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",45],PARAMETER[\"central_meridian\",-118],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",1.00013],PARAMETER[\"false_easting\",131233");
    add_srs_wkt (p, 10,
        ".5958],PARAMETER[\"false_northing\",0],UNIT[\"foot\",0.3");
    add_srs_wkt (p, 11,
        "048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6835\"]]");
    p = add_epsg_def_ex (filter, first, last, 6836, "epsg", 6836,
        "NAD83(CORS96) / Oregon Ontario zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.25 +lon_0=-117 +k=1.0001 +x_0=8000");
    add_proj4text (p, 1,
        "0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Ontario zone (m)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operating");
    add_srs_wkt (p, 2,
        "_Reference_Station_1996\",SPHEROID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 3,
        "298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6783\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",43.25],PARAMETER[\"central_meridian\",-117],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"scale_factor\",1.0001],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",80000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6836\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 6837, "epsg", 6837,
        "NAD83(CORS96) / Oregon Ontario zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.25 +lon_0=-117 +k=1.0001 +x_0=7999");
    add_proj4text (p, 1,
        "9.99999968 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Ontario zone (ft)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operatin");
    add_srs_wkt (p, 2,
        "g_Reference_Station_1996\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6783\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",43.25],PARAMETER[\"central_meridian\",-117],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"scale_factor\",1.0001],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",262467.1916],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"6837\"]]");
    p = add_epsg_def_ex (filter, first, last, 6838, "epsg", 6838,
        "NAD83(2011) / Oregon Ontario zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.25 +lon_0=-117 +k=1.0001 +x_0=8000");
    add_proj4text (p, 1,
        "0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Ontario zone (m)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "16\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",4");
    add_srs_wkt (p, 8,
        "3.25],PARAMETER[\"central_meridian\",-117],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",1.0001],PARAMETER[\"false_easting\",80000]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"6838\"]]");
    p = add_epsg_def_ex (filter, first, last, 6839, "epsg", 6839,
        "NAD83(2011) / Oregon Ontario zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.25 +lon_0=-117 +k=1.0001 +x_0=7999");
    add_proj4text (p, 1,
        "9.99999968 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Ontario zone (ft)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "43.25],PARAMETER[\"central_meridian\",-117],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1.0001],PARAMETER[\"false_easting\",26246");
    add_srs_wkt (p, 10,
        "7.1916],PARAMETER[\"false_northing\",0],UNIT[\"foot\",0.");
    add_srs_wkt (p, 11,
        "3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6839\"]]");
    p = add_epsg_def_ex (filter, first, last, 6840, "epsg", 6840,
        "NAD83(CORS96) / Oregon Coast zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Hotine_Oblique_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=44.75 +lonc=-124.05 +alpha=5 +k=1 +x_");
    add_proj4text (p, 1,
        "0=-300000 +y_0=-4600000 +no_uoff +gamma=5 +ellps=GRS80 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Coast zone (m)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operating_R");
    add_srs_wkt (p, 2,
        "eference_Station_1996\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6783\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Hotine_Oblique_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 8,
        "of_center\",44.75],PARAMETER[\"longitude_of_center\",-12");
    add_srs_wkt (p, 9,
        "4.05],PARAMETER[\"azimuth\",5],PARAMETER[\"rectified_gri");
    add_srs_wkt (p, 10,
        "d_angle\",5],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_easting\",-300000],PARAMETER[\"false_northing\",-46");
    add_srs_wkt (p, 12,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"6840\"]]");
    p = add_epsg_def_ex (filter, first, last, 6841, "epsg", 6841,
        "NAD83(CORS96) / Oregon Coast zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Hotine_Oblique_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=44.75 +lonc=-124.05 +alpha=5 +k=1 +x_");
    add_proj4text (p, 1,
        "0=-299999.9999988 +y_0=-4600000.00001208 +no_uoff +gamma");
    add_proj4text (p, 2,
        "=5 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Coast zone (ft)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operating_");
    add_srs_wkt (p, 2,
        "Reference_Station_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6783\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Hotine_Oblique_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_center\",44.75],PARAMETER[\"longitude_of_center\",-");
    add_srs_wkt (p, 9,
        "124.05],PARAMETER[\"azimuth\",5],PARAMETER[\"rectified_g");
    add_srs_wkt (p, 10,
        "rid_angle\",5],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",-984251.9685],PARAMETER[\"false_northing");
    add_srs_wkt (p, 12,
        "\",-15091863.5171],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 14,
        "ORTH],AUTHORITY[\"EPSG\",\"6841\"]]");
    p = add_epsg_def_ex (filter, first, last, 6842, "epsg", 6842,
        "NAD83(2011) / Oregon Coast zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Hotine_Oblique_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=44.75 +lonc=-124.05 +alpha=5 +k=1 +x_");
    add_proj4text (p, 1,
        "0=-300000 +y_0=-4600000 +no_uoff +gamma=5 +ellps=GRS80 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Coast zone (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Ho");
    add_srs_wkt (p, 7,
        "tine_Oblique_Mercator\"],PARAMETER[\"latitude_of_center\"");
    add_srs_wkt (p, 8,
        ",44.75],PARAMETER[\"longitude_of_center\",-124.05],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"azimuth\",5],PARAMETER[\"rectified_grid_angle\",5");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",-300000],PARAMETER[\"false_northing\",-4600000],UNIT");
    add_srs_wkt (p, 12,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 13,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "6842\"]]");
    p = add_epsg_def_ex (filter, first, last, 6843, "epsg", 6843,
        "NAD83(2011) / Oregon Coast zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Hotine_Oblique_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=44.75 +lonc=-124.05 +alpha=5 +k=1 +x_");
    add_proj4text (p, 1,
        "0=-299999.9999988 +y_0=-4600000.00001208 +no_uoff +gamma");
    add_proj4text (p, 2,
        "=5 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Coast zone (ft)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Ho");
    add_srs_wkt (p, 7,
        "tine_Oblique_Mercator\"],PARAMETER[\"latitude_of_center\"");
    add_srs_wkt (p, 8,
        ",44.75],PARAMETER[\"longitude_of_center\",-124.05],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"azimuth\",5],PARAMETER[\"rectified_grid_angle\",5");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",-984251.9685],PARAMETER[\"false_northing\",-15091863");
    add_srs_wkt (p, 12,
        ".5171],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]");
    add_srs_wkt (p, 13,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 14,
        "ITY[\"EPSG\",\"6843\"]]");
    p = add_epsg_def_ex (filter, first, last, 6844, "epsg", 6844,
        "NAD83(CORS96) / Oregon Pendleton zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.25 +lon_0=-119.1666666666667 +k=1.");
    add_proj4text (p, 1,
        "000045 +x_0=60000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Pendleton zone (m)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operati");
    add_srs_wkt (p, 2,
        "ng_Reference_Station_1996\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 3,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6783\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",45.25],PARAMETER[\"central_meridian\",-119.");
    add_srs_wkt (p, 9,
        "166666666667],PARAMETER[\"scale_factor\",1.000045],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",60000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"6844\"]]");
    p = add_epsg_def_ex (filter, first, last, 6845, "epsg", 6845,
        "NAD83(CORS96) / Oregon Pendleton zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.25 +lon_0=-119.1666666666667 +k=1.");
    add_proj4text (p, 1,
        "000045 +x_0=59999.99999976 +y_0=0 +ellps=GRS80 +units=ft");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Pendleton zone (ft)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operat");
    add_srs_wkt (p, 2,
        "ing_Reference_Station_1996\",SPHEROID[\"GRS 1980\",63781");
    add_srs_wkt (p, 3,
        "37,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6783\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",45.25],PARAMETER[\"central_meridian\",-119");
    add_srs_wkt (p, 9,
        ".166666666667],PARAMETER[\"scale_factor\",1.000045],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",196850.3937],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 12,
        "002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"6845\"]]");
    p = add_epsg_def_ex (filter, first, last, 6846, "epsg", 6846,
        "NAD83(2011) / Oregon Pendleton zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.25 +lon_0=-119.1666666666667 +k=1.");
    add_proj4text (p, 1,
        "000045 +x_0=60000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Pendleton zone (m)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",45.25],PARAMETER[\"central_meridian\",-119.166666666667");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1.000045],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",60000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"684");
    add_srs_wkt (p, 13,
        "6\"]]");
    p = add_epsg_def_ex (filter, first, last, 6847, "epsg", 6847,
        "NAD83(2011) / Oregon Pendleton zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.25 +lon_0=-119.1666666666667 +k=1.");
    add_proj4text (p, 1,
        "000045 +x_0=59999.99999976 +y_0=0 +ellps=GRS80 +units=ft");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Pendleton zone (ft)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refere");
    add_srs_wkt (p, 2,
        "nce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 3,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",45.25],PARAMETER[\"central_meridian\",-119.166666666667");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1.000045],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",196850.3937],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"6847\"]]");
    p = add_epsg_def_ex (filter, first, last, 6848, "epsg", 6848,
        "NAD83(CORS96) / Oregon Pendleton-La Grande zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.08333333333334 +lon_0=-118.3333333");
    add_proj4text (p, 1,
        "333333 +k=1.000175 +x_0=30000 +y_0=0 +ellps=GRS80 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Pendleton-La Grande zone");
    add_srs_wkt (p, 1,
        " (m)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuous");
    add_srs_wkt (p, 2,
        "ly_Operating_Reference_Station_1996\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "6783\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",45.0833333333333],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-118.333333333333],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1.000175],PARAMETER[\"false_easting\",30000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"6848\"]]");
    p = add_epsg_def_ex (filter, first, last, 6849, "epsg", 6849,
        "NAD83(CORS96) / Oregon Pendleton-La Grande zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.08333333333334 +lon_0=-118.3333333");
    add_proj4text (p, 1,
        "333333 +k=1.000175 +x_0=30000.00001512 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Pendleton-La Grande zone");
    add_srs_wkt (p, 1,
        " (ft)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuou");
    add_srs_wkt (p, 2,
        "sly_Operating_Reference_Station_1996\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"6783\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",45.0833333333333],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-118.333333333333],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 10,
        "ctor\",1.000175],PARAMETER[\"false_easting\",98425.1969]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",0],UNIT[\"foot\",0.3048,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6849\"]]");
    p = add_epsg_def_ex (filter, first, last, 6850, "epsg", 6850,
        "NAD83(2011) / Oregon Pendleton-La Grande zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.08333333333334 +lon_0=-118.3333333");
    add_proj4text (p, 1,
        "333333 +k=1.000175 +x_0=30000 +y_0=0 +ellps=GRS80 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Pendleton-La Grande zone (");
    add_srs_wkt (p, 1,
        "m)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spati");
    add_srs_wkt (p, 2,
        "al_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",45.0833333333333],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 9,
        "n\",-118.333333333333],PARAMETER[\"scale_factor\",1.0001");
    add_srs_wkt (p, 10,
        "75],PARAMETER[\"false_easting\",30000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"6850\"]]");
    p = add_epsg_def_ex (filter, first, last, 6851, "epsg", 6851,
        "NAD83(2011) / Oregon Pendleton-La Grande zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.08333333333334 +lon_0=-118.3333333");
    add_proj4text (p, 1,
        "333333 +k=1.000175 +x_0=30000.00001512 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Pendleton-La Grande zone (");
    add_srs_wkt (p, 1,
        "ft)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spat");
    add_srs_wkt (p, 2,
        "ial_Reference_System_2011\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 3,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",45.0833333333333],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",-118.333333333333],PARAMETER[\"scale_factor\",1.00");
    add_srs_wkt (p, 10,
        "0175],PARAMETER[\"false_easting\",98425.1969],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"6851\"]]");
    p = add_epsg_def_ex (filter, first, last, 6852, "epsg", 6852,
        "NAD83(CORS96) / Oregon Portland zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.5 +lat_0=45.5 +lon_0=-122.75 +k_0=1.");
    add_proj4text (p, 1,
        "000002 +x_0=100000 +y_0=50000 +ellps=GRS80 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Portland zone (m)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operatin");
    add_srs_wkt (p, 2,
        "g_Reference_Station_1996\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6783\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",45.5],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-122.75],PARAMETER[\"scale_factor\",1.000002],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",100000],PARAMETER[\"false_northing\",5");
    add_srs_wkt (p, 11,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"6852\"]]");
    p = add_epsg_def_ex (filter, first, last, 6853, "epsg", 6853,
        "NAD83(CORS96) / Oregon Portland zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_1SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.5 +lat_0=45.5 +lon_0=-122.75 +k_0=1.");
    add_proj4text (p, 1,
        "000002 +x_0=99999.99999960001 +y_0=50000.00001504 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Portland zone (ft)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operati");
    add_srs_wkt (p, 2,
        "ng_Reference_Station_1996\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 3,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6783\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",45.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-122.75],PARAMETER[\"scale_factor\",1.000002],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",328083.9895],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",164041.9948],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"6853\"]]");
    p = add_epsg_def_ex (filter, first, last, 6854, "epsg", 6854,
        "NAD83(2011) / Oregon Portland zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.5 +lat_0=45.5 +lon_0=-122.75 +k_0=1.");
    add_proj4text (p, 1,
        "000002 +x_0=100000 +y_0=50000 +ellps=GRS80 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Portland zone (m)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",45.5],PARAMETER[\"central_meridian\",-122.75],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",1.000002],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",100000],PARAMETER[\"false_northing\",50000],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 13,
        "854\"]]");
    p = add_epsg_def_ex (filter, first, last, 6855, "epsg", 6855,
        "NAD83(2011) / Oregon Portland zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.5 +lat_0=45.5 +lon_0=-122.75 +k_0=1.");
    add_proj4text (p, 1,
        "000002 +x_0=99999.99999960001 +y_0=50000.00001504 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Portland zone (ft)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",45.5],PARAMETER[\"central_meridian\",-122.75],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1.000002],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",328083.9895],PARAMETER[\"false_northing\",16404");
    add_srs_wkt (p, 11,
        "1.9948],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6855\"]]");
    p = add_epsg_def_ex (filter, first, last, 6856, "epsg", 6856,
        "NAD83(CORS96) / Oregon Salem zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.33333333333334 +lon_0=-123.0833333");
    add_proj4text (p, 1,
        "333333 +k=1.00001 +x_0=50000 +y_0=0 +ellps=GRS80 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Salem zone (m)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operating_R");
    add_srs_wkt (p, 2,
        "eference_Station_1996\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6783\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",44.3333333333333],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-123.083333333333],PARAMETER[\"scale_factor\",1.00001],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",50000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"6856\"]]");
    p = add_epsg_def_ex (filter, first, last, 6857, "epsg", 6857,
        "NAD83(CORS96) / Oregon Salem zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.33333333333334 +lon_0=-123.0833333");
    add_proj4text (p, 1,
        "333333 +k=1.00001 +x_0=50000.00001504 +y_0=0 +ellps=GRS8");
    add_proj4text (p, 2,
        "0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Salem zone (ft)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operating_");
    add_srs_wkt (p, 2,
        "Reference_Station_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6783\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",44.3333333333333],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",-123.083333333333],PARAMETER[\"scale_factor\",1.00001");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",164041.9948],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"6857\"]]");
    p = add_epsg_def_ex (filter, first, last, 6858, "epsg", 6858,
        "NAD83(2011) / Oregon Salem zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.33333333333334 +lon_0=-123.0833333");
    add_proj4text (p, 1,
        "333333 +k=1.00001 +x_0=50000 +y_0=0 +ellps=GRS80 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Salem zone (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",44");
    add_srs_wkt (p, 8,
        ".3333333333333],PARAMETER[\"central_meridian\",-123.0833");
    add_srs_wkt (p, 9,
        "33333333],PARAMETER[\"scale_factor\",1.00001],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",50000],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"6858\"]]");
    p = add_epsg_def_ex (filter, first, last, 6859, "epsg", 6859,
        "NAD83(2011) / Oregon Salem zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.33333333333334 +lon_0=-123.0833333");
    add_proj4text (p, 1,
        "333333 +k=1.00001 +x_0=50000.00001504 +y_0=0 +ellps=GRS8");
    add_proj4text (p, 2,
        "0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Salem zone (ft)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",44");
    add_srs_wkt (p, 8,
        ".3333333333333],PARAMETER[\"central_meridian\",-123.0833");
    add_srs_wkt (p, 9,
        "33333333],PARAMETER[\"scale_factor\",1.00001],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",164041.9948],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"6859\"]]");
    p = add_epsg_def_ex (filter, first, last, 6860, "epsg", 6860,
        "NAD83(CORS96) / Oregon Santiam Pass zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.08333333333334 +lon_0=-122.5 +k=1.");
    add_proj4text (p, 1,
        "000155 +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Santiam Pass zone (m)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Oper");
    add_srs_wkt (p, 2,
        "ating_Reference_Station_1996\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 3,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6783\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",44.0833333333333],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-122.5],PARAMETER[\"scale_factor\",1.000155],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"6860\"]]");
    p = add_epsg_def_ex (filter, first, last, 6861, "epsg", 6861,
        "NAD83(CORS96) / Oregon Santiam Pass zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.08333333333334 +lon_0=-122.5 +k=1.");
    add_proj4text (p, 1,
        "000155 +x_0=0 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Santiam Pass zone (ft)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Ope");
    add_srs_wkt (p, 2,
        "rating_Reference_Station_1996\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 3,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6783\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",44.0833333333333],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-122.5],PARAMETER[\"scale_factor\",1.000155],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"6861\"]]");
    p = add_epsg_def_ex (filter, first, last, 6862, "epsg", 6862,
        "NAD83(2011) / Oregon Santiam Pass zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.08333333333334 +lon_0=-122.5 +k=1.");
    add_proj4text (p, 1,
        "000155 +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Santiam Pass zone (m)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refe");
    add_srs_wkt (p, 2,
        "rence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",44.0833333333333],PARAMETER[\"central_meridian\",-1");
    add_srs_wkt (p, 9,
        "22.5],PARAMETER[\"scale_factor\",1.000155],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"686");
    add_srs_wkt (p, 13,
        "2\"]]");
    p = add_epsg_def_ex (filter, first, last, 6863, "epsg", 6863,
        "NAD83(2011) / Oregon Santiam Pass zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.08333333333334 +lon_0=-122.5 +k=1.");
    add_proj4text (p, 1,
        "000155 +x_0=0 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Santiam Pass zone (ft)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",44.0833333333333],PARAMETER[\"central_meridian\",-1");
    add_srs_wkt (p, 9,
        "22.5],PARAMETER[\"scale_factor\",1.000155],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "6863\"]]");
    p = add_epsg_def_ex (filter, first, last, 6867, "epsg", 6867,
        "NAD83(CORS96) / Oregon LCC (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43 +lat_2=45.5 +lat_0=41.75 +lon_0=-120");
    add_proj4text (p, 1,
        ".5 +x_0=400000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon LCC (m)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(CORS96)\",DATUM[\"NAD83_Continuously_Operating_Referenc");
    add_srs_wkt (p, 2,
        "e_Station_1996\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6783\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",41.75],PARAMETER[\"central_meridian\",-120.5],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_1\",43],PARAMETER[\"standa");
    add_srs_wkt (p, 10,
        "rd_parallel_2\",45.5],PARAMETER[\"false_easting\",400000");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 13,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"6867\"]]");
    p = add_epsg_def_ex (filter, first, last, 6868, "epsg", 6868,
        "NAD83(CORS96) / Oregon GIC Lambert (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43 +lat_2=45.5 +lat_0=41.75 +lon_0=-120");
    add_proj4text (p, 1,
        ".5 +x_0=399999.9999984 +y_0=0 +ellps=GRS80 +units=ft +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon GIC Lambert (ft)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operating");
    add_srs_wkt (p, 2,
        "_Reference_Station_1996\",SPHEROID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 3,
        "298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6783\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",41.75],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-120.5],PARAMETER[\"standard_parallel_1\",43],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"standard_parallel_2\",45.5],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",1312335.958],PARAMETER[\"false_northing\",0],UNIT[\"f");
    add_srs_wkt (p, 12,
        "oot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 13,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "6868\"]]");
    p = add_epsg_def_ex (filter, first, last, 6870, "epsg", 6870,
        "ETRS89 / Albania TM 2010", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=20 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / Albania TM 2010\",GEOGCS[\"ETRS89\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"European_Terrestrial_Reference_System_1989\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",20],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"6870\"]]");
    p = add_epsg_def_ex (filter, first, last, 6871, "epsg", 6871,
        "WGS 84 / Pseudo-Mercator", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Mercator_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=0 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +uni");
    add_proj4text (p, 1,
        "ts=m +geoidgrids=egm08_25.gtx +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"WGS 84 / Pseudo-Mercator +  EGM2008 geoid hei");
    add_srs_wkt (p, 1,
        "ght\",PROJCS[\"WGS 84 / Pseudo-Mercator\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 2,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Mercator_1SP\"],PARAMETER[\"central_meridian\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 10,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],EXTENSION[\"PROJ4\",\"+proj=merc +a=63");
    add_srs_wkt (p, 12,
        "78137 +b=6378137 +lat_ts=0 +lon_0=0 +x_0=0 +y_0=0 +k=1 +");
    add_srs_wkt (p, 13,
        "units=m +nadgrids=@null +wktext +no_defs\"],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"3857\"]],VERT_CS[\"EGM2008 height\",VERT_DATUM[");
    add_srs_wkt (p, 15,
        "\"EGM2008 geoid\",2005,AUTHORITY[\"EPSG\",\"1027\"]],UNI");
    add_srs_wkt (p, 16,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 17,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"3855\"]],AU");
    add_srs_wkt (p, 18,
        "THORITY[\"EPSG\",\"6871\"]]");
    p = add_epsg_def_ex (filter, first, last, 6875, "epsg", 6875,
        "RDN2008 / Italy zone (N-E)", 0, 1,
        "GRS 1980", "Greenwich",
        "Rete_Dinamica_Nazionale_2008", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9985000000000001 +x_");
    add_proj4text (p, 1,
        "0=7000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RDN2008 / Italy zone (N-E)\",GEOGCS[\"RDN2008\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Rete_Dinamica_Nazionale_2008\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"1132\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"6706\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",12],PARAMETER[\"scale_factor\",0.9985],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",7000000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 11,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"6875\"]]");
    p = add_epsg_def_ex (filter, first, last, 6876, "epsg", 6876,
        "RDN2008 / Zone 12 (N-E)", 0, 1,
        "GRS 1980", "Greenwich",
        "Rete_Dinamica_Nazionale_2008", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=3000000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RDN2008 / Zone 12 (N-E)\",GEOGCS[\"RDN2008\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Rete_Dinamica_Nazionale_2008\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1132\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "6706\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "2],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",3000000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"6876\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 6879, "epsg", 6879,
        "NAD83(2011) / Wisconsin Central", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.5 +lat_2=44.25 +lat_0=43.83333333333");
    add_proj4text (p, 1,
        "334 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Wisconsin Central\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamber");
    add_srs_wkt (p, 7,
        "t_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",43.8333333333333],PARAMETER[\"central_meridian\",-90],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_1\",45.5],PARAMETER[\"stand");
    add_srs_wkt (p, 10,
        "ard_parallel_2\",44.25],PARAMETER[\"false_easting\",6000");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"6879\"]]");
    p = add_epsg_def_ex (filter, first, last, 6880, "epsg", 6880,
        "NAD83(2011) / Nebraska (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +");
    add_proj4text (p, 1,
        "lon_0=-100 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Nebraska (ftUS)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 7,
        "Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "39.8333333333333],PARAMETER[\"central_meridian\",-100],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_1\",43],PARAMETER[\"standar");
    add_srs_wkt (p, 10,
        "d_parallel_2\",40],PARAMETER[\"false_easting\",1640416.6");
    add_srs_wkt (p, 11,
        "667],PARAMETER[\"false_northing\",0],UNIT[\"US survey fo");
    add_srs_wkt (p, 12,
        "ot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXI");
    add_srs_wkt (p, 13,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"6880\"]]");
    p = add_epsg_def_ex (filter, first, last, 6881, "epsg", 6881,
        "Aden 1925", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Aden_1925", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-24,-203,268,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Aden 1925\",DATUM[\"Aden_1925\",SPHEROID[\"Clar");
    add_srs_wkt (p, 1,
        "ke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7012\"]],AUTHORITY[\"EPSG\",\"1135\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 4,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 5,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"6881\"]]");
    p = add_epsg_def_ex (filter, first, last, 6882, "epsg", 6882,
        "Bekaa Valley 1920", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Bekaa_Valley_1920", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-183,-15,273,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Bekaa Valley 1920\",DATUM[\"Bekaa_Valley_1920\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"1137\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"6882\"]]");
    p = add_epsg_def_ex (filter, first, last, 6883, "epsg", 6883,
        "Bioko", 1, 1,
        "International 1924", "Greenwich",
        "Bioko", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-235,-110,393,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Bioko\",DATUM[\"Bioko\",SPHEROID[\"Internationa");
    add_srs_wkt (p, 1,
        "l 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"1136\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 5,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6883\"]]");
    p = add_epsg_def_ex (filter, first, last, 6884, "epsg", 6884,
        "NAD83(CORS96) / Oregon North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46 +lat_2=44.33333333333334 +lat_0=43.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=2500000 +y_0=0 +ellps=G");
    add_proj4text (p, 2,
        "RS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon North\",GEOGCS[\"NAD83(C");
    add_srs_wkt (p, 1,
        "ORS96)\",DATUM[\"NAD83_Continuously_Operating_Reference_");
    add_srs_wkt (p, 2,
        "Station_1996\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "33\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"6783\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",43.6666666666667],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-120.5],PARAMETER[\"standard_parallel_1\",46],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"standard_parallel_2\",44.3333333333333],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",2500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 12,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 13,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"6884\"]]");
    p = add_epsg_def_ex (filter, first, last, 6885, "epsg", 6885,
        "NAD83(CORS96) / Oregon North (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46 +lat_2=44.33333333333334 +lat_0=43.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=2500000.0001424 +y_0=0 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon North (ft)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(CORS96)\",DATUM[\"NAD83_Continuously_Operating_Refer");
    add_srs_wkt (p, 2,
        "ence_Station_1996\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6783\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",43.6666666666667],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",-120.5],PARAMETER[\"standard_parallel_1\",46],PARA");
    add_srs_wkt (p, 10,
        "METER[\"standard_parallel_2\",44.3333333333333],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",8202099.738],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"6885\"]]");
    p = add_epsg_def_ex (filter, first, last, 6886, "epsg", 6886,
        "NAD83(CORS96) / Oregon South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44 +lat_2=42.33333333333334 +lat_0=41.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=1500000 +y_0=0 +ellps=G");
    add_proj4text (p, 2,
        "RS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon South\",GEOGCS[\"NAD83(C");
    add_srs_wkt (p, 1,
        "ORS96)\",DATUM[\"NAD83_Continuously_Operating_Reference_");
    add_srs_wkt (p, 2,
        "Station_1996\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "33\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"6783\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",41.6666666666667],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-120.5],PARAMETER[\"standard_parallel_1\",44],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"standard_parallel_2\",42.3333333333333],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",1500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 12,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 13,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"6886\"]]");
    p = add_epsg_def_ex (filter, first, last, 6887, "epsg", 6887,
        "NAD83(CORS96) / Oregon South (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44 +lat_2=42.33333333333334 +lat_0=41.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=1500000.0001464 +y_0=0 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon South (ft)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(CORS96)\",DATUM[\"NAD83_Continuously_Operating_Refer");
    add_srs_wkt (p, 2,
        "ence_Station_1996\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6783\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",41.6666666666667],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",-120.5],PARAMETER[\"standard_parallel_1\",44],PARA");
    add_srs_wkt (p, 10,
        "METER[\"standard_parallel_2\",42.3333333333333],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",4921259.843],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"6887\"]]");
    p = add_epsg_def_ex (filter, first, last, 6892, "epsg", 6892,
        "South East Island 1943", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "South_East_Island_1943", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-43.685,-179.785,-2");
    add_proj4text (p, 1,
        "67.721,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"South East Island 1943\",DATUM[\"South_East_Isl");
    add_srs_wkt (p, 1,
        "and_1943\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,29");
    add_srs_wkt (p, 2,
        "3.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "1138\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 6,
        "\",EAST],AUTHORITY[\"EPSG\",\"6892\"]]");
    p = add_epsg_def_ex (filter, first, last, 6893, "epsg", 6893,
        "WGS 84 / World Mercator", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Mercator_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=0 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +uni");
    add_proj4text (p, 1,
        "ts=m +geoidgrids=egm08_25.gtx +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"WGS 84 / World Mercator + EGM2008 height\",PR");
    add_srs_wkt (p, 1,
        "OJCS[\"WGS 84 / World Mercator\",GEOGCS[\"WGS 84\",DATUM");
    add_srs_wkt (p, 2,
        "[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Merc");
    add_srs_wkt (p, 7,
        "ator_1SP\"],PARAMETER[\"central_meridian\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",0],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 10,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 11,
        "\",NORTH],AUTHORITY[\"EPSG\",\"3395\"]],VERT_CS[\"EGM200");
    add_srs_wkt (p, 12,
        "8 height\",VERT_DATUM[\"EGM2008 geoid\",2005,AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"1027\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORITY[\"");
    add_srs_wkt (p, 15,
        "EPSG\",\"3855\"]],AUTHORITY[\"EPSG\",\"6893\"]]");
    p = add_epsg_def_ex (filter, first, last, 6894, "epsg", 6894,
        "Gambia", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Gambia", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-63,176,185,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Gambia\",DATUM[\"Gambia\",SPHEROID[\"Clarke 188");
    add_srs_wkt (p, 1,
        "0 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"");
    add_srs_wkt (p, 2,
        "]],AUTHORITY[\"EPSG\",\"1139\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 4,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 5,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"68");
    add_srs_wkt (p, 6,
        "94\"]]");
    p = add_epsg_def_ex (filter, first, last, 6915, "epsg", 6915,
        "South East Island 1943 / UTM zone 40N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "South_East_Island_1943", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=clrk80 +towgs84=-43.685,-179.7");
    add_proj4text (p, 1,
        "85,-267.721,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"South East Island 1943 / UTM zone 40N\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"South East Island 1943\",DATUM[\"South_East_Island_194");
    add_srs_wkt (p, 2,
        "3\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"1138\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6892\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",57],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"6915\"]]");
    p = add_epsg_def_ex (filter, first, last, 6917, "epsg", 6917,
        "SVY21", 1, 1,
        "WGS 84", "Greenwich",
        "SVY21", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SVY21 + SHD height\",GEOGCS[\"SVY21\",DATUM[\"");
    add_srs_wkt (p, 1,
        "SVY21\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6757\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4757\"]],VERT_CS[\"SHD height\",VERT_D");
    add_srs_wkt (p, 7,
        "ATUM[\"Singapore Height Datum\",2005,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 8,
        "\"1140\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 9,
        "],AXIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 10,
        ",\"6916\"]],AUTHORITY[\"EPSG\",\"6917\"]]");
    p = add_epsg_def_ex (filter, first, last, 6922, "epsg", 6922,
        "NAD83 / Kansas LCC", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.5 +lat_2=37.5 +lat_0=36 +lon_0=-98.2");
    add_proj4text (p, 1,
        "5 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Kansas LCC\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PR");
    add_srs_wkt (p, 6,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",36],PARAMETER[\"central_meridian\",-9");
    add_srs_wkt (p, 8,
        "8.25],PARAMETER[\"standard_parallel_1\",39.5],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",37.5],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",400000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6922\"]]");
    p = add_epsg_def_ex (filter, first, last, 6923, "epsg", 6923,
        "NAD83 / Kansas LCC (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.5 +lat_2=37.5 +lat_0=36 +lon_0=-98.2");
    add_proj4text (p, 1,
        "5 +x_0=399999.99998984 +y_0=0 +ellps=GRS80 +towgs84=0,0,");
    add_proj4text (p, 2,
        "0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Kansas LCC (ftUS)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 6,
        "9\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 7,
        "TER[\"latitude_of_origin\",36],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",-98.25],PARAMETER[\"standard_parallel_1\",39.5],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"standard_parallel_2\",37.5],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",1312333.3333],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"6923\"]]");
    p = add_epsg_def_ex (filter, first, last, 6924, "epsg", 6924,
        "NAD83(2011) / Kansas LCC", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.5 +lat_2=37.5 +lat_0=36 +lon_0=-98.2");
    add_proj4text (p, 1,
        "5 +x_0=400000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Kansas LCC\",GEOGCS[\"NAD83(2011)");
    add_srs_wkt (p, 1,
        "\",DATUM[\"NAD83_National_Spatial_Reference_System_2011\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",36],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",-98.25],PARAMETER[\"standard_");
    add_srs_wkt (p, 9,
        "parallel_1\",39.5],PARAMETER[\"standard_parallel_2\",37.");
    add_srs_wkt (p, 10,
        "5],PARAMETER[\"false_easting\",400000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"6924\"]]");
    p = add_epsg_def_ex (filter, first, last, 6925, "epsg", 6925,
        "NAD83(2011) / Kansas LCC (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.5 +lat_2=37.5 +lat_0=36 +lon_0=-98.2");
    add_proj4text (p, 1,
        "5 +x_0=399999.99998984 +y_0=0 +ellps=GRS80 +units=us-ft ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Kansas LCC (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamber");
    add_srs_wkt (p, 7,
        "t_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",36],PARAMETER[\"central_meridian\",-98.25],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_1\",39.5],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 10,
        "l_2\",37.5],PARAMETER[\"false_easting\",1312333.3333],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 12,
        "304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Eas");
    add_srs_wkt (p, 13,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"6925\"]]");
    p = add_epsg_def_ex (filter, first, last, 6927, "epsg", 6927,
        "SVY21 / Singapore TM", 0, 0,
        "WGS 84", "Greenwich",
        "SVY21", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=1.366666666666667 +lon_0=103.83333333");
    add_proj4text (p, 1,
        "33333 +k=1 +x_0=28001.642 +y_0=38744.572 +ellps=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SVY21 / Singapore TM + SHD height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "SVY21 / Singapore TM\",GEOGCS[\"SVY21\",DATUM[\"SVY21\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6757\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4757\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",1.36666666666667]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",103.833333333333],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",2800");
    add_srs_wkt (p, 10,
        "1.642],PARAMETER[\"false_northing\",38744.572],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"3414\"");
    add_srs_wkt (p, 13,
        "]],VERT_CS[\"SHD height\",VERT_DATUM[\"Singapore Height ");
    add_srs_wkt (p, 14,
        "Datum\",2005,AUTHORITY[\"EPSG\",\"1140\"]],UNIT[\"metre\"");
    add_srs_wkt (p, 15,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related ");
    add_srs_wkt (p, 16,
        "height\",UP],AUTHORITY[\"EPSG\",\"6916\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 17,
        "PSG\",\"6927\"]]");
    p = add_epsg_def_ex (filter, first, last, 6931, "epsg", 6931,
        "WGS 84 / NSIDC EASE-Grid 2.0 North", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Azimuthal_Equal_Area", "metre",
        "Easting", "South", "Northing", "South");
    add_proj4text (p, 0,
        "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +datum=WGS84");
    add_proj4text (p, 1,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / NSIDC EASE-Grid 2.0 North\",GEOGCS[\"W");
    add_srs_wkt (p, 1,
        "GS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Lambert_Azimuthal_Equal_Area\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_center\",90],PARAMETER[\"longitude_of_center\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"false_easting\",0],PARAMETER[\"false_nor");
    add_srs_wkt (p, 9,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 10,
        "],AXIS[\"Easting\",SOUTH],AXIS[\"Northing\",SOUTH],AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"6931\"]]");
    p = add_epsg_def_ex (filter, first, last, 6932, "epsg", 6932,
        "WGS 84 / NSIDC EASE-Grid 2.0 South", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Azimuthal_Equal_Area", "metre",
        "Easting", "North", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=laea +lat_0=-90 +lon_0=0 +x_0=0 +y_0=0 +datum=WGS8");
    add_proj4text (p, 1,
        "4 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / NSIDC EASE-Grid 2.0 South\",GEOGCS[\"W");
    add_srs_wkt (p, 1,
        "GS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Lambert_Azimuthal_Equal_Area\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_center\",-90],PARAMETER[\"longitude_of_center\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"false_easting\",0],PARAMETER[\"false_nor");
    add_srs_wkt (p, 9,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 10,
        "],AXIS[\"Easting\",NORTH],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"6932\"]]");
    p = add_epsg_def_ex (filter, first, last, 6933, "epsg", 6933,
        "WGS 84 / NSIDC EASE-Grid 2.0 Global", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Cylindrical_Equal_Area", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cea +lon_0=0 +lat_ts=30 +x_0=0 +y_0=0 +datum=WGS84");
    add_proj4text (p, 1,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / NSIDC EASE-Grid 2.0 Global\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,");
    add_srs_wkt (p, 2,
        "298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PR");
    add_srs_wkt (p, 6,
        "OJECTION[\"Cylindrical_Equal_Area\"],PARAMETER[\"standar");
    add_srs_wkt (p, 7,
        "d_parallel_1\",30],PARAMETER[\"central_meridian\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 9,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 10,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"6933\"]]");
    p = add_epsg_def_ex (filter, first, last, 6956, "epsg", 6956,
        "VN-2000 / TM-3 zone 481 (deprecated)", 0, 0,
        "WGS 84", "Greenwich",
        "Vietnam_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=102 +k=0.9999 +x_0=0 +y_0=50");
    add_proj4text (p, 1,
        "0000 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-1");
    add_proj4text (p, 2,
        "11.45032835,0.00928836,-0.01975479,0.00427372,0.25290627");
    add_proj4text (p, 3,
        "8 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / TM-3 zone 481 (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "VN-2000\",DATUM[\"Vietnam_2000\",SPHEROID[\"WGS 84\",637");
    add_srs_wkt (p, 2,
        "8137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6756\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4756\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",102],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",0],PARAMETER[\"false_northing\",500000],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 11,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6956\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 6957, "epsg", 6957,
        "VN-2000 / TM-3 zone 482 (deprecated)", 0, 0,
        "WGS 84", "Greenwich",
        "Vietnam_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=0.9999 +x_0=0 +y_0=50");
    add_proj4text (p, 1,
        "0000 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-1");
    add_proj4text (p, 2,
        "11.45032835,0.00928836,-0.01975479,0.00427372,0.25290627");
    add_proj4text (p, 3,
        "8 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / TM-3 zone 482 (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "VN-2000\",DATUM[\"Vietnam_2000\",SPHEROID[\"WGS 84\",637");
    add_srs_wkt (p, 2,
        "8137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6756\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4756\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",105],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",0],PARAMETER[\"false_northing\",500000],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 11,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6957\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 6958, "epsg", 6958,
        "VN-2000 / TM-3 zone 491 (deprecated)", 0, 0,
        "WGS 84", "Greenwich",
        "Vietnam_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=108 +k=0.9999 +x_0=0 +y_0=50");
    add_proj4text (p, 1,
        "0000 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-1");
    add_proj4text (p, 2,
        "11.45032835,0.00928836,-0.01975479,0.00427372,0.25290627");
    add_proj4text (p, 3,
        "8 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / TM-3 zone 491 (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "VN-2000\",DATUM[\"Vietnam_2000\",SPHEROID[\"WGS 84\",637");
    add_srs_wkt (p, 2,
        "8137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6756\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4756\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",108],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",0],PARAMETER[\"false_northing\",500000],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 11,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6958\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 6959, "epsg", 6959,
        "VN-2000 / TM-3 Da Nang zone (deprecated)", 0, 0,
        "WGS 84", "Greenwich",
        "Vietnam_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=107.75 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=500000 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279");
    add_proj4text (p, 2,
        ",-111.45032835,0.00928836,-0.01975479,0.00427372,0.25290");
    add_proj4text (p, 3,
        "6278 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / TM-3 Da Nang zone (deprecated)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"VN-2000\",DATUM[\"Vietnam_2000\",SPHEROID[\"WGS 84\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6756\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 6,
        "56\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",10");
    add_srs_wkt (p, 8,
        "7.75],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",0],PARAMETER[\"false_northing\",500000],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "6959\"]]");
    p = add_epsg_def_ex (filter, first, last, 6962, "epsg", 6962,
        "ETRS89 / Albania LCC 2010", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Lambert_Conformal_Conic_2SP", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39 +lat_2=43 +lat_0=41 +lon_0=20 +x_0=0");
    add_proj4text (p, 1,
        " +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / Albania LCC 2010\",GEOGCS[\"ETRS89\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"European_Terrestrial_Reference_System_1989\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4258\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 7,
        "onic_2SP\"],PARAMETER[\"latitude_of_origin\",41],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",20],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 9,
        "l_1\",39],PARAMETER[\"standard_parallel_2\",43],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",0],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"6962\"]]");
    p = add_epsg_def_ex (filter, first, last, 6979, "epsg", 6979,
        "IGD05 (deprecated)", 1, 1,
        "GRS 1980", "Greenwich",
        "Israeli_Geodetic_Datum_2005", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"IGD05\",DATUM[\"Israeli Geodetic Datum 2005\",");
    add_srs_wkt (p, 1,
        "ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUNIT[");
    add_srs_wkt (p, 2,
        "\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree");
    add_srs_wkt (p, 3,
        "\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geodeti");
    add_srs_wkt (p, 4,
        "c latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433]],AXIS[\"geodetic longitude (Lon)\",ea");
    add_srs_wkt (p, 6,
        "st,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],AX");
    add_srs_wkt (p, 7,
        "IS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"m");
    add_srs_wkt (p, 8,
        "etre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Israel - ons");
    add_srs_wkt (p, 9,
        "hore and offshore.\"],BBOX[29.45,32.99,33.53,35.69]],ID[");
    add_srs_wkt (p, 10,
        "\"EPSG\",6979]]");
    p = add_epsg_def_ex (filter, first, last, 6980, "epsg", 6980,
        "IGD05 (deprecated)", 1, 1,
        "GRS 1980", "Greenwich",
        "Israeli_Geodetic_Datum_2005", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGD05 (deprecated)\",DATUM[\"Israeli_Geodetic_D");
    add_srs_wkt (p, 1,
        "atum_2005\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1143\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 6,
        "T],AUTHORITY[\"EPSG\",\"6980\"]]");
    p = add_epsg_def_ex (filter, first, last, 6982, "epsg", 6982,
        "IG05 Intermediate CRS", 1, 1,
        "GRS 1980", "Greenwich",
        "IG05_Intermediate_Datum", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"IG05 Intermediate CRS\",DATUM[\"IG05 Intermedi");
    add_srs_wkt (p, 1,
        "ate Datum\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 2,
        ",LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEU");
    add_srs_wkt (p, 3,
        "NIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],AX");
    add_srs_wkt (p, 4,
        "IS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433]],AXIS[\"geodetic longitud");
    add_srs_wkt (p, 6,
        "e (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 7,
        "5199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LE");
    add_srs_wkt (p, 8,
        "NGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Intermediate stage ");
    add_srs_wkt (p, 9,
        "in transformations - not used otherwise.\"],AREA[\"Israe");
    add_srs_wkt (p, 10,
        "l - onshore; Palestine Territory - onshore.\"],BBOX[29.4");
    add_srs_wkt (p, 11,
        "5,34.17,33.28,35.69]],ID[\"EPSG\",6982]]");
    p = add_epsg_def_ex (filter, first, last, 6983, "epsg", 6983,
        "IG05 Intermediate CRS", 1, 1,
        "GRS 1980", "Greenwich",
        "IG05_Intermediate_Datum", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IG05 Intermediate CRS\",DATUM[\"IG05_Intermedia");
    add_srs_wkt (p, 1,
        "te_Datum\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1142\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 6,
        "T],AUTHORITY[\"EPSG\",\"6983\"]]");
    p = add_epsg_def_ex (filter, first, last, 6984, "epsg", 6984,
        "Israeli Grid 05", 0, 0,
        "GRS 1980", "Greenwich",
        "IG05_Intermediate_Datum", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31.73439361111111 +lon_0=35.204516944");
    add_proj4text (p, 1,
        "44445 +k=1.0000067 +x_0=219529.584 +y_0=626907.39 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Israeli Grid 05\",GEOGCS[\"IG05 Intermediate CR");
    add_srs_wkt (p, 1,
        "S\",DATUM[\"IG05_Intermediate_Datum\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 2,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"1142\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "6983\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",31.7343936111111],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",35.2045169444444],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",1.0000067],PARAMETER[\"false_easting\",219529.584],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",626907.39],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6984\"]]");
    p = add_epsg_def_ex (filter, first, last, 6986, "epsg", 6986,
        "IGD05/12 (deprecated)", 1, 1,
        "GRS 1980", "Greenwich",
        "Israeli_Geodetic_Datum_2005_2012", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"IGD05/12\",DATUM[\"Israeli Geodetic Datum 2005");
    add_srs_wkt (p, 1,
        "(2012)\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LE");
    add_srs_wkt (p, 2,
        "NGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT");
    add_srs_wkt (p, 3,
        "[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[");
    add_srs_wkt (p, 4,
        "\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433]],AXIS[\"geodetic longitude (");
    add_srs_wkt (p, 6,
        "Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 7,
        "9433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGT");
    add_srs_wkt (p, 8,
        "HUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Isr");
    add_srs_wkt (p, 9,
        "ael - onshore and offshore.\"],BBOX[29.45,32.99,33.53,35");
    add_srs_wkt (p, 10,
        ".69]],ID[\"EPSG\",6986]]");
    p = add_epsg_def_ex (filter, first, last, 6987, "epsg", 6987,
        "IGD05/12 (deprecated)", 1, 1,
        "GRS 1980", "Greenwich",
        "Israeli_Geodetic_Datum_2005_2012", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGD05/12 (deprecated)\",DATUM[\"Israeli_Geodeti");
    add_srs_wkt (p, 1,
        "c_Datum_2005_2012\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 2,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1145\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"6987\"]]");
    p = add_epsg_def_ex (filter, first, last, 6989, "epsg", 6989,
        "IG05/12 Intermediate CRS", 1, 1,
        "GRS 1980", "Greenwich",
        "IG05_12_Intermediate_Datum", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=-23.772,-17.49,-17.8");
    add_proj4text (p, 1,
        "59,0.3132,1.85274,-1.67299,5.4262 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"IG05/12 Intermediate CRS\",DATUM[\"IG05/12 Int");
    add_srs_wkt (p, 1,
        "ermediate Datum\",ELLIPSOID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 2,
        "222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 3,
        "ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal");
    add_srs_wkt (p, 4,
        ",3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGL");
    add_srs_wkt (p, 5,
        "EUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic lo");
    add_srs_wkt (p, 6,
        "ngitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017");
    add_srs_wkt (p, 7,
        "4532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER");
    add_srs_wkt (p, 8,
        "[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Intermediate ");
    add_srs_wkt (p, 9,
        "stage in transformations - not used otherwise.\"],AREA[\"");
    add_srs_wkt (p, 10,
        "Israel - onshore; Palestine Territory - onshore.\"],BBOX");
    add_srs_wkt (p, 11,
        "[29.45,34.17,33.28,35.69]],ID[\"EPSG\",6989]]");
    p = add_epsg_def_ex (filter, first, last, 6990, "epsg", 6990,
        "IG05/12 Intermediate CRS", 1, 1,
        "GRS 1980", "Greenwich",
        "IG05_12_Intermediate_Datum", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IG05/12 Intermediate CRS\",DATUM[\"IG05_12_Inte");
    add_srs_wkt (p, 1,
        "rmediate_Datum\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "1144\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 6,
        "\",EAST],AUTHORITY[\"EPSG\",\"6990\"]]");
    p = add_epsg_def_ex (filter, first, last, 6991, "epsg", 6991,
        "Israeli Grid 05/12", 0, 0,
        "GRS 1980", "Greenwich",
        "IG05_12_Intermediate_Datum", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31.73439361111111 +lon_0=35.204516944");
    add_proj4text (p, 1,
        "44445 +k=1.0000067 +x_0=219529.584 +y_0=626907.39 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Israeli Grid 05/12\",GEOGCS[\"IG05/12 Intermedi");
    add_srs_wkt (p, 1,
        "ate CRS\",DATUM[\"IG05_12_Intermediate_Datum\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"1144\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"6990\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",31.7343936111111],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",35.2045169444444],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",1.0000067],PARAMETER[\"false_easting\",2195");
    add_srs_wkt (p, 10,
        "29.584],PARAMETER[\"false_northing\",626907.39],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6991");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 6996, "epsg", 6996,
        "NAD83(2011) / San Francisco CS13 (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.75 +lon_0=-122.45 +k=1.000007 +x_0");
    add_proj4text (p, 1,
        "=48000 +y_0=24000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / San Francisco CS13 (deprecated)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_R");
    add_srs_wkt (p, 2,
        "eference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 3,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",37.75],PARAMETER[\"central_meridian\",-122.45],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"scale_factor\",1.000007E-06],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",48000],PARAMETER[\"false_northing\",24000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"6996\"]]");
    p = add_epsg_def_ex (filter, first, last, 6997, "epsg", 6997,
        "NAD83(2011) / San Francisco CS13 (ftUS) (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.75 +lon_0=-122.45 +k=1.000007 +x_0");
    add_proj4text (p, 1,
        "=48000 +y_0=24000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / San Francisco CS13 (ftUS) (deprec");
    add_srs_wkt (p, 1,
        "ated)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Sp");
    add_srs_wkt (p, 2,
        "atial_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 3,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",37.75],PARAMETER[\"central_meridian\",-122");
    add_srs_wkt (p, 9,
        ".45],PARAMETER[\"scale_factor\",1.000007E-06],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",157480],PARAMETER[\"false_northing\",7");
    add_srs_wkt (p, 11,
        "8740],UNIT[\"US survey foot\",0.304800609601219,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 13,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"6997\"]]");
    p = add_epsg_def_ex (filter, first, last, 7005, "epsg", 7005,
        "Nahrwan 1934 / UTM zone 37N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nahrwan_1934", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=clrk80 +towgs84=-242.2,-144.9,");
    add_proj4text (p, 1,
        "370.3,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nahrwan 1934 / UTM zone 37N\",GEOGCS[\"Nahrwan ");
    add_srs_wkt (p, 1,
        "1934\",DATUM[\"Nahrwan_1934\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6744\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4744\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 12,
        "5\"]]");
    p = add_epsg_def_ex (filter, first, last, 7006, "epsg", 7006,
        "Nahrwan 1934 / UTM zone 38N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nahrwan_1934", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=clrk80 +towgs84=-242.2,-144.9,");
    add_proj4text (p, 1,
        "370.3,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nahrwan 1934 / UTM zone 38N\",GEOGCS[\"Nahrwan ");
    add_srs_wkt (p, 1,
        "1934\",DATUM[\"Nahrwan_1934\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6744\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4744\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",4");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 12,
        "6\"]]");
    p = add_epsg_def_ex (filter, first, last, 7007, "epsg", 7007,
        "Nahrwan 1934 / UTM zone 39N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nahrwan_1934", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=clrk80 +towgs84=-242.2,-144.9,");
    add_proj4text (p, 1,
        "370.3,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nahrwan 1934 / UTM zone 39N\",GEOGCS[\"Nahrwan ");
    add_srs_wkt (p, 1,
        "1934\",DATUM[\"Nahrwan_1934\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6744\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4744\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 12,
        "7\"]]");
    p = add_epsg_def_ex (filter, first, last, 7034, "epsg", 7034,
        "RGSPM06 (lon-lat)", 1, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_Saint_Pierre_et_Miquelon_2006", "none", "degree",
        "Geodetic longitude", "East", "Geodetic latitude", "North");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RGSPM06 (lon-lat)\",DATUM[\"Reseau Geodesique ");
    add_srs_wkt (p, 1,
        "de Saint Pierre et Miquelon 2006\",ELLIPSOID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[");
    add_srs_wkt (p, 3,
        "\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]");
    add_srs_wkt (p, 4,
        "],CS[ellipsoidal,3],AXIS[\"geodetic longitude (Lon)\",ea");
    add_srs_wkt (p, 5,
        "st,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AX");
    add_srs_wkt (p, 6,
        "IS[\"geodetic latitude (Lat)\",north,ORDER[2],ANGLEUNIT[");
    add_srs_wkt (p, 7,
        "\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal heigh");
    add_srs_wkt (p, 8,
        "t (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE");
    add_srs_wkt (p, 9,
        "[\"GIS.\"],AREA[\"St Pierre and Miquelon - onshore and o");
    add_srs_wkt (p, 10,
        "ffshore.\"],BBOX[43.41,-57.1,47.37,-55.9]],ID[\"EPSG\",7");
    add_srs_wkt (p, 11,
        "034]]");
    p = add_epsg_def_ex (filter, first, last, 7035, "epsg", 7035,
        "RGSPM06 (lon-lat)", 1, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_Saint_Pierre_et_Miquelon_2006", "none", "degree",
        "Geodetic longitude", "East", "Geodetic latitude", "North");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGSPM06 (lon-lat)\",DATUM[\"Reseau_Geodesique_d");
    add_srs_wkt (p, 1,
        "e_Saint_Pierre_et_Miquelon_2006\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1038\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AUTHORITY[\"EPSG\",\"7035\"]]");
    p = add_epsg_def_ex (filter, first, last, 7036, "epsg", 7036,
        "RGR92 (lon-lat)", 1, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_la_Reunion_1992", "none", "degree",
        "Geodetic longitude", "East", "Geodetic latitude", "North");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RGR92 (lon-lat)\",DATUM[\"Reseau Geodesique de");
    add_srs_wkt (p, 1,
        " la Reunion 1992\",ELLIPSOID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 2,
        "7222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 3,
        ",ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoida");
    add_srs_wkt (p, 4,
        "l,3],AXIS[\"geodetic longitude (Lon)\",east,ORDER[1],ANG");
    add_srs_wkt (p, 5,
        "LEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic l");
    add_srs_wkt (p, 6,
        "atitude (Lat)\",north,ORDER[2],ANGLEUNIT[\"degree\",0.01");
    add_srs_wkt (p, 7,
        "74532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDE");
    add_srs_wkt (p, 8,
        "R[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"GIS.\"],AREA");
    add_srs_wkt (p, 9,
        "[\"Reunion - onshore and offshore.\"],BBOX[-24.72,51.83,");
    add_srs_wkt (p, 10,
        "-18.28,58.24]],ID[\"EPSG\",7036]]");
}

#endif /* full EPSG initialization enabled/disabled */

