# Configuration

_Supysonic_ looks for four files for its configuration: `/etc/supysonic`,
`~/.supysonic`, `~/.config/supysonic/supysonic.conf` and `supysonic.conf` in
the current folder, merging values from all files.

Configuration files must respect a structure similar to Windows INI file, with
`[section]` headers and using a `KEY = VALUE` or `KEY: VALUE` syntax.

You'll find a roughly documented configuration sample file at the root of the
project, file conveniently named `config.sample`. More details below.

There are six sections in the configuration:
- [base](#base-section): defines the database and additional scanning config
- [webapp](#webapp-section): configuration relative to the HTTP server
- [daemon](#daemon-section): configuration for the scanning file watcher
- [lastfm](#lastfm-section): keys to enable Last.FM scrobbling
- [transcoding](#transcoding-section): defines transcoding  programs
- [mimetypes](#mimetypes-section): some file extension to mimetype mappings

## `[base]` section

`database_uri`: the most important configuration, defines the type and
parameters of the database _Supysonic_ should connect to. It usually includes
username, password, hostname and database name. The typical form of a database
URI is:

    driver://username:password@host:port/database

If the connection needs some additional parameters, they can be provided as a
query string, such as:

    driver://username:password@host:port/database?param1=value1&param2=value2

Supported drivers are `sqlite`, `mysql` and `postgres` (or `postgresql`).

As SQLite connects to local files, the format is slightly different. The "file"
portion of the URI is the filename of the database. For a relative path, it
requires three slashes, for absolute paths it's also three slashes followed by
the absolute path, meaning actually four slashes on Unix systems.

```ini
; Relative path
database_uri = sqlite:///relative-file.db
; Absolute path on Unix-based systems
database_uri = sqlite:////home/user/supysonic.db
; Absolute path on Windows
database_uri = sqlite:///C:\Users\user\supysonic.db
```

A MySQL-compatible database requires either `MySQLdb` or `pymysql` to be
installed. PostgreSQL needs `psycopg2`.
Note that for MySQL if no character set is defined on the URI it defaults to
`utf8mb4` regardless of what's set on your MySQL installation.

If `database_uri` isn't provided, it defaults to a SQLite database stored in
`/tmp/supysonic/supysonic.db`.

`scanner_extensions`: A space separated list of file extensions the scanner is
restricted to. Useful if you have multiple audio formats in your library but
only want to serve some. If left empty, the scanner will try to read every file
it finds.

`follow_symlinks`: if set to `yes`, allows the scanner to follow symbolic links.
Disabled by default, enable it only if you trust your file system as nothing is
done to handle broken links or loops.

```ini
[base]
; A database URI. See the 'schema' folder for schema creation scripts
; Default: sqlite:////tmp/supysonic/supysonic.db
database_uri = sqlite:////var/supysonic/supysonic.db
;database_uri = mysql://supysonic:supysonic@localhost/supysonic
;database_uri = postgres://supysonic:supysonic@localhost/supysonic

; Optional, restrict scanner to these extensions. Default: none
scanner_extensions = mp3 ogg

; Should the scanner follow symbolic links? Default: no
follow_symlinks = no
```

## `[webapp]` section

`cache_dir`: directory used to store generated files, such as resized cover
art or transcoded files. Defaults to `/tmp/supysonic`.

`cache_size`: maximum size (in megabytes) of the cache (except for trancodes).
Defaults to 512 MB

`transcode_cache_size`: maximum size (in megabytes) of the transcode cache.
Defaults to 1024 MB (1 GB)

`log_file`: rotating file where some events generated by the web server are
logged. Leave empty to disable logging.

`log_level`: defines the minimum severity threshold of messages to be added to
`log_file`. Possible values are: `DEBUG`, `INFO`, `WARNING`, `ERROR` and
`CRITICAL`. Defaults to `WARNING`.

`mount_api`: [`on`/`off`] enable or disable the Subsonic REST API. Should be
kept on or _Supysonic_ would be quite useless. Exists mostly for testing
purposes. Defaults to `on`.

`mount_webui`: [`on`/`off`] enable or disable the administrative web interface.
Note that setting this off will prevent users from defining a preferred
transcoding format. Defaults to `on`.

`index_ignored_prefixes`: space separated list of prefixes that should be
ignored from artist names when returning their index. Example: if the word _The_
is in this list, artist _The Rolling Stones_ will be listed under the letter _R_.
The match is case insensitive.
Defaults to `El La Le Las Les Los The`.

```ini
[webapp]
; Optional cache directory. Default: /tmp/supysonic
cache_dir = /var/supysonic/cache

; Main cache max size in MB. Default: 512
cache_size = 512

; Transcode cache max size in MB. Default: 1024 (1GB)
transcode_cache_size = 1024

; Optional rotating log file. Default: none
log_file = /var/supysonic/supysonic.log

; Log level. Possible values: DEBUG, INFO, WARNING, ERROR, CRITICAL.
; Default: WARNING
log_level = WARNING

; Enable the Subsonic REST API. You'll most likely want to keep this on.
; Here for testing purposes. Default: on
;mount_api = on

; Enable the administrative web interface. Default: on
;mount_webui = on

; Space separated list of prefixes that should be ignored on index endpoints
; Default: El La Le Las Les Los The
index_ignored_prefixes = El La Le Las Les Los The
```

## `[daemon]` section

`socket`: Unix domain socket file (or named pipe on Windows) used to communicate
between the daemon and clients that rely on it (eg. CLI, folder admin web page,
etc.). Note that using an IP address here isn't supported.
Default: /tmp/supysonic/supysonic.sock

`run_watcher`: whether or not to start the watcher that will listen for library
changes. Default: yes

`wait_delay`: delay (in seconds) before triggering the scanning operation after
a change have been detected. This prevents running too many scans when multiple
changes are detected for a single file over a short time span.
Default: 5 seconds.

`jukebox_command` : command used by the jukebox mode to play a single file.
See the [jukebox documentation](jukebox.md) for more details.

`log_file`: rotating file where events generated by the file watcher are logged.
If left empty, any logging will be sent to stderr.

`log_level`: defines the minimum severity threshold of messages to be added to
`log_file`. Possible values are: `DEBUG`, `INFO`, `WARNING`, `ERROR` and
`CRITICAL`. Defaults to `WARNING`.

```ini
[daemon]
; Socket file the daemon will listen on for incoming management commands
; Default: /tmp/supysonic/supysonic.sock
socket = /var/run/supysonic.sock

; Defines if the file watcher should be started. Default: yes
run_watcher = yes

; Delay in seconds before triggering scanning operation after a change have been
; detected.
; This prevents running too many scans when multiple changes are detected for a
; single file over a short time span. Default: 5
wait_delay = 5

; Command used by the jukebox
jukebox_command = mplayer -ss %offset %path

; Optional rotating log file for the scanner daemon. Logs to stderr if empty
log_file = /var/supysonic/supysonic-daemon.log
log_level = INFO
```

## `[lastfm]` section

This section allow defining API keys to enable Last.FM integration in
_Supysonic_. Currently it is only used to _scrobble_ played tracks and update
the _now playing_ information.
See https://www.last.fm/api to obtain such keys.
Once keys are set, users have to link their account by visiting their profile
page on _Supysonic_'s administrative UI.

`api_key`: Last.FM API key

`secret`: secret key associated to the API key

```ini
[lastfm]
; API and secret key to enable scrobbling. http://www.last.fm/api/accounts
; Defaults: none
;api_key =
;secret =
```

## `[transcoding]` section

This section defines command-line programs to be used to convert an audio file
to another format or change its bitrate. All configurations in the sample below
have **not** been thoroughly tested.
For more details, please refer to the
[transcoding configuration](transcoding.md).

```ini
[transcoding]
; Programs used to convert from one format/bitrate to another. Defaults: none
transcoder_mp3_mp3 = lame --quiet --mp3input -b %outrate %srcpath -
transcoder = ffmpeg -i %srcpath -ab %outratek -v 0 -f %outfmt -
decoder_mp3 = mpg123 --quiet -w - %srcpath
decoder_ogg = oggdec -o %srcpath
decoder_flac = flac -d -c -s %srcpath
encoder_mp3 = lame --quiet -b %outrate - -
encoder_ogg = oggenc2 -q -M %outrate -
```

## `[mimetypes]` section

Use this section if the system _Supysonic_ is installed on has trouble guessing
the mimetype of some files. This might only be useful in some rare cases.

See the following links for a list of examples:
* https://en.wikipedia.org/wiki/Media_type#Common_examples
* https://www.iana.org/assignments/media-types/media-types.xhtml

```ini
[mimetypes]
; Extension to mimetype mappings in case your system has some trouble guessing
; Default: none
;mp3 = audio/mpeg
;ogg = audio/vorbis
```

