//#include <stdio.h>
#include "systemc.h"

SC_MODULE(isq)
{
        sc_in<bool> RSTN;
        sc_in_clk   CLK;

        sc_out<bool> DIN_rdy;
        sc_in<bool> DIN_vld;
        sc_in<sc_uint<18> > DIN_value;
        sc_in<bool> DOUT_rdy;
        sc_out<bool> DOUT_vld;
        sc_out<sc_uint<10> > DOUT_value;

	void thread();
	sc_uint<10> isqrt5(sc_uint<18>);

	SC_CTOR(isq){
		SC_CTHREAD(thread, CLK.pos());
		reset_signal_is(RSTN,false);
	}
};

void
isq::thread()
{
        if( !RSTN){
                DIN_rdy = 1;
                DOUT_vld = 0;
                wait(1);
        }

	for(;;){
		sc_uint<18> in_value;
		sc_uint<10> out_value;

		in_value = DIN_value.read();
		while( !DIN_vld.read()){
			wait(1);
			in_value = DIN_value.read();
		}
		DIN_rdy = 0;
		wait(1);

		out_value = isqrt5(in_value);

		while( !DOUT_rdy.read()){
			wait(1);
		}
		DOUT_vld = 1;
		DOUT_value.write(out_value);
		DIN_rdy = 1;
		wait(1);
		DOUT_vld = 0;
	}
}


sc_uint<10>
isq::isqrt5(sc_uint<18> x) {
   sc_uint<18> m, y, b;
   sc_int<18> t;

   y = 0;
   for( m = 0x10000; m != 0; m >>= 2){
      b = y | m;
      y = y >> 1;
      t = (sc_int<18>)(x | ~(x - b)) >> 16;
      x = x - (b & t);
      y = y | (m & t);
   }
   return y;
}

struct stimuli {
	unsigned it;
	unsigned is;
} S[] = {
{1,1}, {332,18}, {663,25}, {994,31}, {1325,36}, {1656,40}, {1987,44}, {2318,48},
{2649,51}, {2980,54}, {3311,57}, {3642,60}, {3973,63}, {4304,65}, {4635,68}, {4966,70},
{5297,72}, {5628,75}, {5959,77}, {6290,79}, {6621,81}, {6952,83}, {7283,85}, {7614,87},
{7945,89}, {8276,90}, {8607,92}, {8938,94}, {9269,96}, {9600,97}, {9931,99}, {10262,101},
{10593,102}, {10924,104}, {11255,106}, {11586,107}, {11917,109}, {12248,110}, {12579,112},
{12910,113}, {13241,115}, {13572,116}, {13903,117}, {14234,119}, {14565,120}, {14896,122},
{15227,123}, {15558,124}, {15889,126}, {16220,127}, {16551,128}, {16882,129}, {17213,131},
{17544,132}, {17875,133}, {18206,134}, {18537,136}, {18868,137}, {19199,138}, {19530,139},
{19861,140}, {20192,142}, {20523,143}, {20854,144}, {21185,145}, {21516,146}, {21847,147},
{22178,148}, {22509,150}, {22840,151}, {23171,152}, {23502,153}, {23833,154}, {24164,155},
{24495,156}, {24826,157}, {25157,158}, {25488,159}, {25819,160}, {26150,161}, {26481,162},
{26812,163}, {27143,164}, {27474,165}, {27805,166}, {28136,167}, {28467,168}, {28798,169},
{29129,170}, {29460,171}, {29791,172}, {30122,173}, {30453,174}, {30784,175}, {31115,176},
{31446,177}, {31777,178}, {32108,179}, {32439,180}, {32770,181}, {33101,181}, {33432,182},
{33763,183}, {34094,184}, {34425,185}, {34756,186}, {35087,187}, {35418,188}, {35749,189},
{36080,189}, {36411,190}, {36742,191}, {37073,192}, {37404,193}, {37735,194}, {38066,195},
{38397,195}, {38728,196}, {39059,197}, {39390,198}, {39721,199}, {40052,200}, {40383,200},
{40714,201}, {41045,202}, {41376,203}, {41707,204}, {42038,205}, {42369,205}, {42700,206},
{43031,207}, {43362,208}, {43693,209}, {44024,209}, {44355,210}, {44686,211}, {45017,212},
{45348,212}, {45679,213}, {46010,214}, {46341,215}, {46672,216}, {47003,216}, {47334,217},
{47665,218}, {47996,219}, {48327,219}, {48658,220}, {48989,221}, {49320,222}, {49651,222},
{49982,223}, {50313,224}, {50644,225}, {50975,225}, {51306,226}, {51637,227}, {51968,227},
{52299,228}, {52630,229}, {52961,230}, {53292,230}, {53623,231}, {53954,232}, {54285,232},
{54616,233}, {54947,234}, {55278,235}, {55609,235}, {55940,236}, {56271,237}, {56602,237},
{56933,238}, {57264,239}, {57595,239}, {57926,240}, {58257,241}, {58588,242}, {58919,242},
{59250,243}, {59581,244}, {59912,244}, {60243,245}, {60574,246}, {60905,246}, {61236,247},
{61567,248}, {61898,248}, {62229,249}, {62560,250}, {62891,250}, {63222,251}, {63553,252},
{63884,252}, {64215,253}, {64546,254}, {64877,254}, {65208,255}, {65539,256}, {65870,256},
{66201,257}, {66532,257}, {66863,258}, {67194,259}, {67525,259}, {67856,260}, {68187,261},
{68518,261}, {68849,262}, {69180,263}, {69511,263}, {69842,264}, {70173,264}, {70504,265},
{70835,266}, {71166,266}, {71497,267}, {71828,268}, {72159,268}, {72490,269}, {72821,269},
{73152,270}, {73483,271}, {73814,271}, {74145,272}, {74476,272}, {74807,273}, {75138,274},
{75469,274}, {75800,275}, {76131,275}, {76462,276}, {76793,277}, {77124,277}, {77455,278},
{77786,278}, {78117,279}, {78448,280}, {78779,280}, {79110,281}, {79441,281}, {79772,282},
{80103,283}, {80434,283}, {80765,284}, {81096,284}, {81427,285}, {81758,285}, {82089,286},
{82420,287}, {82751,287}, {83082,288}, {83413,288}, {83744,289}, {84075,289}, {84406,290},
{84737,291}, {85068,291}, {85399,292}, {85730,292}, {86061,293}, {86392,293}, {86723,294},
{87054,295}, {87385,295}, {87716,296}, {88047,296}, {88378,297}, {88709,297}, {89040,298},
{89371,298}, {89702,299}, {90033,300}, {90364,300}, {90695,301}, {91026,301}, {91357,302},
{91688,302}, {92019,303}, {92350,303}, {92681,304}, {93012,304}, {93343,305}, {93674,306},
{94005,306}, {94336,307}, {94667,307}, {94998,308}, {95329,308}, {95660,309}, {95991,309},
{96322,310}, {96653,310}, {96984,311}, {97315,311}, {97646,312}, {97977,313}, {98308,313},
{98639,314}, {98970,314}, {99301,315}, {99632,315}, {99963,316}, {100294,316}, {100625,317},
{100956,317}, {101287,318}, {101618,318}, {101949,319}, {102280,319}, {102611,320}, {102942,320},
{103273,321}, {103604,321}, {103935,322}, {104266,322}, {104597,323}, {104928,323}, {105259,324},
{105590,324}, {105921,325}, {106252,325}, {106583,326}, {106914,326}, {107245,327}, {107576,327},
{107907,328}, {108238,328}, {108569,329}, {108900,330}, {109231,330}, {109562,331}, {109893,331},
{110224,332}, {110555,332}, {110886,332}, {111217,333}, {111548,333}, {111879,334}, {112210,334},
{112541,335}, {112872,335}, {113203,336}, {113534,336}, {113865,337}, {114196,337}, {114527,338},
{114858,338}, {115189,339}, {115520,339}, {115851,340}, {116182,340}, {116513,341}, {116844,341},
{117175,342}, {117506,342}, {117837,343}, {118168,343}, {118499,344}, {118830,344}, {119161,345},
{119492,345}, {119823,346}, {120154,346}, {120485,347}, {120816,347}, {121147,348}, {121478,348},
{121809,349}, {122140,349}, {122471,349}, {122802,350}, {123133,350}, {123464,351}, {123795,351},
{124126,352}, {124457,352}, {124788,353}, {125119,353}, {125450,354}, {125781,354}, {126112,355},
{126443,355}, {126774,356}, {127105,356}, {127436,356}, {127767,357}, {128098,357}, {128429,358},
{128760,358}, {129091,359}, {129422,359}, {129753,360}, {130084,360}, {130415,361}, {130746,361},
{131077,362}, {131408,362}, {131739,362}, {132070,363}, {132401,363}, {132732,364}, {133063,364},
{133394,365}, {133725,365}, {134056,366}, {134387,366}, {134718,367}, {135049,367}, {135380,367},
{135711,368}, {136042,368}, {136373,369}, {136704,369}, {137035,370}, {137366,370}, {137697,371},
{138028,371}, {138359,371}, {138690,372}, {139021,372}, {139352,373}, {139683,373}, {140014,374},
{140345,374}, {140676,375}, {141007,375}, {141338,375}, {141669,376}, {142000,376}, {142331,377},
{142662,377}, {142993,378}, {143324,378}, {143655,379}, {143986,379}, {144317,379}, {144648,380},
{144979,380}, {145310,381}, {145641,381}, {145972,382}, {146303,382}, {146634,382}, {146965,383},
{147296,383}, {147627,384}, {147958,384}, {148289,385}, {148620,385}, {148951,385}, {149282,386},
{149613,386}, {149944,387}, {150275,387}, {150606,388}, {150937,388}, {151268,388}, {151599,389},
{151930,389}, {152261,390}, {152592,390}, {152923,391}, {153254,391}, {153585,391}, {153916,392},
{154247,392}, {154578,393}, {154909,393}, {155240,394}, {155571,394}, {155902,394}, {156233,395},
{156564,395}, {156895,396}, {157226,396}, {157557,396}, {157888,397}, {158219,397}, {158550,398},
{158881,398}, {159212,399}, {159543,399}, {159874,399}, {160205,400}, {160536,400}, {160867,401},
{161198,401}, {161529,401}, {161860,402}, {162191,402}, {162522,403}, {162853,403}, {163184,403},
{163515,404}, {163846,404}, {164177,405}, {164508,405}, {164839,406}, {165170,406}, {165501,406},
{165832,407}, {166163,407}, {166494,408}, {166825,408}, {167156,408}, {167487,409}, {167818,409},
{168149,410}, {168480,410}, {168811,410}, {169142,411}, {169473,411}, {169804,412}, {170135,412},
{170466,412}, {170797,413}, {171128,413}, {171459,414}, {171790,414}, {172121,414}, {172452,415},
{172783,415}, {173114,416}, {173445,416}, {173776,416}, {174107,417}, {174438,417}, {174769,418},
{175100,418}, {175431,418}, {175762,419}, {176093,419}, {176424,420}, {176755,420}, {177086,420},
{177417,421}, {177748,421}, {178079,421}, {178410,422}, {178741,422}, {179072,423}, {179403,423},
{179734,423}, {180065,424}, {180396,424}, {180727,425}, {181058,425}, {181389,425}, {181720,426},
{182051,426}, {182382,427}, {182713,427}, {183044,427}, {183375,428}, {183706,428}, {184037,428},
{184368,429}, {184699,429}, {185030,430}, {185361,430}, {185692,430}, {186023,431}, {186354,431},
{186685,432}, {187016,432}, {187347,432}, {187678,433}, {188009,433}, {188340,433}, {188671,434},
{189002,434}, {189333,435}, {189664,435}, {189995,435}, {190326,436}, {190657,436}, {190988,437},
{191319,437}, {191650,437}, {191981,438}, {192312,438}, {192643,438}, {192974,439}, {193305,439},
{193636,440}, {193967,440}, {194298,440}, {194629,441}, {194960,441}, {195291,441}, {195622,442},
{195953,442}, {196284,443}, {196615,443}, {196946,443}, {197277,444}, {197608,444}, {197939,444},
{198270,445}, {198601,445}, {198932,446}, {199263,446}, {199594,446}, {199925,447}, {200256,447},
{200587,447}, {200918,448}, {201249,448}, {201580,448}, {201911,449}, {202242,449}, {202573,450},
{202904,450}, {203235,450}, {203566,451}, {203897,451}, {204228,451}, {204559,452}, {204890,452},
{205221,453}, {205552,453}, {205883,453}, {206214,454}, {206545,454}, {206876,454}, {207207,455},
{207538,455}, {207869,455}, {208200,456}, {208531,456}, {208862,457}, {209193,457}, {209524,457},
{209855,458}, {210186,458}, {210517,458}, {210848,459}, {211179,459}, {211510,459}, {211841,460},
{212172,460}, {212503,460}, {212834,461}, {213165,461}, {213496,462}, {213827,462}, {214158,462},
{214489,463}, {214820,463}, {215151,463}, {215482,464}, {215813,464}, {216144,464}, {216475,465},
{216806,465}, {217137,465}, {217468,466}, {217799,466}, {218130,467}, {218461,467}, {218792,467},
{219123,468}, {219454,468}, {219785,468}, {220116,469}, {220447,469}, {220778,469}, {221109,470},
{221440,470}, {221771,470}, {222102,471}, {222433,471}, {222764,471}, {223095,472}, {223426,472},
{223757,473}, {224088,473}, {224419,473}, {224750,474}, {225081,474}, {225412,474}, {225743,475},
{226074,475}, {226405,475}, {226736,476}, {227067,476}, {227398,476}, {227729,477}, {228060,477},
{228391,477}, {228722,478}, {229053,478}, {229384,478}, {229715,479}, {230046,479}, {230377,479},
{230708,480}, {231039,480}, {231370,481}, {231701,481}, {232032,481}, {232363,482}, {232694,482},
{233025,482}, {233356,483}, {233687,483}, {234018,483}, {234349,484}, {234680,484}, {235011,484},
{235342,485}, {235673,485}, {236004,485}, {236335,486}, {236666,486}, {236997,486}, {237328,487},
{237659,487}, {237990,487}, {238321,488}, {238652,488}, {238983,488}, {239314,489}, {239645,489},
{239976,489}, {240307,490}, {240638,490}, {240969,490}, {241300,491}, {241631,491}, {241962,491},
{242293,492}, {242624,492}, {242955,492}, {243286,493}, {243617,493}, {243948,493}, {244279,494},
{244610,494}, {244941,494}, {245272,495}, {245603,495}, {245934,495}, {246265,496}, {246596,496},
{246927,496}, {247258,497}, {247589,497}, {247920,497}, {248251,498}, {248582,498}, {248913,498},
{249244,499}, {249575,499}, {249906,499}, {250237,500}, {250568,500}, {250899,500}, {251230,501},
{251561,501}, {251892,501}, {252223,502}, {252554,502}, {252885,502}, {253216,503}, {253547,503},
{253878,503}, {254209,504}, {254540,504}, {254871,504}, {255202,505}, {255533,505}, {255864,505},
{256195,506}, {256526,506}, {256857,506}, {257188,507}, {257519,507}, {257850,507}, {258181,508},
{258512,508}, {258843,508}, {259174,509}, {259505,509}, {259836,509}
};

int
sc_main(int argc, char *argv[])
{
       sc_clock clk;
        sc_signal<bool> reset;
        sc_signal<bool> in_rdy;
        sc_signal<bool> in_vld;
        sc_signal<bool> out_vld;
        sc_signal<bool> out_rdy;
	sc_signal<sc_uint<18> > it;
	sc_signal<sc_uint<10> > is;
	int errors;
	isq *isqp;

	isqp = new isq("isq0");
	(*isqp)(reset, clk,
		in_rdy, in_vld, it,
		out_rdy, out_vld, is);

	reset = 0;
	sc_start(2, SC_NS);
	reset = 1;
	sc_start(2, SC_NS);
	out_rdy = 1;

	sc_start(1, SC_NS);
	errors = 0;
	for(int i = 0; i < sizeof S/sizeof(struct stimuli); i++){
		while( !in_rdy)
			sc_start(1, SC_NS);

		in_vld = 1;
		it.write(S[i].it);
		do { sc_start(1, SC_NS); in_vld = 0; } while(!out_vld);

		if( is.read() != S[i].is){
			printf("error it:%d expected is:%d received is:%d\n",
				(int)S[i].it, (int)S[i].is,
			        (int)is.read());
			errors++;
		}
	}

	if( errors)
		cout << "Program completed with " << errors << " errors" << endl;
	else
		cout << "Program completed." << endl;

	return(0);

}



