#!/usr/bin/perl -w

use strict;
use IO::Socket;
use IO::Select;
use IO::Handle;

sub showsock($$)
{
    my ($s,$flg) = @_;
    my $res = '';

    if($flg & 1)
    {
	$res .=  $s->sockhost . ',' . $s->sockport;
    }
    if($flg == 3)
    {
	$res .= " to ";
    }
    if($flg & 2)
    {
	$res .= $s->peerhost . ',' . $s->peerport;
    }
    $res;
}

my ($lsn, $flag, $fh, $buf, $sel, @ready);

$SIG{INT} = sub {print "Close on SIGINT\n"; $lsn->close(); exit()};

sub cleansock($)
{
    my $fh = $_[0];
    $sel->remove($fh);
    $fh->close();
}

my $port = shift || 'iodemo';

$lsn = new IO::Socket::INET(Listen => 1,
			    LocalPort => $port,
			    Proto => 'tcp',
			    Reuse => 1,
			    Type => SOCK_STREAM) or die "bind $!";

$sel = new IO::Select or die "select $!";

$sel->add($lsn);

print "Listening on ", showsock ($lsn, 1),"\n";

while(@ready = $sel->can_read) 
{
    foreach $fh (@ready) 
    {
	if($fh == $lsn)
	{
	    my $ns = $fh->accept;
	    $sel->add($ns);
	    print "\nConnect ", showsock ($ns, 3), "\n";
	}
	else
	{
	    if($fh->recv($buf, 256, 0), $buf)
	    {
	      print "From ", showsock ($fh, 2), " : ", $buf;
	      $fh->send((length($buf)-1)." :> ".$buf, 0);
	    }
	    else
	    {
		print "Close by ", showsock ($fh, 2), "\n";		
		cleansock($fh);
	    }
	}
    }
}


