
# Remote Zabbix server health

## Overview

This template is designed to monitor internal Zabbix metrics on the remote Zabbix server.

## Requirements

For Zabbix version: 6.0 and higher.

## Setup

Specify the address of the remote Zabbix server by changing `{$ADDRESS}` and `{$PORT}` macros. Don't forget to adjust the `StatsAllowedIP` parameter in the remote server's configuration file to allow the collection of statistics.

## Configuration

No specific Zabbix configuration is required.

### Macros used

|Name|Description|Default|
|----|-----------|-------|
|{$ADDRESS} |<p>-</p> |`` |
|{$PORT} |<p>-</p> |`` |

### Template links

There are no template links in this template.

### Discovery rules

|Name|Description|Type|Key and additional info|
|----|-----------|----|----|
|High availability cluster node discovery |<p>LLD rule with item and trigger prototypes for the node discovery.</p> |DEPENDENT |zabbix.nodes.discovery<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.ha`</p> |

### Items collected

|Group|Name|Description|Type|Key and additional info|
|-----|----|-----------|----|---------------------|
|Cluster |Cluster node [{#NODE.NAME}]: Stats |<p>Provides the statistics of a node.</p> |DEPENDENT |zabbix.nodes.stats[{#NODE.ID}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.ha[?(@.id=="{#NODE.ID}")].first()`</p> |
|Cluster |Cluster node [{#NODE.NAME}]: Address |<p>The IPv4 address of a node.</p> |DEPENDENT |zabbix.nodes.address[{#NODE.ID}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.address`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `12h`</p> |
|Cluster |Cluster node [{#NODE.NAME}]: Last access time |<p>Last access time.</p> |DEPENDENT |zabbix.nodes.lastaccess.time[{#NODE.ID}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.lastaccess`</p> |
|Cluster |Cluster node [{#NODE.NAME}]: Last access age |<p>The time between the database's `unix_timestamp()` and the last access time.</p> |DEPENDENT |zabbix.nodes.lastaccess.age[{#NODE.ID}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.lastaccess_age`</p> |
|Cluster |Cluster node [{#NODE.NAME}]: Status |<p>The status of a node.</p> |DEPENDENT |zabbix.nodes.status[{#NODE.ID}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.status`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `12h`</p> |
|Zabbix raw items |Remote Zabbix server: Zabbix stats |<p>The master item of Zabbix server statistics.</p> |INTERNAL |zabbix[stats,{$ADDRESS},{$PORT}] |
|Zabbix server |Remote Zabbix server: Zabbix stats queue over 10m |<p>The number of monitored items in the queue, which are delayed at least by 10 minutes.</p> |INTERNAL |zabbix[stats,{$ADDRESS},{$PORT},queue,10m]<p>**Preprocessing**:</p><p>- JSONPATH: `$.queue`</p> |
|Zabbix server |Remote Zabbix server: Zabbix stats queue |<p>The number of monitored items in the queue, which are delayed at least by 6 seconds.</p> |INTERNAL |zabbix[stats,{$ADDRESS},{$PORT},queue]<p>**Preprocessing**:</p><p>- JSONPATH: `$.queue`</p> |
|Zabbix server |Remote Zabbix server: Utilization of alert manager internal processes, in % |<p>The average percentage of the time during which the alert manager processes have been busy for the last minute.</p> |DEPENDENT |process.alert_manager.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['alert manager'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "alert manager" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of alert syncer internal processes, in % |<p>The average percentage of the time during which the alert syncer processes have been busy for the last minute.</p> |DEPENDENT |process.alert_syncer.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['alert syncer'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "alert syncer" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of alerter internal processes, in % |<p>The average percentage of the time during which the alerter processes have been busy for the last minute.</p> |DEPENDENT |process.alerter.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['alerter'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "alerter" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of availability manager internal processes, in % |<p>The average percentage of the time during which the availability manager processes have been busy for the last minute.</p> |DEPENDENT |process.availability_manager.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['availability manager'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "availability manager" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of configuration syncer internal processes, in % |<p>The average percentage of the time during which the configuration syncer processes have been busy for the last minute.</p> |DEPENDENT |process.configuration_syncer.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['configuration syncer'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "configuration syncer" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of discoverer data collector processes, in % |<p>The average percentage of the time during which the discoverer processes have been busy for the last minute.</p> |DEPENDENT |process.discoverer.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['discoverer'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "discoverer" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of escalator internal processes, in % |<p>The average percentage of the time during which the escalator processes have been busy for the last minute.</p> |DEPENDENT |process.escalator.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['escalator'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "escalator" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of history poller data collector processes, in % |<p>The average percentage of the time during which the history poller processes have been busy for the last minute.</p> |DEPENDENT |process.history_poller.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['history poller'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "history poller" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of ODBC poller data collector processes, in % |<p>The average percentage of the time during which the ODBC poller processes have been busy for the last minute.</p> |DEPENDENT |process.odbc_poller.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['odbc poller'].busy.avg`</p> |
|Zabbix server |Remote Zabbix server: Utilization of history syncer internal processes, in % |<p>The average percentage of the time during which the history syncer processes have been busy for the last minute.</p> |DEPENDENT |process.history_syncer.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['history syncer'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "history syncer" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of housekeeper internal processes, in % |<p>The average percentage of the time during which the housekeeper processes have been busy for the last minute.</p> |DEPENDENT |process.housekeeper.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['housekeeper'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "housekeeper" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of http poller data collector processes, in % |<p>The average percentage of the time during which the http poller processes have been busy for the last minute.</p> |DEPENDENT |process.http_poller.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['http poller'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "http poller" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of icmp pinger data collector processes, in % |<p>The average percentage of the time during which the icmp pinger processes have been busy for the last minute.</p> |DEPENDENT |process.icmp_pinger.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['icmp pinger'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "icmp pinger" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of ipmi manager internal processes, in % |<p>The average percentage of the time during which the ipmi manager processes have been busy for the last minute.</p> |DEPENDENT |process.ipmi_manager.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['ipmi manager'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "ipmi manager" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of ipmi poller data collector processes, in % |<p>The average percentage of the time during which the ipmi poller processes have been busy for the last minute.</p> |DEPENDENT |process.ipmi_poller.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['ipmi poller'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "ipmi poller" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of java poller data collector processes, in % |<p>The average percentage of the time during which the java poller processes have been busy for the last minute.</p> |DEPENDENT |process.java_poller.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['java poller'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "java poller" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of LLD manager internal processes, in % |<p>The average percentage of the time during which the lld manager processes have been busy for the last minute.</p> |DEPENDENT |process.lld_manager.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['lld manager'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "LLD manager" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of LLD worker internal processes, in % |<p>The average percentage of the time during which the lld worker processes have been busy for the last minute.</p> |DEPENDENT |process.lld_worker.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['lld worker'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "LLD worker" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of poller data collector processes, in % |<p>The average percentage of the time during which the poller processes have been busy for the last minute.</p> |DEPENDENT |process.poller.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['poller'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "poller" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of preprocessing worker internal processes, in % |<p>The average percentage of the time during which the preprocessing worker processes have been busy for the last minute.</p> |DEPENDENT |process.preprocessing_worker.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['preprocessing worker'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "preprocessing worker" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of preprocessing manager internal processes, in % |<p>The average percentage of the time during which the preprocessing manager processes have been busy for the last minute.</p> |DEPENDENT |process.preprocessing_manager.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['preprocessing manager'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "preprocessing manager" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of proxy poller data collector processes, in % |<p>The average percentage of the time during which the proxy poller processes have been busy for the last minute.</p> |DEPENDENT |process.proxy_poller.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['proxy poller'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "proxy poller" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of report manager internal processes, in % |<p>The average percentage of the time during which the report manager processes have been busy for the last minute.</p> |DEPENDENT |process.report_manager.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['report manager'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "report manager" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of report writer internal processes, in % |<p>The average percentage of the time during which the report writer processes have been busy for the last minute.</p> |DEPENDENT |process.report_writer.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['report writer'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "report writer" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of self-monitoring internal processes, in % |<p>The average percentage of the time during which the self-monitoring processes have been busy for the last minute.</p> |DEPENDENT |process.self-monitoring.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['self-monitoring'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "self-monitoring" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of snmp trapper data collector processes, in % |<p>The average percentage of the time during which the snmp trapper processes have been busy for the last minute.</p> |DEPENDENT |process.snmp_trapper.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['snmp trapper'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "snmp trapper" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of task manager internal processes, in % |<p>The average percentage of the time during which the task manager processes have been busy for the last minute.</p> |DEPENDENT |process.task_manager.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['task manager'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "task manager" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of timer internal processes, in % |<p>The average percentage of the time during which the timer processes have been busy for the last minute.</p> |DEPENDENT |process.timer.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['timer'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "timer" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of service manager internal processes, in % |<p>The average percentage of the time during which the service manager processes have been busy for the last minute.</p> |DEPENDENT |process.service_manager.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['service manager'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "service manager" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of trigger housekeeper internal processes, in % |<p>The average percentage of the time during which the trigger housekeeper processes have been busy for the last minute.</p> |DEPENDENT |process.trigger_housekeeper.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['trigger housekeeper'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "trigger housekeeper" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of trapper data collector processes, in % |<p>The average percentage of the time during which the trapper processes have been busy for the last minute.</p> |DEPENDENT |process.trapper.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['trapper'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "trapper" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of unreachable poller data collector processes, in % |<p>The average percentage of the time during which the unreachable poller processes have been busy for the last minute.</p> |DEPENDENT |process.unreachable_poller.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['unreachable poller'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "unreachable poller" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Utilization of vmware data collector processes, in % |<p>The average percentage of the time during which the vmware collector processes have been busy for the last minute.</p> |DEPENDENT |process.vmware_collector.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['vmware collector'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "vmware collector" processes started.`</p> |
|Zabbix server |Remote Zabbix server: Configuration cache, % used |<p>The availability statistics of Zabbix configuration cache. The percentage of used data buffer.</p> |DEPENDENT |rcache.buffer.pused<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.rcache.pused`</p> |
|Zabbix server |Remote Zabbix server: Trend function cache, % of unique requests |<p>The effectiveness statistics of Zabbix trend function cache. The percentage of cached items calculated from the sum of cached items plus requests.</p><p>Low percentage most likely means that the cache size can be reduced.</p> |DEPENDENT |tcache.pitems<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.tcache.pitems`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Not supported in this version.`</p> |
|Zabbix server |Remote Zabbix server: Trend function cache, % of misses |<p>The effectiveness statistics of Zabbix trend function cache. The percentage of cache misses.</p> |DEPENDENT |tcache.pmisses<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.tcache.pmisses`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Not supported in this version.`</p> |
|Zabbix server |Remote Zabbix server: Value cache, % used |<p>The availability statistics of Zabbix value cache. The percentage of used data buffer.</p> |DEPENDENT |vcache.buffer.pused<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.vcache.buffer.pused`</p> |
|Zabbix server |Remote Zabbix server: Value cache hits |<p>The effectiveness statistics of Zabbix value cache. The number of cache hits (history values taken from the cache).</p> |DEPENDENT |vcache.cache.hits<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.vcache.cache.hits`</p><p>- CHANGE_PER_SECOND</p> |
|Zabbix server |Remote Zabbix server: Value cache misses |<p>The effectiveness statistics of Zabbix value cache. The number of cache misses (history values taken from the database).</p> |DEPENDENT |vcache.cache.misses<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.vcache.cache.misses`</p><p>- CHANGE_PER_SECOND</p> |
|Zabbix server |Remote Zabbix server: Value cache operating mode |<p>The operating mode of the value cache.</p> |DEPENDENT |vcache.cache.mode<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.vcache.cache.mode`</p> |
|Zabbix server |Remote Zabbix server: Version |<p>A version of Zabbix server.</p> |DEPENDENT |version<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.version`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|Zabbix server |Remote Zabbix server: VMware cache, % used |<p>The availability statistics of Zabbix vmware cache. The percentage of used data buffer.</p> |DEPENDENT |vmware.buffer.pused<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.vmware.pused`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No "vmware collector" processes started.`</p> |
|Zabbix server |Remote Zabbix server: History write cache, % used |<p>The statistics and availability of Zabbix write cache. The percentage of used history buffer.</p><p>The history cache is used to store item values. A high number indicates performance problems on the database side.</p> |DEPENDENT |wcache.history.pused<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.history.pused`</p> |
|Zabbix server |Remote Zabbix server: History index cache, % used |<p>The statistics and availability of Zabbix write cache. The percentage of used history index buffer.</p><p>The history index cache is used to index values stored in the history cache.</p> |DEPENDENT |wcache.index.pused<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.index.pused`</p> |
|Zabbix server |Remote Zabbix server: Trend write cache, % used |<p>The statistics and availability of Zabbix write cache. The percentage of used trend buffer.</p><p>The trend cache stores the aggregate of all items that have receive data for the current hour.</p> |DEPENDENT |wcache.trend.pused<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.trend.pused`</p> |
|Zabbix server |Remote Zabbix server: Number of processed values per second |<p>The statistics and availability of Zabbix write cache.</p><p>The total number of values processed by Zabbix server or Zabbix proxy, except unsupported items.</p> |DEPENDENT |wcache.values<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.values.all`</p><p>- CHANGE_PER_SECOND</p> |
|Zabbix server |Remote Zabbix server: Number of processed numeric (float) values per second |<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed float values.</p> |DEPENDENT |wcache.values.float<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.values.float`</p><p>- CHANGE_PER_SECOND</p> |
|Zabbix server |Remote Zabbix server: Number of processed log values per second |<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed log values.</p> |DEPENDENT |wcache.values.log<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.values.log`</p><p>- CHANGE_PER_SECOND</p> |
|Zabbix server |Remote Zabbix server: Number of processed not supported values per second |<p>The statistics and availability of Zabbix write cache.</p><p>The number of times the item processing resulted in an item becoming unsupported or keeping that state.</p> |DEPENDENT |wcache.values.not_supported<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.values['not supported']`</p><p>- CHANGE_PER_SECOND</p> |
|Zabbix server |Remote Zabbix server: Number of processed character values per second |<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed character/string values.</p> |DEPENDENT |wcache.values.str<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.values.str`</p><p>- CHANGE_PER_SECOND</p> |
|Zabbix server |Remote Zabbix server: Number of processed text values per second |<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed text values.</p> |DEPENDENT |wcache.values.text<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.values.text`</p><p>- CHANGE_PER_SECOND</p> |
|Zabbix server |Remote Zabbix server: LLD queue |<p>The count of values enqueued in the low-level discovery processing queue.</p> |DEPENDENT |lld_queue<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.lld_queue`</p> |
|Zabbix server |Remote Zabbix server: Preprocessing queue |<p>The count of values enqueued in the preprocessing queue.</p> |DEPENDENT |preprocessing_queue<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.preprocessing_queue`</p> |
|Zabbix server |Remote Zabbix server: Number of processed numeric (unsigned) values per second |<p>The statistics and availability of Zabbix write cache.</p><p>The number of processed numeric (unsigned) values.</p> |DEPENDENT |wcache.values.uint<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.values.uint`</p><p>- CHANGE_PER_SECOND</p> |

### Triggers

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----|----|----|
|Cluster node [{#NODE.NAME}]: Status changed |<p>The state of the node has changed. Confirm to close.</p> |`last(/Remote Zabbix server health/zabbix.nodes.status[{#NODE.ID}],#1)<>last(/Remote Zabbix server health/zabbix.nodes.status[{#NODE.ID}],#2)` |INFO |<p>Manual close: YES</p> |
|Remote Zabbix server: More than 100 items having missing data for more than 10 minutes |<p>The `zabbix[stats,{$IP},{$PORT},queue,10m]` item collects data about the number of items that have been missing the data for more than 10 minutes.</p> |`min(/Remote Zabbix server health/zabbix[stats,{$ADDRESS},{$PORT},queue,10m],10m)>100` |WARNING | |
|Remote Zabbix server: Utilization of alert manager processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.alert_manager.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.alert_manager.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of alert syncer processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.alert_syncer.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.alert_syncer.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of alerter processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.alerter.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.alerter.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of availability manager processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.availability_manager.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.availability_manager.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of configuration syncer processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.configuration_syncer.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.configuration_syncer.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of discoverer processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.discoverer.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.discoverer.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of escalator processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.escalator.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.escalator.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of history poller processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.history_poller.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.history_poller.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of ODBC poller processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.odbc_poller.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.odbc_poller.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of history syncer processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.history_syncer.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.history_syncer.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of housekeeper processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.housekeeper.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.housekeeper.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of http poller processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.http_poller.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.http_poller.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of icmp pinger processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.icmp_pinger.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.icmp_pinger.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of ipmi manager processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.ipmi_manager.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.ipmi_manager.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of ipmi poller processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.ipmi_poller.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.ipmi_poller.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of java poller processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.java_poller.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.java_poller.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of lld manager processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.lld_manager.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.lld_manager.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of lld worker processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.lld_worker.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.lld_worker.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of poller processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.poller.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.poller.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of preprocessing worker processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.preprocessing_worker.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.preprocessing_worker.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of preprocessing manager processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.preprocessing_manager.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.preprocessing_manager.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of proxy poller processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.proxy_poller.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.proxy_poller.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of report manager processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.report_manager.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.report_manager.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of report writer processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.report_writer.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.report_writer.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of self-monitoring processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.self-monitoring.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.self-monitoring.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of snmp trapper processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.snmp_trapper.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.snmp_trapper.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of task manager processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.task_manager.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.task_manager.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of timer processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.timer.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.timer.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of service manager processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.service_manager.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.service_manager.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of trigger housekeeper processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.trigger_housekeeper.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.trigger_housekeeper.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of trapper processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.trapper.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.trapper.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of unreachable poller processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.unreachable_poller.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.unreachable_poller.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of vmware collector processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.vmware_collector.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.vmware_collector.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: More than 75% used in the configuration cache |<p>Consider increasing `CacheSize` in the `zabbix_server.conf` configuration file.</p> |`max(/Remote Zabbix server health/rcache.buffer.pused,10m)>75` |AVERAGE | |
|Remote Zabbix server: More than 95% used in the value cache |<p>Consider increasing `ValueCacheSize` in the `zabbix_server.conf` configuration file.</p> |`max(/Remote Zabbix server health/vcache.buffer.pused,10m)>95` |AVERAGE | |
|Remote Zabbix server: Zabbix value cache working in low memory mode |<p>Once the low memory mode has been switched on, the value cache will remain in this state for 24 hours, even if the problem that triggered this mode is resolved sooner.</p> |`last(/Remote Zabbix server health/vcache.cache.mode)=1` |HIGH | |
|Remote Zabbix server: Version has changed |<p>Zabbix server version has changed. Acknowledge to close manually.</p> |`last(/Remote Zabbix server health/version,#1)<>last(/Remote Zabbix server health/version,#2) and length(last(/Remote Zabbix server health/version))>0` |INFO |<p>Manual close: YES</p> |
|Remote Zabbix server: More than 75% used in the vmware cache |<p>Consider increasing `VMwareCacheSize` in the `zabbix_server.conf` configuration file.</p> |`max(/Remote Zabbix server health/vmware.buffer.pused,10m)>75` |AVERAGE | |
|Remote Zabbix server: More than 75% used in the history cache |<p>Consider increasing `HistoryCacheSize` in the `zabbix_server.conf` configuration file.</p> |`max(/Remote Zabbix server health/wcache.history.pused,10m)>75` |AVERAGE | |
|Remote Zabbix server: More than 75% used in the history index cache |<p>Consider increasing `HistoryIndexCacheSize` in the `zabbix_server.conf` configuration file.</p> |`max(/Remote Zabbix server health/wcache.index.pused,10m)>75` |AVERAGE | |
|Remote Zabbix server: More than 75% used in the trends cache |<p>Consider increasing `TrendCacheSize` in the `zabbix_server.conf` configuration file.</p> |`max(/Remote Zabbix server health/wcache.trend.pused,10m)>75` |AVERAGE | |

## Feedback

Please report any issues with the template at https://support.zabbix.com.

