// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/recommendationengine/v1beta1/user_event_service.proto

package recommendationengine

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	httpbody "google.golang.org/genproto/googleapis/api/httpbody"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	_ "google.golang.org/genproto/googleapis/type/date"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for PurgeUserEvents method.
type PurgeUserEventsRequest struct {
	// Required. The resource name of the event_store under which the events are
	// created. The format is
	// "projects/${projectId}/locations/global/catalogs/${catalogId}/eventStores/${eventStoreId}"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The filter string to specify the events to be deleted. Empty
	// string filter is not allowed. This filter can also be used with
	// ListUserEvents API to list events that will be deleted. The eligible fields
	// for filtering are:
	// * eventType - UserEvent.eventType field of type string.
	// * eventTime - in ISO 8601 "zulu" format.
	// * visitorId - field of type string. Specifying this will delete all events
	// associated with a visitor.
	// * userId - field of type string. Specifying this will delete all events
	// associated with a user.
	// Example 1: Deleting all events in a time range.
	// `eventTime > "2012-04-23T18:25:43.511Z" eventTime <
	// "2012-04-23T18:30:43.511Z"`
	// Example 2: Deleting specific eventType in time range.
	// `eventTime > "2012-04-23T18:25:43.511Z" eventType = "detail-page-view"`
	// Example 3: Deleting all events for a specific visitor
	// `visitorId = visitor1024`
	// The filtering fields are assumed to have an implicit AND.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The default value is false. Override this flag to true to
	// actually perform the purge. If the field is not set to true, a sampling of
	// events to be deleted will be returned.
	Force                bool     `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PurgeUserEventsRequest) Reset()         { *m = PurgeUserEventsRequest{} }
func (m *PurgeUserEventsRequest) String() string { return proto.CompactTextString(m) }
func (*PurgeUserEventsRequest) ProtoMessage()    {}
func (*PurgeUserEventsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b2db17806dba696a, []int{0}
}

func (m *PurgeUserEventsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PurgeUserEventsRequest.Unmarshal(m, b)
}
func (m *PurgeUserEventsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PurgeUserEventsRequest.Marshal(b, m, deterministic)
}
func (m *PurgeUserEventsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PurgeUserEventsRequest.Merge(m, src)
}
func (m *PurgeUserEventsRequest) XXX_Size() int {
	return xxx_messageInfo_PurgeUserEventsRequest.Size(m)
}
func (m *PurgeUserEventsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PurgeUserEventsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PurgeUserEventsRequest proto.InternalMessageInfo

func (m *PurgeUserEventsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *PurgeUserEventsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *PurgeUserEventsRequest) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

// Metadata related to the progress of the PurgeUserEvents operation.
// This will be returned by the google.longrunning.Operation.metadata field.
type PurgeUserEventsMetadata struct {
	// The ID of the request / operation.
	OperationName string `protobuf:"bytes,1,opt,name=operation_name,json=operationName,proto3" json:"operation_name,omitempty"`
	// Operation create time.
	CreateTime           *timestamp.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PurgeUserEventsMetadata) Reset()         { *m = PurgeUserEventsMetadata{} }
func (m *PurgeUserEventsMetadata) String() string { return proto.CompactTextString(m) }
func (*PurgeUserEventsMetadata) ProtoMessage()    {}
func (*PurgeUserEventsMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_b2db17806dba696a, []int{1}
}

func (m *PurgeUserEventsMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PurgeUserEventsMetadata.Unmarshal(m, b)
}
func (m *PurgeUserEventsMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PurgeUserEventsMetadata.Marshal(b, m, deterministic)
}
func (m *PurgeUserEventsMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PurgeUserEventsMetadata.Merge(m, src)
}
func (m *PurgeUserEventsMetadata) XXX_Size() int {
	return xxx_messageInfo_PurgeUserEventsMetadata.Size(m)
}
func (m *PurgeUserEventsMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_PurgeUserEventsMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_PurgeUserEventsMetadata proto.InternalMessageInfo

func (m *PurgeUserEventsMetadata) GetOperationName() string {
	if m != nil {
		return m.OperationName
	}
	return ""
}

func (m *PurgeUserEventsMetadata) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

// Response of the PurgeUserEventsRequest. If the long running operation is
// successfully done, then this message is returned by the
// google.longrunning.Operations.response field.
type PurgeUserEventsResponse struct {
	// The total count of events purged as a result of the operation.
	PurgedEventsCount int64 `protobuf:"varint,1,opt,name=purged_events_count,json=purgedEventsCount,proto3" json:"purged_events_count,omitempty"`
	// A sampling of events deleted (or will be deleted) depending on the `force`
	// property in the request. Max of 500 items will be returned.
	UserEventsSample     []*UserEvent `protobuf:"bytes,2,rep,name=user_events_sample,json=userEventsSample,proto3" json:"user_events_sample,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *PurgeUserEventsResponse) Reset()         { *m = PurgeUserEventsResponse{} }
func (m *PurgeUserEventsResponse) String() string { return proto.CompactTextString(m) }
func (*PurgeUserEventsResponse) ProtoMessage()    {}
func (*PurgeUserEventsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b2db17806dba696a, []int{2}
}

func (m *PurgeUserEventsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PurgeUserEventsResponse.Unmarshal(m, b)
}
func (m *PurgeUserEventsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PurgeUserEventsResponse.Marshal(b, m, deterministic)
}
func (m *PurgeUserEventsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PurgeUserEventsResponse.Merge(m, src)
}
func (m *PurgeUserEventsResponse) XXX_Size() int {
	return xxx_messageInfo_PurgeUserEventsResponse.Size(m)
}
func (m *PurgeUserEventsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PurgeUserEventsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PurgeUserEventsResponse proto.InternalMessageInfo

func (m *PurgeUserEventsResponse) GetPurgedEventsCount() int64 {
	if m != nil {
		return m.PurgedEventsCount
	}
	return 0
}

func (m *PurgeUserEventsResponse) GetUserEventsSample() []*UserEvent {
	if m != nil {
		return m.UserEventsSample
	}
	return nil
}

// Request message for WriteUserEvent method.
type WriteUserEventRequest struct {
	// Required. The parent eventStore resource name, such as
	// "projects/1234/locations/global/catalogs/default_catalog/eventStores/default_event_store".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. User event to write.
	UserEvent            *UserEvent `protobuf:"bytes,2,opt,name=user_event,json=userEvent,proto3" json:"user_event,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *WriteUserEventRequest) Reset()         { *m = WriteUserEventRequest{} }
func (m *WriteUserEventRequest) String() string { return proto.CompactTextString(m) }
func (*WriteUserEventRequest) ProtoMessage()    {}
func (*WriteUserEventRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b2db17806dba696a, []int{3}
}

func (m *WriteUserEventRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WriteUserEventRequest.Unmarshal(m, b)
}
func (m *WriteUserEventRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WriteUserEventRequest.Marshal(b, m, deterministic)
}
func (m *WriteUserEventRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WriteUserEventRequest.Merge(m, src)
}
func (m *WriteUserEventRequest) XXX_Size() int {
	return xxx_messageInfo_WriteUserEventRequest.Size(m)
}
func (m *WriteUserEventRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_WriteUserEventRequest.DiscardUnknown(m)
}

var xxx_messageInfo_WriteUserEventRequest proto.InternalMessageInfo

func (m *WriteUserEventRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *WriteUserEventRequest) GetUserEvent() *UserEvent {
	if m != nil {
		return m.UserEvent
	}
	return nil
}

// Request message for CollectUserEvent method.
type CollectUserEventRequest struct {
	// Required. The parent eventStore name, such as
	// "projects/1234/locations/global/catalogs/default_catalog/eventStores/default_event_store".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. URL encoded UserEvent proto.
	UserEvent string `protobuf:"bytes,2,opt,name=user_event,json=userEvent,proto3" json:"user_event,omitempty"`
	// Optional. The url including cgi-parameters but excluding the hash fragment. The URL
	// must be truncated to 1.5K bytes to conservatively be under the 2K bytes.
	// This is often more useful than the referer url, because many browsers only
	// send the domain for 3rd party requests.
	Uri string `protobuf:"bytes,3,opt,name=uri,proto3" json:"uri,omitempty"`
	// Optional. The event timestamp in milliseconds. This prevents browser caching of
	// otherwise identical get requests. The name is abbreviated to reduce the
	// payload bytes.
	Ets                  int64    `protobuf:"varint,4,opt,name=ets,proto3" json:"ets,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CollectUserEventRequest) Reset()         { *m = CollectUserEventRequest{} }
func (m *CollectUserEventRequest) String() string { return proto.CompactTextString(m) }
func (*CollectUserEventRequest) ProtoMessage()    {}
func (*CollectUserEventRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b2db17806dba696a, []int{4}
}

func (m *CollectUserEventRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CollectUserEventRequest.Unmarshal(m, b)
}
func (m *CollectUserEventRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CollectUserEventRequest.Marshal(b, m, deterministic)
}
func (m *CollectUserEventRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectUserEventRequest.Merge(m, src)
}
func (m *CollectUserEventRequest) XXX_Size() int {
	return xxx_messageInfo_CollectUserEventRequest.Size(m)
}
func (m *CollectUserEventRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectUserEventRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CollectUserEventRequest proto.InternalMessageInfo

func (m *CollectUserEventRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CollectUserEventRequest) GetUserEvent() string {
	if m != nil {
		return m.UserEvent
	}
	return ""
}

func (m *CollectUserEventRequest) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *CollectUserEventRequest) GetEts() int64 {
	if m != nil {
		return m.Ets
	}
	return 0
}

// Request message for ListUserEvents method.
type ListUserEventsRequest struct {
	// Required. The parent eventStore resource name, such as
	// "projects/*/locations/*/catalogs/default_catalog/eventStores/default_event_store".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of results to return per page. If zero, the
	// service will choose a reasonable default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The previous ListUserEventsResponse.next_page_token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filtering expression to specify restrictions over
	// returned events. This is a sequence of terms, where each term applies some
	// kind of a restriction to the returned user events. Use this expression to
	// restrict results to a specific time range, or filter events by eventType.
	//    eg: eventTime > "2012-04-23T18:25:43.511Z" eventsMissingCatalogItems
	//    eventTime<"2012-04-23T18:25:43.511Z" eventType=search
	//
	//   We expect only 3 types of fields:
	//
	//    * eventTime: this can be specified a maximum of 2 times, once with a
	//      less than operator and once with a greater than operator. The
	//      eventTime restrict should result in one contiguous valid eventTime
	//      range.
	//
	//    * eventType: only 1 eventType restriction can be specified.
	//
	//    * eventsMissingCatalogItems: specififying this will restrict results
	//      to events for which catalog items were not found in the catalog. The
	//      default behavior is to return only those events for which catalog
	//      items were found.
	//
	//   Some examples of valid filters expressions:
	//
	//   * Example 1: eventTime > "2012-04-23T18:25:43.511Z"
	//             eventTime < "2012-04-23T18:30:43.511Z"
	//   * Example 2: eventTime > "2012-04-23T18:25:43.511Z"
	//             eventType = detail-page-view
	//   * Example 3: eventsMissingCatalogItems
	//             eventType = search eventTime < "2018-04-23T18:30:43.511Z"
	//   * Example 4: eventTime > "2012-04-23T18:25:43.511Z"
	//   * Example 5: eventType = search
	//   * Example 6: eventsMissingCatalogItems
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListUserEventsRequest) Reset()         { *m = ListUserEventsRequest{} }
func (m *ListUserEventsRequest) String() string { return proto.CompactTextString(m) }
func (*ListUserEventsRequest) ProtoMessage()    {}
func (*ListUserEventsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b2db17806dba696a, []int{5}
}

func (m *ListUserEventsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListUserEventsRequest.Unmarshal(m, b)
}
func (m *ListUserEventsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListUserEventsRequest.Marshal(b, m, deterministic)
}
func (m *ListUserEventsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListUserEventsRequest.Merge(m, src)
}
func (m *ListUserEventsRequest) XXX_Size() int {
	return xxx_messageInfo_ListUserEventsRequest.Size(m)
}
func (m *ListUserEventsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListUserEventsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListUserEventsRequest proto.InternalMessageInfo

func (m *ListUserEventsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListUserEventsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListUserEventsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListUserEventsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// Response message for ListUserEvents method.
type ListUserEventsResponse struct {
	// The user events.
	UserEvents []*UserEvent `protobuf:"bytes,1,rep,name=user_events,json=userEvents,proto3" json:"user_events,omitempty"`
	// If empty, the list is complete. If nonempty, the token to pass to the next
	// request's ListUserEvents.page_token.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListUserEventsResponse) Reset()         { *m = ListUserEventsResponse{} }
func (m *ListUserEventsResponse) String() string { return proto.CompactTextString(m) }
func (*ListUserEventsResponse) ProtoMessage()    {}
func (*ListUserEventsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b2db17806dba696a, []int{6}
}

func (m *ListUserEventsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListUserEventsResponse.Unmarshal(m, b)
}
func (m *ListUserEventsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListUserEventsResponse.Marshal(b, m, deterministic)
}
func (m *ListUserEventsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListUserEventsResponse.Merge(m, src)
}
func (m *ListUserEventsResponse) XXX_Size() int {
	return xxx_messageInfo_ListUserEventsResponse.Size(m)
}
func (m *ListUserEventsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListUserEventsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListUserEventsResponse proto.InternalMessageInfo

func (m *ListUserEventsResponse) GetUserEvents() []*UserEvent {
	if m != nil {
		return m.UserEvents
	}
	return nil
}

func (m *ListUserEventsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*PurgeUserEventsRequest)(nil), "google.cloud.recommendationengine.v1beta1.PurgeUserEventsRequest")
	proto.RegisterType((*PurgeUserEventsMetadata)(nil), "google.cloud.recommendationengine.v1beta1.PurgeUserEventsMetadata")
	proto.RegisterType((*PurgeUserEventsResponse)(nil), "google.cloud.recommendationengine.v1beta1.PurgeUserEventsResponse")
	proto.RegisterType((*WriteUserEventRequest)(nil), "google.cloud.recommendationengine.v1beta1.WriteUserEventRequest")
	proto.RegisterType((*CollectUserEventRequest)(nil), "google.cloud.recommendationengine.v1beta1.CollectUserEventRequest")
	proto.RegisterType((*ListUserEventsRequest)(nil), "google.cloud.recommendationengine.v1beta1.ListUserEventsRequest")
	proto.RegisterType((*ListUserEventsResponse)(nil), "google.cloud.recommendationengine.v1beta1.ListUserEventsResponse")
}

func init() {
	proto.RegisterFile("google/cloud/recommendationengine/v1beta1/user_event_service.proto", fileDescriptor_b2db17806dba696a)
}

var fileDescriptor_b2db17806dba696a = []byte{
	// 1003 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0xcf, 0x6f, 0x1b, 0x45,
	0x14, 0xd6, 0x6e, 0x9a, 0xaa, 0x19, 0x8b, 0x34, 0x0c, 0x24, 0x71, 0x0d, 0x88, 0x68, 0x2b, 0x50,
	0x6a, 0xd1, 0x5d, 0x25, 0x20, 0x84, 0xb6, 0x42, 0xc2, 0x8e, 0x22, 0xa8, 0x54, 0x4a, 0xb4, 0x4e,
	0x93, 0x0a, 0x05, 0x99, 0xf1, 0xfa, 0x79, 0xb3, 0xb0, 0xbb, 0xb3, 0xcc, 0xcc, 0x26, 0xa4, 0xa8,
	0x1c, 0x38, 0x20, 0x4e, 0x5c, 0x38, 0x70, 0x44, 0xe2, 0x88, 0xc4, 0x3f, 0xe2, 0x23, 0x3d, 0x70,
	0x42, 0x70, 0x40, 0x42, 0x82, 0x0b, 0x7f, 0x02, 0x9a, 0x1f, 0xb6, 0x37, 0xae, 0x91, 0x6c, 0x27,
	0x37, 0xfb, 0xbd, 0x6f, 0xbe, 0xf7, 0xbd, 0x37, 0xdf, 0xce, 0x0c, 0x6a, 0x46, 0x94, 0x46, 0x09,
	0x78, 0x61, 0x42, 0x8b, 0xae, 0xc7, 0x20, 0xa4, 0x69, 0x0a, 0x59, 0x97, 0x88, 0x98, 0x66, 0x90,
	0x45, 0x71, 0x06, 0xde, 0xc9, 0x56, 0x07, 0x04, 0xd9, 0xf2, 0x0a, 0x0e, 0xac, 0x0d, 0x27, 0x90,
	0x89, 0x36, 0x07, 0x76, 0x12, 0x87, 0xe0, 0xe6, 0x8c, 0x0a, 0x8a, 0x6f, 0x69, 0x0e, 0x57, 0x71,
	0xb8, 0x93, 0x38, 0x5c, 0xc3, 0x51, 0x7b, 0xd1, 0x94, 0x23, 0x79, 0xec, 0x91, 0x2c, 0xa3, 0x42,
	0x81, 0xb8, 0x26, 0xaa, 0xbd, 0x5c, 0xca, 0xf6, 0x62, 0x48, 0xba, 0xed, 0x0e, 0x1c, 0x93, 0x93,
	0x98, 0x32, 0x03, 0xb8, 0x51, 0x02, 0x1c, 0x0b, 0x91, 0x77, 0x68, 0xf7, 0xcc, 0xa4, 0xde, 0x9c,
	0xbe, 0x91, 0x38, 0xcd, 0x29, 0x13, 0x66, 0x9d, 0x3f, 0xcf, 0x00, 0xcc, 0xda, 0x9b, 0x66, 0x6d,
	0x42, 0xb3, 0x88, 0x15, 0x59, 0x16, 0x67, 0x91, 0x47, 0x73, 0x60, 0x13, 0x9b, 0x52, 0xff, 0x3a,
	0x45, 0xcf, 0x13, 0x71, 0x0a, 0x5c, 0x90, 0x34, 0x37, 0x80, 0x35, 0x03, 0x10, 0x67, 0x39, 0x78,
	0x5d, 0x22, 0xcc, 0x58, 0x6b, 0xeb, 0xa5, 0x66, 0xc3, 0x24, 0x1e, 0x96, 0x75, 0x52, 0xb4, 0xb6,
	0x57, 0xb0, 0x08, 0x1e, 0x70, 0x60, 0xbb, 0x52, 0x0e, 0x0f, 0xe0, 0xb3, 0x02, 0xb8, 0xc0, 0x2f,
	0xa0, 0xab, 0x39, 0x61, 0x90, 0x89, 0xaa, 0xb5, 0x61, 0x6d, 0x2e, 0x35, 0x17, 0xfe, 0x68, 0xd8,
	0x81, 0x09, 0xc9, 0x64, 0x2f, 0x4e, 0x04, 0xb0, 0xaa, 0x5d, 0x4a, 0xea, 0x10, 0xbe, 0x81, 0x16,
	0x7b, 0x94, 0x85, 0x50, 0x5d, 0xd8, 0xb0, 0x36, 0xaf, 0xc9, 0x9c, 0x15, 0xe8, 0x88, 0xf3, 0x18,
	0xad, 0x8f, 0x95, 0x7b, 0x1f, 0x04, 0xe9, 0x12, 0x41, 0xf0, 0x2b, 0x68, 0x79, 0xd8, 0x6f, 0x3b,
	0x23, 0x29, 0xe8, 0xba, 0xc1, 0x33, 0xc3, 0xe8, 0x7d, 0x92, 0x02, 0xbe, 0x83, 0x2a, 0x21, 0x03,
	0x22, 0xa0, 0x2d, 0x7b, 0x57, 0xe5, 0x2b, 0xdb, 0x35, 0xd7, 0xd8, 0x66, 0x30, 0x18, 0x77, 0x7f,
	0x30, 0x98, 0x00, 0x69, 0xb8, 0x0c, 0x38, 0x3f, 0x5b, 0x4f, 0xd5, 0x0f, 0x80, 0xe7, 0x34, 0xe3,
	0x80, 0x5d, 0xf4, 0x5c, 0x2e, 0x53, 0x5d, 0xbd, 0x2d, 0xbc, 0x1d, 0xd2, 0xc2, 0x34, 0xbf, 0x10,
	0x3c, 0xab, 0x53, 0x7a, 0xc9, 0x8e, 0x4c, 0xe0, 0x0e, 0xc2, 0xa3, 0x4d, 0xe4, 0x6d, 0x4e, 0xd2,
	0x3c, 0x91, 0x7a, 0x16, 0x36, 0x2b, 0xdb, 0x6f, 0xb8, 0x53, 0xdb, 0xd8, 0x1d, 0x4a, 0x09, 0x56,
	0x8a, 0xa1, 0xaa, 0x96, 0x62, 0x73, 0xbe, 0xb5, 0xd0, 0xea, 0x21, 0x8b, 0xc5, 0x48, 0xef, 0x54,
	0xbb, 0xf3, 0x10, 0xa1, 0x91, 0x34, 0x33, 0xa2, 0xb9, 0x24, 0x69, 0xda, 0xa5, 0xa1, 0x2e, 0xe7,
	0x1b, 0x0b, 0xad, 0xef, 0xd0, 0x24, 0x81, 0x50, 0xcc, 0x26, 0xc9, 0x79, 0x4a, 0xd2, 0xd2, 0x38,
	0x39, 0x5e, 0x45, 0x0b, 0x05, 0x8b, 0x95, 0x6b, 0x96, 0xb4, 0x6b, 0xe4, 0x7f, 0x19, 0x06, 0xc1,
	0xab, 0x57, 0xe4, 0x46, 0x98, 0x30, 0x08, 0xee, 0x7c, 0x6f, 0xa1, 0xd5, 0x7b, 0x31, 0x17, 0x33,
	0x3a, 0x77, 0x03, 0x2d, 0xe5, 0x24, 0x82, 0x36, 0x8f, 0x1f, 0x69, 0xf7, 0x2c, 0x6a, 0xce, 0x6b,
	0x32, 0xda, 0x8a, 0x1f, 0x81, 0x94, 0xaa, 0x10, 0x82, 0x7e, 0x0a, 0x59, 0x59, 0x8d, 0x5a, 0xb8,
	0x2f, 0xa3, 0x25, 0xff, 0x5f, 0x19, 0xe5, 0x4d, 0x48, 0x2a, 0x5b, 0x1b, 0x57, 0x66, 0x4c, 0xf6,
	0x00, 0x55, 0x4a, 0xa6, 0xa9, 0x5a, 0x17, 0x70, 0x0b, 0x1a, 0xb9, 0x05, 0xbf, 0x8a, 0xae, 0x67,
	0xf0, 0xb9, 0x68, 0x97, 0x74, 0xdb, 0xfa, 0xe3, 0x91, 0xe1, 0xbd, 0x81, 0xec, 0xed, 0x27, 0x15,
	0xb4, 0x32, 0x64, 0x68, 0xe9, 0x83, 0x17, 0xff, 0x6b, 0xa1, 0xe5, 0xf3, 0x26, 0xc3, 0xef, 0xcc,
	0xa0, 0x68, 0xa2, 0x3f, 0x6b, 0x73, 0xf5, 0xe4, 0xf4, 0xbe, 0x7a, 0xf2, 0xe7, 0x77, 0xf6, 0xc7,
	0x4e, 0x30, 0x3c, 0x27, 0xbf, 0xd0, 0xdb, 0xf6, 0x76, 0xce, 0xe8, 0x27, 0x10, 0x0a, 0xee, 0xd5,
	0xbd, 0x84, 0x86, 0xfa, 0x50, 0xf4, 0xea, 0x5e, 0x48, 0x04, 0x49, 0x68, 0x24, 0x7f, 0xaa, 0x91,
	0xb6, 0x04, 0x65, 0xc0, 0xbd, 0xfa, 0x63, 0x6f, 0x34, 0x1d, 0xff, 0x54, 0x2a, 0xf4, 0x4b, 0xfe,
	0xc3, 0x7d, 0x0b, 0xad, 0x8c, 0xdb, 0x18, 0x37, 0x67, 0x90, 0xfc, 0x3f, 0xdf, 0x40, 0xed, 0xf9,
	0x01, 0x07, 0xc9, 0x63, 0xf7, 0x3d, 0x21, 0xf2, 0x26, 0xed, 0x9e, 0x39, 0x47, 0xaa, 0xad, 0x03,
	0xbc, 0x7f, 0xa9, 0x6d, 0x85, 0x5a, 0x03, 0xfe, 0xc7, 0x42, 0xcb, 0xe7, 0xed, 0x36, 0xd3, 0xfe,
	0x4d, 0xfc, 0x86, 0x6a, 0x8d, 0x0b, 0x30, 0x68, 0xaf, 0x3b, 0xfb, 0xaa, 0xeb, 0xfb, 0xf8, 0xde,
	0x65, 0x76, 0x8d, 0x7f, 0xb3, 0xd1, 0xf5, 0xb1, 0x23, 0x1c, 0xcf, 0x22, 0x76, 0xf2, 0x6d, 0x57,
	0x7b, 0x69, 0x40, 0x51, 0xba, 0x7f, 0xdd, 0x0f, 0x06, 0x37, 0x8f, 0xf3, 0x97, 0xd5, 0x6f, 0x7c,
	0x6d, 0xa1, 0xc6, 0x05, 0xea, 0x98, 0x13, 0x60, 0x7e, 0x8a, 0xc1, 0x4d, 0xa9, 0xc6, 0x7a, 0x78,
	0xc9, 0xdf, 0x88, 0xba, 0xdf, 0x7c, 0xab, 0x8e, 0x7f, 0xb5, 0xd1, 0xca, 0x5d, 0xf5, 0xa8, 0x29,
	0x0d, 0x78, 0x96, 0x4f, 0x63, 0x7c, 0xf1, 0x94, 0x13, 0xfe, 0xdd, 0xea, 0x37, 0xbe, 0x1c, 0x3c,
	0x21, 0xe7, 0xab, 0x63, 0x26, 0xfc, 0xd6, 0xac, 0x1c, 0xe7, 0x06, 0xfb, 0xd0, 0x69, 0x5d, 0xea,
	0x60, 0xf5, 0x03, 0xd1, 0xb7, 0xea, 0xb5, 0xc3, 0x7e, 0xe3, 0xe6, 0x44, 0x35, 0x5a, 0x2f, 0xc9,
	0x63, 0xee, 0x86, 0x34, 0xfd, 0xa5, 0xe1, 0xca, 0xe7, 0x28, 0xf7, 0x3d, 0xef, 0xf4, 0xf4, 0x74,
	0x2c, 0xe9, 0x91, 0x42, 0x1c, 0xeb, 0xf7, 0xe5, 0xed, 0x3c, 0x21, 0xa2, 0x47, 0x59, 0xda, 0xfc,
	0xc1, 0x46, 0xb7, 0x43, 0x9a, 0x4e, 0xbf, 0x47, 0x7b, 0xd6, 0x87, 0x1f, 0x19, 0x70, 0x44, 0x13,
	0x92, 0x45, 0x2e, 0x65, 0x91, 0x17, 0x41, 0xa6, 0x9e, 0x4f, 0xde, 0xa8, 0xe4, 0x14, 0x2f, 0xd9,
	0x3b, 0x93, 0x92, 0x3f, 0xda, 0x8b, 0xc1, 0xee, 0x4e, 0xe3, 0xee, 0x4f, 0xf6, 0xad, 0x77, 0x75,
	0x9d, 0x1d, 0x25, 0x2a, 0x38, 0x87, 0xdd, 0xd5, 0xa2, 0x0e, 0xb6, 0x9a, 0x92, 0xa8, 0x3f, 0xc0,
	0x1e, 0x29, 0xec, 0xd1, 0x24, 0xec, 0xd1, 0x81, 0x2e, 0xfa, 0xb7, 0xfd, 0x9a, 0xc6, 0xfa, 0xbe,
	0x02, 0xfb, 0xfe, 0x24, 0xb4, 0xef, 0x1b, 0x78, 0xe7, 0xaa, 0x6a, 0xec, 0xf5, 0xff, 0x02, 0x00,
	0x00, 0xff, 0xff, 0xa2, 0xfa, 0x52, 0x90, 0xa2, 0x0c, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// UserEventServiceClient is the client API for UserEventService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type UserEventServiceClient interface {
	// Writes a single user event.
	WriteUserEvent(ctx context.Context, in *WriteUserEventRequest, opts ...grpc.CallOption) (*UserEvent, error)
	// Writes a single user event from the browser. This uses a GET request to
	// due to browser restriction of POST-ing to a 3rd party domain.
	//
	// This method is used only by the Recommendations AI JavaScript pixel.
	// Users should not call this method directly.
	CollectUserEvent(ctx context.Context, in *CollectUserEventRequest, opts ...grpc.CallOption) (*httpbody.HttpBody, error)
	// Gets a list of user events within a time range, with potential filtering.
	ListUserEvents(ctx context.Context, in *ListUserEventsRequest, opts ...grpc.CallOption) (*ListUserEventsResponse, error)
	// Deletes permanently all user events specified by the filter provided.
	// Depending on the number of events specified by the filter, this operation
	// could take hours or days to complete. To test a filter, use the list
	// command first.
	PurgeUserEvents(ctx context.Context, in *PurgeUserEventsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Bulk import of User events. Request processing might be
	// synchronous. Events that already exist are skipped.
	// Use this method for backfilling historical user events.
	//
	// Operation.response is of type ImportResponse. Note that it is
	// possible for a subset of the items to be successfully inserted.
	// Operation.metadata is of type ImportMetadata.
	ImportUserEvents(ctx context.Context, in *ImportUserEventsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type userEventServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewUserEventServiceClient(cc grpc.ClientConnInterface) UserEventServiceClient {
	return &userEventServiceClient{cc}
}

func (c *userEventServiceClient) WriteUserEvent(ctx context.Context, in *WriteUserEventRequest, opts ...grpc.CallOption) (*UserEvent, error) {
	out := new(UserEvent)
	err := c.cc.Invoke(ctx, "/google.cloud.recommendationengine.v1beta1.UserEventService/WriteUserEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userEventServiceClient) CollectUserEvent(ctx context.Context, in *CollectUserEventRequest, opts ...grpc.CallOption) (*httpbody.HttpBody, error) {
	out := new(httpbody.HttpBody)
	err := c.cc.Invoke(ctx, "/google.cloud.recommendationengine.v1beta1.UserEventService/CollectUserEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userEventServiceClient) ListUserEvents(ctx context.Context, in *ListUserEventsRequest, opts ...grpc.CallOption) (*ListUserEventsResponse, error) {
	out := new(ListUserEventsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.recommendationengine.v1beta1.UserEventService/ListUserEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userEventServiceClient) PurgeUserEvents(ctx context.Context, in *PurgeUserEventsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.recommendationengine.v1beta1.UserEventService/PurgeUserEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userEventServiceClient) ImportUserEvents(ctx context.Context, in *ImportUserEventsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.recommendationengine.v1beta1.UserEventService/ImportUserEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// UserEventServiceServer is the server API for UserEventService service.
type UserEventServiceServer interface {
	// Writes a single user event.
	WriteUserEvent(context.Context, *WriteUserEventRequest) (*UserEvent, error)
	// Writes a single user event from the browser. This uses a GET request to
	// due to browser restriction of POST-ing to a 3rd party domain.
	//
	// This method is used only by the Recommendations AI JavaScript pixel.
	// Users should not call this method directly.
	CollectUserEvent(context.Context, *CollectUserEventRequest) (*httpbody.HttpBody, error)
	// Gets a list of user events within a time range, with potential filtering.
	ListUserEvents(context.Context, *ListUserEventsRequest) (*ListUserEventsResponse, error)
	// Deletes permanently all user events specified by the filter provided.
	// Depending on the number of events specified by the filter, this operation
	// could take hours or days to complete. To test a filter, use the list
	// command first.
	PurgeUserEvents(context.Context, *PurgeUserEventsRequest) (*longrunning.Operation, error)
	// Bulk import of User events. Request processing might be
	// synchronous. Events that already exist are skipped.
	// Use this method for backfilling historical user events.
	//
	// Operation.response is of type ImportResponse. Note that it is
	// possible for a subset of the items to be successfully inserted.
	// Operation.metadata is of type ImportMetadata.
	ImportUserEvents(context.Context, *ImportUserEventsRequest) (*longrunning.Operation, error)
}

// UnimplementedUserEventServiceServer can be embedded to have forward compatible implementations.
type UnimplementedUserEventServiceServer struct {
}

func (*UnimplementedUserEventServiceServer) WriteUserEvent(ctx context.Context, req *WriteUserEventRequest) (*UserEvent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method WriteUserEvent not implemented")
}
func (*UnimplementedUserEventServiceServer) CollectUserEvent(ctx context.Context, req *CollectUserEventRequest) (*httpbody.HttpBody, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CollectUserEvent not implemented")
}
func (*UnimplementedUserEventServiceServer) ListUserEvents(ctx context.Context, req *ListUserEventsRequest) (*ListUserEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListUserEvents not implemented")
}
func (*UnimplementedUserEventServiceServer) PurgeUserEvents(ctx context.Context, req *PurgeUserEventsRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PurgeUserEvents not implemented")
}
func (*UnimplementedUserEventServiceServer) ImportUserEvents(ctx context.Context, req *ImportUserEventsRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportUserEvents not implemented")
}

func RegisterUserEventServiceServer(s *grpc.Server, srv UserEventServiceServer) {
	s.RegisterService(&_UserEventService_serviceDesc, srv)
}

func _UserEventService_WriteUserEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WriteUserEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserEventServiceServer).WriteUserEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recommendationengine.v1beta1.UserEventService/WriteUserEvent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserEventServiceServer).WriteUserEvent(ctx, req.(*WriteUserEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserEventService_CollectUserEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CollectUserEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserEventServiceServer).CollectUserEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recommendationengine.v1beta1.UserEventService/CollectUserEvent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserEventServiceServer).CollectUserEvent(ctx, req.(*CollectUserEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserEventService_ListUserEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUserEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserEventServiceServer).ListUserEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recommendationengine.v1beta1.UserEventService/ListUserEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserEventServiceServer).ListUserEvents(ctx, req.(*ListUserEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserEventService_PurgeUserEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PurgeUserEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserEventServiceServer).PurgeUserEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recommendationengine.v1beta1.UserEventService/PurgeUserEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserEventServiceServer).PurgeUserEvents(ctx, req.(*PurgeUserEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserEventService_ImportUserEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportUserEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserEventServiceServer).ImportUserEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recommendationengine.v1beta1.UserEventService/ImportUserEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserEventServiceServer).ImportUserEvents(ctx, req.(*ImportUserEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _UserEventService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.recommendationengine.v1beta1.UserEventService",
	HandlerType: (*UserEventServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "WriteUserEvent",
			Handler:    _UserEventService_WriteUserEvent_Handler,
		},
		{
			MethodName: "CollectUserEvent",
			Handler:    _UserEventService_CollectUserEvent_Handler,
		},
		{
			MethodName: "ListUserEvents",
			Handler:    _UserEventService_ListUserEvents_Handler,
		},
		{
			MethodName: "PurgeUserEvents",
			Handler:    _UserEventService_PurgeUserEvents_Handler,
		},
		{
			MethodName: "ImportUserEvents",
			Handler:    _UserEventService_ImportUserEvents_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/recommendationengine/v1beta1/user_event_service.proto",
}
