/*
 * KDE. Krita Project.
 *
 * Copyright (c) 2020 Deif Lou <ginoba@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef KISGRADIENTGENERATOR_H
#define KISGRADIENTGENERATOR_H

#include <QObject>

#include "generator/kis_generator.h"

#include "KisGradientGeneratorConfiguration.h"

class KisConfigWidget;

class KisGradientGenerator : public KisGenerator
{
public:
    KisGradientGenerator();

    using KisGenerator::generate;

    virtual void generate(KisProcessingInformation dst,
                          const QSize& size,
                          const KisFilterConfigurationSP config,
                          KoUpdater* progressUpdater) const override;
    
    static inline KoID id() {
        return KoID(KisGradientGeneratorConfiguration::defaultName(), i18n("Gradient"));
    }

    KisFilterConfigurationSP factoryConfiguration() const override;
    KisFilterConfigurationSP defaultConfiguration() const override;
    KisConfigWidget* createConfigurationWidget(QWidget* parent, const KisPaintDeviceSP dev, bool useForMasks) const override;
};

#endif
