# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.


# DO NOT ADD THINGS OTHER THAN ERROR MESSAGES HERE.
# This file gets parsed into a JS dictionary of all known error message ids in
# gen_aboutneterror_codes.py . If we end up needing fluent attributes or
# refactoring them in some way, the script will need updating.

psmerr-ssl-disabled = SSL প্রোটোকল নিষ্ক্রিয় হওয়ার ফলে নিরাপদরূপে সংযোগ স্থাপন করা যায়নি।
psmerr-ssl2-disabled = এই সাইটের সাথে নিরাপদরূপে সংযোগ স্থাপন করা সম্ভব নয় কারণ এই সাইটে SSL প্রোটোকলের একটি পুরোনো ও অরক্ষিত সংস্করণ ব্যবহৃত হয়েছে।

# This is a multi-line message.
psmerr-hostreusedissuerandserial =
    আপনি একটি অকার্যকর সার্টিফিকেট গ্রহণ করেছেন।  সার্ভারের অ্যাডমিনিস্ট্রেটর অথবা ইমেইল লেখক বা প্রাপকের সাথে অনুগ্রহ করে যোগাযোগ করুন এবং তাদেরকে নিম্নলিখিত তথ্য প্রেরণ করুন:
    
    আপনার সার্টিফিকেটের ক্রমিক সংখ্যা সার্টিফিকেট কর্তৃপক্ষর দ্বারা প্রকাশিত অন্য একটি সার্টিফিকেটের ক্রমিক সংখ্যার অনুরূপ।  অনুগ্রহ করে স্বতন্ত্র ক্রমিক সংখ্যা সহ একটি নতুন সার্টিফিকেট গ্রহণ করুন।

ssl-error-export-only-server = নিরাপদভাবে তথ্য বিনিময় করতে ব্যর্থ। পিয়ার উচ্চমানের এনক্রিপশন সমর্থন করে না।
ssl-error-us-only-server = নিরাপদভাবে তথ্য বিনিময় করতে ব্যর্থ। পিয়ার উচ্চমানের এনক্রিপশন দাবী করে যা বর্তমানে সমর্থিত নয়।
ssl-error-no-cypher-overlap = নিরাপদভাবে পিয়ার সার্ভারের সাথে তথ্য বিনিময় করা সম্ভব নয়: এনক্রিপশন এলগরিদমে কোন মিল নেই।
ssl-error-no-certificate = অনুমোদনের জন্য প্রয়োজনীয় সার্টিফিকেট অথবা কী পাওয়া যায়নি।
ssl-error-bad-certificate = নিরাপদভাবে পিয়ার সার্ভারের সাথে তথ্য বিনিময় করা সম্ভব নয়: পিয়ার সার্ভারের সার্টিফিকেট প্রত্যাখ্যান করা হয়েছে।
ssl-error-bad-client = সার্ভার দ্বারা ক্লায়েন্ট থেকে ত্রুটিপূর্ণ তথ্য পেয়েছে।
ssl-error-bad-server = ক্লায়েন্ট দ্বারা সার্ভার থেকে ত্রুটিপূর্ণ তথ্য পেয়েছে।
ssl-error-unsupported-certificate-type = সার্টিফিকেটের ধরণ সমর্থিত নয়।
ssl-error-unsupported-version = পিয়ার নিরাপত্তা প্রোটোকলের অসমর্থিত সংস্করণ ব্যবহার করছে।
ssl-error-wrong-certificate = ক্লায়েন্টের পরিচয় প্রমাণ করতে ব্যর্থ: কী ডাটাবেসের প্রাইভেট কী এবং সার্টিফিকেট ডাটাবেসের পাবলিক কী দুটির মধ্যে অমিল।
ssl-error-bad-cert-domain = নিরাপদভাবে পিয়ার সার্ভারের সাথে তথ্য বিনিময় করা সম্ভব নয়: অনুরোধ করা ডোমেইনের নাম ও সার্ভারের সার্টিফিকেটের মধ্যে অমিল।
ssl-error-post-warning = অপরিচিতি SSL ত্রুটি কোড।
ssl-error-ssl2-disabled = পিয়ার শুধুমাত্র SSL সংস্করণ 2 সমর্থন করে, যা স্থানীয় অবস্থানে নিষ্ক্রিয়।
ssl-error-bad-mac-read = SSL দ্বারা প্রাপ্ত রেকর্ডে, বার্তা অনুমোদনের কোডটি ভুল।
ssl-error-bad-mac-alert = SSL পিয়ার বার্তা অনুমোদনের কোড ভুল হিসেবে প্রতিবেদন করেছে।
ssl-error-bad-cert-alert = SSL পিয়ার দ্বারা আপনার সার্টিফিকেট যাচাই করা সম্ভব নয়।
ssl-error-revoked-cert-alert = SSL পিয়ার দ্বারা আপনার সার্টিফিকেটকে বাতিল বলে প্রত্যাখ্যান করা হয়েছে।
ssl-error-expired-cert-alert = SSL পিয়ার দ্বারা আপনার সার্টিফিকেটকে মেয়াদোত্তীর্ণ বলে প্রত্যাখ্যান করা হয়েছে।
ssl-error-ssl-disabled = সংযোগ করা সম্ভব নয়: SSL নিষ্ক্রিয় রয়েছে।
ssl-error-fortezza-pqg = সংযোগ করা সম্ভব নয়: পিয়ার SSL একটি পৃথক FORTEZZA ডোমেইনের মধ্যে অবস্থিত।
ssl-error-unknown-cipher-suite = একটি অজানা SSL সাইফার স্যুটের অনুরোধ জানানো হয়েছে।
ssl-error-no-ciphers-supported = কোনো ধরনের সাইফার স্যুট উপস্থিত নেই ও প্রোগ্রামের মধ্যে সক্রিয় করা নেই।
ssl-error-bad-block-padding = ত্রুটিপূর্ণ ব্লক প্যাড করা একটি রেকর্ড SSL দ্বারা প্রাপ্ত হয়েছে।
ssl-error-rx-record-too-long = SSL দ্বারা প্রাপ্ত একটি রেকর্ড অনুমোদিত সর্বোচ্চ দৈর্ঘ্য অতিক্রম করেছে।
ssl-error-tx-record-too-long = SSL দ্বারা একটি রেকর্ড পাঠানোর প্রচেষ্টা করা হয়েছে যা অনুমোদিত সর্বোচ্চ দৈর্ঘ্য অতিক্রম করেছে।
ssl-error-rx-malformed-hello-request = SSL ত্রুটিপূর্ণ Hello Request হ্যান্ডশেক বার্তা গ্রহণ করেছে।
ssl-error-rx-malformed-client-hello = SSL ত্রুটিপূর্ণ Client Hello হ্যান্ডশেক বার্তা গ্রহণ করেছে।
ssl-error-rx-malformed-server-hello = SSL, ত্রুটিপূর্ণ Server Hello হ্যান্ডশেক বার্তা গ্রহণ করেছে।
ssl-error-rx-malformed-certificate = SSL, ত্রুটিপূর্ণ Certificate হ্যান্ডশেক বার্তা গ্রহণ করেছে।
ssl-error-rx-malformed-server-key-exch = SSL, ত্রুটিপূর্ণ Server Key Exchange হ্যান্ডশেক বার্তা গ্রহণ করেছে।
ssl-error-rx-malformed-cert-request = SSL, ত্রুটিপূর্ণ Certificate Request হ্যান্ডশেক বার্তা গ্রহণ করেছে।
ssl-error-rx-malformed-hello-done = SSL, ত্রুটিপূর্ণ Server Hello Done হ্যান্ডশেক বার্তা গ্রহণ করেছে।
ssl-error-rx-malformed-cert-verify = SSL, ত্রুটিপূর্ণ Certificate Verify হ্যান্ডশেক বার্তা গ্রহণ করেছে।
ssl-error-rx-malformed-client-key-exch = SSL, ত্রুটিপূর্ণ Client Key Exchange হ্যান্ডশেক বার্তা গ্রহণ করেছে।
ssl-error-rx-malformed-finished = SSL, ত্রুটিপূর্ণ Finished হ্যান্ডশেক বার্তা গ্রহণ করেছে।
ssl-error-rx-malformed-change-cipher = SSL, ত্রুটিপূর্ণ Change Cipher Spec রেকর্ড গ্রহণ করেছে।
ssl-error-rx-malformed-alert = SSL, ত্রুটিপূর্ণ Alert রেকর্ড গ্রহণ করেছে।
ssl-error-rx-malformed-handshake = SSL, ত্রুটিপূর্ণ হ্যান্ডশেক রেকর্ড গ্রহণ করেছে।
ssl-error-rx-malformed-application-data = SSL, ত্রুটিপূর্ণ Application Data রেকর্ড গ্রহণ করেছে।
ssl-error-rx-unexpected-hello-request = SSL, অপ্রত্যাশিত Hello Request হ্যান্ডশেক বার্তা গ্রহণ করেছে।
ssl-error-rx-unexpected-client-hello = SSL, অপ্রত্যাশিত Client Hello হ্যান্ডশেক বার্তা গ্রহণ করেছে।
ssl-error-rx-unexpected-server-hello = SSL, অপ্রত্যাশিত Server Hello হ্যান্ডশেক বার্তা গ্রহণ করেছে।
ssl-error-rx-unexpected-certificate = SSL, অপ্রত্যাশিত Certificate হ্যান্ডশেক বার্তা গ্রহণ করেছে।
ssl-error-rx-unexpected-server-key-exch = SSL, অপ্রত্যাশিত Server Key Exchange হ্যান্ডশেক বার্তা গ্রহণ করেছে।
ssl-error-rx-unexpected-cert-request = SSL, অপ্রত্যাশিত Certificate Request হ্যান্ডশেক বার্তা গ্রহণ করেছে।
ssl-error-rx-unexpected-hello-done = SSL, অপ্রত্যাশিত Server Hello Done হ্যান্ডশেক বার্তা গ্রহণ করেছে।
ssl-error-rx-unexpected-cert-verify = SSL, অপ্রত্যাশিত Certificate Verify হ্যান্ডশেক বার্তা গ্রহণ করেছে।
ssl-error-rx-unexpected-client-key-exch = SSL, অপ্রত্যাশিত Client Key Exchange হ্যান্ডশেক বার্তা গ্রহণ করেছে।
ssl-error-rx-unexpected-finished = SSL, অপ্রত্যাশিত Finished হ্যান্ডশেক বার্তা গ্রহণ করেছে।
ssl-error-rx-unexpected-change-cipher = SSL, অপ্রত্যাশিত Change Cipher Spec রেকর্ড গ্রহণ করেছে।
ssl-error-rx-unexpected-alert = SSL, অপ্রত্যাশিত Alert রেকর্ড গ্রহণ করেছে।
ssl-error-rx-unexpected-handshake = SSL, অপ্রত্যাশিত হ্যান্ডশেক রেকর্ড গ্রহণ করেছে।
ssl-error-rx-unexpected-application-data = SSL, অপ্রত্যাশিত Application Data রেকর্ড গ্রহণ করেছে।
ssl-error-rx-unknown-record-type = SSL, অজানা প্রকৃতির কন্টেন্ট সহ একটি রেকর্ড গ্রহণ করেছে।
ssl-error-rx-unknown-handshake = SSL, অজানা প্রকৃতির বার্তা সহ একটি হ্যান্ডশেক বার্তা গ্রহণ করেছে।
ssl-error-rx-unknown-alert = SSL, অজানা প্রকৃতির সতর্কবার্তার বিবরণ সহ একটি সতর্কতা রেকর্ড গ্রহণ করেছে।
ssl-error-close-notify-alert = পিয়ার SSL দ্বারা এই সংযোগ বন্ধ করা হয়েছে।
ssl-error-handshake-unexpected-alert = পিয়ার SSL দ্বারা প্রাপ্ত হ্যান্ডশেক বার্তা প্রত্যাশিত ছিল না।
ssl-error-decompression-failure-alert = পিয়ার SSL দ্বারা প্রাপ্ত SSL রেকর্ড সাফল্যের সাথে ডিকমপ্রেস করা সম্ভব হয়নি।
ssl-error-handshake-failure-alert = পিয়ার SSL দ্বারা একটি গ্রহণযোগ্য নিরাপত্তা প্যারামিটার সংকলনে একমত হওয়া সম্ভব হয়নি।
ssl-error-illegal-parameter-alert = আপত্তিজনক কন্টেন্টের কারণে পিয়ার SSL দ্বারা একটি হ্যান্ডশেক বার্তা প্রত্যাখ্যান করা হয়েছে।
ssl-error-unsupported-cert-alert = প্রাপ্ত সার্টিফিকেটের ধরণ পিয়ার SSL দ্বারা সমর্থিত নয়।
ssl-error-certificate-unknown-alert = পিয়ার SSL দ্বারা প্রাপ্ত সার্টিফিকেট সম্পর্কে অনির্দিষ্ট সমস্যা দেখা দিয়েছে।
ssl-error-generate-random-failure = SSL এর এলোমেলো সংখ্যা নির্মাণ ব্যবস্থায় ব্যর্থতা দেখা দিয়েছে।
ssl-error-sign-hashes-failure = আপনার সার্টিফিকেট যাচাই করার জন্য প্রয়োজনীয় ডাটা ডিজিটাল স্বাক্ষর করতে ব্যর্থ।
ssl-error-extract-public-key-failure = পিয়ার এর সার্টিফিকেট থেকে পাবলিক কী বের করতে ব্যর্থ হয়েছে SSL।
ssl-error-server-key-exchange-failure = SSL Server Key Exchange হ্যান্ড-শেল প্রক্রিয়াকরণে অনির্দিষ্ট কারণে ব্যর্থ হয়েছে।
ssl-error-client-key-exchange-failure = SSL Client Key Exchange হ্যান্ডশেক প্রক্রিয়াকরণ অনির্দিষ্ট কারণে ব্যর্থ হয়েছে।
ssl-error-encryption-failure = নির্বাচিত সাইফার স্যুটের মধ্যে বৃহৎ পরিমানের তথ্য এনক্রিপশনের এলগরিদম ব্যর্থ হয়েছে।
ssl-error-decryption-failure = নির্বাচিত সাইফার স্যুটের মধ্যে বৃহৎ পরিমানের তথ্য ডিক্রিপশনের এলগরিদম বিফল হয়েছে।
ssl-error-socket-write-failure = নিম্নবর্তী সকেটের মধ্যে এনক্রিপ্ট করা তথ্য লিখতে ব্যর্থ।
ssl-error-md5-digest-failure = MD5 ডাইজেস্ট ফাংশন বিফল।
ssl-error-sha-digest-failure = SHA-1 ডাইজেস্ট ফাংশন বিফল।
ssl-error-mac-computation-failure = MAC কম্পিউটেশন বিফল।
ssl-error-sym-key-context-failure = Symmetric Key কনটেক্সট তৈরি করতে অসফল
ssl-error-sym-key-unwrap-failure = ক্লায়েন্ট কী বিনিময় বার্তার এর মধ্যে সিমেট্রিক কী বের করতে অসফল।
ssl-error-pub-key-size-limit-exceeded = SSL সার্ভার এক্সপোর্ট সাইফার স্যুট এর সাথে ডোমেস্টিক-গ্রেড পাবলিক কী ব্যবহার করার চেষ্টা করেছে।
ssl-error-iv-param-failure = PKCS11 কোড দ্বারা IV-কে param-এ পরিবর্তন করা সম্ভব হয়নি।
ssl-error-init-cipher-suite-failure = নির্বাচিত সাইফার স্যুট আরম্ভ করতে ব্যর্থ।
ssl-error-session-key-gen-failure = SSL সেশানের জন্য ক্লায়েন্ট দ্বারা সেশন কী তৈরি করা যায়নি।
ssl-error-no-server-key-for-alg = চেষ্টারত কী এক্সচেঞ্জ এলগরিদম এর জন্য সার্ভারের কাছে কোনো কী নেই।
ssl-error-token-insertion-removal = কাজ করার সময়ে PKCS#11 টোকেন প্রবেশ অথবা বের করা হয়েছিল।
ssl-error-token-slot-not-found = আবশ্যক কর্ম সঞ্চালনের জন্য কোনো PKCS#11 টোকেন পাওয়া যায়নি।
ssl-error-no-compression-overlap = পিয়ারের সাথে নিরাপদভাবে যোগাযোগ করা সম্ভব নয়: কোনো সাধারণ কমপ্রেশন এলগরিদম নেই।
ssl-error-handshake-not-completed = বর্তমান হ্যান্ডশেক সমাপ্ত না হওয়া অবধি পৃথক SSL হ্যান্ডশেক আরম্ভ করা সম্ভব নয়।
ssl-error-bad-handshake-hash-value = পিয়ার থেকে হ্যান্ডশেক হ্যাশের ভুল মান গ্রহণ করেছে।
ssl-error-cert-kea-mismatch = নির্বাচিত কী বিনিময়ের অ্যালগরিদমের জন্য প্রদত্ত সার্টিফিকেট ব্যবহার করা সম্ভব নয়।
ssl-error-no-trusted-ssl-client-ca = SSL ক্লায়েন্টের অনুমোদনের জন্য কোনো বিশ্বস্ত সার্টিফিকেট কর্তৃপক্ষ উপস্থিত নেই।
ssl-error-session-not-found = সার্ভারের সেশন ক্যাশের মধ্যে ক্লায়েন্টের SSL সেশন ID পাওয়া যায়নি।
ssl-error-decryption-failed-alert = পিয়ার দ্বারা প্রাপ্ত SSL রেকর্ড ডিক্রিপ্ট করা সম্ভব হয়নি।
ssl-error-record-overflow-alert = অনুমোদিত পরিমানের থেকে বেশি SSL রেকর্ড পিয়ার গ্রহণ করেছে।
ssl-error-unknown-ca-alert = আপনার সার্টিফিকেট নির্মাণকারী সার্টিফিকেট কর্তৃপক্ষ, পিয়ারের অপরিচিত ও এটি বিশ্বস্ত নয়।
ssl-error-access-denied-alert = পিয়ার কার্যকর সার্টিফিকেট পেলেও একে ব্যবহারাধিকার প্রদান করা হয়নি।
ssl-error-decode-error-alert = পিয়ার একটি SSL হ্যান্ডশেক বার্তা ডিকোড করতে পারেনি।
ssl-error-decrypt-error-alert = পিয়ার স্বাক্ষর যাচাই অথবা কী বিনিময়ের ব্যর্থতা সম্পর্কে রিপোর্ট করে।
ssl-error-export-restriction-alert = এক্সপোর্টের নিয়ম বহির্ভুত মীমাংসা পিয়ার দ্বারা রিপোর্ট করা হয়েছে।
ssl-error-protocol-version-alert = পিয়ার দ্বারা অসংগত অথবা অসমর্থিত প্রোটোকল সংস্করণ সম্পর্কে রিপোর্ট করা হয়েছে।
ssl-error-insufficient-security-alert = ক্লায়েন্ট দ্বারা সমর্থিত সাইফারের তুলনায় অধিক নিরাপদ সাইফার সার্ভারের প্রয়োজন।
ssl-error-internal-error-alert = পিয়ার দ্বারা একটি অভ্যন্তরীণ ত্রুটির সূচনা প্রদান করা হয়েছে।
ssl-error-user-canceled-alert = পিয়ার ব্যবহারকারী দ্বারা হ্যান্ডশেক বাতিল করা হয়েছে।
ssl-error-no-renegotiation-alert = পিয়ার দ্বারা SSL নিরাপত্তা প্যারামিটারের পুনরায় মীমাংসার অনুমতি প্রদান করা হয় না।
ssl-error-server-cache-not-configured = চিহ্নিত সকেটের জন্য SSL সার্ভার ক্যাশে কনফিগার ও নিষ্ক্রিয় করা হয়নি।
ssl-error-unsupported-extension-alert = অনুরোধ করা TLS এক্সটেনশন, পিয়ার SSL দ্বারা সমর্থিত হয় না।
ssl-error-certificate-unobtainable-alert = প্রদত্ত URL থেকে পিয়ার SSL দ্বারা আপনার সার্টিফিকেট গ্রহণ করা সম্ভব হয়নি।
ssl-error-unrecognized-name-alert = অনুরোধকৃত DNS-র নামের জন্য পিয়ার SSL-র কোনো সার্টিফিকেট উপস্থিত নেই।
ssl-error-bad-cert-status-response-alert = পিয়ার SSL দ্বারা নিজের সার্টিফিকেটের জন্য একটি OCSP প্রতিক্রিয়া গ্রহণ সম্ভব হয়নি।
ssl-error-bad-cert-hash-value-alert = পিয়ার SSL দ্বারা সার্টিফিকেট হ্যাশের ভুল মান সম্পর্কে রিপোর্ট করা হয়েছে।
ssl-error-rx-unexpected-new-session-ticket = একটি অপ্রত্যাশিত নতুন সেশন টিকেট হ্যান্ডসেক বার্তা SSL গ্রহণ করেছে।
ssl-error-rx-malformed-new-session-ticket = একটি বিকৃত নতুন সেশন টিকেট হ্যান্ডসেক বার্তা SSL গ্রহণ করেছে।
ssl-error-decompression-failure = SSL একটি সংকোচিত রেকর্ড গ্রহণ করেছে যা প্রসারিত করা যাবেনা।
ssl-error-renegotiation-not-allowed = SSL সকেটে পুনরায় নেগোসিয়েশন করার অনুমোদন নেই।
ssl-error-unsafe-negotiation = পিয়ার পুরনো শৈলী (সম্ভবত অরক্ষিত) হ্যান্ডসেক প্রচেষ্টা করে।
ssl-error-rx-unexpected-uncompressed-record = SSL একটি অপ্রত্যাশিত অসংকোচিত রেকর্ড গ্রহণ করেছে।
ssl-error-weak-server-ephemeral-dh-key = সার্ভার কী বিনিময় কর্মরদন বার্তায় SSL একটি দুর্বল সল্পস্থায়ী ডিফি-হেলম্যান কী গ্রহণ করেছে।
ssl-error-next-protocol-data-invalid = SSL অবৈধ NPN এক্সটেনশন এর তথ্য পেয়েছে।
ssl-error-feature-not-supported-for-ssl2 = SSL 2.0 সংস্করণের সংযোগ SSL বৈশিষ্ট্যে সমর্থিত নয়।
ssl-error-feature-not-supported-for-servers = সার্ভারের জন্য SSL এর বৈশিষ্ট্য সমর্থিত নয়।
ssl-error-feature-not-supported-for-clients = ক্লায়েন্টদের জন্য SSL এর বৈশিষ্ট্য সমর্থিত নয়।
ssl-error-invalid-version-range = SSL সংস্করণ পরিসর বৈধ নয়।
ssl-error-cipher-disallowed-for-version = SSL- র পিয়ার নির্বাচিত প্রোটোকল সংস্করণ জন্য অননুমোদিত একটি সাইফার স্যুট নির্বাচন করেছেন.
ssl-error-rx-malformed-hello-verify-request = SSL ত্রুটিপূর্ণ Hello Request হ্যান্ডশেক বার্তা গ্রহণ করেছে।
ssl-error-rx-unexpected-hello-verify-request = SSL, অপ্রত্যাশিত Hello Request হ্যান্ডশেক বার্তা গ্রহণ করেছে।
ssl-error-feature-not-supported-for-version = SSL- র বৈশিষ্ট্য প্রোটোকল সংস্করণ জন্য সমর্থিত নয়।
ssl-error-rx-unexpected-cert-status = SSL, অপ্রত্যাশিত Certificate Request হ্যান্ডশেক বার্তা গ্রহণ করেছে।
ssl-error-unsupported-hash-algorithm = TLS সমর্থন পিয়ার ব্যবহৃত অসমর্থিত হ্যাশ অ্যালগরিদম।
ssl-error-digest-failure = ডাইজেস্ট ফাংশন বিফল।
ssl-error-incorrect-signature-algorithm = একটি ডিজিটালরূপে স্বাক্ষরিত উপাদান উল্লিখিত ভুল স্বাক্ষর অ্যালগরিদম।
ssl-error-next-protocol-no-callback = পরবর্তী প্রোটোকল আপস এক্সটেনশন সক্রিয় করা হত, কিন্তু কলব্যাক পূর্বে প্রয়োজন হচ্ছে সাফ করা হয়েছিল।
ssl-error-next-protocol-no-protocol = সার্ভার ক্লায়েন্ট ALPN এক্সটেনশন advertises যে কোন প্রোটোকল সমর্থন করে।
ssl-error-inappropriate-fallback-alert = ক্লায়েন্ট এবং সার্ভার সমর্থন কম TLS সংস্করণে পর্যবসিত কারণ সার্ভার হ্যান্ডশেক প্রত্যাখ্যাত।
ssl-error-weak-server-cert-key = সার্ভার শংসাপত্র খুব দুর্বল ছিল যে একটি পাবলিক কী অন্তর্ভুক্ত।
ssl-error-rx-short-dtls-read = DTLS রেকর্ড সঞ্চয় করার মত পর্যাপ্ত জায়গা নেই।
ssl-error-no-supported-signature-algorithm = কোন সমর্থিত TLS স্বাক্ষর আ্যলগরিদম কনফিগার করা হয়নি।
ssl-error-unsupported-signature-algorithm = পিয়ার একটি অসমর্থিত স্বাক্ষর এবং হ্যাস আ্যলগরিদমের সমাহার ব্যবহার করেছে ।
ssl-error-missing-extended-master-secret = একটি সঠিক extended_master_secret extension ছাড়া পিয়ার পুনরায় সচল করার চেষ্টা করেছিল।
ssl-error-unexpected-extended-master-secret = একটি অপ্রত্যাশিত extended_master_secret extension সহ পিয়ার পুনরায় সচল করার চেষ্টা করেছিল।

sec-error-io = নিরাপত্তামূলক অনুমোদনের সময় ইনপুট/আউটপুট ত্রুটি দেখা দিয়েছে।
sec-error-library-failure = নিরাপত্তা লাইব্রেরির বিফলতা।
sec-error-bad-data = নিরাপত্তা লাইব্রেরি: ত্রুটিপূর্ণ তথ্য গ্রহণ।
sec-error-output-len = নিরাপত্তা লাইব্রেরি: ফলাফলের দৈঘ্য সংক্রান্ত ত্রুটি।
sec-error-input-len = নিরাপত্তা লাইব্রেরি, ইনপুটের দৈর্ঘ্য সম্পর্কিত ত্রুটির সম্মুখীন হয়েছে।
sec-error-invalid-args = নিরাপত্তা লাইব্রেরি: অকার্যকর আর্গুমেন্ট।
sec-error-invalid-algorithm = নিরাপত্তা লাইব্রেরি: অকার্যকর এলগরিদম।
sec-error-invalid-ava = নিরাপত্তা লাইব্রেরি: অকার্যকর AVA।
sec-error-invalid-time = সময় প্রদর্শনের স্ট্রিং বিন্যাস সঠিক নয়।
sec-error-bad-der = নিরাপত্তা লাইব্রেরি: DER-এনকোড করা বার্তার বিন্যাস সঠিক নয়।
sec-error-bad-signature = পিয়ারের সার্টিফিকেটের মধ্যে অকার্যকর স্বাক্ষর বিদ্যমান।
sec-error-expired-certificate = পিয়ারের সার্টিফিকেটের মেয়াদ উত্তীর্ণ হয়ে গেছে।
sec-error-revoked-certificate = পিয়ারের সার্টিফিকেট বাতিল হয়ে গেছে।
sec-error-unknown-issuer = পিয়ারের সার্টিফিকেট নির্মাণকারী পরিচিত নয়।
sec-error-bad-key = পিয়ারের পাবলিক কী কার্যকর নয়।
sec-error-bad-password = উল্লেখিত নিরাপত্তামূলক পাসওয়ার্ড সঠিক নয়।
sec-error-retry-password = নতুন পাসওয়ার্ড সঠিকভাবে লেখা হয়নি। অনুগ্রহ করে পুনরায় চেষ্টা করুন।
sec-error-no-nodelock = নিরাপত্তাবিষয়ক লাইব্রেরি: কোনো nodelock নেই।
sec-error-bad-database = নিরাপত্তাবিষয়ক লাইব্রেরি: ত্রুটিপূর্ণ ডাটাবেস।
sec-error-no-memory = নিরাপত্তাবিষয়ক লাইব্রেরি: মেমরি বরাদ্দকরণে ব্যর্থতা।
sec-error-untrusted-issuer = পিয়ারের সার্টিফিকেট নির্মাণকারীকে ব্যবহারকারী দ্বারা বিশ্বস্ত ধার্য করা হয়নি।
sec-error-untrusted-cert = পিয়ারের সার্টিফিকেটকে ব্যবহারকারী দ্বারা বিশ্বস্ত ধার্য করা হয়নি।
sec-error-duplicate-cert = আপনার ডাটাবেসের মধ্যে সার্টিফিকেট বর্তমানে বিদ্যমান।
sec-error-duplicate-cert-name = ডাউনলোড করা সার্টিফকেটের নাম, ডাটাবেসে বর্তমানে উপস্থিত একটি সার্টিফিকেটের নামের অনুরূপ।
sec-error-adding-cert = ডাটাবেসের মধ্যে সার্টিফিকেট যোগ করতে ত্রুটি।
sec-error-filing-key = চিহ্নিত সার্টিফিকেটের কী পুনরায় যোগ করতে ত্রুটি।
sec-error-no-key = চিহ্নিত সার্টিফিকেটের প্রাইভেট কী এই কী ডাটাবেসের মধ্যে পাওয়া যায়নি।
sec-error-cert-valid = চিহ্নিত সার্টিফিকেটটি কার্যকর।
sec-error-cert-not-valid = চিহ্নিত সার্টিফিকেটটি অকার্যকর।
sec-error-cert-no-response = Cert Library: প্রত্যুত্তর নেই
sec-error-expired-issuer-certificate = সার্টিফিকেট নির্মাণকারীর সার্টিফিকেটের মেয়াদ উত্তীর্ণ হয়ে গেছে। অনুগ্রহ করে সিস্টেমের তারিখ ও সময় পরীক্ষা করুন।
sec-error-crl-expired = সার্টিফিকেট নির্মাণকারীর CRL-র মেয়াদ উত্তীর্ণ হয়ে গেছে। অনুগ্রহ করে এটি হালনাগাদ করুন অথবা সিস্টেমের তারিখ ও সময় পরীক্ষা করুন।
sec-error-crl-bad-signature = সার্টিফিকেট নির্মাণকারীর CRL-এ অকার্যকর স্বাক্ষর বিদ্যমান।
sec-error-crl-invalid = নতুন CRL-এ ব্যবহৃত বিন্যাস সঠিক নয়।
sec-error-extension-value-invalid = সার্টিফিকেটের এক্সটেনশনের মান কার্যকর নয়।
sec-error-extension-not-found = সার্টিফিকেটের এক্সটেনশন পাওয়া যায়নি।
sec-error-ca-cert-invalid = সার্টিফিকেট নির্মাণকারীর সার্টিফিকেট কার্যকর নয়।
sec-error-path-len-constraint-invalid = সার্টিফিকেটের পাথের দৈর্ঘ্যের সীমা কার্যকর নয়।
sec-error-cert-usages-invalid = সার্টিফিকেটের ব্যবহার নির্দেশকারী ক্ষেত্র কার্যকর নয়।
sec-internal-only = **শুধুমাত্র অভ্যন্তরীণ মডিউল**
sec-error-invalid-key = অনুরোধকৃত কাজের জন্য এই কী-র ব্যবহার সমর্থিত নয়।
sec-error-unknown-critical-extension = সার্টিফিকেটের মধ্যে গুরুত্বপূর্ণ অজানা এক্সটেনশন বিদ্যমান।
sec-error-old-crl = বর্তমান CRL-টি নতুন CRL থেকে পুরোনো নয়।
sec-error-no-email-cert = এনক্রিপশন ও স্বাক্ষর বিহীন: আপনার কোনো ইমেইল সার্টিফিকেট নেই।
sec-error-no-recipient-certs-query = এনক্রিপশন বিহীন: প্রত্যেক প্রাপকের জন্য আপনার কাছে সার্টিফিকেট উপস্থিত নেই।
sec-error-not-a-recipient = ডিক্রিপ্ট করা সম্ভব নয়: আপনি সম্ভবত প্রাপক নন, অথবা সুসংগত সার্টিফিকেট ও প্রাইভেট কী পাওয়া যায়নি।
sec-error-pkcs7-keyalg-mismatch = ডিক্রিপ্ট করা সম্ভব নয়: কী এনক্রিপশন এলগরিদম আপনার সার্টিফিকেট এর সাথে খাপ খায় না।
sec-error-pkcs7-bad-signature = স্বাক্ষর যাচাই ব্যর্থ: কোনো স্বাক্ষরকারী পাওয়া যায়নি, অতিরিক্ত স্বাক্ষরকারী পাওয়া গিয়েছে, অথবা অনুপযুক্ত বা নষ্ট ডাটা।
sec-error-unsupported-keyalg = অসমর্থিত বা অজানা কী এলগরিদম।
sec-error-decryption-disallowed = ডিক্রিপ্ট করা সম্ভব নয়: এনক্রিপশন করা হয়েছে অননুমোদিত এলগরিদম বা কী-আকার ব্যবহার করে।
sec-error-no-krl = এই সাইট থেকে প্রাপ্ত সার্টিফিকেট এর জন্য কোনো KRL পাওয়া যায়নি।
sec-error-krl-expired = এই সাইট থেকে প্রাপ্ত সার্টিফিকেট এর KRL মেয়াদোত্তীর্ণ হয়ে গিয়েছে।
sec-error-krl-bad-signature = এই সাইট থেকে প্রাপ্ত সার্টিফিকেট এর KRL এ একটি অকার্যকর স্বাক্ষর আছে।
sec-error-revoked-key = এই সাইট এর সার্টিফিকেট এর কী প্রত্যাহার করা হয়েছে।
sec-error-krl-invalid = নতুন KRL এর ফরম্যাট অকার্যকর।
sec-error-need-random = নিরাপত্তাবিষয়ক লাইব্রেরি: এলোমেলো ডাটা প্রয়োজন।
sec-error-no-module = নিরাপত্তাবিষয়ক লাইব্রেরি: অনুরোধকৃত কাজটি কোনো সিকিউরিটি মডিউল দিয়ে করা সম্ভব নয়।
sec-error-no-token = সিকিউরিটি কার্ড বা টোকেন উপস্থিত নেই, এটি শুরু করতে হবে, বা মুছে ফেলা হয়েছে।
sec-error-read-only = নিরাপত্তাবিষয়ক লাইব্রেরি: শুধু পাঠযোগ্য ডাটাবেস।
sec-error-no-slot-selected = কোনো স্লট বা টোকেন নির্বাচন করা হয়নি।
sec-error-cert-nickname-collision = একই নামসহ আরেকটি সার্টিফিকেট বর্তমানে উপস্থিত আছে।
sec-error-key-nickname-collision = একই নামসহ আরেকটি কী বর্তমানে উপস্থিত আছে।
sec-error-safe-not-created = নিরাপদ অবজেক্ট তৈরি করার সময় ত্রুটি হয়েছে
sec-error-baggage-not-created = ব্যাগেজ অবজেক্ট তৈরি করার সময় ত্রুটি হয়েছে
sec-error-bad-export-algorithm = প্রয়োজনীয় এলগরিদম অননুমোদিত।
sec-error-exporting-certificates = সার্টিফিকেট এক্সপোর্টে ত্রুটি।
sec-error-importing-certificates = সার্টিফিকেট ইমপোর্টে ত্রুটি।
sec-error-pkcs12-decoding-pfx = ইমপোর্ট করতে ব্যর্থ। ডিকোডিং ত্রুটি। ফাইল কার্যকর নয়।
sec-error-pkcs12-invalid-mac = ইমপোর্ট করতে ব্যর্থ। অকার্যকর MAC। ভুল পাসওয়ার্ড বা নষ্ট ফাইল।
sec-error-pkcs12-unsupported-mac-algorithm = ইমপোর্ট করতে ব্যর্থ। MAC এলগরিদম সমর্থিত নয়।
sec-error-pkcs12-unsupported-transport-mode = ইমপোর্ট করতে ব্যর্থ। শুধুমাত্র পাসওয়ার্ডের অখন্ডতা এবং ব্যক্তিগত মোড সমর্থিত।
sec-error-pkcs12-corrupt-pfx-structure = ইমপোর্ট করতে ব্যর্থ। ফাইল কাঠামো বিকৃত।
sec-error-pkcs12-unsupported-pbe-algorithm = ইমপোর্ট করতে ব্যর্থ। এনক্রিপশন এলগরিদম সমর্থিত নয়।
sec-error-pkcs12-unsupported-version = ইমপোর্ট করতে ব্যর্থ। ফাইল সংস্করণ সমর্থিত নয়।
sec-error-pkcs12-privacy-password-incorrect = ইমপোর্ট করতে ব্যর্থ। ভুল ব্যক্তিগত পাসওয়ার্ড।
sec-error-pkcs12-cert-collision = ইমপোর্ট করতে ব্যর্থ। একই ডাকনাম ডাটাবেসে উপস্থিত।
sec-error-user-cancelled = ব্যবহারকারী বাতিল চেপেছেন।
sec-error-pkcs12-duplicate-data = ইমপোর্ট করা হয়নি, ডাটাবেসে আগে থেকেই বিদ্যমান।
sec-error-message-send-aborted = বার্তা পাঠানো হয়নি।
sec-error-inadequate-key-usage = চেষ্টারত অপারেশনের জন্য অপ্রতুল সার্টিফিকেট কী এর ব্যবহার।
sec-error-inadequate-cert-type = অ্যাপ্লিকেশনের জন্য সার্টিফিকেটের ধরন অনুমোদিত নয়।
sec-error-cert-addr-mismatch = সাক্ষরিত সার্টিফিকেটের ঠিকানার সাথে বার্তার শিরোনামে উল্লেখিত ঠিকানা মেলেনি।
sec-error-pkcs12-unable-to-import-key = ইমপোর্ট করতে ব্যর্থ। ব্যক্তিগত কী ইমপোর্ট করতে ত্রুটি।
sec-error-pkcs12-importing-cert-chain = ইমপোর্ট করতে ব্যর্থ। সার্টিফিকেট চেইন ইমপোর্ট করতে ত্রুটি।
sec-error-pkcs12-unable-to-locate-object-by-name = এক্সপোর্ট করতে ব্যর্থ। ডাকনাম দ্বারা সার্টিফিকেট বা কী খুঁজে পেতে ব্যর্থ।
sec-error-pkcs12-unable-to-export-key = এক্সপোর্ট করতে ব্যর্থ। ব্যক্তিগত কী চিহ্নিত এবং এক্সপোর্ট করতে ব্যর্থ।
sec-error-pkcs12-unable-to-write = এক্সপোর্ট করতে ব্যর্থ। এক্সপোর্ট ফাইল লিখতে ব্যর্থ।
sec-error-pkcs12-unable-to-read = ইমপোর্ট করতে ব্যর্থ। ইমপোর্ট ফাইল পড়তে ব্যর্থ।
sec-error-pkcs12-key-database-not-initialized = এক্সপোর্ট করতে ব্যর্থ। কী ডাটাবেস নষ্ট বা মুছে ফেলা হয়েছে।
sec-error-keygen-fail = পাবলিক/প্রাইভেট কী জোড়া তৈরি করতে ব্যর্থ।
sec-error-invalid-password = প্রবেশকৃত পাসওয়ার্ডটি অবৈধ। অনুগ্রহ করে আরেকটি নির্বাচন করুন।
sec-error-retry-old-password = আগের পাসওয়ার্ড ভুলভাবে প্রবেশ করানো হয়েছে। অনুগ্রহ করে আবার চেষ্টা করুন।
sec-error-bad-nickname = সার্টিফিকেটের ডাকনাম আগে থেকেই ব্যবহৃত হচ্ছে।
sec-error-not-fortezza-issuer = পিয়ার FORTEZZA চেইনের একটি non-FORTEZZA সার্টিফিকেট রয়েছে।
sec-error-cannot-move-sensitive-key = একটি সংবেদনশীল কী প্রয়োজনীয় স্লটে সরানো যায়নি।
sec-error-js-invalid-module-name = অকার্যকর মডিউল নাম।
sec-error-js-invalid-dll = অকার্যকর মডিউল পাথ/ফাইলনাম
sec-error-js-add-mod-failure = মডিউল যোগ করতে ব্যর্থ
sec-error-js-del-mod-failure = মডিউল মুছে ফেলতে ব্যর্থ
sec-error-old-krl = নতুন KRL টি বর্তমানের চেয়ে নতুন নয়।
sec-error-ckl-conflict = নতুন CKL এর বর্তমান CKL এর চেয়ে আলাদা ইস্যুকারী রয়েছে। বর্তমান CKL মুছে ফেলুন।
sec-error-cert-not-in-name-space = এই সার্টিফিকেটের জন্য সার্টিফিকেট কর্তৃপক্ষ এই নামে কোনো সার্টিফিকেট ইস্যু করতে অনুমোদিত নয়।
sec-error-krl-not-yet-valid = এই সার্টিফিকেটের জন্য কী প্রত্যাহার তালিকা এখনও কার্যকর নয়।
sec-error-crl-not-yet-valid = এই সার্টিফিকেটের জন্য সার্টিফিকেট প্রত্যাহার তালিকা এখনও কার্যকর নয়।
sec-error-unknown-cert = অনুরোধকৃত সার্টিফিকেট পাওয়া যায়নি।
sec-error-unknown-signer = সাক্ষরকারীর সার্টিফিকেট পাওয়া যায়নি।
sec-error-cert-bad-access-location = সার্টিফিকেট স্ট্যাটাস সার্ভারের অবস্থান অকার্যকর বিন্যাসে আছে।
sec-error-ocsp-unknown-response-type = OCSP উত্তরটি পুরোপুরি ডিকোড করা যায়নি; এটি অজানা ধরনের।
sec-error-ocsp-bad-http-response = OCSP সার্ভার অপ্রত্যাশিত/অকার্যকর HTTP ডাটা প্রেরণ করেছে।
sec-error-ocsp-malformed-request = OCSP সার্ভার দ্বারা অনুরোধটি নষ্ট বা অনুপযুক্ত হিসেবে চিহ্নিত হয়েছে।
sec-error-ocsp-server-error = OCSP সার্ভার একটি অভ্যন্তরীন ত্রুটির সম্মুখীন হয়েছে।
sec-error-ocsp-try-server-later = OCSP সার্ভার পরবর্তীতে আবার চেষ্টা করার পরামর্শ দিচ্ছে।
sec-error-ocsp-request-needs-sig = OCSP সার্ভার এই অনুরোধটিতে একটি সাক্ষর চাচ্ছে।
sec-error-ocsp-unauthorized-request = OCSP সার্ভার এই অনুরোধটিকে অননুমোদিত হিসেবে প্রত্যাখ্যান করেছে।
sec-error-ocsp-unknown-response-status = OCSP সার্ভার একটি অচেনা অবস্থা পাঠিয়েছে।
sec-error-ocsp-unknown-cert = OCSP সার্ভারের এই সার্টিফিকেটের জন্য কোনো অবস্থা নেই।
sec-error-ocsp-not-enabled = এই অপারেশন শুরু করার পূর্বে আপনার অবশ্যই OCSP সক্রিয় করতে হবে।
sec-error-ocsp-no-default-responder = এই অপারেশন শুরু করার পূর্বে আপনাকে অবশ্যই OCSP ডিফল্ট অবস্থা জ্ঞাপনকারী সেট করতে হবে।
sec-error-ocsp-malformed-response = OCSP সার্ভারের উত্তরটি বিকৃত বা অনুপোযুক্ত ছিলো।
sec-error-ocsp-unauthorized-response = OCSP উত্তর সাক্ষরকারী এই সার্টিফিকেটের অবস্থা দেয়ার জন্য অনুমোদিত নয়।
sec-error-ocsp-future-response = OCSP উত্তর এখনও সেট করা হয়নি (এতে ভবিষ্যতের তারিখ আছে)।
sec-error-ocsp-old-response = OCSP উত্তরটিতে বাতিল হওয়া তথ্য আছে।
sec-error-digest-not-found = সাক্ষরিত বার্তায় CMS বা PKCS #7 ডাইজেস্ট পাওয়া যায়নি।
sec-error-unsupported-message-type = CMS বা PKCS #7 বার্তার ধরণ অসমর্থিত।
sec-error-module-stuck = PKCS #11 মডিউলটি অপসারণ করা যায়নি কারন এটি এখনও ব্যবহৃত হচ্ছে।
sec-error-bad-template = ASN.1 ডাটা এক্সেস করা যায়নি। উল্লেখিত খসড়াটি অকার্যকর।
sec-error-crl-not-found = কোনো ম্যাচিং CRL পাওয়া যায়নি।
sec-error-reused-issuer-and-serial = আপনি বর্তমানে উপস্থিত cert এর ইস্যুকারী/সিরিয়ালসহ আরেকটি cert ইমপোর্ট করার চেষ্টা করছেন, কিন্তু এটি একই cert নয়।
sec-error-busy = NSS বন্ধ হতে পারেনি। অবজেক্টগুলি এখনও ব্যবহৃত হচ্ছে।
sec-error-extra-input = DER দ্বারা এনকোড করা বার্তাতে অতিরিক্ত অব্যবহৃত ডাটা ছিলো।
sec-error-unsupported-elliptic-curve = অসমর্থিত উপবৃত্তাকার বক্ররেখা।
sec-error-unsupported-ec-point-form = অসমর্থিত উপবৃত্তাকার বক্ররেখা পয়েন্ট ফর্ম।
sec-error-unrecognized-oid = অচেনা অবজেক্ট আইডেন্টিফায়ার।
sec-error-ocsp-invalid-signing-cert = OCSP উত্তরতে অকার্যকর OCSP সাক্ষরকারী সার্টিফিকেট।
sec-error-revoked-certificate-crl = ইস্যুকারী সার্টিফিকেট বাতিলের তালিকায় সার্টিফিকেট বাতিল করা হয়েছে।
sec-error-revoked-certificate-ocsp = ইস্যুকারীর OCSP উত্তরের রিপোর্ট সার্টিফিকেট বাতিল করা হয়েছে।
sec-error-crl-invalid-version = ইস্যুকারীর সার্টিফিকেট বাতিলের তালিকার সংস্করণ সংখ্যাটি অজানা।
sec-error-crl-v1-critical-extension = ইস্যুকারীর V1 সার্টিফিকেট বাতিলের তালিকার এক্সটেনশনটি জটিল।
sec-error-crl-unknown-critical-extension = ইস্যুকারীর V2 সার্টিফিকেট বাতিলের তালিকার এক্সটেনশনটি অজানা এবং জটিল।
sec-error-unknown-object-type = অজানা অবজেক্টের ধরন উল্লেখ করা হয়েছে।
sec-error-incompatible-pkcs11 = PKCS #11 ড্রাইভার স্পেককে একটি অসামঞ্জস্য উপায়ে ব্যাঘাত ঘটায়।
sec-error-no-event = এই মূহুর্তে কোনো নতুন স্লট ইভেন্ট নেই।
sec-error-crl-already-exists = CRL আগে থেকেই আছে।
sec-error-not-initialized = NSS শুরু করা হয়নি।
sec-error-token-not-logged-in = PKCS#11 টোকেন লগইন করা নেই বলে অপারেশনটি ব্যর্থ হয়েছে।
sec-error-ocsp-responder-cert-invalid = কনফিগার করা OCSP উত্তর প্রদানকারীর সার্টিফিকেটটি অকার্যকর।
sec-error-ocsp-bad-signature = OCSP উত্তরটিতে একটি অকার্যকর সাক্ষর আছে।
sec-error-out-of-search-limits = অনুসন্ধান সীমার বাইরে Cert কার্যকারীতা অনুসন্ধান
sec-error-invalid-policy-mapping = নীতিমালা মানচিত্র যেকোনো নীতিমালা ধারন করে
sec-error-policy-validation-failed = নীতিমালার কার্যকারীতা Cert চেইন এ ব্যর্থ
sec-error-unknown-aia-location-type = cert AIA বর্ধিতাংশে অবস্থানের ধরন অপরিচিত
sec-error-bad-http-response = সার্ভার একটি অপর্যাপ্ত HTTP প্রতিক্রিয়া প্রত্যাবর্তন করেছে
sec-error-bad-ldap-response = সার্ভার একটি অপর্যাপ্ত LDAP প্রতিক্রিয়া প্রত্যাবর্তন করেছে
sec-error-failed-to-encode-data = ASN1 এনকোডারের সাহায্যে ডাটা এনকোড করতে ব্যর্থ
sec-error-bad-info-access-location = cert বর্ধিতাংশে প্রবেশাধিকার অবস্থানের অপর্যাপ্ত তথ্য
sec-error-libpkix-internal = cert কার্যকরনের সময় Libpkix অভ্যন্তরীণ ত্রুটি হয়েছে।
sec-error-pkcs11-general-error = CKR_GENERAL_ERROR এ একটি PKCS #11 মডিউল প্রত্যাবর্তন করেছে, এটি পুনরুদ্ধার করা যায়না এরূপ ত্রুটি নির্দেশ করে।
sec-error-pkcs11-function-failed = CKR_FUNCTION_FAILED এ একটি PKCS #11 মডিউল প্রত্যাবর্তন করেছে, এটি নির্দেশ করে যে অনুরোধকৃত ফাংশনটি সম্পাদন করা যাবেনা। একই ওপারেশন আবার চেষ্টা করলে সফল হওয়া যাবে।
sec-error-pkcs11-device-error = CKR_DEVICE_ERROR এ একটি PKCS #11 মডিউল প্রত্যাবর্তন করেছে, এটি নির্দেশ করে যে টোকেন অথবা স্লট এর সাথে একটি সমস্যা হয়েছে।
sec-error-bad-info-access-method = সার্টিফিকেট বর্ধিতাংশে তথ্য প্রবেশাধিকার নিয়ম অজানা।
sec-error-crl-import-failed = CRL ইম্পোর্ট প্রচেষ্টায় ত্রুটি।
sec-error-expired-password = পাসওয়ার্ডের মেয়াদ শেষ।
sec-error-locked-password = পাসওয়ার্ড লক করা আছে।
sec-error-unknown-pkcs11-error = অজানা PKCS #11 ত্রুটি।
sec-error-bad-crl-dp-url = CRL ডিস্ট্রিবিউশন পয়েন্টের নামের মধ্যে অবৈধ বা অসমর্থিত URL।
sec-error-cert-signature-algorithm-disabled = সার্টিফিকেট একটি নিষ্ক্রিয় সিগনেচার অ্যালগরিদম ব্যবহার করে সাইন করেছে, যা পূর্বেই নিষ্ক্রিয় করা আছে, কারণ এটি নিরাপদ নয়।

mozilla-pkix-error-key-pinning-failure = সার্ভার কী পিন (HPKP) ব্যবহার করে কিন্তু কোন বিশ্বস্ত শংসাপত্র শৃঙ্খল pinset সাথে মিলে যায় যে নির্মাণ করা যেতে পারে. কী পিন লঙ্ঘনের উপেক্ষা করা যাবে না।
mozilla-pkix-error-ca-cert-used-as-end-entity = সার্ভার একটি সার্টিফিকেট অথোরিটি হিসাবে এটি চিহ্নিত একটি মৌলিক সীমাবদ্ধতা এক্সটেনশন সহ একটি সার্টিফিকেট ব্যবহার করে. একটি সঠিকভাবে জারি সার্টিফিকেটের জন্য, এই ক্ষেত্রে করা উচিত।
mozilla-pkix-error-inadequate-key-size = সার্ভার একটি নিরাপদ সংযোগ স্থাপন করার খুব ছোট যে কী আকার সঙ্গে একটি শংসাপত্র উপস্থাপন করেছে।
mozilla-pkix-error-v1-cert-used-as-ca = না একটি ট্রাস্ট নোঙ্গর যে একটি X.509 সংস্করণ 1 সার্টিফিকেট সার্ভারের শংসাপত্র প্রেরণ করা হয়. X.509 সংস্করণ 1 সার্টিফিকেট অবচিত হয়েছে এবং অন্যান্য সার্টিফিকেট সাইন ব্যবহার করা উচিত নয়।
mozilla-pkix-error-not-yet-valid-certificate = সার্ভার এখন পর্যন্ত বৈধ নয় যে একটি শংসাপত্র উপস্থাপন করেছে।
mozilla-pkix-error-not-yet-valid-issuer-certificate = এখন পর্যন্ত বৈধ নয় যে একটি সার্টিফিকেট সার্ভারের শংসাপত্র প্রেরণ করা হয়।
mozilla-pkix-error-signature-algorithm-mismatch = সার্টিফিকেটের স্বাক্ষর স্বাক্ষর ক্ষেত্রের অ্যালগরিদম তার signatureAlgorithm ক্ষেত্রের অ্যালগরিদম মেলে না।
mozilla-pkix-error-ocsp-response-for-cert-missing = OCSP টি প্রতিক্রিয়া সার্টিফিকেটের জন্য একটি অবস্থা যাচাই করা হচ্ছে অন্তর্ভুক্ত নয়।
mozilla-pkix-error-validity-too-long = সার্ভার খুব দীর্ঘ জন্য বৈধ নয় যে একটি শংসাপত্র উপস্থাপন করেছে।
mozilla-pkix-error-required-tls-feature-missing = প্রয়োজনীয় TLS ফিচার পাওয়া যায়নি
mozilla-pkix-error-invalid-integer-encoding = সার্ভার একটি সার্টিফিকেট উপস্থাপন করছে যাতে ইন্টিজারের একটি অকার্যকর এনকোডিং রয়েছে। সাধারণ কারণ হতে পারে ঋণাত্মক সিরিয়াল নাম্বার, ঋণাত্মক RSA moduli, এবং প্রয়োজনের চেয়ে লম্বা এনকোডিং।
mozilla-pkix-error-empty-issuer-name = সার্ভারটি এমন একটি সার্টিফিকেট উপস্থাপন করেছে, যেখানে আলাদা করে খালি ইস্যুকারীর নাম রয়েছে।
mozilla-pkix-error-additional-policy-constraint-failed = বাড়তি নীতি সীমা কারণে সার্টিফিকেটটির বৈধতা যাচাই করতে ব্যর্থ হয়েছে।
mozilla-pkix-error-self-signed-cert = সার্টিফিকেটটি বিশ্বস্ত নয় কারন সেটি নিজে সাইন হয়েছে।

xp-java-remove-principal-error = প্রিন্সিপাল মুছে ফেলা যায়নি
xp-java-delete-privilege-error = বিশেষাধিকার মুছে ফেলা যায়নি
xp-java-cert-not-exists-error = প্রিন্সিপালটির কোনো সার্টিফিকেট নেই

xp-sec-fortezza-bad-card = Fortezza কার্ড সঠিকভাবে শুরু করা হয়নি। অনুগ্রহ করে এটি মুছে ফেলুন এবং এটির ইস্যুকারীর কাছে ফেরত দিন।
xp-sec-fortezza-no-card = কোনো Fortezza কার্ড পাওয়া যায়নি
xp-sec-fortezza-none-selected = কোনো Fortezza কার্ড নির্বাচন করা হয়নি
xp-sec-fortezza-more-info = এই বিষয়ে আর জানার জন্য অনুগ্রহ করে নিজস্ব উপস্থাপনা শৈলী নির্বাচন করুন
xp-sec-fortezza-person-not-found = নিজস্ব উপস্থাপনা শৈলী পাওয়া যায়নি
xp-sec-fortezza-no-more-info = ঐ নিজস্ব উপস্থাপনা শৈলী সম্পর্কে আর কিছু জানা যায়নি
xp-sec-fortezza-bad-pin = অকার্যকর পিন
xp-sec-fortezza-person-error = Fortezza নিজস্ব উপস্থাপনা শৈলী চালু করা যায়নি।
