{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetDuration: TFloatTime;
    procedure SetDuration(const Value: TFloatTime);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdDuration: TSFTime;
    { Internal wrapper for property @link(Duration). This wrapper API may change, we advise to access simpler @link(Duration) instead. }
    public property FdDuration: TSFTime read FFdDuration;
    {  }
    property Duration: TFloatTime read GetDuration write SetDuration;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractChaserNode ----------------------------------------------- }

function TAbstractChaserNode.GetDuration: TFloatTime;
begin
  Result := FdDuration.Value;
end;

procedure TAbstractChaserNode.SetDuration(const Value: TFloatTime);
begin
  FdDuration.Send(Value);
end;

class function TAbstractChaserNode.ClassX3DType: String;
begin
  Result := 'X3DChaserNode';
end;

procedure TAbstractChaserNode.CreateNode;
begin
  inherited;

  FFdDuration := TSFTime.Create(Self, False, 'duration', 0);
   FdDuration.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDuration);
end;

{$endif read_implementation}
