{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetPickingGeometry: TAbstractGeometryNode;
    procedure SetPickingGeometry(const Value: TAbstractGeometryNode);
    function GetIntersectionType: TPickSensorIntersectionType;
    procedure SetIntersectionType(const Value: TPickSensorIntersectionType);
    function GetSortOrder: TPickSensorRange;
    procedure SetSortOrder(const Value: TPickSensorRange);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdObjectType: TMFString;
    { Internal wrapper for property @link(ObjectType). This wrapper API may change, we advise to access simpler @link(ObjectType) instead. }
    public property FdObjectType: TMFString read FFdObjectType;
    {  }
    procedure SetObjectType(const Value: array of string); overload;
    {  }
    procedure SetObjectType(const Value: TCastleStringList); overload;

    strict private FFdPickingGeometry: TSFNode;
    { Internal wrapper for property @link(PickingGeometry). This wrapper API may change, we advise to access simpler @link(PickingGeometry) instead. }
    public property FdPickingGeometry: TSFNode read FFdPickingGeometry;
    {  }
    property PickingGeometry: TAbstractGeometryNode read GetPickingGeometry write SetPickingGeometry;

    strict private FFdPickTarget: TMFNode;
    { Internal wrapper for property @link(PickTarget). This wrapper API may change, we advise to access simpler @link(PickTarget) instead. }
    public property FdPickTarget: TMFNode read FFdPickTarget;

    strict private FEventPickedGeometry: TMFNodeEvent;
    {  }
    public property EventPickedGeometry: TMFNodeEvent read FEventPickedGeometry;

    strict private FFdIntersectionType: TSFStringEnum;
    { Internal wrapper for property @link(IntersectionType). This wrapper API may change, we advise to access simpler @link(IntersectionType) instead. }
    public property FdIntersectionType: TSFStringEnum read FFdIntersectionType;
    {  }
    property IntersectionType: TPickSensorIntersectionType read GetIntersectionType write SetIntersectionType;

    strict private FFdSortOrder: TSFStringEnum;
    { Internal wrapper for property @link(SortOrder). This wrapper API may change, we advise to access simpler @link(SortOrder) instead. }
    public property FdSortOrder: TSFStringEnum read FFdSortOrder;
    {  }
    property SortOrder: TPickSensorRange read GetSortOrder write SetSortOrder;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractPickSensorNode ----------------------------------------------- }

procedure TAbstractPickSensorNode.SetObjectType(const Value: array of string);
begin
  FdObjectType.Send(Value);
end;

procedure TAbstractPickSensorNode.SetObjectType(const Value: TCastleStringList);
begin
  FdObjectType.Send(Value);
end;

function TAbstractPickSensorNode.GetPickingGeometry: TAbstractGeometryNode;
begin
  if FdPickingGeometry.Value is TAbstractGeometryNode then
    Result := TAbstractGeometryNode(FdPickingGeometry.Value)
  else
    Result := nil;
end;

procedure TAbstractPickSensorNode.SetPickingGeometry(const Value: TAbstractGeometryNode);
begin
  FdPickingGeometry.Send(Value);
end;

function TAbstractPickSensorNode.GetIntersectionType: TPickSensorIntersectionType;
begin
  Result := TPickSensorIntersectionType(FdIntersectionType.EnumValue);
end;

procedure TAbstractPickSensorNode.SetIntersectionType(const Value: TPickSensorIntersectionType);
begin
  FdIntersectionType.SendEnumValue(Ord(Value));
end;

function TAbstractPickSensorNode.GetSortOrder: TPickSensorRange;
begin
  Result := TPickSensorRange(FdSortOrder.EnumValue);
end;

procedure TAbstractPickSensorNode.SetSortOrder(const Value: TPickSensorRange);
begin
  FdSortOrder.SendEnumValue(Ord(Value));
end;

class function TAbstractPickSensorNode.ClassX3DType: String;
begin
  Result := 'X3DPickSensorNode';
end;

procedure TAbstractPickSensorNode.CreateNode;
begin
  inherited;

  FFdObjectType := TMFString.Create(Self, True, 'objectType', ['ALL']);
   FdObjectType.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdObjectType);

  FFdPickingGeometry := TSFNode.Create(Self, True, 'pickingGeometry', [TAbstractGeometryNode]);
   FdPickingGeometry.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdPickingGeometry);

  FFdPickTarget := TMFNode.Create(Self, True, 'pickTarget', [TAbstractGroupingNode, TAbstractShapeNode, TInlineNode]);
   FdPickTarget.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdPickTarget);

  FEventPickedGeometry := TMFNodeEvent.Create(Self, 'pickedGeometry', false);
  AddEvent(FEventPickedGeometry);

  FFdIntersectionType := TSFStringEnum.Create(Self, False, 'intersectionType', @PickSensorIntersectionTypeNames, Ord(High(PickSensorIntersectionTypeNames)) + 1, Ord(piBounds));
   FdIntersectionType.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdIntersectionType);

  FFdSortOrder := TSFStringEnum.Create(Self, False, 'sortOrder', @PickSensorRangeNames, Ord(High(PickSensorRangeNames)) + 1, Ord(prClosest));
   FdSortOrder.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSortOrder);
end;

{$endif read_implementation}
