{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetBottom: Boolean;
    procedure SetBottom(const Value: Boolean);
    function GetBottomRadius: Single;
    procedure SetBottomRadius(const Value: Single);
    function GetHeight: Single;
    procedure SetHeight(const Value: Single);
    function GetSide: Boolean;
    procedure SetSide(const Value: Boolean);
    function GetTexCoord: TX3DNode;
    procedure SetTexCoord(const Value: TX3DNode);
    function GetSlices: Integer;
    procedure SetSlices(const Value: Integer);
    function GetStacks: Integer;
    procedure SetStacks(const Value: Integer);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdBottom: TSFBool;
    { Internal wrapper for property @code(Bottom). This wrapper API may change, we advise to access simpler @code(Bottom) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBottom: TSFBool read FFdBottom;
    {  }
    property Bottom: Boolean read GetBottom write SetBottom;

    strict private FFdBottomRadius: TSFFloat;
    { Internal wrapper for property @code(BottomRadius). This wrapper API may change, we advise to access simpler @code(BottomRadius) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBottomRadius: TSFFloat read FFdBottomRadius;
    {  }
    property BottomRadius: Single read GetBottomRadius write SetBottomRadius;

    strict private FFdHeight: TSFFloat;
    { Internal wrapper for property @code(Height). This wrapper API may change, we advise to access simpler @code(Height) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdHeight: TSFFloat read FFdHeight;
    {  }
    property Height: Single read GetHeight write SetHeight;

    strict private FFdSide: TSFBool;
    { Internal wrapper for property @code(Side). This wrapper API may change, we advise to access simpler @code(Side) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSide: TSFBool read FFdSide;
    {  }
    property Side: Boolean read GetSide write SetSide;

    strict private FFdSolid: TSFBool;
    { Internal wrapper for property @code(Solid). This wrapper API may change, we advise to access simpler @code(Solid) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSolid: TSFBool read FFdSolid;

    strict private FFdTexCoord: TSFNode;
    { Internal wrapper for property @code(TexCoord). This wrapper API may change, we advise to access simpler @code(TexCoord) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTexCoord: TSFNode read FFdTexCoord;
    {  }
    property TexCoord: TX3DNode read GetTexCoord write SetTexCoord;

    strict private FFdSlices: TSFInt32;
    { Internal wrapper for property @code(Slices). This wrapper API may change, we advise to access simpler @code(Slices) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSlices: TSFInt32 read FFdSlices;
    { How many "slices" to use to approximate the cone. The cone is rendered using polygons (triangles and quads) that approximate the cone shape. The more slices, the more the cone will look like a cone. Slices divide the objects like slices of a pizza. The default value of 0 means to follow global variable @link(DefaultTriangulationSlices). }
    property Slices: Integer read GetSlices write SetSlices;

    strict private FFdStacks: TSFInt32;
    { Internal wrapper for property @code(Stacks). This wrapper API may change, we advise to access simpler @code(Stacks) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdStacks: TSFInt32 read FFdStacks;
    { How many "stacks" to use to approximate the cone. The cone is rendered using polygons (triangles and quads) that approximate the cone shape. The more stacks, the more the cone will look like a cone. Stacks divide the objects like stacks of a tower. The default value of 0 means to follow global variable @link(DefaultTriangulationStacks). }
    property Stacks: Integer read GetStacks write SetStacks;

{$endif read_interface}

{$ifdef read_implementation}

{ TConeNode ----------------------------------------------- }

function TConeNode.GetBottom: Boolean;
begin
  Result := FdBottom.Value;
end;

procedure TConeNode.SetBottom(const Value: Boolean);
begin
  FdBottom.Send(Value);
end;

function TConeNode.GetBottomRadius: Single;
begin
  Result := FdBottomRadius.Value;
end;

procedure TConeNode.SetBottomRadius(const Value: Single);
begin
  FdBottomRadius.Send(Value);
end;

function TConeNode.GetHeight: Single;
begin
  Result := FdHeight.Value;
end;

procedure TConeNode.SetHeight(const Value: Single);
begin
  FdHeight.Send(Value);
end;

function TConeNode.GetSide: Boolean;
begin
  Result := FdSide.Value;
end;

procedure TConeNode.SetSide(const Value: Boolean);
begin
  FdSide.Send(Value);
end;

function TConeNode.GetTexCoord: TX3DNode;
begin
  if FdTexCoord.Value is TX3DNode then
    Result := TX3DNode(FdTexCoord.Value)
  else
    Result := nil;
end;

procedure TConeNode.SetTexCoord(const Value: TX3DNode);
begin
  FdTexCoord.Send(Value);
end;

function TConeNode.GetSlices: Integer;
begin
  Result := FdSlices.Value;
end;

procedure TConeNode.SetSlices(const Value: Integer);
begin
  FdSlices.Send(Value);
end;

function TConeNode.GetStacks: Integer;
begin
  Result := FdStacks.Value;
end;

procedure TConeNode.SetStacks(const Value: Integer);
begin
  FdStacks.Send(Value);
end;

class function TConeNode.ClassX3DType: String;
begin
  Result := 'Cone';
end;

procedure TConeNode.CreateNode;
begin
  inherited;

  FFdBottom := TSFBool.Create(Self, False, 'bottom', true);
   FdBottom.ChangeAlways := chGeometry;
  AddField(FFdBottom);

  FFdBottomRadius := TSFFloat.Create(Self, False, 'bottomRadius', 1);
   FdBottomRadius.ChangeAlways := chGeometry;
   FdBottomRadius.MustBeNonnegative := true;
  AddField(FFdBottomRadius);

  FFdHeight := TSFFloat.Create(Self, False, 'height', 2);
   FdHeight.ChangeAlways := chGeometry;
   FdHeight.MustBeNonnegative := true;
  AddField(FFdHeight);

  FFdSide := TSFBool.Create(Self, False, 'side', true);
   FdSide.ChangeAlways := chGeometry;
  AddField(FFdSide);

  FFdSolid := TSFBool.Create(Self, False, 'solid', true);
   FdSolid.ChangeAlways := chGeometry;
  AddField(FFdSolid);

  FFdTexCoord := TSFNode.Create(Self, True, 'texCoord', [TTextureCoordinateGeneratorNode, TProjectedTextureCoordinateNode, TMultiGeneratedTextureCoordinateNode]);
   FdTexCoord.ChangeAlways := chGeometry;
   FdTexCoord.OnBeforeValueChange := {$ifdef FPC}@{$endif}MoveShapeAssociations;
  AddField(FFdTexCoord);

  FFdSlices := TSFInt32.Create(Self, True, 'slices', 0);
   FdSlices.ChangeAlways := chGeometry;
  AddField(FFdSlices);

  FFdStacks := TSFInt32.Create(Self, True, 'stacks', 0);
   FdStacks.ChangeAlways := chGeometry;
  AddField(FFdStacks);
end;

{$endif read_implementation}
