<?php
/**
 * File containing the ezcMailImapTransportOptions class.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 * @package Mail
 * @version //autogen//
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
 */

/**
 * Class containing the options for IMAP transport.
 *
 * The options from {@link ezcMailTransportOptions} are inherited.
 *
 * Example of how to use IMAP transport options:
 * <code>
 * $options = new ezcMailImapTransportOptions();
 * $options->ssl = true;
 * $options->timeout = 3;
 * $options->uidReferencing = true;
 *
 * $imap = new ezcMailImapTransport( 'imap.example.com', null, $options );
 * </code>
 *
 * @property bool $uidReferencing
 *           Specifies if the IMAP commands will operate with message unique
 *           IDs or with message numbers (default).
 * @property int $listLimit
 *           Specifies the maximum number of messages to be returned by the
 *           listMessages() method, or 0 for no limit (default).
 *
 * @package Mail
 * @version //autogen//
 */
class ezcMailImapTransportOptions extends ezcMailTransportOptions
{
    /**
     * Constructs an object with the specified values.
     *
     * @throws ezcBasePropertyNotFoundException
     *         if $options contains a property not defined
     * @throws ezcBaseValueException
     *         if $options contains a property with a value not allowed
     * @param array(string=>mixed) $options
     */
    public function __construct( array $options = array() )
    {
        $this->uidReferencing = false;
        $this->listLimit = 0;

        parent::__construct( $options );
    }

    /**
     * Sets the value of the option $name to $value.
     *
     * @throws ezcBasePropertyNotFoundException
     *         if the property $name is not defined
     * @throws ezcBaseValueException
     *         if $value is not correct for the property $name
     * @param string $name
     * @param mixed $value
     * @ignore
     */
    public function __set( $name, $value )
    {
        switch ( $name )
        {
            case 'uidReferencing':
                if ( !is_bool( $value ) )
                {
                    throw new ezcBaseValueException( $name, $value, 'bool' );
                }
                $this->properties[$name] = $value;
                break;

            case 'listLimit':
                if ( !is_int( $value ) || $value < 0 )
                {
                    throw new ezcBaseValueException( $name, $value, 'int >= 0' );
                }
                $this->properties[$name] = $value;
                break;

            default:
                parent::__set( $name, $value );
        }
    }
}
?>
