// Copyright (c) 2023, ETH Zurich and UNC Chapel Hill.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//
//     * Neither the name of ETH Zurich and UNC Chapel Hill nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//
// Author: Johannes L. Schoenberger (jsch-at-demuc-dot-de)

{
  double* a = A.data();
  const double* e = E.data();

  double e2[36];
  double e3[36];
  for (size_t i = 0; i < 36; ++i) {
    e2[i] = e[i] * e[i];
    e3[i] = e2[i] * e[i];
  }

  a[190] = e[33] * e[28] * e[32] - e[33] * e[31] * e[29] +
           e[30] * e[34] * e[29] - e[30] * e[28] * e[35] -
           e[27] * e[32] * e[34] + e[27] * e[31] * e[35];
  a[7] = 0.5 * e[6] * e2[8] - 0.5 * e[6] * e2[5] + 0.5 * e3[6] +
         0.5 * e[6] * e2[7] - 0.5 * e[6] * e2[4] + e[0] * e[2] * e[8] +
         e[3] * e[4] * e[7] + e[3] * e[5] * e[8] + e[0] * e[1] * e[7] -
         0.5 * e[6] * e2[1] - 0.5 * e[6] * e2[2] + 0.5 * e2[0] * e[6] +
         0.5 * e2[3] * e[6];
  a[120] = e[30] * e[34] * e[2] + e[33] * e[1] * e[32] - e[3] * e[28] * e[35] +
           e[0] * e[31] * e[35] + e[3] * e[34] * e[29] - e[30] * e[1] * e[35] +
           e[27] * e[31] * e[8] - e[27] * e[32] * e[7] - e[30] * e[28] * e[8] -
           e[33] * e[31] * e[2] - e[0] * e[32] * e[34] + e[6] * e[28] * e[32] -
           e[33] * e[4] * e[29] + e[33] * e[28] * e[5] + e[30] * e[7] * e[29] +
           e[27] * e[4] * e[35] - e[27] * e[5] * e[34] - e[6] * e[31] * e[29];
  a[77] =
      e[9] * e[27] * e[15] + e[9] * e[29] * e[17] + e[9] * e[11] * e[35] +
      e[9] * e[28] * e[16] + e[9] * e[10] * e[34] + e[27] * e[11] * e[17] +
      e[27] * e[10] * e[16] + e[12] * e[30] * e[15] + e[12] * e[32] * e[17] +
      e[12] * e[14] * e[35] + e[12] * e[31] * e[16] + e[12] * e[13] * e[34] +
      e[30] * e[14] * e[17] + e[30] * e[13] * e[16] + e[15] * e[35] * e[17] +
      e[15] * e[34] * e[16] - e[15] * e[28] * e[10] - e[15] * e[31] * e[13] -
      e[15] * e[32] * e[14] - e[15] * e[29] * e[11] + 0.5 * e2[9] * e[33] +
      0.5 * e[33] * e2[16] - 0.5 * e[33] * e2[11] + 0.5 * e[33] * e2[12] +
      1.5 * e[33] * e2[15] + 0.5 * e[33] * e2[17] - 0.5 * e[33] * e2[10] -
      0.5 * e[33] * e2[14] - 0.5 * e[33] * e2[13];
  a[180] =
      -e[33] * e[22] * e[29] - e[33] * e[31] * e[20] - e[27] * e[32] * e[25] +
      e[27] * e[22] * e[35] - e[27] * e[23] * e[34] + e[27] * e[31] * e[26] +
      e[33] * e[28] * e[23] - e[21] * e[28] * e[35] + e[30] * e[25] * e[29] +
      e[24] * e[28] * e[32] - e[24] * e[31] * e[29] + e[18] * e[31] * e[35] -
      e[30] * e[28] * e[26] - e[30] * e[19] * e[35] + e[21] * e[34] * e[29] +
      e[33] * e[19] * e[32] - e[18] * e[32] * e[34] + e[30] * e[34] * e[20];
  a[87] = e[18] * e[2] * e[17] + e[3] * e[21] * e[15] + e[3] * e[12] * e[24] +
          e[3] * e[23] * e[17] + e[3] * e[14] * e[26] + e[3] * e[22] * e[16] +
          e[3] * e[13] * e[25] + 3. * e[6] * e[24] * e[15] +
          e[6] * e[26] * e[17] + e[6] * e[25] * e[16] + e[0] * e[20] * e[17] +
          e[0] * e[11] * e[26] + e[0] * e[19] * e[16] + e[0] * e[10] * e[25] +
          e[15] * e[26] * e[8] - e[15] * e[20] * e[2] - e[15] * e[19] * e[1] -
          e[15] * e[22] * e[4] + e[15] * e[25] * e[7] - e[15] * e[23] * e[5] +
          e[12] * e[21] * e[6] + e[12] * e[22] * e[7] + e[12] * e[4] * e[25] +
          e[12] * e[23] * e[8] + e[12] * e[5] * e[26] - e[24] * e[11] * e[2] -
          e[24] * e[10] * e[1] - e[24] * e[13] * e[4] + e[24] * e[16] * e[7] -
          e[24] * e[14] * e[5] + e[24] * e[17] * e[8] + e[21] * e[13] * e[7] +
          e[21] * e[4] * e[16] + e[21] * e[14] * e[8] + e[21] * e[5] * e[17] -
          e[6] * e[23] * e[14] - e[6] * e[20] * e[11] - e[6] * e[19] * e[10] -
          e[6] * e[22] * e[13] + e[9] * e[18] * e[6] + e[9] * e[0] * e[24] +
          e[9] * e[19] * e[7] + e[9] * e[1] * e[25] + e[9] * e[20] * e[8] +
          e[9] * e[2] * e[26] + e[18] * e[0] * e[15] + e[18] * e[10] * e[7] +
          e[18] * e[1] * e[16] + e[18] * e[11] * e[8];
  a[150] =
      e[33] * e[10] * e[32] + e[33] * e[28] * e[14] - e[33] * e[13] * e[29] -
      e[33] * e[31] * e[11] + e[9] * e[31] * e[35] - e[9] * e[32] * e[34] +
      e[27] * e[13] * e[35] - e[27] * e[32] * e[16] + e[27] * e[31] * e[17] -
      e[27] * e[14] * e[34] + e[12] * e[34] * e[29] - e[12] * e[28] * e[35] +
      e[30] * e[34] * e[11] + e[30] * e[16] * e[29] - e[30] * e[10] * e[35] -
      e[30] * e[28] * e[17] + e[15] * e[28] * e[32] - e[15] * e[31] * e[29];
  a[57] = e[0] * e[27] * e[6] + e[0] * e[28] * e[7] + e[0] * e[1] * e[34] +
          e[0] * e[29] * e[8] + e[0] * e[2] * e[35] + e[6] * e[34] * e[7] -
          e[6] * e[32] * e[5] + e[6] * e[30] * e[3] + e[6] * e[35] * e[8] -
          e[6] * e[29] * e[2] - e[6] * e[28] * e[1] - e[6] * e[31] * e[4] +
          e[27] * e[1] * e[7] + e[27] * e[2] * e[8] + e[3] * e[31] * e[7] +
          e[3] * e[4] * e[34] + e[3] * e[32] * e[8] + e[3] * e[5] * e[35] +
          e[30] * e[4] * e[7] + e[30] * e[5] * e[8] + 0.5 * e2[0] * e[33] +
          1.5 * e[33] * e2[6] - 0.5 * e[33] * e2[4] - 0.5 * e[33] * e2[5] -
          0.5 * e[33] * e2[1] + 0.5 * e[33] * e2[7] + 0.5 * e[33] * e2[3] -
          0.5 * e[33] * e2[2] + 0.5 * e[33] * e2[8];
  a[80] = -e[0] * e[23] * e[16] + e[9] * e[4] * e[26] + e[9] * e[22] * e[8] -
          e[9] * e[5] * e[25] - e[9] * e[23] * e[7] + e[18] * e[4] * e[17] +
          e[18] * e[13] * e[8] - e[18] * e[5] * e[16] - e[18] * e[14] * e[7] +
          e[3] * e[16] * e[20] + e[3] * e[25] * e[11] - e[3] * e[10] * e[26] -
          e[3] * e[19] * e[17] + e[12] * e[7] * e[20] + e[12] * e[25] * e[2] -
          e[12] * e[1] * e[26] - e[12] * e[19] * e[8] + e[21] * e[7] * e[11] +
          e[21] * e[16] * e[2] - e[21] * e[1] * e[17] - e[21] * e[10] * e[8] +
          e[6] * e[10] * e[23] + e[6] * e[19] * e[14] - e[6] * e[13] * e[20] -
          e[6] * e[22] * e[11] + e[15] * e[1] * e[23] + e[15] * e[19] * e[5] -
          e[15] * e[4] * e[20] - e[15] * e[22] * e[2] + e[24] * e[1] * e[14] +
          e[24] * e[10] * e[5] - e[24] * e[4] * e[11] - e[24] * e[13] * e[2] +
          e[0] * e[13] * e[26] + e[0] * e[22] * e[17] - e[0] * e[14] * e[25];
  a[167] = e[18] * e[19] * e[25] + 0.5 * e3[24] - 0.5 * e[24] * e2[23] +
           e[18] * e[20] * e[26] + e[21] * e[22] * e[25] +
           e[21] * e[23] * e[26] - 0.5 * e[24] * e2[19] + 0.5 * e2[21] * e[24] +
           0.5 * e[24] * e2[26] - 0.5 * e[24] * e2[20] + 0.5 * e2[18] * e[24] -
           0.5 * e[24] * e2[22] + 0.5 * e[24] * e2[25];
  a[50] = -e[3] * e[1] * e[35] - e[0] * e[32] * e[7] + e[27] * e[4] * e[8] +
          e[33] * e[1] * e[5] - e[33] * e[4] * e[2] + e[0] * e[4] * e[35] +
          e[3] * e[34] * e[2] - e[30] * e[1] * e[8] + e[30] * e[7] * e[2] -
          e[6] * e[4] * e[29] + e[3] * e[7] * e[29] + e[6] * e[1] * e[32] -
          e[0] * e[5] * e[34] - e[3] * e[28] * e[8] + e[0] * e[31] * e[8] +
          e[6] * e[28] * e[5] - e[6] * e[31] * e[2] - e[27] * e[5] * e[7];
  a[97] = e[33] * e[16] * e[7] - e[33] * e[14] * e[5] + e[33] * e[17] * e[8] +
          e[30] * e[13] * e[7] + e[30] * e[4] * e[16] + e[30] * e[14] * e[8] +
          e[30] * e[5] * e[17] + e[6] * e[27] * e[9] - e[6] * e[28] * e[10] -
          e[6] * e[31] * e[13] - e[6] * e[32] * e[14] - e[6] * e[29] * e[11] +
          e[9] * e[28] * e[7] + e[9] * e[1] * e[34] + e[9] * e[29] * e[8] +
          e[9] * e[2] * e[35] + e[27] * e[10] * e[7] + e[27] * e[1] * e[16] +
          e[27] * e[11] * e[8] + e[27] * e[2] * e[17] + e[3] * e[30] * e[15] +
          e[3] * e[12] * e[33] + e[3] * e[32] * e[17] + e[3] * e[14] * e[35] +
          e[3] * e[31] * e[16] + e[3] * e[13] * e[34] +
          3. * e[6] * e[33] * e[15] + e[6] * e[35] * e[17] +
          e[6] * e[34] * e[16] + e[0] * e[27] * e[15] + e[0] * e[9] * e[33] +
          e[0] * e[29] * e[17] + e[0] * e[11] * e[35] + e[0] * e[28] * e[16] +
          e[0] * e[10] * e[34] + e[15] * e[34] * e[7] - e[15] * e[32] * e[5] +
          e[15] * e[35] * e[8] - e[15] * e[29] * e[2] - e[15] * e[28] * e[1] -
          e[15] * e[31] * e[4] + e[12] * e[30] * e[6] + e[12] * e[31] * e[7] +
          e[12] * e[4] * e[34] + e[12] * e[32] * e[8] + e[12] * e[5] * e[35] -
          e[33] * e[11] * e[2] - e[33] * e[10] * e[1] - e[33] * e[13] * e[4];
  a[0] = e[6] * e[1] * e[5] - e[6] * e[4] * e[2] + e[3] * e[7] * e[2] +
         e[0] * e[4] * e[8] - e[0] * e[5] * e[7] - e[3] * e[1] * e[8];
  a[17] = 0.5 * e3[15] + e[9] * e[10] * e[16] - 0.5 * e[15] * e2[11] +
          e[9] * e[11] * e[17] + 0.5 * e2[12] * e[15] + 0.5 * e[15] * e2[16] +
          0.5 * e[15] * e2[17] - 0.5 * e[15] * e2[13] + 0.5 * e2[9] * e[15] +
          e[12] * e[14] * e[17] - 0.5 * e[15] * e2[10] - 0.5 * e[15] * e2[14] +
          e[12] * e[13] * e[16];
  a[70] =
      e[15] * e[28] * e[14] - e[15] * e[13] * e[29] - e[15] * e[31] * e[11] +
      e[33] * e[10] * e[14] - e[33] * e[13] * e[11] + e[9] * e[13] * e[35] -
      e[9] * e[32] * e[16] + e[9] * e[31] * e[17] - e[9] * e[14] * e[34] +
      e[27] * e[13] * e[17] - e[27] * e[14] * e[16] + e[12] * e[34] * e[11] +
      e[12] * e[16] * e[29] - e[12] * e[10] * e[35] - e[12] * e[28] * e[17] +
      e[30] * e[16] * e[11] - e[30] * e[10] * e[17] + e[15] * e[10] * e[32];
  a[177] =
      e[18] * e[27] * e[24] + e[18] * e[28] * e[25] + e[18] * e[19] * e[34] +
      e[18] * e[29] * e[26] + e[18] * e[20] * e[35] + e[27] * e[19] * e[25] +
      e[27] * e[20] * e[26] + e[21] * e[30] * e[24] + e[21] * e[31] * e[25] +
      e[21] * e[22] * e[34] + e[21] * e[32] * e[26] + e[21] * e[23] * e[35] +
      e[30] * e[22] * e[25] + e[30] * e[23] * e[26] + e[24] * e[34] * e[25] +
      e[24] * e[35] * e[26] - e[24] * e[29] * e[20] - e[24] * e[31] * e[22] -
      e[24] * e[32] * e[23] - e[24] * e[28] * e[19] + 1.5 * e[33] * e2[24] +
      0.5 * e[33] * e2[25] + 0.5 * e[33] * e2[26] - 0.5 * e[33] * e2[23] -
      0.5 * e[33] * e2[19] - 0.5 * e[33] * e2[20] - 0.5 * e[33] * e2[22] +
      0.5 * e2[18] * e[33] + 0.5 * e2[21] * e[33];
  a[170] =
      e[21] * e[25] * e[29] - e[27] * e[23] * e[25] + e[24] * e[19] * e[32] -
      e[21] * e[28] * e[26] - e[21] * e[19] * e[35] + e[18] * e[31] * e[26] -
      e[30] * e[19] * e[26] - e[24] * e[31] * e[20] + e[24] * e[28] * e[23] +
      e[27] * e[22] * e[26] + e[30] * e[25] * e[20] - e[33] * e[22] * e[20] +
      e[33] * e[19] * e[23] + e[21] * e[34] * e[20] - e[18] * e[23] * e[34] -
      e[24] * e[22] * e[29] - e[18] * e[32] * e[25] + e[18] * e[22] * e[35];
  a[37] = e[12] * e[14] * e[8] + e[12] * e[5] * e[17] + e[15] * e[16] * e[7] +
          e[15] * e[17] * e[8] + e[0] * e[11] * e[17] + e[0] * e[9] * e[15] +
          e[0] * e[10] * e[16] + e[3] * e[14] * e[17] + e[3] * e[13] * e[16] +
          e[9] * e[10] * e[7] + e[9] * e[1] * e[16] + e[9] * e[11] * e[8] +
          e[9] * e[2] * e[17] - e[15] * e[11] * e[2] - e[15] * e[10] * e[1] -
          e[15] * e[13] * e[4] - e[15] * e[14] * e[5] + e[12] * e[3] * e[15] +
          e[12] * e[13] * e[7] + e[12] * e[4] * e[16] + 0.5 * e2[12] * e[6] +
          1.5 * e2[15] * e[6] + 0.5 * e[6] * e2[17] + 0.5 * e[6] * e2[16] +
          0.5 * e[6] * e2[9] - 0.5 * e[6] * e2[11] - 0.5 * e[6] * e2[10] -
          0.5 * e[6] * e2[14] - 0.5 * e[6] * e2[13];
  a[10] = -e[9] * e[14] * e[16] - e[12] * e[10] * e[17] + e[9] * e[13] * e[17] -
          e[15] * e[13] * e[11] + e[15] * e[10] * e[14] + e[12] * e[16] * e[11];
  a[67] = e[21] * e[14] * e[17] + e[21] * e[13] * e[16] +
          e[15] * e[26] * e[17] + e[15] * e[25] * e[16] -
          e[15] * e[23] * e[14] - e[15] * e[20] * e[11] -
          e[15] * e[19] * e[10] - e[15] * e[22] * e[13] + e[9] * e[20] * e[17] +
          e[9] * e[11] * e[26] + e[9] * e[19] * e[16] + e[9] * e[10] * e[25] +
          0.5 * e2[12] * e[24] + 1.5 * e[24] * e2[15] + 0.5 * e[24] * e2[17] +
          0.5 * e[24] * e2[16] + 0.5 * e2[9] * e[24] - 0.5 * e[24] * e2[11] -
          0.5 * e[24] * e2[10] - 0.5 * e[24] * e2[14] - 0.5 * e[24] * e2[13] +
          e[18] * e[11] * e[17] + e[18] * e[9] * e[15] + e[18] * e[10] * e[16] +
          e[12] * e[21] * e[15] + e[12] * e[23] * e[17] +
          e[12] * e[14] * e[26] + e[12] * e[22] * e[16] + e[12] * e[13] * e[25];
  a[90] = -e[9] * e[5] * e[34] + e[9] * e[31] * e[8] - e[9] * e[32] * e[7] +
          e[27] * e[4] * e[17] + e[27] * e[13] * e[8] - e[27] * e[5] * e[16] -
          e[27] * e[14] * e[7] + e[0] * e[13] * e[35] - e[0] * e[32] * e[16] +
          e[0] * e[31] * e[17] - e[0] * e[14] * e[34] + e[9] * e[4] * e[35] +
          e[6] * e[10] * e[32] + e[6] * e[28] * e[14] - e[6] * e[13] * e[29] -
          e[6] * e[31] * e[11] + e[15] * e[1] * e[32] + e[3] * e[34] * e[11] +
          e[3] * e[16] * e[29] - e[3] * e[10] * e[35] - e[3] * e[28] * e[17] -
          e[12] * e[1] * e[35] + e[12] * e[7] * e[29] + e[12] * e[34] * e[2] -
          e[12] * e[28] * e[8] + e[15] * e[28] * e[5] - e[15] * e[4] * e[29] -
          e[15] * e[31] * e[2] + e[33] * e[1] * e[14] + e[33] * e[10] * e[5] -
          e[33] * e[4] * e[11] - e[33] * e[13] * e[2] + e[30] * e[7] * e[11] +
          e[30] * e[16] * e[2] - e[30] * e[1] * e[17] - e[30] * e[10] * e[8];
  a[117] = e[21] * e[31] * e[7] + e[21] * e[4] * e[34] + e[21] * e[32] * e[8] +
           e[21] * e[5] * e[35] + e[30] * e[22] * e[7] + e[30] * e[4] * e[25] +
           e[30] * e[23] * e[8] + e[30] * e[5] * e[26] +
           3. * e[24] * e[33] * e[6] + e[24] * e[34] * e[7] +
           e[24] * e[35] * e[8] + e[33] * e[25] * e[7] + e[33] * e[26] * e[8] +
           e[0] * e[27] * e[24] + e[0] * e[18] * e[33] + e[0] * e[28] * e[25] +
           e[0] * e[19] * e[34] + e[0] * e[29] * e[26] + e[0] * e[20] * e[35] +
           e[18] * e[27] * e[6] + e[18] * e[28] * e[7] + e[18] * e[1] * e[34] +
           e[18] * e[29] * e[8] + e[18] * e[2] * e[35] + e[27] * e[19] * e[7] +
           e[27] * e[1] * e[25] + e[27] * e[20] * e[8] + e[27] * e[2] * e[26] +
           e[3] * e[30] * e[24] + e[3] * e[21] * e[33] + e[3] * e[31] * e[25] +
           e[3] * e[22] * e[34] + e[3] * e[32] * e[26] + e[3] * e[23] * e[35] +
           e[6] * e[30] * e[21] - e[6] * e[29] * e[20] + e[6] * e[35] * e[26] -
           e[6] * e[31] * e[22] - e[6] * e[32] * e[23] - e[6] * e[28] * e[19] +
           e[6] * e[34] * e[25] - e[24] * e[32] * e[5] - e[24] * e[29] * e[2] -
           e[24] * e[28] * e[1] - e[24] * e[31] * e[4] - e[33] * e[20] * e[2] -
           e[33] * e[19] * e[1] - e[33] * e[22] * e[4] - e[33] * e[23] * e[5];
  a[160] = e[21] * e[25] * e[20] - e[21] * e[19] * e[26] +
           e[18] * e[22] * e[26] - e[18] * e[23] * e[25] -
           e[24] * e[22] * e[20] + e[24] * e[19] * e[23];
  a[47] = e[3] * e[4] * e[25] + e[3] * e[23] * e[8] + e[3] * e[5] * e[26] +
          e[21] * e[4] * e[7] + e[21] * e[5] * e[8] + e[6] * e[25] * e[7] +
          e[6] * e[26] * e[8] + e[0] * e[19] * e[7] + e[0] * e[1] * e[25] +
          e[0] * e[20] * e[8] + e[0] * e[2] * e[26] - e[6] * e[20] * e[2] -
          e[6] * e[19] * e[1] - e[6] * e[22] * e[4] - e[6] * e[23] * e[5] +
          e[18] * e[1] * e[7] + e[18] * e[0] * e[6] + e[18] * e[2] * e[8] +
          e[3] * e[21] * e[6] + e[3] * e[22] * e[7] - 0.5 * e[24] * e2[4] +
          0.5 * e[24] * e2[0] + 1.5 * e[24] * e2[6] - 0.5 * e[24] * e2[5] -
          0.5 * e[24] * e2[1] + 0.5 * e[24] * e2[7] + 0.5 * e[24] * e2[3] -
          0.5 * e[24] * e2[2] + 0.5 * e[24] * e2[8];
  a[110] = e[6] * e[28] * e[23] - e[6] * e[22] * e[29] - e[6] * e[31] * e[20] -
           e[3] * e[19] * e[35] + e[3] * e[34] * e[20] + e[3] * e[25] * e[29] -
           e[21] * e[1] * e[35] + e[21] * e[7] * e[29] + e[21] * e[34] * e[2] +
           e[24] * e[1] * e[32] + e[24] * e[28] * e[5] - e[24] * e[4] * e[29] -
           e[24] * e[31] * e[2] + e[33] * e[1] * e[23] + e[33] * e[19] * e[5] -
           e[33] * e[4] * e[20] - e[33] * e[22] * e[2] - e[21] * e[28] * e[8] +
           e[30] * e[7] * e[20] + e[30] * e[25] * e[2] - e[30] * e[1] * e[26] +
           e[18] * e[4] * e[35] - e[18] * e[5] * e[34] + e[18] * e[31] * e[8] -
           e[18] * e[32] * e[7] + e[27] * e[4] * e[26] + e[27] * e[22] * e[8] -
           e[27] * e[5] * e[25] - e[27] * e[23] * e[7] - e[3] * e[28] * e[26] -
           e[0] * e[32] * e[25] + e[0] * e[22] * e[35] - e[0] * e[23] * e[34] +
           e[0] * e[31] * e[26] - e[30] * e[19] * e[8] + e[6] * e[19] * e[32];
  a[107] = 0.5 * e2[18] * e[6] + 0.5 * e2[21] * e[6] + 1.5 * e2[24] * e[6] +
           0.5 * e[6] * e2[26] - 0.5 * e[6] * e2[23] - 0.5 * e[6] * e2[19] -
           0.5 * e[6] * e2[20] - 0.5 * e[6] * e2[22] + 0.5 * e[6] * e2[25] +
           e[21] * e[3] * e[24] + e[18] * e[20] * e[8] + e[21] * e[4] * e[25] +
           e[18] * e[19] * e[7] + e[18] * e[1] * e[25] + e[21] * e[22] * e[7] +
           e[21] * e[23] * e[8] + e[18] * e[0] * e[24] + e[18] * e[2] * e[26] +
           e[21] * e[5] * e[26] + e[24] * e[26] * e[8] - e[24] * e[20] * e[2] -
           e[24] * e[19] * e[1] - e[24] * e[22] * e[4] + e[24] * e[25] * e[7] -
           e[24] * e[23] * e[5] + e[0] * e[19] * e[25] + e[0] * e[20] * e[26] +
           e[3] * e[22] * e[25] + e[3] * e[23] * e[26];
  a[40] = e[18] * e[4] * e[8] + e[3] * e[7] * e[20] + e[3] * e[25] * e[2] -
          e[3] * e[1] * e[26] - e[18] * e[5] * e[7] + e[6] * e[1] * e[23] +
          e[6] * e[19] * e[5] - e[6] * e[4] * e[20] - e[6] * e[22] * e[2] +
          e[21] * e[7] * e[2] - e[21] * e[1] * e[8] + e[24] * e[1] * e[5] -
          e[24] * e[4] * e[2] - e[3] * e[19] * e[8] + e[0] * e[4] * e[26] +
          e[0] * e[22] * e[8] - e[0] * e[5] * e[25] - e[0] * e[23] * e[7];
  a[27] = e[9] * e[1] * e[7] + e[9] * e[0] * e[6] + e[9] * e[2] * e[8] +
          e[3] * e[12] * e[6] + e[3] * e[13] * e[7] + e[3] * e[4] * e[16] +
          e[3] * e[14] * e[8] + e[3] * e[5] * e[17] + e[12] * e[4] * e[7] +
          e[12] * e[5] * e[8] + e[6] * e[16] * e[7] + e[6] * e[17] * e[8] -
          e[6] * e[11] * e[2] - e[6] * e[10] * e[1] - e[6] * e[13] * e[4] -
          e[6] * e[14] * e[5] + e[0] * e[10] * e[7] + e[0] * e[1] * e[16] +
          e[0] * e[11] * e[8] + e[0] * e[2] * e[17] + 0.5 * e2[3] * e[15] +
          1.5 * e[15] * e2[6] + 0.5 * e[15] * e2[7] + 0.5 * e[15] * e2[8] +
          0.5 * e2[0] * e[15] - 0.5 * e[15] * e2[4] - 0.5 * e[15] * e2[5] -
          0.5 * e[15] * e2[1] - 0.5 * e[15] * e2[2];
  a[30] = -e[15] * e[13] * e[2] - e[6] * e[13] * e[11] - e[15] * e[4] * e[11] +
          e[12] * e[16] * e[2] - e[3] * e[10] * e[17] + e[3] * e[16] * e[11] +
          e[0] * e[13] * e[17] - e[0] * e[14] * e[16] + e[15] * e[1] * e[14] -
          e[12] * e[10] * e[8] + e[9] * e[4] * e[17] + e[9] * e[13] * e[8] -
          e[9] * e[5] * e[16] - e[9] * e[14] * e[7] + e[15] * e[10] * e[5] +
          e[12] * e[7] * e[11] + e[6] * e[10] * e[14] - e[12] * e[1] * e[17];
  a[147] =
      e[12] * e[30] * e[24] + e[12] * e[21] * e[33] + e[12] * e[31] * e[25] +
      e[12] * e[22] * e[34] + e[12] * e[32] * e[26] + e[12] * e[23] * e[35] +
      e[9] * e[27] * e[24] + e[9] * e[18] * e[33] + e[9] * e[28] * e[25] +
      e[9] * e[19] * e[34] + e[9] * e[29] * e[26] + e[9] * e[20] * e[35] +
      e[21] * e[30] * e[15] + e[21] * e[32] * e[17] + e[21] * e[14] * e[35] +
      e[21] * e[31] * e[16] + e[21] * e[13] * e[34] + e[30] * e[23] * e[17] +
      e[30] * e[14] * e[26] + e[30] * e[22] * e[16] + e[30] * e[13] * e[25] +
      e[15] * e[27] * e[18] + 3. * e[15] * e[33] * e[24] -
      e[15] * e[29] * e[20] + e[15] * e[35] * e[26] - e[15] * e[31] * e[22] -
      e[15] * e[32] * e[23] - e[15] * e[28] * e[19] + e[15] * e[34] * e[25] +
      e[18] * e[29] * e[17] + e[18] * e[11] * e[35] + e[18] * e[28] * e[16] +
      e[18] * e[10] * e[34] + e[27] * e[20] * e[17] + e[27] * e[11] * e[26] +
      e[27] * e[19] * e[16] + e[27] * e[10] * e[25] - e[24] * e[28] * e[10] -
      e[24] * e[31] * e[13] - e[24] * e[32] * e[14] + e[24] * e[34] * e[16] +
      e[24] * e[35] * e[17] - e[24] * e[29] * e[11] - e[33] * e[23] * e[14] +
      e[33] * e[25] * e[16] + e[33] * e[26] * e[17] - e[33] * e[20] * e[11] -
      e[33] * e[19] * e[10] - e[33] * e[22] * e[13];
  a[60] = e[18] * e[13] * e[17] + e[9] * e[13] * e[26] + e[9] * e[22] * e[17] -
          e[9] * e[14] * e[25] - e[18] * e[14] * e[16] - e[15] * e[13] * e[20] -
          e[15] * e[22] * e[11] + e[12] * e[16] * e[20] +
          e[12] * e[25] * e[11] - e[12] * e[10] * e[26] -
          e[12] * e[19] * e[17] + e[21] * e[16] * e[11] -
          e[21] * e[10] * e[17] - e[9] * e[23] * e[16] + e[24] * e[10] * e[14] -
          e[24] * e[13] * e[11] + e[15] * e[10] * e[23] + e[15] * e[19] * e[14];
  a[137] =
      e[21] * e[12] * e[24] + e[21] * e[23] * e[17] + e[21] * e[14] * e[26] +
      e[21] * e[22] * e[16] + e[21] * e[13] * e[25] + e[24] * e[26] * e[17] +
      e[24] * e[25] * e[16] + e[9] * e[19] * e[25] + e[9] * e[18] * e[24] +
      e[9] * e[20] * e[26] + e[12] * e[22] * e[25] + e[12] * e[23] * e[26] +
      e[18] * e[20] * e[17] + e[18] * e[11] * e[26] + e[18] * e[19] * e[16] +
      e[18] * e[10] * e[25] - e[24] * e[23] * e[14] - e[24] * e[20] * e[11] -
      e[24] * e[19] * e[10] - e[24] * e[22] * e[13] + 0.5 * e2[21] * e[15] +
      1.5 * e2[24] * e[15] + 0.5 * e[15] * e2[25] + 0.5 * e[15] * e2[26] +
      0.5 * e[15] * e2[18] - 0.5 * e[15] * e2[23] - 0.5 * e[15] * e2[19] -
      0.5 * e[15] * e2[20] - 0.5 * e[15] * e2[22];
  a[20] = e[6] * e[1] * e[14] + e[15] * e[1] * e[5] - e[0] * e[5] * e[16] -
          e[0] * e[14] * e[7] + e[0] * e[13] * e[8] - e[15] * e[4] * e[2] +
          e[12] * e[7] * e[2] + e[6] * e[10] * e[5] + e[3] * e[7] * e[11] -
          e[6] * e[4] * e[11] + e[3] * e[16] * e[2] - e[6] * e[13] * e[2] -
          e[3] * e[1] * e[17] - e[9] * e[5] * e[7] - e[3] * e[10] * e[8] -
          e[12] * e[1] * e[8] + e[0] * e[4] * e[17] + e[9] * e[4] * e[8];
  a[16] = -0.5 * e[14] * e2[16] - 0.5 * e[14] * e2[10] - 0.5 * e[14] * e2[9] +
          e[11] * e[9] * e[12] + 0.5 * e3[14] + e[17] * e[13] * e[16] +
          0.5 * e[14] * e2[12] + e[11] * e[10] * e[13] - 0.5 * e[14] * e2[15] +
          0.5 * e[14] * e2[17] + e[17] * e[12] * e[15] + 0.5 * e2[11] * e[14] +
          0.5 * e[14] * e2[13];
  a[100] = -e[21] * e[19] * e[8] + e[18] * e[4] * e[26] - e[18] * e[5] * e[25] -
           e[18] * e[23] * e[7] + e[21] * e[25] * e[2] - e[21] * e[1] * e[26] +
           e[6] * e[19] * e[23] + e[18] * e[22] * e[8] - e[0] * e[23] * e[25] -
           e[6] * e[22] * e[20] + e[24] * e[1] * e[23] + e[24] * e[19] * e[5] -
           e[24] * e[4] * e[20] - e[24] * e[22] * e[2] + e[3] * e[25] * e[20] -
           e[3] * e[19] * e[26] + e[0] * e[22] * e[26] + e[21] * e[7] * e[20];
  a[176] =
      0.5 * e2[20] * e[32] + 1.5 * e[32] * e2[23] + 0.5 * e[32] * e2[22] +
      0.5 * e[32] * e2[21] + 0.5 * e[32] * e2[26] - 0.5 * e[32] * e2[18] -
      0.5 * e[32] * e2[19] - 0.5 * e[32] * e2[24] - 0.5 * e[32] * e2[25] +
      e[20] * e[27] * e[21] + e[20] * e[18] * e[30] + e[20] * e[28] * e[22] +
      e[20] * e[19] * e[31] + e[20] * e[29] * e[23] + e[29] * e[19] * e[22] +
      e[29] * e[18] * e[21] + e[23] * e[30] * e[21] + e[23] * e[31] * e[22] +
      e[26] * e[30] * e[24] + e[26] * e[21] * e[33] + e[26] * e[31] * e[25] +
      e[26] * e[22] * e[34] + e[26] * e[23] * e[35] + e[35] * e[22] * e[25] +
      e[35] * e[21] * e[24] - e[23] * e[27] * e[18] - e[23] * e[33] * e[24] -
      e[23] * e[28] * e[19] - e[23] * e[34] * e[25];
  a[130] =
      -e[9] * e[23] * e[25] - e[21] * e[10] * e[26] - e[21] * e[19] * e[17] -
      e[18] * e[23] * e[16] + e[18] * e[13] * e[26] + e[12] * e[25] * e[20] -
      e[12] * e[19] * e[26] - e[15] * e[22] * e[20] + e[21] * e[16] * e[20] +
      e[21] * e[25] * e[11] + e[24] * e[10] * e[23] + e[24] * e[19] * e[14] -
      e[24] * e[13] * e[20] - e[24] * e[22] * e[11] + e[18] * e[22] * e[17] -
      e[18] * e[14] * e[25] + e[9] * e[22] * e[26] + e[15] * e[19] * e[23];
  a[166] = 0.5 * e[23] * e2[21] + e[20] * e[19] * e[22] +
           e[20] * e[18] * e[21] + 0.5 * e3[23] + e[26] * e[22] * e[25] +
           0.5 * e[23] * e2[26] - 0.5 * e[23] * e2[18] + 0.5 * e[23] * e2[22] -
           0.5 * e[23] * e2[19] + e[26] * e[21] * e[24] + 0.5 * e2[20] * e[23] -
           0.5 * e[23] * e2[24] - 0.5 * e[23] * e2[25];
  a[140] =
      e[18] * e[13] * e[35] - e[18] * e[32] * e[16] + e[18] * e[31] * e[17] -
      e[18] * e[14] * e[34] + e[27] * e[13] * e[26] + e[27] * e[22] * e[17] -
      e[27] * e[14] * e[25] - e[27] * e[23] * e[16] - e[9] * e[32] * e[25] +
      e[9] * e[22] * e[35] - e[9] * e[23] * e[34] + e[9] * e[31] * e[26] +
      e[15] * e[19] * e[32] + e[15] * e[28] * e[23] - e[15] * e[22] * e[29] -
      e[15] * e[31] * e[20] + e[24] * e[10] * e[32] + e[24] * e[28] * e[14] -
      e[24] * e[13] * e[29] - e[24] * e[31] * e[11] + e[33] * e[10] * e[23] +
      e[33] * e[19] * e[14] - e[33] * e[13] * e[20] - e[33] * e[22] * e[11] +
      e[21] * e[16] * e[29] - e[21] * e[10] * e[35] - e[21] * e[28] * e[17] +
      e[30] * e[16] * e[20] + e[30] * e[25] * e[11] - e[30] * e[10] * e[26] -
      e[30] * e[19] * e[17] - e[12] * e[28] * e[26] - e[12] * e[19] * e[35] +
      e[12] * e[34] * e[20] + e[12] * e[25] * e[29] + e[21] * e[34] * e[11];
  a[96] = -e[32] * e[10] * e[1] + e[32] * e[13] * e[4] - e[32] * e[16] * e[7] -
          e[32] * e[15] * e[6] - e[32] * e[9] * e[0] + e[32] * e[12] * e[3] +
          e[17] * e[30] * e[6] + e[17] * e[3] * e[33] + e[17] * e[31] * e[7] +
          e[17] * e[4] * e[34] + e[17] * e[5] * e[35] - e[5] * e[27] * e[9] -
          e[5] * e[28] * e[10] - e[5] * e[33] * e[15] - e[5] * e[34] * e[16] +
          e[5] * e[29] * e[11] + e[35] * e[12] * e[6] + e[35] * e[3] * e[15] +
          e[35] * e[13] * e[7] + e[35] * e[4] * e[16] + e[11] * e[27] * e[3] +
          e[11] * e[0] * e[30] + e[11] * e[28] * e[4] + e[11] * e[1] * e[31] +
          e[29] * e[9] * e[3] + e[29] * e[0] * e[12] + e[29] * e[10] * e[4] +
          e[29] * e[1] * e[13] + e[5] * e[30] * e[12] +
          3. * e[5] * e[32] * e[14] + e[5] * e[31] * e[13] +
          e[8] * e[30] * e[15] + e[8] * e[12] * e[33] + e[8] * e[32] * e[17] +
          e[8] * e[14] * e[35] + e[8] * e[31] * e[16] + e[8] * e[13] * e[34] +
          e[2] * e[27] * e[12] + e[2] * e[9] * e[30] + e[2] * e[29] * e[14] +
          e[2] * e[11] * e[32] + e[2] * e[28] * e[13] + e[2] * e[10] * e[31] -
          e[14] * e[27] * e[0] - e[14] * e[34] * e[7] - e[14] * e[33] * e[6] +
          e[14] * e[30] * e[3] - e[14] * e[28] * e[1] + e[14] * e[31] * e[4];
  a[181] =
      0.5 * e[18] * e2[29] + 0.5 * e[18] * e2[28] + 0.5 * e[18] * e2[30] +
      0.5 * e[18] * e2[33] - 0.5 * e[18] * e2[32] - 0.5 * e[18] * e2[31] -
      0.5 * e[18] * e2[34] - 0.5 * e[18] * e2[35] + 1.5 * e[18] * e2[27] +
      e[27] * e[28] * e[19] + e[27] * e[29] * e[20] + e[21] * e[27] * e[30] +
      e[21] * e[29] * e[32] + e[21] * e[28] * e[31] + e[30] * e[28] * e[22] +
      e[30] * e[19] * e[31] + e[30] * e[29] * e[23] + e[30] * e[20] * e[32] +
      e[24] * e[27] * e[33] + e[24] * e[29] * e[35] + e[24] * e[28] * e[34] +
      e[33] * e[28] * e[25] + e[33] * e[19] * e[34] + e[33] * e[29] * e[26] +
      e[33] * e[20] * e[35] - e[27] * e[35] * e[26] - e[27] * e[31] * e[22] -
      e[27] * e[32] * e[23] - e[27] * e[34] * e[25];
  a[46] = e[20] * e[1] * e[4] + e[20] * e[0] * e[3] + e[20] * e[2] * e[5] +
          e[5] * e[21] * e[3] + e[5] * e[22] * e[4] + e[8] * e[21] * e[6] +
          e[8] * e[3] * e[24] + e[8] * e[22] * e[7] + e[8] * e[4] * e[25] +
          e[8] * e[5] * e[26] + e[26] * e[4] * e[7] + e[26] * e[3] * e[6] +
          e[2] * e[18] * e[3] + e[2] * e[0] * e[21] + e[2] * e[19] * e[4] +
          e[2] * e[1] * e[22] - e[5] * e[19] * e[1] - e[5] * e[18] * e[0] -
          e[5] * e[25] * e[7] - e[5] * e[24] * e[6] + 0.5 * e[23] * e2[4] -
          0.5 * e[23] * e2[0] - 0.5 * e[23] * e2[6] + 1.5 * e[23] * e2[5] -
          0.5 * e[23] * e2[1] - 0.5 * e[23] * e2[7] + 0.5 * e[23] * e2[3] +
          0.5 * e[23] * e2[2] + 0.5 * e[23] * e2[8];
  a[151] =
      1.5 * e[9] * e2[27] + 0.5 * e[9] * e2[29] + 0.5 * e[9] * e2[28] -
      0.5 * e[9] * e2[32] - 0.5 * e[9] * e2[31] + 0.5 * e[9] * e2[33] +
      0.5 * e[9] * e2[30] - 0.5 * e[9] * e2[34] - 0.5 * e[9] * e2[35] +
      e[33] * e[27] * e[15] + e[33] * e[29] * e[17] + e[33] * e[11] * e[35] +
      e[33] * e[28] * e[16] + e[33] * e[10] * e[34] + e[27] * e[29] * e[11] +
      e[27] * e[28] * e[10] + e[27] * e[30] * e[12] - e[27] * e[31] * e[13] -
      e[27] * e[32] * e[14] - e[27] * e[34] * e[16] - e[27] * e[35] * e[17] +
      e[30] * e[29] * e[14] + e[30] * e[11] * e[32] + e[30] * e[28] * e[13] +
      e[30] * e[10] * e[31] + e[12] * e[29] * e[32] + e[12] * e[28] * e[31] +
      e[15] * e[29] * e[35] + e[15] * e[28] * e[34];
  a[116] = -e[32] * e[24] * e[6] + e[8] * e[30] * e[24] + e[8] * e[21] * e[33] +
           e[8] * e[31] * e[25] + e[8] * e[22] * e[34] + e[26] * e[30] * e[6] +
           e[26] * e[3] * e[33] + e[26] * e[31] * e[7] + e[26] * e[4] * e[34] +
           e[26] * e[32] * e[8] + e[26] * e[5] * e[35] + e[35] * e[21] * e[6] +
           e[35] * e[3] * e[24] + e[35] * e[22] * e[7] + e[35] * e[4] * e[25] +
           e[35] * e[23] * e[8] + e[2] * e[27] * e[21] + e[2] * e[18] * e[30] +
           e[2] * e[28] * e[22] + e[2] * e[19] * e[31] + e[2] * e[29] * e[23] +
           e[2] * e[20] * e[32] + e[20] * e[27] * e[3] + e[20] * e[0] * e[30] +
           e[20] * e[28] * e[4] + e[20] * e[1] * e[31] + e[20] * e[29] * e[5] +
           e[29] * e[18] * e[3] + e[29] * e[0] * e[21] + e[29] * e[19] * e[4] +
           e[29] * e[1] * e[22] + e[5] * e[30] * e[21] + e[5] * e[31] * e[22] +
           3. * e[5] * e[32] * e[23] - e[5] * e[27] * e[18] -
           e[5] * e[33] * e[24] - e[5] * e[28] * e[19] - e[5] * e[34] * e[25] -
           e[23] * e[27] * e[0] - e[23] * e[34] * e[7] - e[23] * e[33] * e[6] +
           e[23] * e[30] * e[3] - e[23] * e[28] * e[1] + e[23] * e[31] * e[4] +
           e[32] * e[21] * e[3] - e[32] * e[19] * e[1] + e[32] * e[22] * e[4] -
           e[32] * e[18] * e[0] - e[32] * e[25] * e[7];
  a[191] = 0.5 * e[27] * e2[33] - 0.5 * e[27] * e2[32] - 0.5 * e[27] * e2[31] -
           0.5 * e[27] * e2[34] - 0.5 * e[27] * e2[35] + e[33] * e[29] * e[35] +
           0.5 * e[27] * e2[29] + e[30] * e[29] * e[32] +
           e[30] * e[28] * e[31] + e[33] * e[28] * e[34] +
           0.5 * e[27] * e2[28] + 0.5 * e[27] * e2[30] + 0.5 * e3[27];
  a[66] =
      e[14] * e[21] * e[12] + e[14] * e[22] * e[13] + e[17] * e[21] * e[15] +
      e[17] * e[12] * e[24] + e[17] * e[14] * e[26] + e[17] * e[22] * e[16] +
      e[17] * e[13] * e[25] + e[26] * e[12] * e[15] + e[26] * e[13] * e[16] -
      e[14] * e[24] * e[15] - e[14] * e[25] * e[16] - e[14] * e[18] * e[9] -
      e[14] * e[19] * e[10] + e[11] * e[18] * e[12] + e[11] * e[9] * e[21] +
      e[11] * e[19] * e[13] + e[11] * e[10] * e[22] + e[20] * e[11] * e[14] +
      e[20] * e[9] * e[12] + e[20] * e[10] * e[13] + 1.5 * e[23] * e2[14] +
      0.5 * e[23] * e2[12] + 0.5 * e[23] * e2[13] + 0.5 * e[23] * e2[17] +
      0.5 * e2[11] * e[23] - 0.5 * e[23] * e2[16] - 0.5 * e[23] * e2[9] -
      0.5 * e[23] * e2[15] - 0.5 * e[23] * e2[10];
  a[121] = 1.5 * e[0] * e2[27] + 0.5 * e[0] * e2[29] + 0.5 * e[0] * e2[28] +
           0.5 * e[0] * e2[30] - 0.5 * e[0] * e2[32] - 0.5 * e[0] * e2[31] +
           0.5 * e[0] * e2[33] - 0.5 * e[0] * e2[34] - 0.5 * e[0] * e2[35] -
           e[27] * e[31] * e[4] + e[3] * e[27] * e[30] + e[3] * e[29] * e[32] +
           e[3] * e[28] * e[31] + e[30] * e[28] * e[4] + e[30] * e[1] * e[31] +
           e[30] * e[29] * e[5] + e[30] * e[2] * e[32] + e[6] * e[27] * e[33] +
           e[6] * e[29] * e[35] + e[6] * e[28] * e[34] + e[27] * e[28] * e[1] +
           e[27] * e[29] * e[2] + e[33] * e[28] * e[7] + e[33] * e[1] * e[34] +
           e[33] * e[29] * e[8] + e[33] * e[2] * e[35] - e[27] * e[34] * e[7] -
           e[27] * e[32] * e[5] - e[27] * e[35] * e[8];
  a[36] = e[14] * e[12] * e[3] + e[14] * e[13] * e[4] + e[17] * e[12] * e[6] +
          e[17] * e[3] * e[15] + e[17] * e[13] * e[7] + e[17] * e[4] * e[16] +
          e[17] * e[14] * e[8] + e[8] * e[12] * e[15] + e[8] * e[13] * e[16] +
          e[2] * e[11] * e[14] + e[2] * e[9] * e[12] + e[2] * e[10] * e[13] +
          e[11] * e[9] * e[3] + e[11] * e[0] * e[12] + e[11] * e[10] * e[4] +
          e[11] * e[1] * e[13] - e[14] * e[10] * e[1] - e[14] * e[16] * e[7] -
          e[14] * e[15] * e[6] - e[14] * e[9] * e[0] - 0.5 * e[5] * e2[16] -
          0.5 * e[5] * e2[9] + 0.5 * e[5] * e2[11] + 0.5 * e[5] * e2[12] -
          0.5 * e[5] * e2[15] - 0.5 * e[5] * e2[10] + 0.5 * e[5] * e2[13] +
          1.5 * e2[14] * e[5] + 0.5 * e[5] * e2[17];
  a[71] = 1.5 * e[27] * e2[9] - 0.5 * e[27] * e2[16] + 0.5 * e[27] * e2[11] +
          0.5 * e[27] * e2[12] + 0.5 * e[27] * e2[15] - 0.5 * e[27] * e2[17] +
          0.5 * e[27] * e2[10] - 0.5 * e[27] * e2[14] - 0.5 * e[27] * e2[13] +
          e[12] * e[10] * e[31] + e[30] * e[11] * e[14] +
          e[30] * e[10] * e[13] + e[15] * e[9] * e[33] + e[15] * e[29] * e[17] +
          e[15] * e[11] * e[35] + e[15] * e[28] * e[16] +
          e[15] * e[10] * e[34] + e[33] * e[11] * e[17] +
          e[33] * e[10] * e[16] - e[9] * e[31] * e[13] - e[9] * e[32] * e[14] -
          e[9] * e[34] * e[16] - e[9] * e[35] * e[17] + e[9] * e[29] * e[11] +
          e[9] * e[28] * e[10] + e[12] * e[9] * e[30] + e[12] * e[29] * e[14] +
          e[12] * e[11] * e[32] + e[12] * e[28] * e[13];
  a[146] =
      e[29] * e[18] * e[12] + e[29] * e[9] * e[21] + e[29] * e[19] * e[13] +
      e[29] * e[10] * e[22] + e[17] * e[30] * e[24] + e[17] * e[21] * e[33] +
      e[17] * e[31] * e[25] + e[17] * e[22] * e[34] + e[17] * e[32] * e[26] +
      e[17] * e[23] * e[35] - e[23] * e[27] * e[9] - e[23] * e[28] * e[10] -
      e[23] * e[33] * e[15] - e[23] * e[34] * e[16] - e[32] * e[24] * e[15] -
      e[32] * e[25] * e[16] - e[32] * e[18] * e[9] - e[32] * e[19] * e[10] +
      e[26] * e[30] * e[15] + e[26] * e[12] * e[33] + e[26] * e[31] * e[16] +
      e[26] * e[13] * e[34] + e[35] * e[21] * e[15] + e[35] * e[12] * e[24] +
      e[35] * e[22] * e[16] + e[35] * e[13] * e[25] + e[14] * e[30] * e[21] +
      e[14] * e[31] * e[22] + 3. * e[14] * e[32] * e[23] +
      e[11] * e[27] * e[21] + e[11] * e[18] * e[30] + e[11] * e[28] * e[22] +
      e[11] * e[19] * e[31] + e[11] * e[29] * e[23] + e[11] * e[20] * e[32] +
      e[23] * e[30] * e[12] + e[23] * e[31] * e[13] + e[32] * e[21] * e[12] +
      e[32] * e[22] * e[13] - e[14] * e[27] * e[18] - e[14] * e[33] * e[24] +
      e[14] * e[29] * e[20] + e[14] * e[35] * e[26] - e[14] * e[28] * e[19] -
      e[14] * e[34] * e[25] + e[20] * e[27] * e[12] + e[20] * e[9] * e[30] +
      e[20] * e[28] * e[13] + e[20] * e[10] * e[31];
  a[1] = 0.5 * e[0] * e2[1] + 0.5 * e[0] * e2[2] + e[6] * e[2] * e[8] +
         e[6] * e[1] * e[7] + 0.5 * e[0] * e2[3] + e[3] * e[1] * e[4] +
         0.5 * e[0] * e2[6] + e[3] * e[2] * e[5] - 0.5 * e[0] * e2[5] -
         0.5 * e[0] * e2[8] + 0.5 * e3[0] - 0.5 * e[0] * e2[7] -
         0.5 * e[0] * e2[4];
  a[136] =
      1.5 * e2[23] * e[14] + 0.5 * e[14] * e2[26] - 0.5 * e[14] * e2[18] -
      0.5 * e[14] * e2[19] + 0.5 * e[14] * e2[20] + 0.5 * e[14] * e2[22] -
      0.5 * e[14] * e2[24] + 0.5 * e[14] * e2[21] - 0.5 * e[14] * e2[25] +
      e[23] * e[21] * e[12] + e[23] * e[22] * e[13] + e[26] * e[21] * e[15] +
      e[26] * e[12] * e[24] + e[26] * e[23] * e[17] + e[26] * e[22] * e[16] +
      e[26] * e[13] * e[25] + e[17] * e[22] * e[25] + e[17] * e[21] * e[24] +
      e[11] * e[19] * e[22] + e[11] * e[18] * e[21] + e[11] * e[20] * e[23] +
      e[20] * e[18] * e[12] + e[20] * e[9] * e[21] + e[20] * e[19] * e[13] +
      e[20] * e[10] * e[22] - e[23] * e[24] * e[15] - e[23] * e[25] * e[16] -
      e[23] * e[18] * e[9] - e[23] * e[19] * e[10];
  a[51] = 1.5 * e[27] * e2[0] - 0.5 * e[27] * e2[4] + 0.5 * e[27] * e2[6] -
          0.5 * e[27] * e2[5] + 0.5 * e[27] * e2[1] - 0.5 * e[27] * e2[7] +
          0.5 * e[27] * e2[3] + 0.5 * e[27] * e2[2] - 0.5 * e[27] * e2[8] +
          e[0] * e[33] * e[6] + e[0] * e[30] * e[3] - e[0] * e[35] * e[8] -
          e[0] * e[31] * e[4] + e[3] * e[28] * e[4] + e[3] * e[1] * e[31] +
          e[3] * e[29] * e[5] + e[3] * e[2] * e[32] + e[30] * e[1] * e[4] +
          e[30] * e[2] * e[5] + e[6] * e[28] * e[7] + e[6] * e[1] * e[34] +
          e[6] * e[29] * e[8] + e[6] * e[2] * e[35] + e[33] * e[1] * e[7] +
          e[33] * e[2] * e[8] + e[0] * e[28] * e[1] + e[0] * e[29] * e[2] -
          e[0] * e[34] * e[7] - e[0] * e[32] * e[5];
  a[106] = e[8] * e[22] * e[25] + e[8] * e[21] * e[24] + e[20] * e[18] * e[3] +
           e[20] * e[0] * e[21] + e[20] * e[19] * e[4] + e[20] * e[1] * e[22] +
           e[20] * e[2] * e[23] + e[23] * e[21] * e[3] + e[23] * e[22] * e[4] +
           e[23] * e[26] * e[8] - e[23] * e[19] * e[1] - e[23] * e[18] * e[0] -
           e[23] * e[25] * e[7] - e[23] * e[24] * e[6] + e[2] * e[19] * e[22] +
           e[2] * e[18] * e[21] + e[26] * e[21] * e[6] + e[26] * e[3] * e[24] +
           e[26] * e[22] * e[7] + e[26] * e[4] * e[25] + 0.5 * e2[20] * e[5] +
           1.5 * e2[23] * e[5] + 0.5 * e[5] * e2[22] + 0.5 * e[5] * e2[21] +
           0.5 * e[5] * e2[26] - 0.5 * e[5] * e2[18] - 0.5 * e[5] * e2[19] -
           0.5 * e[5] * e2[24] - 0.5 * e[5] * e2[25];
  a[81] = e[24] * e[11] * e[8] + e[24] * e[2] * e[17] +
          3. * e[9] * e[18] * e[0] + e[9] * e[19] * e[1] + e[9] * e[20] * e[2] +
          e[18] * e[10] * e[1] + e[18] * e[11] * e[2] + e[3] * e[18] * e[12] +
          e[3] * e[9] * e[21] + e[3] * e[20] * e[14] + e[3] * e[11] * e[23] +
          e[3] * e[19] * e[13] + e[3] * e[10] * e[22] + e[6] * e[18] * e[15] +
          e[6] * e[9] * e[24] + e[6] * e[20] * e[17] + e[6] * e[11] * e[26] +
          e[6] * e[19] * e[16] + e[6] * e[10] * e[25] + e[0] * e[20] * e[11] +
          e[0] * e[19] * e[10] - e[9] * e[26] * e[8] - e[9] * e[22] * e[4] -
          e[9] * e[25] * e[7] - e[9] * e[23] * e[5] + e[12] * e[0] * e[21] +
          e[12] * e[19] * e[4] + e[12] * e[1] * e[22] + e[12] * e[20] * e[5] +
          e[12] * e[2] * e[23] - e[18] * e[13] * e[4] - e[18] * e[16] * e[7] -
          e[18] * e[14] * e[5] - e[18] * e[17] * e[8] + e[21] * e[10] * e[4] +
          e[21] * e[1] * e[13] + e[21] * e[11] * e[5] + e[21] * e[2] * e[14] +
          e[15] * e[0] * e[24] + e[15] * e[19] * e[7] + e[15] * e[1] * e[25] +
          e[15] * e[20] * e[8] + e[15] * e[2] * e[26] - e[0] * e[23] * e[14] -
          e[0] * e[25] * e[16] - e[0] * e[26] * e[17] - e[0] * e[22] * e[13] +
          e[24] * e[10] * e[7] + e[24] * e[1] * e[16];
  a[26] = e[11] * e[1] * e[4] + e[11] * e[0] * e[3] + e[11] * e[2] * e[5] +
          e[5] * e[12] * e[3] + e[5] * e[13] * e[4] + e[8] * e[12] * e[6] +
          e[8] * e[3] * e[15] + e[8] * e[13] * e[7] + e[8] * e[4] * e[16] +
          e[8] * e[5] * e[17] + e[17] * e[4] * e[7] + e[17] * e[3] * e[6] -
          e[5] * e[10] * e[1] - e[5] * e[16] * e[7] - e[5] * e[15] * e[6] -
          e[5] * e[9] * e[0] + e[2] * e[9] * e[3] + e[2] * e[0] * e[12] +
          e[2] * e[10] * e[4] + e[2] * e[1] * e[13] + 0.5 * e2[2] * e[14] -
          0.5 * e[14] * e2[0] - 0.5 * e[14] * e2[6] - 0.5 * e[14] * e2[1] -
          0.5 * e[14] * e2[7] + 1.5 * e[14] * e2[5] + 0.5 * e[14] * e2[4] +
          0.5 * e[14] * e2[3] + 0.5 * e[14] * e2[8];
  a[91] = e[3] * e[27] * e[12] + e[3] * e[9] * e[30] + e[3] * e[29] * e[14] +
          e[3] * e[11] * e[32] + e[3] * e[28] * e[13] + e[3] * e[10] * e[31] +
          e[6] * e[27] * e[15] + e[6] * e[9] * e[33] + e[6] * e[29] * e[17] +
          e[6] * e[11] * e[35] + e[6] * e[28] * e[16] + e[6] * e[10] * e[34] +
          3. * e[0] * e[27] * e[9] + e[0] * e[29] * e[11] +
          e[0] * e[28] * e[10] - e[9] * e[34] * e[7] - e[9] * e[32] * e[5] -
          e[9] * e[35] * e[8] + e[9] * e[29] * e[2] + e[9] * e[28] * e[1] -
          e[9] * e[31] * e[4] + e[12] * e[0] * e[30] + e[12] * e[28] * e[4] +
          e[12] * e[1] * e[31] + e[12] * e[29] * e[5] + e[12] * e[2] * e[32] +
          e[27] * e[11] * e[2] + e[27] * e[10] * e[1] - e[27] * e[13] * e[4] -
          e[27] * e[16] * e[7] - e[27] * e[14] * e[5] - e[27] * e[17] * e[8] +
          e[30] * e[10] * e[4] + e[30] * e[1] * e[13] + e[30] * e[11] * e[5] +
          e[30] * e[2] * e[14] + e[15] * e[0] * e[33] + e[15] * e[28] * e[7] +
          e[15] * e[1] * e[34] + e[15] * e[29] * e[8] + e[15] * e[2] * e[35] -
          e[0] * e[31] * e[13] - e[0] * e[32] * e[14] - e[0] * e[34] * e[16] -
          e[0] * e[35] * e[17] + e[33] * e[10] * e[7] + e[33] * e[1] * e[16] +
          e[33] * e[11] * e[8] + e[33] * e[2] * e[17];
  a[127] = 0.5 * e2[30] * e[6] + 0.5 * e[6] * e2[27] - 0.5 * e[6] * e2[32] -
           0.5 * e[6] * e2[28] - 0.5 * e[6] * e2[29] - 0.5 * e[6] * e2[31] +
           1.5 * e[6] * e2[33] + 0.5 * e[6] * e2[34] + 0.5 * e[6] * e2[35] +
           e[0] * e[27] * e[33] + e[0] * e[29] * e[35] + e[0] * e[28] * e[34] +
           e[3] * e[30] * e[33] + e[3] * e[32] * e[35] + e[3] * e[31] * e[34] +
           e[30] * e[31] * e[7] + e[30] * e[4] * e[34] + e[30] * e[32] * e[8] +
           e[30] * e[5] * e[35] + e[27] * e[28] * e[7] + e[27] * e[1] * e[34] +
           e[27] * e[29] * e[8] + e[27] * e[2] * e[35] + e[33] * e[34] * e[7] +
           e[33] * e[35] * e[8] - e[33] * e[32] * e[5] - e[33] * e[29] * e[2] -
           e[33] * e[28] * e[1] - e[33] * e[31] * e[4];
  a[161] = e[24] * e[20] * e[26] + e[21] * e[19] * e[22] -
           0.5 * e[18] * e2[22] - 0.5 * e[18] * e2[25] + 0.5 * e3[18] +
           0.5 * e[18] * e2[21] + e[21] * e[20] * e[23] + 0.5 * e[18] * e2[20] +
           0.5 * e[18] * e2[19] + 0.5 * e[18] * e2[24] + e[24] * e[19] * e[25] -
           0.5 * e[18] * e2[23] - 0.5 * e[18] * e2[26];
  a[197] = 0.5 * e[33] * e2[35] + 0.5 * e3[33] + 0.5 * e2[27] * e[33] +
           0.5 * e2[30] * e[33] - 0.5 * e[33] * e2[29] + 0.5 * e[33] * e2[34] -
           0.5 * e[33] * e2[32] - 0.5 * e[33] * e2[28] + e[30] * e[32] * e[35] -
           0.5 * e[33] * e2[31] + e[27] * e[29] * e[35] +
           e[27] * e[28] * e[34] + e[30] * e[31] * e[34];
  a[171] =
      1.5 * e[27] * e2[18] + 0.5 * e[27] * e2[19] + 0.5 * e[27] * e2[20] +
      0.5 * e[27] * e2[21] + 0.5 * e[27] * e2[24] - 0.5 * e[27] * e2[26] -
      0.5 * e[27] * e2[23] - 0.5 * e[27] * e2[22] - 0.5 * e[27] * e2[25] +
      e[33] * e[20] * e[26] - e[18] * e[35] * e[26] - e[18] * e[31] * e[22] -
      e[18] * e[32] * e[23] - e[18] * e[34] * e[25] + e[18] * e[28] * e[19] +
      e[18] * e[29] * e[20] + e[21] * e[18] * e[30] + e[21] * e[28] * e[22] +
      e[21] * e[19] * e[31] + e[21] * e[29] * e[23] + e[21] * e[20] * e[32] +
      e[30] * e[19] * e[22] + e[30] * e[20] * e[23] + e[24] * e[18] * e[33] +
      e[24] * e[28] * e[25] + e[24] * e[19] * e[34] + e[24] * e[29] * e[26] +
      e[24] * e[20] * e[35] + e[33] * e[19] * e[25];
  a[157] =
      e[9] * e[27] * e[33] + e[9] * e[29] * e[35] + e[9] * e[28] * e[34] +
      e[33] * e[35] * e[17] + e[33] * e[34] * e[16] + e[27] * e[29] * e[17] +
      e[27] * e[11] * e[35] + e[27] * e[28] * e[16] + e[27] * e[10] * e[34] +
      e[33] * e[30] * e[12] - e[33] * e[28] * e[10] - e[33] * e[31] * e[13] -
      e[33] * e[32] * e[14] - e[33] * e[29] * e[11] + e[30] * e[32] * e[17] +
      e[30] * e[14] * e[35] + e[30] * e[31] * e[16] + e[30] * e[13] * e[34] +
      e[12] * e[32] * e[35] + e[12] * e[31] * e[34] + 0.5 * e[15] * e2[27] -
      0.5 * e[15] * e2[32] - 0.5 * e[15] * e2[28] - 0.5 * e[15] * e2[29] -
      0.5 * e[15] * e2[31] + 1.5 * e[15] * e2[33] + 0.5 * e[15] * e2[30] +
      0.5 * e[15] * e2[34] + 0.5 * e[15] * e2[35];
  a[11] = 0.5 * e[9] * e2[12] - 0.5 * e[9] * e2[16] + 0.5 * e[9] * e2[10] -
          0.5 * e[9] * e2[17] - 0.5 * e[9] * e2[13] + e[15] * e[10] * e[16] +
          e[12] * e[11] * e[14] + 0.5 * e[9] * e2[11] + 0.5 * e[9] * e2[15] -
          0.5 * e[9] * e2[14] + e[15] * e[11] * e[17] + 0.5 * e3[9] +
          e[12] * e[10] * e[13];
  a[187] =
      e[18] * e[27] * e[33] + e[18] * e[29] * e[35] + e[18] * e[28] * e[34] +
      e[27] * e[28] * e[25] + e[27] * e[19] * e[34] + e[27] * e[29] * e[26] +
      e[27] * e[20] * e[35] + e[21] * e[30] * e[33] + e[21] * e[32] * e[35] +
      e[21] * e[31] * e[34] + e[30] * e[31] * e[25] + e[30] * e[22] * e[34] +
      e[30] * e[32] * e[26] + e[30] * e[23] * e[35] + e[33] * e[34] * e[25] +
      e[33] * e[35] * e[26] - e[33] * e[29] * e[20] - e[33] * e[31] * e[22] -
      e[33] * e[32] * e[23] - e[33] * e[28] * e[19] + 0.5 * e2[27] * e[24] +
      0.5 * e2[30] * e[24] + 1.5 * e[24] * e2[33] + 0.5 * e[24] * e2[35] +
      0.5 * e[24] * e2[34] - 0.5 * e[24] * e2[32] - 0.5 * e[24] * e2[28] -
      0.5 * e[24] * e2[29] - 0.5 * e[24] * e2[31];
  a[131] =
      0.5 * e[9] * e2[21] + 0.5 * e[9] * e2[24] + 0.5 * e[9] * e2[19] +
      1.5 * e[9] * e2[18] + 0.5 * e[9] * e2[20] - 0.5 * e[9] * e2[26] -
      0.5 * e[9] * e2[23] - 0.5 * e[9] * e2[22] - 0.5 * e[9] * e2[25] +
      e[21] * e[18] * e[12] + e[21] * e[20] * e[14] + e[21] * e[11] * e[23] +
      e[21] * e[19] * e[13] + e[21] * e[10] * e[22] + e[24] * e[18] * e[15] +
      e[24] * e[20] * e[17] + e[24] * e[11] * e[26] + e[24] * e[19] * e[16] +
      e[24] * e[10] * e[25] + e[15] * e[19] * e[25] + e[15] * e[20] * e[26] +
      e[12] * e[19] * e[22] + e[12] * e[20] * e[23] + e[18] * e[20] * e[11] +
      e[18] * e[19] * e[10] - e[18] * e[23] * e[14] - e[18] * e[25] * e[16] -
      e[18] * e[26] * e[17] - e[18] * e[22] * e[13];
  a[189] =
      0.5 * e2[29] * e[26] + 0.5 * e2[32] * e[26] + 0.5 * e[26] * e2[33] +
      1.5 * e[26] * e2[35] + 0.5 * e[26] * e2[34] - 0.5 * e[26] * e2[27] -
      0.5 * e[26] * e2[28] - 0.5 * e[26] * e2[31] - 0.5 * e[26] * e2[30] +
      e[20] * e[27] * e[33] + e[20] * e[29] * e[35] + e[20] * e[28] * e[34] +
      e[29] * e[27] * e[24] + e[29] * e[18] * e[33] + e[29] * e[28] * e[25] +
      e[29] * e[19] * e[34] + e[23] * e[30] * e[33] + e[23] * e[32] * e[35] +
      e[23] * e[31] * e[34] + e[32] * e[30] * e[24] + e[32] * e[21] * e[33] +
      e[32] * e[31] * e[25] + e[32] * e[22] * e[34] + e[35] * e[33] * e[24] +
      e[35] * e[34] * e[25] - e[35] * e[27] * e[18] - e[35] * e[30] * e[21] -
      e[35] * e[31] * e[22] - e[35] * e[28] * e[19];
  a[141] =
      e[12] * e[19] * e[31] + e[12] * e[29] * e[23] + e[12] * e[20] * e[32] +
      3. * e[9] * e[27] * e[18] + e[9] * e[28] * e[19] + e[9] * e[29] * e[20] +
      e[21] * e[9] * e[30] + e[21] * e[29] * e[14] + e[21] * e[11] * e[32] +
      e[21] * e[28] * e[13] + e[21] * e[10] * e[31] + e[30] * e[20] * e[14] +
      e[30] * e[11] * e[23] + e[30] * e[19] * e[13] + e[30] * e[10] * e[22] +
      e[9] * e[33] * e[24] - e[9] * e[35] * e[26] - e[9] * e[31] * e[22] -
      e[9] * e[32] * e[23] - e[9] * e[34] * e[25] + e[18] * e[29] * e[11] +
      e[18] * e[28] * e[10] + e[27] * e[20] * e[11] + e[27] * e[19] * e[10] +
      e[15] * e[27] * e[24] + e[15] * e[18] * e[33] + e[15] * e[28] * e[25] +
      e[15] * e[19] * e[34] + e[15] * e[29] * e[26] + e[15] * e[20] * e[35] -
      e[18] * e[31] * e[13] - e[18] * e[32] * e[14] - e[18] * e[34] * e[16] -
      e[18] * e[35] * e[17] - e[27] * e[23] * e[14] - e[27] * e[25] * e[16] -
      e[27] * e[26] * e[17] - e[27] * e[22] * e[13] + e[24] * e[29] * e[17] +
      e[24] * e[11] * e[35] + e[24] * e[28] * e[16] + e[24] * e[10] * e[34] +
      e[33] * e[20] * e[17] + e[33] * e[11] * e[26] + e[33] * e[19] * e[16] +
      e[33] * e[10] * e[25] + e[12] * e[27] * e[21] + e[12] * e[18] * e[30] +
      e[12] * e[28] * e[22];
  a[159] =
      -0.5 * e[17] * e2[27] + 0.5 * e[17] * e2[32] - 0.5 * e[17] * e2[28] +
      0.5 * e[17] * e2[29] - 0.5 * e[17] * e2[31] + 0.5 * e[17] * e2[33] -
      0.5 * e[17] * e2[30] + 0.5 * e[17] * e2[34] + 1.5 * e[17] * e2[35] +
      e[32] * e[30] * e[15] + e[32] * e[12] * e[33] + e[32] * e[31] * e[16] +
      e[32] * e[13] * e[34] + e[14] * e[30] * e[33] + e[14] * e[31] * e[34] +
      e[11] * e[27] * e[33] + e[11] * e[29] * e[35] + e[11] * e[28] * e[34] +
      e[35] * e[33] * e[15] + e[35] * e[34] * e[16] + e[29] * e[27] * e[15] +
      e[29] * e[9] * e[33] + e[29] * e[28] * e[16] + e[29] * e[10] * e[34] -
      e[35] * e[27] * e[9] - e[35] * e[30] * e[12] - e[35] * e[28] * e[10] -
      e[35] * e[31] * e[13] + e[35] * e[32] * e[14];
  a[21] = 0.5 * e[9] * e2[1] + 1.5 * e[9] * e2[0] + 0.5 * e[9] * e2[2] +
          0.5 * e[9] * e2[3] + 0.5 * e[9] * e2[6] - 0.5 * e[9] * e2[4] -
          0.5 * e[9] * e2[5] - 0.5 * e[9] * e2[7] - 0.5 * e[9] * e2[8] +
          e[6] * e[0] * e[15] + e[6] * e[10] * e[7] + e[6] * e[1] * e[16] +
          e[6] * e[11] * e[8] + e[6] * e[2] * e[17] + e[15] * e[1] * e[7] +
          e[15] * e[2] * e[8] + e[0] * e[11] * e[2] + e[0] * e[10] * e[1] -
          e[0] * e[13] * e[4] - e[0] * e[16] * e[7] - e[0] * e[14] * e[5] -
          e[0] * e[17] * e[8] + e[3] * e[0] * e[12] + e[3] * e[10] * e[4] +
          e[3] * e[1] * e[13] + e[3] * e[11] * e[5] + e[3] * e[2] * e[14] +
          e[12] * e[1] * e[4] + e[12] * e[2] * e[5];
  a[199] = 0.5 * e[35] * e2[33] + 0.5 * e[35] * e2[34] - 0.5 * e[35] * e2[27] -
           0.5 * e[35] * e2[28] - 0.5 * e[35] * e2[31] - 0.5 * e[35] * e2[30] +
           e[32] * e[31] * e[34] + 0.5 * e2[29] * e[35] + 0.5 * e2[32] * e[35] +
           e[29] * e[28] * e[34] + e[32] * e[30] * e[33] + 0.5 * e3[35] +
           e[29] * e[27] * e[33];
  a[101] = 0.5 * e[0] * e2[19] + 0.5 * e[0] * e2[20] + 0.5 * e[0] * e2[24] -
           0.5 * e[0] * e2[26] - 0.5 * e[0] * e2[23] - 0.5 * e[0] * e2[22] -
           0.5 * e[0] * e2[25] + 1.5 * e2[18] * e[0] + 0.5 * e[0] * e2[21] +
           e[18] * e[19] * e[1] + e[18] * e[20] * e[2] + e[21] * e[18] * e[3] +
           e[21] * e[19] * e[4] + e[21] * e[1] * e[22] + e[21] * e[20] * e[5] +
           e[21] * e[2] * e[23] - e[18] * e[26] * e[8] - e[18] * e[22] * e[4] -
           e[18] * e[25] * e[7] - e[18] * e[23] * e[5] + e[18] * e[24] * e[6] +
           e[3] * e[19] * e[22] + e[3] * e[20] * e[23] + e[24] * e[19] * e[7] +
           e[24] * e[1] * e[25] + e[24] * e[20] * e[8] + e[24] * e[2] * e[26] +
           e[6] * e[19] * e[25] + e[6] * e[20] * e[26];
  a[129] = 0.5 * e2[32] * e[8] - 0.5 * e[8] * e2[27] - 0.5 * e[8] * e2[28] +
           0.5 * e[8] * e2[29] - 0.5 * e[8] * e2[31] + 0.5 * e[8] * e2[33] -
           0.5 * e[8] * e2[30] + 0.5 * e[8] * e2[34] + 1.5 * e[8] * e2[35] +
           e[2] * e[27] * e[33] + e[2] * e[29] * e[35] + e[2] * e[28] * e[34] +
           e[5] * e[30] * e[33] + e[5] * e[32] * e[35] + e[5] * e[31] * e[34] +
           e[32] * e[30] * e[6] + e[32] * e[3] * e[33] + e[32] * e[31] * e[7] +
           e[32] * e[4] * e[34] + e[29] * e[27] * e[6] + e[29] * e[0] * e[33] +
           e[29] * e[28] * e[7] + e[29] * e[1] * e[34] + e[35] * e[33] * e[6] +
           e[35] * e[34] * e[7] - e[35] * e[27] * e[0] - e[35] * e[30] * e[3] -
           e[35] * e[28] * e[1] - e[35] * e[31] * e[4];
  a[41] = -0.5 * e[18] * e2[4] + 1.5 * e[18] * e2[0] + 0.5 * e[18] * e2[6] -
          0.5 * e[18] * e2[5] + 0.5 * e[18] * e2[1] - 0.5 * e[18] * e2[7] +
          0.5 * e[18] * e2[3] + 0.5 * e[18] * e2[2] - 0.5 * e[18] * e2[8] +
          e[3] * e[0] * e[21] + e[3] * e[19] * e[4] + e[3] * e[1] * e[22] +
          e[3] * e[20] * e[5] + e[3] * e[2] * e[23] + e[21] * e[1] * e[4] +
          e[21] * e[2] * e[5] + e[6] * e[0] * e[24] + e[6] * e[19] * e[7] +
          e[6] * e[1] * e[25] + e[6] * e[20] * e[8] + e[6] * e[2] * e[26] +
          e[24] * e[1] * e[7] + e[24] * e[2] * e[8] + e[0] * e[19] * e[1] +
          e[0] * e[20] * e[2] - e[0] * e[26] * e[8] - e[0] * e[22] * e[4] -
          e[0] * e[25] * e[7] - e[0] * e[23] * e[5];
  a[28] = e[10] * e[1] * e[7] + e[10] * e[0] * e[6] + e[10] * e[2] * e[8] +
          e[4] * e[12] * e[6] + e[4] * e[3] * e[15] + e[4] * e[13] * e[7] +
          e[4] * e[14] * e[8] + e[4] * e[5] * e[17] + e[13] * e[3] * e[6] +
          e[13] * e[5] * e[8] + e[7] * e[15] * e[6] + e[7] * e[17] * e[8] -
          e[7] * e[11] * e[2] - e[7] * e[9] * e[0] - e[7] * e[14] * e[5] -
          e[7] * e[12] * e[3] + e[1] * e[9] * e[6] + e[1] * e[0] * e[15] +
          e[1] * e[11] * e[8] + e[1] * e[2] * e[17] + 1.5 * e[16] * e2[7] +
          0.5 * e[16] * e2[6] + 0.5 * e[16] * e2[8] + 0.5 * e2[1] * e[16] -
          0.5 * e[16] * e2[0] - 0.5 * e[16] * e2[5] - 0.5 * e[16] * e2[3] -
          0.5 * e[16] * e2[2] + 0.5 * e2[4] * e[16];
  a[111] = e[0] * e[30] * e[21] - e[0] * e[35] * e[26] - e[0] * e[31] * e[22] -
           e[0] * e[32] * e[23] - e[0] * e[34] * e[25] - e[18] * e[34] * e[7] -
           e[18] * e[32] * e[5] - e[18] * e[35] * e[8] - e[18] * e[31] * e[4] -
           e[27] * e[26] * e[8] - e[27] * e[22] * e[4] - e[27] * e[25] * e[7] -
           e[27] * e[23] * e[5] + e[6] * e[28] * e[25] + e[6] * e[19] * e[34] +
           e[6] * e[29] * e[26] + e[6] * e[20] * e[35] + e[21] * e[28] * e[4] +
           e[21] * e[1] * e[31] + e[21] * e[29] * e[5] + e[21] * e[2] * e[32] +
           e[30] * e[19] * e[4] + e[30] * e[1] * e[22] + e[30] * e[20] * e[5] +
           e[30] * e[2] * e[23] + e[24] * e[27] * e[6] + e[24] * e[0] * e[33] +
           e[24] * e[28] * e[7] + e[24] * e[1] * e[34] + e[24] * e[29] * e[8] +
           e[24] * e[2] * e[35] + e[33] * e[18] * e[6] + e[33] * e[19] * e[7] +
           e[33] * e[1] * e[25] + e[33] * e[20] * e[8] + e[33] * e[2] * e[26] +
           3. * e[0] * e[27] * e[18] + e[0] * e[28] * e[19] +
           e[0] * e[29] * e[20] + e[18] * e[28] * e[1] + e[18] * e[29] * e[2] +
           e[27] * e[19] * e[1] + e[27] * e[20] * e[2] + e[3] * e[27] * e[21] +
           e[3] * e[18] * e[30] + e[3] * e[28] * e[22] + e[3] * e[19] * e[31] +
           e[3] * e[29] * e[23] + e[3] * e[20] * e[32];
  a[108] = e[19] * e[18] * e[6] + e[19] * e[0] * e[24] + e[19] * e[1] * e[25] +
           e[19] * e[20] * e[8] + e[19] * e[2] * e[26] + e[22] * e[21] * e[6] +
           e[22] * e[3] * e[24] + e[22] * e[4] * e[25] + e[22] * e[23] * e[8] +
           e[22] * e[5] * e[26] - e[25] * e[21] * e[3] + e[25] * e[26] * e[8] -
           e[25] * e[20] * e[2] - e[25] * e[18] * e[0] - e[25] * e[23] * e[5] +
           e[25] * e[24] * e[6] + e[1] * e[18] * e[24] + e[1] * e[20] * e[26] +
           e[4] * e[21] * e[24] + e[4] * e[23] * e[26] + 0.5 * e2[19] * e[7] +
           0.5 * e2[22] * e[7] + 1.5 * e2[25] * e[7] + 0.5 * e[7] * e2[26] -
           0.5 * e[7] * e2[18] - 0.5 * e[7] * e2[23] - 0.5 * e[7] * e2[20] +
           0.5 * e[7] * e2[24] - 0.5 * e[7] * e2[21];
  a[61] = 0.5 * e[18] * e2[11] + 1.5 * e[18] * e2[9] + 0.5 * e[18] * e2[10] +
          0.5 * e[18] * e2[12] + 0.5 * e[18] * e2[15] - 0.5 * e[18] * e2[16] -
          0.5 * e[18] * e2[17] - 0.5 * e[18] * e2[14] - 0.5 * e[18] * e2[13] +
          e[12] * e[9] * e[21] + e[12] * e[20] * e[14] + e[12] * e[11] * e[23] +
          e[12] * e[19] * e[13] + e[12] * e[10] * e[22] +
          e[21] * e[11] * e[14] + e[21] * e[10] * e[13] + e[15] * e[9] * e[24] +
          e[15] * e[20] * e[17] + e[15] * e[11] * e[26] +
          e[15] * e[19] * e[16] + e[15] * e[10] * e[25] +
          e[24] * e[11] * e[17] + e[24] * e[10] * e[16] - e[9] * e[23] * e[14] -
          e[9] * e[25] * e[16] - e[9] * e[26] * e[17] + e[9] * e[20] * e[11] +
          e[9] * e[19] * e[10] - e[9] * e[22] * e[13];
  a[138] =
      e[13] * e[21] * e[24] + e[13] * e[23] * e[26] + e[19] * e[18] * e[15] +
      e[19] * e[9] * e[24] + e[19] * e[20] * e[17] + e[19] * e[11] * e[26] -
      e[25] * e[23] * e[14] - e[25] * e[20] * e[11] - e[25] * e[18] * e[9] -
      e[25] * e[21] * e[12] + e[22] * e[21] * e[15] + e[22] * e[12] * e[24] +
      e[22] * e[23] * e[17] + e[22] * e[14] * e[26] + e[22] * e[13] * e[25] +
      e[25] * e[24] * e[15] + e[25] * e[26] * e[17] + e[10] * e[19] * e[25] +
      e[10] * e[18] * e[24] + e[10] * e[20] * e[26] - 0.5 * e[16] * e2[18] -
      0.5 * e[16] * e2[23] + 0.5 * e[16] * e2[19] - 0.5 * e[16] * e2[20] -
      0.5 * e[16] * e2[21] + 0.5 * e2[22] * e[16] + 1.5 * e2[25] * e[16] +
      0.5 * e[16] * e2[24] + 0.5 * e[16] * e2[26];
  a[31] = 0.5 * e[0] * e2[12] + 0.5 * e[0] * e2[15] + 0.5 * e[0] * e2[11] +
          1.5 * e[0] * e2[9] + 0.5 * e[0] * e2[10] - 0.5 * e[0] * e2[16] -
          0.5 * e[0] * e2[17] - 0.5 * e[0] * e2[14] - 0.5 * e[0] * e2[13] +
          e[12] * e[9] * e[3] + e[12] * e[10] * e[4] + e[12] * e[1] * e[13] +
          e[12] * e[11] * e[5] + e[12] * e[2] * e[14] + e[15] * e[9] * e[6] +
          e[15] * e[10] * e[7] + e[15] * e[1] * e[16] + e[15] * e[11] * e[8] +
          e[15] * e[2] * e[17] + e[6] * e[11] * e[17] + e[6] * e[10] * e[16] +
          e[3] * e[11] * e[14] + e[3] * e[10] * e[13] + e[9] * e[10] * e[1] +
          e[9] * e[11] * e[2] - e[9] * e[13] * e[4] - e[9] * e[16] * e[7] -
          e[9] * e[14] * e[5] - e[9] * e[17] * e[8];
  a[148] =
      e[19] * e[11] * e[35] + e[28] * e[18] * e[15] + e[28] * e[9] * e[24] +
      e[28] * e[20] * e[17] + e[28] * e[11] * e[26] - e[25] * e[27] * e[9] -
      e[25] * e[30] * e[12] - e[25] * e[32] * e[14] + e[25] * e[33] * e[15] +
      e[25] * e[35] * e[17] - e[25] * e[29] * e[11] - e[34] * e[23] * e[14] +
      e[34] * e[24] * e[15] + e[34] * e[26] * e[17] - e[34] * e[20] * e[11] -
      e[34] * e[18] * e[9] - e[34] * e[21] * e[12] + e[13] * e[30] * e[24] +
      e[13] * e[21] * e[33] + e[13] * e[31] * e[25] + e[13] * e[22] * e[34] +
      e[13] * e[32] * e[26] + e[13] * e[23] * e[35] + e[10] * e[27] * e[24] +
      e[10] * e[18] * e[33] + e[10] * e[28] * e[25] + e[10] * e[19] * e[34] +
      e[10] * e[29] * e[26] + e[10] * e[20] * e[35] + e[22] * e[30] * e[15] +
      e[22] * e[12] * e[33] + e[22] * e[32] * e[17] + e[22] * e[14] * e[35] +
      e[22] * e[31] * e[16] + e[31] * e[21] * e[15] + e[31] * e[12] * e[24] +
      e[31] * e[23] * e[17] + e[31] * e[14] * e[26] - e[16] * e[27] * e[18] +
      e[16] * e[33] * e[24] - e[16] * e[30] * e[21] - e[16] * e[29] * e[20] +
      e[16] * e[35] * e[26] - e[16] * e[32] * e[23] + e[16] * e[28] * e[19] +
      3. * e[16] * e[34] * e[25] + e[19] * e[27] * e[15] +
      e[19] * e[9] * e[33] + e[19] * e[29] * e[17];
  a[52] = e[4] * e[27] * e[3] + e[4] * e[0] * e[30] + e[4] * e[29] * e[5] +
          e[4] * e[2] * e[32] + e[31] * e[0] * e[3] + e[31] * e[2] * e[5] +
          e[7] * e[27] * e[6] + e[7] * e[0] * e[33] + e[7] * e[29] * e[8] +
          e[7] * e[2] * e[35] + e[34] * e[0] * e[6] + e[34] * e[2] * e[8] +
          e[1] * e[27] * e[0] + e[1] * e[29] * e[2] + e[1] * e[34] * e[7] -
          e[1] * e[32] * e[5] - e[1] * e[33] * e[6] - e[1] * e[30] * e[3] -
          e[1] * e[35] * e[8] + e[1] * e[31] * e[4] + 1.5 * e[28] * e2[1] +
          0.5 * e[28] * e2[4] + 0.5 * e[28] * e2[0] - 0.5 * e[28] * e2[6] -
          0.5 * e[28] * e2[5] + 0.5 * e[28] * e2[7] - 0.5 * e[28] * e2[3] +
          0.5 * e[28] * e2[2] - 0.5 * e[28] * e2[8];
  a[99] = -e[35] * e[10] * e[1] - e[35] * e[13] * e[4] + e[35] * e[16] * e[7] +
          e[35] * e[15] * e[6] - e[35] * e[9] * e[0] - e[35] * e[12] * e[3] +
          e[32] * e[12] * e[6] + e[32] * e[3] * e[15] + e[32] * e[13] * e[7] +
          e[32] * e[4] * e[16] - e[8] * e[27] * e[9] - e[8] * e[30] * e[12] -
          e[8] * e[28] * e[10] - e[8] * e[31] * e[13] + e[8] * e[29] * e[11] +
          e[11] * e[27] * e[6] + e[11] * e[0] * e[33] + e[11] * e[28] * e[7] +
          e[11] * e[1] * e[34] + e[29] * e[9] * e[6] + e[29] * e[0] * e[15] +
          e[29] * e[10] * e[7] + e[29] * e[1] * e[16] + e[5] * e[30] * e[15] +
          e[5] * e[12] * e[33] + e[5] * e[32] * e[17] + e[5] * e[14] * e[35] +
          e[5] * e[31] * e[16] + e[5] * e[13] * e[34] + e[8] * e[33] * e[15] +
          3. * e[8] * e[35] * e[17] + e[8] * e[34] * e[16] +
          e[2] * e[27] * e[15] + e[2] * e[9] * e[33] + e[2] * e[29] * e[17] +
          e[2] * e[11] * e[35] + e[2] * e[28] * e[16] + e[2] * e[10] * e[34] -
          e[17] * e[27] * e[0] + e[17] * e[34] * e[7] + e[17] * e[33] * e[6] -
          e[17] * e[30] * e[3] - e[17] * e[28] * e[1] - e[17] * e[31] * e[4] +
          e[14] * e[30] * e[6] + e[14] * e[3] * e[33] + e[14] * e[31] * e[7] +
          e[14] * e[4] * e[34] + e[14] * e[32] * e[8];
  a[82] = e[19] * e[11] * e[2] + e[4] * e[18] * e[12] + e[4] * e[9] * e[21] +
          e[4] * e[20] * e[14] + e[4] * e[11] * e[23] + e[4] * e[19] * e[13] +
          e[4] * e[10] * e[22] + e[7] * e[18] * e[15] + e[7] * e[9] * e[24] +
          e[7] * e[20] * e[17] + e[7] * e[11] * e[26] + e[7] * e[19] * e[16] +
          e[7] * e[10] * e[25] + e[1] * e[18] * e[9] + e[1] * e[20] * e[11] -
          e[10] * e[21] * e[3] - e[10] * e[26] * e[8] - e[10] * e[23] * e[5] -
          e[10] * e[24] * e[6] + e[13] * e[18] * e[3] + e[13] * e[0] * e[21] +
          e[13] * e[1] * e[22] + e[13] * e[20] * e[5] + e[13] * e[2] * e[23] -
          e[19] * e[15] * e[6] - e[19] * e[14] * e[5] - e[19] * e[12] * e[3] -
          e[19] * e[17] * e[8] + e[22] * e[9] * e[3] + e[22] * e[0] * e[12] +
          e[22] * e[11] * e[5] + e[22] * e[2] * e[14] + e[16] * e[18] * e[6] +
          e[16] * e[0] * e[24] + e[16] * e[1] * e[25] + e[16] * e[20] * e[8] +
          e[16] * e[2] * e[26] - e[1] * e[23] * e[14] - e[1] * e[24] * e[15] -
          e[1] * e[26] * e[17] - e[1] * e[21] * e[12] + e[25] * e[9] * e[6] +
          e[25] * e[0] * e[15] + e[25] * e[11] * e[8] + e[25] * e[2] * e[17] +
          e[10] * e[18] * e[0] + 3. * e[10] * e[19] * e[1] +
          e[10] * e[20] * e[2] + e[19] * e[9] * e[0];
  a[169] = 0.5 * e2[23] * e[26] + 0.5 * e[26] * e2[25] + 0.5 * e2[20] * e[26] -
           0.5 * e[26] * e2[18] + 0.5 * e3[26] + 0.5 * e[26] * e2[24] +
           e[20] * e[19] * e[25] - 0.5 * e[26] * e2[19] - 0.5 * e[26] * e2[21] +
           e[20] * e[18] * e[24] - 0.5 * e[26] * e2[22] +
           e[23] * e[21] * e[24] + e[23] * e[22] * e[25];
  a[72] = e[16] * e[9] * e[33] + e[16] * e[29] * e[17] + e[16] * e[11] * e[35] +
          e[16] * e[10] * e[34] + e[34] * e[11] * e[17] + e[34] * e[9] * e[15] -
          e[10] * e[30] * e[12] - e[10] * e[32] * e[14] -
          e[10] * e[33] * e[15] - e[10] * e[35] * e[17] + e[10] * e[27] * e[9] +
          e[10] * e[29] * e[11] + e[13] * e[27] * e[12] + e[13] * e[9] * e[30] +
          e[13] * e[29] * e[14] + e[13] * e[11] * e[32] +
          e[13] * e[10] * e[31] + e[31] * e[11] * e[14] + e[31] * e[9] * e[12] +
          e[16] * e[27] * e[15] + 1.5 * e[28] * e2[10] + 0.5 * e[28] * e2[16] +
          0.5 * e[28] * e2[9] + 0.5 * e[28] * e2[11] - 0.5 * e[28] * e2[12] -
          0.5 * e[28] * e2[15] - 0.5 * e[28] * e2[17] - 0.5 * e[28] * e2[14] +
          0.5 * e[28] * e2[13];
  a[179] =
      0.5 * e2[20] * e[35] + 0.5 * e2[23] * e[35] + 1.5 * e[35] * e2[26] +
      0.5 * e[35] * e2[25] + 0.5 * e[35] * e2[24] - 0.5 * e[35] * e2[18] -
      0.5 * e[35] * e2[19] - 0.5 * e[35] * e2[22] - 0.5 * e[35] * e2[21] +
      e[20] * e[27] * e[24] + e[20] * e[18] * e[33] + e[20] * e[28] * e[25] +
      e[20] * e[19] * e[34] + e[20] * e[29] * e[26] + e[29] * e[19] * e[25] +
      e[29] * e[18] * e[24] + e[23] * e[30] * e[24] + e[23] * e[21] * e[33] +
      e[23] * e[31] * e[25] + e[23] * e[22] * e[34] + e[23] * e[32] * e[26] +
      e[32] * e[22] * e[25] + e[32] * e[21] * e[24] + e[26] * e[33] * e[24] +
      e[26] * e[34] * e[25] - e[26] * e[27] * e[18] - e[26] * e[30] * e[21] -
      e[26] * e[31] * e[22] - e[26] * e[28] * e[19];
  a[2] = e[4] * e[2] * e[5] + 0.5 * e[1] * e2[0] - 0.5 * e[1] * e2[6] +
         e[7] * e[0] * e[6] + 0.5 * e[1] * e2[7] + 0.5 * e[1] * e2[4] -
         0.5 * e[1] * e2[8] + 0.5 * e[1] * e2[2] - 0.5 * e[1] * e2[3] +
         0.5 * e3[1] + e[7] * e[2] * e[8] - 0.5 * e[1] * e2[5] +
         e[4] * e[0] * e[3];
  a[19] = -0.5 * e[17] * e2[13] - 0.5 * e[17] * e2[9] + 0.5 * e[17] * e2[16] +
          0.5 * e[17] * e2[15] + 0.5 * e3[17] - 0.5 * e[17] * e2[10] +
          e[14] * e[13] * e[16] + e[14] * e[12] * e[15] + 0.5 * e2[14] * e[17] +
          e[11] * e[10] * e[16] - 0.5 * e[17] * e2[12] + 0.5 * e2[11] * e[17] +
          e[11] * e[9] * e[15];
  a[122] = e[4] * e[27] * e[30] + e[4] * e[29] * e[32] + e[4] * e[28] * e[31] +
           e[31] * e[27] * e[3] + e[31] * e[0] * e[30] + e[31] * e[29] * e[5] +
           e[31] * e[2] * e[32] + e[7] * e[27] * e[33] + e[7] * e[29] * e[35] +
           e[7] * e[28] * e[34] + e[28] * e[27] * e[0] + e[28] * e[29] * e[2] +
           e[34] * e[27] * e[6] + e[34] * e[0] * e[33] + e[34] * e[29] * e[8] +
           e[34] * e[2] * e[35] - e[28] * e[32] * e[5] - e[28] * e[33] * e[6] -
           e[28] * e[30] * e[3] - e[28] * e[35] * e[8] + 0.5 * e[1] * e2[27] +
           0.5 * e[1] * e2[29] + 1.5 * e[1] * e2[28] + 0.5 * e[1] * e2[31] -
           0.5 * e[1] * e2[32] - 0.5 * e[1] * e2[33] - 0.5 * e[1] * e2[30] +
           0.5 * e[1] * e2[34] - 0.5 * e[1] * e2[35];
  a[79] = 0.5 * e2[11] * e[35] + 0.5 * e[35] * e2[16] - 0.5 * e[35] * e2[9] -
          0.5 * e[35] * e2[12] + 0.5 * e[35] * e2[15] + 1.5 * e[35] * e2[17] -
          0.5 * e[35] * e2[10] + 0.5 * e[35] * e2[14] - 0.5 * e[35] * e2[13] +
          e[11] * e[27] * e[15] + e[11] * e[9] * e[33] + e[11] * e[29] * e[17] +
          e[11] * e[28] * e[16] + e[11] * e[10] * e[34] + e[29] * e[9] * e[15] +
          e[29] * e[10] * e[16] + e[14] * e[30] * e[15] +
          e[14] * e[12] * e[33] + e[14] * e[32] * e[17] +
          e[14] * e[31] * e[16] + e[14] * e[13] * e[34] +
          e[32] * e[12] * e[15] + e[32] * e[13] * e[16] +
          e[17] * e[33] * e[15] + e[17] * e[34] * e[16] - e[17] * e[27] * e[9] -
          e[17] * e[30] * e[12] - e[17] * e[28] * e[10] - e[17] * e[31] * e[13];
  a[192] = e[34] * e[27] * e[33] + e[34] * e[29] * e[35] -
           0.5 * e[28] * e2[30] - 0.5 * e[28] * e2[35] + 0.5 * e3[28] +
           0.5 * e[28] * e2[27] + 0.5 * e[28] * e2[29] + e[31] * e[27] * e[30] +
           e[31] * e[29] * e[32] - 0.5 * e[28] * e2[32] - 0.5 * e[28] * e2[33] +
           0.5 * e[28] * e2[31] + 0.5 * e[28] * e2[34];
  a[9] = 0.5 * e2[5] * e[8] + e[2] * e[0] * e[6] + 0.5 * e2[2] * e[8] +
         0.5 * e3[8] - 0.5 * e[8] * e2[0] + e[5] * e[4] * e[7] +
         e[5] * e[3] * e[6] + 0.5 * e[8] * e2[7] + e[2] * e[1] * e[7] -
         0.5 * e[8] * e2[1] - 0.5 * e[8] * e2[4] - 0.5 * e[8] * e2[3] +
         0.5 * e[8] * e2[6];
  a[152] =
      e[28] * e[27] * e[9] + e[28] * e[29] * e[11] - e[28] * e[30] * e[12] +
      e[28] * e[31] * e[13] - e[28] * e[32] * e[14] - e[28] * e[33] * e[15] -
      e[28] * e[35] * e[17] + e[31] * e[27] * e[12] + e[31] * e[9] * e[30] +
      e[31] * e[29] * e[14] + e[31] * e[11] * e[32] + e[13] * e[27] * e[30] +
      e[13] * e[29] * e[32] + e[16] * e[27] * e[33] + e[16] * e[29] * e[35] +
      e[34] * e[27] * e[15] + e[34] * e[9] * e[33] + e[34] * e[29] * e[17] +
      e[34] * e[11] * e[35] + e[34] * e[28] * e[16] + 0.5 * e[10] * e2[27] +
      0.5 * e[10] * e2[29] + 1.5 * e[10] * e2[28] - 0.5 * e[10] * e2[32] +
      0.5 * e[10] * e2[31] - 0.5 * e[10] * e2[33] - 0.5 * e[10] * e2[30] +
      0.5 * e[10] * e2[34] - 0.5 * e[10] * e2[35];
  a[59] = -0.5 * e[35] * e2[1] + 0.5 * e[35] * e2[7] - 0.5 * e[35] * e2[3] +
          0.5 * e2[2] * e[35] + 1.5 * e[35] * e2[8] - 0.5 * e[35] * e2[4] -
          0.5 * e[35] * e2[0] + 0.5 * e[35] * e2[6] + 0.5 * e[35] * e2[5] +
          e[2] * e[27] * e[6] + e[2] * e[0] * e[33] + e[2] * e[28] * e[7] +
          e[2] * e[1] * e[34] + e[2] * e[29] * e[8] - e[8] * e[27] * e[0] +
          e[8] * e[34] * e[7] + e[8] * e[32] * e[5] + e[8] * e[33] * e[6] -
          e[8] * e[30] * e[3] - e[8] * e[28] * e[1] - e[8] * e[31] * e[4] +
          e[29] * e[1] * e[7] + e[29] * e[0] * e[6] + e[5] * e[30] * e[6] +
          e[5] * e[3] * e[33] + e[5] * e[31] * e[7] + e[5] * e[4] * e[34] +
          e[32] * e[4] * e[7] + e[32] * e[3] * e[6];
  a[182] =
      e[28] * e[27] * e[18] + e[28] * e[29] * e[20] + e[22] * e[27] * e[30] +
      e[22] * e[29] * e[32] + e[22] * e[28] * e[31] + e[31] * e[27] * e[21] +
      e[31] * e[18] * e[30] + e[31] * e[29] * e[23] + e[31] * e[20] * e[32] +
      e[25] * e[27] * e[33] + e[25] * e[29] * e[35] + e[25] * e[28] * e[34] +
      e[34] * e[27] * e[24] + e[34] * e[18] * e[33] + e[34] * e[29] * e[26] +
      e[34] * e[20] * e[35] - e[28] * e[33] * e[24] - e[28] * e[30] * e[21] -
      e[28] * e[35] * e[26] - e[28] * e[32] * e[23] - 0.5 * e[19] * e2[33] -
      0.5 * e[19] * e2[30] - 0.5 * e[19] * e2[35] + 0.5 * e[19] * e2[27] +
      0.5 * e[19] * e2[29] + 1.5 * e[19] * e2[28] + 0.5 * e[19] * e2[31] +
      0.5 * e[19] * e2[34] - 0.5 * e[19] * e2[32];
  a[89] = e[23] * e[3] * e[15] - e[17] * e[19] * e[1] - e[17] * e[22] * e[4] -
          e[17] * e[18] * e[0] + e[17] * e[25] * e[7] + e[17] * e[24] * e[6] +
          e[14] * e[21] * e[6] + e[14] * e[3] * e[24] + e[14] * e[22] * e[7] +
          e[14] * e[4] * e[25] + e[14] * e[23] * e[8] - e[26] * e[10] * e[1] -
          e[26] * e[13] * e[4] + e[26] * e[16] * e[7] + e[26] * e[15] * e[6] -
          e[26] * e[9] * e[0] - e[26] * e[12] * e[3] + e[23] * e[12] * e[6] +
          e[11] * e[18] * e[6] + e[11] * e[0] * e[24] + e[11] * e[19] * e[7] +
          e[11] * e[1] * e[25] + e[11] * e[20] * e[8] + e[11] * e[2] * e[26] +
          e[20] * e[9] * e[6] + e[20] * e[0] * e[15] + e[20] * e[10] * e[7] +
          e[20] * e[1] * e[16] + e[20] * e[2] * e[17] + e[5] * e[21] * e[15] +
          e[5] * e[12] * e[24] + e[5] * e[23] * e[17] + e[5] * e[14] * e[26] +
          e[5] * e[22] * e[16] + e[5] * e[13] * e[25] + e[8] * e[24] * e[15] +
          3. * e[8] * e[26] * e[17] + e[8] * e[25] * e[16] +
          e[2] * e[18] * e[15] + e[2] * e[9] * e[24] + e[2] * e[19] * e[16] +
          e[2] * e[10] * e[25] - e[17] * e[21] * e[3] + e[23] * e[4] * e[16] +
          e[23] * e[13] * e[7] - e[8] * e[18] * e[9] - e[8] * e[21] * e[12] -
          e[8] * e[19] * e[10] - e[8] * e[22] * e[13];
  a[62] = e[13] * e[18] * e[12] + e[13] * e[9] * e[21] + e[13] * e[20] * e[14] +
          e[13] * e[11] * e[23] + e[13] * e[10] * e[22] +
          e[22] * e[11] * e[14] + e[22] * e[9] * e[12] + e[16] * e[18] * e[15] +
          e[16] * e[9] * e[24] + e[16] * e[20] * e[17] + e[16] * e[11] * e[26] +
          e[16] * e[10] * e[25] + e[25] * e[11] * e[17] + e[25] * e[9] * e[15] -
          e[10] * e[23] * e[14] - e[10] * e[24] * e[15] -
          e[10] * e[26] * e[17] + e[10] * e[20] * e[11] + e[10] * e[18] * e[9] -
          e[10] * e[21] * e[12] + 0.5 * e[19] * e2[11] + 0.5 * e[19] * e2[9] +
          1.5 * e[19] * e2[10] + 0.5 * e[19] * e2[13] + 0.5 * e[19] * e2[16] -
          0.5 * e[19] * e2[12] - 0.5 * e[19] * e2[15] - 0.5 * e[19] * e2[17] -
          0.5 * e[19] * e2[14];
  a[88] = e[10] * e[18] * e[6] + e[10] * e[0] * e[24] + e[10] * e[19] * e[7] +
          e[10] * e[1] * e[25] + e[10] * e[20] * e[8] + e[10] * e[2] * e[26] +
          e[19] * e[9] * e[6] + e[19] * e[0] * e[15] + e[19] * e[1] * e[16] +
          e[19] * e[11] * e[8] + e[19] * e[2] * e[17] + e[4] * e[21] * e[15] +
          e[4] * e[12] * e[24] + e[4] * e[23] * e[17] + e[4] * e[14] * e[26] +
          e[4] * e[22] * e[16] + e[4] * e[13] * e[25] + e[7] * e[24] * e[15] +
          e[7] * e[26] * e[17] + 3. * e[7] * e[25] * e[16] +
          e[1] * e[18] * e[15] + e[1] * e[9] * e[24] + e[1] * e[20] * e[17] +
          e[1] * e[11] * e[26] - e[16] * e[21] * e[3] + e[16] * e[26] * e[8] -
          e[16] * e[20] * e[2] - e[16] * e[18] * e[0] - e[16] * e[23] * e[5] +
          e[16] * e[24] * e[6] + e[13] * e[21] * e[6] + e[13] * e[3] * e[24] +
          e[13] * e[22] * e[7] + e[13] * e[23] * e[8] + e[13] * e[5] * e[26] -
          e[25] * e[11] * e[2] + e[25] * e[15] * e[6] - e[25] * e[9] * e[0] -
          e[25] * e[14] * e[5] - e[25] * e[12] * e[3] + e[25] * e[17] * e[8] +
          e[22] * e[12] * e[6] + e[22] * e[3] * e[15] + e[22] * e[14] * e[8] +
          e[22] * e[5] * e[17] - e[7] * e[23] * e[14] - e[7] * e[20] * e[11] -
          e[7] * e[18] * e[9] - e[7] * e[21] * e[12];
  a[32] = e[13] * e[9] * e[3] + e[13] * e[0] * e[12] + e[13] * e[10] * e[4] +
          e[13] * e[11] * e[5] + e[13] * e[2] * e[14] + e[16] * e[9] * e[6] +
          e[16] * e[0] * e[15] + e[16] * e[10] * e[7] + e[16] * e[11] * e[8] +
          e[16] * e[2] * e[17] + e[7] * e[11] * e[17] + e[7] * e[9] * e[15] +
          e[4] * e[11] * e[14] + e[4] * e[9] * e[12] + e[10] * e[9] * e[0] +
          e[10] * e[11] * e[2] - e[10] * e[15] * e[6] - e[10] * e[14] * e[5] -
          e[10] * e[12] * e[3] - e[10] * e[17] * e[8] + 0.5 * e[1] * e2[11] +
          0.5 * e[1] * e2[9] + 1.5 * e[1] * e2[10] - 0.5 * e[1] * e2[12] -
          0.5 * e[1] * e2[15] - 0.5 * e[1] * e2[17] - 0.5 * e[1] * e2[14] +
          0.5 * e[1] * e2[13] + 0.5 * e[1] * e2[16];
  a[58] = e[1] * e[27] * e[6] + e[1] * e[0] * e[33] + e[1] * e[28] * e[7] +
          e[1] * e[29] * e[8] + e[1] * e[2] * e[35] - e[7] * e[27] * e[0] -
          e[7] * e[32] * e[5] + e[7] * e[33] * e[6] - e[7] * e[30] * e[3] +
          e[7] * e[35] * e[8] - e[7] * e[29] * e[2] + e[7] * e[31] * e[4] +
          e[28] * e[0] * e[6] + e[28] * e[2] * e[8] + e[4] * e[30] * e[6] +
          e[4] * e[3] * e[33] + e[4] * e[32] * e[8] + e[4] * e[5] * e[35] +
          e[31] * e[3] * e[6] + e[31] * e[5] * e[8] + 0.5 * e2[1] * e[34] +
          1.5 * e[34] * e2[7] + 0.5 * e[34] * e2[4] - 0.5 * e[34] * e2[0] +
          0.5 * e[34] * e2[6] - 0.5 * e[34] * e2[5] - 0.5 * e[34] * e2[3] -
          0.5 * e[34] * e2[2] + 0.5 * e[34] * e2[8];
  a[42] = e[4] * e[18] * e[3] + e[4] * e[0] * e[21] + e[4] * e[1] * e[22] +
          e[4] * e[20] * e[5] + e[4] * e[2] * e[23] + e[22] * e[0] * e[3] +
          e[22] * e[2] * e[5] + e[7] * e[18] * e[6] + e[7] * e[0] * e[24] +
          e[7] * e[1] * e[25] + e[7] * e[20] * e[8] + e[7] * e[2] * e[26] +
          e[25] * e[0] * e[6] + e[25] * e[2] * e[8] + e[1] * e[18] * e[0] +
          e[1] * e[20] * e[2] - e[1] * e[21] * e[3] - e[1] * e[26] * e[8] -
          e[1] * e[23] * e[5] - e[1] * e[24] * e[6] + 0.5 * e[19] * e2[4] +
          0.5 * e[19] * e2[0] - 0.5 * e[19] * e2[6] - 0.5 * e[19] * e2[5] +
          1.5 * e[19] * e2[1] + 0.5 * e[19] * e2[7] - 0.5 * e[19] * e2[3] +
          0.5 * e[19] * e2[2] - 0.5 * e[19] * e2[8];
  a[8] = -0.5 * e[7] * e2[0] + e[4] * e[5] * e[8] + 0.5 * e2[4] * e[7] -
         0.5 * e[7] * e2[2] + 0.5 * e[7] * e2[8] - 0.5 * e[7] * e2[5] +
         0.5 * e[7] * e2[6] + e[1] * e[0] * e[6] + 0.5 * e3[7] +
         e[4] * e[3] * e[6] + e[1] * e[2] * e[8] - 0.5 * e[7] * e2[3] +
         0.5 * e2[1] * e[7];
  a[112] = -e[1] * e[32] * e[23] - e[19] * e[32] * e[5] - e[19] * e[33] * e[6] -
           e[19] * e[30] * e[3] - e[19] * e[35] * e[8] - e[28] * e[21] * e[3] -
           e[28] * e[26] * e[8] - e[28] * e[23] * e[5] - e[28] * e[24] * e[6] +
           e[7] * e[27] * e[24] + e[7] * e[18] * e[33] + e[7] * e[29] * e[26] +
           e[7] * e[20] * e[35] + e[22] * e[27] * e[3] + e[22] * e[0] * e[30] +
           e[22] * e[29] * e[5] + e[22] * e[2] * e[32] + e[31] * e[18] * e[3] +
           e[31] * e[0] * e[21] + e[31] * e[20] * e[5] + e[31] * e[2] * e[23] +
           e[25] * e[27] * e[6] + e[25] * e[0] * e[33] + e[25] * e[28] * e[7] +
           e[25] * e[1] * e[34] + e[25] * e[29] * e[8] + e[25] * e[2] * e[35] +
           e[34] * e[18] * e[6] + e[34] * e[0] * e[24] + e[34] * e[19] * e[7] +
           e[34] * e[20] * e[8] + e[34] * e[2] * e[26] + e[1] * e[27] * e[18] +
           3. * e[1] * e[28] * e[19] + e[1] * e[29] * e[20] +
           e[19] * e[27] * e[0] + e[19] * e[29] * e[2] + e[28] * e[18] * e[0] +
           e[28] * e[20] * e[2] + e[4] * e[27] * e[21] + e[4] * e[18] * e[30] +
           e[4] * e[28] * e[22] + e[4] * e[19] * e[31] + e[4] * e[29] * e[23] +
           e[4] * e[20] * e[32] - e[1] * e[33] * e[24] - e[1] * e[30] * e[21] -
           e[1] * e[35] * e[26] + e[1] * e[31] * e[22];
  a[78] =
      e[10] * e[27] * e[15] + e[10] * e[9] * e[33] + e[10] * e[29] * e[17] +
      e[10] * e[11] * e[35] + e[10] * e[28] * e[16] + e[28] * e[11] * e[17] +
      e[28] * e[9] * e[15] + e[13] * e[30] * e[15] + e[13] * e[12] * e[33] +
      e[13] * e[32] * e[17] + e[13] * e[14] * e[35] + e[13] * e[31] * e[16] +
      e[31] * e[14] * e[17] + e[31] * e[12] * e[15] + e[16] * e[33] * e[15] +
      e[16] * e[35] * e[17] - e[16] * e[27] * e[9] - e[16] * e[30] * e[12] -
      e[16] * e[32] * e[14] - e[16] * e[29] * e[11] + 0.5 * e2[10] * e[34] +
      1.5 * e[34] * e2[16] - 0.5 * e[34] * e2[9] - 0.5 * e[34] * e2[11] -
      0.5 * e[34] * e2[12] + 0.5 * e[34] * e2[15] + 0.5 * e[34] * e2[17] -
      0.5 * e[34] * e2[14] + 0.5 * e[34] * e2[13];
  a[162] = 0.5 * e[19] * e2[18] + 0.5 * e[19] * e2[25] + 0.5 * e[19] * e2[22] +
           e[25] * e[20] * e[26] - 0.5 * e[19] * e2[21] + 0.5 * e[19] * e2[20] -
           0.5 * e[19] * e2[26] - 0.5 * e[19] * e2[23] - 0.5 * e[19] * e2[24] +
           0.5 * e3[19] + e[22] * e[20] * e[23] + e[25] * e[18] * e[24] +
           e[22] * e[18] * e[21];
  a[198] = 0.5 * e[34] * e2[33] + 0.5 * e[34] * e2[35] - 0.5 * e[34] * e2[27] -
           0.5 * e[34] * e2[32] - 0.5 * e[34] * e2[29] - 0.5 * e[34] * e2[30] +
           0.5 * e2[28] * e[34] + e[31] * e[30] * e[33] +
           e[31] * e[32] * e[35] + e[28] * e[27] * e[33] + 0.5 * e3[34] +
           e[28] * e[29] * e[35] + 0.5 * e2[31] * e[34];
  a[92] = e[4] * e[28] * e[13] + e[4] * e[10] * e[31] + e[7] * e[27] * e[15] +
          e[7] * e[9] * e[33] + e[7] * e[29] * e[17] + e[7] * e[11] * e[35] +
          e[7] * e[28] * e[16] + e[7] * e[10] * e[34] + e[1] * e[27] * e[9] +
          e[1] * e[29] * e[11] + 3. * e[1] * e[28] * e[10] +
          e[10] * e[27] * e[0] - e[10] * e[32] * e[5] - e[10] * e[33] * e[6] -
          e[10] * e[30] * e[3] - e[10] * e[35] * e[8] + e[10] * e[29] * e[2] +
          e[13] * e[27] * e[3] + e[13] * e[0] * e[30] + e[13] * e[1] * e[31] +
          e[13] * e[29] * e[5] + e[13] * e[2] * e[32] + e[28] * e[11] * e[2] -
          e[28] * e[15] * e[6] + e[28] * e[9] * e[0] - e[28] * e[14] * e[5] -
          e[28] * e[12] * e[3] - e[28] * e[17] * e[8] + e[31] * e[9] * e[3] +
          e[31] * e[0] * e[12] + e[31] * e[11] * e[5] + e[31] * e[2] * e[14] +
          e[16] * e[27] * e[6] + e[16] * e[0] * e[33] + e[16] * e[1] * e[34] +
          e[16] * e[29] * e[8] + e[16] * e[2] * e[35] - e[1] * e[30] * e[12] -
          e[1] * e[32] * e[14] - e[1] * e[33] * e[15] - e[1] * e[35] * e[17] +
          e[34] * e[9] * e[6] + e[34] * e[0] * e[15] + e[34] * e[11] * e[8] +
          e[34] * e[2] * e[17] + e[4] * e[27] * e[12] + e[4] * e[9] * e[30] +
          e[4] * e[29] * e[14] + e[4] * e[11] * e[32];
  a[128] = e[4] * e[30] * e[33] + e[4] * e[32] * e[35] + e[4] * e[31] * e[34] +
           e[31] * e[30] * e[6] + e[31] * e[3] * e[33] + e[31] * e[32] * e[8] +
           e[31] * e[5] * e[35] + e[28] * e[27] * e[6] + e[28] * e[0] * e[33] +
           e[28] * e[29] * e[8] + e[28] * e[2] * e[35] + e[34] * e[33] * e[6] +
           e[34] * e[35] * e[8] - e[34] * e[27] * e[0] - e[34] * e[32] * e[5] -
           e[34] * e[30] * e[3] - e[34] * e[29] * e[2] + e[1] * e[27] * e[33] +
           e[1] * e[29] * e[35] + e[1] * e[28] * e[34] + 0.5 * e2[31] * e[7] -
           0.5 * e[7] * e2[27] - 0.5 * e[7] * e2[32] + 0.5 * e[7] * e2[28] -
           0.5 * e[7] * e2[29] + 0.5 * e[7] * e2[33] - 0.5 * e[7] * e2[30] +
           1.5 * e[7] * e2[34] + 0.5 * e[7] * e2[35];
  a[12] = -0.5 * e[10] * e2[14] - 0.5 * e[10] * e2[17] - 0.5 * e[10] * e2[15] +
          e[13] * e[11] * e[14] + e[16] * e[11] * e[17] + 0.5 * e[10] * e2[13] +
          e[13] * e[9] * e[12] - 0.5 * e[10] * e2[12] + 0.5 * e3[10] +
          e[16] * e[9] * e[15] + 0.5 * e[10] * e2[16] + 0.5 * e[10] * e2[11] +
          0.5 * e[10] * e2[9];
  a[188] =
      e[22] * e[32] * e[35] + e[22] * e[31] * e[34] + e[31] * e[30] * e[24] +
      e[31] * e[21] * e[33] + e[31] * e[32] * e[26] + e[31] * e[23] * e[35] +
      e[34] * e[33] * e[24] + e[34] * e[35] * e[26] - e[34] * e[27] * e[18] -
      e[34] * e[30] * e[21] - e[34] * e[29] * e[20] - e[34] * e[32] * e[23] +
      e[19] * e[27] * e[33] + e[19] * e[29] * e[35] + e[19] * e[28] * e[34] +
      e[28] * e[27] * e[24] + e[28] * e[18] * e[33] + e[28] * e[29] * e[26] +
      e[28] * e[20] * e[35] + e[22] * e[30] * e[33] + 0.5 * e2[28] * e[25] +
      0.5 * e2[31] * e[25] + 0.5 * e[25] * e2[33] + 0.5 * e[25] * e2[35] +
      1.5 * e[25] * e2[34] - 0.5 * e[25] * e2[27] - 0.5 * e[25] * e2[32] -
      0.5 * e[25] * e2[29] - 0.5 * e[25] * e2[30];
  a[172] =
      -e[19] * e[35] * e[26] - e[19] * e[32] * e[23] + e[19] * e[27] * e[18] +
      e[19] * e[29] * e[20] + e[22] * e[27] * e[21] + e[22] * e[18] * e[30] +
      e[22] * e[19] * e[31] + e[22] * e[29] * e[23] + e[22] * e[20] * e[32] +
      e[31] * e[18] * e[21] + e[31] * e[20] * e[23] + e[25] * e[27] * e[24] +
      e[25] * e[18] * e[33] + e[25] * e[19] * e[34] + e[25] * e[29] * e[26] +
      e[25] * e[20] * e[35] + e[34] * e[18] * e[24] + e[34] * e[20] * e[26] -
      e[19] * e[33] * e[24] - e[19] * e[30] * e[21] + 1.5 * e[28] * e2[19] +
      0.5 * e[28] * e2[18] + 0.5 * e[28] * e2[20] + 0.5 * e[28] * e2[22] +
      0.5 * e[28] * e2[25] - 0.5 * e[28] * e2[26] - 0.5 * e[28] * e2[23] -
      0.5 * e[28] * e2[24] - 0.5 * e[28] * e2[21];
  a[158] =
      e[10] * e[27] * e[33] + e[10] * e[29] * e[35] + e[10] * e[28] * e[34] +
      e[34] * e[33] * e[15] + e[34] * e[35] * e[17] + e[28] * e[27] * e[15] +
      e[28] * e[9] * e[33] + e[28] * e[29] * e[17] + e[28] * e[11] * e[35] -
      e[34] * e[27] * e[9] - e[34] * e[30] * e[12] + e[34] * e[31] * e[13] -
      e[34] * e[32] * e[14] - e[34] * e[29] * e[11] + e[31] * e[30] * e[15] +
      e[31] * e[12] * e[33] + e[31] * e[32] * e[17] + e[31] * e[14] * e[35] +
      e[13] * e[30] * e[33] + e[13] * e[32] * e[35] - 0.5 * e[16] * e2[27] -
      0.5 * e[16] * e2[32] + 0.5 * e[16] * e2[28] - 0.5 * e[16] * e2[29] +
      0.5 * e[16] * e2[31] + 0.5 * e[16] * e2[33] - 0.5 * e[16] * e2[30] +
      1.5 * e[16] * e2[34] + 0.5 * e[16] * e2[35];
  a[153] =
      e[29] * e[32] * e[14] - e[29] * e[33] * e[15] - e[29] * e[34] * e[16] +
      e[32] * e[27] * e[12] + e[32] * e[9] * e[30] + e[32] * e[28] * e[13] +
      e[32] * e[10] * e[31] + e[14] * e[27] * e[30] + e[14] * e[28] * e[31] +
      e[17] * e[27] * e[33] + e[17] * e[28] * e[34] + e[35] * e[27] * e[15] +
      e[35] * e[9] * e[33] + e[35] * e[29] * e[17] + e[35] * e[28] * e[16] +
      e[35] * e[10] * e[34] + e[29] * e[27] * e[9] + e[29] * e[28] * e[10] -
      e[29] * e[30] * e[12] - e[29] * e[31] * e[13] + 0.5 * e[11] * e2[27] +
      1.5 * e[11] * e2[29] + 0.5 * e[11] * e2[28] + 0.5 * e[11] * e2[32] -
      0.5 * e[11] * e2[31] - 0.5 * e[11] * e2[33] - 0.5 * e[11] * e2[30] -
      0.5 * e[11] * e2[34] + 0.5 * e[11] * e2[35];
  a[118] = e[1] * e[20] * e[35] + e[19] * e[27] * e[6] + e[19] * e[0] * e[33] +
           e[19] * e[28] * e[7] + e[19] * e[29] * e[8] + e[19] * e[2] * e[35] +
           e[28] * e[18] * e[6] + e[28] * e[0] * e[24] + e[28] * e[20] * e[8] +
           e[28] * e[2] * e[26] + e[4] * e[30] * e[24] + e[4] * e[21] * e[33] +
           e[4] * e[31] * e[25] + e[4] * e[22] * e[34] + e[4] * e[32] * e[26] +
           e[4] * e[23] * e[35] - e[7] * e[27] * e[18] + e[7] * e[33] * e[24] -
           e[7] * e[30] * e[21] - e[7] * e[29] * e[20] + e[7] * e[35] * e[26] +
           e[7] * e[31] * e[22] - e[7] * e[32] * e[23] - e[25] * e[27] * e[0] -
           e[25] * e[32] * e[5] - e[25] * e[30] * e[3] - e[25] * e[29] * e[2] -
           e[34] * e[21] * e[3] - e[34] * e[20] * e[2] - e[34] * e[18] * e[0] -
           e[34] * e[23] * e[5] + e[22] * e[30] * e[6] + e[22] * e[3] * e[33] +
           e[22] * e[32] * e[8] + e[22] * e[5] * e[35] + e[31] * e[21] * e[6] +
           e[31] * e[3] * e[24] + e[31] * e[23] * e[8] + e[31] * e[5] * e[26] +
           e[34] * e[26] * e[8] + e[1] * e[27] * e[24] + e[1] * e[18] * e[33] +
           e[1] * e[28] * e[25] + e[1] * e[19] * e[34] + e[1] * e[29] * e[26] +
           e[34] * e[24] * e[6] + e[25] * e[33] * e[6] +
           3. * e[25] * e[34] * e[7] + e[25] * e[35] * e[8];
  a[183] =
      0.5 * e[20] * e2[27] + 1.5 * e[20] * e2[29] + 0.5 * e[20] * e2[28] +
      0.5 * e[20] * e2[32] + 0.5 * e[20] * e2[35] - 0.5 * e[20] * e2[31] -
      0.5 * e[20] * e2[33] - 0.5 * e[20] * e2[30] - 0.5 * e[20] * e2[34] +
      e[29] * e[27] * e[18] + e[29] * e[28] * e[19] + e[23] * e[27] * e[30] +
      e[23] * e[29] * e[32] + e[23] * e[28] * e[31] + e[32] * e[27] * e[21] +
      e[32] * e[18] * e[30] + e[32] * e[28] * e[22] + e[32] * e[19] * e[31] +
      e[26] * e[27] * e[33] + e[26] * e[29] * e[35] + e[26] * e[28] * e[34] +
      e[35] * e[27] * e[24] + e[35] * e[18] * e[33] + e[35] * e[28] * e[25] +
      e[35] * e[19] * e[34] - e[29] * e[33] * e[24] - e[29] * e[30] * e[21] -
      e[29] * e[31] * e[22] - e[29] * e[34] * e[25];
  a[48] = e[19] * e[1] * e[7] + e[19] * e[0] * e[6] + e[19] * e[2] * e[8] +
          e[4] * e[21] * e[6] + e[4] * e[3] * e[24] + e[4] * e[22] * e[7] +
          e[4] * e[23] * e[8] + e[4] * e[5] * e[26] + e[22] * e[3] * e[6] +
          e[22] * e[5] * e[8] + e[7] * e[24] * e[6] + e[7] * e[26] * e[8] +
          e[1] * e[18] * e[6] + e[1] * e[0] * e[24] + e[1] * e[20] * e[8] +
          e[1] * e[2] * e[26] - e[7] * e[21] * e[3] - e[7] * e[20] * e[2] -
          e[7] * e[18] * e[0] - e[7] * e[23] * e[5] + 0.5 * e[25] * e2[4] -
          0.5 * e[25] * e2[0] + 0.5 * e[25] * e2[6] - 0.5 * e[25] * e2[5] +
          0.5 * e[25] * e2[1] + 1.5 * e[25] * e2[7] - 0.5 * e[25] * e2[3] -
          0.5 * e[25] * e2[2] + 0.5 * e[25] * e2[8];
  a[123] = e[5] * e[27] * e[30] + e[5] * e[29] * e[32] + e[5] * e[28] * e[31] +
           e[32] * e[27] * e[3] + e[32] * e[0] * e[30] + e[32] * e[28] * e[4] +
           e[32] * e[1] * e[31] + e[8] * e[27] * e[33] + e[8] * e[29] * e[35] +
           e[8] * e[28] * e[34] + e[29] * e[27] * e[0] + e[29] * e[28] * e[1] +
           e[35] * e[27] * e[6] + e[35] * e[0] * e[33] + e[35] * e[28] * e[7] +
           e[35] * e[1] * e[34] - e[29] * e[34] * e[7] - e[29] * e[33] * e[6] -
           e[29] * e[30] * e[3] - e[29] * e[31] * e[4] + 0.5 * e[2] * e2[27] +
           1.5 * e[2] * e2[29] + 0.5 * e[2] * e2[28] + 0.5 * e[2] * e2[32] -
           0.5 * e[2] * e2[31] - 0.5 * e[2] * e2[33] - 0.5 * e[2] * e2[30] -
           0.5 * e[2] * e2[34] + 0.5 * e[2] * e2[35];
  a[38] = e[13] * e[12] * e[6] + e[13] * e[3] * e[15] + e[13] * e[4] * e[16] +
          e[13] * e[14] * e[8] + e[13] * e[5] * e[17] + e[16] * e[15] * e[6] +
          e[16] * e[17] * e[8] + e[1] * e[11] * e[17] + e[1] * e[9] * e[15] +
          e[1] * e[10] * e[16] + e[4] * e[14] * e[17] + e[4] * e[12] * e[15] +
          e[10] * e[9] * e[6] + e[10] * e[0] * e[15] + e[10] * e[11] * e[8] +
          e[10] * e[2] * e[17] - e[16] * e[11] * e[2] - e[16] * e[9] * e[0] -
          e[16] * e[14] * e[5] - e[16] * e[12] * e[3] + 0.5 * e2[13] * e[7] +
          1.5 * e2[16] * e[7] + 0.5 * e[7] * e2[17] + 0.5 * e[7] * e2[15] -
          0.5 * e[7] * e2[9] - 0.5 * e[7] * e2[11] - 0.5 * e[7] * e2[12] +
          0.5 * e[7] * e2[10] - 0.5 * e[7] * e2[14];
  a[193] = 0.5 * e[29] * e2[32] + 0.5 * e[29] * e2[35] - 0.5 * e[29] * e2[31] -
           0.5 * e[29] * e2[33] - 0.5 * e[29] * e2[30] - 0.5 * e[29] * e2[34] +
           e[32] * e[27] * e[30] + 0.5 * e3[29] + 0.5 * e[29] * e2[28] +
           e[35] * e[28] * e[34] + 0.5 * e[29] * e2[27] +
           e[35] * e[27] * e[33] + e[32] * e[28] * e[31];
  a[68] =
      -e[16] * e[21] * e[12] + e[10] * e[18] * e[15] + e[10] * e[9] * e[24] +
      e[10] * e[20] * e[17] + e[10] * e[11] * e[26] + e[19] * e[11] * e[17] +
      e[19] * e[9] * e[15] + e[19] * e[10] * e[16] + e[13] * e[21] * e[15] +
      e[13] * e[12] * e[24] + e[13] * e[23] * e[17] + e[13] * e[14] * e[26] +
      e[13] * e[22] * e[16] + e[22] * e[14] * e[17] + e[22] * e[12] * e[15] +
      e[16] * e[24] * e[15] + e[16] * e[26] * e[17] - e[16] * e[23] * e[14] -
      e[16] * e[20] * e[11] - e[16] * e[18] * e[9] + 0.5 * e2[13] * e[25] +
      1.5 * e[25] * e2[16] + 0.5 * e[25] * e2[17] + 0.5 * e[25] * e2[15] +
      0.5 * e2[10] * e[25] - 0.5 * e[25] * e2[9] - 0.5 * e[25] * e2[11] -
      0.5 * e[25] * e2[12] - 0.5 * e[25] * e2[14];
  a[102] = e[19] * e[20] * e[2] + e[22] * e[18] * e[3] + e[22] * e[0] * e[21] +
           e[22] * e[19] * e[4] + e[22] * e[20] * e[5] + e[22] * e[2] * e[23] -
           e[19] * e[21] * e[3] - e[19] * e[26] * e[8] + e[19] * e[25] * e[7] -
           e[19] * e[23] * e[5] - e[19] * e[24] * e[6] + e[4] * e[18] * e[21] +
           e[4] * e[20] * e[23] + e[25] * e[18] * e[6] + e[25] * e[0] * e[24] +
           e[25] * e[20] * e[8] + e[25] * e[2] * e[26] + e[7] * e[18] * e[24] +
           e[7] * e[20] * e[26] + e[19] * e[18] * e[0] + 1.5 * e2[19] * e[1] +
           0.5 * e[1] * e2[22] + 0.5 * e[1] * e2[18] + 0.5 * e[1] * e2[20] +
           0.5 * e[1] * e2[25] - 0.5 * e[1] * e2[26] - 0.5 * e[1] * e2[23] -
           0.5 * e[1] * e2[24] - 0.5 * e[1] * e2[21];
  a[178] =
      e[19] * e[27] * e[24] + e[19] * e[18] * e[33] + e[19] * e[28] * e[25] +
      e[19] * e[29] * e[26] + e[19] * e[20] * e[35] + e[28] * e[18] * e[24] +
      e[28] * e[20] * e[26] + e[22] * e[30] * e[24] + e[22] * e[21] * e[33] +
      e[22] * e[31] * e[25] + e[22] * e[32] * e[26] + e[22] * e[23] * e[35] +
      e[31] * e[21] * e[24] + e[31] * e[23] * e[26] + e[25] * e[33] * e[24] +
      e[25] * e[35] * e[26] - e[25] * e[27] * e[18] - e[25] * e[30] * e[21] -
      e[25] * e[29] * e[20] - e[25] * e[32] * e[23] - 0.5 * e[34] * e2[18] -
      0.5 * e[34] * e2[23] - 0.5 * e[34] * e2[20] - 0.5 * e[34] * e2[21] +
      0.5 * e2[19] * e[34] + 0.5 * e2[22] * e[34] + 1.5 * e[34] * e2[25] +
      0.5 * e[34] * e2[24] + 0.5 * e[34] * e2[26];
  a[22] = e[16] * e[0] * e[6] + e[16] * e[2] * e[8] + e[1] * e[11] * e[2] -
          e[1] * e[15] * e[6] + e[1] * e[9] * e[0] - e[1] * e[14] * e[5] -
          e[1] * e[12] * e[3] - e[1] * e[17] * e[8] + e[4] * e[9] * e[3] +
          e[4] * e[0] * e[12] + e[4] * e[1] * e[13] + e[4] * e[11] * e[5] +
          e[4] * e[2] * e[14] + e[13] * e[0] * e[3] + e[13] * e[2] * e[5] +
          e[7] * e[9] * e[6] + e[7] * e[0] * e[15] + e[7] * e[1] * e[16] +
          e[7] * e[11] * e[8] + e[7] * e[2] * e[17] - 0.5 * e[10] * e2[6] -
          0.5 * e[10] * e2[5] - 0.5 * e[10] * e2[3] - 0.5 * e[10] * e2[8] +
          1.5 * e[10] * e2[1] + 0.5 * e[10] * e2[0] + 0.5 * e[10] * e2[2] +
          0.5 * e[10] * e2[4] + 0.5 * e[10] * e2[7];
  a[18] = e[13] * e[14] * e[17] + e[13] * e[12] * e[15] + e[10] * e[9] * e[15] +
          0.5 * e[16] * e2[15] - 0.5 * e[16] * e2[11] - 0.5 * e[16] * e2[12] -
          0.5 * e[16] * e2[14] + e[10] * e[11] * e[17] + 0.5 * e2[10] * e[16] +
          0.5 * e3[16] - 0.5 * e[16] * e2[9] + 0.5 * e[16] * e2[17] +
          0.5 * e2[13] * e[16];
  a[142] =
      e[10] * e[29] * e[20] + e[22] * e[27] * e[12] + e[22] * e[9] * e[30] +
      e[22] * e[29] * e[14] + e[22] * e[11] * e[32] + e[22] * e[10] * e[31] +
      e[31] * e[18] * e[12] + e[31] * e[9] * e[21] + e[31] * e[20] * e[14] +
      e[31] * e[11] * e[23] - e[10] * e[33] * e[24] - e[10] * e[30] * e[21] -
      e[10] * e[35] * e[26] - e[10] * e[32] * e[23] + e[10] * e[34] * e[25] +
      e[19] * e[27] * e[9] + e[19] * e[29] * e[11] + e[28] * e[18] * e[9] +
      e[28] * e[20] * e[11] + e[16] * e[27] * e[24] + e[16] * e[18] * e[33] +
      e[16] * e[28] * e[25] + e[16] * e[19] * e[34] + e[16] * e[29] * e[26] +
      e[16] * e[20] * e[35] - e[19] * e[30] * e[12] - e[19] * e[32] * e[14] -
      e[19] * e[33] * e[15] - e[19] * e[35] * e[17] - e[28] * e[23] * e[14] -
      e[28] * e[24] * e[15] - e[28] * e[26] * e[17] - e[28] * e[21] * e[12] +
      e[25] * e[27] * e[15] + e[25] * e[9] * e[33] + e[25] * e[29] * e[17] +
      e[25] * e[11] * e[35] + e[34] * e[18] * e[15] + e[34] * e[9] * e[24] +
      e[34] * e[20] * e[17] + e[34] * e[11] * e[26] + e[13] * e[27] * e[21] +
      e[13] * e[18] * e[30] + e[13] * e[28] * e[22] + e[13] * e[19] * e[31] +
      e[13] * e[29] * e[23] + e[13] * e[20] * e[32] + e[10] * e[27] * e[18] +
      3. * e[10] * e[28] * e[19];
  a[98] = e[4] * e[30] * e[15] + e[4] * e[12] * e[33] + e[4] * e[32] * e[17] +
          e[4] * e[14] * e[35] + e[4] * e[31] * e[16] + e[4] * e[13] * e[34] +
          e[7] * e[33] * e[15] + e[7] * e[35] * e[17] +
          3. * e[7] * e[34] * e[16] + e[1] * e[27] * e[15] +
          e[1] * e[9] * e[33] + e[1] * e[29] * e[17] + e[1] * e[11] * e[35] +
          e[1] * e[28] * e[16] + e[1] * e[10] * e[34] - e[16] * e[27] * e[0] -
          e[16] * e[32] * e[5] + e[16] * e[33] * e[6] - e[16] * e[30] * e[3] +
          e[16] * e[35] * e[8] - e[16] * e[29] * e[2] + e[13] * e[30] * e[6] +
          e[13] * e[3] * e[33] + e[13] * e[31] * e[7] + e[13] * e[32] * e[8] +
          e[13] * e[5] * e[35] - e[34] * e[11] * e[2] + e[34] * e[15] * e[6] -
          e[34] * e[9] * e[0] - e[34] * e[14] * e[5] - e[34] * e[12] * e[3] +
          e[34] * e[17] * e[8] + e[31] * e[12] * e[6] + e[31] * e[3] * e[15] +
          e[31] * e[14] * e[8] + e[31] * e[5] * e[17] - e[7] * e[27] * e[9] -
          e[7] * e[30] * e[12] + e[7] * e[28] * e[10] - e[7] * e[32] * e[14] +
          e[10] * e[27] * e[6] + e[10] * e[0] * e[33] + e[10] * e[29] * e[8] +
          e[10] * e[2] * e[35] + e[28] * e[9] * e[6] + e[28] * e[0] * e[15] +
          e[28] * e[11] * e[8] + e[28] * e[2] * e[17] - e[7] * e[29] * e[11];
  a[132] =
      e[22] * e[18] * e[12] + e[22] * e[9] * e[21] + e[22] * e[20] * e[14] +
      e[22] * e[11] * e[23] + e[22] * e[19] * e[13] + e[25] * e[18] * e[15] +
      e[25] * e[9] * e[24] + e[25] * e[20] * e[17] + e[25] * e[11] * e[26] +
      e[25] * e[19] * e[16] + e[16] * e[18] * e[24] + e[16] * e[20] * e[26] +
      e[13] * e[18] * e[21] + e[13] * e[20] * e[23] + e[19] * e[18] * e[9] +
      e[19] * e[20] * e[11] - e[19] * e[23] * e[14] - e[19] * e[24] * e[15] -
      e[19] * e[26] * e[17] - e[19] * e[21] * e[12] + 0.5 * e[10] * e2[22] +
      0.5 * e[10] * e2[25] + 1.5 * e[10] * e2[19] + 0.5 * e[10] * e2[18] +
      0.5 * e[10] * e2[20] - 0.5 * e[10] * e2[26] - 0.5 * e[10] * e2[23] -
      0.5 * e[10] * e2[24] - 0.5 * e[10] * e2[21];
  a[168] = e[19] * e[20] * e[26] - 0.5 * e[25] * e2[20] +
           e[22] * e[21] * e[24] + e[19] * e[18] * e[24] +
           0.5 * e2[22] * e[25] - 0.5 * e[25] * e2[21] - 0.5 * e[25] * e2[23] +
           0.5 * e2[19] * e[25] - 0.5 * e[25] * e2[18] + 0.5 * e[25] * e2[24] +
           0.5 * e[25] * e2[26] + 0.5 * e3[25] + e[22] * e[23] * e[26];
  a[113] = -e[20] * e[33] * e[6] - e[20] * e[30] * e[3] - e[20] * e[31] * e[4] -
           e[29] * e[21] * e[3] - e[29] * e[22] * e[4] - e[29] * e[25] * e[7] -
           e[29] * e[24] * e[6] + e[8] * e[27] * e[24] + e[8] * e[18] * e[33] +
           e[8] * e[28] * e[25] + e[8] * e[19] * e[34] + e[23] * e[27] * e[3] +
           e[23] * e[0] * e[30] + e[23] * e[28] * e[4] + e[23] * e[1] * e[31] +
           e[32] * e[18] * e[3] + e[32] * e[0] * e[21] + e[32] * e[19] * e[4] +
           e[32] * e[1] * e[22] + e[26] * e[27] * e[6] + e[26] * e[0] * e[33] +
           e[26] * e[28] * e[7] + e[26] * e[1] * e[34] + e[26] * e[29] * e[8] +
           e[26] * e[2] * e[35] + e[35] * e[18] * e[6] + e[35] * e[0] * e[24] +
           e[35] * e[19] * e[7] + e[35] * e[1] * e[25] + e[35] * e[20] * e[8] +
           e[2] * e[27] * e[18] + e[2] * e[28] * e[19] +
           3. * e[2] * e[29] * e[20] + e[20] * e[27] * e[0] +
           e[20] * e[28] * e[1] + e[29] * e[18] * e[0] + e[29] * e[19] * e[1] +
           e[5] * e[27] * e[21] + e[5] * e[18] * e[30] + e[5] * e[28] * e[22] +
           e[5] * e[19] * e[31] + e[5] * e[29] * e[23] + e[5] * e[20] * e[32] -
           e[2] * e[33] * e[24] - e[2] * e[30] * e[21] - e[2] * e[31] * e[22] +
           e[2] * e[32] * e[23] - e[2] * e[34] * e[25] - e[20] * e[34] * e[7];
  a[43] = e[5] * e[18] * e[3] + e[5] * e[0] * e[21] + e[5] * e[19] * e[4] +
          e[5] * e[1] * e[22] + e[5] * e[2] * e[23] + e[23] * e[1] * e[4] +
          e[23] * e[0] * e[3] + e[8] * e[18] * e[6] + e[8] * e[0] * e[24] +
          e[8] * e[19] * e[7] + e[8] * e[1] * e[25] + e[8] * e[2] * e[26] +
          e[26] * e[1] * e[7] + e[26] * e[0] * e[6] + e[2] * e[18] * e[0] +
          e[2] * e[19] * e[1] - e[2] * e[21] * e[3] - e[2] * e[22] * e[4] -
          e[2] * e[25] * e[7] - e[2] * e[24] * e[6] - 0.5 * e[20] * e2[4] +
          0.5 * e[20] * e2[0] - 0.5 * e[20] * e2[6] + 0.5 * e[20] * e2[5] +
          0.5 * e[20] * e2[1] - 0.5 * e[20] * e2[7] - 0.5 * e[20] * e2[3] +
          1.5 * e[20] * e2[2] + 0.5 * e[20] * e2[8];
  a[33] = e[14] * e[9] * e[3] + e[14] * e[0] * e[12] + e[14] * e[10] * e[4] +
          e[14] * e[1] * e[13] + e[14] * e[11] * e[5] + e[17] * e[9] * e[6] +
          e[17] * e[0] * e[15] + e[17] * e[10] * e[7] + e[17] * e[1] * e[16] +
          e[17] * e[11] * e[8] + e[8] * e[9] * e[15] + e[8] * e[10] * e[16] +
          e[5] * e[9] * e[12] + e[5] * e[10] * e[13] + e[11] * e[9] * e[0] +
          e[11] * e[10] * e[1] - e[11] * e[13] * e[4] - e[11] * e[16] * e[7] -
          e[11] * e[15] * e[6] - e[11] * e[12] * e[3] + 0.5 * e[2] * e2[14] +
          0.5 * e[2] * e2[17] + 1.5 * e[2] * e2[11] + 0.5 * e[2] * e2[9] +
          0.5 * e[2] * e2[10] - 0.5 * e[2] * e2[16] - 0.5 * e[2] * e2[12] -
          0.5 * e[2] * e2[15] - 0.5 * e[2] * e2[13];
  a[63] = e[14] * e[18] * e[12] + e[14] * e[9] * e[21] + e[14] * e[11] * e[23] +
          e[14] * e[19] * e[13] + e[14] * e[10] * e[22] + e[23] * e[9] * e[12] +
          e[23] * e[10] * e[13] + e[17] * e[18] * e[15] + e[17] * e[9] * e[24] +
          e[17] * e[11] * e[26] + e[17] * e[19] * e[16] +
          e[17] * e[10] * e[25] + e[26] * e[9] * e[15] + e[26] * e[10] * e[16] -
          e[11] * e[24] * e[15] - e[11] * e[25] * e[16] + e[11] * e[18] * e[9] -
          e[11] * e[21] * e[12] + e[11] * e[19] * e[10] -
          e[11] * e[22] * e[13] + 1.5 * e[20] * e2[11] + 0.5 * e[20] * e2[9] +
          0.5 * e[20] * e2[10] + 0.5 * e[20] * e2[14] + 0.5 * e[20] * e2[17] -
          0.5 * e[20] * e2[16] - 0.5 * e[20] * e2[12] - 0.5 * e[20] * e2[15] -
          0.5 * e[20] * e2[13];
  a[143] =
      e[23] * e[10] * e[31] + e[32] * e[18] * e[12] + e[32] * e[9] * e[21] +
      e[32] * e[19] * e[13] + e[32] * e[10] * e[22] - e[11] * e[33] * e[24] -
      e[11] * e[30] * e[21] + e[11] * e[35] * e[26] - e[11] * e[31] * e[22] -
      e[11] * e[34] * e[25] + e[20] * e[27] * e[9] + e[20] * e[28] * e[10] +
      e[29] * e[18] * e[9] + e[29] * e[19] * e[10] + e[17] * e[27] * e[24] +
      e[17] * e[18] * e[33] + e[17] * e[28] * e[25] + e[17] * e[19] * e[34] +
      e[17] * e[29] * e[26] + e[17] * e[20] * e[35] - e[20] * e[30] * e[12] -
      e[20] * e[31] * e[13] - e[20] * e[33] * e[15] - e[20] * e[34] * e[16] -
      e[29] * e[24] * e[15] - e[29] * e[25] * e[16] - e[29] * e[21] * e[12] -
      e[29] * e[22] * e[13] + e[26] * e[27] * e[15] + e[26] * e[9] * e[33] +
      e[26] * e[28] * e[16] + e[26] * e[10] * e[34] + e[35] * e[18] * e[15] +
      e[35] * e[9] * e[24] + e[35] * e[19] * e[16] + e[35] * e[10] * e[25] +
      e[14] * e[27] * e[21] + e[14] * e[18] * e[30] + e[14] * e[28] * e[22] +
      e[14] * e[19] * e[31] + e[14] * e[29] * e[23] + e[14] * e[20] * e[32] +
      e[11] * e[27] * e[18] + e[11] * e[28] * e[19] +
      3. * e[11] * e[29] * e[20] + e[23] * e[27] * e[12] +
      e[23] * e[9] * e[30] + e[23] * e[11] * e[32] + e[23] * e[28] * e[13];
  a[133] =
      e[23] * e[18] * e[12] + e[23] * e[9] * e[21] + e[23] * e[20] * e[14] +
      e[23] * e[19] * e[13] + e[23] * e[10] * e[22] + e[26] * e[18] * e[15] +
      e[26] * e[9] * e[24] + e[26] * e[20] * e[17] + e[26] * e[19] * e[16] +
      e[26] * e[10] * e[25] + e[17] * e[19] * e[25] + e[17] * e[18] * e[24] +
      e[14] * e[19] * e[22] + e[14] * e[18] * e[21] + e[20] * e[18] * e[9] +
      e[20] * e[19] * e[10] - e[20] * e[24] * e[15] - e[20] * e[25] * e[16] -
      e[20] * e[21] * e[12] - e[20] * e[22] * e[13] + 0.5 * e[11] * e2[23] +
      0.5 * e[11] * e2[26] + 0.5 * e[11] * e2[19] + 0.5 * e[11] * e2[18] +
      1.5 * e[11] * e2[20] - 0.5 * e[11] * e2[22] - 0.5 * e[11] * e2[24] -
      0.5 * e[11] * e2[21] - 0.5 * e[11] * e2[25];
  a[103] = -e[20] * e[21] * e[3] + e[20] * e[26] * e[8] - e[20] * e[22] * e[4] -
           e[20] * e[25] * e[7] - e[20] * e[24] * e[6] + e[5] * e[19] * e[22] +
           e[5] * e[18] * e[21] + e[26] * e[18] * e[6] + e[26] * e[0] * e[24] +
           e[26] * e[19] * e[7] + e[26] * e[1] * e[25] + e[8] * e[19] * e[25] +
           e[8] * e[18] * e[24] + e[20] * e[18] * e[0] + e[20] * e[19] * e[1] +
           e[23] * e[18] * e[3] + e[23] * e[0] * e[21] + e[23] * e[19] * e[4] +
           e[23] * e[1] * e[22] + e[23] * e[20] * e[5] + 1.5 * e2[20] * e[2] +
           0.5 * e[2] * e2[23] + 0.5 * e[2] * e2[19] + 0.5 * e[2] * e2[18] +
           0.5 * e[2] * e2[26] - 0.5 * e[2] * e2[22] - 0.5 * e[2] * e2[24] -
           0.5 * e[2] * e2[21] - 0.5 * e[2] * e2[25];
  a[23] = -e[2] * e[15] * e[6] + e[2] * e[9] * e[0] - e[2] * e[12] * e[3] +
          e[5] * e[9] * e[3] + e[5] * e[0] * e[12] + e[5] * e[10] * e[4] +
          e[5] * e[1] * e[13] + e[5] * e[2] * e[14] + e[14] * e[1] * e[4] +
          e[14] * e[0] * e[3] + e[8] * e[9] * e[6] + e[8] * e[0] * e[15] +
          e[8] * e[10] * e[7] + e[8] * e[1] * e[16] + e[8] * e[2] * e[17] +
          e[17] * e[1] * e[7] + e[17] * e[0] * e[6] + e[2] * e[10] * e[1] -
          e[2] * e[13] * e[4] - e[2] * e[16] * e[7] + 0.5 * e[11] * e2[1] +
          0.5 * e[11] * e2[0] + 1.5 * e[11] * e2[2] + 0.5 * e[11] * e2[5] +
          0.5 * e[11] * e2[8] - 0.5 * e[11] * e2[4] - 0.5 * e[11] * e2[6] -
          0.5 * e[11] * e2[7] - 0.5 * e[11] * e2[3];
  a[83] = e[5] * e[19] * e[13] + e[5] * e[10] * e[22] + e[8] * e[18] * e[15] +
          e[8] * e[9] * e[24] + e[8] * e[20] * e[17] + e[8] * e[11] * e[26] +
          e[8] * e[19] * e[16] + e[8] * e[10] * e[25] + e[2] * e[18] * e[9] +
          e[2] * e[19] * e[10] - e[11] * e[21] * e[3] - e[11] * e[22] * e[4] -
          e[11] * e[25] * e[7] - e[11] * e[24] * e[6] + e[14] * e[18] * e[3] +
          e[14] * e[0] * e[21] + e[14] * e[19] * e[4] + e[14] * e[1] * e[22] +
          e[14] * e[2] * e[23] - e[20] * e[13] * e[4] - e[20] * e[16] * e[7] -
          e[20] * e[15] * e[6] - e[20] * e[12] * e[3] + e[23] * e[9] * e[3] +
          e[23] * e[0] * e[12] + e[23] * e[10] * e[4] + e[23] * e[1] * e[13] +
          e[17] * e[18] * e[6] + e[17] * e[0] * e[24] + e[17] * e[19] * e[7] +
          e[17] * e[1] * e[25] + e[17] * e[2] * e[26] - e[2] * e[24] * e[15] -
          e[2] * e[25] * e[16] - e[2] * e[21] * e[12] - e[2] * e[22] * e[13] +
          e[26] * e[9] * e[6] + e[26] * e[0] * e[15] + e[26] * e[10] * e[7] +
          e[26] * e[1] * e[16] + e[11] * e[18] * e[0] + e[11] * e[19] * e[1] +
          3. * e[11] * e[20] * e[2] + e[20] * e[9] * e[0] +
          e[20] * e[10] * e[1] + e[5] * e[18] * e[12] + e[5] * e[9] * e[21] +
          e[5] * e[20] * e[14] + e[5] * e[11] * e[23];
  a[53] = e[32] * e[1] * e[4] + e[32] * e[0] * e[3] + e[8] * e[27] * e[6] +
          e[8] * e[0] * e[33] + e[8] * e[28] * e[7] + e[8] * e[1] * e[34] +
          e[35] * e[1] * e[7] + e[35] * e[0] * e[6] + e[2] * e[27] * e[0] +
          e[2] * e[28] * e[1] - e[2] * e[34] * e[7] + e[2] * e[32] * e[5] -
          e[2] * e[33] * e[6] - e[2] * e[30] * e[3] + e[2] * e[35] * e[8] -
          e[2] * e[31] * e[4] + e[5] * e[27] * e[3] + e[5] * e[0] * e[30] +
          e[5] * e[28] * e[4] + e[5] * e[1] * e[31] + 1.5 * e[29] * e2[2] -
          0.5 * e[29] * e2[4] + 0.5 * e[29] * e2[0] - 0.5 * e[29] * e2[6] +
          0.5 * e[29] * e2[5] + 0.5 * e[29] * e2[1] - 0.5 * e[29] * e2[7] -
          0.5 * e[29] * e2[3] + 0.5 * e[29] * e2[8];
  a[3] = e[5] * e[0] * e[3] + e[8] * e[1] * e[7] + e[8] * e[0] * e[6] +
         e[5] * e[1] * e[4] - 0.5 * e[2] * e2[4] + 0.5 * e3[2] +
         0.5 * e[2] * e2[1] - 0.5 * e[2] * e2[3] + 0.5 * e[2] * e2[0] +
         0.5 * e[2] * e2[8] + 0.5 * e[2] * e2[5] - 0.5 * e[2] * e2[6] -
         0.5 * e[2] * e2[7];
  a[73] = e[35] * e[9] * e[15] + e[35] * e[10] * e[16] - e[11] * e[30] * e[12] -
          e[11] * e[31] * e[13] - e[11] * e[33] * e[15] -
          e[11] * e[34] * e[16] + e[11] * e[27] * e[9] + e[11] * e[28] * e[10] +
          e[14] * e[27] * e[12] + e[14] * e[9] * e[30] + e[14] * e[11] * e[32] +
          e[14] * e[28] * e[13] + e[14] * e[10] * e[31] + e[32] * e[9] * e[12] +
          e[32] * e[10] * e[13] + e[17] * e[27] * e[15] + e[17] * e[9] * e[33] +
          e[17] * e[11] * e[35] + e[17] * e[28] * e[16] +
          e[17] * e[10] * e[34] + 1.5 * e[29] * e2[11] - 0.5 * e[29] * e2[16] +
          0.5 * e[29] * e2[9] - 0.5 * e[29] * e2[12] - 0.5 * e[29] * e2[15] +
          0.5 * e[29] * e2[17] + 0.5 * e[29] * e2[10] + 0.5 * e[29] * e2[14] -
          0.5 * e[29] * e2[13];
  a[13] = e[14] * e[9] * e[12] + e[17] * e[10] * e[16] + e[17] * e[9] * e[15] +
          0.5 * e3[11] + e[14] * e[10] * e[13] + 0.5 * e[11] * e2[10] -
          0.5 * e[11] * e2[15] + 0.5 * e[11] * e2[14] - 0.5 * e[11] * e2[13] -
          0.5 * e[11] * e2[12] + 0.5 * e[11] * e2[9] - 0.5 * e[11] * e2[16] +
          0.5 * e[11] * e2[17];
  a[173] =
      e[20] * e[27] * e[18] + e[20] * e[28] * e[19] + e[23] * e[27] * e[21] +
      e[23] * e[18] * e[30] + e[23] * e[28] * e[22] + e[23] * e[19] * e[31] +
      e[23] * e[20] * e[32] + e[32] * e[19] * e[22] + e[32] * e[18] * e[21] +
      e[26] * e[27] * e[24] + e[26] * e[18] * e[33] + e[26] * e[28] * e[25] +
      e[26] * e[19] * e[34] + e[26] * e[20] * e[35] + e[35] * e[19] * e[25] +
      e[35] * e[18] * e[24] - e[20] * e[33] * e[24] - e[20] * e[30] * e[21] -
      e[20] * e[31] * e[22] - e[20] * e[34] * e[25] + 0.5 * e[29] * e2[23] +
      0.5 * e[29] * e2[26] - 0.5 * e[29] * e2[22] - 0.5 * e[29] * e2[24] -
      0.5 * e[29] * e2[21] - 0.5 * e[29] * e2[25] + 1.5 * e[29] * e2[20] +
      0.5 * e[29] * e2[19] + 0.5 * e[29] * e2[18];
  a[163] = 0.5 * e[20] * e2[26] + 0.5 * e[20] * e2[18] + 0.5 * e3[20] +
           0.5 * e[20] * e2[19] + e[26] * e[18] * e[24] + 0.5 * e[20] * e2[23] -
           0.5 * e[20] * e2[25] + e[23] * e[19] * e[22] - 0.5 * e[20] * e2[24] -
           0.5 * e[20] * e2[21] - 0.5 * e[20] * e2[22] + e[23] * e[18] * e[21] +
           e[26] * e[19] * e[25];
  a[93] = e[8] * e[28] * e[16] + e[8] * e[10] * e[34] + e[2] * e[27] * e[9] +
          3. * e[2] * e[29] * e[11] + e[2] * e[28] * e[10] +
          e[11] * e[27] * e[0] - e[11] * e[34] * e[7] - e[11] * e[33] * e[6] -
          e[11] * e[30] * e[3] + e[11] * e[28] * e[1] - e[11] * e[31] * e[4] +
          e[14] * e[27] * e[3] + e[14] * e[0] * e[30] + e[14] * e[28] * e[4] +
          e[14] * e[1] * e[31] + e[14] * e[2] * e[32] + e[29] * e[10] * e[1] -
          e[29] * e[13] * e[4] - e[29] * e[16] * e[7] - e[29] * e[15] * e[6] +
          e[29] * e[9] * e[0] - e[29] * e[12] * e[3] + e[32] * e[9] * e[3] +
          e[32] * e[0] * e[12] + e[32] * e[10] * e[4] + e[32] * e[1] * e[13] +
          e[17] * e[27] * e[6] + e[17] * e[0] * e[33] + e[17] * e[28] * e[7] +
          e[17] * e[1] * e[34] + e[17] * e[2] * e[35] - e[2] * e[30] * e[12] -
          e[2] * e[31] * e[13] - e[2] * e[33] * e[15] - e[2] * e[34] * e[16] +
          e[35] * e[9] * e[6] + e[35] * e[0] * e[15] + e[35] * e[10] * e[7] +
          e[35] * e[1] * e[16] + e[5] * e[27] * e[12] + e[5] * e[9] * e[30] +
          e[5] * e[29] * e[14] + e[5] * e[11] * e[32] + e[5] * e[28] * e[13] +
          e[5] * e[10] * e[31] + e[8] * e[27] * e[15] + e[8] * e[9] * e[33] +
          e[8] * e[29] * e[17] + e[8] * e[11] * e[35];
  a[94] = -e[12] * e[34] * e[7] + e[12] * e[32] * e[5] - e[12] * e[35] * e[8] -
          e[12] * e[29] * e[2] - e[12] * e[28] * e[1] + e[12] * e[31] * e[4] -
          e[30] * e[11] * e[2] - e[30] * e[10] * e[1] + e[30] * e[13] * e[4] -
          e[30] * e[16] * e[7] + e[30] * e[14] * e[5] - e[30] * e[17] * e[8] +
          e[15] * e[3] * e[33] + e[15] * e[31] * e[7] + e[15] * e[4] * e[34] +
          e[15] * e[32] * e[8] + e[15] * e[5] * e[35] + e[3] * e[27] * e[9] -
          e[3] * e[28] * e[10] - e[3] * e[34] * e[16] - e[3] * e[35] * e[17] -
          e[3] * e[29] * e[11] + e[33] * e[13] * e[7] + e[33] * e[4] * e[16] +
          e[33] * e[14] * e[8] + e[33] * e[5] * e[17] + e[9] * e[28] * e[4] +
          e[9] * e[1] * e[31] + e[9] * e[29] * e[5] + e[9] * e[2] * e[32] +
          e[27] * e[10] * e[4] + e[27] * e[1] * e[13] + e[27] * e[11] * e[5] +
          e[27] * e[2] * e[14] + 3. * e[3] * e[30] * e[12] +
          e[3] * e[32] * e[14] + e[3] * e[31] * e[13] + e[6] * e[30] * e[15] +
          e[6] * e[12] * e[33] + e[6] * e[32] * e[17] + e[6] * e[14] * e[35] +
          e[6] * e[31] * e[16] + e[6] * e[13] * e[34] + e[0] * e[27] * e[12] +
          e[0] * e[9] * e[30] + e[0] * e[29] * e[14] + e[0] * e[11] * e[32] +
          e[0] * e[28] * e[13] + e[0] * e[10] * e[31];
  a[164] = 0.5 * e[21] * e2[24] - 0.5 * e[21] * e2[25] + 0.5 * e[21] * e2[23] -
           0.5 * e[21] * e2[26] + 0.5 * e2[18] * e[21] + 0.5 * e[21] * e2[22] -
           0.5 * e[21] * e2[20] + e[24] * e[22] * e[25] +
           e[24] * e[23] * e[26] - 0.5 * e[21] * e2[19] +
           e[18] * e[19] * e[22] + e[18] * e[20] * e[23] + 0.5 * e3[21];
  a[174] =
      -0.5 * e[30] * e2[26] - 0.5 * e[30] * e2[19] - 0.5 * e[30] * e2[20] -
      0.5 * e[30] * e2[25] + 0.5 * e2[18] * e[30] + 1.5 * e[30] * e2[21] +
      0.5 * e[30] * e2[22] + 0.5 * e[30] * e2[23] + 0.5 * e[30] * e2[24] +
      e[18] * e[27] * e[21] + e[18] * e[28] * e[22] + e[18] * e[19] * e[31] +
      e[18] * e[29] * e[23] + e[18] * e[20] * e[32] + e[27] * e[19] * e[22] +
      e[27] * e[20] * e[23] + e[21] * e[31] * e[22] + e[21] * e[32] * e[23] +
      e[24] * e[21] * e[33] + e[24] * e[31] * e[25] + e[24] * e[22] * e[34] +
      e[24] * e[32] * e[26] + e[24] * e[23] * e[35] + e[33] * e[22] * e[25] +
      e[33] * e[23] * e[26] - e[21] * e[29] * e[20] - e[21] * e[35] * e[26] -
      e[21] * e[28] * e[19] - e[21] * e[34] * e[25];
  a[14] = 0.5 * e[12] * e2[15] - 0.5 * e[12] * e2[17] + e[15] * e[13] * e[16] -
          0.5 * e[12] * e2[10] + e[15] * e[14] * e[17] - 0.5 * e[12] * e2[16] -
          0.5 * e[12] * e2[11] + e[9] * e[10] * e[13] + 0.5 * e[12] * e2[13] +
          0.5 * e2[9] * e[12] + 0.5 * e3[12] + e[9] * e[11] * e[14] +
          0.5 * e[12] * e2[14];
  a[34] = e[12] * e[13] * e[4] + e[12] * e[14] * e[5] + e[15] * e[12] * e[6] +
          e[15] * e[13] * e[7] + e[15] * e[4] * e[16] + e[15] * e[14] * e[8] +
          e[15] * e[5] * e[17] + e[6] * e[14] * e[17] + e[6] * e[13] * e[16] +
          e[0] * e[11] * e[14] + e[0] * e[9] * e[12] + e[0] * e[10] * e[13] +
          e[9] * e[10] * e[4] + e[9] * e[1] * e[13] + e[9] * e[11] * e[5] +
          e[9] * e[2] * e[14] - e[12] * e[11] * e[2] - e[12] * e[10] * e[1] -
          e[12] * e[16] * e[7] - e[12] * e[17] * e[8] + 1.5 * e2[12] * e[3] +
          0.5 * e[3] * e2[15] - 0.5 * e[3] * e2[16] + 0.5 * e[3] * e2[9] -
          0.5 * e[3] * e2[11] - 0.5 * e[3] * e2[17] - 0.5 * e[3] * e2[10] +
          0.5 * e[3] * e2[14] + 0.5 * e[3] * e2[13];
  a[64] =
      e[18] * e[11] * e[14] + e[18] * e[9] * e[12] + e[18] * e[10] * e[13] +
      e[12] * e[23] * e[14] + e[12] * e[22] * e[13] + e[15] * e[12] * e[24] +
      e[15] * e[23] * e[17] + e[15] * e[14] * e[26] + e[15] * e[22] * e[16] +
      e[15] * e[13] * e[25] + e[24] * e[14] * e[17] + e[24] * e[13] * e[16] -
      e[12] * e[25] * e[16] - e[12] * e[26] * e[17] - e[12] * e[20] * e[11] -
      e[12] * e[19] * e[10] + e[9] * e[20] * e[14] + e[9] * e[11] * e[23] +
      e[9] * e[19] * e[13] + e[9] * e[10] * e[22] + 0.5 * e2[9] * e[21] -
      0.5 * e[21] * e2[16] - 0.5 * e[21] * e2[11] - 0.5 * e[21] * e2[17] -
      0.5 * e[21] * e2[10] + 1.5 * e[21] * e2[12] + 0.5 * e[21] * e2[14] +
      0.5 * e[21] * e2[13] + 0.5 * e[21] * e2[15];
  a[114] = -e[21] * e[35] * e[8] - e[21] * e[29] * e[2] - e[21] * e[28] * e[1] +
           e[21] * e[31] * e[4] - e[30] * e[26] * e[8] - e[30] * e[20] * e[2] -
           e[30] * e[19] * e[1] + e[30] * e[22] * e[4] - e[30] * e[25] * e[7] +
           e[30] * e[23] * e[5] + e[6] * e[31] * e[25] + e[6] * e[22] * e[34] +
           e[6] * e[32] * e[26] + e[6] * e[23] * e[35] + e[24] * e[30] * e[6] +
           e[24] * e[3] * e[33] + e[24] * e[31] * e[7] + e[24] * e[4] * e[34] +
           e[24] * e[32] * e[8] + e[24] * e[5] * e[35] + e[33] * e[21] * e[6] +
           e[33] * e[22] * e[7] + e[33] * e[4] * e[25] + e[33] * e[23] * e[8] +
           e[33] * e[5] * e[26] + e[0] * e[27] * e[21] + e[0] * e[18] * e[30] +
           e[0] * e[28] * e[22] + e[0] * e[19] * e[31] + e[0] * e[29] * e[23] +
           e[0] * e[20] * e[32] + e[18] * e[27] * e[3] + e[18] * e[28] * e[4] +
           e[18] * e[1] * e[31] + e[18] * e[29] * e[5] + e[18] * e[2] * e[32] +
           e[27] * e[19] * e[4] + e[27] * e[1] * e[22] + e[27] * e[20] * e[5] +
           e[27] * e[2] * e[23] + 3. * e[3] * e[30] * e[21] +
           e[3] * e[31] * e[22] + e[3] * e[32] * e[23] - e[3] * e[29] * e[20] -
           e[3] * e[35] * e[26] - e[3] * e[28] * e[19] - e[3] * e[34] * e[25] -
           e[21] * e[34] * e[7] + e[21] * e[32] * e[5];
  a[44] = e[18] * e[1] * e[4] + e[18] * e[0] * e[3] + e[18] * e[2] * e[5] +
          e[3] * e[22] * e[4] + e[3] * e[23] * e[5] + e[6] * e[3] * e[24] +
          e[6] * e[22] * e[7] + e[6] * e[4] * e[25] + e[6] * e[23] * e[8] +
          e[6] * e[5] * e[26] + e[24] * e[4] * e[7] + e[24] * e[5] * e[8] +
          e[0] * e[19] * e[4] + e[0] * e[1] * e[22] + e[0] * e[20] * e[5] +
          e[0] * e[2] * e[23] - e[3] * e[26] * e[8] - e[3] * e[20] * e[2] -
          e[3] * e[19] * e[1] - e[3] * e[25] * e[7] + 0.5 * e[21] * e2[4] +
          0.5 * e[21] * e2[0] + 0.5 * e[21] * e2[6] + 0.5 * e[21] * e2[5] -
          0.5 * e[21] * e2[1] - 0.5 * e[21] * e2[7] + 1.5 * e[21] * e2[3] -
          0.5 * e[21] * e2[2] - 0.5 * e[21] * e2[8];
  a[184] =
      0.5 * e2[27] * e[21] + 1.5 * e[21] * e2[30] + 0.5 * e[21] * e2[32] +
      0.5 * e[21] * e2[31] + 0.5 * e[21] * e2[33] - 0.5 * e[21] * e2[28] -
      0.5 * e[21] * e2[29] - 0.5 * e[21] * e2[34] - 0.5 * e[21] * e2[35] +
      e[18] * e[27] * e[30] + e[18] * e[29] * e[32] + e[18] * e[28] * e[31] +
      e[27] * e[28] * e[22] + e[27] * e[19] * e[31] + e[27] * e[29] * e[23] +
      e[27] * e[20] * e[32] + e[30] * e[31] * e[22] + e[30] * e[32] * e[23] +
      e[24] * e[30] * e[33] + e[24] * e[32] * e[35] + e[24] * e[31] * e[34] +
      e[33] * e[31] * e[25] + e[33] * e[22] * e[34] + e[33] * e[32] * e[26] +
      e[33] * e[23] * e[35] - e[30] * e[29] * e[20] - e[30] * e[35] * e[26] -
      e[30] * e[28] * e[19] - e[30] * e[34] * e[25];
  a[49] = -0.5 * e[26] * e2[4] - 0.5 * e[26] * e2[0] + 0.5 * e[26] * e2[6] +
          0.5 * e[26] * e2[5] - 0.5 * e[26] * e2[1] + 0.5 * e[26] * e2[7] -
          0.5 * e[26] * e2[3] + 0.5 * e[26] * e2[2] + 1.5 * e[26] * e2[8] +
          e[20] * e[0] * e[6] + e[20] * e[2] * e[8] + e[5] * e[21] * e[6] +
          e[5] * e[3] * e[24] + e[5] * e[22] * e[7] + e[5] * e[4] * e[25] +
          e[5] * e[23] * e[8] + e[23] * e[4] * e[7] + e[23] * e[3] * e[6] +
          e[8] * e[24] * e[6] + e[8] * e[25] * e[7] + e[2] * e[18] * e[6] +
          e[2] * e[0] * e[24] + e[2] * e[19] * e[7] + e[2] * e[1] * e[25] -
          e[8] * e[21] * e[3] - e[8] * e[19] * e[1] - e[8] * e[22] * e[4] -
          e[8] * e[18] * e[0] + e[20] * e[1] * e[7];
  a[154] =
      e[9] * e[27] * e[30] + e[9] * e[29] * e[32] + e[9] * e[28] * e[31] +
      e[33] * e[30] * e[15] + e[33] * e[32] * e[17] + e[33] * e[14] * e[35] +
      e[33] * e[31] * e[16] + e[33] * e[13] * e[34] + e[27] * e[29] * e[14] +
      e[27] * e[11] * e[32] + e[27] * e[28] * e[13] + e[27] * e[10] * e[31] -
      e[30] * e[28] * e[10] + e[30] * e[31] * e[13] + e[30] * e[32] * e[14] -
      e[30] * e[34] * e[16] - e[30] * e[35] * e[17] - e[30] * e[29] * e[11] +
      e[15] * e[32] * e[35] + e[15] * e[31] * e[34] - 0.5 * e[12] * e2[34] -
      0.5 * e[12] * e2[35] + 0.5 * e[12] * e2[27] + 0.5 * e[12] * e2[32] -
      0.5 * e[12] * e2[28] - 0.5 * e[12] * e2[29] + 0.5 * e[12] * e2[31] +
      0.5 * e[12] * e2[33] + 1.5 * e[12] * e2[30];
  a[119] = e[23] * e[30] * e[6] + e[23] * e[3] * e[33] + e[23] * e[31] * e[7] +
           e[23] * e[4] * e[34] + e[32] * e[21] * e[6] + e[32] * e[3] * e[24] +
           e[32] * e[22] * e[7] + e[32] * e[4] * e[25] + e[26] * e[33] * e[6] +
           e[26] * e[34] * e[7] + 3. * e[26] * e[35] * e[8] +
           e[35] * e[24] * e[6] + e[35] * e[25] * e[7] + e[2] * e[27] * e[24] +
           e[2] * e[18] * e[33] + e[2] * e[28] * e[25] + e[2] * e[19] * e[34] +
           e[2] * e[29] * e[26] + e[2] * e[20] * e[35] + e[20] * e[27] * e[6] +
           e[20] * e[0] * e[33] + e[20] * e[28] * e[7] + e[20] * e[1] * e[34] +
           e[20] * e[29] * e[8] + e[29] * e[18] * e[6] + e[29] * e[0] * e[24] +
           e[29] * e[19] * e[7] + e[29] * e[1] * e[25] + e[5] * e[30] * e[24] +
           e[5] * e[21] * e[33] + e[5] * e[31] * e[25] + e[5] * e[22] * e[34] +
           e[5] * e[32] * e[26] + e[5] * e[23] * e[35] - e[8] * e[27] * e[18] +
           e[8] * e[33] * e[24] - e[8] * e[30] * e[21] - e[8] * e[31] * e[22] +
           e[8] * e[32] * e[23] - e[8] * e[28] * e[19] + e[8] * e[34] * e[25] -
           e[26] * e[27] * e[0] - e[26] * e[30] * e[3] - e[26] * e[28] * e[1] -
           e[26] * e[31] * e[4] - e[35] * e[21] * e[3] - e[35] * e[19] * e[1] -
           e[35] * e[22] * e[4] - e[35] * e[18] * e[0];
  a[194] = e[27] * e[29] * e[32] + e[27] * e[28] * e[31] +
           e[33] * e[32] * e[35] + e[33] * e[31] * e[34] + 0.5 * e3[30] -
           0.5 * e[30] * e2[28] - 0.5 * e[30] * e2[29] - 0.5 * e[30] * e2[34] +
           0.5 * e[30] * e2[33] + 0.5 * e2[27] * e[30] + 0.5 * e[30] * e2[32] +
           0.5 * e[30] * e2[31] - 0.5 * e[30] * e2[35];
  a[69] =
      0.5 * e2[14] * e[26] + 1.5 * e[26] * e2[17] + 0.5 * e[26] * e2[15] +
      0.5 * e[26] * e2[16] + 0.5 * e2[11] * e[26] - 0.5 * e[26] * e2[9] -
      0.5 * e[26] * e2[12] - 0.5 * e[26] * e2[10] - 0.5 * e[26] * e2[13] +
      e[20] * e[11] * e[17] + e[20] * e[9] * e[15] + e[20] * e[10] * e[16] +
      e[14] * e[21] * e[15] + e[14] * e[12] * e[24] + e[14] * e[23] * e[17] +
      e[14] * e[22] * e[16] + e[14] * e[13] * e[25] + e[23] * e[12] * e[15] +
      e[23] * e[13] * e[16] + e[17] * e[24] * e[15] + e[17] * e[25] * e[16] -
      e[17] * e[18] * e[9] - e[17] * e[21] * e[12] - e[17] * e[19] * e[10] -
      e[17] * e[22] * e[13] + e[11] * e[18] * e[15] + e[11] * e[9] * e[24] +
      e[11] * e[19] * e[16] + e[11] * e[10] * e[25];
  a[124] = e[0] * e[27] * e[30] + e[0] * e[29] * e[32] + e[0] * e[28] * e[31] +
           e[30] * e[31] * e[4] + e[30] * e[32] * e[5] + e[6] * e[30] * e[33] +
           e[6] * e[32] * e[35] + e[6] * e[31] * e[34] + e[27] * e[28] * e[4] +
           e[27] * e[1] * e[31] + e[27] * e[29] * e[5] + e[27] * e[2] * e[32] +
           e[33] * e[31] * e[7] + e[33] * e[4] * e[34] + e[33] * e[32] * e[8] +
           e[33] * e[5] * e[35] - e[30] * e[34] * e[7] - e[30] * e[35] * e[8] -
           e[30] * e[29] * e[2] - e[30] * e[28] * e[1] + 1.5 * e[3] * e2[30] +
           0.5 * e[3] * e2[32] + 0.5 * e[3] * e2[31] + 0.5 * e[3] * e2[27] -
           0.5 * e[3] * e2[28] - 0.5 * e[3] * e2[29] + 0.5 * e[3] * e2[33] -
           0.5 * e[3] * e2[34] - 0.5 * e[3] * e2[35];
  a[39] = 0.5 * e2[14] * e[8] + 1.5 * e2[17] * e[8] + 0.5 * e[8] * e2[15] +
          0.5 * e[8] * e2[16] - 0.5 * e[8] * e2[9] + 0.5 * e[8] * e2[11] -
          0.5 * e[8] * e2[12] - 0.5 * e[8] * e2[10] - 0.5 * e[8] * e2[13] +
          e[14] * e[12] * e[6] + e[14] * e[3] * e[15] + e[14] * e[13] * e[7] +
          e[14] * e[4] * e[16] + e[14] * e[5] * e[17] + e[17] * e[15] * e[6] +
          e[17] * e[16] * e[7] + e[2] * e[11] * e[17] + e[2] * e[9] * e[15] +
          e[2] * e[10] * e[16] + e[5] * e[12] * e[15] + e[5] * e[13] * e[16] +
          e[11] * e[9] * e[6] + e[11] * e[0] * e[15] + e[11] * e[10] * e[7] +
          e[11] * e[1] * e[16] - e[17] * e[10] * e[1] - e[17] * e[13] * e[4] -
          e[17] * e[9] * e[0] - e[17] * e[12] * e[3];
  a[4] = -0.5 * e[3] * e2[1] - 0.5 * e[3] * e2[7] + 0.5 * e3[3] -
         0.5 * e[3] * e2[8] + e[0] * e[2] * e[5] + 0.5 * e[3] * e2[6] +
         0.5 * e[3] * e2[4] - 0.5 * e[3] * e2[2] + e[0] * e[1] * e[4] +
         e[6] * e[4] * e[7] + 0.5 * e2[0] * e[3] + 0.5 * e[3] * e2[5] +
         e[6] * e[5] * e[8];
  a[139] =
      0.5 * e2[23] * e[17] + 1.5 * e2[26] * e[17] + 0.5 * e[17] * e2[25] +
      0.5 * e[17] * e2[24] - 0.5 * e[17] * e2[18] - 0.5 * e[17] * e2[19] +
      0.5 * e[17] * e2[20] - 0.5 * e[17] * e2[22] - 0.5 * e[17] * e2[21] +
      e[23] * e[21] * e[15] + e[23] * e[12] * e[24] + e[23] * e[14] * e[26] +
      e[23] * e[22] * e[16] + e[23] * e[13] * e[25] + e[26] * e[24] * e[15] +
      e[26] * e[25] * e[16] + e[11] * e[19] * e[25] + e[11] * e[18] * e[24] +
      e[11] * e[20] * e[26] + e[14] * e[22] * e[25] + e[14] * e[21] * e[24] +
      e[20] * e[18] * e[15] + e[20] * e[9] * e[24] + e[20] * e[19] * e[16] +
      e[20] * e[10] * e[25] - e[26] * e[18] * e[9] - e[26] * e[21] * e[12] -
      e[26] * e[19] * e[10] - e[26] * e[22] * e[13];
  a[74] =
      -e[12] * e[34] * e[16] - e[12] * e[35] * e[17] - e[12] * e[29] * e[11] +
      e[9] * e[27] * e[12] + e[9] * e[29] * e[14] + e[9] * e[11] * e[32] +
      e[9] * e[28] * e[13] + e[9] * e[10] * e[31] + e[27] * e[11] * e[14] +
      e[27] * e[10] * e[13] + e[12] * e[32] * e[14] + e[12] * e[31] * e[13] +
      e[15] * e[12] * e[33] + e[15] * e[32] * e[17] + e[15] * e[14] * e[35] +
      e[15] * e[31] * e[16] + e[15] * e[13] * e[34] + e[33] * e[14] * e[17] +
      e[33] * e[13] * e[16] - e[12] * e[28] * e[10] + 0.5 * e2[9] * e[30] -
      0.5 * e[30] * e2[16] - 0.5 * e[30] * e2[11] + 1.5 * e[30] * e2[12] +
      0.5 * e[30] * e2[15] - 0.5 * e[30] * e2[17] - 0.5 * e[30] * e2[10] +
      0.5 * e[30] * e2[14] + 0.5 * e[30] * e2[13];
  a[149] =
      e[32] * e[22] * e[16] + e[32] * e[13] * e[25] - e[17] * e[27] * e[18] +
      e[17] * e[33] * e[24] - e[17] * e[30] * e[21] + e[17] * e[29] * e[20] +
      3. * e[17] * e[35] * e[26] - e[17] * e[31] * e[22] -
      e[17] * e[28] * e[19] + e[17] * e[34] * e[25] + e[20] * e[27] * e[15] +
      e[20] * e[9] * e[33] + e[20] * e[28] * e[16] + e[20] * e[10] * e[34] +
      e[29] * e[18] * e[15] + e[29] * e[9] * e[24] + e[29] * e[19] * e[16] +
      e[29] * e[10] * e[25] - e[26] * e[27] * e[9] - e[26] * e[30] * e[12] -
      e[26] * e[28] * e[10] - e[26] * e[31] * e[13] + e[26] * e[33] * e[15] +
      e[26] * e[34] * e[16] + e[35] * e[24] * e[15] + e[35] * e[25] * e[16] -
      e[35] * e[18] * e[9] - e[35] * e[21] * e[12] - e[35] * e[19] * e[10] -
      e[35] * e[22] * e[13] + e[14] * e[30] * e[24] + e[14] * e[21] * e[33] +
      e[14] * e[31] * e[25] + e[14] * e[22] * e[34] + e[14] * e[32] * e[26] +
      e[14] * e[23] * e[35] + e[11] * e[27] * e[24] + e[11] * e[18] * e[33] +
      e[11] * e[28] * e[25] + e[11] * e[19] * e[34] + e[11] * e[29] * e[26] +
      e[11] * e[20] * e[35] + e[23] * e[30] * e[15] + e[23] * e[12] * e[33] +
      e[23] * e[32] * e[17] + e[23] * e[31] * e[16] + e[23] * e[13] * e[34] +
      e[32] * e[21] * e[15] + e[32] * e[12] * e[24];
  a[84] = e[6] * e[23] * e[17] + e[6] * e[14] * e[26] + e[6] * e[22] * e[16] +
          e[6] * e[13] * e[25] + e[0] * e[20] * e[14] + e[0] * e[11] * e[23] +
          e[0] * e[19] * e[13] + e[0] * e[10] * e[22] - e[12] * e[26] * e[8] -
          e[12] * e[20] * e[2] - e[12] * e[19] * e[1] + e[12] * e[22] * e[4] -
          e[12] * e[25] * e[7] + e[12] * e[23] * e[5] - e[21] * e[11] * e[2] -
          e[21] * e[10] * e[1] + e[21] * e[13] * e[4] - e[21] * e[16] * e[7] +
          e[21] * e[14] * e[5] - e[21] * e[17] * e[8] + e[15] * e[3] * e[24] +
          e[15] * e[22] * e[7] + e[15] * e[4] * e[25] + e[15] * e[23] * e[8] +
          e[15] * e[5] * e[26] - e[3] * e[25] * e[16] - e[3] * e[26] * e[17] -
          e[3] * e[20] * e[11] - e[3] * e[19] * e[10] + e[24] * e[13] * e[7] +
          e[24] * e[4] * e[16] + e[24] * e[14] * e[8] + e[24] * e[5] * e[17] +
          e[9] * e[18] * e[3] + e[9] * e[0] * e[21] + e[9] * e[19] * e[4] +
          e[9] * e[1] * e[22] + e[9] * e[20] * e[5] + e[9] * e[2] * e[23] +
          e[18] * e[0] * e[12] + e[18] * e[10] * e[4] + e[18] * e[1] * e[13] +
          e[18] * e[11] * e[5] + e[18] * e[2] * e[14] +
          3. * e[3] * e[21] * e[12] + e[3] * e[23] * e[14] +
          e[3] * e[22] * e[13] + e[6] * e[21] * e[15] + e[6] * e[12] * e[24];
  a[29] = 0.5 * e2[5] * e[17] + 1.5 * e[17] * e2[8] + 0.5 * e[17] * e2[7] +
          0.5 * e[17] * e2[6] + 0.5 * e2[2] * e[17] - 0.5 * e[17] * e2[4] -
          0.5 * e[17] * e2[0] - 0.5 * e[17] * e2[1] - 0.5 * e[17] * e2[3] +
          e[11] * e[1] * e[7] + e[11] * e[0] * e[6] + e[11] * e[2] * e[8] +
          e[5] * e[12] * e[6] + e[5] * e[3] * e[15] + e[5] * e[13] * e[7] +
          e[5] * e[4] * e[16] + e[5] * e[14] * e[8] + e[14] * e[4] * e[7] +
          e[14] * e[3] * e[6] + e[8] * e[15] * e[6] + e[8] * e[16] * e[7] -
          e[8] * e[10] * e[1] - e[8] * e[13] * e[4] - e[8] * e[9] * e[0] -
          e[8] * e[12] * e[3] + e[2] * e[9] * e[6] + e[2] * e[0] * e[15] +
          e[2] * e[10] * e[7] + e[2] * e[1] * e[16];
  a[54] = e[6] * e[4] * e[34] + e[6] * e[32] * e[8] + e[6] * e[5] * e[35] +
          e[33] * e[4] * e[7] + e[33] * e[5] * e[8] + e[0] * e[27] * e[3] +
          e[0] * e[28] * e[4] + e[0] * e[1] * e[31] + e[0] * e[29] * e[5] +
          e[0] * e[2] * e[32] - e[3] * e[34] * e[7] + e[3] * e[32] * e[5] +
          e[3] * e[33] * e[6] - e[3] * e[35] * e[8] - e[3] * e[29] * e[2] -
          e[3] * e[28] * e[1] + e[3] * e[31] * e[4] + e[27] * e[1] * e[4] +
          e[27] * e[2] * e[5] + e[6] * e[31] * e[7] + 0.5 * e[30] * e2[4] +
          0.5 * e[30] * e2[6] + 0.5 * e[30] * e2[5] - 0.5 * e[30] * e2[1] -
          0.5 * e[30] * e2[7] - 0.5 * e[30] * e2[2] - 0.5 * e[30] * e2[8] +
          0.5 * e2[0] * e[30] + 1.5 * e[30] * e2[3];
  a[109] = 0.5 * e2[23] * e[8] + 1.5 * e2[26] * e[8] - 0.5 * e[8] * e2[18] -
           0.5 * e[8] * e2[19] - 0.5 * e[8] * e2[22] + 0.5 * e[8] * e2[24] -
           0.5 * e[8] * e2[21] + 0.5 * e[8] * e2[25] + 0.5 * e2[20] * e[8] +
           e[20] * e[18] * e[6] + e[20] * e[0] * e[24] + e[20] * e[19] * e[7] +
           e[20] * e[1] * e[25] + e[20] * e[2] * e[26] + e[23] * e[21] * e[6] +
           e[23] * e[3] * e[24] + e[23] * e[22] * e[7] + e[23] * e[4] * e[25] +
           e[23] * e[5] * e[26] - e[26] * e[21] * e[3] - e[26] * e[19] * e[1] -
           e[26] * e[22] * e[4] - e[26] * e[18] * e[0] + e[26] * e[25] * e[7] +
           e[26] * e[24] * e[6] + e[2] * e[19] * e[25] + e[2] * e[18] * e[24] +
           e[5] * e[22] * e[25] + e[5] * e[21] * e[24];
  a[175] =
      e[19] * e[27] * e[21] + e[19] * e[18] * e[30] + e[19] * e[28] * e[22] +
      e[19] * e[29] * e[23] + e[19] * e[20] * e[32] + e[28] * e[18] * e[21] +
      e[28] * e[20] * e[23] + e[22] * e[30] * e[21] + e[22] * e[32] * e[23] +
      e[25] * e[30] * e[24] + e[25] * e[21] * e[33] + e[25] * e[22] * e[34] +
      e[25] * e[32] * e[26] + e[25] * e[23] * e[35] + e[34] * e[21] * e[24] +
      e[34] * e[23] * e[26] - e[22] * e[27] * e[18] - e[22] * e[33] * e[24] -
      e[22] * e[29] * e[20] - e[22] * e[35] * e[26] + 0.5 * e2[19] * e[31] +
      1.5 * e[31] * e2[22] + 0.5 * e[31] * e2[21] + 0.5 * e[31] * e2[23] +
      0.5 * e[31] * e2[25] - 0.5 * e[31] * e2[26] - 0.5 * e[31] * e2[18] -
      0.5 * e[31] * e2[20] - 0.5 * e[31] * e2[24];
  a[15] = -0.5 * e[13] * e2[15] + 0.5 * e[13] * e2[16] + 0.5 * e[13] * e2[12] +
          e[16] * e[12] * e[15] + 0.5 * e3[13] + e[10] * e[11] * e[14] +
          0.5 * e[13] * e2[14] - 0.5 * e[13] * e2[17] - 0.5 * e[13] * e2[11] -
          0.5 * e[13] * e2[9] + 0.5 * e2[10] * e[13] + e[10] * e[9] * e[12] +
          e[16] * e[14] * e[17];
  a[95] = -e[13] * e[29] * e[2] - e[31] * e[11] * e[2] - e[31] * e[15] * e[6] -
          e[31] * e[9] * e[0] + e[31] * e[14] * e[5] + e[31] * e[12] * e[3] -
          e[31] * e[17] * e[8] + e[16] * e[30] * e[6] + e[16] * e[3] * e[33] +
          e[16] * e[4] * e[34] + e[16] * e[32] * e[8] + e[16] * e[5] * e[35] -
          e[4] * e[27] * e[9] + e[4] * e[28] * e[10] - e[4] * e[33] * e[15] -
          e[4] * e[35] * e[17] - e[4] * e[29] * e[11] + e[34] * e[12] * e[6] +
          e[34] * e[3] * e[15] + e[34] * e[14] * e[8] + e[34] * e[5] * e[17] +
          e[10] * e[27] * e[3] + e[10] * e[0] * e[30] + e[10] * e[29] * e[5] +
          e[10] * e[2] * e[32] + e[28] * e[9] * e[3] + e[28] * e[0] * e[12] +
          e[28] * e[11] * e[5] + e[28] * e[2] * e[14] + e[4] * e[30] * e[12] +
          e[4] * e[32] * e[14] + 3. * e[4] * e[31] * e[13] +
          e[7] * e[30] * e[15] + e[7] * e[12] * e[33] + e[7] * e[32] * e[17] +
          e[7] * e[14] * e[35] + e[7] * e[31] * e[16] + e[7] * e[13] * e[34] +
          e[1] * e[27] * e[12] + e[1] * e[9] * e[30] + e[1] * e[29] * e[14] +
          e[1] * e[11] * e[32] + e[1] * e[28] * e[13] + e[1] * e[10] * e[31] -
          e[13] * e[27] * e[0] + e[13] * e[32] * e[5] - e[13] * e[33] * e[6] +
          e[13] * e[30] * e[3] - e[13] * e[35] * e[8];
  a[165] = e[25] * e[23] * e[26] + e[19] * e[20] * e[23] +
           e[19] * e[18] * e[21] + e[25] * e[21] * e[24] + 0.5 * e3[22] +
           0.5 * e[22] * e2[23] + 0.5 * e2[19] * e[22] - 0.5 * e[22] * e2[18] -
           0.5 * e[22] * e2[24] + 0.5 * e[22] * e2[21] + 0.5 * e[22] * e2[25] -
           0.5 * e[22] * e2[20] - 0.5 * e[22] * e2[26];
  a[55] = e[34] * e[5] * e[8] + e[1] * e[27] * e[3] + e[1] * e[0] * e[30] +
          e[1] * e[28] * e[4] + e[1] * e[29] * e[5] + e[1] * e[2] * e[32] -
          e[4] * e[27] * e[0] + e[4] * e[34] * e[7] + e[4] * e[32] * e[5] -
          e[4] * e[33] * e[6] + e[4] * e[30] * e[3] - e[4] * e[35] * e[8] -
          e[4] * e[29] * e[2] + e[28] * e[0] * e[3] + e[28] * e[2] * e[5] +
          e[7] * e[30] * e[6] + e[7] * e[3] * e[33] + e[7] * e[32] * e[8] +
          e[7] * e[5] * e[35] + e[34] * e[3] * e[6] + 0.5 * e2[1] * e[31] +
          1.5 * e[31] * e2[4] - 0.5 * e[31] * e2[0] - 0.5 * e[31] * e2[6] +
          0.5 * e[31] * e2[5] + 0.5 * e[31] * e2[7] + 0.5 * e[31] * e2[3] -
          0.5 * e[31] * e2[2] - 0.5 * e[31] * e2[8];
  a[85] = e[1] * e[20] * e[14] + e[1] * e[11] * e[23] + e[13] * e[21] * e[3] -
          e[13] * e[26] * e[8] - e[13] * e[20] * e[2] - e[13] * e[18] * e[0] +
          e[13] * e[23] * e[5] - e[13] * e[24] * e[6] - e[22] * e[11] * e[2] -
          e[22] * e[15] * e[6] - e[22] * e[9] * e[0] + e[22] * e[14] * e[5] +
          e[22] * e[12] * e[3] - e[22] * e[17] * e[8] + e[16] * e[21] * e[6] +
          e[16] * e[3] * e[24] + e[16] * e[4] * e[25] + e[16] * e[23] * e[8] +
          e[16] * e[5] * e[26] - e[4] * e[24] * e[15] - e[4] * e[26] * e[17] -
          e[4] * e[20] * e[11] - e[4] * e[18] * e[9] + e[25] * e[12] * e[6] +
          e[25] * e[3] * e[15] + e[25] * e[14] * e[8] + e[25] * e[5] * e[17] +
          e[10] * e[18] * e[3] + e[10] * e[0] * e[21] + e[10] * e[19] * e[4] +
          e[10] * e[1] * e[22] + e[10] * e[20] * e[5] + e[10] * e[2] * e[23] +
          e[19] * e[9] * e[3] + e[19] * e[0] * e[12] + e[19] * e[1] * e[13] +
          e[19] * e[11] * e[5] + e[19] * e[2] * e[14] + e[4] * e[21] * e[12] +
          e[4] * e[23] * e[14] + 3. * e[4] * e[22] * e[13] +
          e[7] * e[21] * e[15] + e[7] * e[12] * e[24] + e[7] * e[23] * e[17] +
          e[7] * e[14] * e[26] + e[7] * e[22] * e[16] + e[7] * e[13] * e[25] +
          e[1] * e[18] * e[12] + e[1] * e[9] * e[21];
  a[75] =
      e[10] * e[27] * e[12] + e[10] * e[9] * e[30] + e[10] * e[29] * e[14] +
      e[10] * e[11] * e[32] + e[10] * e[28] * e[13] + e[28] * e[11] * e[14] +
      e[28] * e[9] * e[12] + e[13] * e[30] * e[12] + e[13] * e[32] * e[14] +
      e[16] * e[30] * e[15] + e[16] * e[12] * e[33] + e[16] * e[32] * e[17] +
      e[16] * e[14] * e[35] + e[16] * e[13] * e[34] + e[34] * e[14] * e[17] +
      e[34] * e[12] * e[15] - e[13] * e[27] * e[9] - e[13] * e[33] * e[15] -
      e[13] * e[35] * e[17] - e[13] * e[29] * e[11] + 0.5 * e2[10] * e[31] +
      0.5 * e[31] * e2[16] - 0.5 * e[31] * e2[9] - 0.5 * e[31] * e2[11] +
      0.5 * e[31] * e2[12] - 0.5 * e[31] * e2[15] - 0.5 * e[31] * e2[17] +
      0.5 * e[31] * e2[14] + 1.5 * e[31] * e2[13];
  a[5] = -0.5 * e[4] * e2[6] - 0.5 * e[4] * e2[0] + e[1] * e[2] * e[5] +
         0.5 * e[4] * e2[7] + e[1] * e[0] * e[3] + e[7] * e[5] * e[8] -
         0.5 * e[4] * e2[8] + 0.5 * e[4] * e2[3] + 0.5 * e[4] * e2[5] +
         e[7] * e[3] * e[6] - 0.5 * e[4] * e2[2] + 0.5 * e3[4] +
         0.5 * e2[1] * e[4];
  a[195] = e[34] * e[32] * e[35] - 0.5 * e[31] * e2[35] + 0.5 * e[31] * e2[34] +
           0.5 * e2[28] * e[31] + 0.5 * e3[31] + 0.5 * e[31] * e2[32] +
           e[34] * e[30] * e[33] - 0.5 * e[31] * e2[27] + 0.5 * e[31] * e2[30] -
           0.5 * e[31] * e2[33] - 0.5 * e[31] * e2[29] + e[28] * e[29] * e[32] +
           e[28] * e[27] * e[30];
  a[125] = e[1] * e[27] * e[30] + e[1] * e[29] * e[32] + e[1] * e[28] * e[31] +
           e[31] * e[30] * e[3] + e[31] * e[32] * e[5] + e[7] * e[30] * e[33] +
           e[7] * e[32] * e[35] + e[7] * e[31] * e[34] + e[28] * e[27] * e[3] +
           e[28] * e[0] * e[30] + e[28] * e[29] * e[5] + e[28] * e[2] * e[32] +
           e[34] * e[30] * e[6] + e[34] * e[3] * e[33] + e[34] * e[32] * e[8] +
           e[34] * e[5] * e[35] - e[31] * e[27] * e[0] - e[31] * e[33] * e[6] -
           e[31] * e[35] * e[8] - e[31] * e[29] * e[2] + 0.5 * e[4] * e2[30] +
           0.5 * e[4] * e2[32] + 1.5 * e[4] * e2[31] - 0.5 * e[4] * e2[27] +
           0.5 * e[4] * e2[28] - 0.5 * e[4] * e2[29] - 0.5 * e[4] * e2[33] +
           0.5 * e[4] * e2[34] - 0.5 * e[4] * e2[35];
  a[185] =
      0.5 * e[22] * e2[30] + 0.5 * e[22] * e2[32] + 1.5 * e[22] * e2[31] +
      0.5 * e[22] * e2[34] - 0.5 * e[22] * e2[27] - 0.5 * e[22] * e2[29] -
      0.5 * e[22] * e2[33] - 0.5 * e[22] * e2[35] + e[28] * e[18] * e[30] +
      e[28] * e[29] * e[23] + e[28] * e[20] * e[32] + e[31] * e[30] * e[21] +
      e[31] * e[32] * e[23] + e[25] * e[30] * e[33] + e[25] * e[32] * e[35] +
      e[25] * e[31] * e[34] + e[34] * e[30] * e[24] + e[34] * e[21] * e[33] +
      e[34] * e[32] * e[26] + e[34] * e[23] * e[35] - e[31] * e[27] * e[18] -
      e[31] * e[33] * e[24] - e[31] * e[29] * e[20] - e[31] * e[35] * e[26] +
      e[19] * e[27] * e[30] + e[19] * e[29] * e[32] + e[19] * e[28] * e[31] +
      e[28] * e[27] * e[21] + 0.5 * e2[28] * e[22];
  a[155] =
      e[16] * e[30] * e[33] + e[16] * e[32] * e[35] + e[10] * e[27] * e[30] +
      e[10] * e[29] * e[32] + e[10] * e[28] * e[31] + e[34] * e[30] * e[15] +
      e[34] * e[12] * e[33] + e[34] * e[32] * e[17] + e[34] * e[14] * e[35] +
      e[34] * e[31] * e[16] + e[28] * e[27] * e[12] + e[28] * e[9] * e[30] +
      e[28] * e[29] * e[14] + e[28] * e[11] * e[32] - e[31] * e[27] * e[9] +
      e[31] * e[30] * e[12] + e[31] * e[32] * e[14] - e[31] * e[33] * e[15] -
      e[31] * e[35] * e[17] - e[31] * e[29] * e[11] - 0.5 * e[13] * e2[27] +
      0.5 * e[13] * e2[32] + 0.5 * e[13] * e2[28] - 0.5 * e[13] * e2[29] +
      1.5 * e[13] * e2[31] - 0.5 * e[13] * e2[33] + 0.5 * e[13] * e2[30] +
      0.5 * e[13] * e2[34] - 0.5 * e[13] * e2[35];
  a[134] =
      e[21] * e[23] * e[14] + e[21] * e[22] * e[13] + e[24] * e[21] * e[15] +
      e[24] * e[23] * e[17] + e[24] * e[14] * e[26] + e[24] * e[22] * e[16] +
      e[24] * e[13] * e[25] + e[15] * e[22] * e[25] + e[15] * e[23] * e[26] +
      e[9] * e[19] * e[22] + e[9] * e[18] * e[21] + e[9] * e[20] * e[23] +
      e[18] * e[20] * e[14] + e[18] * e[11] * e[23] + e[18] * e[19] * e[13] +
      e[18] * e[10] * e[22] - e[21] * e[25] * e[16] - e[21] * e[26] * e[17] -
      e[21] * e[20] * e[11] - e[21] * e[19] * e[10] + 1.5 * e2[21] * e[12] +
      0.5 * e[12] * e2[24] - 0.5 * e[12] * e2[26] + 0.5 * e[12] * e2[18] +
      0.5 * e[12] * e2[23] - 0.5 * e[12] * e2[19] - 0.5 * e[12] * e2[20] +
      0.5 * e[12] * e2[22] - 0.5 * e[12] * e2[25];
  a[144] =
      -e[12] * e[29] * e[20] - e[12] * e[35] * e[26] - e[12] * e[28] * e[19] -
      e[12] * e[34] * e[25] + e[18] * e[29] * e[14] + e[18] * e[11] * e[32] +
      e[18] * e[28] * e[13] + e[18] * e[10] * e[31] + e[27] * e[20] * e[14] +
      e[27] * e[11] * e[23] + e[27] * e[19] * e[13] + e[27] * e[10] * e[22] +
      e[15] * e[30] * e[24] + e[15] * e[21] * e[33] + e[15] * e[31] * e[25] +
      e[15] * e[22] * e[34] + e[15] * e[32] * e[26] + e[15] * e[23] * e[35] -
      e[21] * e[28] * e[10] - e[21] * e[34] * e[16] - e[21] * e[35] * e[17] -
      e[21] * e[29] * e[11] - e[30] * e[25] * e[16] - e[30] * e[26] * e[17] -
      e[30] * e[20] * e[11] - e[30] * e[19] * e[10] + e[24] * e[32] * e[17] +
      e[24] * e[14] * e[35] + e[24] * e[31] * e[16] + e[24] * e[13] * e[34] +
      e[33] * e[23] * e[17] + e[33] * e[14] * e[26] + e[33] * e[22] * e[16] +
      e[33] * e[13] * e[25] + 3. * e[12] * e[30] * e[21] +
      e[12] * e[31] * e[22] + e[12] * e[32] * e[23] + e[9] * e[27] * e[21] +
      e[9] * e[18] * e[30] + e[9] * e[28] * e[22] + e[9] * e[19] * e[31] +
      e[9] * e[29] * e[23] + e[9] * e[20] * e[32] + e[21] * e[32] * e[14] +
      e[21] * e[31] * e[13] + e[30] * e[23] * e[14] + e[30] * e[22] * e[13] +
      e[12] * e[27] * e[18] + e[12] * e[33] * e[24];
  a[24] = e[0] * e[11] * e[5] + e[0] * e[2] * e[14] + e[9] * e[1] * e[4] +
          e[9] * e[0] * e[3] + e[9] * e[2] * e[5] + e[3] * e[13] * e[4] +
          e[3] * e[14] * e[5] + e[6] * e[3] * e[15] + e[6] * e[13] * e[7] +
          e[6] * e[4] * e[16] + e[6] * e[14] * e[8] + e[6] * e[5] * e[17] +
          e[15] * e[4] * e[7] + e[15] * e[5] * e[8] - e[3] * e[11] * e[2] -
          e[3] * e[10] * e[1] - e[3] * e[16] * e[7] - e[3] * e[17] * e[8] +
          e[0] * e[10] * e[4] + e[0] * e[1] * e[13] + 1.5 * e[12] * e2[3] +
          0.5 * e[12] * e2[4] + 0.5 * e[12] * e2[5] + 0.5 * e[12] * e2[6] +
          0.5 * e2[0] * e[12] - 0.5 * e[12] * e2[1] - 0.5 * e[12] * e2[7] -
          0.5 * e[12] * e2[2] - 0.5 * e[12] * e2[8];
  a[104] = e[21] * e[24] * e[6] + e[0] * e[19] * e[22] + e[0] * e[20] * e[23] +
           e[24] * e[22] * e[7] + e[24] * e[4] * e[25] + e[24] * e[23] * e[8] +
           e[24] * e[5] * e[26] + e[6] * e[22] * e[25] + e[6] * e[23] * e[26] +
           e[18] * e[0] * e[21] + e[18] * e[19] * e[4] + e[18] * e[1] * e[22] +
           e[18] * e[20] * e[5] + e[18] * e[2] * e[23] + e[21] * e[22] * e[4] +
           e[21] * e[23] * e[5] - e[21] * e[26] * e[8] - e[21] * e[20] * e[2] -
           e[21] * e[19] * e[1] - e[21] * e[25] * e[7] + 1.5 * e2[21] * e[3] +
           0.5 * e[3] * e2[22] + 0.5 * e[3] * e2[23] + 0.5 * e[3] * e2[24] -
           0.5 * e[3] * e2[26] - 0.5 * e[3] * e2[19] - 0.5 * e[3] * e2[20] -
           0.5 * e[3] * e2[25] + 0.5 * e2[18] * e[3];
  a[76] =
      e[11] * e[27] * e[12] + e[11] * e[9] * e[30] + e[11] * e[29] * e[14] +
      e[11] * e[28] * e[13] + e[11] * e[10] * e[31] + e[29] * e[9] * e[12] +
      e[29] * e[10] * e[13] + e[14] * e[30] * e[12] + e[14] * e[31] * e[13] +
      e[17] * e[30] * e[15] + e[17] * e[12] * e[33] + e[17] * e[14] * e[35] +
      e[17] * e[31] * e[16] + e[17] * e[13] * e[34] + e[35] * e[12] * e[15] +
      e[35] * e[13] * e[16] - e[14] * e[27] * e[9] - e[14] * e[28] * e[10] -
      e[14] * e[33] * e[15] - e[14] * e[34] * e[16] + 0.5 * e2[11] * e[32] -
      0.5 * e[32] * e2[16] - 0.5 * e[32] * e2[9] + 0.5 * e[32] * e2[12] -
      0.5 * e[32] * e2[15] + 0.5 * e[32] * e2[17] - 0.5 * e[32] * e2[10] +
      1.5 * e[32] * e2[14] + 0.5 * e[32] * e2[13];
  a[6] = e[8] * e[3] * e[6] + 0.5 * e2[2] * e[5] - 0.5 * e[5] * e2[0] +
         0.5 * e[5] * e2[4] - 0.5 * e[5] * e2[6] + 0.5 * e[5] * e2[8] +
         e[8] * e[4] * e[7] + 0.5 * e3[5] + e[2] * e[0] * e[3] +
         0.5 * e[5] * e2[3] - 0.5 * e[5] * e2[7] + e[2] * e[1] * e[4] -
         0.5 * e[5] * e2[1];
  a[56] = e[2] * e[27] * e[3] + e[2] * e[0] * e[30] + e[2] * e[28] * e[4] +
          e[2] * e[1] * e[31] + e[2] * e[29] * e[5] - e[5] * e[27] * e[0] -
          e[5] * e[34] * e[7] - e[5] * e[33] * e[6] + e[5] * e[30] * e[3] +
          e[5] * e[35] * e[8] - e[5] * e[28] * e[1] + e[5] * e[31] * e[4] +
          e[29] * e[1] * e[4] + e[29] * e[0] * e[3] + e[8] * e[30] * e[6] +
          e[8] * e[3] * e[33] + e[8] * e[31] * e[7] + e[8] * e[4] * e[34] +
          e[35] * e[4] * e[7] + e[35] * e[3] * e[6] + 0.5 * e2[2] * e[32] +
          1.5 * e[32] * e2[5] + 0.5 * e[32] * e2[4] - 0.5 * e[32] * e2[0] -
          0.5 * e[32] * e2[6] - 0.5 * e[32] * e2[1] - 0.5 * e[32] * e2[7] +
          0.5 * e[32] * e2[3] + 0.5 * e[32] * e2[8];
  a[86] = -e[14] * e[19] * e[1] + e[14] * e[22] * e[4] - e[14] * e[18] * e[0] -
          e[14] * e[25] * e[7] - e[14] * e[24] * e[6] - e[23] * e[10] * e[1] +
          e[23] * e[13] * e[4] - e[23] * e[16] * e[7] - e[23] * e[15] * e[6] -
          e[23] * e[9] * e[0] + e[23] * e[12] * e[3] + e[17] * e[21] * e[6] +
          e[17] * e[3] * e[24] + e[17] * e[22] * e[7] + e[17] * e[4] * e[25] +
          e[17] * e[5] * e[26] - e[5] * e[24] * e[15] - e[5] * e[25] * e[16] -
          e[5] * e[18] * e[9] - e[5] * e[19] * e[10] + e[26] * e[12] * e[6] +
          e[26] * e[3] * e[15] + e[26] * e[13] * e[7] + e[26] * e[4] * e[16] +
          e[11] * e[18] * e[3] + e[11] * e[0] * e[21] + e[11] * e[19] * e[4] +
          e[11] * e[1] * e[22] + e[11] * e[20] * e[5] + e[11] * e[2] * e[23] +
          e[20] * e[9] * e[3] + e[20] * e[0] * e[12] + e[20] * e[10] * e[4] +
          e[20] * e[1] * e[13] + e[20] * e[2] * e[14] + e[5] * e[21] * e[12] +
          3. * e[5] * e[23] * e[14] + e[5] * e[22] * e[13] +
          e[8] * e[21] * e[15] + e[8] * e[12] * e[24] + e[8] * e[23] * e[17] +
          e[8] * e[14] * e[26] + e[8] * e[22] * e[16] + e[8] * e[13] * e[25] +
          e[2] * e[18] * e[12] + e[2] * e[9] * e[21] + e[2] * e[19] * e[13] +
          e[2] * e[10] * e[22] + e[14] * e[21] * e[3];
  a[156] =
      -0.5 * e[14] * e2[27] + 1.5 * e[14] * e2[32] - 0.5 * e[14] * e2[28] +
      0.5 * e[14] * e2[29] + 0.5 * e[14] * e2[31] - 0.5 * e[14] * e2[33] +
      0.5 * e[14] * e2[30] - 0.5 * e[14] * e2[34] + 0.5 * e[14] * e2[35] +
      e[11] * e[27] * e[30] + e[11] * e[29] * e[32] + e[11] * e[28] * e[31] +
      e[35] * e[30] * e[15] + e[35] * e[12] * e[33] + e[35] * e[32] * e[17] +
      e[35] * e[31] * e[16] + e[35] * e[13] * e[34] + e[29] * e[27] * e[12] +
      e[29] * e[9] * e[30] + e[29] * e[28] * e[13] + e[29] * e[10] * e[31] -
      e[32] * e[27] * e[9] + e[32] * e[30] * e[12] - e[32] * e[28] * e[10] +
      e[32] * e[31] * e[13] - e[32] * e[33] * e[15] - e[32] * e[34] * e[16] +
      e[17] * e[30] * e[33] + e[17] * e[31] * e[34];
  a[186] =
      -0.5 * e[23] * e2[33] - 0.5 * e[23] * e2[34] + 0.5 * e2[29] * e[23] +
      0.5 * e[23] * e2[30] + 1.5 * e[23] * e2[32] + 0.5 * e[23] * e2[31] +
      0.5 * e[23] * e2[35] - 0.5 * e[23] * e2[27] - 0.5 * e[23] * e2[28] +
      e[32] * e[30] * e[21] + e[32] * e[31] * e[22] + e[26] * e[30] * e[33] +
      e[26] * e[32] * e[35] + e[26] * e[31] * e[34] + e[35] * e[30] * e[24] +
      e[35] * e[21] * e[33] + e[35] * e[31] * e[25] + e[35] * e[22] * e[34] -
      e[32] * e[27] * e[18] - e[32] * e[33] * e[24] - e[32] * e[28] * e[19] -
      e[32] * e[34] * e[25] + e[20] * e[27] * e[30] + e[20] * e[29] * e[32] +
      e[20] * e[28] * e[31] + e[29] * e[27] * e[21] + e[29] * e[18] * e[30] +
      e[29] * e[28] * e[22] + e[29] * e[19] * e[31];
  a[126] = e[2] * e[27] * e[30] + e[2] * e[29] * e[32] + e[2] * e[28] * e[31] +
           e[32] * e[30] * e[3] + e[32] * e[31] * e[4] + e[8] * e[30] * e[33] +
           e[8] * e[32] * e[35] + e[8] * e[31] * e[34] + e[29] * e[27] * e[3] +
           e[29] * e[0] * e[30] + e[29] * e[28] * e[4] + e[29] * e[1] * e[31] +
           e[35] * e[30] * e[6] + e[35] * e[3] * e[33] + e[35] * e[31] * e[7] +
           e[35] * e[4] * e[34] - e[32] * e[27] * e[0] - e[32] * e[34] * e[7] -
           e[32] * e[33] * e[6] - e[32] * e[28] * e[1] + 0.5 * e[5] * e2[30] +
           1.5 * e[5] * e2[32] + 0.5 * e[5] * e2[31] - 0.5 * e[5] * e2[27] -
           0.5 * e[5] * e2[28] + 0.5 * e[5] * e2[29] - 0.5 * e[5] * e2[33] -
           0.5 * e[5] * e2[34] + 0.5 * e[5] * e2[35];
  a[196] = 0.5 * e[32] * e2[31] + 0.5 * e[32] * e2[35] - 0.5 * e[32] * e2[27] +
           e[29] * e[27] * e[30] + e[29] * e[28] * e[31] +
           e[35] * e[30] * e[33] + e[35] * e[31] * e[34] +
           0.5 * e2[29] * e[32] + 0.5 * e3[32] - 0.5 * e[32] * e2[33] -
           0.5 * e[32] * e2[34] + 0.5 * e[32] * e2[30] - 0.5 * e[32] * e2[28];
  a[25] = e[10] * e[1] * e[4] + e[10] * e[0] * e[3] + e[10] * e[2] * e[5] +
          e[4] * e[12] * e[3] + e[4] * e[14] * e[5] + e[7] * e[12] * e[6] +
          e[7] * e[3] * e[15] + e[7] * e[4] * e[16] + e[7] * e[14] * e[8] +
          e[7] * e[5] * e[17] + e[16] * e[3] * e[6] + e[16] * e[5] * e[8] -
          e[4] * e[11] * e[2] - e[4] * e[15] * e[6] - e[4] * e[9] * e[0] -
          e[4] * e[17] * e[8] + e[1] * e[9] * e[3] + e[1] * e[0] * e[12] +
          e[1] * e[11] * e[5] + e[1] * e[2] * e[14] + 1.5 * e[13] * e2[4] +
          0.5 * e[13] * e2[3] + 0.5 * e[13] * e2[5] + 0.5 * e[13] * e2[7] +
          0.5 * e2[1] * e[13] - 0.5 * e[13] * e2[0] - 0.5 * e[13] * e2[6] -
          0.5 * e[13] * e2[2] - 0.5 * e[13] * e2[8];
  a[105] = e[25] * e[21] * e[6] + e[25] * e[3] * e[24] + e[25] * e[23] * e[8] +
           e[25] * e[5] * e[26] + e[7] * e[21] * e[24] + e[7] * e[23] * e[26] +
           e[19] * e[18] * e[3] + e[19] * e[0] * e[21] + e[19] * e[1] * e[22] +
           e[19] * e[20] * e[5] + e[19] * e[2] * e[23] + e[22] * e[21] * e[3] +
           e[22] * e[23] * e[5] - e[22] * e[26] * e[8] - e[22] * e[20] * e[2] -
           e[22] * e[18] * e[0] + e[22] * e[25] * e[7] - e[22] * e[24] * e[6] +
           e[1] * e[18] * e[21] + e[1] * e[20] * e[23] + 0.5 * e[4] * e2[25] -
           0.5 * e[4] * e2[26] - 0.5 * e[4] * e2[18] - 0.5 * e[4] * e2[20] -
           0.5 * e[4] * e2[24] + 0.5 * e2[19] * e[4] + 1.5 * e2[22] * e[4] +
           0.5 * e[4] * e2[21] + 0.5 * e[4] * e2[23];
  a[135] =
      e[22] * e[21] * e[12] + e[22] * e[23] * e[14] + e[25] * e[21] * e[15] +
      e[25] * e[12] * e[24] + e[25] * e[23] * e[17] + e[25] * e[14] * e[26] +
      e[25] * e[22] * e[16] + e[16] * e[21] * e[24] + e[16] * e[23] * e[26] +
      e[10] * e[19] * e[22] + e[10] * e[18] * e[21] + e[10] * e[20] * e[23] +
      e[19] * e[18] * e[12] + e[19] * e[9] * e[21] + e[19] * e[20] * e[14] +
      e[19] * e[11] * e[23] - e[22] * e[24] * e[15] - e[22] * e[26] * e[17] -
      e[22] * e[20] * e[11] - e[22] * e[18] * e[9] - 0.5 * e[13] * e2[26] -
      0.5 * e[13] * e2[18] + 0.5 * e[13] * e2[23] + 0.5 * e[13] * e2[19] -
      0.5 * e[13] * e2[20] - 0.5 * e[13] * e2[24] + 0.5 * e[13] * e2[21] +
      1.5 * e2[22] * e[13] + 0.5 * e[13] * e2[25];
  a[145] =
      e[13] * e[30] * e[21] + 3. * e[13] * e[31] * e[22] +
      e[13] * e[32] * e[23] + e[10] * e[27] * e[21] + e[10] * e[18] * e[30] +
      e[10] * e[28] * e[22] + e[10] * e[19] * e[31] + e[10] * e[29] * e[23] +
      e[10] * e[20] * e[32] + e[22] * e[30] * e[12] + e[22] * e[32] * e[14] +
      e[31] * e[21] * e[12] + e[31] * e[23] * e[14] - e[13] * e[27] * e[18] -
      e[13] * e[33] * e[24] - e[13] * e[29] * e[20] - e[13] * e[35] * e[26] +
      e[13] * e[28] * e[19] + e[13] * e[34] * e[25] + e[19] * e[27] * e[12] +
      e[19] * e[9] * e[30] + e[19] * e[29] * e[14] + e[19] * e[11] * e[32] +
      e[28] * e[18] * e[12] + e[28] * e[9] * e[21] + e[28] * e[20] * e[14] +
      e[28] * e[11] * e[23] + e[16] * e[30] * e[24] + e[16] * e[21] * e[33] +
      e[16] * e[31] * e[25] + e[16] * e[22] * e[34] + e[16] * e[32] * e[26] +
      e[16] * e[23] * e[35] - e[22] * e[27] * e[9] - e[22] * e[33] * e[15] -
      e[22] * e[35] * e[17] - e[22] * e[29] * e[11] - e[31] * e[24] * e[15] -
      e[31] * e[26] * e[17] - e[31] * e[20] * e[11] - e[31] * e[18] * e[9] +
      e[25] * e[30] * e[15] + e[25] * e[12] * e[33] + e[25] * e[32] * e[17] +
      e[25] * e[14] * e[35] + e[34] * e[21] * e[15] + e[34] * e[12] * e[24] +
      e[34] * e[23] * e[17] + e[34] * e[14] * e[26];
  a[65] =
      e[19] * e[11] * e[14] + e[19] * e[9] * e[12] + e[19] * e[10] * e[13] +
      e[13] * e[21] * e[12] + e[13] * e[23] * e[14] + e[16] * e[21] * e[15] +
      e[16] * e[12] * e[24] + e[16] * e[23] * e[17] + e[16] * e[14] * e[26] +
      e[16] * e[13] * e[25] + e[25] * e[14] * e[17] + e[25] * e[12] * e[15] -
      e[13] * e[24] * e[15] - e[13] * e[26] * e[17] - e[13] * e[20] * e[11] -
      e[13] * e[18] * e[9] + e[10] * e[18] * e[12] + e[10] * e[9] * e[21] +
      e[10] * e[20] * e[14] + e[10] * e[11] * e[23] + 1.5 * e[22] * e2[13] +
      0.5 * e[22] * e2[14] + 0.5 * e[22] * e2[12] + 0.5 * e[22] * e2[16] +
      0.5 * e2[10] * e[22] - 0.5 * e[22] * e2[9] - 0.5 * e[22] * e2[11] -
      0.5 * e[22] * e2[15] - 0.5 * e[22] * e2[17];
  a[35] = e[13] * e[12] * e[3] + e[13] * e[14] * e[5] + e[16] * e[12] * e[6] +
          e[16] * e[3] * e[15] + e[16] * e[13] * e[7] + e[16] * e[14] * e[8] +
          e[16] * e[5] * e[17] + e[7] * e[14] * e[17] + e[7] * e[12] * e[15] +
          e[1] * e[11] * e[14] + e[1] * e[9] * e[12] + e[1] * e[10] * e[13] +
          e[10] * e[9] * e[3] + e[10] * e[0] * e[12] + e[10] * e[11] * e[5] +
          e[10] * e[2] * e[14] - e[13] * e[11] * e[2] - e[13] * e[15] * e[6] -
          e[13] * e[9] * e[0] - e[13] * e[17] * e[8] + 1.5 * e2[13] * e[4] +
          0.5 * e[4] * e2[16] - 0.5 * e[4] * e2[9] - 0.5 * e[4] * e2[11] +
          0.5 * e[4] * e2[12] - 0.5 * e[4] * e2[15] - 0.5 * e[4] * e2[17] +
          0.5 * e[4] * e2[10] + 0.5 * e[4] * e2[14];
  a[45] = e[19] * e[1] * e[4] + e[19] * e[0] * e[3] + e[19] * e[2] * e[5] +
          e[4] * e[21] * e[3] + e[4] * e[23] * e[5] + e[7] * e[21] * e[6] +
          e[7] * e[3] * e[24] + e[7] * e[4] * e[25] + e[7] * e[23] * e[8] +
          e[7] * e[5] * e[26] + e[25] * e[3] * e[6] + e[25] * e[5] * e[8] +
          e[1] * e[18] * e[3] + e[1] * e[0] * e[21] + e[1] * e[20] * e[5] +
          e[1] * e[2] * e[23] - e[4] * e[26] * e[8] - e[4] * e[20] * e[2] -
          e[4] * e[18] * e[0] - e[4] * e[24] * e[6] + 1.5 * e[22] * e2[4] -
          0.5 * e[22] * e2[0] - 0.5 * e[22] * e2[6] + 0.5 * e[22] * e2[5] +
          0.5 * e[22] * e2[1] + 0.5 * e[22] * e2[7] + 0.5 * e[22] * e2[3] -
          0.5 * e[22] * e2[2] - 0.5 * e[22] * e2[8];
  a[115] = -e[31] * e[20] * e[2] - e[31] * e[18] * e[0] + e[31] * e[23] * e[5] -
           e[31] * e[24] * e[6] + e[7] * e[30] * e[24] + e[7] * e[21] * e[33] +
           e[7] * e[32] * e[26] + e[7] * e[23] * e[35] + e[25] * e[30] * e[6] +
           e[25] * e[3] * e[33] + e[25] * e[31] * e[7] + e[25] * e[4] * e[34] +
           e[25] * e[32] * e[8] + e[25] * e[5] * e[35] + e[34] * e[21] * e[6] +
           e[34] * e[3] * e[24] + e[34] * e[22] * e[7] + e[34] * e[23] * e[8] +
           e[34] * e[5] * e[26] + e[1] * e[27] * e[21] + e[1] * e[18] * e[30] +
           e[1] * e[28] * e[22] + e[1] * e[19] * e[31] + e[1] * e[29] * e[23] +
           e[1] * e[20] * e[32] + e[19] * e[27] * e[3] + e[19] * e[0] * e[30] +
           e[19] * e[28] * e[4] + e[19] * e[29] * e[5] + e[19] * e[2] * e[32] +
           e[28] * e[18] * e[3] + e[28] * e[0] * e[21] + e[28] * e[20] * e[5] +
           e[28] * e[2] * e[23] + e[4] * e[30] * e[21] +
           3. * e[4] * e[31] * e[22] + e[4] * e[32] * e[23] -
           e[4] * e[27] * e[18] - e[4] * e[33] * e[24] - e[4] * e[29] * e[20] -
           e[4] * e[35] * e[26] - e[22] * e[27] * e[0] + e[22] * e[32] * e[5] -
           e[22] * e[33] * e[6] + e[22] * e[30] * e[3] - e[22] * e[35] * e[8] -
           e[22] * e[29] * e[2] + e[31] * e[21] * e[3] - e[31] * e[26] * e[8];
}
