
/*LICENSE_START*/
/*
 *  Copyright (C) 2024  Washington University School of Medicine
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
/*LICENSE_END*/
namespace caret {

namespace AnnotationMetaDataNames {
        
    static const AString SAMPLES_ALLEN_LOCAL_NAME = "Allen Local Name";
    
    static const AString SAMPLES_ALLEN_SLAB_NUMBER = "Allen Slab Number";
    
    static const AString SAMPLES_ALLEN_TISSUE_TYPE= "Allen Tissue Type";
    
    static const AString SAMPLES_ALTERNATE_PARCELLATION = "Alternate Parcellation";
    
    static const AString SAMPLES_BICAN_DONOR_ID = "BICAN Donor ID";
    
    static const AString SAMPLES_COMMENT = "Comment";

    static const AString SAMPLES_DING_ABBREVIATION = "Ding Abbreviation";
    
    static const AString SAMPLES_DING_FULL_NAME = "Ding Full Name";
    
    static const AString SAMPLES_ENTRY_DATE = "Sample Entry Date";
    
    static const AString SAMPLES_HEMISPHERE = "Hemisphere";
    
    static const AString SAMPLES_LOCAL_SAMPLE_ID = "Local Sample ID";
    
    static const AString SAMPLES_LOCAL_SLAB_ID = "Local Slab ID";
    
    static const AString SAMPLES_LOCATION = "Location";
    
    static const AString SAMPLES_NHASH_SLAB_ID = "NHash Slab ID";
    
    static const AString SAMPLES_ORIGINAL_PARCELLATION = "Original Parcellation";
    
    static const AString SAMPLES_SAMPLE_NUMBER = "Sample Number";

    static const AString SAMPLES_SLAB_FACE = "Slab Face";
    
    static const AString SAMPLES_SAMPLE_TYPE = "Sample Type";

    static const AString SAMPLES_SUBJECT_NAME = "Subject Name";
    
    
    
    static const AString SAMPLES_REMOVED_ALT_ATLAS_DESCRIPTION = "Alt_Atlas_description";
    
    static const AString SAMPLES_REMOVED_ORIG_ATLAS_NAME = "Orig_atlas_name";
    
    static const AString SAMPLES_REMOVED_ORIG_SHORTHAND_ID = "Orig_shorthand_id";
    

    
    
    /** Replaced by SAMPLES_BICAN_DONOR_ID */
    static const AString SAMPLES_OBSOLETE_BICAN_DONOR_ID = "BICAN_Donor_id";

    /** Replaced by SAMPLES_SUBJECT_NAME */
    static const AString SAMPLES_OBSOLETE_CASE_ID = "Case_id";
    
    /** Replaced by SAMPLES_DING_FULL_NAME*/
    static const AString SAMPLES_OBSOLETE_DING_DESCRIPTION = "Ding_description";
    
    /** Replaced by SAMPLES_ENTRY_DATE */
    static const AString SAMPLES_OBSOLETE_DISSECTION_DATE = "Dissection_date";
    
    /** Replaced by SAMPLES_ALLEN_LOCAL_NAME */
    static const AString SAMPLES_OBSOLETE_DONOR_ID = "Donor_id";
    
    /** Replaced by  SAMPLES_SAMPLE_NUMBER */
    static const AString SAMPLES_OBSOLETE_SAMPLE_ID = "Sample_id";
    
    /** Replaced by SAMPLES_SAMPLE_TYPE */
    static const AString SAMPLES_OBSOLETE_SAMPLE_TYPE = "Sample_type";
    
    /** Replaced by SAMPLES_DING_ABBREVIATION */
    static const AString SAMPLES_OBSOLETE_SHORTHAND_ID = "Shorthand_id";
    
    /** Replaced by SAMPLES_SLAB_FACE */
    static const AString SAMPLES_OBSOLETE_SLAB_FACE = "Slab_face";
    
    /** Replaced by  SAMPLES_ALLEN_SLAB_NUMBER */
    static const AString SAMPLES_OBSOLETE_SLAB_ID = "Slab_id";

    
    
    /** Used for converting a QDate to a string */
    const AString SAMPLES_QT_DATE_FORMAT = "dd/MM/yyyy";

    const AString SAMPLES_OBSOLETE_QT_DATE_FORMAT = "dd MMM yyyy";
    

} // namespace

} // namespace
