" Vim syntax file
" Language: DDTP files - Italian version for Client syntax
" Maintainer: Lorenzo Cappelletti <lorenzo.cappelletti@email.it>
" Last Change: 

" For copyright statement and stuff, see file ddtpCom.vim



runtime syntax/ddtpComIt.vim

syntax region ddtpCliIt		fold keepend transparent contained
	\ start=/^\([>+]>[a-z+-][+-]\)\?Description-it/
	\ end=/^$/me=s-1
	\ contains=ddtpCliItSynp,ddtpCliItDesc

syntax region  ddtpCliItSynp	transparent contained
	\ start=/^\([>+]>[a-z+-][+-]\)\?Description-it.*/
	\ end=/^\([>+]>[a-z+-][+-]Description-it.*$\)\@!/
	\ contains=ddtpComSynpKey,ddtpComTodo,@ddtpCliDiff,@ddtpComErrSynp,
		  \@ddtpComItErr,ddtpComErrSynpTrailingDot	" Synopsis

syntax region ddtpCliItDesc 	fold keepend transparent contained
	\ start=/^\(\([>+]>[a-z+-][+-]\)\?Description-it.*$\)\@!/
	\ end=/^$/
	\ contains=ddtpCliItPara,ddtpComDot			" Description

syntax region ddtpCliItPara	fold transparent contained
	\ start=/\(^ \.\)\@!/
	\ skip=/^[#>+]/
	\ end=/ \.$/me=e-2
	\ contains=@ddtpCliComm,ddtpComTodo,@ddtpCliDiff,
		  \@ddtpComErrPara,@ddtpComItErr		" Paragraph

