/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/frame/version.hpp
 *
 * @brief [LEVEL: beta] @ref diagnostics::diagnostics_library_version
 *
 * $Id: version.hpp,v 1.6 2005/06/23 09:54:20 esdentem Exp $
 *
 * @author Christian Schallhart
 *
 * @test none
 */
#ifndef DIAGNOSTICS__FRAME__VERSION_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__FRAME__VERSION_HPP__INCLUDE_GUARD

#include <diagnostics/frame/namespace.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;

/**
 * @brief returns the underlying version of the diagnostic library. 
 * 
 * @param svn_version determines which versioning is used:
 * svn_version==true  gives the cvs-Id of version.cpp. 
 * svn_version==false gives the overall library version.
 */
char const * diagnostics_library_version(bool const svn_version);

DIAGNOSTICS_NAMESPACE_END;

#endif

// vim:ts=4:sw=4
