; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,FALLBACK0
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX,AVX1,AVX1-ONLY,FALLBACK1
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-SLOW,FALLBACK2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-FAST,FALLBACK3
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-FAST-PERLANE,FALLBACK4
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-SLOW,AVX512F-ONLY-SLOW,FALLBACK5
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-FAST,AVX512F-ONLY-FAST,FALLBACK6
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-SLOW,AVX512DQ-SLOW,FALLBACK7
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-FAST,AVX512DQ-FAST,FALLBACK8
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-SLOW,AVX512BW-ONLY-SLOW,FALLBACK9
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-FAST,AVX512BW-ONLY-FAST,FALLBACK10
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-SLOW,AVX512DQBW-SLOW,FALLBACK11
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-FAST,AVX512DQBW-FAST,FALLBACK12

; These patterns are produced by LoopVectorizer for interleaved stores.

define void @store_i16_stride3_vf2(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride3_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm0[0,1,2,3,4,7,6,7]
; SSE-NEXT:    movq %xmm0, (%rcx)
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,2,3]
; SSE-NEXT:    movd %xmm0, 8(%rcx)
; SSE-NEXT:    retq
;
; AVX1-LABEL: store_i16_stride3_vf2:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,8,9,2,3,4,5,12,13,6,7,4,5,6,7]
; AVX1-NEXT:    vpextrd $2, %xmm0, 8(%rcx)
; AVX1-NEXT:    vmovq %xmm0, (%rcx)
; AVX1-NEXT:    retq
;
; AVX512F-LABEL: store_i16_stride3_vf2:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512F-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX512F-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,8,9,2,3,4,5,12,13,6,7,4,5,6,7]
; AVX512F-NEXT:    vpextrd $2, %xmm0, 8(%rcx)
; AVX512F-NEXT:    vmovq %xmm0, (%rcx)
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: store_i16_stride3_vf2:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm1 = [0,2,8,1,3,9,1,9]
; AVX512BW-NEXT:    vpermi2w (%rdx), %xmm0, %xmm1
; AVX512BW-NEXT:    vpextrd $2, %xmm1, 8(%rcx)
; AVX512BW-NEXT:    vmovq %xmm1, (%rcx)
; AVX512BW-NEXT:    retq
  %in.vec0 = load <2 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <2 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <2 x i16>, ptr %in.vecptr2, align 64
  %1 = shufflevector <2 x i16> %in.vec0, <2 x i16> %in.vec1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = shufflevector <2 x i16> %in.vec2, <2 x i16> poison, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  %3 = shufflevector <4 x i16> %1, <4 x i16> %2, <6 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5>
  %interleaved.vec = shufflevector <6 x i16> %3, <6 x i16> poison, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
  store <6 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i16_stride3_vf4(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride3_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm2 = mem[0],zero
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm1[0]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[0,0,0,0]
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm2[0,1,2,3,6,5,4,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,2,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,5,5,6,4]
; SSE-NEXT:    pand %xmm3, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [0,65535,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,3,1,3,4,5,6,7]
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    movq %xmm1, 16(%rcx)
; SSE-NEXT:    movdqa %xmm3, (%rcx)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i16_stride3_vf4:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX1-ONLY-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX1-ONLY-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX1-ONLY-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm1[3,1,2,3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[0,3,1,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[1,1,1,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm3[0],xmm2[1,2],xmm3[3],xmm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[0,1,8,9,u,u,2,3,10,11,u,u,4,5,12,13]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0,1],xmm0[2],xmm1[3,4],xmm0[5],xmm1[6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, (%rcx)
; AVX1-ONLY-NEXT:    vmovq %xmm2, 16(%rcx)
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i16_stride3_vf4:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-ONLY-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-ONLY-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX2-ONLY-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} ymm1 = ymm0[0,1,8,9],zero,zero,ymm0[2,3,10,11],zero,zero,ymm0[4,5,12,13,20,21],zero,zero,zero,zero,ymm0[22,23],zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,ymm0[0,1],zero,zero,zero,zero,ymm0[2,3],zero,zero,zero,zero,zero,zero,ymm0[22,23,30,31],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-ONLY-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-ONLY-NEXT:    vmovq %xmm1, 16(%rcx)
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, (%rcx)
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512F-LABEL: store_i16_stride3_vf4:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512F-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512F-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512F-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512F-NEXT:    vpshufb {{.*#+}} ymm1 = ymm0[0,1,8,9],zero,zero,ymm0[2,3,10,11],zero,zero,ymm0[4,5,12,13,20,21],zero,zero,zero,zero,ymm0[22,23,u,u,u,u,u,u,u,u]
; AVX512F-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX512F-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,ymm0[0,1],zero,zero,zero,zero,ymm0[2,3],zero,zero,zero,zero,zero,zero,ymm0[22,23,30,31],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512F-NEXT:    vmovq %xmm1, 16(%rcx)
; AVX512F-NEXT:    vmovdqa %xmm0, (%rcx)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: store_i16_stride3_vf4:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512BW-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm1 = <0,4,8,1,5,9,2,6,10,3,7,11,u,u,u,u>
; AVX512BW-NEXT:    vpermw %ymm0, %ymm1, %ymm0
; AVX512BW-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512BW-NEXT:    vmovq %xmm1, 16(%rcx)
; AVX512BW-NEXT:    vmovdqa %xmm0, (%rcx)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <4 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <4 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <4 x i16>, ptr %in.vecptr2, align 64
  %1 = shufflevector <4 x i16> %in.vec0, <4 x i16> %in.vec1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = shufflevector <4 x i16> %in.vec2, <4 x i16> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %3 = shufflevector <8 x i16> %1, <8 x i16> %2, <12 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11>
  %interleaved.vec = shufflevector <12 x i16> %3, <12 x i16> poison, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  store <12 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i16_stride3_vf8(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride3_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa (%rsi), %xmm2
; SSE-NEXT:    movdqa (%rdx), %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[0,0,0,0]
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm4, %xmm5
; SSE-NEXT:    pandn %xmm1, %xmm5
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,5,4,5]
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    por %xmm5, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[1,1,2,2]
; SSE-NEXT:    pand %xmm4, %xmm5
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm2[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pandn %xmm6, %xmm4
; SSE-NEXT:    por %xmm5, %xmm4
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [0,65535,65535,0,65535,65535,0,65535]
; SSE-NEXT:    pand %xmm5, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm3[1,1,2,2]
; SSE-NEXT:    pandn %xmm6, %xmm5
; SSE-NEXT:    por %xmm4, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [65535,0,65535,65535,0,65535,65535,0]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[2,1,3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[2,1,1,0,4,5,6,7]
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    por %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm4, 32(%rcx)
; SSE-NEXT:    movdqa %xmm5, 16(%rcx)
; SSE-NEXT:    movdqa %xmm1, (%rcx)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i16_stride3_vf8:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovdqa (%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa (%rdx), %xmm2
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[1,1,2,2]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm1[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1],xmm4[2],xmm3[3,4],xmm4[5],xmm3[6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm2[1,1,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm4[0],xmm3[1,2],xmm4[3],xmm3[4,5],xmm4[6],xmm3[7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[4,5,u,u,10,11,8,9,u,u,14,15,12,13,u,u]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm2[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0],xmm5[1],xmm4[2,3],xmm5[4],xmm4[5,6],xmm5[7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,2,3,u,u,4,5,6,7,u,u,8,9,10,11]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm2[0,0,0,0]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3,4],xmm1[5],xmm0[6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, (%rcx)
; AVX1-ONLY-NEXT:    vmovdqa %xmm4, 32(%rcx)
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, 16(%rcx)
; AVX1-ONLY-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i16_stride3_vf8:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %xmm1
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %xmm2
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm3
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm4 = ymm3[0,1,u,u,6,7,2,3,u,u,8,9,4,5,u,u,16,17,u,u,22,23,18,19,u,u,24,25,20,21,u,u]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,3,0,1]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[u,u,0,1,u,u,u,u,2,3,u,u,u,u,4,5,u,u,22,23,u,u,u,u,24,25,u,u,u,u,26,27]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm4[0],ymm3[1],ymm4[2,3],ymm3[4],ymm4[5,6],ymm3[7],ymm4[8],ymm3[9],ymm4[10,11],ymm3[12],ymm4[13,14],ymm3[15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = <u,0,0,u,1,1,u,2>
; AVX2-SLOW-NEXT:    vpermd %ymm2, %ymm4, %ymm4
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm5 = [255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm5, %ymm3, %ymm4, %ymm3
; AVX2-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,5,u,u,10,11,8,9,u,u,14,15,12,13,u,u]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm1 = xmm2[2,2,3,3]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3],xmm1[4],xmm0[5,6],xmm1[7]
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, 32(%rcx)
; AVX2-SLOW-NEXT:    vmovdqa %ymm3, (%rcx)
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i16_stride3_vf8:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %xmm1
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %xmm2
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm3
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = <u,0,0,u,1,1,u,2>
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm4, %ymm4
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = [0,4,1,5,1,5,2,6]
; AVX2-FAST-NEXT:    vpermd %ymm3, %ymm5, %ymm3
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[0,1,4,5,u,u,2,3,6,7,u,u,8,9,12,13,u,u,18,19,22,23,u,u,24,25,28,29,u,u,26,27]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = [255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm3, %ymm4, %ymm3
; AVX2-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,5,u,u,10,11,8,9,u,u,14,15,12,13,u,u]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm1 = xmm2[2,2,3,3]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3],xmm1[4],xmm0[5,6],xmm1[7]
; AVX2-FAST-NEXT:    vmovdqa %xmm0, 32(%rcx)
; AVX2-FAST-NEXT:    vmovdqa %ymm3, (%rcx)
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: store_i16_stride3_vf8:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %xmm2
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm4 = ymm3[0,1,u,u,6,7,2,3,u,u,8,9,4,5,u,u,16,17,u,u,22,23,18,19,u,u,24,25,20,21,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,3,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[u,u,0,1,u,u,u,u,2,3,u,u,u,u,4,5,u,u,22,23,u,u,u,u,24,25,u,u,u,u,26,27]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm3 = ymm4[0],ymm3[1],ymm4[2,3],ymm3[4],ymm4[5,6],ymm3[7],ymm4[8],ymm3[9],ymm4[10,11],ymm3[12],ymm4[13,14],ymm3[15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm4 = <u,0,0,u,1,1,u,2>
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm2, %ymm4, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm5 = [255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm5, %ymm3, %ymm4, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,5,u,u,10,11,8,9,u,u,14,15,12,13,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm1 = xmm2[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3],xmm1[4],xmm0[5,6],xmm1[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, 32(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm3, (%rcx)
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512F-SLOW-LABEL: store_i16_stride3_vf8:
; AVX512F-SLOW:       # %bb.0:
; AVX512F-SLOW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512F-SLOW-NEXT:    vmovdqa (%rsi), %xmm1
; AVX512F-SLOW-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512F-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm3
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm4 = ymm3[0,1,u,u,u,u,2,3,u,u,u,u,4,5,u,u,u,u,u,u,22,23,u,u,u,u,24,25,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,3,0,1]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[u,u,0,1,u,u,u,u,2,3,u,u,u,u,4,5,u,u,22,23,u,u,u,u,24,25,u,u,u,u,26,27]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm4[0],ymm3[1],ymm4[2,3],ymm3[4],ymm4[5,6],ymm3[7],ymm4[8],ymm3[9],ymm4[10,11],ymm3[12],ymm4[13,14],ymm3[15]
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = <u,0,0,u,1,1,u,2>
; AVX512F-SLOW-NEXT:    vpermd %ymm2, %ymm4, %ymm4
; AVX512F-SLOW-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm3, %ymm4
; AVX512F-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,5,u,u,10,11,8,9,u,u,14,15,12,13,u,u]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm1 = xmm2[2,2,3,3]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3],xmm1[4],xmm0[5,6],xmm1[7]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm0, %zmm4, %zmm0
; AVX512F-SLOW-NEXT:    vmovdqa %ymm4, (%rcx)
; AVX512F-SLOW-NEXT:    vextracti32x4 $2, %zmm0, 32(%rcx)
; AVX512F-SLOW-NEXT:    vzeroupper
; AVX512F-SLOW-NEXT:    retq
;
; AVX512F-FAST-LABEL: store_i16_stride3_vf8:
; AVX512F-FAST:       # %bb.0:
; AVX512F-FAST-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512F-FAST-NEXT:    vmovdqa (%rsi), %xmm1
; AVX512F-FAST-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512F-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm3
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = <u,0,0,u,1,1,u,2>
; AVX512F-FAST-NEXT:    vpermd %ymm2, %ymm4, %ymm4
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = [0,4,1,5,1,5,2,6]
; AVX512F-FAST-NEXT:    vpermd %ymm3, %ymm5, %ymm3
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[0,1,4,5],zero,zero,ymm3[2,3,6,7],zero,zero,ymm3[8,9,12,13],zero,zero,ymm3[18,19,22,23],zero,zero,ymm3[24,25,28,29],zero,zero,ymm3[26,27]
; AVX512F-FAST-NEXT:    vpternlogq $244, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm4, %ymm3
; AVX512F-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,5,u,u,10,11,8,9,u,u,14,15,12,13,u,u]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} xmm1 = xmm2[2,2,3,3]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3],xmm1[4],xmm0[5,6],xmm1[7]
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm0, %zmm3, %zmm0
; AVX512F-FAST-NEXT:    vmovdqa %ymm3, (%rcx)
; AVX512F-FAST-NEXT:    vextracti32x4 $2, %zmm0, 32(%rcx)
; AVX512F-FAST-NEXT:    vzeroupper
; AVX512F-FAST-NEXT:    retq
;
; AVX512BW-LABEL: store_i16_stride3_vf8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512BW-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = <0,8,16,1,9,17,2,10,18,3,11,19,4,12,20,5,13,21,6,14,22,7,15,23,u,u,u,u,u,u,u,u>
; AVX512BW-NEXT:    vpermw %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    vextracti32x4 $2, %zmm0, 32(%rcx)
; AVX512BW-NEXT:    vmovdqa %ymm0, (%rcx)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <8 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <8 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <8 x i16>, ptr %in.vecptr2, align 64
  %1 = shufflevector <8 x i16> %in.vec0, <8 x i16> %in.vec1, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %2 = shufflevector <8 x i16> %in.vec2, <8 x i16> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %3 = shufflevector <16 x i16> %1, <16 x i16> %2, <24 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %interleaved.vec = shufflevector <24 x i16> %3, <24 x i16> poison, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
  store <24 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i16_stride3_vf16(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride3_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm1
; SSE-NEXT:    movdqa 16(%rdi), %xmm6
; SSE-NEXT:    movdqa (%rsi), %xmm2
; SSE-NEXT:    movdqa 16(%rsi), %xmm7
; SSE-NEXT:    movdqa (%rdx), %xmm4
; SSE-NEXT:    movdqa 16(%rdx), %xmm9
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm6[1,1,2,2]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm7[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm0, %xmm8
; SSE-NEXT:    pandn %xmm5, %xmm8
; SSE-NEXT:    por %xmm3, %xmm8
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [0,65535,65535,0,65535,65535,0,65535]
; SSE-NEXT:    pand %xmm3, %xmm8
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm9[1,1,2,2]
; SSE-NEXT:    movdqa %xmm3, %xmm5
; SSE-NEXT:    pandn %xmm10, %xmm5
; SSE-NEXT:    por %xmm8, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm9[0,0,0,0]
; SSE-NEXT:    movdqa %xmm0, %xmm10
; SSE-NEXT:    pandn %xmm8, %xmm10
; SSE-NEXT:    movdqa %xmm6, %xmm8
; SSE-NEXT:    punpcklwd {{.*#+}} xmm8 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[0,1,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm8[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm8 = xmm8[0,1,2,3,7,5,4,5]
; SSE-NEXT:    pand %xmm0, %xmm8
; SSE-NEXT:    por %xmm10, %xmm8
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm1[1,1,2,2]
; SSE-NEXT:    pand %xmm0, %xmm10
; SSE-NEXT:    pshuflw {{.*#+}} xmm11 = xmm2[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm11 = xmm11[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm0, %xmm12
; SSE-NEXT:    pandn %xmm11, %xmm12
; SSE-NEXT:    por %xmm10, %xmm12
; SSE-NEXT:    pand %xmm3, %xmm12
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm4[1,1,2,2]
; SSE-NEXT:    pandn %xmm10, %xmm3
; SSE-NEXT:    por %xmm12, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm4[0,0,0,0]
; SSE-NEXT:    movdqa %xmm1, %xmm11
; SSE-NEXT:    punpcklwd {{.*#+}} xmm11 = xmm11[0],xmm2[0],xmm11[1],xmm2[1],xmm11[2],xmm2[2],xmm11[3],xmm2[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm11[0,1,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm11 = xmm11[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm11 = xmm11[0,1,2,3,7,5,4,5]
; SSE-NEXT:    pand %xmm0, %xmm11
; SSE-NEXT:    pandn %xmm10, %xmm0
; SSE-NEXT:    por %xmm11, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm9[2,2,3,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [65535,0,65535,65535,0,65535,65535,0]
; SSE-NEXT:    movdqa %xmm10, %xmm11
; SSE-NEXT:    pandn %xmm9, %xmm11
; SSE-NEXT:    punpckhwd {{.*#+}} xmm7 = xmm7[4],xmm6[4],xmm7[5],xmm6[5],xmm7[6],xmm6[6],xmm7[7],xmm6[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm7[2,1,3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm6[2,1,1,0,4,5,6,7]
; SSE-NEXT:    pand %xmm10, %xmm6
; SSE-NEXT:    por %xmm11, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[2,1,3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,1,1,0,4,5,6,7]
; SSE-NEXT:    pand %xmm10, %xmm1
; SSE-NEXT:    pandn %xmm4, %xmm10
; SSE-NEXT:    por %xmm1, %xmm10
; SSE-NEXT:    movdqa %xmm10, 32(%rcx)
; SSE-NEXT:    movdqa %xmm6, 80(%rcx)
; SSE-NEXT:    movdqa %xmm0, (%rcx)
; SSE-NEXT:    movdqa %xmm3, 16(%rcx)
; SSE-NEXT:    movdqa %xmm8, 48(%rcx)
; SSE-NEXT:    movdqa %xmm5, 64(%rcx)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i16_stride3_vf16:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm1[1,1,2,2]
; AVX1-ONLY-NEXT:    vmovdqa (%rsi), %xmm3
; AVX1-ONLY-NEXT:    vmovdqa 16(%rsi), %xmm4
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm4[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1],xmm5[2],xmm2[3,4],xmm5[5],xmm2[6,7]
; AVX1-ONLY-NEXT:    vmovdqa (%rdx), %xmm5
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdx), %xmm6
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm6[1,1,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm7[0],xmm2[1,2],xmm7[3],xmm2[4,5],xmm7[6],xmm2[7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm0[1,1,2,2]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm8 = xmm3[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm8 = xmm8[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm7 = xmm7[0,1],xmm8[2],xmm7[3,4],xmm8[5],xmm7[6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm5[1,1,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm7 = xmm8[0],xmm7[1,2],xmm8[3],xmm7[4,5],xmm8[6],xmm7[7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm8 = xmm4[4],xmm1[4],xmm4[5],xmm1[5],xmm4[6],xmm1[6],xmm4[7],xmm1[7]
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm9 = [4,5,10,11,10,11,8,9,8,9,14,15,12,13,14,15]
; AVX1-ONLY-NEXT:    vpshufb %xmm9, %xmm8, %xmm8
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm10 = xmm6[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm8 = xmm8[0],xmm10[1],xmm8[2,3],xmm10[4],xmm8[5,6],xmm10[7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm0[0],xmm3[0],xmm0[1],xmm3[1],xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm11 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX1-ONLY-NEXT:    vpshufb %xmm11, %xmm10, %xmm10
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm5[0,0,0,0]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm10 = xmm10[0,1],xmm12[2],xmm10[3,4],xmm12[5],xmm10[6,7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; AVX1-ONLY-NEXT:    vpshufb %xmm9, %xmm0, %xmm0
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm5[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm3[1],xmm0[2,3],xmm3[4],xmm0[5,6],xmm3[7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],xmm4[0],xmm1[1],xmm4[1],xmm1[2],xmm4[2],xmm1[3],xmm4[3]
; AVX1-ONLY-NEXT:    vpshufb %xmm11, %xmm1, %xmm1
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm6[0,0,0,0]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],xmm3[2],xmm1[3,4],xmm3[5],xmm1[6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, 48(%rcx)
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, 32(%rcx)
; AVX1-ONLY-NEXT:    vmovdqa %xmm10, (%rcx)
; AVX1-ONLY-NEXT:    vmovdqa %xmm8, 80(%rcx)
; AVX1-ONLY-NEXT:    vmovdqa %xmm7, 16(%rcx)
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, 64(%rcx)
; AVX1-ONLY-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i16_stride3_vf16:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %ymm1
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %ymm0
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %xmm2
; AVX2-SLOW-NEXT:    vmovdqa 16(%rdi), %xmm3
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm4 = xmm3[1,1,2,2]
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %xmm5
; AVX2-SLOW-NEXT:    vmovdqa 16(%rsi), %xmm6
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm6[3,3,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,4,4,4]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1],xmm7[2],xmm4[3,4],xmm7[5],xmm4[6,7]
; AVX2-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm6[4],xmm3[4],xmm6[5],xmm3[5],xmm6[6],xmm3[6],xmm6[7],xmm3[7]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[4,5,10,11,10,11,8,9,8,9,14,15,12,13,14,15]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm4, %ymm3
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = <5,5,u,6,6,u,7,7>
; AVX2-SLOW-NEXT:    vpermd %ymm0, %ymm4, %ymm4
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm6 = [0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm6, %ymm3, %ymm4, %ymm3
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm4 = xmm2[1,1,2,2]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm6 = xmm5[3,3,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,4,4,4,4]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1],xmm6[2],xmm4[3,4],xmm6[5],xmm4[6,7]
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm2[0],xmm5[0],xmm2[1],xmm5[1],xmm2[2],xmm5[2],xmm2[3],xmm5[3]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm4, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = <u,0,0,u,1,1,u,2>
; AVX2-SLOW-NEXT:    vpermd %ymm0, %ymm4, %ymm4
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm5 = [255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm5, %ymm2, %ymm4, %ymm2
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = <u,3,3,u,4,4,u,5>
; AVX2-SLOW-NEXT:    vpermd (%rdi), %ymm4, %ymm4
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[10,11,0,1,12,13,12,13,2,3,2,3,14,15,4,5,26,27,16,17,28,29,28,29,18,19,18,19,30,31,20,21]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm5 = <255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm5, %ymm1, %ymm4, %ymm1
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = <2,u,3,3,u,4,4,u>
; AVX2-SLOW-NEXT:    vpermd %ymm0, %ymm4, %ymm0
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vmovdqa %ymm0, 32(%rcx)
; AVX2-SLOW-NEXT:    vmovdqa %ymm2, (%rcx)
; AVX2-SLOW-NEXT:    vmovdqa %ymm3, 64(%rcx)
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i16_stride3_vf16:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %ymm1
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %ymm0
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %xmm2
; AVX2-FAST-NEXT:    vmovdqa 16(%rsi), %xmm3
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm4 = <u,u,u,u,6,7,u,u,u,u,8,9,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm2, %xmm5
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %xmm6
; AVX2-FAST-NEXT:    vmovdqa 16(%rdi), %xmm7
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm8 = xmm6[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm5 = xmm8[0,1],xmm5[2],xmm8[3,4],xmm5[5],xmm8[6,7]
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm6[0],xmm2[0],xmm6[1],xmm2[1],xmm6[2],xmm2[2],xmm6[3],xmm2[3]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm5, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = <u,0,0,u,1,1,u,2>
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm5, %ymm5
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm6 = [255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm6, %ymm2, %ymm5, %ymm2
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm5 = xmm7[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm4 = xmm5[0,1],xmm4[2],xmm5[3,4],xmm4[5],xmm5[6,7]
; AVX2-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm3[4],xmm7[4],xmm3[5],xmm7[5],xmm3[6],xmm7[6],xmm3[7],xmm7[7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[4,5,10,11,10,11,8,9,8,9,14,15,12,13,14,15]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm4, %ymm3
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = <5,5,u,6,6,u,7,7>
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm4, %ymm4
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = [0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm3, %ymm4, %ymm3
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = <u,3,3,u,4,4,u,5>
; AVX2-FAST-NEXT:    vpermd (%rdi), %ymm4, %ymm4
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[10,11,0,1,12,13,12,13,2,3,2,3,14,15,4,5,26,27,16,17,28,29,28,29,18,19,18,19,30,31,20,21]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = <255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255>
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm1, %ymm4, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = <2,u,3,3,u,4,4,u>
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm4, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqa %ymm0, 32(%rcx)
; AVX2-FAST-NEXT:    vmovdqa %ymm3, 64(%rcx)
; AVX2-FAST-NEXT:    vmovdqa %ymm2, (%rcx)
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: store_i16_stride3_vf16:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %xmm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 16(%rsi), %xmm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm4 = <u,u,u,u,6,7,u,u,u,u,8,9,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm4, %xmm2, %xmm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %xmm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 16(%rdi), %xmm7
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm8 = xmm6[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm5 = xmm8[0,1],xmm5[2],xmm8[3,4],xmm5[5],xmm8[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm6[0],xmm2[0],xmm6[1],xmm2[1],xmm6[2],xmm2[2],xmm6[3],xmm2[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm5, %ymm2, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm5 = <u,0,0,u,1,1,u,2>
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm0, %ymm5, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm6 = [255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm2, %ymm5, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm5 = xmm7[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm4 = xmm5[0,1],xmm4[2],xmm5[3,4],xmm4[5],xmm5[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm3[4],xmm7[4],xmm3[5],xmm7[5],xmm3[6],xmm7[6],xmm3[7],xmm7[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[4,5,10,11,10,11,8,9,8,9,14,15,12,13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm3, %ymm4, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm4 = <5,5,u,6,6,u,7,7>
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm0, %ymm4, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm5 = [0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm5, %ymm3, %ymm4, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm4 = <u,3,3,u,4,4,u,5>
; AVX2-FAST-PERLANE-NEXT:    vpermd (%rdi), %ymm4, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[10,11,0,1,12,13,12,13,2,3,2,3,14,15,4,5,26,27,16,17,28,29,28,29,18,19,18,19,30,31,20,21]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm5 = <255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm5, %ymm1, %ymm4, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm4 = <2,u,3,3,u,4,4,u>
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm0, %ymm4, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm1, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm0, 32(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm3, 64(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm2, (%rcx)
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512F-LABEL: store_i16_stride3_vf16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512F-NEXT:    vmovdqa (%rsi), %ymm2
; AVX512F-NEXT:    vmovdqa (%rdx), %ymm0
; AVX512F-NEXT:    vmovdqa (%rsi), %xmm3
; AVX512F-NEXT:    vmovdqa 16(%rsi), %xmm4
; AVX512F-NEXT:    vprold $16, %xmm3, %xmm5
; AVX512F-NEXT:    vmovdqa (%rdi), %xmm6
; AVX512F-NEXT:    vmovdqa 16(%rdi), %xmm7
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm8 = xmm6[1,1,2,2]
; AVX512F-NEXT:    vpblendw {{.*#+}} xmm5 = xmm8[0,1],xmm5[2],xmm8[3,4],xmm5[5],xmm8[6,7]
; AVX512F-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm6[0],xmm3[0],xmm6[1],xmm3[1],xmm6[2],xmm3[2],xmm6[3],xmm3[3]
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[0,1,2,3,u,u,4,5,6,7,u,u,8,9,10,11]
; AVX512F-NEXT:    vinserti128 $1, %xmm5, %ymm3, %ymm3
; AVX512F-NEXT:    vpshufb {{.*#+}} ymm1 = zero,zero,ymm1[u,u,12,13],zero,zero,ymm1[u,u,14,15],zero,zero,ymm1[u,u,16,17],zero,zero,ymm1[u,u,18,19],zero,zero,ymm1[u,u,20,21],zero,zero
; AVX512F-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[10,11,u,u],zero,zero,ymm2[12,13,u,u],zero,zero,ymm2[14,15,u,u],zero,zero,ymm2[16,17,u,u],zero,zero,ymm2[18,19,u,u],zero,zero,ymm2[20,21]
; AVX512F-NEXT:    vpor %ymm1, %ymm2, %ymm1
; AVX512F-NEXT:    vinserti64x4 $1, %ymm1, %zmm3, %zmm1
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm2 = <u,0,0,u,1,1,u,2>
; AVX512F-NEXT:    vpermd %ymm0, %ymm2, %ymm2
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm3 = [65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535]
; AVX512F-NEXT:    vpandn %ymm2, %ymm3, %ymm2
; AVX512F-NEXT:    vpshufb {{.*#+}} ymm3 = zero,zero,ymm0[10,11],zero,zero,zero,zero,ymm0[12,13],zero,zero,zero,zero,ymm0[14,15],zero,zero,zero,zero,ymm0[16,17],zero,zero,zero,zero,ymm0[18,19],zero,zero,zero,zero
; AVX512F-NEXT:    vinserti64x4 $1, %ymm3, %zmm2, %zmm2
; AVX512F-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm1, %zmm2
; AVX512F-NEXT:    vprold $16, %xmm4, %xmm1
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm3 = xmm7[1,1,2,2]
; AVX512F-NEXT:    vpblendw {{.*#+}} xmm1 = xmm3[0,1],xmm1[2],xmm3[3,4],xmm1[5],xmm3[6,7]
; AVX512F-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm4[4],xmm7[4],xmm4[5],xmm7[5],xmm4[6],xmm7[6],xmm4[7],xmm7[7]
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[4,5,u,u,10,11,8,9,u,u,14,15,12,13,u,u]
; AVX512F-NEXT:    vinserti128 $1, %xmm3, %ymm1, %ymm1
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm3 = <5,5,u,6,6,u,7,7>
; AVX512F-NEXT:    vpermd %ymm0, %ymm3, %ymm0
; AVX512F-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm0
; AVX512F-NEXT:    vmovdqa %ymm0, 64(%rcx)
; AVX512F-NEXT:    vmovdqa64 %zmm2, (%rcx)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: store_i16_stride3_vf16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512BW-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512BW-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm2 = [42,11,27,43,12,28,44,13,29,45,14,30,46,15,31,47]
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [0,16,32,1,17,33,2,18,34,3,19,35,4,20,36,5,21,37,6,22,38,7,23,39,8,24,40,9,25,41,10,26]
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    vmovdqa64 %zmm3, (%rcx)
; AVX512BW-NEXT:    vmovdqa %ymm2, 64(%rcx)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <16 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <16 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <16 x i16>, ptr %in.vecptr2, align 64
  %1 = shufflevector <16 x i16> %in.vec0, <16 x i16> %in.vec1, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %2 = shufflevector <16 x i16> %in.vec2, <16 x i16> poison, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %3 = shufflevector <32 x i16> %1, <32 x i16> %2, <48 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47>
  %interleaved.vec = shufflevector <48 x i16> %3, <48 x i16> poison, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
  store <48 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i16_stride3_vf32(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride3_vf32:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa 16(%rdi), %xmm6
; SSE-NEXT:    movdqa 32(%rdi), %xmm4
; SSE-NEXT:    movdqa 48(%rdi), %xmm0
; SSE-NEXT:    movdqa 16(%rsi), %xmm7
; SSE-NEXT:    movdqa 32(%rsi), %xmm8
; SSE-NEXT:    movdqa 48(%rsi), %xmm11
; SSE-NEXT:    movdqa 32(%rdx), %xmm10
; SSE-NEXT:    movdqa 48(%rdx), %xmm12
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,2,2]
; SSE-NEXT:    movdqa %xmm0, %xmm9
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm11[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [0,65535,65535,0,65535,65535,0,65535]
; SSE-NEXT:    pand %xmm2, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm12[1,1,2,2]
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm12[0,0,0,0]
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm9, %xmm1
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm11[0],xmm1[1],xmm11[1],xmm1[2],xmm11[2],xmm1[3],xmm11[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm9 = xmm1[0,1,2,3,7,5,4,5]
; SSE-NEXT:    pand %xmm5, %xmm9
; SSE-NEXT:    por %xmm3, %xmm9
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm4[1,1,2,2]
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm8[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm5, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    por %xmm1, %xmm4
; SSE-NEXT:    pand %xmm2, %xmm4
; SSE-NEXT:    movdqa %xmm10, %xmm3
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm10[1,1,2,2]
; SSE-NEXT:    movdqa %xmm2, %xmm10
; SSE-NEXT:    pandn %xmm1, %xmm10
; SSE-NEXT:    por %xmm4, %xmm10
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[0,0,0,0]
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm8[0],xmm1[1],xmm8[1],xmm1[2],xmm8[2],xmm1[3],xmm8[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm13 = xmm1[0,1,2,3,7,5,4,5]
; SSE-NEXT:    pand %xmm5, %xmm13
; SSE-NEXT:    por %xmm3, %xmm13
; SSE-NEXT:    movdqa %xmm7, %xmm0
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm7[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm6[1,1,2,2]
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa 16(%rdx), %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm7[1,1,2,2]
; SSE-NEXT:    movdqa %xmm2, %xmm14
; SSE-NEXT:    pandn %xmm1, %xmm14
; SSE-NEXT:    pand %xmm2, %xmm3
; SSE-NEXT:    por %xmm3, %xmm14
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm7[0,0,0,0]
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm6, %xmm1
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm15 = xmm1[0,1,2,3,7,5,4,5]
; SSE-NEXT:    pand %xmm5, %xmm15
; SSE-NEXT:    por %xmm3, %xmm15
; SSE-NEXT:    movdqa (%rsi), %xmm4
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm4[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pandn %xmm3, %xmm0
; SSE-NEXT:    movdqa (%rdi), %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm6[1,1,2,2]
; SSE-NEXT:    pand %xmm5, %xmm3
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    movdqa (%rdx), %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm12 = xmm3[1,1,2,2]
; SSE-NEXT:    pandn %xmm12, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm6, %xmm0
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1],xmm0[2],xmm4[2],xmm0[3],xmm4[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,7,5,4,5]
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm12 = xmm3[0,0,0,0]
; SSE-NEXT:    pandn %xmm12, %xmm5
; SSE-NEXT:    por %xmm0, %xmm5
; SSE-NEXT:    pshufd $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[2,2,3,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [65535,0,65535,65535,0,65535,65535,0]
; SSE-NEXT:    movdqa %xmm12, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    punpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Folded Reload
; SSE-NEXT:    # xmm11 = xmm11[4],mem[4],xmm11[5],mem[5],xmm11[6],mem[6],xmm11[7],mem[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm11[2,1,3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm11 = xmm1[2,1,1,0,4,5,6,7]
; SSE-NEXT:    pand %xmm12, %xmm11
; SSE-NEXT:    por %xmm0, %xmm11
; SSE-NEXT:    pshufd $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[2,2,3,3]
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    punpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Folded Reload
; SSE-NEXT:    # xmm8 = xmm8[4],mem[4],xmm8[5],mem[5],xmm8[6],mem[6],xmm8[7],mem[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm8[2,1,3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[2,1,1,0,4,5,6,7]
; SSE-NEXT:    pand %xmm12, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm7[2,2,3,3]
; SSE-NEXT:    movdqa %xmm12, %xmm7
; SSE-NEXT:    pandn %xmm1, %xmm7
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    punpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[4],mem[4],xmm1[5],mem[5],xmm1[6],mem[6],xmm1[7],mem[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,1,1,0,4,5,6,7]
; SSE-NEXT:    pand %xmm12, %xmm1
; SSE-NEXT:    por %xmm7, %xmm1
; SSE-NEXT:    punpckhwd {{.*#+}} xmm4 = xmm4[4],xmm6[4],xmm4[5],xmm6[5],xmm4[6],xmm6[6],xmm4[7],xmm6[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[2,2,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[2,1,3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[2,1,1,0,4,5,6,7]
; SSE-NEXT:    pand %xmm12, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm12
; SSE-NEXT:    por %xmm4, %xmm12
; SSE-NEXT:    movdqa %xmm12, 32(%rcx)
; SSE-NEXT:    movdqa %xmm1, 80(%rcx)
; SSE-NEXT:    movdqa %xmm0, 128(%rcx)
; SSE-NEXT:    movdqa %xmm11, 176(%rcx)
; SSE-NEXT:    movdqa %xmm5, (%rcx)
; SSE-NEXT:    movdqa %xmm2, 16(%rcx)
; SSE-NEXT:    movdqa %xmm15, 48(%rcx)
; SSE-NEXT:    movdqa %xmm14, 64(%rcx)
; SSE-NEXT:    movdqa %xmm13, 96(%rcx)
; SSE-NEXT:    movdqa %xmm10, 112(%rcx)
; SSE-NEXT:    movdqa %xmm9, 144(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rcx)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i16_stride3_vf32:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    vmovdqa (%rdi), %xmm14
; AVX1-ONLY-NEXT:    vmovdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovdqa 32(%rdi), %xmm8
; AVX1-ONLY-NEXT:    vmovdqa 48(%rdi), %xmm9
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm9[1,1,2,2]
; AVX1-ONLY-NEXT:    vmovdqa (%rsi), %xmm3
; AVX1-ONLY-NEXT:    vmovdqa 16(%rsi), %xmm5
; AVX1-ONLY-NEXT:    vmovdqa 32(%rsi), %xmm10
; AVX1-ONLY-NEXT:    vmovdqa 48(%rsi), %xmm12
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm12[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm4 = xmm0[0,1],xmm4[2],xmm0[3,4],xmm4[5],xmm0[6,7]
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdx), %xmm6
; AVX1-ONLY-NEXT:    vmovdqa 32(%rdx), %xmm13
; AVX1-ONLY-NEXT:    vmovdqa 48(%rdx), %xmm0
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm0[1,1,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm7[0],xmm4[1,2],xmm7[3],xmm4[4,5],xmm7[6],xmm4[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm8[1,1,2,2]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm10[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1],xmm7[2],xmm4[3,4],xmm7[5],xmm4[6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm13[1,1,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm7[0],xmm4[1,2],xmm7[3],xmm4[4,5],xmm7[6],xmm4[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm2[1,1,2,2]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm11 = xmm5[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm11 = xmm11[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm7 = xmm7[0,1],xmm11[2],xmm7[3,4],xmm11[5],xmm7[6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm6[1,1,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm11[0],xmm7[1,2],xmm11[3],xmm7[4,5],xmm11[6],xmm7[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm14[1,1,2,2]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm14 = xmm3[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm14 = xmm14[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm11 = xmm11[0,1],xmm14[2],xmm11[3,4],xmm14[5],xmm11[6,7]
; AVX1-ONLY-NEXT:    vmovdqa (%rdx), %xmm15
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm14 = xmm15[1,1,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm14[0],xmm11[1,2],xmm14[3],xmm11[4,5],xmm14[6],xmm11[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm14 = xmm9[0],xmm12[0],xmm9[1],xmm12[1],xmm9[2],xmm12[2],xmm9[3],xmm12[3]
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm7 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX1-ONLY-NEXT:    vpshufb %xmm7, %xmm14, %xmm14
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm0[0,0,0,0]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm14 = xmm14[0,1],xmm4[2],xmm14[3,4],xmm4[5],xmm14[6,7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm10[4],xmm8[4],xmm10[5],xmm8[5],xmm10[6],xmm8[6],xmm10[7],xmm8[7]
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm1 = [4,5,10,11,10,11,8,9,8,9,14,15,12,13,14,15]
; AVX1-ONLY-NEXT:    vpshufb %xmm1, %xmm4, %xmm4
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm13[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0],xmm11[1],xmm4[2,3],xmm11[4],xmm4[5,6],xmm11[7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm9 = xmm12[4],xmm9[4],xmm12[5],xmm9[5],xmm12[6],xmm9[6],xmm12[7],xmm9[7]
; AVX1-ONLY-NEXT:    vpshufb %xmm1, %xmm9, %xmm9
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm9[0],xmm0[1],xmm9[2,3],xmm0[4],xmm9[5,6],xmm0[7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm8[0],xmm10[0],xmm8[1],xmm10[1],xmm8[2],xmm10[2],xmm8[3],xmm10[3]
; AVX1-ONLY-NEXT:    vpshufb %xmm7, %xmm8, %xmm8
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm9 = xmm13[0,0,0,0]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm8 = xmm8[0,1],xmm9[2],xmm8[3,4],xmm9[5],xmm8[6,7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm2[0],xmm5[0],xmm2[1],xmm5[1],xmm2[2],xmm5[2],xmm2[3],xmm5[3]
; AVX1-ONLY-NEXT:    vpshufb %xmm7, %xmm9, %xmm9
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm10 = xmm6[0,0,0,0]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm9 = xmm9[0,1],xmm10[2],xmm9[3,4],xmm10[5],xmm9[6,7]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm10 = xmm3[4],xmm12[4],xmm3[5],xmm12[5],xmm3[6],xmm12[6],xmm3[7],xmm12[7]
; AVX1-ONLY-NEXT:    vpshufb %xmm1, %xmm10, %xmm10
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm15[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm10 = xmm10[0],xmm11[1],xmm10[2,3],xmm11[4],xmm10[5,6],xmm11[7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm5[4],xmm2[4],xmm5[5],xmm2[5],xmm5[6],xmm2[6],xmm5[7],xmm2[7]
; AVX1-ONLY-NEXT:    vpshufb %xmm1, %xmm2, %xmm1
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm6[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0],xmm2[1],xmm1[2,3],xmm2[4],xmm1[5,6],xmm2[7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm12[0],xmm3[0],xmm12[1],xmm3[1],xmm12[2],xmm3[2],xmm12[3],xmm3[3]
; AVX1-ONLY-NEXT:    vpshufb %xmm7, %xmm2, %xmm2
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm15[0,0,0,0]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1],xmm3[2],xmm2[3,4],xmm3[5],xmm2[6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, (%rcx)
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, 80(%rcx)
; AVX1-ONLY-NEXT:    vmovdqa %xmm10, 32(%rcx)
; AVX1-ONLY-NEXT:    vmovdqa %xmm9, 48(%rcx)
; AVX1-ONLY-NEXT:    vmovdqa %xmm8, 96(%rcx)
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, 176(%rcx)
; AVX1-ONLY-NEXT:    vmovdqa %xmm4, 128(%rcx)
; AVX1-ONLY-NEXT:    vmovdqa %xmm14, 144(%rcx)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 16(%rcx)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 64(%rcx)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 112(%rcx)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 160(%rcx)
; AVX1-ONLY-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i16_stride3_vf32:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vmovdqa 32(%rsi), %ymm0
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %ymm4
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %ymm2
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdx), %ymm1
; AVX2-SLOW-NEXT:    vmovdqa 48(%rdi), %xmm3
; AVX2-SLOW-NEXT:    vmovdqa 48(%rsi), %xmm5
; AVX2-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm5[4],xmm3[4],xmm5[5],xmm3[5],xmm5[6],xmm3[6],xmm5[7],xmm3[7]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm7 = [4,5,10,11,10,11,8,9,8,9,14,15,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufb %xmm7, %xmm6, %xmm6
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[1,1,2,2]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm5[3,3,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,4,4,4]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1],xmm5[2],xmm3[3,4],xmm5[5],xmm3[6,7]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm3, %ymm3
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm5 = <5,5,u,6,6,u,7,7>
; AVX2-SLOW-NEXT:    vpermd %ymm1, %ymm5, %ymm6
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm8 = [0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, %ymm3, %ymm6, %ymm3
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %xmm6
; AVX2-SLOW-NEXT:    vmovdqa 16(%rdi), %xmm9
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdi), %xmm10
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %xmm11
; AVX2-SLOW-NEXT:    vmovdqa 16(%rsi), %xmm12
; AVX2-SLOW-NEXT:    vmovdqa 32(%rsi), %xmm13
; AVX2-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm14 = xmm12[4],xmm9[4],xmm12[5],xmm9[5],xmm12[6],xmm9[6],xmm12[7],xmm9[7]
; AVX2-SLOW-NEXT:    vpshufb %xmm7, %xmm14, %xmm7
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[1,1,2,2]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm12 = xmm12[3,3,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm12 = xmm12[0,1,2,3,4,4,4,4]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm9 = xmm9[0,1],xmm12[2],xmm9[3,4],xmm12[5],xmm9[6,7]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm7, %ymm9, %ymm7
; AVX2-SLOW-NEXT:    vpermd %ymm2, %ymm5, %ymm5
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, %ymm7, %ymm5, %ymm5
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm7 = xmm6[1,1,2,2]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm8 = xmm11[3,3,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm8 = xmm8[0,1,2,3,4,4,4,4]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm7 = xmm7[0,1],xmm8[2],xmm7[3,4],xmm8[5],xmm7[6,7]
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm6[0],xmm11[0],xmm6[1],xmm11[1],xmm6[2],xmm11[2],xmm6[3],xmm11[3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm8 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX2-SLOW-NEXT:    vpshufb %xmm8, %xmm6, %xmm6
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm7, %ymm6, %ymm6
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm7 = <u,0,0,u,1,1,u,2>
; AVX2-SLOW-NEXT:    vpermd %ymm2, %ymm7, %ymm9
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm11 = [255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm11, %ymm6, %ymm9, %ymm6
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm9 = xmm10[1,1,2,2]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm12 = xmm13[3,3,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm12 = xmm12[0,1,2,3,4,4,4,4]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm9 = xmm9[0,1],xmm12[2],xmm9[3,4],xmm12[5],xmm9[6,7]
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm10[0],xmm13[0],xmm10[1],xmm13[1],xmm10[2],xmm13[2],xmm10[3],xmm13[3]
; AVX2-SLOW-NEXT:    vpshufb %xmm8, %xmm10, %xmm8
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm9, %ymm8, %ymm8
; AVX2-SLOW-NEXT:    vpermd %ymm1, %ymm7, %ymm7
; AVX2-SLOW-NEXT:    vpblendvb %ymm11, %ymm8, %ymm7, %ymm7
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm8 = [10,11,0,1,12,13,12,13,2,3,2,3,14,15,4,5,26,27,16,17,28,29,28,29,18,19,18,19,30,31,20,21]
; AVX2-SLOW-NEXT:    vpshufb %ymm8, %ymm4, %ymm4
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm9 = <u,3,3,u,4,4,u,5>
; AVX2-SLOW-NEXT:    vpermd (%rdi), %ymm9, %ymm10
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm11 = <255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm11, %ymm4, %ymm10, %ymm4
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm10 = <2,u,3,3,u,4,4,u>
; AVX2-SLOW-NEXT:    vpermd %ymm2, %ymm10, %ymm2
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm12 = [255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm4, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vpshufb %ymm8, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpermd 32(%rdi), %ymm9, %ymm4
; AVX2-SLOW-NEXT:    vpblendvb %ymm11, %ymm0, %ymm4, %ymm0
; AVX2-SLOW-NEXT:    vpermd %ymm1, %ymm10, %ymm1
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vmovdqa %ymm0, 128(%rcx)
; AVX2-SLOW-NEXT:    vmovdqa %ymm2, 32(%rcx)
; AVX2-SLOW-NEXT:    vmovdqa %ymm7, 96(%rcx)
; AVX2-SLOW-NEXT:    vmovdqa %ymm6, (%rcx)
; AVX2-SLOW-NEXT:    vmovdqa %ymm5, 64(%rcx)
; AVX2-SLOW-NEXT:    vmovdqa %ymm3, 160(%rcx)
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i16_stride3_vf32:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %ymm0
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %xmm1
; AVX2-FAST-NEXT:    vmovdqa 32(%rsi), %xmm3
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm2 = <u,u,u,u,6,7,u,u,u,u,8,9,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm2, %xmm1, %xmm4
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %xmm5
; AVX2-FAST-NEXT:    vmovdqa 32(%rdi), %xmm6
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm7 = xmm5[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm4 = xmm7[0,1],xmm4[2],xmm7[3,4],xmm4[5],xmm7[6,7]
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm5[0],xmm1[0],xmm5[1],xmm1[1],xmm5[2],xmm1[2],xmm5[3],xmm1[3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm5 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX2-FAST-NEXT:    vpshufb %xmm5, %xmm1, %xmm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm4, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = <u,0,0,u,1,1,u,2>
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm4, %ymm7
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = [255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm8, %ymm1, %ymm7, %ymm1
; AVX2-FAST-NEXT:    vmovdqa 48(%rdi), %xmm7
; AVX2-FAST-NEXT:    vmovdqa 48(%rsi), %xmm9
; AVX2-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm10 = xmm9[4],xmm7[4],xmm9[5],xmm7[5],xmm9[6],xmm7[6],xmm9[7],xmm7[7]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm11 = [4,5,10,11,10,11,8,9,8,9,14,15,12,13,14,15]
; AVX2-FAST-NEXT:    vpshufb %xmm11, %xmm10, %xmm10
; AVX2-FAST-NEXT:    vpshufb %xmm2, %xmm9, %xmm9
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm7 = xmm7[0,1],xmm9[2],xmm7[3,4],xmm9[5],xmm7[6,7]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm10, %ymm7, %ymm7
; AVX2-FAST-NEXT:    vpshufb %xmm2, %xmm3, %xmm9
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm10 = xmm6[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm9 = xmm10[0,1],xmm9[2],xmm10[3,4],xmm9[5],xmm10[6,7]
; AVX2-FAST-NEXT:    vmovdqa 32(%rdx), %ymm10
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm6[0],xmm3[0],xmm6[1],xmm3[1],xmm6[2],xmm3[2],xmm6[3],xmm3[3]
; AVX2-FAST-NEXT:    vmovdqa 16(%rsi), %xmm6
; AVX2-FAST-NEXT:    vpshufb %xmm5, %xmm3, %xmm3
; AVX2-FAST-NEXT:    vmovdqa 16(%rdi), %xmm5
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm9, %ymm3, %ymm3
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = <5,5,u,6,6,u,7,7>
; AVX2-FAST-NEXT:    vpermd %ymm10, %ymm4, %ymm4
; AVX2-FAST-NEXT:    vpblendvb %ymm8, %ymm3, %ymm4, %ymm3
; AVX2-FAST-NEXT:    vpermd %ymm10, %ymm9, %ymm4
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = [0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm8, %ymm7, %ymm4, %ymm4
; AVX2-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm6[4],xmm5[4],xmm6[5],xmm5[5],xmm6[6],xmm5[6],xmm6[7],xmm5[7]
; AVX2-FAST-NEXT:    vpshufb %xmm11, %xmm7, %xmm7
; AVX2-FAST-NEXT:    vpshufb %xmm2, %xmm6, %xmm2
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %ymm6
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm2 = xmm5[0,1],xmm2[2],xmm5[3,4],xmm2[5],xmm5[6,7]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm7, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm9, %ymm5
; AVX2-FAST-NEXT:    vpblendvb %ymm8, %ymm2, %ymm5, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = [10,11,0,1,12,13,12,13,2,3,2,3,14,15,4,5,26,27,16,17,28,29,28,29,18,19,18,19,30,31,20,21]
; AVX2-FAST-NEXT:    vpshufb %ymm5, %ymm6, %ymm6
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm7 = <u,3,3,u,4,4,u,5>
; AVX2-FAST-NEXT:    vpermd (%rdi), %ymm7, %ymm8
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = <255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255>
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm6, %ymm8, %ymm6
; AVX2-FAST-NEXT:    vmovdqa 32(%rsi), %ymm8
; AVX2-FAST-NEXT:    vpshufb %ymm5, %ymm8, %ymm5
; AVX2-FAST-NEXT:    vpermd 32(%rdi), %ymm7, %ymm7
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm5, %ymm7, %ymm5
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm7 = <2,u,3,3,u,4,4,u>
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm7, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = [255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm8, %ymm6, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpermd %ymm10, %ymm7, %ymm6
; AVX2-FAST-NEXT:    vpblendvb %ymm8, %ymm5, %ymm6, %ymm5
; AVX2-FAST-NEXT:    vmovdqa %ymm5, 128(%rcx)
; AVX2-FAST-NEXT:    vmovdqa %ymm0, 32(%rcx)
; AVX2-FAST-NEXT:    vmovdqa %ymm2, 64(%rcx)
; AVX2-FAST-NEXT:    vmovdqa %ymm3, 96(%rcx)
; AVX2-FAST-NEXT:    vmovdqa %ymm4, 160(%rcx)
; AVX2-FAST-NEXT:    vmovdqa %ymm1, (%rcx)
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: store_i16_stride3_vf32:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rsi), %xmm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm2 = <u,u,u,u,6,7,u,u,u,u,8,9,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm2, %xmm1, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %xmm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdi), %xmm6
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm7 = xmm5[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm4 = xmm7[0,1],xmm4[2],xmm7[3,4],xmm4[5],xmm7[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm5[0],xmm1[0],xmm5[1],xmm1[1],xmm5[2],xmm1[2],xmm5[3],xmm1[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm5 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm5, %xmm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm4, %ymm1, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm4 = <u,0,0,u,1,1,u,2>
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm0, %ymm4, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm8 = [255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm8, %ymm1, %ymm7, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 48(%rdi), %xmm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 48(%rsi), %xmm9
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{.*#+}} xmm10 = xmm9[4],xmm7[4],xmm9[5],xmm7[5],xmm9[6],xmm7[6],xmm9[7],xmm7[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm11 = [4,5,10,11,10,11,8,9,8,9,14,15,12,13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm11, %xmm10, %xmm10
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm2, %xmm9, %xmm9
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm7 = xmm7[0,1],xmm9[2],xmm7[3,4],xmm9[5],xmm7[6,7]
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm10, %ymm7, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm2, %xmm3, %xmm9
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm10 = xmm6[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm9 = xmm10[0,1],xmm9[2],xmm10[3,4],xmm9[5],xmm10[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdx), %ymm10
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm6[0],xmm3[0],xmm6[1],xmm3[1],xmm6[2],xmm3[2],xmm6[3],xmm3[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 16(%rsi), %xmm6
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm5, %xmm3, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 16(%rdi), %xmm5
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm9, %ymm3, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm9 = <5,5,u,6,6,u,7,7>
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm10, %ymm4, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm8, %ymm3, %ymm4, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm10, %ymm9, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm8 = [0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm8, %ymm7, %ymm4, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm6[4],xmm5[4],xmm6[5],xmm5[5],xmm6[6],xmm5[6],xmm6[7],xmm5[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm11, %xmm7, %xmm7
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm2, %xmm6, %xmm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %ymm6
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm2 = xmm5[0,1],xmm2[2],xmm5[3,4],xmm2[5],xmm5[6,7]
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm7, %ymm2, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm0, %ymm9, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm8, %ymm2, %ymm5, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm5 = [10,11,0,1,12,13,12,13,2,3,2,3,14,15,4,5,26,27,16,17,28,29,28,29,18,19,18,19,30,31,20,21]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm5, %ymm6, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm7 = <u,3,3,u,4,4,u,5>
; AVX2-FAST-PERLANE-NEXT:    vpermd (%rdi), %ymm7, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm9 = <255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm9, %ymm6, %ymm8, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rsi), %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm5, %ymm8, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpermd 32(%rdi), %ymm7, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm9, %ymm5, %ymm7, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm7 = <2,u,3,3,u,4,4,u>
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm0, %ymm7, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm8 = [255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm8, %ymm6, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm10, %ymm7, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm8, %ymm5, %ymm6, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm5, 128(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm0, 32(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm2, 64(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm3, 96(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm4, 160(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm1, (%rcx)
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512F-LABEL: store_i16_stride3_vf32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa (%rsi), %xmm0
; AVX512F-NEXT:    vmovdqa 16(%rsi), %xmm3
; AVX512F-NEXT:    vmovdqa 32(%rsi), %xmm2
; AVX512F-NEXT:    vprold $16, %xmm2, %xmm4
; AVX512F-NEXT:    vmovdqa (%rdi), %xmm1
; AVX512F-NEXT:    vmovdqa 16(%rdi), %xmm5
; AVX512F-NEXT:    vmovdqa 32(%rdi), %xmm6
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm7 = xmm6[1,1,2,2]
; AVX512F-NEXT:    vpblendw {{.*#+}} xmm4 = xmm7[0,1],xmm4[2],xmm7[3,4],xmm4[5],xmm7[6,7]
; AVX512F-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm6[0],xmm2[0],xmm6[1],xmm2[1],xmm6[2],xmm2[2],xmm6[3],xmm2[3]
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX512F-NEXT:    vpshufb %xmm2, %xmm6, %xmm6
; AVX512F-NEXT:    vinserti128 $1, %xmm4, %ymm6, %ymm4
; AVX512F-NEXT:    vinserti64x4 $1, %ymm4, %zmm0, %zmm4
; AVX512F-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm3[4],xmm5[4],xmm3[5],xmm5[5],xmm3[6],xmm5[6],xmm3[7],xmm5[7]
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm7 = [4,5,10,11,10,11,8,9,8,9,14,15,12,13,14,15]
; AVX512F-NEXT:    vpshufb %xmm7, %xmm6, %xmm6
; AVX512F-NEXT:    vprold $16, %xmm3, %xmm3
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[1,1,2,2]
; AVX512F-NEXT:    vpblendw {{.*#+}} xmm3 = xmm5[0,1],xmm3[2],xmm5[3,4],xmm3[5],xmm5[6,7]
; AVX512F-NEXT:    vinserti128 $1, %xmm6, %ymm3, %ymm3
; AVX512F-NEXT:    vshufi64x2 {{.*#+}} zmm4 = zmm3[0,1,2,3],zmm4[4,5,6,7]
; AVX512F-NEXT:    vmovdqa (%rdx), %ymm3
; AVX512F-NEXT:    vmovdqa 32(%rdx), %ymm5
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm6 = <u,0,0,u,1,1,u,2>
; AVX512F-NEXT:    vpermd %ymm5, %ymm6, %ymm8
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm9 = <5,5,u,6,6,u,7,7>
; AVX512F-NEXT:    vpermd %ymm3, %ymm9, %ymm10
; AVX512F-NEXT:    vinserti64x4 $1, %ymm8, %zmm10, %zmm8
; AVX512F-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm4, %zmm8
; AVX512F-NEXT:    vmovdqa 32(%rdi), %ymm4
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm10 = [128,128,128,128,12,13,128,128,128,128,14,15,128,128,128,128,16,17,128,128,128,128,18,19,128,128,128,128,20,21,128,128]
; AVX512F-NEXT:    vpshufb %ymm10, %ymm4, %ymm4
; AVX512F-NEXT:    vmovdqa 32(%rsi), %ymm11
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm12 = [10,11,0,1,128,128,12,13,2,3,128,128,14,15,4,5,128,128,16,17,28,29,128,128,18,19,18,19,128,128,20,21]
; AVX512F-NEXT:    vpshufb %ymm12, %ymm11, %ymm11
; AVX512F-NEXT:    vpor %ymm4, %ymm11, %ymm4
; AVX512F-NEXT:    vmovdqa 48(%rdi), %xmm11
; AVX512F-NEXT:    vmovdqa 48(%rsi), %xmm13
; AVX512F-NEXT:    vpunpckhwd {{.*#+}} xmm14 = xmm13[4],xmm11[4],xmm13[5],xmm11[5],xmm13[6],xmm11[6],xmm13[7],xmm11[7]
; AVX512F-NEXT:    vpshufb %xmm7, %xmm14, %xmm7
; AVX512F-NEXT:    vprold $16, %xmm13, %xmm13
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[1,1,2,2]
; AVX512F-NEXT:    vpblendw {{.*#+}} xmm11 = xmm11[0,1],xmm13[2],xmm11[3,4],xmm13[5],xmm11[6,7]
; AVX512F-NEXT:    vinserti128 $1, %xmm7, %ymm11, %ymm7
; AVX512F-NEXT:    vinserti64x4 $1, %ymm7, %zmm0, %zmm7
; AVX512F-NEXT:    vshufi64x2 {{.*#+}} zmm4 = zmm4[0,1,2,3],zmm7[4,5,6,7]
; AVX512F-NEXT:    vpermd %ymm5, %ymm9, %ymm7
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm9 = [0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0]
; AVX512F-NEXT:    vpandn %ymm7, %ymm9, %ymm7
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm9 = [128,128,10,11,128,128,128,128,12,13,128,128,128,128,14,15,128,128,128,128,16,17,128,128,128,128,18,19,128,128,128,128]
; AVX512F-NEXT:    vpshufb %ymm9, %ymm5, %ymm5
; AVX512F-NEXT:    vinserti64x4 $1, %ymm7, %zmm5, %zmm5
; AVX512F-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm4, %zmm5
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm4
; AVX512F-NEXT:    vpshufb %ymm10, %ymm4, %ymm4
; AVX512F-NEXT:    vmovdqa (%rsi), %ymm7
; AVX512F-NEXT:    vpshufb %ymm12, %ymm7, %ymm7
; AVX512F-NEXT:    vpor %ymm4, %ymm7, %ymm4
; AVX512F-NEXT:    vinserti64x4 $1, %ymm4, %zmm0, %zmm4
; AVX512F-NEXT:    vprold $16, %xmm0, %xmm7
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm10 = xmm1[1,1,2,2]
; AVX512F-NEXT:    vpblendw {{.*#+}} xmm7 = xmm10[0,1],xmm7[2],xmm10[3,4],xmm7[5],xmm10[6,7]
; AVX512F-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX512F-NEXT:    vpshufb %xmm2, %xmm0, %xmm0
; AVX512F-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm0
; AVX512F-NEXT:    vshufi64x2 {{.*#+}} zmm0 = zmm0[0,1,2,3],zmm4[4,5,6,7]
; AVX512F-NEXT:    vpshufb %ymm9, %ymm3, %ymm1
; AVX512F-NEXT:    vpermd %ymm3, %ymm6, %ymm2
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm3 = [65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535]
; AVX512F-NEXT:    vpandn %ymm2, %ymm3, %ymm2
; AVX512F-NEXT:    vinserti64x4 $1, %ymm1, %zmm2, %zmm1
; AVX512F-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm1
; AVX512F-NEXT:    vmovdqa64 %zmm1, (%rcx)
; AVX512F-NEXT:    vmovdqa64 %zmm5, 128(%rcx)
; AVX512F-NEXT:    vmovdqa64 %zmm8, 64(%rcx)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: store_i16_stride3_vf32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <0,32,u,1,33,u,2,34,u,3,35,u,4,36,u,5,37,u,6,38,u,7,39,u,8,40,u,9,41,u,10,42>
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [0,1,32,3,4,33,6,7,34,9,10,35,12,13,36,15,16,37,18,19,38,21,22,39,24,25,40,27,28,41,30,31]
; AVX512BW-NEXT:    vpermi2w %zmm2, %zmm3, %zmm4
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <u,11,43,u,12,44,u,13,45,u,14,46,u,15,47,u,16,48,u,17,49,u,18,50,u,19,51,u,20,52,u,21>
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm5 = [42,1,2,43,4,5,44,7,8,45,10,11,46,13,14,47,16,17,48,19,20,49,22,23,50,25,26,51,28,29,52,31]
; AVX512BW-NEXT:    vpermi2w %zmm2, %zmm3, %zmm5
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <21,u,54,22,u,55,23,u,56,24,u,57,25,u,58,26,u,59,27,u,60,28,u,61,29,u,62,30,u,63,31,u>
; AVX512BW-NEXT:    vpermi2w %zmm0, %zmm1, %zmm3
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [0,53,2,3,54,5,6,55,8,9,56,11,12,57,14,15,58,17,18,59,20,21,60,23,24,61,26,27,62,29,30,63]
; AVX512BW-NEXT:    vpermi2w %zmm2, %zmm3, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm0, 128(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, 64(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm4, (%rcx)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <32 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <32 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <32 x i16>, ptr %in.vecptr2, align 64
  %1 = shufflevector <32 x i16> %in.vec0, <32 x i16> %in.vec1, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %2 = shufflevector <32 x i16> %in.vec2, <32 x i16> poison, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %3 = shufflevector <64 x i16> %1, <64 x i16> %2, <96 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95>
  %interleaved.vec = shufflevector <96 x i16> %3, <96 x i16> poison, <96 x i32> <i32 0, i32 32, i32 64, i32 1, i32 33, i32 65, i32 2, i32 34, i32 66, i32 3, i32 35, i32 67, i32 4, i32 36, i32 68, i32 5, i32 37, i32 69, i32 6, i32 38, i32 70, i32 7, i32 39, i32 71, i32 8, i32 40, i32 72, i32 9, i32 41, i32 73, i32 10, i32 42, i32 74, i32 11, i32 43, i32 75, i32 12, i32 44, i32 76, i32 13, i32 45, i32 77, i32 14, i32 46, i32 78, i32 15, i32 47, i32 79, i32 16, i32 48, i32 80, i32 17, i32 49, i32 81, i32 18, i32 50, i32 82, i32 19, i32 51, i32 83, i32 20, i32 52, i32 84, i32 21, i32 53, i32 85, i32 22, i32 54, i32 86, i32 23, i32 55, i32 87, i32 24, i32 56, i32 88, i32 25, i32 57, i32 89, i32 26, i32 58, i32 90, i32 27, i32 59, i32 91, i32 28, i32 60, i32 92, i32 29, i32 61, i32 93, i32 30, i32 62, i32 94, i32 31, i32 63, i32 95>
  store <96 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i16_stride3_vf64(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride3_vf64:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $360, %rsp # imm = 0x168
; SSE-NEXT:    movdqa (%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 16(%rdi), %xmm4
; SSE-NEXT:    movdqa 32(%rdi), %xmm5
; SSE-NEXT:    movdqa (%rsi), %xmm8
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 16(%rsi), %xmm6
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rdx), %xmm0
; SSE-NEXT:    movdqa 16(%rdx), %xmm9
; SSE-NEXT:    movdqa 32(%rdx), %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[0,0,0,0]
; SSE-NEXT:    movdqa %xmm0, %xmm10
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm8[0],xmm1[1],xmm8[1],xmm1[2],xmm8[2],xmm1[3],xmm8[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,5,4,5]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[1,1,2,2]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm8[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm11 = [0,65535,65535,0,65535,65535,0,65535]
; SSE-NEXT:    pand %xmm11, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm10[1,1,2,2]
; SSE-NEXT:    movdqa %xmm11, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm9[0,0,0,0]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm6[0],xmm1[1],xmm6[1],xmm1[2],xmm6[2],xmm1[3],xmm6[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,5,4,5]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm4[1,1,2,2]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm6[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    por %xmm1, %xmm4
; SSE-NEXT:    pand %xmm11, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm9[1,1,2,2]
; SSE-NEXT:    movdqa %xmm11, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm7[0,0,0,0]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa 32(%rsi), %xmm4
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm5, %xmm1
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm4[0],xmm1[1],xmm4[1],xmm1[2],xmm4[2],xmm1[3],xmm4[3]
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,5,4,5]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm4[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[1,1,2,2]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm7[1,1,2,2]
; SSE-NEXT:    movdqa %xmm11, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    pand %xmm11, %xmm3
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 48(%rdx), %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[0,0,0,0]
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    movdqa %xmm2, (%rsp) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa 48(%rdi), %xmm2
; SSE-NEXT:    movdqa 48(%rsi), %xmm15
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm15[0],xmm1[1],xmm15[1],xmm1[2],xmm15[2],xmm1[3],xmm15[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,5,4,5]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm15[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,2,2]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm4[1,1,2,2]
; SSE-NEXT:    movdqa %xmm11, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    pand %xmm11, %xmm3
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 64(%rdx), %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[0,0,0,0]
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa 64(%rdi), %xmm2
; SSE-NEXT:    movdqa 64(%rsi), %xmm12
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm12[0],xmm1[1],xmm12[1],xmm1[2],xmm12[2],xmm1[3],xmm12[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,5,4,5]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm12[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,2,2]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm4[1,1,2,2]
; SSE-NEXT:    movdqa %xmm11, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    pand %xmm11, %xmm3
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 80(%rdx), %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[0,0,0,0]
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa 80(%rdi), %xmm2
; SSE-NEXT:    movdqa 80(%rsi), %xmm10
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm10[0],xmm1[1],xmm10[1],xmm1[2],xmm10[2],xmm1[3],xmm10[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,5,4,5]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm10[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,2,2]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm4[1,1,2,2]
; SSE-NEXT:    movdqa %xmm11, %xmm14
; SSE-NEXT:    pandn %xmm1, %xmm14
; SSE-NEXT:    pand %xmm11, %xmm3
; SSE-NEXT:    por %xmm3, %xmm14
; SSE-NEXT:    movdqa 96(%rdx), %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[0,0,0,0]
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa 96(%rdi), %xmm2
; SSE-NEXT:    movdqa 96(%rsi), %xmm8
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm8[0],xmm1[1],xmm8[1],xmm1[2],xmm8[2],xmm1[3],xmm8[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm13 = xmm1[0,1,2,3,7,5,4,5]
; SSE-NEXT:    pand %xmm0, %xmm13
; SSE-NEXT:    por %xmm3, %xmm13
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm8[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,2,2]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm4[1,1,2,2]
; SSE-NEXT:    movdqa %xmm11, %xmm9
; SSE-NEXT:    pandn %xmm1, %xmm9
; SSE-NEXT:    pand %xmm11, %xmm3
; SSE-NEXT:    por %xmm3, %xmm9
; SSE-NEXT:    movdqa 112(%rdx), %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[0,0,0,0]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa 112(%rdi), %xmm4
; SSE-NEXT:    movdqa 112(%rsi), %xmm6
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm6[0],xmm1[1],xmm6[1],xmm1[2],xmm6[2],xmm1[3],xmm6[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm1[0,1,2,3,7,5,4,5]
; SSE-NEXT:    pand %xmm0, %xmm7
; SSE-NEXT:    por %xmm3, %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm4[1,1,2,2]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm6[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pandn %xmm3, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    pand %xmm11, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,2,2]
; SSE-NEXT:    pandn %xmm1, %xmm11
; SSE-NEXT:    por %xmm0, %xmm11
; SSE-NEXT:    pshufd $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[2,2,3,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,0,65535,65535,0,65535,65535,0]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    punpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[4],mem[4],xmm1[5],mem[5],xmm1[6],mem[6],xmm1[7],mem[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm1[2,1,1,0,4,5,6,7]
; SSE-NEXT:    pand %xmm0, %xmm5
; SSE-NEXT:    por %xmm3, %xmm5
; SSE-NEXT:    pshufd $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = mem[2,2,3,3]
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = xmm2[4],mem[4],xmm2[5],mem[5],xmm2[6],mem[6],xmm2[7],mem[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[2,1,3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm3[2,1,1,0,4,5,6,7]
; SSE-NEXT:    pand %xmm0, %xmm4
; SSE-NEXT:    por %xmm1, %xmm4
; SSE-NEXT:    pshufd $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[2,2,3,3]
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = xmm2[4],mem[4],xmm2[5],mem[5],xmm2[6],mem[6],xmm2[7],mem[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,1,3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm2[2,1,1,0,4,5,6,7]
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    pshufd $250, (%rsp), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[2,2,3,3]
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    punpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Folded Reload
; SSE-NEXT:    # xmm15 = xmm15[4],mem[4],xmm15[5],mem[5],xmm15[6],mem[6],xmm15[7],mem[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm15[2,1,3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm15 = xmm2[2,1,1,0,4,5,6,7]
; SSE-NEXT:    pand %xmm0, %xmm15
; SSE-NEXT:    por %xmm1, %xmm15
; SSE-NEXT:    pshufd $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[2,2,3,3]
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    punpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Folded Reload
; SSE-NEXT:    # xmm12 = xmm12[4],mem[4],xmm12[5],mem[5],xmm12[6],mem[6],xmm12[7],mem[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm12[2,1,3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm12 = xmm1[2,1,1,0,4,5,6,7]
; SSE-NEXT:    pand %xmm0, %xmm12
; SSE-NEXT:    por %xmm2, %xmm12
; SSE-NEXT:    pshufd $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[2,2,3,3]
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    punpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Folded Reload
; SSE-NEXT:    # xmm10 = xmm10[4],mem[4],xmm10[5],mem[5],xmm10[6],mem[6],xmm10[7],mem[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm10[2,1,3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,1,1,0,4,5,6,7]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    pshufd $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[2,2,3,3]
; SSE-NEXT:    movdqa %xmm0, %xmm10
; SSE-NEXT:    pandn %xmm2, %xmm10
; SSE-NEXT:    punpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Folded Reload
; SSE-NEXT:    # xmm8 = xmm8[4],mem[4],xmm8[5],mem[5],xmm8[6],mem[6],xmm8[7],mem[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm8[2,1,3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[2,1,1,0,4,5,6,7]
; SSE-NEXT:    pand %xmm0, %xmm2
; SSE-NEXT:    por %xmm10, %xmm2
; SSE-NEXT:    punpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Folded Reload
; SSE-NEXT:    # xmm6 = xmm6[4],mem[4],xmm6[5],mem[5],xmm6[6],mem[6],xmm6[7],mem[7]
; SSE-NEXT:    pshufd $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Folded Reload
; SSE-NEXT:    # xmm8 = mem[2,2,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[2,1,3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm6[2,1,1,0,4,5,6,7]
; SSE-NEXT:    pand %xmm0, %xmm6
; SSE-NEXT:    pandn %xmm8, %xmm0
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm0, 368(%rcx)
; SSE-NEXT:    movdqa %xmm2, 320(%rcx)
; SSE-NEXT:    movdqa %xmm1, 272(%rcx)
; SSE-NEXT:    movdqa %xmm12, 224(%rcx)
; SSE-NEXT:    movdqa %xmm15, 176(%rcx)
; SSE-NEXT:    movdqa %xmm3, 128(%rcx)
; SSE-NEXT:    movdqa %xmm4, 80(%rcx)
; SSE-NEXT:    movdqa %xmm5, 32(%rcx)
; SSE-NEXT:    movdqa %xmm11, 352(%rcx)
; SSE-NEXT:    movdqa %xmm7, 336(%rcx)
; SSE-NEXT:    movdqa %xmm9, 304(%rcx)
; SSE-NEXT:    movdqa %xmm13, 288(%rcx)
; SSE-NEXT:    movdqa %xmm14, 256(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rcx)
; SSE-NEXT:    addq $360, %rsp # imm = 0x168
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i16_stride3_vf64:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    subq $296, %rsp # imm = 0x128
; AVX1-ONLY-NEXT:    vmovdqa 80(%rdi), %xmm12
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm12[1,1,2,2]
; AVX1-ONLY-NEXT:    vmovdqa 80(%rsi), %xmm7
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm7[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3,4],xmm1[5],xmm0[6,7]
; AVX1-ONLY-NEXT:    vmovdqa 80(%rdx), %xmm2
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm2[1,1,2,2]
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, %xmm15
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1,2],xmm1[3],xmm0[4,5],xmm1[6],xmm0[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 64(%rdi), %xmm13
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm13[1,1,2,2]
; AVX1-ONLY-NEXT:    vmovdqa 64(%rsi), %xmm6
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm6[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3,4],xmm1[5],xmm0[6,7]
; AVX1-ONLY-NEXT:    vmovdqa 64(%rdx), %xmm14
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm14[1,1,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1,2],xmm1[3],xmm0[4,5],xmm1[6],xmm0[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 48(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,2,2]
; AVX1-ONLY-NEXT:    vmovdqa 32(%rsi), %xmm3
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 48(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3,4],xmm1[5],xmm0[6,7]
; AVX1-ONLY-NEXT:    vmovdqa 48(%rdx), %xmm8
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm8[1,1,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1,2],xmm1[3],xmm0[4,5],xmm1[6],xmm0[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm2[1,1,2,2]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm3[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3,4],xmm1[5],xmm0[6,7]
; AVX1-ONLY-NEXT:    vmovdqa 32(%rdx), %xmm4
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm4[1,1,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1,2],xmm1[3],xmm0[4,5],xmm1[6],xmm0[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 112(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vmovdqa 112(%rdi), %xmm9
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm9[1,1,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0,1],xmm0[2],xmm1[3,4],xmm0[5],xmm1[6,7]
; AVX1-ONLY-NEXT:    vmovdqa 112(%rdx), %xmm11
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm11[1,1,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1,2],xmm1[3],xmm0[4,5],xmm1[6],xmm0[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 96(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vmovdqa 96(%rdi), %xmm5
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm5[1,1,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0,1],xmm0[2],xmm1[3,4],xmm0[5],xmm1[6,7]
; AVX1-ONLY-NEXT:    vmovdqa 96(%rdx), %xmm10
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm10[1,1,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1,2],xmm1[3],xmm0[4,5],xmm1[6],xmm0[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 16(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[1,1,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0,1],xmm0[2],xmm1[3,4],xmm0[5],xmm1[6,7]
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdx), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[1,1,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1,2],xmm1[3],xmm0[4,5],xmm1[6],xmm0[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa (%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, (%rsp) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vmovdqa (%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[1,1,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0,1],xmm0[2],xmm1[3,4],xmm0[5],xmm1[6,7]
; AVX1-ONLY-NEXT:    vmovdqa (%rdx), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[1,1,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1,2],xmm1[3],xmm0[4,5],xmm1[6],xmm0[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm7[4],xmm12[4],xmm7[5],xmm12[5],xmm7[6],xmm12[6],xmm7[7],xmm12[7]
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,5,10,11,10,11,8,9,8,9,14,15,12,13,14,15]
; AVX1-ONLY-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm15, %xmm2
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0],xmm15[1],xmm1[2,3],xmm15[4],xmm1[5,6],xmm15[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa %xmm13, %xmm1
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm15 = xmm13[0],xmm6[0],xmm13[1],xmm6[1],xmm13[2],xmm6[2],xmm13[3],xmm6[3]
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm13 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX1-ONLY-NEXT:    vpshufb %xmm13, %xmm15, %xmm15
; AVX1-ONLY-NEXT:    vmovdqa %xmm14, %xmm0
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm14 = xmm14[0,0,0,0]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm14 = xmm15[0,1],xmm14[2],xmm15[3,4],xmm14[5],xmm15[6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm14 = xmm12[0],xmm7[0],xmm12[1],xmm7[1],xmm12[2],xmm7[2],xmm12[3],xmm7[3]
; AVX1-ONLY-NEXT:    vpshufb %xmm13, %xmm14, %xmm14
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm15 = xmm2[0,0,0,0]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm14[0,1],xmm15[2],xmm14[3,4],xmm15[5],xmm14[6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm14 = xmm6[4],xmm1[4],xmm6[5],xmm1[5],xmm6[6],xmm1[6],xmm6[7],xmm1[7]
; AVX1-ONLY-NEXT:    vpshufb %xmm3, %xmm14, %xmm14
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm15 = xmm0[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm14[0],xmm15[1],xmm14[2,3],xmm15[4],xmm14[5,6],xmm15[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm14 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX1-ONLY-NEXT:    vpshufb %xmm13, %xmm14, %xmm14
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm15 = xmm8[0,0,0,0]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm14[0,1],xmm15[2],xmm14[3,4],xmm15[5],xmm14[6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm14 = xmm0[4],xmm6[4],xmm0[5],xmm6[5],xmm0[6],xmm6[6],xmm0[7],xmm6[7]
; AVX1-ONLY-NEXT:    vpshufb %xmm3, %xmm14, %xmm14
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm15 = xmm4[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm7 = xmm14[0],xmm15[1],xmm14[2,3],xmm15[4],xmm14[5,6],xmm15[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm14 = xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; AVX1-ONLY-NEXT:    vpshufb %xmm3, %xmm14, %xmm14
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm14[0],xmm8[1],xmm14[2,3],xmm8[4],xmm14[5,6],xmm8[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm6[0],xmm0[0],xmm6[1],xmm0[1],xmm6[2],xmm0[2],xmm6[3],xmm0[3]
; AVX1-ONLY-NEXT:    vpshufb %xmm13, %xmm8, %xmm8
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[0,0,0,0]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm8 = xmm8[0,1],xmm4[2],xmm8[3,4],xmm4[5],xmm8[6,7]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm9[0],xmm0[0],xmm9[1],xmm0[1],xmm9[2],xmm0[2],xmm9[3],xmm0[3]
; AVX1-ONLY-NEXT:    vpshufb %xmm13, %xmm4, %xmm4
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm14 = xmm11[0,0,0,0]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1],xmm14[2],xmm4[3,4],xmm14[5],xmm4[6,7]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm14 = xmm1[4],xmm5[4],xmm1[5],xmm5[5],xmm1[6],xmm5[6],xmm1[7],xmm5[7]
; AVX1-ONLY-NEXT:    vpshufb %xmm3, %xmm14, %xmm14
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm15 = xmm10[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm14 = xmm14[0],xmm15[1],xmm14[2,3],xmm15[4],xmm14[5,6],xmm15[7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm9 = xmm0[4],xmm9[4],xmm0[5],xmm9[5],xmm0[6],xmm9[6],xmm0[7],xmm9[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, %xmm12
; AVX1-ONLY-NEXT:    vpshufb %xmm3, %xmm9, %xmm9
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm9 = xmm9[0],xmm11[1],xmm9[2,3],xmm11[4],xmm9[5,6],xmm11[7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm5[0],xmm1[0],xmm5[1],xmm1[1],xmm5[2],xmm1[2],xmm5[3],xmm1[3]
; AVX1-ONLY-NEXT:    vpshufb %xmm13, %xmm2, %xmm2
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm10[0,0,0,0]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1],xmm3[2],xmm2[3,4],xmm3[5],xmm2[6,7]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm10[4],xmm6[4],xmm10[5],xmm6[5],xmm10[6],xmm6[6],xmm10[7],xmm6[7]
; AVX1-ONLY-NEXT:    vpshufb %xmm12, %xmm3, %xmm3
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm1[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0],xmm5[1],xmm3[2,3],xmm5[4],xmm3[5,6],xmm5[7]
; AVX1-ONLY-NEXT:    vmovdqa (%rsp), %xmm7 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm0[0],xmm7[0],xmm0[1],xmm7[1],xmm0[2],xmm7[2],xmm0[3],xmm7[3]
; AVX1-ONLY-NEXT:    vpshufb %xmm13, %xmm5, %xmm5
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm15[0,0,0,0]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1],xmm11[2],xmm5[3,4],xmm11[5],xmm5[6,7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm6[0],xmm10[0],xmm6[1],xmm10[1],xmm6[2],xmm10[2],xmm6[3],xmm10[3]
; AVX1-ONLY-NEXT:    vpshufb %xmm13, %xmm10, %xmm6
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm10 = xmm1[0,0,0,0]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm10 = xmm6[0,1],xmm10[2],xmm6[3,4],xmm10[5],xmm6[6,7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm7[4],xmm0[4],xmm7[5],xmm0[5],xmm7[6],xmm0[6],xmm7[7],xmm0[7]
; AVX1-ONLY-NEXT:    vpshufb %xmm12, %xmm6, %xmm1
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm15[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0],xmm6[1],xmm1[2,3],xmm6[4],xmm1[5,6],xmm6[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, 32(%rcx)
; AVX1-ONLY-NEXT:    vmovdqa %xmm10, 48(%rcx)
; AVX1-ONLY-NEXT:    vmovdqa %xmm5, (%rcx)
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, 80(%rcx)
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, 288(%rcx)
; AVX1-ONLY-NEXT:    vmovdqa %xmm9, 368(%rcx)
; AVX1-ONLY-NEXT:    vmovdqa %xmm14, 320(%rcx)
; AVX1-ONLY-NEXT:    vmovdqa %xmm4, 336(%rcx)
; AVX1-ONLY-NEXT:    vmovdqa %xmm8, 96(%rcx)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 176(%rcx)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 128(%rcx)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 144(%rcx)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 224(%rcx)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 240(%rcx)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 192(%rcx)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 272(%rcx)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 16(%rcx)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 64(%rcx)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 304(%rcx)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 352(%rcx)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 112(%rcx)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 160(%rcx)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 208(%rcx)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 256(%rcx)
; AVX1-ONLY-NEXT:    addq $296, %rsp # imm = 0x128
; AVX1-ONLY-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i16_stride3_vf64:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %ymm2
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdx), %ymm0
; AVX2-SLOW-NEXT:    vmovdqa 64(%rdx), %ymm3
; AVX2-SLOW-NEXT:    vmovdqa 96(%rdx), %ymm1
; AVX2-SLOW-NEXT:    vmovdqa 80(%rdi), %xmm4
; AVX2-SLOW-NEXT:    vmovdqa 80(%rsi), %xmm5
; AVX2-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm5[4],xmm4[4],xmm5[5],xmm4[5],xmm5[6],xmm4[6],xmm5[7],xmm4[7]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm7 = [4,5,10,11,10,11,8,9,8,9,14,15,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufb %xmm7, %xmm6, %xmm6
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[1,1,2,2]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm5[3,3,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,4,4,4]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1],xmm5[2],xmm4[3,4],xmm5[5],xmm4[6,7]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm4, %ymm4
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm8 = <5,5,u,6,6,u,7,7>
; AVX2-SLOW-NEXT:    vpermd %ymm3, %ymm8, %ymm5
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm9 = [0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm9, %ymm4, %ymm5, %ymm4
; AVX2-SLOW-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 48(%rdi), %xmm5
; AVX2-SLOW-NEXT:    vmovdqa 48(%rsi), %xmm6
; AVX2-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm10 = xmm6[4],xmm5[4],xmm6[5],xmm5[5],xmm6[6],xmm5[6],xmm6[7],xmm5[7]
; AVX2-SLOW-NEXT:    vpshufb %xmm7, %xmm10, %xmm10
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[1,1,2,2]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm6 = xmm6[3,3,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,4,4,4,4]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1],xmm6[2],xmm5[3,4],xmm6[5],xmm5[6,7]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm10, %ymm5, %ymm5
; AVX2-SLOW-NEXT:    vpermd %ymm0, %ymm8, %ymm6
; AVX2-SLOW-NEXT:    vpblendvb %ymm9, %ymm5, %ymm6, %ymm4
; AVX2-SLOW-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 112(%rdi), %xmm6
; AVX2-SLOW-NEXT:    vmovdqa 112(%rsi), %xmm10
; AVX2-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm11 = xmm10[4],xmm6[4],xmm10[5],xmm6[5],xmm10[6],xmm6[6],xmm10[7],xmm6[7]
; AVX2-SLOW-NEXT:    vpshufb %xmm7, %xmm11, %xmm11
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[1,1,2,2]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm10 = xmm10[3,3,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm10 = xmm10[0,1,2,3,4,4,4,4]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm6 = xmm6[0,1],xmm10[2],xmm6[3,4],xmm10[5],xmm6[6,7]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm11, %ymm6, %ymm6
; AVX2-SLOW-NEXT:    vpermd %ymm1, %ymm8, %ymm10
; AVX2-SLOW-NEXT:    vpblendvb %ymm9, %ymm6, %ymm10, %ymm4
; AVX2-SLOW-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %xmm10
; AVX2-SLOW-NEXT:    vmovdqa 16(%rdi), %xmm11
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %xmm12
; AVX2-SLOW-NEXT:    vmovdqa 16(%rsi), %xmm13
; AVX2-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm14 = xmm13[4],xmm11[4],xmm13[5],xmm11[5],xmm13[6],xmm11[6],xmm13[7],xmm11[7]
; AVX2-SLOW-NEXT:    vpshufb %xmm7, %xmm14, %xmm7
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[1,1,2,2]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm13 = xmm13[3,3,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm13 = xmm13[0,1,2,3,4,4,4,4]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm11 = xmm11[0,1],xmm13[2],xmm11[3,4],xmm13[5],xmm11[6,7]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm7, %ymm11, %ymm7
; AVX2-SLOW-NEXT:    vpermd %ymm2, %ymm8, %ymm8
; AVX2-SLOW-NEXT:    vpblendvb %ymm9, %ymm7, %ymm8, %ymm7
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm8 = xmm10[1,1,2,2]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm9 = xmm12[3,3,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm9 = xmm9[0,1,2,3,4,4,4,4]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm8 = xmm8[0,1],xmm9[2],xmm8[3,4],xmm9[5],xmm8[6,7]
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm10[0],xmm12[0],xmm10[1],xmm12[1],xmm10[2],xmm12[2],xmm10[3],xmm12[3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm11 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX2-SLOW-NEXT:    vpshufb %xmm11, %xmm9, %xmm9
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm8, %ymm9, %ymm8
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm12 = <u,0,0,u,1,1,u,2>
; AVX2-SLOW-NEXT:    vpermd %ymm2, %ymm12, %ymm9
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm13 = [255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm13, %ymm8, %ymm9, %ymm8
; AVX2-SLOW-NEXT:    vmovdqa 64(%rdi), %xmm9
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm10 = xmm9[1,1,2,2]
; AVX2-SLOW-NEXT:    vmovdqa 64(%rsi), %xmm14
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm15 = xmm14[3,3,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm15 = xmm15[0,1,2,3,4,4,4,4]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm10 = xmm10[0,1],xmm15[2],xmm10[3,4],xmm15[5],xmm10[6,7]
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdi), %xmm15
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm9[0],xmm14[0],xmm9[1],xmm14[1],xmm9[2],xmm14[2],xmm9[3],xmm14[3]
; AVX2-SLOW-NEXT:    vmovdqa 32(%rsi), %xmm14
; AVX2-SLOW-NEXT:    vpshufb %xmm11, %xmm9, %xmm9
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm10, %ymm9, %ymm9
; AVX2-SLOW-NEXT:    vpermd %ymm3, %ymm12, %ymm10
; AVX2-SLOW-NEXT:    vpblendvb %ymm13, %ymm9, %ymm10, %ymm9
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm10 = xmm14[3,3,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm10 = xmm10[0,1,2,3,4,4,4,4]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm4 = xmm15[1,1,2,2]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1],xmm10[2],xmm4[3,4],xmm10[5],xmm4[6,7]
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm15[0],xmm14[0],xmm15[1],xmm14[1],xmm15[2],xmm14[2],xmm15[3],xmm14[3]
; AVX2-SLOW-NEXT:    vpshufb %xmm11, %xmm10, %xmm10
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm4, %ymm10, %ymm4
; AVX2-SLOW-NEXT:    vpermd %ymm0, %ymm12, %ymm10
; AVX2-SLOW-NEXT:    vpblendvb %ymm13, %ymm4, %ymm10, %ymm10
; AVX2-SLOW-NEXT:    vmovdqa 96(%rsi), %xmm4
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm14 = xmm4[3,3,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm14 = xmm14[0,1,2,3,4,4,4,4]
; AVX2-SLOW-NEXT:    vmovdqa 96(%rdi), %xmm15
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm5 = xmm15[1,1,2,2]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1],xmm14[2],xmm5[3,4],xmm14[5],xmm5[6,7]
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm15[0],xmm4[0],xmm15[1],xmm4[1],xmm15[2],xmm4[2],xmm15[3],xmm4[3]
; AVX2-SLOW-NEXT:    vpshufb %xmm11, %xmm4, %xmm4
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %ymm11
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm5, %ymm4, %ymm4
; AVX2-SLOW-NEXT:    vpermd %ymm1, %ymm12, %ymm5
; AVX2-SLOW-NEXT:    vpblendvb %ymm13, %ymm4, %ymm5, %ymm4
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm5 = [10,11,0,1,12,13,12,13,2,3,2,3,14,15,4,5,26,27,16,17,28,29,28,29,18,19,18,19,30,31,20,21]
; AVX2-SLOW-NEXT:    vpshufb %ymm5, %ymm11, %ymm11
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm12 = <u,3,3,u,4,4,u,5>
; AVX2-SLOW-NEXT:    vpermd (%rdi), %ymm12, %ymm13
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm14 = <255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm11, %ymm13, %ymm11
; AVX2-SLOW-NEXT:    vmovdqa 64(%rsi), %ymm13
; AVX2-SLOW-NEXT:    vpshufb %ymm5, %ymm13, %ymm13
; AVX2-SLOW-NEXT:    vpermd 64(%rdi), %ymm12, %ymm15
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm13, %ymm15, %ymm13
; AVX2-SLOW-NEXT:    vmovdqa 32(%rsi), %ymm15
; AVX2-SLOW-NEXT:    vpshufb %ymm5, %ymm15, %ymm15
; AVX2-SLOW-NEXT:    vpermd 32(%rdi), %ymm12, %ymm6
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm15, %ymm6, %ymm6
; AVX2-SLOW-NEXT:    vmovdqa 96(%rsi), %ymm15
; AVX2-SLOW-NEXT:    vpshufb %ymm5, %ymm15, %ymm5
; AVX2-SLOW-NEXT:    vpermd 96(%rdi), %ymm12, %ymm12
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm5, %ymm12, %ymm5
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm12 = <2,u,3,3,u,4,4,u>
; AVX2-SLOW-NEXT:    vpermd %ymm2, %ymm12, %ymm2
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm14 = [255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm11, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vpermd %ymm3, %ymm12, %ymm3
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm13, %ymm3, %ymm3
; AVX2-SLOW-NEXT:    vpermd %ymm0, %ymm12, %ymm0
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm6, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpermd %ymm1, %ymm12, %ymm1
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm5, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vmovdqa %ymm1, 320(%rcx)
; AVX2-SLOW-NEXT:    vmovdqa %ymm0, 128(%rcx)
; AVX2-SLOW-NEXT:    vmovdqa %ymm3, 224(%rcx)
; AVX2-SLOW-NEXT:    vmovdqa %ymm2, 32(%rcx)
; AVX2-SLOW-NEXT:    vmovdqa %ymm4, 288(%rcx)
; AVX2-SLOW-NEXT:    vmovdqa %ymm10, 96(%rcx)
; AVX2-SLOW-NEXT:    vmovdqa %ymm9, 192(%rcx)
; AVX2-SLOW-NEXT:    vmovdqa %ymm8, (%rcx)
; AVX2-SLOW-NEXT:    vmovdqa %ymm7, 64(%rcx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 352(%rcx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 160(%rcx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 256(%rcx)
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i16_stride3_vf64:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %ymm1
; AVX2-FAST-NEXT:    vmovdqa 32(%rdx), %ymm9
; AVX2-FAST-NEXT:    vmovdqa 64(%rdx), %ymm2
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %xmm3
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm5 = <u,u,u,u,6,7,u,u,u,u,8,9,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm5, %xmm3, %xmm4
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %xmm6
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm7 = xmm6[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm4 = xmm7[0,1],xmm4[2],xmm7[3,4],xmm4[5],xmm7[6,7]
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm6[0],xmm3[0],xmm6[1],xmm3[1],xmm6[2],xmm3[2],xmm6[3],xmm3[3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm8 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX2-FAST-NEXT:    vpshufb %xmm8, %xmm3, %xmm3
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm4, %ymm3, %ymm3
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm10 = <u,0,0,u,1,1,u,2>
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm10, %ymm4
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm11 = [255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm11, %ymm3, %ymm4, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 80(%rdi), %xmm4
; AVX2-FAST-NEXT:    vmovdqa 80(%rsi), %xmm6
; AVX2-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm6[4],xmm4[4],xmm6[5],xmm4[5],xmm6[6],xmm4[6],xmm6[7],xmm4[7]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,5,10,11,10,11,8,9,8,9,14,15,12,13,14,15]
; AVX2-FAST-NEXT:    vpshufb %xmm3, %xmm7, %xmm7
; AVX2-FAST-NEXT:    vpshufb %xmm5, %xmm6, %xmm6
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1],xmm6[2],xmm4[3,4],xmm6[5],xmm4[6,7]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm7, %ymm4, %ymm4
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm12 = <5,5,u,6,6,u,7,7>
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm12, %ymm6
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm13 = [0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm13, %ymm4, %ymm6, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 64(%rsi), %xmm6
; AVX2-FAST-NEXT:    vpshufb %xmm5, %xmm6, %xmm7
; AVX2-FAST-NEXT:    vmovdqa 64(%rdi), %xmm14
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm15 = xmm14[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm7 = xmm15[0,1],xmm7[2],xmm15[3,4],xmm7[5],xmm15[6,7]
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm14[0],xmm6[0],xmm14[1],xmm6[1],xmm14[2],xmm6[2],xmm14[3],xmm6[3]
; AVX2-FAST-NEXT:    vpshufb %xmm8, %xmm6, %xmm6
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm7, %ymm6, %ymm6
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm10, %ymm7
; AVX2-FAST-NEXT:    vpblendvb %ymm11, %ymm6, %ymm7, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 48(%rdi), %xmm7
; AVX2-FAST-NEXT:    vmovdqa 48(%rsi), %xmm14
; AVX2-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm14[4],xmm7[4],xmm14[5],xmm7[5],xmm14[6],xmm7[6],xmm14[7],xmm7[7]
; AVX2-FAST-NEXT:    vpshufb %xmm5, %xmm14, %xmm14
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm7 = xmm7[0,1],xmm14[2],xmm7[3,4],xmm14[5],xmm7[6,7]
; AVX2-FAST-NEXT:    vmovdqa 32(%rsi), %xmm14
; AVX2-FAST-NEXT:    vpshufb %xmm3, %xmm15, %xmm15
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm15, %ymm7, %ymm7
; AVX2-FAST-NEXT:    vpermd %ymm9, %ymm12, %ymm15
; AVX2-FAST-NEXT:    vpblendvb %ymm13, %ymm7, %ymm15, %ymm7
; AVX2-FAST-NEXT:    vmovdqa 32(%rdi), %xmm15
; AVX2-FAST-NEXT:    vpshufb %xmm5, %xmm14, %xmm0
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm4 = xmm15[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm4[0,1],xmm0[2],xmm4[3,4],xmm0[5],xmm4[6,7]
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm15[0],xmm14[0],xmm15[1],xmm14[1],xmm15[2],xmm14[2],xmm15[3],xmm14[3]
; AVX2-FAST-NEXT:    vpshufb %xmm8, %xmm4, %xmm4
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm4, %ymm0
; AVX2-FAST-NEXT:    vpermd %ymm9, %ymm10, %ymm4
; AVX2-FAST-NEXT:    vpblendvb %ymm11, %ymm0, %ymm4, %ymm14
; AVX2-FAST-NEXT:    vmovdqa 96(%rsi), %xmm0
; AVX2-FAST-NEXT:    vpshufb %xmm5, %xmm0, %xmm4
; AVX2-FAST-NEXT:    vmovdqa 96(%rdi), %xmm15
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm6 = xmm15[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm4 = xmm6[0,1],xmm4[2],xmm6[3,4],xmm4[5],xmm6[6,7]
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm15[0],xmm0[0],xmm15[1],xmm0[1],xmm15[2],xmm0[2],xmm15[3],xmm0[3]
; AVX2-FAST-NEXT:    vpshufb %xmm8, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqa 96(%rdx), %ymm15
; AVX2-FAST-NEXT:    vpermd %ymm15, %ymm10, %ymm4
; AVX2-FAST-NEXT:    vpblendvb %ymm11, %ymm0, %ymm4, %ymm8
; AVX2-FAST-NEXT:    vmovdqa 112(%rdi), %xmm0
; AVX2-FAST-NEXT:    vmovdqa 112(%rsi), %xmm4
; AVX2-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm4[4],xmm0[4],xmm4[5],xmm0[5],xmm4[6],xmm0[6],xmm4[7],xmm0[7]
; AVX2-FAST-NEXT:    vpshufb %xmm5, %xmm4, %xmm4
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm4[2],xmm0[3,4],xmm4[5],xmm0[6,7]
; AVX2-FAST-NEXT:    vpshufb %xmm3, %xmm6, %xmm4
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpermd %ymm15, %ymm12, %ymm4
; AVX2-FAST-NEXT:    vpblendvb %ymm13, %ymm0, %ymm4, %ymm10
; AVX2-FAST-NEXT:    vmovdqa 16(%rsi), %xmm0
; AVX2-FAST-NEXT:    vmovdqa 16(%rdi), %xmm4
; AVX2-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm0[4],xmm4[4],xmm0[5],xmm4[5],xmm0[6],xmm4[6],xmm0[7],xmm4[7]
; AVX2-FAST-NEXT:    vpshufb %xmm3, %xmm6, %xmm3
; AVX2-FAST-NEXT:    vpshufb %xmm5, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm4[0,1],xmm0[2],xmm4[3,4],xmm0[5],xmm4[6,7]
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %ymm4
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm12, %ymm3
; AVX2-FAST-NEXT:    vpblendvb %ymm13, %ymm0, %ymm3, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = [10,11,0,1,12,13,12,13,2,3,2,3,14,15,4,5,26,27,16,17,28,29,28,29,18,19,18,19,30,31,20,21]
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm4, %ymm4
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = <u,3,3,u,4,4,u,5>
; AVX2-FAST-NEXT:    vpermd (%rdi), %ymm5, %ymm6
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm11 = <255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255>
; AVX2-FAST-NEXT:    vpblendvb %ymm11, %ymm4, %ymm6, %ymm4
; AVX2-FAST-NEXT:    vmovdqa 64(%rsi), %ymm6
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm6, %ymm6
; AVX2-FAST-NEXT:    vpermd 64(%rdi), %ymm5, %ymm12
; AVX2-FAST-NEXT:    vpblendvb %ymm11, %ymm6, %ymm12, %ymm6
; AVX2-FAST-NEXT:    vmovdqa 32(%rsi), %ymm12
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm12, %ymm12
; AVX2-FAST-NEXT:    vpermd 32(%rdi), %ymm5, %ymm13
; AVX2-FAST-NEXT:    vpblendvb %ymm11, %ymm12, %ymm13, %ymm12
; AVX2-FAST-NEXT:    vmovdqa 96(%rsi), %ymm13
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm13, %ymm3
; AVX2-FAST-NEXT:    vpermd 96(%rdi), %ymm5, %ymm5
; AVX2-FAST-NEXT:    vpblendvb %ymm11, %ymm3, %ymm5, %ymm3
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = <2,u,3,3,u,4,4,u>
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm5, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm11 = [255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm11, %ymm4, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm5, %ymm2
; AVX2-FAST-NEXT:    vpblendvb %ymm11, %ymm6, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vpermd %ymm9, %ymm5, %ymm4
; AVX2-FAST-NEXT:    vpblendvb %ymm11, %ymm12, %ymm4, %ymm4
; AVX2-FAST-NEXT:    vpermd %ymm15, %ymm5, %ymm5
; AVX2-FAST-NEXT:    vpblendvb %ymm11, %ymm3, %ymm5, %ymm3
; AVX2-FAST-NEXT:    vmovdqa %ymm3, 320(%rcx)
; AVX2-FAST-NEXT:    vmovdqa %ymm4, 128(%rcx)
; AVX2-FAST-NEXT:    vmovdqa %ymm2, 224(%rcx)
; AVX2-FAST-NEXT:    vmovdqa %ymm1, 32(%rcx)
; AVX2-FAST-NEXT:    vmovdqa %ymm0, 64(%rcx)
; AVX2-FAST-NEXT:    vmovdqa %ymm8, 288(%rcx)
; AVX2-FAST-NEXT:    vmovdqa %ymm10, 352(%rcx)
; AVX2-FAST-NEXT:    vmovdqa %ymm14, 96(%rcx)
; AVX2-FAST-NEXT:    vmovdqa %ymm7, 160(%rcx)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 192(%rcx)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 256(%rcx)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, (%rcx)
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: store_i16_stride3_vf64:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdx), %ymm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rdx), %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %xmm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm5 = <u,u,u,u,6,7,u,u,u,u,8,9,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm5, %xmm3, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %xmm6
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm7 = xmm6[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm4 = xmm7[0,1],xmm4[2],xmm7[3,4],xmm4[5],xmm7[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm6[0],xmm3[0],xmm6[1],xmm3[1],xmm6[2],xmm3[2],xmm6[3],xmm3[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm8 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm8, %xmm3, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm4, %ymm3, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm10 = <u,0,0,u,1,1,u,2>
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm1, %ymm10, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm11 = [255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm11, %ymm3, %ymm4, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 80(%rdi), %xmm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 80(%rsi), %xmm6
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm6[4],xmm4[4],xmm6[5],xmm4[5],xmm6[6],xmm4[6],xmm6[7],xmm4[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,5,10,11,10,11,8,9,8,9,14,15,12,13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm3, %xmm7, %xmm7
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm5, %xmm6, %xmm6
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1],xmm6[2],xmm4[3,4],xmm6[5],xmm4[6,7]
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm7, %ymm4, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm12 = <5,5,u,6,6,u,7,7>
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm2, %ymm12, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm13 = [0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm13, %ymm4, %ymm6, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rsi), %xmm6
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm5, %xmm6, %xmm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rdi), %xmm14
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm15 = xmm14[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm7 = xmm15[0,1],xmm7[2],xmm15[3,4],xmm7[5],xmm15[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm14[0],xmm6[0],xmm14[1],xmm6[1],xmm14[2],xmm6[2],xmm14[3],xmm6[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm8, %xmm6, %xmm6
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm7, %ymm6, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm2, %ymm10, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm11, %ymm6, %ymm7, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 48(%rdi), %xmm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 48(%rsi), %xmm14
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm14[4],xmm7[4],xmm14[5],xmm7[5],xmm14[6],xmm7[6],xmm14[7],xmm7[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm5, %xmm14, %xmm14
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm7 = xmm7[0,1],xmm14[2],xmm7[3,4],xmm14[5],xmm7[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rsi), %xmm14
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm3, %xmm15, %xmm15
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm15, %ymm7, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm9, %ymm12, %ymm15
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm13, %ymm7, %ymm15, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdi), %xmm15
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm5, %xmm14, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm4 = xmm15[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm0 = xmm4[0,1],xmm0[2],xmm4[3,4],xmm0[5],xmm4[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm15[0],xmm14[0],xmm15[1],xmm14[1],xmm15[2],xmm14[2],xmm15[3],xmm14[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm8, %xmm4, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm0, %ymm4, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm9, %ymm10, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm11, %ymm0, %ymm4, %ymm14
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rsi), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm5, %xmm0, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rdi), %xmm15
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm6 = xmm15[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm4 = xmm6[0,1],xmm4[2],xmm6[3,4],xmm4[5],xmm6[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm15[0],xmm0[0],xmm15[1],xmm0[1],xmm15[2],xmm0[2],xmm15[3],xmm0[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm8, %xmm0, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rdx), %ymm15
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm15, %ymm10, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm11, %ymm0, %ymm4, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 112(%rdi), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 112(%rsi), %xmm4
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm4[4],xmm0[4],xmm4[5],xmm0[5],xmm4[6],xmm0[6],xmm4[7],xmm0[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm5, %xmm4, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm4[2],xmm0[3,4],xmm4[5],xmm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm3, %xmm6, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm15, %ymm12, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm13, %ymm0, %ymm4, %ymm10
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 16(%rsi), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 16(%rdi), %xmm4
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm0[4],xmm4[4],xmm0[5],xmm4[5],xmm0[6],xmm4[6],xmm0[7],xmm4[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm3, %xmm6, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm5, %xmm0, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm0 = xmm4[0,1],xmm0[2],xmm4[3,4],xmm0[5],xmm4[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %ymm4
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm1, %ymm12, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm13, %ymm0, %ymm3, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm3 = [10,11,0,1,12,13,12,13,2,3,2,3,14,15,4,5,26,27,16,17,28,29,28,29,18,19,18,19,30,31,20,21]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm3, %ymm4, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm5 = <u,3,3,u,4,4,u,5>
; AVX2-FAST-PERLANE-NEXT:    vpermd (%rdi), %ymm5, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm11 = <255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255,u,u,0,0,255,255>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm11, %ymm4, %ymm6, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rsi), %ymm6
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm3, %ymm6, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vpermd 64(%rdi), %ymm5, %ymm12
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm11, %ymm6, %ymm12, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rsi), %ymm12
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm3, %ymm12, %ymm12
; AVX2-FAST-PERLANE-NEXT:    vpermd 32(%rdi), %ymm5, %ymm13
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm11, %ymm12, %ymm13, %ymm12
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rsi), %ymm13
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm3, %ymm13, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpermd 96(%rdi), %ymm5, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm11, %ymm3, %ymm5, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm5 = <2,u,3,3,u,4,4,u>
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm1, %ymm5, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm11 = [255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm11, %ymm4, %ymm1, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm2, %ymm5, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm11, %ymm6, %ymm2, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm9, %ymm5, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm11, %ymm12, %ymm4, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm15, %ymm5, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm11, %ymm3, %ymm5, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm3, 320(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm4, 128(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm2, 224(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm1, 32(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm0, 64(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm8, 288(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm10, 352(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm14, 96(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm7, 160(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 192(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 256(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, (%rcx)
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512F-LABEL: store_i16_stride3_vf64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm6 = [128,128,128,128,12,13,128,128,128,128,14,15,128,128,128,128,16,17,128,128,128,128,18,19,128,128,128,128,20,21,128,128]
; AVX512F-NEXT:    vpshufb %ymm6, %ymm0, %ymm0
; AVX512F-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm2 = [10,11,0,1,128,128,12,13,2,3,128,128,14,15,4,5,128,128,16,17,28,29,128,128,18,19,18,19,128,128,20,21]
; AVX512F-NEXT:    vpshufb %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vmovdqa %ymm2, %ymm10
; AVX512F-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm2
; AVX512F-NEXT:    vmovdqa (%rsi), %xmm4
; AVX512F-NEXT:    vmovdqa64 16(%rsi), %xmm23
; AVX512F-NEXT:    vmovdqa64 32(%rsi), %xmm25
; AVX512F-NEXT:    vprold $16, %xmm4, %xmm5
; AVX512F-NEXT:    vmovdqa (%rdi), %xmm7
; AVX512F-NEXT:    vmovdqa64 16(%rdi), %xmm24
; AVX512F-NEXT:    vmovdqa 32(%rdi), %xmm11
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm8 = xmm7[1,1,2,2]
; AVX512F-NEXT:    vpblendw {{.*#+}} xmm5 = xmm8[0,1],xmm5[2],xmm8[3,4],xmm5[5],xmm8[6,7]
; AVX512F-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm7[0],xmm4[0],xmm7[1],xmm4[1],xmm7[2],xmm4[2],xmm7[3],xmm4[3]
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm0 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX512F-NEXT:    vpshufb %xmm0, %xmm4, %xmm4
; AVX512F-NEXT:    vinserti128 $1, %xmm5, %ymm4, %ymm4
; AVX512F-NEXT:    vshufi64x2 {{.*#+}} zmm12 = zmm4[0,1,2,3],zmm2[4,5,6,7]
; AVX512F-NEXT:    vmovdqa (%rdx), %ymm2
; AVX512F-NEXT:    vmovdqa 32(%rdx), %ymm5
; AVX512F-NEXT:    vmovdqa 64(%rdx), %ymm15
; AVX512F-NEXT:    vmovdqa 96(%rdx), %ymm7
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm3 = [128,128,10,11,128,128,128,128,12,13,128,128,128,128,14,15,128,128,128,128,16,17,128,128,128,128,18,19,128,128,128,128]
; AVX512F-NEXT:    vpshufb %ymm3, %ymm2, %ymm4
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} ymm20 = <u,0,0,u,1,1,u,2>
; AVX512F-NEXT:    vpermd %ymm2, %ymm20, %ymm13
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} ymm17 = [65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535]
; AVX512F-NEXT:    vpandnq %ymm13, %ymm17, %ymm13
; AVX512F-NEXT:    vinserti64x4 $1, %ymm4, %zmm13, %zmm4
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm18 = [65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535]
; AVX512F-NEXT:    vpternlogq $248, %zmm18, %zmm12, %zmm4
; AVX512F-NEXT:    vmovdqa 96(%rsi), %xmm12
; AVX512F-NEXT:    vprold $16, %xmm12, %xmm13
; AVX512F-NEXT:    vmovdqa 96(%rdi), %xmm14
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm8 = xmm14[1,1,2,2]
; AVX512F-NEXT:    vpblendw {{.*#+}} xmm8 = xmm8[0,1],xmm13[2],xmm8[3,4],xmm13[5],xmm8[6,7]
; AVX512F-NEXT:    vpunpcklwd {{.*#+}} xmm12 = xmm14[0],xmm12[0],xmm14[1],xmm12[1],xmm14[2],xmm12[2],xmm14[3],xmm12[3]
; AVX512F-NEXT:    vpshufb %xmm0, %xmm12, %xmm12
; AVX512F-NEXT:    vmovdqa64 %xmm0, %xmm26
; AVX512F-NEXT:    vinserti128 $1, %xmm8, %ymm12, %ymm8
; AVX512F-NEXT:    vinserti64x4 $1, %ymm8, %zmm0, %zmm8
; AVX512F-NEXT:    vmovdqa 80(%rdi), %xmm12
; AVX512F-NEXT:    vmovdqa 80(%rsi), %xmm14
; AVX512F-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm14[4],xmm12[4],xmm14[5],xmm12[5],xmm14[6],xmm12[6],xmm14[7],xmm12[7]
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm13 = [4,5,10,11,10,11,8,9,8,9,14,15,12,13,14,15]
; AVX512F-NEXT:    vpshufb %xmm13, %xmm0, %xmm0
; AVX512F-NEXT:    vprold $16, %xmm14, %xmm14
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[1,1,2,2]
; AVX512F-NEXT:    vpblendw {{.*#+}} xmm12 = xmm12[0,1],xmm14[2],xmm12[3,4],xmm14[5],xmm12[6,7]
; AVX512F-NEXT:    vinserti128 $1, %xmm0, %ymm12, %ymm0
; AVX512F-NEXT:    vshufi64x2 {{.*#+}} zmm0 = zmm0[0,1,2,3],zmm8[4,5,6,7]
; AVX512F-NEXT:    vpermd %ymm7, %ymm20, %ymm8
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} ymm21 = <5,5,u,6,6,u,7,7>
; AVX512F-NEXT:    vpermd %ymm15, %ymm21, %ymm12
; AVX512F-NEXT:    vinserti64x4 $1, %ymm8, %zmm12, %zmm12
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm16 = [0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535]
; AVX512F-NEXT:    vpternlogq $184, %zmm0, %zmm16, %zmm12
; AVX512F-NEXT:    vmovdqa 96(%rdi), %ymm0
; AVX512F-NEXT:    vpshufb %ymm6, %ymm0, %ymm0
; AVX512F-NEXT:    vmovdqa 96(%rsi), %ymm8
; AVX512F-NEXT:    vmovdqa %ymm10, %ymm1
; AVX512F-NEXT:    vpshufb %ymm10, %ymm8, %ymm8
; AVX512F-NEXT:    vpor %ymm0, %ymm8, %ymm0
; AVX512F-NEXT:    vmovdqa 112(%rdi), %xmm8
; AVX512F-NEXT:    vmovdqa 112(%rsi), %xmm14
; AVX512F-NEXT:    vpunpckhwd {{.*#+}} xmm10 = xmm14[4],xmm8[4],xmm14[5],xmm8[5],xmm14[6],xmm8[6],xmm14[7],xmm8[7]
; AVX512F-NEXT:    vpshufb %xmm13, %xmm10, %xmm10
; AVX512F-NEXT:    vprold $16, %xmm14, %xmm14
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[1,1,2,2]
; AVX512F-NEXT:    vpblendw {{.*#+}} xmm8 = xmm8[0,1],xmm14[2],xmm8[3,4],xmm14[5],xmm8[6,7]
; AVX512F-NEXT:    vinserti128 $1, %xmm10, %ymm8, %ymm8
; AVX512F-NEXT:    vinserti64x4 $1, %ymm8, %zmm0, %zmm8
; AVX512F-NEXT:    vshufi64x2 {{.*#+}} zmm0 = zmm0[0,1,2,3],zmm8[4,5,6,7]
; AVX512F-NEXT:    vpermd %ymm7, %ymm21, %ymm8
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} ymm27 = [0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0]
; AVX512F-NEXT:    vpandnq %ymm8, %ymm27, %ymm8
; AVX512F-NEXT:    vpshufb %ymm3, %ymm7, %ymm7
; AVX512F-NEXT:    vinserti64x4 $1, %ymm8, %zmm7, %zmm19
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm22 = [65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0]
; AVX512F-NEXT:    vpternlogq $248, %zmm22, %zmm0, %zmm19
; AVX512F-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX512F-NEXT:    vpshufb %ymm6, %ymm0, %ymm0
; AVX512F-NEXT:    vmovdqa 64(%rsi), %ymm8
; AVX512F-NEXT:    vpshufb %ymm1, %ymm8, %ymm8
; AVX512F-NEXT:    vpor %ymm0, %ymm8, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; AVX512F-NEXT:    vmovdqa 64(%rsi), %xmm8
; AVX512F-NEXT:    vprold $16, %xmm8, %xmm14
; AVX512F-NEXT:    vmovdqa 64(%rdi), %xmm7
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm9 = xmm7[1,1,2,2]
; AVX512F-NEXT:    vpblendw {{.*#+}} xmm9 = xmm9[0,1],xmm14[2],xmm9[3,4],xmm14[5],xmm9[6,7]
; AVX512F-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm7[0],xmm8[0],xmm7[1],xmm8[1],xmm7[2],xmm8[2],xmm7[3],xmm8[3]
; AVX512F-NEXT:    vmovdqa64 %xmm26, %xmm10
; AVX512F-NEXT:    vpshufb %xmm10, %xmm7, %xmm7
; AVX512F-NEXT:    vinserti128 $1, %xmm9, %ymm7, %ymm7
; AVX512F-NEXT:    vshufi64x2 {{.*#+}} zmm0 = zmm7[0,1,2,3],zmm0[4,5,6,7]
; AVX512F-NEXT:    vpshufb %ymm3, %ymm15, %ymm7
; AVX512F-NEXT:    vpermd %ymm15, %ymm20, %ymm8
; AVX512F-NEXT:    vpandnq %ymm8, %ymm17, %ymm8
; AVX512F-NEXT:    vinserti64x4 $1, %ymm7, %zmm8, %zmm7
; AVX512F-NEXT:    vpternlogq $248, %zmm18, %zmm0, %zmm7
; AVX512F-NEXT:    vmovdqa 32(%rdi), %ymm0
; AVX512F-NEXT:    vpshufb %ymm6, %ymm0, %ymm0
; AVX512F-NEXT:    vmovdqa 32(%rsi), %ymm8
; AVX512F-NEXT:    vpshufb %ymm1, %ymm8, %ymm8
; AVX512F-NEXT:    vpor %ymm0, %ymm8, %ymm0
; AVX512F-NEXT:    vmovdqa 48(%rdi), %xmm8
; AVX512F-NEXT:    vmovdqa 48(%rsi), %xmm9
; AVX512F-NEXT:    vpunpckhwd {{.*#+}} xmm14 = xmm9[4],xmm8[4],xmm9[5],xmm8[5],xmm9[6],xmm8[6],xmm9[7],xmm8[7]
; AVX512F-NEXT:    vpshufb %xmm13, %xmm14, %xmm14
; AVX512F-NEXT:    vprold $16, %xmm9, %xmm9
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[1,1,2,2]
; AVX512F-NEXT:    vpblendw {{.*#+}} xmm8 = xmm8[0,1],xmm9[2],xmm8[3,4],xmm9[5],xmm8[6,7]
; AVX512F-NEXT:    vinserti128 $1, %xmm14, %ymm8, %ymm8
; AVX512F-NEXT:    vinserti64x4 $1, %ymm8, %zmm0, %zmm8
; AVX512F-NEXT:    vshufi64x2 {{.*#+}} zmm0 = zmm0[0,1,2,3],zmm8[4,5,6,7]
; AVX512F-NEXT:    vpermd %ymm5, %ymm21, %ymm8
; AVX512F-NEXT:    vpandnq %ymm8, %ymm27, %ymm8
; AVX512F-NEXT:    vpshufb %ymm3, %ymm5, %ymm9
; AVX512F-NEXT:    vinserti64x4 $1, %ymm8, %zmm9, %zmm8
; AVX512F-NEXT:    vpternlogq $248, %zmm22, %zmm0, %zmm8
; AVX512F-NEXT:    vmovdqa64 %xmm25, %xmm1
; AVX512F-NEXT:    vprold $16, %xmm25, %xmm0
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm9 = xmm11[1,1,2,2]
; AVX512F-NEXT:    vpblendw {{.*#+}} xmm0 = xmm9[0,1],xmm0[2],xmm9[3,4],xmm0[5],xmm9[6,7]
; AVX512F-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm11[0],xmm1[0],xmm11[1],xmm1[1],xmm11[2],xmm1[2],xmm11[3],xmm1[3]
; AVX512F-NEXT:    vpshufb %xmm10, %xmm3, %xmm3
; AVX512F-NEXT:    vinserti128 $1, %xmm0, %ymm3, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; AVX512F-NEXT:    vmovdqa64 %xmm23, %xmm6
; AVX512F-NEXT:    vmovdqa64 %xmm24, %xmm1
; AVX512F-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm6[4],xmm1[4],xmm6[5],xmm1[5],xmm6[6],xmm1[6],xmm6[7],xmm1[7]
; AVX512F-NEXT:    vpshufb %xmm13, %xmm3, %xmm3
; AVX512F-NEXT:    vprold $16, %xmm23, %xmm6
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm1 = xmm24[1,1,2,2]
; AVX512F-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],xmm6[2],xmm1[3,4],xmm6[5],xmm1[6,7]
; AVX512F-NEXT:    vinserti128 $1, %xmm3, %ymm1, %ymm1
; AVX512F-NEXT:    vshufi64x2 {{.*#+}} zmm0 = zmm1[0,1,2,3],zmm0[4,5,6,7]
; AVX512F-NEXT:    vpermd %ymm5, %ymm20, %ymm1
; AVX512F-NEXT:    vpermd %ymm2, %ymm21, %ymm2
; AVX512F-NEXT:    vinserti64x4 $1, %ymm1, %zmm2, %zmm1
; AVX512F-NEXT:    vpternlogq $184, %zmm0, %zmm16, %zmm1
; AVX512F-NEXT:    vmovdqa64 %zmm1, 64(%rcx)
; AVX512F-NEXT:    vmovdqa64 %zmm8, 128(%rcx)
; AVX512F-NEXT:    vmovdqa64 %zmm7, 192(%rcx)
; AVX512F-NEXT:    vmovdqa64 %zmm19, 320(%rcx)
; AVX512F-NEXT:    vmovdqa64 %zmm12, 256(%rcx)
; AVX512F-NEXT:    vmovdqa64 %zmm4, (%rcx)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: store_i16_stride3_vf64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512BW-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512BW-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm6 = <0,32,u,1,33,u,2,34,u,3,35,u,4,36,u,5,37,u,6,38,u,7,39,u,8,40,u,9,41,u,10,42>
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512BW-NEXT:    vpermt2w %zmm2, %zmm6, %zmm7
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm8 = [0,1,32,3,4,33,6,7,34,9,10,35,12,13,36,15,16,37,18,19,38,21,22,39,24,25,40,27,28,41,30,31]
; AVX512BW-NEXT:    vpermt2w %zmm4, %zmm8, %zmm7
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm9 = <21,u,54,22,u,55,23,u,56,24,u,57,25,u,58,26,u,59,27,u,60,28,u,61,29,u,62,30,u,63,31,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm10
; AVX512BW-NEXT:    vpermt2w %zmm1, %zmm9, %zmm10
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm11 = [0,53,2,3,54,5,6,55,8,9,56,11,12,57,14,15,58,17,18,59,20,21,60,23,24,61,26,27,62,29,30,63]
; AVX512BW-NEXT:    vpermt2w %zmm5, %zmm11, %zmm10
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <u,11,43,u,12,44,u,13,45,u,14,46,u,15,47,u,16,48,u,17,49,u,18,50,u,19,51,u,20,52,u,21>
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm13
; AVX512BW-NEXT:    vpermt2w %zmm3, %zmm12, %zmm13
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm14 = [42,1,2,43,4,5,44,7,8,45,10,11,46,13,14,47,16,17,48,19,20,49,22,23,50,25,26,51,28,29,52,31]
; AVX512BW-NEXT:    vpermt2w %zmm5, %zmm14, %zmm13
; AVX512BW-NEXT:    vpermt2w %zmm3, %zmm6, %zmm1
; AVX512BW-NEXT:    vpermt2w %zmm5, %zmm8, %zmm1
; AVX512BW-NEXT:    vpermi2w %zmm0, %zmm2, %zmm9
; AVX512BW-NEXT:    vpermt2w %zmm4, %zmm11, %zmm9
; AVX512BW-NEXT:    vpermt2w %zmm2, %zmm12, %zmm0
; AVX512BW-NEXT:    vpermt2w %zmm4, %zmm14, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm0, 64(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm9, 128(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm1, 192(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm13, 256(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm10, 320(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, (%rcx)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <64 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <64 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <64 x i16>, ptr %in.vecptr2, align 64
  %1 = shufflevector <64 x i16> %in.vec0, <64 x i16> %in.vec1, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %2 = shufflevector <64 x i16> %in.vec2, <64 x i16> poison, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %3 = shufflevector <128 x i16> %1, <128 x i16> %2, <192 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191>
  %interleaved.vec = shufflevector <192 x i16> %3, <192 x i16> poison, <192 x i32> <i32 0, i32 64, i32 128, i32 1, i32 65, i32 129, i32 2, i32 66, i32 130, i32 3, i32 67, i32 131, i32 4, i32 68, i32 132, i32 5, i32 69, i32 133, i32 6, i32 70, i32 134, i32 7, i32 71, i32 135, i32 8, i32 72, i32 136, i32 9, i32 73, i32 137, i32 10, i32 74, i32 138, i32 11, i32 75, i32 139, i32 12, i32 76, i32 140, i32 13, i32 77, i32 141, i32 14, i32 78, i32 142, i32 15, i32 79, i32 143, i32 16, i32 80, i32 144, i32 17, i32 81, i32 145, i32 18, i32 82, i32 146, i32 19, i32 83, i32 147, i32 20, i32 84, i32 148, i32 21, i32 85, i32 149, i32 22, i32 86, i32 150, i32 23, i32 87, i32 151, i32 24, i32 88, i32 152, i32 25, i32 89, i32 153, i32 26, i32 90, i32 154, i32 27, i32 91, i32 155, i32 28, i32 92, i32 156, i32 29, i32 93, i32 157, i32 30, i32 94, i32 158, i32 31, i32 95, i32 159, i32 32, i32 96, i32 160, i32 33, i32 97, i32 161, i32 34, i32 98, i32 162, i32 35, i32 99, i32 163, i32 36, i32 100, i32 164, i32 37, i32 101, i32 165, i32 38, i32 102, i32 166, i32 39, i32 103, i32 167, i32 40, i32 104, i32 168, i32 41, i32 105, i32 169, i32 42, i32 106, i32 170, i32 43, i32 107, i32 171, i32 44, i32 108, i32 172, i32 45, i32 109, i32 173, i32 46, i32 110, i32 174, i32 47, i32 111, i32 175, i32 48, i32 112, i32 176, i32 49, i32 113, i32 177, i32 50, i32 114, i32 178, i32 51, i32 115, i32 179, i32 52, i32 116, i32 180, i32 53, i32 117, i32 181, i32 54, i32 118, i32 182, i32 55, i32 119, i32 183, i32 56, i32 120, i32 184, i32 57, i32 121, i32 185, i32 58, i32 122, i32 186, i32 59, i32 123, i32 187, i32 60, i32 124, i32 188, i32 61, i32 125, i32 189, i32 62, i32 126, i32 190, i32 63, i32 127, i32 191>
  store <192 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; AVX: {{.*}}
; AVX2: {{.*}}
; AVX512: {{.*}}
; AVX512BW-FAST: {{.*}}
; AVX512BW-ONLY-FAST: {{.*}}
; AVX512BW-ONLY-SLOW: {{.*}}
; AVX512BW-SLOW: {{.*}}
; AVX512DQ-FAST: {{.*}}
; AVX512DQ-SLOW: {{.*}}
; AVX512DQBW-FAST: {{.*}}
; AVX512DQBW-SLOW: {{.*}}
; AVX512F-ONLY-FAST: {{.*}}
; AVX512F-ONLY-SLOW: {{.*}}
; FALLBACK0: {{.*}}
; FALLBACK1: {{.*}}
; FALLBACK10: {{.*}}
; FALLBACK11: {{.*}}
; FALLBACK12: {{.*}}
; FALLBACK2: {{.*}}
; FALLBACK3: {{.*}}
; FALLBACK4: {{.*}}
; FALLBACK5: {{.*}}
; FALLBACK6: {{.*}}
; FALLBACK7: {{.*}}
; FALLBACK8: {{.*}}
; FALLBACK9: {{.*}}
