use core:lang;
use lang:bs;
use lang:bs:macro;

/**
 * A high-level template in Storm.
 */
package class Template extends core:lang:Template {
	// Create.
	init(SrcPos pos, Scope scope, TemplateParam[] params, SFileItem body) {
		// TODO: It would be nice to be able to extract the name without creating an instance: doing
		// this without parameters could fail, in spite of lazy loading.
		var generated = body.transform(paramLookupScope(pos, scope, params));
		// var generated = body.transform(defaultParams(scope, params));
		Named named = if (generated as Named) {
			generated;
		} else if (generated as NamedDecl) {
			generated.create();
		} else {
			throw SyntaxError(pos, "The declaration after this 'template' keyword can not be templated.");
		};

		var paramDeduction = if (named as Function) {
			createParamDeduction(pos, params, named.params);
		} else if (named.params.any) {
			createParamDeduction(pos, params, named.params);
		} else {
			createTrivialDeduction(params);
		};

		init(named.name) {
			scope = scope;
			params = paramDeduction;
			body = body;
		}
	}

	// Original scope.
	private Scope scope;

	// Deduction for parameter.
	private Deduction[] params;

	// The body to create.
	private SFileItem body;

	Named? generate(SimplePart part) : override {
		if (part.params.count != params.count)
			return null;

		Value[] paramsCopy;
		for (p in part.params)
			paramsCopy << p.asRef(false);

		Str->Value p;
		for (i, par in params) {
			if (!par.deduce(scope, paramsCopy[i], p))
				return null;
		}

		Scope child = scope;
		child.lookup = TemplateLookup(scope.lookup, p);

		var created = body.transform(child);

		Named named = if (created as Named) {
			created.params = paramsCopy;
			created;
		} else if (created as NamedDecl) {
			Named n = created.create();
			n.params = paramsCopy;
			created.resolve();
			n;
		} else {
			throw SyntaxError(body.pos, "This body should always create the same thing.");
		};

		// TODO: Handle documentation!

		// Make the matching behave more predictably.
		named.flags += NamedFlags:namedMatchNoInheritance;
		return named;
	}
}


/**
 * Special lookup to inject template parameters.
 */
private class TemplateLookup extends ScopeLookup {
	// Create.
	init(ScopeLookup? original, Str->Value params) {
		init() {
			params = params;
			original = original;
		}
	}

	// Original lookup.
	private ScopeLookup? original;

	// Parameters to inject.
	private Str->Value params;

	// Find named entities.
	Named? find(Scope source, SimpleName name) : override {
		if (h = findHere(name)) {
			if (t = h.type) {
				return t;
			}
		}

		if (original)
			return original.find(source, name);
		else
			return super:find(source, name);
	}

	// Find types.
	Value value(Scope source, SimpleName name, SrcPos pos) : override {
		if (h = findHere(name)) {
			return h;
		}

		if (original)
			return original.value(source, name, pos);
		else
			return super:value(source, name, pos);
	}

	// Helper to find things here.
	private Value? findHere(SimpleName name) {
		unless (name.count == 1)
			return null;

		var part = name[0];
		unless (part.params.empty)
			return null;

		params.at(part.name);
	}
}
