use test;
use lang:bs:macro;
use lang:bs;
use core:lang;

value ToSFull {
	Int v;

	init(Int v) {
		init { v = v; }
	}

	void toS(StrBuf to) {
		to << "strbuf:" << v;
	}

	Str toS() {
		"str:" # v;
	}
}

value ToSLimited {
	Int v;

	init(Int v) {
		init { v = v; }
	}

	Str toS() {
		"str:" # v;
	}
}

test ToSImpl {
	ToSFull full(1);
	ToSLimited limited(2);

	check full.toS() == "str:1";
	check (StrBuf() << full).toS == "strbuf:1";
	check ("!" # full) == "!strbuf:1";
	check "!${full}" == "!strbuf:1";
	check ToSFull:[full].toS == "[strbuf:1]";

	check limited.toS() == "str:2";
	check (StrBuf() << limited).toS == "str:2";
	check ("!" # limited) == "!str:2";
	check "!${limited}" == "!str:2";
	check ToSLimited:[limited].toS == "[str:2]";
}

class ToSActor on Compiler {
	// Intentionally no 'toS' here. That means that when we call toS(StrBuf) in the base class, we
	// will get a thread switch, and thereby noting will get outputted to the stream in the caller.


	// Used to act as the implementation for toS here. To test that we can replace entities that are
	// automatically generated.
	void futureToS(StrBuf out) {
		out << "replaced";
	}
}

class ToSDerived extends ToSActor {
	void toS(StrBuf to) {
		to << "success";
	}

	Str callSuperToS() {
		StrBuf out;
		super:toS(out);
		return out.toS;
	}
}

Str callToS(ToSActor obj) on Compiler {
	StrBuf b;
	obj.toS(b);
	return b.toS;
}

test ToSThreaded on Compiler {
	// Previously, the 'toS' member of the base class was percieved as "thread: any", rather than
	// the thread declared for the actor. As such, we got a non-intuitive thread switch.
	check callToS(ToSDerived()) == "success";
	check callToS(ToSActor()) startsWith "ToSActor";

	// Calling super:toS(StrBuf) should call the TObject implementation at this stage:
	check ToSDerived.callSuperToS().startsWith("ToSDerived");

	// Find the old function, so that we can make sure that its refs get updated properly.
	// Function oldFn = named{ToSActor:toS<ToSActor, StrBuf>};

	// Insert a toS function into toSActor and hope that vtable lookup still works!
	Type t = named{ToSActor};
	Function base = named{ToSActor:futureToS<ToSActor, StrBuf>};
	Function f(base.pos, base.result, "toS", base.params);
	f.setCode(DelegatedCode(base.directRef));

	// This replaces the version that was automatically generated before!
	t.add(f);

	// Now, we should get something different from the base class!
	check callToS(ToSDerived()) == "success";
	check callToS(ToSActor()) == "replaced";

	// And the call to super should work (it uses a direct ref, so it requires that refs get updated properly!)
	check ToSDerived.callSuperToS() == "replaced";
}
