# SwiftPM 5.7 Release Notes

### Package Plugins

[SE-0303: Build tool plugins](https://github.com/apple/swift-evolution/blob/main/proposals/0303-swiftpm-extensible-build-tools.md) and [SE-0332: Command Plugins](https://github.com/apple/swift-evolution/blob/main/proposals/0332-swiftpm-command-plugins.md) which were first introduced in Swift 5.6 have been further refined, with support for generating resources and improved diagnostics. To learn more, refer to the [Getting Started with Plugins](../Plugins.md) guide.

### Package Registry Support

SwiftPM now supports package registry related capabilities introduced by [SE-0292](https://github.com/apple/swift-evolution/blob/main/proposals/0292-package-registry-service.md) and the corresponding [service specification](../Registry.md). With the exception of package publishing, SwiftPM can resolve and download dependencies from any compliant registry using the defined APIs. 

To get started, users will need to specify their package registry by running the `swift package-registry set` subcommand or editing the `registries.json` configuration file. `swift package` tool's `--use-registry-identity-for-scm` and `--replace-scm-with-registry` options might also be of interest.
  
### Module Aliasing For Disambiguation

Modules with the same name from different packages can now be disambiguated by module aliasing [SE-0339](https://github.com/apple/swift-evolution/blob/main/proposals/0339-module-aliasing-for-disambiguation.md). When adding a product dependency for a target in a package manifest, use a new parameter `moduleAliases` to provide a new unique name for a conflicting module. 


* [#4119] 
 
  Add a `--disable-testable-imports` flag to `swift test` with which tests are built without the testability feature (`import @testable` disabled).

