#!/bin/bash

# Get the binary size of unknown packages by downloading them
# Use this script in a SCHROOT environment to not polute yours
# as it downloads and removes the packages for which size is unknown

# Usage:
#   Run this from a schroot environment
#     ./debian/scripts/get_unpacked_size.sh
#

if [ ! "a$SCHROOT_USER" = "aroot" ]; then
    echo "This must be run in a schroot as user root."
    exit
fi

check_empty_android-sdk_dir() {
    if [ -e /usr/lib/android-sdk ]; then
        echo "First remove all google-android-* packages to have no /usr/lib/android-sdk dir";
        exit;
    fi
}

get_unpacked_size() {
    # $1 = $version
    # $2 = $PKG_NAME

    # Installs the deb package to download the archive on google servers
    # Then gets the uncompressed size of the downloaded archive
    # Finally purge the package

    UNPACKED_SIZE=$(grep --perl-regex "^$1\t" ../version_list.txt | cut -d "	" -f12 | sed "s/^$/0/")
    if [ $UNPACKED_SIZE -eq 0 ]; then
        check_empty_android-sdk_dir
        dpkg --force-depends -i ../../../${2}_*.deb
        SIZE=$(du -b /usr/lib/android-sdk/ | tail -2 | head -1 | cut -d "	" -f1)
        dpkg -P ${2}
        echo -e "$1\t$SIZE">> ../_DELETE_ME_after_size_reported_to_version_list_unpacked_size.txt
    fi
}

SCRIPT_PATH=$(dirname $0)

cd $SCRIPT_PATH
source _components_to_package.sh

for version in ${PLATFORMS_VERSIONS_TO_PACKAGE}; do
    version=$(echo $version | sed "s/,/;/g")
    VER=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f2)
    VERBIS=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f1 | cut -d ";" -f2 | cut -d "-" -f2 | tr '[:upper:]' '[:lower:]')
    if [ "$VERBIS" != "$VER" ]; then VER="$VER-$VERBIS"; fi

    PKG_NAME_SHORT=platform
    PKG_NAME=google-android-$PKG_NAME_SHORT-$VER-installer

    get_unpacked_size "$version" "$PKG_NAME"
done

for version in ${BUILD_TOOLS_VERSIONS_TO_PACKAGE}; do
    version=$(echo $version | sed "s/,/;/g")
    VER=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f3)

    PKG_NAME_SHORT=build-tools
    PKG_NAME=google-android-$PKG_NAME_SHORT-$VER-installer

    get_unpacked_size "$version" "$PKG_NAME"

done

for version in ${PATCHER_VERSIONS_TO_PACKAGE}; do
    version=$(echo $version | sed "s/,/;/g")
    VER=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f1 | cut -d ";" -f2 | tr -d 'v')

    PKG_NAME_SHORT=patcher
    PKG_NAME=google-android-$PKG_NAME_SHORT-$VER-installer

    get_unpacked_size "$version" "$PKG_NAME"

done

for version in ${CMDLINE_TOOLS_VERSIONS_TO_PACKAGE}; do
    version=$(echo $version | sed "s/,/;/g")
    VER=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f3)

    PKG_NAME_SHORT=cmdline-tools
    PKG_NAME=google-android-$PKG_NAME_SHORT-$VER-installer

    get_unpacked_size "$version" "$PKG_NAME"

done

for version in ${PLATFORM_TOOLS_VERSIONS_TO_PACKAGE}; do
    version=$(echo $version | sed "s/,/;/g")
    VER=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f3)

    PKG_NAME_SHORT=platform-tools
    PKG_NAME=google-android-$PKG_NAME_SHORT-installer

    get_unpacked_size "$version" "$PKG_NAME"

done

for version in ${NDK_VERSIONS_TO_PACKAGE}; do
    version=$(echo $version | sed "s/,/;/g")
    VER_LONG=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f3)
    VER_MAJOR=$(echo $VER_LONG | cut -d . -f 1)
    VER=r$(echo $VER_LONG | cut -d . -f 1)$(echo $VER_LONG | cut -d . -f 2 | tr '[1-9]' '[b-z]' | tr -d '0')

    PKG_NAME_SHORT=ndk
    PKG_NAME=google-android-$PKG_NAME_SHORT-$VER-installer

    get_unpacked_size "$version" "$PKG_NAME"

done

for version in ${SOURCES_VERSIONS_TO_PACKAGE}; do
    version=$(echo $version | sed "s/,/;/g")
    VER=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f1 | cut -d ";" -f2 | cut -d '-' -f2)

    PKG_NAME_SHORT=sources
    PKG_NAME=google-android-$PKG_NAME_SHORT-$VER-installer

    get_unpacked_size "$version" "$PKG_NAME"

done

for version in ${EMULATOR_VERSIONS_TO_PACKAGE}; do
    version=$(echo $version | sed "s/,/;/g")
    VER=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f3)

    PKG_NAME_SHORT=emulator
    PKG_NAME=google-android-$PKG_NAME_SHORT-installer

    get_unpacked_size "$version" "$PKG_NAME"

done

for version in ${EXTRAS_GOOGLE_AUTO_VERSIONS_TO_PACKAGE}; do
    version=$(echo $version | sed "s/,/;/g")
    VER=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f3)

    PKG_NAME_SHORT=extras-google-auto
    PKG_NAME=google-android-$PKG_NAME_SHORT-installer

    get_unpacked_size "$version" "$PKG_NAME"

done
